import{s as ls,n as ss,o as ts}from"../chunks/scheduler.00b97157.js";import{S as es,i as ns,e as M,s as n,c as i,h as as,a as p,d as t,b as a,f as Pl,g as y,j as o,k as Ol,l as Ms,m as e,n as j,t as U,o as J,p as c}from"../chunks/index.a7c1a7a1.js";import{C as ps,H as Al,E as os}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.f42c21e2.js";import{C as r}from"../chunks/CodeBlock.c713f000.js";import{D as is}from"../chunks/DocNotebookDropdown.be7b60e3.js";function ys(Sl){let u,K,F,P,T,O,w,ll,m,sl,b,El="在此教程中，我们将看到如何使用 <code>smolagents</code> 实现一个利用 SQL 的 agent。",tl,I,Rl="<p>让我们从经典问题开始：为什么不简单地使用标准的 text-to-SQL pipeline 呢？</p>",el,C,kl="标准的 text-to-SQL pipeline 很脆弱，因为生成的 SQL 查询可能会出错。更糟糕的是，查询可能出错却不引发错误警报，从而返回一些不正确或无用的结果。",nl,h,Nl="👉 相反，agent 系统则可以检视输出结果并决定查询是否需要被更改，因此带来巨大的性能提升。",al,d,_l="让我们来一起构建这个 agent! 💪",Ml,g,vl="首先，我们构建一个 SQL 的环境：",pl,B,ol,Q,il,f,Vl="现在，我们构建一个 agent，它将使用 SQL 查询来回答问题。工具的 description 属性将被 agent 系统嵌入到 LLM 的提示中：它为 LLM 提供有关如何使用该工具的信息。这正是我们描述 SQL 表的地方。",yl,q,jl,Z,Ul,W,Gl='现在让我们构建我们的工具。它需要以下内容：（更多细节请参阅<a href="../tutorials/tools">工具文档</a>）',Jl,A,xl="<li>一个带有 <code>Args:</code> 部分列出参数的 docstring。</li> <li>输入和输出的type hints。</li>",cl,S,ul,E,$l="我们现在使用这个工具来创建一个 agent。我们使用 <code>CodeAgent</code>，这是 smolagent 的主要 agent 类：一个在代码中编写操作并根据 ReAct 框架迭代先前输出的 agent。",rl,R,Xl="这个模型是驱动 agent 系统的 LLM。<code>InferenceClientModel</code> 允许你使用 HF  Inference API 调用 LLM，无论是通过 Serverless 还是 Dedicated endpoint，但你也可以使用任何专有 API。",Tl,k,wl,N,ml,_,Hl="现在让我们增加一些挑战！我们希望我们的 agent 能够处理跨多个表的连接。因此，我们创建一个新表，记录每个 receipt_id 的服务员名字！",bl,v,Il,V,Yl="因为我们改变了表，我们需要更新 <code>SQLExecutorTool</code>，让 LLM 能够正确利用这个表的信息。",Cl,G,hl,x,zl='因为这个request 比之前的要难一些，我们将 LLM 引擎切换到更强大的 <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow">Qwen/Qwen2.5-Coder-32B-Instruct</a>！',dl,$,gl,X,Ll="它直接就能工作！设置过程非常简单，难道不是吗？",Bl,H,Fl="这个例子到此结束！我们涵盖了这些概念：",Ql,Y,Dl="<li>构建新工具。</li> <li>更新工具的描述。</li> <li>切换到更强大的 LLM 有助于 agent 推理。</li>",fl,z,Kl="✅ 现在你可以构建你一直梦寐以求的 text-to-SQL 系统了！✨",ql,L,Zl,D,Wl;return T=new ps({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new is({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/zh/text_to_sql.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/zh/pytorch/text_to_sql.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/zh/tensorflow/text_to_sql.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/zh/text_to_sql.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/zh/pytorch/text_to_sql.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/zh/tensorflow/text_to_sql.ipynb"}]}}),m=new Al({props:{title:"Text-to-SQL",local:"text-to-sql",headingTag:"h1"}}),B=new r({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sqlalchemy <span class="hljs-keyword">import</span> (
    create_engine,
    MetaData,
    Table,
    Column,
    String,
    Integer,
    Float,
    insert,
    inspect,
    text,
)

engine = create_engine(<span class="hljs-string">&quot;sqlite:///:memory:&quot;</span>)
metadata_obj = MetaData()

<span class="hljs-comment"># create city SQL table</span>
table_name = <span class="hljs-string">&quot;receipts&quot;</span>
receipts = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;customer_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;price&quot;</span>, Float),
    Column(<span class="hljs-string">&quot;tip&quot;</span>, Float),
)
metadata_obj.create_all(engine)

rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alan Payne&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">12.06</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.20</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alex Mason&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">23.86</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">0.24</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Woodrow Wilson&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">53.43</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">5.43</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">21.11</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.00</span>},
]
<span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
    stmt = insert(receipts).values(**row)
    <span class="hljs-keyword">with</span> engine.begin() <span class="hljs-keyword">as</span> connection:
        cursor = connection.execute(stmt)`,wrap:!1}}),Q=new Al({props:{title:"构建 agent",local:"构建-agent",headingTag:"h3"}}),q=new r({props:{code:"aW5zcGVjdG9yJTIwJTNEJTIwaW5zcGVjdChlbmdpbmUpJTBBY29sdW1uc19pbmZvJTIwJTNEJTIwJTVCKGNvbCU1QiUyMm5hbWUlMjIlNUQlMkMlMjBjb2wlNUIlMjJ0eXBlJTIyJTVEKSUyMGZvciUyMGNvbCUyMGluJTIwaW5zcGVjdG9yLmdldF9jb2x1bW5zKCUyMnJlY2VpcHRzJTIyKSU1RCUwQSUwQXRhYmxlX2Rlc2NyaXB0aW9uJTIwJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCklMEFwcmludCh0YWJsZV9kZXNjcmlwdGlvbik=",highlighted:`inspector = inspect(engine)
columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(<span class="hljs-string">&quot;receipts&quot;</span>)]

table_description = <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info])
<span class="hljs-built_in">print</span>(table_description)`,wrap:!1}}),Z=new r({props:{code:"Q29sdW1ucyUzQSUwQSUyMCUyMC0lMjByZWNlaXB0X2lkJTNBJTIwSU5URUdFUiUwQSUyMCUyMC0lMjBjdXN0b21lcl9uYW1lJTNBJTIwVkFSQ0hBUigxNiklMEElMjAlMjAtJTIwcHJpY2UlM0ElMjBGTE9BVCUwQSUyMCUyMC0lMjB0aXAlM0ElMjBGTE9BVA==",highlighted:`Columns:
  - receipt_id: INTEGER
  - customer_name: VARCHAR(16)
  - price: FLOAT
  - tip: FLOAT`,wrap:!1}}),S=new r({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjB0b29sJTBBJTBBJTQwdG9vbCUwQWRlZiUyMHNxbF9lbmdpbmUocXVlcnklM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMEFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMFJldHVybnMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMHJlc3VsdC4lMEElMjAlMjAlMjAlMjBUaGUlMjB0YWJsZSUyMGlzJTIwbmFtZWQlMjAncmVjZWlwdHMnLiUyMEl0cyUyMGRlc2NyaXB0aW9uJTIwaXMlMjBhcyUyMGZvbGxvd3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBDb2x1bW5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMHJlY2VpcHRfaWQlM0ElMjBJTlRFR0VSJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMGN1c3RvbWVyX25hbWUlM0ElMjBWQVJDSEFSKDE2KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC0lMjBwcmljZSUzQSUyMEZMT0FUJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMHRpcCUzQSUyMEZMT0FUJTBBJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHF1ZXJ5JTNBJTIwVGhlJTIwcXVlcnklMjB0byUyMHBlcmZvcm0uJTIwVGhpcyUyMHNob3VsZCUyMGJlJTIwY29ycmVjdCUyMFNRTC4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjAlMjIlMjIlMEElMjAlMjAlMjAlMjB3aXRoJTIwZW5naW5lLmNvbm5lY3QoKSUyMGFzJTIwY29uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcm93cyUyMCUzRCUyMGNvbi5leGVjdXRlKHRleHQocXVlcnkpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dCUyMCUyQiUzRCUyMCUyMiU1Q24lMjIlMjAlMkIlMjBzdHIocm93KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">sql_engine</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Allows you to perform SQL queries on the table. Returns a string representation of the result.
    The table is named &#x27;receipts&#x27;. Its description is as follows:
        Columns:
        - receipt_id: INTEGER
        - customer_name: VARCHAR(16)
        - price: FLOAT
        - tip: FLOAT

    Args:
        query: The query to perform. This should be correct SQL.
    &quot;&quot;&quot;</span>
    output = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">with</span> engine.connect() <span class="hljs-keyword">as</span> con:
        rows = con.execute(text(query))
        <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
            output += <span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-built_in">str</span>(row)
    <span class="hljs-keyword">return</span> output`,wrap:!1}}),k=new r({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCc3FsX2VuZ2luZSU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLjEtOEItSW5zdHJ1Y3QlMjIpJTJDJTBBKSUwQWFnZW50LnJ1biglMjJDYW4lMjB5b3UlMjBnaXZlJTIwbWUlMjB0aGUlMjBuYW1lJTIwb2YlMjB0aGUlMjBjbGllbnQlMjB3aG8lMjBnb3QlMjB0aGUlMjBtb3N0JTIwZXhwZW5zaXZlJTIwcmVjZWlwdCUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

agent = CodeAgent(
    tools=[sql_engine],
    model=InferenceClientModel(model_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-8B-Instruct&quot;</span>),
)
agent.run(<span class="hljs-string">&quot;Can you give me the name of the client who got the most expensive receipt?&quot;</span>)`,wrap:!1}}),N=new Al({props:{title:"Level 2: 表连接",local:"level-2-表连接",headingTag:"h3"}}),v=new r({props:{code:"dGFibGVfbmFtZSUyMCUzRCUyMCUyMndhaXRlcnMlMjIlMEFyZWNlaXB0cyUyMCUzRCUyMFRhYmxlKCUwQSUyMCUyMCUyMCUyMHRhYmxlX25hbWUlMkMlMEElMjAlMjAlMjAlMjBtZXRhZGF0YV9vYmolMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIycmVjZWlwdF9pZCUyMiUyQyUyMEludGVnZXIlMkMlMjBwcmltYXJ5X2tleSUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwQ29sdW1uKCUyMndhaXRlcl9uYW1lJTIyJTJDJTIwU3RyaW5nKDE2KSUyQyUyMHByaW1hcnlfa2V5JTNEVHJ1ZSklMkMlMEEpJTBBbWV0YWRhdGFfb2JqLmNyZWF0ZV9hbGwoZW5naW5lKSUwQSUwQXJvd3MlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwMSUyQyUyMCUyMndhaXRlcl9uYW1lJTIyJTNBJTIwJTIyQ29yZXklMjBKb2huc29uJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycmVjZWlwdF9pZCUyMiUzQSUyMDIlMkMlMjAlMjJ3YWl0ZXJfbmFtZSUyMiUzQSUyMCUyMk1pY2hhZWwlMjBXYXR0cyUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjAzJTJDJTIwJTIyd2FpdGVyX25hbWUlMjIlM0ElMjAlMjJNaWNoYWVsJTIwV2F0dHMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwNCUyQyUyMCUyMndhaXRlcl9uYW1lJTIyJTNBJTIwJTIyTWFyZ2FyZXQlMjBKYW1lcyUyMiU3RCUyQyUwQSU1RCUwQWZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMHN0bXQlMjAlM0QlMjBpbnNlcnQocmVjZWlwdHMpLnZhbHVlcygqKnJvdyklMEElMjAlMjAlMjAlMjB3aXRoJTIwZW5naW5lLmJlZ2luKCklMjBhcyUyMGNvbm5lY3Rpb24lM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjdXJzb3IlMjAlM0QlMjBjb25uZWN0aW9uLmV4ZWN1dGUoc3RtdCk=",highlighted:`table_name = <span class="hljs-string">&quot;waiters&quot;</span>
receipts = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;waiter_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
)
metadata_obj.create_all(engine)

rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Corey Johnson&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>},
]
<span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
    stmt = insert(receipts).values(**row)
    <span class="hljs-keyword">with</span> engine.begin() <span class="hljs-keyword">as</span> connection:
        cursor = connection.execute(stmt)`,wrap:!1}}),G=new r({props:{code:"dXBkYXRlZF9kZXNjcmlwdGlvbiUyMCUzRCUyMCUyMiUyMiUyMkFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMEJld2FyZSUyMHRoYXQlMjB0aGlzJTIwdG9vbCdzJTIwb3V0cHV0JTIwaXMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMGV4ZWN1dGlvbiUyMG91dHB1dC4lMEFJdCUyMGNhbiUyMHVzZSUyMHRoZSUyMGZvbGxvd2luZyUyMHRhYmxlcyUzQSUyMiUyMiUyMiUwQSUwQWluc3BlY3RvciUyMCUzRCUyMGluc3BlY3QoZW5naW5lKSUwQWZvciUyMHRhYmxlJTIwaW4lMjAlNUIlMjJyZWNlaXB0cyUyMiUyQyUyMCUyMndhaXRlcnMlMjIlNUQlM0ElMEElMjAlMjAlMjAlMjBjb2x1bW5zX2luZm8lMjAlM0QlMjAlNUIoY29sJTVCJTIybmFtZSUyMiU1RCUyQyUyMGNvbCU1QiUyMnR5cGUlMjIlNUQpJTIwZm9yJTIwY29sJTIwaW4lMjBpbnNwZWN0b3IuZ2V0X2NvbHVtbnModGFibGUpJTVEJTBBJTBBJTIwJTIwJTIwJTIwdGFibGVfZGVzY3JpcHRpb24lMjAlM0QlMjBmJTIyVGFibGUlMjAnJTdCdGFibGUlN0QnJTNBJTVDbiUyMiUwQSUwQSUyMCUyMCUyMCUyMHRhYmxlX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCklMEElMjAlMjAlMjAlMjB1cGRhdGVkX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyJTVDbiU1Q24lMjIlMjAlMkIlMjB0YWJsZV9kZXNjcmlwdGlvbiUwQSUwQXByaW50KHVwZGF0ZWRfZGVzY3JpcHRpb24p",highlighted:`updated_description = <span class="hljs-string">&quot;&quot;&quot;Allows you to perform SQL queries on the table. Beware that this tool&#x27;s output is a string representation of the execution output.
It can use the following tables:&quot;&quot;&quot;</span>

inspector = inspect(engine)
<span class="hljs-keyword">for</span> table <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;receipts&quot;</span>, <span class="hljs-string">&quot;waiters&quot;</span>]:
    columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(table)]

    table_description = <span class="hljs-string">f&quot;Table &#x27;<span class="hljs-subst">{table}</span>&#x27;:\\n&quot;</span>

    table_description += <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info])
    updated_description += <span class="hljs-string">&quot;\\n\\n&quot;</span> + table_description

<span class="hljs-built_in">print</span>(updated_description)`,wrap:!1}}),$=new r({props:{code:"c3FsX2VuZ2luZS5kZXNjcmlwdGlvbiUyMCUzRCUyMHVwZGF0ZWRfZGVzY3JpcHRpb24lMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QnNxbF9lbmdpbmUlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzREluZmVyZW5jZUNsaWVudE1vZGVsKG1vZGVsX2lkJTNEJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyKSUyQyUwQSklMEElMEFhZ2VudC5ydW4oJTIyV2hpY2glMjB3YWl0ZXIlMjBnb3QlMjBtb3JlJTIwdG90YWwlMjBtb25leSUyMGZyb20lMjB0aXBzJTNGJTIyKQ==",highlighted:`sql_engine.description = updated_description

agent = CodeAgent(
    tools=[sql_engine],
    model=InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>),
)

agent.run(<span class="hljs-string">&quot;Which waiter got more total money from tips?&quot;</span>)`,wrap:!1}}),L=new os({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/zh/examples/text_to_sql.md"}}),{c(){u=M("meta"),K=n(),F=M("p"),P=n(),i(T.$$.fragment),O=n(),i(w.$$.fragment),ll=n(),i(m.$$.fragment),sl=n(),b=M("p"),b.innerHTML=El,tl=n(),I=M("blockquote"),I.innerHTML=Rl,el=n(),C=M("p"),C.textContent=kl,nl=n(),h=M("p"),h.textContent=Nl,al=n(),d=M("p"),d.textContent=_l,Ml=n(),g=M("p"),g.textContent=vl,pl=n(),i(B.$$.fragment),ol=n(),i(Q.$$.fragment),il=n(),f=M("p"),f.textContent=Vl,yl=n(),i(q.$$.fragment),jl=n(),i(Z.$$.fragment),Ul=n(),W=M("p"),W.innerHTML=Gl,Jl=n(),A=M("ul"),A.innerHTML=xl,cl=n(),i(S.$$.fragment),ul=n(),E=M("p"),E.innerHTML=$l,rl=n(),R=M("p"),R.innerHTML=Xl,Tl=n(),i(k.$$.fragment),wl=n(),i(N.$$.fragment),ml=n(),_=M("p"),_.textContent=Hl,bl=n(),i(v.$$.fragment),Il=n(),V=M("p"),V.innerHTML=Yl,Cl=n(),i(G.$$.fragment),hl=n(),x=M("p"),x.innerHTML=zl,dl=n(),i($.$$.fragment),gl=n(),X=M("p"),X.textContent=Ll,Bl=n(),H=M("p"),H.textContent=Fl,Ql=n(),Y=M("ul"),Y.innerHTML=Dl,fl=n(),z=M("p"),z.textContent=Kl,ql=n(),i(L.$$.fragment),Zl=n(),D=M("p"),this.h()},l(l){const s=as("svelte-u9bgzb",document.head);u=p(s,"META",{name:!0,content:!0}),s.forEach(t),K=a(l),F=p(l,"P",{}),Pl(F).forEach(t),P=a(l),y(T.$$.fragment,l),O=a(l),y(w.$$.fragment,l),ll=a(l),y(m.$$.fragment,l),sl=a(l),b=p(l,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1ob817j"&&(b.innerHTML=El),tl=a(l),I=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),o(I)!=="svelte-1nv4dfo"&&(I.innerHTML=Rl),el=a(l),C=p(l,"P",{"data-svelte-h":!0}),o(C)!=="svelte-140w2o6"&&(C.textContent=kl),nl=a(l),h=p(l,"P",{"data-svelte-h":!0}),o(h)!=="svelte-17vkcu6"&&(h.textContent=Nl),al=a(l),d=p(l,"P",{"data-svelte-h":!0}),o(d)!=="svelte-1aktbgq"&&(d.textContent=_l),Ml=a(l),g=p(l,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1y1dwhj"&&(g.textContent=vl),pl=a(l),y(B.$$.fragment,l),ol=a(l),y(Q.$$.fragment,l),il=a(l),f=p(l,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1kv0h82"&&(f.textContent=Vl),yl=a(l),y(q.$$.fragment,l),jl=a(l),y(Z.$$.fragment,l),Ul=a(l),W=p(l,"P",{"data-svelte-h":!0}),o(W)!=="svelte-j0rkid"&&(W.innerHTML=Gl),Jl=a(l),A=p(l,"UL",{"data-svelte-h":!0}),o(A)!=="svelte-trx23w"&&(A.innerHTML=xl),cl=a(l),y(S.$$.fragment,l),ul=a(l),E=p(l,"P",{"data-svelte-h":!0}),o(E)!=="svelte-qczbhp"&&(E.innerHTML=$l),rl=a(l),R=p(l,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1543jkp"&&(R.innerHTML=Xl),Tl=a(l),y(k.$$.fragment,l),wl=a(l),y(N.$$.fragment,l),ml=a(l),_=p(l,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1j4rn1j"&&(_.textContent=Hl),bl=a(l),y(v.$$.fragment,l),Il=a(l),V=p(l,"P",{"data-svelte-h":!0}),o(V)!=="svelte-12610yd"&&(V.innerHTML=Yl),Cl=a(l),y(G.$$.fragment,l),hl=a(l),x=p(l,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1wg9x5z"&&(x.innerHTML=zl),dl=a(l),y($.$$.fragment,l),gl=a(l),X=p(l,"P",{"data-svelte-h":!0}),o(X)!=="svelte-vdr5n0"&&(X.textContent=Ll),Bl=a(l),H=p(l,"P",{"data-svelte-h":!0}),o(H)!=="svelte-q03rhk"&&(H.textContent=Fl),Ql=a(l),Y=p(l,"UL",{"data-svelte-h":!0}),o(Y)!=="svelte-orc4qo"&&(Y.innerHTML=Dl),fl=a(l),z=p(l,"P",{"data-svelte-h":!0}),o(z)!=="svelte-14tva2x"&&(z.textContent=Kl),ql=a(l),y(L.$$.fragment,l),Zl=a(l),D=p(l,"P",{}),Pl(D).forEach(t),this.h()},h(){Ol(u,"name","hf:doc:metadata"),Ol(u,"content",js)},m(l,s){Ms(document.head,u),e(l,K,s),e(l,F,s),e(l,P,s),j(T,l,s),e(l,O,s),j(w,l,s),e(l,ll,s),j(m,l,s),e(l,sl,s),e(l,b,s),e(l,tl,s),e(l,I,s),e(l,el,s),e(l,C,s),e(l,nl,s),e(l,h,s),e(l,al,s),e(l,d,s),e(l,Ml,s),e(l,g,s),e(l,pl,s),j(B,l,s),e(l,ol,s),j(Q,l,s),e(l,il,s),e(l,f,s),e(l,yl,s),j(q,l,s),e(l,jl,s),j(Z,l,s),e(l,Ul,s),e(l,W,s),e(l,Jl,s),e(l,A,s),e(l,cl,s),j(S,l,s),e(l,ul,s),e(l,E,s),e(l,rl,s),e(l,R,s),e(l,Tl,s),j(k,l,s),e(l,wl,s),j(N,l,s),e(l,ml,s),e(l,_,s),e(l,bl,s),j(v,l,s),e(l,Il,s),e(l,V,s),e(l,Cl,s),j(G,l,s),e(l,hl,s),e(l,x,s),e(l,dl,s),j($,l,s),e(l,gl,s),e(l,X,s),e(l,Bl,s),e(l,H,s),e(l,Ql,s),e(l,Y,s),e(l,fl,s),e(l,z,s),e(l,ql,s),j(L,l,s),e(l,Zl,s),e(l,D,s),Wl=!0},p:ss,i(l){Wl||(U(T.$$.fragment,l),U(w.$$.fragment,l),U(m.$$.fragment,l),U(B.$$.fragment,l),U(Q.$$.fragment,l),U(q.$$.fragment,l),U(Z.$$.fragment,l),U(S.$$.fragment,l),U(k.$$.fragment,l),U(N.$$.fragment,l),U(v.$$.fragment,l),U(G.$$.fragment,l),U($.$$.fragment,l),U(L.$$.fragment,l),Wl=!0)},o(l){J(T.$$.fragment,l),J(w.$$.fragment,l),J(m.$$.fragment,l),J(B.$$.fragment,l),J(Q.$$.fragment,l),J(q.$$.fragment,l),J(Z.$$.fragment,l),J(S.$$.fragment,l),J(k.$$.fragment,l),J(N.$$.fragment,l),J(v.$$.fragment,l),J(G.$$.fragment,l),J($.$$.fragment,l),J(L.$$.fragment,l),Wl=!1},d(l){l&&(t(K),t(F),t(P),t(O),t(ll),t(sl),t(b),t(tl),t(I),t(el),t(C),t(nl),t(h),t(al),t(d),t(Ml),t(g),t(pl),t(ol),t(il),t(f),t(yl),t(jl),t(Ul),t(W),t(Jl),t(A),t(cl),t(ul),t(E),t(rl),t(R),t(Tl),t(wl),t(ml),t(_),t(bl),t(Il),t(V),t(Cl),t(hl),t(x),t(dl),t(gl),t(X),t(Bl),t(H),t(Ql),t(Y),t(fl),t(z),t(ql),t(Zl),t(D)),t(u),c(T,l),c(w,l),c(m,l),c(B,l),c(Q,l),c(q,l),c(Z,l),c(S,l),c(k,l),c(N,l),c(v,l),c(G,l),c($,l),c(L,l)}}}const js='{"title":"Text-to-SQL","local":"text-to-sql","sections":[{"title":"构建 agent","local":"构建-agent","sections":[],"depth":3},{"title":"Level 2: 表连接","local":"level-2-表连接","sections":[],"depth":3}],"depth":1}';function Us(Sl){return ts(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ws extends es{constructor(u){super(),ns(this,u,Us,ys,ls,{})}}export{ws as component};
