import{s as Pe,f as He,n as Je,o as je}from"../chunks/scheduler.f6319a2a.js";import{S as Ie,i as Ue,g as i,s as l,r as Y,A as qe,h as a,f as n,c as s,j as Ae,u as Z,x as r,k as lt,y as Ge,a as o,v as Q,d as D,t as K,w as tt}from"../chunks/index.85aa684c.js";import{C as Se}from"../chunks/CodeBlock.3400fc53.js";import{H as st,E as We}from"../chunks/getInferenceSnippets.0233181f.js";function Be(Yt){let u,it,nt,at,h,rt,d,ut,c,Zt="Any efficient system using AI will need to provide LLMs some kind of access to the real world: for instance the possibility to call a search tool to get external information, or to act on certain programs in order to solve a task. In other words, LLMs should have <strong><em>agency</em></strong>. Agentic programs are the gateway to the outside world for LLMs.",pt,p,Qt="<p>AI Agents are <strong>programs where LLM outputs control the workflow</strong>.</p>",mt,f,Dt="Any system leveraging LLMs will integrate the LLM outputs into code. The influence of the LLM’s input on the code workflow is the level of agency of LLMs in the system.",ht,g,Kt="Note that with this definition, “agent” is not a discrete, 0 or 1 definition: instead, “agency” evolves on a continuous spectrum, as you give more or less power to the LLM on your workflow.",dt,w,te="See in the table below how agency can vary across systems:",ct,y,ee="<thead><tr><th>Agency Level</th> <th>Description</th> <th>Short name</th> <th>Example Code</th></tr></thead> <tbody><tr><td>☆☆☆</td> <td>LLM output has no impact on program flow</td> <td>Simple processor</td> <td><code>process_llm_output(llm_response)</code></td></tr> <tr><td>★☆☆</td> <td>LLM output controls an if/else switch</td> <td>Router</td> <td><code>if llm_decision(): path_a() else: path_b()</code></td></tr> <tr><td>★★☆</td> <td>LLM output controls function execution</td> <td>Tool call</td> <td><code>run_function(llm_chosen_tool, llm_chosen_args)</code></td></tr> <tr><td>★★☆</td> <td>LLM output controls iteration and program continuation</td> <td>Multi-step Agent</td> <td><code>while llm_should_continue(): execute_next_step()</code></td></tr> <tr><td>★★★</td> <td>One agentic workflow can start another agentic workflow</td> <td>Multi-Agent</td> <td><code>if llm_trigger(): execute_agent()</code></td></tr> <tr><td>★★★</td> <td>LLM acts in code, can define its own tools / start other agents</td> <td>Code Agents</td> <td><code>def custom_tool(args): ...</code></td></tr></tbody>",ft,v,ne="The multi-step agent has this code structure:",gt,x,wt,b,oe="This agentic system runs in a loop, executing a new action at each step (the action can involve calling some pre-determined <em>tools</em> that are just functions), until its observations make it apparent that a satisfactory state has been reached to solve the given task. Here’s an example of how a multi-step agent can solve a simple math question:",yt,m,le='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/Agent_ManimCE.gif"/>',vt,M,xt,L,se=`Agents are useful when you need an LLM to determine the workflow of an app. But they’re often overkill. The question is: do I really need flexibility in the workflow to efficiently solve the task at hand?
If the pre-determined workflow falls short too often, that means you need more flexibility.
Let’s take an example: say you’re making an app that handles customer requests on a surfing trip website.`,bt,C,ie="You could know in advance that the requests will belong to either of 2 buckets (based on user choice), and you have a predefined workflow for each of these 2 cases.",Mt,_,ae="<li>Want some knowledge on the trips? ⇒ give them access to a search bar to search your knowledge base</li> <li>Wants to talk to sales? ⇒ let them type in a contact form.</li>",Lt,k,re="If that deterministic workflow fits all queries, by all means just code everything! This will give you a 100% reliable system with no risk of error introduced by letting unpredictable LLMs meddle in your workflow. For the sake of simplicity and robustness, it’s advised to regularize towards not using any agentic behaviour.",Ct,T,ue="But what if the workflow can’t be determined that well in advance?",_t,$,pe="For instance, a user wants to ask: <code>&quot;I can come on Monday, but I forgot my passport so risk being delayed to Wednesday, is it possible to take me and my stuff to surf on Tuesday morning, with a cancellation insurance?&quot;</code> This question hinges on many factors, and probably none of the predetermined criteria above will suffice for this request.",kt,A,me="If the pre-determined workflow falls short too often, that means you need more flexibility.",Tt,P,he="That is where an agentic setup helps.",$t,H,de="In the above example, you could just make a multi-step agent that has access to a weather API for weather forecasts, Google Maps API to compute travel distance, an employee availability dashboard and a RAG system on your knowledge base.",At,J,ce="Until recently, computer programs were restricted to pre-determined workflows, trying to handle complexity by piling up  if/else switches. They focused on extremely narrow tasks, like “compute the sum of these numbers” or “find the shortest path in this graph”. But actually, most real-life tasks, like our trip example above, do not fit in pre-determined workflows. Agentic systems open up the vast world of real-world tasks to programs!",Pt,j,Ht,I,fe="For some low-level agentic use cases, like chains or routers, you can write all the code yourself. You’ll be much better that way, since it will let you control and understand your system better.",Jt,U,ge="But once you start going for more complicated behaviours like letting an LLM call a function (that’s “tool calling”) or letting an LLM run a while loop (“multi-step agent”), some abstractions become necessary:",jt,q,we="<li>For tool calling, you need to parse the agent’s output, so this output needs a predefined format like “Thought: I should call tool ‘get_weather’. Action: get_weather(Paris).”, that you parse with a predefined function, and system prompt given to the LLM should notify it about this format.</li> <li>For a multi-step agent where the LLM output determines the loop, you need to give a different prompt to the LLM based on what happened in the last loop iteration: so you need some kind of memory.</li>",It,G,ye="See? With these two examples, we already found the need for a few items to help us:",Ut,S,ve="<li>Of course, an LLM that acts as the engine powering the system</li> <li>A list of tools that the agent can access</li> <li>A system prompt guiding the LLM on the agent logic: ReAct loop of Reflection -&gt; Action -&gt; Observation, available tools, tool calling format to use…</li> <li>A parser that extracts tool calls from the LLM output, in the format indicated by system prompt above.</li> <li>A memory</li>",qt,W,xe="But wait, since we give room to LLMs in decisions, surely they will make mistakes: so we need error logging and retry mechanisms.",Gt,B,be="All these elements need tight coupling to make a well-functioning system. That’s why we decided we needed to make basic building blocks to make all this stuff work together.",St,E,Wt,R,Me="In a multi-step agent, at each step, the LLM can write an action, in the form of some calls to external tools. A common format (used by Anthropic, OpenAI, and many others) for writing these actions is generally different shades of “writing actions as a JSON of tools names and arguments to use, which you then parse to know which tool to execute and with which arguments”.",Bt,O,Le='<a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Multiple</a> <a href="https://huggingface.co/papers/2411.01747" rel="nofollow">research</a> <a href="https://huggingface.co/papers/2401.00812" rel="nofollow">papers</a> have shown that having the LLMs actions written as code snippets is a more natural and flexible way of writing them.',Et,V,Ce=`The reason for this simply that <em>we crafted our code languages specifically to express the actions performed by a computer</em>.
In other words, our agent is going to write programs in order to solve the user’s issues : do you think their programming will be easier in blocks of Python or JSON?`,Rt,N,_e='The figure below, taken from <a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Executable Code Actions Elicit Better LLM Agents</a>, illustrates some advantages of writing actions in code:',Ot,et,ke,Vt,z,Te="Writing actions in code rather than JSON-like snippets provides better:",Nt,F,$e="<li><strong>Composability:</strong> could you nest JSON actions within each other, or define a set of JSON actions to re-use later, the same way you could just define a python function?</li> <li><strong>Object management:</strong> how do you store the output of an action like <code>generate_image</code> in JSON?</li> <li><strong>Generality:</strong> code is built to express simply anything you can have a computer do.</li> <li><strong>Representation in LLM training data:</strong> plenty of quality code actions are already included in LLMs’ training data which means they’re already trained for this!</li>",zt,X,Ft,ot,Xt;return h=new st({props:{title:"What are agents? 🤔",local:"what-are-agents-",headingTag:"h1"}}),d=new st({props:{title:"An introduction to agentic systems.",local:"an-introduction-to-agentic-systems",headingTag:"h2"}}),x=new Se({props:{code:"bWVtb3J5JTIwJTNEJTIwJTVCdXNlcl9kZWZpbmVkX3Rhc2slNUQlMEF3aGlsZSUyMGxsbV9zaG91bGRfY29udGludWUobWVtb3J5KSUzQSUyMCUyMyUyMHRoaXMlMjBsb29wJTIwaXMlMjB0aGUlMjBtdWx0aS1zdGVwJTIwcGFydCUwQSUyMCUyMCUyMCUyMGFjdGlvbiUyMCUzRCUyMGxsbV9nZXRfbmV4dF9hY3Rpb24obWVtb3J5KSUyMCUyMyUyMHRoaXMlMjBpcyUyMHRoZSUyMHRvb2wtY2FsbGluZyUyMHBhcnQlMEElMjAlMjAlMjAlMjBvYnNlcnZhdGlvbnMlMjAlM0QlMjBleGVjdXRlX2FjdGlvbihhY3Rpb24pJTBBJTIwJTIwJTIwJTIwbWVtb3J5JTIwJTJCJTNEJTIwJTVCYWN0aW9uJTJDJTIwb2JzZXJ2YXRpb25zJTVE",highlighted:`memory = [user_defined_task]
<span class="hljs-keyword">while</span> llm_should_continue(memory): <span class="hljs-comment"># this loop is the multi-step part</span>
    action = llm_get_next_action(memory) <span class="hljs-comment"># this is the tool-calling part</span>
    observations = execute_action(action)
    memory += [action, observations]`,wrap:!1}}),M=new st({props:{title:"✅ When to use agents / ⛔ when to avoid them",local:"-when-to-use-agents---when-to-avoid-them",headingTag:"h2"}}),j=new st({props:{title:"Why smolagents ?",local:"why-smolagents-",headingTag:"h2"}}),E=new st({props:{title:"Code agents",local:"code-agents",headingTag:"h2"}}),X=new We({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/conceptual_guides/intro_agents.md"}}),{c(){u=i("meta"),it=l(),nt=i("p"),at=l(),Y(h.$$.fragment),rt=l(),Y(d.$$.fragment),ut=l(),c=i("p"),c.innerHTML=Zt,pt=l(),p=i("blockquote"),p.innerHTML=Qt,mt=l(),f=i("p"),f.textContent=Dt,ht=l(),g=i("p"),g.textContent=Kt,dt=l(),w=i("p"),w.textContent=te,ct=l(),y=i("table"),y.innerHTML=ee,ft=l(),v=i("p"),v.textContent=ne,gt=l(),Y(x.$$.fragment),wt=l(),b=i("p"),b.innerHTML=oe,yt=l(),m=i("div"),m.innerHTML=le,vt=l(),Y(M.$$.fragment),xt=l(),L=i("p"),L.textContent=se,bt=l(),C=i("p"),C.textContent=ie,Mt=l(),_=i("ol"),_.innerHTML=ae,Lt=l(),k=i("p"),k.textContent=re,Ct=l(),T=i("p"),T.textContent=ue,_t=l(),$=i("p"),$.innerHTML=pe,kt=l(),A=i("p"),A.textContent=me,Tt=l(),P=i("p"),P.textContent=he,$t=l(),H=i("p"),H.textContent=de,At=l(),J=i("p"),J.textContent=ce,Pt=l(),Y(j.$$.fragment),Ht=l(),I=i("p"),I.textContent=fe,Jt=l(),U=i("p"),U.textContent=ge,jt=l(),q=i("ul"),q.innerHTML=we,It=l(),G=i("p"),G.textContent=ye,Ut=l(),S=i("ul"),S.innerHTML=ve,qt=l(),W=i("p"),W.textContent=xe,Gt=l(),B=i("p"),B.textContent=be,St=l(),Y(E.$$.fragment),Wt=l(),R=i("p"),R.textContent=Me,Bt=l(),O=i("p"),O.innerHTML=Le,Et=l(),V=i("p"),V.innerHTML=Ce,Rt=l(),N=i("p"),N.innerHTML=_e,Ot=l(),et=i("img"),Vt=l(),z=i("p"),z.textContent=Te,Nt=l(),F=i("ul"),F.innerHTML=$e,zt=l(),Y(X.$$.fragment),Ft=l(),ot=i("p"),this.h()},l(t){const e=qe("svelte-u9bgzb",document.head);u=a(e,"META",{name:!0,content:!0}),e.forEach(n),it=s(t),nt=a(t,"P",{}),Ae(nt).forEach(n),at=s(t),Z(h.$$.fragment,t),rt=s(t),Z(d.$$.fragment,t),ut=s(t),c=a(t,"P",{"data-svelte-h":!0}),r(c)!=="svelte-t8xwkl"&&(c.innerHTML=Zt),pt=s(t),p=a(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(p)!=="svelte-12jgvf4"&&(p.innerHTML=Qt),mt=s(t),f=a(t,"P",{"data-svelte-h":!0}),r(f)!=="svelte-hvpo8l"&&(f.textContent=Dt),ht=s(t),g=a(t,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1ocrk28"&&(g.textContent=Kt),dt=s(t),w=a(t,"P",{"data-svelte-h":!0}),r(w)!=="svelte-15ep98q"&&(w.textContent=te),ct=s(t),y=a(t,"TABLE",{"data-svelte-h":!0}),r(y)!=="svelte-167gmr2"&&(y.innerHTML=ee),ft=s(t),v=a(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1xdd6c8"&&(v.textContent=ne),gt=s(t),Z(x.$$.fragment,t),wt=s(t),b=a(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1n725h4"&&(b.innerHTML=oe),yt=s(t),m=a(t,"DIV",{class:!0,"data-svelte-h":!0}),r(m)!=="svelte-znws87"&&(m.innerHTML=le),vt=s(t),Z(M.$$.fragment,t),xt=s(t),L=a(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1vnvz56"&&(L.textContent=se),bt=s(t),C=a(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-16gbieh"&&(C.textContent=ie),Mt=s(t),_=a(t,"OL",{"data-svelte-h":!0}),r(_)!=="svelte-1v0rus5"&&(_.innerHTML=ae),Lt=s(t),k=a(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-d38gnh"&&(k.textContent=re),Ct=s(t),T=a(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-16wqlg"&&(T.textContent=ue),_t=s(t),$=a(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1qwedk6"&&($.innerHTML=pe),kt=s(t),A=a(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-j2eqzu"&&(A.textContent=me),Tt=s(t),P=a(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-lqbq6n"&&(P.textContent=he),$t=s(t),H=a(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-eus48c"&&(H.textContent=de),At=s(t),J=a(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-4d8m3z"&&(J.textContent=ce),Pt=s(t),Z(j.$$.fragment,t),Ht=s(t),I=a(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1o6p1sy"&&(I.textContent=fe),Jt=s(t),U=a(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-olr701"&&(U.textContent=ge),jt=s(t),q=a(t,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-5j7kqn"&&(q.innerHTML=we),It=s(t),G=a(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-19q6xk9"&&(G.textContent=ye),Ut=s(t),S=a(t,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-fxlju7"&&(S.innerHTML=ve),qt=s(t),W=a(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-95dd5s"&&(W.textContent=xe),Gt=s(t),B=a(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-19mjig0"&&(B.textContent=be),St=s(t),Z(E.$$.fragment,t),Wt=s(t),R=a(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1i79ci0"&&(R.textContent=Me),Bt=s(t),O=a(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-qdqtni"&&(O.innerHTML=Le),Et=s(t),V=a(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-ysoq7h"&&(V.innerHTML=Ce),Rt=s(t),N=a(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1k33473"&&(N.innerHTML=_e),Ot=s(t),et=a(t,"IMG",{src:!0}),Vt=s(t),z=a(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-18lekkw"&&(z.textContent=Te),Nt=s(t),F=a(t,"UL",{"data-svelte-h":!0}),r(F)!=="svelte-1qmn0c3"&&(F.innerHTML=$e),zt=s(t),Z(X.$$.fragment,t),Ft=s(t),ot=a(t,"P",{}),Ae(ot).forEach(n),this.h()},h(){lt(u,"name","hf:doc:metadata"),lt(u,"content",Ee),lt(p,"class","tip"),lt(m,"class","flex justify-center"),He(et.src,ke="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/code_vs_json_actions.png")||lt(et,"src",ke)},m(t,e){Ge(document.head,u),o(t,it,e),o(t,nt,e),o(t,at,e),Q(h,t,e),o(t,rt,e),Q(d,t,e),o(t,ut,e),o(t,c,e),o(t,pt,e),o(t,p,e),o(t,mt,e),o(t,f,e),o(t,ht,e),o(t,g,e),o(t,dt,e),o(t,w,e),o(t,ct,e),o(t,y,e),o(t,ft,e),o(t,v,e),o(t,gt,e),Q(x,t,e),o(t,wt,e),o(t,b,e),o(t,yt,e),o(t,m,e),o(t,vt,e),Q(M,t,e),o(t,xt,e),o(t,L,e),o(t,bt,e),o(t,C,e),o(t,Mt,e),o(t,_,e),o(t,Lt,e),o(t,k,e),o(t,Ct,e),o(t,T,e),o(t,_t,e),o(t,$,e),o(t,kt,e),o(t,A,e),o(t,Tt,e),o(t,P,e),o(t,$t,e),o(t,H,e),o(t,At,e),o(t,J,e),o(t,Pt,e),Q(j,t,e),o(t,Ht,e),o(t,I,e),o(t,Jt,e),o(t,U,e),o(t,jt,e),o(t,q,e),o(t,It,e),o(t,G,e),o(t,Ut,e),o(t,S,e),o(t,qt,e),o(t,W,e),o(t,Gt,e),o(t,B,e),o(t,St,e),Q(E,t,e),o(t,Wt,e),o(t,R,e),o(t,Bt,e),o(t,O,e),o(t,Et,e),o(t,V,e),o(t,Rt,e),o(t,N,e),o(t,Ot,e),o(t,et,e),o(t,Vt,e),o(t,z,e),o(t,Nt,e),o(t,F,e),o(t,zt,e),Q(X,t,e),o(t,Ft,e),o(t,ot,e),Xt=!0},p:Je,i(t){Xt||(D(h.$$.fragment,t),D(d.$$.fragment,t),D(x.$$.fragment,t),D(M.$$.fragment,t),D(j.$$.fragment,t),D(E.$$.fragment,t),D(X.$$.fragment,t),Xt=!0)},o(t){K(h.$$.fragment,t),K(d.$$.fragment,t),K(x.$$.fragment,t),K(M.$$.fragment,t),K(j.$$.fragment,t),K(E.$$.fragment,t),K(X.$$.fragment,t),Xt=!1},d(t){t&&(n(it),n(nt),n(at),n(rt),n(ut),n(c),n(pt),n(p),n(mt),n(f),n(ht),n(g),n(dt),n(w),n(ct),n(y),n(ft),n(v),n(gt),n(wt),n(b),n(yt),n(m),n(vt),n(xt),n(L),n(bt),n(C),n(Mt),n(_),n(Lt),n(k),n(Ct),n(T),n(_t),n($),n(kt),n(A),n(Tt),n(P),n($t),n(H),n(At),n(J),n(Pt),n(Ht),n(I),n(Jt),n(U),n(jt),n(q),n(It),n(G),n(Ut),n(S),n(qt),n(W),n(Gt),n(B),n(St),n(Wt),n(R),n(Bt),n(O),n(Et),n(V),n(Rt),n(N),n(Ot),n(et),n(Vt),n(z),n(Nt),n(F),n(zt),n(Ft),n(ot)),n(u),tt(h,t),tt(d,t),tt(x,t),tt(M,t),tt(j,t),tt(E,t),tt(X,t)}}}const Ee='{"title":"What are agents? 🤔","local":"what-are-agents-","sections":[{"title":"An introduction to agentic systems.","local":"an-introduction-to-agentic-systems","sections":[],"depth":2},{"title":"✅ When to use agents / ⛔ when to avoid them","local":"-when-to-use-agents---when-to-avoid-them","sections":[],"depth":2},{"title":"Why smolagents ?","local":"why-smolagents-","sections":[],"depth":2},{"title":"Code agents","local":"code-agents","sections":[],"depth":2}],"depth":1}';function Re(Yt){return je(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fe extends Ie{constructor(u){super(),Ue(this,u,Re,Be,Pe,{})}}export{Fe as component};
