import{s as Ac,o as Kc,n as j}from"../chunks/scheduler.6062bdaf.js";import{S as eu,i as tu,g as m,s as a,r as u,A as nu,h as d,f as r,c as l,j as x,u as g,x as T,k as $,y as o,a as c,v as f,d as h,t as _,w as b}from"../chunks/index.4bca734e.js";import{T as Z}from"../chunks/Tip.b9ac1f03.js";import{D as k}from"../chunks/Docstring.ed07512f.js";import{C as U}from"../chunks/CodeBlock.fa01571c.js";import{E as R}from"../chunks/ExampleCodeBlock.823fb173.js";import{H as J}from"../chunks/Heading.723dceba.js";function ou(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(i){n=d(i,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(i,s){c(i,n,s)},p:j,d(i){i&&r(n)}}}function su(v){let n,M="Example of text generation:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ2F1c2FsTE0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMk15JTIwbmFtZSUyMGlzJTIwQXJ0aHVyJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBZ2VuX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDZG9fc2FtcGxlJTNEVHJ1ZSUyQ3RlbXBlcmF0dXJlJTNEMC45JTJDJTIwbWluX2xlbmd0aCUzRDIwJTJDbWF4X2xlbmd0aCUzRDIwKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuX3Rva2Vucyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Arthur and I live in&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs,do_sample=<span class="hljs-literal">True</span>,temperature=<span class="hljs-number">0.9</span>, min_length=<span class="hljs-number">20</span>,max_length=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1bvu0cy"&&(n.textContent=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function au(v){let n,M="Example using <code>transformers.pipelines</code>:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmdwdDIlMjIpJTBBb25ueF9nZW4lMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMEFydGh1ciUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjIlMEFnZW4lMjAlM0QlMjBvbm54X2dlbih0ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_gen = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Arthur and I live in&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen = onnx_gen(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1da1qsq"&&(n.innerHTML=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function lu(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(i){n=d(i,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(i,s){c(i,n,s)},p:j,d(i){i&&r(n)}}}function iu(v){let n,M="Example of feature extraction:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yTWFza2VkTE0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtdW5jYXNlZC1mb3ItZmlsbC1tYXNrJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS11bmNhc2VkLWZvci1maWxsLW1hc2slMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwJTVCTUFTSyU1RC4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">8</span>, <span class="hljs-number">28996</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-12vwt80"&&(n.textContent=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function ru(v){let n,M="Example using <code>transformers.pipeline</code>:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JNYXNrZWRMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtdW5jYXNlZC1mb3ItZmlsbC1tYXNrJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS11bmNhc2VkLWZvci1maWxsLW1hc2slMjIpJTBBZmlsbF9tYXNrZXIlMjAlM0QlMjBwaXBlbGluZSglMjJmaWxsLW1hc2slMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMCU1Qk1BU0slNUQuJTIyJTBBcHJlZCUyMCUzRCUyMGZpbGxfbWFza2VyKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>fill_masker = pipeline(<span class="hljs-string">&quot;fill-mask&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = fill_masker(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function pu(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(i){n=d(i,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(i,s){c(i,n,s)},p:j,d(i){i&&r(n)}}}function mu(v){let n,M="Example of text generation:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VxMlNlcUxNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnQ1LXNtYWxsJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ0NS1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyTXklMjBuYW1lJTIwaXMlMjBFdXN0YWNoZSUyMGFuZCUyMEklMjBsaWtlJTIwdG8lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Eustache and I like to&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1bvu0cy"&&(n.textContent=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function du(v){let n,M="Example using <code>transformers.pipeline</code>:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGdDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnQ1LXNtYWxsJTIyKSUwQW9ubnhfdHJhbnNsYXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJ0cmFuc2xhdGlvbl9lbl90b19kZSUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBdGV4dCUyMCUzRCUyMCUyMk15JTIwbmFtZSUyMGlzJTIwRXVzdGFjaGUuJTIyJTBBcHJlZCUyMCUzRCUyMG9ubnhfdHJhbnNsYXRpb24odGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_translation = pipeline(<span class="hljs-string">&quot;translation_en_to_de&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Eustache.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_translation(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function cu(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(i){n=d(i,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(i,s){c(i,n,s)},p:j,d(i){i&&r(n)}}}function uu(v){let n,M="Example of single-label classification:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-ykxpe4"&&(n.textContent=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function gu(v){let n,M="Example using <code>transformers.pipelines</code>:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIpJTBBb25ueF9jbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBdGV4dCUyMCUzRCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9jbGFzc2lmaWVyKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_classifier = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_classifier(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1da1qsq"&&(n.innerHTML=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function fu(v){let n,M="Example using zero-shot-classification <code>transformers.pipelines</code>:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLW1ubGklMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1tbmxpJTIyKSUwQW9ubnhfejAlMjAlM0QlMjBwaXBlbGluZSglMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXNlcXVlbmNlX3RvX2NsYXNzaWZ5JTIwJTNEJTIwJTIyV2hvJTIwYXJlJTIweW91JTIwdm90aW5nJTIwZm9yJTIwaW4lMjAyMDIwJTNGJTIyJTBBY2FuZGlkYXRlX2xhYmVscyUyMCUzRCUyMCU1QiUyMkV1cm9wZSUyMiUyQyUyMCUyMnB1YmxpYyUyMGhlYWx0aCUyMiUyQyUyMCUyMnBvbGl0aWNzJTIyJTJDJTIwJTIyZWxlY3Rpb25zJTIyJTVEJTBBcHJlZCUyMCUzRCUyMG9ubnhfejAoc2VxdWVuY2VfdG9fY2xhc3NpZnklMkMlMjBjYW5kaWRhdGVfbGFiZWxzJTJDJTIwbXVsdGlfbGFiZWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_z0 = pipeline(<span class="hljs-string">&quot;zero-shot-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_to_classify = <span class="hljs-string">&quot;Who are you voting for in 2020?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>candidate_labels = [<span class="hljs-string">&quot;Europe&quot;</span>, <span class="hljs-string">&quot;public health&quot;</span>, <span class="hljs-string">&quot;politics&quot;</span>, <span class="hljs-string">&quot;elections&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_z0(sequence_to_classify, candidate_labels, multi_label=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1vtj8d2"&&(n.innerHTML=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function hu(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(i){n=d(i,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(i,s){c(i,n,s)},p:j,d(i){i&&r(n)}}}function _u(v){let n,M="Example of token classification:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS1ORVIlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtTkVSJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">9</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-rtgw80"&&(n.textContent=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function bu(v){let n,M="Example using <code>transformers.pipelines</code>:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS1ORVIlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtTkVSJTIyKSUwQW9ubnhfbmVyJTIwJTNEJTIwcGlwZWxpbmUoJTIydG9rZW4tY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9uZXIodGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_ner = pipeline(<span class="hljs-string">&quot;token-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_ner(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1da1qsq"&&(n.innerHTML=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function yu(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(i){n=d(i,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(i,s){c(i,n,s)},p:j,d(i){i&&r(n)}}}function Tu(v){let n,M="Example of mutliple choice:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yTXVsdGlwbGVDaG9pY2UlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJlaGR3bnMxNTE2JTJGYmVydC1iYXNlLXVuY2FzZWRfU1dBRyUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMmVoZHduczE1MTYlMkZiZXJ0LWJhc2UtdW5jYXNlZF9TV0FHJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEElMEFudW1fY2hvaWNlcyUyMCUzRCUyMDQlMEFmaXJzdF9zZW50ZW5jZSUyMCUzRCUyMCU1QiUyMk1lbWJlcnMlMjBvZiUyMHRoZSUyMHByb2Nlc3Npb24lMjB3YWxrJTIwZG93biUyMHRoZSUyMHN0cmVldCUyMGhvbGRpbmclMjBzbWFsbCUyMGhvcm4lMjBicmFzcyUyMGluc3RydW1lbnRzLiUyMiU1RCUyMColMjBudW1fY2hvaWNlcyUwQXNlY29uZF9zZW50ZW5jZSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMkElMjBkcnVtJTIwbGluZSUyMHBhc3NlcyUyMGJ5JTIwd2Fsa2luZyUyMGRvd24lMjB0aGUlMjBzdHJlZXQlMjBwbGF5aW5nJTIwdGhlaXIlMjBpbnN0cnVtZW50cy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjBoYXMlMjBoZWFyZCUyMGFwcHJvYWNoaW5nJTIwdGhlbS4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjBhcnJpdmVzJTIwYW5kJTIwdGhleSdyZSUyMG91dHNpZGUlMjBkYW5jaW5nJTIwYW5kJTIwYXNsZWVwLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkElMjBkcnVtJTIwbGluZSUyMHR1cm5zJTIwdGhlJTIwbGVhZCUyMHNpbmdlciUyMHdhdGNoZXMlMjB0aGUlMjBwZXJmb3JtYW5jZS4lMjIlMEElNUQlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoZmlyc3Rfc2VudGVuY2UlMkMlMjBzZWNvbmRfc2VudGVuY2UlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQSUwQWZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyU1QmslNUQlMjAlM0QlMjAlNUJ2JTVCaSUzQSUyMGklMjAlMkIlMjBudW1fY2hvaWNlcyU1RCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKDAlMkMlMjBsZW4odiklMkMlMjBudW1fY2hvaWNlcyklNUQlMEFpbnB1dHMlMjAlM0QlMjBkaWN0KGlucHV0cy5jb252ZXJ0X3RvX3RlbnNvcnModGVuc29yX3R5cGUlM0QlMjJwdCUyMikpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;ehdwns1516/bert-base-uncased_SWAG&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;ehdwns1516/bert-base-uncased_SWAG&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_choices = <span class="hljs-number">4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>first_sentence = [<span class="hljs-string">&quot;Members of the procession walk down the street holding small horn brass instruments.&quot;</span>] * num_choices
<span class="hljs-meta">&gt;&gt;&gt; </span>second_sentence = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line passes by walking down the street playing their instruments.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line has heard approaching them.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line arrives and they&#x27;re outside dancing and asleep.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line turns the lead singer watches the performance.&quot;</span>
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(first_sentence, second_sentence, truncation=<span class="hljs-literal">True</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Unflatten the inputs values expanding it to the shape [batch_size, num_choices, seq_length]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items():
<span class="hljs-meta">... </span>    inputs[k] = [v[i: i + num_choices] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(v), num_choices)]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-built_in">dict</span>(inputs.convert_to_tensors(tensor_type=<span class="hljs-string">&quot;pt&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-lfckvi"&&(n.textContent=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function Mu(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(i){n=d(i,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(i,s){c(i,n,s)},p:j,d(i){i&&r(n)}}}function wu(v){let n,M="Example of question answering:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocXVlc3Rpb24lMkMlMjB0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEFzdGFydF9wb3NpdGlvbnMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCMSU1RCklMEFlbmRfcG9zaXRpb25zJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjMlNUQpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwc3RhcnRfcG9zaXRpb25zJTNEc3RhcnRfcG9zaXRpb25zJTJDJTIwZW5kX3Bvc2l0aW9ucyUzRGVuZF9wb3NpdGlvbnMpJTBBc3RhcnRfc2NvcmVzJTIwJTNEJTIwb3V0cHV0cy5zdGFydF9sb2dpdHMlMEFlbmRfc2NvcmVzJTIwJTNEJTIwb3V0cHV0cy5lbmRfbG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_positions = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>end_positions = torch.tensor([<span class="hljs-number">3</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=start_positions, end_positions=end_positions)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_scores = outputs.start_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>end_scores = outputs.end_logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1ml1brl"&&(n.textContent=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function vu(v){let n,M="Example using <code>transformers.pipeline</code>:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTBBb25ueF9xYSUyMCUzRCUyMHBpcGVsaW5lKCUyMnF1ZXN0aW9uLWFuc3dlcmluZyUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9xYShxdWVzdGlvbiUyQyUyMHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_qa = pipeline(<span class="hljs-string">&quot;question-answering&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_qa(question, text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function xu(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(i){n=d(i,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(i,s){c(i,n,s)},p:j,d(i){i&&r(n)}}}function $u(v){let n,M="Example of image classification:",i,s,y;return s=new U({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvRmVhdHVyZUV4dHJhY3RvciUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFwcmVwcm9jZXNzb3IlMjAlM0QlMjBBdXRvRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJlcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1nh3zco"&&(n.textContent=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function ku(v){let n,M="Example using <code>transformers.pipeline</code>:",i,s,y;return s=new U({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBcHJlcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQW9ubnhfaW1hZ2VfY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMmltYWdlLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJlcHJvY2Vzc29yKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9pbWFnZV9jbGFzc2lmaWVyKHVybCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_image_classifier = pipeline(<span class="hljs-string">&quot;image-classification&quot;</span>, model=model, feature_extractor=preprocessor)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_image_classifier(url)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function ju(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(i){n=d(i,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(i,s){c(i,n,s)},p:j,d(i){i&&r(n)}}}function Ju(v){let n,M="Example of semantic segmentation:",i,s,y;return s=new U({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBcHJlcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzZWdmb3JtZXItYjAtZmluZXR1bmVkLWFkZS01MTItNTEyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnNlZ2Zvcm1lci1iMC1maW5ldHVuZWQtYWRlLTUxMi01MTIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJlcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSemanticSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1wzzaup"&&(n.textContent=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function Ru(v){let n,M="Example using <code>transformers.pipeline</code>:",i,s,y;return s=new U({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbiUwQSUwQXByZXByb2Nlc3NvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGc2VnZm9ybWVyLWIwLWZpbmV0dW5lZC1hZGUtNTEyLTUxMiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzZWdmb3JtZXItYjAtZmluZXR1bmVkLWFkZS01MTItNTEyJTIyKSUwQW9ubnhfaW1hZ2Vfc2VnbWVudGVyJTIwJTNEJTIwcGlwZWxpbmUoJTIyaW1hZ2Utc2VnbWVudGF0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJlcHJvY2Vzc29yKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9pbWFnZV9zZWdtZW50ZXIodXJsKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_image_segmenter = pipeline(<span class="hljs-string">&quot;image-segmentation&quot;</span>, model=model, feature_extractor=preprocessor)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_image_segmenter(url)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function Uu(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(i){n=d(i,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(i,s){c(i,n,s)},p:j,d(i){i&&r(n)}}}function Iu(v){let n,M="Example of audio classification:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kZW1vJTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc29ydCglMjJpZCUyMiklMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwZGF0YXNldC5mZWF0dXJlcyU1QiUyMmF1ZGlvJTIyJTVELnNhbXBsaW5nX3JhdGUlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkcyUyMCUzRCUyMHRvcmNoLmFyZ21heChsb2dpdHMlMkMlMjBkaW0lM0QtMSkuaXRlbSgpJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkcyU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = model.config.id2label[predicted_class_ids]`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1mp8f15"&&(n.textContent=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function Cu(v){let n,M="Example using <code>transformers.pipeline</code>:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTJDJTIwcGlwZWxpbmUlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQXVkaW9DbGFzc2lmaWNhdGlvbiUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZodWJlcnQtYmFzZS1zdXBlcmIta3MlMjIpJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQW9ubnhfYWMlMjAlM0QlMjBwaXBlbGluZSglMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBmZWF0dXJlX2V4dHJhY3RvciUzRGZlYXR1cmVfZXh0cmFjdG9yKSUwQSUwQXByZWQlMjAlM0QlMjBvbm54X2FjKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_ac = pipeline(<span class="hljs-string">&quot;audio-classification&quot;</span>, model=model, feature_extractor=feature_extractor)

<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_ac(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function Zu(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(i){n=d(i,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(i,s){c(i,n,s)},p:j,d(i){i&&r(n)}}}function Wu(v){let n,M="Example of audio frame classification:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvRnJhbWVDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3YXYydmVjMi1iYXNlLXN1cGVyYi1zZCUyMiklMEFtb2RlbCUyMCUzRCUyMCUyME9SVE1vZGVsRm9yQXVkaW9GcmFtZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc2QlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJvYmFiaWxpdGllcyUyMCUzRCUyMHRvcmNoLnNpZ21vaWQobG9naXRzJTVCMCU1RCklMEFsYWJlbHMlMjAlM0QlMjAocHJvYmFiaWxpdGllcyUyMCUzRSUyMDAuNSkubG9uZygpJTBBbGFiZWxzJTVCMCU1RC50b2xpc3QoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioFrameClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sd&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model =  ORTModelForAudioFrameClassification.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sd&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, sampling_rate=sampling_rate)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.sigmoid(logits[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = (probabilities &gt; <span class="hljs-number">0.5</span>).long()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels[<span class="hljs-number">0</span>].tolist()`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-12boqdm"&&(n.textContent=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function Nu(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(i){n=d(i,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(i,s){c(i,n,s)},p:j,d(i){i&&r(n)}}}function Su(v){let n,M="Example of CTC:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBIdWJlcnRGb3JDVEMlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ1RDJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwdG9yY2glMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZGVtbyUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNvcnQoJTIyaWQlMjIpJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGRhdGFzZXQuZmVhdHVyZXMlNUIlMjJhdWRpbyUyMiU1RC5zYW1wbGluZ19yYXRlJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmh1YmVydC1sYXJnZS1sczk2MC1mdCUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWxhcmdlLWxzOTYwLWZ0JTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQXByZWRpY3RlZF9pZHMlMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTJDJTIwZGltJTNELTEpJTBBJTBBdHJhbnNjcmlwdGlvbiUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUocHJlZGljdGVkX2lkcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, HubertForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-large-ls960-ft&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCTC.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-large-ls960-ft&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(predicted_ids)`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-mdyxnj"&&(n.textContent=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function Fu(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(i){n=d(i,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(i,s){c(i,n,s)},p:j,d(i){i&&r(n)}}}function Ou(v){let n,M="Example of text generation:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU3BlZWNoU2VxMlNlcSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3aGlzcGVyLXRpbnkuZW4lMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3aGlzcGVyLXRpbnkuZW4lMjIpJTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kdW1teSUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvci5mZWF0dXJlX2V4dHJhY3RvcihkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFnZW5fdG9rZW5zJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTNEaW5wdXRzLmlucHV0X2ZlYXR1cmVzKSUwQW91dHB1dHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSpeechSeq2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor.feature_extractor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(inputs=inputs.input_features)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = processor.tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1bvu0cy"&&(n.textContent=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function Gu(v){let n,M="Example using <code>transformers.pipeline</code>:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTcGVlY2hTZXEyU2VxJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRndoaXNwZXItdGlueS5lbiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU3BlZWNoU2VxMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRndoaXNwZXItdGlueS5lbiUyMiklMEFzcGVlY2hfcmVjb2duaXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHByb2Nlc3Nvci50b2tlbml6ZXIlMkMlMjBmZWF0dXJlX2V4dHJhY3RvciUzRHByb2Nlc3Nvci5mZWF0dXJlX2V4dHJhY3RvciklMEElMEFkcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBcHJlZCUyMCUzRCUyMHNwZWVjaF9yZWNvZ25pdGlvbihkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSpeechSeq2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>speech_recognition = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=model, tokenizer=processor.tokenizer, feature_extractor=processor.feature_extractor)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = speech_recognition(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function Xu(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(i){n=d(i,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(i,s){c(i,n,s)},p:j,d(i){i&&r(n)}}}function Vu(v){let n,M="Example of Audio XVector:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvWFZlY3RvciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3YXYydmVjMi1iYXNlLXN1cGVyYi1zdiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQXVkaW9YVmVjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc3YlMjIpJTBBJTBBJTIzJTIwYXVkaW8lMjBmaWxlJTIwaXMlMjBkZWNvZGVkJTIwb24lMjB0aGUlMjBmbHklMEFpbnB1dHMlMjAlM0QlMjBmZWF0dXJlX2V4dHJhY3RvciglMEElMjAlMjAlMjAlMjAlNUJkJTVCJTIyYXJyYXklMjIlNUQlMjBmb3IlMjBkJTIwaW4lMjBkYXRhc2V0JTVCJTNBMiU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUlMEEpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGVtYmVkZGluZ3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykuZW1iZWRkaW5ncyUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLm5vcm1hbGl6ZShlbWJlZGRpbmdzJTJDJTIwZGltJTNELTEpLmNwdSgpJTBBJTBBY29zaW5lX3NpbSUyMCUzRCUyMHRvcmNoLm5uLkNvc2luZVNpbWlsYXJpdHkoZGltJTNELTEpJTBBc2ltaWxhcml0eSUyMCUzRCUyMGNvc2luZV9zaW0oZW1iZWRkaW5ncyU1QjAlNUQlMkMlMjBlbWJlZGRpbmdzJTVCMSU1RCklMEF0aHJlc2hvbGQlMjAlM0QlMjAwLjclMEFpZiUyMHNpbWlsYXJpdHklMjAlM0MlMjB0aHJlc2hvbGQlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJTcGVha2VycyUyMGFyZSUyMG5vdCUyMHRoZSUyMHNhbWUhJTIyKSUwQXJvdW5kKHNpbWlsYXJpdHkuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioXVector
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioXVector.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(
<span class="hljs-meta">... </span>    [d[<span class="hljs-string">&quot;array&quot;</span>] <span class="hljs-keyword">for</span> d <span class="hljs-keyword">in</span> dataset[:<span class="hljs-number">2</span>][<span class="hljs-string">&quot;audio&quot;</span>]], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    embeddings = model(**inputs).embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = torch.nn.functional.normalize(embeddings, dim=-<span class="hljs-number">1</span>).cpu()

<span class="hljs-meta">&gt;&gt;&gt; </span>cosine_sim = torch.nn.CosineSimilarity(dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>similarity = cosine_sim(embeddings[<span class="hljs-number">0</span>], embeddings[<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>threshold = <span class="hljs-number">0.7</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> similarity &lt; threshold:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Speakers are not the same!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(similarity.item(), <span class="hljs-number">2</span>)`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1kzdm5c"&&(n.textContent=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function zu(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(i){n=d(i,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(i,s){c(i,n,s)},p:j,d(i){i&&r(n)}}}function Lu(v){let n,M="Example of text generation:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yVmlzaW9uMlNlcSUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yVmlzaW9uMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIybmxwY29ubmVjdCUyRnZpdC1ncHQyLWltYWdlLWNhcHRpb25pbmclMjIlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForVision2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests


<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = tokenizer.batch_decode(gen_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1bvu0cy"&&(n.textContent=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function qu(v){let n,M="Example using <code>transformers.pipeline</code>:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JWaXNpb24yU2VxJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm5scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm5scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3RvX3RleHQlMjAlM0QlMjBwaXBlbGluZSglMjJpbWFnZS10by10ZXh0JTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJvY2Vzc29yJTJDJTIwaW1hZ2VfcHJvY2Vzc29yJTNEcHJvY2Vzc29yKSUwQXByZWQlMjAlM0QlMjBpbWFnZV90b190ZXh0KGltYWdlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForVision2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests


<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_to_text = pipeline(<span class="hljs-string">&quot;image-to-text&quot;</span>, model=model, tokenizer=tokenizer, feature_extractor=processor, image_processor=processor)
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = image_to_text(image)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function Bu(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(i){n=d(i,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(i,s){c(i,n,s)},p:j,d(i){i&&r(n)}}}function Hu(v){let n,M="Example of pix2struct:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUGl4MlN0cnVjdCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGcGl4MnN0cnVjdC1haTJkLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclBpeDJTdHJ1Y3QuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnBpeDJzdHJ1Y3QtYWkyZC1iYXNlJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMHVzZV9pb19iaW5kaW5nJTNEVHJ1ZSklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0cmFuc2Zvcm1lcnMlMkZ0YXNrcyUyRmFpMmQtZGVtby5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFxdWVzdGlvbiUyMCUzRCUyMCUyMldoYXQlMjBkb2VzJTIwdGhlJTIwbGFiZWwlMjAxNSUyMHJlcHJlc2VudCUzRiUyMCgxKSUyMGxhdmElMjAoMiklMjBjb3JlJTIwKDMpJTIwdHVubmVsJTIwKDQpJTIwYXNoJTIwY2xvdWQlMjIlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjB0ZXh0JTNEcXVlc3Rpb24lMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForPix2Struct
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/pix2struct-ai2d-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForPix2Struct.from_pretrained(<span class="hljs-string">&quot;google/pix2struct-ai2d-base&quot;</span>, export=<span class="hljs-literal">True</span>, use_io_binding=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/ai2d-demo.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What does the label 15 represent? (1) lava (2) core (3) tunnel (4) ash cloud&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = processor.batch_decode(gen_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11ikyn3"&&(n.textContent=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function Pu(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(i){n=d(i,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(i,s){c(i,n,s)},p:j,d(i){i&&r(n)}}}function Eu(v){let n,M="Example of custom tasks(e.g. a sentence transformers taking <code>pooler_output</code> as output):",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ3VzdG9tVGFza3MlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGc2JlcnQtYWxsLU1pbmlMTS1MNi13aXRoLXBvb2xlciUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQ3VzdG9tVGFza3MuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzYmVydC1hbGwtTWluaUxNLUw2LXdpdGgtcG9vbGVyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJJJTIwbG92ZSUyMGJ1cnJpdG9zISUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQXBvb2xlcl9vdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnBvb2xlcl9vdXRwdXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCustomTasks

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCustomTasks.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;I love burritos!&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooler_output = outputs.pooler_output`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-6kynse"&&(n.innerHTML=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function Qu(v){let n,M="Example using <code>transformers.pipelines</code>(only if the task is supported):",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JDdXN0b21UYXNrcyUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzYmVydC1hbGwtTWluaUxNLUw2LXdpdGgtcG9vbGVyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDdXN0b21UYXNrcy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnNiZXJ0LWFsbC1NaW5pTE0tTDYtd2l0aC1wb29sZXIlMjIpJTBBb25ueF9leHRyYWN0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJJJTIwbG92ZSUyMGJ1cnJpdG9zISUyMiUwQXByZWQlMjAlM0QlMjBvbm54X2V4dHJhY3Rvcih0ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCustomTasks

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCustomTasks.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_extractor = pipeline(<span class="hljs-string">&quot;feature-extraction&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;I love burritos!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_extractor(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-xxeb0k"&&(n.innerHTML=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function Du(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(i){n=d(i,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(i,s){c(i,n,s)},p:j,d(i){i&&r(n)}}}function Yu(v){let n,M="Example of feature extraction:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yRmVhdHVyZUV4dHJhY3Rpb24lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZhbGwtTWluaUxNLUw2LXYyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmFsbC1NaW5pTE0tTDYtdjIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMk15JTIwbmFtZSUyMGlzJTIwUGhpbGlwcCUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBHZXJtYW55LiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGUuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForFeatureExtraction
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForFeatureExtraction.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_state.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">384</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-12vwt80"&&(n.textContent=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function Au(v){let n,M="Example using <code>transformers.pipeline</code>:",i,s,y;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZhbGwtTWluaUxNLUw2LXYyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmFsbC1NaW5pTE0tTDYtdjIlMjIpJTBBb25ueF9leHRyYWN0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9leHRyYWN0b3IodGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForFeatureExtraction

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForFeatureExtraction.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_extractor = pipeline(<span class="hljs-string">&quot;feature-extraction&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_extractor(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,i=a(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),i=l(t),g(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,i,w),f(s,t,w),y=!0},p:j,i(t){y||(h(s.$$.fragment,t),y=!0)},o(t){_(s.$$.fragment,t),y=!1},d(t){t&&(r(n),r(i)),b(s,t)}}}function Ku(v){let n,M,i,s,y,t,w,dl,bn,Pm="The following ORT classes are available for instantiating a base model class without a specific head.",cl,yn,ul,I,Tn,vi,ds,Em="Base class for implementing models using ONNX Runtime.",xi,cs,Qm=`The ORTModel implements generic methods for interacting with the Hugging Face Hub as well as exporting vanilla
transformers models to ONNX using <code>optimum.exporters.onnx</code> toolchain.`,$i,us,Dm="Class attributes:",ki,gs,Ym=`<li>model_type (<code>str</code>, <em>optional</em>, defaults to <code>&quot;onnx_model&quot;</code>) — The name of the model type to use when
registering the ORTModel classes.</li> <li>auto_model_class (<code>Type</code>, <em>optional</em>, defaults to <code>AutoModel</code>) — The “AutoModel” class to represented by the
current ORTModel class.</li>`,ji,fs,Am="Common attributes:",Ji,hs,Km=`<li>model (<code>ort.InferenceSession</code>) — The ONNX Runtime InferenceSession that is running the model.</li> <li>config (<a href="https://huggingface.co/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> — The configuration of the model.</li> <li>use_io_binding (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) — Whether to use I/O bindings with <strong>ONNX Runtime
with the CUDAExecutionProvider</strong>, this can significantly speedup inference depending on the task.</li> <li>model_save_dir (<code>Path</code>) — The directory where the model exported to ONNX is saved.
By defaults, if the loaded model is local, the directory where the original model will be used. Otherwise, the
cache directory is used.</li> <li>providers (\`List[str]) — The list of execution providers available to ONNX Runtime.</li>`,Ri,mt,Mn,Ui,_s,ed="Instantiate a pretrained model from a pre-trained model configuration.",Ii,dt,wn,Ci,bs,td=`Loads an ONNX Inference session with a given provider. Default provider is <code>CPUExecutionProvider</code> to match the
default behaviour in PyTorch/TensorFlow/JAX.`,Zi,ct,vn,Wi,ys,nd="Raises an error if IO Binding is requested although the tensor used are numpy arrays.",Ni,ut,xn,Si,Ts,od="Initializes attributes that may be shared among several ONNX Runtime inference sesssions.",Fi,gt,$n,Oi,Ms,sd="Changes the ONNX Runtime provider according to the device.",gl,kn,fl,jn,ad="The following ORT classes are available for the following natural language processing tasks.",hl,Jn,_l,N,Rn,Gi,ws,ld="ONNX model with a causal language modeling head for ONNX Runtime inference. This class officially supports bloom, codegen, falcon, gpt2, gpt_bigcode, gpt_neo, gpt_neox, gptj, llama.",Xi,vs,id=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Vi,xs,rd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',zi,le,Un,Li,$s,pd="The <code>ORTModelForCausalLM</code> forward method, overrides the <code>__call__</code> special method.",qi,ft,Bi,ht,Hi,_t,bl,In,yl,S,Cn,Pi,ks,md="ONNX Model with a MaskedLMOutput for masked language modeling tasks. This class officially supports albert, bert, camembert, convbert, data2vec_text, deberta, deberta_v2, distilbert, electra, flaubert, ibert, mobilebert, roberta, roformer, squeezebert, xlm, xlm_roberta.",Ei,js,dd=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Qi,Js,cd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Di,ie,Zn,Yi,Rs,ud="The <code>ORTModelForMaskedLM</code> forward method, overrides the <code>__call__</code> special method.",Ai,bt,Ki,yt,er,Tt,Tl,Wn,Ml,F,Nn,tr,Us,gd="Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports bart, blenderbot, blenderbot_small, longt5, m2m_100, marian, mbart, mt5, pegasus, t5.",nr,Is,fd=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,or,Cs,hd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',sr,re,Sn,ar,Zs,_d="The <code>ORTModelForSeq2SeqLM</code> forward method, overrides the <code>__call__</code> special method.",lr,Mt,ir,wt,rr,vt,wl,Fn,vl,O,On,pr,Ws,bd=`ONNX Model with a sequence classification/regression head on top (a linear layer on top of the
pooled output) e.g. for GLUE tasks. This class officially supports albert, bart, bert, camembert, convbert, data2vec_text, deberta, deberta_v2, distilbert, electra, flaubert, ibert, mbart, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.`,mr,Ns,yd=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,dr,Ss,Td='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',cr,W,Gn,ur,Fs,Md="The <code>ORTModelForSequenceClassification</code> forward method, overrides the <code>__call__</code> special method.",gr,xt,fr,$t,hr,kt,_r,jt,xl,Xn,$l,G,Vn,br,Os,wd=`ONNX Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g.
for Named-Entity-Recognition (NER) tasks. This class officially supports albert, bert, bloom, camembert, convbert, data2vec_text, deberta, deberta_v2, distilbert, electra, flaubert, gpt2, ibert, mobilebert, roberta, roformer, squeezebert, xlm, xlm_roberta.`,yr,Gs,vd=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Tr,Xs,xd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Mr,pe,zn,wr,Vs,$d="The <code>ORTModelForTokenClassification</code> forward method, overrides the <code>__call__</code> special method.",vr,Jt,xr,Rt,$r,Ut,kl,Ln,jl,X,qn,kr,zs,kd=`ONNX Model with a multiple choice classification head on top (a linear layer on top of the pooled output and a
softmax) e.g. for RocStories/SWAG tasks. This class officially supports albert, bert, camembert, convbert, data2vec_text, deberta_v2, distilbert, electra, flaubert, ibert, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.`,jr,Ls,jd=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Jr,qs,Jd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Rr,Ae,Bn,Ur,Bs,Rd="The <code>ORTModelForMultipleChoice</code> forward method, overrides the <code>__call__</code> special method.",Ir,It,Cr,Ct,Jl,Hn,Rl,V,Pn,Zr,Hs,Ud="ONNX Model with a QuestionAnsweringModelOutput for extractive question-answering tasks like SQuAD. This class officially supports albert, bart, bert, camembert, convbert, data2vec_text, deberta, deberta_v2, distilbert, electra, flaubert, gptj, ibert, mbart, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.",Wr,Ps,Id=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Nr,Es,Cd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Sr,me,En,Fr,Qs,Zd="The <code>ORTModelForQuestionAnswering</code> forward method, overrides the <code>__call__</code> special method.",Or,Zt,Gr,Wt,Xr,Nt,Ul,Qn,Il,Dn,Wd="The following ORT classes are available for the following computer vision tasks.",Cl,Yn,Zl,z,An,Vr,Ds,Nd="ONNX Model for image-classification tasks. This class officially supports beit, convnext, convnextv2, data2vec_vision, deit, levit, mobilenet_v1, mobilenet_v2, mobilevit, poolformer, resnet, segformer, swin, vit.",zr,Ys,Sd=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Lr,As,Fd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',qr,de,Kn,Br,Ks,Od="The <code>ORTModelForImageClassification</code> forward method, overrides the <code>__call__</code> special method.",Hr,St,Pr,Ft,Er,Ot,Wl,eo,Nl,L,to,Qr,ea,Gd="ONNX Model for semantic-segmentation, with an all-MLP decode head on top e.g. for ADE20k, CityScapes. This class officially supports segformer.",Dr,ta,Xd=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Yr,na,Vd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Ar,ce,no,Kr,oa,zd="The <code>ORTModelForSemanticSegmentation</code> forward method, overrides the <code>__call__</code> special method.",ep,Gt,tp,Xt,np,Vt,Sl,oo,Fl,so,Ld="The following ORT classes are available for the following audio tasks.",Ol,ao,Gl,q,lo,op,sa,qd=`ONNX Model for audio-classification, with a sequence classification head on top (a linear layer over the pooled output) for tasks like
SUPERB Keyword Spotting. This class officially supports audio_spectrogram_transformer, data2vec_audio, hubert, sew, sew_d, unispeech, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.`,sp,aa,Bd=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,ap,la,Hd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',lp,ue,io,ip,ia,Pd="The <code>ORTModelForAudioClassification</code> forward method, overrides the <code>__call__</code> special method.",rp,zt,pp,Lt,mp,qt,Xl,ro,Vl,B,po,dp,ra,Ed="ONNX Model with a frame classification head on top for tasks like Speaker Diarization. This class officially supports data2vec_audio, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.",cp,pa,Qd=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,up,ma,Dd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',gp,Ke,mo,fp,da,Yd="The <code>ORTModelForAudioFrameClassification</code> forward method, overrides the <code>__call__</code> special method.",hp,Bt,_p,Ht,zl,co,Ll,H,uo,bp,ca,Ad="ONNX Model with a language modeling head on top for Connectionist Temporal Classification (CTC). This class officially supports data2vec_audio, hubert, sew, sew_d, unispeech, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.",yp,ua,Kd=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Tp,ga,ec='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Mp,et,go,wp,fa,tc="The <code>ORTModelForCTC</code> forward method, overrides the <code>__call__</code> special method.",vp,Pt,xp,Et,ql,fo,Bl,P,ho,$p,ha,nc="Speech Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports whisper, speech_to_text.",kp,_a,oc=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,jp,ba,sc='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Jp,ge,_o,Rp,ya,ac="The <code>ORTModelForSpeechSeq2Seq</code> forward method, overrides the <code>__call__</code> special method.",Up,Qt,Ip,Dt,Cp,Yt,Hl,bo,Pl,E,yo,Zp,Ta,lc="ONNX Model with an XVector feature extraction head on top for tasks like Speaker Verification. This class officially supports data2vec_audio, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.",Wp,Ma,ic=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Np,wa,rc='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Sp,tt,To,Fp,va,pc="The <code>ORTModelForAudioXVector</code> forward method, overrides the <code>__call__</code> special method.",Op,At,Gp,Kt,El,Mo,Ql,wo,mc="The following ORT classes are available for the following multimodal tasks.",Dl,vo,Yl,Q,xo,Xp,xa,dc="VisionEncoderDecoder Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports trocr and vision-encoder-decoder.",Vp,$a,cc=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,zp,ka,uc='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Lp,fe,$o,qp,ja,gc="The <code>ORTModelForVision2Seq</code> forward method, overrides the <code>__call__</code> special method.",Bp,en,Hp,tn,Pp,nn,Al,ko,Kl,D,jo,Ep,Ja,fc="Pix2struct model with a language modeling head for ONNX Runtime inference. This class officially supports pix2struct.",Qp,Ra,hc=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Dp,Ua,_c='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Yp,nt,Jo,Ap,Ia,bc="The <code>ORTModelForPix2Struct</code> forward method, overrides the <code>__call__</code> special method.",Kp,on,em,sn,ei,Ro,ti,Uo,yc="The following ORT classes are available for the following custom tasks.",ni,Io,oi,Y,Co,tm,Ca,Tc="ONNX Model for any custom tasks. It can be used to leverage the inference acceleration for any single-file ONNX model, that may use custom inputs and outputs.",nm,Za,Mc=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,om,Wa,wc='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',sm,he,Zo,am,Na,vc="The <code>ORTModelForCustomTasks</code> forward method, overrides the <code>__call__</code> special method.",lm,an,im,ln,rm,rn,si,Wo,ai,A,No,pm,Sa,xc="ONNX Model for feature-extraction task.",mm,Fa,$c=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,dm,Oa,kc='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',cm,_e,So,um,Ga,jc="The <code>ORTModelForFeatureExtraction</code> forward method, overrides the <code>__call__</code> special method.",gm,pn,fm,mn,hm,dn,li,Fo,ii,Oo,ri,K,Go,_m,Xa,Jc='ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline" rel="nofollow">diffusers.StableDiffusionPipeline</a>.',bm,Va,Rc=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,ym,za,Uc='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Tm,cn,Xo,Mm,La,Ic="Function invoked when calling the pipeline for generation.",pi,Vo,mi,ee,zo,wm,qa,Cc='ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline" rel="nofollow">diffusers.StableDiffusionImg2ImgPipeline</a>.',vm,Ba,Zc=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,xm,Ha,Wc='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',$m,un,Lo,km,Pa,Nc="Function invoked when calling the pipeline for generation.",di,qo,ci,te,Bo,jm,Ea,Sc='ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline" rel="nofollow">diffusers.StableDiffusionInpaintPipeline</a>.',Jm,Qa,Fc=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Rm,Da,Oc='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Um,gn,Ho,Im,Ya,Gc="Function invoked when calling the pipeline for generation.",ui,Po,gi,ne,Eo,Cm,Aa,Xc='ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline" rel="nofollow">diffusers.StableDiffusionXLPipeline</a>.',Zm,Ka,Vc=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Wm,el,zc='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Nm,fn,Qo,Sm,tl,Lc="Function invoked when calling the pipeline for generation.",fi,Do,hi,oe,Yo,Fm,nl,qc='ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLImg2ImgPipeline" rel="nofollow">diffusers.StableDiffusionXLImg2ImgPipeline</a>.',Om,ol,Bc=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Gm,sl,Hc='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Xm,hn,Ao,Vm,al,Pc="Function invoked when calling the pipeline for generation.",_i,Ko,bi,se,es,zm,ll,Ec='ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/latent_consistency#diffusers.LatentConsistencyModelPipeline" rel="nofollow">diffusers.LatentConsistencyModelPipeline</a>.',Lm,il,Qc=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,qm,rl,Dc='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Bm,_n,ts,Hm,pl,Yc="Function invoked when calling the pipeline for generation.",yi,ml,Ti;return y=new J({props:{title:"Models",local:"models",headingTag:"h1"}}),w=new J({props:{title:"Generic model classes",local:"generic-model-classes",headingTag:"h2"}}),yn=new J({props:{title:"ORTModel",local:"optimum.onnxruntime.ORTModel",headingTag:"h3"}}),Tn=new k({props:{name:"class optimum.onnxruntime.ORTModel",anchor:"optimum.onnxruntime.ORTModel",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L138"}}),Mn=new k({props:{name:"from_pretrained",anchor:"optimum.onnxruntime.ORTModel.from_pretrained",parameters:[{name:"model_id",val:": typing.Union[str, pathlib.Path]"},{name:"export",val:": bool = False"},{name:"force_download",val:": bool = False"},{name:"use_auth_token",val:": typing.Optional[str] = None"},{name:"cache_dir",val:": typing.Optional[str] = None"},{name:"subfolder",val:": str = ''"},{name:"config",val:": typing.Optional[ForwardRef('PretrainedConfig')] = None"},{name:"local_files_only",val:": bool = False"},{name:"provider",val:": str = 'CPUExecutionProvider'"},{name:"session_options",val:": typing.Optional[onnxruntime.capi.onnxruntime_pybind11_state.SessionOptions] = None"},{name:"provider_options",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.model_id",description:`<strong>model_id</strong> (<code>Union[str, Path]</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>A path to a <em>directory</em> containing a model saved using <code>~OptimizedModel.save_pretrained</code>,
e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"model_id"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.from_transformers",description:`<strong>from_transformers</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Defines whether the provided <code>model_id</code> contains a vanilla Transformers checkpoint.`,name:"from_transformers"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_auth_token",description:`<strong>use_auth_token</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>transformers-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"use_auth_token"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo either locally or on huggingface.co, you can
specify the folder name here.`,name:"subfolder"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.config",description:`<strong>config</strong> (<code>Optional[transformers.PretrainedConfig]</code>, defaults to <code>None</code>) &#x2014;
The model configuration.`,name:"config"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>Optional[bool]</code>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (i.e., do not try to download the model).`,name:"local_files_only"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom code defined on the Hub in their own modeling. This option should only be set
to <code>True</code> for repositories you trust and in which you have read the code, as it will execute code present on
the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.provider",description:`<strong>provider</strong> (<code>str</code>, defaults to <code>&quot;CPUExecutionProvider&quot;</code>) &#x2014;
ONNX Runtime provider to use for loading the model. See <a href="https://onnxruntime.ai/docs/execution-providers/" rel="nofollow">https://onnxruntime.ai/docs/execution-providers/</a> for
possible providers.`,name:"provider"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.session_options",description:`<strong>session_options</strong> (<code>Optional[onnxruntime.SessionOptions]</code>, defaults to <code>None</code>), &#x2014;
ONNX Runtime session options to use for loading the model.`,name:"session_options"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.provider_options",description:`<strong>provider_options</strong> (<code>Optional[Dict[str, Any]]</code>, defaults to <code>None</code>) &#x2014;
Provider option dictionaries corresponding to the provider used. See available options
for each provider: <a href="https://onnxruntime.ai/docs/api/c/group___global.html" rel="nofollow">https://onnxruntime.ai/docs/api/c/group___global.html</a> .`,name:"provider_options"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_io_binding",description:`<strong>use_io_binding</strong> (<code>Optional[bool]</code>, defaults to <code>None</code>) &#x2014;
Whether to use IOBinding during inference to avoid memory copy between the host and device, or between numpy/torch tensors and ONNX Runtime ORTValue. Defaults to
<code>True</code> if the execution provider is CUDAExecutionProvider. For [~onnxruntime.ORTModelForCausalLM], defaults to <code>True</code> on CPUExecutionProvider,
in all other cases defaults to <code>False</code>.`,name:"use_io_binding"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Will be passed to the underlying model loading methods.`,name:"kwargs"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L613",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The loaded ORTModel model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ORTModel</code></p>
`,parameterGroups:[{title:"Parameters for decoder models (ORTModelForCausalLM, ORTModelForSeq2SeqLM, ORTModelForSeq2SeqLM, ORTModelForSpeechSeq2Seq, ORTModelForVision2Seq)",parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_cache",description:`<strong>use_cache</strong> (<code>Optional[bool]</code>, defaults to <code>True</code>) &#x2014;
Whether or not past key/values cache should be used. Defaults to <code>True</code>.`,name:"use_cache"}]},{title:"Parameters for ORTModelForCausalLM",parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_merged",description:`<strong>use_merged</strong> (<code>Optional[bool]</code>, defaults to <code>None</code>) &#x2014;
whether or not to use a single ONNX that handles both the decoding without and with past key values reuse. This option defaults
to <code>True</code> if loading from a local repository and a merged decoder is found. When exporting with <code>export=True</code>,
defaults to <code>False</code>. This option should be set to <code>True</code> to minimize memory usage.`,name:"use_merged"}]}]}}),wn=new k({props:{name:"load_model",anchor:"optimum.onnxruntime.ORTModel.load_model",parameters:[{name:"path",val:": typing.Union[str, pathlib.Path]"},{name:"provider",val:": str = 'CPUExecutionProvider'"},{name:"session_options",val:": typing.Optional[onnxruntime.capi.onnxruntime_pybind11_state.SessionOptions] = None"},{name:"provider_options",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.load_model.path",description:`<strong>path</strong> (<code>Union[str, Path]</code>) &#x2014;
Path of the ONNX model.`,name:"path"},{anchor:"optimum.onnxruntime.ORTModel.load_model.provider",description:`<strong>provider</strong> (<code>str</code>, defaults to <code>&quot;CPUExecutionProvider&quot;</code>) &#x2014;
ONNX Runtime provider to use for loading the model. See <a href="https://onnxruntime.ai/docs/execution-providers/" rel="nofollow">https://onnxruntime.ai/docs/execution-providers/</a>
for possible providers.`,name:"provider"},{anchor:"optimum.onnxruntime.ORTModel.load_model.session_options",description:`<strong>session_options</strong> (<code>Optional[onnxruntime.SessionOptions]</code>, defaults to <code>None</code>) &#x2014;
ONNX Runtime session options to use for loading the model.`,name:"session_options"},{anchor:"optimum.onnxruntime.ORTModel.load_model.provider_options",description:`<strong>provider_options</strong> (<code>Optional[Dict[str, Any]]</code>, defaults to <code>None</code>) &#x2014;
Provider option dictionary corresponding to the provider used. See available options
for each provider: <a href="https://onnxruntime.ai/docs/api/c/group___global.html" rel="nofollow">https://onnxruntime.ai/docs/api/c/group___global.html</a> .`,name:"provider_options"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L334"}}),vn=new k({props:{name:"raise_on_numpy_input_io_binding",anchor:"optimum.onnxruntime.ORTModel.raise_on_numpy_input_io_binding",parameters:[{name:"use_torch",val:": bool"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.raise_on_numpy_input_io_binding.use_torch",description:`<strong>use_torch</strong> (<code>bool</code>) &#x2014;
Whether the tensor used during inference are of type torch.Tensor or not.`,name:"use_torch"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L834"}}),xn=new k({props:{name:"shared_attributes_init",anchor:"optimum.onnxruntime.ORTModel.shared_attributes_init",parameters:[{name:"model",val:": InferenceSession"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L181"}}),$n=new k({props:{name:"to",anchor:"optimum.onnxruntime.ORTModel.to",parameters:[{name:"device",val:": typing.Union[torch.device, str, int]"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.to.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code> or <code>int</code>) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run
the model on the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too.`,name:"device"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L294",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the model placed on the requested device.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ORTModel</code></p>
`}}),kn=new J({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h2"}}),Jn=new J({props:{title:"ORTModelForCausalLM",local:"optimum.onnxruntime.ORTModelForCausalLM",headingTag:"h3"}}),Rn=new k({props:{name:"class optimum.onnxruntime.ORTModelForCausalLM",anchor:"optimum.onnxruntime.ORTModelForCausalLM",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_decoder.py#L115"}}),Un=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache_branch",val:": bool = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, sequence_length)</code>.`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>) &#x2014;
Mask to avoid performing attention on padding token indices, of shape
<code>(batch_size, sequence_length)</code>. Mask values selected in <code>[0, 1]</code>.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_decoder.py#L182"}}),ft=new Z({props:{$$slots:{default:[ou]},$$scope:{ctx:v}}}),ht=new R({props:{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.example",$$slots:{default:[su]},$$scope:{ctx:v}}}),_t=new R({props:{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.example-2",$$slots:{default:[au]},$$scope:{ctx:v}}}),In=new J({props:{title:"ORTModelForMaskedLM",local:"optimum.onnxruntime.ORTModelForMaskedLM",headingTag:"h3"}}),Cn=new k({props:{name:"class optimum.onnxruntime.ORTModelForMaskedLM",anchor:"optimum.onnxruntime.ORTModelForMaskedLM",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1096"}}),Zn=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1103"}}),bt=new Z({props:{$$slots:{default:[lu]},$$scope:{ctx:v}}}),yt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.example",$$slots:{default:[iu]},$$scope:{ctx:v}}}),Tt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.example-2",$$slots:{default:[ru]},$$scope:{ctx:v}}}),Wn=new J({props:{title:"ORTModelForSeq2SeqLM",local:"optimum.onnxruntime.ORTModelForSeq2SeqLM",headingTag:"h3"}}),Nn=new k({props:{name:"class optimum.onnxruntime.ORTModelForSeq2SeqLM",anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM",parameters:[{name:"encoder_session",val:": InferenceSession"},{name:"decoder_session",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"onnx_paths",val:": typing.List[str]"},{name:"decoder_with_past_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"use_cache",val:": bool = True"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_seq2seq.py#L1122"}}),Sn=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of input sequence tokens in the vocabulary of shape <code>(batch_size, encoder_sequence_length)</code>.`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>) &#x2014;
Mask to avoid performing attention on padding token indices, of shape
<code>(batch_size, encoder_sequence_length)</code>. Mask values selected in <code>[0, 1]</code>.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_seq2seq.py#L1176"}}),Mt=new Z({props:{$$slots:{default:[pu]},$$scope:{ctx:v}}}),wt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.example",$$slots:{default:[mu]},$$scope:{ctx:v}}}),vt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.example-2",$$slots:{default:[du]},$$scope:{ctx:v}}}),Fn=new J({props:{title:"ORTModelForSequenceClassification",local:"optimum.onnxruntime.ORTModelForSequenceClassification",headingTag:"h3"}}),On=new k({props:{name:"class optimum.onnxruntime.ORTModelForSequenceClassification",anchor:"optimum.onnxruntime.ORTModelForSequenceClassification",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1321"}}),Gn=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1329"}}),xt=new Z({props:{$$slots:{default:[cu]},$$scope:{ctx:v}}}),$t=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example",$$slots:{default:[uu]},$$scope:{ctx:v}}}),kt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example-2",$$slots:{default:[gu]},$$scope:{ctx:v}}}),jt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example-3",$$slots:{default:[fu]},$$scope:{ctx:v}}}),Xn=new J({props:{title:"ORTModelForTokenClassification",local:"optimum.onnxruntime.ORTModelForTokenClassification",headingTag:"h3"}}),Vn=new k({props:{name:"class optimum.onnxruntime.ORTModelForTokenClassification",anchor:"optimum.onnxruntime.ORTModelForTokenClassification",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1422"}}),zn=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1431"}}),Jt=new Z({props:{$$slots:{default:[hu]},$$scope:{ctx:v}}}),Rt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.example",$$slots:{default:[_u]},$$scope:{ctx:v}}}),Ut=new R({props:{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.example-2",$$slots:{default:[bu]},$$scope:{ctx:v}}}),Ln=new J({props:{title:"ORTModelForMultipleChoice",local:"optimum.onnxruntime.ORTModelForMultipleChoice",headingTag:"h3"}}),qn=new k({props:{name:"class optimum.onnxruntime.ORTModelForMultipleChoice",anchor:"optimum.onnxruntime.ORTModelForMultipleChoice",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1521"}}),Bn=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1529"}}),It=new Z({props:{$$slots:{default:[yu]},$$scope:{ctx:v}}}),Ct=new R({props:{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.example",$$slots:{default:[Tu]},$$scope:{ctx:v}}}),Hn=new J({props:{title:"ORTModelForQuestionAnswering",local:"optimum.onnxruntime.ORTModelForQuestionAnswering",headingTag:"h3"}}),Pn=new k({props:{name:"class optimum.onnxruntime.ORTModelForQuestionAnswering",anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1199"}}),En=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1206"}}),Zt=new Z({props:{$$slots:{default:[Mu]},$$scope:{ctx:v}}}),Wt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.example",$$slots:{default:[wu]},$$scope:{ctx:v}}}),Nt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.example-2",$$slots:{default:[vu]},$$scope:{ctx:v}}}),Qn=new J({props:{title:"Computer vision",local:"computer-vision",headingTag:"h2"}}),Yn=new J({props:{title:"ORTModelForImageClassification",local:"optimum.onnxruntime.ORTModelForImageClassification",headingTag:"h3"}}),An=new k({props:{name:"class optimum.onnxruntime.ORTModelForImageClassification",anchor:"optimum.onnxruntime.ORTModelForImageClassification",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1627"}}),Kn=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward",parameters:[{name:"pixel_values",val:": typing.Union[torch.Tensor, numpy.ndarray]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1634"}}),St=new Z({props:{$$slots:{default:[xu]},$$scope:{ctx:v}}}),Ft=new R({props:{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.example",$$slots:{default:[$u]},$$scope:{ctx:v}}}),Ot=new R({props:{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.example-2",$$slots:{default:[ku]},$$scope:{ctx:v}}}),eo=new J({props:{title:"ORTModelForSemanticSegmentation",local:"optimum.onnxruntime.ORTModelForSemanticSegmentation",headingTag:"h3"}}),to=new k({props:{name:"class optimum.onnxruntime.ORTModelForSemanticSegmentation",anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1721"}}),no=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1728"}}),Gt=new Z({props:{$$slots:{default:[ju]},$$scope:{ctx:v}}}),Xt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.example",$$slots:{default:[Ju]},$$scope:{ctx:v}}}),Vt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.example-2",$$slots:{default:[Ru]},$$scope:{ctx:v}}}),oo=new J({props:{title:"Audio",local:"audio",headingTag:"h2"}}),ao=new J({props:{title:"ORTModelForAudioClassification",local:"optimum.onnxruntime.ORTModelForAudioClassification",headingTag:"h3"}}),lo=new k({props:{name:"class optimum.onnxruntime.ORTModelForAudioClassification",anchor:"optimum.onnxruntime.ORTModelForAudioClassification",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1827"}}),io=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.Tensor] = None"},{name:"attenton_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1835"}}),zt=new Z({props:{$$slots:{default:[Uu]},$$scope:{ctx:v}}}),Lt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.example",$$slots:{default:[Iu]},$$scope:{ctx:v}}}),qt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.example-2",$$slots:{default:[Cu]},$$scope:{ctx:v}}}),ro=new J({props:{title:"ORTModelForAudioFrameClassification",local:"optimum.onnxruntime.ORTModelForAudioFrameClassification",headingTag:"h3"}}),po=new k({props:{name:"class optimum.onnxruntime.ORTModelForAudioFrameClassification",anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L2108"}}),mo=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L2115"}}),Bt=new Z({props:{$$slots:{default:[Zu]},$$scope:{ctx:v}}}),Ht=new R({props:{anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward.example",$$slots:{default:[Wu]},$$scope:{ctx:v}}}),co=new J({props:{title:"ORTModelForCTC",local:"optimum.onnxruntime.ORTModelForCTC",headingTag:"h3"}}),uo=new k({props:{name:"class optimum.onnxruntime.ORTModelForCTC",anchor:"optimum.onnxruntime.ORTModelForCTC",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1913"}}),go=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCTC.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForCTC.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1920"}}),Pt=new Z({props:{$$slots:{default:[Nu]},$$scope:{ctx:v}}}),Et=new R({props:{anchor:"optimum.onnxruntime.ORTModelForCTC.forward.example",$$slots:{default:[Su]},$$scope:{ctx:v}}}),fo=new J({props:{title:"ORTModelForSpeechSeq2Seq",local:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq",headingTag:"h3"}}),ho=new k({props:{name:"class optimum.onnxruntime.ORTModelForSpeechSeq2Seq",anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq",parameters:[{name:"encoder_session",val:": InferenceSession"},{name:"decoder_session",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"onnx_paths",val:": typing.List[str]"},{name:"decoder_with_past_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"use_cache",val:": bool = True"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_seq2seq.py#L1271"}}),_o=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward",parameters:[{name:"input_features",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.input_features",description:`<strong>input_features</strong> (<code>torch.FloatTensor</code>) &#x2014;
Mel features extracted from the raw speech waveform.
<code>(batch_size, feature_size, encoder_sequence_length)</code>.`,name:"input_features"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_seq2seq.py#L1313"}}),Qt=new Z({props:{$$slots:{default:[Fu]},$$scope:{ctx:v}}}),Dt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.example",$$slots:{default:[Ou]},$$scope:{ctx:v}}}),Yt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.example-2",$$slots:{default:[Gu]},$$scope:{ctx:v}}}),bo=new J({props:{title:"ORTModelForAudioXVector",local:"optimum.onnxruntime.ORTModelForAudioXVector",headingTag:"h3"}}),yo=new k({props:{name:"class optimum.onnxruntime.ORTModelForAudioXVector",anchor:"optimum.onnxruntime.ORTModelForAudioXVector",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L2019"}}),To=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L2026"}}),At=new Z({props:{$$slots:{default:[Xu]},$$scope:{ctx:v}}}),Kt=new R({props:{anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward.example",$$slots:{default:[Vu]},$$scope:{ctx:v}}}),Mo=new J({props:{title:"Multimodal",local:"multimodal",headingTag:"h2"}}),vo=new J({props:{title:"ORTModelForVision2Seq",local:"optimum.onnxruntime.ORTModelForVision2Seq",headingTag:"h3"}}),xo=new k({props:{name:"class optimum.onnxruntime.ORTModelForVision2Seq",anchor:"optimum.onnxruntime.ORTModelForVision2Seq",parameters:[{name:"encoder_session",val:": InferenceSession"},{name:"decoder_session",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"onnx_paths",val:": typing.List[str]"},{name:"decoder_with_past_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"use_cache",val:": bool = True"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_seq2seq.py#L1846"}}),$o=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Features extracted from an Image. This tensor should be of shape
<code>(batch_size, num_channels, height, width)</code>.`,name:"pixel_values"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_seq2seq.py#L1904"}}),en=new Z({props:{$$slots:{default:[zu]},$$scope:{ctx:v}}}),tn=new R({props:{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.example",$$slots:{default:[Lu]},$$scope:{ctx:v}}}),nn=new R({props:{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.example-2",$$slots:{default:[qu]},$$scope:{ctx:v}}}),ko=new J({props:{title:"ORTModelForPix2Struct",local:"optimum.onnxruntime.ORTModelForPix2Struct",headingTag:"h3"}}),jo=new k({props:{name:"class optimum.onnxruntime.ORTModelForPix2Struct",anchor:"optimum.onnxruntime.ORTModelForPix2Struct",parameters:[{name:"encoder_session",val:": InferenceSession"},{name:"decoder_session",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"onnx_paths",val:": typing.List[str]"},{name:"decoder_with_past_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"use_cache",val:": bool = True"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_seq2seq.py#L1995"}}),Jo=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward",parameters:[{name:"flattened_patches",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.flattened_patches",description:`<strong>flattened_patches</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, seq_length, hidden_size)</code>) &#x2014;
Flattened pixel patches. the <code>hidden_size</code> is obtained by the following formula: <code>hidden_size</code> =
<code>num_channels</code> <em> <code>patch_size</code> </em> <code>patch_size</code>
The process of flattening the pixel patches is done by <code>Pix2StructProcessor</code>.`,name:"flattened_patches"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.
Pix2StructText uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If
<code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_seq2seq.py#L2007"}}),on=new Z({props:{$$slots:{default:[Bu]},$$scope:{ctx:v}}}),sn=new R({props:{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.example",$$slots:{default:[Hu]},$$scope:{ctx:v}}}),Ro=new J({props:{title:"Custom Tasks",local:"custom-tasks",headingTag:"h2"}}),Io=new J({props:{title:"ORTModelForCustomTasks",local:"optimum.onnxruntime.ORTModelForCustomTasks",headingTag:"h4"}}),Co=new k({props:{name:"class optimum.onnxruntime.ORTModelForCustomTasks",anchor:"optimum.onnxruntime.ORTModelForCustomTasks",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L2188"}}),Zo=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L2193"}}),an=new Z({props:{$$slots:{default:[Pu]},$$scope:{ctx:v}}}),ln=new R({props:{anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward.example",$$slots:{default:[Eu]},$$scope:{ctx:v}}}),rn=new R({props:{anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward.example-2",$$slots:{default:[Qu]},$$scope:{ctx:v}}}),Wo=new J({props:{title:"ORTModelForFeatureExtraction",local:"optimum.onnxruntime.ORTModelForFeatureExtraction",headingTag:"h4"}}),No=new k({props:{name:"class optimum.onnxruntime.ORTModelForFeatureExtraction",anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L934"}}),So=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L941"}}),pn=new Z({props:{$$slots:{default:[Du]},$$scope:{ctx:v}}}),mn=new R({props:{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.example",$$slots:{default:[Yu]},$$scope:{ctx:v}}}),dn=new R({props:{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.example-2",$$slots:{default:[Au]},$$scope:{ctx:v}}}),Fo=new J({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),Oo=new J({props:{title:"ORTStableDiffusionPipeline",local:"optimum.onnxruntime.ORTStableDiffusionPipeline",headingTag:"h4"}}),Go=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline",parameters:[{name:"vae_decoder_session",val:": InferenceSession"},{name:"text_encoder_session",val:": InferenceSession"},{name:"unet_session",val:": InferenceSession"},{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_pndm.PNDMScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler]"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"vae_encoder_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"text_encoder_2_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_diffusion.py#L542"}}),Xo=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[numpy.random.mtrand.RandomState] = None"},{name:"latents",val:": typing.Optional[numpy.ndarray] = None"},{name:"prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, numpy.ndarray], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"guidance_rescale",val:": float = 0.0"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to None) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.height",description:`<strong>height</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.width",description:`<strong>width</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>Optional[Union[str, list]]</code>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code>. instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code>
is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[np.random.RandomState]</code>, defaults to <code>None</code>) &#x2014;:
A np.random.RandomState to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.latents",description:`<strong>latents</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.callback",description:`<strong>callback</strong> (Optional[Callable], defaults to <code>None</code>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/pipelines/diffusers/pipeline_stable_diffusion.py#L202",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),Vo=new J({props:{title:"ORTStableDiffusionImg2ImgPipeline",local:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline",headingTag:"h4"}}),zo=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline",parameters:[{name:"vae_decoder_session",val:": InferenceSession"},{name:"text_encoder_session",val:": InferenceSession"},{name:"unet_session",val:": InferenceSession"},{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_pndm.PNDMScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler]"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"vae_encoder_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"text_encoder_2_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_diffusion.py#L551"}}),Lo=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[numpy.ndarray, PIL.Image.Image] = None"},{name:"strength",val:": float = 0.8"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[numpy.random.mtrand.RandomState] = None"},{name:"prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, numpy.ndarray], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to None) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>Union[np.ndarray, PIL.Image.Image]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch which will be upscaled.`,name:"image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, defaults to 0.8) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>Optional[Union[str, list]]</code>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code>. instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code>
is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[np.random.RandomState]</code>, defaults to <code>None</code>) &#x2014;:
A np.random.RandomState to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.callback",description:`<strong>callback</strong> (Optional[Callable], defaults to <code>None</code>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/pipelines/diffusers/pipeline_stable_diffusion_img2img.py#L76",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),qo=new J({props:{title:"ORTStableDiffusionInpaintPipeline",local:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline",headingTag:"h4"}}),Bo=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionInpaintPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline",parameters:[{name:"vae_decoder_session",val:": InferenceSession"},{name:"text_encoder_session",val:": InferenceSession"},{name:"unet_session",val:": InferenceSession"},{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_pndm.PNDMScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler]"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"vae_encoder_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"text_encoder_2_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_diffusion.py#L560"}}),Ho=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"image",val:": Image"},{name:"mask_image",val:": Image"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[numpy.random.mtrand.RandomState] = None"},{name:"latents",val:": typing.Optional[numpy.ndarray] = None"},{name:"prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, numpy.ndarray], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Union[str, List[str]]</code>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch which will be upscaled.`,name:"image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing a masked image batch which will be upscaled.`,name:"mask_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>Optional[Union[str, list]]</code>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code>. instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code>
is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[np.random.RandomState]</code>, defaults to <code>None</code>) &#x2014;:
A np.random.RandomState to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.callback",description:`<strong>callback</strong> (Optional[Callable], defaults to <code>None</code>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/pipelines/diffusers/pipeline_stable_diffusion_inpaint.py#L98",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),Po=new J({props:{title:"ORTStableDiffusionXLPipeline",local:"optimum.onnxruntime.ORTStableDiffusionXLPipeline",headingTag:"h4"}}),Eo=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionXLPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline",parameters:[{name:"vae_decoder_session",val:": InferenceSession"},{name:"text_encoder_session",val:": InferenceSession"},{name:"unet_session",val:": InferenceSession"},{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_pndm.PNDMScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler]"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"vae_encoder_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"text_encoder_2_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"add_watermarker",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_diffusion.py#L627"}}),Qo=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[numpy.random.mtrand.RandomState] = None"},{name:"latents",val:": typing.Optional[numpy.ndarray] = None"},{name:"prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, numpy.ndarray], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": typing.Union[typing.Tuple[int, int], NoneType] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Union[typing.Tuple[int, int], NoneType] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to None) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.height",description:`<strong>height</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.width",description:`<strong>width</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>Optional[Union[str, list]]</code>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code>. instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code>
is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[np.random.RandomState]</code>, defaults to <code>None</code>) &#x2014;:
A np.random.RandomState to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.latents",description:`<strong>latents</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.callback",description:`<strong>callback</strong> (Optional[Callable], defaults to <code>None</code>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, defaults to 0.7) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/pipelines/diffusers/pipeline_stable_diffusion_xl.py#L263",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),Do=new J({props:{title:"ORTStableDiffusionXLImg2ImgPipeline",local:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline",headingTag:"h4"}}),Yo=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline",parameters:[{name:"vae_decoder_session",val:": InferenceSession"},{name:"text_encoder_session",val:": InferenceSession"},{name:"unet_session",val:": InferenceSession"},{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_pndm.PNDMScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler]"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"vae_encoder_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"text_encoder_2_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"add_watermarker",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_diffusion.py#L636"}}),Ao=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[numpy.ndarray, PIL.Image.Image] = None"},{name:"strength",val:": float = 0.3"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[numpy.random.mtrand.RandomState] = None"},{name:"latents",val:": typing.Optional[numpy.ndarray] = None"},{name:"prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, numpy.ndarray], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": typing.Union[typing.Tuple[int, int], NoneType] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Union[typing.Tuple[int, int], NoneType] = None"},{name:"aesthetic_score",val:": float = 6.0"},{name:"negative_aesthetic_score",val:": float = 2.5"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to None) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>Union[np.ndarray, PIL.Image.Image]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch which will be upscaled.`,name:"image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, defaults to 0.8) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>Optional[Union[str, list]]</code>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code>. instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code>
is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[np.random.RandomState]</code>, defaults to <code>None</code>) &#x2014;:
A np.random.RandomState to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.callback",description:`<strong>callback</strong> (Optional[Callable], defaults to <code>None</code>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, defaults to 0.7) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/pipelines/diffusers/pipeline_stable_diffusion_xl_img2img.py#L267",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),Ko=new J({props:{title:"ORTLatentConsistencyModelPipeline",local:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline",headingTag:"h4"}}),es=new k({props:{name:"class optimum.onnxruntime.ORTLatentConsistencyModelPipeline",anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline",parameters:[{name:"vae_decoder_session",val:": InferenceSession"},{name:"text_encoder_session",val:": InferenceSession"},{name:"unet_session",val:": InferenceSession"},{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_pndm.PNDMScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler]"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"vae_encoder_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"text_encoder_2_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_diffusion.py#L569"}}),ts=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 4"},{name:"original_inference_steps",val:": int = None"},{name:"guidance_scale",val:": float = 8.5"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": typing.Optional[numpy.random.mtrand.RandomState] = None"},{name:"latents",val:": typing.Optional[numpy.ndarray] = None"},{name:"prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, numpy.ndarray], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to None) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.height",description:`<strong>height</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.width",description:`<strong>width</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[np.random.RandomState]</code>, defaults to <code>None</code>) &#x2014;:
A np.random.RandomState to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.latents",description:`<strong>latents</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.callback",description:`<strong>callback</strong> (Optional[Callable], defaults to <code>None</code>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"optimum.onnxruntime.ORTLatentConsistencyModelPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/pipelines/diffusers/pipeline_latent_consistency.py#L30",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),{c(){n=m("meta"),M=a(),i=m("p"),s=a(),u(y.$$.fragment),t=a(),u(w.$$.fragment),dl=a(),bn=m("p"),bn.textContent=Pm,cl=a(),u(yn.$$.fragment),ul=a(),I=m("div"),u(Tn.$$.fragment),vi=a(),ds=m("p"),ds.textContent=Em,xi=a(),cs=m("p"),cs.innerHTML=Qm,$i=a(),us=m("p"),us.textContent=Dm,ki=a(),gs=m("ul"),gs.innerHTML=Ym,ji=a(),fs=m("p"),fs.textContent=Am,Ji=a(),hs=m("ul"),hs.innerHTML=Km,Ri=a(),mt=m("div"),u(Mn.$$.fragment),Ui=a(),_s=m("p"),_s.textContent=ed,Ii=a(),dt=m("div"),u(wn.$$.fragment),Ci=a(),bs=m("p"),bs.innerHTML=td,Zi=a(),ct=m("div"),u(vn.$$.fragment),Wi=a(),ys=m("p"),ys.textContent=nd,Ni=a(),ut=m("div"),u(xn.$$.fragment),Si=a(),Ts=m("p"),Ts.textContent=od,Fi=a(),gt=m("div"),u($n.$$.fragment),Oi=a(),Ms=m("p"),Ms.textContent=sd,gl=a(),u(kn.$$.fragment),fl=a(),jn=m("p"),jn.textContent=ad,hl=a(),u(Jn.$$.fragment),_l=a(),N=m("div"),u(Rn.$$.fragment),Gi=a(),ws=m("p"),ws.textContent=ld,Xi=a(),vs=m("p"),vs.innerHTML=id,Vi=a(),xs=m("p"),xs.innerHTML=rd,zi=a(),le=m("div"),u(Un.$$.fragment),Li=a(),$s=m("p"),$s.innerHTML=pd,qi=a(),u(ft.$$.fragment),Bi=a(),u(ht.$$.fragment),Hi=a(),u(_t.$$.fragment),bl=a(),u(In.$$.fragment),yl=a(),S=m("div"),u(Cn.$$.fragment),Pi=a(),ks=m("p"),ks.textContent=md,Ei=a(),js=m("p"),js.innerHTML=dd,Qi=a(),Js=m("p"),Js.innerHTML=cd,Di=a(),ie=m("div"),u(Zn.$$.fragment),Yi=a(),Rs=m("p"),Rs.innerHTML=ud,Ai=a(),u(bt.$$.fragment),Ki=a(),u(yt.$$.fragment),er=a(),u(Tt.$$.fragment),Tl=a(),u(Wn.$$.fragment),Ml=a(),F=m("div"),u(Nn.$$.fragment),tr=a(),Us=m("p"),Us.textContent=gd,nr=a(),Is=m("p"),Is.innerHTML=fd,or=a(),Cs=m("p"),Cs.innerHTML=hd,sr=a(),re=m("div"),u(Sn.$$.fragment),ar=a(),Zs=m("p"),Zs.innerHTML=_d,lr=a(),u(Mt.$$.fragment),ir=a(),u(wt.$$.fragment),rr=a(),u(vt.$$.fragment),wl=a(),u(Fn.$$.fragment),vl=a(),O=m("div"),u(On.$$.fragment),pr=a(),Ws=m("p"),Ws.textContent=bd,mr=a(),Ns=m("p"),Ns.innerHTML=yd,dr=a(),Ss=m("p"),Ss.innerHTML=Td,cr=a(),W=m("div"),u(Gn.$$.fragment),ur=a(),Fs=m("p"),Fs.innerHTML=Md,gr=a(),u(xt.$$.fragment),fr=a(),u($t.$$.fragment),hr=a(),u(kt.$$.fragment),_r=a(),u(jt.$$.fragment),xl=a(),u(Xn.$$.fragment),$l=a(),G=m("div"),u(Vn.$$.fragment),br=a(),Os=m("p"),Os.textContent=wd,yr=a(),Gs=m("p"),Gs.innerHTML=vd,Tr=a(),Xs=m("p"),Xs.innerHTML=xd,Mr=a(),pe=m("div"),u(zn.$$.fragment),wr=a(),Vs=m("p"),Vs.innerHTML=$d,vr=a(),u(Jt.$$.fragment),xr=a(),u(Rt.$$.fragment),$r=a(),u(Ut.$$.fragment),kl=a(),u(Ln.$$.fragment),jl=a(),X=m("div"),u(qn.$$.fragment),kr=a(),zs=m("p"),zs.textContent=kd,jr=a(),Ls=m("p"),Ls.innerHTML=jd,Jr=a(),qs=m("p"),qs.innerHTML=Jd,Rr=a(),Ae=m("div"),u(Bn.$$.fragment),Ur=a(),Bs=m("p"),Bs.innerHTML=Rd,Ir=a(),u(It.$$.fragment),Cr=a(),u(Ct.$$.fragment),Jl=a(),u(Hn.$$.fragment),Rl=a(),V=m("div"),u(Pn.$$.fragment),Zr=a(),Hs=m("p"),Hs.textContent=Ud,Wr=a(),Ps=m("p"),Ps.innerHTML=Id,Nr=a(),Es=m("p"),Es.innerHTML=Cd,Sr=a(),me=m("div"),u(En.$$.fragment),Fr=a(),Qs=m("p"),Qs.innerHTML=Zd,Or=a(),u(Zt.$$.fragment),Gr=a(),u(Wt.$$.fragment),Xr=a(),u(Nt.$$.fragment),Ul=a(),u(Qn.$$.fragment),Il=a(),Dn=m("p"),Dn.textContent=Wd,Cl=a(),u(Yn.$$.fragment),Zl=a(),z=m("div"),u(An.$$.fragment),Vr=a(),Ds=m("p"),Ds.textContent=Nd,zr=a(),Ys=m("p"),Ys.innerHTML=Sd,Lr=a(),As=m("p"),As.innerHTML=Fd,qr=a(),de=m("div"),u(Kn.$$.fragment),Br=a(),Ks=m("p"),Ks.innerHTML=Od,Hr=a(),u(St.$$.fragment),Pr=a(),u(Ft.$$.fragment),Er=a(),u(Ot.$$.fragment),Wl=a(),u(eo.$$.fragment),Nl=a(),L=m("div"),u(to.$$.fragment),Qr=a(),ea=m("p"),ea.textContent=Gd,Dr=a(),ta=m("p"),ta.innerHTML=Xd,Yr=a(),na=m("p"),na.innerHTML=Vd,Ar=a(),ce=m("div"),u(no.$$.fragment),Kr=a(),oa=m("p"),oa.innerHTML=zd,ep=a(),u(Gt.$$.fragment),tp=a(),u(Xt.$$.fragment),np=a(),u(Vt.$$.fragment),Sl=a(),u(oo.$$.fragment),Fl=a(),so=m("p"),so.textContent=Ld,Ol=a(),u(ao.$$.fragment),Gl=a(),q=m("div"),u(lo.$$.fragment),op=a(),sa=m("p"),sa.textContent=qd,sp=a(),aa=m("p"),aa.innerHTML=Bd,ap=a(),la=m("p"),la.innerHTML=Hd,lp=a(),ue=m("div"),u(io.$$.fragment),ip=a(),ia=m("p"),ia.innerHTML=Pd,rp=a(),u(zt.$$.fragment),pp=a(),u(Lt.$$.fragment),mp=a(),u(qt.$$.fragment),Xl=a(),u(ro.$$.fragment),Vl=a(),B=m("div"),u(po.$$.fragment),dp=a(),ra=m("p"),ra.textContent=Ed,cp=a(),pa=m("p"),pa.innerHTML=Qd,up=a(),ma=m("p"),ma.innerHTML=Dd,gp=a(),Ke=m("div"),u(mo.$$.fragment),fp=a(),da=m("p"),da.innerHTML=Yd,hp=a(),u(Bt.$$.fragment),_p=a(),u(Ht.$$.fragment),zl=a(),u(co.$$.fragment),Ll=a(),H=m("div"),u(uo.$$.fragment),bp=a(),ca=m("p"),ca.textContent=Ad,yp=a(),ua=m("p"),ua.innerHTML=Kd,Tp=a(),ga=m("p"),ga.innerHTML=ec,Mp=a(),et=m("div"),u(go.$$.fragment),wp=a(),fa=m("p"),fa.innerHTML=tc,vp=a(),u(Pt.$$.fragment),xp=a(),u(Et.$$.fragment),ql=a(),u(fo.$$.fragment),Bl=a(),P=m("div"),u(ho.$$.fragment),$p=a(),ha=m("p"),ha.textContent=nc,kp=a(),_a=m("p"),_a.innerHTML=oc,jp=a(),ba=m("p"),ba.innerHTML=sc,Jp=a(),ge=m("div"),u(_o.$$.fragment),Rp=a(),ya=m("p"),ya.innerHTML=ac,Up=a(),u(Qt.$$.fragment),Ip=a(),u(Dt.$$.fragment),Cp=a(),u(Yt.$$.fragment),Hl=a(),u(bo.$$.fragment),Pl=a(),E=m("div"),u(yo.$$.fragment),Zp=a(),Ta=m("p"),Ta.textContent=lc,Wp=a(),Ma=m("p"),Ma.innerHTML=ic,Np=a(),wa=m("p"),wa.innerHTML=rc,Sp=a(),tt=m("div"),u(To.$$.fragment),Fp=a(),va=m("p"),va.innerHTML=pc,Op=a(),u(At.$$.fragment),Gp=a(),u(Kt.$$.fragment),El=a(),u(Mo.$$.fragment),Ql=a(),wo=m("p"),wo.textContent=mc,Dl=a(),u(vo.$$.fragment),Yl=a(),Q=m("div"),u(xo.$$.fragment),Xp=a(),xa=m("p"),xa.textContent=dc,Vp=a(),$a=m("p"),$a.innerHTML=cc,zp=a(),ka=m("p"),ka.innerHTML=uc,Lp=a(),fe=m("div"),u($o.$$.fragment),qp=a(),ja=m("p"),ja.innerHTML=gc,Bp=a(),u(en.$$.fragment),Hp=a(),u(tn.$$.fragment),Pp=a(),u(nn.$$.fragment),Al=a(),u(ko.$$.fragment),Kl=a(),D=m("div"),u(jo.$$.fragment),Ep=a(),Ja=m("p"),Ja.textContent=fc,Qp=a(),Ra=m("p"),Ra.innerHTML=hc,Dp=a(),Ua=m("p"),Ua.innerHTML=_c,Yp=a(),nt=m("div"),u(Jo.$$.fragment),Ap=a(),Ia=m("p"),Ia.innerHTML=bc,Kp=a(),u(on.$$.fragment),em=a(),u(sn.$$.fragment),ei=a(),u(Ro.$$.fragment),ti=a(),Uo=m("p"),Uo.textContent=yc,ni=a(),u(Io.$$.fragment),oi=a(),Y=m("div"),u(Co.$$.fragment),tm=a(),Ca=m("p"),Ca.textContent=Tc,nm=a(),Za=m("p"),Za.innerHTML=Mc,om=a(),Wa=m("p"),Wa.innerHTML=wc,sm=a(),he=m("div"),u(Zo.$$.fragment),am=a(),Na=m("p"),Na.innerHTML=vc,lm=a(),u(an.$$.fragment),im=a(),u(ln.$$.fragment),rm=a(),u(rn.$$.fragment),si=a(),u(Wo.$$.fragment),ai=a(),A=m("div"),u(No.$$.fragment),pm=a(),Sa=m("p"),Sa.textContent=xc,mm=a(),Fa=m("p"),Fa.innerHTML=$c,dm=a(),Oa=m("p"),Oa.innerHTML=kc,cm=a(),_e=m("div"),u(So.$$.fragment),um=a(),Ga=m("p"),Ga.innerHTML=jc,gm=a(),u(pn.$$.fragment),fm=a(),u(mn.$$.fragment),hm=a(),u(dn.$$.fragment),li=a(),u(Fo.$$.fragment),ii=a(),u(Oo.$$.fragment),ri=a(),K=m("div"),u(Go.$$.fragment),_m=a(),Xa=m("p"),Xa.innerHTML=Jc,bm=a(),Va=m("p"),Va.innerHTML=Rc,ym=a(),za=m("p"),za.innerHTML=Uc,Tm=a(),cn=m("div"),u(Xo.$$.fragment),Mm=a(),La=m("p"),La.textContent=Ic,pi=a(),u(Vo.$$.fragment),mi=a(),ee=m("div"),u(zo.$$.fragment),wm=a(),qa=m("p"),qa.innerHTML=Cc,vm=a(),Ba=m("p"),Ba.innerHTML=Zc,xm=a(),Ha=m("p"),Ha.innerHTML=Wc,$m=a(),un=m("div"),u(Lo.$$.fragment),km=a(),Pa=m("p"),Pa.textContent=Nc,di=a(),u(qo.$$.fragment),ci=a(),te=m("div"),u(Bo.$$.fragment),jm=a(),Ea=m("p"),Ea.innerHTML=Sc,Jm=a(),Qa=m("p"),Qa.innerHTML=Fc,Rm=a(),Da=m("p"),Da.innerHTML=Oc,Um=a(),gn=m("div"),u(Ho.$$.fragment),Im=a(),Ya=m("p"),Ya.textContent=Gc,ui=a(),u(Po.$$.fragment),gi=a(),ne=m("div"),u(Eo.$$.fragment),Cm=a(),Aa=m("p"),Aa.innerHTML=Xc,Zm=a(),Ka=m("p"),Ka.innerHTML=Vc,Wm=a(),el=m("p"),el.innerHTML=zc,Nm=a(),fn=m("div"),u(Qo.$$.fragment),Sm=a(),tl=m("p"),tl.textContent=Lc,fi=a(),u(Do.$$.fragment),hi=a(),oe=m("div"),u(Yo.$$.fragment),Fm=a(),nl=m("p"),nl.innerHTML=qc,Om=a(),ol=m("p"),ol.innerHTML=Bc,Gm=a(),sl=m("p"),sl.innerHTML=Hc,Xm=a(),hn=m("div"),u(Ao.$$.fragment),Vm=a(),al=m("p"),al.textContent=Pc,_i=a(),u(Ko.$$.fragment),bi=a(),se=m("div"),u(es.$$.fragment),zm=a(),ll=m("p"),ll.innerHTML=Ec,Lm=a(),il=m("p"),il.innerHTML=Qc,qm=a(),rl=m("p"),rl.innerHTML=Dc,Bm=a(),_n=m("div"),u(ts.$$.fragment),Hm=a(),pl=m("p"),pl.textContent=Yc,yi=a(),ml=m("p"),this.h()},l(e){const p=nu("svelte-u9bgzb",document.head);n=d(p,"META",{name:!0,content:!0}),p.forEach(r),M=l(e),i=d(e,"P",{}),x(i).forEach(r),s=l(e),g(y.$$.fragment,e),t=l(e),g(w.$$.fragment,e),dl=l(e),bn=d(e,"P",{"data-svelte-h":!0}),T(bn)!=="svelte-uyecg"&&(bn.textContent=Pm),cl=l(e),g(yn.$$.fragment,e),ul=l(e),I=d(e,"DIV",{class:!0});var C=x(I);g(Tn.$$.fragment,C),vi=l(C),ds=d(C,"P",{"data-svelte-h":!0}),T(ds)!=="svelte-12yueui"&&(ds.textContent=Em),xi=l(C),cs=d(C,"P",{"data-svelte-h":!0}),T(cs)!=="svelte-zarm0s"&&(cs.innerHTML=Qm),$i=l(C),us=d(C,"P",{"data-svelte-h":!0}),T(us)!=="svelte-wz8va1"&&(us.textContent=Dm),ki=l(C),gs=d(C,"UL",{"data-svelte-h":!0}),T(gs)!=="svelte-qpxha0"&&(gs.innerHTML=Ym),ji=l(C),fs=d(C,"P",{"data-svelte-h":!0}),T(fs)!=="svelte-86gko0"&&(fs.textContent=Am),Ji=l(C),hs=d(C,"UL",{"data-svelte-h":!0}),T(hs)!=="svelte-1hugf7m"&&(hs.innerHTML=Km),Ri=l(C),mt=d(C,"DIV",{class:!0});var ns=x(mt);g(Mn.$$.fragment,ns),Ui=l(ns),_s=d(ns,"P",{"data-svelte-h":!0}),T(_s)!=="svelte-18vxhwp"&&(_s.textContent=ed),ns.forEach(r),Ii=l(C),dt=d(C,"DIV",{class:!0});var os=x(dt);g(wn.$$.fragment,os),Ci=l(os),bs=d(os,"P",{"data-svelte-h":!0}),T(bs)!=="svelte-1sb2z5w"&&(bs.innerHTML=td),os.forEach(r),Zi=l(C),ct=d(C,"DIV",{class:!0});var ss=x(ct);g(vn.$$.fragment,ss),Wi=l(ss),ys=d(ss,"P",{"data-svelte-h":!0}),T(ys)!=="svelte-h8ck7o"&&(ys.textContent=nd),ss.forEach(r),Ni=l(C),ut=d(C,"DIV",{class:!0});var as=x(ut);g(xn.$$.fragment,as),Si=l(as),Ts=d(as,"P",{"data-svelte-h":!0}),T(Ts)!=="svelte-1b4tey4"&&(Ts.textContent=od),as.forEach(r),Fi=l(C),gt=d(C,"DIV",{class:!0});var ls=x(gt);g($n.$$.fragment,ls),Oi=l(ls),Ms=d(ls,"P",{"data-svelte-h":!0}),T(Ms)!=="svelte-1tdm1u4"&&(Ms.textContent=sd),ls.forEach(r),C.forEach(r),gl=l(e),g(kn.$$.fragment,e),fl=l(e),jn=d(e,"P",{"data-svelte-h":!0}),T(jn)!=="svelte-1tlroh"&&(jn.textContent=ad),hl=l(e),g(Jn.$$.fragment,e),_l=l(e),N=d(e,"DIV",{class:!0});var be=x(N);g(Rn.$$.fragment,be),Gi=l(be),ws=d(be,"P",{"data-svelte-h":!0}),T(ws)!=="svelte-pig4vj"&&(ws.textContent=ld),Xi=l(be),vs=d(be,"P",{"data-svelte-h":!0}),T(vs)!=="svelte-1pmzjgn"&&(vs.innerHTML=id),Vi=l(be),xs=d(be,"P",{"data-svelte-h":!0}),T(xs)!=="svelte-7jrnx4"&&(xs.innerHTML=rd),zi=l(be),le=d(be,"DIV",{class:!0});var ye=x(le);g(Un.$$.fragment,ye),Li=l(ye),$s=d(ye,"P",{"data-svelte-h":!0}),T($s)!=="svelte-1ox9av6"&&($s.innerHTML=pd),qi=l(ye),g(ft.$$.fragment,ye),Bi=l(ye),g(ht.$$.fragment,ye),Hi=l(ye),g(_t.$$.fragment,ye),ye.forEach(r),be.forEach(r),bl=l(e),g(In.$$.fragment,e),yl=l(e),S=d(e,"DIV",{class:!0});var Te=x(S);g(Cn.$$.fragment,Te),Pi=l(Te),ks=d(Te,"P",{"data-svelte-h":!0}),T(ks)!=="svelte-lnzl0e"&&(ks.textContent=md),Ei=l(Te),js=d(Te,"P",{"data-svelte-h":!0}),T(js)!=="svelte-1pmzjgn"&&(js.innerHTML=dd),Qi=l(Te),Js=d(Te,"P",{"data-svelte-h":!0}),T(Js)!=="svelte-7jrnx4"&&(Js.innerHTML=cd),Di=l(Te),ie=d(Te,"DIV",{class:!0});var Me=x(ie);g(Zn.$$.fragment,Me),Yi=l(Me),Rs=d(Me,"P",{"data-svelte-h":!0}),T(Rs)!=="svelte-1xqof9m"&&(Rs.innerHTML=ud),Ai=l(Me),g(bt.$$.fragment,Me),Ki=l(Me),g(yt.$$.fragment,Me),er=l(Me),g(Tt.$$.fragment,Me),Me.forEach(r),Te.forEach(r),Tl=l(e),g(Wn.$$.fragment,e),Ml=l(e),F=d(e,"DIV",{class:!0});var we=x(F);g(Nn.$$.fragment,we),tr=l(we),Us=d(we,"P",{"data-svelte-h":!0}),T(Us)!=="svelte-t6z30i"&&(Us.textContent=gd),nr=l(we),Is=d(we,"P",{"data-svelte-h":!0}),T(Is)!=="svelte-1pmzjgn"&&(Is.innerHTML=fd),or=l(we),Cs=d(we,"P",{"data-svelte-h":!0}),T(Cs)!=="svelte-7jrnx4"&&(Cs.innerHTML=hd),sr=l(we),re=d(we,"DIV",{class:!0});var ve=x(re);g(Sn.$$.fragment,ve),ar=l(ve),Zs=d(ve,"P",{"data-svelte-h":!0}),T(Zs)!=="svelte-n65k7h"&&(Zs.innerHTML=_d),lr=l(ve),g(Mt.$$.fragment,ve),ir=l(ve),g(wt.$$.fragment,ve),rr=l(ve),g(vt.$$.fragment,ve),ve.forEach(r),we.forEach(r),wl=l(e),g(Fn.$$.fragment,e),vl=l(e),O=d(e,"DIV",{class:!0});var xe=x(O);g(On.$$.fragment,xe),pr=l(xe),Ws=d(xe,"P",{"data-svelte-h":!0}),T(Ws)!=="svelte-ixbo5n"&&(Ws.textContent=bd),mr=l(xe),Ns=d(xe,"P",{"data-svelte-h":!0}),T(Ns)!=="svelte-1pmzjgn"&&(Ns.innerHTML=yd),dr=l(xe),Ss=d(xe,"P",{"data-svelte-h":!0}),T(Ss)!=="svelte-7jrnx4"&&(Ss.innerHTML=Td),cr=l(xe),W=d(xe,"DIV",{class:!0});var ae=x(W);g(Gn.$$.fragment,ae),ur=l(ae),Fs=d(ae,"P",{"data-svelte-h":!0}),T(Fs)!=="svelte-1plx9t"&&(Fs.innerHTML=Md),gr=l(ae),g(xt.$$.fragment,ae),fr=l(ae),g($t.$$.fragment,ae),hr=l(ae),g(kt.$$.fragment,ae),_r=l(ae),g(jt.$$.fragment,ae),ae.forEach(r),xe.forEach(r),xl=l(e),g(Xn.$$.fragment,e),$l=l(e),G=d(e,"DIV",{class:!0});var $e=x(G);g(Vn.$$.fragment,$e),br=l($e),Os=d($e,"P",{"data-svelte-h":!0}),T(Os)!=="svelte-1l2d2mz"&&(Os.textContent=wd),yr=l($e),Gs=d($e,"P",{"data-svelte-h":!0}),T(Gs)!=="svelte-1pmzjgn"&&(Gs.innerHTML=vd),Tr=l($e),Xs=d($e,"P",{"data-svelte-h":!0}),T(Xs)!=="svelte-7jrnx4"&&(Xs.innerHTML=xd),Mr=l($e),pe=d($e,"DIV",{class:!0});var ke=x(pe);g(zn.$$.fragment,ke),wr=l(ke),Vs=d(ke,"P",{"data-svelte-h":!0}),T(Vs)!=="svelte-xk2xch"&&(Vs.innerHTML=$d),vr=l(ke),g(Jt.$$.fragment,ke),xr=l(ke),g(Rt.$$.fragment,ke),$r=l(ke),g(Ut.$$.fragment,ke),ke.forEach(r),$e.forEach(r),kl=l(e),g(Ln.$$.fragment,e),jl=l(e),X=d(e,"DIV",{class:!0});var je=x(X);g(qn.$$.fragment,je),kr=l(je),zs=d(je,"P",{"data-svelte-h":!0}),T(zs)!=="svelte-1oobrgk"&&(zs.textContent=kd),jr=l(je),Ls=d(je,"P",{"data-svelte-h":!0}),T(Ls)!=="svelte-1pmzjgn"&&(Ls.innerHTML=jd),Jr=l(je),qs=d(je,"P",{"data-svelte-h":!0}),T(qs)!=="svelte-7jrnx4"&&(qs.innerHTML=Jd),Rr=l(je),Ae=d(je,"DIV",{class:!0});var ot=x(Ae);g(Bn.$$.fragment,ot),Ur=l(ot),Bs=d(ot,"P",{"data-svelte-h":!0}),T(Bs)!=="svelte-qesv8n"&&(Bs.innerHTML=Rd),Ir=l(ot),g(It.$$.fragment,ot),Cr=l(ot),g(Ct.$$.fragment,ot),ot.forEach(r),je.forEach(r),Jl=l(e),g(Hn.$$.fragment,e),Rl=l(e),V=d(e,"DIV",{class:!0});var Je=x(V);g(Pn.$$.fragment,Je),Zr=l(Je),Hs=d(Je,"P",{"data-svelte-h":!0}),T(Hs)!=="svelte-1hsozsl"&&(Hs.textContent=Ud),Wr=l(Je),Ps=d(Je,"P",{"data-svelte-h":!0}),T(Ps)!=="svelte-1pmzjgn"&&(Ps.innerHTML=Id),Nr=l(Je),Es=d(Je,"P",{"data-svelte-h":!0}),T(Es)!=="svelte-7jrnx4"&&(Es.innerHTML=Cd),Sr=l(Je),me=d(Je,"DIV",{class:!0});var Re=x(me);g(En.$$.fragment,Re),Fr=l(Re),Qs=d(Re,"P",{"data-svelte-h":!0}),T(Qs)!=="svelte-1dng7rw"&&(Qs.innerHTML=Zd),Or=l(Re),g(Zt.$$.fragment,Re),Gr=l(Re),g(Wt.$$.fragment,Re),Xr=l(Re),g(Nt.$$.fragment,Re),Re.forEach(r),Je.forEach(r),Ul=l(e),g(Qn.$$.fragment,e),Il=l(e),Dn=d(e,"P",{"data-svelte-h":!0}),T(Dn)!=="svelte-1h2y3wu"&&(Dn.textContent=Wd),Cl=l(e),g(Yn.$$.fragment,e),Zl=l(e),z=d(e,"DIV",{class:!0});var Ue=x(z);g(An.$$.fragment,Ue),Vr=l(Ue),Ds=d(Ue,"P",{"data-svelte-h":!0}),T(Ds)!=="svelte-lp0at6"&&(Ds.textContent=Nd),zr=l(Ue),Ys=d(Ue,"P",{"data-svelte-h":!0}),T(Ys)!=="svelte-1pmzjgn"&&(Ys.innerHTML=Sd),Lr=l(Ue),As=d(Ue,"P",{"data-svelte-h":!0}),T(As)!=="svelte-7jrnx4"&&(As.innerHTML=Fd),qr=l(Ue),de=d(Ue,"DIV",{class:!0});var Ie=x(de);g(Kn.$$.fragment,Ie),Br=l(Ie),Ks=d(Ie,"P",{"data-svelte-h":!0}),T(Ks)!=="svelte-1azuqx"&&(Ks.innerHTML=Od),Hr=l(Ie),g(St.$$.fragment,Ie),Pr=l(Ie),g(Ft.$$.fragment,Ie),Er=l(Ie),g(Ot.$$.fragment,Ie),Ie.forEach(r),Ue.forEach(r),Wl=l(e),g(eo.$$.fragment,e),Nl=l(e),L=d(e,"DIV",{class:!0});var Ce=x(L);g(to.$$.fragment,Ce),Qr=l(Ce),ea=d(Ce,"P",{"data-svelte-h":!0}),T(ea)!=="svelte-mw2y5y"&&(ea.textContent=Gd),Dr=l(Ce),ta=d(Ce,"P",{"data-svelte-h":!0}),T(ta)!=="svelte-1pmzjgn"&&(ta.innerHTML=Xd),Yr=l(Ce),na=d(Ce,"P",{"data-svelte-h":!0}),T(na)!=="svelte-7jrnx4"&&(na.innerHTML=Vd),Ar=l(Ce),ce=d(Ce,"DIV",{class:!0});var Ze=x(ce);g(no.$$.fragment,Ze),Kr=l(Ze),oa=d(Ze,"P",{"data-svelte-h":!0}),T(oa)!=="svelte-1s27jle"&&(oa.innerHTML=zd),ep=l(Ze),g(Gt.$$.fragment,Ze),tp=l(Ze),g(Xt.$$.fragment,Ze),np=l(Ze),g(Vt.$$.fragment,Ze),Ze.forEach(r),Ce.forEach(r),Sl=l(e),g(oo.$$.fragment,e),Fl=l(e),so=d(e,"P",{"data-svelte-h":!0}),T(so)!=="svelte-liyjdz"&&(so.textContent=Ld),Ol=l(e),g(ao.$$.fragment,e),Gl=l(e),q=d(e,"DIV",{class:!0});var We=x(q);g(lo.$$.fragment,We),op=l(We),sa=d(We,"P",{"data-svelte-h":!0}),T(sa)!=="svelte-yleggj"&&(sa.textContent=qd),sp=l(We),aa=d(We,"P",{"data-svelte-h":!0}),T(aa)!=="svelte-1pmzjgn"&&(aa.innerHTML=Bd),ap=l(We),la=d(We,"P",{"data-svelte-h":!0}),T(la)!=="svelte-7jrnx4"&&(la.innerHTML=Hd),lp=l(We),ue=d(We,"DIV",{class:!0});var Ne=x(ue);g(io.$$.fragment,Ne),ip=l(Ne),ia=d(Ne,"P",{"data-svelte-h":!0}),T(ia)!=="svelte-p67kxo"&&(ia.innerHTML=Pd),rp=l(Ne),g(zt.$$.fragment,Ne),pp=l(Ne),g(Lt.$$.fragment,Ne),mp=l(Ne),g(qt.$$.fragment,Ne),Ne.forEach(r),We.forEach(r),Xl=l(e),g(ro.$$.fragment,e),Vl=l(e),B=d(e,"DIV",{class:!0});var Se=x(B);g(po.$$.fragment,Se),dp=l(Se),ra=d(Se,"P",{"data-svelte-h":!0}),T(ra)!=="svelte-lyybxc"&&(ra.textContent=Ed),cp=l(Se),pa=d(Se,"P",{"data-svelte-h":!0}),T(pa)!=="svelte-1pmzjgn"&&(pa.innerHTML=Qd),up=l(Se),ma=d(Se,"P",{"data-svelte-h":!0}),T(ma)!=="svelte-7jrnx4"&&(ma.innerHTML=Dd),gp=l(Se),Ke=d(Se,"DIV",{class:!0});var st=x(Ke);g(mo.$$.fragment,st),fp=l(st),da=d(st,"P",{"data-svelte-h":!0}),T(da)!=="svelte-18aced7"&&(da.innerHTML=Yd),hp=l(st),g(Bt.$$.fragment,st),_p=l(st),g(Ht.$$.fragment,st),st.forEach(r),Se.forEach(r),zl=l(e),g(co.$$.fragment,e),Ll=l(e),H=d(e,"DIV",{class:!0});var Fe=x(H);g(uo.$$.fragment,Fe),bp=l(Fe),ca=d(Fe,"P",{"data-svelte-h":!0}),T(ca)!=="svelte-xbkga4"&&(ca.textContent=Ad),yp=l(Fe),ua=d(Fe,"P",{"data-svelte-h":!0}),T(ua)!=="svelte-1pmzjgn"&&(ua.innerHTML=Kd),Tp=l(Fe),ga=d(Fe,"P",{"data-svelte-h":!0}),T(ga)!=="svelte-7jrnx4"&&(ga.innerHTML=ec),Mp=l(Fe),et=d(Fe,"DIV",{class:!0});var at=x(et);g(go.$$.fragment,at),wp=l(at),fa=d(at,"P",{"data-svelte-h":!0}),T(fa)!=="svelte-1szjv6u"&&(fa.innerHTML=tc),vp=l(at),g(Pt.$$.fragment,at),xp=l(at),g(Et.$$.fragment,at),at.forEach(r),Fe.forEach(r),ql=l(e),g(fo.$$.fragment,e),Bl=l(e),P=d(e,"DIV",{class:!0});var Oe=x(P);g(ho.$$.fragment,Oe),$p=l(Oe),ha=d(Oe,"P",{"data-svelte-h":!0}),T(ha)!=="svelte-135bhh9"&&(ha.textContent=nc),kp=l(Oe),_a=d(Oe,"P",{"data-svelte-h":!0}),T(_a)!=="svelte-1pmzjgn"&&(_a.innerHTML=oc),jp=l(Oe),ba=d(Oe,"P",{"data-svelte-h":!0}),T(ba)!=="svelte-7jrnx4"&&(ba.innerHTML=sc),Jp=l(Oe),ge=d(Oe,"DIV",{class:!0});var Ge=x(ge);g(_o.$$.fragment,Ge),Rp=l(Ge),ya=d(Ge,"P",{"data-svelte-h":!0}),T(ya)!=="svelte-1e3zkhy"&&(ya.innerHTML=ac),Up=l(Ge),g(Qt.$$.fragment,Ge),Ip=l(Ge),g(Dt.$$.fragment,Ge),Cp=l(Ge),g(Yt.$$.fragment,Ge),Ge.forEach(r),Oe.forEach(r),Hl=l(e),g(bo.$$.fragment,e),Pl=l(e),E=d(e,"DIV",{class:!0});var Xe=x(E);g(yo.$$.fragment,Xe),Zp=l(Xe),Ta=d(Xe,"P",{"data-svelte-h":!0}),T(Ta)!=="svelte-1bhc8y0"&&(Ta.textContent=lc),Wp=l(Xe),Ma=d(Xe,"P",{"data-svelte-h":!0}),T(Ma)!=="svelte-1pmzjgn"&&(Ma.innerHTML=ic),Np=l(Xe),wa=d(Xe,"P",{"data-svelte-h":!0}),T(wa)!=="svelte-7jrnx4"&&(wa.innerHTML=rc),Sp=l(Xe),tt=d(Xe,"DIV",{class:!0});var lt=x(tt);g(To.$$.fragment,lt),Fp=l(lt),va=d(lt,"P",{"data-svelte-h":!0}),T(va)!=="svelte-1fuxgrl"&&(va.innerHTML=pc),Op=l(lt),g(At.$$.fragment,lt),Gp=l(lt),g(Kt.$$.fragment,lt),lt.forEach(r),Xe.forEach(r),El=l(e),g(Mo.$$.fragment,e),Ql=l(e),wo=d(e,"P",{"data-svelte-h":!0}),T(wo)!=="svelte-1gk58z"&&(wo.textContent=mc),Dl=l(e),g(vo.$$.fragment,e),Yl=l(e),Q=d(e,"DIV",{class:!0});var Ve=x(Q);g(xo.$$.fragment,Ve),Xp=l(Ve),xa=d(Ve,"P",{"data-svelte-h":!0}),T(xa)!=="svelte-1yhfevg"&&(xa.textContent=dc),Vp=l(Ve),$a=d(Ve,"P",{"data-svelte-h":!0}),T($a)!=="svelte-1pmzjgn"&&($a.innerHTML=cc),zp=l(Ve),ka=d(Ve,"P",{"data-svelte-h":!0}),T(ka)!=="svelte-7jrnx4"&&(ka.innerHTML=uc),Lp=l(Ve),fe=d(Ve,"DIV",{class:!0});var ze=x(fe);g($o.$$.fragment,ze),qp=l(ze),ja=d(ze,"P",{"data-svelte-h":!0}),T(ja)!=="svelte-11xalzp"&&(ja.innerHTML=gc),Bp=l(ze),g(en.$$.fragment,ze),Hp=l(ze),g(tn.$$.fragment,ze),Pp=l(ze),g(nn.$$.fragment,ze),ze.forEach(r),Ve.forEach(r),Al=l(e),g(ko.$$.fragment,e),Kl=l(e),D=d(e,"DIV",{class:!0});var Le=x(D);g(jo.$$.fragment,Le),Ep=l(Le),Ja=d(Le,"P",{"data-svelte-h":!0}),T(Ja)!=="svelte-80a148"&&(Ja.textContent=fc),Qp=l(Le),Ra=d(Le,"P",{"data-svelte-h":!0}),T(Ra)!=="svelte-1pmzjgn"&&(Ra.innerHTML=hc),Dp=l(Le),Ua=d(Le,"P",{"data-svelte-h":!0}),T(Ua)!=="svelte-7jrnx4"&&(Ua.innerHTML=_c),Yp=l(Le),nt=d(Le,"DIV",{class:!0});var it=x(nt);g(Jo.$$.fragment,it),Ap=l(it),Ia=d(it,"P",{"data-svelte-h":!0}),T(Ia)!=="svelte-eywb10"&&(Ia.innerHTML=bc),Kp=l(it),g(on.$$.fragment,it),em=l(it),g(sn.$$.fragment,it),it.forEach(r),Le.forEach(r),ei=l(e),g(Ro.$$.fragment,e),ti=l(e),Uo=d(e,"P",{"data-svelte-h":!0}),T(Uo)!=="svelte-1n8n3ms"&&(Uo.textContent=yc),ni=l(e),g(Io.$$.fragment,e),oi=l(e),Y=d(e,"DIV",{class:!0});var qe=x(Y);g(Co.$$.fragment,qe),tm=l(qe),Ca=d(qe,"P",{"data-svelte-h":!0}),T(Ca)!=="svelte-5pmyjn"&&(Ca.textContent=Tc),nm=l(qe),Za=d(qe,"P",{"data-svelte-h":!0}),T(Za)!=="svelte-1pmzjgn"&&(Za.innerHTML=Mc),om=l(qe),Wa=d(qe,"P",{"data-svelte-h":!0}),T(Wa)!=="svelte-7jrnx4"&&(Wa.innerHTML=wc),sm=l(qe),he=d(qe,"DIV",{class:!0});var Be=x(he);g(Zo.$$.fragment,Be),am=l(Be),Na=d(Be,"P",{"data-svelte-h":!0}),T(Na)!=="svelte-1usnw5b"&&(Na.innerHTML=vc),lm=l(Be),g(an.$$.fragment,Be),im=l(Be),g(ln.$$.fragment,Be),rm=l(Be),g(rn.$$.fragment,Be),Be.forEach(r),qe.forEach(r),si=l(e),g(Wo.$$.fragment,e),ai=l(e),A=d(e,"DIV",{class:!0});var He=x(A);g(No.$$.fragment,He),pm=l(He),Sa=d(He,"P",{"data-svelte-h":!0}),T(Sa)!=="svelte-1rhquq6"&&(Sa.textContent=xc),mm=l(He),Fa=d(He,"P",{"data-svelte-h":!0}),T(Fa)!=="svelte-1pmzjgn"&&(Fa.innerHTML=$c),dm=l(He),Oa=d(He,"P",{"data-svelte-h":!0}),T(Oa)!=="svelte-7jrnx4"&&(Oa.innerHTML=kc),cm=l(He),_e=d(He,"DIV",{class:!0});var Pe=x(_e);g(So.$$.fragment,Pe),um=l(Pe),Ga=d(Pe,"P",{"data-svelte-h":!0}),T(Ga)!=="svelte-iqwqsz"&&(Ga.innerHTML=jc),gm=l(Pe),g(pn.$$.fragment,Pe),fm=l(Pe),g(mn.$$.fragment,Pe),hm=l(Pe),g(dn.$$.fragment,Pe),Pe.forEach(r),He.forEach(r),li=l(e),g(Fo.$$.fragment,e),ii=l(e),g(Oo.$$.fragment,e),ri=l(e),K=d(e,"DIV",{class:!0});var Ee=x(K);g(Go.$$.fragment,Ee),_m=l(Ee),Xa=d(Ee,"P",{"data-svelte-h":!0}),T(Xa)!=="svelte-o3cjct"&&(Xa.innerHTML=Jc),bm=l(Ee),Va=d(Ee,"P",{"data-svelte-h":!0}),T(Va)!=="svelte-1pmzjgn"&&(Va.innerHTML=Rc),ym=l(Ee),za=d(Ee,"P",{"data-svelte-h":!0}),T(za)!=="svelte-7jrnx4"&&(za.innerHTML=Uc),Tm=l(Ee),cn=d(Ee,"DIV",{class:!0});var is=x(cn);g(Xo.$$.fragment,is),Mm=l(is),La=d(is,"P",{"data-svelte-h":!0}),T(La)!=="svelte-v78lg8"&&(La.textContent=Ic),is.forEach(r),Ee.forEach(r),pi=l(e),g(Vo.$$.fragment,e),mi=l(e),ee=d(e,"DIV",{class:!0});var Qe=x(ee);g(zo.$$.fragment,Qe),wm=l(Qe),qa=d(Qe,"P",{"data-svelte-h":!0}),T(qa)!=="svelte-1ds9yih"&&(qa.innerHTML=Cc),vm=l(Qe),Ba=d(Qe,"P",{"data-svelte-h":!0}),T(Ba)!=="svelte-1pmzjgn"&&(Ba.innerHTML=Zc),xm=l(Qe),Ha=d(Qe,"P",{"data-svelte-h":!0}),T(Ha)!=="svelte-7jrnx4"&&(Ha.innerHTML=Wc),$m=l(Qe),un=d(Qe,"DIV",{class:!0});var rs=x(un);g(Lo.$$.fragment,rs),km=l(rs),Pa=d(rs,"P",{"data-svelte-h":!0}),T(Pa)!=="svelte-v78lg8"&&(Pa.textContent=Nc),rs.forEach(r),Qe.forEach(r),di=l(e),g(qo.$$.fragment,e),ci=l(e),te=d(e,"DIV",{class:!0});var De=x(te);g(Bo.$$.fragment,De),jm=l(De),Ea=d(De,"P",{"data-svelte-h":!0}),T(Ea)!=="svelte-1jlenwy"&&(Ea.innerHTML=Sc),Jm=l(De),Qa=d(De,"P",{"data-svelte-h":!0}),T(Qa)!=="svelte-1pmzjgn"&&(Qa.innerHTML=Fc),Rm=l(De),Da=d(De,"P",{"data-svelte-h":!0}),T(Da)!=="svelte-7jrnx4"&&(Da.innerHTML=Oc),Um=l(De),gn=d(De,"DIV",{class:!0});var ps=x(gn);g(Ho.$$.fragment,ps),Im=l(ps),Ya=d(ps,"P",{"data-svelte-h":!0}),T(Ya)!=="svelte-v78lg8"&&(Ya.textContent=Gc),ps.forEach(r),De.forEach(r),ui=l(e),g(Po.$$.fragment,e),gi=l(e),ne=d(e,"DIV",{class:!0});var Ye=x(ne);g(Eo.$$.fragment,Ye),Cm=l(Ye),Aa=d(Ye,"P",{"data-svelte-h":!0}),T(Aa)!=="svelte-tg08kp"&&(Aa.innerHTML=Xc),Zm=l(Ye),Ka=d(Ye,"P",{"data-svelte-h":!0}),T(Ka)!=="svelte-1pmzjgn"&&(Ka.innerHTML=Vc),Wm=l(Ye),el=d(Ye,"P",{"data-svelte-h":!0}),T(el)!=="svelte-7jrnx4"&&(el.innerHTML=zc),Nm=l(Ye),fn=d(Ye,"DIV",{class:!0});var ms=x(fn);g(Qo.$$.fragment,ms),Sm=l(ms),tl=d(ms,"P",{"data-svelte-h":!0}),T(tl)!=="svelte-v78lg8"&&(tl.textContent=Lc),ms.forEach(r),Ye.forEach(r),fi=l(e),g(Do.$$.fragment,e),hi=l(e),oe=d(e,"DIV",{class:!0});var rt=x(oe);g(Yo.$$.fragment,rt),Fm=l(rt),nl=d(rt,"P",{"data-svelte-h":!0}),T(nl)!=="svelte-zcp8nz"&&(nl.innerHTML=qc),Om=l(rt),ol=d(rt,"P",{"data-svelte-h":!0}),T(ol)!=="svelte-1pmzjgn"&&(ol.innerHTML=Bc),Gm=l(rt),sl=d(rt,"P",{"data-svelte-h":!0}),T(sl)!=="svelte-7jrnx4"&&(sl.innerHTML=Hc),Xm=l(rt),hn=d(rt,"DIV",{class:!0});var Mi=x(hn);g(Ao.$$.fragment,Mi),Vm=l(Mi),al=d(Mi,"P",{"data-svelte-h":!0}),T(al)!=="svelte-v78lg8"&&(al.textContent=Pc),Mi.forEach(r),rt.forEach(r),_i=l(e),g(Ko.$$.fragment,e),bi=l(e),se=d(e,"DIV",{class:!0});var pt=x(se);g(es.$$.fragment,pt),zm=l(pt),ll=d(pt,"P",{"data-svelte-h":!0}),T(ll)!=="svelte-1d0xpim"&&(ll.innerHTML=Ec),Lm=l(pt),il=d(pt,"P",{"data-svelte-h":!0}),T(il)!=="svelte-1pmzjgn"&&(il.innerHTML=Qc),qm=l(pt),rl=d(pt,"P",{"data-svelte-h":!0}),T(rl)!=="svelte-7jrnx4"&&(rl.innerHTML=Dc),Bm=l(pt),_n=d(pt,"DIV",{class:!0});var wi=x(_n);g(ts.$$.fragment,wi),Hm=l(wi),pl=d(wi,"P",{"data-svelte-h":!0}),T(pl)!=="svelte-v78lg8"&&(pl.textContent=Yc),wi.forEach(r),pt.forEach(r),yi=l(e),ml=d(e,"P",{}),x(ml).forEach(r),this.h()},h(){$(n,"name","hf:doc:metadata"),$(n,"content",eg),$(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(_n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){o(document.head,n),c(e,M,p),c(e,i,p),c(e,s,p),f(y,e,p),c(e,t,p),f(w,e,p),c(e,dl,p),c(e,bn,p),c(e,cl,p),f(yn,e,p),c(e,ul,p),c(e,I,p),f(Tn,I,null),o(I,vi),o(I,ds),o(I,xi),o(I,cs),o(I,$i),o(I,us),o(I,ki),o(I,gs),o(I,ji),o(I,fs),o(I,Ji),o(I,hs),o(I,Ri),o(I,mt),f(Mn,mt,null),o(mt,Ui),o(mt,_s),o(I,Ii),o(I,dt),f(wn,dt,null),o(dt,Ci),o(dt,bs),o(I,Zi),o(I,ct),f(vn,ct,null),o(ct,Wi),o(ct,ys),o(I,Ni),o(I,ut),f(xn,ut,null),o(ut,Si),o(ut,Ts),o(I,Fi),o(I,gt),f($n,gt,null),o(gt,Oi),o(gt,Ms),c(e,gl,p),f(kn,e,p),c(e,fl,p),c(e,jn,p),c(e,hl,p),f(Jn,e,p),c(e,_l,p),c(e,N,p),f(Rn,N,null),o(N,Gi),o(N,ws),o(N,Xi),o(N,vs),o(N,Vi),o(N,xs),o(N,zi),o(N,le),f(Un,le,null),o(le,Li),o(le,$s),o(le,qi),f(ft,le,null),o(le,Bi),f(ht,le,null),o(le,Hi),f(_t,le,null),c(e,bl,p),f(In,e,p),c(e,yl,p),c(e,S,p),f(Cn,S,null),o(S,Pi),o(S,ks),o(S,Ei),o(S,js),o(S,Qi),o(S,Js),o(S,Di),o(S,ie),f(Zn,ie,null),o(ie,Yi),o(ie,Rs),o(ie,Ai),f(bt,ie,null),o(ie,Ki),f(yt,ie,null),o(ie,er),f(Tt,ie,null),c(e,Tl,p),f(Wn,e,p),c(e,Ml,p),c(e,F,p),f(Nn,F,null),o(F,tr),o(F,Us),o(F,nr),o(F,Is),o(F,or),o(F,Cs),o(F,sr),o(F,re),f(Sn,re,null),o(re,ar),o(re,Zs),o(re,lr),f(Mt,re,null),o(re,ir),f(wt,re,null),o(re,rr),f(vt,re,null),c(e,wl,p),f(Fn,e,p),c(e,vl,p),c(e,O,p),f(On,O,null),o(O,pr),o(O,Ws),o(O,mr),o(O,Ns),o(O,dr),o(O,Ss),o(O,cr),o(O,W),f(Gn,W,null),o(W,ur),o(W,Fs),o(W,gr),f(xt,W,null),o(W,fr),f($t,W,null),o(W,hr),f(kt,W,null),o(W,_r),f(jt,W,null),c(e,xl,p),f(Xn,e,p),c(e,$l,p),c(e,G,p),f(Vn,G,null),o(G,br),o(G,Os),o(G,yr),o(G,Gs),o(G,Tr),o(G,Xs),o(G,Mr),o(G,pe),f(zn,pe,null),o(pe,wr),o(pe,Vs),o(pe,vr),f(Jt,pe,null),o(pe,xr),f(Rt,pe,null),o(pe,$r),f(Ut,pe,null),c(e,kl,p),f(Ln,e,p),c(e,jl,p),c(e,X,p),f(qn,X,null),o(X,kr),o(X,zs),o(X,jr),o(X,Ls),o(X,Jr),o(X,qs),o(X,Rr),o(X,Ae),f(Bn,Ae,null),o(Ae,Ur),o(Ae,Bs),o(Ae,Ir),f(It,Ae,null),o(Ae,Cr),f(Ct,Ae,null),c(e,Jl,p),f(Hn,e,p),c(e,Rl,p),c(e,V,p),f(Pn,V,null),o(V,Zr),o(V,Hs),o(V,Wr),o(V,Ps),o(V,Nr),o(V,Es),o(V,Sr),o(V,me),f(En,me,null),o(me,Fr),o(me,Qs),o(me,Or),f(Zt,me,null),o(me,Gr),f(Wt,me,null),o(me,Xr),f(Nt,me,null),c(e,Ul,p),f(Qn,e,p),c(e,Il,p),c(e,Dn,p),c(e,Cl,p),f(Yn,e,p),c(e,Zl,p),c(e,z,p),f(An,z,null),o(z,Vr),o(z,Ds),o(z,zr),o(z,Ys),o(z,Lr),o(z,As),o(z,qr),o(z,de),f(Kn,de,null),o(de,Br),o(de,Ks),o(de,Hr),f(St,de,null),o(de,Pr),f(Ft,de,null),o(de,Er),f(Ot,de,null),c(e,Wl,p),f(eo,e,p),c(e,Nl,p),c(e,L,p),f(to,L,null),o(L,Qr),o(L,ea),o(L,Dr),o(L,ta),o(L,Yr),o(L,na),o(L,Ar),o(L,ce),f(no,ce,null),o(ce,Kr),o(ce,oa),o(ce,ep),f(Gt,ce,null),o(ce,tp),f(Xt,ce,null),o(ce,np),f(Vt,ce,null),c(e,Sl,p),f(oo,e,p),c(e,Fl,p),c(e,so,p),c(e,Ol,p),f(ao,e,p),c(e,Gl,p),c(e,q,p),f(lo,q,null),o(q,op),o(q,sa),o(q,sp),o(q,aa),o(q,ap),o(q,la),o(q,lp),o(q,ue),f(io,ue,null),o(ue,ip),o(ue,ia),o(ue,rp),f(zt,ue,null),o(ue,pp),f(Lt,ue,null),o(ue,mp),f(qt,ue,null),c(e,Xl,p),f(ro,e,p),c(e,Vl,p),c(e,B,p),f(po,B,null),o(B,dp),o(B,ra),o(B,cp),o(B,pa),o(B,up),o(B,ma),o(B,gp),o(B,Ke),f(mo,Ke,null),o(Ke,fp),o(Ke,da),o(Ke,hp),f(Bt,Ke,null),o(Ke,_p),f(Ht,Ke,null),c(e,zl,p),f(co,e,p),c(e,Ll,p),c(e,H,p),f(uo,H,null),o(H,bp),o(H,ca),o(H,yp),o(H,ua),o(H,Tp),o(H,ga),o(H,Mp),o(H,et),f(go,et,null),o(et,wp),o(et,fa),o(et,vp),f(Pt,et,null),o(et,xp),f(Et,et,null),c(e,ql,p),f(fo,e,p),c(e,Bl,p),c(e,P,p),f(ho,P,null),o(P,$p),o(P,ha),o(P,kp),o(P,_a),o(P,jp),o(P,ba),o(P,Jp),o(P,ge),f(_o,ge,null),o(ge,Rp),o(ge,ya),o(ge,Up),f(Qt,ge,null),o(ge,Ip),f(Dt,ge,null),o(ge,Cp),f(Yt,ge,null),c(e,Hl,p),f(bo,e,p),c(e,Pl,p),c(e,E,p),f(yo,E,null),o(E,Zp),o(E,Ta),o(E,Wp),o(E,Ma),o(E,Np),o(E,wa),o(E,Sp),o(E,tt),f(To,tt,null),o(tt,Fp),o(tt,va),o(tt,Op),f(At,tt,null),o(tt,Gp),f(Kt,tt,null),c(e,El,p),f(Mo,e,p),c(e,Ql,p),c(e,wo,p),c(e,Dl,p),f(vo,e,p),c(e,Yl,p),c(e,Q,p),f(xo,Q,null),o(Q,Xp),o(Q,xa),o(Q,Vp),o(Q,$a),o(Q,zp),o(Q,ka),o(Q,Lp),o(Q,fe),f($o,fe,null),o(fe,qp),o(fe,ja),o(fe,Bp),f(en,fe,null),o(fe,Hp),f(tn,fe,null),o(fe,Pp),f(nn,fe,null),c(e,Al,p),f(ko,e,p),c(e,Kl,p),c(e,D,p),f(jo,D,null),o(D,Ep),o(D,Ja),o(D,Qp),o(D,Ra),o(D,Dp),o(D,Ua),o(D,Yp),o(D,nt),f(Jo,nt,null),o(nt,Ap),o(nt,Ia),o(nt,Kp),f(on,nt,null),o(nt,em),f(sn,nt,null),c(e,ei,p),f(Ro,e,p),c(e,ti,p),c(e,Uo,p),c(e,ni,p),f(Io,e,p),c(e,oi,p),c(e,Y,p),f(Co,Y,null),o(Y,tm),o(Y,Ca),o(Y,nm),o(Y,Za),o(Y,om),o(Y,Wa),o(Y,sm),o(Y,he),f(Zo,he,null),o(he,am),o(he,Na),o(he,lm),f(an,he,null),o(he,im),f(ln,he,null),o(he,rm),f(rn,he,null),c(e,si,p),f(Wo,e,p),c(e,ai,p),c(e,A,p),f(No,A,null),o(A,pm),o(A,Sa),o(A,mm),o(A,Fa),o(A,dm),o(A,Oa),o(A,cm),o(A,_e),f(So,_e,null),o(_e,um),o(_e,Ga),o(_e,gm),f(pn,_e,null),o(_e,fm),f(mn,_e,null),o(_e,hm),f(dn,_e,null),c(e,li,p),f(Fo,e,p),c(e,ii,p),f(Oo,e,p),c(e,ri,p),c(e,K,p),f(Go,K,null),o(K,_m),o(K,Xa),o(K,bm),o(K,Va),o(K,ym),o(K,za),o(K,Tm),o(K,cn),f(Xo,cn,null),o(cn,Mm),o(cn,La),c(e,pi,p),f(Vo,e,p),c(e,mi,p),c(e,ee,p),f(zo,ee,null),o(ee,wm),o(ee,qa),o(ee,vm),o(ee,Ba),o(ee,xm),o(ee,Ha),o(ee,$m),o(ee,un),f(Lo,un,null),o(un,km),o(un,Pa),c(e,di,p),f(qo,e,p),c(e,ci,p),c(e,te,p),f(Bo,te,null),o(te,jm),o(te,Ea),o(te,Jm),o(te,Qa),o(te,Rm),o(te,Da),o(te,Um),o(te,gn),f(Ho,gn,null),o(gn,Im),o(gn,Ya),c(e,ui,p),f(Po,e,p),c(e,gi,p),c(e,ne,p),f(Eo,ne,null),o(ne,Cm),o(ne,Aa),o(ne,Zm),o(ne,Ka),o(ne,Wm),o(ne,el),o(ne,Nm),o(ne,fn),f(Qo,fn,null),o(fn,Sm),o(fn,tl),c(e,fi,p),f(Do,e,p),c(e,hi,p),c(e,oe,p),f(Yo,oe,null),o(oe,Fm),o(oe,nl),o(oe,Om),o(oe,ol),o(oe,Gm),o(oe,sl),o(oe,Xm),o(oe,hn),f(Ao,hn,null),o(hn,Vm),o(hn,al),c(e,_i,p),f(Ko,e,p),c(e,bi,p),c(e,se,p),f(es,se,null),o(se,zm),o(se,ll),o(se,Lm),o(se,il),o(se,qm),o(se,rl),o(se,Bm),o(se,_n),f(ts,_n,null),o(_n,Hm),o(_n,pl),c(e,yi,p),c(e,ml,p),Ti=!0},p(e,[p]){const C={};p&2&&(C.$$scope={dirty:p,ctx:e}),ft.$set(C);const ns={};p&2&&(ns.$$scope={dirty:p,ctx:e}),ht.$set(ns);const os={};p&2&&(os.$$scope={dirty:p,ctx:e}),_t.$set(os);const ss={};p&2&&(ss.$$scope={dirty:p,ctx:e}),bt.$set(ss);const as={};p&2&&(as.$$scope={dirty:p,ctx:e}),yt.$set(as);const ls={};p&2&&(ls.$$scope={dirty:p,ctx:e}),Tt.$set(ls);const be={};p&2&&(be.$$scope={dirty:p,ctx:e}),Mt.$set(be);const ye={};p&2&&(ye.$$scope={dirty:p,ctx:e}),wt.$set(ye);const Te={};p&2&&(Te.$$scope={dirty:p,ctx:e}),vt.$set(Te);const Me={};p&2&&(Me.$$scope={dirty:p,ctx:e}),xt.$set(Me);const we={};p&2&&(we.$$scope={dirty:p,ctx:e}),$t.$set(we);const ve={};p&2&&(ve.$$scope={dirty:p,ctx:e}),kt.$set(ve);const xe={};p&2&&(xe.$$scope={dirty:p,ctx:e}),jt.$set(xe);const ae={};p&2&&(ae.$$scope={dirty:p,ctx:e}),Jt.$set(ae);const $e={};p&2&&($e.$$scope={dirty:p,ctx:e}),Rt.$set($e);const ke={};p&2&&(ke.$$scope={dirty:p,ctx:e}),Ut.$set(ke);const je={};p&2&&(je.$$scope={dirty:p,ctx:e}),It.$set(je);const ot={};p&2&&(ot.$$scope={dirty:p,ctx:e}),Ct.$set(ot);const Je={};p&2&&(Je.$$scope={dirty:p,ctx:e}),Zt.$set(Je);const Re={};p&2&&(Re.$$scope={dirty:p,ctx:e}),Wt.$set(Re);const Ue={};p&2&&(Ue.$$scope={dirty:p,ctx:e}),Nt.$set(Ue);const Ie={};p&2&&(Ie.$$scope={dirty:p,ctx:e}),St.$set(Ie);const Ce={};p&2&&(Ce.$$scope={dirty:p,ctx:e}),Ft.$set(Ce);const Ze={};p&2&&(Ze.$$scope={dirty:p,ctx:e}),Ot.$set(Ze);const We={};p&2&&(We.$$scope={dirty:p,ctx:e}),Gt.$set(We);const Ne={};p&2&&(Ne.$$scope={dirty:p,ctx:e}),Xt.$set(Ne);const Se={};p&2&&(Se.$$scope={dirty:p,ctx:e}),Vt.$set(Se);const st={};p&2&&(st.$$scope={dirty:p,ctx:e}),zt.$set(st);const Fe={};p&2&&(Fe.$$scope={dirty:p,ctx:e}),Lt.$set(Fe);const at={};p&2&&(at.$$scope={dirty:p,ctx:e}),qt.$set(at);const Oe={};p&2&&(Oe.$$scope={dirty:p,ctx:e}),Bt.$set(Oe);const Ge={};p&2&&(Ge.$$scope={dirty:p,ctx:e}),Ht.$set(Ge);const Xe={};p&2&&(Xe.$$scope={dirty:p,ctx:e}),Pt.$set(Xe);const lt={};p&2&&(lt.$$scope={dirty:p,ctx:e}),Et.$set(lt);const Ve={};p&2&&(Ve.$$scope={dirty:p,ctx:e}),Qt.$set(Ve);const ze={};p&2&&(ze.$$scope={dirty:p,ctx:e}),Dt.$set(ze);const Le={};p&2&&(Le.$$scope={dirty:p,ctx:e}),Yt.$set(Le);const it={};p&2&&(it.$$scope={dirty:p,ctx:e}),At.$set(it);const qe={};p&2&&(qe.$$scope={dirty:p,ctx:e}),Kt.$set(qe);const Be={};p&2&&(Be.$$scope={dirty:p,ctx:e}),en.$set(Be);const He={};p&2&&(He.$$scope={dirty:p,ctx:e}),tn.$set(He);const Pe={};p&2&&(Pe.$$scope={dirty:p,ctx:e}),nn.$set(Pe);const Ee={};p&2&&(Ee.$$scope={dirty:p,ctx:e}),on.$set(Ee);const is={};p&2&&(is.$$scope={dirty:p,ctx:e}),sn.$set(is);const Qe={};p&2&&(Qe.$$scope={dirty:p,ctx:e}),an.$set(Qe);const rs={};p&2&&(rs.$$scope={dirty:p,ctx:e}),ln.$set(rs);const De={};p&2&&(De.$$scope={dirty:p,ctx:e}),rn.$set(De);const ps={};p&2&&(ps.$$scope={dirty:p,ctx:e}),pn.$set(ps);const Ye={};p&2&&(Ye.$$scope={dirty:p,ctx:e}),mn.$set(Ye);const ms={};p&2&&(ms.$$scope={dirty:p,ctx:e}),dn.$set(ms)},i(e){Ti||(h(y.$$.fragment,e),h(w.$$.fragment,e),h(yn.$$.fragment,e),h(Tn.$$.fragment,e),h(Mn.$$.fragment,e),h(wn.$$.fragment,e),h(vn.$$.fragment,e),h(xn.$$.fragment,e),h($n.$$.fragment,e),h(kn.$$.fragment,e),h(Jn.$$.fragment,e),h(Rn.$$.fragment,e),h(Un.$$.fragment,e),h(ft.$$.fragment,e),h(ht.$$.fragment,e),h(_t.$$.fragment,e),h(In.$$.fragment,e),h(Cn.$$.fragment,e),h(Zn.$$.fragment,e),h(bt.$$.fragment,e),h(yt.$$.fragment,e),h(Tt.$$.fragment,e),h(Wn.$$.fragment,e),h(Nn.$$.fragment,e),h(Sn.$$.fragment,e),h(Mt.$$.fragment,e),h(wt.$$.fragment,e),h(vt.$$.fragment,e),h(Fn.$$.fragment,e),h(On.$$.fragment,e),h(Gn.$$.fragment,e),h(xt.$$.fragment,e),h($t.$$.fragment,e),h(kt.$$.fragment,e),h(jt.$$.fragment,e),h(Xn.$$.fragment,e),h(Vn.$$.fragment,e),h(zn.$$.fragment,e),h(Jt.$$.fragment,e),h(Rt.$$.fragment,e),h(Ut.$$.fragment,e),h(Ln.$$.fragment,e),h(qn.$$.fragment,e),h(Bn.$$.fragment,e),h(It.$$.fragment,e),h(Ct.$$.fragment,e),h(Hn.$$.fragment,e),h(Pn.$$.fragment,e),h(En.$$.fragment,e),h(Zt.$$.fragment,e),h(Wt.$$.fragment,e),h(Nt.$$.fragment,e),h(Qn.$$.fragment,e),h(Yn.$$.fragment,e),h(An.$$.fragment,e),h(Kn.$$.fragment,e),h(St.$$.fragment,e),h(Ft.$$.fragment,e),h(Ot.$$.fragment,e),h(eo.$$.fragment,e),h(to.$$.fragment,e),h(no.$$.fragment,e),h(Gt.$$.fragment,e),h(Xt.$$.fragment,e),h(Vt.$$.fragment,e),h(oo.$$.fragment,e),h(ao.$$.fragment,e),h(lo.$$.fragment,e),h(io.$$.fragment,e),h(zt.$$.fragment,e),h(Lt.$$.fragment,e),h(qt.$$.fragment,e),h(ro.$$.fragment,e),h(po.$$.fragment,e),h(mo.$$.fragment,e),h(Bt.$$.fragment,e),h(Ht.$$.fragment,e),h(co.$$.fragment,e),h(uo.$$.fragment,e),h(go.$$.fragment,e),h(Pt.$$.fragment,e),h(Et.$$.fragment,e),h(fo.$$.fragment,e),h(ho.$$.fragment,e),h(_o.$$.fragment,e),h(Qt.$$.fragment,e),h(Dt.$$.fragment,e),h(Yt.$$.fragment,e),h(bo.$$.fragment,e),h(yo.$$.fragment,e),h(To.$$.fragment,e),h(At.$$.fragment,e),h(Kt.$$.fragment,e),h(Mo.$$.fragment,e),h(vo.$$.fragment,e),h(xo.$$.fragment,e),h($o.$$.fragment,e),h(en.$$.fragment,e),h(tn.$$.fragment,e),h(nn.$$.fragment,e),h(ko.$$.fragment,e),h(jo.$$.fragment,e),h(Jo.$$.fragment,e),h(on.$$.fragment,e),h(sn.$$.fragment,e),h(Ro.$$.fragment,e),h(Io.$$.fragment,e),h(Co.$$.fragment,e),h(Zo.$$.fragment,e),h(an.$$.fragment,e),h(ln.$$.fragment,e),h(rn.$$.fragment,e),h(Wo.$$.fragment,e),h(No.$$.fragment,e),h(So.$$.fragment,e),h(pn.$$.fragment,e),h(mn.$$.fragment,e),h(dn.$$.fragment,e),h(Fo.$$.fragment,e),h(Oo.$$.fragment,e),h(Go.$$.fragment,e),h(Xo.$$.fragment,e),h(Vo.$$.fragment,e),h(zo.$$.fragment,e),h(Lo.$$.fragment,e),h(qo.$$.fragment,e),h(Bo.$$.fragment,e),h(Ho.$$.fragment,e),h(Po.$$.fragment,e),h(Eo.$$.fragment,e),h(Qo.$$.fragment,e),h(Do.$$.fragment,e),h(Yo.$$.fragment,e),h(Ao.$$.fragment,e),h(Ko.$$.fragment,e),h(es.$$.fragment,e),h(ts.$$.fragment,e),Ti=!0)},o(e){_(y.$$.fragment,e),_(w.$$.fragment,e),_(yn.$$.fragment,e),_(Tn.$$.fragment,e),_(Mn.$$.fragment,e),_(wn.$$.fragment,e),_(vn.$$.fragment,e),_(xn.$$.fragment,e),_($n.$$.fragment,e),_(kn.$$.fragment,e),_(Jn.$$.fragment,e),_(Rn.$$.fragment,e),_(Un.$$.fragment,e),_(ft.$$.fragment,e),_(ht.$$.fragment,e),_(_t.$$.fragment,e),_(In.$$.fragment,e),_(Cn.$$.fragment,e),_(Zn.$$.fragment,e),_(bt.$$.fragment,e),_(yt.$$.fragment,e),_(Tt.$$.fragment,e),_(Wn.$$.fragment,e),_(Nn.$$.fragment,e),_(Sn.$$.fragment,e),_(Mt.$$.fragment,e),_(wt.$$.fragment,e),_(vt.$$.fragment,e),_(Fn.$$.fragment,e),_(On.$$.fragment,e),_(Gn.$$.fragment,e),_(xt.$$.fragment,e),_($t.$$.fragment,e),_(kt.$$.fragment,e),_(jt.$$.fragment,e),_(Xn.$$.fragment,e),_(Vn.$$.fragment,e),_(zn.$$.fragment,e),_(Jt.$$.fragment,e),_(Rt.$$.fragment,e),_(Ut.$$.fragment,e),_(Ln.$$.fragment,e),_(qn.$$.fragment,e),_(Bn.$$.fragment,e),_(It.$$.fragment,e),_(Ct.$$.fragment,e),_(Hn.$$.fragment,e),_(Pn.$$.fragment,e),_(En.$$.fragment,e),_(Zt.$$.fragment,e),_(Wt.$$.fragment,e),_(Nt.$$.fragment,e),_(Qn.$$.fragment,e),_(Yn.$$.fragment,e),_(An.$$.fragment,e),_(Kn.$$.fragment,e),_(St.$$.fragment,e),_(Ft.$$.fragment,e),_(Ot.$$.fragment,e),_(eo.$$.fragment,e),_(to.$$.fragment,e),_(no.$$.fragment,e),_(Gt.$$.fragment,e),_(Xt.$$.fragment,e),_(Vt.$$.fragment,e),_(oo.$$.fragment,e),_(ao.$$.fragment,e),_(lo.$$.fragment,e),_(io.$$.fragment,e),_(zt.$$.fragment,e),_(Lt.$$.fragment,e),_(qt.$$.fragment,e),_(ro.$$.fragment,e),_(po.$$.fragment,e),_(mo.$$.fragment,e),_(Bt.$$.fragment,e),_(Ht.$$.fragment,e),_(co.$$.fragment,e),_(uo.$$.fragment,e),_(go.$$.fragment,e),_(Pt.$$.fragment,e),_(Et.$$.fragment,e),_(fo.$$.fragment,e),_(ho.$$.fragment,e),_(_o.$$.fragment,e),_(Qt.$$.fragment,e),_(Dt.$$.fragment,e),_(Yt.$$.fragment,e),_(bo.$$.fragment,e),_(yo.$$.fragment,e),_(To.$$.fragment,e),_(At.$$.fragment,e),_(Kt.$$.fragment,e),_(Mo.$$.fragment,e),_(vo.$$.fragment,e),_(xo.$$.fragment,e),_($o.$$.fragment,e),_(en.$$.fragment,e),_(tn.$$.fragment,e),_(nn.$$.fragment,e),_(ko.$$.fragment,e),_(jo.$$.fragment,e),_(Jo.$$.fragment,e),_(on.$$.fragment,e),_(sn.$$.fragment,e),_(Ro.$$.fragment,e),_(Io.$$.fragment,e),_(Co.$$.fragment,e),_(Zo.$$.fragment,e),_(an.$$.fragment,e),_(ln.$$.fragment,e),_(rn.$$.fragment,e),_(Wo.$$.fragment,e),_(No.$$.fragment,e),_(So.$$.fragment,e),_(pn.$$.fragment,e),_(mn.$$.fragment,e),_(dn.$$.fragment,e),_(Fo.$$.fragment,e),_(Oo.$$.fragment,e),_(Go.$$.fragment,e),_(Xo.$$.fragment,e),_(Vo.$$.fragment,e),_(zo.$$.fragment,e),_(Lo.$$.fragment,e),_(qo.$$.fragment,e),_(Bo.$$.fragment,e),_(Ho.$$.fragment,e),_(Po.$$.fragment,e),_(Eo.$$.fragment,e),_(Qo.$$.fragment,e),_(Do.$$.fragment,e),_(Yo.$$.fragment,e),_(Ao.$$.fragment,e),_(Ko.$$.fragment,e),_(es.$$.fragment,e),_(ts.$$.fragment,e),Ti=!1},d(e){e&&(r(M),r(i),r(s),r(t),r(dl),r(bn),r(cl),r(ul),r(I),r(gl),r(fl),r(jn),r(hl),r(_l),r(N),r(bl),r(yl),r(S),r(Tl),r(Ml),r(F),r(wl),r(vl),r(O),r(xl),r($l),r(G),r(kl),r(jl),r(X),r(Jl),r(Rl),r(V),r(Ul),r(Il),r(Dn),r(Cl),r(Zl),r(z),r(Wl),r(Nl),r(L),r(Sl),r(Fl),r(so),r(Ol),r(Gl),r(q),r(Xl),r(Vl),r(B),r(zl),r(Ll),r(H),r(ql),r(Bl),r(P),r(Hl),r(Pl),r(E),r(El),r(Ql),r(wo),r(Dl),r(Yl),r(Q),r(Al),r(Kl),r(D),r(ei),r(ti),r(Uo),r(ni),r(oi),r(Y),r(si),r(ai),r(A),r(li),r(ii),r(ri),r(K),r(pi),r(mi),r(ee),r(di),r(ci),r(te),r(ui),r(gi),r(ne),r(fi),r(hi),r(oe),r(_i),r(bi),r(se),r(yi),r(ml)),r(n),b(y,e),b(w,e),b(yn,e),b(Tn),b(Mn),b(wn),b(vn),b(xn),b($n),b(kn,e),b(Jn,e),b(Rn),b(Un),b(ft),b(ht),b(_t),b(In,e),b(Cn),b(Zn),b(bt),b(yt),b(Tt),b(Wn,e),b(Nn),b(Sn),b(Mt),b(wt),b(vt),b(Fn,e),b(On),b(Gn),b(xt),b($t),b(kt),b(jt),b(Xn,e),b(Vn),b(zn),b(Jt),b(Rt),b(Ut),b(Ln,e),b(qn),b(Bn),b(It),b(Ct),b(Hn,e),b(Pn),b(En),b(Zt),b(Wt),b(Nt),b(Qn,e),b(Yn,e),b(An),b(Kn),b(St),b(Ft),b(Ot),b(eo,e),b(to),b(no),b(Gt),b(Xt),b(Vt),b(oo,e),b(ao,e),b(lo),b(io),b(zt),b(Lt),b(qt),b(ro,e),b(po),b(mo),b(Bt),b(Ht),b(co,e),b(uo),b(go),b(Pt),b(Et),b(fo,e),b(ho),b(_o),b(Qt),b(Dt),b(Yt),b(bo,e),b(yo),b(To),b(At),b(Kt),b(Mo,e),b(vo,e),b(xo),b($o),b(en),b(tn),b(nn),b(ko,e),b(jo),b(Jo),b(on),b(sn),b(Ro,e),b(Io,e),b(Co),b(Zo),b(an),b(ln),b(rn),b(Wo,e),b(No),b(So),b(pn),b(mn),b(dn),b(Fo,e),b(Oo,e),b(Go),b(Xo),b(Vo,e),b(zo),b(Lo),b(qo,e),b(Bo),b(Ho),b(Po,e),b(Eo),b(Qo),b(Do,e),b(Yo),b(Ao),b(Ko,e),b(es),b(ts)}}}const eg='{"title":"Models","local":"models","sections":[{"title":"Generic model classes","local":"generic-model-classes","sections":[{"title":"ORTModel","local":"optimum.onnxruntime.ORTModel","sections":[],"depth":3}],"depth":2},{"title":"Natural Language Processing","local":"natural-language-processing","sections":[{"title":"ORTModelForCausalLM","local":"optimum.onnxruntime.ORTModelForCausalLM","sections":[],"depth":3},{"title":"ORTModelForMaskedLM","local":"optimum.onnxruntime.ORTModelForMaskedLM","sections":[],"depth":3},{"title":"ORTModelForSeq2SeqLM","local":"optimum.onnxruntime.ORTModelForSeq2SeqLM","sections":[],"depth":3},{"title":"ORTModelForSequenceClassification","local":"optimum.onnxruntime.ORTModelForSequenceClassification","sections":[],"depth":3},{"title":"ORTModelForTokenClassification","local":"optimum.onnxruntime.ORTModelForTokenClassification","sections":[],"depth":3},{"title":"ORTModelForMultipleChoice","local":"optimum.onnxruntime.ORTModelForMultipleChoice","sections":[],"depth":3},{"title":"ORTModelForQuestionAnswering","local":"optimum.onnxruntime.ORTModelForQuestionAnswering","sections":[],"depth":3}],"depth":2},{"title":"Computer vision","local":"computer-vision","sections":[{"title":"ORTModelForImageClassification","local":"optimum.onnxruntime.ORTModelForImageClassification","sections":[],"depth":3},{"title":"ORTModelForSemanticSegmentation","local":"optimum.onnxruntime.ORTModelForSemanticSegmentation","sections":[],"depth":3}],"depth":2},{"title":"Audio","local":"audio","sections":[{"title":"ORTModelForAudioClassification","local":"optimum.onnxruntime.ORTModelForAudioClassification","sections":[],"depth":3},{"title":"ORTModelForAudioFrameClassification","local":"optimum.onnxruntime.ORTModelForAudioFrameClassification","sections":[],"depth":3},{"title":"ORTModelForCTC","local":"optimum.onnxruntime.ORTModelForCTC","sections":[],"depth":3},{"title":"ORTModelForSpeechSeq2Seq","local":"optimum.onnxruntime.ORTModelForSpeechSeq2Seq","sections":[],"depth":3},{"title":"ORTModelForAudioXVector","local":"optimum.onnxruntime.ORTModelForAudioXVector","sections":[],"depth":3}],"depth":2},{"title":"Multimodal","local":"multimodal","sections":[{"title":"ORTModelForVision2Seq","local":"optimum.onnxruntime.ORTModelForVision2Seq","sections":[],"depth":3},{"title":"ORTModelForPix2Struct","local":"optimum.onnxruntime.ORTModelForPix2Struct","sections":[],"depth":3}],"depth":2},{"title":"Custom Tasks","local":"custom-tasks","sections":[{"title":"ORTModelForCustomTasks","local":"optimum.onnxruntime.ORTModelForCustomTasks","sections":[],"depth":4},{"title":"ORTModelForFeatureExtraction","local":"optimum.onnxruntime.ORTModelForFeatureExtraction","sections":[],"depth":4}],"depth":2},{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"ORTStableDiffusionPipeline","local":"optimum.onnxruntime.ORTStableDiffusionPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionImg2ImgPipeline","local":"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionInpaintPipeline","local":"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionXLPipeline","local":"optimum.onnxruntime.ORTStableDiffusionXLPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionXLImg2ImgPipeline","local":"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline","sections":[],"depth":4},{"title":"ORTLatentConsistencyModelPipeline","local":"optimum.onnxruntime.ORTLatentConsistencyModelPipeline","sections":[],"depth":4}],"depth":2}],"depth":1}';function tg(v){return Kc(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pg extends eu{constructor(n){super(),tu(this,n,tg,Ku,Ac,{})}}export{pg as component};
