import{s as Te,n as xe,o as He}from"../chunks/scheduler.85c25b89.js";import{S as ye,i as je,g as i,s as a,r as m,A as ve,h as o,f as l,c as s,j as Me,u as p,x as h,k as _e,y as ke,a as n,v as r,d,t as g,w as u}from"../chunks/index.c9bcf812.js";import{C as V}from"../chunks/CodeBlock.94efc595.js";import{H as me}from"../chunks/Heading.3c6e5b17.js";function Je(pe){let f,F,P,U,c,I,$,he="The <code>timm</code> library has a built-in integration with the Hugging Face Hub, making it easy to share and load models from the 🤗 Hub.",R,b,re="In this short guide, we’ll see how to:",B,w,de="<li>Share a <code>timm</code> model on the Hub</li> <li>How to load that model back from the Hub</li>",N,M,E,_,ge="First, you’ll need to make sure you have the <code>huggingface_hub</code> package installed.",Q,T,X,x,ue="Then, you’ll need to authenticate yourself. You can do this by running the following command:",A,H,z,y,fe="Or, if you’re using a notebook, you can use the <code>notebook_login</code> helper:",D,j,q,v,K,k,O,J,ce="Here is where you would normally train or fine-tune the model. We’ll skip that for the sake of this tutorial.",ee,Z,$e="Let’s pretend we’ve now fine-tuned the model. The next step would be to push it to the Hub! We can do this with the <code>timm.models.hub.push_to_hf_hub</code> function.",te,L,le,C,be="Running the above would push the model to <code>&lt;your-username&gt;/resnet18-random</code> on the Hub. You can now share this model with your friends, or use it in your own code!",ne,W,ae,G,we='Loading a model from the Hub is as simple as calling <code>timm.create_model</code> with the <code>pretrained</code> argument set to the name of the model you want to load. In this case, we’ll use <a href="https://huggingface.co/nateraw/resnet18-random" rel="nofollow"><code>nateraw/resnet18-random</code></a>, which is the model we just pushed to the Hub.',se,S,ie,Y,oe;return c=new me({props:{title:"Sharing and Loading Models From the Hugging Face Hub",local:"sharing-and-loading-models-from-the-hugging-face-hub",headingTag:"h1"}}),M=new me({props:{title:"Authenticating",local:"authenticating",headingTag:"h2"}}),T=new V({props:{code:"cGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX2h1Yg==",highlighted:"pip install huggingface_hub",wrap:!1}}),H=new V({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),j=new V({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login
<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),v=new me({props:{title:"Sharing a Model",local:"sharing-a-model",headingTag:"h2"}}),k=new V({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3Jlc25ldDE4JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0Q0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-number">4</span>)`,wrap:!1}}),L=new V({props:{code:"bW9kZWxfY2ZnJTIwJTNEJTIwZGljdChsYWJlbHMlM0QlNUInYSclMkMlMjAnYiclMkMlMjAnYyclMkMlMjAnZCclNUQpJTBBdGltbS5tb2RlbHMuaHViLnB1c2hfdG9faGZfaHViKG1vZGVsJTJDJTIwJ3Jlc25ldDE4LXJhbmRvbSclMkMlMjBtb2RlbF9jb25maWclM0Rtb2RlbF9jZmcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model_cfg = <span class="hljs-built_in">dict</span>(labels=[<span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>timm.models.hub.push_to_hf_hub(model, <span class="hljs-string">&#x27;resnet18-random&#x27;</span>, model_config=model_cfg)`,wrap:!1}}),W=new me({props:{title:"Loading a Model",local:"loading-a-model",headingTag:"h2"}}),S=new V({props:{code:"bW9kZWxfcmVsb2FkZWQlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnaGZfaHViJTNBbmF0ZXJhdyUyRnJlc25ldDE4LXJhbmRvbSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model_reloaded = timm.create_model(<span class="hljs-string">&#x27;hf_hub:nateraw/resnet18-random&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)',wrap:!1}}),{c(){f=i("meta"),F=a(),P=i("p"),U=a(),m(c.$$.fragment),I=a(),$=i("p"),$.innerHTML=he,R=a(),b=i("p"),b.textContent=re,B=a(),w=i("ol"),w.innerHTML=de,N=a(),m(M.$$.fragment),E=a(),_=i("p"),_.innerHTML=ge,Q=a(),m(T.$$.fragment),X=a(),x=i("p"),x.textContent=ue,A=a(),m(H.$$.fragment),z=a(),y=i("p"),y.innerHTML=fe,D=a(),m(j.$$.fragment),q=a(),m(v.$$.fragment),K=a(),m(k.$$.fragment),O=a(),J=i("p"),J.textContent=ce,ee=a(),Z=i("p"),Z.innerHTML=$e,te=a(),m(L.$$.fragment),le=a(),C=i("p"),C.innerHTML=be,ne=a(),m(W.$$.fragment),ae=a(),G=i("p"),G.innerHTML=we,se=a(),m(S.$$.fragment),ie=a(),Y=i("p"),this.h()},l(e){const t=ve("svelte-u9bgzb",document.head);f=o(t,"META",{name:!0,content:!0}),t.forEach(l),F=s(e),P=o(e,"P",{}),Me(P).forEach(l),U=s(e),p(c.$$.fragment,e),I=s(e),$=o(e,"P",{"data-svelte-h":!0}),h($)!=="svelte-1lmv8hz"&&($.innerHTML=he),R=s(e),b=o(e,"P",{"data-svelte-h":!0}),h(b)!=="svelte-11r33nm"&&(b.textContent=re),B=s(e),w=o(e,"OL",{"data-svelte-h":!0}),h(w)!=="svelte-1t5ulh6"&&(w.innerHTML=de),N=s(e),p(M.$$.fragment,e),E=s(e),_=o(e,"P",{"data-svelte-h":!0}),h(_)!=="svelte-18o00ln"&&(_.innerHTML=ge),Q=s(e),p(T.$$.fragment,e),X=s(e),x=o(e,"P",{"data-svelte-h":!0}),h(x)!=="svelte-1dqusp5"&&(x.textContent=ue),A=s(e),p(H.$$.fragment,e),z=s(e),y=o(e,"P",{"data-svelte-h":!0}),h(y)!=="svelte-yj2stu"&&(y.innerHTML=fe),D=s(e),p(j.$$.fragment,e),q=s(e),p(v.$$.fragment,e),K=s(e),p(k.$$.fragment,e),O=s(e),J=o(e,"P",{"data-svelte-h":!0}),h(J)!=="svelte-1d50rfn"&&(J.textContent=ce),ee=s(e),Z=o(e,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-jqz7ws"&&(Z.innerHTML=$e),te=s(e),p(L.$$.fragment,e),le=s(e),C=o(e,"P",{"data-svelte-h":!0}),h(C)!=="svelte-jnvz89"&&(C.innerHTML=be),ne=s(e),p(W.$$.fragment,e),ae=s(e),G=o(e,"P",{"data-svelte-h":!0}),h(G)!=="svelte-kug5in"&&(G.innerHTML=we),se=s(e),p(S.$$.fragment,e),ie=s(e),Y=o(e,"P",{}),Me(Y).forEach(l),this.h()},h(){_e(f,"name","hf:doc:metadata"),_e(f,"content",Ze)},m(e,t){ke(document.head,f),n(e,F,t),n(e,P,t),n(e,U,t),r(c,e,t),n(e,I,t),n(e,$,t),n(e,R,t),n(e,b,t),n(e,B,t),n(e,w,t),n(e,N,t),r(M,e,t),n(e,E,t),n(e,_,t),n(e,Q,t),r(T,e,t),n(e,X,t),n(e,x,t),n(e,A,t),r(H,e,t),n(e,z,t),n(e,y,t),n(e,D,t),r(j,e,t),n(e,q,t),r(v,e,t),n(e,K,t),r(k,e,t),n(e,O,t),n(e,J,t),n(e,ee,t),n(e,Z,t),n(e,te,t),r(L,e,t),n(e,le,t),n(e,C,t),n(e,ne,t),r(W,e,t),n(e,ae,t),n(e,G,t),n(e,se,t),r(S,e,t),n(e,ie,t),n(e,Y,t),oe=!0},p:xe,i(e){oe||(d(c.$$.fragment,e),d(M.$$.fragment,e),d(T.$$.fragment,e),d(H.$$.fragment,e),d(j.$$.fragment,e),d(v.$$.fragment,e),d(k.$$.fragment,e),d(L.$$.fragment,e),d(W.$$.fragment,e),d(S.$$.fragment,e),oe=!0)},o(e){g(c.$$.fragment,e),g(M.$$.fragment,e),g(T.$$.fragment,e),g(H.$$.fragment,e),g(j.$$.fragment,e),g(v.$$.fragment,e),g(k.$$.fragment,e),g(L.$$.fragment,e),g(W.$$.fragment,e),g(S.$$.fragment,e),oe=!1},d(e){e&&(l(F),l(P),l(U),l(I),l($),l(R),l(b),l(B),l(w),l(N),l(E),l(_),l(Q),l(X),l(x),l(A),l(z),l(y),l(D),l(q),l(K),l(O),l(J),l(ee),l(Z),l(te),l(le),l(C),l(ne),l(ae),l(G),l(se),l(ie),l(Y)),l(f),u(c,e),u(M,e),u(T,e),u(H,e),u(j,e),u(v,e),u(k,e),u(L,e),u(W,e),u(S,e)}}}const Ze='{"title":"Sharing and Loading Models From the Hugging Face Hub","local":"sharing-and-loading-models-from-the-hugging-face-hub","sections":[{"title":"Authenticating","local":"authenticating","sections":[],"depth":2},{"title":"Sharing a Model","local":"sharing-a-model","sections":[],"depth":2},{"title":"Loading a Model","local":"loading-a-model","sections":[],"depth":2}],"depth":1}';function Le(pe){return He(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ve extends ye{constructor(f){super(),je(this,f,Le,Je,Te,{})}}export{Ve as component};
