import{s as Us,n as Zs,o as $s}from"../chunks/scheduler.85c25b89.js";import{S as Cs,i as ks,g as p,s as e,r as i,A as Is,h as m,f as l,c as n,j as Ts,u as o,x as j,k as bs,y as Ws,a,v as c,d as r,t as h,w as M}from"../chunks/index.c9bcf812.js";import{C as Q}from"../chunks/CodeBlock.94efc595.js";import{H as V}from"../chunks/Heading.3c6e5b17.js";function Gs(rs){let g,R,X,Y,y,_,d,hs="<strong>NASNet</strong> is a type of convolutional neural network discovered through neural architecture search. The building blocks consist of normal and reduction cells.",S,J,z,w,Ms="To load a pretrained model:",F,u,H,f,js="To load and preprocess the image:",L,T,q,b,gs="To get the model predictions:",D,U,P,Z,ys="To get the top-5 predictions class names:",K,$,O,C,ds="Replace the model name with the variant you want to use, e.g. <code>nasnetalarge</code>. You can find the IDs in the model summaries at the top of this page.",ss,k,Js='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ts,I,ls,W,ws="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",as,G,es,N,us=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ns,x,ps,B,fs='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',ms,v,is,E,os,A,cs;return y=new V({props:{title:"NASNet",local:"nasnet",headingTag:"h1"}}),J=new V({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new Q({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ25hc25ldGFsYXJnZSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;nasnetalarge&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),T=new Q({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),$=new Q({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),I=new V({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),G=new Q({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbmFzbmV0YWxhcmdlJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;nasnetalarge&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),x=new V({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),v=new V({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new Q({props:{code:"JTQwbWlzYyU3QnpvcGgyMDE4bGVhcm5pbmclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QkxlYXJuaW5nJTIwVHJhbnNmZXJhYmxlJTIwQXJjaGl0ZWN0dXJlcyUyMGZvciUyMFNjYWxhYmxlJTIwSW1hZ2UlMjBSZWNvZ25pdGlvbiU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QkJhcnJldCUyMFpvcGglMjBhbmQlMjBWaWpheSUyMFZhc3VkZXZhbiUyMGFuZCUyMEpvbmF0aG9uJTIwU2hsZW5zJTIwYW5kJTIwUXVvYyUyMFYuJTIwTGUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE3MDcuMDcwMTIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`@misc{zoph2018learning,
      title={Learning Transferable Architectures for <span class="hljs-keyword">Scalable </span>Image Recognition}, 
      author={<span class="hljs-keyword">Barret </span>Zoph <span class="hljs-keyword">and </span>Vijay Vasudevan <span class="hljs-keyword">and </span><span class="hljs-keyword">Jonathon </span><span class="hljs-keyword">Shlens </span><span class="hljs-keyword">and </span>Quoc V. Le},
      year={<span class="hljs-number">2018</span>},
      eprint={<span class="hljs-number">1707</span>.<span class="hljs-number">07012</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),{c(){g=p("meta"),R=e(),X=p("p"),Y=e(),i(y.$$.fragment),_=e(),d=p("p"),d.innerHTML=hs,S=e(),i(J.$$.fragment),z=e(),w=p("p"),w.textContent=Ms,F=e(),i(u.$$.fragment),H=e(),f=p("p"),f.textContent=js,L=e(),i(T.$$.fragment),q=e(),b=p("p"),b.textContent=gs,D=e(),i(U.$$.fragment),P=e(),Z=p("p"),Z.textContent=ys,K=e(),i($.$$.fragment),O=e(),C=p("p"),C.innerHTML=ds,ss=e(),k=p("p"),k.innerHTML=Js,ts=e(),i(I.$$.fragment),ls=e(),W=p("p"),W.textContent=ws,as=e(),i(G.$$.fragment),es=e(),N=p("p"),N.innerHTML=us,ns=e(),i(x.$$.fragment),ps=e(),B=p("p"),B.innerHTML=fs,ms=e(),i(v.$$.fragment),is=e(),i(E.$$.fragment),os=e(),A=p("p"),this.h()},l(s){const t=Is("svelte-u9bgzb",document.head);g=m(t,"META",{name:!0,content:!0}),t.forEach(l),R=n(s),X=m(s,"P",{}),Ts(X).forEach(l),Y=n(s),o(y.$$.fragment,s),_=n(s),d=m(s,"P",{"data-svelte-h":!0}),j(d)!=="svelte-1u56z5m"&&(d.innerHTML=hs),S=n(s),o(J.$$.fragment,s),z=n(s),w=m(s,"P",{"data-svelte-h":!0}),j(w)!=="svelte-18ywhxh"&&(w.textContent=Ms),F=n(s),o(u.$$.fragment,s),H=n(s),f=m(s,"P",{"data-svelte-h":!0}),j(f)!=="svelte-1c2ipa8"&&(f.textContent=js),L=n(s),o(T.$$.fragment,s),q=n(s),b=m(s,"P",{"data-svelte-h":!0}),j(b)!=="svelte-1n9qsq1"&&(b.textContent=gs),D=n(s),o(U.$$.fragment,s),P=n(s),Z=m(s,"P",{"data-svelte-h":!0}),j(Z)!=="svelte-19cnvx1"&&(Z.textContent=ys),K=n(s),o($.$$.fragment,s),O=n(s),C=m(s,"P",{"data-svelte-h":!0}),j(C)!=="svelte-qu63rt"&&(C.innerHTML=ds),ss=n(s),k=m(s,"P",{"data-svelte-h":!0}),j(k)!=="svelte-1wmi3ea"&&(k.innerHTML=Js),ts=n(s),o(I.$$.fragment,s),ls=n(s),W=m(s,"P",{"data-svelte-h":!0}),j(W)!=="svelte-9sr7nh"&&(W.textContent=ws),as=n(s),o(G.$$.fragment,s),es=n(s),N=m(s,"P",{"data-svelte-h":!0}),j(N)!=="svelte-1kguc51"&&(N.innerHTML=us),ns=n(s),o(x.$$.fragment,s),ps=n(s),B=m(s,"P",{"data-svelte-h":!0}),j(B)!=="svelte-1n0coha"&&(B.innerHTML=fs),ms=n(s),o(v.$$.fragment,s),is=n(s),o(E.$$.fragment,s),os=n(s),A=m(s,"P",{}),Ts(A).forEach(l),this.h()},h(){bs(g,"name","hf:doc:metadata"),bs(g,"content",Ns)},m(s,t){Ws(document.head,g),a(s,R,t),a(s,X,t),a(s,Y,t),c(y,s,t),a(s,_,t),a(s,d,t),a(s,S,t),c(J,s,t),a(s,z,t),a(s,w,t),a(s,F,t),c(u,s,t),a(s,H,t),a(s,f,t),a(s,L,t),c(T,s,t),a(s,q,t),a(s,b,t),a(s,D,t),c(U,s,t),a(s,P,t),a(s,Z,t),a(s,K,t),c($,s,t),a(s,O,t),a(s,C,t),a(s,ss,t),a(s,k,t),a(s,ts,t),c(I,s,t),a(s,ls,t),a(s,W,t),a(s,as,t),c(G,s,t),a(s,es,t),a(s,N,t),a(s,ns,t),c(x,s,t),a(s,ps,t),a(s,B,t),a(s,ms,t),c(v,s,t),a(s,is,t),c(E,s,t),a(s,os,t),a(s,A,t),cs=!0},p:Zs,i(s){cs||(r(y.$$.fragment,s),r(J.$$.fragment,s),r(u.$$.fragment,s),r(T.$$.fragment,s),r(U.$$.fragment,s),r($.$$.fragment,s),r(I.$$.fragment,s),r(G.$$.fragment,s),r(x.$$.fragment,s),r(v.$$.fragment,s),r(E.$$.fragment,s),cs=!0)},o(s){h(y.$$.fragment,s),h(J.$$.fragment,s),h(u.$$.fragment,s),h(T.$$.fragment,s),h(U.$$.fragment,s),h($.$$.fragment,s),h(I.$$.fragment,s),h(G.$$.fragment,s),h(x.$$.fragment,s),h(v.$$.fragment,s),h(E.$$.fragment,s),cs=!1},d(s){s&&(l(R),l(X),l(Y),l(_),l(d),l(S),l(z),l(w),l(F),l(H),l(f),l(L),l(q),l(b),l(D),l(P),l(Z),l(K),l(O),l(C),l(ss),l(k),l(ts),l(ls),l(W),l(as),l(es),l(N),l(ns),l(ps),l(B),l(ms),l(is),l(os),l(A)),l(g),M(y,s),M(J,s),M(u,s),M(T,s),M(U,s),M($,s),M(I,s),M(G,s),M(x,s),M(v,s),M(E,s)}}}const Ns='{"title":"NASNet","local":"nasnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function xs(rs){return $s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xs extends Cs{constructor(g){super(),ks(this,g,xs,Gs,Us,{})}}export{Xs as component};
