import{s as St,n as zt,o as Ft}from"../chunks/scheduler.85c25b89.js";import{S as At,i as Lt,g as p,s as l,r,m as S,H as Ut,A as Dt,h as i,f as a,c as n,j as kt,u as h,x as c,n as z,B as xt,k as Vt,y as J,a as e,v as g,d,t as w,w as M}from"../chunks/index.c9837788.js";import{C as X}from"../chunks/CodeBlock.52fa569e.js";import{H as F}from"../chunks/Heading.3097d2ed.js";function qt(Zt){let u,A,Y,L,j,D,o,Q,$t="HRNet",ft,V,Ct="High-Resolution Net",It,q,Xt='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>n</mi></mrow><annotation encoding="application/x-tex"> n </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.4306em;"></span><span class="mord mathnormal">n</span></span></span></span>',P,K,Yt='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>n</mi></mrow><annotation encoding="application/x-tex"> n </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.4306em;"></span><span class="mord mathnormal">n</span></span></span></span>',O,tt,Ht='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>n</mi></mrow><annotation encoding="application/x-tex"> n </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.4306em;"></span><span class="mord mathnormal">n</span></span></span></span>',st,at,y,et,T,Wt="To load a pretrained model:",lt,b,nt,f,Bt="To load and preprocess the image:",ot,I,pt,U,vt="To get the model predictions:",it,k,mt,x,Gt="To get the top-5 predictions class names:",rt,Z,ht,$,Nt="Replace the model name with the variant you want to use, e.g. <code>hrnet_w18</code>. You can find the IDs in the model summaries at the top of this page.",ct,C,_t='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',gt,W,dt,B,Et="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",wt,v,Mt,G,Rt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ut,N,Jt,_,Qt='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',jt,E,yt,R,Tt,H,bt;return j=new F({props:{title:"HRNet",local:"hrnet",headingTag:"h1"}}),y=new F({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),b=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2hybmV0X3cxOCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;hrnet_w18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),I=new X({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),k=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new X({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new F({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),v=new X({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnaHJuZXRfdzE4JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;hrnet_w18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),N=new F({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new F({props:{title:"Citation",local:"citation",headingTag:"h2"}}),R=new X({props:{code:"JTQwbWlzYyU3QnN1bjIwMTloaWdocmVzb2x1dGlvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCSGlnaC1SZXNvbHV0aW9uJTIwUmVwcmVzZW50YXRpb25zJTIwZm9yJTIwTGFiZWxpbmclMjBQaXhlbHMlMjBhbmQlMjBSZWdpb25zJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCS2UlMjBTdW4lMjBhbmQlMjBZYW5nJTIwWmhhbyUyMGFuZCUyMEJvcnVpJTIwSmlhbmclMjBhbmQlMjBUaWFuaGVuZyUyMENoZW5nJTIwYW5kJTIwQmluJTIwWGlhbyUyMGFuZCUyMERvbmclMjBMaXUlMjBhbmQlMjBZYWRvbmclMjBNdSUyMGFuZCUyMFhpbmdnYW5nJTIwV2FuZyUyMGFuZCUyMFdlbnl1JTIwTGl1JTIwYW5kJTIwSmluZ2RvbmclMjBXYW5nJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTA0LjA0NTE0JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`@misc{sun2019highresolution,
      title={High-Resolution Representations for Labeling Pixels <span class="hljs-keyword">and </span>Regions},
      author={Ke Sun <span class="hljs-keyword">and </span>Yang Zhao <span class="hljs-keyword">and </span><span class="hljs-keyword">Borui </span><span class="hljs-keyword">Jiang </span><span class="hljs-keyword">and </span>Tianheng Cheng <span class="hljs-keyword">and </span><span class="hljs-keyword">Bin </span>Xiao <span class="hljs-keyword">and </span>Dong Liu <span class="hljs-keyword">and </span>Yadong Mu <span class="hljs-keyword">and </span>Xinggang Wang <span class="hljs-keyword">and </span>Wenyu Liu <span class="hljs-keyword">and </span><span class="hljs-keyword">Jingdong </span>Wang},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1904</span>.<span class="hljs-number">04514</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),{c(){u=p("meta"),A=l(),Y=p("p"),L=l(),r(j.$$.fragment),D=l(),o=p("p"),Q=p("strong"),Q.textContent=$t,ft=S(", or "),V=p("strong"),V.textContent=Ct,It=S(", is a general purpose convolutional neural network for tasks like semantic segmentation, object detection and image classification. It is able to maintain high resolution representations through the whole process. We start from a high-resolution convolution stream, gradually add high-to-low resolution convolution streams one by one, and connect the multi-resolution streams in parallel. The resulting network consists of several (\\( 4 \\) in the paper) stages and the"),q=new Ut(!1),P=S("th stage contains"),K=new Ut(!1),O=S(" streams corresponding to"),tt=new Ut(!1),st=S(" resolutions. The authors conduct repeated multi-resolution fusions by exchanging the information across the parallel streams over and over."),at=l(),r(y.$$.fragment),et=l(),T=p("p"),T.textContent=Wt,lt=l(),r(b.$$.fragment),nt=l(),f=p("p"),f.textContent=Bt,ot=l(),r(I.$$.fragment),pt=l(),U=p("p"),U.textContent=vt,it=l(),r(k.$$.fragment),mt=l(),x=p("p"),x.textContent=Gt,rt=l(),r(Z.$$.fragment),ht=l(),$=p("p"),$.innerHTML=Nt,ct=l(),C=p("p"),C.innerHTML=_t,gt=l(),r(W.$$.fragment),dt=l(),B=p("p"),B.textContent=Et,wt=l(),r(v.$$.fragment),Mt=l(),G=p("p"),G.innerHTML=Rt,ut=l(),r(N.$$.fragment),Jt=l(),_=p("p"),_.innerHTML=Qt,jt=l(),r(E.$$.fragment),yt=l(),r(R.$$.fragment),Tt=l(),H=p("p"),this.h()},l(t){const s=Dt("svelte-u9bgzb",document.head);u=i(s,"META",{name:!0,content:!0}),s.forEach(a),A=n(t),Y=i(t,"P",{}),kt(Y).forEach(a),L=n(t),h(j.$$.fragment,t),D=n(t),o=i(t,"P",{});var m=kt(o);Q=i(m,"STRONG",{"data-svelte-h":!0}),c(Q)!=="svelte-xrpqk9"&&(Q.textContent=$t),ft=z(m,", or "),V=i(m,"STRONG",{"data-svelte-h":!0}),c(V)!=="svelte-1tonmeo"&&(V.textContent=Ct),It=z(m,", is a general purpose convolutional neural network for tasks like semantic segmentation, object detection and image classification. It is able to maintain high resolution representations through the whole process. We start from a high-resolution convolution stream, gradually add high-to-low resolution convolution streams one by one, and connect the multi-resolution streams in parallel. The resulting network consists of several (\\( 4 \\) in the paper) stages and the"),q=xt(m,!1),P=z(m,"th stage contains"),K=xt(m,!1),O=z(m," streams corresponding to"),tt=xt(m,!1),st=z(m," resolutions. The authors conduct repeated multi-resolution fusions by exchanging the information across the parallel streams over and over."),m.forEach(a),at=n(t),h(y.$$.fragment,t),et=n(t),T=i(t,"P",{"data-svelte-h":!0}),c(T)!=="svelte-18ywhxh"&&(T.textContent=Wt),lt=n(t),h(b.$$.fragment,t),nt=n(t),f=i(t,"P",{"data-svelte-h":!0}),c(f)!=="svelte-1c2ipa8"&&(f.textContent=Bt),ot=n(t),h(I.$$.fragment,t),pt=n(t),U=i(t,"P",{"data-svelte-h":!0}),c(U)!=="svelte-1n9qsq1"&&(U.textContent=vt),it=n(t),h(k.$$.fragment,t),mt=n(t),x=i(t,"P",{"data-svelte-h":!0}),c(x)!=="svelte-19cnvx1"&&(x.textContent=Gt),rt=n(t),h(Z.$$.fragment,t),ht=n(t),$=i(t,"P",{"data-svelte-h":!0}),c($)!=="svelte-17maku0"&&($.innerHTML=Nt),ct=n(t),C=i(t,"P",{"data-svelte-h":!0}),c(C)!=="svelte-1wmi3ea"&&(C.innerHTML=_t),gt=n(t),h(W.$$.fragment,t),dt=n(t),B=i(t,"P",{"data-svelte-h":!0}),c(B)!=="svelte-9sr7nh"&&(B.textContent=Et),wt=n(t),h(v.$$.fragment,t),Mt=n(t),G=i(t,"P",{"data-svelte-h":!0}),c(G)!=="svelte-1kguc51"&&(G.innerHTML=Rt),ut=n(t),h(N.$$.fragment,t),Jt=n(t),_=i(t,"P",{"data-svelte-h":!0}),c(_)!=="svelte-1n0coha"&&(_.innerHTML=Qt),jt=n(t),h(E.$$.fragment,t),yt=n(t),h(R.$$.fragment,t),Tt=n(t),H=i(t,"P",{}),kt(H).forEach(a),this.h()},h(){Vt(u,"name","hf:doc:metadata"),Vt(u,"content",Pt),q.a=P,K.a=O,tt.a=st},m(t,s){J(document.head,u),e(t,A,s),e(t,Y,s),e(t,L,s),g(j,t,s),e(t,D,s),e(t,o,s),J(o,Q),J(o,ft),J(o,V),J(o,It),q.m(Xt,o),J(o,P),K.m(Yt,o),J(o,O),tt.m(Ht,o),J(o,st),e(t,at,s),g(y,t,s),e(t,et,s),e(t,T,s),e(t,lt,s),g(b,t,s),e(t,nt,s),e(t,f,s),e(t,ot,s),g(I,t,s),e(t,pt,s),e(t,U,s),e(t,it,s),g(k,t,s),e(t,mt,s),e(t,x,s),e(t,rt,s),g(Z,t,s),e(t,ht,s),e(t,$,s),e(t,ct,s),e(t,C,s),e(t,gt,s),g(W,t,s),e(t,dt,s),e(t,B,s),e(t,wt,s),g(v,t,s),e(t,Mt,s),e(t,G,s),e(t,ut,s),g(N,t,s),e(t,Jt,s),e(t,_,s),e(t,jt,s),g(E,t,s),e(t,yt,s),g(R,t,s),e(t,Tt,s),e(t,H,s),bt=!0},p:zt,i(t){bt||(d(j.$$.fragment,t),d(y.$$.fragment,t),d(b.$$.fragment,t),d(I.$$.fragment,t),d(k.$$.fragment,t),d(Z.$$.fragment,t),d(W.$$.fragment,t),d(v.$$.fragment,t),d(N.$$.fragment,t),d(E.$$.fragment,t),d(R.$$.fragment,t),bt=!0)},o(t){w(j.$$.fragment,t),w(y.$$.fragment,t),w(b.$$.fragment,t),w(I.$$.fragment,t),w(k.$$.fragment,t),w(Z.$$.fragment,t),w(W.$$.fragment,t),w(v.$$.fragment,t),w(N.$$.fragment,t),w(E.$$.fragment,t),w(R.$$.fragment,t),bt=!1},d(t){t&&(a(A),a(Y),a(L),a(D),a(o),a(at),a(et),a(T),a(lt),a(nt),a(f),a(ot),a(pt),a(U),a(it),a(mt),a(x),a(rt),a(ht),a($),a(ct),a(C),a(gt),a(dt),a(B),a(wt),a(Mt),a(G),a(ut),a(Jt),a(_),a(jt),a(yt),a(Tt),a(H)),a(u),M(j,t),M(y,t),M(b,t),M(I,t),M(k,t),M(Z,t),M(W,t),M(v,t),M(N,t),M(E,t),M(R,t)}}}const Pt='{"title":"HRNet","local":"hrnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Kt(Zt){return Ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class es extends At{constructor(u){super(),Lt(this,u,Kt,qt,St,{})}}export{es as component};
