import{s as At,o as zt,n as Ue}from"../chunks/scheduler.c57aa7ef.js";import{S as Vt,i as Et,g as U,s as o,r as c,A as xt,h as w,f as a,c as r,j as Yt,u as d,x as b,k as yt,y as Nt,a as l,v as f,d as y,t as h,w as u}from"../chunks/index.c50cb18e.js";import{T as ht}from"../chunks/Tip.9268b0ca.js";import{C as j}from"../chunks/CodeBlock.34f0a53d.js";import{H as Je}from"../chunks/Heading.c7d7e0e7.js";import{H as Ht,a as ft}from"../chunks/HfOption.189bbdfa.js";function Lt(C){let s,T='Some familiarity with the general process of training an image classification model would be really helpful and allow you to focus on the low-rank decomposition methods. If you’re new, we recommend taking a look at the <a href="https://huggingface.co/docs/transformers/tasks/image_classification" rel="nofollow">Image classification</a> guide first from the Transformers documentation. When you’re ready, come back and see how easy it is to drop PEFT in to your training!';return{c(){s=U("p"),s.innerHTML=T},l(i){s=w(i,"P",{"data-svelte-h":!0}),b(s)!=="svelte-122rdqq"&&(s.innerHTML=T)},m(i,p){l(i,s,p)},p:Ue,d(i){i&&a(s)}}}function qt(C){let s,T='Call the <a href="/docs/peft/v0.8.2/en/package_reference/peft_model#peft.PeftModel.print_trainable_parameters">print_trainable_parameters()</a> method to compare the number of parameters of <a href="/docs/peft/v0.8.2/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> versus the number of parameters in the base model!';return{c(){s=U("p"),s.innerHTML=T},l(i){s=w(i,"P",{"data-svelte-h":!0}),b(s)!=="svelte-1u0q3wd"&&(s.innerHTML=T)},m(i,p){l(i,s,p)},p:Ue,d(i){i&&a(s)}}}function St(C){let s,T='<a href="../conceptual_guides/adapter#low-rank-adaptation-lora">LoRA</a> decomposes the weight update matrix into <em>two</em> smaller matrices. The size of these low-rank matrices is determined by its <em>rank</em> or <code>r</code>. A higher rank means the model has more parameters to train, but it also means the model has more learning capacity. You’ll also want to specify the <code>target_modules</code> which determine where the smaller matrices are inserted. For this guide, you’ll target the <em>query</em> and <em>value</em> matrices of the attention blocks. Other important parameters to set are <code>lora_alpha</code> (scaling factor), <code>bias</code> (whether <code>none</code>, <code>all</code> or only the LoRA bias parameters should be trained), and <code>modules_to_save</code> (the modules apart from the LoRA layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/v0.8.2/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>.',i,p,M;return p=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxNiUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycXVlcnklMjIlMkMlMjAlMjJ2YWx1ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kdWxlc190b19zYXZlJTNEJTVCJTIyY2xhc3NpZmllciUyMiU1RCUyQyUwQSklMEFtb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwY29uZmlnKSUwQW1vZGVsLnByaW50X3RyYWluYWJsZV9wYXJhbWV0ZXJzKCklMEElMjJ0cmFpbmFibGUlMjBwYXJhbXMlM0ElMjA2NjclMkM0OTMlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA4NiUyQzU0MyUyQzgxOCUyMCU3QyU3QyUyMHRyYWluYWJsZSUyNSUzQSUyMDAuNzcxMjc3NTA0NzY2NDI5NCUyMg==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">16</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    lora_dropout=<span class="hljs-number">0.1</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 667,493 || all params: 86,543,818 || trainable%: 0.7712775047664294&quot;</span>`,wrap:!1}}),{c(){s=U("p"),s.innerHTML=T,i=o(),c(p.$$.fragment)},l(n){s=w(n,"P",{"data-svelte-h":!0}),b(s)!=="svelte-1rls4ri"&&(s.innerHTML=T),i=r(n),d(p.$$.fragment,n)},m(n,J){l(n,s,J),l(n,i,J),f(p,n,J),M=!0},p:Ue,i(n){M||(y(p.$$.fragment,n),M=!0)},o(n){h(p.$$.fragment,n),M=!1},d(n){n&&(a(s),a(i)),u(p,n)}}}function Dt(C){let s,T='<a href="../conceptual_guides/adapter#low-rank-hadamard-product-loha">LoHa</a> decomposes the weight update matrix into <em>four</em> smaller matrices and each pair of smaller matrices is combined with the Hadamard product. This allows the weight update matrix to keep the same number of trainable parameters when compared to LoRA, but with a higher rank (<code>r^2</code> for LoHA when compared to <code>2*r</code> for LoRA). The size of the smaller matrices is determined by its <em>rank</em> or <code>r</code>. You’ll also want to specify the <code>target_modules</code> which determines where the smaller matrices are inserted. For this guide, you’ll target the <em>query</em> and <em>value</em> matrices of the attention blocks. Other important parameters to set are <code>alpha</code> (scaling factor), and <code>modules_to_save</code> (the modules apart from the LoHa layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/v0.8.2/en/package_reference/loha#peft.LoHaConfig">LoHaConfig</a>.',i,p,M;return p=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb0hhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb0hhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGFscGhhJTNEMTYlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnF1ZXJ5JTIyJTJDJTIwJTIydmFsdWUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2R1bGVfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMmNsYXNzaWZpZXIlMjIlNUQlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwMSUyQzI1NyUyQzMxNyUyMCU3QyU3QyUyMGFsbCUyMHBhcmFtcyUzQSUyMDg3JTJDMTMzJTJDNjQyJTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMS40NDI5NzUzNzc5ODMxNjc2JTIy",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoHaConfig, get_peft_model

config = LoHaConfig(
    r=<span class="hljs-number">16</span>,
    alpha=<span class="hljs-number">16</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    module_dropout=<span class="hljs-number">0.1</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 1,257,317 || all params: 87,133,642 || trainable%: 1.4429753779831676&quot;</span>`,wrap:!1}}),{c(){s=U("p"),s.innerHTML=T,i=o(),c(p.$$.fragment)},l(n){s=w(n,"P",{"data-svelte-h":!0}),b(s)!=="svelte-1vp00mf"&&(s.innerHTML=T),i=r(n),d(p.$$.fragment,n)},m(n,J){l(n,s,J),l(n,i,J),f(p,n,J),M=!0},p:Ue,i(n){M||(y(p.$$.fragment,n),M=!0)},o(n){h(p.$$.fragment,n),M=!1},d(n){n&&(a(s),a(i)),u(p,n)}}}function Pt(C){let s,T='<a href="../conceptual_guides/adapter#low-rank-kronecker-product-lokr">LoKr</a> expresses the weight update matrix as a decomposition of a Kronecker product, creating a block matrix that is able to preserve the rank of the original weight matrix. The size of the smaller matrices are determined by its <em>rank</em> or <code>r</code>. You’ll also want to specify the <code>target_modules</code> which determines where the smaller matrices are inserted. For this guide, you’ll target the <em>query</em> and <em>value</em> matrices of the attention blocks. Other important parameters to set are <code>alpha</code> (scaling factor), and <code>modules_to_save</code> (the modules apart from the LoKr layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/v0.8.2/en/package_reference/lokr#peft.LoKrConfig">LoKrConfig</a>.',i,p,M;return p=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb0tyQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb0tyQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGFscGhhJTNEMTYlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnF1ZXJ5JTIyJTJDJTIwJTIydmFsdWUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2R1bGVfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMmNsYXNzaWZpZXIlMjIlNUQlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwMTE2JTJDMDY5JTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwODclMkMxNzIlMkMwNDIlMjAlN0MlN0MlMjB0cmFpbmFibGUlMjUlM0ElMjAwLjEzMzE0OTM0MTYyMDMzMjgyJTIy",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoKrConfig, get_peft_model

config = LoKrConfig(
    r=<span class="hljs-number">16</span>,
    alpha=<span class="hljs-number">16</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    module_dropout=<span class="hljs-number">0.1</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 116,069 || all params: 87,172,042 || trainable%: 0.13314934162033282&quot;</span>`,wrap:!1}}),{c(){s=U("p"),s.innerHTML=T,i=o(),c(p.$$.fragment)},l(n){s=w(n,"P",{"data-svelte-h":!0}),b(s)!=="svelte-106ptlg"&&(s.innerHTML=T),i=r(n),d(p.$$.fragment,n)},m(n,J){l(n,s,J),l(n,i,J),f(p,n,J),M=!0},p:Ue,i(n){M||(y(p.$$.fragment,n),M=!0)},o(n){h(p.$$.fragment,n),M=!1},d(n){n&&(a(s),a(i)),u(p,n)}}}function Kt(C){let s,T='<a href="../conceptual_guides/adapter#adaptive-low-rank-adaptation-adalora">AdaLoRA</a> efficiently manages the LoRA parameter budget by assigning important weight matrices more parameters and pruning less important ones. In contrast, LoRA evenly distributes parameters across all modules. You can control the average desired <em>rank</em> or <code>r</code> of the matrices, and which modules to apply AdaLoRA to with <code>target_modules</code>. Other important parameters to set are <code>lora_alpha</code> (scaling factor), and <code>modules_to_save</code> (the modules apart from the AdaLoRA layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/v0.8.2/en/package_reference/adalora#peft.AdaLoraConfig">AdaLoraConfig</a>.',i,p,M;return p=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBBZGFMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBBZGFMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwaW5pdF9yJTNEMTIlMkMlMEElMjAlMjAlMjAlMjB0aW5pdCUzRDIwMCUyQyUwQSUyMCUyMCUyMCUyMHRmaW5hbCUzRDEwMDAlMkMlMEElMjAlMjAlMjAlMjBkZWx0YVQlM0QxMCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycXVlcnklMjIlMkMlMjAlMjJ2YWx1ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMmNsYXNzaWZpZXIlMjIlNUQlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwNTIwJTJDMzI1JTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwODclMkM2MTQlMkM3MjIlMjAlN0MlN0MlMjB0cmFpbmFibGUlMjUlM0ElMjAwLjU5Mzg3ODUwMzY2MDYwNjIlMjI=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> AdaLoraConfig, get_peft_model

config = AdaLoraConfig(
    r=<span class="hljs-number">8</span>,
    init_r=<span class="hljs-number">12</span>,
    tinit=<span class="hljs-number">200</span>,
    tfinal=<span class="hljs-number">1000</span>,
    deltaT=<span class="hljs-number">10</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 520,325 || all params: 87,614,722 || trainable%: 0.5938785036606062&quot;</span>`,wrap:!1}}),{c(){s=U("p"),s.innerHTML=T,i=o(),c(p.$$.fragment)},l(n){s=w(n,"P",{"data-svelte-h":!0}),b(s)!=="svelte-vvbw0m"&&(s.innerHTML=T),i=r(n),d(p.$$.fragment,n)},m(n,J){l(n,s,J),l(n,i,J),f(p,n,J),M=!0},p:Ue,i(n){M||(y(p.$$.fragment,n),M=!0)},o(n){h(p.$$.fragment,n),M=!1},d(n){n&&(a(s),a(i)),u(p,n)}}}function Ot(C){let s,T,i,p,M,n,J,B;return s=new ft({props:{id:"loras",option:"LoRA",$$slots:{default:[St]},$$scope:{ctx:C}}}),i=new ft({props:{id:"loras",option:"LoHa",$$slots:{default:[Dt]},$$scope:{ctx:C}}}),M=new ft({props:{id:"loras",option:"LoKr",$$slots:{default:[Pt]},$$scope:{ctx:C}}}),J=new ft({props:{id:"loras",option:"AdaLoRA",$$slots:{default:[Kt]},$$scope:{ctx:C}}}),{c(){c(s.$$.fragment),T=o(),c(i.$$.fragment),p=o(),c(M.$$.fragment),n=o(),c(J.$$.fragment)},l(m){d(s.$$.fragment,m),T=r(m),d(i.$$.fragment,m),p=r(m),d(M.$$.fragment,m),n=r(m),d(J.$$.fragment,m)},m(m,g){f(s,m,g),l(m,T,g),f(i,m,g),l(m,p,g),f(M,m,g),l(m,n,g),f(J,m,g),B=!0},p(m,g){const we={};g&2&&(we.$$scope={dirty:g,ctx:m}),s.$set(we);const v={};g&2&&(v.$$scope={dirty:g,ctx:m}),i.$set(v);const $={};g&2&&($.$$scope={dirty:g,ctx:m}),M.$set($);const Te={};g&2&&(Te.$$scope={dirty:g,ctx:m}),J.$set(Te)},i(m){B||(y(s.$$.fragment,m),y(i.$$.fragment,m),y(M.$$.fragment,m),y(J.$$.fragment,m),B=!0)},o(m){h(s.$$.fragment,m),h(i.$$.fragment,m),h(M.$$.fragment,m),h(J.$$.fragment,m),B=!1},d(m){m&&(a(T),a(p),a(n)),u(s,m),u(i,m),u(M,m),u(J,m)}}}function ea(C){let s,T='AdaLoRA has an <a href="/docs/peft/v0.8.2/en/package_reference/adalora#peft.AdaLoraModel.update_and_allocate">update_and_allocate()</a> method that should be called at each training step to update the parameter budget and mask, otherwise the adaptation step is not performed. This requires writing a custom training loop or subclassing the <a href="https://huggingface.co/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> to incorporate this method. As an example, take a look at this <a href="https://github.com/huggingface/peft/blob/912ad41e96e03652cabf47522cd876076f7a0c4f/examples/conditional_generation/peft_adalora_seq2seq.py#L120" rel="nofollow">custom training loop</a>.';return{c(){s=U("p"),s.innerHTML=T},l(i){s=w(i,"P",{"data-svelte-h":!0}),b(s)!=="svelte-1vadauz"&&(s.innerHTML=T)},m(i,p){l(i,s,p)},p:Ue,d(i){i&&a(s)}}}function ta(C){let s,T,i,p,M,n,J,B="A popular way to efficiently train large models is to insert (typically in the attention blocks) smaller trainable matrices that are a low-rank decomposition of the delta weight matrix to be learnt during finetuning. The pretrained model’s original weight matrix is frozen and only the smaller matrices are updated during training. This reduces the number of trainable parameters, reducing memory usage and training time which can be very expensive for large models.",m,g,we='There are several different ways to express the weight matrix as a low-rank decomposition, but <a href="../conceptual_guides/adapter#low-rank-adaptation-lora">Low-Rank Adaptation (LoRA)</a> is the most common method. The PEFT library supports several other LoRA variants, such as <a href="../conceptual_guides/adapter#low-rank-hadamard-product-loha">Low-Rank Hadamard Product (LoHa)</a>, <a href="../conceptual_guides/adapter#low-rank-kronecker-product-lokr">Low-Rank Kronecker Product (LoKr)</a>, and <a href="../conceptual_guides/adapter#adaptive-low-rank-adaptation-adalora">Adaptive Low-Rank Adaptation (AdaLoRA)</a>. You can learn more about how these methods work conceptually in the <a href="../conceptual_guides/adapter">Adapters</a> guide. If you’re interested in applying these methods to other tasks and use cases like semantic segmentation, token classification, take a look at our <a href="https://huggingface.co/collections/PEFT/notebooks-6573b28b33e5a4bf5b157fc1" rel="nofollow">notebook collection</a>!',v,$,Te="This guide will show you how to quickly train an image classification model - with a low-rank decomposition method - to identify the class of food shown in an image.",ge,_,je,R,ut="Before you begin, make sure you have all the necessary libraries installed.",Ce,Q,$e,G,_e,F,Jt='In this guide, you’ll use the <a href="https://huggingface.co/datasets/food101" rel="nofollow">Food-101</a> dataset which contains images of 101 food classes (take a look at the <a href="https://huggingface.co/datasets/food101/viewer/default/train" rel="nofollow">dataset viewer</a> to get a better idea of what the dataset looks like).',Ze,X,Ut='Load the dataset with the <a href="https://huggingface.co/docs/datasets/v2.17.1/en/package_reference/loading_methods#datasets.load_dataset" rel="nofollow">load_dataset</a> function.',Ie,Y,ke,A,wt="Each food class is labeled with an integer, so to make it easier to understand what these integers represent, you’ll create a <code>label2id</code> and <code>id2label</code> dictionary to map the integer to its class label.",We,z,Be,V,Tt="Load an image processor to properly resize and normalize the pixel values of the training and evaluation images.",ve,E,Re,x,bt="You can also use the image processor to prepare some transformation functions for data augmentation and pixel scaling.",Qe,N,Ge,H,gt='Define the training and validation datasets, and use the <a href="https://huggingface.co/docs/datasets/v2.17.1/en/package_reference/main_classes#datasets.Dataset.set_transform" rel="nofollow">set_transform</a> function to apply the transformations on-the-fly.',Fe,L,Xe,q,jt="Finally, you’ll need a data collator to create a batch of training and evaluation data and convert the labels to <code>torch.tensor</code> objects.",Ye,S,Ae,D,ze,P,Ct='Now let’s load a pretrained model to use as the base model. This guide uses the <a href="https://huggingface.co/google/vit-base-patch16-224-in21k" rel="nofollow">google/vit-base-patch16-224-in21k</a> model, but you can use any image classification model you want. Pass the <code>label2id</code> and <code>id2label</code> dictionaries to the model so it knows how to map the integer labels to their class labels, and you can optionally pass the <code>ignore_mismatched_sizes=True</code> parameter if you’re finetuning a checkpoint that has already been finetuned.',Ve,K,Ee,O,xe,ee,$t='Every PEFT method requires a configuration that holds all the parameters specifying how the PEFT method should be applied. Once the configuration is setup, pass it to the <a href="/docs/peft/v0.8.2/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function along with the base model to create a trainable <a href="/docs/peft/v0.8.2/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',Ne,Z,He,I,Le,te,qe,ae,_t='For training, let’s use the <a href="https://huggingface.co/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class from Transformers. The <code>Trainer</code> contains a PyTorch training loop, and when you’re ready, call <a href="https://huggingface.co/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.Trainer.train" rel="nofollow">train</a> to start training. To customize the training run, configure the training hyperparameters in the <a href="https://huggingface.co/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a> class. With LoRA-like methods, you can afford to use a higher batch size and learning rate.',Se,k,De,le,Pe,se,Zt='Begin training with <a href="https://huggingface.co/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.Trainer.train" rel="nofollow">train</a>.',Ke,ne,Oe,oe,et,re,It='Once training is complete, you can upload your model to the Hub with the <a href="https://huggingface.co/docs/transformers/v4.37.2/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> method. You’ll need to login to your Hugging Face account first and enter your token when prompted.',tt,ie,at,pe,kt='Call <a href="https://huggingface.co/docs/transformers/v4.37.2/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> to save your model to your repositoy.',lt,me,st,Me,nt,ce,Wt="Let’s load the model from the Hub and test it out on a food image.",ot,de,rt,W,Bt='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/beignets.jpeg"/>',it,fe,vt="Convert the image to RGB and return the underlying PyTorch tensors.",pt,ye,mt,he,Rt="Now run the model and return the predicted class!",Mt,ue,ct,be,dt;return M=new Je({props:{title:"LoRA methods",local:"lora-methods",headingTag:"h1"}}),_=new ht({props:{$$slots:{default:[Lt]},$$scope:{ctx:C}}}),Q=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwcGVmdCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRz",highlighted:"pip install -q peft transformers datasets",wrap:!1}}),G=new Je({props:{title:"Dataset",local:"dataset",headingTag:"h2"}}),Y=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZm9vZDEwMSUyMik=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>)`,wrap:!1}}),z=new j({props:{code:"bGFiZWxzJTIwJTNEJTIwZHMlNUIlMjJ0cmFpbiUyMiU1RC5mZWF0dXJlcyU1QiUyMmxhYmVsJTIyJTVELm5hbWVzJTBBbGFiZWwyaWQlMkMlMjBpZDJsYWJlbCUyMCUzRCUyMGRpY3QoKSUyQyUyMGRpY3QoKSUwQWZvciUyMGklMkMlMjBsYWJlbCUyMGluJTIwZW51bWVyYXRlKGxhYmVscyklM0ElMEElMjAlMjAlMjAlMjBsYWJlbDJpZCU1QmxhYmVsJTVEJTIwJTNEJTIwaSUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTVCaSU1RCUyMCUzRCUyMGxhYmVsJTBBJTBBaWQybGFiZWwlNUIyJTVEJTBBJTIyYmFrbGF2YSUyMg==",highlighted:`labels = ds[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;label&quot;</span>].names
label2id, id2label = <span class="hljs-built_in">dict</span>(), <span class="hljs-built_in">dict</span>()
<span class="hljs-keyword">for</span> i, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(labels):
    label2id[label] = i
    id2label[i] = label

id2label[<span class="hljs-number">2</span>]
<span class="hljs-string">&quot;baklava&quot;</span>`,wrap:!1}}),E=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQtaW4yMWslMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224-in21k&quot;</span>)`,wrap:!1}}),N=new j({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQ2VudGVyQ3JvcCUyQyUwQSUyMCUyMCUyMCUyMENvbXBvc2UlMkMlMEElMjAlMjAlMjAlMjBOb3JtYWxpemUlMkMlMEElMjAlMjAlMjAlMjBSYW5kb21Ib3Jpem9udGFsRmxpcCUyQyUwQSUyMCUyMCUyMCUyMFJhbmRvbVJlc2l6ZWRDcm9wJTJDJTBBJTIwJTIwJTIwJTIwUmVzaXplJTJDJTBBJTIwJTIwJTIwJTIwVG9UZW5zb3IlMkMlMEEpJTBBJTBBbm9ybWFsaXplJTIwJTNEJTIwTm9ybWFsaXplKG1lYW4lM0RpbWFnZV9wcm9jZXNzb3IuaW1hZ2VfbWVhbiUyQyUyMHN0ZCUzRGltYWdlX3Byb2Nlc3Nvci5pbWFnZV9zdGQpJTBBdHJhaW5fdHJhbnNmb3JtcyUyMCUzRCUyMENvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUmFuZG9tUmVzaXplZENyb3AoaW1hZ2VfcHJvY2Vzc29yLnNpemUlNUIlMjJoZWlnaHQlMjIlNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUmFuZG9tSG9yaXpvbnRhbEZsaXAoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFRvVGVuc29yKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemUlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBJTBBdmFsX3RyYW5zZm9ybXMlMjAlM0QlMjBDb21wb3NlKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFJlc2l6ZShpbWFnZV9wcm9jZXNzb3Iuc2l6ZSU1QiUyMmhlaWdodCUyMiU1RCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBDZW50ZXJDcm9wKGltYWdlX3Byb2Nlc3Nvci5zaXplJTVCJTIyaGVpZ2h0JTIyJTVEKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFRvVGVuc29yKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemUlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBJTBBZGVmJTIwcHJlcHJvY2Vzc190cmFpbihleGFtcGxlX2JhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMGV4YW1wbGVfYmF0Y2glNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMjAlM0QlMjAlNUJ0cmFpbl90cmFuc2Zvcm1zKGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSklMjBmb3IlMjBpbWFnZSUyMGluJTIwZXhhbXBsZV9iYXRjaCU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZV9iYXRjaCUwQSUwQWRlZiUyMHByZXByb2Nlc3NfdmFsKGV4YW1wbGVfYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwZXhhbXBsZV9iYXRjaCU1QiUyMnBpeGVsX3ZhbHVlcyUyMiU1RCUyMCUzRCUyMCU1QnZhbF90cmFuc2Zvcm1zKGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSklMjBmb3IlMjBpbWFnZSUyMGluJTIwZXhhbXBsZV9iYXRjaCU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZV9iYXRjaA==",highlighted:`<span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> (
    CenterCrop,
    Compose,
    Normalize,
    RandomHorizontalFlip,
    RandomResizedCrop,
    Resize,
    ToTensor,
)

normalize = Normalize(mean=image_processor.image_mean, std=image_processor.image_std)
train_transforms = Compose(
    [
        RandomResizedCrop(image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]),
        RandomHorizontalFlip(),
        ToTensor(),
        normalize,
    ]
)

val_transforms = Compose(
    [
        Resize(image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]),
        CenterCrop(image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]),
        ToTensor(),
        normalize,
    ]
)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_train</span>(<span class="hljs-params">example_batch</span>):
    example_batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [train_transforms(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
    <span class="hljs-keyword">return</span> example_batch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_val</span>(<span class="hljs-params">example_batch</span>):
    example_batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [val_transforms(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
    <span class="hljs-keyword">return</span> example_batch`,wrap:!1}}),L=new j({props:{code:"dHJhaW5fZHMlMjAlM0QlMjBkcyU1QiUyMnRyYWluJTIyJTVEJTBBdmFsX2RzJTIwJTNEJTIwZHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTBBJTBBdHJhaW5fZHMuc2V0X3RyYW5zZm9ybShwcmVwcm9jZXNzX3RyYWluKSUwQXZhbF9kcy5zZXRfdHJhbnNmb3JtKHByZXByb2Nlc3NfdmFsKQ==",highlighted:`train_ds = ds[<span class="hljs-string">&quot;train&quot;</span>]
val_ds = ds[<span class="hljs-string">&quot;validation&quot;</span>]

train_ds.set_transform(preprocess_train)
val_ds.set_transform(preprocess_val)`,wrap:!1}}),S=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZWYlMjBjb2xsYXRlX2ZuKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMHBpeGVsX3ZhbHVlcyUyMCUzRCUyMHRvcmNoLnN0YWNrKCU1QmV4YW1wbGUlNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMjBmb3IlMjBleGFtcGxlJTIwaW4lMjBleGFtcGxlcyU1RCklMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZXhhbXBsZSU1QiUyMmxhYmVsJTIyJTVEJTIwZm9yJTIwZXhhbXBsZSUyMGluJTIwZXhhbXBsZXMlNUQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIycGl4ZWxfdmFsdWVzJTIyJTNBJTIwcGl4ZWxfdmFsdWVzJTJDJTIwJTIybGFiZWxzJTIyJTNBJTIwbGFiZWxzJTdE",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">examples</span>):
    pixel_values = torch.stack([example[<span class="hljs-string">&quot;pixel_values&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
    labels = torch.tensor([example[<span class="hljs-string">&quot;label&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;pixel_values&quot;</span>: pixel_values, <span class="hljs-string">&quot;labels&quot;</span>: labels}`,wrap:!1}}),D=new Je({props:{title:"Model",local:"model",headingTag:"h2"}}),K=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMkMlMjBUcmFpbmluZ0FyZ3VtZW50cyUyQyUyMFRyYWluZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LWluMjFrJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTNEaWQybGFiZWwlMkMlMEElMjAlMjAlMjAlMjBpZ25vcmVfbWlzbWF0Y2hlZF9zaXplcyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification, TrainingArguments, Trainer

model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;google/vit-base-patch16-224-in21k&quot;</span>,
    label2id=label2id,
    id2label=id2label,
    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),O=new Je({props:{title:"PEFT configuration and model",local:"peft-configuration-and-model",headingTag:"h3"}}),Z=new ht({props:{$$slots:{default:[qt]},$$scope:{ctx:C}}}),I=new Ht({props:{id:"loras",options:["LoRA","LoHa","LoKr","AdaLoRA"],$$slots:{default:[Ot]},$$scope:{ctx:C}}}),te=new Je({props:{title:"Training",local:"training",headingTag:"h3"}}),k=new ht({props:{warning:!0,$$slots:{default:[ea]},$$scope:{ctx:C}}}),le=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQWFjY291bnQlMjAlM0QlMjAlMjJzdGV2aGxpdSUyMiUwQXBlZnRfbW9kZWxfaWQlMjAlM0QlMjBmJTIyJTdCYWNjb3VudCU3RCUyRmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LWluMjFrLWxvcmElMjIlMEFiYXRjaF9zaXplJTIwJTNEJTIwMTI4JTBBJTBBYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMHBlZnRfbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfdW51c2VkX2NvbHVtbnMlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0Q1ZS0zJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0Q1JTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDEwJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9iZXN0X21vZGVsX2F0X2VuZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBsYWJlbF9uYW1lcyUzRCU1QiUyMmxhYmVscyUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer

account = <span class="hljs-string">&quot;stevhliu&quot;</span>
peft_model_id = <span class="hljs-string">f&quot;<span class="hljs-subst">{account}</span>/google/vit-base-patch16-224-in21k-lora&quot;</span>
batch_size = <span class="hljs-number">128</span>

args = TrainingArguments(
    peft_model_id,
    remove_unused_columns=<span class="hljs-literal">False</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">5e-3</span>,
    per_device_train_batch_size=batch_size,
    gradient_accumulation_steps=<span class="hljs-number">4</span>,
    per_device_eval_batch_size=batch_size,
    fp16=<span class="hljs-literal">True</span>,
    num_train_epochs=<span class="hljs-number">5</span>,
    logging_steps=<span class="hljs-number">10</span>,
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
)`,wrap:!1}}),ne=new j({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RzJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEdmFsX2RzJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEaW1hZ2VfcHJvY2Vzc29yJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGNvbGxhdGVfZm4lMkMlMEEpJTBBdHJhaW5lci50cmFpbigp",highlighted:`trainer = Trainer(
    model,
    args,
    train_dataset=train_ds,
    eval_dataset=val_ds,
    tokenizer=image_processor,
    data_collator=collate_fn,
)
trainer.train()`,wrap:!1}}),oe=new Je({props:{title:"Share your model",local:"share-your-model",headingTag:"h2"}}),ie=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),me=new j({props:{code:"bW9kZWwucHVzaF90b19odWIocGVmdF9tb2RlbF9pZCk=",highlighted:"model.push_to_hub(peft_model_id)",wrap:!1}}),Me=new Je({props:{title:"Inference",local:"inference",headingTag:"h2"}}),de=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0Q29uZmlnJTJDJTIwUGVmdE1vZGVsJTBBZnJvbSUyMHRyYW5zZm9tZXJzJTIwaW1wb3J0JTIwQXV0b0ltYWdlUHJvY2Vzc29yJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEFjb25maWclMjAlM0QlMjBQZWZ0Q29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJzdGV2aGxpdSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LWluMjFrLWxvcmElMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBjb25maWcuYmFzZV9tb2RlbF9uYW1lX29yX3BhdGglMkMlMEElMjAlMjAlMjAlMjBsYWJlbDJpZCUzRGxhYmVsMmlkJTJDJTBBJTIwJTIwJTIwJTIwaWQybGFiZWwlM0RpZDJsYWJlbCUyQyUwQSUyMCUyMCUyMCUyMGlnbm9yZV9taXNtYXRjaGVkX3NpemVzJTNEVHJ1ZSUyQyUwQSklMEFtb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQobW9kZWwlMkMlMjAlMjJzdGV2aGxpdSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LWluMjFrLWxvcmElMjIpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGc2F5YWtwYXVsJTJGc2FtcGxlLWRhdGFzZXRzJTJGcmVzb2x2ZSUyRm1haW4lMkZiZWlnbmV0cy5qcGVnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftConfig, PeftModel
<span class="hljs-keyword">from</span> transfomers <span class="hljs-keyword">import</span> AutoImageProcessor
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

config = PeftConfig.from_pretrained(<span class="hljs-string">&quot;stevhliu/vit-base-patch16-224-in21k-lora&quot;</span>)
model = AutoModelForImageClassification.from_pretrained(
    config.base_model_name_or_path,
    label2id=label2id,
    id2label=id2label,
    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,
)
model = PeftModel.from_pretrained(model, <span class="hljs-string">&quot;stevhliu/vit-base-patch16-224-in21k-lora&quot;</span>)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/beignets.jpeg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
image`,wrap:!1}}),ye=new j({props:{code:"ZW5jb2RpbmclMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UuY29udmVydCglMjJSR0IlMjIpJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'encoding = image_processor(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),ue=new j({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmVuY29kaW5nKSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGNsYXNzJTNBJTIyJTJDJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkeCU1RCklMEElMjJQcmVkaWN0ZWQlMjBjbGFzcyUzQSUyMGJlaWduZXRzJTIy",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**encoding)
    logits = outputs.logits

predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
<span class="hljs-string">&quot;Predicted class: beignets&quot;</span>`,wrap:!1}}),{c(){s=U("meta"),T=o(),i=U("p"),p=o(),c(M.$$.fragment),n=o(),J=U("p"),J.textContent=B,m=o(),g=U("p"),g.innerHTML=we,v=o(),$=U("p"),$.textContent=Te,ge=o(),c(_.$$.fragment),je=o(),R=U("p"),R.textContent=ut,Ce=o(),c(Q.$$.fragment),$e=o(),c(G.$$.fragment),_e=o(),F=U("p"),F.innerHTML=Jt,Ze=o(),X=U("p"),X.innerHTML=Ut,Ie=o(),c(Y.$$.fragment),ke=o(),A=U("p"),A.innerHTML=wt,We=o(),c(z.$$.fragment),Be=o(),V=U("p"),V.textContent=Tt,ve=o(),c(E.$$.fragment),Re=o(),x=U("p"),x.textContent=bt,Qe=o(),c(N.$$.fragment),Ge=o(),H=U("p"),H.innerHTML=gt,Fe=o(),c(L.$$.fragment),Xe=o(),q=U("p"),q.innerHTML=jt,Ye=o(),c(S.$$.fragment),Ae=o(),c(D.$$.fragment),ze=o(),P=U("p"),P.innerHTML=Ct,Ve=o(),c(K.$$.fragment),Ee=o(),c(O.$$.fragment),xe=o(),ee=U("p"),ee.innerHTML=$t,Ne=o(),c(Z.$$.fragment),He=o(),c(I.$$.fragment),Le=o(),c(te.$$.fragment),qe=o(),ae=U("p"),ae.innerHTML=_t,Se=o(),c(k.$$.fragment),De=o(),c(le.$$.fragment),Pe=o(),se=U("p"),se.innerHTML=Zt,Ke=o(),c(ne.$$.fragment),Oe=o(),c(oe.$$.fragment),et=o(),re=U("p"),re.innerHTML=It,tt=o(),c(ie.$$.fragment),at=o(),pe=U("p"),pe.innerHTML=kt,lt=o(),c(me.$$.fragment),st=o(),c(Me.$$.fragment),nt=o(),ce=U("p"),ce.textContent=Wt,ot=o(),c(de.$$.fragment),rt=o(),W=U("div"),W.innerHTML=Bt,it=o(),fe=U("p"),fe.textContent=vt,pt=o(),c(ye.$$.fragment),mt=o(),he=U("p"),he.textContent=Rt,Mt=o(),c(ue.$$.fragment),ct=o(),be=U("p"),this.h()},l(e){const t=xt("svelte-u9bgzb",document.head);s=w(t,"META",{name:!0,content:!0}),t.forEach(a),T=r(e),i=w(e,"P",{}),Yt(i).forEach(a),p=r(e),d(M.$$.fragment,e),n=r(e),J=w(e,"P",{"data-svelte-h":!0}),b(J)!=="svelte-3c4mx2"&&(J.textContent=B),m=r(e),g=w(e,"P",{"data-svelte-h":!0}),b(g)!=="svelte-1mec8a1"&&(g.innerHTML=we),v=r(e),$=w(e,"P",{"data-svelte-h":!0}),b($)!=="svelte-3yvnz9"&&($.textContent=Te),ge=r(e),d(_.$$.fragment,e),je=r(e),R=w(e,"P",{"data-svelte-h":!0}),b(R)!=="svelte-1rdzhb1"&&(R.textContent=ut),Ce=r(e),d(Q.$$.fragment,e),$e=r(e),d(G.$$.fragment,e),_e=r(e),F=w(e,"P",{"data-svelte-h":!0}),b(F)!=="svelte-l33v6t"&&(F.innerHTML=Jt),Ze=r(e),X=w(e,"P",{"data-svelte-h":!0}),b(X)!=="svelte-10go91p"&&(X.innerHTML=Ut),Ie=r(e),d(Y.$$.fragment,e),ke=r(e),A=w(e,"P",{"data-svelte-h":!0}),b(A)!=="svelte-1a5q7dy"&&(A.innerHTML=wt),We=r(e),d(z.$$.fragment,e),Be=r(e),V=w(e,"P",{"data-svelte-h":!0}),b(V)!=="svelte-13cytaa"&&(V.textContent=Tt),ve=r(e),d(E.$$.fragment,e),Re=r(e),x=w(e,"P",{"data-svelte-h":!0}),b(x)!=="svelte-1p1x6w4"&&(x.textContent=bt),Qe=r(e),d(N.$$.fragment,e),Ge=r(e),H=w(e,"P",{"data-svelte-h":!0}),b(H)!=="svelte-l1hbql"&&(H.innerHTML=gt),Fe=r(e),d(L.$$.fragment,e),Xe=r(e),q=w(e,"P",{"data-svelte-h":!0}),b(q)!=="svelte-mznco7"&&(q.innerHTML=jt),Ye=r(e),d(S.$$.fragment,e),Ae=r(e),d(D.$$.fragment,e),ze=r(e),P=w(e,"P",{"data-svelte-h":!0}),b(P)!=="svelte-akpunr"&&(P.innerHTML=Ct),Ve=r(e),d(K.$$.fragment,e),Ee=r(e),d(O.$$.fragment,e),xe=r(e),ee=w(e,"P",{"data-svelte-h":!0}),b(ee)!=="svelte-12xfme4"&&(ee.innerHTML=$t),Ne=r(e),d(Z.$$.fragment,e),He=r(e),d(I.$$.fragment,e),Le=r(e),d(te.$$.fragment,e),qe=r(e),ae=w(e,"P",{"data-svelte-h":!0}),b(ae)!=="svelte-1pdhu1j"&&(ae.innerHTML=_t),Se=r(e),d(k.$$.fragment,e),De=r(e),d(le.$$.fragment,e),Pe=r(e),se=w(e,"P",{"data-svelte-h":!0}),b(se)!=="svelte-ktd426"&&(se.innerHTML=Zt),Ke=r(e),d(ne.$$.fragment,e),Oe=r(e),d(oe.$$.fragment,e),et=r(e),re=w(e,"P",{"data-svelte-h":!0}),b(re)!=="svelte-mgki93"&&(re.innerHTML=It),tt=r(e),d(ie.$$.fragment,e),at=r(e),pe=w(e,"P",{"data-svelte-h":!0}),b(pe)!=="svelte-mc6bs3"&&(pe.innerHTML=kt),lt=r(e),d(me.$$.fragment,e),st=r(e),d(Me.$$.fragment,e),nt=r(e),ce=w(e,"P",{"data-svelte-h":!0}),b(ce)!=="svelte-1whrqzq"&&(ce.textContent=Wt),ot=r(e),d(de.$$.fragment,e),rt=r(e),W=w(e,"DIV",{class:!0,"data-svelte-h":!0}),b(W)!=="svelte-sucph9"&&(W.innerHTML=Bt),it=r(e),fe=w(e,"P",{"data-svelte-h":!0}),b(fe)!=="svelte-1nlb27h"&&(fe.textContent=vt),pt=r(e),d(ye.$$.fragment,e),mt=r(e),he=w(e,"P",{"data-svelte-h":!0}),b(he)!=="svelte-1mvhoi"&&(he.textContent=Rt),Mt=r(e),d(ue.$$.fragment,e),ct=r(e),be=w(e,"P",{}),Yt(be).forEach(a),this.h()},h(){yt(s,"name","hf:doc:metadata"),yt(s,"content",aa),yt(W,"class","flex justify-center")},m(e,t){Nt(document.head,s),l(e,T,t),l(e,i,t),l(e,p,t),f(M,e,t),l(e,n,t),l(e,J,t),l(e,m,t),l(e,g,t),l(e,v,t),l(e,$,t),l(e,ge,t),f(_,e,t),l(e,je,t),l(e,R,t),l(e,Ce,t),f(Q,e,t),l(e,$e,t),f(G,e,t),l(e,_e,t),l(e,F,t),l(e,Ze,t),l(e,X,t),l(e,Ie,t),f(Y,e,t),l(e,ke,t),l(e,A,t),l(e,We,t),f(z,e,t),l(e,Be,t),l(e,V,t),l(e,ve,t),f(E,e,t),l(e,Re,t),l(e,x,t),l(e,Qe,t),f(N,e,t),l(e,Ge,t),l(e,H,t),l(e,Fe,t),f(L,e,t),l(e,Xe,t),l(e,q,t),l(e,Ye,t),f(S,e,t),l(e,Ae,t),f(D,e,t),l(e,ze,t),l(e,P,t),l(e,Ve,t),f(K,e,t),l(e,Ee,t),f(O,e,t),l(e,xe,t),l(e,ee,t),l(e,Ne,t),f(Z,e,t),l(e,He,t),f(I,e,t),l(e,Le,t),f(te,e,t),l(e,qe,t),l(e,ae,t),l(e,Se,t),f(k,e,t),l(e,De,t),f(le,e,t),l(e,Pe,t),l(e,se,t),l(e,Ke,t),f(ne,e,t),l(e,Oe,t),f(oe,e,t),l(e,et,t),l(e,re,t),l(e,tt,t),f(ie,e,t),l(e,at,t),l(e,pe,t),l(e,lt,t),f(me,e,t),l(e,st,t),f(Me,e,t),l(e,nt,t),l(e,ce,t),l(e,ot,t),f(de,e,t),l(e,rt,t),l(e,W,t),l(e,it,t),l(e,fe,t),l(e,pt,t),f(ye,e,t),l(e,mt,t),l(e,he,t),l(e,Mt,t),f(ue,e,t),l(e,ct,t),l(e,be,t),dt=!0},p(e,[t]){const Qt={};t&2&&(Qt.$$scope={dirty:t,ctx:e}),_.$set(Qt);const Gt={};t&2&&(Gt.$$scope={dirty:t,ctx:e}),Z.$set(Gt);const Ft={};t&2&&(Ft.$$scope={dirty:t,ctx:e}),I.$set(Ft);const Xt={};t&2&&(Xt.$$scope={dirty:t,ctx:e}),k.$set(Xt)},i(e){dt||(y(M.$$.fragment,e),y(_.$$.fragment,e),y(Q.$$.fragment,e),y(G.$$.fragment,e),y(Y.$$.fragment,e),y(z.$$.fragment,e),y(E.$$.fragment,e),y(N.$$.fragment,e),y(L.$$.fragment,e),y(S.$$.fragment,e),y(D.$$.fragment,e),y(K.$$.fragment,e),y(O.$$.fragment,e),y(Z.$$.fragment,e),y(I.$$.fragment,e),y(te.$$.fragment,e),y(k.$$.fragment,e),y(le.$$.fragment,e),y(ne.$$.fragment,e),y(oe.$$.fragment,e),y(ie.$$.fragment,e),y(me.$$.fragment,e),y(Me.$$.fragment,e),y(de.$$.fragment,e),y(ye.$$.fragment,e),y(ue.$$.fragment,e),dt=!0)},o(e){h(M.$$.fragment,e),h(_.$$.fragment,e),h(Q.$$.fragment,e),h(G.$$.fragment,e),h(Y.$$.fragment,e),h(z.$$.fragment,e),h(E.$$.fragment,e),h(N.$$.fragment,e),h(L.$$.fragment,e),h(S.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),h(O.$$.fragment,e),h(Z.$$.fragment,e),h(I.$$.fragment,e),h(te.$$.fragment,e),h(k.$$.fragment,e),h(le.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(ie.$$.fragment,e),h(me.$$.fragment,e),h(Me.$$.fragment,e),h(de.$$.fragment,e),h(ye.$$.fragment,e),h(ue.$$.fragment,e),dt=!1},d(e){e&&(a(T),a(i),a(p),a(n),a(J),a(m),a(g),a(v),a($),a(ge),a(je),a(R),a(Ce),a($e),a(_e),a(F),a(Ze),a(X),a(Ie),a(ke),a(A),a(We),a(Be),a(V),a(ve),a(Re),a(x),a(Qe),a(Ge),a(H),a(Fe),a(Xe),a(q),a(Ye),a(Ae),a(ze),a(P),a(Ve),a(Ee),a(xe),a(ee),a(Ne),a(He),a(Le),a(qe),a(ae),a(Se),a(De),a(Pe),a(se),a(Ke),a(Oe),a(et),a(re),a(tt),a(at),a(pe),a(lt),a(st),a(nt),a(ce),a(ot),a(rt),a(W),a(it),a(fe),a(pt),a(mt),a(he),a(Mt),a(ct),a(be)),a(s),u(M,e),u(_,e),u(Q,e),u(G,e),u(Y,e),u(z,e),u(E,e),u(N,e),u(L,e),u(S,e),u(D,e),u(K,e),u(O,e),u(Z,e),u(I,e),u(te,e),u(k,e),u(le,e),u(ne,e),u(oe,e),u(ie,e),u(me,e),u(Me,e),u(de,e),u(ye,e),u(ue,e)}}}const aa='{"title":"LoRA methods","local":"lora-methods","sections":[{"title":"Dataset","local":"dataset","sections":[],"depth":2},{"title":"Model","local":"model","sections":[{"title":"PEFT configuration and model","local":"peft-configuration-and-model","sections":[],"depth":3},{"title":"Training","local":"training","sections":[],"depth":3}],"depth":2},{"title":"Share your model","local":"share-your-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function la(C){return zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ma extends Vt{constructor(s){super(),Et(this,s,la,ta,At,{})}}export{ma as component};
