import{s as fa,n as va,o as ba}from"../chunks/scheduler.9039eef2.js";import{S as Ta,i as Ma,g as r,s as a,r as p,A as ya,h as i,f as o,c as n,j as v,u as g,x as m,k as b,y as t,a as s,v as _,d as h,t as u,w as f}from"../chunks/index.ded8f90d.js";import{D as T}from"../chunks/Docstring.a2ba2b54.js";import{C as Pt}from"../chunks/CodeBlock.8580f3e8.js";import{H as Ne}from"../chunks/Heading.f027f30d.js";function wa(Ht){let U,Ee,Ke,Le,K,qe,F,Bt='TRL supports the Kahneman-Tversky Optimization (KTO) Trainer for training language models from unpaired preference data, as described in the <a href="https://arxiv.org/abs/2402.01306" rel="nofollow">report</a> by Kawin Ethayarajh, Winnie Xu, Niklas Muennighoff, Dan Jurafsky, and Douwe Kiela.',ze,E,De,L,Wt="The KTO trainer expects a very specific format for the dataset as it does not require pairwise preferences. Since the model will be trained to directly optimize examples that consist of a prompt, model completion, and a label to indicate whether the completion is “good” or “bad”, we expect a dataset with the following columns:",Pe,q,St="<li><code>prompt</code></li> <li><code>completion</code></li> <li><code>label</code></li>",He,z,Qt="for example:",Be,D,We,P,Zt="where the <code>prompt</code> contains the context inputs, <code>completion</code> contains the corresponding responses and <code>label</code> contains the corresponding flag that indicates if the generated completion is desired or undesired. As can be seen a prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.",Se,H,Qe,B,Rt="The KTO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",Ze,W,Re,S,Xt="For a detailed example have a look at the <code>examples/scripts/kto.py</code> script. At a high level we need to initialize the <code>KTOTrainer</code> with a <code>model</code> we wish to train, a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response, the <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).",Xe,Q,Ge,Z,Gt="After this one can then call:",Ve,R,Ye,X,et,d,G,pt,ce,Vt="Initialize KTOTrainer.",gt,x,V,_t,pe,Yt=`Llama tokenizer does not satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,ht,O,Y,ut,ge,ea="Computes log probabilities of the reference model for a single padded batch of a KTO specific dataset.",ft,w,ee,vt,_e,ta=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,bt,he,aa="Works both with or without labels.",Tt,j,te,Mt,ue,na="Compute the log probabilities of the given labels under the given logits.",yt,J,ae,wt,fe,oa="Compute the KTO loss and other metrics for the given batch of inputs for train or test.",Ct,I,ne,$t,ve,la="Generate samples from the model and reference model for the given batch of inputs.",Ut,C,oe,xt,be,ra="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",Ot,Te,ia="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",jt,$,le,Jt,Me,sa="Returns the training <code>~torch.utils.data.DataLoader</code>.",It,ye,da="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",kt,k,re,At,we,ma="Compute the KTO loss for a batch of policy and reference model log probabilities.",Nt,A,ie,Kt,Ce,ca="Log <code>logs</code> on the various objects watching training, including stored metrics.",Ft,M,se,Et,$e,pa="Tokenize a single row from a KTO specific dataset.",Lt,Ue,ga=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + completion responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the completion.`,qt,xe,_a=`We also create the labels for the completion responses, which are of length equal to
the sum of the length of the prompt and the completion response, with
label_pad_token_id  for the prompt tokens.`,tt,de,at,y,me,zt,Oe,ha='KTOConfig collects all training arguments related to the <a href="/docs/trl/main/en/kto_trainer#trl.KTOTrainer">KTOTrainer</a> class.',Dt,je,ua=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,nt,Fe,ot;return K=new Ne({props:{title:"KTO Trainer",local:"kto-trainer",headingTag:"h1"}}),E=new Ne({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),D=new Pt({props:{code:"a3RvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhleSUyQyUyMGhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoaSUyMG5pY2UlMjB0byUyMG1lZXQlMjB5b3UlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwZG9uJ3QlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJDJTJCJTJCJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySmF2YSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`kto_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;Hey, hello&quot;</span>,
        <span class="hljs-string">&quot;How are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;completion&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I don&#x27;t have a name&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;label&quot;</span>: [
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">False</span>,
    ],
}`,wrap:!1}}),H=new Ne({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),W=new Ne({props:{title:"Using the KTOTrainer",local:"using-the-ktotrainer",headingTag:"h2"}}),Q=new Pt({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMEtUT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBKSUwQSUwQWt0b190cmFpbmVyJTIwJTNEJTIwS1RPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX3JlZiUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:`training_args = KTOConfig(
    beta=<span class="hljs-number">0.1</span>,
)

kto_trainer = KTOTrainer(
    model,
    model_ref,
    args=training_args,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),R=new Pt({props:{code:"a3RvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"kto_trainer.train()",wrap:!1}}),X=new Ne({props:{title:"KTOTrainer",local:"trl.KTOTrainer",headingTag:"h2"}}),G=new T({props:{name:"class trl.KTOTrainer",anchor:"trl.KTOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"args",val:": KTOConfig = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.KTOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.KTOTrainer.args",description:`<strong>args</strong> (<code>KTOConfig</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.KTOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.KTOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.KTOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.KTOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.KTOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.KTOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.KTOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.KTOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.KTOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.KTOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.KTOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L66"}}),V=new T({props:{name:"build_tokenized_answer",anchor:"trl.KTOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L535"}}),Y=new T({props:{name:"compute_reference_log_probs",anchor:"trl.KTOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L495"}}),ee=new T({props:{name:"evaluation_loop",anchor:"trl.KTOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1027"}}),te=new T({props:{name:"get_batch_logps",anchor:"trl.KTOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L695",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),ae=new T({props:{name:"get_batch_loss_metrics",anchor:"trl.KTOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L829"}}),ne=new T({props:{name:"get_batch_samples",anchor:"trl.KTOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L941"}}),oe=new T({props:{name:"get_eval_dataloader",anchor:"trl.KTOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L452"}}),le=new T({props:{name:"get_train_dataloader",anchor:"trl.KTOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L422"}}),re=new T({props:{name:"kto_loss",anchor:"trl.KTOTrainer.kto_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"policy_KL_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"reference_KL_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L779",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards, KL).
The losses tensor contains the KTO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.
The KL tensor contains the detached KL divergence estimate between the policy and reference models.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of four tensors</p>
`}}),ie=new T({props:{name:"log",anchor:"trl.KTOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.KTOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1083"}}),se=new T({props:{name:"tokenize_row",anchor:"trl.KTOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L592"}}),de=new Ne({props:{title:"KTOConfig",local:"trl.KTOConfig",headingTag:"h2"}}),me=new T({props:{name:"class trl.KTOConfig",anchor:"trl.KTOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"evaluation_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Optional = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": int = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Optional = None"},{name:"deepspeed",val:": Optional = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Optional = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Optional = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"fp16_backend",val:": str = 'auto'"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"desirable_weight",val:": Optional = 1.0"},{name:"undesirable_weight",val:": Optional = 1.0"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.KTOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.KTOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.KTOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in KTO loss. Higher beta means less divergence from the initial policy.`,name:"beta"},{anchor:"trl.KTOConfig.desirable_weight",description:`<strong>desirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The desirable losses are weighed by this factor to counter unequal number of desirable and undesirable paris.`,name:"desirable_weight"},{anchor:"trl.KTOConfig.undesirable_weight",description:`<strong>undesirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The undesirable losses are weighed by this factor to counter unequal number of desirable and undesirable pairs.`,name:"undesirable_weight"},{anchor:"trl.KTOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.KTOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.KTOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.KTOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.KTOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.KTOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities for training and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string.
ref_model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the ref model from a string.`,name:"precompute_ref_log_probs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_config.py#L20"}}),{c(){U=r("meta"),Ee=a(),Ke=r("p"),Le=a(),p(K.$$.fragment),qe=a(),F=r("p"),F.innerHTML=Bt,ze=a(),p(E.$$.fragment),De=a(),L=r("p"),L.textContent=Wt,Pe=a(),q=r("ul"),q.innerHTML=St,He=a(),z=r("p"),z.textContent=Qt,Be=a(),p(D.$$.fragment),We=a(),P=r("p"),P.innerHTML=Zt,Se=a(),p(H.$$.fragment),Qe=a(),B=r("p"),B.innerHTML=Rt,Ze=a(),p(W.$$.fragment),Re=a(),S=r("p"),S.innerHTML=Xt,Xe=a(),p(Q.$$.fragment),Ge=a(),Z=r("p"),Z.textContent=Gt,Ve=a(),p(R.$$.fragment),Ye=a(),p(X.$$.fragment),et=a(),d=r("div"),p(G.$$.fragment),pt=a(),ce=r("p"),ce.textContent=Vt,gt=a(),x=r("div"),p(V.$$.fragment),_t=a(),pe=r("p"),pe.innerHTML=Yt,ht=a(),O=r("div"),p(Y.$$.fragment),ut=a(),ge=r("p"),ge.textContent=ea,ft=a(),w=r("div"),p(ee.$$.fragment),vt=a(),_e=r("p"),_e.innerHTML=ta,bt=a(),he=r("p"),he.textContent=aa,Tt=a(),j=r("div"),p(te.$$.fragment),Mt=a(),ue=r("p"),ue.textContent=na,yt=a(),J=r("div"),p(ae.$$.fragment),wt=a(),fe=r("p"),fe.textContent=oa,Ct=a(),I=r("div"),p(ne.$$.fragment),$t=a(),ve=r("p"),ve.textContent=la,Ut=a(),C=r("div"),p(oe.$$.fragment),xt=a(),be=r("p"),be.innerHTML=ra,Ot=a(),Te=r("p"),Te.innerHTML=ia,jt=a(),$=r("div"),p(le.$$.fragment),Jt=a(),Me=r("p"),Me.innerHTML=sa,It=a(),ye=r("p"),ye.innerHTML=da,kt=a(),k=r("div"),p(re.$$.fragment),At=a(),we=r("p"),we.textContent=ma,Nt=a(),A=r("div"),p(ie.$$.fragment),Kt=a(),Ce=r("p"),Ce.innerHTML=ca,Ft=a(),M=r("div"),p(se.$$.fragment),Et=a(),$e=r("p"),$e.textContent=pa,Lt=a(),Ue=r("p"),Ue.textContent=ga,qt=a(),xe=r("p"),xe.textContent=_a,tt=a(),p(de.$$.fragment),at=a(),y=r("div"),p(me.$$.fragment),zt=a(),Oe=r("p"),Oe.innerHTML=ha,Dt=a(),je=r("p"),je.innerHTML=ua,nt=a(),Fe=r("p"),this.h()},l(e){const l=ya("svelte-u9bgzb",document.head);U=i(l,"META",{name:!0,content:!0}),l.forEach(o),Ee=n(e),Ke=i(e,"P",{}),v(Ke).forEach(o),Le=n(e),g(K.$$.fragment,e),qe=n(e),F=i(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-uco8t1"&&(F.innerHTML=Bt),ze=n(e),g(E.$$.fragment,e),De=n(e),L=i(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-1792bye"&&(L.textContent=Wt),Pe=n(e),q=i(e,"UL",{"data-svelte-h":!0}),m(q)!=="svelte-1bk1n3o"&&(q.innerHTML=St),He=n(e),z=i(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1gl9mvz"&&(z.textContent=Qt),Be=n(e),g(D.$$.fragment,e),We=n(e),P=i(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-ft5huo"&&(P.innerHTML=Zt),Se=n(e),g(H.$$.fragment,e),Qe=n(e),B=i(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-znx0uh"&&(B.innerHTML=Rt),Ze=n(e),g(W.$$.fragment,e),Re=n(e),S=i(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1s8sgs3"&&(S.innerHTML=Xt),Xe=n(e),g(Q.$$.fragment,e),Ge=n(e),Z=i(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1lg6q1l"&&(Z.textContent=Gt),Ve=n(e),g(R.$$.fragment,e),Ye=n(e),g(X.$$.fragment,e),et=n(e),d=i(e,"DIV",{class:!0});var c=v(d);g(G.$$.fragment,c),pt=n(c),ce=i(c,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-hyhzxp"&&(ce.textContent=Vt),gt=n(c),x=i(c,"DIV",{class:!0});var lt=v(x);g(V.$$.fragment,lt),_t=n(lt),pe=i(lt,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-y1fzbp"&&(pe.innerHTML=Yt),lt.forEach(o),ht=n(c),O=i(c,"DIV",{class:!0});var rt=v(O);g(Y.$$.fragment,rt),ut=n(rt),ge=i(rt,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-pt6g01"&&(ge.textContent=ea),rt.forEach(o),ft=n(c),w=i(c,"DIV",{class:!0});var Je=v(w);g(ee.$$.fragment,Je),vt=n(Je),_e=i(Je,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-8qlty5"&&(_e.innerHTML=ta),bt=n(Je),he=i(Je,"P",{"data-svelte-h":!0}),m(he)!=="svelte-1tyo99t"&&(he.textContent=aa),Je.forEach(o),Tt=n(c),j=i(c,"DIV",{class:!0});var it=v(j);g(te.$$.fragment,it),Mt=n(it),ue=i(it,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-4nmimv"&&(ue.textContent=na),it.forEach(o),yt=n(c),J=i(c,"DIV",{class:!0});var st=v(J);g(ae.$$.fragment,st),wt=n(st),fe=i(st,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-db7iek"&&(fe.textContent=oa),st.forEach(o),Ct=n(c),I=i(c,"DIV",{class:!0});var dt=v(I);g(ne.$$.fragment,dt),$t=n(dt),ve=i(dt,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-18uwvbi"&&(ve.textContent=la),dt.forEach(o),Ut=n(c),C=i(c,"DIV",{class:!0});var Ie=v(C);g(oe.$$.fragment,Ie),xt=n(Ie),be=i(Ie,"P",{"data-svelte-h":!0}),m(be)!=="svelte-xesobz"&&(be.innerHTML=ra),Ot=n(Ie),Te=i(Ie,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-qg43tm"&&(Te.innerHTML=ia),Ie.forEach(o),jt=n(c),$=i(c,"DIV",{class:!0});var ke=v($);g(le.$$.fragment,ke),Jt=n(ke),Me=i(ke,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-dkae9b"&&(Me.innerHTML=sa),It=n(ke),ye=i(ke,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-hmd5cw"&&(ye.innerHTML=da),ke.forEach(o),kt=n(c),k=i(c,"DIV",{class:!0});var mt=v(k);g(re.$$.fragment,mt),At=n(mt),we=i(mt,"P",{"data-svelte-h":!0}),m(we)!=="svelte-svckwe"&&(we.textContent=ma),mt.forEach(o),Nt=n(c),A=i(c,"DIV",{class:!0});var ct=v(A);g(ie.$$.fragment,ct),Kt=n(ct),Ce=i(ct,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-nqksfz"&&(Ce.innerHTML=ca),ct.forEach(o),Ft=n(c),M=i(c,"DIV",{class:!0});var N=v(M);g(se.$$.fragment,N),Et=n(N),$e=i(N,"P",{"data-svelte-h":!0}),m($e)!=="svelte-118ojw5"&&($e.textContent=pa),Lt=n(N),Ue=i(N,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-1ku9h1p"&&(Ue.textContent=ga),qt=n(N),xe=i(N,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-qa9jmj"&&(xe.textContent=_a),N.forEach(o),c.forEach(o),tt=n(e),g(de.$$.fragment,e),at=n(e),y=i(e,"DIV",{class:!0});var Ae=v(y);g(me.$$.fragment,Ae),zt=n(Ae),Oe=i(Ae,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-1i1r5fd"&&(Oe.innerHTML=ha),Dt=n(Ae),je=i(Ae,"P",{"data-svelte-h":!0}),m(je)!=="svelte-1xl7jqc"&&(je.innerHTML=ua),Ae.forEach(o),nt=n(e),Fe=i(e,"P",{}),v(Fe).forEach(o),this.h()},h(){b(U,"name","hf:doc:metadata"),b(U,"content",Ca),b(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){t(document.head,U),s(e,Ee,l),s(e,Ke,l),s(e,Le,l),_(K,e,l),s(e,qe,l),s(e,F,l),s(e,ze,l),_(E,e,l),s(e,De,l),s(e,L,l),s(e,Pe,l),s(e,q,l),s(e,He,l),s(e,z,l),s(e,Be,l),_(D,e,l),s(e,We,l),s(e,P,l),s(e,Se,l),_(H,e,l),s(e,Qe,l),s(e,B,l),s(e,Ze,l),_(W,e,l),s(e,Re,l),s(e,S,l),s(e,Xe,l),_(Q,e,l),s(e,Ge,l),s(e,Z,l),s(e,Ve,l),_(R,e,l),s(e,Ye,l),_(X,e,l),s(e,et,l),s(e,d,l),_(G,d,null),t(d,pt),t(d,ce),t(d,gt),t(d,x),_(V,x,null),t(x,_t),t(x,pe),t(d,ht),t(d,O),_(Y,O,null),t(O,ut),t(O,ge),t(d,ft),t(d,w),_(ee,w,null),t(w,vt),t(w,_e),t(w,bt),t(w,he),t(d,Tt),t(d,j),_(te,j,null),t(j,Mt),t(j,ue),t(d,yt),t(d,J),_(ae,J,null),t(J,wt),t(J,fe),t(d,Ct),t(d,I),_(ne,I,null),t(I,$t),t(I,ve),t(d,Ut),t(d,C),_(oe,C,null),t(C,xt),t(C,be),t(C,Ot),t(C,Te),t(d,jt),t(d,$),_(le,$,null),t($,Jt),t($,Me),t($,It),t($,ye),t(d,kt),t(d,k),_(re,k,null),t(k,At),t(k,we),t(d,Nt),t(d,A),_(ie,A,null),t(A,Kt),t(A,Ce),t(d,Ft),t(d,M),_(se,M,null),t(M,Et),t(M,$e),t(M,Lt),t(M,Ue),t(M,qt),t(M,xe),s(e,tt,l),_(de,e,l),s(e,at,l),s(e,y,l),_(me,y,null),t(y,zt),t(y,Oe),t(y,Dt),t(y,je),s(e,nt,l),s(e,Fe,l),ot=!0},p:va,i(e){ot||(h(K.$$.fragment,e),h(E.$$.fragment,e),h(D.$$.fragment,e),h(H.$$.fragment,e),h(W.$$.fragment,e),h(Q.$$.fragment,e),h(R.$$.fragment,e),h(X.$$.fragment,e),h(G.$$.fragment,e),h(V.$$.fragment,e),h(Y.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(le.$$.fragment,e),h(re.$$.fragment,e),h(ie.$$.fragment,e),h(se.$$.fragment,e),h(de.$$.fragment,e),h(me.$$.fragment,e),ot=!0)},o(e){u(K.$$.fragment,e),u(E.$$.fragment,e),u(D.$$.fragment,e),u(H.$$.fragment,e),u(W.$$.fragment,e),u(Q.$$.fragment,e),u(R.$$.fragment,e),u(X.$$.fragment,e),u(G.$$.fragment,e),u(V.$$.fragment,e),u(Y.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(le.$$.fragment,e),u(re.$$.fragment,e),u(ie.$$.fragment,e),u(se.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),ot=!1},d(e){e&&(o(Ee),o(Ke),o(Le),o(qe),o(F),o(ze),o(De),o(L),o(Pe),o(q),o(He),o(z),o(Be),o(We),o(P),o(Se),o(Qe),o(B),o(Ze),o(Re),o(S),o(Xe),o(Ge),o(Z),o(Ve),o(Ye),o(et),o(d),o(tt),o(at),o(y),o(nt),o(Fe)),o(U),f(K,e),f(E,e),f(D,e),f(H,e),f(W,e),f(Q,e),f(R,e),f(X,e),f(G),f(V),f(Y),f(ee),f(te),f(ae),f(ne),f(oe),f(le),f(re),f(ie),f(se),f(de,e),f(me)}}}const Ca='{"title":"KTO Trainer","local":"kto-trainer","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the KTOTrainer","local":"using-the-ktotrainer","sections":[],"depth":2},{"title":"KTOTrainer","local":"trl.KTOTrainer","sections":[],"depth":2},{"title":"KTOConfig","local":"trl.KTOConfig","sections":[],"depth":2}],"depth":1}';function $a(Ht){return ba(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ia extends Ta{constructor(U){super(),Ma(this,U,$a,wa,fa,{})}}export{Ia as component};
