import{s as es,n as ls,o as ts}from"../chunks/scheduler.eb244325.js";import{S as ss,i as as,e as o,s as a,c as M,q as ns,h as os,a as i,d as t,b as n,f as Ot,g as r,j as p,r as is,k as Mt,l as ps,m as s,n as c,t as m,o as y,p as w}from"../chunks/index.3fe63ad3.js";import{C as Ms}from"../chunks/CopyLLMTxtMenu.9e6f31ad.js";import{C as J}from"../chunks/CodeBlock.9d957056.js";import{H as j,E as rs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b7f3e490.js";function cs(rt){let T,Re,xe,Se,b,Xe,u,Qe,h,ct="This tutorial will explain how to integrate your own robot design into the LeRobot ecosystem and have it access all of our tools (data collection, control pipelines, policy training and inference).",ze,f,mt='To that end, we provide the <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/robots/robot.py" rel="nofollow"><code>Robot</code></a> base class in the LeRobot which specifies a standard interface for physical robot integration. Let’s see how to implement it.',He,U,Ve,I,yt='<li>Your own robot which exposes a communication interface (e.g. serial, CAN, TCP)</li> <li>A way to read sensor data and send motor commands programmatically, e.g. manufacturer’s SDK or API, or your own protocol implementation.</li> <li>LeRobot installed in your environment. Follow our <a href="./installation.mdx">Installation Guide</a>.</li>',Fe,C,Le,v,wt="If you’re using Feetech or Dynamixel motors, LeRobot provides built-in bus interfaces:",qe,g,jt='<li><a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/motors/feetech/feetech.py" rel="nofollow"><code>FeetechMotorsBus</code></a> – for controlling Feetech servos</li> <li><a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/motors/dynamixel/dynamixel.py" rel="nofollow"><code>DynamixelMotorsBus</code></a> – for controlling Dynamixel servos</li>',De,B,Jt=`Please refer to the <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/motors/motors_bus.py" rel="nofollow"><code>MotorsBus</code></a> abstract class to learn about its API.
For a good example of how it can be used, you can have a look at our own <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/robots/so101_follower/so101_follower.py" rel="nofollow">SO101 follower implementation</a>`,Pe,A,Tt="Use these if compatible. Otherwise, you’ll need to find or write a Python interface (not covered in this tutorial):",Ke,$,dt="<li>Find an existing SDK in Python (or use bindings to C/C++)</li> <li>Or implement a basic communication wrapper (e.g., via pyserial, socket, or CANopen)</li>",Oe,_,bt="You’re not alone—many community contributions use custom boards or firmware!",el,Z,ut="For Feetech and Dynamixel, we currently support these servos: - Feetech: - STS &amp; SMS series (protocol 0): <code>sts3215</code>, <code>sts3250</code>, <code>sm8512bl</code> - SCS series (protocol 1): <code>scs0009</code> - Dynamixel (protocol 2.0 only): <code>xl330-m077</code>, <code>xl330-m288</code>, <code>xl430-w250</code>, <code>xm430-w350</code>, <code>xm540-w270</code>, <code>xc430-w150</code>",ll,k,ht='If you are using Feetech or Dynamixel servos that are not in this list, you can add those in the <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/motors/feetech/tables.py" rel="nofollow">Feetech table</a> or <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/motors/dynamixel/tables.py" rel="nofollow">Dynamixel table</a>. Depending on the model, this will require you to add model-specific information. In most cases though, there shouldn’t be a lot of additions to do.',tl,G,ft="In the next sections, we’ll use a <code>FeetechMotorsBus</code> as the motors interface for the examples. Replace it and adapt to your motors if necessary.",sl,W,al,Y,Ut="You’ll first need to specify the config class and a string identifier (<code>name</code>) for your robot. If your robot has special needs that you’d like to be able to change easily, it should go here (e.g. port/address, baudrate).",nl,N,It="Here, we’ll add the port name and one camera by default for our robot:",ol,x,il,E,Ct='<a href="./cameras.mdx">Cameras tutorial</a> to understand how to detect and add your camera.',pl,R,vt="Next, we’ll create our actual robot class which inherits from <code>Robot</code>. This abstract class defines a contract you must follow for your robot to be usable with the rest of the LeRobot tools.",Ml,S,gt="Here we’ll create a simple 5-DoF robot with one camera. It could be a simple arm but notice that the <code>Robot</code> abstract class does not assume anything on your robot’s form factor. You can let you imagination run wild when designing new robots!",rl,X,cl,Q,ml,z,Bt="These two properties define the <em>interface contract</em> between your robot and tools that consume it (such as data collection or learning pipelines).",yl,d,At="<p>Note that these properties must be callable even if the robot is not yet connected, so avoid relying on runtime hardware state to define them.</p>",wl,H,jl,V,$t="This property should return a dictionary describing the structure of sensor outputs from your robot. The keys match what <code>get_observation()</code> returns, and the values describe either the shape (for arrays/images) or the type (for simple values).",Jl,F,_t="Example for our 5-DoF arm with one camera:",Tl,L,dl,q,Zt="In this case, observations consist of a simple dict storing each motor’s position and a camera image.",bl,D,ul,P,kt="This property describes the commands your robot expects via <code>send_action()</code>. Again, keys must match the expected input format, and values define the shape/type of each command.",hl,K,Gt="Here, we simply use the same joints proprioceptive features (<code>self._motors_ft</code>) as with <code>observation_features</code>: the action sent will simply the goal position for each motor.",fl,O,Ul,ee,Il,le,Wt="These methods should handle opening and closing communication with your hardware (e.g. serial ports, CAN interfaces, USB devices, cameras).",Cl,te,vl,se,Yt="This property should simply reflect that communication with the robot’s hardware is established. When this property is <code>True</code>, it should be possible to read and write to the hardware using <code>get_observation()</code> and <code>send_action()</code>.",gl,ae,Bl,ne,Al,oe,Nt="This method should establish communication with the hardware. Moreover, if your robot needs calibration and is not calibrated, it should start a calibration procedure by default. If your robot needs some specific configuration, this should also be called here.",$l,ie,_l,pe,Zl,Me,xt="This method should gracefully terminate communication with the hardware: free any related resources (threads or processes), close ports, etc.",kl,re,Et="Here, we already handle this in our <code>MotorsBus</code> and <code>Camera</code> classes so we just need to call their own <code>disconnect()</code> methods:",Gl,ce,Wl,me,Yl,ye,Rt="LeRobot supports saving and loading calibration data automatically. This is useful for joint offsets, zero positions, or sensor alignment.",Nl,we,St="<p>Note that depending on your hardware, this may not apply. If that’s the case, you can simply leave these methods as no-ops:</p>",xl,je,El,Je,Xt=`@property
def is_calibrated(self) -> bool:
return self.bus.is_calibrated`,Rl,Te,Sl,de,Xl,be,Qt="Use this to set up any configuration for your hardware (servos control modes, controller gains, etc.). This should usually be run at connection time and be idempotent.",Ql,ue,zl,he,Hl,fe,zt="These are the most important runtime functions: the core I/O loop.",Vl,Ue,Fl,Ie,Ht="Returns a dictionary of sensor values from the robot. These typically include motor states, camera frames, various sensors, etc. In the LeRobot framework, these observations are what will be fed to a policy in order to predict the actions to take. The dictionary keys and structure must match <code>observation_features</code>.",Ll,Ce,ql,ve,Dl,ge,Vt="Takes a dictionary that matches <code>action_features</code>, and sends it to your hardware. You can add safety limits (clipping, smoothing) and return what was actually sent.",Pl,Be,Ft="For simplicity, we won’t be adding any modification of the actions in our example here.",Kl,Ae,Ol,$e,et,_e,Lt='For implementing teleoperation devices, we also provide a <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/teleoperators/teleoperator.py" rel="nofollow"><code>Teleoperator</code></a> base class. This class is very similar to the <code>Robot</code> base class and also doesn’t assume anything on form factor.',lt,Ze,qt="The main differences are in the I/O functions: a teleoperator allows you to produce action via <code>get_action</code> and can receive feedback actions via <code>send_feedback</code>. Feedback could be anything controllable on the teleoperation device that could help the person controlling it understand the consequences of the actions sent. Think motion/force feedback on a leader arm, vibrations on a gamepad controller for example. To implement a teleoperator, you can follow this same tutorial and adapt it for these two methods.",tt,ke,st,Ge,Dt="Once your robot class is complete, you can leverage the LeRobot ecosystem:",at,We,Pt="<li>Control your robot with available teleoperators or integrate directly your teleoperating device</li> <li>Record training data and visualize it</li> <li>Integrate it into RL or imitation learning pipelines</li>",nt,Ye,Kt='Don’t hesitate to reach out to the community for help on our <a href="https://discord.gg/s3KuuzsPFb" rel="nofollow">Discord</a> 🤗',ot,Ne,it,Ee,pt;return b=new Ms({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),u=new j({props:{title:"Bring Your Own Hardware",local:"bring-your-own-hardware",headingTag:"h1"}}),U=new j({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h2"}}),C=new j({props:{title:"Choose your motors",local:"choose-your-motors",headingTag:"h2"}}),W=new j({props:{title:"Step 1: Subclass the Robot Interface",local:"step-1-subclass-the-robot-interface",headingTag:"h2"}}),x=new J({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTJDJTIwZmllbGQlMEElMEFmcm9tJTIwbGVyb2JvdC5jYW1lcmFzJTIwaW1wb3J0JTIwQ2FtZXJhQ29uZmlnJTBBZnJvbSUyMGxlcm9ib3QuY2FtZXJhcy5vcGVuY3YlMjBpbXBvcnQlMjBPcGVuQ1ZDYW1lcmFDb25maWclMEFmcm9tJTIwbGVyb2JvdC5yb2JvdHMlMjBpbXBvcnQlMjBSb2JvdENvbmZpZyUwQSUwQSUwQSU0MFJvYm90Q29uZmlnLnJlZ2lzdGVyX3N1YmNsYXNzKCUyMm15X2Nvb2xfcm9ib3QlMjIpJTBBJTQwZGF0YWNsYXNzJTBBY2xhc3MlMjBNeUNvb2xSb2JvdENvbmZpZyhSb2JvdENvbmZpZyklM0ElMEElMjAlMjAlMjAlMjBwb3J0JTNBJTIwc3RyJTBBJTIwJTIwJTIwJTIwY2FtZXJhcyUzQSUyMGRpY3QlNUJzdHIlMkMlMjBDYW1lcmFDb25maWclNUQlMjAlM0QlMjBmaWVsZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZWZhdWx0X2ZhY3RvcnklM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjYW1fMSUyMiUzQSUyME9wZW5DVkNhbWVyYUNvbmZpZyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbmRleF9vcl9wYXRoJTNEMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZwcyUzRDMwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2lkdGglM0Q0ODAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBoZWlnaHQlM0Q2NDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass, field

<span class="hljs-keyword">from</span> lerobot.cameras <span class="hljs-keyword">import</span> CameraConfig
<span class="hljs-keyword">from</span> lerobot.cameras.opencv <span class="hljs-keyword">import</span> OpenCVCameraConfig
<span class="hljs-keyword">from</span> lerobot.robots <span class="hljs-keyword">import</span> RobotConfig


<span class="hljs-meta">@RobotConfig.register_subclass(<span class="hljs-params"><span class="hljs-string">&quot;my_cool_robot&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyCoolRobotConfig</span>(<span class="hljs-title class_ inherited__">RobotConfig</span>):
    port: <span class="hljs-built_in">str</span>
    cameras: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, CameraConfig] = field(
        default_factory={
            <span class="hljs-string">&quot;cam_1&quot;</span>: OpenCVCameraConfig(
                index_or_path=<span class="hljs-number">2</span>,
                fps=<span class="hljs-number">30</span>,
                width=<span class="hljs-number">480</span>,
                height=<span class="hljs-number">640</span>,
            ),
        }
    )`,wrap:!1}}),X=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> lerobot.cameras <span class="hljs-keyword">import</span> make_cameras_from_configs
<span class="hljs-keyword">from</span> lerobot.motors <span class="hljs-keyword">import</span> Motor, MotorNormMode
<span class="hljs-keyword">from</span> lerobot.motors.feetech <span class="hljs-keyword">import</span> FeetechMotorsBus
<span class="hljs-keyword">from</span> lerobot.robots <span class="hljs-keyword">import</span> Robot

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyCoolRobot</span>(<span class="hljs-title class_ inherited__">Robot</span>):
    config_class = MyCoolRobotConfig
    name = <span class="hljs-string">&quot;my_cool_robot&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: MyCoolRobotConfig</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        self.bus = FeetechMotorsBus(
            port=self.config.port,
            motors={
                <span class="hljs-string">&quot;joint_1&quot;</span>: Motor(<span class="hljs-number">1</span>, <span class="hljs-string">&quot;sts3250&quot;</span>, MotorNormMode.RANGE_M100_100),
                <span class="hljs-string">&quot;joint_2&quot;</span>: Motor(<span class="hljs-number">2</span>, <span class="hljs-string">&quot;sts3215&quot;</span>, MotorNormMode.RANGE_M100_100),
                <span class="hljs-string">&quot;joint_3&quot;</span>: Motor(<span class="hljs-number">3</span>, <span class="hljs-string">&quot;sts3215&quot;</span>, MotorNormMode.RANGE_M100_100),
                <span class="hljs-string">&quot;joint_4&quot;</span>: Motor(<span class="hljs-number">4</span>, <span class="hljs-string">&quot;sts3215&quot;</span>, MotorNormMode.RANGE_M100_100),
                <span class="hljs-string">&quot;joint_5&quot;</span>: Motor(<span class="hljs-number">5</span>, <span class="hljs-string">&quot;sts3215&quot;</span>, MotorNormMode.RANGE_M100_100),
            },
            calibration=self.calibration,
        )
        self.cameras = make_cameras_from_configs(config.cameras)`,wrap:!1}}),Q=new j({props:{title:"Step 2: Define Observation and Action Features",local:"step-2-define-observation-and-action-features",headingTag:"h2"}}),H=new j({props:{title:"observation_features",local:"observationfeatures",headingTag:"h3"}}),L=new J({props:{code:"JTQwcHJvcGVydHklMEFkZWYlMjBfbW90b3JzX2Z0KHNlbGYpJTIwLSUzRSUyMGRpY3QlNUJzdHIlMkMlMjB0eXBlJTVEJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyam9pbnRfMS5wb3MlMjIlM0ElMjBmbG9hdCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmpvaW50XzIucG9zJTIyJTNBJTIwZmxvYXQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJqb2ludF8zLnBvcyUyMiUzQSUyMGZsb2F0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyam9pbnRfNC5wb3MlMjIlM0ElMjBmbG9hdCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmpvaW50XzUucG9zJTIyJTNBJTIwZmxvYXQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEElMEElNDBwcm9wZXJ0eSUwQWRlZiUyMF9jYW1lcmFzX2Z0KHNlbGYpJTIwLSUzRSUyMGRpY3QlNUJzdHIlMkMlMjB0dXBsZSU1RCUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhbSUzQSUyMChzZWxmLmNhbWVyYXMlNUJjYW0lNUQuaGVpZ2h0JTJDJTIwc2VsZi5jYW1lcmFzJTVCY2FtJTVELndpZHRoJTJDJTIwMyklMjBmb3IlMjBjYW0lMjBpbiUyMHNlbGYuY2FtZXJhcyUwQSUyMCUyMCUyMCUyMCU3RCUwQSUwQSU0MHByb3BlcnR5JTBBZGVmJTIwb2JzZXJ2YXRpb25fZmVhdHVyZXMoc2VsZiklMjAtJTNFJTIwZGljdCUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3Qioqc2VsZi5fbW90b3JzX2Z0JTJDJTIwKipzZWxmLl9jYW1lcmFzX2Z0JTdE",highlighted:`<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">_motors_ft</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">type</span>]:
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;joint_1.pos&quot;</span>: <span class="hljs-built_in">float</span>,
        <span class="hljs-string">&quot;joint_2.pos&quot;</span>: <span class="hljs-built_in">float</span>,
        <span class="hljs-string">&quot;joint_3.pos&quot;</span>: <span class="hljs-built_in">float</span>,
        <span class="hljs-string">&quot;joint_4.pos&quot;</span>: <span class="hljs-built_in">float</span>,
        <span class="hljs-string">&quot;joint_5.pos&quot;</span>: <span class="hljs-built_in">float</span>,
    }

<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">_cameras_ft</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">tuple</span>]:
    <span class="hljs-keyword">return</span> {
        cam: (self.cameras[cam].height, self.cameras[cam].width, <span class="hljs-number">3</span>) <span class="hljs-keyword">for</span> cam <span class="hljs-keyword">in</span> self.cameras
    }

<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">observation_features</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>:
    <span class="hljs-keyword">return</span> {**self._motors_ft, **self._cameras_ft}`,wrap:!1}}),D=new j({props:{title:"action_features",local:"actionfeatures",headingTag:"h3"}}),O=new J({props:{code:"ZGVmJTIwYWN0aW9uX2ZlYXR1cmVzKHNlbGYpJTIwLSUzRSUyMGRpY3QlM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLl9tb3RvcnNfZnQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">action_features</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>:
    <span class="hljs-keyword">return</span> self._motors_ft`,wrap:!1}}),ee=new j({props:{title:"Step 3: Handle Connection and Disconnection",local:"step-3-handle-connection-and-disconnection",headingTag:"h2"}}),te=new j({props:{title:"is_connected",local:"isconnected",headingTag:"h3"}}),ae=new J({props:{code:"JTQwcHJvcGVydHklMEFkZWYlMjBpc19jb25uZWN0ZWQoc2VsZiklMjAtJTNFJTIwYm9vbCUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYuYnVzLmlzX2Nvbm5lY3RlZCUyMGFuZCUyMGFsbChjYW0uaXNfY29ubmVjdGVkJTIwZm9yJTIwY2FtJTIwaW4lMjBzZWxmLmNhbWVyYXMudmFsdWVzKCkp",highlighted:`<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_connected</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">bool</span>:
    <span class="hljs-keyword">return</span> self.bus.is_connected <span class="hljs-keyword">and</span> <span class="hljs-built_in">all</span>(cam.is_connected <span class="hljs-keyword">for</span> cam <span class="hljs-keyword">in</span> self.cameras.values())`,wrap:!1}}),ne=new j({props:{title:"connect()",local:"connect",headingTag:"h3"}}),ie=new J({props:{code:"ZGVmJTIwY29ubmVjdChzZWxmJTJDJTIwY2FsaWJyYXRlJTNBJTIwYm9vbCUyMCUzRCUyMFRydWUpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjBzZWxmLmJ1cy5jb25uZWN0KCklMEElMjAlMjAlMjAlMjBpZiUyMG5vdCUyMHNlbGYuaXNfY2FsaWJyYXRlZCUyMGFuZCUyMGNhbGlicmF0ZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY2FsaWJyYXRlKCklMEElMEElMjAlMjAlMjAlMjBmb3IlMjBjYW0lMjBpbiUyMHNlbGYuY2FtZXJhcy52YWx1ZXMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhbS5jb25uZWN0KCklMEElMEElMjAlMjAlMjAlMjBzZWxmLmNvbmZpZ3VyZSgp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">connect</span>(<span class="hljs-params">self, calibrate: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">True</span></span>) -&gt; <span class="hljs-literal">None</span>:
    self.bus.connect()
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.is_calibrated <span class="hljs-keyword">and</span> calibrate:
        self.calibrate()

    <span class="hljs-keyword">for</span> cam <span class="hljs-keyword">in</span> self.cameras.values():
        cam.connect()

    self.configure()`,wrap:!1}}),pe=new j({props:{title:"disconnect()",local:"disconnect",headingTag:"h3"}}),ce=new J({props:{code:"ZGVmJTIwZGlzY29ubmVjdChzZWxmKSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwc2VsZi5idXMuZGlzY29ubmVjdCgpJTBBJTIwJTIwJTIwJTIwZm9yJTIwY2FtJTIwaW4lMjBzZWxmLmNhbWVyYXMudmFsdWVzKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYW0uZGlzY29ubmVjdCgp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">disconnect</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
    self.bus.disconnect()
    <span class="hljs-keyword">for</span> cam <span class="hljs-keyword">in</span> self.cameras.values():
        cam.disconnect()`,wrap:!1}}),me=new j({props:{title:"Step 4: Support Calibration and Configuration",local:"step-4-support-calibration-and-configuration",headingTag:"h2"}}),je=new J({props:{code:"JTNFJTIwJTQwcHJvcGVydHklMEElM0UlMjBkZWYlMjBpc19jYWxpYnJhdGVkKHNlbGYpJTIwLSUzRSUyMGJvb2wlM0ElMEElM0UlMjAlMjAlMjAlMjByZXR1cm4lMjBUcnVlJTBBJTNFJTBBJTNFJTIwZGVmJTIwY2FsaWJyYXRlKHNlbGYpJTIwLSUzRSUyME5vbmUlM0ElMEElM0UlMjAlMjAlMjAlMjBwYXNzJTBBJTNFJTIwJTYwJTYwJTYwJTBBJTBBJTIzJTIzJTIzJTIwJTYwaXNfY2FsaWJyYXRlZCU2MCUwQSUwQVRoaXMlMjBzaG91bGQlMjByZWZsZWN0JTIwd2hldGhlciUyMHlvdXIlMjByb2JvdCUyMGhhcyUyMHRoZSUyMHJlcXVpcmVkJTIwY2FsaWJyYXRpb24lMjBsb2FkZWQuJTBB",highlighted:`&gt; @<span class="hljs-built_in">property</span>
&gt; <span class="hljs-keyword">def</span> <span class="hljs-title function_">is_calibrated</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">bool</span>:
&gt;    <span class="hljs-keyword">return</span> <span class="hljs-literal">True</span>
&gt;
&gt; <span class="hljs-keyword">def</span> <span class="hljs-title function_">calibrate</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
&gt;    <span class="hljs-keyword">pass</span>
&gt; \`\`\`

<span class="hljs-comment">### \`is_calibrated\`</span>

This should reflect whether your robot has the required calibration loaded.
`,wrap:!1}}),Te=new J({props:{code:"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",highlighted:`
<span class="hljs-comment">### \`calibrate()\`</span>

The goal of the calibration <span class="hljs-keyword">is</span> twofold:
    - Know the physical <span class="hljs-built_in">range</span> of motion of each motors <span class="hljs-keyword">in</span> order to only send commands within this <span class="hljs-built_in">range</span>.
    - Normalize raw motors positions to sensible continuous values (e.g. percentages, degrees) instead of arbitrary discrete value dependant on the specific motor used that will <span class="hljs-keyword">not</span> replicate elsewhere.

It should implement the logic <span class="hljs-keyword">for</span> calibration (<span class="hljs-keyword">if</span> relevant) <span class="hljs-keyword">and</span> update the \`self.calibration\` dictionary. If you are using Feetech <span class="hljs-keyword">or</span> Dynamixel motors, our bus interfaces already include methods to <span class="hljs-built_in">help</span> <span class="hljs-keyword">with</span> this.


&lt;!-- prettier-ignore-start --&gt;
\`\`\`python
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calibrate</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
    self.bus.disable_torque()
    <span class="hljs-keyword">for</span> motor <span class="hljs-keyword">in</span> self.bus.motors:
        self.bus.write(<span class="hljs-string">&quot;Operating_Mode&quot;</span>, motor, OperatingMode.POSITION.value)

    <span class="hljs-built_in">input</span>(<span class="hljs-string">f&quot;Move <span class="hljs-subst">{self}</span> to the middle of its range of motion and press ENTER....&quot;</span>)
    homing_offsets = self.bus.set_half_turn_homings()

    <span class="hljs-built_in">print</span>(
        <span class="hljs-string">&quot;Move all joints sequentially through their entire ranges &quot;</span>
        <span class="hljs-string">&quot;of motion.\\nRecording positions. Press ENTER to stop...&quot;</span>
    )
    range_mins, range_maxes = self.bus.record_ranges_of_motion()

    self.calibration = {}
    <span class="hljs-keyword">for</span> motor, m <span class="hljs-keyword">in</span> self.bus.motors.items():
        self.calibration[motor] = MotorCalibration(
            <span class="hljs-built_in">id</span>=m.<span class="hljs-built_in">id</span>,
            drive_mode=<span class="hljs-number">0</span>,
            homing_offset=homing_offsets[motor],
            range_min=range_mins[motor],
            range_max=range_maxes[motor],
        )

    self.bus.write_calibration(self.calibration)
    self._save_calibration()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Calibration saved to&quot;</span>, self.calibration_fpath)`,wrap:!1}}),de=new j({props:{title:"configure()",local:"configure",headingTag:"h3"}}),ue=new J({props:{code:"ZGVmJTIwY29uZmlndXJlKHNlbGYpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwc2VsZi5idXMudG9ycXVlX2Rpc2FibGVkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmJ1cy5jb25maWd1cmVfbW90b3JzKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBtb3RvciUyMGluJTIwc2VsZi5idXMubW90b3JzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5idXMud3JpdGUoJTIyT3BlcmF0aW5nX01vZGUlMjIlMkMlMjBtb3RvciUyQyUyME9wZXJhdGluZ01vZGUuUE9TSVRJT04udmFsdWUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5idXMud3JpdGUoJTIyUF9Db2VmZmljaWVudCUyMiUyQyUyMG1vdG9yJTJDJTIwMTYpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5idXMud3JpdGUoJTIySV9Db2VmZmljaWVudCUyMiUyQyUyMG1vdG9yJTJDJTIwMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmJ1cy53cml0ZSglMjJEX0NvZWZmaWNpZW50JTIyJTJDJTIwbW90b3IlMkMlMjAzMik=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">configure</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">with</span> self.bus.torque_disabled():
        self.bus.configure_motors()
        <span class="hljs-keyword">for</span> motor <span class="hljs-keyword">in</span> self.bus.motors:
            self.bus.write(<span class="hljs-string">&quot;Operating_Mode&quot;</span>, motor, OperatingMode.POSITION.value)
            self.bus.write(<span class="hljs-string">&quot;P_Coefficient&quot;</span>, motor, <span class="hljs-number">16</span>)
            self.bus.write(<span class="hljs-string">&quot;I_Coefficient&quot;</span>, motor, <span class="hljs-number">0</span>)
            self.bus.write(<span class="hljs-string">&quot;D_Coefficient&quot;</span>, motor, <span class="hljs-number">32</span>)`,wrap:!1}}),he=new j({props:{title:"Step 5: Implement Sensors Reading and Action Sending",local:"step-5-implement-sensors-reading-and-action-sending",headingTag:"h2"}}),Ue=new j({props:{title:"get_observation()",local:"getobservation",headingTag:"h3"}}),Ce=new J({props:{code:"ZGVmJTIwZ2V0X29ic2VydmF0aW9uKHNlbGYpJTIwLSUzRSUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQlM0ElMEElMjAlMjAlMjAlMjBpZiUyMG5vdCUyMHNlbGYuaXNfY29ubmVjdGVkJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmFpc2UlMjBDb25uZWN0aW9uRXJyb3IoZiUyMiU3QnNlbGYlN0QlMjBpcyUyMG5vdCUyMGNvbm5lY3RlZC4lMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwUmVhZCUyMGFybSUyMHBvc2l0aW9uJTBBJTIwJTIwJTIwJTIwb2JzX2RpY3QlMjAlM0QlMjBzZWxmLmJ1cy5zeW5jX3JlYWQoJTIyUHJlc2VudF9Qb3NpdGlvbiUyMiklMEElMjAlMjAlMjAlMjBvYnNfZGljdCUyMCUzRCUyMCU3QmYlMjIlN0Jtb3RvciU3RC5wb3MlMjIlM0ElMjB2YWwlMjBmb3IlMjBtb3RvciUyQyUyMHZhbCUyMGluJTIwb2JzX2RpY3QuaXRlbXMoKSU3RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMENhcHR1cmUlMjBpbWFnZXMlMjBmcm9tJTIwY2FtZXJhcyUwQSUyMCUyMCUyMCUyMGZvciUyMGNhbV9rZXklMkMlMjBjYW0lMjBpbiUyMHNlbGYuY2FtZXJhcy5pdGVtcygpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb2JzX2RpY3QlNUJjYW1fa2V5JTVEJTIwJTNEJTIwY2FtLmFzeW5jX3JlYWQoKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG9ic19kaWN0",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_observation</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.is_connected:
        <span class="hljs-keyword">raise</span> ConnectionError(<span class="hljs-string">f&quot;<span class="hljs-subst">{self}</span> is not connected.&quot;</span>)

    <span class="hljs-comment"># Read arm position</span>
    obs_dict = self.bus.sync_read(<span class="hljs-string">&quot;Present_Position&quot;</span>)
    obs_dict = {<span class="hljs-string">f&quot;<span class="hljs-subst">{motor}</span>.pos&quot;</span>: val <span class="hljs-keyword">for</span> motor, val <span class="hljs-keyword">in</span> obs_dict.items()}

    <span class="hljs-comment"># Capture images from cameras</span>
    <span class="hljs-keyword">for</span> cam_key, cam <span class="hljs-keyword">in</span> self.cameras.items():
        obs_dict[cam_key] = cam.async_read()

    <span class="hljs-keyword">return</span> obs_dict`,wrap:!1}}),ve=new j({props:{title:"send_action()",local:"sendaction",headingTag:"h3"}}),Ae=new J({props:{code:"ZGVmJTIwc2VuZF9hY3Rpb24oc2VsZiUyQyUyMGFjdGlvbiUzQSUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQpJTIwLSUzRSUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQlM0ElMEElMjAlMjAlMjAlMjBnb2FsX3BvcyUyMCUzRCUyMCU3QmtleS5yZW1vdmVzdWZmaXgoJTIyLnBvcyUyMiklM0ElMjB2YWwlMjBmb3IlMjBrZXklMkMlMjB2YWwlMjBpbiUyMGFjdGlvbi5pdGVtcygpJTdEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwU2VuZCUyMGdvYWwlMjBwb3NpdGlvbiUyMHRvJTIwdGhlJTIwYXJtJTBBJTIwJTIwJTIwJTIwc2VsZi5idXMuc3luY193cml0ZSglMjJHb2FsX1Bvc2l0aW9uJTIyJTJDJTIwZ29hbF9wb3MpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYWN0aW9u",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">send_action</span>(<span class="hljs-params">self, action: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
    goal_pos = {key.removesuffix(<span class="hljs-string">&quot;.pos&quot;</span>): val <span class="hljs-keyword">for</span> key, val <span class="hljs-keyword">in</span> action.items()}

    <span class="hljs-comment"># Send goal position to the arm</span>
    self.bus.sync_write(<span class="hljs-string">&quot;Goal_Position&quot;</span>, goal_pos)

    <span class="hljs-keyword">return</span> action`,wrap:!1}}),$e=new j({props:{title:"Adding a Teleoperator",local:"adding-a-teleoperator",headingTag:"h2"}}),ke=new j({props:{title:"Wrapping Up",local:"wrapping-up",headingTag:"h2"}}),Ne=new rs({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/integrate_hardware.mdx"}}),{c(){T=o("meta"),Re=a(),xe=o("p"),Se=a(),M(b.$$.fragment),Xe=a(),M(u.$$.fragment),Qe=a(),h=o("p"),h.textContent=ct,ze=a(),f=o("p"),f.innerHTML=mt,He=a(),M(U.$$.fragment),Ve=a(),I=o("ul"),I.innerHTML=yt,Fe=a(),M(C.$$.fragment),Le=a(),v=o("p"),v.textContent=wt,qe=a(),g=o("ul"),g.innerHTML=jt,De=a(),B=o("p"),B.innerHTML=Jt,Pe=a(),A=o("p"),A.textContent=Tt,Ke=a(),$=o("ul"),$.innerHTML=dt,Oe=a(),_=o("p"),_.textContent=bt,el=a(),Z=o("p"),Z.innerHTML=ut,ll=a(),k=o("p"),k.innerHTML=ht,tl=a(),G=o("p"),G.innerHTML=ft,sl=a(),M(W.$$.fragment),al=a(),Y=o("p"),Y.innerHTML=Ut,nl=a(),N=o("p"),N.textContent=It,ol=a(),M(x.$$.fragment),il=a(),E=o("p"),E.innerHTML=Ct,pl=a(),R=o("p"),R.innerHTML=vt,Ml=a(),S=o("p"),S.innerHTML=gt,rl=a(),M(X.$$.fragment),cl=a(),M(Q.$$.fragment),ml=a(),z=o("p"),z.innerHTML=Bt,yl=a(),d=o("blockquote"),d.innerHTML=At,wl=a(),M(H.$$.fragment),jl=a(),V=o("p"),V.innerHTML=$t,Jl=a(),F=o("p"),F.textContent=_t,Tl=a(),M(L.$$.fragment),dl=a(),q=o("p"),q.textContent=Zt,bl=a(),M(D.$$.fragment),ul=a(),P=o("p"),P.innerHTML=kt,hl=a(),K=o("p"),K.innerHTML=Gt,fl=a(),M(O.$$.fragment),Ul=a(),M(ee.$$.fragment),Il=a(),le=o("p"),le.textContent=Wt,Cl=a(),M(te.$$.fragment),vl=a(),se=o("p"),se.innerHTML=Yt,gl=a(),M(ae.$$.fragment),Bl=a(),M(ne.$$.fragment),Al=a(),oe=o("p"),oe.textContent=Nt,$l=a(),M(ie.$$.fragment),_l=a(),M(pe.$$.fragment),Zl=a(),Me=o("p"),Me.textContent=xt,kl=a(),re=o("p"),re.innerHTML=Et,Gl=a(),M(ce.$$.fragment),Wl=a(),M(me.$$.fragment),Yl=a(),ye=o("p"),ye.textContent=Rt,Nl=a(),we=o("blockquote"),we.innerHTML=St,xl=a(),M(je.$$.fragment),El=ns(`
python
`),Je=o("p"),Je.textContent=Xt,Rl=a(),M(Te.$$.fragment),Sl=a(),M(de.$$.fragment),Xl=a(),be=o("p"),be.textContent=Qt,Ql=a(),M(ue.$$.fragment),zl=a(),M(he.$$.fragment),Hl=a(),fe=o("p"),fe.textContent=zt,Vl=a(),M(Ue.$$.fragment),Fl=a(),Ie=o("p"),Ie.innerHTML=Ht,Ll=a(),M(Ce.$$.fragment),ql=a(),M(ve.$$.fragment),Dl=a(),ge=o("p"),ge.innerHTML=Vt,Pl=a(),Be=o("p"),Be.textContent=Ft,Kl=a(),M(Ae.$$.fragment),Ol=a(),M($e.$$.fragment),et=a(),_e=o("p"),_e.innerHTML=Lt,lt=a(),Ze=o("p"),Ze.innerHTML=qt,tt=a(),M(ke.$$.fragment),st=a(),Ge=o("p"),Ge.textContent=Dt,at=a(),We=o("ul"),We.innerHTML=Pt,nt=a(),Ye=o("p"),Ye.innerHTML=Kt,ot=a(),M(Ne.$$.fragment),it=a(),Ee=o("p"),this.h()},l(e){const l=os("svelte-u9bgzb",document.head);T=i(l,"META",{name:!0,content:!0}),l.forEach(t),Re=n(e),xe=i(e,"P",{}),Ot(xe).forEach(t),Se=n(e),r(b.$$.fragment,e),Xe=n(e),r(u.$$.fragment,e),Qe=n(e),h=i(e,"P",{"data-svelte-h":!0}),p(h)!=="svelte-sl443g"&&(h.textContent=ct),ze=n(e),f=i(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-yp6pog"&&(f.innerHTML=mt),He=n(e),r(U.$$.fragment,e),Ve=n(e),I=i(e,"UL",{"data-svelte-h":!0}),p(I)!=="svelte-1dkkhxt"&&(I.innerHTML=yt),Fe=n(e),r(C.$$.fragment,e),Le=n(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-9dsyh9"&&(v.textContent=wt),qe=n(e),g=i(e,"UL",{"data-svelte-h":!0}),p(g)!=="svelte-1cfhvoe"&&(g.innerHTML=jt),De=n(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-169ujvt"&&(B.innerHTML=Jt),Pe=n(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-12o83v0"&&(A.textContent=Tt),Ke=n(e),$=i(e,"UL",{"data-svelte-h":!0}),p($)!=="svelte-1d5xfjp"&&($.innerHTML=dt),Oe=n(e),_=i(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1e113uy"&&(_.textContent=bt),el=n(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-145ejj4"&&(Z.innerHTML=ut),ll=n(e),k=i(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-wbam8h"&&(k.innerHTML=ht),tl=n(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-tm2a0s"&&(G.innerHTML=ft),sl=n(e),r(W.$$.fragment,e),al=n(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-rc24jv"&&(Y.innerHTML=Ut),nl=n(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1p0w0g0"&&(N.textContent=It),ol=n(e),r(x.$$.fragment,e),il=n(e),E=i(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-12tjci0"&&(E.innerHTML=Ct),pl=n(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-dxku0t"&&(R.innerHTML=vt),Ml=n(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-nb93rz"&&(S.innerHTML=gt),rl=n(e),r(X.$$.fragment,e),cl=n(e),r(Q.$$.fragment,e),ml=n(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-l9j1d3"&&(z.innerHTML=Bt),yl=n(e),d=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(d)!=="svelte-5ox74y"&&(d.innerHTML=At),wl=n(e),r(H.$$.fragment,e),jl=n(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-u7pcb4"&&(V.innerHTML=$t),Jl=n(e),F=i(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1t42iyr"&&(F.textContent=_t),Tl=n(e),r(L.$$.fragment,e),dl=n(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1rkp57y"&&(q.textContent=Zt),bl=n(e),r(D.$$.fragment,e),ul=n(e),P=i(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-12yyl6o"&&(P.innerHTML=kt),hl=n(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1h5avx7"&&(K.innerHTML=Gt),fl=n(e),r(O.$$.fragment,e),Ul=n(e),r(ee.$$.fragment,e),Il=n(e),le=i(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-h4v7d7"&&(le.textContent=Wt),Cl=n(e),r(te.$$.fragment,e),vl=n(e),se=i(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1gpnath"&&(se.innerHTML=Yt),gl=n(e),r(ae.$$.fragment,e),Bl=n(e),r(ne.$$.fragment,e),Al=n(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1iphpc4"&&(oe.textContent=Nt),$l=n(e),r(ie.$$.fragment,e),_l=n(e),r(pe.$$.fragment,e),Zl=n(e),Me=i(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-lfuhuo"&&(Me.textContent=xt),kl=n(e),re=i(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1seywak"&&(re.innerHTML=Et),Gl=n(e),r(ce.$$.fragment,e),Wl=n(e),r(me.$$.fragment,e),Yl=n(e),ye=i(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1e7cuec"&&(ye.textContent=Rt),Nl=n(e),we=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),p(we)!=="svelte-9w4yye"&&(we.innerHTML=St),xl=n(e),r(je.$$.fragment,e),El=is(e,`
python
`),Je=i(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-1ufctnq"&&(Je.textContent=Xt),Rl=n(e),r(Te.$$.fragment,e),Sl=n(e),r(de.$$.fragment,e),Xl=n(e),be=i(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-1gxojkw"&&(be.textContent=Qt),Ql=n(e),r(ue.$$.fragment,e),zl=n(e),r(he.$$.fragment,e),Hl=n(e),fe=i(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-1qfd9tp"&&(fe.textContent=zt),Vl=n(e),r(Ue.$$.fragment,e),Fl=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-adteeq"&&(Ie.innerHTML=Ht),Ll=n(e),r(Ce.$$.fragment,e),ql=n(e),r(ve.$$.fragment,e),Dl=n(e),ge=i(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1elar01"&&(ge.innerHTML=Vt),Pl=n(e),Be=i(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-xmm0bj"&&(Be.textContent=Ft),Kl=n(e),r(Ae.$$.fragment,e),Ol=n(e),r($e.$$.fragment,e),et=n(e),_e=i(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1s7uvme"&&(_e.innerHTML=Lt),lt=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-19bs1hk"&&(Ze.innerHTML=qt),tt=n(e),r(ke.$$.fragment,e),st=n(e),Ge=i(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-ta7vyn"&&(Ge.textContent=Dt),at=n(e),We=i(e,"UL",{"data-svelte-h":!0}),p(We)!=="svelte-16m8r0w"&&(We.innerHTML=Pt),nt=n(e),Ye=i(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-o90m39"&&(Ye.innerHTML=Kt),ot=n(e),r(Ne.$$.fragment,e),it=n(e),Ee=i(e,"P",{}),Ot(Ee).forEach(t),this.h()},h(){Mt(T,"name","hf:doc:metadata"),Mt(T,"content",ms),Mt(d,"class","warning")},m(e,l){ps(document.head,T),s(e,Re,l),s(e,xe,l),s(e,Se,l),c(b,e,l),s(e,Xe,l),c(u,e,l),s(e,Qe,l),s(e,h,l),s(e,ze,l),s(e,f,l),s(e,He,l),c(U,e,l),s(e,Ve,l),s(e,I,l),s(e,Fe,l),c(C,e,l),s(e,Le,l),s(e,v,l),s(e,qe,l),s(e,g,l),s(e,De,l),s(e,B,l),s(e,Pe,l),s(e,A,l),s(e,Ke,l),s(e,$,l),s(e,Oe,l),s(e,_,l),s(e,el,l),s(e,Z,l),s(e,ll,l),s(e,k,l),s(e,tl,l),s(e,G,l),s(e,sl,l),c(W,e,l),s(e,al,l),s(e,Y,l),s(e,nl,l),s(e,N,l),s(e,ol,l),c(x,e,l),s(e,il,l),s(e,E,l),s(e,pl,l),s(e,R,l),s(e,Ml,l),s(e,S,l),s(e,rl,l),c(X,e,l),s(e,cl,l),c(Q,e,l),s(e,ml,l),s(e,z,l),s(e,yl,l),s(e,d,l),s(e,wl,l),c(H,e,l),s(e,jl,l),s(e,V,l),s(e,Jl,l),s(e,F,l),s(e,Tl,l),c(L,e,l),s(e,dl,l),s(e,q,l),s(e,bl,l),c(D,e,l),s(e,ul,l),s(e,P,l),s(e,hl,l),s(e,K,l),s(e,fl,l),c(O,e,l),s(e,Ul,l),c(ee,e,l),s(e,Il,l),s(e,le,l),s(e,Cl,l),c(te,e,l),s(e,vl,l),s(e,se,l),s(e,gl,l),c(ae,e,l),s(e,Bl,l),c(ne,e,l),s(e,Al,l),s(e,oe,l),s(e,$l,l),c(ie,e,l),s(e,_l,l),c(pe,e,l),s(e,Zl,l),s(e,Me,l),s(e,kl,l),s(e,re,l),s(e,Gl,l),c(ce,e,l),s(e,Wl,l),c(me,e,l),s(e,Yl,l),s(e,ye,l),s(e,Nl,l),s(e,we,l),s(e,xl,l),c(je,e,l),s(e,El,l),s(e,Je,l),s(e,Rl,l),c(Te,e,l),s(e,Sl,l),c(de,e,l),s(e,Xl,l),s(e,be,l),s(e,Ql,l),c(ue,e,l),s(e,zl,l),c(he,e,l),s(e,Hl,l),s(e,fe,l),s(e,Vl,l),c(Ue,e,l),s(e,Fl,l),s(e,Ie,l),s(e,Ll,l),c(Ce,e,l),s(e,ql,l),c(ve,e,l),s(e,Dl,l),s(e,ge,l),s(e,Pl,l),s(e,Be,l),s(e,Kl,l),c(Ae,e,l),s(e,Ol,l),c($e,e,l),s(e,et,l),s(e,_e,l),s(e,lt,l),s(e,Ze,l),s(e,tt,l),c(ke,e,l),s(e,st,l),s(e,Ge,l),s(e,at,l),s(e,We,l),s(e,nt,l),s(e,Ye,l),s(e,ot,l),c(Ne,e,l),s(e,it,l),s(e,Ee,l),pt=!0},p:ls,i(e){pt||(m(b.$$.fragment,e),m(u.$$.fragment,e),m(U.$$.fragment,e),m(C.$$.fragment,e),m(W.$$.fragment,e),m(x.$$.fragment,e),m(X.$$.fragment,e),m(Q.$$.fragment,e),m(H.$$.fragment,e),m(L.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(te.$$.fragment,e),m(ae.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(pe.$$.fragment,e),m(ce.$$.fragment,e),m(me.$$.fragment,e),m(je.$$.fragment,e),m(Te.$$.fragment,e),m(de.$$.fragment,e),m(ue.$$.fragment,e),m(he.$$.fragment,e),m(Ue.$$.fragment,e),m(Ce.$$.fragment,e),m(ve.$$.fragment,e),m(Ae.$$.fragment,e),m($e.$$.fragment,e),m(ke.$$.fragment,e),m(Ne.$$.fragment,e),pt=!0)},o(e){y(b.$$.fragment,e),y(u.$$.fragment,e),y(U.$$.fragment,e),y(C.$$.fragment,e),y(W.$$.fragment,e),y(x.$$.fragment,e),y(X.$$.fragment,e),y(Q.$$.fragment,e),y(H.$$.fragment,e),y(L.$$.fragment,e),y(D.$$.fragment,e),y(O.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(ae.$$.fragment,e),y(ne.$$.fragment,e),y(ie.$$.fragment,e),y(pe.$$.fragment,e),y(ce.$$.fragment,e),y(me.$$.fragment,e),y(je.$$.fragment,e),y(Te.$$.fragment,e),y(de.$$.fragment,e),y(ue.$$.fragment,e),y(he.$$.fragment,e),y(Ue.$$.fragment,e),y(Ce.$$.fragment,e),y(ve.$$.fragment,e),y(Ae.$$.fragment,e),y($e.$$.fragment,e),y(ke.$$.fragment,e),y(Ne.$$.fragment,e),pt=!1},d(e){e&&(t(Re),t(xe),t(Se),t(Xe),t(Qe),t(h),t(ze),t(f),t(He),t(Ve),t(I),t(Fe),t(Le),t(v),t(qe),t(g),t(De),t(B),t(Pe),t(A),t(Ke),t($),t(Oe),t(_),t(el),t(Z),t(ll),t(k),t(tl),t(G),t(sl),t(al),t(Y),t(nl),t(N),t(ol),t(il),t(E),t(pl),t(R),t(Ml),t(S),t(rl),t(cl),t(ml),t(z),t(yl),t(d),t(wl),t(jl),t(V),t(Jl),t(F),t(Tl),t(dl),t(q),t(bl),t(ul),t(P),t(hl),t(K),t(fl),t(Ul),t(Il),t(le),t(Cl),t(vl),t(se),t(gl),t(Bl),t(Al),t(oe),t($l),t(_l),t(Zl),t(Me),t(kl),t(re),t(Gl),t(Wl),t(Yl),t(ye),t(Nl),t(we),t(xl),t(El),t(Je),t(Rl),t(Sl),t(Xl),t(be),t(Ql),t(zl),t(Hl),t(fe),t(Vl),t(Fl),t(Ie),t(Ll),t(ql),t(Dl),t(ge),t(Pl),t(Be),t(Kl),t(Ol),t(et),t(_e),t(lt),t(Ze),t(tt),t(st),t(Ge),t(at),t(We),t(nt),t(Ye),t(ot),t(it),t(Ee)),t(T),w(b,e),w(u,e),w(U,e),w(C,e),w(W,e),w(x,e),w(X,e),w(Q,e),w(H,e),w(L,e),w(D,e),w(O,e),w(ee,e),w(te,e),w(ae,e),w(ne,e),w(ie,e),w(pe,e),w(ce,e),w(me,e),w(je,e),w(Te,e),w(de,e),w(ue,e),w(he,e),w(Ue,e),w(Ce,e),w(ve,e),w(Ae,e),w($e,e),w(ke,e),w(Ne,e)}}}const ms='{"title":"Bring Your Own Hardware","local":"bring-your-own-hardware","sections":[{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":2},{"title":"Choose your motors","local":"choose-your-motors","sections":[],"depth":2},{"title":"Step 1: Subclass the Robot Interface","local":"step-1-subclass-the-robot-interface","sections":[],"depth":2},{"title":"Step 2: Define Observation and Action Features","local":"step-2-define-observation-and-action-features","sections":[{"title":"observation_features","local":"observationfeatures","sections":[],"depth":3},{"title":"action_features","local":"actionfeatures","sections":[],"depth":3}],"depth":2},{"title":"Step 3: Handle Connection and Disconnection","local":"step-3-handle-connection-and-disconnection","sections":[{"title":"is_connected","local":"isconnected","sections":[],"depth":3},{"title":"connect()","local":"connect","sections":[],"depth":3},{"title":"disconnect()","local":"disconnect","sections":[],"depth":3}],"depth":2},{"title":"Step 4: Support Calibration and Configuration","local":"step-4-support-calibration-and-configuration","sections":[{"title":"configure()","local":"configure","sections":[],"depth":3}],"depth":2},{"title":"Step 5: Implement Sensors Reading and Action Sending","local":"step-5-implement-sensors-reading-and-action-sending","sections":[{"title":"get_observation()","local":"getobservation","sections":[],"depth":3},{"title":"send_action()","local":"sendaction","sections":[],"depth":3}],"depth":2},{"title":"Adding a Teleoperator","local":"adding-a-teleoperator","sections":[],"depth":2},{"title":"Wrapping Up","local":"wrapping-up","sections":[],"depth":2}],"depth":1}';function ys(rt){return ts(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bs extends ss{constructor(T){super(),as(this,T,ys,cs,es,{})}}export{bs as component};
