import{s as ql,a as Fl,n as Ol,o as Kl}from"../chunks/scheduler.eb244325.js";import{S as Dl,i as es,e as i,s as n,c,h as ts,a as o,d as t,b as a,f as M,g as u,j as r,k as He,l as p,m as s,n as h,t as d,o as m,p as f}from"../chunks/index.3fe63ad3.js";import{C as ls}from"../chunks/CopyLLMTxtMenu.9e6f31ad.js";import{C as y}from"../chunks/CodeBlock.9d957056.js";import{H as g,E as ss}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b7f3e490.js";function ns(dl){let j,Qe,ze,Ne,T,Ye,v,qe,_,ml="Use your phone (iOS or Android) to control your robot.",Fe,J,fl="<strong>In this guide you’ll learn:</strong>",Oe,x,Ml="<li>How to connect an iOS/Android phone</li> <li>How phone pose is mapped to robot end‑effector (EE) targets</li> <li>How to tweak safety limits, gripper control, and IK settings</li>",Ke,E,bl="To use phone to control your robot, install the relevant dependencies with:",De,I,et,R,tt,A,lt,Z,yl="<li>iOS: Uses the HEBI Mobile I/O app (ARKit pose + buttons). Download the app first, open it and the examples will discover it on your network and stream the phone pose and inputs.</li> <li>Android: Uses the <code>teleop</code> package (WebXR). When you start the Python process, it prints a local URL. Open the link on your phone, tap Start, then use Move to stream pose.</li>",st,G,gl="Links:",nt,L,$l='<li>Android WebXR library: <a href="https://pypi.org/project/teleop/" rel="nofollow"><code>teleop</code> on PyPI</a></li> <li>iOS app: <a href="https://docs.hebi.us/tools.html#mobile-io" rel="nofollow">HEBI Mobile I/O</a></li>',at,k,it,S,Ul="<li>Orientation: hold the phone with the screen facing up and the top edge pointing in the same direction as the robot gripper. This ensures calibration aligns the phone’s frame with the robot frame so motion feels natural, see the image below for reference.</li> <li>Enable/disable:<ul><li>iOS: Hold <code>B1</code> to enable teleoperation, release to stop. The first press captures a reference pose.</li> <li>Android: Press and hold the <code>Move</code> button, release to stop. The first press captures a reference pose.</li></ul></li> <li>Gripper control:<ul><li>iOS: Analog input <code>A3</code> controls the gripper as velocity input.</li> <li>Android: Buttons <code>A</code> and <code>B</code> act like increment/decrement (A opens, B closes). You can tune velocity in the <code>GripperVelocityToJoint</code> step.</li></ul></li>",ot,w,jl,pt,W,rt,X,wl="Modify the examples to use <code>PhoneOS.IOS</code> or <code>PhoneOS.ANDROID</code> in <code>PhoneConfig</code>. The API is identical across platforms, only the input source differs. All examples are under <code>examples/</code> and have <code>phone_so100_*.py</code> variants.",ct,B,Cl="Teleoperation example:",ut,V,ht,H,dt,z,Tl="When <code>Phone(teleop_config)</code> is created and <code>connect()</code> is called, calibration is prompted automatically. Hold the phone in the orientation described above, then:",mt,P,vl="<li>iOS: press and hold <code>B1</code> to capture the reference pose.</li> <li>Android: press <code>Move</code> button on the WebXR page to capture the reference pose.</li>",ft,Q,_l="Why calibrate? We capture the current pose so subsequent poses are expressed in a robot aligned frame. When you again press the button to enable control, the position is recaptured to avoid drift when your phone is repositioned while it was disabled.",Mt,N,bt,Y,Jl="Run on of the examples scripts to teleoperate, record a dataset, replay a dataset or evaluate a policy.",yt,q,xl="All scripts assume you configured your robot (e.g., SO-100 follower) and set the correct serial port.",gt,F,El='Additionally you need to <strong>copy the urdf of the robot to the examples folder</strong>. For the examples in this tutorial (Using SO100/SO101) it is highly recommended to use the urdf in the <a href="https://github.com/TheRobotStudio/SO-ARM100/blob/main/Simulation/SO101/so101_new_calib.urdf" rel="nofollow">SO-ARM100 repo</a>',$t,Ee,O,Ie,Il="Run this example to teleoperate:",qt,K,Ut,D,Rl="After running the example:",jt,ee,Al="<li>Android: after starting the script, open the printed local URL on your phone, tap Start, then press and hold Move.</li> <li>iOS: open HEBI Mobile I/O first; B1 enables motion. A3 controls the gripper.</li>",wt,te,Zl='Additionally you can customize mapping or safety limits by editing the processor steps shown in the examples. You can also remap inputs (e.g., use a different analog input) or adapt the pipeline to other robots (e.g., LeKiwi) by modifying the input and kinematics steps. More about this in the <a href="./processors_robots_teleop.mdx">Processors for Robots and Teleoperators</a> guide.',Ct,$,le,Re,Gl="Run this example to record a dataset, which saves absolute end effector observations and actions:",Ft,se,Ot,ne,Ae,Ll="Run this example to replay recorded episodes:",Kt,ae,Dt,ie,Ze,kl="Run this example to evaluate a pretrained policy:",el,oe,Tt,pe,vt,b,re,Ge,Sl='Kinematics are used in multiple steps. We use <a href="https://github.com/Rhoban/placo" rel="nofollow">Placo</a> which is a wrapper around Pinocchio for handling our kinematics. We construct the kinematics object by passing the robot’s URDF and target frame. We set <code>target_frame_name</code> to the gripper frame.',tl,ce,ll,ue,Le,Wl="The <code>MapPhoneActionToRobotAction</code> step converts the calibrated phone pose and inputs into target deltas and gripper commands, below is shown what the step outputs.",sl,he,nl,de,ke,Xl="The <code>EEReferenceAndDelta</code> step converts target deltas to an absolute desired EE pose, storing a reference on enable, the <code>end_effector_step_sizes</code> are the step sizes for the EE pose and can be modified to change the motion speed.",al,me,il,fe,Se,Bl="The <code>EEBoundsAndSafety</code> step clamps EE motion to a workspace and checks for large ee step jumps to ensure safety. The <code>end_effector_bounds</code> are the bounds for the EE pose and can be modified to change the workspace. The <code>max_ee_step_m</code> are the step limits for the EE pose and can be modified to change the safety limits.",ol,Me,pl,be,We,Vl="The <code>GripperVelocityToJoint</code> step turns a velocity‑like gripper input into absolute gripper position using the current measured state. The <code>speed_factor</code> is the factor by which the velocity is multiplied.",rl,ye,_t,ge,Jt,$e,Hl="We use different IK initial guesses in the kinematic steps. As initial guess either the current measured joints or the previous IK solution is used.",xt,C,Ue,Xe,zl="Closed loop (used in record/eval): sets <code>initial_guess_current_joints=True</code> so IK starts from the measured joints each frame.",cl,je,ul,we,Be,Pl="Open loop (used in replay): sets <code>initial_guess_current_joints=False</code> so IK continues from the previous IK solution rather than the measured state. This preserves action stability when we replay without feedback.",hl,Ce,Et,Te,It,ve,Ql="<li>MapPhoneActionToRobotAction: converts calibrated phone pose and inputs into target deltas and a gripper command. Motion is gated by an enable signal (B1 on iOS, Move on Android).</li> <li>EEReferenceAndDelta: latches a reference EE pose on enable and combines it with target deltas to produce an absolute desired EE pose each frame. When disabled, it keeps sending the last commanded pose.</li> <li>EEBoundsAndSafety: clamps the EE pose to a workspace and rate‑limits jumps for safety. Also declares <code>action.ee.*</code> features.</li> <li>InverseKinematicsEEToJoints: turns an EE pose into joint positions with IK. <code>initial_guess_current_joints=True</code> is recommended for closed‑loop control; set <code>False</code> for open‑loop replay for stability.</li> <li>GripperVelocityToJoint: integrates a velocity‑like gripper input into an absolute gripper position using the current measured state.</li> <li>ForwardKinematicsJointsToEE: computes <code>observation.state.ee.*</code> from observed joints for logging and training on EE state.</li>",Rt,_e,At,Je,Nl="<li>iOS not discovered: ensure HEBI Mobile I/O is open and your laptop/phone are on the same network.</li> <li>Android URL not reachable: check local you used <code>https</code> instead of <code>http</code>, use the exact IP printed by the script and allow your browser to enter and ignore the certificate issue.</li> <li>Motion feels inverted: adjust the sign flips in <code>MapPhoneActionToRobotAction</code> or swap axes to match your setup.</li>",Zt,xe,Gt,Pe,Lt;return T=new ls({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),v=new g({props:{title:"Phone",local:"phone",headingTag:"h1"}}),I=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxlcm9ib3QlNUJwaG9uZSU1RA==",highlighted:"pip install lerobot[phone]",wrap:!1}}),R=new g({props:{title:"Get started",local:"get-started",headingTag:"h2"}}),A=new g({props:{title:"Supported platforms",local:"supported-platforms",headingTag:"h3"}}),k=new g({props:{title:"Phone orientation and controls",local:"phone-orientation-and-controls",headingTag:"h3"}}),W=new g({props:{title:"Step 1: Choose the platform",local:"step-1-choose-the-platform",headingTag:"h3"}}),V=new y({props:{code:"ZnJvbSUyMGxlcm9ib3QudGVsZW9wZXJhdG9ycy5waG9uZS5jb25maWdfcGhvbmUlMjBpbXBvcnQlMjBQaG9uZUNvbmZpZyUyQyUyMFBob25lT1MlMEElMEF0ZWxlb3BfY29uZmlnJTIwJTNEJTIwUGhvbmVDb25maWcocGhvbmVfb3MlM0RQaG9uZU9TLklPUyklMjAlMjAlMjMlMjBvciUyMFBob25lT1MuQU5EUk9JRCUwQXRlbGVvcF9kZXZpY2UlMjAlM0QlMjBQaG9uZSh0ZWxlb3BfY29uZmlnKQ==",highlighted:`from lerobot.teleoperators.phone.config_phone import PhoneConfig, PhoneOS

teleop_config = <span class="hljs-constructor">PhoneConfig(<span class="hljs-params">phone_os</span>=PhoneOS.IOS)</span>  # <span class="hljs-keyword">or</span> PhoneOS.ANDROID
teleop_device = <span class="hljs-constructor">Phone(<span class="hljs-params">teleop_config</span>)</span>`,wrap:!1}}),H=new g({props:{title:"Step 2: Connect and calibrate",local:"step-2-connect-and-calibrate",headingTag:"h3"}}),N=new g({props:{title:"Step 3: Run an example",local:"step-3-run-an-example",headingTag:"h3"}}),K=new y({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZwaG9uZV90b19zbzEwMCUyRnRlbGVvcGVyYXRlLnB5",highlighted:"python examples/phone_to_so100/teleoperate.py",wrap:!1}}),se=new y({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZwaG9uZV90b19zbzEwMCUyRnJlY29yZC5weQ==",highlighted:"python examples/phone_to_so100/record.py",wrap:!1}}),ae=new y({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZwaG9uZV90b19zbzEwMCUyRnJlcGxheS5weQ==",highlighted:"python examples/phone_to_so100/replay.py",wrap:!1}}),oe=new y({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZwaG9uZV90b19zbzEwMCUyRmV2YWx1YXRlLnB5",highlighted:"python examples/phone_to_so100/evaluate.py",wrap:!1}}),pe=new g({props:{title:"Important pipeline steps and options",local:"important-pipeline-steps-and-options",headingTag:"h3"}}),ce=new y({props:{code:"a2luZW1hdGljc19zb2x2ZXIlMjAlM0QlMjBSb2JvdEtpbmVtYXRpY3MoJTBBJTIwJTIwdXJkZl9wYXRoJTNEJTIyLiUyRlNPMTAxJTJGc28xMDFfbmV3X2NhbGliLnVyZGYlMjIlMkMlMEElMjAlMjB0YXJnZXRfZnJhbWVfbmFtZSUzRCUyMmdyaXBwZXJfZnJhbWVfbGluayUyMiUyQyUwQSUyMCUyMGpvaW50X25hbWVzJTNEbGlzdChyb2JvdC5idXMubW90b3JzLmtleXMoKSklMkMlMEEpJTBB",highlighted:`kinematics_solver = RobotKinematics(
  <span class="hljs-attribute">urdf_path</span>=<span class="hljs-string">&quot;./SO101/so101_new_calib.urdf&quot;</span>,
  <span class="hljs-attribute">target_frame_name</span>=<span class="hljs-string">&quot;gripper_frame_link&quot;</span>,
  <span class="hljs-attribute">joint_names</span>=list(robot.bus.motors.keys()),
)
`,wrap:!1}}),he=new y({props:{code:"YWN0aW9uJTVCJTIyZW5hYmxlZCUyMiU1RCUyMCUzRCUyMGVuYWJsZWQlMEElMjAlMjAlMjAlMjAlMjAlMjBhY3Rpb24lNUIlMjJ0YXJnZXRfeCUyMiU1RCUyMCUzRCUyMC1wb3MlNUIxJTVEJTIwaWYlMjBlbmFibGVkJTIwZWxzZSUyMDAuMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGFjdGlvbiU1QiUyMnRhcmdldF95JTIyJTVEJTIwJTNEJTIwcG9zJTVCMCU1RCUyMGlmJTIwZW5hYmxlZCUyMGVsc2UlMjAwLjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhY3Rpb24lNUIlMjJ0YXJnZXRfeiUyMiU1RCUyMCUzRCUyMHBvcyU1QjIlNUQlMjBpZiUyMGVuYWJsZWQlMjBlbHNlJTIwMC4wJTBBJTIwJTIwJTIwJTIwJTIwJTIwYWN0aW9uJTVCJTIydGFyZ2V0X3d4JTIyJTVEJTIwJTNEJTIwcm90dmVjJTVCMSU1RCUyMGlmJTIwZW5hYmxlZCUyMGVsc2UlMjAwLjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhY3Rpb24lNUIlMjJ0YXJnZXRfd3klMjIlNUQlMjAlM0QlMjByb3R2ZWMlNUIwJTVEJTIwaWYlMjBlbmFibGVkJTIwZWxzZSUyMDAuMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGFjdGlvbiU1QiUyMnRhcmdldF93eiUyMiU1RCUyMCUzRCUyMC1yb3R2ZWMlNUIyJTVEJTIwaWYlMjBlbmFibGVkJTIwZWxzZSUyMDAuMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGFjdGlvbiU1QiUyMmdyaXBwZXJfdmVsJTIyJTVEJTIwJTNEJTIwZ3JpcHBlcl92ZWwlMjAlMjAlMjMlMjBTdGlsbCUyMHNlbmQlMjBncmlwcGVyJTIwYWN0aW9uJTIwd2hlbiUyMGRpc2FibGVk",highlighted:`<span class="hljs-attribute">action</span>[<span class="hljs-string">&quot;enabled&quot;</span>] = enabled
      <span class="hljs-attribute">action</span>[<span class="hljs-string">&quot;target_x&quot;</span>] = -pos[<span class="hljs-number">1</span>] if enabled else <span class="hljs-number">0</span>.<span class="hljs-number">0</span>
      <span class="hljs-attribute">action</span>[<span class="hljs-string">&quot;target_y&quot;</span>] = pos[<span class="hljs-number">0</span>] if enabled else <span class="hljs-number">0</span>.<span class="hljs-number">0</span>
      <span class="hljs-attribute">action</span>[<span class="hljs-string">&quot;target_z&quot;</span>] = pos[<span class="hljs-number">2</span>] if enabled else <span class="hljs-number">0</span>.<span class="hljs-number">0</span>
      <span class="hljs-attribute">action</span>[<span class="hljs-string">&quot;target_wx&quot;</span>] = rotvec[<span class="hljs-number">1</span>] if enabled else <span class="hljs-number">0</span>.<span class="hljs-number">0</span>
      <span class="hljs-attribute">action</span>[<span class="hljs-string">&quot;target_wy&quot;</span>] = rotvec[<span class="hljs-number">0</span>] if enabled else <span class="hljs-number">0</span>.<span class="hljs-number">0</span>
      <span class="hljs-attribute">action</span>[<span class="hljs-string">&quot;target_wz&quot;</span>] = -rotvec[<span class="hljs-number">2</span>] if enabled else <span class="hljs-number">0</span>.<span class="hljs-number">0</span>
      <span class="hljs-attribute">action</span>[<span class="hljs-string">&quot;gripper_vel&quot;</span>] = gripper_vel  # Still send gripper action when disabled`,wrap:!1}}),me=new y({props:{code:"RUVSZWZlcmVuY2VBbmREZWx0YSglMEElMjAlMjAlMjAlMjBraW5lbWF0aWNzJTNEa2luZW1hdGljc19zb2x2ZXIlMkMlMEElMjAlMjAlMjAlMjBlbmRfZWZmZWN0b3Jfc3RlcF9zaXplcyUzRCU3QiUyMnglMjIlM0ElMjAwLjUlMkMlMjAlMjJ5JTIyJTNBJTIwMC41JTJDJTIwJTIyeiUyMiUzQSUyMDAuNSU3RCUyQyUwQSUyMCUyMCUyMCUyMG1vdG9yX25hbWVzJTNEbGlzdChyb2JvdC5idXMubW90b3JzLmtleXMoKSklMkMlMEElMjAlMjAlMjAlMjB1c2VfbGF0Y2hlZF9yZWZlcmVuY2UlM0RUcnVlJTJDJTBBKSUyQw==",highlighted:`EEReferenceAndDelta(
    <span class="hljs-attribute">kinematics</span>=kinematics_solver,
    end_effector_step_sizes={<span class="hljs-string">&quot;x&quot;</span>: 0.5, <span class="hljs-string">&quot;y&quot;</span>: 0.5, <span class="hljs-string">&quot;z&quot;</span>: 0.5},
    <span class="hljs-attribute">motor_names</span>=list(robot.bus.motors.keys()),
    <span class="hljs-attribute">use_latched_reference</span>=<span class="hljs-literal">True</span>,
),`,wrap:!1}}),Me=new y({props:{code:"RUVCb3VuZHNBbmRTYWZldHkoJTBBJTIwJTIwJTIwJTIwZW5kX2VmZmVjdG9yX2JvdW5kcyUzRCU3QiUyMm1pbiUyMiUzQSUyMCU1Qi0xLjAlMkMlMjAtMS4wJTJDJTIwLTEuMCU1RCUyQyUyMCUyMm1heCUyMiUzQSUyMCU1QjEuMCUyQyUyMDEuMCUyQyUyMDEuMCU1RCU3RCUyQyUwQSUyMCUyMCUyMCUyMG1heF9lZV9zdGVwX20lM0QwLjEwJTJDJTBBKQ==",highlighted:`<span class="hljs-built_in">EEBoundsAndSafety</span>(
    end_effector_bounds={<span class="hljs-string">&quot;min&quot;</span>: <span class="hljs-selector-attr">[-1.0, -1.0, -1.0]</span>, <span class="hljs-string">&quot;max&quot;</span>: <span class="hljs-selector-attr">[1.0, 1.0, 1.0]</span>},
    max_ee_step_m=<span class="hljs-number">0.10</span>,
)`,wrap:!1}}),ye=new y({props:{code:"R3JpcHBlclZlbG9jaXR5VG9Kb2ludChzcGVlZF9mYWN0b3IlM0QyMC4wKQ==",highlighted:'<span class="hljs-function"><span class="hljs-title">GripperVelocityToJoint</span><span class="hljs-params">(speed_factor=<span class="hljs-number">20.0</span>)</span></span>',wrap:!1}}),ge=new g({props:{title:"Different IK initial guesses",local:"different-ik-initial-guesses",headingTag:"h4"}}),je=new y({props:{code:"SW52ZXJzZUtpbmVtYXRpY3NFRVRvSm9pbnRzKCUwQSUyMCUyMCUyMCUyMGtpbmVtYXRpY3MlM0RraW5lbWF0aWNzX3NvbHZlciUyQyUwQSUyMCUyMCUyMCUyMG1vdG9yX25hbWVzJTNEbGlzdChyb2JvdC5idXMubW90b3JzLmtleXMoKSklMkMlMEElMjAlMjAlMjAlMjBpbml0aWFsX2d1ZXNzX2N1cnJlbnRfam9pbnRzJTNEVHJ1ZSUyQyUyMCUyMCUyMyUyMGNsb3NlZCUyMGxvb3AlMEEp",highlighted:`InverseKinematicsEEToJoints(
    <span class="hljs-attribute">kinematics</span>=kinematics_solver,
    <span class="hljs-attribute">motor_names</span>=list(robot.bus.motors.keys()),
    <span class="hljs-attribute">initial_guess_current_joints</span>=<span class="hljs-literal">True</span>,  # closed loop
)`,wrap:!1}}),Ce=new y({props:{code:"SW52ZXJzZUtpbmVtYXRpY3NFRVRvSm9pbnRzKCUwQSUyMCUyMCUyMCUyMGtpbmVtYXRpY3MlM0RraW5lbWF0aWNzX3NvbHZlciUyQyUwQSUyMCUyMCUyMCUyMG1vdG9yX25hbWVzJTNEbGlzdChyb2JvdC5idXMubW90b3JzLmtleXMoKSklMkMlMEElMjAlMjAlMjAlMjBpbml0aWFsX2d1ZXNzX2N1cnJlbnRfam9pbnRzJTNERmFsc2UlMkMlMjAlMjAlMjMlMjBvcGVuJTIwbG9vcCUwQSk=",highlighted:`InverseKinematicsEEToJoints(
    <span class="hljs-attribute">kinematics</span>=kinematics_solver,
    <span class="hljs-attribute">motor_names</span>=list(robot.bus.motors.keys()),
    <span class="hljs-attribute">initial_guess_current_joints</span>=<span class="hljs-literal">False</span>,  # open loop
)`,wrap:!1}}),Te=new g({props:{title:"Pipeline steps explained",local:"pipeline-steps-explained",headingTag:"h3"}}),_e=new g({props:{title:"Troubleshooting",local:"troubleshooting",headingTag:"h3"}}),xe=new ss({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/phone_teleop.mdx"}}),{c(){j=i("meta"),Qe=n(),ze=i("p"),Ne=n(),c(T.$$.fragment),Ye=n(),c(v.$$.fragment),qe=n(),_=i("p"),_.textContent=ml,Fe=n(),J=i("p"),J.innerHTML=fl,Oe=n(),x=i("ul"),x.innerHTML=Ml,Ke=n(),E=i("p"),E.textContent=bl,De=n(),c(I.$$.fragment),et=n(),c(R.$$.fragment),tt=n(),c(A.$$.fragment),lt=n(),Z=i("ul"),Z.innerHTML=yl,st=n(),G=i("p"),G.textContent=gl,nt=n(),L=i("ul"),L.innerHTML=$l,at=n(),c(k.$$.fragment),it=n(),S=i("ul"),S.innerHTML=Ul,ot=n(),w=i("img"),pt=n(),c(W.$$.fragment),rt=n(),X=i("p"),X.innerHTML=wl,ct=n(),B=i("p"),B.textContent=Cl,ut=n(),c(V.$$.fragment),ht=n(),c(H.$$.fragment),dt=n(),z=i("p"),z.innerHTML=Tl,mt=n(),P=i("ul"),P.innerHTML=vl,ft=n(),Q=i("p"),Q.textContent=_l,Mt=n(),c(N.$$.fragment),bt=n(),Y=i("p"),Y.textContent=Jl,yt=n(),q=i("p"),q.textContent=xl,gt=n(),F=i("p"),F.innerHTML=El,$t=n(),Ee=i("ul"),O=i("li"),Ie=i("p"),Ie.textContent=Il,qt=n(),c(K.$$.fragment),Ut=n(),D=i("p"),D.textContent=Rl,jt=n(),ee=i("ul"),ee.innerHTML=Al,wt=n(),te=i("p"),te.innerHTML=Zl,Ct=n(),$=i("ul"),le=i("li"),Re=i("p"),Re.textContent=Gl,Ft=n(),c(se.$$.fragment),Ot=n(),ne=i("li"),Ae=i("p"),Ae.textContent=Ll,Kt=n(),c(ae.$$.fragment),Dt=n(),ie=i("li"),Ze=i("p"),Ze.textContent=kl,el=n(),c(oe.$$.fragment),Tt=n(),c(pe.$$.fragment),vt=n(),b=i("ul"),re=i("li"),Ge=i("p"),Ge.innerHTML=Sl,tl=n(),c(ce.$$.fragment),ll=n(),ue=i("li"),Le=i("p"),Le.innerHTML=Wl,sl=n(),c(he.$$.fragment),nl=n(),de=i("li"),ke=i("p"),ke.innerHTML=Xl,al=n(),c(me.$$.fragment),il=n(),fe=i("li"),Se=i("p"),Se.innerHTML=Bl,ol=n(),c(Me.$$.fragment),pl=n(),be=i("li"),We=i("p"),We.innerHTML=Vl,rl=n(),c(ye.$$.fragment),_t=n(),c(ge.$$.fragment),Jt=n(),$e=i("p"),$e.textContent=Hl,xt=n(),C=i("ul"),Ue=i("li"),Xe=i("p"),Xe.innerHTML=zl,cl=n(),c(je.$$.fragment),ul=n(),we=i("li"),Be=i("p"),Be.innerHTML=Pl,hl=n(),c(Ce.$$.fragment),Et=n(),c(Te.$$.fragment),It=n(),ve=i("ul"),ve.innerHTML=Ql,Rt=n(),c(_e.$$.fragment),At=n(),Je=i("ul"),Je.innerHTML=Nl,Zt=n(),c(xe.$$.fragment),Gt=n(),Pe=i("p"),this.h()},l(e){const l=ts("svelte-u9bgzb",document.head);j=o(l,"META",{name:!0,content:!0}),l.forEach(t),Qe=a(e),ze=o(e,"P",{}),M(ze).forEach(t),Ne=a(e),u(T.$$.fragment,e),Ye=a(e),u(v.$$.fragment,e),qe=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-3vf8g7"&&(_.textContent=ml),Fe=a(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1er8ae6"&&(J.innerHTML=fl),Oe=a(e),x=o(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-1nz9ma3"&&(x.innerHTML=Ml),Ke=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1lyia1j"&&(E.textContent=bl),De=a(e),u(I.$$.fragment,e),et=a(e),u(R.$$.fragment,e),tt=a(e),u(A.$$.fragment,e),lt=a(e),Z=o(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-xkftyz"&&(Z.innerHTML=yl),st=a(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-y594fb"&&(G.textContent=gl),nt=a(e),L=o(e,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-faeeyl"&&(L.innerHTML=$l),at=a(e),u(k.$$.fragment,e),it=a(e),S=o(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-dfqf70"&&(S.innerHTML=Ul),ot=a(e),w=o(e,"IMG",{src:!0,alt:!0,title:!0,width:!0}),pt=a(e),u(W.$$.fragment,e),rt=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1c3fk2a"&&(X.innerHTML=wl),ct=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-rrbhjt"&&(B.textContent=Cl),ut=a(e),u(V.$$.fragment,e),ht=a(e),u(H.$$.fragment,e),dt=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-11v1co9"&&(z.innerHTML=Tl),mt=a(e),P=o(e,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-10nmcyd"&&(P.innerHTML=vl),ft=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1v5ctat"&&(Q.textContent=_l),Mt=a(e),u(N.$$.fragment,e),bt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-biq5h"&&(Y.textContent=Jl),yt=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-cziu4v"&&(q.textContent=xl),gt=a(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-bo4jsw"&&(F.innerHTML=El),$t=a(e),Ee=o(e,"UL",{});var Yl=M(Ee);O=o(Yl,"LI",{});var kt=M(O);Ie=o(kt,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1n9m9bo"&&(Ie.textContent=Il),qt=a(kt),u(K.$$.fragment,kt),kt.forEach(t),Yl.forEach(t),Ut=a(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-tep4ru"&&(D.textContent=Rl),jt=a(e),ee=o(e,"UL",{"data-svelte-h":!0}),r(ee)!=="svelte-19691k6"&&(ee.innerHTML=Al),wt=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-ijvg9p"&&(te.innerHTML=Zl),Ct=a(e),$=o(e,"UL",{});var Ve=M($);le=o(Ve,"LI",{});var St=M(le);Re=o(St,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-11bjw3i"&&(Re.textContent=Gl),Ft=a(St),u(se.$$.fragment,St),St.forEach(t),Ot=a(Ve),ne=o(Ve,"LI",{});var Wt=M(ne);Ae=o(Wt,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-eb2jkf"&&(Ae.textContent=Ll),Kt=a(Wt),u(ae.$$.fragment,Wt),Wt.forEach(t),Dt=a(Ve),ie=o(Ve,"LI",{});var Xt=M(ie);Ze=o(Xt,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-r2to9q"&&(Ze.textContent=kl),el=a(Xt),u(oe.$$.fragment,Xt),Xt.forEach(t),Ve.forEach(t),Tt=a(e),u(pe.$$.fragment,e),vt=a(e),b=o(e,"UL",{});var U=M(b);re=o(U,"LI",{});var Bt=M(re);Ge=o(Bt,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1y9rs6w"&&(Ge.innerHTML=Sl),tl=a(Bt),u(ce.$$.fragment,Bt),Bt.forEach(t),ll=a(U),ue=o(U,"LI",{});var Vt=M(ue);Le=o(Vt,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-b5g37b"&&(Le.innerHTML=Wl),sl=a(Vt),u(he.$$.fragment,Vt),Vt.forEach(t),nl=a(U),de=o(U,"LI",{});var Ht=M(de);ke=o(Ht,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1lpl7iy"&&(ke.innerHTML=Xl),al=a(Ht),u(me.$$.fragment,Ht),Ht.forEach(t),il=a(U),fe=o(U,"LI",{});var zt=M(fe);Se=o(zt,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-h12igb"&&(Se.innerHTML=Bl),ol=a(zt),u(Me.$$.fragment,zt),zt.forEach(t),pl=a(U),be=o(U,"LI",{});var Pt=M(be);We=o(Pt,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1c721cm"&&(We.innerHTML=Vl),rl=a(Pt),u(ye.$$.fragment,Pt),Pt.forEach(t),U.forEach(t),_t=a(e),u(ge.$$.fragment,e),Jt=a(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1s0tjx9"&&($e.textContent=Hl),xt=a(e),C=o(e,"UL",{});var Qt=M(C);Ue=o(Qt,"LI",{});var Nt=M(Ue);Xe=o(Nt,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-sebqar"&&(Xe.innerHTML=zl),cl=a(Nt),u(je.$$.fragment,Nt),Nt.forEach(t),ul=a(Qt),we=o(Qt,"LI",{});var Yt=M(we);Be=o(Yt,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-13tu7ua"&&(Be.innerHTML=Pl),hl=a(Yt),u(Ce.$$.fragment,Yt),Yt.forEach(t),Qt.forEach(t),Et=a(e),u(Te.$$.fragment,e),It=a(e),ve=o(e,"UL",{"data-svelte-h":!0}),r(ve)!=="svelte-1a6s0a3"&&(ve.innerHTML=Ql),Rt=a(e),u(_e.$$.fragment,e),At=a(e),Je=o(e,"UL",{"data-svelte-h":!0}),r(Je)!=="svelte-adc87g"&&(Je.innerHTML=Nl),Zt=a(e),u(xe.$$.fragment,e),Gt=a(e),Pe=o(e,"P",{}),M(Pe).forEach(t),this.h()},h(){He(j,"name","hf:doc:metadata"),He(j,"content",as),Fl(w.src,jl="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/phone_teleop.webp")||He(w,"src",jl),He(w,"alt","Phone teleop orientation"),He(w,"title","Phone teleop orientation"),He(w,"width","40%")},m(e,l){p(document.head,j),s(e,Qe,l),s(e,ze,l),s(e,Ne,l),h(T,e,l),s(e,Ye,l),h(v,e,l),s(e,qe,l),s(e,_,l),s(e,Fe,l),s(e,J,l),s(e,Oe,l),s(e,x,l),s(e,Ke,l),s(e,E,l),s(e,De,l),h(I,e,l),s(e,et,l),h(R,e,l),s(e,tt,l),h(A,e,l),s(e,lt,l),s(e,Z,l),s(e,st,l),s(e,G,l),s(e,nt,l),s(e,L,l),s(e,at,l),h(k,e,l),s(e,it,l),s(e,S,l),s(e,ot,l),s(e,w,l),s(e,pt,l),h(W,e,l),s(e,rt,l),s(e,X,l),s(e,ct,l),s(e,B,l),s(e,ut,l),h(V,e,l),s(e,ht,l),h(H,e,l),s(e,dt,l),s(e,z,l),s(e,mt,l),s(e,P,l),s(e,ft,l),s(e,Q,l),s(e,Mt,l),h(N,e,l),s(e,bt,l),s(e,Y,l),s(e,yt,l),s(e,q,l),s(e,gt,l),s(e,F,l),s(e,$t,l),s(e,Ee,l),p(Ee,O),p(O,Ie),p(O,qt),h(K,O,null),s(e,Ut,l),s(e,D,l),s(e,jt,l),s(e,ee,l),s(e,wt,l),s(e,te,l),s(e,Ct,l),s(e,$,l),p($,le),p(le,Re),p(le,Ft),h(se,le,null),p($,Ot),p($,ne),p(ne,Ae),p(ne,Kt),h(ae,ne,null),p($,Dt),p($,ie),p(ie,Ze),p(ie,el),h(oe,ie,null),s(e,Tt,l),h(pe,e,l),s(e,vt,l),s(e,b,l),p(b,re),p(re,Ge),p(re,tl),h(ce,re,null),p(b,ll),p(b,ue),p(ue,Le),p(ue,sl),h(he,ue,null),p(b,nl),p(b,de),p(de,ke),p(de,al),h(me,de,null),p(b,il),p(b,fe),p(fe,Se),p(fe,ol),h(Me,fe,null),p(b,pl),p(b,be),p(be,We),p(be,rl),h(ye,be,null),s(e,_t,l),h(ge,e,l),s(e,Jt,l),s(e,$e,l),s(e,xt,l),s(e,C,l),p(C,Ue),p(Ue,Xe),p(Ue,cl),h(je,Ue,null),p(C,ul),p(C,we),p(we,Be),p(we,hl),h(Ce,we,null),s(e,Et,l),h(Te,e,l),s(e,It,l),s(e,ve,l),s(e,Rt,l),h(_e,e,l),s(e,At,l),s(e,Je,l),s(e,Zt,l),h(xe,e,l),s(e,Gt,l),s(e,Pe,l),Lt=!0},p:Ol,i(e){Lt||(d(T.$$.fragment,e),d(v.$$.fragment,e),d(I.$$.fragment,e),d(R.$$.fragment,e),d(A.$$.fragment,e),d(k.$$.fragment,e),d(W.$$.fragment,e),d(V.$$.fragment,e),d(H.$$.fragment,e),d(N.$$.fragment,e),d(K.$$.fragment,e),d(se.$$.fragment,e),d(ae.$$.fragment,e),d(oe.$$.fragment,e),d(pe.$$.fragment,e),d(ce.$$.fragment,e),d(he.$$.fragment,e),d(me.$$.fragment,e),d(Me.$$.fragment,e),d(ye.$$.fragment,e),d(ge.$$.fragment,e),d(je.$$.fragment,e),d(Ce.$$.fragment,e),d(Te.$$.fragment,e),d(_e.$$.fragment,e),d(xe.$$.fragment,e),Lt=!0)},o(e){m(T.$$.fragment,e),m(v.$$.fragment,e),m(I.$$.fragment,e),m(R.$$.fragment,e),m(A.$$.fragment,e),m(k.$$.fragment,e),m(W.$$.fragment,e),m(V.$$.fragment,e),m(H.$$.fragment,e),m(N.$$.fragment,e),m(K.$$.fragment,e),m(se.$$.fragment,e),m(ae.$$.fragment,e),m(oe.$$.fragment,e),m(pe.$$.fragment,e),m(ce.$$.fragment,e),m(he.$$.fragment,e),m(me.$$.fragment,e),m(Me.$$.fragment,e),m(ye.$$.fragment,e),m(ge.$$.fragment,e),m(je.$$.fragment,e),m(Ce.$$.fragment,e),m(Te.$$.fragment,e),m(_e.$$.fragment,e),m(xe.$$.fragment,e),Lt=!1},d(e){e&&(t(Qe),t(ze),t(Ne),t(Ye),t(qe),t(_),t(Fe),t(J),t(Oe),t(x),t(Ke),t(E),t(De),t(et),t(tt),t(lt),t(Z),t(st),t(G),t(nt),t(L),t(at),t(it),t(S),t(ot),t(w),t(pt),t(rt),t(X),t(ct),t(B),t(ut),t(ht),t(dt),t(z),t(mt),t(P),t(ft),t(Q),t(Mt),t(bt),t(Y),t(yt),t(q),t(gt),t(F),t($t),t(Ee),t(Ut),t(D),t(jt),t(ee),t(wt),t(te),t(Ct),t($),t(Tt),t(vt),t(b),t(_t),t(Jt),t($e),t(xt),t(C),t(Et),t(It),t(ve),t(Rt),t(At),t(Je),t(Zt),t(Gt),t(Pe)),t(j),f(T,e),f(v,e),f(I,e),f(R,e),f(A,e),f(k,e),f(W,e),f(V,e),f(H,e),f(N,e),f(K),f(se),f(ae),f(oe),f(pe,e),f(ce),f(he),f(me),f(Me),f(ye),f(ge,e),f(je),f(Ce),f(Te,e),f(_e,e),f(xe,e)}}}const as='{"title":"Phone","local":"phone","sections":[{"title":"Get started","local":"get-started","sections":[{"title":"Supported platforms","local":"supported-platforms","sections":[],"depth":3},{"title":"Phone orientation and controls","local":"phone-orientation-and-controls","sections":[],"depth":3},{"title":"Step 1: Choose the platform","local":"step-1-choose-the-platform","sections":[],"depth":3},{"title":"Step 2: Connect and calibrate","local":"step-2-connect-and-calibrate","sections":[],"depth":3},{"title":"Step 3: Run an example","local":"step-3-run-an-example","sections":[],"depth":3},{"title":"Important pipeline steps and options","local":"important-pipeline-steps-and-options","sections":[{"title":"Different IK initial guesses","local":"different-ik-initial-guesses","sections":[],"depth":4}],"depth":3},{"title":"Pipeline steps explained","local":"pipeline-steps-explained","sections":[],"depth":3},{"title":"Troubleshooting","local":"troubleshooting","sections":[],"depth":3}],"depth":2}],"depth":1}';function is(dl){return Kl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hs extends Dl{constructor(j){super(),es(this,j,is,ns,ql,{})}}export{hs as component};
