import{s as wc,n as dc,o as Uc}from"../chunks/scheduler.eb244325.js";import{S as Ic,i as fc,e as p,s as e,c,q as Cc,h as bc,a as i,d as l,b as a,f as N,g as r,j as o,r as gc,k as m,l as J,m as n,n as M,t as u,o as j,p as y}from"../chunks/index.3fe63ad3.js";import{C as vc}from"../chunks/CopyLLMTxtMenu.9e6f31ad.js";import{C as h}from"../chunks/CodeBlock.9d957056.js";import{H as T,E as Ac}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b7f3e490.js";function Bc(Gp){let U,pn,en,on,q,cn,x,rn,Q,Xp="In this tutorial you will go through the full Human-in-the-Loop Sample-Efficient Reinforcement Learning (HIL-SERL) workflow using LeRobot. You will master training a policy with RL on a real robot in just a few hours.",Mn,k,zp="HIL-SERL is a sample-efficient reinforcement learning algorithm that combines human demonstrations with online learning and human interventions. The approach starts from a small set of human demonstrations, uses them to train a reward classifier, and then employs an actor-learner architecture where humans can intervene during policy execution to guide exploration and correct unsafe behaviors. In this tutorial, you’ll use a gamepad to provide interventions and control the robot during the learning process.",un,L,Vp="It combines three key ingredients:",jn,H,Yp="<li><p><strong>Offline demonstrations &amp; reward classifier:</strong> a handful of human-teleop episodes plus a vision-based success detector give the policy a shaped starting point.</p></li> <li><p><strong>On-robot actor / learner loop with human interventions:</strong> a distributed Soft Actor Critic (SAC) learner updates the policy while an actor explores on the physical robot; the human can jump in at any time to correct dangerous or unproductive behaviour.</p></li> <li><p><strong>Safety &amp; efficiency tools:</strong> joint/end-effector (EE) bounds, crop region of interest (ROI) preprocessing and WandB monitoring keep the data useful and the hardware safe.</p></li>",yn,R,Fp="Together these elements let HIL-SERL reach near-perfect task success and faster cycle times than imitation-only baselines.",hn,I,Pp='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/hilserl-main-figure.png" alt="HIL-SERL workflow" title="HIL-SERL workflow" width="100%"/>',Tn,f,Dp="<i>HIL-SERL workflow, Luo et al. 2024</i>",Jn,S,Op="This guide provides step-by-step instructions for training a robot policy using LeRobot’s HilSerl implementation to train on a real robot.",mn,W,wn,G,Kp="<li>A gamepad (recommended) or keyboard to control the robot</li> <li>A Nvidia GPU</li> <li>A real robot with a follower and leader arm (optional if you use the keyboard or the gamepad)</li> <li>A URDF file for the robot for the kinematics package (check <code>lerobot/model/kinematics.py</code>)</li>",dn,X,Un,z,si="One can use HIL-SERL to train on a variety of manipulation tasks. Some recommendations:",In,V,ti="<li>Start with a simple task to understand how the system works.<ul><li>Push cube to a goal region</li> <li>Pick and lift cube with the gripper</li></ul></li> <li>Avoid extremely long horizon tasks. Focus on tasks that can be completed in 5-10 seconds.</li> <li>Once you have a good idea of how the system works, you can try more complex tasks and longer horizons.<ul><li>Pick and place cube</li> <li>Bimanual tasks to pick objects with two arms</li> <li>Hand-over tasks to transfer objects from one arm to another</li> <li>Go crazy!</li></ul></li>",fn,Y,Cn,F,li="To install LeRobot with HIL-SERL, you need to install the <code>hilserl</code> extra.",bn,P,gn,D,vn,O,An,K,ni="The training process begins with proper configuration for the HILSerl environment. The main configuration class is <code>GymManipulatorConfig</code> in <code>lerobot/rl/gym_manipulator.py</code>, which contains nested <code>HILSerlRobotEnvConfig</code> and <code>DatasetConfig</code>. The configuration is organized into focused, nested sub-configs:",Bn,ss,_n,ts,Zn,ls,ei="HIL-SERL uses a modular processor pipeline architecture that processes robot observations and actions through a series of composable steps. The pipeline is divided into two main components:",En,ns,$n,es,ai="The environment processor (<code>env_processor</code>) handles incoming observations and environment state:",Nn,as,pi="<li><strong>VanillaObservationProcessorStep</strong>: Converts raw robot observations into standardized format</li> <li><strong>JointVelocityProcessorStep</strong> (optional): Adds joint velocity information to observations</li> <li><strong>MotorCurrentProcessorStep</strong> (optional): Adds motor current readings to observations</li> <li><strong>ForwardKinematicsJointsToEE</strong> (optional): Computes end-effector pose from joint positions</li> <li><strong>ImageCropResizeProcessorStep</strong> (optional): Crops and resizes camera images</li> <li><strong>TimeLimitProcessorStep</strong> (optional): Enforces episode time limits</li> <li><strong>GripperPenaltyProcessorStep</strong> (optional): Applies penalties for inappropriate gripper usage</li> <li><strong>RewardClassifierProcessorStep</strong> (optional): Automated reward detection using vision models</li> <li><strong>AddBatchDimensionProcessorStep</strong>: Converts data to batch format for neural network processing</li> <li><strong>DeviceProcessorStep</strong>: Moves data to the specified compute device (CPU/GPU)</li>",qn,ps,xn,is,ii="The action processor (<code>action_processor</code>) handles outgoing actions and human interventions:",Qn,os,oi="<li><strong>AddTeleopActionAsComplimentaryDataStep</strong>: Captures teleoperator actions for logging</li> <li><strong>AddTeleopEventsAsInfoStep</strong>: Records intervention events and episode control signals</li> <li><strong>InterventionActionProcessorStep</strong>: Handles human interventions and episode termination</li> <li><strong>Inverse Kinematics Pipeline</strong> (when enabled):<ul><li><strong>MapDeltaActionToRobotActionStep</strong>: Converts delta actions to robot action format</li> <li><strong>EEReferenceAndDelta</strong>: Computes end-effector reference and delta movements</li> <li><strong>EEBoundsAndSafety</strong>: Enforces workspace safety bounds</li> <li><strong>InverseKinematicsEEToJoints</strong>: Converts end-effector actions to joint targets</li> <li><strong>GripperVelocityToJoint</strong>: Handles gripper control commands</li></ul></li>",kn,cs,Ln,rs,ci="<strong>Basic Observation Processing</strong>:",Hn,Ms,Rn,us,ri="<strong>Image Processing</strong>:",Sn,js,Wn,ys,Mi="<strong>Inverse Kinematics Setup</strong>:",Gn,hs,Xn,Ts,zn,Js,ui="The HIL-SERL framework supports additional observation processing features that can improve policy learning:",Vn,ms,Yn,ws,ji="Enable joint velocity estimation to provide the policy with motion information:",Fn,ds,Pn,Us,yi="This processor:",Dn,Is,hi="<li>Estimates joint velocities using finite differences between consecutive joint position readings</li> <li>Adds velocity information to the observation state vector</li> <li>Useful for policies that need motion awareness for dynamic tasks</li>",On,fs,Kn,Cs,Ti="Monitor motor currents to detect contact forces and load conditions:",se,bs,te,gs,Ji="This processor:",le,vs,mi="<li>Reads motor current values from the robot’s control system</li> <li>Adds current measurements to the observation state vector</li> <li>Helps detect contact events, object weights, and mechanical resistance</li> <li>Useful for contact-rich manipulation tasks</li>",ne,As,ee,Bs,wi="You can enable multiple observation processing features simultaneously:",ae,_s,pe,Zs,di="<strong>Note</strong>: Enabling additional observation features increases the state space dimensionality, which may require adjusting your policy network architecture and potentially collecting more training data.",ie,Es,oe,$s,Ui="Before collecting demonstrations, you need to determine the appropriate operational bounds for your robot.",ce,Ns,Ii="This helps simplify the problem of learning on the real robot in two ways: 1) by limiting the robot’s operational space to a specific region that solves the task and avoids unnecessary or unsafe exploration, and 2) by allowing training in end-effector space rather than joint space. Empirically, learning in joint space for reinforcement learning in manipulation is often a harder problem - some tasks are nearly impossible to learn in joint space but become learnable when the action space is transformed to end-effector coordinates.",re,qs,fi="<strong>Using lerobot-find-joint-limits</strong>",Me,xs,Ci=`This script helps you find the safe operational bounds for your robot’s end-effector. Given that you have a follower and leader arm, you can use the script to find the bounds for the follower arm that will be applied during training.
Bounding the action space will reduce the redundant exploration of the agent and guarantees safety.`,ue,Qs,je,ks,bi="<strong>Workflow</strong>",ye,d,Pl,gi="Run the script and move the robot through the space that solves the task",Np,Dl,qp,Ls,xp,Ol,vi="Use these values in the configuration of your teleoperation device (TeleoperatorConfig) under the <code>end_effector_bounds</code> field",he,Hs,Ai="<strong>Example Configuration</strong>",Te,Rs,Je,Ss,me,Ws,Bi="With the bounds defined, you can safely collect demonstrations for training. Training RL with off-policy algorithm allows us to use offline datasets collected in order to improve the efficiency of the learning process.",we,Gs,_i="<strong>Setting Up Record Mode</strong>",de,Xs,Zi='Create a configuration file for recording demonstrations (or edit an existing one like <a href="https://huggingface.co/datasets/lerobot/config_examples/resolve/main/rl/env_config.json" rel="nofollow">env_config.json</a>):',Ue,zs,Ei="<li>Set <code>mode</code> to <code>&quot;record&quot;</code> at the root level</li> <li>Specify a unique <code>repo_id</code> for your dataset in the <code>dataset</code> section (e.g., “username/task_name”)</li> <li>Set <code>num_episodes_to_record</code> in the <code>dataset</code> section to the number of demonstrations you want to collect</li> <li>Set <code>env.processor.image_preprocessing.crop_params_dict</code> to <code>{}</code> initially (we’ll determine crops later)</li> <li>Configure <code>env.robot</code>, <code>env.teleop</code>, and other hardware settings in the <code>env</code> section</li>",Ie,Vs,$i="Example configuration section:",fe,Ys,Ce,Fs,be,Ps,Ni=`Along with your robot, you will need a teleoperation device to control it in order to collect datasets of your task and perform interventions during the online training.
We support using a gamepad or a keyboard or the leader arm of the robot.`,ge,Ds,qi="HIL-Serl learns actions in the end-effector space of the robot. Therefore, the teleoperation will control the end-effector’s x,y,z displacements.",ve,Os,xi="For that we need to define a version of the robot that takes actions in the end-effector space. Check the robot class <code>SO100FollowerEndEffector</code> and its configuration <code>SO100FollowerEndEffectorConfig</code> for the default parameters related to the end-effector space.",Ae,Ks,Be,st,Qi="The <code>Teleoperator</code> defines the teleoperation device. You can check the list of available teleoperators in <code>lerobot/teleoperators</code>.",_e,tt,ki="<strong>Setting up the Gamepad</strong>",Ze,lt,Li="The gamepad provides a very convenient way to control the robot and the episode state.",Ee,nt,Hi="To setup the gamepad, you need to set the <code>control_mode</code> to <code>&quot;gamepad&quot;</code> and define the <code>teleop</code> section in the configuration file.",$e,et,Ne,C,Ri='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/gamepad_guide.jpg?raw=true" alt="Figure shows the control mappings on a Logitech gamepad." title="Gamepad Control Mapping" width="100%"/>',qe,b,Si="<i>Gamepad button mapping for robot control and episode management</i>",xe,at,Wi="<strong>Setting up the SO101 leader</strong>",Qe,pt,Gi="The SO101 leader arm has reduced gears that allows it to move and track the follower arm during exploration. Therefore, taking over is much smoother than the gearless SO100.",ke,it,Xi="To setup the SO101 leader, you need to set the <code>control_mode</code> to <code>&quot;leader&quot;</code> and define the <code>teleop</code> section in the configuration file.",Le,ot,He,ct,zi=`In order to annotate the success/failure of the episode, <strong>you will need</strong> to use a keyboard to press <code>s</code> for success, <code>esc</code> for failure.
During the online training, press <code>space</code> to take over the policy and <code>space</code> again to give the control back to the policy.`,Re,rt,Vi='<summary><strong>Video: SO101 leader teleoperation</strong></summary> <div class="video-container"><video controls="" width="600"><source src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/so101_leader_tutorial.mp4" type="video/mp4"/></video></div> <p align="center"><i>SO101 leader teleoperation example, the leader tracks the follower, press `space` to intervene</i></p>',Se,Mt,Yi="<strong>Recording Demonstrations</strong>",We,ut,Fi='Start the recording process, an example of the config file can be found <a href="https://huggingface.co/datasets/aractingi/lerobot-example-config-files/blob/main/env_config_so100.json" rel="nofollow">here</a>:',Ge,jt,Xe,yt,Pi="During recording:",ze,ht,Di="<li>The robot will reset to the initial position defined in the configuration file <code>env.processor.reset.fixed_reset_joint_positions</code></li> <li>Complete the task successfully</li> <li>The episode ends with a reward of 1 when you press the “success” button</li> <li>If the time limit is reached, or the fail button is pressed, the episode ends with a reward of 0</li> <li>You can rerecord an episode by pressing the “rerecord” button</li> <li>The process automatically continues to the next episode</li> <li>After recording all episodes, the dataset is pushed to the Hugging Face Hub (optional) and saved locally</li>",Ve,Tt,Ye,Jt,Oi=`After collecting demonstrations, process them to determine optimal camera crops.
Reinforcement learning is sensitive to background distractions, so it is important to crop the images to the relevant workspace area.`,Fe,mt,Ki="Visual RL algorithms learn directly from pixel inputs, making them vulnerable to irrelevant visual information. Background elements like changing lighting, shadows, people moving, or objects outside the workspace can confuse the learning process. Good ROI selection should:",Pe,wt,so="<li>Include only the essential workspace where the task happens</li> <li>Capture the robot’s end-effector and all objects involved in the task</li> <li>Exclude unnecessary background elements and distractions</li>",De,dt,to="Note: If you already know the crop parameters, you can skip this step and just set the <code>crop_params_dict</code> in the configuration file during recording.",Oe,Ut,lo="<strong>Determining Crop Parameters</strong>",Ke,It,no="Use the <code>crop_dataset_roi.py</code> script to interactively select regions of interest in your camera images:",sa,ft,ta,Ct,eo="<li>For each camera view, the script will display the first frame</li> <li>Draw a rectangle around the relevant workspace area</li> <li>Press ‘c’ to confirm the selection</li> <li>Repeat for all camera views</li> <li>The script outputs cropping parameters and creates a new cropped dataset</li>",la,bt,ao="Example output:",na,gt,ea,g,po='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/crop_dataset.gif" width="600"/>',aa,v,io="<i>Interactive cropping tool for selecting regions of interest</i>",pa,vt,oo="<strong>Updating Configuration</strong>",ia,At,co="Add these crop parameters to your training configuration:",oa,Bt,ca,_t,ro="<strong>Recommended image resolution</strong>",ra,Zt,Mo="Most vision-based policies have been validated on square inputs of either <strong>128×128</strong> (default) or <strong>64×64</strong> pixels. We therefore advise setting the resize_size parameter to [128, 128] – or [64, 64] if you need to save GPU memory and bandwidth. Other resolutions are possible but have not been extensively tested.",Ma,Et,ua,$t,uo="The reward classifier plays an important role in the HIL-SERL workflow by automating reward assignment and automatically detecting episode success. Instead of manually defining reward functions or relying on human feedback for every timestep, the reward classifier learns to predict success/failure from visual observations. This enables the RL algorithm to learn efficiently by providing consistent and automated reward signals based on the robot’s camera inputs.",ja,Nt,jo="This guide explains how to train a reward classifier for human-in-the-loop reinforcement learning implementation of LeRobot. Reward classifiers learn to predict the reward value given a state which can be used in an RL setup to train a policy.",ya,qt,yo="<strong>Note</strong>: Training a reward classifier is optional. You can start the first round of RL experiments by annotating the success manually with your gamepad or keyboard device.",ha,xt,ho="The reward classifier implementation in <code>modeling_classifier.py</code> uses a pretrained vision model to process the images. It can output either a single value for binary rewards to predict success/fail cases or multiple values for multi-class settings.",Ta,Qt,To="<strong>Collecting a Dataset for the reward classifier</strong>",Ja,kt,Jo="Before training, you need to collect a dataset with labeled examples. The <code>record_dataset</code> function in <code>gym_manipulator.py</code> enables the process of collecting a dataset of observations, actions, and rewards.",ma,Lt,mo="To collect a dataset, you need to modify some parameters in the environment configuration based on HILSerlRobotEnvConfig.",wa,Ht,da,Rt,wo="<strong>Key Parameters for Data Collection</strong>",Ua,St,Uo="<li><strong>mode</strong>: set it to <code>&quot;record&quot;</code> to collect a dataset (at root level)</li> <li><strong>dataset.repo_id</strong>: <code>&quot;hf_username/dataset_name&quot;</code>, name of the dataset and repo on the hub</li> <li><strong>dataset.num_episodes_to_record</strong>: Number of episodes to record</li> <li><strong>env.processor.reset.terminate_on_success</strong>: Whether to automatically terminate episodes when success is detected (default: <code>true</code>)</li> <li><strong>env.fps</strong>: Number of frames per second to record</li> <li><strong>dataset.push_to_hub</strong>: Whether to push the dataset to the hub</li>",Ia,Wt,Io="The <code>env.processor.reset.terminate_on_success</code> parameter allows you to control episode termination behavior. When set to <code>false</code>, episodes will continue even after success is detected, allowing you to collect more positive examples with the reward=1 label. This is crucial for training reward classifiers as it provides more success state examples in your dataset. When set to <code>true</code> (default), episodes terminate immediately upon success detection.",fa,Gt,fo="<strong>Important</strong>: For reward classifier training, set <code>terminate_on_success: false</code> to collect sufficient positive examples. For regular HIL-SERL training, keep it as <code>true</code> to enable automatic episode termination when the task is completed successfully.",Ca,Xt,Co="Example configuration section for data collection:",ba,zt,ga,Vt,bo="<strong>Reward Classifier Configuration</strong>",va,Yt,go="The reward classifier is configured using <code>configuration_classifier.py</code>. Here are the key parameters:",Aa,Ft,vo="<li><strong>model_name</strong>: Base model architecture (e.g., we mainly use <code>&quot;helper2424/resnet10&quot;</code>)</li> <li><strong>model_type</strong>: <code>&quot;cnn&quot;</code> or <code>&quot;transformer&quot;</code></li> <li><strong>num_cameras</strong>: Number of camera inputs</li> <li><strong>num_classes</strong>: Number of output classes (typically 2 for binary success/failure)</li> <li><strong>hidden_dim</strong>: Size of hidden representation</li> <li><strong>dropout_rate</strong>: Regularization parameter</li> <li><strong>learning_rate</strong>: Learning rate for optimizer</li>",Ba,Pt,Ao='Example configuration for training the <a href="https://huggingface.co/datasets/aractingi/lerobot-example-config-files/blob/main/reward_classifier_train_config.json" rel="nofollow">reward classifier</a>:',_a,Dt,Za,Ot,Bo="<strong>Training the Classifier</strong>",Ea,Kt,_o="To train the classifier, use the <code>train.py</code> script with your configuration:",$a,sl,Na,tl,Zo="<strong>Deploying and Testing the Model</strong>",qa,ll,Eo="To use your trained reward classifier, configure the <code>HILSerlRobotEnvConfig</code> to use your model:",xa,nl,Qa,el,$o="or set the argument in the json config file.",ka,al,La,pl,No="Run <code>gym_manipulator.py</code> to test the model.",Ha,il,Ra,ol,qo="The reward classifier will automatically provide rewards based on the visual input from the robot’s cameras.",Sa,cl,xo="<strong>Example Workflow for training the reward classifier</strong>",Wa,w,Kl,Qo=`<p><strong>Create the configuration files</strong>:
Create the necessary json configuration files for the reward classifier and the environment. Check the examples <a href="https://huggingface.co/datasets/lerobot/config_examples/resolve/main/reward_classifier/config.json" rel="nofollow">here</a>.</p>`,Qp,rl,sn,ko="<strong>Collect a dataset</strong>:",kp,Ml,Lp,ul,tn,Lo="<strong>Train the classifier</strong>:",Hp,jl,Rp,yl,ln,Ho="<strong>Test the classifier</strong>:",Sp,hl,Ga,Tl,Xa,Jl,Ro="The LeRobot system uses a distributed actor-learner architecture for training. This architecture decouples robot interactions from the learning process, allowing them to run concurrently without blocking each other. The actor server handles robot observations and actions, sending interaction data to the learner server. The learner server performs gradient descent and periodically updates the actor’s policy weights. You will need to start two processes: a learner and an actor.",za,ml,So="<strong>Configuration Setup</strong>",Va,wl,Wo='Create a training configuration file (example available <a href="https://huggingface.co/datasets/lerobot/config_examples/resolve/main/rl/train_config.json" rel="nofollow">here</a>). The training config is based on the main <code>TrainRLServerPipelineConfig</code> class in <code>lerobot/configs/train.py</code>.',Ya,dl,Go='<li>Configure the policy settings (<code>type=&quot;sac&quot;</code>, <code>device</code>, etc.)</li> <li>Set <code>dataset</code> to your cropped dataset</li> <li>Configure environment settings with crop parameters</li> <li>Check the other parameters related to SAC in <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/policies/sac/configuration_sac.py#L79" rel="nofollow">configuration_sac.py</a>.</li> <li>Verify that the <code>policy</code> config is correct with the right <code>input_features</code> and <code>output_features</code> for your task.</li>',Fa,Ul,Xo="<strong>Starting the Learner</strong>",Pa,Il,zo="First, start the learner server process:",Da,fl,Oa,Cl,Vo="The learner:",Ka,bl,Yo="<li>Initializes the policy network</li> <li>Prepares replay buffers</li> <li>Opens a <code>gRPC</code> server to communicate with actors</li> <li>Processes transitions and updates the policy</li>",sp,gl,Fo="<strong>Starting the Actor</strong>",tp,vl,Po="In a separate terminal, start the actor process with the same configuration:",lp,Al,np,Bl,Do="The actor:",ep,_l,Oo="<li>Connects to the learner via <code>gRPC</code></li> <li>Initializes the environment</li> <li>Execute rollouts of the policy to collect experience</li> <li>Sends transitions to the learner</li> <li>Receives updated policy parameters</li>",ap,Zl,Ko="<strong>Training Flow</strong>",pp,El,sc="The training proceeds automatically:",ip,$l,tc="<li>The actor executes the policy in the environment</li> <li>Transitions are collected and sent to the learner</li> <li>The learner updates the policy based on these transitions</li> <li>Updated policy parameters are sent back to the actor</li> <li>The process continues until the specified step limit is reached</li>",op,Nl,lc="<strong>Human in the Loop</strong>",cp,ql,nc="<li>The key to learning efficiently is to have human interventions to provide corrective feedback and completing the task to aide the policy learning and exploration.</li> <li>To perform human interventions, you can press the upper right trigger button on the gamepad (or the <code>space</code> key on the keyboard). This will pause the policy actions and allow you to take over.</li> <li>A successful experiment is one where the human has to intervene at the start but then reduces the amount of interventions as the policy improves. You can monitor the intervention rate in the <code>wandb</code> dashboard.</li>",rp,A,ec='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/hil_effect.png?raw=true" alt="Figure shows the control mappings on a Logitech gamepad." title="Gamepad Control Mapping" width="100%"/>',Mp,B,ac="<i>Example showing how human interventions help guide policy learning over time</i>",up,xl,pc="<li>The figure shows the plot of the episodic reward over interaction step. The figure shows the effect of human interventions on the policy learning.</li> <li>The orange curve is an experiment without any human interventions. While the pink and blue curves are experiments with human interventions.</li> <li>We can observe that the number of steps where the policy starts achieving the maximum reward is cut by a quarter when human interventions are present.</li>",jp,Ql,ic="<strong>Monitoring and Debugging</strong>",yp,kl,oc='If you have <code>wandb.enable</code> set to <code>true</code> in your configuration, you can monitor training progress in real-time through the <a href="https://wandb.ai/site/" rel="nofollow">Weights &amp; Biases</a> dashboard.',hp,Ll,Tp,Hl,cc="The learning process is very sensitive to the intervention strategy. It will takes a few runs to understand how to intervene effectively. Some tips and hints:",Jp,Rl,rc="<li>Allow the policy to explore for a few episodes at the start of training.</li> <li>Avoid intervening for long periods of time. Try to intervene in situation to correct the robot’s behaviour when it goes off track.</li> <li>Once the policy starts achieving the task, even if its not perfect, you can limit your interventions to simple quick actions like a simple grasping commands.</li>",mp,Sl,Mc="The ideal behaviour is that your intervention rate should drop gradually during training as shown in the figure below.",wp,_,uc='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobot/intervention_rate_tutorial_rl.png?raw=true" alt="Intervention rate" title="Intervention rate during training" width="100%"/>',dp,Z,jc=`<i>Plot of the intervention rate during a training run on a pick and lift cube
    task</i>`,Up,Wl,Ip,Gl,yc="Some configuration values have a disproportionate impact on training stability and speed:",fp,Xl,hc="<li><strong><code>temperature_init</code></strong> (<code>policy.temperature_init</code>) – initial entropy temperature in SAC. Higher values encourage more exploration; lower values make the policy more deterministic early on. A good starting point is <code>1e-2</code>. We observed that setting it too high can make human interventions ineffective and slow down learning.</li> <li><strong><code>policy_parameters_push_frequency</code></strong> (<code>policy.actor_learner_config.policy_parameters_push_frequency</code>) – interval in <em>seconds</em> between two weight pushes from the learner to the actor. The default is <code>4 s</code>. Decrease to <strong>1-2 s</strong> to provide fresher weights (at the cost of more network traffic); increase only if your connection is slow, as this will reduce sample efficiency.</li> <li><strong><code>storage_device</code></strong> (<code>policy.storage_device</code>) – device on which the learner keeps the policy parameters. If you have spare GPU memory, set this to <code>&quot;cuda&quot;</code> (instead of the default <code>&quot;cpu&quot;</code>). Keeping the weights on-GPU removes CPU→GPU transfer overhead and can significantly increase the number of learner updates per second.</li>",Cp,zl,Tc="Congrats 🎉, you have finished this tutorial!",bp,E,Jc='<p>If you have any questions or need help, please reach out on <a href="https://discord.com/invite/s3KuuzsPFb" rel="nofollow">Discord</a>.</p>',gp,Vl,mc="Paper citation:",vp,Yl,Ap,Fl,Bp,an,_p;return q=new vc({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),x=new T({props:{title:"HIL-SERL Real Robot Training Workflow Guide",local:"hil-serl-real-robot-training-workflow-guide",headingTag:"h1"}}),W=new T({props:{title:"What do I need?",local:"what-do-i-need",headingTag:"h2"}}),X=new T({props:{title:"What kind of tasks can I train?",local:"what-kind-of-tasks-can-i-train",headingTag:"h2"}}),Y=new T({props:{title:"Install LeRobot with HIL-SERL",local:"install-lerobot-with-hil-serl",headingTag:"h2"}}),P=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1lJTIwJTIyLiU1QmhpbHNlcmwlNUQlMjI=",highlighted:'pip install -e <span class="hljs-string">&quot;.[hilserl]&quot;</span>',wrap:!1}}),D=new T({props:{title:"Real Robot Training Workflow",local:"real-robot-training-workflow",headingTag:"h2"}}),O=new T({props:{title:"Understanding Configuration",local:"understanding-configuration",headingTag:"h3"}}),ss=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">GymManipulatorConfig</span>:
    env: HILSerlRobotEnvConfig    <span class="hljs-comment"># Environment configuration (nested)</span>
    dataset: DatasetConfig    <span class="hljs-comment"># Dataset recording/replay configuration (nested)</span>
    mode: <span class="hljs-built_in">str</span> | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># &quot;record&quot;, &quot;replay&quot;, or None (for training)</span>
    device: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;cpu&quot;</span>    <span class="hljs-comment"># Compute device</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HILSerlRobotEnvConfig</span>(<span class="hljs-title class_ inherited__">EnvConfig</span>):
    robot: RobotConfig | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Main robot agent (defined in \`lerobot/robots\`)</span>
    teleop: TeleoperatorConfig | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Teleoperator agent, e.g., gamepad or leader arm</span>
    processor: HILSerlProcessorConfig    <span class="hljs-comment"># Processing pipeline configuration (nested)</span>
    name: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;real_robot&quot;</span>    <span class="hljs-comment"># Environment name</span>
    task: <span class="hljs-built_in">str</span> | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Task identifier</span>
    fps: <span class="hljs-built_in">int</span> = <span class="hljs-number">10</span>    <span class="hljs-comment"># Control frequency</span>

<span class="hljs-comment"># Nested processor configuration</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">HILSerlProcessorConfig</span>:
    control_mode: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;gamepad&quot;</span>    <span class="hljs-comment"># Control mode</span>
    observation: ObservationConfig | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Observation processing settings</span>
    image_preprocessing: ImagePreprocessingConfig | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Image crop/resize settings</span>
    gripper: GripperConfig | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Gripper control and penalty settings</span>
    reset: ResetConfig | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Environment reset and timing settings</span>
    inverse_kinematics: InverseKinematicsConfig | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># IK processing settings</span>
    reward_classifier: RewardClassifierConfig | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Reward classifier settings</span>
    max_gripper_pos: <span class="hljs-built_in">float</span> | <span class="hljs-literal">None</span> = <span class="hljs-number">100.0</span>    <span class="hljs-comment"># Maximum gripper position</span>

<span class="hljs-comment"># Sub-configuration classes</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">ObservationConfig</span>:
    add_joint_velocity_to_observation: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>    <span class="hljs-comment"># Add joint velocities to state</span>
    add_current_to_observation: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>    <span class="hljs-comment"># Add motor currents to state</span>
    display_cameras: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>    <span class="hljs-comment"># Display camera feeds during execution</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">ImagePreprocessingConfig</span>:
    crop_params_dict: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">tuple</span>[<span class="hljs-built_in">int</span>, <span class="hljs-built_in">int</span>, <span class="hljs-built_in">int</span>, <span class="hljs-built_in">int</span>]] | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Image cropping parameters</span>
    resize_size: <span class="hljs-built_in">tuple</span>[<span class="hljs-built_in">int</span>, <span class="hljs-built_in">int</span>] | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Target image size</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">GripperConfig</span>:
    use_gripper: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">True</span>    <span class="hljs-comment"># Enable gripper control</span>
    gripper_penalty: <span class="hljs-built_in">float</span> = <span class="hljs-number">0.0</span>    <span class="hljs-comment"># Penalty for inappropriate gripper usage</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResetConfig</span>:
    fixed_reset_joint_positions: <span class="hljs-type">Any</span> | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Joint positions for reset</span>
    reset_time_s: <span class="hljs-built_in">float</span> = <span class="hljs-number">5.0</span>    <span class="hljs-comment"># Time to wait during reset</span>
    control_time_s: <span class="hljs-built_in">float</span> = <span class="hljs-number">20.0</span>    <span class="hljs-comment"># Maximum episode duration</span>
    terminate_on_success: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">True</span>    <span class="hljs-comment"># Whether to terminate episodes on success detection</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">InverseKinematicsConfig</span>:
    urdf_path: <span class="hljs-built_in">str</span> | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Path to robot URDF file</span>
    target_frame_name: <span class="hljs-built_in">str</span> | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># End-effector frame name</span>
    end_effector_bounds: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">list</span>[<span class="hljs-built_in">float</span>]] | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># EE workspace bounds</span>
    end_effector_step_sizes: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">float</span>] | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># EE step sizes per axis</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">RewardClassifierConfig</span>:
    pretrained_path: <span class="hljs-built_in">str</span> | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Path to pretrained reward classifier</span>
    success_threshold: <span class="hljs-built_in">float</span> = <span class="hljs-number">0.5</span>    <span class="hljs-comment"># Success detection threshold</span>
    success_reward: <span class="hljs-built_in">float</span> = <span class="hljs-number">1.0</span>    <span class="hljs-comment"># Reward value for successful episodes</span>

<span class="hljs-comment"># Dataset configuration</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">DatasetConfig</span>:
    repo_id: <span class="hljs-built_in">str</span>    <span class="hljs-comment"># LeRobot dataset repository ID</span>
    task: <span class="hljs-built_in">str</span>    <span class="hljs-comment"># Task identifier</span>
    root: <span class="hljs-built_in">str</span> | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Local dataset root directory</span>
    num_episodes_to_record: <span class="hljs-built_in">int</span> = <span class="hljs-number">5</span>    <span class="hljs-comment"># Number of episodes for recording</span>
    replay_episode: <span class="hljs-built_in">int</span> | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>    <span class="hljs-comment"># Episode index for replay</span>
    push_to_hub: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>    <span class="hljs-comment"># Whether to push datasets to Hub</span>`,wrap:!1}}),ts=new T({props:{title:"Processor Pipeline Architecture",local:"processor-pipeline-architecture",headingTag:"h3"}}),ns=new T({props:{title:"Environment Processor Pipeline",local:"environment-processor-pipeline",headingTag:"h4"}}),ps=new T({props:{title:"Action Processor Pipeline",local:"action-processor-pipeline",headingTag:"h4"}}),cs=new T({props:{title:"Configuration Examples",local:"configuration-examples",headingTag:"h4"}}),Ms=new h({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvY2Vzc29yJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyb2JzZXJ2YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhZGRfam9pbnRfdmVsb2NpdHlfdG9fb2JzZXJ2YXRpb24lMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWRkX2N1cnJlbnRfdG9fb2JzZXJ2YXRpb24lMjIlM0ElMjBmYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRpc3BsYXlfY2FtZXJhcyUyMiUzQSUyMGZhbHNlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;observation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;add_joint_velocity_to_observation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;add_current_to_observation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;display_cameras&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),js=new h({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvY2Vzc29yJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW1hZ2VfcHJlcHJvY2Vzc2luZyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNyb3BfcGFyYW1zX2RpY3QlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5pbWFnZXMuZnJvbnQlMjIlM0ElMjAlNUIxODAlMkMlMjAyNTAlMkMlMjAxMjAlMkMlMjAxNTAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5pbWFnZXMuc2lkZSUyMiUzQSUyMCU1QjE4MCUyQyUyMDIwNyUyQyUyMDE4MCUyQyUyMDIwMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlc2l6ZV9zaXplJTIyJTNBJTIwJTVCMTI4JTJDJTIwMTI4JTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;image_preprocessing&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;crop_params_dict&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;observation.images.front&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">180</span><span class="hljs-punctuation">,</span> <span class="hljs-number">250</span><span class="hljs-punctuation">,</span> <span class="hljs-number">120</span><span class="hljs-punctuation">,</span> <span class="hljs-number">150</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;observation.images.side&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">180</span><span class="hljs-punctuation">,</span> <span class="hljs-number">207</span><span class="hljs-punctuation">,</span> <span class="hljs-number">180</span><span class="hljs-punctuation">,</span> <span class="hljs-number">200</span><span class="hljs-punctuation">]</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;resize_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">128</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">]</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),hs=new h({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvY2Vzc29yJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW52ZXJzZV9raW5lbWF0aWNzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydXJkZl9wYXRoJTIyJTNBJTIwJTIycGF0aCUyRnRvJTJGcm9ib3QudXJkZiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRhcmdldF9mcmFtZV9uYW1lJTIyJTNBJTIwJTIyZW5kX2VmZmVjdG9yJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW5kX2VmZmVjdG9yX2JvdW5kcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1pbiUyMiUzQSUyMCU1QjAuMTYlMkMlMjAtMC4wOCUyQyUyMDAuMDMlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtYXglMjIlM0ElMjAlNUIwLjI0JTJDJTIwMC4yJTJDJTIwMC4xJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW5kX2VmZmVjdG9yX3N0ZXBfc2l6ZXMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ4JTIyJTNBJTIwMC4wMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnklMjIlM0ElMjAwLjAyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyeiUyMiUzQSUyMDAuMDIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;inverse_kinematics&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;urdf_path&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;path/to/robot.urdf&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;target_frame_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;end_effector&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;end_effector_bounds&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;min&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">0.16</span><span class="hljs-punctuation">,</span> <span class="hljs-number">-0.08</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.03</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;max&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">0.24</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.2</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.1</span><span class="hljs-punctuation">]</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;end_effector_step_sizes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;x&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.02</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;y&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.02</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;z&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.02</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ts=new T({props:{title:"Advanced Observation Processing",local:"advanced-observation-processing",headingTag:"h3"}}),ms=new T({props:{title:"Joint Velocity Processing",local:"joint-velocity-processing",headingTag:"h4"}}),ds=new h({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvY2Vzc29yJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyb2JzZXJ2YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhZGRfam9pbnRfdmVsb2NpdHlfdG9fb2JzZXJ2YXRpb24lMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;observation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;add_joint_velocity_to_observation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),fs=new T({props:{title:"Motor Current Processing",local:"motor-current-processing",headingTag:"h4"}}),bs=new h({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvY2Vzc29yJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyb2JzZXJ2YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhZGRfY3VycmVudF90b19vYnNlcnZhdGlvbiUyMiUzQSUyMHRydWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;observation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;add_current_to_observation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),As=new T({props:{title:"Combined Observation Processing",local:"combined-observation-processing",headingTag:"h4"}}),_s=new h({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvY2Vzc29yJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyb2JzZXJ2YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhZGRfam9pbnRfdmVsb2NpdHlfdG9fb2JzZXJ2YXRpb24lMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWRkX2N1cnJlbnRfdG9fb2JzZXJ2YXRpb24lMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGlzcGxheV9jYW1lcmFzJTIyJTNBJTIwZmFsc2UlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;observation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;add_joint_velocity_to_observation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;add_current_to_observation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;display_cameras&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Es=new T({props:{title:"Finding Robot Workspace Bounds",local:"finding-robot-workspace-bounds",headingTag:"h3"}}),Qs=new h({props:{code:"bGVyb2JvdC1maW5kLWpvaW50LWxpbWl0cyUyMCU1QyUwQSUyMCUyMC0tcm9ib3QudHlwZSUzRHNvMTAwX2ZvbGxvd2VyJTIwJTVDJTBBJTIwJTIwLS1yb2JvdC5wb3J0JTNEJTJGZGV2JTJGdHR5LnVzYm1vZGVtNTg3NjA0MzE1NDElMjAlNUMlMEElMjAlMjAtLXJvYm90LmlkJTNEYmxhY2slMjAlNUMlMEElMjAlMjAtLXRlbGVvcC50eXBlJTNEc28xMDBfbGVhZGVyJTIwJTVDJTBBJTIwJTIwLS10ZWxlb3AucG9ydCUzRCUyRmRldiUyRnR0eS51c2Jtb2RlbTU4NzYwNDMxNTUxJTIwJTVDJTBBJTIwJTIwLS10ZWxlb3AuaWQlM0RibHVl",highlighted:`lerobot-find-joint-limits \\
  --robot.type=so100_follower \\
  --robot.port=/dev/tty.usbmodem58760431541 \\
  --robot.id=black \\
  --teleop.type=so100_leader \\
  --teleop.port=/dev/tty.usbmodem58760431551 \\
  --teleop.id=blue`,wrap:!1}}),Ls=new h({props:{code:"TWF4JTIwZWUlMjBwb3NpdGlvbiUyMCU1QjAuMjQxNyUyMDAuMjAxMiUyMDAuMTAyNyU1RCUwQU1pbiUyMGVlJTIwcG9zaXRpb24lMjAlNUIwLjE2NjMlMjAtMC4wODIzJTIwMC4wMzM2JTVEJTBBTWF4JTIwam9pbnQlMjBwb3NpdGlvbnMlMjAlNUItMjAuMCUyQyUyMC0yMC4wJTJDJTIwLTIwLjAlMkMlMjAtMjAuMCUyQyUyMC0yMC4wJTJDJTIwLTIwLjAlNUQlMEFNaW4lMjBqb2ludCUyMHBvc2l0aW9ucyUyMCU1QjUwLjAlMkMlMjA1MC4wJTJDJTIwNTAuMCUyQyUyMDUwLjAlMkMlMjA1MC4wJTJDJTIwNTAuMCU1RA==",highlighted:`Max ee position [0.2417 0.2012 0.1027]
Min ee position [0.1663 <span class="hljs-string">-0</span>.0823 0.0336]
Max joint positions [<span class="hljs-string">-20</span>.0, <span class="hljs-string">-20</span>.0, <span class="hljs-string">-20</span>.0, <span class="hljs-string">-20</span>.0, <span class="hljs-string">-20</span>.0, <span class="hljs-string">-20</span>.0]
Min joint positions [50.0, 50.0, 50.0, 50.0, 50.0, 50.0]`,wrap:!1}}),Rs=new h({props:{code:"JTIyZW5kX2VmZmVjdG9yX2JvdW5kcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMm1heCUyMiUzQSUyMCU1QjAuMjQlMkMlMjAwLjIwJTJDJTIwMC4xMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMm1pbiUyMiUzQSUyMCU1QjAuMTYlMkMlMjAtMC4wOCUyQyUyMDAuMDMlNUQlMEElN0Q=",highlighted:`<span class="hljs-attr">&quot;end_effector_bounds&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;max&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">0.24</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.20</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.10</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;min&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">0.16</span><span class="hljs-punctuation">,</span> <span class="hljs-number">-0.08</span><span class="hljs-punctuation">,</span> <span class="hljs-number">0.03</span><span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ss=new T({props:{title:"Collecting Demonstrations",local:"collecting-demonstrations",headingTag:"h3"}}),Ys=new h({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gym_manipulator&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;real_robot&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;fps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">10</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;control_mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gamepad&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;observation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;display_cameras&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;image_preprocessing&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;crop_params_dict&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;resize_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">128</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">]</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;gripper&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;use_gripper&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;gripper_penalty&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;reset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;reset_time_s&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">5.0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;control_time_s&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">20.0</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;robot&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-comment">// ... robot configuration ...</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;teleop&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-comment">// ... teleoperator configuration ...</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;dataset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;repo_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;username/pick_lift_cube&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;root&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;pick_and_lift&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_episodes_to_record&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">15</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;replay_episode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;push_to_hub&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;record&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Fs=new T({props:{title:"Using a Teleoperation Device",local:"using-a-teleoperation-device",headingTag:"h3"}}),Ks=new h({props:{code:"Y2xhc3MlMjBTTzEwMEZvbGxvd2VyRW5kRWZmZWN0b3JDb25maWcoU08xMDBGb2xsb3dlckNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJDb25maWd1cmF0aW9uJTIwZm9yJTIwdGhlJTIwU08xMDBGb2xsb3dlckVuZEVmZmVjdG9yJTIwcm9ib3QuJTIyJTIyJTIyJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRGVmYXVsdCUyMGJvdW5kcyUyMGZvciUyMHRoZSUyMGVuZC1lZmZlY3RvciUyMHBvc2l0aW9uJTIwKGluJTIwbWV0ZXJzKSUwQSUyMCUyMCUyMCUyMGVuZF9lZmZlY3Rvcl9ib3VuZHMlM0ElMjBkaWN0JTVCc3RyJTJDJTIwbGlzdCU1QmZsb2F0JTVEJTVEJTIwJTNEJTIwZmllbGQoJTIwJTIzJTIwYm91bmRzJTIwZm9yJTIwdGhlJTIwZW5kLWVmZmVjdG9yJTIwaW4lMjB4JTJDeSUyQ3olMjBkaXJlY3Rpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZWZhdWx0X2ZhY3RvcnklM0RsYW1iZGElM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtaW4lMjIlM0ElMjAlNUItMS4wJTJDJTIwLTEuMCUyQyUyMC0xLjAlNUQlMkMlMjAlMjAlMjMlMjBtaW4lMjB4JTJDJTIweSUyQyUyMHolMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtYXglMjIlM0ElMjAlNUIxLjAlMkMlMjAxLjAlMkMlMjAxLjAlNUQlMkMlMjAlMjAlMjMlMjBtYXglMjB4JTJDJTIweSUyQyUyMHolMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwbWF4X2dyaXBwZXJfcG9zJTNBJTIwZmxvYXQlMjAlM0QlMjA1MCUyMCUyMyUyMG1heGltdW0lMjBncmlwcGVyJTIwcG9zaXRpb24lMjB0aGF0JTIwdGhlJTIwZ3JpcHBlciUyMHdpbGwlMjBiZSUyMG9wZW4lMjBhdCUwQSUwQSUyMCUyMCUyMCUyMGVuZF9lZmZlY3Rvcl9zdGVwX3NpemVzJTNBJTIwZGljdCU1QnN0ciUyQyUyMGZsb2F0JTVEJTIwJTNEJTIwZmllbGQoJTIwJTIzJTIwbWF4aW11bSUyMHN0ZXAlMjBzaXplJTIwZm9yJTIwdGhlJTIwZW5kLWVmZmVjdG9yJTIwaW4lMjB4JTJDeSUyQ3olMjBkaXJlY3Rpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZWZhdWx0X2ZhY3RvcnklM0RsYW1iZGElM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ4JTIyJTNBJTIwMC4wMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnklMjIlM0ElMjAwLjAyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyeiUyMiUzQSUyMDAuMDIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAp",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SO100FollowerEndEffectorConfig</span>(<span class="hljs-title class_ inherited__">SO100FollowerConfig</span>):
    <span class="hljs-string">&quot;&quot;&quot;Configuration for the SO100FollowerEndEffector robot.&quot;&quot;&quot;</span>

    <span class="hljs-comment"># Default bounds for the end-effector position (in meters)</span>
    end_effector_bounds: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">list</span>[<span class="hljs-built_in">float</span>]] = field( <span class="hljs-comment"># bounds for the end-effector in x,y,z direction</span>
        default_factory=<span class="hljs-keyword">lambda</span>: {
            <span class="hljs-string">&quot;min&quot;</span>: [-<span class="hljs-number">1.0</span>, -<span class="hljs-number">1.0</span>, -<span class="hljs-number">1.0</span>],  <span class="hljs-comment"># min x, y, z</span>
            <span class="hljs-string">&quot;max&quot;</span>: [<span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>],  <span class="hljs-comment"># max x, y, z</span>
        }
    )

    max_gripper_pos: <span class="hljs-built_in">float</span> = <span class="hljs-number">50</span> <span class="hljs-comment"># maximum gripper position that the gripper will be open at</span>

    end_effector_step_sizes: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">float</span>] = field( <span class="hljs-comment"># maximum step size for the end-effector in x,y,z direction</span>
        default_factory=<span class="hljs-keyword">lambda</span>: {
            <span class="hljs-string">&quot;x&quot;</span>: <span class="hljs-number">0.02</span>,
            <span class="hljs-string">&quot;y&quot;</span>: <span class="hljs-number">0.02</span>,
            <span class="hljs-string">&quot;z&quot;</span>: <span class="hljs-number">0.02</span>,
        }
    )`,wrap:!1}}),et=new h({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydGVsZW9wJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmdhbWVwYWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ1c2VfZ3JpcHBlciUyMiUzQSUyMHRydWUlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJwcm9jZXNzb3IlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250cm9sX21vZGUlMjIlM0ElMjAlMjJnYW1lcGFkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyZ3JpcHBlciUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVzZV9ncmlwcGVyJTIyJTNBJTIwdHJ1ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;teleop&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gamepad&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;use_gripper&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;control_mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gamepad&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;gripper&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;use_gripper&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ot=new h({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydGVsZW9wJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnNvMTAxX2xlYWRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnBvcnQlMjIlM0ElMjAlMjIlMkZkZXYlMkZ0dHkudXNibW9kZW01ODVBMDA3NzkyMSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnVzZV9kZWdyZWVzJTIyJTNBJTIwdHJ1ZSUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnByb2Nlc3NvciUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRyb2xfbW9kZSUyMiUzQSUyMCUyMmxlYWRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmdyaXBwZXIlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ1c2VfZ3JpcHBlciUyMiUzQSUyMHRydWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;teleop&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;so101_leader&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;port&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;/dev/tty.usbmodem585A0077921&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;use_degrees&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;control_mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;leader&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;gripper&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;use_gripper&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),jt=new h({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnJsLmd5bV9tYW5pcHVsYXRvciUyMC0tY29uZmlnX3BhdGglMjBzcmMlMkZsZXJvYm90JTJGY29uZmlncyUyRmVudl9jb25maWdfc28xMDAuanNvbg==",highlighted:"python -m lerobot.rl.gym_manipulator --config_path src/lerobot/configs/env_config_so100.json",wrap:!1}}),Tt=new T({props:{title:"Processing the Dataset",local:"processing-the-dataset",headingTag:"h3"}}),ft=new h({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnJsLmNyb3BfZGF0YXNldF9yb2klMjAtLXJlcG8taWQlMjB1c2VybmFtZSUyRnBpY2tfbGlmdF9jdWJl",highlighted:"python -m lerobot.rl.crop_dataset_roi --repo-id username/pick_lift_cube",wrap:!1}}),gt=new h({props:{code:"U2VsZWN0ZWQlMjBSZWN0YW5ndWxhciUyMFJlZ2lvbnMlMjBvZiUyMEludGVyZXN0JTIwKHRvcCUyQyUyMGxlZnQlMkMlMjBoZWlnaHQlMkMlMjB3aWR0aCklM0ElMEFvYnNlcnZhdGlvbi5pbWFnZXMuc2lkZSUzQSUyMCU1QjE4MCUyQyUyMDIwNyUyQyUyMDE4MCUyQyUyMDIwMCU1RCUwQW9ic2VydmF0aW9uLmltYWdlcy5mcm9udCUzQSUyMCU1QjE4MCUyQyUyMDI1MCUyQyUyMDEyMCUyQyUyMDE1MCU1RA==",highlighted:`Selected Rectangular Regions of Interest (<span class="hljs-attribute">top</span>, left, height, width):
observation<span class="hljs-selector-class">.images</span><span class="hljs-selector-class">.side</span>: <span class="hljs-selector-attr">[180, 207, 180, 200]</span>
observation<span class="hljs-selector-class">.images</span><span class="hljs-selector-class">.front</span>: <span class="hljs-selector-attr">[180, 250, 120, 150]</span>`,wrap:!1}}),Bt=new h({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvY2Vzc29yJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW1hZ2VfcHJlcHJvY2Vzc2luZyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNyb3BfcGFyYW1zX2RpY3QlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5pbWFnZXMuc2lkZSUyMiUzQSUyMCU1QjE4MCUyQyUyMDIwNyUyQyUyMDE4MCUyQyUyMDIwMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm9ic2VydmF0aW9uLmltYWdlcy5mcm9udCUyMiUzQSUyMCU1QjE4MCUyQyUyMDI1MCUyQyUyMDEyMCUyQyUyMDE1MCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlc2l6ZV9zaXplJTIyJTNBJTIwJTVCMTI4JTJDJTIwMTI4JTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;image_preprocessing&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;crop_params_dict&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;observation.images.side&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">180</span><span class="hljs-punctuation">,</span> <span class="hljs-number">207</span><span class="hljs-punctuation">,</span> <span class="hljs-number">180</span><span class="hljs-punctuation">,</span> <span class="hljs-number">200</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;observation.images.front&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">180</span><span class="hljs-punctuation">,</span> <span class="hljs-number">250</span><span class="hljs-punctuation">,</span> <span class="hljs-number">120</span><span class="hljs-punctuation">,</span> <span class="hljs-number">150</span><span class="hljs-punctuation">]</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;resize_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">128</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">]</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Et=new T({props:{title:"Training a Reward Classifier",local:"training-a-reward-classifier",headingTag:"h3"}}),Ht=new h({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnJsLmd5bV9tYW5pcHVsYXRvciUyMC0tY29uZmlnX3BhdGglMjBzcmMlMkZsZXJvYm90JTJGY29uZmlncyUyRnJld2FyZF9jbGFzc2lmaWVyX3RyYWluX2NvbmZpZy5qc29u",highlighted:"python -m lerobot.rl.gym_manipulator --config_path src/lerobot/configs/reward_classifier_train_config.json",wrap:!1}}),zt=new h({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmd5bV9tYW5pcHVsYXRvciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJyZWFsX3JvYm90JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyZnBzJTIyJTNBJTIwMTAlMkMlMEElMjAlMjAlMjAlMjAlMjJwcm9jZXNzb3IlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJyZXNldCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlc2V0X3RpbWVfcyUyMiUzQSUyMDUuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRyb2xfdGltZV9zJTIyJTNBJTIwMjAuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRlcm1pbmF0ZV9vbl9zdWNjZXNzJTIyJTNBJTIwZmFsc2UlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJncmlwcGVyJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydXNlX2dyaXBwZXIlMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIycm9ib3QlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMkYlMkYlMjAuLi4lMjByb2JvdCUyMGNvbmZpZ3VyYXRpb24lMjAuLi4lMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJ0ZWxlb3AlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMkYlMkYlMjAuLi4lMjB0ZWxlb3BlcmF0b3IlMjBjb25maWd1cmF0aW9uJTIwLi4uJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIyZGF0YXNldCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnJlcG9faWQlMjIlM0ElMjAlMjJoZl91c2VybmFtZSUyRmRhdGFzZXRfbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmRhdGFzZXRfcm9vdCUyMiUzQSUyMCUyMmRhdGElMkZ5b3VyX2RhdGFzZXQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0YXNrJTIyJTNBJTIwJTIycmV3YXJkX2NsYXNzaWZpZXJfdGFzayUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMm51bV9lcGlzb2Rlc190b19yZWNvcmQlMjIlM0ElMjAyMCUyQyUwQSUyMCUyMCUyMCUyMCUyMnJlcGxheV9lcGlzb2RlJTIyJTNBJTIwbnVsbCUyQyUwQSUyMCUyMCUyMCUyMCUyMnB1c2hfdG9faHViJTIyJTNBJTIwdHJ1ZSUwQSUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMm1vZGUlMjIlM0ElMjAlMjJyZWNvcmQlMjIlMkMlMEElMjAlMjAlMjJkZXZpY2UlMjIlM0ElMjAlMjJjcHUlMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gym_manipulator&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;real_robot&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;fps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">10</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;reset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;reset_time_s&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">5.0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;control_time_s&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">20.0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;terminate_on_success&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;gripper&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;use_gripper&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;robot&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-comment">// ... robot configuration ...</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;teleop&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-comment">// ... teleoperator configuration ...</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;dataset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;repo_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;hf_username/dataset_name&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;dataset_root&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;data/your_dataset&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;reward_classifier_task&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_episodes_to_record&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">20</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;replay_episode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;push_to_hub&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;record&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Dt=new h({props:{code:"JTdCJTBBJTIwJTIwJTIycG9saWN5JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnJld2FyZF9jbGFzc2lmaWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIybW9kZWxfbmFtZSUyMiUzQSUyMCUyMmhlbHBlcjI0MjQlMkZyZXNuZXQxMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMm1vZGVsX3R5cGUlMjIlM0ElMjAlMjJjbm4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJudW1fY2FtZXJhcyUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjJudW1fY2xhc3NlcyUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjJoaWRkZW5fZGltJTIyJTNBJTIwMjU2JTJDJTBBJTIwJTIwJTIwJTIwJTIyZHJvcG91dF9yYXRlJTIyJTNBJTIwMC4xJTJDJTBBJTIwJTIwJTIwJTIwJTIybGVhcm5pbmdfcmF0ZSUyMiUzQSUyMDFlLTQlMkMlMEElMjAlMjAlMjAlMjAlMjJkZXZpY2UlMjIlM0ElMjAlMjJjdWRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydXNlX2FtcCUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnB1dF9mZWF0dXJlcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm9ic2VydmF0aW9uLmltYWdlcy5mcm9udCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJWSVNVQUwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzaGFwZSUyMiUzQSUyMCU1QjMlMkMlMjAxMjglMkMlMjAxMjglNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5pbWFnZXMuc2lkZSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJWSVNVQUwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzaGFwZSUyMiUzQSUyMCU1QjMlMkMlMjAxMjglMkMlMjAxMjglNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;policy&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;reward_classifier&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;helper2424/resnet10&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cnn&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_cameras&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_classes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;hidden_dim&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">256</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;dropout_rate&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;learning_rate&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e-4</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cuda&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;use_amp&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;input_features&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;observation.images.front&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;VISUAL&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;shape&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">3</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">]</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;observation.images.side&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;VISUAL&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;shape&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-number">3</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">,</span> <span class="hljs-number">128</span><span class="hljs-punctuation">]</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),sl=new h({props:{code:"bGVyb2JvdC10cmFpbiUyMC0tY29uZmlnX3BhdGglMjBwYXRoJTJGdG8lMkZyZXdhcmRfY2xhc3NpZmllcl90cmFpbl9jb25maWcuanNvbg==",highlighted:"lerobot-train --config_path path/to/reward_classifier_train_config.json",wrap:!1}}),nl=new h({props:{code:"Y29uZmlnJTIwJTNEJTIwR3ltTWFuaXB1bGF0b3JDb25maWcoJTBBJTIwJTIwJTIwJTIwZW52JTNESElMU2VybFJvYm90RW52Q29uZmlnKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2Nlc3NvciUzREhJTFNlcmxQcm9jZXNzb3JDb25maWcoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV3YXJkX2NsYXNzaWZpZXIlM0RSZXdhcmRDbGFzc2lmaWVyQ29uZmlnKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByZXRyYWluZWRfcGF0aCUzRCUyMnBhdGhfdG9feW91cl9wcmV0cmFpbmVkX3RyYWluZWRfbW9kZWwlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME90aGVyJTIwZW52aXJvbm1lbnQlMjBwYXJhbWV0ZXJzJTBBJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXQlM0REYXRhc2V0Q29uZmlnKC4uLiklMkMlMEElMjAlMjAlMjAlMjBtb2RlJTNETm9uZSUyMCUyMCUyMyUyMEZvciUyMHRyYWluaW5nJTBBKQ==",highlighted:`config = GymManipulatorConfig(
    env=HILSerlRobotEnvConfig(
        processor=HILSerlProcessorConfig(
            reward_classifier=RewardClassifierConfig(
                pretrained_path=<span class="hljs-string">&quot;path_to_your_pretrained_trained_model&quot;</span>
            )
        ),
        <span class="hljs-comment"># Other environment parameters</span>
    ),
    dataset=DatasetConfig(...),
    mode=<span class="hljs-literal">None</span>  <span class="hljs-comment"># For training</span>
)`,wrap:!1}}),al=new h({props:{code:"JTdCJTBBJTIwJTIwJTIyZW52JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvY2Vzc29yJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycmV3YXJkX2NsYXNzaWZpZXIlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwcmV0cmFpbmVkX3BhdGglMjIlM0ElMjAlMjJwYXRoX3RvX3lvdXJfcHJldHJhaW5lZF9tb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN1Y2Nlc3NfdGhyZXNob2xkJTIyJTNBJTIwMC43JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3VjY2Vzc19yZXdhcmQlMjIlM0ElMjAxLjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJyZXNldCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRlcm1pbmF0ZV9vbl9zdWNjZXNzJTIyJTNBJTIwdHJ1ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;processor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;reward_classifier&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;pretrained_path&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;path_to_your_pretrained_model&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;success_threshold&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.7</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;success_reward&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1.0</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;reset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;terminate_on_success&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),il=new h({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnJsLmd5bV9tYW5pcHVsYXRvciUyMC0tY29uZmlnX3BhdGglMjBwYXRoJTJGdG8lMkZlbnZfY29uZmlnLmpzb24=",highlighted:"python -m lerobot.rl.gym_manipulator --config_path path/to/env_config.json",wrap:!1}}),Ml=new h({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnJsLmd5bV9tYW5pcHVsYXRvciUyMC0tY29uZmlnX3BhdGglMjBzcmMlMkZsZXJvYm90JTJGY29uZmlncyUyRmVudl9jb25maWcuanNvbg==",highlighted:"python -m lerobot.rl.gym_manipulator --config_path src/lerobot/configs/env_config.json",wrap:!1}}),jl=new h({props:{code:"bGVyb2JvdC10cmFpbiUyMC0tY29uZmlnX3BhdGglMjBzcmMlMkZsZXJvYm90JTJGY29uZmlncyUyRnJld2FyZF9jbGFzc2lmaWVyX3RyYWluX2NvbmZpZy5qc29u",highlighted:"lerobot-train --config_path src/lerobot/configs/reward_classifier_train_config.json",wrap:!1}}),hl=new h({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnJsLmd5bV9tYW5pcHVsYXRvciUyMC0tY29uZmlnX3BhdGglMjBzcmMlMkZsZXJvYm90JTJGY29uZmlncyUyRmVudl9jb25maWcuanNvbg==",highlighted:"python -m lerobot.rl.gym_manipulator --config_path src/lerobot/configs/env_config.json",wrap:!1}}),Tl=new T({props:{title:"Training with Actor-Learner",local:"training-with-actor-learner",headingTag:"h3"}}),fl=new h({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnJsLmxlYXJuZXIlMjAtLWNvbmZpZ19wYXRoJTIwc3JjJTJGbGVyb2JvdCUyRmNvbmZpZ3MlMkZ0cmFpbl9jb25maWdfaGlsc2VybF9zbzEwMC5qc29u",highlighted:"python -m lerobot.rl.learner --config_path src/lerobot/configs/train_config_hilserl_so100.json",wrap:!1}}),Al=new h({props:{code:"cHl0aG9uJTIwLW0lMjBsZXJvYm90LnJsLmFjdG9yJTIwLS1jb25maWdfcGF0aCUyMHNyYyUyRmxlcm9ib3QlMkZjb25maWdzJTJGdHJhaW5fY29uZmlnX2hpbHNlcmxfc28xMDAuanNvbg==",highlighted:"python -m lerobot.rl.actor --config_path src/lerobot/configs/train_config_hilserl_so100.json",wrap:!1}}),Ll=new T({props:{title:"Guide to Human Interventions",local:"guide-to-human-interventions",headingTag:"h3"}}),Wl=new T({props:{title:"Key hyperparameters to tune",local:"key-hyperparameters-to-tune",headingTag:"h3"}}),Yl=new h({props:{code:"JTQwYXJ0aWNsZSU3Qmx1bzIwMjRwcmVjaXNlJTJDJTBBJTIwJTIwdGl0bGUlM0QlN0JQcmVjaXNlJTIwYW5kJTIwRGV4dGVyb3VzJTIwUm9ib3RpYyUyME1hbmlwdWxhdGlvbiUyMHZpYSUyMEh1bWFuLWluLXRoZS1Mb29wJTIwUmVpbmZvcmNlbWVudCUyMExlYXJuaW5nJTdEJTJDJTBBJTIwJTIwYXV0aG9yJTNEJTdCTHVvJTJDJTIwSmlhbmxhbiUyMGFuZCUyMFh1JTJDJTIwQ2hhcmxlcyUyMGFuZCUyMFd1JTJDJTIwSmVmZnJleSUyMGFuZCUyMExldmluZSUyQyUyMFNlcmdleSU3RCUyQyUwQSUyMCUyMGpvdXJuYWwlM0QlN0JhclhpdiUyMHByZXByaW50JTIwYXJYaXYlM0EyNDEwLjIxODQ1JTdEJTJDJTBBJTIwJTIweWVhciUzRCU3QjIwMjQlN0QlMEElN0Q=",highlighted:`@article{luo2024precise,
  title={Precise <span class="hljs-keyword">and </span>Dexterous Robotic Manipulation via Human-in-the-Loop Reinforcement Learning},
  author={Luo, <span class="hljs-keyword">Jianlan </span><span class="hljs-keyword">and </span>Xu, Charles <span class="hljs-keyword">and </span>Wu, <span class="hljs-keyword">Jeffrey </span><span class="hljs-keyword">and </span>Levine, Sergey},
  <span class="hljs-keyword">journal={arXiv </span>preprint arXiv:<span class="hljs-number">2410</span>.<span class="hljs-number">21845</span>},
  year={<span class="hljs-number">2024</span>}
}`,wrap:!1}}),Fl=new Ac({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/hilserl.mdx"}}),{c(){U=p("meta"),pn=e(),en=p("p"),on=e(),c(q.$$.fragment),cn=e(),c(x.$$.fragment),rn=e(),Q=p("p"),Q.textContent=Xp,Mn=e(),k=p("p"),k.textContent=zp,un=e(),L=p("p"),L.textContent=Vp,jn=e(),H=p("ol"),H.innerHTML=Yp,yn=e(),R=p("p"),R.textContent=Fp,hn=e(),I=p("p"),I.innerHTML=Pp,Tn=e(),f=p("p"),f.innerHTML=Dp,Jn=e(),S=p("p"),S.textContent=Op,mn=e(),c(W.$$.fragment),wn=e(),G=p("ul"),G.innerHTML=Kp,dn=e(),c(X.$$.fragment),Un=e(),z=p("p"),z.textContent=si,In=e(),V=p("ul"),V.innerHTML=ti,fn=e(),c(Y.$$.fragment),Cn=e(),F=p("p"),F.innerHTML=li,bn=e(),c(P.$$.fragment),gn=e(),c(D.$$.fragment),vn=e(),c(O.$$.fragment),An=e(),K=p("p"),K.innerHTML=ni,Bn=e(),c(ss.$$.fragment),_n=e(),c(ts.$$.fragment),Zn=e(),ls=p("p"),ls.textContent=ei,En=e(),c(ns.$$.fragment),$n=e(),es=p("p"),es.innerHTML=ai,Nn=e(),as=p("ol"),as.innerHTML=pi,qn=e(),c(ps.$$.fragment),xn=e(),is=p("p"),is.innerHTML=ii,Qn=e(),os=p("ol"),os.innerHTML=oi,kn=e(),c(cs.$$.fragment),Ln=e(),rs=p("p"),rs.innerHTML=ci,Hn=e(),c(Ms.$$.fragment),Rn=e(),us=p("p"),us.innerHTML=ri,Sn=e(),c(js.$$.fragment),Wn=e(),ys=p("p"),ys.innerHTML=Mi,Gn=e(),c(hs.$$.fragment),Xn=e(),c(Ts.$$.fragment),zn=e(),Js=p("p"),Js.textContent=ui,Vn=e(),c(ms.$$.fragment),Yn=e(),ws=p("p"),ws.textContent=ji,Fn=e(),c(ds.$$.fragment),Pn=e(),Us=p("p"),Us.textContent=yi,Dn=e(),Is=p("ul"),Is.innerHTML=hi,On=e(),c(fs.$$.fragment),Kn=e(),Cs=p("p"),Cs.textContent=Ti,se=e(),c(bs.$$.fragment),te=e(),gs=p("p"),gs.textContent=Ji,le=e(),vs=p("ul"),vs.innerHTML=mi,ne=e(),c(As.$$.fragment),ee=e(),Bs=p("p"),Bs.textContent=wi,ae=e(),c(_s.$$.fragment),pe=e(),Zs=p("p"),Zs.innerHTML=di,ie=e(),c(Es.$$.fragment),oe=e(),$s=p("p"),$s.textContent=Ui,ce=e(),Ns=p("p"),Ns.textContent=Ii,re=e(),qs=p("p"),qs.innerHTML=fi,Me=e(),xs=p("p"),xs.textContent=Ci,ue=e(),c(Qs.$$.fragment),je=e(),ks=p("p"),ks.innerHTML=bi,ye=e(),d=p("ol"),Pl=p("li"),Pl.textContent=gi,Np=e(),Dl=p("li"),qp=Cc(`The script will record the minimum and maximum end-effector positions and the joint angles and prints them to the console, for example:
	`),c(Ls.$$.fragment),xp=e(),Ol=p("li"),Ol.innerHTML=vi,he=e(),Hs=p("p"),Hs.innerHTML=Ai,Te=e(),c(Rs.$$.fragment),Je=e(),c(Ss.$$.fragment),me=e(),Ws=p("p"),Ws.textContent=Bi,we=e(),Gs=p("p"),Gs.innerHTML=_i,de=e(),Xs=p("p"),Xs.innerHTML=Zi,Ue=e(),zs=p("ol"),zs.innerHTML=Ei,Ie=e(),Vs=p("p"),Vs.textContent=$i,fe=e(),c(Ys.$$.fragment),Ce=e(),c(Fs.$$.fragment),be=e(),Ps=p("p"),Ps.textContent=Ni,ge=e(),Ds=p("p"),Ds.textContent=qi,ve=e(),Os=p("p"),Os.innerHTML=xi,Ae=e(),c(Ks.$$.fragment),Be=e(),st=p("p"),st.innerHTML=Qi,_e=e(),tt=p("p"),tt.innerHTML=ki,Ze=e(),lt=p("p"),lt.textContent=Li,Ee=e(),nt=p("p"),nt.innerHTML=Hi,$e=e(),c(et.$$.fragment),Ne=e(),C=p("p"),C.innerHTML=Ri,qe=e(),b=p("p"),b.innerHTML=Si,xe=e(),at=p("p"),at.innerHTML=Wi,Qe=e(),pt=p("p"),pt.textContent=Gi,ke=e(),it=p("p"),it.innerHTML=Xi,Le=e(),c(ot.$$.fragment),He=e(),ct=p("p"),ct.innerHTML=zi,Re=e(),rt=p("details"),rt.innerHTML=Vi,Se=e(),Mt=p("p"),Mt.innerHTML=Yi,We=e(),ut=p("p"),ut.innerHTML=Fi,Ge=e(),c(jt.$$.fragment),Xe=e(),yt=p("p"),yt.textContent=Pi,ze=e(),ht=p("ol"),ht.innerHTML=Di,Ve=e(),c(Tt.$$.fragment),Ye=e(),Jt=p("p"),Jt.textContent=Oi,Fe=e(),mt=p("p"),mt.textContent=Ki,Pe=e(),wt=p("ul"),wt.innerHTML=so,De=e(),dt=p("p"),dt.innerHTML=to,Oe=e(),Ut=p("p"),Ut.innerHTML=lo,Ke=e(),It=p("p"),It.innerHTML=no,sa=e(),c(ft.$$.fragment),ta=e(),Ct=p("ol"),Ct.innerHTML=eo,la=e(),bt=p("p"),bt.textContent=ao,na=e(),c(gt.$$.fragment),ea=e(),g=p("p"),g.innerHTML=po,aa=e(),v=p("p"),v.innerHTML=io,pa=e(),vt=p("p"),vt.innerHTML=oo,ia=e(),At=p("p"),At.textContent=co,oa=e(),c(Bt.$$.fragment),ca=e(),_t=p("p"),_t.innerHTML=ro,ra=e(),Zt=p("p"),Zt.innerHTML=Mo,Ma=e(),c(Et.$$.fragment),ua=e(),$t=p("p"),$t.textContent=uo,ja=e(),Nt=p("p"),Nt.textContent=jo,ya=e(),qt=p("p"),qt.innerHTML=yo,ha=e(),xt=p("p"),xt.innerHTML=ho,Ta=e(),Qt=p("p"),Qt.innerHTML=To,Ja=e(),kt=p("p"),kt.innerHTML=Jo,ma=e(),Lt=p("p"),Lt.textContent=mo,wa=e(),c(Ht.$$.fragment),da=e(),Rt=p("p"),Rt.innerHTML=wo,Ua=e(),St=p("ul"),St.innerHTML=Uo,Ia=e(),Wt=p("p"),Wt.innerHTML=Io,fa=e(),Gt=p("p"),Gt.innerHTML=fo,Ca=e(),Xt=p("p"),Xt.textContent=Co,ba=e(),c(zt.$$.fragment),ga=e(),Vt=p("p"),Vt.innerHTML=bo,va=e(),Yt=p("p"),Yt.innerHTML=go,Aa=e(),Ft=p("ul"),Ft.innerHTML=vo,Ba=e(),Pt=p("p"),Pt.innerHTML=Ao,_a=e(),c(Dt.$$.fragment),Za=e(),Ot=p("p"),Ot.innerHTML=Bo,Ea=e(),Kt=p("p"),Kt.innerHTML=_o,$a=e(),c(sl.$$.fragment),Na=e(),tl=p("p"),tl.innerHTML=Zo,qa=e(),ll=p("p"),ll.innerHTML=Eo,xa=e(),c(nl.$$.fragment),Qa=e(),el=p("p"),el.textContent=$o,ka=e(),c(al.$$.fragment),La=e(),pl=p("p"),pl.innerHTML=No,Ha=e(),c(il.$$.fragment),Ra=e(),ol=p("p"),ol.textContent=qo,Sa=e(),cl=p("p"),cl.innerHTML=xo,Wa=e(),w=p("ol"),Kl=p("li"),Kl.innerHTML=Qo,Qp=e(),rl=p("li"),sn=p("p"),sn.innerHTML=ko,kp=e(),c(Ml.$$.fragment),Lp=e(),ul=p("li"),tn=p("p"),tn.innerHTML=Lo,Hp=e(),c(jl.$$.fragment),Rp=e(),yl=p("li"),ln=p("p"),ln.innerHTML=Ho,Sp=e(),c(hl.$$.fragment),Ga=e(),c(Tl.$$.fragment),Xa=e(),Jl=p("p"),Jl.textContent=Ro,za=e(),ml=p("p"),ml.innerHTML=So,Va=e(),wl=p("p"),wl.innerHTML=Wo,Ya=e(),dl=p("ol"),dl.innerHTML=Go,Fa=e(),Ul=p("p"),Ul.innerHTML=Xo,Pa=e(),Il=p("p"),Il.textContent=zo,Da=e(),c(fl.$$.fragment),Oa=e(),Cl=p("p"),Cl.textContent=Vo,Ka=e(),bl=p("ul"),bl.innerHTML=Yo,sp=e(),gl=p("p"),gl.innerHTML=Fo,tp=e(),vl=p("p"),vl.textContent=Po,lp=e(),c(Al.$$.fragment),np=e(),Bl=p("p"),Bl.textContent=Do,ep=e(),_l=p("ul"),_l.innerHTML=Oo,ap=e(),Zl=p("p"),Zl.innerHTML=Ko,pp=e(),El=p("p"),El.textContent=sc,ip=e(),$l=p("ol"),$l.innerHTML=tc,op=e(),Nl=p("p"),Nl.innerHTML=lc,cp=e(),ql=p("ul"),ql.innerHTML=nc,rp=e(),A=p("p"),A.innerHTML=ec,Mp=e(),B=p("p"),B.innerHTML=ac,up=e(),xl=p("ul"),xl.innerHTML=pc,jp=e(),Ql=p("p"),Ql.innerHTML=ic,yp=e(),kl=p("p"),kl.innerHTML=oc,hp=e(),c(Ll.$$.fragment),Tp=e(),Hl=p("p"),Hl.textContent=cc,Jp=e(),Rl=p("ul"),Rl.innerHTML=rc,mp=e(),Sl=p("p"),Sl.textContent=Mc,wp=e(),_=p("p"),_.innerHTML=uc,dp=e(),Z=p("p"),Z.innerHTML=jc,Up=e(),c(Wl.$$.fragment),Ip=e(),Gl=p("p"),Gl.textContent=yc,fp=e(),Xl=p("ul"),Xl.innerHTML=hc,Cp=e(),zl=p("p"),zl.textContent=Tc,bp=e(),E=p("blockquote"),E.innerHTML=Jc,gp=e(),Vl=p("p"),Vl.textContent=mc,vp=e(),c(Yl.$$.fragment),Ap=e(),c(Fl.$$.fragment),Bp=e(),an=p("p"),this.h()},l(s){const t=bc("svelte-u9bgzb",document.head);U=i(t,"META",{name:!0,content:!0}),t.forEach(l),pn=a(s),en=i(s,"P",{}),N(en).forEach(l),on=a(s),r(q.$$.fragment,s),cn=a(s),r(x.$$.fragment,s),rn=a(s),Q=i(s,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-tip1wc"&&(Q.textContent=Xp),Mn=a(s),k=i(s,"P",{"data-svelte-h":!0}),o(k)!=="svelte-85x4lc"&&(k.textContent=zp),un=a(s),L=i(s,"P",{"data-svelte-h":!0}),o(L)!=="svelte-orvej0"&&(L.textContent=Vp),jn=a(s),H=i(s,"OL",{"data-svelte-h":!0}),o(H)!=="svelte-1x8sf4s"&&(H.innerHTML=Yp),yn=a(s),R=i(s,"P",{"data-svelte-h":!0}),o(R)!=="svelte-6ttl9o"&&(R.textContent=Fp),hn=a(s),I=i(s,"P",{align:!0,"data-svelte-h":!0}),o(I)!=="svelte-2ozfa6"&&(I.innerHTML=Pp),Tn=a(s),f=i(s,"P",{align:!0,"data-svelte-h":!0}),o(f)!=="svelte-agh7op"&&(f.innerHTML=Dp),Jn=a(s),S=i(s,"P",{"data-svelte-h":!0}),o(S)!=="svelte-kh48rx"&&(S.textContent=Op),mn=a(s),r(W.$$.fragment,s),wn=a(s),G=i(s,"UL",{"data-svelte-h":!0}),o(G)!=="svelte-st8mkn"&&(G.innerHTML=Kp),dn=a(s),r(X.$$.fragment,s),Un=a(s),z=i(s,"P",{"data-svelte-h":!0}),o(z)!=="svelte-12wjggm"&&(z.textContent=si),In=a(s),V=i(s,"UL",{"data-svelte-h":!0}),o(V)!=="svelte-1xew5vn"&&(V.innerHTML=ti),fn=a(s),r(Y.$$.fragment,s),Cn=a(s),F=i(s,"P",{"data-svelte-h":!0}),o(F)!=="svelte-punxaj"&&(F.innerHTML=li),bn=a(s),r(P.$$.fragment,s),gn=a(s),r(D.$$.fragment,s),vn=a(s),r(O.$$.fragment,s),An=a(s),K=i(s,"P",{"data-svelte-h":!0}),o(K)!=="svelte-cdivzo"&&(K.innerHTML=ni),Bn=a(s),r(ss.$$.fragment,s),_n=a(s),r(ts.$$.fragment,s),Zn=a(s),ls=i(s,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-t3kexy"&&(ls.textContent=ei),En=a(s),r(ns.$$.fragment,s),$n=a(s),es=i(s,"P",{"data-svelte-h":!0}),o(es)!=="svelte-12gy7f5"&&(es.innerHTML=ai),Nn=a(s),as=i(s,"OL",{"data-svelte-h":!0}),o(as)!=="svelte-1gpq231"&&(as.innerHTML=pi),qn=a(s),r(ps.$$.fragment,s),xn=a(s),is=i(s,"P",{"data-svelte-h":!0}),o(is)!=="svelte-1asy0ii"&&(is.innerHTML=ii),Qn=a(s),os=i(s,"OL",{"data-svelte-h":!0}),o(os)!=="svelte-14o3ek8"&&(os.innerHTML=oi),kn=a(s),r(cs.$$.fragment,s),Ln=a(s),rs=i(s,"P",{"data-svelte-h":!0}),o(rs)!=="svelte-knexnm"&&(rs.innerHTML=ci),Hn=a(s),r(Ms.$$.fragment,s),Rn=a(s),us=i(s,"P",{"data-svelte-h":!0}),o(us)!=="svelte-wdd8kr"&&(us.innerHTML=ri),Sn=a(s),r(js.$$.fragment,s),Wn=a(s),ys=i(s,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-c3vsy6"&&(ys.innerHTML=Mi),Gn=a(s),r(hs.$$.fragment,s),Xn=a(s),r(Ts.$$.fragment,s),zn=a(s),Js=i(s,"P",{"data-svelte-h":!0}),o(Js)!=="svelte-gdmfb"&&(Js.textContent=ui),Vn=a(s),r(ms.$$.fragment,s),Yn=a(s),ws=i(s,"P",{"data-svelte-h":!0}),o(ws)!=="svelte-14792dc"&&(ws.textContent=ji),Fn=a(s),r(ds.$$.fragment,s),Pn=a(s),Us=i(s,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-8sqcpy"&&(Us.textContent=yi),Dn=a(s),Is=i(s,"UL",{"data-svelte-h":!0}),o(Is)!=="svelte-s07ppm"&&(Is.innerHTML=hi),On=a(s),r(fs.$$.fragment,s),Kn=a(s),Cs=i(s,"P",{"data-svelte-h":!0}),o(Cs)!=="svelte-1p9befs"&&(Cs.textContent=Ti),se=a(s),r(bs.$$.fragment,s),te=a(s),gs=i(s,"P",{"data-svelte-h":!0}),o(gs)!=="svelte-8sqcpy"&&(gs.textContent=Ji),le=a(s),vs=i(s,"UL",{"data-svelte-h":!0}),o(vs)!=="svelte-1t8tsrc"&&(vs.innerHTML=mi),ne=a(s),r(As.$$.fragment,s),ee=a(s),Bs=i(s,"P",{"data-svelte-h":!0}),o(Bs)!=="svelte-1mm601g"&&(Bs.textContent=wi),ae=a(s),r(_s.$$.fragment,s),pe=a(s),Zs=i(s,"P",{"data-svelte-h":!0}),o(Zs)!=="svelte-1mkidii"&&(Zs.innerHTML=di),ie=a(s),r(Es.$$.fragment,s),oe=a(s),$s=i(s,"P",{"data-svelte-h":!0}),o($s)!=="svelte-qhx7nb"&&($s.textContent=Ui),ce=a(s),Ns=i(s,"P",{"data-svelte-h":!0}),o(Ns)!=="svelte-13zpkl7"&&(Ns.textContent=Ii),re=a(s),qs=i(s,"P",{"data-svelte-h":!0}),o(qs)!=="svelte-13scwos"&&(qs.innerHTML=fi),Me=a(s),xs=i(s,"P",{"data-svelte-h":!0}),o(xs)!=="svelte-12g0x8n"&&(xs.textContent=Ci),ue=a(s),r(Qs.$$.fragment,s),je=a(s),ks=i(s,"P",{"data-svelte-h":!0}),o(ks)!=="svelte-133252y"&&(ks.innerHTML=bi),ye=a(s),d=i(s,"OL",{});var nn=N(d);Pl=i(nn,"LI",{"data-svelte-h":!0}),o(Pl)!=="svelte-jwhws7"&&(Pl.textContent=gi),Np=a(nn),Dl=i(nn,"LI",{});var Wp=N(Dl);qp=gc(Wp,`The script will record the minimum and maximum end-effector positions and the joint angles and prints them to the console, for example:
	`),r(Ls.$$.fragment,Wp),Wp.forEach(l),xp=a(nn),Ol=i(nn,"LI",{"data-svelte-h":!0}),o(Ol)!=="svelte-1o9aezs"&&(Ol.innerHTML=vi),nn.forEach(l),he=a(s),Hs=i(s,"P",{"data-svelte-h":!0}),o(Hs)!=="svelte-9e4z7l"&&(Hs.innerHTML=Ai),Te=a(s),r(Rs.$$.fragment,s),Je=a(s),r(Ss.$$.fragment,s),me=a(s),Ws=i(s,"P",{"data-svelte-h":!0}),o(Ws)!=="svelte-1xayq1k"&&(Ws.textContent=Bi),we=a(s),Gs=i(s,"P",{"data-svelte-h":!0}),o(Gs)!=="svelte-1b1oyiu"&&(Gs.innerHTML=_i),de=a(s),Xs=i(s,"P",{"data-svelte-h":!0}),o(Xs)!=="svelte-4pvw4m"&&(Xs.innerHTML=Zi),Ue=a(s),zs=i(s,"OL",{"data-svelte-h":!0}),o(zs)!=="svelte-hmmy75"&&(zs.innerHTML=Ei),Ie=a(s),Vs=i(s,"P",{"data-svelte-h":!0}),o(Vs)!=="svelte-gur1fh"&&(Vs.textContent=$i),fe=a(s),r(Ys.$$.fragment,s),Ce=a(s),r(Fs.$$.fragment,s),be=a(s),Ps=i(s,"P",{"data-svelte-h":!0}),o(Ps)!=="svelte-1k55eio"&&(Ps.textContent=Ni),ge=a(s),Ds=i(s,"P",{"data-svelte-h":!0}),o(Ds)!=="svelte-1gu8vct"&&(Ds.textContent=qi),ve=a(s),Os=i(s,"P",{"data-svelte-h":!0}),o(Os)!=="svelte-lkgt27"&&(Os.innerHTML=xi),Ae=a(s),r(Ks.$$.fragment,s),Be=a(s),st=i(s,"P",{"data-svelte-h":!0}),o(st)!=="svelte-12kabho"&&(st.innerHTML=Qi),_e=a(s),tt=i(s,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-123qamy"&&(tt.innerHTML=ki),Ze=a(s),lt=i(s,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-q27m3q"&&(lt.textContent=Li),Ee=a(s),nt=i(s,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-1458spy"&&(nt.innerHTML=Hi),$e=a(s),r(et.$$.fragment,s),Ne=a(s),C=i(s,"P",{align:!0,"data-svelte-h":!0}),o(C)!=="svelte-l7xw97"&&(C.innerHTML=Ri),qe=a(s),b=i(s,"P",{align:!0,"data-svelte-h":!0}),o(b)!=="svelte-i8xgvo"&&(b.innerHTML=Si),xe=a(s),at=i(s,"P",{"data-svelte-h":!0}),o(at)!=="svelte-17w4vys"&&(at.innerHTML=Wi),Qe=a(s),pt=i(s,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-1n513na"&&(pt.textContent=Gi),ke=a(s),it=i(s,"P",{"data-svelte-h":!0}),o(it)!=="svelte-fnzfno"&&(it.innerHTML=Xi),Le=a(s),r(ot.$$.fragment,s),He=a(s),ct=i(s,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-u9lwpw"&&(ct.innerHTML=zi),Re=a(s),rt=i(s,"DETAILS",{"data-svelte-h":!0}),o(rt)!=="svelte-1raqgp9"&&(rt.innerHTML=Vi),Se=a(s),Mt=i(s,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-1lumdn2"&&(Mt.innerHTML=Yi),We=a(s),ut=i(s,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-303oat"&&(ut.innerHTML=Fi),Ge=a(s),r(jt.$$.fragment,s),Xe=a(s),yt=i(s,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-1e9jl8o"&&(yt.textContent=Pi),ze=a(s),ht=i(s,"OL",{"data-svelte-h":!0}),o(ht)!=="svelte-an135w"&&(ht.innerHTML=Di),Ve=a(s),r(Tt.$$.fragment,s),Ye=a(s),Jt=i(s,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-1muq6i8"&&(Jt.textContent=Oi),Fe=a(s),mt=i(s,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-1q8tlhb"&&(mt.textContent=Ki),Pe=a(s),wt=i(s,"UL",{"data-svelte-h":!0}),o(wt)!=="svelte-b0vrwx"&&(wt.innerHTML=so),De=a(s),dt=i(s,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-tevvdp"&&(dt.innerHTML=to),Oe=a(s),Ut=i(s,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-98970x"&&(Ut.innerHTML=lo),Ke=a(s),It=i(s,"P",{"data-svelte-h":!0}),o(It)!=="svelte-1eej4ha"&&(It.innerHTML=no),sa=a(s),r(ft.$$.fragment,s),ta=a(s),Ct=i(s,"OL",{"data-svelte-h":!0}),o(Ct)!=="svelte-xydyib"&&(Ct.innerHTML=eo),la=a(s),bt=i(s,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-c9hbnf"&&(bt.textContent=ao),na=a(s),r(gt.$$.fragment,s),ea=a(s),g=i(s,"P",{align:!0,"data-svelte-h":!0}),o(g)!=="svelte-1kgsj1n"&&(g.innerHTML=po),aa=a(s),v=i(s,"P",{align:!0,"data-svelte-h":!0}),o(v)!=="svelte-m2u5tt"&&(v.innerHTML=io),pa=a(s),vt=i(s,"P",{"data-svelte-h":!0}),o(vt)!=="svelte-1fvonll"&&(vt.innerHTML=oo),ia=a(s),At=i(s,"P",{"data-svelte-h":!0}),o(At)!=="svelte-1u063o4"&&(At.textContent=co),oa=a(s),r(Bt.$$.fragment,s),ca=a(s),_t=i(s,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-gm91yt"&&(_t.innerHTML=ro),ra=a(s),Zt=i(s,"P",{"data-svelte-h":!0}),o(Zt)!=="svelte-1xu368l"&&(Zt.innerHTML=Mo),Ma=a(s),r(Et.$$.fragment,s),ua=a(s),$t=i(s,"P",{"data-svelte-h":!0}),o($t)!=="svelte-1s4360z"&&($t.textContent=uo),ja=a(s),Nt=i(s,"P",{"data-svelte-h":!0}),o(Nt)!=="svelte-1gn06z5"&&(Nt.textContent=jo),ya=a(s),qt=i(s,"P",{"data-svelte-h":!0}),o(qt)!=="svelte-a5qxyo"&&(qt.innerHTML=yo),ha=a(s),xt=i(s,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-d4pith"&&(xt.innerHTML=ho),Ta=a(s),Qt=i(s,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-1v0tk6u"&&(Qt.innerHTML=To),Ja=a(s),kt=i(s,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-972ybh"&&(kt.innerHTML=Jo),ma=a(s),Lt=i(s,"P",{"data-svelte-h":!0}),o(Lt)!=="svelte-1najbyj"&&(Lt.textContent=mo),wa=a(s),r(Ht.$$.fragment,s),da=a(s),Rt=i(s,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-6lst9n"&&(Rt.innerHTML=wo),Ua=a(s),St=i(s,"UL",{"data-svelte-h":!0}),o(St)!=="svelte-699qds"&&(St.innerHTML=Uo),Ia=a(s),Wt=i(s,"P",{"data-svelte-h":!0}),o(Wt)!=="svelte-17ktvqg"&&(Wt.innerHTML=Io),fa=a(s),Gt=i(s,"P",{"data-svelte-h":!0}),o(Gt)!=="svelte-1817pj8"&&(Gt.innerHTML=fo),Ca=a(s),Xt=i(s,"P",{"data-svelte-h":!0}),o(Xt)!=="svelte-17ipf62"&&(Xt.textContent=Co),ba=a(s),r(zt.$$.fragment,s),ga=a(s),Vt=i(s,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-1g8qm4r"&&(Vt.innerHTML=bo),va=a(s),Yt=i(s,"P",{"data-svelte-h":!0}),o(Yt)!=="svelte-1k00g85"&&(Yt.innerHTML=go),Aa=a(s),Ft=i(s,"UL",{"data-svelte-h":!0}),o(Ft)!=="svelte-299w4m"&&(Ft.innerHTML=vo),Ba=a(s),Pt=i(s,"P",{"data-svelte-h":!0}),o(Pt)!=="svelte-164cgkl"&&(Pt.innerHTML=Ao),_a=a(s),r(Dt.$$.fragment,s),Za=a(s),Ot=i(s,"P",{"data-svelte-h":!0}),o(Ot)!=="svelte-gncodb"&&(Ot.innerHTML=Bo),Ea=a(s),Kt=i(s,"P",{"data-svelte-h":!0}),o(Kt)!=="svelte-1i92i25"&&(Kt.innerHTML=_o),$a=a(s),r(sl.$$.fragment,s),Na=a(s),tl=i(s,"P",{"data-svelte-h":!0}),o(tl)!=="svelte-t7wvp3"&&(tl.innerHTML=Zo),qa=a(s),ll=i(s,"P",{"data-svelte-h":!0}),o(ll)!=="svelte-1373v1s"&&(ll.innerHTML=Eo),xa=a(s),r(nl.$$.fragment,s),Qa=a(s),el=i(s,"P",{"data-svelte-h":!0}),o(el)!=="svelte-1dg5zv5"&&(el.textContent=$o),ka=a(s),r(al.$$.fragment,s),La=a(s),pl=i(s,"P",{"data-svelte-h":!0}),o(pl)!=="svelte-ufcypw"&&(pl.innerHTML=No),Ha=a(s),r(il.$$.fragment,s),Ra=a(s),ol=i(s,"P",{"data-svelte-h":!0}),o(ol)!=="svelte-kwp5x9"&&(ol.textContent=qo),Sa=a(s),cl=i(s,"P",{"data-svelte-h":!0}),o(cl)!=="svelte-164odnw"&&(cl.innerHTML=xo),Wa=a(s),w=i(s,"OL",{});var $=N(w);Kl=i($,"LI",{"data-svelte-h":!0}),o(Kl)!=="svelte-m0vvy1"&&(Kl.innerHTML=Qo),Qp=a($),rl=i($,"LI",{});var Zp=N(rl);sn=i(Zp,"P",{"data-svelte-h":!0}),o(sn)!=="svelte-uug10y"&&(sn.innerHTML=ko),kp=a(Zp),r(Ml.$$.fragment,Zp),Zp.forEach(l),Lp=a($),ul=i($,"LI",{});var Ep=N(ul);tn=i(Ep,"P",{"data-svelte-h":!0}),o(tn)!=="svelte-1bu8h49"&&(tn.innerHTML=Lo),Hp=a(Ep),r(jl.$$.fragment,Ep),Ep.forEach(l),Rp=a($),yl=i($,"LI",{});var $p=N(yl);ln=i($p,"P",{"data-svelte-h":!0}),o(ln)!=="svelte-9fejhf"&&(ln.innerHTML=Ho),Sp=a($p),r(hl.$$.fragment,$p),$p.forEach(l),$.forEach(l),Ga=a(s),r(Tl.$$.fragment,s),Xa=a(s),Jl=i(s,"P",{"data-svelte-h":!0}),o(Jl)!=="svelte-ielnui"&&(Jl.textContent=Ro),za=a(s),ml=i(s,"P",{"data-svelte-h":!0}),o(ml)!=="svelte-1nzvpp6"&&(ml.innerHTML=So),Va=a(s),wl=i(s,"P",{"data-svelte-h":!0}),o(wl)!=="svelte-1c7esbk"&&(wl.innerHTML=Wo),Ya=a(s),dl=i(s,"OL",{"data-svelte-h":!0}),o(dl)!=="svelte-46iinu"&&(dl.innerHTML=Go),Fa=a(s),Ul=i(s,"P",{"data-svelte-h":!0}),o(Ul)!=="svelte-a4qqfr"&&(Ul.innerHTML=Xo),Pa=a(s),Il=i(s,"P",{"data-svelte-h":!0}),o(Il)!=="svelte-3hlmw"&&(Il.textContent=zo),Da=a(s),r(fl.$$.fragment,s),Oa=a(s),Cl=i(s,"P",{"data-svelte-h":!0}),o(Cl)!=="svelte-1j61g44"&&(Cl.textContent=Vo),Ka=a(s),bl=i(s,"UL",{"data-svelte-h":!0}),o(bl)!=="svelte-1a6gefp"&&(bl.innerHTML=Yo),sp=a(s),gl=i(s,"P",{"data-svelte-h":!0}),o(gl)!=="svelte-mqduir"&&(gl.innerHTML=Fo),tp=a(s),vl=i(s,"P",{"data-svelte-h":!0}),o(vl)!=="svelte-1fri2t1"&&(vl.textContent=Po),lp=a(s),r(Al.$$.fragment,s),np=a(s),Bl=i(s,"P",{"data-svelte-h":!0}),o(Bl)!=="svelte-1pg0b4o"&&(Bl.textContent=Do),ep=a(s),_l=i(s,"UL",{"data-svelte-h":!0}),o(_l)!=="svelte-1a3rfwc"&&(_l.innerHTML=Oo),ap=a(s),Zl=i(s,"P",{"data-svelte-h":!0}),o(Zl)!=="svelte-1gfkg27"&&(Zl.innerHTML=Ko),pp=a(s),El=i(s,"P",{"data-svelte-h":!0}),o(El)!=="svelte-16xa10t"&&(El.textContent=sc),ip=a(s),$l=i(s,"OL",{"data-svelte-h":!0}),o($l)!=="svelte-xvk7zd"&&($l.innerHTML=tc),op=a(s),Nl=i(s,"P",{"data-svelte-h":!0}),o(Nl)!=="svelte-1t6xdcm"&&(Nl.innerHTML=lc),cp=a(s),ql=i(s,"UL",{"data-svelte-h":!0}),o(ql)!=="svelte-1lrs7nq"&&(ql.innerHTML=nc),rp=a(s),A=i(s,"P",{align:!0,"data-svelte-h":!0}),o(A)!=="svelte-gebtxy"&&(A.innerHTML=ec),Mp=a(s),B=i(s,"P",{align:!0,"data-svelte-h":!0}),o(B)!=="svelte-1nilrco"&&(B.innerHTML=ac),up=a(s),xl=i(s,"UL",{"data-svelte-h":!0}),o(xl)!=="svelte-ya9pqf"&&(xl.innerHTML=pc),jp=a(s),Ql=i(s,"P",{"data-svelte-h":!0}),o(Ql)!=="svelte-5yw35g"&&(Ql.innerHTML=ic),yp=a(s),kl=i(s,"P",{"data-svelte-h":!0}),o(kl)!=="svelte-67cyg"&&(kl.innerHTML=oc),hp=a(s),r(Ll.$$.fragment,s),Tp=a(s),Hl=i(s,"P",{"data-svelte-h":!0}),o(Hl)!=="svelte-rqagvd"&&(Hl.textContent=cc),Jp=a(s),Rl=i(s,"UL",{"data-svelte-h":!0}),o(Rl)!=="svelte-sb7wdj"&&(Rl.innerHTML=rc),mp=a(s),Sl=i(s,"P",{"data-svelte-h":!0}),o(Sl)!=="svelte-1ezclbk"&&(Sl.textContent=Mc),wp=a(s),_=i(s,"P",{align:!0,"data-svelte-h":!0}),o(_)!=="svelte-mocte1"&&(_.innerHTML=uc),dp=a(s),Z=i(s,"P",{align:!0,"data-svelte-h":!0}),o(Z)!=="svelte-15kockq"&&(Z.innerHTML=jc),Up=a(s),r(Wl.$$.fragment,s),Ip=a(s),Gl=i(s,"P",{"data-svelte-h":!0}),o(Gl)!=="svelte-1h575sh"&&(Gl.textContent=yc),fp=a(s),Xl=i(s,"UL",{"data-svelte-h":!0}),o(Xl)!=="svelte-1t7hhz6"&&(Xl.innerHTML=hc),Cp=a(s),zl=i(s,"P",{"data-svelte-h":!0}),o(zl)!=="svelte-kg8fpw"&&(zl.textContent=Tc),bp=a(s),E=i(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(E)!=="svelte-so5vtc"&&(E.innerHTML=Jc),gp=a(s),Vl=i(s,"P",{"data-svelte-h":!0}),o(Vl)!=="svelte-k8021v"&&(Vl.textContent=mc),vp=a(s),r(Yl.$$.fragment,s),Ap=a(s),r(Fl.$$.fragment,s),Bp=a(s),an=i(s,"P",{}),N(an).forEach(l),this.h()},h(){m(U,"name","hf:doc:metadata"),m(U,"content",_c),m(I,"align","center"),m(f,"align","center"),m(C,"align","center"),m(b,"align","center"),m(g,"align","center"),m(v,"align","center"),m(A,"align","center"),m(B,"align","center"),m(_,"align","center"),m(Z,"align","center"),m(E,"class","tip")},m(s,t){J(document.head,U),n(s,pn,t),n(s,en,t),n(s,on,t),M(q,s,t),n(s,cn,t),M(x,s,t),n(s,rn,t),n(s,Q,t),n(s,Mn,t),n(s,k,t),n(s,un,t),n(s,L,t),n(s,jn,t),n(s,H,t),n(s,yn,t),n(s,R,t),n(s,hn,t),n(s,I,t),n(s,Tn,t),n(s,f,t),n(s,Jn,t),n(s,S,t),n(s,mn,t),M(W,s,t),n(s,wn,t),n(s,G,t),n(s,dn,t),M(X,s,t),n(s,Un,t),n(s,z,t),n(s,In,t),n(s,V,t),n(s,fn,t),M(Y,s,t),n(s,Cn,t),n(s,F,t),n(s,bn,t),M(P,s,t),n(s,gn,t),M(D,s,t),n(s,vn,t),M(O,s,t),n(s,An,t),n(s,K,t),n(s,Bn,t),M(ss,s,t),n(s,_n,t),M(ts,s,t),n(s,Zn,t),n(s,ls,t),n(s,En,t),M(ns,s,t),n(s,$n,t),n(s,es,t),n(s,Nn,t),n(s,as,t),n(s,qn,t),M(ps,s,t),n(s,xn,t),n(s,is,t),n(s,Qn,t),n(s,os,t),n(s,kn,t),M(cs,s,t),n(s,Ln,t),n(s,rs,t),n(s,Hn,t),M(Ms,s,t),n(s,Rn,t),n(s,us,t),n(s,Sn,t),M(js,s,t),n(s,Wn,t),n(s,ys,t),n(s,Gn,t),M(hs,s,t),n(s,Xn,t),M(Ts,s,t),n(s,zn,t),n(s,Js,t),n(s,Vn,t),M(ms,s,t),n(s,Yn,t),n(s,ws,t),n(s,Fn,t),M(ds,s,t),n(s,Pn,t),n(s,Us,t),n(s,Dn,t),n(s,Is,t),n(s,On,t),M(fs,s,t),n(s,Kn,t),n(s,Cs,t),n(s,se,t),M(bs,s,t),n(s,te,t),n(s,gs,t),n(s,le,t),n(s,vs,t),n(s,ne,t),M(As,s,t),n(s,ee,t),n(s,Bs,t),n(s,ae,t),M(_s,s,t),n(s,pe,t),n(s,Zs,t),n(s,ie,t),M(Es,s,t),n(s,oe,t),n(s,$s,t),n(s,ce,t),n(s,Ns,t),n(s,re,t),n(s,qs,t),n(s,Me,t),n(s,xs,t),n(s,ue,t),M(Qs,s,t),n(s,je,t),n(s,ks,t),n(s,ye,t),n(s,d,t),J(d,Pl),J(d,Np),J(d,Dl),J(Dl,qp),M(Ls,Dl,null),J(d,xp),J(d,Ol),n(s,he,t),n(s,Hs,t),n(s,Te,t),M(Rs,s,t),n(s,Je,t),M(Ss,s,t),n(s,me,t),n(s,Ws,t),n(s,we,t),n(s,Gs,t),n(s,de,t),n(s,Xs,t),n(s,Ue,t),n(s,zs,t),n(s,Ie,t),n(s,Vs,t),n(s,fe,t),M(Ys,s,t),n(s,Ce,t),M(Fs,s,t),n(s,be,t),n(s,Ps,t),n(s,ge,t),n(s,Ds,t),n(s,ve,t),n(s,Os,t),n(s,Ae,t),M(Ks,s,t),n(s,Be,t),n(s,st,t),n(s,_e,t),n(s,tt,t),n(s,Ze,t),n(s,lt,t),n(s,Ee,t),n(s,nt,t),n(s,$e,t),M(et,s,t),n(s,Ne,t),n(s,C,t),n(s,qe,t),n(s,b,t),n(s,xe,t),n(s,at,t),n(s,Qe,t),n(s,pt,t),n(s,ke,t),n(s,it,t),n(s,Le,t),M(ot,s,t),n(s,He,t),n(s,ct,t),n(s,Re,t),n(s,rt,t),n(s,Se,t),n(s,Mt,t),n(s,We,t),n(s,ut,t),n(s,Ge,t),M(jt,s,t),n(s,Xe,t),n(s,yt,t),n(s,ze,t),n(s,ht,t),n(s,Ve,t),M(Tt,s,t),n(s,Ye,t),n(s,Jt,t),n(s,Fe,t),n(s,mt,t),n(s,Pe,t),n(s,wt,t),n(s,De,t),n(s,dt,t),n(s,Oe,t),n(s,Ut,t),n(s,Ke,t),n(s,It,t),n(s,sa,t),M(ft,s,t),n(s,ta,t),n(s,Ct,t),n(s,la,t),n(s,bt,t),n(s,na,t),M(gt,s,t),n(s,ea,t),n(s,g,t),n(s,aa,t),n(s,v,t),n(s,pa,t),n(s,vt,t),n(s,ia,t),n(s,At,t),n(s,oa,t),M(Bt,s,t),n(s,ca,t),n(s,_t,t),n(s,ra,t),n(s,Zt,t),n(s,Ma,t),M(Et,s,t),n(s,ua,t),n(s,$t,t),n(s,ja,t),n(s,Nt,t),n(s,ya,t),n(s,qt,t),n(s,ha,t),n(s,xt,t),n(s,Ta,t),n(s,Qt,t),n(s,Ja,t),n(s,kt,t),n(s,ma,t),n(s,Lt,t),n(s,wa,t),M(Ht,s,t),n(s,da,t),n(s,Rt,t),n(s,Ua,t),n(s,St,t),n(s,Ia,t),n(s,Wt,t),n(s,fa,t),n(s,Gt,t),n(s,Ca,t),n(s,Xt,t),n(s,ba,t),M(zt,s,t),n(s,ga,t),n(s,Vt,t),n(s,va,t),n(s,Yt,t),n(s,Aa,t),n(s,Ft,t),n(s,Ba,t),n(s,Pt,t),n(s,_a,t),M(Dt,s,t),n(s,Za,t),n(s,Ot,t),n(s,Ea,t),n(s,Kt,t),n(s,$a,t),M(sl,s,t),n(s,Na,t),n(s,tl,t),n(s,qa,t),n(s,ll,t),n(s,xa,t),M(nl,s,t),n(s,Qa,t),n(s,el,t),n(s,ka,t),M(al,s,t),n(s,La,t),n(s,pl,t),n(s,Ha,t),M(il,s,t),n(s,Ra,t),n(s,ol,t),n(s,Sa,t),n(s,cl,t),n(s,Wa,t),n(s,w,t),J(w,Kl),J(w,Qp),J(w,rl),J(rl,sn),J(rl,kp),M(Ml,rl,null),J(w,Lp),J(w,ul),J(ul,tn),J(ul,Hp),M(jl,ul,null),J(w,Rp),J(w,yl),J(yl,ln),J(yl,Sp),M(hl,yl,null),n(s,Ga,t),M(Tl,s,t),n(s,Xa,t),n(s,Jl,t),n(s,za,t),n(s,ml,t),n(s,Va,t),n(s,wl,t),n(s,Ya,t),n(s,dl,t),n(s,Fa,t),n(s,Ul,t),n(s,Pa,t),n(s,Il,t),n(s,Da,t),M(fl,s,t),n(s,Oa,t),n(s,Cl,t),n(s,Ka,t),n(s,bl,t),n(s,sp,t),n(s,gl,t),n(s,tp,t),n(s,vl,t),n(s,lp,t),M(Al,s,t),n(s,np,t),n(s,Bl,t),n(s,ep,t),n(s,_l,t),n(s,ap,t),n(s,Zl,t),n(s,pp,t),n(s,El,t),n(s,ip,t),n(s,$l,t),n(s,op,t),n(s,Nl,t),n(s,cp,t),n(s,ql,t),n(s,rp,t),n(s,A,t),n(s,Mp,t),n(s,B,t),n(s,up,t),n(s,xl,t),n(s,jp,t),n(s,Ql,t),n(s,yp,t),n(s,kl,t),n(s,hp,t),M(Ll,s,t),n(s,Tp,t),n(s,Hl,t),n(s,Jp,t),n(s,Rl,t),n(s,mp,t),n(s,Sl,t),n(s,wp,t),n(s,_,t),n(s,dp,t),n(s,Z,t),n(s,Up,t),M(Wl,s,t),n(s,Ip,t),n(s,Gl,t),n(s,fp,t),n(s,Xl,t),n(s,Cp,t),n(s,zl,t),n(s,bp,t),n(s,E,t),n(s,gp,t),n(s,Vl,t),n(s,vp,t),M(Yl,s,t),n(s,Ap,t),M(Fl,s,t),n(s,Bp,t),n(s,an,t),_p=!0},p:dc,i(s){_p||(u(q.$$.fragment,s),u(x.$$.fragment,s),u(W.$$.fragment,s),u(X.$$.fragment,s),u(Y.$$.fragment,s),u(P.$$.fragment,s),u(D.$$.fragment,s),u(O.$$.fragment,s),u(ss.$$.fragment,s),u(ts.$$.fragment,s),u(ns.$$.fragment,s),u(ps.$$.fragment,s),u(cs.$$.fragment,s),u(Ms.$$.fragment,s),u(js.$$.fragment,s),u(hs.$$.fragment,s),u(Ts.$$.fragment,s),u(ms.$$.fragment,s),u(ds.$$.fragment,s),u(fs.$$.fragment,s),u(bs.$$.fragment,s),u(As.$$.fragment,s),u(_s.$$.fragment,s),u(Es.$$.fragment,s),u(Qs.$$.fragment,s),u(Ls.$$.fragment,s),u(Rs.$$.fragment,s),u(Ss.$$.fragment,s),u(Ys.$$.fragment,s),u(Fs.$$.fragment,s),u(Ks.$$.fragment,s),u(et.$$.fragment,s),u(ot.$$.fragment,s),u(jt.$$.fragment,s),u(Tt.$$.fragment,s),u(ft.$$.fragment,s),u(gt.$$.fragment,s),u(Bt.$$.fragment,s),u(Et.$$.fragment,s),u(Ht.$$.fragment,s),u(zt.$$.fragment,s),u(Dt.$$.fragment,s),u(sl.$$.fragment,s),u(nl.$$.fragment,s),u(al.$$.fragment,s),u(il.$$.fragment,s),u(Ml.$$.fragment,s),u(jl.$$.fragment,s),u(hl.$$.fragment,s),u(Tl.$$.fragment,s),u(fl.$$.fragment,s),u(Al.$$.fragment,s),u(Ll.$$.fragment,s),u(Wl.$$.fragment,s),u(Yl.$$.fragment,s),u(Fl.$$.fragment,s),_p=!0)},o(s){j(q.$$.fragment,s),j(x.$$.fragment,s),j(W.$$.fragment,s),j(X.$$.fragment,s),j(Y.$$.fragment,s),j(P.$$.fragment,s),j(D.$$.fragment,s),j(O.$$.fragment,s),j(ss.$$.fragment,s),j(ts.$$.fragment,s),j(ns.$$.fragment,s),j(ps.$$.fragment,s),j(cs.$$.fragment,s),j(Ms.$$.fragment,s),j(js.$$.fragment,s),j(hs.$$.fragment,s),j(Ts.$$.fragment,s),j(ms.$$.fragment,s),j(ds.$$.fragment,s),j(fs.$$.fragment,s),j(bs.$$.fragment,s),j(As.$$.fragment,s),j(_s.$$.fragment,s),j(Es.$$.fragment,s),j(Qs.$$.fragment,s),j(Ls.$$.fragment,s),j(Rs.$$.fragment,s),j(Ss.$$.fragment,s),j(Ys.$$.fragment,s),j(Fs.$$.fragment,s),j(Ks.$$.fragment,s),j(et.$$.fragment,s),j(ot.$$.fragment,s),j(jt.$$.fragment,s),j(Tt.$$.fragment,s),j(ft.$$.fragment,s),j(gt.$$.fragment,s),j(Bt.$$.fragment,s),j(Et.$$.fragment,s),j(Ht.$$.fragment,s),j(zt.$$.fragment,s),j(Dt.$$.fragment,s),j(sl.$$.fragment,s),j(nl.$$.fragment,s),j(al.$$.fragment,s),j(il.$$.fragment,s),j(Ml.$$.fragment,s),j(jl.$$.fragment,s),j(hl.$$.fragment,s),j(Tl.$$.fragment,s),j(fl.$$.fragment,s),j(Al.$$.fragment,s),j(Ll.$$.fragment,s),j(Wl.$$.fragment,s),j(Yl.$$.fragment,s),j(Fl.$$.fragment,s),_p=!1},d(s){s&&(l(pn),l(en),l(on),l(cn),l(rn),l(Q),l(Mn),l(k),l(un),l(L),l(jn),l(H),l(yn),l(R),l(hn),l(I),l(Tn),l(f),l(Jn),l(S),l(mn),l(wn),l(G),l(dn),l(Un),l(z),l(In),l(V),l(fn),l(Cn),l(F),l(bn),l(gn),l(vn),l(An),l(K),l(Bn),l(_n),l(Zn),l(ls),l(En),l($n),l(es),l(Nn),l(as),l(qn),l(xn),l(is),l(Qn),l(os),l(kn),l(Ln),l(rs),l(Hn),l(Rn),l(us),l(Sn),l(Wn),l(ys),l(Gn),l(Xn),l(zn),l(Js),l(Vn),l(Yn),l(ws),l(Fn),l(Pn),l(Us),l(Dn),l(Is),l(On),l(Kn),l(Cs),l(se),l(te),l(gs),l(le),l(vs),l(ne),l(ee),l(Bs),l(ae),l(pe),l(Zs),l(ie),l(oe),l($s),l(ce),l(Ns),l(re),l(qs),l(Me),l(xs),l(ue),l(je),l(ks),l(ye),l(d),l(he),l(Hs),l(Te),l(Je),l(me),l(Ws),l(we),l(Gs),l(de),l(Xs),l(Ue),l(zs),l(Ie),l(Vs),l(fe),l(Ce),l(be),l(Ps),l(ge),l(Ds),l(ve),l(Os),l(Ae),l(Be),l(st),l(_e),l(tt),l(Ze),l(lt),l(Ee),l(nt),l($e),l(Ne),l(C),l(qe),l(b),l(xe),l(at),l(Qe),l(pt),l(ke),l(it),l(Le),l(He),l(ct),l(Re),l(rt),l(Se),l(Mt),l(We),l(ut),l(Ge),l(Xe),l(yt),l(ze),l(ht),l(Ve),l(Ye),l(Jt),l(Fe),l(mt),l(Pe),l(wt),l(De),l(dt),l(Oe),l(Ut),l(Ke),l(It),l(sa),l(ta),l(Ct),l(la),l(bt),l(na),l(ea),l(g),l(aa),l(v),l(pa),l(vt),l(ia),l(At),l(oa),l(ca),l(_t),l(ra),l(Zt),l(Ma),l(ua),l($t),l(ja),l(Nt),l(ya),l(qt),l(ha),l(xt),l(Ta),l(Qt),l(Ja),l(kt),l(ma),l(Lt),l(wa),l(da),l(Rt),l(Ua),l(St),l(Ia),l(Wt),l(fa),l(Gt),l(Ca),l(Xt),l(ba),l(ga),l(Vt),l(va),l(Yt),l(Aa),l(Ft),l(Ba),l(Pt),l(_a),l(Za),l(Ot),l(Ea),l(Kt),l($a),l(Na),l(tl),l(qa),l(ll),l(xa),l(Qa),l(el),l(ka),l(La),l(pl),l(Ha),l(Ra),l(ol),l(Sa),l(cl),l(Wa),l(w),l(Ga),l(Xa),l(Jl),l(za),l(ml),l(Va),l(wl),l(Ya),l(dl),l(Fa),l(Ul),l(Pa),l(Il),l(Da),l(Oa),l(Cl),l(Ka),l(bl),l(sp),l(gl),l(tp),l(vl),l(lp),l(np),l(Bl),l(ep),l(_l),l(ap),l(Zl),l(pp),l(El),l(ip),l($l),l(op),l(Nl),l(cp),l(ql),l(rp),l(A),l(Mp),l(B),l(up),l(xl),l(jp),l(Ql),l(yp),l(kl),l(hp),l(Tp),l(Hl),l(Jp),l(Rl),l(mp),l(Sl),l(wp),l(_),l(dp),l(Z),l(Up),l(Ip),l(Gl),l(fp),l(Xl),l(Cp),l(zl),l(bp),l(E),l(gp),l(Vl),l(vp),l(Ap),l(Bp),l(an)),l(U),y(q,s),y(x,s),y(W,s),y(X,s),y(Y,s),y(P,s),y(D,s),y(O,s),y(ss,s),y(ts,s),y(ns,s),y(ps,s),y(cs,s),y(Ms,s),y(js,s),y(hs,s),y(Ts,s),y(ms,s),y(ds,s),y(fs,s),y(bs,s),y(As,s),y(_s,s),y(Es,s),y(Qs,s),y(Ls),y(Rs,s),y(Ss,s),y(Ys,s),y(Fs,s),y(Ks,s),y(et,s),y(ot,s),y(jt,s),y(Tt,s),y(ft,s),y(gt,s),y(Bt,s),y(Et,s),y(Ht,s),y(zt,s),y(Dt,s),y(sl,s),y(nl,s),y(al,s),y(il,s),y(Ml),y(jl),y(hl),y(Tl,s),y(fl,s),y(Al,s),y(Ll,s),y(Wl,s),y(Yl,s),y(Fl,s)}}}const _c='{"title":"HIL-SERL Real Robot Training Workflow Guide","local":"hil-serl-real-robot-training-workflow-guide","sections":[{"title":"What do I need?","local":"what-do-i-need","sections":[],"depth":2},{"title":"What kind of tasks can I train?","local":"what-kind-of-tasks-can-i-train","sections":[],"depth":2},{"title":"Install LeRobot with HIL-SERL","local":"install-lerobot-with-hil-serl","sections":[],"depth":2},{"title":"Real Robot Training Workflow","local":"real-robot-training-workflow","sections":[{"title":"Understanding Configuration","local":"understanding-configuration","sections":[],"depth":3},{"title":"Processor Pipeline Architecture","local":"processor-pipeline-architecture","sections":[{"title":"Environment Processor Pipeline","local":"environment-processor-pipeline","sections":[],"depth":4},{"title":"Action Processor Pipeline","local":"action-processor-pipeline","sections":[],"depth":4},{"title":"Configuration Examples","local":"configuration-examples","sections":[],"depth":4}],"depth":3},{"title":"Advanced Observation Processing","local":"advanced-observation-processing","sections":[{"title":"Joint Velocity Processing","local":"joint-velocity-processing","sections":[],"depth":4},{"title":"Motor Current Processing","local":"motor-current-processing","sections":[],"depth":4},{"title":"Combined Observation Processing","local":"combined-observation-processing","sections":[],"depth":4}],"depth":3},{"title":"Finding Robot Workspace Bounds","local":"finding-robot-workspace-bounds","sections":[],"depth":3},{"title":"Collecting Demonstrations","local":"collecting-demonstrations","sections":[],"depth":3},{"title":"Using a Teleoperation Device","local":"using-a-teleoperation-device","sections":[],"depth":3},{"title":"Processing the Dataset","local":"processing-the-dataset","sections":[],"depth":3},{"title":"Training a Reward Classifier","local":"training-a-reward-classifier","sections":[],"depth":3},{"title":"Training with Actor-Learner","local":"training-with-actor-learner","sections":[],"depth":3},{"title":"Guide to Human Interventions","local":"guide-to-human-interventions","sections":[],"depth":3},{"title":"Key hyperparameters to tune","local":"key-hyperparameters-to-tune","sections":[],"depth":3}],"depth":2}],"depth":1}';function Zc(Gp){return Uc(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qc extends Ic{constructor(U){super(),fc(this,U,Zc,Bc,wc,{})}}export{Qc as component};
