import{s as qa,n as Aa,o as _a}from"../chunks/scheduler.5f3e6389.js";import{S as $a,i as Ba,e as j,s as n,c as e,h as Za,a as h,d as l,b as p,f as Ca,g as u,j as r,k as ba,l as Ea,m as t,n as i,t as o,o as M,p as c}from"../chunks/index.373ab25c.js";import{C as is}from"../chunks/CodeBlock.9962115b.js";import{H as T,E as va}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.9be40644.js";function ka(pa){let J,cs,os,js,y,hs,U,ea="Lighteval provides comprehensive logging and result management through the <code>EvaluationTracker</code> class. This system allows you to save results locally and optionally push them to various platforms for collaboration and analysis.",rs,d,Ts,m,ua=`Lighteval automatically saves results and evaluation details in the
directory specified with the <code>--output-dir</code> option. The results are saved in
<code>{output_dir}/results/{model_name}/results_{timestamp}.json</code>. <a href="#example-of-a-result-file">Here is an
example of a result file</a>. The output path can be
any <a href="https://filesystem-spec.readthedocs.io/en/latest/index.html" rel="nofollow">fsspec</a>
compliant path (local, S3, Hugging Face Hub, Google Drive, FTP, etc.).`,Js,w,ia=`To save detailed evaluation information, you can use the <code>--save-details</code>
option. The details are saved in Parquet files at
<code>{output_dir}/details/{model_name}/{timestamp}/details_{task}_{timestamp}.parquet</code>.`,ys,I,oa=`If you want results to be saved in a custom path structure, you can set the <code>results-path-template</code> option.
This allows you to specify a string template for the path. The template must contain the following
variables: <code>output_dir</code>, <code>model_name</code>, <code>org</code>. For example:
<code>{output_dir}/{org}_{model}</code>. The template will be used to create the path for the results file.`,Us,g,ds,f,Ma=`You can push results and evaluation details to the Hugging Face Hub. To do
so, you need to set the <code>--push-to-hub</code> option as well as the <code>--results-org</code>
option. The results are saved in a dataset with the name
<code>{results_org}/{model_org}/{model_name}</code>. To push the details, you need to set
the <code>--save-details</code> option.`,ms,C,ca=`The dataset created will be private by default. You can make it public by
setting the <code>--public-run</code> option.`,ws,b,Is,q,ja=`You can push results to TensorBoard by setting <code>--push-to-tensorboard</code>.
This creates a TensorBoard dashboard in a Hugging Face organization specified with the <code>--results-org</code>
option.`,gs,A,fs,_,ha=`You can push results to Weights &amp; Biases by setting <code>--wandb</code>. This initializes a W&amp;B
run and logs the results.`,Cs,$,ra="W&B arguments need to be set in your environment variables:",bs,B,qs,Z,Ta='You can find a complete list of variables in the <a href="https://docs.wandb.ai/guides/track/environment-variables/" rel="nofollow">W&amp;B documentation</a>.',As,E,Ja=`If Trackio is available in your environment (<code>pip install lighteval[trackio]</code>), it will be used to log and push results to a
Hugging Face dataset. Choose the dataset name and organization with:`,_s,v,$s,k,Bs,Q,Zs,N,Es,W,vs,G,ks,z,Qs,R,ya="The detail file contains the following columns:",Ns,X,Ua="<li><strong><code>__doc__</code></strong>: The document used for evaluation, containing the gold reference, few-shot examples, and other hyperparameters used for the task.</li> <li><strong><code>__model_response__</code></strong>: Contains model generations, log probabilities, and the input that was sent to the model.</li> <li><strong><code>__metric__</code></strong>: The value of the metrics for this sample.</li>",Ws,F,Gs,S,da="The <code>EvaluationTracker</code> class provides several configuration options for customizing how results are saved and pushed:",zs,V,Rs,H,Xs,Y,Fs,x,Ss,D,Vs,L,ma="<li><strong><code>output_dir</code></strong>: Local directory to save evaluation results and logs</li> <li><strong><code>results_path_template</code></strong>: Template for results directory structure</li> <li><strong><code>save_details</code></strong>: Whether to save detailed evaluation records (default: True)</li> <li><strong><code>push_to_hub</code></strong>: Whether to push results to Hugging Face Hub (default: False)</li> <li><strong><code>push_to_tensorboard</code></strong>: Whether to push metrics to TensorBoard (default: False)</li> <li><strong><code>hub_results_org</code></strong>: Hugging Face Hub organization to push results to</li> <li><strong><code>tensorboard_metric_prefix</code></strong>: Prefix for TensorBoard metrics (default: “eval”)</li> <li><strong><code>public</code></strong>: Whether to make Hub datasets public (default: False)</li> <li><strong><code>use_wandb</code></strong>: Whether to log to Weights &amp; Biases or Trackio (default: False)</li>",Hs,P,Ys,O,wa="The main results file contains several sections:",xs,K,Ds,ss,Ia="<li><strong><code>config_general</code></strong>: Overall evaluation configuration including model information, timing, and system details</li> <li><strong><code>summary_general</code></strong>: General statistics about the evaluation run</li>",Ls,as,Ps,ls,ga="<li><strong><code>config_tasks</code></strong>: Configuration details for each evaluated task</li> <li><strong><code>summary_tasks</code></strong>: Task-specific statistics and metadata</li> <li><strong><code>versions</code></strong>: Version information for tasks and datasets</li>",Os,ts,Ks,ns,fa="<li><strong><code>results</code></strong>: Actual evaluation metrics and scores for each task</li>",sa,ps,aa,es,la,us,ta,Ms,na;return y=new T({props:{title:"Saving and Reading Results",local:"saving-and-reading-results",headingTag:"h1"}}),d=new T({props:{title:"Saving Results Locally",local:"saving-results-locally",headingTag:"h2"}}),g=new T({props:{title:"Pushing Results to the Hugging Face Hub",local:"pushing-results-to-the-hugging-face-hub",headingTag:"h2"}}),b=new T({props:{title:"Pushing Results to TensorBoard",local:"pushing-results-to-tensorboard",headingTag:"h2"}}),A=new T({props:{title:"Pushing Results to Weights & Biases or Trackio",local:"pushing-results-to-weights--biases-or-trackio",headingTag:"h2"}}),B=new is({props:{code:"ZXhwb3J0JTIwV0FOREJfUFJPSkVDVCUzRCUyMmxpZ2h0ZXZhbCUyMg==",highlighted:'<span class="hljs-built_in">export</span> WANDB_PROJECT=<span class="hljs-string">&quot;lighteval&quot;</span>',wrap:!1}}),v=new is({props:{code:"ZXhwb3J0JTIwV0FOREJfU1BBQ0VfSUQlM0QlMjJvcmclMkZuYW1lJTIy",highlighted:'<span class="hljs-built_in">export</span> WANDB_SPACE_ID=<span class="hljs-string">&quot;org/name&quot;</span>',wrap:!1}}),k=new T({props:{title:"How to Load and Investigate Details",local:"how-to-load-and-investigate-details",headingTag:"h2"}}),Q=new T({props:{title:"Loading from Local Detail Files",local:"loading-from-local-detail-files",headingTag:"h3"}}),N=new is({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwb3MlMEFpbXBvcnQlMjBnbG9iJTBBJTBBb3V0cHV0X2RpciUyMCUzRCUyMCUyMmV2YWxzX2RvYyUyMiUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEF0aW1lc3RhbXAlMjAlM0QlMjAlMjJsYXRlc3QlMjIlMEF0YXNrJTIwJTNEJTIwJTIybGlnaHRldmFsJTdDZ3NtOGslN0MwJTIyJTBBJTBBaWYlMjB0aW1lc3RhbXAlMjAlM0QlM0QlMjAlMjJsYXRlc3QlMjIlM0ElMEElMjAlMjAlMjAlMjBwYXRoJTIwJTNEJTIwZiUyMiU3Qm91dHB1dF9kaXIlN0QlMkZkZXRhaWxzJTJGJTdCbW9kZWxfbmFtZSU3RCUyRiolMkYlMjIlMEElMjAlMjAlMjAlMjB0aW1lc3RhbXBzJTIwJTNEJTIwZ2xvYi5nbG9iKHBhdGgpJTBBJTIwJTIwJTIwJTIwdGltZXN0YW1wJTIwJTNEJTIwc29ydGVkKHRpbWVzdGFtcHMpJTVCLTElNUQuc3BsaXQoJTIyJTJGJTIyKSU1Qi0yJTVEJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMkxhdGVzdCUyMHRpbWVzdGFtcCUzQSUyMCU3QnRpbWVzdGFtcCU3RCUyMiklMEElMEFkZXRhaWxzX3BhdGglMjAlM0QlMjBmJTIyJTdCb3V0cHV0X2RpciU3RCUyRmRldGFpbHMlMkYlN0Jtb2RlbF9uYW1lJTdEJTJGJTdCdGltZXN0YW1wJTdEJTJGZGV0YWlsc18lN0J0YXNrJTdEXyU3QnRpbWVzdGFtcCU3RC5wYXJxdWV0JTIyJTBBJTBBJTIzJTIwTG9hZCUyMHRoZSUyMGRldGFpbHMlMEFkZXRhaWxzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnBhcnF1ZXQlMjIlMkMlMjBkYXRhX2ZpbGVzJTNEZGV0YWlsc19wYXRoJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEElMEFmb3IlMjBkZXRhaWwlMjBpbiUyMGRldGFpbHMlM0ElMEElMjAlMjAlMjAlMjBwcmludChkZXRhaWwp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> glob

output_dir = <span class="hljs-string">&quot;evals_doc&quot;</span>
model_name = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
timestamp = <span class="hljs-string">&quot;latest&quot;</span>
task = <span class="hljs-string">&quot;lighteval|gsm8k|0&quot;</span>

<span class="hljs-keyword">if</span> timestamp == <span class="hljs-string">&quot;latest&quot;</span>:
    path = <span class="hljs-string">f&quot;<span class="hljs-subst">{output_dir}</span>/details/<span class="hljs-subst">{model_name}</span>/*/&quot;</span>
    timestamps = glob.glob(path)
    timestamp = <span class="hljs-built_in">sorted</span>(timestamps)[-<span class="hljs-number">1</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">2</span>]
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Latest timestamp: <span class="hljs-subst">{timestamp}</span>&quot;</span>)

details_path = <span class="hljs-string">f&quot;<span class="hljs-subst">{output_dir}</span>/details/<span class="hljs-subst">{model_name}</span>/<span class="hljs-subst">{timestamp}</span>/details_<span class="hljs-subst">{task}</span>_<span class="hljs-subst">{timestamp}</span>.parquet&quot;</span>

<span class="hljs-comment"># Load the details</span>
details = load_dataset(<span class="hljs-string">&quot;parquet&quot;</span>, data_files=details_path, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-keyword">for</span> detail <span class="hljs-keyword">in</span> details:
    <span class="hljs-built_in">print</span>(detail)`,wrap:!1}}),W=new T({props:{title:"Loading from the Hugging Face Hub",local:"loading-from-the-hugging-face-hub",headingTag:"h3"}}),G=new is({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcmVzdWx0c19vcmclMjAlM0QlMjAlMjJTYXlsb3JUd2lmdCUyMiUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEFzYW5pdGl6ZWRfbW9kZWxfbmFtZSUyMCUzRCUyMG1vZGVsX25hbWUucmVwbGFjZSglMjIlMkYlMjIlMkMlMjAlMjJfXyUyMiklMEF0YXNrJTIwJTNEJTIwJTIybGlnaHRldmFsJTdDZ3NtOGslN0MwJTIyJTBBcHVibGljX3J1biUyMCUzRCUyMEZhbHNlJTBBJTBBZGF0YXNldF9wYXRoJTIwJTNEJTIwZiUyMiU3QnJlc3VsdHNfb3JnJTdEJTJGZGV0YWlsc18lN0JzYW5pdGl6ZWRfbW9kZWxfbmFtZSU3RCU3QidfcHJpdmF0ZSclMjBpZiUyMG5vdCUyMHB1YmxpY19ydW4lMjBlbHNlJTIwJyclN0QlMjIlMEFkZXRhaWxzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KGRhdGFzZXRfcGF0aCUyQyUyMHRhc2sucmVwbGFjZSglMjIlN0MlMjIlMkMlMjAlMjJfJTIyKSUyQyUyMHNwbGl0JTNEJTIybGF0ZXN0JTIyKSUwQSUwQWZvciUyMGRldGFpbCUyMGluJTIwZGV0YWlscyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGRldGFpbCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

results_org = <span class="hljs-string">&quot;SaylorTwift&quot;</span>
model_name = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
sanitized_model_name = model_name.replace(<span class="hljs-string">&quot;/&quot;</span>, <span class="hljs-string">&quot;__&quot;</span>)
task = <span class="hljs-string">&quot;lighteval|gsm8k|0&quot;</span>
public_run = <span class="hljs-literal">False</span>

dataset_path = <span class="hljs-string">f&quot;<span class="hljs-subst">{results_org}</span>/details_<span class="hljs-subst">{sanitized_model_name}</span><span class="hljs-subst">{<span class="hljs-string">&#x27;_private&#x27;</span> <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> public_run <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;&#x27;</span>}</span>&quot;</span>
details = load_dataset(dataset_path, task.replace(<span class="hljs-string">&quot;|&quot;</span>, <span class="hljs-string">&quot;_&quot;</span>), split=<span class="hljs-string">&quot;latest&quot;</span>)

<span class="hljs-keyword">for</span> detail <span class="hljs-keyword">in</span> details:
    <span class="hljs-built_in">print</span>(detail)`,wrap:!1}}),z=new T({props:{title:"Detail File Structure",local:"detail-file-structure",headingTag:"h2"}}),F=new T({props:{title:"EvaluationTracker Configuration",local:"evaluationtracker-configuration",headingTag:"h2"}}),V=new T({props:{title:"Basic Configuration",local:"basic-configuration",headingTag:"h3"}}),H=new is({props:{code:"ZnJvbSUyMGxpZ2h0ZXZhbC5sb2dnaW5nLmV2YWx1YXRpb25fdHJhY2tlciUyMGltcG9ydCUyMEV2YWx1YXRpb25UcmFja2VyJTBBJTBBdHJhY2tlciUyMCUzRCUyMEV2YWx1YXRpb25UcmFja2VyKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjIuJTJGcmVzdWx0cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfZGV0YWlscyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBwdXNoX3RvX2h1YiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBodWJfcmVzdWx0c19vcmclM0QlMjJ5b3VyX3VzZXJuYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwcHVibGljJTNERmFsc2UlMEEp",highlighted:`<span class="hljs-keyword">from</span> lighteval.logging.evaluation_tracker <span class="hljs-keyword">import</span> EvaluationTracker

tracker = EvaluationTracker(
    output_dir=<span class="hljs-string">&quot;./results&quot;</span>,
    save_details=<span class="hljs-literal">True</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    hub_results_org=<span class="hljs-string">&quot;your_username&quot;</span>,
    public=<span class="hljs-literal">False</span>
)`,wrap:!1}}),Y=new T({props:{title:"Advanced Configuration",local:"advanced-configuration",headingTag:"h3"}}),x=new is({props:{code:"dHJhY2tlciUyMCUzRCUyMEV2YWx1YXRpb25UcmFja2VyKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjIuJTJGcmVzdWx0cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlc3VsdHNfcGF0aF90ZW1wbGF0ZSUzRCUyMiU3Qm91dHB1dF9kaXIlN0QlMkZjdXN0b20lMkYlN0JvcmclN0RfJTdCbW9kZWwlN0QlMjIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX2RldGFpbHMlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b190ZW5zb3Jib2FyZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBodWJfcmVzdWx0c19vcmclM0QlMjJteS1vcmclMjIlMkMlMEElMjAlMjAlMjAlMjB0ZW5zb3Jib2FyZF9tZXRyaWNfcHJlZml4JTNEJTIyZXZhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHB1YmxpYyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjB1c2Vfd2FuZGIlM0RUcnVlJTBBKQ==",highlighted:`tracker = EvaluationTracker(
    output_dir=<span class="hljs-string">&quot;./results&quot;</span>,
    results_path_template=<span class="hljs-string">&quot;{output_dir}/custom/{org}_{model}&quot;</span>,
    save_details=<span class="hljs-literal">True</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    push_to_tensorboard=<span class="hljs-literal">True</span>,
    hub_results_org=<span class="hljs-string">&quot;my-org&quot;</span>,
    tensorboard_metric_prefix=<span class="hljs-string">&quot;eval&quot;</span>,
    public=<span class="hljs-literal">True</span>,
    use_wandb=<span class="hljs-literal">True</span>
)`,wrap:!1}}),D=new T({props:{title:"Key Parameters",local:"key-parameters",headingTag:"h3"}}),P=new T({props:{title:"Result File Structure",local:"result-file-structure",headingTag:"h2"}}),K=new T({props:{title:"General Configuration",local:"general-configuration",headingTag:"h3"}}),as=new T({props:{title:"Task-Specific Information",local:"task-specific-information",headingTag:"h3"}}),ts=new T({props:{title:"Results",local:"results",headingTag:"h3"}}),ps=new T({props:{title:"Example of a Result File",local:"example-of-a-result-file",headingTag:"h2"}}),es=new is({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;config_general&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;lighteval_sha&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;203045a8431bc9b77245c9998e05fc54509ea07f&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_fewshot_seeds&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;max_samples&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;job_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;start_time&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">620979.879320166</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;end_time&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">621004.632108041</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;total_evaluation_time_secondes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;24.752787875011563&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gpt2&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_sha&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;607a30d783dfa663caf39e06633721c8d4cfcd7e&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_dtype&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;476.2 MB&quot;</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;results&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;lighteval|gsm8k|0&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;em&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;em_stderr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;maj@8&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;maj@8_stderr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;all&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;em&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;em_stderr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;maj@8&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;maj@8_stderr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;versions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;lighteval|gsm8k|0&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;config_tasks&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;lighteval|gsm8k&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gsm8k&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;prompt_function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gsm8k&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hf_repo&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gsm8k&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hf_subset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;main&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;metric&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;metric_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;em&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;higher_is_better&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;category&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;3&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;use_case&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;sample_level_fn&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;compute&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;corpus_level_fn&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;mean&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;metric_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;maj@8&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;higher_is_better&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;category&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;use_case&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;sample_level_fn&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;compute&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;corpus_level_fn&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;mean&quot;</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hf_avail_splits&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;train&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-string">&quot;test&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;evaluation_splits&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;test&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;few_shots_split&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;few_shots_select&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;random_sampling_from_train&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;generation_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">256</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;generation_grammar&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;stop_sequence&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;Question=&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;num_samples&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;suite&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;lighteval&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;original_num_docs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1319</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;effective_num_docs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;must_remove_duplicate_docs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;version&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;summary_tasks&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;lighteval|gsm8k|0&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;hashes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;hash_examples&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;8517d5bf7e880086&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hash_full_prompts&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;8517d5bf7e880086&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hash_input_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;29916e7afe5cb51d&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hash_cont_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;37f91ce23ef6d435&quot;</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;padded&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;non_padded&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;effective_few_shots&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;summary_general&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;hashes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;hash_examples&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5f383c395f01096e&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hash_full_prompts&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5f383c395f01096e&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hash_input_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;ac933feb14f96d7b&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hash_cont_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;9d03fb26f8da7277&quot;</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;padded&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;non_padded&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),us=new va({props:{source:"https://github.com/huggingface/lighteval/blob/main/docs/source/saving-and-reading-results.mdx"}}),{c(){J=j("meta"),cs=n(),os=j("p"),js=n(),e(y.$$.fragment),hs=n(),U=j("p"),U.innerHTML=ea,rs=n(),e(d.$$.fragment),Ts=n(),m=j("p"),m.innerHTML=ua,Js=n(),w=j("p"),w.innerHTML=ia,ys=n(),I=j("p"),I.innerHTML=oa,Us=n(),e(g.$$.fragment),ds=n(),f=j("p"),f.innerHTML=Ma,ms=n(),C=j("p"),C.innerHTML=ca,ws=n(),e(b.$$.fragment),Is=n(),q=j("p"),q.innerHTML=ja,gs=n(),e(A.$$.fragment),fs=n(),_=j("p"),_.innerHTML=ha,Cs=n(),$=j("p"),$.textContent=ra,bs=n(),e(B.$$.fragment),qs=n(),Z=j("p"),Z.innerHTML=Ta,As=n(),E=j("p"),E.innerHTML=Ja,_s=n(),e(v.$$.fragment),$s=n(),e(k.$$.fragment),Bs=n(),e(Q.$$.fragment),Zs=n(),e(N.$$.fragment),Es=n(),e(W.$$.fragment),vs=n(),e(G.$$.fragment),ks=n(),e(z.$$.fragment),Qs=n(),R=j("p"),R.textContent=ya,Ns=n(),X=j("ul"),X.innerHTML=Ua,Ws=n(),e(F.$$.fragment),Gs=n(),S=j("p"),S.innerHTML=da,zs=n(),e(V.$$.fragment),Rs=n(),e(H.$$.fragment),Xs=n(),e(Y.$$.fragment),Fs=n(),e(x.$$.fragment),Ss=n(),e(D.$$.fragment),Vs=n(),L=j("ul"),L.innerHTML=ma,Hs=n(),e(P.$$.fragment),Ys=n(),O=j("p"),O.textContent=wa,xs=n(),e(K.$$.fragment),Ds=n(),ss=j("ul"),ss.innerHTML=Ia,Ls=n(),e(as.$$.fragment),Ps=n(),ls=j("ul"),ls.innerHTML=ga,Os=n(),e(ts.$$.fragment),Ks=n(),ns=j("ul"),ns.innerHTML=fa,sa=n(),e(ps.$$.fragment),aa=n(),e(es.$$.fragment),la=n(),e(us.$$.fragment),ta=n(),Ms=j("p"),this.h()},l(s){const a=Za("svelte-u9bgzb",document.head);J=h(a,"META",{name:!0,content:!0}),a.forEach(l),cs=p(s),os=h(s,"P",{}),Ca(os).forEach(l),js=p(s),u(y.$$.fragment,s),hs=p(s),U=h(s,"P",{"data-svelte-h":!0}),r(U)!=="svelte-9aqcbu"&&(U.innerHTML=ea),rs=p(s),u(d.$$.fragment,s),Ts=p(s),m=h(s,"P",{"data-svelte-h":!0}),r(m)!=="svelte-nzo4lv"&&(m.innerHTML=ua),Js=p(s),w=h(s,"P",{"data-svelte-h":!0}),r(w)!=="svelte-103anxe"&&(w.innerHTML=ia),ys=p(s),I=h(s,"P",{"data-svelte-h":!0}),r(I)!=="svelte-h64e6b"&&(I.innerHTML=oa),Us=p(s),u(g.$$.fragment,s),ds=p(s),f=h(s,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1cjd5zg"&&(f.innerHTML=Ma),ms=p(s),C=h(s,"P",{"data-svelte-h":!0}),r(C)!=="svelte-icxxh7"&&(C.innerHTML=ca),ws=p(s),u(b.$$.fragment,s),Is=p(s),q=h(s,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1bci1gp"&&(q.innerHTML=ja),gs=p(s),u(A.$$.fragment,s),fs=p(s),_=h(s,"P",{"data-svelte-h":!0}),r(_)!=="svelte-17ozben"&&(_.innerHTML=ha),Cs=p(s),$=h(s,"P",{"data-svelte-h":!0}),r($)!=="svelte-qmfp1v"&&($.textContent=ra),bs=p(s),u(B.$$.fragment,s),qs=p(s),Z=h(s,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-407scl"&&(Z.innerHTML=Ta),As=p(s),E=h(s,"P",{"data-svelte-h":!0}),r(E)!=="svelte-174dmv1"&&(E.innerHTML=Ja),_s=p(s),u(v.$$.fragment,s),$s=p(s),u(k.$$.fragment,s),Bs=p(s),u(Q.$$.fragment,s),Zs=p(s),u(N.$$.fragment,s),Es=p(s),u(W.$$.fragment,s),vs=p(s),u(G.$$.fragment,s),ks=p(s),u(z.$$.fragment,s),Qs=p(s),R=h(s,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1w33ibm"&&(R.textContent=ya),Ns=p(s),X=h(s,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-1wz4paq"&&(X.innerHTML=Ua),Ws=p(s),u(F.$$.fragment,s),Gs=p(s),S=h(s,"P",{"data-svelte-h":!0}),r(S)!=="svelte-vgm6ps"&&(S.innerHTML=da),zs=p(s),u(V.$$.fragment,s),Rs=p(s),u(H.$$.fragment,s),Xs=p(s),u(Y.$$.fragment,s),Fs=p(s),u(x.$$.fragment,s),Ss=p(s),u(D.$$.fragment,s),Vs=p(s),L=h(s,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-n2g9hd"&&(L.innerHTML=ma),Hs=p(s),u(P.$$.fragment,s),Ys=p(s),O=h(s,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1ieqcct"&&(O.textContent=wa),xs=p(s),u(K.$$.fragment,s),Ds=p(s),ss=h(s,"UL",{"data-svelte-h":!0}),r(ss)!=="svelte-r2q4i7"&&(ss.innerHTML=Ia),Ls=p(s),u(as.$$.fragment,s),Ps=p(s),ls=h(s,"UL",{"data-svelte-h":!0}),r(ls)!=="svelte-a95mdm"&&(ls.innerHTML=ga),Os=p(s),u(ts.$$.fragment,s),Ks=p(s),ns=h(s,"UL",{"data-svelte-h":!0}),r(ns)!=="svelte-1iqqkon"&&(ns.innerHTML=fa),sa=p(s),u(ps.$$.fragment,s),aa=p(s),u(es.$$.fragment,s),la=p(s),u(us.$$.fragment,s),ta=p(s),Ms=h(s,"P",{}),Ca(Ms).forEach(l),this.h()},h(){ba(J,"name","hf:doc:metadata"),ba(J,"content",Qa)},m(s,a){Ea(document.head,J),t(s,cs,a),t(s,os,a),t(s,js,a),i(y,s,a),t(s,hs,a),t(s,U,a),t(s,rs,a),i(d,s,a),t(s,Ts,a),t(s,m,a),t(s,Js,a),t(s,w,a),t(s,ys,a),t(s,I,a),t(s,Us,a),i(g,s,a),t(s,ds,a),t(s,f,a),t(s,ms,a),t(s,C,a),t(s,ws,a),i(b,s,a),t(s,Is,a),t(s,q,a),t(s,gs,a),i(A,s,a),t(s,fs,a),t(s,_,a),t(s,Cs,a),t(s,$,a),t(s,bs,a),i(B,s,a),t(s,qs,a),t(s,Z,a),t(s,As,a),t(s,E,a),t(s,_s,a),i(v,s,a),t(s,$s,a),i(k,s,a),t(s,Bs,a),i(Q,s,a),t(s,Zs,a),i(N,s,a),t(s,Es,a),i(W,s,a),t(s,vs,a),i(G,s,a),t(s,ks,a),i(z,s,a),t(s,Qs,a),t(s,R,a),t(s,Ns,a),t(s,X,a),t(s,Ws,a),i(F,s,a),t(s,Gs,a),t(s,S,a),t(s,zs,a),i(V,s,a),t(s,Rs,a),i(H,s,a),t(s,Xs,a),i(Y,s,a),t(s,Fs,a),i(x,s,a),t(s,Ss,a),i(D,s,a),t(s,Vs,a),t(s,L,a),t(s,Hs,a),i(P,s,a),t(s,Ys,a),t(s,O,a),t(s,xs,a),i(K,s,a),t(s,Ds,a),t(s,ss,a),t(s,Ls,a),i(as,s,a),t(s,Ps,a),t(s,ls,a),t(s,Os,a),i(ts,s,a),t(s,Ks,a),t(s,ns,a),t(s,sa,a),i(ps,s,a),t(s,aa,a),i(es,s,a),t(s,la,a),i(us,s,a),t(s,ta,a),t(s,Ms,a),na=!0},p:Aa,i(s){na||(o(y.$$.fragment,s),o(d.$$.fragment,s),o(g.$$.fragment,s),o(b.$$.fragment,s),o(A.$$.fragment,s),o(B.$$.fragment,s),o(v.$$.fragment,s),o(k.$$.fragment,s),o(Q.$$.fragment,s),o(N.$$.fragment,s),o(W.$$.fragment,s),o(G.$$.fragment,s),o(z.$$.fragment,s),o(F.$$.fragment,s),o(V.$$.fragment,s),o(H.$$.fragment,s),o(Y.$$.fragment,s),o(x.$$.fragment,s),o(D.$$.fragment,s),o(P.$$.fragment,s),o(K.$$.fragment,s),o(as.$$.fragment,s),o(ts.$$.fragment,s),o(ps.$$.fragment,s),o(es.$$.fragment,s),o(us.$$.fragment,s),na=!0)},o(s){M(y.$$.fragment,s),M(d.$$.fragment,s),M(g.$$.fragment,s),M(b.$$.fragment,s),M(A.$$.fragment,s),M(B.$$.fragment,s),M(v.$$.fragment,s),M(k.$$.fragment,s),M(Q.$$.fragment,s),M(N.$$.fragment,s),M(W.$$.fragment,s),M(G.$$.fragment,s),M(z.$$.fragment,s),M(F.$$.fragment,s),M(V.$$.fragment,s),M(H.$$.fragment,s),M(Y.$$.fragment,s),M(x.$$.fragment,s),M(D.$$.fragment,s),M(P.$$.fragment,s),M(K.$$.fragment,s),M(as.$$.fragment,s),M(ts.$$.fragment,s),M(ps.$$.fragment,s),M(es.$$.fragment,s),M(us.$$.fragment,s),na=!1},d(s){s&&(l(cs),l(os),l(js),l(hs),l(U),l(rs),l(Ts),l(m),l(Js),l(w),l(ys),l(I),l(Us),l(ds),l(f),l(ms),l(C),l(ws),l(Is),l(q),l(gs),l(fs),l(_),l(Cs),l($),l(bs),l(qs),l(Z),l(As),l(E),l(_s),l($s),l(Bs),l(Zs),l(Es),l(vs),l(ks),l(Qs),l(R),l(Ns),l(X),l(Ws),l(Gs),l(S),l(zs),l(Rs),l(Xs),l(Fs),l(Ss),l(Vs),l(L),l(Hs),l(Ys),l(O),l(xs),l(Ds),l(ss),l(Ls),l(Ps),l(ls),l(Os),l(Ks),l(ns),l(sa),l(aa),l(la),l(ta),l(Ms)),l(J),c(y,s),c(d,s),c(g,s),c(b,s),c(A,s),c(B,s),c(v,s),c(k,s),c(Q,s),c(N,s),c(W,s),c(G,s),c(z,s),c(F,s),c(V,s),c(H,s),c(Y,s),c(x,s),c(D,s),c(P,s),c(K,s),c(as,s),c(ts,s),c(ps,s),c(es,s),c(us,s)}}}const Qa='{"title":"Saving and Reading Results","local":"saving-and-reading-results","sections":[{"title":"Saving Results Locally","local":"saving-results-locally","sections":[],"depth":2},{"title":"Pushing Results to the Hugging Face Hub","local":"pushing-results-to-the-hugging-face-hub","sections":[],"depth":2},{"title":"Pushing Results to TensorBoard","local":"pushing-results-to-tensorboard","sections":[],"depth":2},{"title":"Pushing Results to Weights & Biases or Trackio","local":"pushing-results-to-weights--biases-or-trackio","sections":[],"depth":2},{"title":"How to Load and Investigate Details","local":"how-to-load-and-investigate-details","sections":[{"title":"Loading from Local Detail Files","local":"loading-from-local-detail-files","sections":[],"depth":3},{"title":"Loading from the Hugging Face Hub","local":"loading-from-the-hugging-face-hub","sections":[],"depth":3}],"depth":2},{"title":"Detail File Structure","local":"detail-file-structure","sections":[],"depth":2},{"title":"EvaluationTracker Configuration","local":"evaluationtracker-configuration","sections":[{"title":"Basic Configuration","local":"basic-configuration","sections":[],"depth":3},{"title":"Advanced Configuration","local":"advanced-configuration","sections":[],"depth":3},{"title":"Key Parameters","local":"key-parameters","sections":[],"depth":3}],"depth":2},{"title":"Result File Structure","local":"result-file-structure","sections":[{"title":"General Configuration","local":"general-configuration","sections":[],"depth":3},{"title":"Task-Specific Information","local":"task-specific-information","sections":[],"depth":3},{"title":"Results","local":"results","sections":[],"depth":3}],"depth":2},{"title":"Example of a Result File","local":"example-of-a-result-file","sections":[],"depth":2}],"depth":1}';function Na(pa){return _a(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xa extends $a{constructor(J){super(),Ba(this,J,Na,ka,qa,{})}}export{Xa as component};
