import{s as $t,n as Tt,o as wt}from"../chunks/scheduler.5f3e6389.js";import{S as Jt,i as Ut,e as M,s as i,c as a,h as jt,a as u,d as l,b as n,f as dt,g as m,j as y,k as tt,l as Ct,m as s,n as p,t as r,o as c,p as o}from"../chunks/index.373ab25c.js";import{C as h}from"../chunks/CodeBlock.9962115b.js";import{H as f,E as bt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.9be40644.js";function vt(lt){let g,re,me,ce,T,oe,w,Me,J,ue,U,st="There are two types of metrics in Lighteval:",fe,j,ye,C,it="<li><strong>Purpose</strong>: Evaluate individual samples/predictions</li> <li><strong>Input</strong>: Takes a <code>Doc</code> and <code>ModelResponse</code> (model’s prediction)</li> <li><strong>Output</strong>: Returns a float or boolean value for that specific sample</li> <li><strong>Example</strong>: Checking if a model’s answer matches the correct answer for one sample</li>",ge,b,he,v,nt="<li><strong>Purpose</strong>: Compute final scores across the entire dataset/corpus</li> <li><strong>Input</strong>: Takes the results from all sample-level evaluations</li> <li><strong>Output</strong>: Returns a single score representing overall performance</li> <li><strong>Examples</strong>:<ul><li>Simple aggregation: Calculating average accuracy across all test samples</li> <li>Complex metrics: BLEU score where sample-level metric prepares data (tokenization, etc.) and corpus-level metric computes the actual BLEU score</li></ul></li>",de,I,$e,_,at=`First, check if you can use one of the parameterized functions in
<a href="package_reference/metrics#corpus-metrics">Corpus Metrics</a> or
<a href="package_reference/metrics#sample-metrics">Sample Metrics</a>.`,Te,k,mt="If not, you can use the <code>custom_task</code> system to register your new metric.",we,d,pt='<p>To see an example of a custom metric added along with a custom task, look at the <a href="https://github.com/huggingface/lighteval/tree/main/examples/custom_tasks/ifeval" rel="nofollow">IFEval custom task</a>.</p>',Je,$,rt=`<p>To contribute your custom metric to the Lighteval repository, you would first need
to install the required dev dependencies by running <code>pip install -e .[dev]</code>
and then run <code>pre-commit install</code> to install the pre-commit hooks.</p>`,Ue,G,je,V,Ce,E,ct=`Create a new Python file which should contain the full logic of your metric.
The file also needs to start with these imports:`,be,B,ve,Z,Ie,S,ot=`You need to define a sample-level metric. All sample-level metrics will have the same signature, taking a
<code>~lighteval.types.Doc</code> and a <code>~lighteval.types.ModelResponse</code>. The metric should return a float or a
boolean.`,_e,X,ke,x,Ge,R,Ve,Y,Mt="If you want to return multiple metrics per sample, you need to return a dictionary with the metrics as keys and the values as values:",Ee,N,Be,W,Ze,z,ut="You can define an aggregation function if needed. A common aggregation function is <code>np.mean</code>:",Se,A,Xe,Q,xe,L,Re,q,ft=`If it’s a sample-level metric, you can use the following code
with <a href="/docs/lighteval/main/en/package_reference/metrics#lighteval.metrics.utils.metric_utils.SampleLevelMetric">SampleLevelMetric</a>:`,Ye,H,Ne,F,We,D,yt=`If your metric defines multiple metrics per sample, you can use the following code
with <a href="/docs/lighteval/main/en/package_reference/metrics#lighteval.metrics.utils.metric_utils.SampleLevelMetricGrouping">SampleLevelMetricGrouping</a>:`,ze,P,Ae,O,Qe,K,gt=`To finish, add the following code so that it adds your metric to our metrics list
when loaded as a module:`,Le,ee,qe,te,He,le,Fe,se,ht="You can then give your custom metric to Lighteval by using <code>--custom-tasks path_to_your_file</code> when launching it after adding it to the task config.",De,ie,Pe,ne,Oe,ae,Ke,pe,et;return T=new f({props:{title:"Adding a New Metric",local:"adding-a-new-metric",headingTag:"h1"}}),w=new f({props:{title:"Before You Start",local:"before-you-start",headingTag:"h2"}}),J=new f({props:{title:"Two different types of metrics",local:"two-different-types-of-metrics",headingTag:"h3"}}),j=new f({props:{title:"Sample-Level Metrics",local:"sample-level-metrics",headingTag:"h4"}}),b=new f({props:{title:"Corpus-Level Metrics",local:"corpus-level-metrics",headingTag:"h4"}}),I=new f({props:{title:"Check Existing Metrics",local:"check-existing-metrics",headingTag:"h3"}}),G=new f({props:{title:"Creating a Custom Metric",local:"creating-a-custom-metric",headingTag:"h2"}}),V=new f({props:{title:"Step 1: Create the Metric File",local:"step-1-create-the-metric-file",headingTag:"h3"}}),B=new h({props:{code:"ZnJvbSUyMGFlbnVtJTIwaW1wb3J0JTIwZXh0ZW5kX2VudW0lMEFmcm9tJTIwbGlnaHRldmFsLm1ldHJpY3MlMjBpbXBvcnQlMjBNZXRyaWNz",highlighted:`<span class="hljs-keyword">from</span> aenum <span class="hljs-keyword">import</span> extend_enum
<span class="hljs-keyword">from</span> lighteval.metrics <span class="hljs-keyword">import</span> Metrics`,wrap:!1}}),Z=new f({props:{title:"Step 2: Define the Sample-Level Metric",local:"step-2-define-the-sample-level-metric",headingTag:"h3"}}),X=new f({props:{title:"Single Metric Example",local:"single-metric-example",headingTag:"h4"}}),x=new h({props:{code:"ZGVmJTIwY3VzdG9tX21ldHJpYyhkb2MlM0ElMjBEb2MlMkMlMjBtb2RlbF9yZXNwb25zZSUzQSUyME1vZGVsUmVzcG9uc2UpJTIwLSUzRSUyMGJvb2wlM0ElMEElMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMG1vZGVsX3Jlc3BvbnNlLnRleHQlNUIwJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzcG9uc2UlMjAlM0QlM0QlMjBkb2MuY2hvaWNlcyU1QmRvYy5nb2xkX2luZGV4JTVE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">custom_metric</span>(<span class="hljs-params">doc: Doc, model_response: ModelResponse</span>) -&gt; <span class="hljs-built_in">bool</span>:
    response = model_response.text[<span class="hljs-number">0</span>]
    <span class="hljs-keyword">return</span> response == doc.choices[doc.gold_index]`,wrap:!1}}),R=new f({props:{title:"Multiple Metrics Example",local:"multiple-metrics-example",headingTag:"h4"}}),N=new h({props:{code:"ZGVmJTIwY3VzdG9tX21ldHJpYyhkb2MlM0ElMjBEb2MlMkMlMjBtb2RlbF9yZXNwb25zZSUzQSUyME1vZGVsUmVzcG9uc2UpJTIwLSUzRSUyMGRpY3QlM0ElMEElMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMG1vZGVsX3Jlc3BvbnNlLnRleHQlNUIwJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyYWNjdXJhY3klMjIlM0ElMjByZXNwb25zZSUyMCUzRCUzRCUyMGRvYy5jaG9pY2VzJTVCZG9jLmdvbGRfaW5kZXglNUQlMkMlMjAlMjJvdGhlcl9tZXRyaWMlMjIlM0ElMjAwLjUlN0Q=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">custom_metric</span>(<span class="hljs-params">doc: Doc, model_response: ModelResponse</span>) -&gt; <span class="hljs-built_in">dict</span>:
    response = model_response.text[<span class="hljs-number">0</span>]
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;accuracy&quot;</span>: response == doc.choices[doc.gold_index], <span class="hljs-string">&quot;other_metric&quot;</span>: <span class="hljs-number">0.5</span>}`,wrap:!1}}),W=new f({props:{title:"Step 3: Define Aggregation Function (Optional)",local:"step-3-define-aggregation-function-optional",headingTag:"h3"}}),A=new h({props:{code:"ZGVmJTIwYWdnX2Z1bmN0aW9uKGl0ZW1zKSUzQSUwQSUyMCUyMCUyMCUyMGZsYXRfaXRlbXMlMjAlM0QlMjAlNUJpdGVtJTIwZm9yJTIwc3VibGlzdCUyMGluJTIwaXRlbXMlMjBmb3IlMjBpdGVtJTIwaW4lMjBzdWJsaXN0JTVEJTBBJTIwJTIwJTIwJTIwc2NvcmUlMjAlM0QlMjBzdW0oZmxhdF9pdGVtcyklMjAlMkYlMjBsZW4oZmxhdF9pdGVtcyklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzY29yZQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">agg_function</span>(<span class="hljs-params">items</span>):
    flat_items = [item <span class="hljs-keyword">for</span> sublist <span class="hljs-keyword">in</span> items <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> sublist]
    score = <span class="hljs-built_in">sum</span>(flat_items) / <span class="hljs-built_in">len</span>(flat_items)
    <span class="hljs-keyword">return</span> score`,wrap:!1}}),Q=new f({props:{title:"Step 4: Create the Metric Object",local:"step-4-create-the-metric-object",headingTag:"h3"}}),L=new f({props:{title:"Single Metric",local:"single-metric",headingTag:"h4"}}),H=new h({props:{code:"bXlfY3VzdG9tX21ldHJpYyUyMCUzRCUyMFNhbXBsZUxldmVsTWV0cmljKCUwQSUyMCUyMCUyMCUyMG1ldHJpY19uYW1lJTNEJTIyY3VzdG9tX2FjY3VyYWN5JTIyJTJDJTBBJTIwJTIwJTIwJTIwaGlnaGVyX2lzX2JldHRlciUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBjYXRlZ29yeSUzRFNhbXBsaW5nTWV0aG9kLkdFTkVSQVRJVkUlMkMlMEElMjAlMjAlMjAlMjBzYW1wbGVfbGV2ZWxfZm4lM0RjdXN0b21fbWV0cmljJTJDJTBBJTIwJTIwJTIwJTIwY29ycHVzX2xldmVsX2ZuJTNEYWdnX2Z1bmN0aW9uJTJDJTBBKQ==",highlighted:`my_custom_metric = SampleLevelMetric(
    metric_name=<span class="hljs-string">&quot;custom_accuracy&quot;</span>,
    higher_is_better=<span class="hljs-literal">True</span>,
    category=SamplingMethod.GENERATIVE,
    sample_level_fn=custom_metric,
    corpus_level_fn=agg_function,
)`,wrap:!1}}),F=new f({props:{title:"Multiple Metrics",local:"multiple-metrics",headingTag:"h4"}}),P=new h({props:{code:"Y3VzdG9tX21ldHJpYyUyMCUzRCUyMFNhbXBsZUxldmVsTWV0cmljR3JvdXBpbmcoJTBBJTIwJTIwJTIwJTIwbWV0cmljX25hbWUlM0QlNUIlMjJhY2N1cmFjeSUyMiUyQyUyMCUyMnJlc3BvbnNlX2xlbmd0aCUyMiUyQyUyMCUyMmNvbmZpZGVuY2UlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBoaWdoZXJfaXNfYmV0dGVyJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWNjdXJhY3klMjIlM0ElMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycmVzcG9uc2VfbGVuZ3RoJTIyJTNBJTIwRmFsc2UlMkMlMjAlMjAlMjMlMjBTaG9ydGVyJTIwcmVzcG9uc2VzJTIwbWlnaHQlMjBiZSUyMGJldHRlciUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbmZpZGVuY2UlMjIlM0ElMjBUcnVlJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwY2F0ZWdvcnklM0RTYW1wbGluZ01ldGhvZC5HRU5FUkFUSVZFJTJDJTBBJTIwJTIwJTIwJTIwc2FtcGxlX2xldmVsX2ZuJTNEY3VzdG9tX21ldHJpYyUyQyUwQSUyMCUyMCUyMCUyMGNvcnB1c19sZXZlbF9mbiUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmFjY3VyYWN5JTIyJTNBJTIwbnAubWVhbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlc3BvbnNlX2xlbmd0aCUyMiUzQSUyMG5wLm1lYW4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb25maWRlbmNlJTIyJTNBJTIwbnAubWVhbiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSk=",highlighted:`custom_metric = SampleLevelMetricGrouping(
    metric_name=[<span class="hljs-string">&quot;accuracy&quot;</span>, <span class="hljs-string">&quot;response_length&quot;</span>, <span class="hljs-string">&quot;confidence&quot;</span>],
    higher_is_better={
        <span class="hljs-string">&quot;accuracy&quot;</span>: <span class="hljs-literal">True</span>,
        <span class="hljs-string">&quot;response_length&quot;</span>: <span class="hljs-literal">False</span>,  <span class="hljs-comment"># Shorter responses might be better</span>
        <span class="hljs-string">&quot;confidence&quot;</span>: <span class="hljs-literal">True</span>
    },
    category=SamplingMethod.GENERATIVE,
    sample_level_fn=custom_metric,
    corpus_level_fn={
        <span class="hljs-string">&quot;accuracy&quot;</span>: np.mean,
        <span class="hljs-string">&quot;response_length&quot;</span>: np.mean,
        <span class="hljs-string">&quot;confidence&quot;</span>: np.mean,
    },
)`,wrap:!1}}),O=new f({props:{title:"Step 5: Register the Metric",local:"step-5-register-the-metric",headingTag:"h3"}}),ee=new h({props:{code:"JTIzJTIwQWRkcyUyMHRoZSUyMG1ldHJpYyUyMHRvJTIwdGhlJTIwbWV0cmljJTIwbGlzdCElMEFleHRlbmRfZW51bShNZXRyaWNzJTJDJTIwJTIyQ1VTVE9NX0FDQ1VSQUNZJTIyJTJDJTIwbXlfY3VzdG9tX21ldHJpYyklMEElMEFpZiUyMF9fbmFtZV9fJTIwJTNEJTNEJTIwJTIyX19tYWluX18lMjIlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJJbXBvcnRlZCUyMG1ldHJpYyUyMik=",highlighted:`<span class="hljs-comment"># Adds the metric to the metric list!</span>
extend_enum(Metrics, <span class="hljs-string">&quot;CUSTOM_ACCURACY&quot;</span>, my_custom_metric)

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Imported metric&quot;</span>)`,wrap:!1}}),te=new f({props:{title:"Using Your Custom Metric",local:"using-your-custom-metric",headingTag:"h2"}}),le=new f({props:{title:"With Custom Tasks",local:"with-custom-tasks",headingTag:"h3"}}),ie=new h({props:{code:"bGlnaHRldmFsJTIwYWNjZWxlcmF0ZSUyMCU1QyUwQSUyMCUyMCUyMCUyMCUyMm1vZGVsX25hbWUlM0RvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMCUyMmxlYWRlcmJvYXJkJTdDdHJ1dGhmdWxxYSUzQW1jJTdDMCUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY3VzdG9tLXRhc2tzJTIwcGF0aF90b195b3VyX21ldHJpY19maWxlLnB5",highlighted:`lighteval accelerate \\
    <span class="hljs-string">&quot;model_name=openai-community/gpt2&quot;</span> \\
    <span class="hljs-string">&quot;leaderboard|truthfulqa:mc|0&quot;</span> \\
    --custom-tasks path_to_your_metric_file.py`,wrap:!1}}),ne=new h({props:{code:"ZnJvbSUyMGxpZ2h0ZXZhbC50YXNrcy5saWdodGV2YWxfdGFzayUyMGltcG9ydCUyMExpZ2h0ZXZhbFRhc2tDb25maWclMEElMEF0YXNrJTIwJTNEJTIwTGlnaHRldmFsVGFza0NvbmZpZyglMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIybXlfY3VzdG9tX3Rhc2slMjIlMkMlMEElMjAlMjAlMjAlMjBzdWl0ZSUzRCU1QiUyMmNvbW11bml0eSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1ldHJpYyUzRCU1Qm15X2N1c3RvbV9tZXRyaWMlNUQlMkMlMjAlMjAlMjMlMjBVc2UlMjB5b3VyJTIwY3VzdG9tJTIwbWV0cmljJTIwaGVyZSUwQSUyMCUyMCUyMCUyMHByb21wdF9mdW5jdGlvbiUzRG15X3Byb21wdF9mdW5jdGlvbiUyQyUwQSUyMCUyMCUyMCUyMGhmX3JlcG8lM0QlMjJteV9kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwZXZhbHVhdGlvbl9zcGxpdHMlM0QlNUIlMjJ0ZXN0JTIyJTVEJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> lighteval.tasks.lighteval_task <span class="hljs-keyword">import</span> LightevalTaskConfig

task = LightevalTaskConfig(
    name=<span class="hljs-string">&quot;my_custom_task&quot;</span>,
    suite=[<span class="hljs-string">&quot;community&quot;</span>],
    metric=[my_custom_metric],  <span class="hljs-comment"># Use your custom metric here</span>
    prompt_function=my_prompt_function,
    hf_repo=<span class="hljs-string">&quot;my_dataset&quot;</span>,
    evaluation_splits=[<span class="hljs-string">&quot;test&quot;</span>]
)`,wrap:!1}}),ae=new bt({props:{source:"https://github.com/huggingface/lighteval/blob/main/docs/source/adding-a-new-metric.mdx"}}),{c(){g=M("meta"),re=i(),me=M("p"),ce=i(),a(T.$$.fragment),oe=i(),a(w.$$.fragment),Me=i(),a(J.$$.fragment),ue=i(),U=M("p"),U.textContent=st,fe=i(),a(j.$$.fragment),ye=i(),C=M("ul"),C.innerHTML=it,ge=i(),a(b.$$.fragment),he=i(),v=M("ul"),v.innerHTML=nt,de=i(),a(I.$$.fragment),$e=i(),_=M("p"),_.innerHTML=at,Te=i(),k=M("p"),k.innerHTML=mt,we=i(),d=M("blockquote"),d.innerHTML=pt,Je=i(),$=M("blockquote"),$.innerHTML=rt,Ue=i(),a(G.$$.fragment),je=i(),a(V.$$.fragment),Ce=i(),E=M("p"),E.textContent=ct,be=i(),a(B.$$.fragment),ve=i(),a(Z.$$.fragment),Ie=i(),S=M("p"),S.innerHTML=ot,_e=i(),a(X.$$.fragment),ke=i(),a(x.$$.fragment),Ge=i(),a(R.$$.fragment),Ve=i(),Y=M("p"),Y.textContent=Mt,Ee=i(),a(N.$$.fragment),Be=i(),a(W.$$.fragment),Ze=i(),z=M("p"),z.innerHTML=ut,Se=i(),a(A.$$.fragment),Xe=i(),a(Q.$$.fragment),xe=i(),a(L.$$.fragment),Re=i(),q=M("p"),q.innerHTML=ft,Ye=i(),a(H.$$.fragment),Ne=i(),a(F.$$.fragment),We=i(),D=M("p"),D.innerHTML=yt,ze=i(),a(P.$$.fragment),Ae=i(),a(O.$$.fragment),Qe=i(),K=M("p"),K.textContent=gt,Le=i(),a(ee.$$.fragment),qe=i(),a(te.$$.fragment),He=i(),a(le.$$.fragment),Fe=i(),se=M("p"),se.innerHTML=ht,De=i(),a(ie.$$.fragment),Pe=i(),a(ne.$$.fragment),Oe=i(),a(ae.$$.fragment),Ke=i(),pe=M("p"),this.h()},l(e){const t=jt("svelte-u9bgzb",document.head);g=u(t,"META",{name:!0,content:!0}),t.forEach(l),re=n(e),me=u(e,"P",{}),dt(me).forEach(l),ce=n(e),m(T.$$.fragment,e),oe=n(e),m(w.$$.fragment,e),Me=n(e),m(J.$$.fragment,e),ue=n(e),U=u(e,"P",{"data-svelte-h":!0}),y(U)!=="svelte-1jnixsg"&&(U.textContent=st),fe=n(e),m(j.$$.fragment,e),ye=n(e),C=u(e,"UL",{"data-svelte-h":!0}),y(C)!=="svelte-1nwago0"&&(C.innerHTML=it),ge=n(e),m(b.$$.fragment,e),he=n(e),v=u(e,"UL",{"data-svelte-h":!0}),y(v)!=="svelte-1b4pgyk"&&(v.innerHTML=nt),de=n(e),m(I.$$.fragment,e),$e=n(e),_=u(e,"P",{"data-svelte-h":!0}),y(_)!=="svelte-vpq2qz"&&(_.innerHTML=at),Te=n(e),k=u(e,"P",{"data-svelte-h":!0}),y(k)!=="svelte-xdscpl"&&(k.innerHTML=mt),we=n(e),d=u(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),y(d)!=="svelte-1nxhxit"&&(d.innerHTML=pt),Je=n(e),$=u(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),y($)!=="svelte-3wrpqo"&&($.innerHTML=rt),Ue=n(e),m(G.$$.fragment,e),je=n(e),m(V.$$.fragment,e),Ce=n(e),E=u(e,"P",{"data-svelte-h":!0}),y(E)!=="svelte-rk8zi4"&&(E.textContent=ct),be=n(e),m(B.$$.fragment,e),ve=n(e),m(Z.$$.fragment,e),Ie=n(e),S=u(e,"P",{"data-svelte-h":!0}),y(S)!=="svelte-uw89ed"&&(S.innerHTML=ot),_e=n(e),m(X.$$.fragment,e),ke=n(e),m(x.$$.fragment,e),Ge=n(e),m(R.$$.fragment,e),Ve=n(e),Y=u(e,"P",{"data-svelte-h":!0}),y(Y)!=="svelte-1vuyefu"&&(Y.textContent=Mt),Ee=n(e),m(N.$$.fragment,e),Be=n(e),m(W.$$.fragment,e),Ze=n(e),z=u(e,"P",{"data-svelte-h":!0}),y(z)!=="svelte-n3kro3"&&(z.innerHTML=ut),Se=n(e),m(A.$$.fragment,e),Xe=n(e),m(Q.$$.fragment,e),xe=n(e),m(L.$$.fragment,e),Re=n(e),q=u(e,"P",{"data-svelte-h":!0}),y(q)!=="svelte-fdo7f5"&&(q.innerHTML=ft),Ye=n(e),m(H.$$.fragment,e),Ne=n(e),m(F.$$.fragment,e),We=n(e),D=u(e,"P",{"data-svelte-h":!0}),y(D)!=="svelte-1vqvxhl"&&(D.innerHTML=yt),ze=n(e),m(P.$$.fragment,e),Ae=n(e),m(O.$$.fragment,e),Qe=n(e),K=u(e,"P",{"data-svelte-h":!0}),y(K)!=="svelte-1bbv5uf"&&(K.textContent=gt),Le=n(e),m(ee.$$.fragment,e),qe=n(e),m(te.$$.fragment,e),He=n(e),m(le.$$.fragment,e),Fe=n(e),se=u(e,"P",{"data-svelte-h":!0}),y(se)!=="svelte-o8irch"&&(se.innerHTML=ht),De=n(e),m(ie.$$.fragment,e),Pe=n(e),m(ne.$$.fragment,e),Oe=n(e),m(ae.$$.fragment,e),Ke=n(e),pe=u(e,"P",{}),dt(pe).forEach(l),this.h()},h(){tt(g,"name","hf:doc:metadata"),tt(g,"content",It),tt(d,"class","tip"),tt($,"class","warning")},m(e,t){Ct(document.head,g),s(e,re,t),s(e,me,t),s(e,ce,t),p(T,e,t),s(e,oe,t),p(w,e,t),s(e,Me,t),p(J,e,t),s(e,ue,t),s(e,U,t),s(e,fe,t),p(j,e,t),s(e,ye,t),s(e,C,t),s(e,ge,t),p(b,e,t),s(e,he,t),s(e,v,t),s(e,de,t),p(I,e,t),s(e,$e,t),s(e,_,t),s(e,Te,t),s(e,k,t),s(e,we,t),s(e,d,t),s(e,Je,t),s(e,$,t),s(e,Ue,t),p(G,e,t),s(e,je,t),p(V,e,t),s(e,Ce,t),s(e,E,t),s(e,be,t),p(B,e,t),s(e,ve,t),p(Z,e,t),s(e,Ie,t),s(e,S,t),s(e,_e,t),p(X,e,t),s(e,ke,t),p(x,e,t),s(e,Ge,t),p(R,e,t),s(e,Ve,t),s(e,Y,t),s(e,Ee,t),p(N,e,t),s(e,Be,t),p(W,e,t),s(e,Ze,t),s(e,z,t),s(e,Se,t),p(A,e,t),s(e,Xe,t),p(Q,e,t),s(e,xe,t),p(L,e,t),s(e,Re,t),s(e,q,t),s(e,Ye,t),p(H,e,t),s(e,Ne,t),p(F,e,t),s(e,We,t),s(e,D,t),s(e,ze,t),p(P,e,t),s(e,Ae,t),p(O,e,t),s(e,Qe,t),s(e,K,t),s(e,Le,t),p(ee,e,t),s(e,qe,t),p(te,e,t),s(e,He,t),p(le,e,t),s(e,Fe,t),s(e,se,t),s(e,De,t),p(ie,e,t),s(e,Pe,t),p(ne,e,t),s(e,Oe,t),p(ae,e,t),s(e,Ke,t),s(e,pe,t),et=!0},p:Tt,i(e){et||(r(T.$$.fragment,e),r(w.$$.fragment,e),r(J.$$.fragment,e),r(j.$$.fragment,e),r(b.$$.fragment,e),r(I.$$.fragment,e),r(G.$$.fragment,e),r(V.$$.fragment,e),r(B.$$.fragment,e),r(Z.$$.fragment,e),r(X.$$.fragment,e),r(x.$$.fragment,e),r(R.$$.fragment,e),r(N.$$.fragment,e),r(W.$$.fragment,e),r(A.$$.fragment,e),r(Q.$$.fragment,e),r(L.$$.fragment,e),r(H.$$.fragment,e),r(F.$$.fragment,e),r(P.$$.fragment,e),r(O.$$.fragment,e),r(ee.$$.fragment,e),r(te.$$.fragment,e),r(le.$$.fragment,e),r(ie.$$.fragment,e),r(ne.$$.fragment,e),r(ae.$$.fragment,e),et=!0)},o(e){c(T.$$.fragment,e),c(w.$$.fragment,e),c(J.$$.fragment,e),c(j.$$.fragment,e),c(b.$$.fragment,e),c(I.$$.fragment,e),c(G.$$.fragment,e),c(V.$$.fragment,e),c(B.$$.fragment,e),c(Z.$$.fragment,e),c(X.$$.fragment,e),c(x.$$.fragment,e),c(R.$$.fragment,e),c(N.$$.fragment,e),c(W.$$.fragment,e),c(A.$$.fragment,e),c(Q.$$.fragment,e),c(L.$$.fragment,e),c(H.$$.fragment,e),c(F.$$.fragment,e),c(P.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(ie.$$.fragment,e),c(ne.$$.fragment,e),c(ae.$$.fragment,e),et=!1},d(e){e&&(l(re),l(me),l(ce),l(oe),l(Me),l(ue),l(U),l(fe),l(ye),l(C),l(ge),l(he),l(v),l(de),l($e),l(_),l(Te),l(k),l(we),l(d),l(Je),l($),l(Ue),l(je),l(Ce),l(E),l(be),l(ve),l(Ie),l(S),l(_e),l(ke),l(Ge),l(Ve),l(Y),l(Ee),l(Be),l(Ze),l(z),l(Se),l(Xe),l(xe),l(Re),l(q),l(Ye),l(Ne),l(We),l(D),l(ze),l(Ae),l(Qe),l(K),l(Le),l(qe),l(He),l(Fe),l(se),l(De),l(Pe),l(Oe),l(Ke),l(pe)),l(g),o(T,e),o(w,e),o(J,e),o(j,e),o(b,e),o(I,e),o(G,e),o(V,e),o(B,e),o(Z,e),o(X,e),o(x,e),o(R,e),o(N,e),o(W,e),o(A,e),o(Q,e),o(L,e),o(H,e),o(F,e),o(P,e),o(O,e),o(ee,e),o(te,e),o(le,e),o(ie,e),o(ne,e),o(ae,e)}}}const It='{"title":"Adding a New Metric","local":"adding-a-new-metric","sections":[{"title":"Before You Start","local":"before-you-start","sections":[{"title":"Two different types of metrics","local":"two-different-types-of-metrics","sections":[{"title":"Sample-Level Metrics","local":"sample-level-metrics","sections":[],"depth":4},{"title":"Corpus-Level Metrics","local":"corpus-level-metrics","sections":[],"depth":4}],"depth":3},{"title":"Check Existing Metrics","local":"check-existing-metrics","sections":[],"depth":3}],"depth":2},{"title":"Creating a Custom Metric","local":"creating-a-custom-metric","sections":[{"title":"Step 1: Create the Metric File","local":"step-1-create-the-metric-file","sections":[],"depth":3},{"title":"Step 2: Define the Sample-Level Metric","local":"step-2-define-the-sample-level-metric","sections":[{"title":"Single Metric Example","local":"single-metric-example","sections":[],"depth":4},{"title":"Multiple Metrics Example","local":"multiple-metrics-example","sections":[],"depth":4}],"depth":3},{"title":"Step 3: Define Aggregation Function (Optional)","local":"step-3-define-aggregation-function-optional","sections":[],"depth":3},{"title":"Step 4: Create the Metric Object","local":"step-4-create-the-metric-object","sections":[{"title":"Single Metric","local":"single-metric","sections":[],"depth":4},{"title":"Multiple Metrics","local":"multiple-metrics","sections":[],"depth":4}],"depth":3},{"title":"Step 5: Register the Metric","local":"step-5-register-the-metric","sections":[],"depth":3}],"depth":2},{"title":"Using Your Custom Metric","local":"using-your-custom-metric","sections":[{"title":"With Custom Tasks","local":"with-custom-tasks","sections":[],"depth":3}],"depth":2}],"depth":1}';function _t(lt){return wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bt extends Jt{constructor(g){super(),Ut(this,g,_t,vt,$t,{})}}export{Bt as component};
