import{s as We,n as Ve,o as ke}from"../chunks/scheduler.5f3e6389.js";import{S as xe,i as Re,e as r,s as n,c as i,q as Ee,h as _e,a as d,d as t,b as a,f as pe,g as p,j as y,r as Ne,k as oe,l as ce,m as s,n as o,t as m,o as M,p as c}from"../chunks/index.373ab25c.js";import{C as T}from"../chunks/CodeBlock.9962115b.js";import{H as h,E as Qe}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.9be40644.js";function Ae(re){let u,dl,cl,yl,w,hl,U,de=`Lighteval allows you to evaluate custom model implementations by creating a custom model class that inherits from <code>LightevalModel</code>.
This is useful when you want to evaluate models that aren’t directly supported by the standard backends and providers (Transformers, VLLM, etc.), or
if you want to add your own pre/post-processing logic.`,ul,g,Tl,f,Jl,j,ye="Create a Python file containing your custom model implementation. The model must inherit from <code>LightevalModel</code> and implement all required methods.",wl,b,he="Here’s a basic example:",Ul,C,gl,I,fl,$,ue="The custom model file should contain exactly one class that inherits from <code>LightevalModel</code>. This class will be automatically detected and instantiated when loading the model.",jl,J,Te="<p>You can find a complete example of a custom model implementation in <code>examples/custom_models/google_translate_model.py</code>.</p>",bl,G,Cl,Z,Je="You can evaluate your custom model using either the command-line interface or the Python API.",Il,B,$l,v,Gl,W,we="The command takes three required arguments:",Zl,V,Ue="<li><strong>Model name</strong>: Used for tracking in results/logs</li> <li><strong>Model implementation file path</strong>: Path to your Python file containing the custom model</li> <li><strong>Tasks</strong>: Tasks to evaluate on (same format as other backends)</li>",Bl,k,vl,x,Wl,R,Vl,E,ge="Your custom model must implement these core methods:",kl,_,xl,N,fe="For generating text until a stop sequence or max tokens is reached. This is used for generative evaluations.",Rl,Q,El,A,_l,Y,je="For computing log probabilities of specific continuations. This is used for multiple choice logprob evaluations.",Nl,S,Ql,X,Al,z,be="For computing rolling log probabilities of sequences. This is used for perplexity metrics.",Yl,F,Sl,L,Ce="See the <code>LightevalModel</code> base class documentation for detailed method signatures and requirements.",Xl,H,zl,q,Ie=`Lighteval includes a caching system that can significantly speed up evaluations by storing and reusing model predictions.
To enable caching in your custom model:`,Fl,P,Ll,D,Hl,K,ql,O,Pl,ll,Ml,me,el,Dl,tl,$e='For detailed information about the caching system, see the <a href="caching">Caching Documentation</a>.',Kl,sl,Ol,nl,le,al,Ge="<li><strong>Import Errors</strong>: Ensure all required dependencies are installed</li> <li><strong>Method Signature Errors</strong>: Verify your methods match the expected signatures</li> <li><strong>Caching Issues</strong>: Check that cache decorators are applied correctly</li> <li><strong>Performance Issues</strong>: Consider implementing batching and caching</li>",ee,il,te,pl,Ze="<li>Use the <code>--max-samples</code> flag to test with a small dataset</li> <li>Enable detailed logging to see what’s happening</li> <li>Test individual methods in isolation</li> <li>Check the example implementations for reference</li>",se,ol,Be='For more detailed information about custom model implementation, see the <a href="package_reference/models">Model Reference</a>.',ne,ml,ae,rl,ie;return w=new h({props:{title:"Evaluating Custom Models",local:"evaluating-custom-models",headingTag:"h1"}}),g=new h({props:{title:"Creating a Custom Model",local:"creating-a-custom-model",headingTag:"h2"}}),f=new h({props:{title:"Step 1: Create Your Model Implementation",local:"step-1-create-your-model-implementation",headingTag:"h3"}}),C=new T({props:{code:"ZnJvbSUyMGxpZ2h0ZXZhbC5tb2RlbHMuYWJzdHJhY3RfbW9kZWwlMjBpbXBvcnQlMjBMaWdodGV2YWxNb2RlbCUwQWZyb20lMjBsaWdodGV2YWwubW9kZWxzLm1vZGVsX291dHB1dCUyMGltcG9ydCUyME1vZGVsUmVzcG9uc2UlMEFmcm9tJTIwbGlnaHRldmFsLnRhc2tzLnJlcXVlc3RzJTIwaW1wb3J0JTIwRG9jJTJDJTIwU2FtcGxpbmdNZXRob2QlMEFmcm9tJTIwbGlnaHRldmFsLnV0aWxzLmNhY2hlX21hbmFnZW1lbnQlMjBpbXBvcnQlMjBTYW1wbGVDYWNoZSUyQyUyMGNhY2hlZCUwQSUwQWNsYXNzJTIwTXlDdXN0b21Nb2RlbChMaWdodGV2YWxNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEluaXRpYWxpemUlMjB5b3VyJTIwbW9kZWwlMjBoZXJlLi4uJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRW5hYmxlJTIwY2FjaGluZyUyMChyZWNvbW1lbmRlZCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLl9jYWNoZSUyMCUzRCUyMFNhbXBsZUNhY2hlKGNvbmZpZyklMEElMEElMjAlMjAlMjAlMjAlNDBjYWNoZWQoU2FtcGxpbmdNZXRob2QuR0VORVJBVElWRSklMEElMjAlMjAlMjAlMjBkZWYlMjBncmVlZHlfdW50aWwoc2VsZiUyQyUyMGRvY3MlM0ElMjBMaXN0JTVCRG9jJTVEKSUyMC0lM0UlMjBMaXN0JTVCTW9kZWxSZXNwb25zZSU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEltcGxlbWVudCUyMGdlbmVyYXRpb24lMjBsb2dpYyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhc3MlMEElMEElMjAlMjAlMjAlMjAlNDBjYWNoZWQoU2FtcGxpbmdNZXRob2QuTE9HUFJPQlMpJTBBJTIwJTIwJTIwJTIwZGVmJTIwbG9nbGlrZWxpaG9vZChzZWxmJTJDJTIwZG9jcyUzQSUyMExpc3QlNUJEb2MlNUQpJTIwLSUzRSUyMExpc3QlNUJNb2RlbFJlc3BvbnNlJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwSW1wbGVtZW50JTIwbG9nbGlrZWxpaG9vZCUyMGNvbXB1dGF0aW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFzcyUwQSUwQSUyMCUyMCUyMCUyMCU0MGNhY2hlZChTYW1wbGluZ01ldGhvZC5QRVJQTEVYSVRZKSUwQSUyMCUyMCUyMCUyMGRlZiUyMGxvZ2xpa2VsaWhvb2Rfcm9sbGluZyhzZWxmJTJDJTIwZG9jcyUzQSUyMExpc3QlNUJEb2MlNUQpJTIwLSUzRSUyMExpc3QlNUJNb2RlbFJlc3BvbnNlJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwSW1wbGVtZW50JTIwcm9sbGluZyUyMGxvZ2xpa2VsaWhvb2QlMjBjb21wdXRhdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhc3M=",highlighted:`<span class="hljs-keyword">from</span> lighteval.models.abstract_model <span class="hljs-keyword">import</span> LightevalModel
<span class="hljs-keyword">from</span> lighteval.models.model_output <span class="hljs-keyword">import</span> ModelResponse
<span class="hljs-keyword">from</span> lighteval.tasks.requests <span class="hljs-keyword">import</span> Doc, SamplingMethod
<span class="hljs-keyword">from</span> lighteval.utils.cache_management <span class="hljs-keyword">import</span> SampleCache, cached

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyCustomModel</span>(<span class="hljs-title class_ inherited__">LightevalModel</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        <span class="hljs-comment"># Initialize your model here...</span>

        <span class="hljs-comment"># Enable caching (recommended)</span>
        self._cache = SampleCache(config)

<span class="hljs-meta">    @cached(<span class="hljs-params">SamplingMethod.GENERATIVE</span>)</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">greedy_until</span>(<span class="hljs-params">self, docs: <span class="hljs-type">List</span>[Doc]</span>) -&gt; <span class="hljs-type">List</span>[ModelResponse]:
        <span class="hljs-comment"># Implement generation logic</span>
        <span class="hljs-keyword">pass</span>

<span class="hljs-meta">    @cached(<span class="hljs-params">SamplingMethod.LOGPROBS</span>)</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">loglikelihood</span>(<span class="hljs-params">self, docs: <span class="hljs-type">List</span>[Doc]</span>) -&gt; <span class="hljs-type">List</span>[ModelResponse]:
        <span class="hljs-comment"># Implement loglikelihood computation</span>
        <span class="hljs-keyword">pass</span>

<span class="hljs-meta">    @cached(<span class="hljs-params">SamplingMethod.PERPLEXITY</span>)</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">loglikelihood_rolling</span>(<span class="hljs-params">self, docs: <span class="hljs-type">List</span>[Doc]</span>) -&gt; <span class="hljs-type">List</span>[ModelResponse]:
        <span class="hljs-comment"># Implement rolling loglikelihood computation</span>
        <span class="hljs-keyword">pass</span>`,wrap:!1}}),I=new h({props:{title:"Step 2: Model File Requirements",local:"step-2-model-file-requirements",headingTag:"h3"}}),G=new h({props:{title:"Running the Evaluation",local:"running-the-evaluation",headingTag:"h2"}}),B=new h({props:{title:"Using the Command Line",local:"using-the-command-line",headingTag:"h3"}}),v=new T({props:{code:"bGlnaHRldmFsJTIwY3VzdG9tJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlLXRyYW5zbGF0ZSUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMCUyMmV4YW1wbGVzJTJGY3VzdG9tX21vZGVscyUyRmdvb2dsZV90cmFuc2xhdGVfbW9kZWwucHklMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAlMjJsaWdodGV2YWwlN0N3bXQyMCUzQWZyLWRlJTdDMCUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWF4LXNhbXBsZXMlMjAxMA==",highlighted:`lighteval custom \\
    <span class="hljs-string">&quot;google-translate&quot;</span> \\
    <span class="hljs-string">&quot;examples/custom_models/google_translate_model.py&quot;</span> \\
    <span class="hljs-string">&quot;lighteval|wmt20:fr-de|0&quot;</span> \\
    --max-samples 10`,wrap:!1}}),k=new h({props:{title:"Using the Python API",local:"using-the-python-api",headingTag:"h3"}}),x=new T({props:{code:"ZnJvbSUyMGxpZ2h0ZXZhbC5sb2dnaW5nLmV2YWx1YXRpb25fdHJhY2tlciUyMGltcG9ydCUyMEV2YWx1YXRpb25UcmFja2VyJTBBZnJvbSUyMGxpZ2h0ZXZhbC5tb2RlbHMuY3VzdG9tLmN1c3RvbV9tb2RlbCUyMGltcG9ydCUyMEN1c3RvbU1vZGVsQ29uZmlnJTBBZnJvbSUyMGxpZ2h0ZXZhbC5waXBlbGluZSUyMGltcG9ydCUyMFBpcGVsaW5lJTJDJTIwUGlwZWxpbmVQYXJhbWV0ZXJzJTJDJTIwUGFyYWxsZWxpc21NYW5hZ2VyJTBBJTBBJTIzJTIwU2V0JTIwdXAlMjBldmFsdWF0aW9uJTIwdHJhY2tpbmclMEFldmFsdWF0aW9uX3RyYWNrZXIlMjAlM0QlMjBFdmFsdWF0aW9uVHJhY2tlciglMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEJTIycmVzdWx0cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfZGV0YWlscyUzRFRydWUlMEEpJTBBJTBBJTIzJTIwQ29uZmlndXJlJTIwdGhlJTIwcGlwZWxpbmUlMEFwaXBlbGluZV9wYXJhbXMlMjAlM0QlMjBQaXBlbGluZVBhcmFtZXRlcnMoJTBBJTIwJTIwJTIwJTIwbGF1bmNoZXJfdHlwZSUzRFBhcmFsbGVsaXNtTWFuYWdlci5DVVNUT00lMkMlMEEpJTBBJTBBJTIzJTIwQ29uZmlndXJlJTIweW91ciUyMGN1c3RvbSUyMG1vZGVsJTBBbW9kZWxfY29uZmlnJTIwJTNEJTIwQ3VzdG9tTW9kZWxDb25maWcoJTBBJTIwJTIwJTIwJTIwbW9kZWxfbmFtZSUzRCUyMm15LWN1c3RvbS1tb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2RlZmluaXRpb25fZmlsZV9wYXRoJTNEJTIycGF0aCUyRnRvJTJGbXlfbW9kZWwucHklMjIlMEEpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwYW5kJTIwcnVuJTIwdGhlJTIwcGlwZWxpbmUlMEFwaXBlbGluZSUyMCUzRCUyMFBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHRhc2tzJTNEJTIybGVhZGVyYm9hcmQlN0N0cnV0aGZ1bHFhJTNBbWMlN0MwJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmVfcGFyYW1ldGVycyUzRHBpcGVsaW5lX3BhcmFtcyUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fdHJhY2tlciUzRGV2YWx1YXRpb25fdHJhY2tlciUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2NvbmZpZyUzRG1vZGVsX2NvbmZpZyUwQSklMEElMEFwaXBlbGluZS5ldmFsdWF0ZSgpJTBBcGlwZWxpbmUuc2F2ZV9hbmRfcHVzaF9yZXN1bHRzKCk=",highlighted:`<span class="hljs-keyword">from</span> lighteval.logging.evaluation_tracker <span class="hljs-keyword">import</span> EvaluationTracker
<span class="hljs-keyword">from</span> lighteval.models.custom.custom_model <span class="hljs-keyword">import</span> CustomModelConfig
<span class="hljs-keyword">from</span> lighteval.pipeline <span class="hljs-keyword">import</span> Pipeline, PipelineParameters, ParallelismManager

<span class="hljs-comment"># Set up evaluation tracking</span>
evaluation_tracker = EvaluationTracker(
    output_dir=<span class="hljs-string">&quot;results&quot;</span>,
    save_details=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># Configure the pipeline</span>
pipeline_params = PipelineParameters(
    launcher_type=ParallelismManager.CUSTOM,
)

<span class="hljs-comment"># Configure your custom model</span>
model_config = CustomModelConfig(
    model_name=<span class="hljs-string">&quot;my-custom-model&quot;</span>,
    model_definition_file_path=<span class="hljs-string">&quot;path/to/my_model.py&quot;</span>
)

<span class="hljs-comment"># Create and run the pipeline</span>
pipeline = Pipeline(
    tasks=<span class="hljs-string">&quot;leaderboard|truthfulqa:mc|0&quot;</span>,
    pipeline_parameters=pipeline_params,
    evaluation_tracker=evaluation_tracker,
    model_config=model_config
)

pipeline.evaluate()
pipeline.save_and_push_results()`,wrap:!1}}),R=new h({props:{title:"Required Methods",local:"required-methods",headingTag:"h2"}}),_=new h({props:{title:"greedy_until",local:"greedyuntil",headingTag:"h3"}}),Q=new T({props:{code:"ZGVmJTIwZ3JlZWR5X3VudGlsKHNlbGYlMkMlMjBkb2NzJTNBJTIwbGlzdCU1QkRvYyU1RCklMjAtJTNFJTIwbGlzdCU1Qk1vZGVsUmVzcG9uc2UlNUQlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBHZW5lcmF0ZSUyMHRleHQlMjB1bnRpbCUyMHN0b3AlMjBzZXF1ZW5jZSUyMG9yJTIwbWF4JTIwdG9rZW5zLiUwQSUwQSUyMCUyMCUyMCUyMEFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkb2NzJTNBJTIwbGlzdCUyMG9mJTIwZG9jdW1lbnRzJTIwY29udGFpbmluZyUyMHByb21wdHMlMjBhbmQlMjBnZW5lcmF0aW9uJTIwcGFyYW1ldGVycyUwQSUwQSUyMCUyMCUyMCUyMFJldHVybnMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsaXN0JTIwb2YlMjBtb2RlbCUyMHJlc3BvbnNlcyUyMHdpdGglMjBnZW5lcmF0ZWQlMjB0ZXh0JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcGFzcw==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">greedy_until</span>(<span class="hljs-params">self, docs: <span class="hljs-built_in">list</span>[Doc]</span>) -&gt; <span class="hljs-built_in">list</span>[ModelResponse]:
    <span class="hljs-string">&quot;&quot;&quot;
    Generate text until stop sequence or max tokens.

    Args:
        docs: list of documents containing prompts and generation parameters

    Returns:
        list of model responses with generated text
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),A=new h({props:{title:"loglikelihood",local:"loglikelihood",headingTag:"h3"}}),S=new T({props:{code:"ZGVmJTIwbG9nbGlrZWxpaG9vZChzZWxmJTJDJTIwZG9jcyUzQSUyMGxpc3QlNUJEb2MlNUQpJTIwLSUzRSUyMGxpc3QlNUJNb2RlbFJlc3BvbnNlJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwQ29tcHV0ZSUyMGxvZyUyMHByb2JhYmlsaXRpZXMlMjBvZiUyMGNvbnRpbnVhdGlvbnMuJTBBJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRvY3MlM0ElMjBsaXN0JTIwb2YlMjBkb2N1bWVudHMlMjBjb250YWluaW5nJTIwY29udGV4dCUyMGFuZCUyMGNvbnRpbnVhdGlvbiUyMHBhaXJzJTBBJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxpc3QlMjBvZiUyMG1vZGVsJTIwcmVzcG9uc2VzJTIwd2l0aCUyMGxvZyUyMHByb2JhYmlsaXRpZXMlMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBwYXNz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">loglikelihood</span>(<span class="hljs-params">self, docs: <span class="hljs-built_in">list</span>[Doc]</span>) -&gt; <span class="hljs-built_in">list</span>[ModelResponse]:
    <span class="hljs-string">&quot;&quot;&quot;
    Compute log probabilities of continuations.

    Args:
        docs: list of documents containing context and continuation pairs

    Returns:
        list of model responses with log probabilities
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),X=new h({props:{title:"loglikelihood_rolling",local:"loglikelihoodrolling",headingTag:"h3"}}),F=new T({props:{code:"ZGVmJTIwbG9nbGlrZWxpaG9vZF9yb2xsaW5nKHNlbGYlMkMlMjBkb2NzJTNBJTIwbGlzdCU1QkRvYyU1RCklMjAtJTNFJTIwbGlzdCU1Qk1vZGVsUmVzcG9uc2UlNUQlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBDb21wdXRlJTIwcm9sbGluZyUyMGxvZyUyMHByb2JhYmlsaXRpZXMlMjBvZiUyMHNlcXVlbmNlcy4lMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG9jcyUzQSUyMGxpc3QlMjBvZiUyMGRvY3VtZW50cyUyMGNvbnRhaW5pbmclMjB0ZXh0JTIwc2VxdWVuY2VzJTBBJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxpc3QlMjBvZiUyMG1vZGVsJTIwcmVzcG9uc2VzJTIwd2l0aCUyMHJvbGxpbmclMjBsb2clMjBwcm9iYWJpbGl0aWVzJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcGFzcw==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">loglikelihood_rolling</span>(<span class="hljs-params">self, docs: <span class="hljs-built_in">list</span>[Doc]</span>) -&gt; <span class="hljs-built_in">list</span>[ModelResponse]:
    <span class="hljs-string">&quot;&quot;&quot;
    Compute rolling log probabilities of sequences.

    Args:
        docs: list of documents containing text sequences

    Returns:
        list of model responses with rolling log probabilities
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),H=new h({props:{title:"Enabling Caching (Recommended)",local:"enabling-caching-recommended",headingTag:"h2"}}),P=new h({props:{title:"Step 1: Import Caching Components",local:"step-1-import-caching-components",headingTag:"h3"}}),D=new T({props:{code:"ZnJvbSUyMGxpZ2h0ZXZhbC51dGlscy5jYWNoZV9tYW5hZ2VtZW50JTIwaW1wb3J0JTIwU2FtcGxlQ2FjaGUlMkMlMjBjYWNoZWQ=",highlighted:'<span class="hljs-keyword">from</span> lighteval.utils.cache_management <span class="hljs-keyword">import</span> SampleCache, cached',wrap:!1}}),K=new h({props:{title:"Step 2: Initialize Cache in Constructor",local:"step-2-initialize-cache-in-constructor",headingTag:"h3"}}),O=new T({props:{code:"ZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjMlMjBZb3VyJTIwaW5pdGlhbGl6YXRpb24lMjBjb2RlLi4uJTBBJTIwJTIwJTIwJTIwc2VsZi5fY2FjaGUlMjAlM0QlMjBTYW1wbGVDYWNoZShjb25maWcp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
    <span class="hljs-built_in">super</span>().__init__(config)
    <span class="hljs-comment"># Your initialization code...</span>
    self._cache = SampleCache(config)`,wrap:!1}}),el=new T({props:{code:"JTQwY2FjaGVkKFNhbXBsaW5nTWV0aG9kLkdFTkVSQVRJVkUpJTBBZGVmJTIwZ3JlZWR5X3VudGlsKHNlbGYlMkMlMjBkb2NzJTNBJTIwTGlzdCU1QkRvYyU1RCklMjAtJTNFJTIwTGlzdCU1Qk1vZGVsUmVzcG9uc2UlNUQlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBZb3VyJTIwaW1wbGVtZW50YXRpb24uLi4=",highlighted:`<span class="hljs-meta">@cached(<span class="hljs-params">SamplingMethod.GENERATIVE</span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">greedy_until</span>(<span class="hljs-params">self, docs: <span class="hljs-type">List</span>[Doc]</span>) -&gt; <span class="hljs-type">List</span>[ModelResponse]:
    <span class="hljs-comment"># Your implementation...</span>`,wrap:!1}}),sl=new h({props:{title:"Troubleshooting",local:"troubleshooting",headingTag:"h2"}}),nl=new h({props:{title:"Common Issues",local:"common-issues",headingTag:"h3"}}),il=new h({props:{title:"Debugging Tips",local:"debugging-tips",headingTag:"h3"}}),ml=new Qe({props:{source:"https://github.com/huggingface/lighteval/blob/main/docs/source/evaluating-a-custom-model.mdx"}}),{c(){u=r("meta"),dl=n(),cl=r("p"),yl=n(),i(w.$$.fragment),hl=n(),U=r("p"),U.innerHTML=de,ul=n(),i(g.$$.fragment),Tl=n(),i(f.$$.fragment),Jl=n(),j=r("p"),j.innerHTML=ye,wl=n(),b=r("p"),b.textContent=he,Ul=n(),i(C.$$.fragment),gl=n(),i(I.$$.fragment),fl=n(),$=r("p"),$.innerHTML=ue,jl=n(),J=r("blockquote"),J.innerHTML=Te,bl=n(),i(G.$$.fragment),Cl=n(),Z=r("p"),Z.textContent=Je,Il=n(),i(B.$$.fragment),$l=n(),i(v.$$.fragment),Gl=n(),W=r("p"),W.textContent=we,Zl=n(),V=r("ul"),V.innerHTML=Ue,Bl=n(),i(k.$$.fragment),vl=n(),i(x.$$.fragment),Wl=n(),i(R.$$.fragment),Vl=n(),E=r("p"),E.textContent=ge,kl=n(),i(_.$$.fragment),xl=n(),N=r("p"),N.textContent=fe,Rl=n(),i(Q.$$.fragment),El=n(),i(A.$$.fragment),_l=n(),Y=r("p"),Y.textContent=je,Nl=n(),i(S.$$.fragment),Ql=n(),i(X.$$.fragment),Al=n(),z=r("p"),z.textContent=be,Yl=n(),i(F.$$.fragment),Sl=n(),L=r("p"),L.innerHTML=Ce,Xl=n(),i(H.$$.fragment),zl=n(),q=r("p"),q.textContent=Ie,Fl=n(),i(P.$$.fragment),Ll=n(),i(D.$$.fragment),Hl=n(),i(K.$$.fragment),ql=n(),i(O.$$.fragment),Pl=n(),ll=r("ol"),Ml=r("li"),me=Ee(`Add cache decorators to your prediction methods:
	`),i(el.$$.fragment),Dl=n(),tl=r("p"),tl.innerHTML=$e,Kl=n(),i(sl.$$.fragment),Ol=n(),i(nl.$$.fragment),le=n(),al=r("ol"),al.innerHTML=Ge,ee=n(),i(il.$$.fragment),te=n(),pl=r("ul"),pl.innerHTML=Ze,se=n(),ol=r("p"),ol.innerHTML=Be,ne=n(),i(ml.$$.fragment),ae=n(),rl=r("p"),this.h()},l(l){const e=_e("svelte-u9bgzb",document.head);u=d(e,"META",{name:!0,content:!0}),e.forEach(t),dl=a(l),cl=d(l,"P",{}),pe(cl).forEach(t),yl=a(l),p(w.$$.fragment,l),hl=a(l),U=d(l,"P",{"data-svelte-h":!0}),y(U)!=="svelte-15yahec"&&(U.innerHTML=de),ul=a(l),p(g.$$.fragment,l),Tl=a(l),p(f.$$.fragment,l),Jl=a(l),j=d(l,"P",{"data-svelte-h":!0}),y(j)!=="svelte-64btiy"&&(j.innerHTML=ye),wl=a(l),b=d(l,"P",{"data-svelte-h":!0}),y(b)!=="svelte-1frc3d"&&(b.textContent=he),Ul=a(l),p(C.$$.fragment,l),gl=a(l),p(I.$$.fragment,l),fl=a(l),$=d(l,"P",{"data-svelte-h":!0}),y($)!=="svelte-4gi028"&&($.innerHTML=ue),jl=a(l),J=d(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),y(J)!=="svelte-1m7vrvf"&&(J.innerHTML=Te),bl=a(l),p(G.$$.fragment,l),Cl=a(l),Z=d(l,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-md1ogy"&&(Z.textContent=Je),Il=a(l),p(B.$$.fragment,l),$l=a(l),p(v.$$.fragment,l),Gl=a(l),W=d(l,"P",{"data-svelte-h":!0}),y(W)!=="svelte-9ha93v"&&(W.textContent=we),Zl=a(l),V=d(l,"UL",{"data-svelte-h":!0}),y(V)!=="svelte-7oyst4"&&(V.innerHTML=Ue),Bl=a(l),p(k.$$.fragment,l),vl=a(l),p(x.$$.fragment,l),Wl=a(l),p(R.$$.fragment,l),Vl=a(l),E=d(l,"P",{"data-svelte-h":!0}),y(E)!=="svelte-abp4ax"&&(E.textContent=ge),kl=a(l),p(_.$$.fragment,l),xl=a(l),N=d(l,"P",{"data-svelte-h":!0}),y(N)!=="svelte-1nk29lo"&&(N.textContent=fe),Rl=a(l),p(Q.$$.fragment,l),El=a(l),p(A.$$.fragment,l),_l=a(l),Y=d(l,"P",{"data-svelte-h":!0}),y(Y)!=="svelte-1bufz8k"&&(Y.textContent=je),Nl=a(l),p(S.$$.fragment,l),Ql=a(l),p(X.$$.fragment,l),Al=a(l),z=d(l,"P",{"data-svelte-h":!0}),y(z)!=="svelte-dqj7yp"&&(z.textContent=be),Yl=a(l),p(F.$$.fragment,l),Sl=a(l),L=d(l,"P",{"data-svelte-h":!0}),y(L)!=="svelte-845vib"&&(L.innerHTML=Ce),Xl=a(l),p(H.$$.fragment,l),zl=a(l),q=d(l,"P",{"data-svelte-h":!0}),y(q)!=="svelte-1eshig5"&&(q.textContent=Ie),Fl=a(l),p(P.$$.fragment,l),Ll=a(l),p(D.$$.fragment,l),Hl=a(l),p(K.$$.fragment,l),ql=a(l),p(O.$$.fragment,l),Pl=a(l),ll=d(l,"OL",{start:!0});var ve=pe(ll);Ml=d(ve,"LI",{});var Me=pe(Ml);me=Ne(Me,`Add cache decorators to your prediction methods:
	`),p(el.$$.fragment,Me),Me.forEach(t),ve.forEach(t),Dl=a(l),tl=d(l,"P",{"data-svelte-h":!0}),y(tl)!=="svelte-eqax9m"&&(tl.innerHTML=$e),Kl=a(l),p(sl.$$.fragment,l),Ol=a(l),p(nl.$$.fragment,l),le=a(l),al=d(l,"OL",{"data-svelte-h":!0}),y(al)!=="svelte-hifd4u"&&(al.innerHTML=Ge),ee=a(l),p(il.$$.fragment,l),te=a(l),pl=d(l,"UL",{"data-svelte-h":!0}),y(pl)!=="svelte-1g8hpki"&&(pl.innerHTML=Ze),se=a(l),ol=d(l,"P",{"data-svelte-h":!0}),y(ol)!=="svelte-15nhhnt"&&(ol.innerHTML=Be),ne=a(l),p(ml.$$.fragment,l),ae=a(l),rl=d(l,"P",{}),pe(rl).forEach(t),this.h()},h(){oe(u,"name","hf:doc:metadata"),oe(u,"content",Ye),oe(J,"class","tip"),oe(ll,"start","3")},m(l,e){ce(document.head,u),s(l,dl,e),s(l,cl,e),s(l,yl,e),o(w,l,e),s(l,hl,e),s(l,U,e),s(l,ul,e),o(g,l,e),s(l,Tl,e),o(f,l,e),s(l,Jl,e),s(l,j,e),s(l,wl,e),s(l,b,e),s(l,Ul,e),o(C,l,e),s(l,gl,e),o(I,l,e),s(l,fl,e),s(l,$,e),s(l,jl,e),s(l,J,e),s(l,bl,e),o(G,l,e),s(l,Cl,e),s(l,Z,e),s(l,Il,e),o(B,l,e),s(l,$l,e),o(v,l,e),s(l,Gl,e),s(l,W,e),s(l,Zl,e),s(l,V,e),s(l,Bl,e),o(k,l,e),s(l,vl,e),o(x,l,e),s(l,Wl,e),o(R,l,e),s(l,Vl,e),s(l,E,e),s(l,kl,e),o(_,l,e),s(l,xl,e),s(l,N,e),s(l,Rl,e),o(Q,l,e),s(l,El,e),o(A,l,e),s(l,_l,e),s(l,Y,e),s(l,Nl,e),o(S,l,e),s(l,Ql,e),o(X,l,e),s(l,Al,e),s(l,z,e),s(l,Yl,e),o(F,l,e),s(l,Sl,e),s(l,L,e),s(l,Xl,e),o(H,l,e),s(l,zl,e),s(l,q,e),s(l,Fl,e),o(P,l,e),s(l,Ll,e),o(D,l,e),s(l,Hl,e),o(K,l,e),s(l,ql,e),o(O,l,e),s(l,Pl,e),s(l,ll,e),ce(ll,Ml),ce(Ml,me),o(el,Ml,null),s(l,Dl,e),s(l,tl,e),s(l,Kl,e),o(sl,l,e),s(l,Ol,e),o(nl,l,e),s(l,le,e),s(l,al,e),s(l,ee,e),o(il,l,e),s(l,te,e),s(l,pl,e),s(l,se,e),s(l,ol,e),s(l,ne,e),o(ml,l,e),s(l,ae,e),s(l,rl,e),ie=!0},p:Ve,i(l){ie||(m(w.$$.fragment,l),m(g.$$.fragment,l),m(f.$$.fragment,l),m(C.$$.fragment,l),m(I.$$.fragment,l),m(G.$$.fragment,l),m(B.$$.fragment,l),m(v.$$.fragment,l),m(k.$$.fragment,l),m(x.$$.fragment,l),m(R.$$.fragment,l),m(_.$$.fragment,l),m(Q.$$.fragment,l),m(A.$$.fragment,l),m(S.$$.fragment,l),m(X.$$.fragment,l),m(F.$$.fragment,l),m(H.$$.fragment,l),m(P.$$.fragment,l),m(D.$$.fragment,l),m(K.$$.fragment,l),m(O.$$.fragment,l),m(el.$$.fragment,l),m(sl.$$.fragment,l),m(nl.$$.fragment,l),m(il.$$.fragment,l),m(ml.$$.fragment,l),ie=!0)},o(l){M(w.$$.fragment,l),M(g.$$.fragment,l),M(f.$$.fragment,l),M(C.$$.fragment,l),M(I.$$.fragment,l),M(G.$$.fragment,l),M(B.$$.fragment,l),M(v.$$.fragment,l),M(k.$$.fragment,l),M(x.$$.fragment,l),M(R.$$.fragment,l),M(_.$$.fragment,l),M(Q.$$.fragment,l),M(A.$$.fragment,l),M(S.$$.fragment,l),M(X.$$.fragment,l),M(F.$$.fragment,l),M(H.$$.fragment,l),M(P.$$.fragment,l),M(D.$$.fragment,l),M(K.$$.fragment,l),M(O.$$.fragment,l),M(el.$$.fragment,l),M(sl.$$.fragment,l),M(nl.$$.fragment,l),M(il.$$.fragment,l),M(ml.$$.fragment,l),ie=!1},d(l){l&&(t(dl),t(cl),t(yl),t(hl),t(U),t(ul),t(Tl),t(Jl),t(j),t(wl),t(b),t(Ul),t(gl),t(fl),t($),t(jl),t(J),t(bl),t(Cl),t(Z),t(Il),t($l),t(Gl),t(W),t(Zl),t(V),t(Bl),t(vl),t(Wl),t(Vl),t(E),t(kl),t(xl),t(N),t(Rl),t(El),t(_l),t(Y),t(Nl),t(Ql),t(Al),t(z),t(Yl),t(Sl),t(L),t(Xl),t(zl),t(q),t(Fl),t(Ll),t(Hl),t(ql),t(Pl),t(ll),t(Dl),t(tl),t(Kl),t(Ol),t(le),t(al),t(ee),t(te),t(pl),t(se),t(ol),t(ne),t(ae),t(rl)),t(u),c(w,l),c(g,l),c(f,l),c(C,l),c(I,l),c(G,l),c(B,l),c(v,l),c(k,l),c(x,l),c(R,l),c(_,l),c(Q,l),c(A,l),c(S,l),c(X,l),c(F,l),c(H,l),c(P,l),c(D,l),c(K,l),c(O,l),c(el),c(sl,l),c(nl,l),c(il,l),c(ml,l)}}}const Ye='{"title":"Evaluating Custom Models","local":"evaluating-custom-models","sections":[{"title":"Creating a Custom Model","local":"creating-a-custom-model","sections":[{"title":"Step 1: Create Your Model Implementation","local":"step-1-create-your-model-implementation","sections":[],"depth":3},{"title":"Step 2: Model File Requirements","local":"step-2-model-file-requirements","sections":[],"depth":3}],"depth":2},{"title":"Running the Evaluation","local":"running-the-evaluation","sections":[{"title":"Using the Command Line","local":"using-the-command-line","sections":[],"depth":3},{"title":"Using the Python API","local":"using-the-python-api","sections":[],"depth":3}],"depth":2},{"title":"Required Methods","local":"required-methods","sections":[{"title":"greedy_until","local":"greedyuntil","sections":[],"depth":3},{"title":"loglikelihood","local":"loglikelihood","sections":[],"depth":3},{"title":"loglikelihood_rolling","local":"loglikelihoodrolling","sections":[],"depth":3}],"depth":2},{"title":"Enabling Caching (Recommended)","local":"enabling-caching-recommended","sections":[{"title":"Step 1: Import Caching Components","local":"step-1-import-caching-components","sections":[],"depth":3},{"title":"Step 2: Initialize Cache in Constructor","local":"step-2-initialize-cache-in-constructor","sections":[],"depth":3}],"depth":2},{"title":"Troubleshooting","local":"troubleshooting","sections":[{"title":"Common Issues","local":"common-issues","sections":[],"depth":3},{"title":"Debugging Tips","local":"debugging-tips","sections":[],"depth":3}],"depth":2}],"depth":1}';function Se(re){return ke(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class He extends xe{constructor(u){super(),Re(this,u,Se,Ae,We,{})}}export{He as component};
