import{s as dt,y as ft,o as ut}from"../chunks/scheduler.d6170356.js";import{S as gt,i as wt,g as n,s as l,r as c,A as Mt,h as o,f as s,c as i,j as Ye,u as m,x as r,k as M,y as yt,a,v as h,d,t as f,w as u,m as bt,n as Tt}from"../chunks/index.fcd4cc08.js";import{T as jt}from"../chunks/Tip.b09c67cf.js";import{C as ae}from"../chunks/CodeBlock.7b16bdef.js";import{H as te,E as Jt}from"../chunks/EditOnGithub.da2b595c.js";function $t(le){let p;return{c(){p=bt("Only port 8501 is allowed for Streamlit Spaces (default port). As a result if you provide a `config.toml` file for your Space make sure the default port is not overriden.")},l(w){p=Tt(w,"Only port 8501 is allowed for Streamlit Spaces (default port). As a result if you provide a `config.toml` file for your Space make sure the default port is not overriden.")},m(w,T){a(w,p,T)},d(w){w&&s(p)}}}function St(le){let p,w,T,ie,j,ne,J,Ee='<strong>Streamlit</strong> gives users freedom to build a full-featured web app with Python in a <em>reactive</em> way. Your code is rerun each time the state of the app changes. Streamlit is also great for data visualization and supports several charting libraries such as Bokeh, Plotly, and Altair. Read this <a href="https://huggingface.co/blog/streamlit-spaces" rel="nofollow">blog post</a> about building and hosting Streamlit apps in Spaces.',oe,$,qe='Selecting <strong>Streamlit</strong> as the SDK when <a href="https://huggingface.co/new-space" rel="nofollow">creating a new Space</a> will initialize your Space with the latest version of Streamlit by setting the <code>sdk</code> property to <code>streamlit</code> in your <code>README.md</code> file’s YAML block. If you’d like to change the Streamlit version, you can edit the <code>sdk_version</code> property.',re,S,Fe='To use Streamlit in a Space, select <strong>Streamlit</strong> as the SDK when you create a Space through the <a href="https://huggingface.co/new-space" rel="nofollow"><strong>New Space</strong> form</a>. This will create a repository with a <code>README.md</code> that contains the following properties in the YAML configuration block:',pe,v,ce,U,Ae='You can edit the <code>sdk_version</code>, but note that issues may occur when you use an unsupported Streamlit version. Not all Streamlit versions are supported, so please refer to the <a href="./spaces-config-reference">reference section</a> to see which versions are available.',me,I,Pe='For in-depth information about Streamlit, refer to the <a href="https://docs.streamlit.io/" rel="nofollow">Streamlit documentation</a>.',he,y,de,Z,fe,B,Xe='In the following sections, you’ll learn the basics of creating a Space, configuring it, and deploying your code to it. We’ll create a <strong>Hot Dog Classifier</strong> Space with Streamlit that’ll be used to demo the <a href="https://huggingface.co/julien-c/hotdog-not-hotdog" rel="nofollow">julien-c/hotdog-not-hotdog</a> model, which can detect whether a given picture contains a hot dog 🌭',ue,k,De='You can find a completed version of this hosted at <a href="https://huggingface.co/spaces/NimaBoscarino/hotdog-streamlit" rel="nofollow">NimaBoscarino/hotdog-streamlit</a>.',ge,W,we,H,Ve='We’ll start by <a href="https://huggingface.co/new-space" rel="nofollow">creating a brand new Space</a> and choosing <strong>Streamlit</strong> as our SDK. Hugging Face Spaces are Git repositories, meaning that you can work on your Space incrementally (and collaboratively) by pushing commits. Take a look at the <a href="./repositories-getting-started">Getting Started with Repositories</a> guide to learn about how you can create and edit files before continuing.',Me,L,ye,_,Ke='For the <strong>Hot Dog Classifier</strong> we’ll be using a <a href="https://huggingface.co/docs/transformers/pipeline_tutorial" rel="nofollow">🤗 Transformers pipeline</a> to use the model, so we need to start by installing a few dependencies. This can be done by creating a <strong>requirements.txt</strong> file in our repository, and adding the following dependencies to it:',be,C,Te,z,Oe="The Spaces runtime will handle installing the dependencies!",je,x,Je,N,et="To create the Streamlit app, make a new file in the repository called <strong>app.py</strong>, and add the following code:",$e,R,Se,Q,tt='This Python script uses a <a href="https://huggingface.co/docs/transformers/pipeline_tutorial" rel="nofollow">🤗 Transformers pipeline</a> to load the <a href="https://huggingface.co/julien-c/hotdog-not-hotdog" rel="nofollow">julien-c/hotdog-not-hotdog</a> model, which is used by the Streamlit interface. The Streamlit app will expect you to upload an image, which it’ll then classify as <em>hot dog</em> or <em>not hot dog</em>. Once you’ve saved the code to the <strong>app.py</strong> file, visit the <strong>App</strong> tab to see your app in action!',ve,b,st='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/spaces-hot-dog-streamlit.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/spaces-hot-dog-streamlit-dark.png"/>',Ue,G,Ie,Y,at="You can use the HTML <code>&lt;iframe&gt;</code> tag to embed a Streamlit Space as an inline frame on other webpages. Simply include the URL of your Space, ending with the <code>.hf.space</code> suffix. To find the URL of your Space, you can use the “Embed this Space” button from the Spaces options.",Ze,E,lt="For example, the demo above can be embedded in these docs with the following tag:",Be,q,ke,g,it,We,F,nt="Please note that we have added <code>?embed=true</code> to the URL, which activates the embed mode of the Streamlit app, removing some spacers and the footer for slim embeds.",He,A,Le,P,ot='Streamlit has supported automatic iframe resizing since <a href="https://docs.streamlit.io/library/changelog#version-1170" rel="nofollow">1.17.0</a> so that the size of the parent iframe is automatically adjusted to fit the content volume of the embedded Streamlit application.',_e,X,rt='It relies on the <a href="https://github.com/davidjbradshaw/iframe-resizer" rel="nofollow"><code>iFrame Resizer</code></a> library, for which you need to add a few lines of code, as in the following example where',Ce,D,pt="<li><code>id</code> is set to <code>&lt;iframe /&gt;</code> that is used to specify the auto-resize target.</li> <li>The <code>iFrame Resizer</code> is loaded via the <code>script</code> tag.</li> <li>The <code>iFrameResize()</code> function is called with the ID of the target <code>iframe</code> element, so that its size changes automatically.</li>",ze,V,ct='We can pass options to the first argument of <code>iFrameResize()</code>. See <a href="https://github.com/davidjbradshaw/iframe-resizer/blob/master/docs/parent_page/options.md" rel="nofollow">the document</a> for the details.',xe,K,Ne,O,mt='Additionally, you can checkout <a href="./spaces-embed">our documentation</a>.',Re,ee,Qe,se,Ge;return j=new te({props:{title:"Streamlit Spaces",local:"streamlit-spaces",headingTag:"h1"}}),v=new ae({props:{code:"c2RrJTNBJTIwc3RyZWFtbGl0JTBBc2RrX3ZlcnNpb24lM0ElMjAxLjI1LjAlMjAlMjMlMjBUaGUlMjBsYXRlc3QlMjBzdXBwb3J0ZWQlMjB2ZXJzaW9u",highlighted:`<span class="hljs-attr">sdk:</span> <span class="hljs-string">streamlit</span>
<span class="hljs-attr">sdk_version:</span> <span class="hljs-number">1.25</span><span class="hljs-number">.0</span> <span class="hljs-comment"># The latest supported version</span>`,wrap:!1}}),y=new jt({props:{warning:!0,$$slots:{default:[$t]},$$scope:{ctx:le}}}),Z=new te({props:{title:"Your First Streamlit Space: Hot Dog Classifier",local:"your-first-streamlit-space-hot-dog-classifier",headingTag:"h2"}}),W=new te({props:{title:"Create a new Streamlit Space",local:"create-a-new-streamlit-space",headingTag:"h2"}}),L=new te({props:{title:"Add the dependencies",local:"add-the-dependencies",headingTag:"h2"}}),C=new ae({props:{code:"dHJhbnNmb3JtZXJzJTBBdG9yY2g=",highlighted:`<span class="hljs-attribute">transformers
torch</span>`,wrap:!1}}),x=new te({props:{title:"Create the Streamlit app",local:"create-the-streamlit-app",headingTag:"h2"}}),R=new ae({props:{code:"aW1wb3J0JTIwc3RyZWFtbGl0JTIwYXMlMjBzdCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmltYWdlLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJqdWxpZW4tYyUyRmhvdGRvZy1ub3QtaG90ZG9nJTIyKSUwQSUwQXN0LnRpdGxlKCUyMkhvdCUyMERvZyUzRiUyME9yJTIwTm90JTNGJTIyKSUwQSUwQWZpbGVfbmFtZSUyMCUzRCUyMHN0LmZpbGVfdXBsb2FkZXIoJTIyVXBsb2FkJTIwYSUyMGhvdCUyMGRvZyUyMGNhbmRpZGF0ZSUyMGltYWdlJTIyKSUwQSUwQWlmJTIwZmlsZV9uYW1lJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwY29sMSUyQyUyMGNvbDIlMjAlM0QlMjBzdC5jb2x1bW5zKDIpJTBBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKGZpbGVfbmFtZSklMEElMjAlMjAlMjAlMjBjb2wxLmltYWdlKGltYWdlJTJDJTIwdXNlX2NvbHVtbl93aWR0aCUzRFRydWUpJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBwaXBlbGluZShpbWFnZSklMEElMEElMjAlMjAlMjAlMjBjb2wyLmhlYWRlciglMjJQcm9iYWJpbGl0aWVzJTIyKSUwQSUyMCUyMCUyMCUyMGZvciUyMHAlMjBpbiUyMHByZWRpY3Rpb25zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29sMi5zdWJoZWFkZXIoZiUyMiU3QiUyMHAlNUInbGFiZWwnJTVEJTIwJTdEJTNBJTIwJTdCJTIwcm91bmQocCU1QidzY29yZSclNUQlMjAqJTIwMTAwJTJDJTIwMSklN0QlMjUlMjIp",highlighted:`<span class="hljs-keyword">import</span> streamlit <span class="hljs-keyword">as</span> st
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

pipeline = pipeline(task=<span class="hljs-string">&quot;image-classification&quot;</span>, model=<span class="hljs-string">&quot;julien-c/hotdog-not-hotdog&quot;</span>)

st.title(<span class="hljs-string">&quot;Hot Dog? Or Not?&quot;</span>)

file_name = st.file_uploader(<span class="hljs-string">&quot;Upload a hot dog candidate image&quot;</span>)

<span class="hljs-keyword">if</span> file_name <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    col1, col2 = st.columns(<span class="hljs-number">2</span>)

    image = Image.<span class="hljs-built_in">open</span>(file_name)
    col1.image(image, use_column_width=<span class="hljs-literal">True</span>)
    predictions = pipeline(image)

    col2.header(<span class="hljs-string">&quot;Probabilities&quot;</span>)
    <span class="hljs-keyword">for</span> p <span class="hljs-keyword">in</span> predictions:
        col2.subheader(<span class="hljs-string">f&quot;<span class="hljs-subst">{ p[<span class="hljs-string">&#x27;label&#x27;</span>] }</span>: <span class="hljs-subst">{ <span class="hljs-built_in">round</span>(p[<span class="hljs-string">&#x27;score&#x27;</span>] * <span class="hljs-number">100</span>, <span class="hljs-number">1</span>)}</span>%&quot;</span>)`,wrap:!1}}),G=new te({props:{title:"Embed Streamlit Spaces on other webpages",local:"embed-streamlit-spaces-on-other-webpages",headingTag:"h2"}}),q=new ae({props:{code:"JTNDaWZyYW1lJTBBJTIwJTIwc3JjJTNEJTIyaHR0cHMlM0ElMkYlMkZOaW1hQm9zY2FyaW5vLWhvdGRvZy1zdHJlYW1saXQuaGYuc3BhY2UlM0ZlbWJlZCUzRHRydWUlMjIlMEElMjAlMjB0aXRsZSUzRCUyMk15JTIwYXdlc29tZSUyMFN0cmVhbWxpdCUyMFNwYWNlJTIyJTBBJTNFJTNDJTJGaWZyYW1lJTNF",highlighted:`&lt;iframe
  src<span class="hljs-operator">=</span><span class="hljs-string">&quot;https://NimaBoscarino-hotdog-streamlit.hf.space?embed=true&quot;</span>
  title<span class="hljs-operator">=</span><span class="hljs-string">&quot;My awesome Streamlit Space&quot;</span>
&gt;&lt;/iframe&gt;`,wrap:!1}}),A=new te({props:{title:"Embed Streamlit Spaces with auto-resizing IFrames",local:"embed-streamlit-spaces-with-auto-resizing-iframes",headingTag:"h2"}}),K=new ae({props:{code:"JTNDaWZyYW1lJTBBJTA5aWQlM0QlMjJ5b3VyLWlmcmFtZS1pZCUyMiUwQSUwOXNyYyUzRCUyMmh0dHBzJTNBJTJGJTJGJTNDc3BhY2Utc3ViZG9tYWluJTNFLmhmLnNwYWNlJTIyJTBBJTA5ZnJhbWVib3JkZXIlM0QlMjIwJTIyJTBBJTA5d2lkdGglM0QlMjI4NTAlMjIlMEElMDloZWlnaHQlM0QlMjI0NTAlMjIlMEElM0UlM0MlMkZpZnJhbWUlM0UlMEElM0NzY3JpcHQlMjBzcmMlM0QlMjJodHRwcyUzQSUyRiUyRmNkbi5qc2RlbGl2ci5uZXQlMkZucG0lMkZpZnJhbWUtcmVzaXplciU0MDQuMy40JTJGanMlMkZpZnJhbWVSZXNpemVyLm1pbi5qcyUyMiUzRSUzQyUyRnNjcmlwdCUzRSUwQSUzQ3NjcmlwdCUzRSUwQSUyMCUyMGlGcmFtZVJlc2l6ZSglN0IlN0QlMkMlMjAlMjIlMjN5b3VyLWlmcmFtZS1pZCUyMiklMEElM0MlMkZzY3JpcHQlM0U=",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">iframe</span>
	<span class="hljs-attr">id</span>=<span class="hljs-string">&quot;your-iframe-id&quot;</span>
	<span class="hljs-attr">src</span>=<span class="hljs-string">&quot;https://&lt;space-subdomain&gt;.hf.space&quot;</span>
	<span class="hljs-attr">frameborder</span>=<span class="hljs-string">&quot;0&quot;</span>
	<span class="hljs-attr">width</span>=<span class="hljs-string">&quot;850&quot;</span>
	<span class="hljs-attr">height</span>=<span class="hljs-string">&quot;450&quot;</span>
&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">iframe</span>&gt;</span>
<span class="hljs-tag">&lt;<span class="hljs-name">script</span> <span class="hljs-attr">src</span>=<span class="hljs-string">&quot;https://cdn.jsdelivr.net/npm/iframe-resizer@4.3.4/js/iframeResizer.min.js&quot;</span>&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">script</span>&gt;</span>
<span class="hljs-tag">&lt;<span class="hljs-name">script</span>&gt;</span><span class="language-javascript">
  <span class="hljs-title function_">iFrameResize</span>({}, <span class="hljs-string">&quot;#your-iframe-id&quot;</span>)
</span><span class="hljs-tag">&lt;/<span class="hljs-name">script</span>&gt;</span>`,wrap:!1}}),ee=new Jt({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/spaces-sdks-streamlit.md"}}),{c(){p=n("meta"),w=l(),T=n("p"),ie=l(),c(j.$$.fragment),ne=l(),J=n("p"),J.innerHTML=Ee,oe=l(),$=n("p"),$.innerHTML=qe,re=l(),S=n("p"),S.innerHTML=Fe,pe=l(),c(v.$$.fragment),ce=l(),U=n("p"),U.innerHTML=Ae,me=l(),I=n("p"),I.innerHTML=Pe,he=l(),c(y.$$.fragment),de=l(),c(Z.$$.fragment),fe=l(),B=n("p"),B.innerHTML=Xe,ue=l(),k=n("p"),k.innerHTML=De,ge=l(),c(W.$$.fragment),we=l(),H=n("p"),H.innerHTML=Ve,Me=l(),c(L.$$.fragment),ye=l(),_=n("p"),_.innerHTML=Ke,be=l(),c(C.$$.fragment),Te=l(),z=n("p"),z.textContent=Oe,je=l(),c(x.$$.fragment),Je=l(),N=n("p"),N.innerHTML=et,$e=l(),c(R.$$.fragment),Se=l(),Q=n("p"),Q.innerHTML=tt,ve=l(),b=n("div"),b.innerHTML=st,Ue=l(),c(G.$$.fragment),Ie=l(),Y=n("p"),Y.innerHTML=at,Ze=l(),E=n("p"),E.textContent=lt,Be=l(),c(q.$$.fragment),ke=l(),g=n("iframe"),We=l(),F=n("p"),F.innerHTML=nt,He=l(),c(A.$$.fragment),Le=l(),P=n("p"),P.innerHTML=ot,_e=l(),X=n("p"),X.innerHTML=rt,Ce=l(),D=n("ul"),D.innerHTML=pt,ze=l(),V=n("p"),V.innerHTML=ct,xe=l(),c(K.$$.fragment),Ne=l(),O=n("p"),O.innerHTML=mt,Re=l(),c(ee.$$.fragment),Qe=l(),se=n("p"),this.h()},l(e){const t=Mt("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(s),w=i(e),T=o(e,"P",{}),Ye(T).forEach(s),ie=i(e),m(j.$$.fragment,e),ne=i(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-155nn9c"&&(J.innerHTML=Ee),oe=i(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-fhngw3"&&($.innerHTML=qe),re=i(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1lndvi6"&&(S.innerHTML=Fe),pe=i(e),m(v.$$.fragment,e),ce=i(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-rlzh8f"&&(U.innerHTML=Ae),me=i(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1i51m04"&&(I.innerHTML=Pe),he=i(e),m(y.$$.fragment,e),de=i(e),m(Z.$$.fragment,e),fe=i(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-w37as0"&&(B.innerHTML=Xe),ue=i(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1yuvt6i"&&(k.innerHTML=De),ge=i(e),m(W.$$.fragment,e),we=i(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-7i2a6u"&&(H.innerHTML=Ve),Me=i(e),m(L.$$.fragment,e),ye=i(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-12qvnza"&&(_.innerHTML=Ke),be=i(e),m(C.$$.fragment,e),Te=i(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-pc1ide"&&(z.textContent=Oe),je=i(e),m(x.$$.fragment,e),Je=i(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1s8aj3m"&&(N.innerHTML=et),$e=i(e),m(R.$$.fragment,e),Se=i(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1lyf612"&&(Q.innerHTML=tt),ve=i(e),b=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-10soa41"&&(b.innerHTML=st),Ue=i(e),m(G.$$.fragment,e),Ie=i(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-h9u7cp"&&(Y.innerHTML=at),Ze=i(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-m5fkq0"&&(E.textContent=lt),Be=i(e),m(q.$$.fragment,e),ke=i(e),g=o(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),Ye(g).forEach(s),We=i(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-190mgpd"&&(F.innerHTML=nt),He=i(e),m(A.$$.fragment,e),Le=i(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1pycgf5"&&(P.innerHTML=ot),_e=i(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1na14o1"&&(X.innerHTML=rt),Ce=i(e),D=o(e,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-13i7z0x"&&(D.innerHTML=pt),ze=i(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1hn154n"&&(V.innerHTML=ct),xe=i(e),m(K.$$.fragment,e),Ne=i(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-18gaz5u"&&(O.innerHTML=mt),Re=i(e),m(ee.$$.fragment,e),Qe=i(e),se=o(e,"P",{}),Ye(se).forEach(s),this.h()},h(){M(p,"name","hf:doc:metadata"),M(p,"content",vt),M(b,"class","flex justify-center"),ft(g.src,it="https://NimaBoscarino-hotdog-streamlit.hf.space?embed=true")||M(g,"src",it),M(g,"frameborder","0"),M(g,"height","364"),M(g,"title","Streamlit app"),M(g,"class","container p-0 grow space-iframe"),M(g,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),M(g,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){yt(document.head,p),a(e,w,t),a(e,T,t),a(e,ie,t),h(j,e,t),a(e,ne,t),a(e,J,t),a(e,oe,t),a(e,$,t),a(e,re,t),a(e,S,t),a(e,pe,t),h(v,e,t),a(e,ce,t),a(e,U,t),a(e,me,t),a(e,I,t),a(e,he,t),h(y,e,t),a(e,de,t),h(Z,e,t),a(e,fe,t),a(e,B,t),a(e,ue,t),a(e,k,t),a(e,ge,t),h(W,e,t),a(e,we,t),a(e,H,t),a(e,Me,t),h(L,e,t),a(e,ye,t),a(e,_,t),a(e,be,t),h(C,e,t),a(e,Te,t),a(e,z,t),a(e,je,t),h(x,e,t),a(e,Je,t),a(e,N,t),a(e,$e,t),h(R,e,t),a(e,Se,t),a(e,Q,t),a(e,ve,t),a(e,b,t),a(e,Ue,t),h(G,e,t),a(e,Ie,t),a(e,Y,t),a(e,Ze,t),a(e,E,t),a(e,Be,t),h(q,e,t),a(e,ke,t),a(e,g,t),a(e,We,t),a(e,F,t),a(e,He,t),h(A,e,t),a(e,Le,t),a(e,P,t),a(e,_e,t),a(e,X,t),a(e,Ce,t),a(e,D,t),a(e,ze,t),a(e,V,t),a(e,xe,t),h(K,e,t),a(e,Ne,t),a(e,O,t),a(e,Re,t),h(ee,e,t),a(e,Qe,t),a(e,se,t),Ge=!0},p(e,[t]){const ht={};t&2&&(ht.$$scope={dirty:t,ctx:e}),y.$set(ht)},i(e){Ge||(d(j.$$.fragment,e),d(v.$$.fragment,e),d(y.$$.fragment,e),d(Z.$$.fragment,e),d(W.$$.fragment,e),d(L.$$.fragment,e),d(C.$$.fragment,e),d(x.$$.fragment,e),d(R.$$.fragment,e),d(G.$$.fragment,e),d(q.$$.fragment,e),d(A.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),Ge=!0)},o(e){f(j.$$.fragment,e),f(v.$$.fragment,e),f(y.$$.fragment,e),f(Z.$$.fragment,e),f(W.$$.fragment,e),f(L.$$.fragment,e),f(C.$$.fragment,e),f(x.$$.fragment,e),f(R.$$.fragment,e),f(G.$$.fragment,e),f(q.$$.fragment,e),f(A.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),Ge=!1},d(e){e&&(s(w),s(T),s(ie),s(ne),s(J),s(oe),s($),s(re),s(S),s(pe),s(ce),s(U),s(me),s(I),s(he),s(de),s(fe),s(B),s(ue),s(k),s(ge),s(we),s(H),s(Me),s(ye),s(_),s(be),s(Te),s(z),s(je),s(Je),s(N),s($e),s(Se),s(Q),s(ve),s(b),s(Ue),s(Ie),s(Y),s(Ze),s(E),s(Be),s(ke),s(g),s(We),s(F),s(He),s(Le),s(P),s(_e),s(X),s(Ce),s(D),s(ze),s(V),s(xe),s(Ne),s(O),s(Re),s(Qe),s(se)),s(p),u(j,e),u(v,e),u(y,e),u(Z,e),u(W,e),u(L,e),u(C,e),u(x,e),u(R,e),u(G,e),u(q,e),u(A,e),u(K,e),u(ee,e)}}}const vt='{"title":"Streamlit Spaces","local":"streamlit-spaces","sections":[{"title":"Your First Streamlit Space: Hot Dog Classifier","local":"your-first-streamlit-space-hot-dog-classifier","sections":[],"depth":2},{"title":"Create a new Streamlit Space","local":"create-a-new-streamlit-space","sections":[],"depth":2},{"title":"Add the dependencies","local":"add-the-dependencies","sections":[],"depth":2},{"title":"Create the Streamlit app","local":"create-the-streamlit-app","sections":[],"depth":2},{"title":"Embed Streamlit Spaces on other webpages","local":"embed-streamlit-spaces-on-other-webpages","sections":[],"depth":2},{"title":"Embed Streamlit Spaces with auto-resizing IFrames","local":"embed-streamlit-spaces-with-auto-resizing-iframes","sections":[],"depth":2}],"depth":1}';function Ut(le){return ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ht extends gt{constructor(p){super(),wt(this,p,Ut,St,dt,{})}}export{Ht as component};
