import{s as wt,f as Mt,o as Tt,n as et}from"../chunks/scheduler.25b97de1.js";import{S as jt,i as Jt,g as r,s as a,r as m,A as vt,h as p,f as n,c as o,j as ge,u as g,x as _,k as C,y as d,a as s,v as f,d as u,t as y,w as b}from"../chunks/index.d9030fc9.js";import{T as $t}from"../chunks/Tip.baa67368.js";import{D as Fe}from"../chunks/Docstring.ffac8efa.js";import{C as He}from"../chunks/CodeBlock.e6cd0d95.js";import{E as _t}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as R,E as Ut}from"../chunks/EditOnGithub.91d95064.js";function Ct(k){let i,j="Example:",c,h,w;return h=new He({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlcHRoQW55dGhpbmdDb25maWclMkMlMjBEZXB0aEFueXRoaW5nRm9yRGVwdGhFc3RpbWF0aW9uJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMERlcHRoQW55dGhpbmclMjBzbWFsbCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBEZXB0aEFueXRoaW5nQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwRGVwdGhBbnl0aGluZyUyMHNtYWxsJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBEZXB0aEFueXRoaW5nRm9yRGVwdGhFc3RpbWF0aW9uKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DepthAnythingConfig, DepthAnythingForDepthEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a DepthAnything small style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = DepthAnythingConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the DepthAnything small style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DepthAnythingForDepthEstimation(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){i=r("p"),i.textContent=j,c=a(),m(h.$$.fragment)},l(l){i=p(l,"P",{"data-svelte-h":!0}),_(i)!=="svelte-11lpom8"&&(i.textContent=j),c=o(l),g(h.$$.fragment,l)},m(l,M){s(l,i,M),s(l,c,M),f(h,l,M),w=!0},p:et,i(l){w||(u(h.$$.fragment,l),w=!0)},o(l){y(h.$$.fragment,l),w=!1},d(l){l&&(n(i),n(c)),b(h,l)}}}function kt(k){let i,j=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=r("p"),i.innerHTML=j},l(c){i=p(c,"P",{"data-svelte-h":!0}),_(i)!=="svelte-fincs2"&&(i.innerHTML=j)},m(c,h){s(c,i,h)},p:et,d(c){c&&n(i)}}}function Wt(k){let i,j="Examples:",c,h,w;return h=new He({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJMaWhlWW91bmclMkZkZXB0aC1hbnl0aGluZy1zbWFsbC1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyTGloZVlvdW5nJTJGZGVwdGgtYW55dGhpbmctc21hbGwtaGYlMjIpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwaW50ZXJwb2xhdGUlMjB0byUyMG9yaWdpbmFsJTIwc2l6ZSUwQXBvc3RfcHJvY2Vzc2VkX291dHB1dCUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5wb3N0X3Byb2Nlc3NfZGVwdGhfZXN0aW1hdGlvbiglMEElMjAlMjAlMjAlMjBvdXRwdXRzJTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X3NpemVzJTNEJTVCKGltYWdlLmhlaWdodCUyQyUyMGltYWdlLndpZHRoKSU1RCUyQyUwQSklMEElMEElMjMlMjB2aXN1YWxpemUlMjB0aGUlMjBwcmVkaWN0aW9uJTBBcHJlZGljdGVkX2RlcHRoJTIwJTNEJTIwcG9zdF9wcm9jZXNzZWRfb3V0cHV0JTVCMCU1RCU1QiUyMnByZWRpY3RlZF9kZXB0aCUyMiU1RCUwQWRlcHRoJTIwJTNEJTIwcHJlZGljdGVkX2RlcHRoJTIwKiUyMDI1NSUyMCUyRiUyMHByZWRpY3RlZF9kZXB0aC5tYXgoKSUwQWRlcHRoJTIwJTNEJTIwZGVwdGguZGV0YWNoKCkuY3B1KCkubnVtcHkoKSUwQWRlcHRoJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGRlcHRoLmFzdHlwZSglMjJ1aW50OCUyMikp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-small-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-small-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>post_processed_output = image_processor.post_process_depth_estimation(
<span class="hljs-meta">... </span>    outputs,
<span class="hljs-meta">... </span>    target_sizes=[(image.height, image.width)],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_depth = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;predicted_depth&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = predicted_depth * <span class="hljs-number">255</span> / predicted_depth.<span class="hljs-built_in">max</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = depth.detach().cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(depth.astype(<span class="hljs-string">&quot;uint8&quot;</span>))`,wrap:!1}}),{c(){i=r("p"),i.textContent=j,c=a(),m(h.$$.fragment)},l(l){i=p(l,"P",{"data-svelte-h":!0}),_(i)!=="svelte-kvfsh7"&&(i.textContent=j),c=o(l),g(h.$$.fragment,l)},m(l,M){s(l,i,M),s(l,c,M),f(h,l,M),w=!0},p:et,i(l){w||(u(h.$$.fragment,l),w=!0)},o(l){y(h.$$.fragment,l),w=!1},d(l){l&&(n(i),n(c)),b(h,l)}}}function Bt(k){let i,j,c,h,w,l,M,ue,x,tt='Depth Anything V2 was introduced in <a href="https://arxiv.org/abs/2406.09414" rel="nofollow">the paper of the same name</a> by Lihe Yang et al. It uses the same architecture as the original <a href="depth_anything">Depth Anything model</a>, but uses synthetic data and a larger capacity teacher model to achieve much finer and robust depth predictions.',ye,I,nt="The abstract from the paper is the following:",be,E,st="<em>This work presents Depth Anything V2. Without pursuing fancy techniques, we aim to reveal crucial findings to pave the way towards building a powerful monocular depth estimation model. Notably, compared with V1, this version produces much finer and more robust depth predictions through three key practices: 1) replacing all labeled real images with synthetic images, 2) scaling up the capacity of our teacher model, and 3) teaching student models via the bridge of large-scale pseudo-labeled real images. Compared with the latest models built on Stable Diffusion, our models are significantly more efficient (more than 10x faster) and more accurate. We offer models of different scales (ranging from 25M to 1.3B params) to support extensive scenarios. Benefiting from their strong generalization capability, we fine-tune them with metric depth labels to obtain our metric depth models. In addition to our models, considering the limited diversity and frequent noise in current test sets, we construct a versatile evaluation benchmark with precise annotations and diverse scenes to facilitate future research.</em>",_e,W,at,we,V,ot='Depth Anything overview. Taken from the <a href="https://arxiv.org/abs/2401.10891">original paper</a>.',Me,F,lt=`The Depth Anything models were contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/DepthAnything/Depth-Anything-V2" rel="nofollow">here</a>.`,Te,H,je,z,it="There are 2 main ways to use Depth Anything V2: either using the pipeline API, which abstracts away all the complexity for you, or by using the <code>DepthAnythingForDepthEstimation</code> class yourself.",Je,N,ve,X,rt="The pipeline allows to use the model in a few lines of code:",$e,Y,Ue,L,Ce,P,pt="If you want to do the pre- and post-processing yourself, here’s how to do that:",ke,S,We,q,Be,Q,ht="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with Depth Anything.",Ze,K,ct='<li><a href="../tasks/monocular_depth_estimation">Monocular depth estimation task guide</a></li> <li><a href="https://huggingface.co/spaces/depth-anything/Depth-Anything-V2" rel="nofollow">Depth Anything V2 demo</a>.</li> <li>A notebook showcasing inference with <a href="/docs/transformers/main/en/model_doc/depth_anything_v2#transformers.DepthAnythingForDepthEstimation">DepthAnythingForDepthEstimation</a> can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/Depth%20Anything/Predicting_depth_in_an_image_with_Depth_Anything.ipynb" rel="nofollow">here</a>. 🌎</li> <li><a href="https://huggingface.co/apple/coreml-depth-anything-v2-small" rel="nofollow">Core ML conversion of the <code>small</code> variant for use on Apple Silicon</a>.</li>',Ge,O,dt="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",De,ee,Ae,T,te,ze,re,mt=`This is the configuration class to store the configuration of a <code>DepthAnythingModel</code>. It is used to instantiate a DepthAnything
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the DepthAnything
<a href="https://huggingface.co/LiheYoung/depth-anything-small-hf" rel="nofollow">LiheYoung/depth-anything-small-hf</a> architecture.`,Ne,pe,gt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Xe,B,Ye,Z,ne,Le,he,ft=`Serializes this instance to a Python dictionary. Override the default <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.to_dict">to_dict()</a>. Returns:
<code>Dict[str, any]</code>: Dictionary of all the attributes that make up this configuration instance,`,Re,se,xe,J,ae,Pe,ce,ut="Depth Anything Model with a depth estimation head on top (consisting of 3 convolutional layers) e.g. for KITTI, NYUv2.",Se,de,yt=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,qe,$,oe,Qe,me,bt='The <a href="/docs/transformers/main/en/model_doc/depth_anything_v2#transformers.DepthAnythingForDepthEstimation">DepthAnythingForDepthEstimation</a> forward method, overrides the <code>__call__</code> special method.',Ke,G,Oe,D,Ie,le,Ee,fe,Ve;return w=new R({props:{title:"Depth Anything V2",local:"depth-anything-v2",headingTag:"h1"}}),M=new R({props:{title:"Overview",local:"overview",headingTag:"h2"}}),H=new R({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),N=new R({props:{title:"Pipeline API",local:"pipeline-api",headingTag:"h3"}}),Y=new He({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMjMlMjBsb2FkJTIwcGlwZSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyZGVwdGgtZXN0aW1hdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyZGVwdGgtYW55dGhpbmclMkZEZXB0aC1Bbnl0aGluZy1WMi1TbWFsbC1oZiUyMiklMEElMEElMjMlMjBsb2FkJTIwaW1hZ2UlMEF1cmwlMjAlM0QlMjAnaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyclMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEElMjMlMjBpbmZlcmVuY2UlMEFkZXB0aCUyMCUzRCUyMHBpcGUoaW1hZ2UpJTVCJTIyZGVwdGglMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load pipe</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(task=<span class="hljs-string">&quot;depth-estimation&quot;</span>, model=<span class="hljs-string">&quot;depth-anything/Depth-Anything-V2-Small-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&#x27;http://images.cocodataset.org/val2017/000000039769.jpg&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = pipe(image)[<span class="hljs-string">&quot;depth&quot;</span>]`,wrap:!1}}),L=new R({props:{title:"Using the model yourself",local:"using-the-model-yourself",headingTag:"h3"}}),S=new He({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJkZXB0aC1hbnl0aGluZyUyRkRlcHRoLUFueXRoaW5nLVYyLVNtYWxsLWhmJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yRGVwdGhFc3RpbWF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJkZXB0aC1hbnl0aGluZyUyRkRlcHRoLUFueXRoaW5nLVYyLVNtYWxsLWhmJTIyKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUyMGZvciUyMHRoZSUyMG1vZGVsJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQSUyMyUyMGludGVycG9sYXRlJTIwdG8lMjBvcmlnaW5hbCUyMHNpemUlMjBhbmQlMjB2aXN1YWxpemUlMjB0aGUlMjBwcmVkaWN0aW9uJTBBcG9zdF9wcm9jZXNzZWRfb3V0cHV0JTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yLnBvc3RfcHJvY2Vzc19kZXB0aF9lc3RpbWF0aW9uKCUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfc2l6ZXMlM0QlNUIoaW1hZ2UuaGVpZ2h0JTJDJTIwaW1hZ2Uud2lkdGgpJTVEJTJDJTBBKSUwQSUwQXByZWRpY3RlZF9kZXB0aCUyMCUzRCUyMHBvc3RfcHJvY2Vzc2VkX291dHB1dCU1QjAlNUQlNUIlMjJwcmVkaWN0ZWRfZGVwdGglMjIlNUQlMEFkZXB0aCUyMCUzRCUyMChwcmVkaWN0ZWRfZGVwdGglMjAtJTIwcHJlZGljdGVkX2RlcHRoLm1pbigpKSUyMCUyRiUyMChwcmVkaWN0ZWRfZGVwdGgubWF4KCklMjAtJTIwcHJlZGljdGVkX2RlcHRoLm1pbigpKSUwQWRlcHRoJTIwJTNEJTIwZGVwdGguZGV0YWNoKCkuY3B1KCkubnVtcHkoKSUyMColMjAyNTUlMEFkZXB0aCUyMCUzRCUyMEltYWdlLmZyb21hcnJheShkZXB0aC5hc3R5cGUoJTIydWludDglMjIpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;depth-anything/Depth-Anything-V2-Small-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;depth-anything/Depth-Anything-V2-Small-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size and visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>post_processed_output = image_processor.post_process_depth_estimation(
<span class="hljs-meta">... </span>    outputs,
<span class="hljs-meta">... </span>    target_sizes=[(image.height, image.width)],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_depth = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;predicted_depth&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = (predicted_depth - predicted_depth.<span class="hljs-built_in">min</span>()) / (predicted_depth.<span class="hljs-built_in">max</span>() - predicted_depth.<span class="hljs-built_in">min</span>())
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = depth.detach().cpu().numpy() * <span class="hljs-number">255</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(depth.astype(<span class="hljs-string">&quot;uint8&quot;</span>))`,wrap:!1}}),q=new R({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ee=new R({props:{title:"DepthAnythingConfig",local:"transformers.DepthAnythingConfig",headingTag:"h2"}}),te=new Fe({props:{name:"class transformers.DepthAnythingConfig",anchor:"transformers.DepthAnythingConfig",parameters:[{name:"backbone_config",val:" = None"},{name:"backbone",val:" = None"},{name:"use_pretrained_backbone",val:" = False"},{name:"use_timm_backbone",val:" = False"},{name:"backbone_kwargs",val:" = None"},{name:"patch_size",val:" = 14"},{name:"initializer_range",val:" = 0.02"},{name:"reassemble_hidden_size",val:" = 384"},{name:"reassemble_factors",val:" = [4, 2, 1, 0.5]"},{name:"neck_hidden_sizes",val:" = [48, 96, 192, 384]"},{name:"fusion_hidden_size",val:" = 64"},{name:"head_in_index",val:" = -1"},{name:"head_hidden_size",val:" = 32"},{name:"depth_estimation_type",val:" = 'relative'"},{name:"max_depth",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DepthAnythingConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>Union[Dict[str, Any], PretrainedConfig]</code>, <em>optional</em>) &#x2014;
The configuration of the backbone model. Only used in case <code>is_hybrid</code> is <code>True</code> or in case you want to
leverage the <a href="/docs/transformers/main/en/main_classes/backbones#transformers.AutoBackbone">AutoBackbone</a> API.`,name:"backbone_config"},{anchor:"transformers.DepthAnythingConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.DepthAnythingConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.DepthAnythingConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the <code>timm</code> library for the backbone. If set to <code>False</code>, will use the <a href="/docs/transformers/main/en/main_classes/backbones#transformers.AutoBackbone">AutoBackbone</a>
API.`,name:"use_timm_backbone"},{anchor:"transformers.DepthAnythingConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.DepthAnythingConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 14) &#x2014;
The size of the patches to extract from the backbone features.`,name:"patch_size"},{anchor:"transformers.DepthAnythingConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.DepthAnythingConfig.reassemble_hidden_size",description:`<strong>reassemble_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 384) &#x2014;
The number of input channels of the reassemble layers.`,name:"reassemble_hidden_size"},{anchor:"transformers.DepthAnythingConfig.reassemble_factors",description:`<strong>reassemble_factors</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 2, 1, 0.5]</code>) &#x2014;
The up/downsampling factors of the reassemble layers.`,name:"reassemble_factors"},{anchor:"transformers.DepthAnythingConfig.neck_hidden_sizes",description:`<strong>neck_hidden_sizes</strong> (<code>List[str]</code>, <em>optional</em>, defaults to <code>[48, 96, 192, 384]</code>) &#x2014;
The hidden sizes to project to for the feature maps of the backbone.`,name:"neck_hidden_sizes"},{anchor:"transformers.DepthAnythingConfig.fusion_hidden_size",description:`<strong>fusion_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
The number of channels before fusion.`,name:"fusion_hidden_size"},{anchor:"transformers.DepthAnythingConfig.head_in_index",description:`<strong>head_in_index</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
The index of the features to use in the depth estimation head.`,name:"head_in_index"},{anchor:"transformers.DepthAnythingConfig.head_hidden_size",description:`<strong>head_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The number of output channels in the second convolution of the depth estimation head.`,name:"head_hidden_size"},{anchor:"transformers.DepthAnythingConfig.depth_estimation_type",description:`<strong>depth_estimation_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;relative&quot;</code>) &#x2014;
The type of depth estimation to use. Can be one of <code>[&quot;relative&quot;, &quot;metric&quot;]</code>.`,name:"depth_estimation_type"},{anchor:"transformers.DepthAnythingConfig.max_depth",description:`<strong>max_depth</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The maximum depth to use for the &#x201C;metric&#x201D; depth estimation head. 20 should be used for indoor models
and 80 for outdoor models. For &#x201C;relative&#x201D; depth estimation, this value is ignored.`,name:"max_depth"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_anything/configuration_depth_anything.py#L28"}}),B=new _t({props:{anchor:"transformers.DepthAnythingConfig.example",$$slots:{default:[Ct]},$$scope:{ctx:k}}}),ne=new Fe({props:{name:"to_dict",anchor:"transformers.DepthAnythingConfig.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_anything/configuration_depth_anything.py#L154"}}),se=new R({props:{title:"DepthAnythingForDepthEstimation",local:"transformers.DepthAnythingForDepthEstimation",headingTag:"h2"}}),ae=new Fe({props:{name:"class transformers.DepthAnythingForDepthEstimation",anchor:"transformers.DepthAnythingForDepthEstimation",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.DepthAnythingForDepthEstimation.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/depth_anything_v2#transformers.DepthAnythingConfig">DepthAnythingConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_anything/modeling_depth_anything.py#L362"}}),oe=new Fe({props:{name:"forward",anchor:"transformers.DepthAnythingForDepthEstimation.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DepthAnythingForDepthEstimation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">DPTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.DepthAnythingForDepthEstimation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DepthAnythingForDepthEstimation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DepthAnythingForDepthEstimation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.DepthAnythingForDepthEstimation.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth depth estimation maps for computing the loss.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/depth_anything/modeling_depth_anything.py#L381",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/depth_anything_v2#transformers.DepthAnythingConfig"
>DepthAnythingConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>predicted_depth</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>) — Predicted depth for each pixel.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),G=new $t({props:{$$slots:{default:[kt]},$$scope:{ctx:k}}}),D=new _t({props:{anchor:"transformers.DepthAnythingForDepthEstimation.forward.example",$$slots:{default:[Wt]},$$scope:{ctx:k}}}),le=new Ut({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/depth_anything_v2.md"}}),{c(){i=r("meta"),j=a(),c=r("p"),h=a(),m(w.$$.fragment),l=a(),m(M.$$.fragment),ue=a(),x=r("p"),x.innerHTML=tt,ye=a(),I=r("p"),I.textContent=nt,be=a(),E=r("p"),E.innerHTML=st,_e=a(),W=r("img"),we=a(),V=r("small"),V.innerHTML=ot,Me=a(),F=r("p"),F.innerHTML=lt,Te=a(),m(H.$$.fragment),je=a(),z=r("p"),z.innerHTML=it,Je=a(),m(N.$$.fragment),ve=a(),X=r("p"),X.textContent=rt,$e=a(),m(Y.$$.fragment),Ue=a(),m(L.$$.fragment),Ce=a(),P=r("p"),P.textContent=pt,ke=a(),m(S.$$.fragment),We=a(),m(q.$$.fragment),Be=a(),Q=r("p"),Q.textContent=ht,Ze=a(),K=r("ul"),K.innerHTML=ct,Ge=a(),O=r("p"),O.textContent=dt,De=a(),m(ee.$$.fragment),Ae=a(),T=r("div"),m(te.$$.fragment),ze=a(),re=r("p"),re.innerHTML=mt,Ne=a(),pe=r("p"),pe.innerHTML=gt,Xe=a(),m(B.$$.fragment),Ye=a(),Z=r("div"),m(ne.$$.fragment),Le=a(),he=r("p"),he.innerHTML=ft,Re=a(),m(se.$$.fragment),xe=a(),J=r("div"),m(ae.$$.fragment),Pe=a(),ce=r("p"),ce.textContent=ut,Se=a(),de=r("p"),de.innerHTML=yt,qe=a(),$=r("div"),m(oe.$$.fragment),Qe=a(),me=r("p"),me.innerHTML=bt,Ke=a(),m(G.$$.fragment),Oe=a(),m(D.$$.fragment),Ie=a(),m(le.$$.fragment),Ee=a(),fe=r("p"),this.h()},l(e){const t=vt("svelte-u9bgzb",document.head);i=p(t,"META",{name:!0,content:!0}),t.forEach(n),j=o(e),c=p(e,"P",{}),ge(c).forEach(n),h=o(e),g(w.$$.fragment,e),l=o(e),g(M.$$.fragment,e),ue=o(e),x=p(e,"P",{"data-svelte-h":!0}),_(x)!=="svelte-bx62jk"&&(x.innerHTML=tt),ye=o(e),I=p(e,"P",{"data-svelte-h":!0}),_(I)!=="svelte-vfdo9a"&&(I.textContent=nt),be=o(e),E=p(e,"P",{"data-svelte-h":!0}),_(E)!=="svelte-1ybeoq5"&&(E.innerHTML=st),_e=o(e),W=p(e,"IMG",{src:!0,alt:!0,width:!0}),we=o(e),V=p(e,"SMALL",{"data-svelte-h":!0}),_(V)!=="svelte-1ldczql"&&(V.innerHTML=ot),Me=o(e),F=p(e,"P",{"data-svelte-h":!0}),_(F)!=="svelte-hg4duy"&&(F.innerHTML=lt),Te=o(e),g(H.$$.fragment,e),je=o(e),z=p(e,"P",{"data-svelte-h":!0}),_(z)!=="svelte-1ct8de3"&&(z.innerHTML=it),Je=o(e),g(N.$$.fragment,e),ve=o(e),X=p(e,"P",{"data-svelte-h":!0}),_(X)!=="svelte-1yjxirq"&&(X.textContent=rt),$e=o(e),g(Y.$$.fragment,e),Ue=o(e),g(L.$$.fragment,e),Ce=o(e),P=p(e,"P",{"data-svelte-h":!0}),_(P)!=="svelte-12aulqw"&&(P.textContent=pt),ke=o(e),g(S.$$.fragment,e),We=o(e),g(q.$$.fragment,e),Be=o(e),Q=p(e,"P",{"data-svelte-h":!0}),_(Q)!=="svelte-msamn6"&&(Q.textContent=ht),Ze=o(e),K=p(e,"UL",{"data-svelte-h":!0}),_(K)!=="svelte-1hbmbxv"&&(K.innerHTML=ct),Ge=o(e),O=p(e,"P",{"data-svelte-h":!0}),_(O)!=="svelte-1xesile"&&(O.textContent=dt),De=o(e),g(ee.$$.fragment,e),Ae=o(e),T=p(e,"DIV",{class:!0});var v=ge(T);g(te.$$.fragment,v),ze=o(v),re=p(v,"P",{"data-svelte-h":!0}),_(re)!=="svelte-30ivap"&&(re.innerHTML=mt),Ne=o(v),pe=p(v,"P",{"data-svelte-h":!0}),_(pe)!=="svelte-o55m63"&&(pe.innerHTML=gt),Xe=o(v),g(B.$$.fragment,v),Ye=o(v),Z=p(v,"DIV",{class:!0});var ie=ge(Z);g(ne.$$.fragment,ie),Le=o(ie),he=p(ie,"P",{"data-svelte-h":!0}),_(he)!=="svelte-f91b28"&&(he.innerHTML=ft),ie.forEach(n),v.forEach(n),Re=o(e),g(se.$$.fragment,e),xe=o(e),J=p(e,"DIV",{class:!0});var U=ge(J);g(ae.$$.fragment,U),Pe=o(U),ce=p(U,"P",{"data-svelte-h":!0}),_(ce)!=="svelte-1lyww6q"&&(ce.textContent=ut),Se=o(U),de=p(U,"P",{"data-svelte-h":!0}),_(de)!=="svelte-1gjh92c"&&(de.innerHTML=yt),qe=o(U),$=p(U,"DIV",{class:!0});var A=ge($);g(oe.$$.fragment,A),Qe=o(A),me=p(A,"P",{"data-svelte-h":!0}),_(me)!=="svelte-17wclr2"&&(me.innerHTML=bt),Ke=o(A),g(G.$$.fragment,A),Oe=o(A),g(D.$$.fragment,A),A.forEach(n),U.forEach(n),Ie=o(e),g(le.$$.fragment,e),Ee=o(e),fe=p(e,"P",{}),ge(fe).forEach(n),this.h()},h(){C(i,"name","hf:doc:metadata"),C(i,"content",Zt),Mt(W.src,at="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/depth_anything_overview.jpg")||C(W,"src",at),C(W,"alt","drawing"),C(W,"width","600"),C(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){d(document.head,i),s(e,j,t),s(e,c,t),s(e,h,t),f(w,e,t),s(e,l,t),f(M,e,t),s(e,ue,t),s(e,x,t),s(e,ye,t),s(e,I,t),s(e,be,t),s(e,E,t),s(e,_e,t),s(e,W,t),s(e,we,t),s(e,V,t),s(e,Me,t),s(e,F,t),s(e,Te,t),f(H,e,t),s(e,je,t),s(e,z,t),s(e,Je,t),f(N,e,t),s(e,ve,t),s(e,X,t),s(e,$e,t),f(Y,e,t),s(e,Ue,t),f(L,e,t),s(e,Ce,t),s(e,P,t),s(e,ke,t),f(S,e,t),s(e,We,t),f(q,e,t),s(e,Be,t),s(e,Q,t),s(e,Ze,t),s(e,K,t),s(e,Ge,t),s(e,O,t),s(e,De,t),f(ee,e,t),s(e,Ae,t),s(e,T,t),f(te,T,null),d(T,ze),d(T,re),d(T,Ne),d(T,pe),d(T,Xe),f(B,T,null),d(T,Ye),d(T,Z),f(ne,Z,null),d(Z,Le),d(Z,he),s(e,Re,t),f(se,e,t),s(e,xe,t),s(e,J,t),f(ae,J,null),d(J,Pe),d(J,ce),d(J,Se),d(J,de),d(J,qe),d(J,$),f(oe,$,null),d($,Qe),d($,me),d($,Ke),f(G,$,null),d($,Oe),f(D,$,null),s(e,Ie,t),f(le,e,t),s(e,Ee,t),s(e,fe,t),Ve=!0},p(e,[t]){const v={};t&2&&(v.$$scope={dirty:t,ctx:e}),B.$set(v);const ie={};t&2&&(ie.$$scope={dirty:t,ctx:e}),G.$set(ie);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),D.$set(U)},i(e){Ve||(u(w.$$.fragment,e),u(M.$$.fragment,e),u(H.$$.fragment,e),u(N.$$.fragment,e),u(Y.$$.fragment,e),u(L.$$.fragment,e),u(S.$$.fragment,e),u(q.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(B.$$.fragment,e),u(ne.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(oe.$$.fragment,e),u(G.$$.fragment,e),u(D.$$.fragment,e),u(le.$$.fragment,e),Ve=!0)},o(e){y(w.$$.fragment,e),y(M.$$.fragment,e),y(H.$$.fragment,e),y(N.$$.fragment,e),y(Y.$$.fragment,e),y(L.$$.fragment,e),y(S.$$.fragment,e),y(q.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(B.$$.fragment,e),y(ne.$$.fragment,e),y(se.$$.fragment,e),y(ae.$$.fragment,e),y(oe.$$.fragment,e),y(G.$$.fragment,e),y(D.$$.fragment,e),y(le.$$.fragment,e),Ve=!1},d(e){e&&(n(j),n(c),n(h),n(l),n(ue),n(x),n(ye),n(I),n(be),n(E),n(_e),n(W),n(we),n(V),n(Me),n(F),n(Te),n(je),n(z),n(Je),n(ve),n(X),n($e),n(Ue),n(Ce),n(P),n(ke),n(We),n(Be),n(Q),n(Ze),n(K),n(Ge),n(O),n(De),n(Ae),n(T),n(Re),n(xe),n(J),n(Ie),n(Ee),n(fe)),n(i),b(w,e),b(M,e),b(H,e),b(N,e),b(Y,e),b(L,e),b(S,e),b(q,e),b(ee,e),b(te),b(B),b(ne),b(se,e),b(ae),b(oe),b(G),b(D),b(le,e)}}}const Zt='{"title":"Depth Anything V2","local":"depth-anything-v2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Pipeline API","local":"pipeline-api","sections":[],"depth":3},{"title":"Using the model yourself","local":"using-the-model-yourself","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"DepthAnythingConfig","local":"transformers.DepthAnythingConfig","sections":[],"depth":2},{"title":"DepthAnythingForDepthEstimation","local":"transformers.DepthAnythingForDepthEstimation","sections":[],"depth":2}],"depth":1}';function Gt(k){return Tt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ft extends jt{constructor(i){super(),Jt(this,i,Gt,Bt,wt,{})}}export{Ft as component};
