import{s as Yt,f as At,o as Kt,n as Qt}from"../chunks/scheduler.25b97de1.js";import{S as Ot,i as eo,g as a,s,r as d,A as to,h as i,f as o,c as r,j as I,u as m,x as c,k as C,y as l,a as n,v as u,d as f,t as h,w as g}from"../chunks/index.d9030fc9.js";import{T as oo}from"../chunks/Tip.baa67368.js";import{D as he}from"../chunks/Docstring.ffac8efa.js";import{C as lt}from"../chunks/CodeBlock.e6cd0d95.js";import{E as no}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as ge,E as so}from"../chunks/EditOnGithub.91d95064.js";function ro(ye){let p,U="Example:",_,w,J;return w=new lt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN1cGVyUG9pbnRDb25maWclMkMlMjBTdXBlclBvaW50Rm9yS2V5cG9pbnREZXRlY3Rpb24lMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwU3VwZXJQb2ludCUyMHN1cGVycG9pbnQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwU3VwZXJQb2ludENvbmZpZygpJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMHN1cGVycG9pbnQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFN1cGVyUG9pbnRGb3JLZXlwb2ludERldGVjdGlvbihjb25maWd1cmF0aW9uKSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SuperPointConfig, SuperPointForKeypointDetection

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a SuperPoint superpoint style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = SuperPointConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the superpoint style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SuperPointForKeypointDetection(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){p=a("p"),p.textContent=U,_=s(),d(w.$$.fragment)},l(y){p=i(y,"P",{"data-svelte-h":!0}),c(p)!=="svelte-11lpom8"&&(p.textContent=U),_=r(y),m(w.$$.fragment,y)},m(y,$){n(y,p,$),n(y,_,$),u(w,y,$),J=!0},p:Qt,i(y){J||(f(w.$$.fragment,y),J=!0)},o(y){h(w.$$.fragment,y),J=!1},d(y){y&&(o(p),o(_)),g(w,y)}}}function ao(ye){let p,U=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){p=a("p"),p.innerHTML=U},l(_){p=i(_,"P",{"data-svelte-h":!0}),c(p)!=="svelte-fincs2"&&(p.innerHTML=U)},m(_,w){n(_,p,w)},p:Qt,d(_){_&&o(p)}}}function io(ye){let p,U,_,w,J,y,$,Se,q,Jt=`The SuperPoint model was proposed
in <a href="https://arxiv.org/abs/1712.07629" rel="nofollow">SuperPoint: Self-Supervised Interest Point Detection and Description</a> by Daniel
DeTone, Tomasz Malisiewicz and Andrew Rabinovich.`,Ie,D,Ct=`This model is the result of a self-supervised training of a fully-convolutional network for interest point detection and
description. The model is able to detect interest points that are repeatable under homographic transformations and
provide a descriptor for each point. The use of the model in its own is limited, but it can be used as a feature
extractor for other tasks such as homography estimation, image matching, etc.`,je,Z,$t="The abstract from the paper is the following:",xe,G,Pt=`<em>This paper presents a self-supervised framework for training interest point detectors and descriptors suitable for a
large number of multiple-view geometry problems in computer vision. As opposed to patch-based neural networks, our
fully-convolutional model operates on full-sized images and jointly computes pixel-level interest point locations and
associated descriptors in one forward pass. We introduce Homographic Adaptation, a multi-scale, multi-homography
approach for boosting interest point detection repeatability and performing cross-domain adaptation (e.g.,
synthetic-to-real). Our model, when trained on the MS-COCO generic image dataset using Homographic Adaptation, is able
to repeatedly detect a much richer set of interest points than the initial pre-adapted deep model and any other
traditional corner detector. The final system gives rise to state-of-the-art homography estimation results on HPatches
when compared to LIFT, SIFT and ORB.</em>`,ze,j,Ut,ke,H,St='SuperPoint overview. Taken from the <a href="https://arxiv.org/abs/1712.07629v4">original paper.</a>',Ve,N,We,B,It="Here is a quick example of using the model to detect interest points in an image:",Re,E,qe,F,jt="The outputs contain the list of keypoint coordinates with their respective score and description (a 256-long vector).",De,L,xt=`You can also feed multiple images to the model. Due to the nature of SuperPoint, to output a dynamic number of keypoints,
you will need to use the mask attribute to retrieve the respective information :`,Ze,X,Ge,Q,zt="You can then print the keypoints on the image of your choice to visualize the result:",He,Y,Ne,A,kt='<img src="https://cdn-uploads.huggingface.co/production/uploads/632885ba1558dac67c440aa8/ZtFmphEhx8tcbEQqOolyE.png" alt="image/png"/>',Be,K,Vt=`This model was contributed by <a href="https://huggingface.co/stevenbucaille" rel="nofollow">stevenbucaille</a>.
The original code can be found <a href="https://github.com/magicleap/SuperPointPretrainedNetwork" rel="nofollow">here</a>.`,Ee,O,Fe,ee,Wt="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with SuperPoint. If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Le,te,Rt='<li>A notebook showcasing inference and visualization with SuperPoint can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/SuperPoint/Inference_with_SuperPoint_to_detect_interest_points_in_an_image.ipynb" rel="nofollow">here</a>. 🌎</li>',Xe,oe,Qe,T,ne,ct,_e,qt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/superpoint#transformers.SuperPointForKeypointDetection">SuperPointForKeypointDetection</a>. It is used to instantiate a
SuperPoint model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the SuperPoint
<a href="https://huggingface.co/magic-leap-community/superpoint" rel="nofollow">magic-leap-community/superpoint</a> architecture.`,pt,be,Dt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,dt,x,Ye,se,Ae,b,re,mt,we,Zt="Constructs a SuperPoint image processor.",ut,z,ae,ft,Te,Gt=`Converts the raw output of <a href="/docs/transformers/main/en/model_doc/superpoint#transformers.SuperPointForKeypointDetection">SuperPointForKeypointDetection</a> into lists of keypoints, scores and descriptors
with coordinates absolute to the original image sizes.`,ht,k,ie,gt,Me,Ht="Preprocess an image or batch of images.",yt,V,le,_t,ve,Nt="Resize an image.",Ke,ce,Bt="<li>preprocess</li> <li>post_process_keypoint_detection</li>",Oe,pe,et,M,de,bt,Je,Et=`SuperPoint model outputting keypoints and descriptors.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,wt,Ce,Ft=`SuperPoint model. It consists of a SuperPointEncoder, a SuperPointInterestPointDecoder and a
SuperPointDescriptorDecoder. SuperPoint was proposed in <code>SuperPoint: Self-Supervised Interest Point Detection and Description &lt;https://arxiv.org/abs/1712.07629&gt;</code>__ by Daniel DeTone, Tomasz Malisiewicz, and Andrew Rabinovich. It
is a fully convolutional neural network that extracts keypoints and descriptors from an image. It is trained in a
self-supervised manner, using a combination of a photometric loss and a loss based on the homographic adaptation of
keypoints. It is made of a convolutional encoder and two decoders: one for keypoints and one for descriptors.`,Tt,S,me,Mt,$e,Lt='The <a href="/docs/transformers/main/en/model_doc/superpoint#transformers.SuperPointForKeypointDetection">SuperPointForKeypointDetection</a> forward method, overrides the <code>__call__</code> special method.',vt,W,tt,ue,Xt="<li>forward</li>",ot,fe,nt,Ue,st;return J=new ge({props:{title:"SuperPoint",local:"superpoint",headingTag:"h1"}}),$=new ge({props:{title:"Overview",local:"overview",headingTag:"h2"}}),N=new ge({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),E=new lt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFN1cGVyUG9pbnRGb3JLZXlwb2ludERldGVjdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtYWdpYy1sZWFwLWNvbW11bml0eSUyRnN1cGVycG9pbnQlMjIpJTBBbW9kZWwlMjAlM0QlMjBTdXBlclBvaW50Rm9yS2V5cG9pbnREZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1hZ2ljLWxlYXAtY29tbXVuaXR5JTJGc3VwZXJwb2ludCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, SuperPointForKeypointDetection
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)
model = SuperPointForKeypointDetection.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)

inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
outputs = model(**inputs)`,wrap:!1}}),X=new lt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFN1cGVyUG9pbnRGb3JLZXlwb2ludERldGVjdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmxfaW1hZ2VfMSUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZV8xJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsX2ltYWdlXzElMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBdXJsX2ltYWdlXzIlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnRlc3Qtc3R1ZmYyMDE3JTJGMDAwMDAwMDAwNTY4LmpwZyUyMiUwQWltYWdlXzIlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmxfaW1hZ2VfMiUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZXMlMjAlM0QlMjAlNUJpbWFnZV8xJTJDJTIwaW1hZ2VfMiU1RCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWFnaWMtbGVhcC1jb21tdW5pdHklMkZzdXBlcnBvaW50JTIyKSUwQW1vZGVsJTIwJTNEJTIwU3VwZXJQb2ludEZvcktleXBvaW50RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtYWdpYy1sZWFwLWNvbW11bml0eSUyRnN1cGVycG9pbnQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWltYWdlX3NpemVzJTIwJTNEJTIwJTVCKGltYWdlLmhlaWdodCUyQyUyMGltYWdlLndpZHRoKSUyMGZvciUyMGltYWdlJTIwaW4lMjBpbWFnZXMlNUQlMEFvdXRwdXRzJTIwJTNEJTIwcHJvY2Vzc29yLnBvc3RfcHJvY2Vzc19rZXlwb2ludF9kZXRlY3Rpb24ob3V0cHV0cyUyQyUyMGltYWdlX3NpemVzKSUwQSUwQWZvciUyMG91dHB1dCUyMGluJTIwb3V0cHV0cyUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGtleXBvaW50cyUyQyUyMHNjb3JlcyUyQyUyMGRlc2NyaXB0b3JzJTIwaW4lMjB6aXAob3V0cHV0JTVCJTIya2V5cG9pbnRzJTIyJTVEJTJDJTIwb3V0cHV0JTVCJTIyc2NvcmVzJTIyJTVEJTJDJTIwb3V0cHV0JTVCJTIyZGVzY3JpcHRvcnMlMjIlNUQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMktleXBvaW50cyUzQSUyMCU3QmtleXBvaW50cyU3RCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyU2NvcmVzJTNBJTIwJTdCc2NvcmVzJTdEJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjJEZXNjcmlwdG9ycyUzQSUyMCU3QmRlc2NyaXB0b3JzJTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, SuperPointForKeypointDetection
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url_image_1 = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image_1 = Image.<span class="hljs-built_in">open</span>(requests.get(url_image_1, stream=<span class="hljs-literal">True</span>).raw)
url_image_2 = <span class="hljs-string">&quot;http://images.cocodataset.org/test-stuff2017/000000000568.jpg&quot;</span>
image_2 = Image.<span class="hljs-built_in">open</span>(requests.get(url_image_2, stream=<span class="hljs-literal">True</span>).raw)

images = [image_1, image_2]

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)
model = SuperPointForKeypointDetection.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)

inputs = processor(images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
outputs = model(**inputs)
image_sizes = [(image.height, image.width) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> images]
outputs = processor.post_process_keypoint_detection(outputs, image_sizes)

<span class="hljs-keyword">for</span> output <span class="hljs-keyword">in</span> outputs:
    <span class="hljs-keyword">for</span> keypoints, scores, descriptors <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(output[<span class="hljs-string">&quot;keypoints&quot;</span>], output[<span class="hljs-string">&quot;scores&quot;</span>], output[<span class="hljs-string">&quot;descriptors&quot;</span>]):
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Keypoints: <span class="hljs-subst">{keypoints}</span>&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Scores: <span class="hljs-subst">{scores}</span>&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Descriptors: <span class="hljs-subst">{descriptors}</span>&quot;</span>)`,wrap:!1}}),Y=new lt({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5heGlzKCUyMm9mZiUyMiklMEFwbHQuaW1zaG93KGltYWdlXzEpJTBBcGx0LnNjYXR0ZXIoJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyU1QjAlNUQlNUIlMjJrZXlwb2ludHMlMjIlNUQlNUIlM0ElMkMlMjAwJTVEJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyU1QjAlNUQlNUIlMjJrZXlwb2ludHMlMjIlNUQlNUIlM0ElMkMlMjAxJTVEJTJDJTBBJTIwJTIwJTIwJTIwYyUzRG91dHB1dHMlNUIwJTVEJTVCJTIyc2NvcmVzJTIyJTVEJTIwKiUyMDEwMCUyQyUwQSUyMCUyMCUyMCUyMHMlM0RvdXRwdXRzJTVCMCU1RCU1QiUyMnNjb3JlcyUyMiU1RCUyMColMjA1MCUyQyUwQSUyMCUyMCUyMCUyMGFscGhhJTNEMC44JTBBKSUwQXBsdC5zYXZlZmlnKGYlMjJvdXRwdXRfaW1hZ2UucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.axis(<span class="hljs-string">&quot;off&quot;</span>)
plt.imshow(image_1)
plt.scatter(
    outputs[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;keypoints&quot;</span>][:, <span class="hljs-number">0</span>],
    outputs[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;keypoints&quot;</span>][:, <span class="hljs-number">1</span>],
    c=outputs[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;scores&quot;</span>] * <span class="hljs-number">100</span>,
    s=outputs[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;scores&quot;</span>] * <span class="hljs-number">50</span>,
    alpha=<span class="hljs-number">0.8</span>
)
plt.savefig(<span class="hljs-string">f&quot;output_image.png&quot;</span>)`,wrap:!1}}),O=new ge({props:{title:"Resources",local:"resources",headingTag:"h2"}}),oe=new ge({props:{title:"SuperPointConfig",local:"transformers.SuperPointConfig",headingTag:"h2"}}),ne=new he({props:{name:"class transformers.SuperPointConfig",anchor:"transformers.SuperPointConfig",parameters:[{name:"encoder_hidden_sizes",val:": typing.List[int] = [64, 64, 128, 128]"},{name:"decoder_hidden_size",val:": int = 256"},{name:"keypoint_decoder_dim",val:": int = 65"},{name:"descriptor_decoder_dim",val:": int = 256"},{name:"keypoint_threshold",val:": float = 0.005"},{name:"max_keypoints",val:": int = -1"},{name:"nms_radius",val:": int = 4"},{name:"border_removal_distance",val:": int = 4"},{name:"initializer_range",val:" = 0.02"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperPointConfig.encoder_hidden_sizes",description:`<strong>encoder_hidden_sizes</strong> (<code>List</code>, <em>optional</em>, defaults to <code>[64, 64, 128, 128]</code>) &#x2014;
The number of channels in each convolutional layer in the encoder.`,name:"encoder_hidden_sizes"},{anchor:"transformers.SuperPointConfig.decoder_hidden_size",description:"<strong>decoder_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014; The hidden size of the decoder.",name:"decoder_hidden_size"},{anchor:"transformers.SuperPointConfig.keypoint_decoder_dim",description:"<strong>keypoint_decoder_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 65) &#x2014; The output dimension of the keypoint decoder.",name:"keypoint_decoder_dim"},{anchor:"transformers.SuperPointConfig.descriptor_decoder_dim",description:"<strong>descriptor_decoder_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014; The output dimension of the descriptor decoder.",name:"descriptor_decoder_dim"},{anchor:"transformers.SuperPointConfig.keypoint_threshold",description:`<strong>keypoint_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.005) &#x2014;
The threshold to use for extracting keypoints.`,name:"keypoint_threshold"},{anchor:"transformers.SuperPointConfig.max_keypoints",description:`<strong>max_keypoints</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
The maximum number of keypoints to extract. If <code>-1</code>, will extract all keypoints.`,name:"max_keypoints"},{anchor:"transformers.SuperPointConfig.nms_radius",description:`<strong>nms_radius</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The radius for non-maximum suppression.`,name:"nms_radius"},{anchor:"transformers.SuperPointConfig.border_removal_distance",description:`<strong>border_removal_distance</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The distance from the border to remove keypoints.`,name:"border_removal_distance"},{anchor:"transformers.SuperPointConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/configuration_superpoint.py#L23"}}),x=new no({props:{anchor:"transformers.SuperPointConfig.example",$$slots:{default:[ro]},$$scope:{ctx:ye}}}),se=new ge({props:{title:"SuperPointImageProcessor",local:"transformers.SuperPointImageProcessor",headingTag:"h2"}}),re=new he({props:{name:"class transformers.SuperPointImageProcessor",anchor:"transformers.SuperPointImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperPointImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overriden
by <code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.SuperPointImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 480, &quot;width&quot;: 640}</code>):
Resolution of the output image after <code>resize</code> is applied. Only has an effect if <code>do_resize</code> is set to
<code>True</code>. Can be overriden by <code>size</code> in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.SuperPointImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overriden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.SuperPointImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overriden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/image_processing_superpoint.py#L93"}}),ae=new he({props:{name:"post_process_keypoint_detection",anchor:"transformers.SuperPointImageProcessor.post_process_keypoint_detection",parameters:[{name:"outputs",val:": SuperPointKeypointDescriptionOutput"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple]]"}],parametersDescription:[{anchor:"transformers.SuperPointImageProcessor.post_process_keypoint_detection.outputs",description:`<strong>outputs</strong> (<code>SuperPointKeypointDescriptionOutput</code>) &#x2014;
Raw outputs of the model containing keypoints in a relative (x, y) format, with scores and descriptors.`,name:"outputs"},{anchor:"transformers.SuperPointImageProcessor.post_process_keypoint_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. This must be the original
image size (before any processing).`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/image_processing_superpoint.py#L280",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the keypoints in absolute format according
to target_sizes, scores and descriptors for an image in the batch as predicted by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),ie=new he({props:{name:"preprocess",anchor:"transformers.SuperPointImageProcessor.preprocess",parameters:[{name:"images",val:""},{name:"do_resize",val:": bool = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperPointImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.SuperPointImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.SuperPointImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the output image after <code>resize</code> has been applied. If <code>size[&quot;shortest_edge&quot;]</code> &gt;= 384, the image
is resized to <code>(size[&quot;shortest_edge&quot;], size[&quot;shortest_edge&quot;])</code>. Otherwise, the smaller edge of the
image will be matched to <code>int(size[&quot;shortest_edge&quot;]/ crop_pct)</code>, after which the image is cropped to
<code>(size[&quot;shortest_edge&quot;], size[&quot;shortest_edge&quot;])</code>. Only has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"size"},{anchor:"transformers.SuperPointImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.SuperPointImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.SuperPointImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.SuperPointImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.SuperPointImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/image_processing_superpoint.py#L170"}}),le=new he({props:{name:"resize",anchor:"transformers.SuperPointImageProcessor.resize",parameters:[{name:"image",val:": ndarray"},{name:"size",val:": typing.Dict[str, int]"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperPointImageProcessor.resize.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to resize.`,name:"image"},{anchor:"transformers.SuperPointImageProcessor.resize.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>) &#x2014;
Dictionary of the form <code>{&quot;height&quot;: int, &quot;width&quot;: int}</code>, specifying the size of the output image.`,name:"size"},{anchor:"transformers.SuperPointImageProcessor.resize.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the output image. If not provided, it will be inferred from the input
image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.SuperPointImageProcessor.resize.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/image_processing_superpoint.py#L131"}}),pe=new ge({props:{title:"SuperPointForKeypointDetection",local:"transformers.SuperPointForKeypointDetection",headingTag:"h2"}}),de=new he({props:{name:"class transformers.SuperPointForKeypointDetection",anchor:"transformers.SuperPointForKeypointDetection",parameters:[{name:"config",val:": SuperPointConfig"}],parametersDescription:[{anchor:"transformers.SuperPointForKeypointDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/superpoint#transformers.SuperPointConfig">SuperPointConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/modeling_superpoint.py#L391"}}),me=new he({props:{name:"forward",anchor:"transformers.SuperPointForKeypointDetection.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SuperPointForKeypointDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/superpoint#transformers.SuperPointImageProcessor">SuperPointImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">SuperPointImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.SuperPointForKeypointDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for more
detail.`,name:"output_hidden_states"},{anchor:"transformers.SuperPointForKeypointDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.</p>
<p>Examples:`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/modeling_superpoint.py#L416"}}),W=new oo({props:{$$slots:{default:[ao]},$$scope:{ctx:ye}}}),fe=new so({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/superpoint.md"}}),{c(){p=a("meta"),U=s(),_=a("p"),w=s(),d(J.$$.fragment),y=s(),d($.$$.fragment),Se=s(),q=a("p"),q.innerHTML=Jt,Ie=s(),D=a("p"),D.textContent=Ct,je=s(),Z=a("p"),Z.textContent=$t,xe=s(),G=a("p"),G.innerHTML=Pt,ze=s(),j=a("img"),ke=s(),H=a("small"),H.innerHTML=St,Ve=s(),d(N.$$.fragment),We=s(),B=a("p"),B.textContent=It,Re=s(),d(E.$$.fragment),qe=s(),F=a("p"),F.textContent=jt,De=s(),L=a("p"),L.textContent=xt,Ze=s(),d(X.$$.fragment),Ge=s(),Q=a("p"),Q.textContent=zt,He=s(),d(Y.$$.fragment),Ne=s(),A=a("p"),A.innerHTML=kt,Be=s(),K=a("p"),K.innerHTML=Vt,Ee=s(),d(O.$$.fragment),Fe=s(),ee=a("p"),ee.textContent=Wt,Le=s(),te=a("ul"),te.innerHTML=Rt,Xe=s(),d(oe.$$.fragment),Qe=s(),T=a("div"),d(ne.$$.fragment),ct=s(),_e=a("p"),_e.innerHTML=qt,pt=s(),be=a("p"),be.innerHTML=Dt,dt=s(),d(x.$$.fragment),Ye=s(),d(se.$$.fragment),Ae=s(),b=a("div"),d(re.$$.fragment),mt=s(),we=a("p"),we.textContent=Zt,ut=s(),z=a("div"),d(ae.$$.fragment),ft=s(),Te=a("p"),Te.innerHTML=Gt,ht=s(),k=a("div"),d(ie.$$.fragment),gt=s(),Me=a("p"),Me.textContent=Ht,yt=s(),V=a("div"),d(le.$$.fragment),_t=s(),ve=a("p"),ve.textContent=Nt,Ke=s(),ce=a("ul"),ce.innerHTML=Bt,Oe=s(),d(pe.$$.fragment),et=s(),M=a("div"),d(de.$$.fragment),bt=s(),Je=a("p"),Je.innerHTML=Et,wt=s(),Ce=a("p"),Ce.innerHTML=Ft,Tt=s(),S=a("div"),d(me.$$.fragment),Mt=s(),$e=a("p"),$e.innerHTML=Lt,vt=s(),d(W.$$.fragment),tt=s(),ue=a("ul"),ue.innerHTML=Xt,ot=s(),d(fe.$$.fragment),nt=s(),Ue=a("p"),this.h()},l(e){const t=to("svelte-u9bgzb",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(o),U=r(e),_=i(e,"P",{}),I(_).forEach(o),w=r(e),m(J.$$.fragment,e),y=r(e),m($.$$.fragment,e),Se=r(e),q=i(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-3y1k2h"&&(q.innerHTML=Jt),Ie=r(e),D=i(e,"P",{"data-svelte-h":!0}),c(D)!=="svelte-113tmz"&&(D.textContent=Ct),je=r(e),Z=i(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-vfdo9a"&&(Z.textContent=$t),xe=r(e),G=i(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-110fra1"&&(G.innerHTML=Pt),ze=r(e),j=i(e,"IMG",{src:!0,alt:!0,width:!0}),ke=r(e),H=i(e,"SMALL",{"data-svelte-h":!0}),c(H)!=="svelte-1md4ofy"&&(H.innerHTML=St),Ve=r(e),m(N.$$.fragment,e),We=r(e),B=i(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-u2cob9"&&(B.textContent=It),Re=r(e),m(E.$$.fragment,e),qe=r(e),F=i(e,"P",{"data-svelte-h":!0}),c(F)!=="svelte-qs9qlh"&&(F.textContent=jt),De=r(e),L=i(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-g88i9e"&&(L.textContent=xt),Ze=r(e),m(X.$$.fragment,e),Ge=r(e),Q=i(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-1ak0l5f"&&(Q.textContent=zt),He=r(e),m(Y.$$.fragment,e),Ne=r(e),A=i(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-oxei2o"&&(A.innerHTML=kt),Be=r(e),K=i(e,"P",{"data-svelte-h":!0}),c(K)!=="svelte-1s32sqj"&&(K.innerHTML=Vt),Ee=r(e),m(O.$$.fragment,e),Fe=r(e),ee=i(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-1tjytfm"&&(ee.textContent=Wt),Le=r(e),te=i(e,"UL",{"data-svelte-h":!0}),c(te)!=="svelte-1w6ygh7"&&(te.innerHTML=Rt),Xe=r(e),m(oe.$$.fragment,e),Qe=r(e),T=i(e,"DIV",{class:!0});var P=I(T);m(ne.$$.fragment,P),ct=r(P),_e=i(P,"P",{"data-svelte-h":!0}),c(_e)!=="svelte-rmywrk"&&(_e.innerHTML=qt),pt=r(P),be=i(P,"P",{"data-svelte-h":!0}),c(be)!=="svelte-o55m63"&&(be.innerHTML=Dt),dt=r(P),m(x.$$.fragment,P),P.forEach(o),Ye=r(e),m(se.$$.fragment,e),Ae=r(e),b=i(e,"DIV",{class:!0});var v=I(b);m(re.$$.fragment,v),mt=r(v),we=i(v,"P",{"data-svelte-h":!0}),c(we)!=="svelte-bn94yj"&&(we.textContent=Zt),ut=r(v),z=i(v,"DIV",{class:!0});var rt=I(z);m(ae.$$.fragment,rt),ft=r(rt),Te=i(rt,"P",{"data-svelte-h":!0}),c(Te)!=="svelte-14d1kg5"&&(Te.innerHTML=Gt),rt.forEach(o),ht=r(v),k=i(v,"DIV",{class:!0});var at=I(k);m(ie.$$.fragment,at),gt=r(at),Me=i(at,"P",{"data-svelte-h":!0}),c(Me)!=="svelte-1x3yxsa"&&(Me.textContent=Ht),at.forEach(o),yt=r(v),V=i(v,"DIV",{class:!0});var it=I(V);m(le.$$.fragment,it),_t=r(it),ve=i(it,"P",{"data-svelte-h":!0}),c(ve)!=="svelte-1eb2h1k"&&(ve.textContent=Nt),it.forEach(o),v.forEach(o),Ke=r(e),ce=i(e,"UL",{"data-svelte-h":!0}),c(ce)!=="svelte-166rkny"&&(ce.innerHTML=Bt),Oe=r(e),m(pe.$$.fragment,e),et=r(e),M=i(e,"DIV",{class:!0});var R=I(M);m(de.$$.fragment,R),bt=r(R),Je=i(R,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-1jukl7g"&&(Je.innerHTML=Et),wt=r(R),Ce=i(R,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-1177mku"&&(Ce.innerHTML=Ft),Tt=r(R),S=i(R,"DIV",{class:!0});var Pe=I(S);m(me.$$.fragment,Pe),Mt=r(Pe),$e=i(Pe,"P",{"data-svelte-h":!0}),c($e)!=="svelte-1kya80i"&&($e.innerHTML=Lt),vt=r(Pe),m(W.$$.fragment,Pe),Pe.forEach(o),R.forEach(o),tt=r(e),ue=i(e,"UL",{"data-svelte-h":!0}),c(ue)!=="svelte-n3ow4o"&&(ue.innerHTML=Xt),ot=r(e),m(fe.$$.fragment,e),nt=r(e),Ue=i(e,"P",{}),I(Ue).forEach(o),this.h()},h(){C(p,"name","hf:doc:metadata"),C(p,"content",lo),At(j.src,Ut="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/superpoint_architecture.png")||C(j,"src",Ut),C(j,"alt","drawing"),C(j,"width","500"),C(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){l(document.head,p),n(e,U,t),n(e,_,t),n(e,w,t),u(J,e,t),n(e,y,t),u($,e,t),n(e,Se,t),n(e,q,t),n(e,Ie,t),n(e,D,t),n(e,je,t),n(e,Z,t),n(e,xe,t),n(e,G,t),n(e,ze,t),n(e,j,t),n(e,ke,t),n(e,H,t),n(e,Ve,t),u(N,e,t),n(e,We,t),n(e,B,t),n(e,Re,t),u(E,e,t),n(e,qe,t),n(e,F,t),n(e,De,t),n(e,L,t),n(e,Ze,t),u(X,e,t),n(e,Ge,t),n(e,Q,t),n(e,He,t),u(Y,e,t),n(e,Ne,t),n(e,A,t),n(e,Be,t),n(e,K,t),n(e,Ee,t),u(O,e,t),n(e,Fe,t),n(e,ee,t),n(e,Le,t),n(e,te,t),n(e,Xe,t),u(oe,e,t),n(e,Qe,t),n(e,T,t),u(ne,T,null),l(T,ct),l(T,_e),l(T,pt),l(T,be),l(T,dt),u(x,T,null),n(e,Ye,t),u(se,e,t),n(e,Ae,t),n(e,b,t),u(re,b,null),l(b,mt),l(b,we),l(b,ut),l(b,z),u(ae,z,null),l(z,ft),l(z,Te),l(b,ht),l(b,k),u(ie,k,null),l(k,gt),l(k,Me),l(b,yt),l(b,V),u(le,V,null),l(V,_t),l(V,ve),n(e,Ke,t),n(e,ce,t),n(e,Oe,t),u(pe,e,t),n(e,et,t),n(e,M,t),u(de,M,null),l(M,bt),l(M,Je),l(M,wt),l(M,Ce),l(M,Tt),l(M,S),u(me,S,null),l(S,Mt),l(S,$e),l(S,vt),u(W,S,null),n(e,tt,t),n(e,ue,t),n(e,ot,t),u(fe,e,t),n(e,nt,t),n(e,Ue,t),st=!0},p(e,[t]){const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),x.$set(P);const v={};t&2&&(v.$$scope={dirty:t,ctx:e}),W.$set(v)},i(e){st||(f(J.$$.fragment,e),f($.$$.fragment,e),f(N.$$.fragment,e),f(E.$$.fragment,e),f(X.$$.fragment,e),f(Y.$$.fragment,e),f(O.$$.fragment,e),f(oe.$$.fragment,e),f(ne.$$.fragment,e),f(x.$$.fragment,e),f(se.$$.fragment,e),f(re.$$.fragment,e),f(ae.$$.fragment,e),f(ie.$$.fragment,e),f(le.$$.fragment,e),f(pe.$$.fragment,e),f(de.$$.fragment,e),f(me.$$.fragment,e),f(W.$$.fragment,e),f(fe.$$.fragment,e),st=!0)},o(e){h(J.$$.fragment,e),h($.$$.fragment,e),h(N.$$.fragment,e),h(E.$$.fragment,e),h(X.$$.fragment,e),h(Y.$$.fragment,e),h(O.$$.fragment,e),h(oe.$$.fragment,e),h(ne.$$.fragment,e),h(x.$$.fragment,e),h(se.$$.fragment,e),h(re.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(le.$$.fragment,e),h(pe.$$.fragment,e),h(de.$$.fragment,e),h(me.$$.fragment,e),h(W.$$.fragment,e),h(fe.$$.fragment,e),st=!1},d(e){e&&(o(U),o(_),o(w),o(y),o(Se),o(q),o(Ie),o(D),o(je),o(Z),o(xe),o(G),o(ze),o(j),o(ke),o(H),o(Ve),o(We),o(B),o(Re),o(qe),o(F),o(De),o(L),o(Ze),o(Ge),o(Q),o(He),o(Ne),o(A),o(Be),o(K),o(Ee),o(Fe),o(ee),o(Le),o(te),o(Xe),o(Qe),o(T),o(Ye),o(Ae),o(b),o(Ke),o(ce),o(Oe),o(et),o(M),o(tt),o(ue),o(ot),o(nt),o(Ue)),o(p),g(J,e),g($,e),g(N,e),g(E,e),g(X,e),g(Y,e),g(O,e),g(oe,e),g(ne),g(x),g(se,e),g(re),g(ae),g(ie),g(le),g(pe,e),g(de),g(me),g(W),g(fe,e)}}}const lo='{"title":"SuperPoint","local":"superpoint","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"SuperPointConfig","local":"transformers.SuperPointConfig","sections":[],"depth":2},{"title":"SuperPointImageProcessor","local":"transformers.SuperPointImageProcessor","sections":[],"depth":2},{"title":"SuperPointForKeypointDetection","local":"transformers.SuperPointForKeypointDetection","sections":[],"depth":2}],"depth":1}';function co(ye){return Kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _o extends Ot{constructor(p){super(),eo(this,p,co,io,Yt,{})}}export{_o as component};
