import{s as El,n as Wl,o as kl}from"../chunks/scheduler.25b97de1.js";import{S as Gl,i as $l,g as M,s as a,r as p,A as Xl,h as i,f as e,c as n,j as Rl,u as r,x as o,k as il,y as Vl,a as s,v as y,d as j,t as m,w as U}from"../chunks/index.d9030fc9.js";import{C as c}from"../chunks/CodeBlock.e6cd0d95.js";import{D as Nl}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{H as yt,E as Hl}from"../chunks/EditOnGithub.91d95064.js";function Sl(ol){let u,jt,pt,mt,h,Ut,w,ct,d,pl="Image-text-to-text models, also known as vision language models (VLMs), are language models that take an image input. These models can tackle various tasks, from visual question answering to image segmentation. This task shares many similarities with image-to-text, but with some overlapping use cases like image captioning. Image-to-text models only take image inputs and often accomplish a specific task, whereas VLMs take open-ended text and image inputs and are more generalist models.",ut,g,rl="In this guide, we provide a brief overview of VLMs and show how to use them with Transformers for inference.",Jt,A,yl="To begin with, there are multiple types of VLMs:",Tt,C,jl="<li>base models used for fine-tuning</li> <li>chat fine-tuned models for conversation</li> <li>instruction fine-tuned models</li>",ht,I,ml="This guide focuses on inference with an instruction-tuned model.",wt,f,Ul="Let’s begin installing the dependencies.",dt,b,gt,Z,cl="Let’s initialize the model and the processor.",At,B,Ct,x,ul='This model has a <a href="./chat_templating">chat template</a> that helps user parse chat outputs. Moreover, the model can also accept multiple images as input in a single conversation or message. We will now prepare the inputs.',It,v,Jl="The image inputs look like the following.",ft,J,Tl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/cats.png" alt="Two cats sitting on a net"/>',bt,T,hl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg" alt="A bee on a pink flower"/>',Zt,q,Bt,Q,wl="Below is an example of the chat template. We can feed conversation turns and the last message as an input by appending it at the end of the template.",xt,_,vt,R,dl='We will now call the processors’ <a href="/docs/transformers/main/en/main_classes/processors#transformers.ProcessorMixin.apply_chat_template">apply_chat_template()</a> method to preprocess its output along with the image inputs.',qt,E,Qt,W,gl="We can now pass the preprocessed inputs to the model.",_t,k,Rt,G,Et,$,Al='The fastest way to get started is to use the <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a> API. Specify the <code>&quot;image-text-to-text&quot;</code> task and the model you want to use.',Wt,X,kt,V,Cl="The example below uses chat templates to format the text inputs.",Gt,N,$t,H,Il='Pass the chat template formatted text and image to <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a> and set <code>return_full_text=False</code> to remove the input from the generated output.',Xt,S,Vt,z,Nt,F,fl='We can use <a href="./generation_strategies#streaming">text streaming</a> for a better generation experience. Transformers supports streaming with the <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TextStreamer">TextStreamer</a> or <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TextIteratorStreamer">TextIteratorStreamer</a> classes. We will use the <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TextIteratorStreamer">TextIteratorStreamer</a> with IDEFICS-8B.',Ht,Y,bl='Assume we have an application that keeps chat history and takes in the new user input. We will preprocess the inputs as usual and initialize <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TextIteratorStreamer">TextIteratorStreamer</a> to handle the generation in a separate thread. This allows you to stream the generated text tokens in real-time. Any generation arguments can be passed to <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TextIteratorStreamer">TextIteratorStreamer</a>.',St,L,zt,P,Zl="Now let’s call the <code>model_inference</code> function we created and stream the values.",Ft,D,Yt,K,Lt,O,Bl='VLMs are often large and need to be optimized to fit on smaller hardware. Transformers supports many model quantization libraries, and here we will only show int8 quantization with <a href="./quantization/quanto#quanto">Quanto</a>. int8 quantization offers memory improvements up to 75 percent (if all weights are quantized). However it is no free lunch, since 8-bit is not a CUDA-native precision, the weights are quantized back and forth on the fly, which adds up to latency.',Pt,tt,xl="First, install dependencies.",Dt,lt,Kt,et,vl='To quantize a model during loading, we need to first create <a href="/docs/transformers/main/en/main_classes/quantization#transformers.QuantoConfig">QuantoConfig</a>. Then load the model as usual, but pass <code>quantization_config</code> during model initialization.',Ot,st,tl,at,ql="And that’s it, we can use the model the same way with no changes.",ll,nt,el,Mt,Ql="Here are some more resources for the image-text-to-text task.",sl,it,_l='<li><a href="https://huggingface.co/tasks/image-text-to-text" rel="nofollow">Image-text-to-text task page</a> covers model types, use cases, datasets, and more.</li> <li><a href="https://huggingface.co/blog/vlms" rel="nofollow">Vision Language Models Explained</a> is a blog post that covers everything about vision language models and supervised fine-tuning using <a href="https://huggingface.co/docs/trl/en/index" rel="nofollow">TRL</a>.</li>',al,ot,nl,rt,Ml;return h=new yt({props:{title:"Image-text-to-text",local:"image-text-to-text",headingTag:"h1"}}),w=new Nl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/image_text_to_text.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_text_to_text.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_text_to_text.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/image_text_to_text.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_text_to_text.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_text_to_text.ipynb"}]}}),b=new c({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMGZsYXNoX2F0dG4=",highlighted:"pip install -q transformers accelerate flash_attn",wrap:!1}}),B=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRldmljZSUyMCUzRCUyMHRvcmNoLmRldmljZSglMjJjdWRhJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VUZXh0VG9UZXh0LmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJIdWdnaW5nRmFjZU00JTJGaWRlZmljczItOGIlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTJDJTBBKS50byhkZXZpY2UpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VNNCUyRmlkZWZpY3MyLThiJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText
<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>)
model = AutoModelForImageTextToText.from_pretrained(
    <span class="hljs-string">&quot;HuggingFaceM4/idefics2-8b&quot;</span>,
    torch_dtype=torch.bfloat16,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
).to(device)

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;HuggingFaceM4/idefics2-8b&quot;</span>)`,wrap:!1}}),q=new c({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEFpbWdfdXJscyUyMCUzRCU1QiUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmNhdHMucG5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGYmVlLmpwZyUyMiU1RCUwQWltYWdlcyUyMCUzRCUyMCU1QkltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KGltZ191cmxzJTVCMCU1RCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldChpbWdfdXJscyU1QjElNUQlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTVE",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

img_urls =[<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/cats.png&quot;</span>,
           <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg&quot;</span>]
images = [Image.<span class="hljs-built_in">open</span>(requests.get(img_urls[<span class="hljs-number">0</span>], stream=<span class="hljs-literal">True</span>).raw),
          Image.<span class="hljs-built_in">open</span>(requests.get(img_urls[<span class="hljs-number">1</span>], stream=<span class="hljs-literal">True</span>).raw)]`,wrap:!1}}),_=new c({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJXaGF0JTIwZG8lMjB3ZSUyMHNlZSUyMGluJTIwdGhpcyUyMGltYWdlJTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJJbiUyMHRoaXMlMjBpbWFnZSUyMHdlJTIwY2FuJTIwc2VlJTIwdHdvJTIwY2F0cyUyMG9uJTIwdGhlJTIwbmV0cy4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJBbmQlMjBob3clMjBhYm91dCUyMHRoaXMlMjBpbWFnZSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSU1RA==",highlighted:`messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What do we see in this image?&quot;</span>},
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;In this image we can see two cats on the nets.&quot;</span>},
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;And how about this image?&quot;</span>},
        ]
    },
]`,wrap:!1}}),E=new c({props:{code:"cHJvbXB0JTIwJTNEJTIwcHJvY2Vzc29yLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlKSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEcHJvbXB0JTJDJTIwaW1hZ2VzJTNEJTVCaW1hZ2VzJTVCMCU1RCUyQyUyMGltYWdlcyU1QjElNUQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhkZXZpY2Up",highlighted:`prompt = processor.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>)
inputs = processor(text=prompt, images=[images[<span class="hljs-number">0</span>], images[<span class="hljs-number">1</span>]], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)`,wrap:!1}}),k=new c({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNENTAwKSUwQWdlbmVyYXRlZF90ZXh0cyUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQSUwQXByaW50KGdlbmVyYXRlZF90ZXh0cyklMEElMjMlMjMlMjAlNUInVXNlciUzQSUyMFdoYXQlMjBkbyUyMHdlJTIwc2VlJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlMjAlNUNuQXNzaXN0YW50JTNBJTIwSW4lMjB0aGlzJTIwaW1hZ2UlMjB3ZSUyMGNhbiUyMHNlZSUyMHR3byUyMGNhdHMlMjBvbiUyMHRoZSUyMG5ldHMuJTIwJTVDblVzZXIlM0ElMjBBbmQlMjBob3clMjBhYm91dCUyMHRoaXMlMjBpbWFnZSUzRiUyMCU1Q25Bc3Npc3RhbnQlM0ElMjBJbiUyMHRoaXMlMjBpbWFnZSUyMHdlJTIwY2FuJTIwc2VlJTIwZmxvd2VycyUyQyUyMHBsYW50cyUyMGFuZCUyMGluc2VjdC4nJTVE",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">500</span>)
generated_texts = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-built_in">print</span>(generated_texts)
<span class="hljs-comment">## [&#x27;User: What do we see in this image? \\nAssistant: In this image we can see two cats on the nets. \\nUser: And how about this image? \\nAssistant: In this image we can see flowers, plants and insect.&#x27;]</span>`,wrap:!1}}),G=new yt({props:{title:"Pipeline",local:"pipeline",headingTag:"h2"}}),X=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmltYWdlLXRleHQtdG8tdGV4dCUyMiUyQyUyMG1vZGVsJTNEJTIybGxhdmEtaGYlMkZsbGF2YS1pbnRlcmxlYXZlLXF3ZW4tMC41Yi1oZiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
pipe = pipeline(<span class="hljs-string">&quot;image-text-to-text&quot;</span>, model=<span class="hljs-string">&quot;llava-hf/llava-interleave-qwen-0.5b-hf&quot;</span>)`,wrap:!1}}),N=new c({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbWFnZSUyMiUzQSUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmJlZS5qcGclMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJEZXNjcmliZSUyMHRoaXMlMjBpbWFnZS4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMlRoZXJlJ3MlMjBhJTIwcGluayUyMGZsb3dlciUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCU1RA==",highlighted:`messages = [
     {
         <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
         <span class="hljs-string">&quot;content&quot;</span>: [
             {
                 <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>,
                 <span class="hljs-string">&quot;image&quot;</span>: <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg&quot;</span>,
             },
             {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe this image.&quot;</span>},
         ],
     },
     {
         <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
         <span class="hljs-string">&quot;content&quot;</span>: [
             {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;There&#x27;s a pink flower&quot;</span>},
         ],
     },
 ]`,wrap:!1}}),S=new c({props:{code:"b3V0cHV0cyUyMCUzRCUyMHBpcGUodGV4dCUzRG1lc3NhZ2VzJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCUyQyUyMHJldHVybl9mdWxsX3RleHQlM0RGYWxzZSklMEFvdXRwdXRzJTVCMCU1RCU1QiUyMmdlbmVyYXRlZF90ZXh0JTIyJTVEJTBBJTIzJTIwJTIwd2l0aCUyMGElMjB5ZWxsb3clMjBjZW50ZXIlMjBpbiUyMHRoZSUyMGZvcmVncm91bmQuJTIwVGhlJTIwZmxvd2VyJTIwaXMlMjBzdXJyb3VuZGVkJTIwYnklMjByZWQlMjBhbmQlMjB3aGl0ZSUyMGZsb3dlcnMlMjB3aXRoJTIwZ3JlZW4lMjBzdGVtcw==",highlighted:`outputs = pipe(text=messages, max_new_tokens=<span class="hljs-number">20</span>, return_full_text=<span class="hljs-literal">False</span>)
outputs[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>]
<span class="hljs-comment">#  with a yellow center in the foreground. The flower is surrounded by red and white flowers with green stems</span>`,wrap:!1}}),z=new yt({props:{title:"Streaming",local:"streaming",headingTag:"h2"}}),L=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TextIteratorStreamer
<span class="hljs-keyword">from</span> threading <span class="hljs-keyword">import</span> Thread

<span class="hljs-keyword">def</span> <span class="hljs-title function_">model_inference</span>(<span class="hljs-params">
    user_prompt,
    chat_history,
    max_new_tokens,
    images
</span>):
    user_prompt = {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: user_prompt},
        ]
    }
    chat_history.append(user_prompt)
    streamer = TextIteratorStreamer(
        processor.tokenizer,
        skip_prompt=<span class="hljs-literal">True</span>,
        timeout=<span class="hljs-number">5.0</span>,
    )

    generation_args = {
        <span class="hljs-string">&quot;max_new_tokens&quot;</span>: max_new_tokens,
        <span class="hljs-string">&quot;streamer&quot;</span>: streamer,
        <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">False</span>
    }

    <span class="hljs-comment"># add_generation_prompt=True makes model generate bot response</span>
    prompt = processor.apply_chat_template(chat_history, add_generation_prompt=<span class="hljs-literal">True</span>)
    inputs = processor(
        text=prompt,
        images=images,
        return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    ).to(device)
    generation_args.update(inputs)

    thread = Thread(
        target=model.generate,
        kwargs=generation_args,
    )
    thread.start()

    acc_text = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">for</span> text_token <span class="hljs-keyword">in</span> streamer:
        time.sleep(<span class="hljs-number">0.04</span>)
        acc_text += text_token
        <span class="hljs-keyword">if</span> acc_text.endswith(<span class="hljs-string">&quot;&lt;end_of_utterance&gt;&quot;</span>):
            acc_text = acc_text[:-<span class="hljs-number">18</span>]
        <span class="hljs-keyword">yield</span> acc_text

    thread.join()`,wrap:!1}}),D=new c({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwbW9kZWxfaW5mZXJlbmNlKCUwQSUyMCUyMCUyMCUyMHVzZXJfcHJvbXB0JTNEJTIyQW5kJTIwd2hhdCUyMGlzJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjBjaGF0X2hpc3RvcnklM0RtZXNzYWdlcyU1QiUzQTIlNUQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlcyUzRGltYWdlcyUwQSklMEElMEFmb3IlMjB2YWx1ZSUyMGluJTIwZ2VuZXJhdG9yJTNBJTBBJTIwJTIwcHJpbnQodmFsdWUpJTBBJTBBJTIzJTIwSW4lMEElMjMlMjBJbiUyMHRoaXMlMEElMjMlMjBJbiUyMHRoaXMlMjBpbWFnZSUyMC4uLg==",highlighted:`generator = model_inference(
    user_prompt=<span class="hljs-string">&quot;And what is in this image?&quot;</span>,
    chat_history=messages[:<span class="hljs-number">2</span>],
    max_new_tokens=<span class="hljs-number">100</span>,
    images=images
)

<span class="hljs-keyword">for</span> value <span class="hljs-keyword">in</span> generator:
  <span class="hljs-built_in">print</span>(value)

<span class="hljs-comment"># In</span>
<span class="hljs-comment"># In this</span>
<span class="hljs-comment"># In this image ...</span>`,wrap:!1}}),K=new yt({props:{title:"Fit models in smaller hardware",local:"fit-models-in-smaller-hardware",headingTag:"h2"}}),lt=new c({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwcXVhbnRvJTIwYml0c2FuZGJ5dGVz",highlighted:"pip install -U quanto bitsandbytes",wrap:!1}}),st=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlVGV4dFRvVGV4dCUyQyUyMFF1YW50b0NvbmZpZyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIySHVnZ2luZ0ZhY2VNNCUyRmlkZWZpY3MyLThiJTIyJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMFF1YW50b0NvbmZpZyh3ZWlnaHRzJTNEJTIyaW50OCUyMiklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageTextToText, QuantoConfig

model_id = <span class="hljs-string">&quot;HuggingFaceM4/idefics2-8b&quot;</span>
quantization_config = QuantoConfig(weights=<span class="hljs-string">&quot;int8&quot;</span>)
quantized_model = AutoModelForImageTextToText.from_pretrained(
    model_id, device_map=<span class="hljs-string">&quot;cuda&quot;</span>, quantization_config=quantization_config
)`,wrap:!1}}),nt=new yt({props:{title:"Further Reading",local:"further-reading",headingTag:"h2"}}),ot=new Hl({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/image_text_to_text.md"}}),{c(){u=M("meta"),jt=a(),pt=M("p"),mt=a(),p(h.$$.fragment),Ut=a(),p(w.$$.fragment),ct=a(),d=M("p"),d.textContent=pl,ut=a(),g=M("p"),g.textContent=rl,Jt=a(),A=M("p"),A.textContent=yl,Tt=a(),C=M("ul"),C.innerHTML=jl,ht=a(),I=M("p"),I.textContent=ml,wt=a(),f=M("p"),f.textContent=Ul,dt=a(),p(b.$$.fragment),gt=a(),Z=M("p"),Z.textContent=cl,At=a(),p(B.$$.fragment),Ct=a(),x=M("p"),x.innerHTML=ul,It=a(),v=M("p"),v.textContent=Jl,ft=a(),J=M("div"),J.innerHTML=Tl,bt=a(),T=M("div"),T.innerHTML=hl,Zt=a(),p(q.$$.fragment),Bt=a(),Q=M("p"),Q.textContent=wl,xt=a(),p(_.$$.fragment),vt=a(),R=M("p"),R.innerHTML=dl,qt=a(),p(E.$$.fragment),Qt=a(),W=M("p"),W.textContent=gl,_t=a(),p(k.$$.fragment),Rt=a(),p(G.$$.fragment),Et=a(),$=M("p"),$.innerHTML=Al,Wt=a(),p(X.$$.fragment),kt=a(),V=M("p"),V.textContent=Cl,Gt=a(),p(N.$$.fragment),$t=a(),H=M("p"),H.innerHTML=Il,Xt=a(),p(S.$$.fragment),Vt=a(),p(z.$$.fragment),Nt=a(),F=M("p"),F.innerHTML=fl,Ht=a(),Y=M("p"),Y.innerHTML=bl,St=a(),p(L.$$.fragment),zt=a(),P=M("p"),P.innerHTML=Zl,Ft=a(),p(D.$$.fragment),Yt=a(),p(K.$$.fragment),Lt=a(),O=M("p"),O.innerHTML=Bl,Pt=a(),tt=M("p"),tt.textContent=xl,Dt=a(),p(lt.$$.fragment),Kt=a(),et=M("p"),et.innerHTML=vl,Ot=a(),p(st.$$.fragment),tl=a(),at=M("p"),at.textContent=ql,ll=a(),p(nt.$$.fragment),el=a(),Mt=M("p"),Mt.textContent=Ql,sl=a(),it=M("ul"),it.innerHTML=_l,al=a(),p(ot.$$.fragment),nl=a(),rt=M("p"),this.h()},l(t){const l=Xl("svelte-u9bgzb",document.head);u=i(l,"META",{name:!0,content:!0}),l.forEach(e),jt=n(t),pt=i(t,"P",{}),Rl(pt).forEach(e),mt=n(t),r(h.$$.fragment,t),Ut=n(t),r(w.$$.fragment,t),ct=n(t),d=i(t,"P",{"data-svelte-h":!0}),o(d)!=="svelte-16zti1"&&(d.textContent=pl),ut=n(t),g=i(t,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1fk5u1j"&&(g.textContent=rl),Jt=n(t),A=i(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-ql8pa"&&(A.textContent=yl),Tt=n(t),C=i(t,"UL",{"data-svelte-h":!0}),o(C)!=="svelte-1vpzkb0"&&(C.innerHTML=jl),ht=n(t),I=i(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1m8dinx"&&(I.textContent=ml),wt=n(t),f=i(t,"P",{"data-svelte-h":!0}),o(f)!=="svelte-5jp6fp"&&(f.textContent=Ul),dt=n(t),r(b.$$.fragment,t),gt=n(t),Z=i(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1rw69r9"&&(Z.textContent=cl),At=n(t),r(B.$$.fragment,t),Ct=n(t),x=i(t,"P",{"data-svelte-h":!0}),o(x)!=="svelte-sa4wix"&&(x.innerHTML=ul),It=n(t),v=i(t,"P",{"data-svelte-h":!0}),o(v)!=="svelte-5oehs9"&&(v.textContent=Jl),ft=n(t),J=i(t,"DIV",{class:!0,"data-svelte-h":!0}),o(J)!=="svelte-z5b734"&&(J.innerHTML=Tl),bt=n(t),T=i(t,"DIV",{class:!0,"data-svelte-h":!0}),o(T)!=="svelte-vw53ct"&&(T.innerHTML=hl),Zt=n(t),r(q.$$.fragment,t),Bt=n(t),Q=i(t,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-it4u80"&&(Q.textContent=wl),xt=n(t),r(_.$$.fragment,t),vt=n(t),R=i(t,"P",{"data-svelte-h":!0}),o(R)!=="svelte-dclbpo"&&(R.innerHTML=dl),qt=n(t),r(E.$$.fragment,t),Qt=n(t),W=i(t,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1c12q4j"&&(W.textContent=gl),_t=n(t),r(k.$$.fragment,t),Rt=n(t),r(G.$$.fragment,t),Et=n(t),$=i(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-1wgz4d8"&&($.innerHTML=Al),Wt=n(t),r(X.$$.fragment,t),kt=n(t),V=i(t,"P",{"data-svelte-h":!0}),o(V)!=="svelte-qman2s"&&(V.textContent=Cl),Gt=n(t),r(N.$$.fragment,t),$t=n(t),H=i(t,"P",{"data-svelte-h":!0}),o(H)!=="svelte-hph3ip"&&(H.innerHTML=Il),Xt=n(t),r(S.$$.fragment,t),Vt=n(t),r(z.$$.fragment,t),Nt=n(t),F=i(t,"P",{"data-svelte-h":!0}),o(F)!=="svelte-ycqsyr"&&(F.innerHTML=fl),Ht=n(t),Y=i(t,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-opb7dg"&&(Y.innerHTML=bl),St=n(t),r(L.$$.fragment,t),zt=n(t),P=i(t,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1or0ggk"&&(P.innerHTML=Zl),Ft=n(t),r(D.$$.fragment,t),Yt=n(t),r(K.$$.fragment,t),Lt=n(t),O=i(t,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1qxdmp"&&(O.innerHTML=Bl),Pt=n(t),tt=i(t,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-1kehp8k"&&(tt.textContent=xl),Dt=n(t),r(lt.$$.fragment,t),Kt=n(t),et=i(t,"P",{"data-svelte-h":!0}),o(et)!=="svelte-hu48ru"&&(et.innerHTML=vl),Ot=n(t),r(st.$$.fragment,t),tl=n(t),at=i(t,"P",{"data-svelte-h":!0}),o(at)!=="svelte-1174nfw"&&(at.textContent=ql),ll=n(t),r(nt.$$.fragment,t),el=n(t),Mt=i(t,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-n9r3vs"&&(Mt.textContent=Ql),sl=n(t),it=i(t,"UL",{"data-svelte-h":!0}),o(it)!=="svelte-30a4e"&&(it.innerHTML=_l),al=n(t),r(ot.$$.fragment,t),nl=n(t),rt=i(t,"P",{}),Rl(rt).forEach(e),this.h()},h(){il(u,"name","hf:doc:metadata"),il(u,"content",zl),il(J,"class","flex justify-center"),il(T,"class","flex justify-center")},m(t,l){Vl(document.head,u),s(t,jt,l),s(t,pt,l),s(t,mt,l),y(h,t,l),s(t,Ut,l),y(w,t,l),s(t,ct,l),s(t,d,l),s(t,ut,l),s(t,g,l),s(t,Jt,l),s(t,A,l),s(t,Tt,l),s(t,C,l),s(t,ht,l),s(t,I,l),s(t,wt,l),s(t,f,l),s(t,dt,l),y(b,t,l),s(t,gt,l),s(t,Z,l),s(t,At,l),y(B,t,l),s(t,Ct,l),s(t,x,l),s(t,It,l),s(t,v,l),s(t,ft,l),s(t,J,l),s(t,bt,l),s(t,T,l),s(t,Zt,l),y(q,t,l),s(t,Bt,l),s(t,Q,l),s(t,xt,l),y(_,t,l),s(t,vt,l),s(t,R,l),s(t,qt,l),y(E,t,l),s(t,Qt,l),s(t,W,l),s(t,_t,l),y(k,t,l),s(t,Rt,l),y(G,t,l),s(t,Et,l),s(t,$,l),s(t,Wt,l),y(X,t,l),s(t,kt,l),s(t,V,l),s(t,Gt,l),y(N,t,l),s(t,$t,l),s(t,H,l),s(t,Xt,l),y(S,t,l),s(t,Vt,l),y(z,t,l),s(t,Nt,l),s(t,F,l),s(t,Ht,l),s(t,Y,l),s(t,St,l),y(L,t,l),s(t,zt,l),s(t,P,l),s(t,Ft,l),y(D,t,l),s(t,Yt,l),y(K,t,l),s(t,Lt,l),s(t,O,l),s(t,Pt,l),s(t,tt,l),s(t,Dt,l),y(lt,t,l),s(t,Kt,l),s(t,et,l),s(t,Ot,l),y(st,t,l),s(t,tl,l),s(t,at,l),s(t,ll,l),y(nt,t,l),s(t,el,l),s(t,Mt,l),s(t,sl,l),s(t,it,l),s(t,al,l),y(ot,t,l),s(t,nl,l),s(t,rt,l),Ml=!0},p:Wl,i(t){Ml||(j(h.$$.fragment,t),j(w.$$.fragment,t),j(b.$$.fragment,t),j(B.$$.fragment,t),j(q.$$.fragment,t),j(_.$$.fragment,t),j(E.$$.fragment,t),j(k.$$.fragment,t),j(G.$$.fragment,t),j(X.$$.fragment,t),j(N.$$.fragment,t),j(S.$$.fragment,t),j(z.$$.fragment,t),j(L.$$.fragment,t),j(D.$$.fragment,t),j(K.$$.fragment,t),j(lt.$$.fragment,t),j(st.$$.fragment,t),j(nt.$$.fragment,t),j(ot.$$.fragment,t),Ml=!0)},o(t){m(h.$$.fragment,t),m(w.$$.fragment,t),m(b.$$.fragment,t),m(B.$$.fragment,t),m(q.$$.fragment,t),m(_.$$.fragment,t),m(E.$$.fragment,t),m(k.$$.fragment,t),m(G.$$.fragment,t),m(X.$$.fragment,t),m(N.$$.fragment,t),m(S.$$.fragment,t),m(z.$$.fragment,t),m(L.$$.fragment,t),m(D.$$.fragment,t),m(K.$$.fragment,t),m(lt.$$.fragment,t),m(st.$$.fragment,t),m(nt.$$.fragment,t),m(ot.$$.fragment,t),Ml=!1},d(t){t&&(e(jt),e(pt),e(mt),e(Ut),e(ct),e(d),e(ut),e(g),e(Jt),e(A),e(Tt),e(C),e(ht),e(I),e(wt),e(f),e(dt),e(gt),e(Z),e(At),e(Ct),e(x),e(It),e(v),e(ft),e(J),e(bt),e(T),e(Zt),e(Bt),e(Q),e(xt),e(vt),e(R),e(qt),e(Qt),e(W),e(_t),e(Rt),e(Et),e($),e(Wt),e(kt),e(V),e(Gt),e($t),e(H),e(Xt),e(Vt),e(Nt),e(F),e(Ht),e(Y),e(St),e(zt),e(P),e(Ft),e(Yt),e(Lt),e(O),e(Pt),e(tt),e(Dt),e(Kt),e(et),e(Ot),e(tl),e(at),e(ll),e(el),e(Mt),e(sl),e(it),e(al),e(nl),e(rt)),e(u),U(h,t),U(w,t),U(b,t),U(B,t),U(q,t),U(_,t),U(E,t),U(k,t),U(G,t),U(X,t),U(N,t),U(S,t),U(z,t),U(L,t),U(D,t),U(K,t),U(lt,t),U(st,t),U(nt,t),U(ot,t)}}}const zl='{"title":"Image-text-to-text","local":"image-text-to-text","sections":[{"title":"Pipeline","local":"pipeline","sections":[],"depth":2},{"title":"Streaming","local":"streaming","sections":[],"depth":2},{"title":"Fit models in smaller hardware","local":"fit-models-in-smaller-hardware","sections":[],"depth":2},{"title":"Further Reading","local":"further-reading","sections":[],"depth":2}],"depth":1}';function Fl(ol){return kl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ol extends Gl{constructor(u){super(),$l(this,u,Fl,Sl,El,{})}}export{Ol as component};
