import{s as Rs,o as zs,n as rt}from"../chunks/scheduler.6062bdaf.js";import{S as Fs,i as Ps,g as c,s as a,r as p,A as Ks,h as r,f as n,c as l,j as As,u as d,x as o,k as Fn,y as Os,a as s,v as u,d as g,t as f,w as h}from"../chunks/index.4bca734e.js";import{T as ct}from"../chunks/Tip.b9ac1f03.js";import{C as M}from"../chunks/CodeBlock.fa01571c.js";import{H as _,E as Ds}from"../chunks/EditOnGithub.74ab2baa.js";function ea(C){let i,j=`<a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is a Python client making HTTP calls to our APIs. If you want to make the HTTP calls directly using
your preferred tool (curl, postman,…), please refer to the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>
or to the <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a> documentation pages.`,m,y,U=`For web development, a <a href="https://huggingface.co/docs/huggingface.js/inference/README" rel="nofollow">JS client</a> has been released.
If you are interested in game development, you might have a look at our <a href="https://github.com/huggingface/unity-api" rel="nofollow">C# project</a>.`;return{c(){i=c("p"),i.innerHTML=j,m=a(),y=c("p"),y.innerHTML=U},l(b){i=r(b,"P",{"data-svelte-h":!0}),o(i)!=="svelte-1be8gtn"&&(i.innerHTML=j),m=l(b),y=r(b,"P",{"data-svelte-h":!0}),o(y)!=="svelte-22w7rm"&&(y.innerHTML=U)},m(b,w){s(b,i,w),s(b,m,w),s(b,y,w)},p:rt,d(b){b&&(n(i),n(m),n(y))}}}function ta(C){let i,j=`The API is designed to be simple. Not all parameters and options are available or described for the end user. Check out
<a href="https://huggingface.co/docs/api-inference/detailed_parameters" rel="nofollow">this page</a> if you are interested in learning more about
all the parameters available for each task.`;return{c(){i=c("p"),i.innerHTML=j},l(m){i=r(m,"P",{"data-svelte-h":!0}),o(i)!=="svelte-1o4uc5e"&&(i.innerHTML=j)},m(m,y){s(m,i,y)},p:rt,d(m){m&&n(i)}}}function na(C){let i,j=`When using the Hugging Face Inference API (default provider), each task comes with a recommended model from the 200k+ models available on the Hub.
However, this recommendation can change over time, so it’s best to explicitly set a model once you’ve decided which one to use.
For third-party providers, you must always specify a model that is compatible with that provider.`,m,y,U='Visit the <a href="https://huggingface.co/models?inference=warm" rel="nofollow">Models</a> page on the Hub to explore models available through the Inference API, or check the provider’s documentation for their supported models.';return{c(){i=c("p"),i.textContent=j,m=a(),y=c("p"),y.innerHTML=U},l(b){i=r(b,"P",{"data-svelte-h":!0}),o(i)!=="svelte-1bqi6ra"&&(i.textContent=j),m=l(b),y=r(b,"P",{"data-svelte-h":!0}),o(y)!=="svelte-riv991"&&(y.innerHTML=U)},m(b,w){s(b,i,w),s(b,m,w),s(b,y,w)},p:rt,d(b){b&&(n(i),n(m),n(y))}}}function sa(C){let i,j='<code>InferenceClient.chat.completions.create</code> is simply an alias for <code>InferenceClient.chat_completion</code>. Check out the package reference of <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a> for more details. <code>base_url</code> and <code>api_key</code> parameters when instantiating the client are also aliases for <code>model</code> and <code>token</code>. These aliases have been defined to reduce friction when switching from <code>OpenAI</code> to <code>InferenceClient</code>.';return{c(){i=c("p"),i.innerHTML=j},l(m){i=r(m,"P",{"data-svelte-h":!0}),o(i)!=="svelte-1dpcgfo"&&(i.innerHTML=j)},m(m,y){s(m,i,y)},p:rt,d(m){m&&n(i)}}}function aa(C){let i,j='Check out the <a href="https://huggingface.co/tasks" rel="nofollow">Tasks</a> page to learn more about each task.';return{c(){i=c("p"),i.innerHTML=j},l(m){i=r(m,"P",{"data-svelte-h":!0}),o(i)!=="svelte-1odjvkm"&&(i.innerHTML=j)},m(m,y){s(m,i,y)},p:rt,d(m){m&&n(i)}}}function la(C){let i,j=`This is the recommended way to adapt your code to <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>. It lets you benefit from the task-specific
methods like <code>feature_extraction</code>.`;return{c(){i=c("p"),i.innerHTML=j},l(m){i=r(m,"P",{"data-svelte-h":!0}),o(i)!=="svelte-vp4r81"&&(i.innerHTML=j)},m(m,y){s(m,i,y)},p:rt,d(m){m&&n(i)}}}function ia(C){let i,j,m,y,U,b,w,Pn=`Inference is the process of using a trained model to make predictions on new data. Because this process can be compute-intensive, running on a dedicated or external service can be an interesting option.<br/>
The <code>huggingface_hub</code> library provides a unified interface to run inference across multiple services for models hosted on the Hugging Face Hub:`,pt,W,Kn='<li><a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">HF Inference API</a>: a serverless solution that allows you to run model inference on Hugging Face’s infrastructure for free. This service is a fast way to get started, test different models, and prototype AI products.</li> <li><a href="#supported-providers-and-tasks">Third-party providers</a>: various serverless solution provided by external providers (Together, Sambanova, etc.). These providers offer production-ready APIs on a pay-as-you-go model. This is the fastest way to integrate AI in your products with a maintenance-free and scalable solution. Refer to the <a href="#supported-providers-and-tasks">Supported providers and tasks</a> section for a list of supported providers.</li> <li><a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a>: a product to easily deploy models to production. Inference is run by Hugging Face in a dedicated, fully managed infrastructure on a cloud provider of your choice.</li>',dt,x,On=`These services can all be called from the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> object. It acts as a replacement for the legacy
<a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceApi">InferenceApi</a> client, adding specific support for tasks and third-party providers.
Learn how to migrate to the new client in the <a href="#legacy-inferenceapi-client">Legacy InferenceAPI client</a> section.`,ut,I,gt,q,ft,G,Dn="Let’s get started with a text-to-image task:",ht,V,mt,N,es=`In the example above, we initialized an <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> with a third-party provider, <a href="https://replicate.com/" rel="nofollow">Replicate</a>. When using a provider, you must specify the model you want to use. The model id must be the id of the model on the Hugging Face Hub, not the id of the model from the third-party provider.
In our example, we generated an image from a text prompt. The returned value is a <code>PIL.Image</code> object that can be saved to a file. For more details, check out the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_image">text_to_image()</a> documentation.`,yt,H,ts='Let’s now see an example using the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a> API. This task uses an LLM to generate a response from a list of messages:',bt,B,Mt,Q,ns='In the example above, we used a third-party provider (<a href="https://www.together.ai/" rel="nofollow">Together AI</a>) and specified which model we want to use (<code>&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</code>). We then gave a list of messages to complete (here, a single question) and passed an additional parameter to the API (<code>max_token=100</code>). The output is a <code>ChatCompletionOutput</code> object that follows the OpenAI specification. The generated content can be accessed with <code>output.choices[0].message.content</code>. For more details, check out the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a> documentation.',jt,$,_t,Y,wt,S,ss='If you want to use a specific provider, you can specify it when initializing the client. The default provider is “hf-inference”, the Hugging Face Serverless Inference API. Refer to the <a href="#supported-providers-and-tasks">Supported providers and tasks</a> section for a list of supported providers.',Ct,L,Ut,E,It,X,as="What if you want to use a specific model? You can specify it either as a parameter or directly at an instance level:",$t,A,Tt,T,Jt,R,Zt,z,ls=`The examples we saw above use either the Hugging Face Inference API or third-party providers. While these prove to be very useful for prototyping
and testing things quickly. Once you’re ready to deploy your model to production, you’ll need to use a dedicated infrastructure.
That’s where <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a> comes into play. It allows you to deploy
any model and expose it as a private API. Once deployed, you’ll get a URL that you can connect to using exactly the same
code as before, changing only the <code>model</code> parameter:`,kt,F,vt,P,is="Note that you cannot specify both a URL and a provider - they are mutually exclusive. URLs are used to connect directly to deployed endpoints.",Wt,K,xt,O,cs="Authentication depends on which provider you are using:",qt,D,rs='<li>For the default Hugging Face Inference API, you can authenticate using a <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">User Access Token</a>:</li>',Gt,ee,Vt,te,os='By default, it will use the token saved on your machine if you are logged in (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">how to authenticate</a>).',Nt,J,ps="<li>For third-party providers, you have two options:</li>",Ht,ne,ds="<strong>Direct access to provider</strong>: Use your own API key to interact directly with the provider’s service:",Bt,se,Qt,ae,us=`<strong>Routed through Hugging Face</strong> : Use Hugging Face as a proxy to access third-party providers. Simply specify
your Hugging Face token and the provider you want to use. The calls will be routed through Hugging Face’s infrastructure
using our provider keys, and the usage will be billed directly to your Hugging Face account:`,Yt,le,St,ie,Lt,ce,gs='The <code>chat_completion</code> task follows <a href="https://github.com/openai/openai-python" rel="nofollow">OpenAI’s Python client</a> syntax. What does it mean for you? It means that if you are used to play with <code>OpenAI</code>’s APIs you will be able to switch to <code>huggingface_hub.InferenceClient</code> to work with open-source models by updating just 2 line of code!',Et,re,Xt,oe,fs='And that’s it! The only required changes are to replace <code>from openai import OpenAI</code> by <code>from huggingface_hub import InferenceClient</code> and <code>client = OpenAI(...)</code> by <code>client = InferenceClient(...)</code>. You can choose any LLM model from the Hugging Face Hub by passing its model id as <code>model</code> parameter. <a href="https://huggingface.co/models?pipeline_tag=text-generation&amp;other=conversational,text-generation-inference&amp;sort=trending" rel="nofollow">Here is a list</a> of supported models. For authentication, you should pass a valid <a href="https://huggingface.co/settings/tokens" rel="nofollow">User Access Token</a> as <code>api_key</code> or authenticate using <code>huggingface_hub</code> (see the <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">authentication guide</a>).',At,pe,hs='All input parameters and output format are strictly the same. In particular, you can pass <code>stream=True</code> to receive tokens as they are generated. You can also use the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a> to run inference using <code>asyncio</code>:',Rt,de,zt,ue,ms='You might wonder why using <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> instead of OpenAI’s client? There are a few reasons for that:',Ft,ge,ys='<li><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is configured for Hugging Face services. You don’t need to provide a <code>base_url</code> to run models on the serverless Inference API. You also don’t need to provide a <code>token</code> or <code>api_key</code> if your machine is already correctly logged in.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is tailored for both Text-Generation-Inference (TGI) and <code>transformers</code> frameworks, meaning you are assured it will always be on-par with the latest updates.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is integrated with our Inference Endpoints service, making it easier to launch an Inference Endpoint, check its status and run inference on it. Check out the <a href="./inference_endpoints.md">Inference Endpoints</a> guide for more details.</li>',Pt,Z,Kt,fe,Ot,he,bs='<a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>’s goal is to provide the easiest interface to run inference on Hugging Face models, on any provider. It has a simple API that supports the most common tasks. Here is a table showing which providers support which tasks:',Dt,me,Ms='<thead><tr><th>Domain</th> <th>Task</th> <th>HF Inference</th> <th>Replicate</th> <th>fal-ai</th> <th>Sambanova</th> <th>Together</th></tr></thead> <tbody><tr><td><strong>Audio</strong></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.audio_classification">audio_classification()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.audio_to_audio">audio_to_audio()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.automatic_speech_recognition">automatic_speech_recognition()</a></td> <td>✅</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td></tr> <tr><td></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_speech">text_to_speech()</a></td> <td>✅</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><strong>Computer Vision</strong></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_classification">image_classification()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_segmentation">image_segmentation()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_to_image">image_to_image()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_to_text">image_to_text()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.object_detection">object_detection()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_image">text_to_image()</a></td> <td>✅</td> <td>✅</td> <td>✅</td> <td>❌</td> <td>✅</td></tr> <tr><td></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_video">text_to_video()</a></td> <td>❌</td> <td>✅</td> <td>✅</td> <td>❌</td> <td>❌</td></tr> <tr><td></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.zero_shot_image_classification">zero_shot_image_classification()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><strong>Multimodal</strong></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.document_question_answering">document_question_answering()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.visual_question_answering">visual_question_answering()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><strong>NLP</strong></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>✅</td></tr> <tr><td></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.feature_extraction">feature_extraction()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.fill_mask">fill_mask()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.question_answering">question_answering()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.sentence_similarity">sentence_similarity()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.summarization">summarization()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.table_question_answering">table_question_answering()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_classification">text_classification()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation">text_generation()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td></tr> <tr><td></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.token_classification">token_classification()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.translation">translation()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.zero_shot_classification">zero_shot_classification()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><strong>Tabular</strong></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.tabular_classification">tabular_classification()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td></td> <td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.tabular_regression">tabular_regression()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr></tbody>',en,k,tn,ye,nn,be,js=`However, it is not always possible to cover all use cases. For custom requests, the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.post">InferenceClient.post()</a> method
gives you the flexibility to send any request to the Inference API. For example, you can specify how to parse the inputs
and outputs. In the example below, the generated image is returned as raw bytes instead of parsing it as a <code>PIL Image</code>.
This can be helpful if you don’t have <code>Pillow</code> installed in your setup and just care about the binary content of the
image. <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.post">InferenceClient.post()</a> is also useful to handle tasks that are not yet officially supported.`,sn,Me,an,je,ln,_e,_s=`An async version of the client is also provided, based on <code>asyncio</code> and <code>aiohttp</code>. You can either install <code>aiohttp</code>
directly or use the <code>[inference]</code> extra:`,cn,we,rn,Ce,ws=`After installation all async API endpoints are available via <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a>. Its initialization and APIs are
strictly the same as the sync-only version.`,on,Ue,pn,Ie,Cs='For more information about the <code>asyncio</code> module, please refer to the <a href="https://docs.python.org/3/library/asyncio.html" rel="nofollow">official documentation</a>.',dn,$e,un,Te,Us='In the above section, we saw the main aspects of <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>. Let’s dive into some more advanced tips.',gn,Je,fn,Ze,Is="When doing inference, there are two main causes for a timeout:",hn,ke,$s="<li>The inference process takes a long time to complete.</li> <li>The model is not available, for example when Inference API is loading it for the first time.</li>",mn,ve,Ts=`<a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> has a global <code>timeout</code> parameter to handle those two aspects. By default, it is set to <code>None</code>,
meaning that the client will wait indefinitely for the inference to complete. If you want more control in your workflow,
you can set it to a specific value in seconds. If the timeout delay expires, an <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError">InferenceTimeoutError</a> is raised.
You can catch it and handle it in your code:`,yn,We,bn,xe,Mn,qe,Js=`Some tasks require binary inputs, for example, when dealing with images or audio files. In this case, <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
tries to be as permissive as possible and accept different types:`,jn,Ge,Zs=`<li>raw <code>bytes</code></li> <li>a file-like object, opened as binary (<code>with open(&quot;audio.flac&quot;, &quot;rb&quot;) as f: ...</code>)</li> <li>a path (<code>str</code> or <code>Path</code>) pointing to a local file</li> <li>a URL (<code>str</code>) pointing to a remote file (e.g. <code>https://...</code>). In this case, the file will be downloaded locally before
sending it to the Inference API.</li>`,_n,Ve,wn,Ne,Cn,He,ks=`<a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> acts as a replacement for the legacy <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceApi">InferenceApi</a> client. It adds specific support for tasks and
handles inference on both <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a> and <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a>.`,Un,Be,vs='Here is a short guide to help you migrate from <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceApi">InferenceApi</a> to <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>.',In,Qe,$n,Ye,Ws="Change from",Tn,Se,Jn,Le,xs="to",Zn,Ee,kn,Xe,vn,Ae,qs="Change from",Wn,Re,xn,ze,Gs="to",qn,Fe,Gn,v,Vn,Pe,Nn,Ke,Vs="Change from",Hn,Oe,Bn,De,Ns="to",Qn,et,Yn,tt,Sn,nt,Hs="Change from",Ln,st,En,at,Bs="to",Xn,lt,An,it,Rn,ot,zn;return U=new _({props:{title:"Run Inference on servers",local:"run-inference-on-servers",headingTag:"h1"}}),I=new ct({props:{$$slots:{default:[ea]},$$scope:{ctx:C}}}),q=new _({props:{title:"Getting started",local:"getting-started",headingTag:"h2"}}),V=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQXJlcGxpY2F0ZV9jbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoJTBBcmVwbGljYXRlX2ltYWdlJTIwJTNEJTIwcmVwbGljYXRlX2NsaWVudC50ZXh0X3RvX2ltYWdlKCUwQXJlcGxpY2F0ZV9pbWFnZS5zYXZlKCUyMmZseWluZ19jYXIucG5nJTIyKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-comment"># Example with an external provider (e.g. replicate)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>replicate_client = InferenceClient(
    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
    api_key=<span class="hljs-string">&quot;my_replicate_api_key&quot;</span>,
)
<span class="hljs-meta">&gt;&gt;&gt; </span>replicate_image = replicate_client.text_to_image(
    <span class="hljs-string">&quot;A flying car crossing a futuristic cityscape.&quot;</span>,
    model=<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
)
<span class="hljs-meta">&gt;&gt;&gt; </span>replicate_image.save(<span class="hljs-string">&quot;flying_car.png&quot;</span>)
`,wrap:!1}}),B=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUwQWNsaWVudC5jaGF0X2NvbXBsZXRpb24obWVzc2FnZXMlMkMlMjBtYXhfdG9rZW5zJTNEMTAwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>,
    }
]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
    provider=<span class="hljs-string">&quot;together&quot;</span>,
    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
    api_key=<span class="hljs-string">&quot;my_together_api_key&quot;</span>,
)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(messages, max_tokens=<span class="hljs-number">100</span>)
ChatCompletionOutput(
    choices=[
        ChatCompletionOutputComplete(
            finish_reason=<span class="hljs-string">&quot;eos_token&quot;</span>,
            index=<span class="hljs-number">0</span>,
            message=ChatCompletionOutputMessage(
                role=<span class="hljs-string">&quot;assistant&quot;</span>, content=<span class="hljs-string">&quot;The capital of France is Paris.&quot;</span>, name=<span class="hljs-literal">None</span>, tool_calls=<span class="hljs-literal">None</span>
            ),
            logprobs=<span class="hljs-literal">None</span>,
        )
    ],
    created=<span class="hljs-number">1719907176</span>,
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;&quot;</span>,
    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
    <span class="hljs-built_in">object</span>=<span class="hljs-string">&quot;text_completion&quot;</span>,
    system_fingerprint=<span class="hljs-string">&quot;2.0.4-sha-f426a33&quot;</span>,
    usage=ChatCompletionOutputUsage(completion_tokens=<span class="hljs-number">8</span>, prompt_tokens=<span class="hljs-number">17</span>, total_tokens=<span class="hljs-number">25</span>),
)`,wrap:!1}}),$=new ct({props:{warning:!0,$$slots:{default:[ta]},$$scope:{ctx:C}}}),Y=new _({props:{title:"Using a specific provider",local:"using-a-specific-provider",headingTag:"h3"}}),L=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUyMGFwaV9rZXklM0QlMjJteV9yZXBsaWNhdGVfYXBpX2tleSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(provider=<span class="hljs-string">&quot;replicate&quot;</span>, api_key=<span class="hljs-string">&quot;my_replicate_api_key&quot;</span>)`,wrap:!1}}),E=new _({props:{title:"Using a specific model",local:"using-a-specific-model",headingTag:"h3"}}),A=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMnByb21wdGhlcm8lMkZvcGVuam91cm5leS12NCUyMiklMEFjbGllbnQudGV4dF90b19pbWFnZSguLi4pJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCklMEFjbGllbnQudGV4dF90b19pbWFnZSguLi4lMkMlMjBtb2RlbCUzRCUyMnByb21wdGhlcm8lMkZvcGVuam91cm5leS12NCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-comment"># Initialize client for a specific model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(model=<span class="hljs-string">&quot;prompthero/openjourney-v4&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(...)
<span class="hljs-comment"># Or use a generic client but pass your model as an argument</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(..., model=<span class="hljs-string">&quot;prompthero/openjourney-v4&quot;</span>)`,wrap:!1}}),T=new ct({props:{$$slots:{default:[na]},$$scope:{ctx:C}}}),R=new _({props:{title:"Using a specific URL",local:"using-a-specific-url",headingTag:"h3"}}),F=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMmh0dHBzJTNBJTJGJTJGdXUxNDlyZXo2Z3c5ZWhlai5ldS13ZXN0LTEuYXdzLmVuZHBvaW50cy5odWdnaW5nZmFjZS5jbG91ZCUyRmRlZXBmbG95ZC1pZiUyMiklMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoKSUwQWNsaWVudC50ZXh0X3RvX2ltYWdlKC4uLiUyQyUyMG1vZGVsJTNEJTIyaHR0cHMlM0ElMkYlMkZ1dTE0OXJlejZndzllaGVqLmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZGVlcGZsb3lkLWlmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(model=<span class="hljs-string">&quot;https://uu149rez6gw9ehej.eu-west-1.aws.endpoints.huggingface.cloud/deepfloyd-if&quot;</span>)
<span class="hljs-comment"># or</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(..., model=<span class="hljs-string">&quot;https://uu149rez6gw9ehej.eu-west-1.aws.endpoints.huggingface.cloud/deepfloyd-if&quot;</span>)`,wrap:!1}}),K=new _({props:{title:"Authentication",local:"authentication",headingTag:"h3"}}),ee=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCh0b2tlbiUzRCUyMmhmXyoqKiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(token=<span class="hljs-string">&quot;hf_***&quot;</span>)`,wrap:!1}}),se=new M({props:{code:"Y2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
    api_key=<span class="hljs-string">&quot;r8_****&quot;</span>  <span class="hljs-comment"># Your Replicate API key</span>
)`,wrap:!1}}),le=new M({props:{code:"Y2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
    token=<span class="hljs-string">&quot;hf_****&quot;</span>  <span class="hljs-comment"># Your HF token </span>
)`,wrap:!1}}),ie=new _({props:{title:"OpenAI compatibility",local:"openai-compatibility",headingTag:"h2"}}),re=new M({props:{code:"LSUyMGZyb20lMjBvcGVuYWklMjBpbXBvcnQlMjBPcGVuQUklMEElMkIlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBLSUyMGNsaWVudCUyMCUzRCUyME9wZW5BSSglMEElMkIlMjBjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoJTBBJTIwJTIwJTIwJTIwYmFzZV91cmwlM0QuLi4lMkMlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNELi4uJTJDJTBBKSUwQSUwQSUwQW91dHB1dCUyMCUzRCUyMGNsaWVudC5jaGF0LmNvbXBsZXRpb25zLmNyZWF0ZSglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQ291bnQlMjB0byUyMDEwJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RyZWFtJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBKSUwQSUwQWZvciUyMGNodW5rJTIwaW4lMjBvdXRwdXQlM0ElMEElMjAlMjAlMjAlMjBwcmludChjaHVuay5jaG9pY2VzJTVCMCU1RC5kZWx0YS5jb250ZW50KQ==",highlighted:`<span class="hljs-deletion">- from openai import OpenAI</span>
<span class="hljs-addition">+ from huggingface_hub import InferenceClient</span>

<span class="hljs-deletion">- client = OpenAI(</span>
<span class="hljs-addition">+ client = InferenceClient(</span>
    base_url=...,
    api_key=...,
)


output = client.chat.completions.create(
    model=&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;,
    messages=[
        {&quot;role&quot;: &quot;system&quot;, &quot;content&quot;: &quot;You are a helpful assistant.&quot;},
        {&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;Count to 10&quot;},
    ],
    stream=True,
    max_tokens=1024,
)

for chunk in output:
    print(chunk.choices[0].delta.content)`,wrap:!1}}),de=new M({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQS0lMjBmcm9tJTIwb3BlbmFpJTIwaW1wb3J0JTIwQXN5bmNPcGVuQUklMEElMkIlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwQXN5bmNJbmZlcmVuY2VDbGllbnQlMEElMEEtJTIwY2xpZW50JTIwJTNEJTIwQXN5bmNPcGVuQUkoKSUwQSUyQiUyMGNsaWVudCUyMCUzRCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50KCklMEElMEFhc3luYyUyMGRlZiUyMG1haW4oKSUzQSUwQSUyMCUyMCUyMCUyMHN0cmVhbSUyMCUzRCUyMGF3YWl0JTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyU2F5JTIwdGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdHJlYW0lM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZm9yJTIwY2h1bmslMjBpbiUyMHN0cmVhbSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGNodW5rLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQlMjBvciUyMCUyMiUyMiUyQyUyMGVuZCUzRCUyMiUyMiklMEElMEFhc3luY2lvLnJ1bihtYWluKCkp",highlighted:`import asyncio
<span class="hljs-deletion">- from openai import AsyncOpenAI</span>
<span class="hljs-addition">+ from huggingface_hub import AsyncInferenceClient</span>

<span class="hljs-deletion">- client = AsyncOpenAI()</span>
<span class="hljs-addition">+ client = AsyncInferenceClient()</span>

async def main():
    stream = await client.chat.completions.create(
        model=&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;,
        messages=[{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;Say this is a test&quot;}],
        stream=True,
    )
    async for chunk in stream:
        print(chunk.choices[0].delta.content or &quot;&quot;, end=&quot;&quot;)

asyncio.run(main())`,wrap:!1}}),Z=new ct({props:{$$slots:{default:[sa]},$$scope:{ctx:C}}}),fe=new _({props:{title:"Supported providers and tasks",local:"supported-providers-and-tasks",headingTag:"h2"}}),k=new ct({props:{$$slots:{default:[aa]},$$scope:{ctx:C}}}),ye=new _({props:{title:"Custom requests",local:"custom-requests",headingTag:"h2"}}),Me=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBcmVzcG9uc2UlMjAlM0QlMjBjbGllbnQucG9zdChqc29uJTNEJTdCJTIyaW5wdXRzJTIyJTNBJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMHRoZSUyMG1vb24uJTIyJTdEJTJDJTIwbW9kZWwlM0QlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xJTIyKSUwQXJlc3BvbnNlLmNvbnRlbnQlMjAlMjMlMjByYXclMjBieXRlcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>}, model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.content <span class="hljs-comment"># raw bytes</span>
<span class="hljs-string">b&#x27;...&#x27;</span>`,wrap:!1}}),je=new _({props:{title:"Async client",local:"async-client",headingTag:"h2"}}),we=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGh1Z2dpbmdmYWNlX2h1YiU1QmluZmVyZW5jZSU1RCUwQSUyMyUyMG9yJTBBJTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFpb2h0dHA=",highlighted:`pip install --upgrade huggingface_hub[inference]
<span class="hljs-comment"># or</span>
<span class="hljs-comment"># pip install aiohttp</span>`,wrap:!1}}),Ue=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWFzeW5jJTIwZm9yJTIwdG9rZW4lMjBpbiUyMGF3YWl0JTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJUaGUlMjBIdWdnaW5nZmFjZSUyMEh1YiUyMGlzJTIyJTJDJTIwc3RyZWFtJTNEVHJ1ZSklM0ElMEElMjAlMjAlMjAlMjBwcmludCh0b2tlbiUyQyUyMGVuZCUzRCUyMiUyMik=",highlighted:`<span class="hljs-comment"># Code must be run in an asyncio concurrent context.</span>
<span class="hljs-comment"># $ python -m asyncio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The Huggingface Hub is&quot;</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token, end=<span class="hljs-string">&quot;&quot;</span>)
 a platform <span class="hljs-keyword">for</span> sharing <span class="hljs-keyword">and</span> discussing ML-related content.`,wrap:!1}}),$e=new _({props:{title:"Advanced tips",local:"advanced-tips",headingTag:"h2"}}),Je=new _({props:{title:"Timeout",local:"timeout",headingTag:"h3"}}),We=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUyQyUyMEluZmVyZW5jZVRpbWVvdXRFcnJvciUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCh0aW1lb3V0JTNEMzApJTBBdHJ5JTNBJTBBJTIwJTIwJTIwJTIwY2xpZW50LnRleHRfdG9faW1hZ2UoLi4uKSUwQWV4Y2VwdCUyMEluZmVyZW5jZVRpbWVvdXRFcnJvciUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkluZmVyZW5jZSUyMHRpbWVkJTIwb3V0JTIwYWZ0ZXIlMjAzMHMuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient, InferenceTimeoutError
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(timeout=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>    client.text_to_image(...)
<span class="hljs-meta">... </span><span class="hljs-keyword">except</span> InferenceTimeoutError:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Inference timed out after 30s.&quot;</span>)`,wrap:!1}}),xe=new _({props:{title:"Binary inputs",local:"binary-inputs",headingTag:"h3"}}),Ve=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9779096841812134</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>}, ...]`,wrap:!1}}),Ne=new _({props:{title:"Legacy InferenceAPI client",local:"legacy-inferenceapi-client",headingTag:"h2"}}),Qe=new _({props:{title:"Initialization",local:"initialization",headingTag:"h3"}}),Se=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMkMlMjB0b2tlbiUzREFQSV9UT0tFTik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, token=API_TOKEN)`,wrap:!1}}),Ee=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyJTJDJTIwdG9rZW4lM0RBUElfVE9LRU4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceClient(model=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, token=API_TOKEN)`,wrap:!1}}),Xe=new _({props:{title:"Run on a specific task",local:"run-on-a-specific-task",headingTag:"h3"}}),Re=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIycGFyYXBocmFzZS14bG0tci1tdWx0aWxpbmd1YWwtdjElMjIlMkMlMjB0YXNrJTNEJTIyZmVhdHVyZS1leHRyYWN0aW9uJTIyKSUwQWluZmVyZW5jZSguLi4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;paraphrase-xlm-r-multilingual-v1&quot;</span>, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(...)`,wrap:!1}}),Fe=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBaW5mZXJlbmNlLmZlYXR1cmVfZXh0cmFjdGlvbiguLi4lMkMlMjBtb2RlbCUzRCUyMnBhcmFwaHJhc2UteGxtLXItbXVsdGlsaW5ndWFsLXYxJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>inference.feature_extraction(..., model=<span class="hljs-string">&quot;paraphrase-xlm-r-multilingual-v1&quot;</span>)`,wrap:!1}}),v=new ct({props:{$$slots:{default:[la]},$$scope:{ctx:C}}}),Pe=new _({props:{title:"Run custom request",local:"run-custom-request",headingTag:"h3"}}),Oe=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBaW5mZXJlbmNlKGlucHV0cyUzRCUyMlRoZSUyMGdvYWwlMjBvZiUyMGxpZmUlMjBpcyUyMCU1Qk1BU0slNUQuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs=<span class="hljs-string">&quot;The goal of life is [MASK].&quot;</span>)
[{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;the goal of life is life.&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10933292657136917</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">2166</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;life&#x27;</span>}]`,wrap:!1}}),et=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBcmVzcG9uc2UlMjAlM0QlMjBjbGllbnQucG9zdChqc29uJTNEJTdCJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhlJTIwZ29hbCUyMG9mJTIwbGlmZSUyMGlzJTIwJTVCTUFTSyU1RC4lMjIlN0QlMkMlMjBtb2RlbCUzRCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQXJlc3BvbnNlLmpzb24oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;The goal of life is [MASK].&quot;</span>}, model=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.json()
[{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;the goal of life is life.&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10933292657136917</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">2166</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;life&#x27;</span>}]`,wrap:!1}}),tt=new _({props:{title:"Run with parameters",local:"run-with-parameters",headingTag:"h3"}}),st=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUFwaSUwQWluZmVyZW5jZSUyMCUzRCUyMEluZmVyZW5jZUFwaShyZXBvX2lkJTNEJTIydHlwZWZvcm0lMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1tbmxpJTIyKSUwQWlucHV0cyUyMCUzRCUyMCUyMkhpJTJDJTIwSSUyMHJlY2VudGx5JTIwYm91Z2h0JTIwYSUyMGRldmljZSUyMGZyb20lMjB5b3VyJTIwY29tcGFueSUyMGJ1dCUyMGl0JTIwaXMlMjBub3QlMjB3b3JraW5nJTIwYXMlMjBhZHZlcnRpc2VkJTIwYW5kJTIwSSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwZ2V0JTIwcmVpbWJ1cnNlZCElMjIlMEFwYXJhbXMlMjAlM0QlMjAlN0IlMjJjYW5kaWRhdGVfbGFiZWxzJTIyJTNBJTVCJTIycmVmdW5kJTIyJTJDJTIwJTIybGVnYWwlMjIlMkMlMjAlMjJmYXElMjIlNUQlN0QlMEFpbmZlcmVuY2UoaW5wdXRzJTJDJTIwcGFyYW1zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceApi
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(repo_id=<span class="hljs-string">&quot;typeform/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = {<span class="hljs-string">&quot;candidate_labels&quot;</span>:[<span class="hljs-string">&quot;refund&quot;</span>, <span class="hljs-string">&quot;legal&quot;</span>, <span class="hljs-string">&quot;faq&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs, params)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.9378499388694763</span>, <span class="hljs-number">0.04914155602455139</span>, <span class="hljs-number">0.013008488342165947</span>]}`,wrap:!1}}),lt=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBaW5wdXRzJTIwJTNEJTIwJTIySGklMkMlMjBJJTIwcmVjZW50bHklMjBib3VnaHQlMjBhJTIwZGV2aWNlJTIwZnJvbSUyMHlvdXIlMjBjb21wYW55JTIwYnV0JTIwaXQlMjBpcyUyMG5vdCUyMHdvcmtpbmclMjBhcyUyMGFkdmVydGlzZWQlMjBhbmQlMjBJJTIwd291bGQlMjBsaWtlJTIwdG8lMjBnZXQlMjByZWltYnVyc2VkISUyMiUwQXBhcmFtcyUyMCUzRCUyMCU3QiUyMmNhbmRpZGF0ZV9sYWJlbHMlMjIlM0ElNUIlMjJyZWZ1bmQlMjIlMkMlMjAlMjJsZWdhbCUyMiUyQyUyMCUyMmZhcSUyMiU1RCU3RCUwQXJlc3BvbnNlJTIwJTNEJTIwY2xpZW50LnBvc3QoanNvbiUzRCU3QiUyMmlucHV0cyUyMiUzQSUyMGlucHV0cyUyQyUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjBwYXJhbXMlN0QlMkMlMjBtb2RlbCUzRCUyMnR5cGVmb3JtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtbW5saSUyMiklMEFyZXNwb25zZS5qc29uKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = {<span class="hljs-string">&quot;candidate_labels&quot;</span>:[<span class="hljs-string">&quot;refund&quot;</span>, <span class="hljs-string">&quot;legal&quot;</span>, <span class="hljs-string">&quot;faq&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: inputs, <span class="hljs-string">&quot;parameters&quot;</span>: params}, model=<span class="hljs-string">&quot;typeform/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.json()
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.9378499388694763</span>, <span class="hljs-number">0.04914155602455139</span>, <span class="hljs-number">0.013008488342165947</span>]}`,wrap:!1}}),it=new Ds({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/inference.md"}}),{c(){i=c("meta"),j=a(),m=c("p"),y=a(),p(U.$$.fragment),b=a(),w=c("p"),w.innerHTML=Pn,pt=a(),W=c("ol"),W.innerHTML=Kn,dt=a(),x=c("p"),x.innerHTML=On,ut=a(),p(I.$$.fragment),gt=a(),p(q.$$.fragment),ft=a(),G=c("p"),G.textContent=Dn,ht=a(),p(V.$$.fragment),mt=a(),N=c("p"),N.innerHTML=es,yt=a(),H=c("p"),H.innerHTML=ts,bt=a(),p(B.$$.fragment),Mt=a(),Q=c("p"),Q.innerHTML=ns,jt=a(),p($.$$.fragment),_t=a(),p(Y.$$.fragment),wt=a(),S=c("p"),S.innerHTML=ss,Ct=a(),p(L.$$.fragment),Ut=a(),p(E.$$.fragment),It=a(),X=c("p"),X.textContent=as,$t=a(),p(A.$$.fragment),Tt=a(),p(T.$$.fragment),Jt=a(),p(R.$$.fragment),Zt=a(),z=c("p"),z.innerHTML=ls,kt=a(),p(F.$$.fragment),vt=a(),P=c("p"),P.textContent=is,Wt=a(),p(K.$$.fragment),xt=a(),O=c("p"),O.textContent=cs,qt=a(),D=c("ol"),D.innerHTML=rs,Gt=a(),p(ee.$$.fragment),Vt=a(),te=c("p"),te.innerHTML=os,Nt=a(),J=c("ol"),J.innerHTML=ps,Ht=a(),ne=c("p"),ne.innerHTML=ds,Bt=a(),p(se.$$.fragment),Qt=a(),ae=c("p"),ae.innerHTML=us,Yt=a(),p(le.$$.fragment),St=a(),p(ie.$$.fragment),Lt=a(),ce=c("p"),ce.innerHTML=gs,Et=a(),p(re.$$.fragment),Xt=a(),oe=c("p"),oe.innerHTML=fs,At=a(),pe=c("p"),pe.innerHTML=hs,Rt=a(),p(de.$$.fragment),zt=a(),ue=c("p"),ue.innerHTML=ms,Ft=a(),ge=c("ol"),ge.innerHTML=ys,Pt=a(),p(Z.$$.fragment),Kt=a(),p(fe.$$.fragment),Ot=a(),he=c("p"),he.innerHTML=bs,Dt=a(),me=c("table"),me.innerHTML=Ms,en=a(),p(k.$$.fragment),tn=a(),p(ye.$$.fragment),nn=a(),be=c("p"),be.innerHTML=js,sn=a(),p(Me.$$.fragment),an=a(),p(je.$$.fragment),ln=a(),_e=c("p"),_e.innerHTML=_s,cn=a(),p(we.$$.fragment),rn=a(),Ce=c("p"),Ce.innerHTML=ws,on=a(),p(Ue.$$.fragment),pn=a(),Ie=c("p"),Ie.innerHTML=Cs,dn=a(),p($e.$$.fragment),un=a(),Te=c("p"),Te.innerHTML=Us,gn=a(),p(Je.$$.fragment),fn=a(),Ze=c("p"),Ze.textContent=Is,hn=a(),ke=c("ul"),ke.innerHTML=$s,mn=a(),ve=c("p"),ve.innerHTML=Ts,yn=a(),p(We.$$.fragment),bn=a(),p(xe.$$.fragment),Mn=a(),qe=c("p"),qe.innerHTML=Js,jn=a(),Ge=c("ul"),Ge.innerHTML=Zs,_n=a(),p(Ve.$$.fragment),wn=a(),p(Ne.$$.fragment),Cn=a(),He=c("p"),He.innerHTML=ks,Un=a(),Be=c("p"),Be.innerHTML=vs,In=a(),p(Qe.$$.fragment),$n=a(),Ye=c("p"),Ye.textContent=Ws,Tn=a(),p(Se.$$.fragment),Jn=a(),Le=c("p"),Le.textContent=xs,Zn=a(),p(Ee.$$.fragment),kn=a(),p(Xe.$$.fragment),vn=a(),Ae=c("p"),Ae.textContent=qs,Wn=a(),p(Re.$$.fragment),xn=a(),ze=c("p"),ze.textContent=Gs,qn=a(),p(Fe.$$.fragment),Gn=a(),p(v.$$.fragment),Vn=a(),p(Pe.$$.fragment),Nn=a(),Ke=c("p"),Ke.textContent=Vs,Hn=a(),p(Oe.$$.fragment),Bn=a(),De=c("p"),De.textContent=Ns,Qn=a(),p(et.$$.fragment),Yn=a(),p(tt.$$.fragment),Sn=a(),nt=c("p"),nt.textContent=Hs,Ln=a(),p(st.$$.fragment),En=a(),at=c("p"),at.textContent=Bs,Xn=a(),p(lt.$$.fragment),An=a(),p(it.$$.fragment),Rn=a(),ot=c("p"),this.h()},l(e){const t=Ks("svelte-u9bgzb",document.head);i=r(t,"META",{name:!0,content:!0}),t.forEach(n),j=l(e),m=r(e,"P",{}),As(m).forEach(n),y=l(e),d(U.$$.fragment,e),b=l(e),w=r(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-26bzqw"&&(w.innerHTML=Pn),pt=l(e),W=r(e,"OL",{"data-svelte-h":!0}),o(W)!=="svelte-1x7s1wa"&&(W.innerHTML=Kn),dt=l(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1vbf08n"&&(x.innerHTML=On),ut=l(e),d(I.$$.fragment,e),gt=l(e),d(q.$$.fragment,e),ft=l(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-8lplub"&&(G.textContent=Dn),ht=l(e),d(V.$$.fragment,e),mt=l(e),N=r(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-181xjky"&&(N.innerHTML=es),yt=l(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1d6dn6"&&(H.innerHTML=ts),bt=l(e),d(B.$$.fragment,e),Mt=l(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-19dgkah"&&(Q.innerHTML=ns),jt=l(e),d($.$$.fragment,e),_t=l(e),d(Y.$$.fragment,e),wt=l(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-ukpcrh"&&(S.innerHTML=ss),Ct=l(e),d(L.$$.fragment,e),Ut=l(e),d(E.$$.fragment,e),It=l(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1npu22n"&&(X.textContent=as),$t=l(e),d(A.$$.fragment,e),Tt=l(e),d(T.$$.fragment,e),Jt=l(e),d(R.$$.fragment,e),Zt=l(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-u8akyu"&&(z.innerHTML=ls),kt=l(e),d(F.$$.fragment,e),vt=l(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1yhw21f"&&(P.textContent=is),Wt=l(e),d(K.$$.fragment,e),xt=l(e),O=r(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1gwnv0n"&&(O.textContent=cs),qt=l(e),D=r(e,"OL",{"data-svelte-h":!0}),o(D)!=="svelte-1luo03y"&&(D.innerHTML=rs),Gt=l(e),d(ee.$$.fragment,e),Vt=l(e),te=r(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-cgnawa"&&(te.innerHTML=os),Nt=l(e),J=r(e,"OL",{start:!0,"data-svelte-h":!0}),o(J)!=="svelte-11t1tnm"&&(J.innerHTML=ps),Ht=l(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-zxs6jj"&&(ne.innerHTML=ds),Bt=l(e),d(se.$$.fragment,e),Qt=l(e),ae=r(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-y7q25h"&&(ae.innerHTML=us),Yt=l(e),d(le.$$.fragment,e),St=l(e),d(ie.$$.fragment,e),Lt=l(e),ce=r(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-bmxago"&&(ce.innerHTML=gs),Et=l(e),d(re.$$.fragment,e),Xt=l(e),oe=r(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-94ddrt"&&(oe.innerHTML=fs),At=l(e),pe=r(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1wef96y"&&(pe.innerHTML=hs),Rt=l(e),d(de.$$.fragment,e),zt=l(e),ue=r(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-u2g99k"&&(ue.innerHTML=ms),Ft=l(e),ge=r(e,"OL",{"data-svelte-h":!0}),o(ge)!=="svelte-1oyc4dd"&&(ge.innerHTML=ys),Pt=l(e),d(Z.$$.fragment,e),Kt=l(e),d(fe.$$.fragment,e),Ot=l(e),he=r(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-qhknp8"&&(he.innerHTML=bs),Dt=l(e),me=r(e,"TABLE",{"data-svelte-h":!0}),o(me)!=="svelte-1m0jrf9"&&(me.innerHTML=Ms),en=l(e),d(k.$$.fragment,e),tn=l(e),d(ye.$$.fragment,e),nn=l(e),be=r(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-1jtwxv4"&&(be.innerHTML=js),sn=l(e),d(Me.$$.fragment,e),an=l(e),d(je.$$.fragment,e),ln=l(e),_e=r(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-1gqwj00"&&(_e.innerHTML=_s),cn=l(e),d(we.$$.fragment,e),rn=l(e),Ce=r(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-1bdjfju"&&(Ce.innerHTML=ws),on=l(e),d(Ue.$$.fragment,e),pn=l(e),Ie=r(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-q492az"&&(Ie.innerHTML=Cs),dn=l(e),d($e.$$.fragment,e),un=l(e),Te=r(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-2b1sa3"&&(Te.innerHTML=Us),gn=l(e),d(Je.$$.fragment,e),fn=l(e),Ze=r(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-8gznjs"&&(Ze.textContent=Is),hn=l(e),ke=r(e,"UL",{"data-svelte-h":!0}),o(ke)!=="svelte-ovc80h"&&(ke.innerHTML=$s),mn=l(e),ve=r(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-1erkhu8"&&(ve.innerHTML=Ts),yn=l(e),d(We.$$.fragment,e),bn=l(e),d(xe.$$.fragment,e),Mn=l(e),qe=r(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-4hhs15"&&(qe.innerHTML=Js),jn=l(e),Ge=r(e,"UL",{"data-svelte-h":!0}),o(Ge)!=="svelte-vaeuct"&&(Ge.innerHTML=Zs),_n=l(e),d(Ve.$$.fragment,e),wn=l(e),d(Ne.$$.fragment,e),Cn=l(e),He=r(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-4xn88d"&&(He.innerHTML=ks),Un=l(e),Be=r(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-17wtofw"&&(Be.innerHTML=vs),In=l(e),d(Qe.$$.fragment,e),$n=l(e),Ye=r(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-ft9vbs"&&(Ye.textContent=Ws),Tn=l(e),d(Se.$$.fragment,e),Jn=l(e),Le=r(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-8wg17z"&&(Le.textContent=xs),Zn=l(e),d(Ee.$$.fragment,e),kn=l(e),d(Xe.$$.fragment,e),vn=l(e),Ae=r(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-ft9vbs"&&(Ae.textContent=qs),Wn=l(e),d(Re.$$.fragment,e),xn=l(e),ze=r(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-8wg17z"&&(ze.textContent=Gs),qn=l(e),d(Fe.$$.fragment,e),Gn=l(e),d(v.$$.fragment,e),Vn=l(e),d(Pe.$$.fragment,e),Nn=l(e),Ke=r(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-ft9vbs"&&(Ke.textContent=Vs),Hn=l(e),d(Oe.$$.fragment,e),Bn=l(e),De=r(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-8wg17z"&&(De.textContent=Ns),Qn=l(e),d(et.$$.fragment,e),Yn=l(e),d(tt.$$.fragment,e),Sn=l(e),nt=r(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-ft9vbs"&&(nt.textContent=Hs),Ln=l(e),d(st.$$.fragment,e),En=l(e),at=r(e,"P",{"data-svelte-h":!0}),o(at)!=="svelte-8wg17z"&&(at.textContent=Bs),Xn=l(e),d(lt.$$.fragment,e),An=l(e),d(it.$$.fragment,e),Rn=l(e),ot=r(e,"P",{}),As(ot).forEach(n),this.h()},h(){Fn(i,"name","hf:doc:metadata"),Fn(i,"content",ca),Fn(J,"start","2")},m(e,t){Os(document.head,i),s(e,j,t),s(e,m,t),s(e,y,t),u(U,e,t),s(e,b,t),s(e,w,t),s(e,pt,t),s(e,W,t),s(e,dt,t),s(e,x,t),s(e,ut,t),u(I,e,t),s(e,gt,t),u(q,e,t),s(e,ft,t),s(e,G,t),s(e,ht,t),u(V,e,t),s(e,mt,t),s(e,N,t),s(e,yt,t),s(e,H,t),s(e,bt,t),u(B,e,t),s(e,Mt,t),s(e,Q,t),s(e,jt,t),u($,e,t),s(e,_t,t),u(Y,e,t),s(e,wt,t),s(e,S,t),s(e,Ct,t),u(L,e,t),s(e,Ut,t),u(E,e,t),s(e,It,t),s(e,X,t),s(e,$t,t),u(A,e,t),s(e,Tt,t),u(T,e,t),s(e,Jt,t),u(R,e,t),s(e,Zt,t),s(e,z,t),s(e,kt,t),u(F,e,t),s(e,vt,t),s(e,P,t),s(e,Wt,t),u(K,e,t),s(e,xt,t),s(e,O,t),s(e,qt,t),s(e,D,t),s(e,Gt,t),u(ee,e,t),s(e,Vt,t),s(e,te,t),s(e,Nt,t),s(e,J,t),s(e,Ht,t),s(e,ne,t),s(e,Bt,t),u(se,e,t),s(e,Qt,t),s(e,ae,t),s(e,Yt,t),u(le,e,t),s(e,St,t),u(ie,e,t),s(e,Lt,t),s(e,ce,t),s(e,Et,t),u(re,e,t),s(e,Xt,t),s(e,oe,t),s(e,At,t),s(e,pe,t),s(e,Rt,t),u(de,e,t),s(e,zt,t),s(e,ue,t),s(e,Ft,t),s(e,ge,t),s(e,Pt,t),u(Z,e,t),s(e,Kt,t),u(fe,e,t),s(e,Ot,t),s(e,he,t),s(e,Dt,t),s(e,me,t),s(e,en,t),u(k,e,t),s(e,tn,t),u(ye,e,t),s(e,nn,t),s(e,be,t),s(e,sn,t),u(Me,e,t),s(e,an,t),u(je,e,t),s(e,ln,t),s(e,_e,t),s(e,cn,t),u(we,e,t),s(e,rn,t),s(e,Ce,t),s(e,on,t),u(Ue,e,t),s(e,pn,t),s(e,Ie,t),s(e,dn,t),u($e,e,t),s(e,un,t),s(e,Te,t),s(e,gn,t),u(Je,e,t),s(e,fn,t),s(e,Ze,t),s(e,hn,t),s(e,ke,t),s(e,mn,t),s(e,ve,t),s(e,yn,t),u(We,e,t),s(e,bn,t),u(xe,e,t),s(e,Mn,t),s(e,qe,t),s(e,jn,t),s(e,Ge,t),s(e,_n,t),u(Ve,e,t),s(e,wn,t),u(Ne,e,t),s(e,Cn,t),s(e,He,t),s(e,Un,t),s(e,Be,t),s(e,In,t),u(Qe,e,t),s(e,$n,t),s(e,Ye,t),s(e,Tn,t),u(Se,e,t),s(e,Jn,t),s(e,Le,t),s(e,Zn,t),u(Ee,e,t),s(e,kn,t),u(Xe,e,t),s(e,vn,t),s(e,Ae,t),s(e,Wn,t),u(Re,e,t),s(e,xn,t),s(e,ze,t),s(e,qn,t),u(Fe,e,t),s(e,Gn,t),u(v,e,t),s(e,Vn,t),u(Pe,e,t),s(e,Nn,t),s(e,Ke,t),s(e,Hn,t),u(Oe,e,t),s(e,Bn,t),s(e,De,t),s(e,Qn,t),u(et,e,t),s(e,Yn,t),u(tt,e,t),s(e,Sn,t),s(e,nt,t),s(e,Ln,t),u(st,e,t),s(e,En,t),s(e,at,t),s(e,Xn,t),u(lt,e,t),s(e,An,t),u(it,e,t),s(e,Rn,t),s(e,ot,t),zn=!0},p(e,[t]){const Qs={};t&2&&(Qs.$$scope={dirty:t,ctx:e}),I.$set(Qs);const Ys={};t&2&&(Ys.$$scope={dirty:t,ctx:e}),$.$set(Ys);const Ss={};t&2&&(Ss.$$scope={dirty:t,ctx:e}),T.$set(Ss);const Ls={};t&2&&(Ls.$$scope={dirty:t,ctx:e}),Z.$set(Ls);const Es={};t&2&&(Es.$$scope={dirty:t,ctx:e}),k.$set(Es);const Xs={};t&2&&(Xs.$$scope={dirty:t,ctx:e}),v.$set(Xs)},i(e){zn||(g(U.$$.fragment,e),g(I.$$.fragment,e),g(q.$$.fragment,e),g(V.$$.fragment,e),g(B.$$.fragment,e),g($.$$.fragment,e),g(Y.$$.fragment,e),g(L.$$.fragment,e),g(E.$$.fragment,e),g(A.$$.fragment,e),g(T.$$.fragment,e),g(R.$$.fragment,e),g(F.$$.fragment,e),g(K.$$.fragment,e),g(ee.$$.fragment,e),g(se.$$.fragment,e),g(le.$$.fragment,e),g(ie.$$.fragment,e),g(re.$$.fragment,e),g(de.$$.fragment,e),g(Z.$$.fragment,e),g(fe.$$.fragment,e),g(k.$$.fragment,e),g(ye.$$.fragment,e),g(Me.$$.fragment,e),g(je.$$.fragment,e),g(we.$$.fragment,e),g(Ue.$$.fragment,e),g($e.$$.fragment,e),g(Je.$$.fragment,e),g(We.$$.fragment,e),g(xe.$$.fragment,e),g(Ve.$$.fragment,e),g(Ne.$$.fragment,e),g(Qe.$$.fragment,e),g(Se.$$.fragment,e),g(Ee.$$.fragment,e),g(Xe.$$.fragment,e),g(Re.$$.fragment,e),g(Fe.$$.fragment,e),g(v.$$.fragment,e),g(Pe.$$.fragment,e),g(Oe.$$.fragment,e),g(et.$$.fragment,e),g(tt.$$.fragment,e),g(st.$$.fragment,e),g(lt.$$.fragment,e),g(it.$$.fragment,e),zn=!0)},o(e){f(U.$$.fragment,e),f(I.$$.fragment,e),f(q.$$.fragment,e),f(V.$$.fragment,e),f(B.$$.fragment,e),f($.$$.fragment,e),f(Y.$$.fragment,e),f(L.$$.fragment,e),f(E.$$.fragment,e),f(A.$$.fragment,e),f(T.$$.fragment,e),f(R.$$.fragment,e),f(F.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(se.$$.fragment,e),f(le.$$.fragment,e),f(ie.$$.fragment,e),f(re.$$.fragment,e),f(de.$$.fragment,e),f(Z.$$.fragment,e),f(fe.$$.fragment,e),f(k.$$.fragment,e),f(ye.$$.fragment,e),f(Me.$$.fragment,e),f(je.$$.fragment,e),f(we.$$.fragment,e),f(Ue.$$.fragment,e),f($e.$$.fragment,e),f(Je.$$.fragment,e),f(We.$$.fragment,e),f(xe.$$.fragment,e),f(Ve.$$.fragment,e),f(Ne.$$.fragment,e),f(Qe.$$.fragment,e),f(Se.$$.fragment,e),f(Ee.$$.fragment,e),f(Xe.$$.fragment,e),f(Re.$$.fragment,e),f(Fe.$$.fragment,e),f(v.$$.fragment,e),f(Pe.$$.fragment,e),f(Oe.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(st.$$.fragment,e),f(lt.$$.fragment,e),f(it.$$.fragment,e),zn=!1},d(e){e&&(n(j),n(m),n(y),n(b),n(w),n(pt),n(W),n(dt),n(x),n(ut),n(gt),n(ft),n(G),n(ht),n(mt),n(N),n(yt),n(H),n(bt),n(Mt),n(Q),n(jt),n(_t),n(wt),n(S),n(Ct),n(Ut),n(It),n(X),n($t),n(Tt),n(Jt),n(Zt),n(z),n(kt),n(vt),n(P),n(Wt),n(xt),n(O),n(qt),n(D),n(Gt),n(Vt),n(te),n(Nt),n(J),n(Ht),n(ne),n(Bt),n(Qt),n(ae),n(Yt),n(St),n(Lt),n(ce),n(Et),n(Xt),n(oe),n(At),n(pe),n(Rt),n(zt),n(ue),n(Ft),n(ge),n(Pt),n(Kt),n(Ot),n(he),n(Dt),n(me),n(en),n(tn),n(nn),n(be),n(sn),n(an),n(ln),n(_e),n(cn),n(rn),n(Ce),n(on),n(pn),n(Ie),n(dn),n(un),n(Te),n(gn),n(fn),n(Ze),n(hn),n(ke),n(mn),n(ve),n(yn),n(bn),n(Mn),n(qe),n(jn),n(Ge),n(_n),n(wn),n(Cn),n(He),n(Un),n(Be),n(In),n($n),n(Ye),n(Tn),n(Jn),n(Le),n(Zn),n(kn),n(vn),n(Ae),n(Wn),n(xn),n(ze),n(qn),n(Gn),n(Vn),n(Nn),n(Ke),n(Hn),n(Bn),n(De),n(Qn),n(Yn),n(Sn),n(nt),n(Ln),n(En),n(at),n(Xn),n(An),n(Rn),n(ot)),n(i),h(U,e),h(I,e),h(q,e),h(V,e),h(B,e),h($,e),h(Y,e),h(L,e),h(E,e),h(A,e),h(T,e),h(R,e),h(F,e),h(K,e),h(ee,e),h(se,e),h(le,e),h(ie,e),h(re,e),h(de,e),h(Z,e),h(fe,e),h(k,e),h(ye,e),h(Me,e),h(je,e),h(we,e),h(Ue,e),h($e,e),h(Je,e),h(We,e),h(xe,e),h(Ve,e),h(Ne,e),h(Qe,e),h(Se,e),h(Ee,e),h(Xe,e),h(Re,e),h(Fe,e),h(v,e),h(Pe,e),h(Oe,e),h(et,e),h(tt,e),h(st,e),h(lt,e),h(it,e)}}}const ca='{"title":"Run Inference on servers","local":"run-inference-on-servers","sections":[{"title":"Getting started","local":"getting-started","sections":[{"title":"Using a specific provider","local":"using-a-specific-provider","sections":[],"depth":3},{"title":"Using a specific model","local":"using-a-specific-model","sections":[],"depth":3},{"title":"Using a specific URL","local":"using-a-specific-url","sections":[],"depth":3},{"title":"Authentication","local":"authentication","sections":[],"depth":3}],"depth":2},{"title":"OpenAI compatibility","local":"openai-compatibility","sections":[],"depth":2},{"title":"Supported providers and tasks","local":"supported-providers-and-tasks","sections":[],"depth":2},{"title":"Custom requests","local":"custom-requests","sections":[],"depth":2},{"title":"Async client","local":"async-client","sections":[],"depth":2},{"title":"Advanced tips","local":"advanced-tips","sections":[{"title":"Timeout","local":"timeout","sections":[],"depth":3},{"title":"Binary inputs","local":"binary-inputs","sections":[],"depth":3}],"depth":2},{"title":"Legacy InferenceAPI client","local":"legacy-inferenceapi-client","sections":[{"title":"Initialization","local":"initialization","sections":[],"depth":3},{"title":"Run on a specific task","local":"run-on-a-specific-task","sections":[],"depth":3},{"title":"Run custom request","local":"run-custom-request","sections":[],"depth":3},{"title":"Run with parameters","local":"run-with-parameters","sections":[],"depth":3}],"depth":2}],"depth":1}';function ra(C){return zs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fa extends Fs{constructor(i){super(),Ps(this,i,ra,ia,Rs,{})}}export{fa as component};
