import{s as _l,n as fl,o as hl}from"../chunks/scheduler.b108d059.js";import{S as Bl,i as Wl,g as M,s as a,r as o,A as Al,h as n,f as t,c as i,j as bl,u as J,x as p,k as Cl,y as Xl,a as e,v as m,d as T,t as y,w as u}from"../chunks/index.008de539.js";import{C as V}from"../chunks/CodeBlock.3968c746.js";import{H as pl}from"../chunks/Heading.88bfeb84.js";function Nl(cl){let c,k,R,G,w,Y,j,ol="In case you don’t settle for the default scikit-learn metrics, you can define your own metric.",Q,U,Jl="Here, we expect the organizer to know python.",x,d,F,r,ml="To define a custom metric, change <code>EVAL_METRIC</code> in <code>conf.json</code> to <code>custom</code>. You must also make sure that <code>EVAL_HIGHER_IS_BETTER</code> is set to <code>1</code> or <code>0</code> depending on whether a higher value of the metric is better or not.",$,I,Tl=`The second step is to create a file <code>metric.py</code> in the private competition repo.
The file should contain a <code>compute</code> function that takes competition params as input.`,S,b,yl="Here is the part where we check if metric is custom and calculate the metric value:",g,C,q,_,ul="You can find the above part in competitions github repo <code>compute_metrics.py</code>",L,f,wl="<code>params</code> is defined as:",P,h,K,B,jl=`You are free to do whatever you want to in the <code>compute</code> function.
In the end it must return a dictionary with the following keys:`,D,W,O,A,Ul=`public and private scores must be dictionaries! You can also use multiple metrics.
Example for multiple metrics:`,ll,X,sl,N,dl="Note: When using multiple metrics, conf.json must have <code>SCORING_METRIC</code> specified to rank the participants in the competition.",tl,v,rl="For example, if I want to use metric2 to rank the participants, I will set <code>SCORING_METRIC</code> to <code>metric2</code> in <code>conf.json</code>.",el,E,al,z,il,Z,Il=`Take a careful look at the above code.
You can see that we are downloading the solution file and the submission file from the dataset repo.
We are then calculating the metric on the public and private splits of the solution and submission files.
Finally, we are returning the metric values in a dictionary.`,Ml,H,nl;return w=new pl({props:{title:"Custom metric",local:"custom-metric",headingTag:"h1"}}),d=new pl({props:{title:"How to define a custom metric",local:"how-to-define-a-custom-metric",headingTag:"h3"}}),C=new V({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKHBhcmFtcyklM0ElMEElMjAlMjAlMjAlMjBpZiUyMHBhcmFtcy5tZXRyaWMlMjAlM0QlM0QlMjAlMjJjdXN0b20lMjIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfZmlsZSUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEcGFyYW1zLmNvbXBldGl0aW9uX2lkJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZmlsZW5hbWUlM0QlMjJtZXRyaWMucHklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b2tlbiUzRHBhcmFtcy50b2tlbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3lzLnBhdGguYXBwZW5kKG9zLnBhdGguZGlybmFtZShtZXRyaWNfZmlsZSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWV0cmljJTIwJTNEJTIwaW1wb3J0bGliLmltcG9ydF9tb2R1bGUoJTIybWV0cmljJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV2YWx1YXRpb24lMjAlM0QlMjBtZXRyaWMuY29tcHV0ZShwYXJhbXMpJTBBJTIwJTIwJTIwJTIwLiUwQSUyMCUyMCUyMCUyMC4lMEElMjAlMjAlMjAlMjAu",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">params</span>):
    <span class="hljs-keyword">if</span> params.metric == <span class="hljs-string">&quot;custom&quot;</span>:
        metric_file = hf_hub_download(
            repo_id=params.competition_id,
            filename=<span class="hljs-string">&quot;metric.py&quot;</span>,
            token=params.token,
            repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
        )
        sys.path.append(os.path.dirname(metric_file))
        metric = importlib.import_module(<span class="hljs-string">&quot;metric&quot;</span>)
        evaluation = metric.compute(params)
    .
    .
    .`,wrap:!1}}),h=new V({props:{code:"Y2xhc3MlMjBFdmFsUGFyYW1zKEJhc2VNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb21wZXRpdGlvbl9pZCUzQSUyMHN0ciUwQSUyMCUyMCUyMCUyMGNvbXBldGl0aW9uX3R5cGUlM0ElMjBzdHIlMEElMjAlMjAlMjAlMjBtZXRyaWMlM0ElMjBzdHIlMEElMjAlMjAlMjAlMjB0b2tlbiUzQSUyMHN0ciUwQSUyMCUyMCUyMCUyMHRlYW1faWQlM0ElMjBzdHIlMEElMjAlMjAlMjAlMjBzdWJtaXNzaW9uX2lkJTNBJTIwc3RyJTBBJTIwJTIwJTIwJTIwc3VibWlzc2lvbl9pZF9jb2wlM0ElMjBzdHIlMEElMjAlMjAlMjAlMjBzdWJtaXNzaW9uX2NvbHMlM0ElMjBMaXN0JTVCc3RyJTVEJTBBJTIwJTIwJTIwJTIwc3VibWlzc2lvbl9yb3dzJTNBJTIwaW50JTBBJTIwJTIwJTIwJTIwb3V0cHV0X3BhdGglM0ElMjBzdHIlMEElMjAlMjAlMjAlMjBzdWJtaXNzaW9uX3JlcG8lM0ElMjBzdHIlMEElMjAlMjAlMjAlMjB0aW1lX2xpbWl0JTNBJTIwaW50JTBBJTIwJTIwJTIwJTIwZGF0YXNldCUzQSUyMHN0ciUyMCUyMCUyMyUyMHByaXZhdGUlMjB0ZXN0JTIwZGF0YXNldCUyQyUyMHVzZWQlMjBvbmx5JTIwZm9yJTIwc2NyaXB0JTIwY29tcGV0aXRpb25z",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">EvalParams</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
    competition_id: <span class="hljs-built_in">str</span>
    competition_type: <span class="hljs-built_in">str</span>
    metric: <span class="hljs-built_in">str</span>
    token: <span class="hljs-built_in">str</span>
    team_id: <span class="hljs-built_in">str</span>
    submission_id: <span class="hljs-built_in">str</span>
    submission_id_col: <span class="hljs-built_in">str</span>
    submission_cols: <span class="hljs-type">List</span>[<span class="hljs-built_in">str</span>]
    submission_rows: <span class="hljs-built_in">int</span>
    output_path: <span class="hljs-built_in">str</span>
    submission_repo: <span class="hljs-built_in">str</span>
    time_limit: <span class="hljs-built_in">int</span>
    dataset: <span class="hljs-built_in">str</span>  <span class="hljs-comment"># private test dataset, used only for script competitions</span>`,wrap:!1}}),W=new V({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycHVibGljX3Njb3JlJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWV0cmljMSUyMiUzQSUyMG1ldHJpY192YWx1ZSUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUyQyUwQSUyMCUyMCUyMCUyMCUyMnByaXZhdGVfc2NvcmUlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtZXRyaWMxJTIyJTNBJTIwbWV0cmljX3ZhbHVlJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTJDJTBBJTdE",highlighted:`{
    <span class="hljs-string">&quot;public_score&quot;</span>: {
        <span class="hljs-string">&quot;metric1&quot;</span>: metric_value,
    },,
    <span class="hljs-string">&quot;private_score&quot;</span>: {
        <span class="hljs-string">&quot;metric1&quot;</span>: metric_value,
    },,
}`,wrap:!1}}),X=new V({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycHVibGljX3Njb3JlJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWV0cmljMSUyMiUzQSUyMG1ldHJpY192YWx1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1ldHJpYzIlMjIlM0ElMjBtZXRyaWNfdmFsdWUlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJwcml2YXRlX3Njb3JlJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWV0cmljMSUyMiUzQSUyMG1ldHJpY192YWx1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1ldHJpYzIlMjIlM0ElMjBtZXRyaWNfdmFsdWUlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElN0Q=",highlighted:`{
    <span class="hljs-string">&quot;public_score&quot;</span>: {
        <span class="hljs-string">&quot;metric1&quot;</span>: metric_value,
        <span class="hljs-string">&quot;metric2&quot;</span>: metric_value,
    },
    <span class="hljs-string">&quot;private_score&quot;</span>: {
        <span class="hljs-string">&quot;metric1&quot;</span>: metric_value,
        <span class="hljs-string">&quot;metric2&quot;</span>: metric_value,
    },
}`,wrap:!1}}),E=new pl({props:{title:"Example of a custom metric",local:"example-of-a-custom-metric",headingTag:"h3"}}),z=new V({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBoZl9odWJfZG93bmxvYWQlMEElMEElMEFkZWYlMjBjb21wdXRlKHBhcmFtcyklM0ElMEElMjAlMjAlMjAlMjBzb2x1dGlvbl9maWxlJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0RwYXJhbXMuY29tcGV0aXRpb25faWQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmaWxlbmFtZSUzRCUyMnNvbHV0aW9uLmNzdiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRva2VuJTNEcGFyYW1zLnRva2VuJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjBzb2x1dGlvbl9kZiUyMCUzRCUyMHBkLnJlYWRfY3N2KHNvbHV0aW9uX2ZpbGUpJTBBJTBBJTIwJTIwJTIwJTIwc3VibWlzc2lvbl9maWxlbmFtZSUyMCUzRCUyMGYlMjJzdWJtaXNzaW9ucyUyRiU3QnBhcmFtcy50ZWFtX2lkJTdELSU3QnBhcmFtcy5zdWJtaXNzaW9uX2lkJTdELmNzdiUyMiUwQSUyMCUyMCUyMCUyMHN1Ym1pc3Npb25fZmlsZSUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEcGFyYW1zLmNvbXBldGl0aW9uX2lkJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZmlsZW5hbWUlM0RzdWJtaXNzaW9uX2ZpbGVuYW1lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9rZW4lM0RwYXJhbXMudG9rZW4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMHN1Ym1pc3Npb25fZGYlMjAlM0QlMjBwZC5yZWFkX2NzdihzdWJtaXNzaW9uX2ZpbGUpJTBBJTBBJTIwJTIwJTIwJTIwcHVibGljX2lkcyUyMCUzRCUyMHNvbHV0aW9uX2RmJTVCc29sdXRpb25fZGYuc3BsaXQlMjAlM0QlM0QlMjAlMjJwdWJsaWMlMjIlNUQlNUJwYXJhbXMuc3VibWlzc2lvbl9pZF9jb2wlNUQudmFsdWVzJTBBJTIwJTIwJTIwJTIwcHJpdmF0ZV9pZHMlMjAlM0QlMjBzb2x1dGlvbl9kZiU1QnNvbHV0aW9uX2RmLnNwbGl0JTIwJTNEJTNEJTIwJTIycHJpdmF0ZSUyMiU1RCU1QnBhcmFtcy5zdWJtaXNzaW9uX2lkX2NvbCU1RC52YWx1ZXMlMEElMEElMjAlMjAlMjAlMjBwdWJsaWNfc29sdXRpb25fZGYlMjAlM0QlMjBzb2x1dGlvbl9kZiU1QnNvbHV0aW9uX2RmJTVCcGFyYW1zLnN1Ym1pc3Npb25faWRfY29sJTVELmlzaW4ocHVibGljX2lkcyklNUQlMEElMjAlMjAlMjAlMjBwdWJsaWNfc3VibWlzc2lvbl9kZiUyMCUzRCUyMHN1Ym1pc3Npb25fZGYlNUJzdWJtaXNzaW9uX2RmJTVCcGFyYW1zLnN1Ym1pc3Npb25faWRfY29sJTVELmlzaW4ocHVibGljX2lkcyklNUQlMEElMEElMjAlMjAlMjAlMjBwcml2YXRlX3NvbHV0aW9uX2RmJTIwJTNEJTIwc29sdXRpb25fZGYlNUJzb2x1dGlvbl9kZiU1QnBhcmFtcy5zdWJtaXNzaW9uX2lkX2NvbCU1RC5pc2luKHByaXZhdGVfaWRzKSU1RCUwQSUyMCUyMCUyMCUyMHByaXZhdGVfc3VibWlzc2lvbl9kZiUyMCUzRCUyMHN1Ym1pc3Npb25fZGYlNUJzdWJtaXNzaW9uX2RmJTVCcGFyYW1zLnN1Ym1pc3Npb25faWRfY29sJTVELmlzaW4ocHJpdmF0ZV9pZHMpJTVEJTBBJTBBJTIwJTIwJTIwJTIwcHVibGljX3NvbHV0aW9uX2RmJTIwJTNEJTIwcHVibGljX3NvbHV0aW9uX2RmLnNvcnRfdmFsdWVzKHBhcmFtcy5zdWJtaXNzaW9uX2lkX2NvbCkucmVzZXRfaW5kZXgoZHJvcCUzRFRydWUpJTBBJTIwJTIwJTIwJTIwcHVibGljX3N1Ym1pc3Npb25fZGYlMjAlM0QlMjBwdWJsaWNfc3VibWlzc2lvbl9kZi5zb3J0X3ZhbHVlcyhwYXJhbXMuc3VibWlzc2lvbl9pZF9jb2wpLnJlc2V0X2luZGV4KGRyb3AlM0RUcnVlKSUwQSUwQSUyMCUyMCUyMCUyMHByaXZhdGVfc29sdXRpb25fZGYlMjAlM0QlMjBwcml2YXRlX3NvbHV0aW9uX2RmLnNvcnRfdmFsdWVzKHBhcmFtcy5zdWJtaXNzaW9uX2lkX2NvbCkucmVzZXRfaW5kZXgoZHJvcCUzRFRydWUpJTBBJTIwJTIwJTIwJTIwcHJpdmF0ZV9zdWJtaXNzaW9uX2RmJTIwJTNEJTIwcHJpdmF0ZV9zdWJtaXNzaW9uX2RmLnNvcnRfdmFsdWVzKHBhcmFtcy5zdWJtaXNzaW9uX2lkX2NvbCkucmVzZXRfaW5kZXgoZHJvcCUzRFRydWUpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwQ0FMQ1VMQVRFJTIwTUVUUklDUyUyMEhFUkUuLi4uLi4uJTBBJTIwJTIwJTIwJTIwJTIzJTIwX21ldHJpYyUyMCUzRCUyMFNPTUUlMjBNRVRSSUMlMjBGVU5DVElPTiUwQSUyMCUyMCUyMCUyMHRhcmdldF9jb2xzJTIwJTNEJTIwJTVCY29sJTIwZm9yJTIwY29sJTIwaW4lMjBzb2x1dGlvbl9kZi5jb2x1bW5zJTIwaWYlMjBjb2wlMjBub3QlMjBpbiUyMCU1QnBhcmFtcy5zdWJtaXNzaW9uX2lkX2NvbCUyQyUyMCUyMnNwbGl0JTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcHVibGljX3Njb3JlJTIwJTNEJTIwX21ldHJpYyhwdWJsaWNfc29sdXRpb25fZGYlNUJ0YXJnZXRfY29scyU1RCUyQyUyMHB1YmxpY19zdWJtaXNzaW9uX2RmJTVCdGFyZ2V0X2NvbHMlNUQpJTBBJTIwJTIwJTIwJTIwcHJpdmF0ZV9zY29yZSUyMCUzRCUyMF9tZXRyaWMocHJpdmF0ZV9zb2x1dGlvbl9kZiU1QnRhcmdldF9jb2xzJTVEJTJDJTIwcHJpdmF0ZV9zdWJtaXNzaW9uX2RmJTVCdGFyZ2V0X2NvbHMlNUQpJTBBJTBBJTIwJTIwJTIwJTIwZXZhbHVhdGlvbiUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnB1YmxpY19zY29yZSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1ldHJpYzElMjIlM0ElMjBwdWJsaWNfc2NvcmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwcml2YXRlX3Njb3JlJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWV0cmljMSUyMiUzQSUyMHB1YmxpY19zY29yZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV2YWx1YXRpb24=",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute</span>(<span class="hljs-params">params</span>):
    solution_file = hf_hub_download(
        repo_id=params.competition_id,
        filename=<span class="hljs-string">&quot;solution.csv&quot;</span>,
        token=params.token,
        repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
    )

    solution_df = pd.read_csv(solution_file)

    submission_filename = <span class="hljs-string">f&quot;submissions/<span class="hljs-subst">{params.team_id}</span>-<span class="hljs-subst">{params.submission_id}</span>.csv&quot;</span>
    submission_file = hf_hub_download(
        repo_id=params.competition_id,
        filename=submission_filename,
        token=params.token,
        repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
    )
    submission_df = pd.read_csv(submission_file)

    public_ids = solution_df[solution_df.split == <span class="hljs-string">&quot;public&quot;</span>][params.submission_id_col].values
    private_ids = solution_df[solution_df.split == <span class="hljs-string">&quot;private&quot;</span>][params.submission_id_col].values

    public_solution_df = solution_df[solution_df[params.submission_id_col].isin(public_ids)]
    public_submission_df = submission_df[submission_df[params.submission_id_col].isin(public_ids)]

    private_solution_df = solution_df[solution_df[params.submission_id_col].isin(private_ids)]
    private_submission_df = submission_df[submission_df[params.submission_id_col].isin(private_ids)]

    public_solution_df = public_solution_df.sort_values(params.submission_id_col).reset_index(drop=<span class="hljs-literal">True</span>)
    public_submission_df = public_submission_df.sort_values(params.submission_id_col).reset_index(drop=<span class="hljs-literal">True</span>)

    private_solution_df = private_solution_df.sort_values(params.submission_id_col).reset_index(drop=<span class="hljs-literal">True</span>)
    private_submission_df = private_submission_df.sort_values(params.submission_id_col).reset_index(drop=<span class="hljs-literal">True</span>)

    <span class="hljs-comment"># CALCULATE METRICS HERE.......</span>
    <span class="hljs-comment"># _metric = SOME METRIC FUNCTION</span>
    target_cols = [col <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> solution_df.columns <span class="hljs-keyword">if</span> col <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [params.submission_id_col, <span class="hljs-string">&quot;split&quot;</span>]]
    public_score = _metric(public_solution_df[target_cols], public_submission_df[target_cols])
    private_score = _metric(private_solution_df[target_cols], private_submission_df[target_cols])

    evaluation = {
        <span class="hljs-string">&quot;public_score&quot;</span>: {
            <span class="hljs-string">&quot;metric1&quot;</span>: public_score,
        },
        <span class="hljs-string">&quot;private_score&quot;</span>: {
            <span class="hljs-string">&quot;metric1&quot;</span>: public_score,
        }
    }
    <span class="hljs-keyword">return</span> evaluation`,wrap:!1}}),{c(){c=M("meta"),k=a(),R=M("p"),G=a(),o(w.$$.fragment),Y=a(),j=M("p"),j.textContent=ol,Q=a(),U=M("p"),U.textContent=Jl,x=a(),o(d.$$.fragment),F=a(),r=M("p"),r.innerHTML=ml,$=a(),I=M("p"),I.innerHTML=Tl,S=a(),b=M("p"),b.textContent=yl,g=a(),o(C.$$.fragment),q=a(),_=M("p"),_.innerHTML=ul,L=a(),f=M("p"),f.innerHTML=wl,P=a(),o(h.$$.fragment),K=a(),B=M("p"),B.innerHTML=jl,D=a(),o(W.$$.fragment),O=a(),A=M("p"),A.textContent=Ul,ll=a(),o(X.$$.fragment),sl=a(),N=M("p"),N.innerHTML=dl,tl=a(),v=M("p"),v.innerHTML=rl,el=a(),o(E.$$.fragment),al=a(),o(z.$$.fragment),il=a(),Z=M("p"),Z.textContent=Il,Ml=a(),H=M("p"),this.h()},l(l){const s=Al("svelte-u9bgzb",document.head);c=n(s,"META",{name:!0,content:!0}),s.forEach(t),k=i(l),R=n(l,"P",{}),bl(R).forEach(t),G=i(l),J(w.$$.fragment,l),Y=i(l),j=n(l,"P",{"data-svelte-h":!0}),p(j)!=="svelte-thew86"&&(j.textContent=ol),Q=i(l),U=n(l,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1bv7n2t"&&(U.textContent=Jl),x=i(l),J(d.$$.fragment,l),F=i(l),r=n(l,"P",{"data-svelte-h":!0}),p(r)!=="svelte-x1ibbx"&&(r.innerHTML=ml),$=i(l),I=n(l,"P",{"data-svelte-h":!0}),p(I)!=="svelte-otcxp4"&&(I.innerHTML=Tl),S=i(l),b=n(l,"P",{"data-svelte-h":!0}),p(b)!=="svelte-1g3svse"&&(b.textContent=yl),g=i(l),J(C.$$.fragment,l),q=i(l),_=n(l,"P",{"data-svelte-h":!0}),p(_)!=="svelte-14x4oq"&&(_.innerHTML=ul),L=i(l),f=n(l,"P",{"data-svelte-h":!0}),p(f)!=="svelte-1icqugy"&&(f.innerHTML=wl),P=i(l),J(h.$$.fragment,l),K=i(l),B=n(l,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1o6b4b1"&&(B.innerHTML=jl),D=i(l),J(W.$$.fragment,l),O=i(l),A=n(l,"P",{"data-svelte-h":!0}),p(A)!=="svelte-17v7btv"&&(A.textContent=Ul),ll=i(l),J(X.$$.fragment,l),sl=i(l),N=n(l,"P",{"data-svelte-h":!0}),p(N)!=="svelte-mkd2au"&&(N.innerHTML=dl),tl=i(l),v=n(l,"P",{"data-svelte-h":!0}),p(v)!=="svelte-h3dhy9"&&(v.innerHTML=rl),el=i(l),J(E.$$.fragment,l),al=i(l),J(z.$$.fragment,l),il=i(l),Z=n(l,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-mlly83"&&(Z.textContent=Il),Ml=i(l),H=n(l,"P",{}),bl(H).forEach(t),this.h()},h(){Cl(c,"name","hf:doc:metadata"),Cl(c,"content",vl)},m(l,s){Xl(document.head,c),e(l,k,s),e(l,R,s),e(l,G,s),m(w,l,s),e(l,Y,s),e(l,j,s),e(l,Q,s),e(l,U,s),e(l,x,s),m(d,l,s),e(l,F,s),e(l,r,s),e(l,$,s),e(l,I,s),e(l,S,s),e(l,b,s),e(l,g,s),m(C,l,s),e(l,q,s),e(l,_,s),e(l,L,s),e(l,f,s),e(l,P,s),m(h,l,s),e(l,K,s),e(l,B,s),e(l,D,s),m(W,l,s),e(l,O,s),e(l,A,s),e(l,ll,s),m(X,l,s),e(l,sl,s),e(l,N,s),e(l,tl,s),e(l,v,s),e(l,el,s),m(E,l,s),e(l,al,s),m(z,l,s),e(l,il,s),e(l,Z,s),e(l,Ml,s),e(l,H,s),nl=!0},p:fl,i(l){nl||(T(w.$$.fragment,l),T(d.$$.fragment,l),T(C.$$.fragment,l),T(h.$$.fragment,l),T(W.$$.fragment,l),T(X.$$.fragment,l),T(E.$$.fragment,l),T(z.$$.fragment,l),nl=!0)},o(l){y(w.$$.fragment,l),y(d.$$.fragment,l),y(C.$$.fragment,l),y(h.$$.fragment,l),y(W.$$.fragment,l),y(X.$$.fragment,l),y(E.$$.fragment,l),y(z.$$.fragment,l),nl=!1},d(l){l&&(t(k),t(R),t(G),t(Y),t(j),t(Q),t(U),t(x),t(F),t(r),t($),t(I),t(S),t(b),t(g),t(q),t(_),t(L),t(f),t(P),t(K),t(B),t(D),t(O),t(A),t(ll),t(sl),t(N),t(tl),t(v),t(el),t(al),t(il),t(Z),t(Ml),t(H)),t(c),u(w,l),u(d,l),u(C,l),u(h,l),u(W,l),u(X,l),u(E,l),u(z,l)}}}const vl='{"title":"Custom metric","local":"custom-metric","sections":[{"title":"How to define a custom metric","local":"how-to-define-a-custom-metric","sections":[],"depth":3},{"title":"Example of a custom metric","local":"example-of-a-custom-metric","sections":[],"depth":3}],"depth":1}';function El(cl){return hl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vl extends Bl{constructor(c){super(),Wl(this,c,El,Nl,_l,{})}}export{Vl as component};
