import{s as Vl,n as Rl,o as Yl}from"../chunks/scheduler.6062bdaf.js";import{S as Sl,i as Ql,g as i,s,r as M,A as Fl,h as o,f as t,c as n,j as Xl,u as p,x as r,k as ol,y as Ll,a,v as c,d,t as h,w as m}from"../chunks/index.4bca734e.js";import{C as Me}from"../chunks/CodeBlock.fa01571c.js";import{H as u}from"../chunks/Heading.723dceba.js";function zl(rl){let y,de,pe,he,w,me,b,Ml=`The Hugging Face Hub makes hosting and sharing models with the community easy. It supports
<a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">dozens of libraries</a> in the Open Source ecosystem. We are always
working on expanding this support to push collaborative Machine Learning forward. The <code>huggingface_hub</code> library plays a
key role in this process, allowing any Python script to easily push and load files.`,ue,T,pl="There are four main ways to integrate a library with the Hub:",ye,g,cl=`<li><strong>Push to Hub:</strong> implement a method to upload a model to the Hub. This includes the model weights, as well as
<a href="https://huggingface.co/docs/huggingface_hub/how-to-model-cards" rel="nofollow">the model card</a> and any other relevant information
or data necessary to run the model (for example, training logs). This method is often called <code>push_to_hub()</code>.</li> <li><strong>Download from Hub:</strong> implement a method to load a model from the Hub. The method should download the model
configuration/weights and load the model. This method is often called <code>from_pretrained</code> or <code>load_from_hub()</code>.</li> <li><strong>Inference API:</strong> use our servers to run inference on models supported by your library for free.</li> <li><strong>Widgets:</strong> display a widget on the landing page of your models on the Hub. It allows users to quickly try a model
from the browser.</li>`,fe,J,dl=`In this guide, we will focus on the first two topics. We will present the two main approaches you can use to integrate
a library, with their advantages and drawbacks. Everything is summarized at the end of the guide to help you choose
between the two. Please keep in mind that these are only guidelines that you are free to adapt to you requirements.`,je,U,hl=`If you are interested in Inference and Widgets, you can follow <a href="https://huggingface.co/docs/hub/models-adding-libraries#set-up-the-inference-api" rel="nofollow">this guide</a>.
In both cases, you can reach out to us if you are integrating a library with the Hub and want to be listed
<a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">in our docs</a>.`,we,_,be,I,ml=`The first approach to integrate a library to the Hub is to actually implement the <code>push_to_hub</code> and <code>from_pretrained</code>
methods by yourself. This gives you full flexibility on which files you need to upload/download and how to handle inputs
specific to your framework. You can refer to the two <a href="./upload">upload files</a> and <a href="./download">download files</a> guides
to learn more about how to do that. This is, for example how the FastAI integration is implemented (see <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.push_to_hub_fastai">push_to_hub_fastai()</a>
and <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.from_pretrained_fastai">from_pretrained_fastai()</a>).`,Te,C,ul="Implementation can differ between libraries, but the workflow is often similar.",ge,A,Je,v,yl="This is how a <code>from_pretrained</code> method usually look like:",Ue,k,_e,x,Ie,B,fl=`The <code>push_to_hub</code> method often requires a bit more complexity to handle repo creation, generate the model card and save weights.
A common approach is to save all of these files in a temporary folder, upload it and then delete it.`,Ce,Z,Ae,H,jl=`This is of course only an example. If you are interested in more complex manipulations (delete remote files, upload
weights on the fly, persist weights locally, etc.) please refer to the <a href="./upload">upload files</a> guide.`,ve,E,ke,G,wl=`While being flexible, this approach has some drawbacks, especially in terms of maintenance. Hugging Face users are often
used to additional features when working with <code>huggingface_hub</code>. For example, when loading files from the Hub, it is
common to offer parameters like:`,xe,W,bl="<li><code>token</code>: to download from a private repo</li> <li><code>revision</code>: to download from a specific branch</li> <li><code>cache_dir</code>: to cache files in a specific directory</li> <li><code>force_download</code>/<code>resume_download</code>/<code>local_files_only</code>: to reuse the cache or not</li> <li><code>proxies</code>: configure HTTP session</li>",Be,$,Tl="When pushing models, similar parameters are supported:",Ze,X,gl="<li><code>commit_message</code>: custom commit message</li> <li><code>private</code>: create a private repo if missing</li> <li><code>create_pr</code>: create a PR instead of pushing to <code>main</code></li> <li><code>branch</code>: push to a branch instead of the <code>main</code> branch</li> <li><code>allow_patterns</code>/<code>ignore_patterns</code>: filter which files to upload</li> <li><code>token</code></li> <li>…</li>",He,V,Jl=`All of these parameters can be added to the implementations we saw above and passed to the <code>huggingface_hub</code> methods.
However, if a parameter changes or a new feature is added, you will need to update your package. Supporting those
parameters also means more documentation to maintain on your side. To see how to mitigate these limitations, let’s jump
to our next section <strong>class inheritance</strong>.`,Ee,R,Ge,Y,Ul=`As we saw above, there are two main methods to include in your library to integrate it with the Hub: upload files
(<code>push_to_hub</code>) and download files (<code>from_pretrained</code>). You can implement those methods by yourself but it comes with
caveats. To tackle this, <code>huggingface_hub</code> provides a tool that uses class inheritance. Let’s see how it works!`,We,S,_l=`In a lot of cases, a library already implements its model using a Python class. The class contains the properties of
the model and methods to load, run, train, and evaluate it. Our approach is to extend this class to include upload and
download features using mixins. A <a href="https://stackoverflow.com/a/547714" rel="nofollow">Mixin</a> is a class that is meant to extend an
existing class with a set of specific features using multiple inheritance. <code>huggingface_hub</code> provides its own mixin,
the <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>. The key here is to understand its behavior and how to customize it.`,$e,Q,Il=`The <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> class implements 3 <em>public</em> methods (<code>push_to_hub</code>, <code>save_pretrained</code> and <code>from_pretrained</code>). Those
are the methods that your users will call to load/save models with your library. <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> also defines 2
<em>private</em> methods (<code>_save_pretrained</code> and <code>_from_pretrained</code>). Those are the ones you must implement. So to integrate
your library, you should:`,Xe,F,Cl=`<li>Make your Model class inherit from <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>.</li> <li>Implement the private methods:<ul><li><a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin._save_pretrained">_save_pretrained()</a>: method taking as input a path to a directory and saving the model to it.
You must write all the logic to dump your model in this method: model card, model weights, configuration files,
training logs, and figures. Any relevant information for this model must be handled by this method.
<a href="https://huggingface.co/docs/hub/model-cards" rel="nofollow">Model Cards</a> are particularly important to describe your model. Check
out <a href="./model-cards">our implementation guide</a> for more details.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin._from_pretrained">_from_pretrained()</a>: <strong>class method</strong> taking as input a <code>model_id</code> and returning an instantiated
model. The method must download the relevant files and load them.</li></ul></li> <li>You are done!</li>`,Ve,L,Al=`The advantage of using <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> is that once you take care of the serialization/loading of the files, you
are ready to go. You don’t need to worry about stuff like repo creation, commits, PRs, or revisions. All
of this is handled by the mixin and is available to your users. The Mixin also ensures that public methods are well
documented and type annotated.`,Re,z,vl='As a bonus, <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> handles the model configuration for you. If your <code>__init__</code> method expects a <code>config</code> input, it will be automatically saved in the repo when calling <code>save_pretrained</code> and reloaded correctly by <code>load_pretrained</code>. Moreover, if the <code>config</code> input parameter is annotated with dataclass type (e.g. <code>config: Optional[MyConfigClass] = None</code>), then the <code>config</code> value will be correctly deserialized for you. Finally, all jsonable values passed at initialization will be also stored in the config file. This means you don’t necessarily have to expect a <code>config</code> input to benefit from it. The big advantage of having a <code>config.json</code> file in your model repository is that it automatically enables the analytics on the Hub (e.g. the “downloads” count).',Ye,N,Se,q,kl='A good example of what we saw above is <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.PyTorchModelHubMixin">PyTorchModelHubMixin</a>, our integration for the PyTorch framework. This is a ready-to-use integration.',Qe,P,Fe,K,xl="Here is how any user can load/save a PyTorch model from/to the Hub:",Le,D,ze,O,Ne,ee,Bl='The implementation is actually very straightforward, and the full implementation can be found <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py" rel="nofollow">here</a>.',qe,le,Zl="<li>First, inherit your class from <code>ModelHubMixin</code>:</li>",Pe,te,Ke,f,Hl="<li>Implement the <code>_save_pretrained</code> method:</li>",De,ae,Oe,j,El="<li>Implement the <code>_from_pretrained</code> method:</li>",el,se,ll,ne,Gl="And that’s it! Your library now enables users to upload and download files to and from the Hub.",tl,ie,al,oe,Wl=`Let’s quickly sum up the two approaches we saw with their advantages and drawbacks. The table below is only indicative.
Your framework might have some specificities that you need to address. This guide is only here to give guidelines and
ideas on how to handle integration. In any case, feel free to contact us if you have any questions!`,sl,re,$l='<thead><tr><th align="center">Integration</th> <th align="center">Using helpers</th> <th align="center">Using <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a></th></tr></thead> <tbody><tr><td align="center">User experience</td> <td align="center"><code>model = load_from_hub(...)</code><br/><code>push_to_hub(model, ...)</code></td> <td align="center"><code>model = MyModel.from_pretrained(...)</code><br/><code>model.push_to_hub(...)</code></td></tr> <tr><td align="center">Flexibility</td> <td align="center">Very flexible.<br/>You fully control the implementation.</td> <td align="center">Less flexible.<br/>Your framework must have a model class.</td></tr> <tr><td align="center">Maintenance</td> <td align="center">More maintenance to add support for configuration, and new features. Might also require fixing issues reported by users.</td> <td align="center">Less maintenance as most of the interactions with the Hub are implemented in <code>huggingface_hub</code>.</td></tr> <tr><td align="center">Documentation / Type annotation</td> <td align="center">To be written manually.</td> <td align="center">Partially handled by <code>huggingface_hub</code>.</td></tr> <tr><td align="center">Download counter</td> <td align="center">To be handled manually.</td> <td align="center">Enabled by default if class has a <code>config</code> attribute.</td></tr></tbody>',nl,ce,il;return w=new u({props:{title:"Integrate any ML framework with the Hub",local:"integrate-any-ml-framework-with-the-hub",headingTag:"h1"}}),_=new u({props:{title:"A flexible approach: helpers",local:"a-flexible-approach-helpers",headingTag:"h2"}}),A=new u({props:{title:"from_pretrained",local:"frompretrained",headingTag:"h3"}}),k=new Me({props:{code:"ZGVmJTIwZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTNBJTIwc3RyKSUyMC0lM0UlMjBNeU1vZGVsQ2xhc3MlM0ElMEElMjAlMjAlMjAlMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwZnJvbSUyMEh1YiUwQSUyMCUyMCUyMGNhY2hlZF9tb2RlbCUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZCglMEElMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGZpbGVuYW1lJTNEJTIybW9kZWwucGtsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbGlicmFyeV9uYW1lJTNEJTIyZmFzdGFpJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbGlicmFyeV92ZXJzaW9uJTNEZ2V0X2Zhc3RhaV92ZXJzaW9uKCklMkMlMEElMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIzJTIwTG9hZCUyMG1vZGVsJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbG9hZF9tb2RlbChjYWNoZWRfbW9kZWwp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">from_pretrained</span>(<span class="hljs-params">model_id: <span class="hljs-built_in">str</span></span>) -&gt; MyModelClass:
   <span class="hljs-comment"># Download model from Hub</span>
   cached_model = hf_hub_download(
      repo_id=repo_id,
      filename=<span class="hljs-string">&quot;model.pkl&quot;</span>,
      library_name=<span class="hljs-string">&quot;fastai&quot;</span>,
      library_version=get_fastai_version(),
   )

   <span class="hljs-comment"># Load model</span>
    <span class="hljs-keyword">return</span> load_model(cached_model)`,wrap:!1}}),x=new u({props:{title:"push_to_hub",local:"pushtohub",headingTag:"h3"}}),Z=new Me({props:{code:"ZGVmJTIwcHVzaF90b19odWIobW9kZWwlM0ElMjBNeU1vZGVsQ2xhc3MlMkMlMjByZXBvX25hbWUlM0ElMjBzdHIpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjBhcGklMjAlM0QlMjBIZkFwaSgpJTBBJTBBJTIwJTIwJTIwJTIzJTIwQ3JlYXRlJTIwcmVwbyUyMGlmJTIwbm90JTIwZXhpc3RpbmclMjB5ZXQlMjBhbmQlMjBnZXQlMjB0aGUlMjBhc3NvY2lhdGVkJTIwcmVwb19pZCUwQSUyMCUyMCUyMHJlcG9faWQlMjAlM0QlMjBhcGkuY3JlYXRlX3JlcG8ocmVwb19uYW1lJTJDJTIwZXhpc3Rfb2slM0RUcnVlKSUwQSUwQSUyMCUyMCUyMCUyMyUyMFNhdmUlMjBhbGwlMjBmaWxlcyUyMGluJTIwYSUyMHRlbXBvcmFyeSUyMGRpcmVjdG9yeSUyMGFuZCUyMHB1c2glMjB0aGVtJTIwaW4lMjBhJTIwc2luZ2xlJTIwY29tbWl0JTBBJTIwJTIwJTIwd2l0aCUyMFRlbXBvcmFyeURpcmVjdG9yeSgpJTIwYXMlMjB0bXBkaXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjB0bXBkaXIlMjAlM0QlMjBQYXRoKHRtcGRpciklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTYXZlJTIwd2VpZ2h0cyUwQSUyMCUyMCUyMCUyMCUyMCUyMHNhdmVfbW9kZWwobW9kZWwlMkMlMjB0bXBkaXIlMjAlMkYlMjAlMjJtb2RlbC5zYWZldGVuc29ycyUyMiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBHZW5lcmF0ZSUyMG1vZGVsJTIwY2FyZCUwQSUyMCUyMCUyMCUyMCUyMCUyMGNhcmQlMjAlM0QlMjBnZW5lcmF0ZV9tb2RlbF9jYXJkKG1vZGVsKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCh0bXBkaXIlMjAlMkYlMjAlMjJSRUFETUUubWQlMjIpLndyaXRlX3RleHQoY2FyZCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTYXZlJTIwbG9ncyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFNhdmUlMjBmaWd1cmVzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwU2F2ZSUyMGV2YWx1YXRpb24lMjBtZXRyaWNzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwLi4uJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwUHVzaCUyMHRvJTIwaHViJTBBJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwYXBpLnVwbG9hZF9mb2xkZXIocmVwb19pZCUzRHJlcG9faWQlMkMlMjBmb2xkZXJfcGF0aCUzRHRtcGRpcik=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">push_to_hub</span>(<span class="hljs-params">model: MyModelClass, repo_name: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-literal">None</span>:
   api = HfApi()

   <span class="hljs-comment"># Create repo if not existing yet and get the associated repo_id</span>
   repo_id = api.create_repo(repo_name, exist_ok=<span class="hljs-literal">True</span>)

   <span class="hljs-comment"># Save all files in a temporary directory and push them in a single commit</span>
   <span class="hljs-keyword">with</span> TemporaryDirectory() <span class="hljs-keyword">as</span> tmpdir:
      tmpdir = Path(tmpdir)

      <span class="hljs-comment"># Save weights</span>
      save_model(model, tmpdir / <span class="hljs-string">&quot;model.safetensors&quot;</span>)

      <span class="hljs-comment"># Generate model card</span>
      card = generate_model_card(model)
      (tmpdir / <span class="hljs-string">&quot;README.md&quot;</span>).write_text(card)

      <span class="hljs-comment"># Save logs</span>
      <span class="hljs-comment"># Save figures</span>
      <span class="hljs-comment"># Save evaluation metrics</span>
      <span class="hljs-comment"># ...</span>

      <span class="hljs-comment"># Push to hub</span>
      <span class="hljs-keyword">return</span> api.upload_folder(repo_id=repo_id, folder_path=tmpdir)`,wrap:!1}}),E=new u({props:{title:"Limitations",local:"limitations",headingTag:"h3"}}),R=new u({props:{title:"A more complex approach: class inheritance",local:"a-more-complex-approach-class-inheritance",headingTag:"h2"}}),N=new u({props:{title:"A concrete example: PyTorch",local:"a-concrete-example-pytorch",headingTag:"h3"}}),P=new u({props:{title:"How to use it?",local:"how-to-use-it",headingTag:"h4"}}),D=new Me({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwUHlUb3JjaE1vZGVsSHViTWl4aW4lMEElMEElMEFjbGFzcyUyME15TW9kZWwobm4uTW9kdWxlJTJDJTIwUHlUb3JjaE1vZGVsSHViTWl4aW4pJTNBJTIwJTIzJTIwbXVsdGlwbGUlMjBpbmhlcml0YW5jZSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBoaWRkZW5fc2l6ZSUzQSUyMGludCUyMCUzRCUyMDUxMiUyQyUyMHZvY2FiX3NpemUlM0ElMjBpbnQlMjAlM0QlMjAzMDAwMCUyQyUyMG91dHB1dF9zaXplJTNBJTIwaW50JTIwJTNEJTIwNCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnBhcmFtJTIwJTNEJTIwbm4uUGFyYW1ldGVyKHRvcmNoLnJhbmQoaGlkZGVuX3NpemUlMkMlMjB2b2NhYl9zaXplKSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmxpbmVhciUyMCUzRCUyMG5uLkxpbmVhcihvdXRwdXRfc2l6ZSUyQyUyMHZvY2FiX3NpemUpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIweCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLmxpbmVhcih4JTIwJTJCJTIwc2VsZi5wYXJhbSklMEElMEFtb2RlbCUyMCUzRCUyME15TW9kZWwoaGlkZGVuX3NpemUlM0QxMjgpJTBBJTBBbW9kZWwuY29uZmlnJTBBJTBBbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMnBhdGglMkZ0byUyRm15LWF3ZXNvbWUtbW9kZWwlMjIpJTBBJTBBbW9kZWwucHVzaF90b19odWIoJTIybXktYXdlc29tZS1tb2RlbCUyMiklMEElMEFtb2RlbCUyMCUzRCUyME15TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnVzZXJuYW1lJTJGbXktYXdlc29tZS1tb2RlbCUyMiklMEFtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> PyTorchModelHubMixin


<span class="hljs-comment"># Define your Pytorch model exactly the same way you are used to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(nn.Module, PyTorchModelHubMixin): <span class="hljs-comment"># multiple inheritance</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, hidden_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">512</span>, vocab_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">30000</span>, output_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">4</span></span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__()
<span class="hljs-meta">... </span>        self.param = nn.Parameter(torch.rand(hidden_size, vocab_size))
<span class="hljs-meta">... </span>        self.linear = nn.Linear(output_size, vocab_size)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> self.linear(x + self.param)

<span class="hljs-comment"># 1. Create model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel(hidden_size=<span class="hljs-number">128</span>)

<span class="hljs-comment"># Config is automatically created based on input + default values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config
{<span class="hljs-string">&quot;hidden_size&quot;</span>: <span class="hljs-number">128</span>, <span class="hljs-string">&quot;vocab_size&quot;</span>: <span class="hljs-number">30000</span>, <span class="hljs-string">&quot;output_size&quot;</span>: <span class="hljs-number">4</span>}

<span class="hljs-comment"># 2. (optional) Save model to local directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;path/to/my-awesome-model&quot;</span>)

<span class="hljs-comment"># 3. Push model weights to the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># 4. Initialize model from the Hub =&gt; config has been preserved</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel.from_pretrained(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config
{<span class="hljs-string">&quot;hidden_size&quot;</span>: <span class="hljs-number">128</span>, <span class="hljs-string">&quot;vocab_size&quot;</span>: <span class="hljs-number">30000</span>, <span class="hljs-string">&quot;output_size&quot;</span>: <span class="hljs-number">4</span>}`,wrap:!1}}),O=new u({props:{title:"Implementation",local:"implementation",headingTag:"h4"}}),te=new Me({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelHubMixin

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)`,wrap:!1}}),ae=new Me({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLiklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfc2F2ZV9wcmV0cmFpbmVkKHNlbGYlMkMlMjBzYXZlX2RpcmVjdG9yeSUzQSUyMFBhdGgpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlMjIlMjJTYXZlJTIwd2VpZ2h0cyUyMGZyb20lMjBhJTIwUHl0b3JjaCUyMG1vZGVsJTIwdG8lMjBhJTIwbG9jYWwlMjBkaXJlY3RvcnkuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2F2ZV9tb2RlbF9hc19zYWZldGVuc29yKHNlbGYubW9kdWxlJTJDJTIwc3RyKHNhdmVfZGlyZWN0b3J5JTIwJTJGJTIwU0FGRVRFTlNPUlNfU0lOR0xFX0ZJTEUpKSUwQQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelHubMixin

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_save_pretrained</span>(<span class="hljs-params">self, save_directory: Path</span>) -&gt; <span class="hljs-literal">None</span>:
        <span class="hljs-string">&quot;&quot;&quot;Save weights from a Pytorch model to a local directory.&quot;&quot;&quot;</span>
        save_model_as_safetensor(self.module, <span class="hljs-built_in">str</span>(save_directory / SAFETENSORS_SINGLE_FILE))
`,wrap:!1}}),se=new Me({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

<span class="hljs-meta">   @classmethod </span><span class="hljs-comment"># Must be a classmethod!</span>
   <span class="hljs-keyword">def</span> <span class="hljs-title function_">_from_pretrained</span>(<span class="hljs-params">
      cls,
      *,
      model_id: <span class="hljs-built_in">str</span>,
      revision: <span class="hljs-built_in">str</span>,
      cache_dir: <span class="hljs-built_in">str</span>,
      force_download: <span class="hljs-built_in">bool</span>,
      proxies: <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>],
      resume_download: <span class="hljs-built_in">bool</span>,
      local_files_only: <span class="hljs-built_in">bool</span>,
      token: <span class="hljs-type">Union</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">bool</span>, <span class="hljs-literal">None</span>],
      map_location: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;cpu&quot;</span>, <span class="hljs-comment"># additional argument</span>
      strict: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>, <span class="hljs-comment"># additional argument</span>
      **model_kwargs,
   </span>):
      <span class="hljs-string">&quot;&quot;&quot;Load Pytorch pretrained weights and return the loaded model.&quot;&quot;&quot;</span>
        model = cls(**model_kwargs)
        <span class="hljs-keyword">if</span> os.path.isdir(model_id):
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Loading weights from local directory&quot;</span>)
            model_file = os.path.join(model_id, SAFETENSORS_SINGLE_FILE)
            <span class="hljs-keyword">return</span> cls._load_as_safetensor(model, model_file, map_location, strict)

         model_file = hf_hub_download(
            repo_id=model_id,
            filename=SAFETENSORS_SINGLE_FILE,
            revision=revision,
            cache_dir=cache_dir,
            force_download=force_download,
            proxies=proxies,
            resume_download=resume_download,
            token=token,
            local_files_only=local_files_only,
            )
         <span class="hljs-keyword">return</span> cls._load_as_safetensor(model, model_file, map_location, strict)`,wrap:!1}}),ie=new u({props:{title:"Quick comparison",local:"quick-comparison",headingTag:"h2"}}),{c(){y=i("meta"),de=s(),pe=i("p"),he=s(),M(w.$$.fragment),me=s(),b=i("p"),b.innerHTML=Ml,ue=s(),T=i("p"),T.textContent=pl,ye=s(),g=i("ol"),g.innerHTML=cl,fe=s(),J=i("p"),J.textContent=dl,je=s(),U=i("p"),U.innerHTML=hl,we=s(),M(_.$$.fragment),be=s(),I=i("p"),I.innerHTML=ml,Te=s(),C=i("p"),C.textContent=ul,ge=s(),M(A.$$.fragment),Je=s(),v=i("p"),v.innerHTML=yl,Ue=s(),M(k.$$.fragment),_e=s(),M(x.$$.fragment),Ie=s(),B=i("p"),B.innerHTML=fl,Ce=s(),M(Z.$$.fragment),Ae=s(),H=i("p"),H.innerHTML=jl,ve=s(),M(E.$$.fragment),ke=s(),G=i("p"),G.innerHTML=wl,xe=s(),W=i("ul"),W.innerHTML=bl,Be=s(),$=i("p"),$.textContent=Tl,Ze=s(),X=i("ul"),X.innerHTML=gl,He=s(),V=i("p"),V.innerHTML=Jl,Ee=s(),M(R.$$.fragment),Ge=s(),Y=i("p"),Y.innerHTML=Ul,We=s(),S=i("p"),S.innerHTML=_l,$e=s(),Q=i("p"),Q.innerHTML=Il,Xe=s(),F=i("ol"),F.innerHTML=Cl,Ve=s(),L=i("p"),L.innerHTML=Al,Re=s(),z=i("p"),z.innerHTML=vl,Ye=s(),M(N.$$.fragment),Se=s(),q=i("p"),q.innerHTML=kl,Qe=s(),M(P.$$.fragment),Fe=s(),K=i("p"),K.textContent=xl,Le=s(),M(D.$$.fragment),ze=s(),M(O.$$.fragment),Ne=s(),ee=i("p"),ee.innerHTML=Bl,qe=s(),le=i("ol"),le.innerHTML=Zl,Pe=s(),M(te.$$.fragment),Ke=s(),f=i("ol"),f.innerHTML=Hl,De=s(),M(ae.$$.fragment),Oe=s(),j=i("ol"),j.innerHTML=El,el=s(),M(se.$$.fragment),ll=s(),ne=i("p"),ne.textContent=Gl,tl=s(),M(ie.$$.fragment),al=s(),oe=i("p"),oe.textContent=Wl,sl=s(),re=i("table"),re.innerHTML=$l,nl=s(),ce=i("p"),this.h()},l(e){const l=Fl("svelte-u9bgzb",document.head);y=o(l,"META",{name:!0,content:!0}),l.forEach(t),de=n(e),pe=o(e,"P",{}),Xl(pe).forEach(t),he=n(e),p(w.$$.fragment,e),me=n(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-uvt37o"&&(b.innerHTML=Ml),ue=n(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-14vdlq5"&&(T.textContent=pl),ye=n(e),g=o(e,"OL",{"data-svelte-h":!0}),r(g)!=="svelte-14btp4x"&&(g.innerHTML=cl),fe=n(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1tx4sul"&&(J.textContent=dl),je=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-10f3yyh"&&(U.innerHTML=hl),we=n(e),p(_.$$.fragment,e),be=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-r9ojoj"&&(I.innerHTML=ml),Te=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1g2giur"&&(C.textContent=ul),ge=n(e),p(A.$$.fragment,e),Je=n(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-bozc1x"&&(v.innerHTML=yl),Ue=n(e),p(k.$$.fragment,e),_e=n(e),p(x.$$.fragment,e),Ie=n(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-7bmo7d"&&(B.innerHTML=fl),Ce=n(e),p(Z.$$.fragment,e),Ae=n(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-15vgu12"&&(H.innerHTML=jl),ve=n(e),p(E.$$.fragment,e),ke=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-tzwehq"&&(G.innerHTML=wl),xe=n(e),W=o(e,"UL",{"data-svelte-h":!0}),r(W)!=="svelte-6gcvoy"&&(W.innerHTML=bl),Be=n(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-3m9y73"&&($.textContent=Tl),Ze=n(e),X=o(e,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-30swpt"&&(X.innerHTML=gl),He=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-p8rs76"&&(V.innerHTML=Jl),Ee=n(e),p(R.$$.fragment,e),Ge=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1uvlinw"&&(Y.innerHTML=Ul),We=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-qqd3b3"&&(S.innerHTML=_l),$e=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1e60xo5"&&(Q.innerHTML=Il),Xe=n(e),F=o(e,"OL",{"data-svelte-h":!0}),r(F)!=="svelte-1czklek"&&(F.innerHTML=Cl),Ve=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-15kbqb0"&&(L.innerHTML=Al),Re=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-a35nta"&&(z.innerHTML=vl),Ye=n(e),p(N.$$.fragment,e),Se=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-ua16f3"&&(q.innerHTML=kl),Qe=n(e),p(P.$$.fragment,e),Fe=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-l2ktl8"&&(K.textContent=xl),Le=n(e),p(D.$$.fragment,e),ze=n(e),p(O.$$.fragment,e),Ne=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-l2iz9k"&&(ee.innerHTML=Bl),qe=n(e),le=o(e,"OL",{"data-svelte-h":!0}),r(le)!=="svelte-1a9vqht"&&(le.innerHTML=Zl),Pe=n(e),p(te.$$.fragment,e),Ke=n(e),f=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(f)!=="svelte-mclxy5"&&(f.innerHTML=Hl),De=n(e),p(ae.$$.fragment,e),Oe=n(e),j=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(j)!=="svelte-1vfuaub"&&(j.innerHTML=El),el=n(e),p(se.$$.fragment,e),ll=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-zuw9zy"&&(ne.textContent=Gl),tl=n(e),p(ie.$$.fragment,e),al=n(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1qi11kl"&&(oe.textContent=Wl),sl=n(e),re=o(e,"TABLE",{"data-svelte-h":!0}),r(re)!=="svelte-1ifyewn"&&(re.innerHTML=$l),nl=n(e),ce=o(e,"P",{}),Xl(ce).forEach(t),this.h()},h(){ol(y,"name","hf:doc:metadata"),ol(y,"content",Nl),ol(f,"start","2"),ol(j,"start","3")},m(e,l){Ll(document.head,y),a(e,de,l),a(e,pe,l),a(e,he,l),c(w,e,l),a(e,me,l),a(e,b,l),a(e,ue,l),a(e,T,l),a(e,ye,l),a(e,g,l),a(e,fe,l),a(e,J,l),a(e,je,l),a(e,U,l),a(e,we,l),c(_,e,l),a(e,be,l),a(e,I,l),a(e,Te,l),a(e,C,l),a(e,ge,l),c(A,e,l),a(e,Je,l),a(e,v,l),a(e,Ue,l),c(k,e,l),a(e,_e,l),c(x,e,l),a(e,Ie,l),a(e,B,l),a(e,Ce,l),c(Z,e,l),a(e,Ae,l),a(e,H,l),a(e,ve,l),c(E,e,l),a(e,ke,l),a(e,G,l),a(e,xe,l),a(e,W,l),a(e,Be,l),a(e,$,l),a(e,Ze,l),a(e,X,l),a(e,He,l),a(e,V,l),a(e,Ee,l),c(R,e,l),a(e,Ge,l),a(e,Y,l),a(e,We,l),a(e,S,l),a(e,$e,l),a(e,Q,l),a(e,Xe,l),a(e,F,l),a(e,Ve,l),a(e,L,l),a(e,Re,l),a(e,z,l),a(e,Ye,l),c(N,e,l),a(e,Se,l),a(e,q,l),a(e,Qe,l),c(P,e,l),a(e,Fe,l),a(e,K,l),a(e,Le,l),c(D,e,l),a(e,ze,l),c(O,e,l),a(e,Ne,l),a(e,ee,l),a(e,qe,l),a(e,le,l),a(e,Pe,l),c(te,e,l),a(e,Ke,l),a(e,f,l),a(e,De,l),c(ae,e,l),a(e,Oe,l),a(e,j,l),a(e,el,l),c(se,e,l),a(e,ll,l),a(e,ne,l),a(e,tl,l),c(ie,e,l),a(e,al,l),a(e,oe,l),a(e,sl,l),a(e,re,l),a(e,nl,l),a(e,ce,l),il=!0},p:Rl,i(e){il||(d(w.$$.fragment,e),d(_.$$.fragment,e),d(A.$$.fragment,e),d(k.$$.fragment,e),d(x.$$.fragment,e),d(Z.$$.fragment,e),d(E.$$.fragment,e),d(R.$$.fragment,e),d(N.$$.fragment,e),d(P.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(ae.$$.fragment,e),d(se.$$.fragment,e),d(ie.$$.fragment,e),il=!0)},o(e){h(w.$$.fragment,e),h(_.$$.fragment,e),h(A.$$.fragment,e),h(k.$$.fragment,e),h(x.$$.fragment,e),h(Z.$$.fragment,e),h(E.$$.fragment,e),h(R.$$.fragment,e),h(N.$$.fragment,e),h(P.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(se.$$.fragment,e),h(ie.$$.fragment,e),il=!1},d(e){e&&(t(de),t(pe),t(he),t(me),t(b),t(ue),t(T),t(ye),t(g),t(fe),t(J),t(je),t(U),t(we),t(be),t(I),t(Te),t(C),t(ge),t(Je),t(v),t(Ue),t(_e),t(Ie),t(B),t(Ce),t(Ae),t(H),t(ve),t(ke),t(G),t(xe),t(W),t(Be),t($),t(Ze),t(X),t(He),t(V),t(Ee),t(Ge),t(Y),t(We),t(S),t($e),t(Q),t(Xe),t(F),t(Ve),t(L),t(Re),t(z),t(Ye),t(Se),t(q),t(Qe),t(Fe),t(K),t(Le),t(ze),t(Ne),t(ee),t(qe),t(le),t(Pe),t(Ke),t(f),t(De),t(Oe),t(j),t(el),t(ll),t(ne),t(tl),t(al),t(oe),t(sl),t(re),t(nl),t(ce)),t(y),m(w,e),m(_,e),m(A,e),m(k,e),m(x,e),m(Z,e),m(E,e),m(R,e),m(N,e),m(P,e),m(D,e),m(O,e),m(te,e),m(ae,e),m(se,e),m(ie,e)}}}const Nl='{"title":"Integrate any ML framework with the Hub","local":"integrate-any-ml-framework-with-the-hub","sections":[{"title":"A flexible approach: helpers","local":"a-flexible-approach-helpers","sections":[{"title":"from_pretrained","local":"frompretrained","sections":[],"depth":3},{"title":"push_to_hub","local":"pushtohub","sections":[],"depth":3},{"title":"Limitations","local":"limitations","sections":[],"depth":3}],"depth":2},{"title":"A more complex approach: class inheritance","local":"a-more-complex-approach-class-inheritance","sections":[{"title":"A concrete example: PyTorch","local":"a-concrete-example-pytorch","sections":[{"title":"How to use it?","local":"how-to-use-it","sections":[],"depth":4},{"title":"Implementation","local":"implementation","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Quick comparison","local":"quick-comparison","sections":[],"depth":2}],"depth":1}';function ql(rl){return Yl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class et extends Sl{constructor(y){super(),Ql(this,y,ql,zl,Vl,{})}}export{et as component};
