import{s as Uo,o as jo,n as vt}from"../chunks/scheduler.182ea377.js";import{S as Jo,i as Xo,g as n,s as i,p as g,A as No,h as o,f as r,c as s,j as M,q as h,m as d,k as m,v as e,a as P,r as _,d as x,t as b,u as v}from"../chunks/index.008d68e4.js";import{T as Wo}from"../chunks/Tip.4f096367.js";import{D as $}from"../chunks/Docstring.7aec8b85.js";import{C as Zt}from"../chunks/CodeBlock.5ed6eb7b.js";import{I as En}from"../chunks/IconCopyLink.96bbb92b.js";import{E as Wt}from"../chunks/ExampleCodeBlock.23e54afe.js";function Zo(C){let l,T='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){l=n("p"),l.innerHTML=T},l(p){l=o(p,"P",{"data-svelte-h":!0}),d(l)!=="svelte-1wmc0l4"&&(l.innerHTML=T)},m(p,c){P(p,l,c)},p:vt,d(p){p&&r(l)}}}function zo(C){let l,T="Examples:",p,c,I;return c=new Zt({props:{code:"aW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUlMEElMEElMEFkZWYlMjBkb3dubG9hZF9pbWFnZSh1cmwpJTNBJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMFBJTC5JbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZkaWZmdXNlcnMlMkZkaWZmdXNlcnMtaW1hZ2VzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRm1vdW50YWluLnBuZyUyMiUwQSUwQWltYWdlJTIwJTNEJTIwZG93bmxvYWRfaW1hZ2UoaW1nX3VybCkucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbnN0cnVjdFBpeDJQaXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIydGltYnJvb2tzJTJGaW5zdHJ1Y3QtcGl4MnBpeCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMm1ha2UlMjB0aGUlMjBtb3VudGFpbnMlMjBzbm93eSUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInstructPix2PixPipeline


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
<span class="hljs-meta">... </span>    response = requests.get(url)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/diffusers-images-docs/resolve/main/mountain.png&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionInstructPix2PixPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;timbrooks/instruct-pix2pix&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;make the mountains snowy&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=prompt, image=image).images[<span class="hljs-number">0</span>]`}}),{c(){l=n("p"),l.textContent=T,p=i(),g(c.$$.fragment)},l(a){l=o(a,"P",{"data-svelte-h":!0}),d(l)!=="svelte-kvfsh7"&&(l.textContent=T),p=s(a),h(c.$$.fragment,a)},m(a,D){P(a,l,D),P(a,p,D),_(c,a,D),I=!0},p:vt,i(a){I||(x(c.$$.fragment,a),I=!0)},o(a){b(c.$$.fragment,a),I=!1},d(a){a&&(r(l),r(p)),v(c,a)}}}function Eo(C){let l,T="To load a Textual Inversion embedding vector in 🤗 Diffusers format:",p,c,I;return c=new Zt({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`}}),{c(){l=n("p"),l.textContent=T,p=i(),g(c.$$.fragment)},l(a){l=o(a,"P",{"data-svelte-h":!0}),d(l)!=="svelte-1gc783q"&&(l.textContent=T),p=s(a),h(c.$$.fragment,a)},m(a,D){P(a,l,D),P(a,p,D),_(c,a,D),I=!0},p:vt,i(a){I||(x(c.$$.fragment,a),I=!0)},o(a){b(c.$$.fragment,a),I=!1},d(a){a&&(r(l),r(p)),v(c,a)}}}function Go(C){let l,T="locally:",p,c,I;return c=new Zt({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`}}),{c(){l=n("p"),l.textContent=T,p=i(),g(c.$$.fragment)},l(a){l=o(a,"P",{"data-svelte-h":!0}),d(l)!=="svelte-4c75kq"&&(l.textContent=T),p=s(a),h(c.$$.fragment,a)},m(a,D){P(a,l,D),P(a,p,D),_(c,a,D),I=!0},p:vt,i(a){I||(x(c.$$.fragment,a),I=!0)},o(a){b(c.$$.fragment,a),I=!1},d(a){a&&(r(l),r(p)),v(c,a)}}}function Bo(C){let l,T="Examples:",p,c,I;return c=new Zt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExJbnN0cnVjdFBpeDJQaXhQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcmVzb2x1dGlvbiUyMCUzRCUyMDc2OCUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmhmLmNvJTJGZGF0YXNldHMlMkZkaWZmdXNlcnMlMkZkaWZmdXNlcnMtaW1hZ2VzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRm1vdW50YWluLnBuZyUyMiUwQSkucmVzaXplKChyZXNvbHV0aW9uJTJDJTIwcmVzb2x1dGlvbikpJTBBZWRpdF9pbnN0cnVjdGlvbiUyMCUzRCUyMCUyMlR1cm4lMjBza3klMjBpbnRvJTIwYSUyMGNsb3VkeSUyMG9uZSUyMiUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTEluc3RydWN0UGl4MlBpeFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMkZzZHhsLWluc3RydWN0cGl4MnBpeC03NjglMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBZWRpdGVkX2ltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0RlZGl0X2luc3RydWN0aW9uJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRHJlc29sdXRpb24lMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRHJlc29sdXRpb24lMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDMuMCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlX2d1aWRhbmNlX3NjYWxlJTNEMS41JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBZWRpdGVkX2ltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLInstructPix2PixPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>resolution = <span class="hljs-number">768</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://hf.co/datasets/diffusers/diffusers-images-docs/resolve/main/mountain.png&quot;</span>
<span class="hljs-meta">... </span>).resize((resolution, resolution))
<span class="hljs-meta">&gt;&gt;&gt; </span>edit_instruction = <span class="hljs-string">&quot;Turn sky into a cloudy one&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionXLInstructPix2PixPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;diffusers/sdxl-instructpix2pix-768&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>edited_image = pipe(
<span class="hljs-meta">... </span>    prompt=edit_instruction,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    height=resolution,
<span class="hljs-meta">... </span>    width=resolution,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">3.0</span>,
<span class="hljs-meta">... </span>    image_guidance_scale=<span class="hljs-number">1.5</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>edited_image`}}),{c(){l=n("p"),l.textContent=T,p=i(),g(c.$$.fragment)},l(a){l=o(a,"P",{"data-svelte-h":!0}),d(l)!=="svelte-kvfsh7"&&(l.textContent=T),p=s(a),h(c.$$.fragment,a)},m(a,D){P(a,l,D),P(a,p,D),_(c,a,D),I=!0},p:vt,i(a){I||(x(c.$$.fragment,a),I=!0)},o(a){b(c.$$.fragment,a),I=!1},d(a){a&&(r(l),r(p)),v(c,a)}}}function Fo(C){let l,T,p,c,I,a,D,De,Gn="InstructPix2Pix",Pt,ie,Bn='<a href="https://huggingface.co/papers/2211.09800" rel="nofollow">InstructPix2Pix: Learning to Follow Image Editing Instructions</a> is by Tim Brooks, Aleksander Holynski and Alexei A. Efros.',wt,se,Fn="The abstract from the paper is:",yt,ae,An="<em>We propose a method for editing images from human instructions: given an input image and a written instruction that tells the model what to do, our model follows these instructions to edit the image. To obtain training data for this problem, we combine the knowledge of two large pretrained models — a language model (GPT-3) and a text-to-image model (Stable Diffusion) — to generate a large dataset of image editing examples. Our conditional diffusion model, InstructPix2Pix, is trained on our generated data, and generalizes to real images and user-written instructions at inference time. Since it performs edits in the forward pass and does not require per example fine-tuning or inversion, our model edits images quickly, in a matter of seconds. We show compelling editing results for a diverse collection of input images and written instructions.</em>",It,re,Hn='You can find additional information about InstructPix2Pix on the <a href="https://www.timothybrooks.com/instruct-pix2pix" rel="nofollow">project page</a>, <a href="https://github.com/timothybrooks/instruct-pix2pix" rel="nofollow">original codebase</a>, and try it out in a <a href="https://huggingface.co/spaces/timbrooks/instruct-pix2pix" rel="nofollow">demo</a>.',Mt,B,St,E,F,gt,le,zt,ke,Rn="StableDiffusionInstructPix2PixPipeline",Tt,w,de,Et,Le,qn="Pipeline for pixel-level image editing by following text instructions (based on Stable Diffusion).",Gt,$e,Vn=`This model inherits from <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Bt,Ce,Yn="The pipeline also inherits the following loading methods:",Ft,Ue,Qn='<li><a href="/docs/diffusers/v0.25.0/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',At,N,ce,Ht,je,On="The call function to the pipeline for generation.",Rt,A,qt,k,pe,Vt,Je,Kn=`Load Textual Inversion embeddings into the text encoder of <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,Yt,Xe,eo="Example:",Qt,H,Ot,Ne,to=`To load a Textual Inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,Kt,R,en,L,fe,tn,We,no=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,nn,Ze,oo="All kwargs are forwarded to <code>self.lora_state_dict</code>.",on,ze,io='See <a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is loaded.',sn,Ee,so=`See <a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is loaded into
<code>self.unet</code>.`,an,Ge,ao=`See <a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state dict is loaded
into <code>self.text_encoder</code>.`,rn,q,ue,ln,Be,ro="Save the LoRA parameters corresponding to the UNet and text encoder.",dn,V,me,cn,Fe,lo="Disables the FreeU mechanism if enabled.",pn,U,ge,fn,Ae,co='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',un,He,po="The suffixes after the scaling factors represent the stages where they are being applied.",mn,Re,fo=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,Dt,G,Y,ht,he,gn,qe,uo="StableDiffusionXLInstructPix2PixPipeline",kt,u,_e,hn,Ve,mo="Pipeline for pixel-level image editing by following text instructions. Based on Stable Diffusion XL.",_n,Ye,go=`This model inherits from <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,xn,Qe,ho="The pipeline also inherits the following loading methods:",bn,Oe,_o='<li><a href="/docs/diffusers/v0.25.0/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><code>save_lora_weights()</code> for saving LoRA weights</li>',vn,W,xe,Pn,Ke,xo="Function invoked when calling the pipeline for generation.",wn,Q,yn,O,be,In,et,bo="Disables the FreeU mechanism if enabled.",Mn,K,ve,Sn,tt,vo=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously invoked, this method will go back to
computing decoding in one step.`,Tn,ee,Pe,Dn,nt,Po=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously invoked, this method will go back to
computing decoding in one step.`,kn,j,we,Ln,ot,wo='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',$n,it,yo="The suffixes after the scaling factors represent the stages where they are being applied.",Cn,st,Io=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,Un,Z,ye,jn,at,Mo="Enable sliced VAE decoding.",Jn,rt,So=`When this option is enabled, the VAE will split the input tensor in slices to compute decoding in several
steps. This is useful to save some memory and allow larger batch sizes.`,Xn,z,Ie,Nn,lt,To="Enable tiled VAE decoding.",Wn,dt,Do=`When this option is enabled, the VAE will split the input tensor into tiles to compute decoding and encoding in
several steps. This is useful to save a large amount of memory and to allow the processing of larger images.`,Zn,te,Me,zn,ct,ko="Encodes the prompt into text encoder hidden states.",Lt;return a=new En({}),B=new Wo({props:{$$slots:{default:[Zo]},$$scope:{ctx:C}}}),le=new En({}),de=new $({props:{name:"class diffusers.StableDiffusionInstructPix2PixPipeline",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": Optional = None"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.25.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.25.0/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.25.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_instruct_pix2pix.py#L75"}}),ce=new $({props:{name:"__call__",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"image",val:": Union = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 7.5"},{name:"image_guidance_scale",val:": float = 1.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code> <code>np.ndarray</code>, <code>PIL.Image.Image</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code> or tensor representing an image batch to be repainted according to <code>prompt</code>. Can also accept
image latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.image_guidance_scale",description:`<strong>image_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.5) &#x2014;
Push the generated image towards the inital <code>image</code>. Image guidance scale is enabled by setting
<code>image_guidance_scale &gt; 1</code>. Higher image guidance scale encourages generated images that are closely
linked to the source <code>image</code>, usually at the expense of lower image quality. This pipeline requires a
value of at least <code>1</code>.`,name:"image_guidance_scale"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_instruct_pix2pix.py#L159",returnDescription:`
<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`
<p><a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),A=new Wt({props:{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.example",$$slots:{default:[zo]},$$scope:{ctx:C}}}),pe=new $({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"token",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"text_encoder",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/loaders/textual_inversion.py#L265"}}),H=new Wt({props:{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.example",$$slots:{default:[Eo]},$$scope:{ctx:C}}}),R=new Wt({props:{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.example-2",$$slots:{default:[Go]},$$scope:{ctx:C}}}),fe=new $({props:{name:"load_lora_weights",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": Union"},{name:"adapter_name",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
See <a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/loaders/lora.py#L82"}}),ue=new $({props:{name:"save_lora_weights",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights",parameters:[{name:"save_directory",val:": Union"},{name:"unet_lora_layers",val:": Dict = None"},{name:"text_encoder_lora_layers",val:": Dict = None"},{name:"transformer_lora_layers",val:": Dict = None"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": Callable = None"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save LoRA parameters to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.unet_lora_layers",description:`<strong>unet_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>unet</code>.`,name:"unet_lora_layers"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.text_encoder_lora_layers",description:`<strong>text_encoder_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_lora_layers"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/loaders/lora.py#L869"}}),me=new $({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_instruct_pix2pix.py#L832"}}),ge=new $({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_instruct_pix2pix.py#L809"}}),he=new En({}),_e=new $({props:{name:"class diffusers.StableDiffusionXLInstructPix2PixPipeline",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder. Stable Diffusion XL uses the text portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code> CLIPTextModelWithProjection</code>) &#x2014;
Second frozen text-encoder. Stable Diffusion XL uses the text and pool portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.unet",description:'<strong>unet</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014; Conditional U-Net architecture to denoise the encoded image latents.',name:"unet"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.25.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.25.0/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.25.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.requires_aesthetics_score",description:`<strong>requires_aesthetics_score</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;False&quot;</code>) &#x2014;
Whether the <code>unet</code> requires a aesthetic_score condition to be passed during inference. Also see the config
of <code>stabilityai/stable-diffusion-xl-refiner-1-0</code>.`,name:"requires_aesthetics_score"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.force_zeros_for_empty_prompt",description:`<strong>force_zeros_for_empty_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;True&quot;</code>) &#x2014;
Whether the negative prompt embeddings shall be forced to always be set to 0. Also see the config of
<code>stabilityai/stable-diffusion-xl-base-1-0</code>.`,name:"force_zeros_for_empty_prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.add_watermarker",description:`<strong>add_watermarker</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use the <a href="https://github.com/ShieldMnt/invisible-watermark/" rel="nofollow">invisible_watermark library</a> to
watermark output images. If not defined, it will default to True if the package is installed, otherwise no
watermarker will be used.`,name:"add_watermarker"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L120"}}),xe=new $({props:{name:"__call__",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"prompt_2",val:": Union = None"},{name:"image",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 100"},{name:"denoising_end",val:": Optional = None"},{name:"guidance_scale",val:": float = 5.0"},{name:"image_guidance_scale",val:": float = 1.5"},{name:"negative_prompt",val:": Union = None"},{name:"negative_prompt_2",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": Tuple = None"},{name:"crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"target_size",val:": Tuple = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code> or <code>PIL.Image.Image</code> or <code>np.ndarray</code> or <code>List[torch.FloatTensor]</code> or <code>List[PIL.Image.Image]</code> or <code>List[np.ndarray]</code>) &#x2014;
The image(s) to modify with the pipeline.`,name:"image"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise as determined by the discrete timesteps selected by the
scheduler. The denoising_end parameter should ideally be utilized when this pipeline forms a part of a
&#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>`,name:"denoising_end"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.image_guidance_scale",description:`<strong>image_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.5) &#x2014;
Image guidance scale is to push the generated image towards the inital image <code>image</code>. Image guidance
scale is enabled by setting <code>image_guidance_scale &gt; 1</code>. Higher image guidance scale encourages to
generate images that are closely linked to the source image <code>image</code>, usually at the expense of lower
image quality. This pipeline requires a value of at least <code>1</code>.`,name:"image_guidance_scale"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders.`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.aesthetic_score",description:`<strong>aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 6.0) &#x2014;
Used to simulate an aesthetic score of the generated image by influencing the positive text condition.
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"aesthetic_score"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.negative_aesthetic_score",description:`<strong>negative_aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 2.5) &#x2014;
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. Can be used to
simulate an aesthetic score of the generated image by influencing the negative text condition.`,name:"negative_aesthetic_score"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L652",returnDescription:`
<p><code>StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`
<p><code>StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),Q=new Wt({props:{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.example",$$slots:{default:[Bo]},$$scope:{ctx:C}}}),be=new $({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L648"}}),ve=new $({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L217"}}),Pe=new $({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L233"}}),we=new $({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L625"}}),ye=new $({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L208"}}),Ie=new $({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L224"}}),Me=new $({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt",parameters:[{name:"prompt",val:": str"},{name:"prompt_2",val:": Optional = None"},{name:"device",val:": Optional = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": Optional = None"},{name:"negative_prompt_2",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L240"}}),{c(){l=n("meta"),T=i(),p=n("h1"),c=n("a"),I=n("span"),g(a.$$.fragment),D=i(),De=n("span"),De.textContent=Gn,Pt=i(),ie=n("p"),ie.innerHTML=Bn,wt=i(),se=n("p"),se.textContent=Fn,yt=i(),ae=n("p"),ae.innerHTML=An,It=i(),re=n("p"),re.innerHTML=Hn,Mt=i(),g(B.$$.fragment),St=i(),E=n("h2"),F=n("a"),gt=n("span"),g(le.$$.fragment),zt=i(),ke=n("span"),ke.textContent=Rn,Tt=i(),w=n("div"),g(de.$$.fragment),Et=i(),Le=n("p"),Le.textContent=qn,Gt=i(),$e=n("p"),$e.innerHTML=Vn,Bt=i(),Ce=n("p"),Ce.textContent=Yn,Ft=i(),Ue=n("ul"),Ue.innerHTML=Qn,At=i(),N=n("div"),g(ce.$$.fragment),Ht=i(),je=n("p"),je.textContent=On,Rt=i(),g(A.$$.fragment),qt=i(),k=n("div"),g(pe.$$.fragment),Vt=i(),Je=n("p"),Je.innerHTML=Kn,Yt=i(),Xe=n("p"),Xe.textContent=eo,Qt=i(),g(H.$$.fragment),Ot=i(),Ne=n("p"),Ne.innerHTML=to,Kt=i(),g(R.$$.fragment),en=i(),L=n("div"),g(fe.$$.fragment),tn=i(),We=n("p"),We.innerHTML=no,nn=i(),Ze=n("p"),Ze.innerHTML=oo,on=i(),ze=n("p"),ze.innerHTML=io,sn=i(),Ee=n("p"),Ee.innerHTML=so,an=i(),Ge=n("p"),Ge.innerHTML=ao,rn=i(),q=n("div"),g(ue.$$.fragment),ln=i(),Be=n("p"),Be.textContent=ro,dn=i(),V=n("div"),g(me.$$.fragment),cn=i(),Fe=n("p"),Fe.textContent=lo,pn=i(),U=n("div"),g(ge.$$.fragment),fn=i(),Ae=n("p"),Ae.innerHTML=co,un=i(),He=n("p"),He.textContent=po,mn=i(),Re=n("p"),Re.innerHTML=fo,Dt=i(),G=n("h2"),Y=n("a"),ht=n("span"),g(he.$$.fragment),gn=i(),qe=n("span"),qe.textContent=uo,kt=i(),u=n("div"),g(_e.$$.fragment),hn=i(),Ve=n("p"),Ve.textContent=mo,_n=i(),Ye=n("p"),Ye.innerHTML=go,xn=i(),Qe=n("p"),Qe.textContent=ho,bn=i(),Oe=n("ul"),Oe.innerHTML=_o,vn=i(),W=n("div"),g(xe.$$.fragment),Pn=i(),Ke=n("p"),Ke.textContent=xo,wn=i(),g(Q.$$.fragment),yn=i(),O=n("div"),g(be.$$.fragment),In=i(),et=n("p"),et.textContent=bo,Mn=i(),K=n("div"),g(ve.$$.fragment),Sn=i(),tt=n("p"),tt.innerHTML=vo,Tn=i(),ee=n("div"),g(Pe.$$.fragment),Dn=i(),nt=n("p"),nt.innerHTML=Po,kn=i(),j=n("div"),g(we.$$.fragment),Ln=i(),ot=n("p"),ot.innerHTML=wo,$n=i(),it=n("p"),it.textContent=yo,Cn=i(),st=n("p"),st.innerHTML=Io,Un=i(),Z=n("div"),g(ye.$$.fragment),jn=i(),at=n("p"),at.textContent=Mo,Jn=i(),rt=n("p"),rt.textContent=So,Xn=i(),z=n("div"),g(Ie.$$.fragment),Nn=i(),lt=n("p"),lt.textContent=To,Wn=i(),dt=n("p"),dt.textContent=Do,Zn=i(),te=n("div"),g(Me.$$.fragment),zn=i(),ct=n("p"),ct.textContent=ko,this.h()},l(t){const f=No("svelte-1phssyn",document.head);l=o(f,"META",{name:!0,content:!0}),f.forEach(r),T=s(t),p=o(t,"H1",{class:!0});var Se=M(p);c=o(Se,"A",{id:!0,class:!0,href:!0});var _t=M(c);I=o(_t,"SPAN",{});var xt=M(I);h(a.$$.fragment,xt),xt.forEach(r),_t.forEach(r),D=s(Se),De=o(Se,"SPAN",{"data-svelte-h":!0}),d(De)!=="svelte-2bv5cv"&&(De.textContent=Gn),Se.forEach(r),Pt=s(t),ie=o(t,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-1tl4gnd"&&(ie.innerHTML=Bn),wt=s(t),se=o(t,"P",{"data-svelte-h":!0}),d(se)!=="svelte-1cwsb16"&&(se.textContent=Fn),yt=s(t),ae=o(t,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1gbgk0u"&&(ae.innerHTML=An),It=s(t),re=o(t,"P",{"data-svelte-h":!0}),d(re)!=="svelte-18wh1q7"&&(re.innerHTML=Hn),Mt=s(t),h(B.$$.fragment,t),St=s(t),E=o(t,"H2",{class:!0});var Te=M(E);F=o(Te,"A",{id:!0,class:!0,href:!0});var bt=M(F);gt=o(bt,"SPAN",{});var Lo=M(gt);h(le.$$.fragment,Lo),Lo.forEach(r),bt.forEach(r),zt=s(Te),ke=o(Te,"SPAN",{"data-svelte-h":!0}),d(ke)!=="svelte-1q2pjeh"&&(ke.textContent=Rn),Te.forEach(r),Tt=s(t),w=o(t,"DIV",{class:!0});var S=M(w);h(de.$$.fragment,S),Et=s(S),Le=o(S,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-1gz00nq"&&(Le.textContent=qn),Gt=s(S),$e=o(S,"P",{"data-svelte-h":!0}),d($e)!=="svelte-s6xyvg"&&($e.innerHTML=Vn),Bt=s(S),Ce=o(S,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-14s6m4u"&&(Ce.textContent=Yn),Ft=s(S),Ue=o(S,"UL",{"data-svelte-h":!0}),d(Ue)!=="svelte-1f0ng5k"&&(Ue.innerHTML=Qn),At=s(S),N=o(S,"DIV",{class:!0});var pt=M(N);h(ce.$$.fragment,pt),Ht=s(pt),je=o(pt,"P",{"data-svelte-h":!0}),d(je)!=="svelte-50j04k"&&(je.textContent=On),Rt=s(pt),h(A.$$.fragment,pt),pt.forEach(r),qt=s(S),k=o(S,"DIV",{class:!0});var J=M(k);h(pe.$$.fragment,J),Vt=s(J),Je=o(J,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-1a425ok"&&(Je.innerHTML=Kn),Yt=s(J),Xe=o(J,"P",{"data-svelte-h":!0}),d(Xe)!=="svelte-11lpom8"&&(Xe.textContent=eo),Qt=s(J),h(H.$$.fragment,J),Ot=s(J),Ne=o(J,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-15d7mv5"&&(Ne.innerHTML=to),Kt=s(J),h(R.$$.fragment,J),J.forEach(r),en=s(S),L=o(S,"DIV",{class:!0});var X=M(L);h(fe.$$.fragment,X),tn=s(X),We=o(X,"P",{"data-svelte-h":!0}),d(We)!=="svelte-vs7s0z"&&(We.innerHTML=no),nn=s(X),Ze=o(X,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-15b960v"&&(Ze.innerHTML=oo),on=s(X),ze=o(X,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-1sfxfk0"&&(ze.innerHTML=io),sn=s(X),Ee=o(X,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-flvvrp"&&(Ee.innerHTML=so),an=s(X),Ge=o(X,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-n2pvuj"&&(Ge.innerHTML=ao),X.forEach(r),rn=s(S),q=o(S,"DIV",{class:!0});var $t=M(q);h(ue.$$.fragment,$t),ln=s($t),Be=o($t,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-1ufq5ot"&&(Be.textContent=ro),$t.forEach(r),dn=s(S),V=o(S,"DIV",{class:!0});var Ct=M(V);h(me.$$.fragment,Ct),cn=s(Ct),Fe=o(Ct,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-psupw6"&&(Fe.textContent=lo),Ct.forEach(r),pn=s(S),U=o(S,"DIV",{class:!0});var ne=M(U);h(ge.$$.fragment,ne),fn=s(ne),Ae=o(ne,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-1f3tmq1"&&(Ae.innerHTML=co),un=s(ne),He=o(ne,"P",{"data-svelte-h":!0}),d(He)!=="svelte-xjijlp"&&(He.textContent=po),mn=s(ne),Re=o(ne,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-hy0nzs"&&(Re.innerHTML=fo),ne.forEach(r),S.forEach(r),Dt=s(t),G=o(t,"H2",{class:!0});var Ut=M(G);Y=o(Ut,"A",{id:!0,class:!0,href:!0});var $o=M(Y);ht=o($o,"SPAN",{});var Co=M(ht);h(he.$$.fragment,Co),Co.forEach(r),$o.forEach(r),gn=s(Ut),qe=o(Ut,"SPAN",{"data-svelte-h":!0}),d(qe)!=="svelte-rhfbgd"&&(qe.textContent=uo),Ut.forEach(r),kt=s(t),u=o(t,"DIV",{class:!0});var y=M(u);h(_e.$$.fragment,y),hn=s(y),Ve=o(y,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-1n3req3"&&(Ve.textContent=mo),_n=s(y),Ye=o(y,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-1bjwwin"&&(Ye.innerHTML=go),xn=s(y),Qe=o(y,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-14s6m4u"&&(Qe.textContent=ho),bn=s(y),Oe=o(y,"UL",{"data-svelte-h":!0}),d(Oe)!=="svelte-1jvp8xa"&&(Oe.innerHTML=_o),vn=s(y),W=o(y,"DIV",{class:!0});var ft=M(W);h(xe.$$.fragment,ft),Pn=s(ft),Ke=o(ft,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-v78lg8"&&(Ke.textContent=xo),wn=s(ft),h(Q.$$.fragment,ft),ft.forEach(r),yn=s(y),O=o(y,"DIV",{class:!0});var jt=M(O);h(be.$$.fragment,jt),In=s(jt),et=o(jt,"P",{"data-svelte-h":!0}),d(et)!=="svelte-psupw6"&&(et.textContent=bo),jt.forEach(r),Mn=s(y),K=o(y,"DIV",{class:!0});var Jt=M(K);h(ve.$$.fragment,Jt),Sn=s(Jt),tt=o(Jt,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-1lk12qh"&&(tt.innerHTML=vo),Jt.forEach(r),Tn=s(y),ee=o(y,"DIV",{class:!0});var Xt=M(ee);h(Pe.$$.fragment,Xt),Dn=s(Xt),nt=o(Xt,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-elsxjh"&&(nt.innerHTML=Po),Xt.forEach(r),kn=s(y),j=o(y,"DIV",{class:!0});var oe=M(j);h(we.$$.fragment,oe),Ln=s(oe),ot=o(oe,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-1f3tmq1"&&(ot.innerHTML=wo),$n=s(oe),it=o(oe,"P",{"data-svelte-h":!0}),d(it)!=="svelte-xjijlp"&&(it.textContent=yo),Cn=s(oe),st=o(oe,"P",{"data-svelte-h":!0}),d(st)!=="svelte-hy0nzs"&&(st.innerHTML=Io),oe.forEach(r),Un=s(y),Z=o(y,"DIV",{class:!0});var ut=M(Z);h(ye.$$.fragment,ut),jn=s(ut),at=o(ut,"P",{"data-svelte-h":!0}),d(at)!=="svelte-ssd5ny"&&(at.textContent=Mo),Jn=s(ut),rt=o(ut,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-62zig4"&&(rt.textContent=So),ut.forEach(r),Xn=s(y),z=o(y,"DIV",{class:!0});var mt=M(z);h(Ie.$$.fragment,mt),Nn=s(mt),lt=o(mt,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-4j2l7q"&&(lt.textContent=To),Wn=s(mt),dt=o(mt,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-1biw85q"&&(dt.textContent=Do),mt.forEach(r),Zn=s(y),te=o(y,"DIV",{class:!0});var Nt=M(te);h(Me.$$.fragment,Nt),zn=s(Nt),ct=o(Nt,"P",{"data-svelte-h":!0}),d(ct)!=="svelte-16q0ax1"&&(ct.textContent=ko),Nt.forEach(r),y.forEach(r),this.h()},h(){m(l,"name","hf:doc:metadata"),m(l,"content",JSON.stringify(Ao)),m(c,"id","instructpix2pix"),m(c,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(c,"href","#instructpix2pix"),m(p,"class","relative group"),m(F,"id","diffusers.StableDiffusionInstructPix2PixPipeline"),m(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(F,"href","#diffusers.StableDiffusionInstructPix2PixPipeline"),m(E,"class","relative group"),m(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(Y,"id","diffusers.StableDiffusionXLInstructPix2PixPipeline"),m(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Y,"href","#diffusers.StableDiffusionXLInstructPix2PixPipeline"),m(G,"class","relative group"),m(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(u,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,f){e(document.head,l),P(t,T,f),P(t,p,f),e(p,c),e(c,I),_(a,I,null),e(p,D),e(p,De),P(t,Pt,f),P(t,ie,f),P(t,wt,f),P(t,se,f),P(t,yt,f),P(t,ae,f),P(t,It,f),P(t,re,f),P(t,Mt,f),_(B,t,f),P(t,St,f),P(t,E,f),e(E,F),e(F,gt),_(le,gt,null),e(E,zt),e(E,ke),P(t,Tt,f),P(t,w,f),_(de,w,null),e(w,Et),e(w,Le),e(w,Gt),e(w,$e),e(w,Bt),e(w,Ce),e(w,Ft),e(w,Ue),e(w,At),e(w,N),_(ce,N,null),e(N,Ht),e(N,je),e(N,Rt),_(A,N,null),e(w,qt),e(w,k),_(pe,k,null),e(k,Vt),e(k,Je),e(k,Yt),e(k,Xe),e(k,Qt),_(H,k,null),e(k,Ot),e(k,Ne),e(k,Kt),_(R,k,null),e(w,en),e(w,L),_(fe,L,null),e(L,tn),e(L,We),e(L,nn),e(L,Ze),e(L,on),e(L,ze),e(L,sn),e(L,Ee),e(L,an),e(L,Ge),e(w,rn),e(w,q),_(ue,q,null),e(q,ln),e(q,Be),e(w,dn),e(w,V),_(me,V,null),e(V,cn),e(V,Fe),e(w,pn),e(w,U),_(ge,U,null),e(U,fn),e(U,Ae),e(U,un),e(U,He),e(U,mn),e(U,Re),P(t,Dt,f),P(t,G,f),e(G,Y),e(Y,ht),_(he,ht,null),e(G,gn),e(G,qe),P(t,kt,f),P(t,u,f),_(_e,u,null),e(u,hn),e(u,Ve),e(u,_n),e(u,Ye),e(u,xn),e(u,Qe),e(u,bn),e(u,Oe),e(u,vn),e(u,W),_(xe,W,null),e(W,Pn),e(W,Ke),e(W,wn),_(Q,W,null),e(u,yn),e(u,O),_(be,O,null),e(O,In),e(O,et),e(u,Mn),e(u,K),_(ve,K,null),e(K,Sn),e(K,tt),e(u,Tn),e(u,ee),_(Pe,ee,null),e(ee,Dn),e(ee,nt),e(u,kn),e(u,j),_(we,j,null),e(j,Ln),e(j,ot),e(j,$n),e(j,it),e(j,Cn),e(j,st),e(u,Un),e(u,Z),_(ye,Z,null),e(Z,jn),e(Z,at),e(Z,Jn),e(Z,rt),e(u,Xn),e(u,z),_(Ie,z,null),e(z,Nn),e(z,lt),e(z,Wn),e(z,dt),e(u,Zn),e(u,te),_(Me,te,null),e(te,zn),e(te,ct),Lt=!0},p(t,[f]){const Se={};f&2&&(Se.$$scope={dirty:f,ctx:t}),B.$set(Se);const _t={};f&2&&(_t.$$scope={dirty:f,ctx:t}),A.$set(_t);const xt={};f&2&&(xt.$$scope={dirty:f,ctx:t}),H.$set(xt);const Te={};f&2&&(Te.$$scope={dirty:f,ctx:t}),R.$set(Te);const bt={};f&2&&(bt.$$scope={dirty:f,ctx:t}),Q.$set(bt)},i(t){Lt||(x(a.$$.fragment,t),x(B.$$.fragment,t),x(le.$$.fragment,t),x(de.$$.fragment,t),x(ce.$$.fragment,t),x(A.$$.fragment,t),x(pe.$$.fragment,t),x(H.$$.fragment,t),x(R.$$.fragment,t),x(fe.$$.fragment,t),x(ue.$$.fragment,t),x(me.$$.fragment,t),x(ge.$$.fragment,t),x(he.$$.fragment,t),x(_e.$$.fragment,t),x(xe.$$.fragment,t),x(Q.$$.fragment,t),x(be.$$.fragment,t),x(ve.$$.fragment,t),x(Pe.$$.fragment,t),x(we.$$.fragment,t),x(ye.$$.fragment,t),x(Ie.$$.fragment,t),x(Me.$$.fragment,t),Lt=!0)},o(t){b(a.$$.fragment,t),b(B.$$.fragment,t),b(le.$$.fragment,t),b(de.$$.fragment,t),b(ce.$$.fragment,t),b(A.$$.fragment,t),b(pe.$$.fragment,t),b(H.$$.fragment,t),b(R.$$.fragment,t),b(fe.$$.fragment,t),b(ue.$$.fragment,t),b(me.$$.fragment,t),b(ge.$$.fragment,t),b(he.$$.fragment,t),b(_e.$$.fragment,t),b(xe.$$.fragment,t),b(Q.$$.fragment,t),b(be.$$.fragment,t),b(ve.$$.fragment,t),b(Pe.$$.fragment,t),b(we.$$.fragment,t),b(ye.$$.fragment,t),b(Ie.$$.fragment,t),b(Me.$$.fragment,t),Lt=!1},d(t){t&&(r(T),r(p),r(Pt),r(ie),r(wt),r(se),r(yt),r(ae),r(It),r(re),r(Mt),r(St),r(E),r(Tt),r(w),r(Dt),r(G),r(kt),r(u)),r(l),v(a),v(B,t),v(le),v(de),v(ce),v(A),v(pe),v(H),v(R),v(fe),v(ue),v(me),v(ge),v(he),v(_e),v(xe),v(Q),v(be),v(ve),v(Pe),v(we),v(ye),v(Ie),v(Me)}}}const Ao={local:"instructpix2pix",sections:[{local:"diffusers.StableDiffusionInstructPix2PixPipeline",title:"StableDiffusionInstructPix2PixPipeline"},{local:"diffusers.StableDiffusionXLInstructPix2PixPipeline",title:"StableDiffusionXLInstructPix2PixPipeline"}],title:"InstructPix2Pix"};function Ho(C){return jo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ei extends Jo{constructor(l){super(),Xo(this,l,Ho,Fo,Uo,{})}}export{ei as component};
