import{s as si,o as ii,n as W}from"../chunks/scheduler.182ea377.js";import{S as ai,i as ri,g as s,s as a,p as h,A as li,h as i,f as l,c as r,j as M,q as g,m as f,k as w,v as t,a as y,r as _,d as b,t as v,u as x}from"../chunks/index.008d68e4.js";import{T as mn}from"../chunks/Tip.4f096367.js";import{D}from"../chunks/Docstring.7aec8b85.js";import{C as ft}from"../chunks/CodeBlock.5ed6eb7b.js";import{I as hn}from"../chunks/IconCopyLink.96bbb92b.js";import{E as ct}from"../chunks/ExampleCodeBlock.23e54afe.js";function di(S){let o,T='Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!',c,d,$='If you’re interested in using one of the official checkpoints for a task, explore the <a href="https://huggingface.co/CompVis" rel="nofollow">CompVis</a>, <a href="https://huggingface.co/runwayml" rel="nofollow">Runway</a>, and <a href="https://huggingface.co/stabilityai" rel="nofollow">Stability AI</a> Hub organizations!';return{c(){o=s("p"),o.innerHTML=T,c=a(),d=s("p"),d.innerHTML=$},l(n){o=i(n,"P",{"data-svelte-h":!0}),f(o)!=="svelte-1j961ct"&&(o.innerHTML=T),c=r(n),d=i(n,"P",{"data-svelte-h":!0}),f(d)!=="svelte-z4pn9c"&&(d.innerHTML=$)},m(n,P){y(n,o,P),y(n,c,P),y(n,d,P)},p:W,d(n){n&&(l(o),l(c),l(d))}}}function ci(S){let o,T="Examples:",c,d,$;return d=new ft({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`}}),{c(){o=s("p"),o.textContent=T,c=a(),h(d.$$.fragment)},l(n){o=i(n,"P",{"data-svelte-h":!0}),f(o)!=="svelte-kvfsh7"&&(o.textContent=T),c=r(n),g(d.$$.fragment,n)},m(n,P){y(n,o,P),y(n,c,P),_(d,n,P),$=!0},p:W,i(n){$||(b(d.$$.fragment,n),$=!0)},o(n){v(d.$$.fragment,n),$=!1},d(n){n&&(l(o),l(c)),x(d,n)}}}function fi(S){let o,T=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){o=s("p"),o.innerHTML=T},l(c){o=i(c,"P",{"data-svelte-h":!0}),f(o)!=="svelte-ackzsn"&&(o.innerHTML=T)},m(c,d){y(c,o,d)},p:W,d(c){c&&l(o)}}}function pi(S){let o,T="Examples:",c,d,$;return d=new ft({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`}}),{c(){o=s("p"),o.textContent=T,c=a(),h(d.$$.fragment)},l(n){o=i(n,"P",{"data-svelte-h":!0}),f(o)!=="svelte-kvfsh7"&&(o.textContent=T),c=r(n),g(d.$$.fragment,n)},m(n,P){y(n,o,P),y(n,c,P),_(d,n,P),$=!0},p:W,i(n){$||(b(d.$$.fragment,n),$=!0)},o(n){v(d.$$.fragment,n),$=!1},d(n){n&&(l(o),l(c)),x(d,n)}}}function ui(S){let o,T=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){o=s("p"),o.textContent=T},l(c){o=i(c,"P",{"data-svelte-h":!0}),f(o)!=="svelte-17p1lpg"&&(o.textContent=T)},m(c,d){y(c,o,d)},p:W,d(c){c&&l(o)}}}function mi(S){let o,T="Examples:",c,d,$;return d=new ft({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`}}),{c(){o=s("p"),o.textContent=T,c=a(),h(d.$$.fragment)},l(n){o=i(n,"P",{"data-svelte-h":!0}),f(o)!=="svelte-kvfsh7"&&(o.textContent=T),c=r(n),g(d.$$.fragment,n)},m(n,P){y(n,o,P),y(n,c,P),_(d,n,P),$=!0},p:W,i(n){$||(b(d.$$.fragment,n),$=!0)},o(n){v(d.$$.fragment,n),$=!1},d(n){n&&(l(o),l(c)),x(d,n)}}}function hi(S){let o,T="To load a Textual Inversion embedding vector in 🤗 Diffusers format:",c,d,$;return d=new ft({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`}}),{c(){o=s("p"),o.textContent=T,c=a(),h(d.$$.fragment)},l(n){o=i(n,"P",{"data-svelte-h":!0}),f(o)!=="svelte-1gc783q"&&(o.textContent=T),c=r(n),g(d.$$.fragment,n)},m(n,P){y(n,o,P),y(n,c,P),_(d,n,P),$=!0},p:W,i(n){$||(b(d.$$.fragment,n),$=!0)},o(n){v(d.$$.fragment,n),$=!1},d(n){n&&(l(o),l(c)),x(d,n)}}}function gi(S){let o,T="locally:",c,d,$;return d=new ft({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`}}),{c(){o=s("p"),o.textContent=T,c=a(),h(d.$$.fragment)},l(n){o=i(n,"P",{"data-svelte-h":!0}),f(o)!=="svelte-4c75kq"&&(o.textContent=T),c=r(n),g(d.$$.fragment,n)},m(n,P){y(n,o,P),y(n,c,P),_(d,n,P),$=!0},p:W,i(n){$||(b(d.$$.fragment,n),$=!0)},o(n){v(d.$$.fragment,n),$=!1},d(n){n&&(l(o),l(c)),x(d,n)}}}function _i(S){let o,T="Examples:",c,d,$;return d=new ft({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGV2Fycmlvck1hbWE3NzclMkZPcmFuZ2VNaXhzJTJGYmxvYiUyRm1haW4lMkZNb2RlbHMlMkZBYnlzc09yYW5nZU1peCUyRkFieXNzT3JhbmdlTWl4LnNhZmV0ZW5zb3JzJTIyJTBBKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMjBmcm9tJTIwbG9jYWwlMjBmaWxlJTBBJTIzJTIwZmlsZSUyMGlzJTIwZG93bmxvYWRlZCUyMHVuZGVyJTIwLiUyRnYxLTUtcHJ1bmVkLWVtYW9ubHkuY2twdCUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMjIuJTJGdjEtNS1wcnVuZWQtZW1hb25seSUyMiklMEElMEElMjMlMjBFbmFibGUlMjBmbG9hdDE2JTIwYW5kJTIwbW92ZSUyMHRvJTIwR1BVJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRmJsb2IlMkZtYWluJTJGdjEtNS1wcnVuZWQtZW1hb25seS5ja3B0JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQXBpcGVsaW5lLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/WarriorMama777/OrangeMixs/blob/main/Models/AbyssOrangeMix/AbyssOrangeMix.safetensors&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from local file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># file is downloaded under ./v1-5-pruned-emaonly.ckpt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(<span class="hljs-string">&quot;./v1-5-pruned-emaonly&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Enable float16 and move to GPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/v1-5-pruned-emaonly.ckpt&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`}}),{c(){o=s("p"),o.textContent=T,c=a(),h(d.$$.fragment)},l(n){o=i(n,"P",{"data-svelte-h":!0}),f(o)!=="svelte-kvfsh7"&&(o.textContent=T),c=r(n),g(d.$$.fragment,n)},m(n,P){y(n,o,P),y(n,c,P),_(d,n,P),$=!0},p:W,i(n){$||(b(d.$$.fragment,n),$=!0)},o(n){v(d.$$.fragment,n),$=!1},d(n){n&&(l(o),l(c)),x(d,n)}}}function bi(S){let o,T="This API is 🧪 experimental.";return{c(){o=s("p"),o.textContent=T},l(c){o=i(c,"P",{"data-svelte-h":!0}),f(o)!=="svelte-89q1io"&&(o.textContent=T)},m(c,d){y(c,o,d)},p:W,d(c){c&&l(o)}}}function vi(S){let o,T="This API is 🧪 experimental.";return{c(){o=s("p"),o.textContent=T},l(c){o=i(c,"P",{"data-svelte-h":!0}),f(o)!=="svelte-89q1io"&&(o.textContent=T)},m(c,d){y(c,o,d)},p:W,d(c){c&&l(o)}}}function xi(S){let o,T="Examples:",c,d,$;return d=new ft({props:{code:"aW1wb3J0JTIwamF4JTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGZsYXguamF4X3V0aWxzJTIwaW1wb3J0JTIwcmVwbGljYXRlJTBBZnJvbSUyMGZsYXgudHJhaW5pbmcuY29tbW9uX3V0aWxzJTIwaW1wb3J0JTIwc2hhcmQlMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmxheFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMkMlMjBwYXJhbXMlMjAlM0QlMjBGbGF4U3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwcmV2aXNpb24lM0QlMjJiZjE2JTIyJTJDJTIwZHR5cGUlM0RqYXgubnVtcHkuYmZsb2F0MTYlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQSUwQXBybmdfc2VlZCUyMCUzRCUyMGpheC5yYW5kb20uUFJOR0tleSgwKSUwQW51bV9pbmZlcmVuY2Vfc3RlcHMlMjAlM0QlMjA1MCUwQSUwQW51bV9zYW1wbGVzJTIwJTNEJTIwamF4LmRldmljZV9jb3VudCgpJTBBcHJvbXB0JTIwJTNEJTIwbnVtX3NhbXBsZXMlMjAqJTIwJTVCcHJvbXB0JTVEJTBBcHJvbXB0X2lkcyUyMCUzRCUyMHBpcGVsaW5lLnByZXBhcmVfaW5wdXRzKHByb21wdCklMEElMEFwYXJhbXMlMjAlM0QlMjByZXBsaWNhdGUocGFyYW1zKSUwQXBybmdfc2VlZCUyMCUzRCUyMGpheC5yYW5kb20uc3BsaXQocHJuZ19zZWVkJTJDJTIwamF4LmRldmljZV9jb3VudCgpKSUwQXByb21wdF9pZHMlMjAlM0QlMjBzaGFyZChwcm9tcHRfaWRzKSUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKHByb21wdF9pZHMlMkMlMjBwYXJhbXMlMkMlMjBwcm5nX3NlZWQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTJDJTIwaml0JTNEVHJ1ZSkuaW1hZ2VzJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUubnVtcHlfdG9fcGlsKG5wLmFzYXJyYXkoaW1hZ2VzLnJlc2hhcGUoKG51bV9zYW1wbGVzJTJDKSUyMCUyQiUyMGltYWdlcy5zaGFwZSU1Qi0zJTNBJTVEKSkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.jax_utils <span class="hljs-keyword">import</span> replicate
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.training.common_utils <span class="hljs-keyword">import</span> shard

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxStableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline, params = FlaxStableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, revision=<span class="hljs-string">&quot;bf16&quot;</span>, dtype=jax.numpy.bfloat16
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>prng_seed = jax.random.PRNGKey(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>num_inference_steps = <span class="hljs-number">50</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>num_samples = jax.device_count()
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = num_samples * [prompt]
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids = pipeline.prepare_inputs(prompt)
<span class="hljs-comment"># shard inputs and rng</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>params = replicate(params)
<span class="hljs-meta">&gt;&gt;&gt; </span>prng_seed = jax.random.split(prng_seed, jax.device_count())
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids = shard(prompt_ids)

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipeline(prompt_ids, params, prng_seed, num_inference_steps, jit=<span class="hljs-literal">True</span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipeline.numpy_to_pil(np.asarray(images.reshape((num_samples,) + images.shape[-<span class="hljs-number">3</span>:])))`}}),{c(){o=s("p"),o.textContent=T,c=a(),h(d.$$.fragment)},l(n){o=i(n,"P",{"data-svelte-h":!0}),f(o)!=="svelte-kvfsh7"&&(o.textContent=T),c=r(n),g(d.$$.fragment,n)},m(n,P){y(n,o,P),y(n,c,P),_(d,n,P),$=!0},p:W,i(n){$||(b(d.$$.fragment,n),$=!0)},o(n){v(d.$$.fragment,n),$=!1},d(n){n&&(l(o),l(c)),x(d,n)}}}function wi(S){let o,T,c,d,$,n,P,pt,rs="Text-to-image",gn,Se,ls='The Stable Diffusion model was created by researchers and engineers from <a href="https://github.com/CompVis" rel="nofollow">CompVis</a>, <a href="https://stability.ai/" rel="nofollow">Stability AI</a>, <a href="https://github.com/runwayml" rel="nofollow">Runway</a>, and <a href="https://laion.ai/" rel="nofollow">LAION</a>. The <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> is capable of generating photorealistic images given any text input. It’s trained on 512x512 images from a subset of the LAION-5B dataset. This model uses a frozen CLIP ViT-L/14 text encoder to condition the model on text prompts. With its 860M UNet and 123M text encoder, the model is relatively lightweight and can run on consumer GPUs. Latent diffusion is the research on top of which Stable Diffusion was built. It was proposed in <a href="https://huggingface.co/papers/2112.10752" rel="nofollow">High-Resolution Image Synthesis with Latent Diffusion Models</a> by Robin Rombach, Andreas Blattmann, Dominik Lorenz, Patrick Esser, Björn Ommer.',_n,De,ds="The abstract from the paper is:",bn,ke,cs='<em>By decomposing the image formation process into a sequential application of denoising autoencoders, diffusion models (DMs) achieve state-of-the-art synthesis results on image data and beyond. Additionally, their formulation allows for a guiding mechanism to control the image generation process without retraining. However, since these models typically operate directly in pixel space, optimization of powerful DMs often consumes hundreds of GPU days and inference is expensive due to sequential evaluations. To enable DM training on limited computational resources while retaining their quality and flexibility, we apply them in the latent space of powerful pretrained autoencoders. In contrast to previous work, training diffusion models on such a representation allows for the first time to reach a near-optimal point between complexity reduction and detail preservation, greatly boosting visual fidelity. By introducing cross-attention layers into the model architecture, we turn diffusion models into powerful and flexible generators for general conditioning inputs such as text or bounding boxes and high-resolution synthesis becomes possible in a convolutional manner. Our latent diffusion models (LDMs) achieve a new state of the art for image inpainting and highly competitive performance on various tasks, including unconditional image generation, semantic scene synthesis, and super-resolution, while significantly reducing computational requirements compared to pixel-based DMs. Code is available at <a href="https://github.com/CompVis/latent-diffusion" rel="nofollow">https://github.com/CompVis/latent-diffusion</a>.</em>',vn,Q,xn,R,O,an,Je,En,ut,fs="StableDiffusionPipeline",wn,u,Ce,Vn,mt,ps="Pipeline for text-to-image generation using Stable Diffusion.",Bn,ht,us=`This model inherits from <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,zn,gt,ms="The pipeline also inherits the following loading methods:",Rn,_t,hs='<li><a href="/docs/diffusers/v0.25.0/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',An,N,Ie,Hn,bt,gs="The call function to the pipeline for generation.",qn,K,Yn,I,Ue,Xn,vt,_s=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Qn,ee,On,te,Kn,ne,je,eo,xt,bs=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,to,oe,Le,no,wt,vs=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,oo,se,Ze,so,yt,xs=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,io,U,We,ao,$t,ws=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,ro,ie,lo,ae,co,re,Ge,fo,Tt,ys='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',po,le,Fe,uo,Mt,$s=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,mo,de,Ne,ho,Pt,Ts=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,go,k,Ee,_o,St,Ms=`Load Textual Inversion embeddings into the text encoder of <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,bo,Dt,Ps="Example:",vo,ce,xo,kt,Ss=`To load a Textual Inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,wo,fe,yo,E,Ve,$o,Jt,Ds=`Instantiate a <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> from pretrained pipeline weights saved in the <code>.ckpt</code> or <code>.safetensors</code>
format. The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.`,To,pe,Mo,J,Be,Po,Ct,ks=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,So,It,Js="All kwargs are forwarded to <code>self.lora_state_dict</code>.",Do,Ut,Cs='See <a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is loaded.',ko,jt,Is=`See <a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is loaded into
<code>self.unet</code>.`,Jo,Lt,Us=`See <a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state dict is loaded
into <code>self.text_encoder</code>.`,Co,ue,ze,Io,Zt,js="Save the LoRA parameters corresponding to the UNet and text encoder.",Uo,me,Re,jo,Wt,Ls="Disables the FreeU mechanism if enabled.",Lo,j,Ae,Zo,Gt,Zs='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',Wo,Ft,Ws="The suffixes after the scaling factors represent the stages where they are being applied.",Go,Nt,Gs=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,Fo,he,He,No,Et,Fs="Encodes the prompt into text encoder hidden states.",Eo,V,qe,Vo,Vt,Ns=`Enables fused QKV projections. For self-attention modules, all projection matrices (i.e., query,
key, value) are fused. For cross-attention modules, key and value projection matrices are fused.`,Bo,ge,zo,_e,Ye,Ro,Bt,Es='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',Ao,B,Xe,Ho,zt,Vs="Disable QKV projection fusion if enabled.",qo,be,yn,A,ve,rn,Qe,Yo,Rt,Bs="StableDiffusionPipelineOutput",$n,H,Oe,Xo,At,zs="Output class for Stable Diffusion pipelines.",Tn,q,xe,ln,Ke,Qo,Ht,Rs="FlaxStableDiffusionPipeline",Mn,C,et,Oo,qt,As="Flax-based pipeline for text-to-image generation using Stable Diffusion.",Ko,Yt,Hs=`This model inherits from <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline">FlaxDiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,es,z,tt,ts,Xt,qs="The call function to the pipeline for generation.",ns,we,Pn,Y,ye,dn,nt,os,Qt,Ys="FlaxStableDiffusionPipelineOutput",Sn,G,ot,ss,Ot,Xs="Output class for Flax-based Stable Diffusion pipelines.",is,$e,st,as,Kt,Qs="“Returns a new object replacing the specified fields with new values.",Dn;return n=new hn({}),Q=new mn({props:{$$slots:{default:[di]},$$scope:{ctx:S}}}),Je=new hn({}),Ce=new D({props:{name:"class diffusers.StableDiffusionPipeline",anchor:"diffusers.StableDiffusionPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.25.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.25.0/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.25.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L118"}}),Ie=new D({props:{name:"__call__",anchor:"diffusers.StableDiffusionPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": List = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.StableDiffusionPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor from <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a>. Guidance rescale factor should fix overexposure when
using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.StableDiffusionPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L775",returnDescription:`
<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`
<p><a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),K=new ct({props:{anchor:"diffusers.StableDiffusionPipeline.__call__.example",$$slots:{default:[ci]},$$scope:{ctx:S}}}),Ue=new D({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/pipeline_utils.py#L2048"}}),ee=new mn({props:{warning:!0,$$slots:{default:[fi]},$$scope:{ctx:S}}}),te=new ct({props:{anchor:"diffusers.StableDiffusionPipeline.enable_attention_slicing.example",$$slots:{default:[pi]},$$scope:{ctx:S}}}),je=new D({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/pipeline_utils.py#L2088"}}),Le=new D({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L251"}}),Ze=new D({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L258"}}),We=new D({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/pipeline_utils.py#L1987"}}),ie=new mn({props:{warning:!0,$$slots:{default:[ui]},$$scope:{ctx:S}}}),ae=new ct({props:{anchor:"diffusers.StableDiffusionPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[mi]},$$scope:{ctx:S}}}),Ge=new D({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/pipeline_utils.py#L2022"}}),Fe=new D({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L265"}}),Ne=new D({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L273"}}),Ee=new D({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"token",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"text_encoder",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/loaders/textual_inversion.py#L265"}}),ce=new ct({props:{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.example",$$slots:{default:[hi]},$$scope:{ctx:S}}}),fe=new ct({props:{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.example-2",$$slots:{default:[gi]},$$scope:{ctx:S}}}),Ve=new D({props:{name:"from_single_file",anchor:"diffusers.StableDiffusionPipeline.from_single_file",parameters:[{name:"pretrained_model_link_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.from_single_file.pretrained_model_link_or_path",description:`<strong>pretrained_model_link_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:<ul>
<li>A link to the <code>.ckpt</code> file (for example
<code>&quot;https://huggingface.co/&lt;repo_id&gt;/blob/main/&lt;path_to_file&gt;.ckpt&quot;</code>) on the Hub.</li>
<li>A path to a <em>file</em> containing all pipeline weights.</li>
</ul>`,name:"pretrained_model_link_or_path"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If <code>&quot;auto&quot;</code> is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.extract_ema",description:`<strong>extract_ema</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to extract the EMA weights or not. Pass <code>True</code> to extract the EMA weights which usually yield
higher quality images for inference. Non-EMA weights are usually better for continuing finetuning.`,name:"extract_ema"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.upcast_attention",description:`<strong>upcast_attention</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether the attention computation should always be upcasted.`,name:"upcast_attention"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The image size the model was trained on. Use 512 for all Stable Diffusion v1 models and the Stable
Diffusion v2 base model. Use 768 for Stable Diffusion v2.`,name:"image_size"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.prediction_type",description:`<strong>prediction_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The prediction type the model was trained on. Use <code>&apos;epsilon&apos;</code> for all Stable Diffusion v1 models and
the Stable Diffusion v2 base model. Use <code>&apos;v_prediction&apos;</code> for Stable Diffusion v2.`,name:"prediction_type"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.num_in_channels",description:`<strong>num_in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The number of input channels. If <code>None</code>, it is automatically inferred.`,name:"num_in_channels"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.scheduler_type",description:`<strong>scheduler_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pndm&quot;</code>) &#x2014;
Type of scheduler to use. Should be one of <code>[&quot;pndm&quot;, &quot;lms&quot;, &quot;heun&quot;, &quot;euler&quot;, &quot;euler-ancestral&quot;, &quot;dpm&quot;, &quot;ddim&quot;]</code>.`,name:"scheduler_type"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.load_safety_checker",description:`<strong>load_safety_checker</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to load the safety checker or not.`,name:"load_safety_checker"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
An instance of <code>CLIPTextModel</code> to use, specifically the
<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant. If this
parameter is <code>None</code>, the function loads a new instance of <code>CLIPTextModel</code> by itself if needed.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.vae",description:`<strong>vae</strong> (<code>AutoencoderKL</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations. If
this parameter is <code>None</code>, the function will load a new instance of [CLIP] by itself, if needed.`,name:"vae"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
An instance of <code>CLIPTokenizer</code> to use. If this parameter is <code>None</code>, the function loads a new instance
of <code>CLIPTokenizer</code> by itself if needed.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.original_config_file",description:`<strong>original_config_file</strong> (<code>str</code>) &#x2014;
Path to <code>.yaml</code> config file corresponding to the original architecture. If <code>None</code>, will be
automatically inferred by looking for a key that only exists in SD2.0 models.`,name:"original_config_file"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (for example the pipeline components of the
specific pipeline class). The overwritten components are directly passed to the pipelines <code>__init__</code>
method. See example below for more information.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/loaders/single_file.py#L53"}}),pe=new ct({props:{anchor:"diffusers.StableDiffusionPipeline.from_single_file.example",$$slots:{default:[_i]},$$scope:{ctx:S}}}),Be=new D({props:{name:"load_lora_weights",anchor:"diffusers.StableDiffusionPipeline.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": Union"},{name:"adapter_name",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
See <a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.StableDiffusionPipeline.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"},{anchor:"diffusers.StableDiffusionPipeline.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/loaders/lora.py#L82"}}),ze=new D({props:{name:"save_lora_weights",anchor:"diffusers.StableDiffusionPipeline.save_lora_weights",parameters:[{name:"save_directory",val:": Union"},{name:"unet_lora_layers",val:": Dict = None"},{name:"text_encoder_lora_layers",val:": Dict = None"},{name:"transformer_lora_layers",val:": Dict = None"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": Callable = None"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save LoRA parameters to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.unet_lora_layers",description:`<strong>unet_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>unet</code>.`,name:"unet_lora_layers"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.text_encoder_lora_layers",description:`<strong>text_encoder_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_lora_layers"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/loaders/lora.py#L869"}}),Re=new D({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L650"}}),Ae=new D({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L628"}}),He=new D({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L312"}}),qe=new D({props:{name:"fuse_qkv_projections",anchor:"diffusers.StableDiffusionPipeline.fuse_qkv_projections",parameters:[{name:"unet",val:": bool = True"},{name:"vae",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.fuse_qkv_projections.unet",description:"<strong>unet</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014; To apply fusion on the UNet.",name:"unet"},{anchor:"diffusers.StableDiffusionPipeline.fuse_qkv_projections.vae",description:"<strong>vae</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014; To apply fusion on the VAE.",name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L655"}}),ge=new mn({props:{warning:!0,$$slots:{default:[bi]},$$scope:{ctx:S}}}),Ye=new D({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.StableDiffusionPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:""},{name:"embedding_dim",val:" = 512"},{name:"dtype",val:" = torch.float32"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.get_guidance_scale_embedding.timesteps",description:`<strong>timesteps</strong> (<code>torch.Tensor</code>) &#x2014;
generate embedding vectors at these timesteps`,name:"timesteps"},{anchor:"diffusers.StableDiffusionPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
dimension of the embeddings to generate
dtype &#x2014;
data type of the generated embeddings`,name:"embedding_dim"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L716",returnDescription:`
<p>Embedding vectors with shape <code>(len(timesteps), embedding_dim)</code></p>
`,returnType:`
<p><code>torch.FloatTensor</code></p>
`}}),Xe=new D({props:{name:"unfuse_qkv_projections",anchor:"diffusers.StableDiffusionPipeline.unfuse_qkv_projections",parameters:[{name:"unet",val:": bool = True"},{name:"vae",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.unfuse_qkv_projections.unet",description:"<strong>unet</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014; To apply fusion on the UNet.",name:"unet"},{anchor:"diffusers.StableDiffusionPipeline.unfuse_qkv_projections.vae",description:"<strong>vae</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014; To apply fusion on the VAE.",name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L687"}}),be=new mn({props:{warning:!0,$$slots:{default:[vi]},$$scope:{ctx:S}}}),Qe=new hn({}),Oe=new D({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": Union"},{name:"nsfw_content_detected",val:": Optional"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L10"}}),Ke=new hn({}),et=new D({props:{name:"class diffusers.FlaxStableDiffusionPipeline",anchor:"diffusers.FlaxStableDiffusionPipeline",parameters:[{name:"vae",val:": FlaxAutoencoderKL"},{name:"text_encoder",val:": FlaxCLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": FlaxUNet2DConditionModel"},{name:"scheduler",val:": Union"},{name:"safety_checker",val:": FlaxStableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/autoencoderkl#diffusers.FlaxAutoencoderKL">FlaxAutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FlaxStableDiffusionPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.FlaxCLIPTextModel" rel="nofollow">FlaxCLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.FlaxStableDiffusionPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.FlaxStableDiffusionPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/unet2d-cond#diffusers.FlaxUNet2DConditionModel">FlaxUNet2DConditionModel</a>) &#x2014;
A <code>FlaxUNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.FlaxStableDiffusionPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.25.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<code>FlaxDDIMScheduler</code>, <code>FlaxLMSDiscreteScheduler</code>, <code>FlaxPNDMScheduler</code>, or
<code>FlaxDPMSolverMultistepScheduler</code>.`,name:"scheduler"},{anchor:"diffusers.FlaxStableDiffusionPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>FlaxStableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.FlaxStableDiffusionPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_flax_stable_diffusion.py#L81"}}),tt=new D({props:{name:"__call__",anchor:"diffusers.FlaxStableDiffusionPipeline.__call__",parameters:[{name:"prompt_ids",val:": array"},{name:"params",val:": Union"},{name:"prng_seed",val:": Array"},{name:"num_inference_steps",val:": int = 50"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"guidance_scale",val:": Union = 7.5"},{name:"latents",val:": Array = None"},{name:"neg_prompt_ids",val:": Array = None"},{name:"return_dict",val:": bool = True"},{name:"jit",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation.`,name:"prompt"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.latents",description:`<strong>latents</strong> (<code>jnp.ndarray</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
array is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.jit",description:`<strong>jit</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to run <code>pmap</code> versions of the generation and safety scoring functions.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>This argument exists because <code>__call__</code> is not yet end-to-end pmap-able. It will be removed in a
future release.</p>

					</div>`,name:"jit"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput">FlaxStableDiffusionPipelineOutput</a> instead of
a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_flax_stable_diffusion.py#L310",returnDescription:`
<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated images
and the second element is a list of <code>bool</code>s indicating whether the corresponding generated image
contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`
<p><a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),we=new ct({props:{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.example",$$slots:{default:[xi]},$$scope:{ctx:S}}}),nt=new hn({}),ot=new D({props:{name:"class diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",parameters:[{name:"images",val:": ndarray"},{name:"nsfw_content_detected",val:": List"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>np.ndarray</code>) &#x2014;
Denoised images of array shape of <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content
or <code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L31"}}),st=new D({props:{name:"replace",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/flax/struct.py#L110"}}),{c(){o=s("meta"),T=a(),c=s("h1"),d=s("a"),$=s("span"),h(n.$$.fragment),P=a(),pt=s("span"),pt.textContent=rs,gn=a(),Se=s("p"),Se.innerHTML=ls,_n=a(),De=s("p"),De.textContent=ds,bn=a(),ke=s("p"),ke.innerHTML=cs,vn=a(),h(Q.$$.fragment),xn=a(),R=s("h2"),O=s("a"),an=s("span"),h(Je.$$.fragment),En=a(),ut=s("span"),ut.textContent=fs,wn=a(),u=s("div"),h(Ce.$$.fragment),Vn=a(),mt=s("p"),mt.textContent=ps,Bn=a(),ht=s("p"),ht.innerHTML=us,zn=a(),gt=s("p"),gt.textContent=ms,Rn=a(),_t=s("ul"),_t.innerHTML=hs,An=a(),N=s("div"),h(Ie.$$.fragment),Hn=a(),bt=s("p"),bt.textContent=gs,qn=a(),h(K.$$.fragment),Yn=a(),I=s("div"),h(Ue.$$.fragment),Xn=a(),vt=s("p"),vt.textContent=_s,Qn=a(),h(ee.$$.fragment),On=a(),h(te.$$.fragment),Kn=a(),ne=s("div"),h(je.$$.fragment),eo=a(),xt=s("p"),xt.innerHTML=bs,to=a(),oe=s("div"),h(Le.$$.fragment),no=a(),wt=s("p"),wt.textContent=vs,oo=a(),se=s("div"),h(Ze.$$.fragment),so=a(),yt=s("p"),yt.innerHTML=xs,io=a(),U=s("div"),h(We.$$.fragment),ao=a(),$t=s("p"),$t.innerHTML=ws,ro=a(),h(ie.$$.fragment),lo=a(),h(ae.$$.fragment),co=a(),re=s("div"),h(Ge.$$.fragment),fo=a(),Tt=s("p"),Tt.innerHTML=ys,po=a(),le=s("div"),h(Fe.$$.fragment),uo=a(),Mt=s("p"),Mt.textContent=$s,mo=a(),de=s("div"),h(Ne.$$.fragment),ho=a(),Pt=s("p"),Pt.innerHTML=Ts,go=a(),k=s("div"),h(Ee.$$.fragment),_o=a(),St=s("p"),St.innerHTML=Ms,bo=a(),Dt=s("p"),Dt.textContent=Ps,vo=a(),h(ce.$$.fragment),xo=a(),kt=s("p"),kt.innerHTML=Ss,wo=a(),h(fe.$$.fragment),yo=a(),E=s("div"),h(Ve.$$.fragment),$o=a(),Jt=s("p"),Jt.innerHTML=Ds,To=a(),h(pe.$$.fragment),Mo=a(),J=s("div"),h(Be.$$.fragment),Po=a(),Ct=s("p"),Ct.innerHTML=ks,So=a(),It=s("p"),It.innerHTML=Js,Do=a(),Ut=s("p"),Ut.innerHTML=Cs,ko=a(),jt=s("p"),jt.innerHTML=Is,Jo=a(),Lt=s("p"),Lt.innerHTML=Us,Co=a(),ue=s("div"),h(ze.$$.fragment),Io=a(),Zt=s("p"),Zt.textContent=js,Uo=a(),me=s("div"),h(Re.$$.fragment),jo=a(),Wt=s("p"),Wt.textContent=Ls,Lo=a(),j=s("div"),h(Ae.$$.fragment),Zo=a(),Gt=s("p"),Gt.innerHTML=Zs,Wo=a(),Ft=s("p"),Ft.textContent=Ws,Go=a(),Nt=s("p"),Nt.innerHTML=Gs,Fo=a(),he=s("div"),h(He.$$.fragment),No=a(),Et=s("p"),Et.textContent=Fs,Eo=a(),V=s("div"),h(qe.$$.fragment),Vo=a(),Vt=s("p"),Vt.textContent=Ns,Bo=a(),h(ge.$$.fragment),zo=a(),_e=s("div"),h(Ye.$$.fragment),Ro=a(),Bt=s("p"),Bt.innerHTML=Es,Ao=a(),B=s("div"),h(Xe.$$.fragment),Ho=a(),zt=s("p"),zt.textContent=Vs,qo=a(),h(be.$$.fragment),yn=a(),A=s("h2"),ve=s("a"),rn=s("span"),h(Qe.$$.fragment),Yo=a(),Rt=s("span"),Rt.textContent=Bs,$n=a(),H=s("div"),h(Oe.$$.fragment),Xo=a(),At=s("p"),At.textContent=zs,Tn=a(),q=s("h2"),xe=s("a"),ln=s("span"),h(Ke.$$.fragment),Qo=a(),Ht=s("span"),Ht.textContent=Rs,Mn=a(),C=s("div"),h(et.$$.fragment),Oo=a(),qt=s("p"),qt.textContent=As,Ko=a(),Yt=s("p"),Yt.innerHTML=Hs,es=a(),z=s("div"),h(tt.$$.fragment),ts=a(),Xt=s("p"),Xt.textContent=qs,ns=a(),h(we.$$.fragment),Pn=a(),Y=s("h2"),ye=s("a"),dn=s("span"),h(nt.$$.fragment),os=a(),Qt=s("span"),Qt.textContent=Ys,Sn=a(),G=s("div"),h(ot.$$.fragment),ss=a(),Ot=s("p"),Ot.textContent=Xs,is=a(),$e=s("div"),h(st.$$.fragment),as=a(),Kt=s("p"),Kt.textContent=Qs,this.h()},l(e){const p=li("svelte-1phssyn",document.head);o=i(p,"META",{name:!0,content:!0}),p.forEach(l),T=r(e),c=i(e,"H1",{class:!0});var it=M(c);d=i(it,"A",{id:!0,class:!0,href:!0});var cn=M(d);$=i(cn,"SPAN",{});var fn=M($);g(n.$$.fragment,fn),fn.forEach(l),cn.forEach(l),P=r(it),pt=i(it,"SPAN",{"data-svelte-h":!0}),f(pt)!=="svelte-ws6p24"&&(pt.textContent=rs),it.forEach(l),gn=r(e),Se=i(e,"P",{"data-svelte-h":!0}),f(Se)!=="svelte-98sy2y"&&(Se.innerHTML=ls),_n=r(e),De=i(e,"P",{"data-svelte-h":!0}),f(De)!=="svelte-1cwsb16"&&(De.textContent=ds),bn=r(e),ke=i(e,"P",{"data-svelte-h":!0}),f(ke)!=="svelte-1xoozhu"&&(ke.innerHTML=cs),vn=r(e),g(Q.$$.fragment,e),xn=r(e),R=i(e,"H2",{class:!0});var at=M(R);O=i(at,"A",{id:!0,class:!0,href:!0});var pn=M(O);an=i(pn,"SPAN",{});var un=M(an);g(Je.$$.fragment,un),un.forEach(l),pn.forEach(l),En=r(at),ut=i(at,"SPAN",{"data-svelte-h":!0}),f(ut)!=="svelte-xp2e3v"&&(ut.textContent=fs),at.forEach(l),wn=r(e),u=i(e,"DIV",{class:!0});var m=M(u);g(Ce.$$.fragment,m),Vn=r(m),mt=i(m,"P",{"data-svelte-h":!0}),f(mt)!=="svelte-35p306"&&(mt.textContent=ps),Bn=r(m),ht=i(m,"P",{"data-svelte-h":!0}),f(ht)!=="svelte-s6xyvg"&&(ht.innerHTML=us),zn=r(m),gt=i(m,"P",{"data-svelte-h":!0}),f(gt)!=="svelte-14s6m4u"&&(gt.textContent=ms),Rn=r(m),_t=i(m,"UL",{"data-svelte-h":!0}),f(_t)!=="svelte-1kastu5"&&(_t.innerHTML=hs),An=r(m),N=i(m,"DIV",{class:!0});var X=M(N);g(Ie.$$.fragment,X),Hn=r(X),bt=i(X,"P",{"data-svelte-h":!0}),f(bt)!=="svelte-50j04k"&&(bt.textContent=gs),qn=r(X),g(K.$$.fragment,X),X.forEach(l),Yn=r(m),I=i(m,"DIV",{class:!0});var F=M(I);g(Ue.$$.fragment,F),Xn=r(F),vt=i(F,"P",{"data-svelte-h":!0}),f(vt)!=="svelte-10jaql7"&&(vt.textContent=_s),Qn=r(F),g(ee.$$.fragment,F),On=r(F),g(te.$$.fragment,F),F.forEach(l),Kn=r(m),ne=i(m,"DIV",{class:!0});var rt=M(ne);g(je.$$.fragment,rt),eo=r(rt),xt=i(rt,"P",{"data-svelte-h":!0}),f(xt)!=="svelte-1lh0nh5"&&(xt.innerHTML=bs),rt.forEach(l),to=r(m),oe=i(m,"DIV",{class:!0});var lt=M(oe);g(Le.$$.fragment,lt),no=r(lt),wt=i(lt,"P",{"data-svelte-h":!0}),f(wt)!=="svelte-14bnrb6"&&(wt.textContent=vs),lt.forEach(l),oo=r(m),se=i(m,"DIV",{class:!0});var dt=M(se);g(Ze.$$.fragment,dt),so=r(dt),yt=i(dt,"P",{"data-svelte-h":!0}),f(yt)!=="svelte-1s3c06i"&&(yt.innerHTML=xs),dt.forEach(l),io=r(m),U=i(m,"DIV",{class:!0});var Te=M(U);g(We.$$.fragment,Te),ao=r(Te),$t=i(Te,"P",{"data-svelte-h":!0}),f($t)!=="svelte-e03q3e"&&($t.innerHTML=ws),ro=r(Te),g(ie.$$.fragment,Te),lo=r(Te),g(ae.$$.fragment,Te),Te.forEach(l),co=r(m),re=i(m,"DIV",{class:!0});var kn=M(re);g(Ge.$$.fragment,kn),fo=r(kn),Tt=i(kn,"P",{"data-svelte-h":!0}),f(Tt)!=="svelte-1vfte1e"&&(Tt.innerHTML=ys),kn.forEach(l),po=r(m),le=i(m,"DIV",{class:!0});var Jn=M(le);g(Fe.$$.fragment,Jn),uo=r(Jn),Mt=i(Jn,"P",{"data-svelte-h":!0}),f(Mt)!=="svelte-1xwrf7t"&&(Mt.textContent=$s),Jn.forEach(l),mo=r(m),de=i(m,"DIV",{class:!0});var Cn=M(de);g(Ne.$$.fragment,Cn),ho=r(Cn),Pt=i(Cn,"P",{"data-svelte-h":!0}),f(Pt)!=="svelte-pkn4ui"&&(Pt.innerHTML=Ts),Cn.forEach(l),go=r(m),k=i(m,"DIV",{class:!0});var L=M(k);g(Ee.$$.fragment,L),_o=r(L),St=i(L,"P",{"data-svelte-h":!0}),f(St)!=="svelte-1a425ok"&&(St.innerHTML=Ms),bo=r(L),Dt=i(L,"P",{"data-svelte-h":!0}),f(Dt)!=="svelte-11lpom8"&&(Dt.textContent=Ps),vo=r(L),g(ce.$$.fragment,L),xo=r(L),kt=i(L,"P",{"data-svelte-h":!0}),f(kt)!=="svelte-15d7mv5"&&(kt.innerHTML=Ss),wo=r(L),g(fe.$$.fragment,L),L.forEach(l),yo=r(m),E=i(m,"DIV",{class:!0});var en=M(E);g(Ve.$$.fragment,en),$o=r(en),Jt=i(en,"P",{"data-svelte-h":!0}),f(Jt)!=="svelte-lj9puh"&&(Jt.innerHTML=Ds),To=r(en),g(pe.$$.fragment,en),en.forEach(l),Mo=r(m),J=i(m,"DIV",{class:!0});var Z=M(J);g(Be.$$.fragment,Z),Po=r(Z),Ct=i(Z,"P",{"data-svelte-h":!0}),f(Ct)!=="svelte-vs7s0z"&&(Ct.innerHTML=ks),So=r(Z),It=i(Z,"P",{"data-svelte-h":!0}),f(It)!=="svelte-15b960v"&&(It.innerHTML=Js),Do=r(Z),Ut=i(Z,"P",{"data-svelte-h":!0}),f(Ut)!=="svelte-1sfxfk0"&&(Ut.innerHTML=Cs),ko=r(Z),jt=i(Z,"P",{"data-svelte-h":!0}),f(jt)!=="svelte-flvvrp"&&(jt.innerHTML=Is),Jo=r(Z),Lt=i(Z,"P",{"data-svelte-h":!0}),f(Lt)!=="svelte-n2pvuj"&&(Lt.innerHTML=Us),Z.forEach(l),Co=r(m),ue=i(m,"DIV",{class:!0});var In=M(ue);g(ze.$$.fragment,In),Io=r(In),Zt=i(In,"P",{"data-svelte-h":!0}),f(Zt)!=="svelte-1ufq5ot"&&(Zt.textContent=js),In.forEach(l),Uo=r(m),me=i(m,"DIV",{class:!0});var Un=M(me);g(Re.$$.fragment,Un),jo=r(Un),Wt=i(Un,"P",{"data-svelte-h":!0}),f(Wt)!=="svelte-psupw6"&&(Wt.textContent=Ls),Un.forEach(l),Lo=r(m),j=i(m,"DIV",{class:!0});var Me=M(j);g(Ae.$$.fragment,Me),Zo=r(Me),Gt=i(Me,"P",{"data-svelte-h":!0}),f(Gt)!=="svelte-1f3tmq1"&&(Gt.innerHTML=Zs),Wo=r(Me),Ft=i(Me,"P",{"data-svelte-h":!0}),f(Ft)!=="svelte-xjijlp"&&(Ft.textContent=Ws),Go=r(Me),Nt=i(Me,"P",{"data-svelte-h":!0}),f(Nt)!=="svelte-hy0nzs"&&(Nt.innerHTML=Gs),Me.forEach(l),Fo=r(m),he=i(m,"DIV",{class:!0});var jn=M(he);g(He.$$.fragment,jn),No=r(jn),Et=i(jn,"P",{"data-svelte-h":!0}),f(Et)!=="svelte-16q0ax1"&&(Et.textContent=Fs),jn.forEach(l),Eo=r(m),V=i(m,"DIV",{class:!0});var tn=M(V);g(qe.$$.fragment,tn),Vo=r(tn),Vt=i(tn,"P",{"data-svelte-h":!0}),f(Vt)!=="svelte-le0q9u"&&(Vt.textContent=Ns),Bo=r(tn),g(ge.$$.fragment,tn),tn.forEach(l),zo=r(m),_e=i(m,"DIV",{class:!0});var Ln=M(_e);g(Ye.$$.fragment,Ln),Ro=r(Ln),Bt=i(Ln,"P",{"data-svelte-h":!0}),f(Bt)!=="svelte-vo59ec"&&(Bt.innerHTML=Es),Ln.forEach(l),Ao=r(m),B=i(m,"DIV",{class:!0});var nn=M(B);g(Xe.$$.fragment,nn),Ho=r(nn),zt=i(nn,"P",{"data-svelte-h":!0}),f(zt)!=="svelte-fohozp"&&(zt.textContent=Vs),qo=r(nn),g(be.$$.fragment,nn),nn.forEach(l),m.forEach(l),yn=r(e),A=i(e,"H2",{class:!0});var Zn=M(A);ve=i(Zn,"A",{id:!0,class:!0,href:!0});var Os=M(ve);rn=i(Os,"SPAN",{});var Ks=M(rn);g(Qe.$$.fragment,Ks),Ks.forEach(l),Os.forEach(l),Yo=r(Zn),Rt=i(Zn,"SPAN",{"data-svelte-h":!0}),f(Rt)!=="svelte-1ocdz42"&&(Rt.textContent=Bs),Zn.forEach(l),$n=r(e),H=i(e,"DIV",{class:!0});var Wn=M(H);g(Oe.$$.fragment,Wn),Xo=r(Wn),At=i(Wn,"P",{"data-svelte-h":!0}),f(At)!=="svelte-1qpjiuf"&&(At.textContent=zs),Wn.forEach(l),Tn=r(e),q=i(e,"H2",{class:!0});var Gn=M(q);xe=i(Gn,"A",{id:!0,class:!0,href:!0});var ei=M(xe);ln=i(ei,"SPAN",{});var ti=M(ln);g(Ke.$$.fragment,ti),ti.forEach(l),ei.forEach(l),Qo=r(Gn),Ht=i(Gn,"SPAN",{"data-svelte-h":!0}),f(Ht)!=="svelte-8lmvei"&&(Ht.textContent=Rs),Gn.forEach(l),Mn=r(e),C=i(e,"DIV",{class:!0});var Pe=M(C);g(et.$$.fragment,Pe),Oo=r(Pe),qt=i(Pe,"P",{"data-svelte-h":!0}),f(qt)!=="svelte-d05p75"&&(qt.textContent=As),Ko=r(Pe),Yt=i(Pe,"P",{"data-svelte-h":!0}),f(Yt)!=="svelte-egv27w"&&(Yt.innerHTML=Hs),es=r(Pe),z=i(Pe,"DIV",{class:!0});var on=M(z);g(tt.$$.fragment,on),ts=r(on),Xt=i(on,"P",{"data-svelte-h":!0}),f(Xt)!=="svelte-50j04k"&&(Xt.textContent=qs),ns=r(on),g(we.$$.fragment,on),on.forEach(l),Pe.forEach(l),Pn=r(e),Y=i(e,"H2",{class:!0});var Fn=M(Y);ye=i(Fn,"A",{id:!0,class:!0,href:!0});var ni=M(ye);dn=i(ni,"SPAN",{});var oi=M(dn);g(nt.$$.fragment,oi),oi.forEach(l),ni.forEach(l),os=r(Fn),Qt=i(Fn,"SPAN",{"data-svelte-h":!0}),f(Qt)!=="svelte-1yazx8z"&&(Qt.textContent=Ys),Fn.forEach(l),Sn=r(e),G=i(e,"DIV",{class:!0});var sn=M(G);g(ot.$$.fragment,sn),ss=r(sn),Ot=i(sn,"P",{"data-svelte-h":!0}),f(Ot)!=="svelte-wzv2jc"&&(Ot.textContent=Xs),is=r(sn),$e=i(sn,"DIV",{class:!0});var Nn=M($e);g(st.$$.fragment,Nn),as=r(Nn),Kt=i(Nn,"P",{"data-svelte-h":!0}),f(Kt)!=="svelte-5ihtpa"&&(Kt.textContent=Qs),Nn.forEach(l),sn.forEach(l),this.h()},h(){w(o,"name","hf:doc:metadata"),w(o,"content",JSON.stringify(yi)),w(d,"id","texttoimage"),w(d,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),w(d,"href","#texttoimage"),w(c,"class","relative group"),w(O,"id","diffusers.StableDiffusionPipeline"),w(O,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),w(O,"href","#diffusers.StableDiffusionPipeline"),w(R,"class","relative group"),w(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(u,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ve,"id","diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"),w(ve,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),w(ve,"href","#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"),w(A,"class","relative group"),w(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(xe,"id","diffusers.FlaxStableDiffusionPipeline"),w(xe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),w(xe,"href","#diffusers.FlaxStableDiffusionPipeline"),w(q,"class","relative group"),w(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ye,"id","diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"),w(ye,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),w(ye,"href","#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"),w(Y,"class","relative group"),w($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){t(document.head,o),y(e,T,p),y(e,c,p),t(c,d),t(d,$),_(n,$,null),t(c,P),t(c,pt),y(e,gn,p),y(e,Se,p),y(e,_n,p),y(e,De,p),y(e,bn,p),y(e,ke,p),y(e,vn,p),_(Q,e,p),y(e,xn,p),y(e,R,p),t(R,O),t(O,an),_(Je,an,null),t(R,En),t(R,ut),y(e,wn,p),y(e,u,p),_(Ce,u,null),t(u,Vn),t(u,mt),t(u,Bn),t(u,ht),t(u,zn),t(u,gt),t(u,Rn),t(u,_t),t(u,An),t(u,N),_(Ie,N,null),t(N,Hn),t(N,bt),t(N,qn),_(K,N,null),t(u,Yn),t(u,I),_(Ue,I,null),t(I,Xn),t(I,vt),t(I,Qn),_(ee,I,null),t(I,On),_(te,I,null),t(u,Kn),t(u,ne),_(je,ne,null),t(ne,eo),t(ne,xt),t(u,to),t(u,oe),_(Le,oe,null),t(oe,no),t(oe,wt),t(u,oo),t(u,se),_(Ze,se,null),t(se,so),t(se,yt),t(u,io),t(u,U),_(We,U,null),t(U,ao),t(U,$t),t(U,ro),_(ie,U,null),t(U,lo),_(ae,U,null),t(u,co),t(u,re),_(Ge,re,null),t(re,fo),t(re,Tt),t(u,po),t(u,le),_(Fe,le,null),t(le,uo),t(le,Mt),t(u,mo),t(u,de),_(Ne,de,null),t(de,ho),t(de,Pt),t(u,go),t(u,k),_(Ee,k,null),t(k,_o),t(k,St),t(k,bo),t(k,Dt),t(k,vo),_(ce,k,null),t(k,xo),t(k,kt),t(k,wo),_(fe,k,null),t(u,yo),t(u,E),_(Ve,E,null),t(E,$o),t(E,Jt),t(E,To),_(pe,E,null),t(u,Mo),t(u,J),_(Be,J,null),t(J,Po),t(J,Ct),t(J,So),t(J,It),t(J,Do),t(J,Ut),t(J,ko),t(J,jt),t(J,Jo),t(J,Lt),t(u,Co),t(u,ue),_(ze,ue,null),t(ue,Io),t(ue,Zt),t(u,Uo),t(u,me),_(Re,me,null),t(me,jo),t(me,Wt),t(u,Lo),t(u,j),_(Ae,j,null),t(j,Zo),t(j,Gt),t(j,Wo),t(j,Ft),t(j,Go),t(j,Nt),t(u,Fo),t(u,he),_(He,he,null),t(he,No),t(he,Et),t(u,Eo),t(u,V),_(qe,V,null),t(V,Vo),t(V,Vt),t(V,Bo),_(ge,V,null),t(u,zo),t(u,_e),_(Ye,_e,null),t(_e,Ro),t(_e,Bt),t(u,Ao),t(u,B),_(Xe,B,null),t(B,Ho),t(B,zt),t(B,qo),_(be,B,null),y(e,yn,p),y(e,A,p),t(A,ve),t(ve,rn),_(Qe,rn,null),t(A,Yo),t(A,Rt),y(e,$n,p),y(e,H,p),_(Oe,H,null),t(H,Xo),t(H,At),y(e,Tn,p),y(e,q,p),t(q,xe),t(xe,ln),_(Ke,ln,null),t(q,Qo),t(q,Ht),y(e,Mn,p),y(e,C,p),_(et,C,null),t(C,Oo),t(C,qt),t(C,Ko),t(C,Yt),t(C,es),t(C,z),_(tt,z,null),t(z,ts),t(z,Xt),t(z,ns),_(we,z,null),y(e,Pn,p),y(e,Y,p),t(Y,ye),t(ye,dn),_(nt,dn,null),t(Y,os),t(Y,Qt),y(e,Sn,p),y(e,G,p),_(ot,G,null),t(G,ss),t(G,Ot),t(G,is),t(G,$e),_(st,$e,null),t($e,as),t($e,Kt),Dn=!0},p(e,[p]){const it={};p&2&&(it.$$scope={dirty:p,ctx:e}),Q.$set(it);const cn={};p&2&&(cn.$$scope={dirty:p,ctx:e}),K.$set(cn);const fn={};p&2&&(fn.$$scope={dirty:p,ctx:e}),ee.$set(fn);const at={};p&2&&(at.$$scope={dirty:p,ctx:e}),te.$set(at);const pn={};p&2&&(pn.$$scope={dirty:p,ctx:e}),ie.$set(pn);const un={};p&2&&(un.$$scope={dirty:p,ctx:e}),ae.$set(un);const m={};p&2&&(m.$$scope={dirty:p,ctx:e}),ce.$set(m);const X={};p&2&&(X.$$scope={dirty:p,ctx:e}),fe.$set(X);const F={};p&2&&(F.$$scope={dirty:p,ctx:e}),pe.$set(F);const rt={};p&2&&(rt.$$scope={dirty:p,ctx:e}),ge.$set(rt);const lt={};p&2&&(lt.$$scope={dirty:p,ctx:e}),be.$set(lt);const dt={};p&2&&(dt.$$scope={dirty:p,ctx:e}),we.$set(dt)},i(e){Dn||(b(n.$$.fragment,e),b(Q.$$.fragment,e),b(Je.$$.fragment,e),b(Ce.$$.fragment,e),b(Ie.$$.fragment,e),b(K.$$.fragment,e),b(Ue.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),b(je.$$.fragment,e),b(Le.$$.fragment,e),b(Ze.$$.fragment,e),b(We.$$.fragment,e),b(ie.$$.fragment,e),b(ae.$$.fragment,e),b(Ge.$$.fragment,e),b(Fe.$$.fragment,e),b(Ne.$$.fragment,e),b(Ee.$$.fragment,e),b(ce.$$.fragment,e),b(fe.$$.fragment,e),b(Ve.$$.fragment,e),b(pe.$$.fragment,e),b(Be.$$.fragment,e),b(ze.$$.fragment,e),b(Re.$$.fragment,e),b(Ae.$$.fragment,e),b(He.$$.fragment,e),b(qe.$$.fragment,e),b(ge.$$.fragment,e),b(Ye.$$.fragment,e),b(Xe.$$.fragment,e),b(be.$$.fragment,e),b(Qe.$$.fragment,e),b(Oe.$$.fragment,e),b(Ke.$$.fragment,e),b(et.$$.fragment,e),b(tt.$$.fragment,e),b(we.$$.fragment,e),b(nt.$$.fragment,e),b(ot.$$.fragment,e),b(st.$$.fragment,e),Dn=!0)},o(e){v(n.$$.fragment,e),v(Q.$$.fragment,e),v(Je.$$.fragment,e),v(Ce.$$.fragment,e),v(Ie.$$.fragment,e),v(K.$$.fragment,e),v(Ue.$$.fragment,e),v(ee.$$.fragment,e),v(te.$$.fragment,e),v(je.$$.fragment,e),v(Le.$$.fragment,e),v(Ze.$$.fragment,e),v(We.$$.fragment,e),v(ie.$$.fragment,e),v(ae.$$.fragment,e),v(Ge.$$.fragment,e),v(Fe.$$.fragment,e),v(Ne.$$.fragment,e),v(Ee.$$.fragment,e),v(ce.$$.fragment,e),v(fe.$$.fragment,e),v(Ve.$$.fragment,e),v(pe.$$.fragment,e),v(Be.$$.fragment,e),v(ze.$$.fragment,e),v(Re.$$.fragment,e),v(Ae.$$.fragment,e),v(He.$$.fragment,e),v(qe.$$.fragment,e),v(ge.$$.fragment,e),v(Ye.$$.fragment,e),v(Xe.$$.fragment,e),v(be.$$.fragment,e),v(Qe.$$.fragment,e),v(Oe.$$.fragment,e),v(Ke.$$.fragment,e),v(et.$$.fragment,e),v(tt.$$.fragment,e),v(we.$$.fragment,e),v(nt.$$.fragment,e),v(ot.$$.fragment,e),v(st.$$.fragment,e),Dn=!1},d(e){e&&(l(T),l(c),l(gn),l(Se),l(_n),l(De),l(bn),l(ke),l(vn),l(xn),l(R),l(wn),l(u),l(yn),l(A),l($n),l(H),l(Tn),l(q),l(Mn),l(C),l(Pn),l(Y),l(Sn),l(G)),l(o),x(n),x(Q,e),x(Je),x(Ce),x(Ie),x(K),x(Ue),x(ee),x(te),x(je),x(Le),x(Ze),x(We),x(ie),x(ae),x(Ge),x(Fe),x(Ne),x(Ee),x(ce),x(fe),x(Ve),x(pe),x(Be),x(ze),x(Re),x(Ae),x(He),x(qe),x(ge),x(Ye),x(Xe),x(be),x(Qe),x(Oe),x(Ke),x(et),x(tt),x(we),x(nt),x(ot),x(st)}}}const yi={local:"texttoimage",sections:[{local:"diffusers.StableDiffusionPipeline",title:"StableDiffusionPipeline"},{local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",title:"StableDiffusionPipelineOutput"},{local:"diffusers.FlaxStableDiffusionPipeline",title:"FlaxStableDiffusionPipeline"},{local:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",title:"FlaxStableDiffusionPipelineOutput"}],title:"Text-to-image"};function $i(S){return ii(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ci extends ai{constructor(o){super(),ri(this,o,$i,wi,si,{})}}export{Ci as component};
