import{s as Zi,o as Wi,n as Ri}from"../chunks/scheduler.6062bdaf.js";import{S as Di,i as Gi,g as l,s as a,r as c,A as Ki,h as s,f as i,c as o,j as Ei,u,x as r,k as Kt,y as Vi,a as n,v as m,d,t as f,w as h}from"../chunks/index.4bca734e.js";import{T as Oi}from"../chunks/Tip.b9ac1f03.js";import{C as Pe}from"../chunks/CodeBlock.cbbddafc.js";import{H as b,E as Xi}from"../chunks/getInferenceSnippets.8ccbc96a.js";function Yi(Ue){let p,v=`Usually <code>round(a/S + Z)</code> corresponds to the smallest representable value in the considered data type, and <code>round(b/S + Z)</code>
to the biggest one. But this can vary, for instance when using a <em>symmetric quantization scheme</em> as you will see in the next
paragraph.`;return{c(){p=l("p"),p.innerHTML=v},l(g){p=s(g,"P",{"data-svelte-h":!0}),r(p)!=="svelte-d33l1n"&&(p.innerHTML=v)},m(g,w){n(g,p,w)},p:Ri,d(g){g&&i(p)}}}function en(Ue){let p,v=`The section is not fundamental to understand the rest. It explains in brief how numbers are represented in computers.
Since quantization is about going from one representation to another, it can be useful to have some basics, but it is
definitely not mandatory.`;return{c(){p=l("p"),p.textContent=v},l(g){p=s(g,"P",{"data-svelte-h":!0}),r(p)!=="svelte-193nbxk"&&(p.textContent=v)},m(g,w){n(g,p,w)},p:Ri,d(g){g&&i(p)}}}function tn(Ue){let p,v,g,w,x,Je,q,Vt=`Quantization is a technique to reduce the computational and memory costs of running inference by representing the
weights and activations with low-precision data types like 8-bit integer (<code>int8</code>) instead of the usual 32-bit floating
point (<code>float32</code>).`,Se,z,Xt=`Reducing the number of bits means the resulting model requires less memory storage, consumes less energy (in theory), and
operations like matrix multiplication can be performed much faster with integer arithmetic. It also allows to run models
on embedded devices, which sometimes only support integer data types.`,Ae,C,Qe,L,Yt=`The basic idea behind quantization is quite easy: going from high-precision representation (usually the regular 32-bit
floating-point) for weights and activations to a lower precision data type. The most common lower precision data types
are:`,Ne,_,ei="<li><code>float16</code>, accumulation data type <code>float16</code></li> <li><code>bfloat16</code>, accumulation data type <code>float32</code></li> <li><code>int16</code>, accumulation data type <code>int32</code></li> <li><code>int8</code>, accumulation data type <code>int32</code></li>",Be,H,ti=`The accumulation data type specifies the type of the result of accumulating (adding, multiplying, etc) values of the
data type in question. For example, let’s consider two <code>int8</code> values <code>A = 127</code>, <code>B = 127</code>, and let’s define <code>C</code> as the
sum of <code>A</code> and <code>B</code>:`,Fe,j,Ee,k,ii=`Here the result is much bigger than the biggest representable value in <code>int8</code>, which is <code>127</code>. Hence the need for a larger
precision data type to avoid a huge precision loss that would make the whole quantization process useless.`,Oe,U,Re,P,ni="The two most common quantization cases are <code>float32 -&gt; float16</code> and <code>float32 -&gt; int8</code>.",Ze,I,We,J,ai=`Performing quantization to go from <code>float32</code> to <code>float16</code> is quite straightforward since both data types follow the same
representation scheme. The questions to ask yourself when quantizing an operation to <code>float16</code> are:`,De,S,oi=`<li>Does my operation have a <code>float16</code> implementation?</li> <li>Does my hardware suport <code>float16</code>? For instance, Intel CPUs <a href="https://scicomp.stackexchange.com/a/35193" rel="nofollow">have been supporting <code>float16</code> as a storage type, but
computation is done after converting to <code>float32</code></a>. Full support will come
in Cooper Lake and Sapphire Rapids.</li> <li>Is my operation sensitive to lower precision?
For instance the value of epsilon in <code>LayerNorm</code> is usually very small (~ <code>1e-12</code>), but the smallest representable value in
<code>float16</code> is ~ <code>6e-5</code>, this can cause <code>NaN</code> issues.  The same applies for big values.</li>`,Ge,A,Ke,Q,li=`Performing quantization to go from <code>float32</code> to <code>int8</code> is more tricky. Only 256 values can be represented in <code>int8</code>,
while <code>float32</code> can represent a very wide range of values. The idea is to find the best way to project our range <code>[a, b]</code>
of <code>float32</code> values  to the <code>int8</code> space.`,Ve,N,si=`Let’s consider a float <code>x</code> in <code>[a, b]</code>, then we can write the following quantization scheme, also called the <em>affine
quantization scheme</em>:`,Xe,B,Ye,F,ri="where:",et,E,pi=`<li><code>x_q</code> is the quantized <code>int8</code> value associated to <code>x</code></li> <li><code>S</code> and <code>Z</code> are the quantization parameters<ul><li><code>S</code> is the scale, and is a positive <code>float32</code></li> <li><code>Z</code> is called the zero-point, it is the <code>int8</code> value corresponding to the value <code>0</code> in the <code>float32</code> realm. This is
important to be able to represent exactly the value <code>0</code> because it is used everywhere throughout machine learning
models.</li></ul></li>`,tt,O,ci="The quantized value <code>x_q</code> of <code>x</code> in <code>[a, b]</code> can be computed as follows:",it,R,nt,Z,ui=`And <code>float32</code> values outside of the <code>[a, b]</code> range are clipped to the closest representable value, so for any
floating-point number <code>x</code>:`,at,W,ot,$,lt,D,st,G,mi="The equation above is called the <em>affine quantization scheme</em> because the mapping from <code>[a, b]</code> to <code>int8</code> is an affine one.",rt,K,di=`A common special case of this scheme is the <em>symmetric quantization scheme</em>, where we consider a symmetric range of float values <code>[-a, a]</code>.
In this case the integer space is usually <code>[-127, 127]</code>, meaning that the <code>-128</code> is opted out of the regular <code>[-128, 127]</code> signed <code>int8</code> range.
The reason being that having a symmetric range allows to have <code>Z = 0</code>. While one value out of the 256 representable
values is lost, it can provide a speedup since a lot of addition operations can be skipped.`,pt,V,fi=`<strong>Note</strong>: To learn how the quantization parameters <code>S</code> and <code>Z</code> are computed, you can read the
<a href="https://arxiv.org/abs/1712.05877" rel="nofollow">Quantization and Training of Neural Networks for Efficient Integer-Arithmetic-Only Inference</a>
paper, or <a href="https://leimao.github.io/article/Neural-Networks-Quantization" rel="nofollow">Lei Mao’s blog post</a> on the subject.`,ct,X,ut,Y,hi="Depending on the accuracy / latency trade-off you are targetting you can play with the granularity of the quantization parameters:",mt,ee,gi=`<li>Quantization parameters can be computed on a <em>per-tensor</em> basis, meaning that one pair of <code>(S, Z)</code> will be used per
tensor.</li> <li>Quantization parameters can be computed on a <em>per-channel</em> basis, meaning that it is possible to store a pair of
<code>(S, Z)</code> per element along one of the dimensions of a tensor. For example for a tensor of shape <code>[N, C, H, W]</code>, having
<em>per-channel</em> quantization parameters for the second dimension would result in having <code>C</code> pairs of <code>(S, Z)</code>. While this
can give a better accuracy, it requires more memory.</li>`,dt,te,ft,ie,bi=`The section above described how quantization from <code>float32</code> to <code>int8</code> works, but one question
remains: how is the <code>[a, b]</code> range of <code>float32</code> values determined? That is where calibration comes in to play.`,ht,ne,vi=`Calibration is the step during quantization where the <code>float32</code> ranges are computed. For weights it is quite easy since
the actual range is known at <em>quantization-time</em>. But it is less clear for activations, and different approaches exist:`,gt,ae,wi=`<li>Post training <strong>dynamic quantization</strong>: the range for each activation is computed on the fly at <em>runtime</em>. While this
gives great results without too much work, it can be a bit slower than static quantization because of the overhead
introduced by computing the range each time.
It is also not an option on certain hardware.</li> <li>Post training <strong>static quantization</strong>: the range for each activation is computed in advance at <em>quantization-time</em>,
typically by passing representative data through the model and recording the activation values. In practice, the steps are:<ol><li>Observers are put on activations to record their values.</li> <li>A certain number of forward passes on a calibration dataset is done (around <code>200</code> examples is enough).</li> <li>The ranges for each computation are computed according to some <em>calibration technique</em>.</li></ol></li> <li><strong>Quantization aware training</strong>: the range for each activation is computed at <em>training-time</em>, following the same idea
than post training static quantization. But “fake quantize” operators are used instead of observers: they record
values just as observers do, but they also simulate the error induced by quantization to let the model adapt to it.</li>`,bt,oe,$i=`For both post training static quantization and quantization aware training, it is necessary to define calibration
techniques, the most common are:`,vt,le,Ti=`<li>Min-max: the computed range is <code>[min observed value, max observed value]</code>, this works well with weights.</li> <li>Moving average min-max: the computed range is <code>[moving average min observed value, moving average max observed value]</code>,
this works well with activations.</li> <li>Histogram: records a histogram of values along with min and max values, then chooses according to some criterion:<ul><li>Entropy: the range is computed as the one minimizing the error between the full-precision and the quantized data.</li> <li>Mean Square Error: the range is computed as the one minimizing the mean square error between the full-precision and
the quantized data.</li> <li>Percentile: the range is computed using a given percentile value <code>p</code> on the observed values. The idea is to try to have
<code>p%</code> of the observed values in the computed range. While this is possible when doing affine quantization, it is not always
possible to exactly match that when doing symmetric quantization. You can check <a href="https://github.com/microsoft/onnxruntime/blob/2cb12caf9317f1ded37f6db125cb03ba99320c40/onnxruntime/python/tools/quantization/calibrate.py#L698" rel="nofollow">how it is done in ONNX
Runtime</a>
for more details.</li></ul></li>`,wt,se,$t,re,yi="To effectively quantize a model to <code>int8</code>, the steps to follow are:",Tt,pe,Mi=`<li>Choose which operators to quantize. Good operators to quantize are the one dominating it terms of computation time,
for instance linear projections and matrix multiplications.</li> <li>Try post-training dynamic quantization, if it is fast enough stop here, otherwise continue to step 3.</li> <li>Try post-training static quantization which can be faster than dynamic quantization but often with a drop in terms of
accuracy. Apply observers to your models in places where you want to quantize.</li> <li>Choose a calibration technique and perform it.</li> <li>Convert the model to its quantized form: the observers are removed and the <code>float32</code> operators are converted to their <code>int8</code>
coutnerparts.</li> <li>Evaluate the quantized model: is the accuracy good enough? If yes, stop here, otherwise start again at step 3 but
with quantization aware training this time.</li>`,yt,ce,Mt,ue,xi="🤗 Optimum provides APIs to perform quantization using different tools for different targets:",xt,me,qi=`<li>The <code>optimum.onnxruntime</code> package allows to
<a href="https://huggingface.co/docs/optimum/onnxruntime/usage_guides/quantization" rel="nofollow">quantize and run ONNX models</a> using the
ONNX Runtime tool.</li> <li>The <code>optimum.intel</code> package enables to <a href="https://huggingface.co/docs/optimum/intel/optimization_inc" rel="nofollow">quantize</a> 🤗 Transformers
models while respecting accuracy and latency constraints.</li> <li>The <code>optimum.fx</code> package provides wrappers around the
<a href="https://pytorch.org/docs/stable/quantization-support.html#torch-quantization-quantize-fx" rel="nofollow">PyTorch quantization functions</a>
to allow graph-mode quantization of 🤗 Transformers models in PyTorch. This is a lower-level API compared to the two
mentioned above, giving more flexibility, but requiring more work on your end.</li> <li>The <code>optimum.gptq</code> package allows to <a href="../llm_quantization/usage_guides/quantization">quantize and run LLM models</a> with GPTQ.</li>`,qt,de,zt,T,Ct,fe,zi=`The most fundamental unit of representation for computers is the bit. Everything in computers is represented as a
sequence of bits, including numbers. But the representation varies whether the numbers in question are integers or
real numbers.`,Lt,he,_t,ge,Ci=`Integers are usually represented with the following bit lengths: <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>. When representing integers, two cases
are considered:`,Ht,be,Li=`<li>Unsigned (positive) integers: they are simply represented as a sequence of bits. Each bit corresponds to a power
of two (from <code>0</code> to <code>n-1</code> where <code>n</code> is the bit-length), and the resulting number is the sum of those powers of two.</li>`,jt,ve,_i="Example: <code>19</code> is represented as an unsigned int8 as <code>00010011</code> because :",kt,we,Ut,y,Hi=`<li>Signed integers: it is less straightforward to represent signed integers, and multiple approachs exist, the most
common being the <em>two’s complement</em>. For more information, you can check the
<a href="https://en.wikipedia.org/wiki/Signed_number_representations" rel="nofollow">Wikipedia page</a> on the subject.</li>`,Pt,$e,It,Te,ji=`Real numbers are usually represented with the following bit lengths: <code>16</code>, <code>32</code>, <code>64</code>.
The two main ways of representing real numbers are:`,Jt,ye,ki="<li>Fixed-point: there are fixed number of digits reserved for representing the integer part and the fractional part.</li> <li>Floating-point: the number of digits for representing the integer and the fractional parts can vary.</li>",St,Me,Ui=`The floating-point representation can represent bigger ranges of values, and this is the one we will be focusing on
since it is the most commonly used. There are three components in the floating-point representation:`,At,xe,Pi="<li>The sign bit: this is the bit specifying the sign of the number.</li> <li>The exponent part</li>",Qt,qe,Ii="<li>5 bits in <code>float16</code></li> <li>8 bits in <code>bfloat16</code></li> <li>8 bits in <code>float32</code></li> <li>11 bits in <code>float64</code></li>",Nt,M,Ji="<li>The mantissa</li>",Bt,ze,Si="<li>11 bits in <code>float16</code> (10 explictly stored)</li> <li>8 bits in <code>bfloat16</code> (7 explicitly stored)</li> <li>24 bits in <code>float32</code> (23 explictly stored)</li> <li>53 bits in <code>float64</code> (52 explictly stored)</li>",Ft,Ce,Ai=`For more information on the bits allocation for each data type, check the nice illustration on the Wikipedia page about
the <a href="https://en.wikipedia.org/wiki/Bfloat16_floating-point_format" rel="nofollow">bfloat16 floating-point format</a>.`,Et,Le,Qi="For a real number <code>x</code> we have:",Ot,_e,Rt,He,Zt,je,Ni=`<li>The
<a href="https://arxiv.org/abs/1712.05877" rel="nofollow">Quantization and Training of Neural Networks for Efficient Integer-Arithmetic-Only Inference</a> paper</li> <li>The <a href="https://iq.opengenus.org/basics-of-quantization-in-ml/" rel="nofollow">Basics of Quantization in Machine Learning (ML) for Beginners</a>
blog post</li> <li>The <a href="https://tivadardanka.com/blog/neural-networks-quantization" rel="nofollow">How to accelerate and compress neural networks with quantization</a>
blog post</li> <li>The Wikipedia pages on integers representation <a href="https://en.wikipedia.org/wiki/Integer_(computer_science)" rel="nofollow">here</a> and
<a href="https://en.wikipedia.org/wiki/Signed_number_representations" rel="nofollow">here</a></li> <li>The Wikipedia pages on<ul><li><a href="https://en.wikipedia.org/wiki/Bfloat16_floating-point_format" rel="nofollow">bfloat16 floating-point format</a></li> <li><a href="https://en.wikipedia.org/wiki/Half-precision_floating-point_format" rel="nofollow">Half-precision floating-point format</a></li> <li><a href="https://en.wikipedia.org/wiki/Single-precision_floating-point_format" rel="nofollow">Single-precision floating-point format</a></li> <li><a href="https://en.wikipedia.org/wiki/Double-precision_floating-point_format" rel="nofollow">Double-precision floating-point format</a></li></ul></li>`,Wt,ke,Dt,Ie,Gt;return x=new b({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),C=new b({props:{title:"Theory",local:"theory",headingTag:"h2"}}),j=new Pe({props:{code:"QyUyMCUzRCUyMEElMjAlMkIlMjBC",highlighted:'<span class="hljs-attr">C</span> = A + B',wrap:!1}}),U=new b({props:{title:"Quantization",local:"quantization",headingTag:"h2"}}),I=new b({props:{title:"Quantization to float16",local:"quantization-to-float16",headingTag:"h3"}}),A=new b({props:{title:"Quantization to int8",local:"quantization-to-int8",headingTag:"h3"}}),B=new Pe({props:{code:"eCUyMCUzRCUyMFMlMjAqJTIwKHhfcSUyMC0lMjBaKQ==",highlighted:'<span class="hljs-attribute">x</span> <span class="hljs-operator">=</span> S * (x_q - Z)',wrap:!1}}),R=new Pe({props:{code:"eF9xJTIwJTNEJTIwcm91bmQoeCUyRlMlMjAlMkIlMjBaKQ==",highlighted:'<span class="hljs-variable">x_q</span> = <span class="hljs-function"><span class="hljs-title"><span class="hljs-built_in">round</span></span>(<span class="hljs-variable">x</span>/<span class="hljs-variable">S</span> + <span class="hljs-variable">Z</span>)</span>',wrap:!1}}),W=new Pe({props:{code:"eF9xJTIwJTNEJTIwY2xpcChyb3VuZCh4JTJGUyUyMCUyQiUyMFopJTJDJTIwcm91bmQoYSUyRlMlMjAlMkIlMjBaKSUyQyUyMHJvdW5kKGIlMkZTJTIwJTJCJTIwWikpJTBB",highlighted:`x_q = <span class="hljs-built_in">clip</span>(<span class="hljs-built_in">round</span>(x/S + Z), <span class="hljs-built_in">round</span>(a/S + Z), <span class="hljs-built_in">round</span>(b/S + Z))
`,wrap:!1}}),$=new Oi({props:{$$slots:{default:[Yi]},$$scope:{ctx:Ue}}}),D=new b({props:{title:"Symmetric and affine quantization schemes",local:"symmetric-and-affine-quantization-schemes",headingTag:"h3"}}),X=new b({props:{title:"Per-tensor and per-channel quantization",local:"per-tensor-and-per-channel-quantization",headingTag:"h3"}}),te=new b({props:{title:"Calibration",local:"calibration",headingTag:"h3"}}),se=new b({props:{title:"Pratical steps to follow to quantize a model to int8",local:"pratical-steps-to-follow-to-quantize-a-model-to-int8",headingTag:"h3"}}),ce=new b({props:{title:"Supported tools to perform quantization in 🤗 Optimum",local:"supported-tools-to-perform-quantization-in--optimum",headingTag:"h2"}}),de=new b({props:{title:"Going further: How do machines represent numbers?",local:"going-further-how-do-machines-represent-numbers",headingTag:"h2"}}),T=new Oi({props:{$$slots:{default:[en]},$$scope:{ctx:Ue}}}),he=new b({props:{title:"Integer representation",local:"integer-representation",headingTag:"h4"}}),we=new Pe({props:{code:"MTklMjAlM0QlMjAwJTIweCUyMDIlNUU3JTIwJTJCJTIwMCUyMHglMjAyJTVFNiUyMCUyQiUyMDAlMjB4JTIwMiU1RTUlMjAlMkIlMjAxJTIweCUyMDIlNUU0JTIwJTJCJTIwMCUyMHglMjAyJTVFMyUyMCUyQiUyMDAlMjB4JTIwMiU1RTIlMjAlMkIlMjAxJTIweCUyMDIlNUUxJTIwJTJCJTIwMSUyMHglMjAyJTVFMA==",highlighted:'<span class="hljs-attribute">19</span> = <span class="hljs-number">0</span> x <span class="hljs-number">2</span>^<span class="hljs-number">7</span> + <span class="hljs-number">0</span> x <span class="hljs-number">2</span>^<span class="hljs-number">6</span> + <span class="hljs-number">0</span> x <span class="hljs-number">2</span>^<span class="hljs-number">5</span> + <span class="hljs-number">1</span> x <span class="hljs-number">2</span>^<span class="hljs-number">4</span> + <span class="hljs-number">0</span> x <span class="hljs-number">2</span>^<span class="hljs-number">3</span> + <span class="hljs-number">0</span> x <span class="hljs-number">2</span>^<span class="hljs-number">2</span> + <span class="hljs-number">1</span> x <span class="hljs-number">2</span>^<span class="hljs-number">1</span> + <span class="hljs-number">1</span> x <span class="hljs-number">2</span>^<span class="hljs-number">0</span>',wrap:!1}}),$e=new b({props:{title:"Real numbers representation",local:"real-numbers-representation",headingTag:"h4"}}),_e=new Pe({props:{code:"eCUyMCUzRCUyMHNpZ24lMjB4JTIwbWFudGlzc2ElMjB4JTIwKDIlNUVleHBvbmVudCk=",highlighted:'<span class="hljs-keyword">x</span> <span class="hljs-operator">=</span> sign <span class="hljs-keyword">x</span> mantissa <span class="hljs-keyword">x</span> (<span class="hljs-number">2</span>^exponent)',wrap:!1}}),He=new b({props:{title:"References",local:"references",headingTag:"h2"}}),ke=new Xi({props:{source:"https://github.com/huggingface/optimum/blob/main/docs/source/concept_guides/quantization.mdx"}}),{c(){p=l("meta"),v=a(),g=l("p"),w=a(),c(x.$$.fragment),Je=a(),q=l("p"),q.innerHTML=Vt,Se=a(),z=l("p"),z.textContent=Xt,Ae=a(),c(C.$$.fragment),Qe=a(),L=l("p"),L.textContent=Yt,Ne=a(),_=l("ul"),_.innerHTML=ei,Be=a(),H=l("p"),H.innerHTML=ti,Fe=a(),c(j.$$.fragment),Ee=a(),k=l("p"),k.innerHTML=ii,Oe=a(),c(U.$$.fragment),Re=a(),P=l("p"),P.innerHTML=ni,Ze=a(),c(I.$$.fragment),We=a(),J=l("p"),J.innerHTML=ai,De=a(),S=l("ul"),S.innerHTML=oi,Ge=a(),c(A.$$.fragment),Ke=a(),Q=l("p"),Q.innerHTML=li,Ve=a(),N=l("p"),N.innerHTML=si,Xe=a(),c(B.$$.fragment),Ye=a(),F=l("p"),F.textContent=ri,et=a(),E=l("ul"),E.innerHTML=pi,tt=a(),O=l("p"),O.innerHTML=ci,it=a(),c(R.$$.fragment),nt=a(),Z=l("p"),Z.innerHTML=ui,at=a(),c(W.$$.fragment),ot=a(),c($.$$.fragment),lt=a(),c(D.$$.fragment),st=a(),G=l("p"),G.innerHTML=mi,rt=a(),K=l("p"),K.innerHTML=di,pt=a(),V=l("p"),V.innerHTML=fi,ct=a(),c(X.$$.fragment),ut=a(),Y=l("p"),Y.textContent=hi,mt=a(),ee=l("ul"),ee.innerHTML=gi,dt=a(),c(te.$$.fragment),ft=a(),ie=l("p"),ie.innerHTML=bi,ht=a(),ne=l("p"),ne.innerHTML=vi,gt=a(),ae=l("ol"),ae.innerHTML=wi,bt=a(),oe=l("p"),oe.textContent=$i,vt=a(),le=l("ul"),le.innerHTML=Ti,wt=a(),c(se.$$.fragment),$t=a(),re=l("p"),re.innerHTML=yi,Tt=a(),pe=l("ol"),pe.innerHTML=Mi,yt=a(),c(ce.$$.fragment),Mt=a(),ue=l("p"),ue.textContent=xi,xt=a(),me=l("ul"),me.innerHTML=qi,qt=a(),c(de.$$.fragment),zt=a(),c(T.$$.fragment),Ct=a(),fe=l("p"),fe.textContent=zi,Lt=a(),c(he.$$.fragment),_t=a(),ge=l("p"),ge.innerHTML=Ci,Ht=a(),be=l("ol"),be.innerHTML=Li,jt=a(),ve=l("p"),ve.innerHTML=_i,kt=a(),c(we.$$.fragment),Ut=a(),y=l("ol"),y.innerHTML=Hi,Pt=a(),c($e.$$.fragment),It=a(),Te=l("p"),Te.innerHTML=ji,Jt=a(),ye=l("ol"),ye.innerHTML=ki,St=a(),Me=l("p"),Me.textContent=Ui,At=a(),xe=l("ol"),xe.innerHTML=Pi,Qt=a(),qe=l("ul"),qe.innerHTML=Ii,Nt=a(),M=l("ol"),M.innerHTML=Ji,Bt=a(),ze=l("ul"),ze.innerHTML=Si,Ft=a(),Ce=l("p"),Ce.innerHTML=Ai,Et=a(),Le=l("p"),Le.innerHTML=Qi,Ot=a(),c(_e.$$.fragment),Rt=a(),c(He.$$.fragment),Zt=a(),je=l("ul"),je.innerHTML=Ni,Wt=a(),c(ke.$$.fragment),Dt=a(),Ie=l("p"),this.h()},l(e){const t=Ki("svelte-u9bgzb",document.head);p=s(t,"META",{name:!0,content:!0}),t.forEach(i),v=o(e),g=s(e,"P",{}),Ei(g).forEach(i),w=o(e),u(x.$$.fragment,e),Je=o(e),q=s(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-p89nc2"&&(q.innerHTML=Vt),Se=o(e),z=s(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-525bhg"&&(z.textContent=Xt),Ae=o(e),u(C.$$.fragment,e),Qe=o(e),L=s(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-b9e65e"&&(L.textContent=Yt),Ne=o(e),_=s(e,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-1jnatgf"&&(_.innerHTML=ei),Be=o(e),H=s(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1vh20e4"&&(H.innerHTML=ti),Fe=o(e),u(j.$$.fragment,e),Ee=o(e),k=s(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-txsgkq"&&(k.innerHTML=ii),Oe=o(e),u(U.$$.fragment,e),Re=o(e),P=s(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-jca8pk"&&(P.innerHTML=ni),Ze=o(e),u(I.$$.fragment,e),We=o(e),J=s(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1vonttx"&&(J.innerHTML=ai),De=o(e),S=s(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-j3zm40"&&(S.innerHTML=oi),Ge=o(e),u(A.$$.fragment,e),Ke=o(e),Q=s(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-w5smo0"&&(Q.innerHTML=li),Ve=o(e),N=s(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1hvpx8c"&&(N.innerHTML=si),Xe=o(e),u(B.$$.fragment,e),Ye=o(e),F=s(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-uc2av9"&&(F.textContent=ri),et=o(e),E=s(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-55l006"&&(E.innerHTML=pi),tt=o(e),O=s(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-vbg2s5"&&(O.innerHTML=ci),it=o(e),u(R.$$.fragment,e),nt=o(e),Z=s(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-174sqfa"&&(Z.innerHTML=ui),at=o(e),u(W.$$.fragment,e),ot=o(e),u($.$$.fragment,e),lt=o(e),u(D.$$.fragment,e),st=o(e),G=s(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1mcqahw"&&(G.innerHTML=mi),rt=o(e),K=s(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-14zssat"&&(K.innerHTML=di),pt=o(e),V=s(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-vjpm0g"&&(V.innerHTML=fi),ct=o(e),u(X.$$.fragment,e),ut=o(e),Y=s(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-d46ged"&&(Y.textContent=hi),mt=o(e),ee=s(e,"UL",{"data-svelte-h":!0}),r(ee)!=="svelte-1h6e562"&&(ee.innerHTML=gi),dt=o(e),u(te.$$.fragment,e),ft=o(e),ie=s(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1fm4s9k"&&(ie.innerHTML=bi),ht=o(e),ne=s(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-9f9h6s"&&(ne.innerHTML=vi),gt=o(e),ae=s(e,"OL",{"data-svelte-h":!0}),r(ae)!=="svelte-1e9v2jr"&&(ae.innerHTML=wi),bt=o(e),oe=s(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-bp3yi9"&&(oe.textContent=$i),vt=o(e),le=s(e,"UL",{"data-svelte-h":!0}),r(le)!=="svelte-1y2stc2"&&(le.innerHTML=Ti),wt=o(e),u(se.$$.fragment,e),$t=o(e),re=s(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-5xtk1x"&&(re.innerHTML=yi),Tt=o(e),pe=s(e,"OL",{"data-svelte-h":!0}),r(pe)!=="svelte-ej0tmd"&&(pe.innerHTML=Mi),yt=o(e),u(ce.$$.fragment,e),Mt=o(e),ue=s(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-3ofdc8"&&(ue.textContent=xi),xt=o(e),me=s(e,"UL",{"data-svelte-h":!0}),r(me)!=="svelte-163ivnk"&&(me.innerHTML=qi),qt=o(e),u(de.$$.fragment,e),zt=o(e),u(T.$$.fragment,e),Ct=o(e),fe=s(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-h5k7ub"&&(fe.textContent=zi),Lt=o(e),u(he.$$.fragment,e),_t=o(e),ge=s(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-pndq9n"&&(ge.innerHTML=Ci),Ht=o(e),be=s(e,"OL",{"data-svelte-h":!0}),r(be)!=="svelte-s3ctan"&&(be.innerHTML=Li),jt=o(e),ve=s(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-73e7m1"&&(ve.innerHTML=_i),kt=o(e),u(we.$$.fragment,e),Ut=o(e),y=s(e,"OL",{start:!0,"data-svelte-h":!0}),r(y)!=="svelte-1usbjfc"&&(y.innerHTML=Hi),Pt=o(e),u($e.$$.fragment,e),It=o(e),Te=s(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1vnsbhs"&&(Te.innerHTML=ji),Jt=o(e),ye=s(e,"OL",{"data-svelte-h":!0}),r(ye)!=="svelte-acn83z"&&(ye.innerHTML=ki),St=o(e),Me=s(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-vm5l3c"&&(Me.textContent=Ui),At=o(e),xe=s(e,"OL",{"data-svelte-h":!0}),r(xe)!=="svelte-1g2q9e4"&&(xe.innerHTML=Pi),Qt=o(e),qe=s(e,"UL",{"data-svelte-h":!0}),r(qe)!=="svelte-18dzkd8"&&(qe.innerHTML=Ii),Nt=o(e),M=s(e,"OL",{start:!0,"data-svelte-h":!0}),r(M)!=="svelte-48nw91"&&(M.innerHTML=Ji),Bt=o(e),ze=s(e,"UL",{"data-svelte-h":!0}),r(ze)!=="svelte-1gkiele"&&(ze.innerHTML=Si),Ft=o(e),Ce=s(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1ugjpds"&&(Ce.innerHTML=Ai),Et=o(e),Le=s(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-9ui238"&&(Le.innerHTML=Qi),Ot=o(e),u(_e.$$.fragment,e),Rt=o(e),u(He.$$.fragment,e),Zt=o(e),je=s(e,"UL",{"data-svelte-h":!0}),r(je)!=="svelte-ertv4x"&&(je.innerHTML=Ni),Wt=o(e),u(ke.$$.fragment,e),Dt=o(e),Ie=s(e,"P",{}),Ei(Ie).forEach(i),this.h()},h(){Kt(p,"name","hf:doc:metadata"),Kt(p,"content",nn),Kt(y,"start","2"),Kt(M,"start","2")},m(e,t){Vi(document.head,p),n(e,v,t),n(e,g,t),n(e,w,t),m(x,e,t),n(e,Je,t),n(e,q,t),n(e,Se,t),n(e,z,t),n(e,Ae,t),m(C,e,t),n(e,Qe,t),n(e,L,t),n(e,Ne,t),n(e,_,t),n(e,Be,t),n(e,H,t),n(e,Fe,t),m(j,e,t),n(e,Ee,t),n(e,k,t),n(e,Oe,t),m(U,e,t),n(e,Re,t),n(e,P,t),n(e,Ze,t),m(I,e,t),n(e,We,t),n(e,J,t),n(e,De,t),n(e,S,t),n(e,Ge,t),m(A,e,t),n(e,Ke,t),n(e,Q,t),n(e,Ve,t),n(e,N,t),n(e,Xe,t),m(B,e,t),n(e,Ye,t),n(e,F,t),n(e,et,t),n(e,E,t),n(e,tt,t),n(e,O,t),n(e,it,t),m(R,e,t),n(e,nt,t),n(e,Z,t),n(e,at,t),m(W,e,t),n(e,ot,t),m($,e,t),n(e,lt,t),m(D,e,t),n(e,st,t),n(e,G,t),n(e,rt,t),n(e,K,t),n(e,pt,t),n(e,V,t),n(e,ct,t),m(X,e,t),n(e,ut,t),n(e,Y,t),n(e,mt,t),n(e,ee,t),n(e,dt,t),m(te,e,t),n(e,ft,t),n(e,ie,t),n(e,ht,t),n(e,ne,t),n(e,gt,t),n(e,ae,t),n(e,bt,t),n(e,oe,t),n(e,vt,t),n(e,le,t),n(e,wt,t),m(se,e,t),n(e,$t,t),n(e,re,t),n(e,Tt,t),n(e,pe,t),n(e,yt,t),m(ce,e,t),n(e,Mt,t),n(e,ue,t),n(e,xt,t),n(e,me,t),n(e,qt,t),m(de,e,t),n(e,zt,t),m(T,e,t),n(e,Ct,t),n(e,fe,t),n(e,Lt,t),m(he,e,t),n(e,_t,t),n(e,ge,t),n(e,Ht,t),n(e,be,t),n(e,jt,t),n(e,ve,t),n(e,kt,t),m(we,e,t),n(e,Ut,t),n(e,y,t),n(e,Pt,t),m($e,e,t),n(e,It,t),n(e,Te,t),n(e,Jt,t),n(e,ye,t),n(e,St,t),n(e,Me,t),n(e,At,t),n(e,xe,t),n(e,Qt,t),n(e,qe,t),n(e,Nt,t),n(e,M,t),n(e,Bt,t),n(e,ze,t),n(e,Ft,t),n(e,Ce,t),n(e,Et,t),n(e,Le,t),n(e,Ot,t),m(_e,e,t),n(e,Rt,t),m(He,e,t),n(e,Zt,t),n(e,je,t),n(e,Wt,t),m(ke,e,t),n(e,Dt,t),n(e,Ie,t),Gt=!0},p(e,[t]){const Bi={};t&2&&(Bi.$$scope={dirty:t,ctx:e}),$.$set(Bi);const Fi={};t&2&&(Fi.$$scope={dirty:t,ctx:e}),T.$set(Fi)},i(e){Gt||(d(x.$$.fragment,e),d(C.$$.fragment,e),d(j.$$.fragment,e),d(U.$$.fragment,e),d(I.$$.fragment,e),d(A.$$.fragment,e),d(B.$$.fragment,e),d(R.$$.fragment,e),d(W.$$.fragment,e),d($.$$.fragment,e),d(D.$$.fragment,e),d(X.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(ce.$$.fragment,e),d(de.$$.fragment,e),d(T.$$.fragment,e),d(he.$$.fragment,e),d(we.$$.fragment,e),d($e.$$.fragment,e),d(_e.$$.fragment,e),d(He.$$.fragment,e),d(ke.$$.fragment,e),Gt=!0)},o(e){f(x.$$.fragment,e),f(C.$$.fragment,e),f(j.$$.fragment,e),f(U.$$.fragment,e),f(I.$$.fragment,e),f(A.$$.fragment,e),f(B.$$.fragment,e),f(R.$$.fragment,e),f(W.$$.fragment,e),f($.$$.fragment,e),f(D.$$.fragment,e),f(X.$$.fragment,e),f(te.$$.fragment,e),f(se.$$.fragment,e),f(ce.$$.fragment,e),f(de.$$.fragment,e),f(T.$$.fragment,e),f(he.$$.fragment,e),f(we.$$.fragment,e),f($e.$$.fragment,e),f(_e.$$.fragment,e),f(He.$$.fragment,e),f(ke.$$.fragment,e),Gt=!1},d(e){e&&(i(v),i(g),i(w),i(Je),i(q),i(Se),i(z),i(Ae),i(Qe),i(L),i(Ne),i(_),i(Be),i(H),i(Fe),i(Ee),i(k),i(Oe),i(Re),i(P),i(Ze),i(We),i(J),i(De),i(S),i(Ge),i(Ke),i(Q),i(Ve),i(N),i(Xe),i(Ye),i(F),i(et),i(E),i(tt),i(O),i(it),i(nt),i(Z),i(at),i(ot),i(lt),i(st),i(G),i(rt),i(K),i(pt),i(V),i(ct),i(ut),i(Y),i(mt),i(ee),i(dt),i(ft),i(ie),i(ht),i(ne),i(gt),i(ae),i(bt),i(oe),i(vt),i(le),i(wt),i($t),i(re),i(Tt),i(pe),i(yt),i(Mt),i(ue),i(xt),i(me),i(qt),i(zt),i(Ct),i(fe),i(Lt),i(_t),i(ge),i(Ht),i(be),i(jt),i(ve),i(kt),i(Ut),i(y),i(Pt),i(It),i(Te),i(Jt),i(ye),i(St),i(Me),i(At),i(xe),i(Qt),i(qe),i(Nt),i(M),i(Bt),i(ze),i(Ft),i(Ce),i(Et),i(Le),i(Ot),i(Rt),i(Zt),i(je),i(Wt),i(Dt),i(Ie)),i(p),h(x,e),h(C,e),h(j,e),h(U,e),h(I,e),h(A,e),h(B,e),h(R,e),h(W,e),h($,e),h(D,e),h(X,e),h(te,e),h(se,e),h(ce,e),h(de,e),h(T,e),h(he,e),h(we,e),h($e,e),h(_e,e),h(He,e),h(ke,e)}}}const nn='{"title":"Quantization","local":"quantization","sections":[{"title":"Theory","local":"theory","sections":[],"depth":2},{"title":"Quantization","local":"quantization","sections":[{"title":"Quantization to float16","local":"quantization-to-float16","sections":[],"depth":3},{"title":"Quantization to int8","local":"quantization-to-int8","sections":[],"depth":3},{"title":"Symmetric and affine quantization schemes","local":"symmetric-and-affine-quantization-schemes","sections":[],"depth":3},{"title":"Per-tensor and per-channel quantization","local":"per-tensor-and-per-channel-quantization","sections":[],"depth":3},{"title":"Calibration","local":"calibration","sections":[],"depth":3},{"title":"Pratical steps to follow to quantize a model to int8","local":"pratical-steps-to-follow-to-quantize-a-model-to-int8","sections":[],"depth":3}],"depth":2},{"title":"Supported tools to perform quantization in 🤗 Optimum","local":"supported-tools-to-perform-quantization-in--optimum","sections":[],"depth":2},{"title":"Going further: How do machines represent numbers?","local":"going-further-how-do-machines-represent-numbers","sections":[{"title":"Integer representation","local":"integer-representation","sections":[],"depth":4},{"title":"Real numbers representation","local":"real-numbers-representation","sections":[],"depth":4}],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function an(Ue){return Wi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cn extends Di{constructor(p){super(),Gi(this,p,an,tn,Zi,{})}}export{cn as component};
