import{s as Ut,n as It,o as Ct}from"../chunks/scheduler.85c25b89.js";import{S as Zt,i as $t,g as p,s as l,r as i,A as Wt,h as m,f as a,c as n,j as bt,u as o,x as g,k as ft,y as Bt,a as e,v as c,d as r,t as h,w as M}from"../chunks/index.c9bcf812.js";import{C as v}from"../chunks/CodeBlock.94efc595.js";import{H as X}from"../chunks/Heading.3c6e5b17.js";function xt(rt){let d,_,V,A,J,Y,y,ht='An <strong>ECA ResNet</strong> is a variant on a <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNet</a> that utilises an <a href="https://paperswithcode.com/method/efficient-channel-attention" rel="nofollow">Efficient Channel Attention module</a>. Efficient Channel Attention is an architectural unit based on <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation blocks</a> that reduces model complexity without dimensionality reduction.',z,w,H,j,Mt="To load a pretrained model:",F,T,S,u,gt="To load and preprocess the image:",L,b,D,f,dt="To get the model predictions:",q,U,P,I,Jt="To get the top-5 predictions class names:",K,C,O,Z,yt="Replace the model name with the variant you want to use, e.g. <code>ecaresnet101d</code>. You can find the IDs in the model summaries at the top of this page.",tt,$,wt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',st,W,at,B,jt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",et,x,lt,N,Tt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,nt,k,pt,G,ut='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',mt,E,it,Q,ot,R,ct;return J=new X({props:{title:"ECA-ResNet",local:"eca-resnet",headingTag:"h1"}}),w=new X({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new v({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2VjYXJlc25ldDEwMWQnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;ecaresnet101d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new v({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),C=new v({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new X({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),x=new v({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZWNhcmVzbmV0MTAxZCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;ecaresnet101d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),k=new X({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new X({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new v({props:{code:"JTQwbWlzYyU3QndhbmcyMDIwZWNhbmV0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JFQ0EtTmV0JTNBJTIwRWZmaWNpZW50JTIwQ2hhbm5lbCUyMEF0dGVudGlvbiUyMGZvciUyMERlZXAlMjBDb252b2x1dGlvbmFsJTIwTmV1cmFsJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JRaWxvbmclMjBXYW5nJTIwYW5kJTIwQmFuZ2d1JTIwV3UlMjBhbmQlMjBQZW5nZmVpJTIwWmh1JTIwYW5kJTIwUGVpaHVhJTIwTGklMjBhbmQlMjBXYW5nbWVuZyUyMFp1byUyMGFuZCUyMFFpbmdodWElMjBIdSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTkxMC4wMzE1MSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{wang2020ecanet,
      title={ECA-Net: Efficient Channel Attention for Deep Convolutional Neural Networks}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Qilong Wang and Banggu Wu and Pengfei Zhu and Peihua Li and Wangmeng Zuo and Qinghua Hu}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1910.03151}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),{c(){d=p("meta"),_=l(),V=p("p"),A=l(),i(J.$$.fragment),Y=l(),y=p("p"),y.innerHTML=ht,z=l(),i(w.$$.fragment),H=l(),j=p("p"),j.textContent=Mt,F=l(),i(T.$$.fragment),S=l(),u=p("p"),u.textContent=gt,L=l(),i(b.$$.fragment),D=l(),f=p("p"),f.textContent=dt,q=l(),i(U.$$.fragment),P=l(),I=p("p"),I.textContent=Jt,K=l(),i(C.$$.fragment),O=l(),Z=p("p"),Z.innerHTML=yt,tt=l(),$=p("p"),$.innerHTML=wt,st=l(),i(W.$$.fragment),at=l(),B=p("p"),B.textContent=jt,et=l(),i(x.$$.fragment),lt=l(),N=p("p"),N.innerHTML=Tt,nt=l(),i(k.$$.fragment),pt=l(),G=p("p"),G.innerHTML=ut,mt=l(),i(E.$$.fragment),it=l(),i(Q.$$.fragment),ot=l(),R=p("p"),this.h()},l(t){const s=Wt("svelte-u9bgzb",document.head);d=m(s,"META",{name:!0,content:!0}),s.forEach(a),_=n(t),V=m(t,"P",{}),bt(V).forEach(a),A=n(t),o(J.$$.fragment,t),Y=n(t),y=m(t,"P",{"data-svelte-h":!0}),g(y)!=="svelte-1ly2dl5"&&(y.innerHTML=ht),z=n(t),o(w.$$.fragment,t),H=n(t),j=m(t,"P",{"data-svelte-h":!0}),g(j)!=="svelte-18ywhxh"&&(j.textContent=Mt),F=n(t),o(T.$$.fragment,t),S=n(t),u=m(t,"P",{"data-svelte-h":!0}),g(u)!=="svelte-1c2ipa8"&&(u.textContent=gt),L=n(t),o(b.$$.fragment,t),D=n(t),f=m(t,"P",{"data-svelte-h":!0}),g(f)!=="svelte-1n9qsq1"&&(f.textContent=dt),q=n(t),o(U.$$.fragment,t),P=n(t),I=m(t,"P",{"data-svelte-h":!0}),g(I)!=="svelte-19cnvx1"&&(I.textContent=Jt),K=n(t),o(C.$$.fragment,t),O=n(t),Z=m(t,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-r0xl90"&&(Z.innerHTML=yt),tt=n(t),$=m(t,"P",{"data-svelte-h":!0}),g($)!=="svelte-1wmi3ea"&&($.innerHTML=wt),st=n(t),o(W.$$.fragment,t),at=n(t),B=m(t,"P",{"data-svelte-h":!0}),g(B)!=="svelte-9sr7nh"&&(B.textContent=jt),et=n(t),o(x.$$.fragment,t),lt=n(t),N=m(t,"P",{"data-svelte-h":!0}),g(N)!=="svelte-1kguc51"&&(N.innerHTML=Tt),nt=n(t),o(k.$$.fragment,t),pt=n(t),G=m(t,"P",{"data-svelte-h":!0}),g(G)!=="svelte-1n0coha"&&(G.innerHTML=ut),mt=n(t),o(E.$$.fragment,t),it=n(t),o(Q.$$.fragment,t),ot=n(t),R=m(t,"P",{}),bt(R).forEach(a),this.h()},h(){ft(d,"name","hf:doc:metadata"),ft(d,"content",Nt)},m(t,s){Bt(document.head,d),e(t,_,s),e(t,V,s),e(t,A,s),c(J,t,s),e(t,Y,s),e(t,y,s),e(t,z,s),c(w,t,s),e(t,H,s),e(t,j,s),e(t,F,s),c(T,t,s),e(t,S,s),e(t,u,s),e(t,L,s),c(b,t,s),e(t,D,s),e(t,f,s),e(t,q,s),c(U,t,s),e(t,P,s),e(t,I,s),e(t,K,s),c(C,t,s),e(t,O,s),e(t,Z,s),e(t,tt,s),e(t,$,s),e(t,st,s),c(W,t,s),e(t,at,s),e(t,B,s),e(t,et,s),c(x,t,s),e(t,lt,s),e(t,N,s),e(t,nt,s),c(k,t,s),e(t,pt,s),e(t,G,s),e(t,mt,s),c(E,t,s),e(t,it,s),c(Q,t,s),e(t,ot,s),e(t,R,s),ct=!0},p:It,i(t){ct||(r(J.$$.fragment,t),r(w.$$.fragment,t),r(T.$$.fragment,t),r(b.$$.fragment,t),r(U.$$.fragment,t),r(C.$$.fragment,t),r(W.$$.fragment,t),r(x.$$.fragment,t),r(k.$$.fragment,t),r(E.$$.fragment,t),r(Q.$$.fragment,t),ct=!0)},o(t){h(J.$$.fragment,t),h(w.$$.fragment,t),h(T.$$.fragment,t),h(b.$$.fragment,t),h(U.$$.fragment,t),h(C.$$.fragment,t),h(W.$$.fragment,t),h(x.$$.fragment,t),h(k.$$.fragment,t),h(E.$$.fragment,t),h(Q.$$.fragment,t),ct=!1},d(t){t&&(a(_),a(V),a(A),a(Y),a(y),a(z),a(H),a(j),a(F),a(S),a(u),a(L),a(D),a(f),a(q),a(P),a(I),a(K),a(O),a(Z),a(tt),a($),a(st),a(at),a(B),a(et),a(lt),a(N),a(nt),a(pt),a(G),a(mt),a(it),a(ot),a(R)),a(d),M(J,t),M(w,t),M(T,t),M(b,t),M(U,t),M(C,t),M(W,t),M(x,t),M(k,t),M(E,t),M(Q,t)}}}const Nt='{"title":"ECA-ResNet","local":"eca-resnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function kt(rt){return Ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vt extends Zt{constructor(d){super(),$t(this,d,kt,xt,Ut,{})}}export{Vt as component};
