import{s as os,n as ps,o as Cs}from"../chunks/scheduler.37c15a92.js";import{S as is,i as Is,g as e,s as a,r as j,A as cs,h as y,f as M,c as n,j as Js,u as J,x as U,k as ws,y as As,a as t,v as w,d as T,t as o,w as p}from"../chunks/index.2bf4358c.js";import{C as Ts}from"../chunks/CodeBlock.4e987730.js";import{H as K}from"../chunks/Heading.8ada512a.js";import{E as ms}from"../chunks/getInferenceSnippets.0aa3753f.js";function hs(El){let C,ll,D,sl,i,Ml,I,Sl="Now that you’ve explored the potential and limitations of Agentic AI in games, it’s time to get hands-on. In this section, you’ll <strong>build your very own AI Agent to battle in Pokémon-style turn-based combat</strong>, using everything you’ve learned throughout the course.",tl,c,Ql="We’ll break the system into four key building blocks:",al,A,Vl="<li><p><strong>Poke-env:</strong> A Python library designed to train rule-based or reinforcement learning Pokémon bots.</p></li> <li><p><strong>Pokémon Showdown:</strong> An online battle simulator where your agent will fight.</p></li> <li><p><strong>LLMAgentBase:</strong> A custom Python class we’ve built to connect your LLM with the Poke-env battle environment.</p></li> <li><p><strong>TemplateAgent:</strong> A starter template you’ll complete to create your own unique battle agent.</p></li>",nl,m,xl="Let’s explore each of these components in more detail.",el,h,yl,u,Rl='<img src="https://github.com/hsahovic/poke-env/raw/master/rl-gif.gif" alt="Battle gif"/>',Ul,b,ql=`<a href="https://github.com/hsahovic/poke-env" rel="nofollow">Poke-env</a> is a Python interface originally built for training reinforcement learning bots by <a href="https://huggingface.co/hsahovic" rel="nofollow">Haris Sahovic</a>, but we’ve repurposed it for Agentic AI.<br/>
It allows your agent to interact with Pokémon Showdown through a simple API.`,jl,r,zl="It provides a <code>Player</code> class from which your Agent will inherit, covering everything needed to communicate with the graphical interface.",Jl,d,Fl='<strong>Documentation</strong>: <a href="https://poke-env.readthedocs.io/en/stable/" rel="nofollow">poke-env.readthedocs.io</a><br/> <strong>Repository</strong>: <a href="https://github.com/hsahovic/poke-env" rel="nofollow">github.com/hsahovic/poke-env</a>',wl,f,Tl,B,Hl=`<a href="https://pokemonshowdown.com/" rel="nofollow">Pokémon Showdown</a> is an <a href="https://github.com/smogon/Pokemon-Showdown" rel="nofollow">open-source</a> battle simulator where your agent will play live Pokémon battles.<br/>
It provides a full interface to simulate and display battles in real time. In our challenge, your bot will act just like a human player, choosing moves turn by turn.`,ol,_,Ll="We’ve deployed a server that all participants will use to battle. Let’s see who builds the best AI battle Agent!",pl,Z,$l='<strong>Repository</strong>: <a href="https://github.com/smogon/Pokemon-Showdown" rel="nofollow">github.com/smogon/Pokemon-Showdown</a><br/> <strong>Website</strong>: <a href="https://pokemonshowdown.com/" rel="nofollow">pokemonshowdown.com</a>',Cl,v,il,N,Pl=`<code>LLMAgentBase</code> is a Python class that extends the <code>Player</code> class from <strong>Poke-env</strong>.<br/>
It serves as the bridge between your <strong>LLM</strong> and the <strong>Pokémon battle simulator</strong>, handling input/output formatting and maintaining battle context.`,Il,G,Kl="This base agent provides a set of tools (defined in <code>STANDARD_TOOL_SCHEMA</code>) to interact with the environment, including:",cl,g,Dl="<li><code>choose_move</code>: for selecting an attack during battle</li> <li><code>choose_switch</code>: for switching Pokémon</li>",Al,k,Ol="The LLM should use these tools to make decisions during a match.",ml,W,hl,Y,ls="<li><code>choose_move(battle: Battle)</code>: This is the main method invoked each turn. It takes a <code>Battle</code> object and returns an action string based on the LLM’s output.</li>",ul,X,bl,E,ss="<li><p><code>_format_battle_state(battle)</code>: Converts the current battle state into a string, making it suitable for sending to the LLM.</p></li> <li><p><code>_find_move_by_name(battle, move_name)</code>: Finds a move by name, used in LLM responses that call <code>choose_move</code>.</p></li> <li><p><code>_find_pokemon_by_name(battle, pokemon_name)</code>: Locates a specific Pokémon to switch into, based on the LLM’s switch command.</p></li> <li><p><code>_get_llm_decision(battle_state)</code>: This method is abstract in the base class. You’ll need to implement it in your own agent (see next section), where you define how to query the LLM and parse its response.</p></li>",rl,S,Ms="Here’s an excerpt showing how that decision-making works:",dl,Q,fl,V,ts='<strong>Full source code</strong>: <a href="https://huggingface.co/spaces/Jofthomas/twitch_streaming/blob/main/agents.py" rel="nofollow">agents.py</a>',Bl,x,_l,R,as="Now comes the fun part! With LLMAgentBase as your foundation, it’s time to implement your own agent, with your own strategy to climb the leaderboard.",Zl,q,ns='You’ll start from this template and build your own logic. We’ve also provided three <a href="https://huggingface.co/spaces/Jofthomas/twitch_streaming/blob/main/agents.py" rel="nofollow">complete examples</a> using <strong>OpenAI</strong>, <strong>Mistral</strong>, and <strong>Gemini</strong> models to guide you.',vl,z,es="Here’s a simplified version of the template:",Nl,F,Gl,H,ys="This code won’t run out of the box, it’s a blueprint for your custom logic.",gl,L,Us="With all the pieces ready, it’s your turn to build a competitive agent. In the next section, we’ll show how to deploy your agent to our server and battle others in real-time.",kl,$,js="Let the battle begin! 🔥",Wl,P,Yl,O,Xl;return i=new K({props:{title:"Build Your Own Pokémon Battle Agent",local:"build-your-own-pokémon-battle-agent",headingTag:"h1"}}),h=new K({props:{title:"🧠 Poke-env",local:"-poke-env",headingTag:"h2"}}),f=new K({props:{title:"⚔️ Pokémon Showdown",local:"-pokémon-showdown",headingTag:"h2"}}),v=new K({props:{title:"🔌 LLMAgentBase",local:"-llmagentbase",headingTag:"h2"}}),W=new K({props:{title:"🧠 Core Logic",local:"-core-logic",headingTag:"h3"}}),X=new K({props:{title:"🔧 Key Internal Methods",local:"-key-internal-methods",headingTag:"h3"}}),Q=new Ts({props:{code:"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",highlighted:`STANDARD_TOOL_SCHEMA = {
    <span class="hljs-string">&quot;choose_move&quot;</span>: {
        ...
    },
    <span class="hljs-string">&quot;choose_switch&quot;</span>: {
        ...
    },
}

<span class="hljs-keyword">class</span> <span class="hljs-title class_">LLMAgentBase</span>(<span class="hljs-title class_ inherited__">Player</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, *args, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(*args, **kwargs)
        self.standard_tools = STANDARD_TOOL_SCHEMA
        self.battle_history = []

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_format_battle_state</span>(<span class="hljs-params">self, battle: Battle</span>) -&gt; <span class="hljs-built_in">str</span>:
        active_pkmn = battle.active_pokemon
        active_pkmn_info = <span class="hljs-string">f&quot;Your active Pokemon: <span class="hljs-subst">{active_pkmn.species}</span> &quot;</span> \\
                           <span class="hljs-string">f&quot;(Type: <span class="hljs-subst">{<span class="hljs-string">&#x27;/&#x27;</span>.join(<span class="hljs-built_in">map</span>(<span class="hljs-built_in">str</span>, active_pkmn.types))}</span>) &quot;</span> \\
                           <span class="hljs-string">f&quot;HP: <span class="hljs-subst">{active_pkmn.current_hp_fraction * <span class="hljs-number">100</span>:<span class="hljs-number">.1</span>f}</span>% &quot;</span> \\
                           <span class="hljs-string">f&quot;Status: <span class="hljs-subst">{active_pkmn.status.name <span class="hljs-keyword">if</span> active_pkmn.status <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;None&#x27;</span>}</span> &quot;</span> \\
                           <span class="hljs-string">f&quot;Boosts: <span class="hljs-subst">{active_pkmn.boosts}</span>&quot;</span>

        opponent_pkmn = battle.opponent_active_pokemon
        opp_info_str = <span class="hljs-string">&quot;Unknown&quot;</span>
        <span class="hljs-keyword">if</span> opponent_pkmn:
            opp_info_str = <span class="hljs-string">f&quot;<span class="hljs-subst">{opponent_pkmn.species}</span> &quot;</span> \\
                           <span class="hljs-string">f&quot;(Type: <span class="hljs-subst">{<span class="hljs-string">&#x27;/&#x27;</span>.join(<span class="hljs-built_in">map</span>(<span class="hljs-built_in">str</span>, opponent_pkmn.types))}</span>) &quot;</span> \\
                           <span class="hljs-string">f&quot;HP: <span class="hljs-subst">{opponent_pkmn.current_hp_fraction * <span class="hljs-number">100</span>:<span class="hljs-number">.1</span>f}</span>% &quot;</span> \\
                           <span class="hljs-string">f&quot;Status: <span class="hljs-subst">{opponent_pkmn.status.name <span class="hljs-keyword">if</span> opponent_pkmn.status <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;None&#x27;</span>}</span> &quot;</span> \\
                           <span class="hljs-string">f&quot;Boosts: <span class="hljs-subst">{opponent_pkmn.boosts}</span>&quot;</span>
        opponent_pkmn_info = <span class="hljs-string">f&quot;Opponent&#x27;s active Pokemon: <span class="hljs-subst">{opp_info_str}</span>&quot;</span>

        available_moves_info = <span class="hljs-string">&quot;Available moves:\\n&quot;</span>
        <span class="hljs-keyword">if</span> battle.available_moves:
            available_moves_info += <span class="hljs-string">&quot;\\n&quot;</span>.join(
                [<span class="hljs-string">f&quot;- <span class="hljs-subst">{move.<span class="hljs-built_in">id</span>}</span> (Type: <span class="hljs-subst">{move.<span class="hljs-built_in">type</span>}</span>, BP: <span class="hljs-subst">{move.base_power}</span>, Acc: <span class="hljs-subst">{move.accuracy}</span>, PP: <span class="hljs-subst">{move.current_pp}</span>/<span class="hljs-subst">{move.max_pp}</span>, Cat: <span class="hljs-subst">{move.category.name}</span>)&quot;</span>
                 <span class="hljs-keyword">for</span> move <span class="hljs-keyword">in</span> battle.available_moves]
            )
        <span class="hljs-keyword">else</span>:
             available_moves_info += <span class="hljs-string">&quot;- None (Must switch or Struggle)&quot;</span>

        available_switches_info = <span class="hljs-string">&quot;Available switches:\\n&quot;</span>
        <span class="hljs-keyword">if</span> battle.available_switches:
              available_switches_info += <span class="hljs-string">&quot;\\n&quot;</span>.join(
                  [<span class="hljs-string">f&quot;- <span class="hljs-subst">{pkmn.species}</span> (HP: <span class="hljs-subst">{pkmn.current_hp_fraction * <span class="hljs-number">100</span>:<span class="hljs-number">.1</span>f}</span>%, Status: <span class="hljs-subst">{pkmn.status.name <span class="hljs-keyword">if</span> pkmn.status <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;None&#x27;</span>}</span>)&quot;</span>
                   <span class="hljs-keyword">for</span> pkmn <span class="hljs-keyword">in</span> battle.available_switches]
              )
        <span class="hljs-keyword">else</span>:
            available_switches_info += <span class="hljs-string">&quot;- None&quot;</span>

        state_str = <span class="hljs-string">f&quot;<span class="hljs-subst">{active_pkmn_info}</span>\\n&quot;</span> \\
                    <span class="hljs-string">f&quot;<span class="hljs-subst">{opponent_pkmn_info}</span>\\n\\n&quot;</span> \\
                    <span class="hljs-string">f&quot;<span class="hljs-subst">{available_moves_info}</span>\\n\\n&quot;</span> \\
                    <span class="hljs-string">f&quot;<span class="hljs-subst">{available_switches_info}</span>\\n\\n&quot;</span> \\
                    <span class="hljs-string">f&quot;Weather: <span class="hljs-subst">{battle.weather}</span>\\n&quot;</span> \\
                    <span class="hljs-string">f&quot;Terrains: <span class="hljs-subst">{battle.fields}</span>\\n&quot;</span> \\
                    <span class="hljs-string">f&quot;Your Side Conditions: <span class="hljs-subst">{battle.side_conditions}</span>\\n&quot;</span> \\
                    <span class="hljs-string">f&quot;Opponent Side Conditions: <span class="hljs-subst">{battle.opponent_side_conditions}</span>&quot;</span>
        <span class="hljs-keyword">return</span> state_str.strip()

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_find_move_by_name</span>(<span class="hljs-params">self, battle: Battle, move_name: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Optional</span>[Move]:
        normalized_name = normalize_name(move_name)
        <span class="hljs-comment"># Prioritize exact ID match</span>
        <span class="hljs-keyword">for</span> move <span class="hljs-keyword">in</span> battle.available_moves:
            <span class="hljs-keyword">if</span> move.<span class="hljs-built_in">id</span> == normalized_name:
                <span class="hljs-keyword">return</span> move
        <span class="hljs-comment"># Fallback: Check display name (less reliable)</span>
        <span class="hljs-keyword">for</span> move <span class="hljs-keyword">in</span> battle.available_moves:
            <span class="hljs-keyword">if</span> move.name.lower() == move_name.lower():
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Warning: Matched move by display name &#x27;<span class="hljs-subst">{move.name}</span>&#x27; instead of ID &#x27;<span class="hljs-subst">{move.<span class="hljs-built_in">id</span>}</span>&#x27;. Input was &#x27;<span class="hljs-subst">{move_name}</span>&#x27;.&quot;</span>)
                <span class="hljs-keyword">return</span> move
        <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_find_pokemon_by_name</span>(<span class="hljs-params">self, battle: Battle, pokemon_name: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Optional</span>[Pokemon]:
        normalized_name = normalize_name(pokemon_name)
        <span class="hljs-keyword">for</span> pkmn <span class="hljs-keyword">in</span> battle.available_switches:
            <span class="hljs-comment"># Normalize the species name for comparison</span>
            <span class="hljs-keyword">if</span> normalize_name(pkmn.species) == normalized_name:
                <span class="hljs-keyword">return</span> pkmn
        <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>

    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">choose_move</span>(<span class="hljs-params">self, battle: Battle</span>) -&gt; <span class="hljs-built_in">str</span>:
        battle_state_str = self._format_battle_state(battle)
        decision_result = <span class="hljs-keyword">await</span> self._get_llm_decision(battle_state_str)
        <span class="hljs-built_in">print</span>(decision_result)
        decision = decision_result.get(<span class="hljs-string">&quot;decision&quot;</span>)
        error_message = decision_result.get(<span class="hljs-string">&quot;error&quot;</span>)
        action_taken = <span class="hljs-literal">False</span>
        fallback_reason = <span class="hljs-string">&quot;&quot;</span>

        <span class="hljs-keyword">if</span> decision:
            function_name = decision.get(<span class="hljs-string">&quot;name&quot;</span>)
            args = decision.get(<span class="hljs-string">&quot;arguments&quot;</span>, {})
            <span class="hljs-keyword">if</span> function_name == <span class="hljs-string">&quot;choose_move&quot;</span>:
                move_name = args.get(<span class="hljs-string">&quot;move_name&quot;</span>)
                <span class="hljs-keyword">if</span> move_name:
                    chosen_move = self._find_move_by_name(battle, move_name)
                    <span class="hljs-keyword">if</span> chosen_move <span class="hljs-keyword">and</span> chosen_move <span class="hljs-keyword">in</span> battle.available_moves:
                        action_taken = <span class="hljs-literal">True</span>
                        chat_msg = <span class="hljs-string">f&quot;AI Decision: Using move &#x27;<span class="hljs-subst">{chosen_move.<span class="hljs-built_in">id</span>}</span>&#x27;.&quot;</span>
                        <span class="hljs-built_in">print</span>(chat_msg)
                        <span class="hljs-keyword">return</span> self.create_order(chosen_move)
                    <span class="hljs-keyword">else</span>:
                        fallback_reason = <span class="hljs-string">f&quot;LLM chose unavailable/invalid move &#x27;<span class="hljs-subst">{move_name}</span>&#x27;.&quot;</span>
                <span class="hljs-keyword">else</span>:
                     fallback_reason = <span class="hljs-string">&quot;LLM &#x27;choose_move&#x27; called without &#x27;move_name&#x27;.&quot;</span>
            <span class="hljs-keyword">elif</span> function_name == <span class="hljs-string">&quot;choose_switch&quot;</span>:
                pokemon_name = args.get(<span class="hljs-string">&quot;pokemon_name&quot;</span>)
                <span class="hljs-keyword">if</span> pokemon_name:
                    chosen_switch = self._find_pokemon_by_name(battle, pokemon_name)
                    <span class="hljs-keyword">if</span> chosen_switch <span class="hljs-keyword">and</span> chosen_switch <span class="hljs-keyword">in</span> battle.available_switches:
                        action_taken = <span class="hljs-literal">True</span>
                        chat_msg = <span class="hljs-string">f&quot;AI Decision: Switching to &#x27;<span class="hljs-subst">{chosen_switch.species}</span>&#x27;.&quot;</span>
                        <span class="hljs-built_in">print</span>(chat_msg)
                        <span class="hljs-keyword">return</span> self.create_order(chosen_switch)
                    <span class="hljs-keyword">else</span>:
                        fallback_reason = <span class="hljs-string">f&quot;LLM chose unavailable/invalid switch &#x27;<span class="hljs-subst">{pokemon_name}</span>&#x27;.&quot;</span>
                <span class="hljs-keyword">else</span>:
                    fallback_reason = <span class="hljs-string">&quot;LLM &#x27;choose_switch&#x27; called without &#x27;pokemon_name&#x27;.&quot;</span>
            <span class="hljs-keyword">else</span>:
                fallback_reason = <span class="hljs-string">f&quot;LLM called unknown function &#x27;<span class="hljs-subst">{function_name}</span>&#x27;.&quot;</span>

        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> action_taken:
            <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> fallback_reason:
                 <span class="hljs-keyword">if</span> error_message:
                     fallback_reason = <span class="hljs-string">f&quot;API Error: <span class="hljs-subst">{error_message}</span>&quot;</span>
                 <span class="hljs-keyword">elif</span> decision <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
                      fallback_reason = <span class="hljs-string">&quot;LLM did not provide a valid function call.&quot;</span>
                 <span class="hljs-keyword">else</span>:
                      fallback_reason = <span class="hljs-string">&quot;Unknown error processing LLM decision.&quot;</span>

            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Warning: <span class="hljs-subst">{fallback_reason}</span> Choosing random action.&quot;</span>)

            <span class="hljs-keyword">if</span> battle.available_moves <span class="hljs-keyword">or</span> battle.available_switches:
                 <span class="hljs-keyword">return</span> self.choose_random_move(battle)
            <span class="hljs-keyword">else</span>:
                 <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;AI Fallback: No moves or switches available. Using Struggle/Default.&quot;</span>)
                 <span class="hljs-keyword">return</span> self.choose_default_move(battle)

    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">_get_llm_decision</span>(<span class="hljs-params">self, battle_state: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
        <span class="hljs-keyword">raise</span> NotImplementedError(<span class="hljs-string">&quot;Subclasses must implement _get_llm_decision&quot;</span>)`,wrap:!1}}),x=new K({props:{title:"🧪 TemplateAgent",local:"-templateagent",headingTag:"h2"}}),F=new Ts({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">TemplateAgent</span>(<span class="hljs-title class_ inherited__">LLMAgentBase</span>):
    <span class="hljs-string">&quot;&quot;&quot;Uses Template AI API for decisions.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, api_key: <span class="hljs-built_in">str</span> = <span class="hljs-literal">None</span>, model: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;model-name&quot;</span>, *args, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(*args, **kwargs)
        self.model = model
        self.template_client = TemplateModelProvider(api_key=...)
        self.template_tools = <span class="hljs-built_in">list</span>(self.standard_tools.values())

    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">_get_llm_decision</span>(<span class="hljs-params">self, battle_state: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
        <span class="hljs-string">&quot;&quot;&quot;Sends state to the LLM and gets back the function call decision.&quot;&quot;&quot;</span>
        system_prompt = (
            <span class="hljs-string">&quot;You are a ...&quot;</span>
        )
        user_prompt = <span class="hljs-string">f&quot;...&quot;</span>

        <span class="hljs-keyword">try</span>:
            response = <span class="hljs-keyword">await</span> self.template_client.chat.completions.create(
                model=self.model,
                messages=[
                    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: system_prompt},
                    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: user_prompt},
                ],
            )
            message = response.choices[<span class="hljs-number">0</span>].message
            
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;decision&quot;</span>: {<span class="hljs-string">&quot;name&quot;</span>: function_name, <span class="hljs-string">&quot;arguments&quot;</span>: arguments}}

        <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Unexpected error during call: <span class="hljs-subst">{e}</span>&quot;</span>)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;error&quot;</span>: <span class="hljs-string">f&quot;Unexpected error: <span class="hljs-subst">{e}</span>&quot;</span>}`,wrap:!1}}),P=new ms({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/bonus-unit3/building_your_pokemon_agent.mdx"}}),{c(){C=e("meta"),ll=a(),D=e("p"),sl=a(),j(i.$$.fragment),Ml=a(),I=e("p"),I.innerHTML=Sl,tl=a(),c=e("p"),c.textContent=Ql,al=a(),A=e("ul"),A.innerHTML=Vl,nl=a(),m=e("p"),m.textContent=xl,el=a(),j(h.$$.fragment),yl=a(),u=e("p"),u.innerHTML=Rl,Ul=a(),b=e("p"),b.innerHTML=ql,jl=a(),r=e("p"),r.innerHTML=zl,Jl=a(),d=e("p"),d.innerHTML=Fl,wl=a(),j(f.$$.fragment),Tl=a(),B=e("p"),B.innerHTML=Hl,ol=a(),_=e("p"),_.textContent=Ll,pl=a(),Z=e("p"),Z.innerHTML=$l,Cl=a(),j(v.$$.fragment),il=a(),N=e("p"),N.innerHTML=Pl,Il=a(),G=e("p"),G.innerHTML=Kl,cl=a(),g=e("ul"),g.innerHTML=Dl,Al=a(),k=e("p"),k.textContent=Ol,ml=a(),j(W.$$.fragment),hl=a(),Y=e("ul"),Y.innerHTML=ls,ul=a(),j(X.$$.fragment),bl=a(),E=e("ul"),E.innerHTML=ss,rl=a(),S=e("p"),S.textContent=Ms,dl=a(),j(Q.$$.fragment),fl=a(),V=e("p"),V.innerHTML=ts,Bl=a(),j(x.$$.fragment),_l=a(),R=e("p"),R.textContent=as,Zl=a(),q=e("p"),q.innerHTML=ns,vl=a(),z=e("p"),z.textContent=es,Nl=a(),j(F.$$.fragment),Gl=a(),H=e("p"),H.textContent=ys,gl=a(),L=e("p"),L.textContent=Us,kl=a(),$=e("p"),$.textContent=js,Wl=a(),j(P.$$.fragment),Yl=a(),O=e("p"),this.h()},l(l){const s=cs("svelte-u9bgzb",document.head);C=y(s,"META",{name:!0,content:!0}),s.forEach(M),ll=n(l),D=y(l,"P",{}),Js(D).forEach(M),sl=n(l),J(i.$$.fragment,l),Ml=n(l),I=y(l,"P",{"data-svelte-h":!0}),U(I)!=="svelte-15onf7o"&&(I.innerHTML=Sl),tl=n(l),c=y(l,"P",{"data-svelte-h":!0}),U(c)!=="svelte-80pqn7"&&(c.textContent=Ql),al=n(l),A=y(l,"UL",{"data-svelte-h":!0}),U(A)!=="svelte-12bbsbs"&&(A.innerHTML=Vl),nl=n(l),m=y(l,"P",{"data-svelte-h":!0}),U(m)!=="svelte-14tx904"&&(m.textContent=xl),el=n(l),J(h.$$.fragment,l),yl=n(l),u=y(l,"P",{"data-svelte-h":!0}),U(u)!=="svelte-a0rkmd"&&(u.innerHTML=Rl),Ul=n(l),b=y(l,"P",{"data-svelte-h":!0}),U(b)!=="svelte-6k4kyn"&&(b.innerHTML=ql),jl=n(l),r=y(l,"P",{"data-svelte-h":!0}),U(r)!=="svelte-vsvnc8"&&(r.innerHTML=zl),Jl=n(l),d=y(l,"P",{"data-svelte-h":!0}),U(d)!=="svelte-1tn5h7d"&&(d.innerHTML=Fl),wl=n(l),J(f.$$.fragment,l),Tl=n(l),B=y(l,"P",{"data-svelte-h":!0}),U(B)!=="svelte-16cq85o"&&(B.innerHTML=Hl),ol=n(l),_=y(l,"P",{"data-svelte-h":!0}),U(_)!=="svelte-q73emc"&&(_.textContent=Ll),pl=n(l),Z=y(l,"P",{"data-svelte-h":!0}),U(Z)!=="svelte-kkgamm"&&(Z.innerHTML=$l),Cl=n(l),J(v.$$.fragment,l),il=n(l),N=y(l,"P",{"data-svelte-h":!0}),U(N)!=="svelte-1jjw3w5"&&(N.innerHTML=Pl),Il=n(l),G=y(l,"P",{"data-svelte-h":!0}),U(G)!=="svelte-j0gif1"&&(G.innerHTML=Kl),cl=n(l),g=y(l,"UL",{"data-svelte-h":!0}),U(g)!=="svelte-zzfwig"&&(g.innerHTML=Dl),Al=n(l),k=y(l,"P",{"data-svelte-h":!0}),U(k)!=="svelte-tti1gv"&&(k.textContent=Ol),ml=n(l),J(W.$$.fragment,l),hl=n(l),Y=y(l,"UL",{"data-svelte-h":!0}),U(Y)!=="svelte-1hun6po"&&(Y.innerHTML=ls),ul=n(l),J(X.$$.fragment,l),bl=n(l),E=y(l,"UL",{"data-svelte-h":!0}),U(E)!=="svelte-cgbcxh"&&(E.innerHTML=ss),rl=n(l),S=y(l,"P",{"data-svelte-h":!0}),U(S)!=="svelte-s452ne"&&(S.textContent=Ms),dl=n(l),J(Q.$$.fragment,l),fl=n(l),V=y(l,"P",{"data-svelte-h":!0}),U(V)!=="svelte-1opxous"&&(V.innerHTML=ts),Bl=n(l),J(x.$$.fragment,l),_l=n(l),R=y(l,"P",{"data-svelte-h":!0}),U(R)!=="svelte-1d3y92c"&&(R.textContent=as),Zl=n(l),q=y(l,"P",{"data-svelte-h":!0}),U(q)!=="svelte-1gx2s0i"&&(q.innerHTML=ns),vl=n(l),z=y(l,"P",{"data-svelte-h":!0}),U(z)!=="svelte-g3yucj"&&(z.textContent=es),Nl=n(l),J(F.$$.fragment,l),Gl=n(l),H=y(l,"P",{"data-svelte-h":!0}),U(H)!=="svelte-oim3xo"&&(H.textContent=ys),gl=n(l),L=y(l,"P",{"data-svelte-h":!0}),U(L)!=="svelte-1qifh46"&&(L.textContent=Us),kl=n(l),$=y(l,"P",{"data-svelte-h":!0}),U($)!=="svelte-frbzfm"&&($.textContent=js),Wl=n(l),J(P.$$.fragment,l),Yl=n(l),O=y(l,"P",{}),Js(O).forEach(M),this.h()},h(){ws(C,"name","hf:doc:metadata"),ws(C,"content",us)},m(l,s){As(document.head,C),t(l,ll,s),t(l,D,s),t(l,sl,s),w(i,l,s),t(l,Ml,s),t(l,I,s),t(l,tl,s),t(l,c,s),t(l,al,s),t(l,A,s),t(l,nl,s),t(l,m,s),t(l,el,s),w(h,l,s),t(l,yl,s),t(l,u,s),t(l,Ul,s),t(l,b,s),t(l,jl,s),t(l,r,s),t(l,Jl,s),t(l,d,s),t(l,wl,s),w(f,l,s),t(l,Tl,s),t(l,B,s),t(l,ol,s),t(l,_,s),t(l,pl,s),t(l,Z,s),t(l,Cl,s),w(v,l,s),t(l,il,s),t(l,N,s),t(l,Il,s),t(l,G,s),t(l,cl,s),t(l,g,s),t(l,Al,s),t(l,k,s),t(l,ml,s),w(W,l,s),t(l,hl,s),t(l,Y,s),t(l,ul,s),w(X,l,s),t(l,bl,s),t(l,E,s),t(l,rl,s),t(l,S,s),t(l,dl,s),w(Q,l,s),t(l,fl,s),t(l,V,s),t(l,Bl,s),w(x,l,s),t(l,_l,s),t(l,R,s),t(l,Zl,s),t(l,q,s),t(l,vl,s),t(l,z,s),t(l,Nl,s),w(F,l,s),t(l,Gl,s),t(l,H,s),t(l,gl,s),t(l,L,s),t(l,kl,s),t(l,$,s),t(l,Wl,s),w(P,l,s),t(l,Yl,s),t(l,O,s),Xl=!0},p:ps,i(l){Xl||(T(i.$$.fragment,l),T(h.$$.fragment,l),T(f.$$.fragment,l),T(v.$$.fragment,l),T(W.$$.fragment,l),T(X.$$.fragment,l),T(Q.$$.fragment,l),T(x.$$.fragment,l),T(F.$$.fragment,l),T(P.$$.fragment,l),Xl=!0)},o(l){o(i.$$.fragment,l),o(h.$$.fragment,l),o(f.$$.fragment,l),o(v.$$.fragment,l),o(W.$$.fragment,l),o(X.$$.fragment,l),o(Q.$$.fragment,l),o(x.$$.fragment,l),o(F.$$.fragment,l),o(P.$$.fragment,l),Xl=!1},d(l){l&&(M(ll),M(D),M(sl),M(Ml),M(I),M(tl),M(c),M(al),M(A),M(nl),M(m),M(el),M(yl),M(u),M(Ul),M(b),M(jl),M(r),M(Jl),M(d),M(wl),M(Tl),M(B),M(ol),M(_),M(pl),M(Z),M(Cl),M(il),M(N),M(Il),M(G),M(cl),M(g),M(Al),M(k),M(ml),M(hl),M(Y),M(ul),M(bl),M(E),M(rl),M(S),M(dl),M(fl),M(V),M(Bl),M(_l),M(R),M(Zl),M(q),M(vl),M(z),M(Nl),M(Gl),M(H),M(gl),M(L),M(kl),M($),M(Wl),M(Yl),M(O)),M(C),p(i,l),p(h,l),p(f,l),p(v,l),p(W,l),p(X,l),p(Q,l),p(x,l),p(F,l),p(P,l)}}}const us='{"title":"Build Your Own Pokémon Battle Agent","local":"build-your-own-pokémon-battle-agent","sections":[{"title":"🧠 Poke-env","local":"-poke-env","sections":[],"depth":2},{"title":"⚔️ Pokémon Showdown","local":"-pokémon-showdown","sections":[],"depth":2},{"title":"🔌 LLMAgentBase","local":"-llmagentbase","sections":[{"title":"🧠 Core Logic","local":"-core-logic","sections":[],"depth":3},{"title":"🔧 Key Internal Methods","local":"-key-internal-methods","sections":[],"depth":3}],"depth":2},{"title":"🧪 TemplateAgent","local":"-templateagent","sections":[],"depth":2}],"depth":1}';function bs(El){return Cs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zs extends is{constructor(C){super(),Is(this,C,bs,hs,os,{})}}export{Zs as component};
