import{s as Ps,n as Ks,o as Ds}from"../chunks/scheduler.37c15a92.js";import{S as Os,i as te,g as o,s as a,r as w,m as Ls,A as se,h as p,f as e,c as n,j as ys,u as c,x as i,n as Ys,k as mt,y as ht,a as l,v as r,d as M,t as u,w as d}from"../chunks/index.2bf4358c.js";import{C as J}from"../chunks/CodeBlock.4e987730.js";import{H as T}from"../chunks/Heading.8ada512a.js";import{E as ee}from"../chunks/getInferenceSnippets.0aa3753f.js";function le(ms){let m,jt,dt,Jt,f,Tt,U,hs="A workflow in LlamaIndex provides a structured way to organize your code into sequential and manageable steps.",ft,b,js=`Such a workflow is created by defining <code>Steps</code> which are triggered by <code>Events</code>, and themselves emit <code>Events</code> to trigger further steps.
Let’s take a look at Alfred showing a LlamaIndex workflow for a RAG task.`,Ut,C,Js='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/workflows.png" alt="Workflow Schematic"/>',bt,I,Ts="<strong>Workflows offer several key benefits:</strong>",Ct,g,fs="<li>Clear organization of code into discrete steps</li> <li>Event-driven architecture for flexible control flow</li> <li>Type-safe communication between steps</li> <li>Built-in state management</li> <li>Support for both simple and complex agent interactions</li>",It,k,Us="As you might have guessed, <strong>workflows strike a great balance between the autonomy of agents while maintaining control over the overall workflow.</strong>",gt,B,bs="So, let’s learn how to create a workflow ourselves!",kt,v,Bt,h,Cs='<p>You can follow the code in <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/llama-index/workflows.ipynb" target="_blank">this notebook</a> that you can run using Google Colab.</p>',vt,Z,Zt,y,Mt,Is="Install the Workflow package",us,G,gs="section on the LlamaHub",ds,_,Gt,x,ks=`We can create a single-step workflow by defining a class that inherits from <code>Workflow</code> and decorating your functions with <code>@step</code>.
We will also need to add <code>StartEvent</code> and <code>StopEvent</code>, which are special events that are used to indicate the start and end of the workflow.`,_t,E,xt,W,Bs="As you can see, we can now run the workflow by calling <code>w.run()</code>.",Et,V,Wt,Q,vs=`To connect multiple steps, we <strong>create custom events that carry data between steps.</strong>
To do so, we need to add an <code>Event</code> that is passed between the steps and transfers the output of the first step to the second step.`,Vt,S,Qt,$,Zs="The type hinting is important here, as it ensures that the workflow is executed correctly. Let’s complicate things a bit more!",St,H,$t,A,Gs="The type hinting is the most powerful part of workflows because it allows us to create branches, loops, and joins to facilitate more complex workflows.",Ht,F,_s=`Let’s show an example of <strong>creating a loop</strong> by using the union operator <code>|</code>.
In the example below, we see that the <code>LoopEvent</code> is taken as input for the step and can also be returned as output.`,At,X,Ft,q,Xt,R,xs="We can also draw workflows. Let’s use the <code>draw_all_possible_flows</code> function to draw the workflow. This stores the workflow in an HTML file.",qt,N,Rt,z,Es='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/workflow-draw.png" alt="workflow drawing"/>',Nt,L,Ws="There is one last cool trick that we will cover in the course, which is the ability to add state to the workflow.",zt,Y,Lt,P,Vs=`State management is useful when you want to keep track of the state of the workflow, so that every step has access to the same state.
We can do this by using the <code>Context</code> type hint on top of a parameter in the step function.`,Yt,K,Pt,D,Qs="Great! Now you know how to create basic workflows in LlamaIndex!",Kt,j,Ss='<p>There are some more complex nuances to workflows, which you can learn about in <a href="https://docs.llamaindex.ai/en/stable/understanding/workflows/">the LlamaIndex documentation</a>.</p>',Dt,O,$s="However, there is another way to create workflows, which relies on the <code>AgentWorkflow</code> class. Let’s take a look at how we can use this to create a multi-agent workflow.",Ot,tt,ts,st,Hs=`Instead of manual workflow creation, we can use the <strong><code>AgentWorkflow</code> class to create a multi-agent workflow</strong>.
The <code>AgentWorkflow</code> uses Workflow Agents to allow you to create a system of one or more agents that can collaborate and hand off tasks to each other based on their specialized capabilities.
This enables building complex agent systems where different agents handle different aspects of a task.
Instead of importing classes from <code>llama_index.core.agent</code>, we will import the agent classes from <code>llama_index.core.agent.workflow</code>.
One agent must be designated as the root agent in the <code>AgentWorkflow</code> constructor.
When a user message comes in, it is first routed to the root agent.`,ss,et,As="Each agent can then:",es,lt,Fs="<li>Handle the request directly using their tools</li> <li>Handoff to another agent better suited for the task</li> <li>Return a response to the user</li>",ls,at,Xs="Let’s see how to create a multi-agent workflow.",as,nt,ns,ot,qs=`Agent tools can also modify the workflow state we mentioned earlier. Before starting the workflow, we can provide an initial state dict that will be available to all agents.
The state is stored in the state key of the workflow context. It will be injected into the state_prompt which augments each new user message.`,os,pt,Rs="Let’s inject a counter to count function calls by modifying the previous example:",ps,it,is,wt,Ns="Congratulations! You have now mastered the basics of Agents in LlamaIndex! 🎉",ws,ct,zs="Let’s continue with one final quiz to solidify your knowledge! 🚀",cs,rt,rs,yt,Ms;return f=new T({props:{title:"Creating agentic workflows in LlamaIndex",local:"creating-agentic-workflows-in-llamaindex",headingTag:"h1"}}),v=new T({props:{title:"Creating Workflows",local:"creating-workflows",headingTag:"h2"}}),Z=new T({props:{title:"Basic Workflow Creation",local:"basic-workflow-creation",headingTag:"h3"}}),_=new J({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxsYW1hLWluZGV4LXV0aWxzLXdvcmtmbG93",highlighted:"pip install llama-index-utils-workflow",wrap:!1}}),E=new J({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBTdGFydEV2ZW50JTJDJTIwU3RvcEV2ZW50JTJDJTIwV29ya2Zsb3clMkMlMjBzdGVwJTBBJTBBY2xhc3MlMjBNeVdvcmtmbG93KFdvcmtmbG93KSUzQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMG15X3N0ZXAoc2VsZiUyQyUyMGV2JTNBJTIwU3RhcnRFdmVudCklMjAtJTNFJTIwU3RvcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZG8lMjBzb21ldGhpbmclMjBoZXJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRCUyMkhlbGxvJTJDJTIwd29ybGQhJTIyKSUwQSUwQSUwQXclMjAlM0QlMjBNeVdvcmtmbG93KHRpbWVvdXQlM0QxMCUyQyUyMHZlcmJvc2UlM0RGYWxzZSklMEFyZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHcucnVuKCk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> StartEvent, StopEvent, Workflow, step

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">my_step</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># do something here</span>
        <span class="hljs-keyword">return</span> StopEvent(result=<span class="hljs-string">&quot;Hello, world!&quot;</span>)


w = MyWorkflow(timeout=<span class="hljs-number">10</span>, verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()`,wrap:!1}}),V=new T({props:{title:"Connecting Multiple Steps",local:"connecting-multiple-steps",headingTag:"h3"}}),S=new J({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBFdmVudCUwQSUwQWNsYXNzJTIwUHJvY2Vzc2luZ0V2ZW50KEV2ZW50KSUzQSUwQSUyMCUyMCUyMCUyMGludGVybWVkaWF0ZV9yZXN1bHQlM0ElMjBzdHIlMEElMEFjbGFzcyUyME11bHRpU3RlcFdvcmtmbG93KFdvcmtmbG93KSUzQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMHN0ZXBfb25lKHNlbGYlMkMlMjBldiUzQSUyMFN0YXJ0RXZlbnQpJTIwLSUzRSUyMFByb2Nlc3NpbmdFdmVudCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFByb2Nlc3MlMjBpbml0aWFsJTIwZGF0YSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMFByb2Nlc3NpbmdFdmVudChpbnRlcm1lZGlhdGVfcmVzdWx0JTNEJTIyU3RlcCUyMDElMjBjb21wbGV0ZSUyMiklMEElMEElMjAlMjAlMjAlMjAlNDBzdGVwJTBBJTIwJTIwJTIwJTIwYXN5bmMlMjBkZWYlMjBzdGVwX3R3byhzZWxmJTJDJTIwZXYlM0ElMjBQcm9jZXNzaW5nRXZlbnQpJTIwLSUzRSUyMFN0b3BFdmVudCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFVzZSUyMHRoZSUyMGludGVybWVkaWF0ZSUyMHJlc3VsdCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZpbmFsX3Jlc3VsdCUyMCUzRCUyMGYlMjJGaW5pc2hlZCUyMHByb2Nlc3NpbmclM0ElMjAlN0Jldi5pbnRlcm1lZGlhdGVfcmVzdWx0JTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRGZpbmFsX3Jlc3VsdCklMEElMEF3JTIwJTNEJTIwTXVsdGlTdGVwV29ya2Zsb3codGltZW91dCUzRDEwJTJDJTIwdmVyYm9zZSUzREZhbHNlKSUwQXJlc3VsdCUyMCUzRCUyMGF3YWl0JTIwdy5ydW4oKSUwQXJlc3VsdA==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Event

<span class="hljs-keyword">class</span> <span class="hljs-title class_">ProcessingEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    intermediate_result: <span class="hljs-built_in">str</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiStepWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_one</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; ProcessingEvent:
        <span class="hljs-comment"># Process initial data</span>
        <span class="hljs-keyword">return</span> ProcessingEvent(intermediate_result=<span class="hljs-string">&quot;Step 1 complete&quot;</span>)

<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_two</span>(<span class="hljs-params">self, ev: ProcessingEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># Use the intermediate result</span>
        final_result = <span class="hljs-string">f&quot;Finished processing: <span class="hljs-subst">{ev.intermediate_result}</span>&quot;</span>
        <span class="hljs-keyword">return</span> StopEvent(result=final_result)

w = MultiStepWorkflow(timeout=<span class="hljs-number">10</span>, verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()
result`,wrap:!1}}),H=new T({props:{title:"Loops and Branches",local:"loops-and-branches",headingTag:"h3"}}),X=new J({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBFdmVudCUwQWltcG9ydCUyMHJhbmRvbSUwQSUwQSUwQWNsYXNzJTIwUHJvY2Vzc2luZ0V2ZW50KEV2ZW50KSUzQSUwQSUyMCUyMCUyMCUyMGludGVybWVkaWF0ZV9yZXN1bHQlM0ElMjBzdHIlMEElMEElMEFjbGFzcyUyMExvb3BFdmVudChFdmVudCklM0ElMEElMjAlMjAlMjAlMjBsb29wX291dHB1dCUzQSUyMHN0ciUwQSUwQSUwQWNsYXNzJTIwTXVsdGlTdGVwV29ya2Zsb3coV29ya2Zsb3cpJTNBJTBBJTIwJTIwJTIwJTIwJTQwc3RlcCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc3RlcF9vbmUoc2VsZiUyQyUyMGV2JTNBJTIwU3RhcnRFdmVudCUyMCU3QyUyMExvb3BFdmVudCklMjAtJTNFJTIwUHJvY2Vzc2luZ0V2ZW50JTIwJTdDJTIwTG9vcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjByYW5kb20ucmFuZGludCgwJTJDJTIwMSklMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyQmFkJTIwdGhpbmclMjBoYXBwZW5lZCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBMb29wRXZlbnQobG9vcF9vdXRwdXQlM0QlMjJCYWNrJTIwdG8lMjBzdGVwJTIwb25lLiUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyR29vZCUyMHRoaW5nJTIwaGFwcGVuZWQlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwUHJvY2Vzc2luZ0V2ZW50KGludGVybWVkaWF0ZV9yZXN1bHQlM0QlMjJGaXJzdCUyMHN0ZXAlMjBjb21wbGV0ZS4lMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTQwc3RlcCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc3RlcF90d28oc2VsZiUyQyUyMGV2JTNBJTIwUHJvY2Vzc2luZ0V2ZW50KSUyMC0lM0UlMjBTdG9wRXZlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBVc2UlMjB0aGUlMjBpbnRlcm1lZGlhdGUlMjByZXN1bHQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmaW5hbF9yZXN1bHQlMjAlM0QlMjBmJTIyRmluaXNoZWQlMjBwcm9jZXNzaW5nJTNBJTIwJTdCZXYuaW50ZXJtZWRpYXRlX3Jlc3VsdCU3RCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMFN0b3BFdmVudChyZXN1bHQlM0RmaW5hbF9yZXN1bHQpJTBBJTBBJTBBdyUyMCUzRCUyME11bHRpU3RlcFdvcmtmbG93KHZlcmJvc2UlM0RGYWxzZSklMEFyZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHcucnVuKCklMEFyZXN1bHQ=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Event
<span class="hljs-keyword">import</span> random


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ProcessingEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    intermediate_result: <span class="hljs-built_in">str</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoopEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    loop_output: <span class="hljs-built_in">str</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiStepWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_one</span>(<span class="hljs-params">self, ev: StartEvent | LoopEvent</span>) -&gt; ProcessingEvent | LoopEvent:
        <span class="hljs-keyword">if</span> random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>) == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Bad thing happened&quot;</span>)
            <span class="hljs-keyword">return</span> LoopEvent(loop_output=<span class="hljs-string">&quot;Back to step one.&quot;</span>)
        <span class="hljs-keyword">else</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Good thing happened&quot;</span>)
            <span class="hljs-keyword">return</span> ProcessingEvent(intermediate_result=<span class="hljs-string">&quot;First step complete.&quot;</span>)

<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_two</span>(<span class="hljs-params">self, ev: ProcessingEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># Use the intermediate result</span>
        final_result = <span class="hljs-string">f&quot;Finished processing: <span class="hljs-subst">{ev.intermediate_result}</span>&quot;</span>
        <span class="hljs-keyword">return</span> StopEvent(result=final_result)


w = MultiStepWorkflow(verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()
result`,wrap:!1}}),q=new T({props:{title:"Drawing Workflows",local:"drawing-workflows",headingTag:"h3"}}),N=new J({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LnV0aWxzLndvcmtmbG93JTIwaW1wb3J0JTIwZHJhd19hbGxfcG9zc2libGVfZmxvd3MlMEElMEF3JTIwJTNEJTIwLi4uJTIwJTIzJTIwYXMlMjBkZWZpbmVkJTIwaW4lMjB0aGUlMjBwcmV2aW91cyUyMHNlY3Rpb24lMEFkcmF3X2FsbF9wb3NzaWJsZV9mbG93cyh3JTJDJTIwJTIyZmxvdy5odG1sJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.utils.workflow <span class="hljs-keyword">import</span> draw_all_possible_flows

w = ... <span class="hljs-comment"># as defined in the previous section</span>
draw_all_possible_flows(w, <span class="hljs-string">&quot;flow.html&quot;</span>)`,wrap:!1}}),Y=new T({props:{title:"State Management",local:"state-management",headingTag:"h3"}}),K=new J({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBDb250ZXh0JTJDJTIwU3RhcnRFdmVudCUyQyUyMFN0b3BFdmVudCUwQSUwQSUwQSU0MHN0ZXAlMEFhc3luYyUyMGRlZiUyMHF1ZXJ5KHNlbGYlMkMlMjBjdHglM0ElMjBDb250ZXh0JTJDJTIwZXYlM0ElMjBTdGFydEV2ZW50KSUyMC0lM0UlMjBTdG9wRXZlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBzdG9yZSUyMHF1ZXJ5JTIwaW4lMjB0aGUlMjBjb250ZXh0JTBBJTIwJTIwJTIwJTIwYXdhaXQlMjBjdHguc3RvcmUuc2V0KCUyMnF1ZXJ5JTIyJTJDJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGRvJTIwc29tZXRoaW5nJTIwd2l0aCUyMGNvbnRleHQlMjBhbmQlMjBldmVudCUwQSUyMCUyMCUyMCUyMHZhbCUyMCUzRCUyMC4uLiUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMHJldHJpZXZlJTIwcXVlcnklMjBmcm9tJTIwdGhlJTIwY29udGV4dCUwQSUyMCUyMCUyMCUyMHF1ZXJ5JTIwJTNEJTIwYXdhaXQlMjBjdHguc3RvcmUuZ2V0KCUyMnF1ZXJ5JTIyKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMFN0b3BFdmVudChyZXN1bHQlM0R2YWwp",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context, StartEvent, StopEvent


<span class="hljs-meta">@step</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">query</span>(<span class="hljs-params">self, ctx: Context, ev: StartEvent</span>) -&gt; StopEvent:
    <span class="hljs-comment"># store query in the context</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;What is the capital of France?&quot;</span>)

    <span class="hljs-comment"># do something with context and event</span>
    val = ...

    <span class="hljs-comment"># retrieve query from the context</span>
    query = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;query&quot;</span>)

    <span class="hljs-keyword">return</span> StopEvent(result=val)`,wrap:!1}}),tt=new T({props:{title:"Automating workflows with Multi-Agent Workflows",local:"automating-workflows-with-multi-agent-workflows",headingTag:"h2"}}),nt=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.agent.workflow <span class="hljs-keyword">import</span> AgentWorkflow, ReActAgent
<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

<span class="hljs-comment"># Define some tools</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Add two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a + b

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

<span class="hljs-comment"># we can pass functions directly without FunctionTool -- the fn/docstring are parsed for the name/description</span>
multiply_agent = ReActAgent(
    name=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Is able to multiply two integers&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;A helpful assistant that can use a tool to multiply numbers.&quot;</span>,
    tools=[multiply],
    llm=llm,
)

addition_agent = ReActAgent(
    name=<span class="hljs-string">&quot;add_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Is able to add two integers&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;A helpful assistant that can use a tool to add numbers.&quot;</span>,
    tools=[add],
    llm=llm,
)

<span class="hljs-comment"># Create the workflow</span>
workflow = AgentWorkflow(
    agents=[multiply_agent, addition_agent],
    root_agent=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
)

<span class="hljs-comment"># Run the system</span>
response = <span class="hljs-keyword">await</span> workflow.run(user_msg=<span class="hljs-string">&quot;Can you add 5 and 3?&quot;</span>)`,wrap:!1}}),it=new J({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context

<span class="hljs-comment"># Define some tools</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">ctx: Context, a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Add two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># update our count</span>
    cur_state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
    cur_state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>] += <span class="hljs-number">1</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;state&quot;</span>, cur_state)

    <span class="hljs-keyword">return</span> a + b

<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">ctx: Context, a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># update our count</span>
    cur_state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
    cur_state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>] += <span class="hljs-number">1</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;state&quot;</span>, cur_state)

    <span class="hljs-keyword">return</span> a * b

...

workflow = AgentWorkflow(
    agents=[multiply_agent, addition_agent],
    root_agent=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
    initial_state={<span class="hljs-string">&quot;num_fn_calls&quot;</span>: <span class="hljs-number">0</span>},
    state_prompt=<span class="hljs-string">&quot;Current state: {state}. User message: {msg}&quot;</span>,
)

<span class="hljs-comment"># run the workflow with context</span>
ctx = Context(workflow)
response = <span class="hljs-keyword">await</span> workflow.run(user_msg=<span class="hljs-string">&quot;Can you add 5 and 3?&quot;</span>, ctx=ctx)

<span class="hljs-comment"># pull out and inspect the state</span>
state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
<span class="hljs-built_in">print</span>(state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>])`,wrap:!1}}),rt=new ee({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/llama-index/workflows.mdx"}}),{c(){m=o("meta"),jt=a(),dt=o("p"),Jt=a(),w(f.$$.fragment),Tt=a(),U=o("p"),U.textContent=hs,ft=a(),b=o("p"),b.innerHTML=js,Ut=a(),C=o("p"),C.innerHTML=Js,bt=a(),I=o("p"),I.innerHTML=Ts,Ct=a(),g=o("ul"),g.innerHTML=fs,It=a(),k=o("p"),k.innerHTML=Us,gt=a(),B=o("p"),B.textContent=bs,kt=a(),w(v.$$.fragment),Bt=a(),h=o("blockquote"),h.innerHTML=Cs,vt=a(),w(Z.$$.fragment),Zt=a(),y=o("details"),Mt=o("summary"),Mt.textContent=Is,us=Ls(`
As introduced in the `),G=o("a"),G.textContent=gs,ds=Ls(`, we can install the Workflow package with the following command:

	`),w(_.$$.fragment),Gt=a(),x=o("p"),x.innerHTML=ks,_t=a(),w(E.$$.fragment),xt=a(),W=o("p"),W.innerHTML=Bs,Et=a(),w(V.$$.fragment),Wt=a(),Q=o("p"),Q.innerHTML=vs,Vt=a(),w(S.$$.fragment),Qt=a(),$=o("p"),$.textContent=Zs,St=a(),w(H.$$.fragment),$t=a(),A=o("p"),A.textContent=Gs,Ht=a(),F=o("p"),F.innerHTML=_s,At=a(),w(X.$$.fragment),Ft=a(),w(q.$$.fragment),Xt=a(),R=o("p"),R.innerHTML=xs,qt=a(),w(N.$$.fragment),Rt=a(),z=o("p"),z.innerHTML=Es,Nt=a(),L=o("p"),L.textContent=Ws,zt=a(),w(Y.$$.fragment),Lt=a(),P=o("p"),P.innerHTML=Vs,Yt=a(),w(K.$$.fragment),Pt=a(),D=o("p"),D.textContent=Qs,Kt=a(),j=o("blockquote"),j.innerHTML=Ss,Dt=a(),O=o("p"),O.innerHTML=$s,Ot=a(),w(tt.$$.fragment),ts=a(),st=o("p"),st.innerHTML=Hs,ss=a(),et=o("p"),et.textContent=As,es=a(),lt=o("ul"),lt.innerHTML=Fs,ls=a(),at=o("p"),at.textContent=Xs,as=a(),w(nt.$$.fragment),ns=a(),ot=o("p"),ot.textContent=qs,os=a(),pt=o("p"),pt.textContent=Rs,ps=a(),w(it.$$.fragment),is=a(),wt=o("p"),wt.textContent=Ns,ws=a(),ct=o("p"),ct.textContent=zs,cs=a(),w(rt.$$.fragment),rs=a(),yt=o("p"),this.h()},l(t){const s=se("svelte-u9bgzb",document.head);m=p(s,"META",{name:!0,content:!0}),s.forEach(e),jt=n(t),dt=p(t,"P",{}),ys(dt).forEach(e),Jt=n(t),c(f.$$.fragment,t),Tt=n(t),U=p(t,"P",{"data-svelte-h":!0}),i(U)!=="svelte-1kssncf"&&(U.textContent=hs),ft=n(t),b=p(t,"P",{"data-svelte-h":!0}),i(b)!=="svelte-1ogtysv"&&(b.innerHTML=js),Ut=n(t),C=p(t,"P",{"data-svelte-h":!0}),i(C)!=="svelte-whmuha"&&(C.innerHTML=Js),bt=n(t),I=p(t,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1ff8id8"&&(I.innerHTML=Ts),Ct=n(t),g=p(t,"UL",{"data-svelte-h":!0}),i(g)!=="svelte-14kaj17"&&(g.innerHTML=fs),It=n(t),k=p(t,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1cddxrt"&&(k.innerHTML=Us),gt=n(t),B=p(t,"P",{"data-svelte-h":!0}),i(B)!=="svelte-i0dazf"&&(B.textContent=bs),kt=n(t),c(v.$$.fragment,t),Bt=n(t),h=p(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(h)!=="svelte-y2ec6g"&&(h.innerHTML=Cs),vt=n(t),c(Z.$$.fragment,t),Zt=n(t),y=p(t,"DETAILS",{});var ut=ys(y);Mt=p(ut,"SUMMARY",{"data-svelte-h":!0}),i(Mt)!=="svelte-1vs5sev"&&(Mt.textContent=Is),us=Ys(ut,`
As introduced in the `),G=p(ut,"A",{href:!0,"data-svelte-h":!0}),i(G)!=="svelte-16phayx"&&(G.textContent=gs),ds=Ys(ut,`, we can install the Workflow package with the following command:

	`),c(_.$$.fragment,ut),ut.forEach(e),Gt=n(t),x=p(t,"P",{"data-svelte-h":!0}),i(x)!=="svelte-1wc9dhn"&&(x.innerHTML=ks),_t=n(t),c(E.$$.fragment,t),xt=n(t),W=p(t,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1x5qg2q"&&(W.innerHTML=Bs),Et=n(t),c(V.$$.fragment,t),Wt=n(t),Q=p(t,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1gl1q10"&&(Q.innerHTML=vs),Vt=n(t),c(S.$$.fragment,t),Qt=n(t),$=p(t,"P",{"data-svelte-h":!0}),i($)!=="svelte-1ssz2vu"&&($.textContent=Zs),St=n(t),c(H.$$.fragment,t),$t=n(t),A=p(t,"P",{"data-svelte-h":!0}),i(A)!=="svelte-7kgjbz"&&(A.textContent=Gs),Ht=n(t),F=p(t,"P",{"data-svelte-h":!0}),i(F)!=="svelte-19z56vc"&&(F.innerHTML=_s),At=n(t),c(X.$$.fragment,t),Ft=n(t),c(q.$$.fragment,t),Xt=n(t),R=p(t,"P",{"data-svelte-h":!0}),i(R)!=="svelte-gq4idr"&&(R.innerHTML=xs),qt=n(t),c(N.$$.fragment,t),Rt=n(t),z=p(t,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1j5vf43"&&(z.innerHTML=Es),Nt=n(t),L=p(t,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1nn9pf"&&(L.textContent=Ws),zt=n(t),c(Y.$$.fragment,t),Lt=n(t),P=p(t,"P",{"data-svelte-h":!0}),i(P)!=="svelte-1a42m1e"&&(P.innerHTML=Vs),Yt=n(t),c(K.$$.fragment,t),Pt=n(t),D=p(t,"P",{"data-svelte-h":!0}),i(D)!=="svelte-ayh2hg"&&(D.textContent=Qs),Kt=n(t),j=p(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(j)!=="svelte-q0pq5d"&&(j.innerHTML=Ss),Dt=n(t),O=p(t,"P",{"data-svelte-h":!0}),i(O)!=="svelte-1f8yr21"&&(O.innerHTML=$s),Ot=n(t),c(tt.$$.fragment,t),ts=n(t),st=p(t,"P",{"data-svelte-h":!0}),i(st)!=="svelte-64dk7s"&&(st.innerHTML=Hs),ss=n(t),et=p(t,"P",{"data-svelte-h":!0}),i(et)!=="svelte-1b9i7pj"&&(et.textContent=As),es=n(t),lt=p(t,"UL",{"data-svelte-h":!0}),i(lt)!=="svelte-bg3pcb"&&(lt.innerHTML=Fs),ls=n(t),at=p(t,"P",{"data-svelte-h":!0}),i(at)!=="svelte-193z3j0"&&(at.textContent=Xs),as=n(t),c(nt.$$.fragment,t),ns=n(t),ot=p(t,"P",{"data-svelte-h":!0}),i(ot)!=="svelte-y63ydc"&&(ot.textContent=qs),os=n(t),pt=p(t,"P",{"data-svelte-h":!0}),i(pt)!=="svelte-k4pfxh"&&(pt.textContent=Rs),ps=n(t),c(it.$$.fragment,t),is=n(t),wt=p(t,"P",{"data-svelte-h":!0}),i(wt)!=="svelte-1rveoqn"&&(wt.textContent=Ns),ws=n(t),ct=p(t,"P",{"data-svelte-h":!0}),i(ct)!=="svelte-u1alm2"&&(ct.textContent=zs),cs=n(t),c(rt.$$.fragment,t),rs=n(t),yt=p(t,"P",{}),ys(yt).forEach(e),this.h()},h(){mt(m,"name","hf:doc:metadata"),mt(m,"content",ae),mt(h,"class","tip"),mt(G,"href","./llama-hub"),mt(j,"class","tip")},m(t,s){ht(document.head,m),l(t,jt,s),l(t,dt,s),l(t,Jt,s),r(f,t,s),l(t,Tt,s),l(t,U,s),l(t,ft,s),l(t,b,s),l(t,Ut,s),l(t,C,s),l(t,bt,s),l(t,I,s),l(t,Ct,s),l(t,g,s),l(t,It,s),l(t,k,s),l(t,gt,s),l(t,B,s),l(t,kt,s),r(v,t,s),l(t,Bt,s),l(t,h,s),l(t,vt,s),r(Z,t,s),l(t,Zt,s),l(t,y,s),ht(y,Mt),ht(y,us),ht(y,G),ht(y,ds),r(_,y,null),l(t,Gt,s),l(t,x,s),l(t,_t,s),r(E,t,s),l(t,xt,s),l(t,W,s),l(t,Et,s),r(V,t,s),l(t,Wt,s),l(t,Q,s),l(t,Vt,s),r(S,t,s),l(t,Qt,s),l(t,$,s),l(t,St,s),r(H,t,s),l(t,$t,s),l(t,A,s),l(t,Ht,s),l(t,F,s),l(t,At,s),r(X,t,s),l(t,Ft,s),r(q,t,s),l(t,Xt,s),l(t,R,s),l(t,qt,s),r(N,t,s),l(t,Rt,s),l(t,z,s),l(t,Nt,s),l(t,L,s),l(t,zt,s),r(Y,t,s),l(t,Lt,s),l(t,P,s),l(t,Yt,s),r(K,t,s),l(t,Pt,s),l(t,D,s),l(t,Kt,s),l(t,j,s),l(t,Dt,s),l(t,O,s),l(t,Ot,s),r(tt,t,s),l(t,ts,s),l(t,st,s),l(t,ss,s),l(t,et,s),l(t,es,s),l(t,lt,s),l(t,ls,s),l(t,at,s),l(t,as,s),r(nt,t,s),l(t,ns,s),l(t,ot,s),l(t,os,s),l(t,pt,s),l(t,ps,s),r(it,t,s),l(t,is,s),l(t,wt,s),l(t,ws,s),l(t,ct,s),l(t,cs,s),r(rt,t,s),l(t,rs,s),l(t,yt,s),Ms=!0},p:Ks,i(t){Ms||(M(f.$$.fragment,t),M(v.$$.fragment,t),M(Z.$$.fragment,t),M(_.$$.fragment,t),M(E.$$.fragment,t),M(V.$$.fragment,t),M(S.$$.fragment,t),M(H.$$.fragment,t),M(X.$$.fragment,t),M(q.$$.fragment,t),M(N.$$.fragment,t),M(Y.$$.fragment,t),M(K.$$.fragment,t),M(tt.$$.fragment,t),M(nt.$$.fragment,t),M(it.$$.fragment,t),M(rt.$$.fragment,t),Ms=!0)},o(t){u(f.$$.fragment,t),u(v.$$.fragment,t),u(Z.$$.fragment,t),u(_.$$.fragment,t),u(E.$$.fragment,t),u(V.$$.fragment,t),u(S.$$.fragment,t),u(H.$$.fragment,t),u(X.$$.fragment,t),u(q.$$.fragment,t),u(N.$$.fragment,t),u(Y.$$.fragment,t),u(K.$$.fragment,t),u(tt.$$.fragment,t),u(nt.$$.fragment,t),u(it.$$.fragment,t),u(rt.$$.fragment,t),Ms=!1},d(t){t&&(e(jt),e(dt),e(Jt),e(Tt),e(U),e(ft),e(b),e(Ut),e(C),e(bt),e(I),e(Ct),e(g),e(It),e(k),e(gt),e(B),e(kt),e(Bt),e(h),e(vt),e(Zt),e(y),e(Gt),e(x),e(_t),e(xt),e(W),e(Et),e(Wt),e(Q),e(Vt),e(Qt),e($),e(St),e($t),e(A),e(Ht),e(F),e(At),e(Ft),e(Xt),e(R),e(qt),e(Rt),e(z),e(Nt),e(L),e(zt),e(Lt),e(P),e(Yt),e(Pt),e(D),e(Kt),e(j),e(Dt),e(O),e(Ot),e(ts),e(st),e(ss),e(et),e(es),e(lt),e(ls),e(at),e(as),e(ns),e(ot),e(os),e(pt),e(ps),e(is),e(wt),e(ws),e(ct),e(cs),e(rs),e(yt)),e(m),d(f,t),d(v,t),d(Z,t),d(_),d(E,t),d(V,t),d(S,t),d(H,t),d(X,t),d(q,t),d(N,t),d(Y,t),d(K,t),d(tt,t),d(nt,t),d(it,t),d(rt,t)}}}const ae='{"title":"Creating agentic workflows in LlamaIndex","local":"creating-agentic-workflows-in-llamaindex","sections":[{"title":"Creating Workflows","local":"creating-workflows","sections":[{"title":"Basic Workflow Creation","local":"basic-workflow-creation","sections":[],"depth":3},{"title":"Connecting Multiple Steps","local":"connecting-multiple-steps","sections":[],"depth":3},{"title":"Loops and Branches","local":"loops-and-branches","sections":[],"depth":3},{"title":"Drawing Workflows","local":"drawing-workflows","sections":[],"depth":3},{"title":"State Management","local":"state-management","sections":[],"depth":3}],"depth":2},{"title":"Automating workflows with Multi-Agent Workflows","local":"automating-workflows-with-multi-agent-workflows","sections":[],"depth":2}],"depth":1}';function ne(ms){return Ds(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class re extends Os{constructor(m){super(),te(this,m,ne,le,Ps,{})}}export{re as component};
