import{s as Ys,f as xl,n as zs,o as Ps}from"../chunks/scheduler.37c15a92.js";import{S as Ds,i as Os,g as i,s as n,r as J,A as Ks,h as M,f as l,c as a,j as Sl,u as r,x as o,k as w,y as en,a as s,v as y,d as U,t as T,w as p}from"../chunks/index.2bf4358c.js";import{C as c}from"../chunks/CodeBlock.4e987730.js";import{C as tn}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as h}from"../chunks/Heading.8ada512a.js";import{E as ln}from"../chunks/getInferenceSnippets.0aa3753f.js";function sn($l){let d,et,Oe,tt,f,lt,b,st,B,Ql="Code agents are the default agent type in <code>smolagents</code>. They generate Python tool calls to perform actions, achieving action representations that are efficient, expressive, and accurate.",nt,v,El="Their streamlined approach reduces the number of required actions, simplifies complex operations, and enables reuse of existing code functions. <code>smolagents</code> provides a lightweight framework for building code agents, implemented in approximately 1,000 lines of code.",at,k,Rl=`<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/code_vs_json_actions.png" alt="Code vs JSON Actions"/>
Graphic from the paper <a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Executable Code Actions Elicit Better LLM Agents</a>`,it,m,ql='<p>If you want to learn more about why code agents are effective, check out <a href="https://huggingface.co/docs/smolagents/en/conceptual_guides/intro_agents#code-agents" target="_blank">this guide</a> from the smolagents documentation.</p>',Mt,A,ot,Z,Xl="In a multi-step agent process, the LLM writes and executes actions, typically involving external tool calls. Traditional approaches use a JSON format to specify tool names and arguments as strings, <strong>which the system must parse to determine which tool to execute</strong>.",Jt,V,Ll='However, research shows that <strong>tool-calling LLMs work more effectively with code directly</strong>. This is a core principle of <code>smolagents</code>, as shown in the diagram above from <a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Executable Code Actions Elicit Better LLM Agents</a>.',rt,G,_l="Writing actions in code rather than JSON offers several key advantages:",yt,W,Yl="<li><strong>Composability</strong>: Easily combine and reuse actions</li> <li><strong>Object Management</strong>: Work directly with complex structures like images</li> <li><strong>Generality</strong>: Express any computationally possible task</li> <li><strong>Natural for LLMs</strong>: High-quality code is already present in LLM training data</li>",Ut,N,Tt,H,zl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/codeagent_docs.png" alt="From https://huggingface.co/docs/smolagents/conceptual_guides/react"/>',pt,F,Pl="The diagram above illustrates how <code>CodeAgent.run()</code> operates, following the ReAct framework we mentioned in Unit 1. The main abstraction for agents in <code>smolagents</code> is a <code>MultiStepAgent</code>, which serves as the core building block. <code>CodeAgent</code> is a special kind of <code>MultiStepAgent</code>, as we will see in an example below.",wt,x,Dl="A <code>CodeAgent</code> performs actions through a cycle of steps, with existing variables and knowledge being incorporated into the agent’s context, which is kept in an execution log:",ct,S,Ol='<li><p>The system prompt is stored in a <code>SystemPromptStep</code>, and the user query is logged in a <code>TaskStep</code>.</p></li> <li><p>Then, the following while loop is executed:</p> <p>2.1 Method <code>agent.write_memory_to_messages()</code> writes the agent’s logs into a list of LLM-readable <a href="https://huggingface.co/docs/transformers/main/en/chat_templating" rel="nofollow">chat messages</a>.</p> <p>2.2 These messages are sent to a <code>Model</code>, which generates a completion.</p> <p>2.3 The completion is parsed to extract the action, which, in our case, should be a code snippet since we’re working with a <code>CodeAgent</code>.</p> <p>2.4 The action is executed.</p> <p>2.5 The results are logged into memory in an <code>ActionStep</code>.</p></li>',ut,$,Kl="At the end of each step, if the agent includes any function calls (in <code>agent.step_callback</code>), they are executed.",ht,Q,dt,g,es='<p>You can follow the code in <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/code_agents.ipynb" target="_blank">this notebook</a> that you can run using Google Colab.</p>',mt,E,ts="Alfred is planning a party at the Wayne family mansion and needs your help to ensure everything goes smoothly. To assist him, we’ll apply what we’ve learned about how a multi-step <code>CodeAgent</code> operates.",gt,R,ls,jt,q,ss="If you haven’t installed <code>smolagents</code> yet, you can do so by running the following command:",Ct,X,It,L,ns="Let’s also login to the Hugging Face Hub to have access to the Serverless Inference API.",ft,_,bt,Y,Bt,z,as="Music is an essential part of a successful party! Alfred needs some help selecting the playlist. Luckily, <code>smolagents</code> has got us covered! We can build an agent capable of searching the web using DuckDuckGo. To give the agent access to this tool, we include it in the tool list when creating the agent.",vt,P,is,kt,D,Ms='For the model, we’ll rely on <code>InferenceClientModel</code>, which provides access to Hugging Face’s <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Serverless Inference API</a>. The default model is <code>&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</code>, which is performant and available for fast inference, but you can select any compatible model from the Hub.',At,O,os="Running an agent is quite straightforward:",Zt,K,Vt,ee,Js="When you run this example, the output will <strong>display a trace of the workflow steps being executed</strong>. It will also print the corresponding Python code with the message:",Gt,te,Wt,le,rs="After a few steps, you’ll see the generated playlist that Alfred can use for the party! 🎵",Nt,se,Ht,ne,ys,Ft,ae,Us="Now that we have selected a playlist, we need to organize the menu for the guests. Again, Alfred can take advantage of <code>smolagents</code> to do so. Here, we use the <code>@tool</code> decorator to define a custom function that acts as a tool. We’ll cover tool creation in more detail later, so for now, we can simply run the code.",xt,ie,Ts="As you can see in the example below, we will create a tool using the <code>@tool</code> decorator and include it in the <code>tools</code> list.",St,Me,$t,oe,ps="The agent will run for a few steps until finding the answer. Precising allowed values in the docstring helps direct agent to <code>occasion</code> argument values which exist and limit hallucinations.",Qt,Je,ws="The menu is ready! 🥗",Et,re,Rt,ye,cs="We have the playlist and menu ready, but we need to check one more crucial detail: preparation time!",qt,Ue,us="Alfred needs to calculate when everything would be ready if he started preparing now, in case they need assistance from other superheroes.",Xt,Te,hs="<code>smolagents</code> specializes in agents that write and execute Python code snippets, offering sandboxed execution for security.",Lt,pe,ds=`<strong>Code execution has strict security measures</strong> - imports outside a predefined safe list are blocked by default. However, you can authorize additional imports by passing them as strings in <code>additional_authorized_imports</code>.
For more details on secure code execution, see the official <a href="https://huggingface.co/docs/smolagents/tutorials/secure_code_execution" rel="nofollow">guide</a>.`,_t,we,ms="When creating the agent, we’ll use <code>additional_authorized_imports</code> to allow for importing the <code>datetime</code> module.",Yt,ce,zt,ue,gs=`These examples are just the beginning of what you can do with code agents, and we’re already starting to see their utility for preparing the party.
You can learn more about how to build code agents in the <a href="https://huggingface.co/docs/smolagents" rel="nofollow">smolagents documentation</a>.`,Pt,he,js="In summary, <code>smolagents</code> specializes in agents that write and execute Python code snippets, offering sandboxed execution for security. It supports both local and API-based language models, making it adaptable to various development environments.",Dt,de,Ot,me,Cs="Wouldn’t it be <strong>amazing to share our very own Alfred agent with the community</strong>? By doing so, anyone can easily download and use the agent directly from the Hub, bringing the ultimate party planner of Gotham to their fingertips! Let’s make it happen! 🎉",Kt,ge,Is="The <code>smolagents</code> library makes this possible by allowing you to share a complete agent with the community and download others for immediate use. It’s as simple as the following:",el,je,tl,Ce,fs="To download the agent again, use the code below:",ll,Ie,sl,fe,bs='What’s also exciting is that shared agents are directly available as Hugging Face Spaces, allowing you to interact with them in real-time. You can explore other agents <a href="https://huggingface.co/spaces/davidberenstein1957/smolagents-and-tools" rel="nofollow">here</a>.',nl,be,Bs='For example, the <em>AlfredAgent</em> is available <a href="https://huggingface.co/spaces/sergiopaniego/AlfredAgent" rel="nofollow">here</a>. You can try it out directly below:',al,u,vs,il,Be,ks="You may be wondering—how did Alfred build such an agent using <code>smolagents</code>? By integrating several tools, he can generate an agent as follows. Don’t worry about the tools for now, as we’ll have a dedicated section later in this unit to explore that in detail:",Ml,ve,ol,ke,As="As you can see, we’ve created a <code>CodeAgent</code> with several tools that enhance the agent’s functionality, turning it into the ultimate party planner ready to share with the community! 🎉",Jl,Ae,Zs="Now, it’s your turn: build your very own agent and share it with the community using the knowledge we’ve just learned! 🕵️‍♂️💡",rl,j,Vs='<p>If you would like to share your agent project, then make a space and tag the <a href="https://huggingface.co/agents-course">agents-course</a> on the Hugging Face Hub. We’d love to see what you’ve created!</p>',yl,Ze,Ul,Ve,Gs="As Alfred fine-tunes the Party Preparator Agent, he’s growing weary of debugging its runs. Agents, by nature, are unpredictable and difficult to inspect. But since he aims to build the ultimate Party Preparator Agent and deploy it in production, he needs robust traceability for future monitoring and analysis.",Tl,Ge,Ws='Once again, <code>smolagents</code> comes to the rescue! It embraces the <a href="https://opentelemetry.io/" rel="nofollow">OpenTelemetry</a> standard for instrumenting agent runs, allowing seamless inspection and logging. With the help of <a href="https://langfuse.com/" rel="nofollow">Langfuse</a> and the <code>SmolagentsInstrumentor</code>, Alfred can easily track and analyze his agent’s behavior.',pl,We,Ns="Setting it up is straightforward!",wl,Ne,Hs="First, we need to install the necessary dependencies:",cl,He,ul,Fe,Fs='Next, Alfred has already created an account on Langfuse and has his API keys ready. If you haven’t done so yet, you can sign up for Langfuse Cloud <a href="https://cloud.langfuse.com/" rel="nofollow">here</a> or explore <a href="https://huggingface.co/docs/smolagents/tutorials/inspect_runs" rel="nofollow">alternatives</a>.',hl,xe,xs="Once you have your API keys, they need to be properly configured as follows:",dl,Se,ml,$e,Ss="With the environment variables set, we can now initialize the Langfuse client. get_client() initializes the Langfuse client using the credentials provided in the environment variables.",gl,Qe,jl,Ee,$s="Finally, Alfred is ready to initialize the <code>SmolagentsInstrumentor</code> and start tracking his agent’s performance.",Cl,Re,Il,qe,Qs="Alfred is now connected 🔌! The runs from <code>smolagents</code> are being logged in Langfuse, giving him full visibility into the agent’s behavior. With this setup, he’s ready to revisit previous runs and refine his Party Preparator Agent even further.",fl,C,Es='<p>To learn more about tracing your agents and using the collected data to evaluate their performance, check out <a href="https://huggingface.co/learn/agents-course/bonus-unit2/introduction">Bonus Unit 2</a>.</p>',bl,Xe,Bl,Le,Rs='Alfred can now access these logs <a href="https://cloud.langfuse.com/project/cm7bq0abj025rad078ak3luwi/traces/995fc019255528e4f48cf6770b0ce27b?timestamp=2025-02-19T10%3A28%3A36.929Z" rel="nofollow">here</a> to review and analyze them.',vl,I,qs='<p>Actually, a minor error occurred during execution. Can you spot it in the logs? Try to track how the agent handles it and still returns a valid answer. <a href="https://cloud.langfuse.com/project/cm7bq0abj025rad078ak3luwi/traces/995fc019255528e4f48cf6770b0ce27b?timestamp=2025-02-19T10%3A28%3A36.929Z&amp;observation=80ca57ace4f69b52">Here</a> is the direct link to the error if you want to verify your answer. Of course the error has been fixed in the meantime, more details can be found in this <a href="https://github.com/huggingface/smolagents/issues/838">issue</a>.</p>',kl,_e,Xs='Meanwhile, the <a href="https://open.spotify.com/playlist/0gZMMHjuxMrrybQ7wTMTpw" rel="nofollow">suggested playlist</a> sets the perfect vibe for the party preparations. Cool, right? 🎶',Al,Zl,Vl,Ye,Ls="Now that we have created our first Code Agent, let’s <strong>learn how we can create Tool Calling Agents</strong>, the second type of agent available in <code>smolagents</code>.",Gl,ze,Wl,Pe,_s='<li><a href="https://huggingface.co/blog/smolagents" rel="nofollow">smolagents Blog</a> - Introduction to smolagents and code interactions</li> <li><a href="https://huggingface.co/docs/smolagents/tutorials/building_good_agents" rel="nofollow">smolagents: Building Good Agents</a> - Best practices for reliable agents</li> <li><a href="https://www.anthropic.com/research/building-effective-agents" rel="nofollow">Building Effective Agents - Anthropic</a> - Agent design principles</li> <li><a href="https://huggingface.co/docs/smolagents/tutorials/inspect_runs" rel="nofollow">Sharing runs with OpenTelemetry</a> - Details about how to setup OpenTelemetry for tracking your agents.</li>',Nl,De,Hl,Ke,Fl;return f=new tn({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/code_agents.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),b=new h({props:{title:"Building Agents That Use Code",local:"building-agents-that-use-code",headingTag:"h1"}}),A=new h({props:{title:"Why Code Agents?",local:"why-code-agents",headingTag:"h2"}}),N=new h({props:{title:"How Does a Code Agent Work?",local:"how-does-a-code-agent-work",headingTag:"h2"}}),Q=new h({props:{title:"Let’s See Some Examples",local:"lets-see-some-examples",headingTag:"h2"}}),X=new c({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNtb2xhZ2VudHMlMjAtVQ==",highlighted:"pip install smolagents -U",wrap:!1}}),_=new c({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBJTBBbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login

login()`,wrap:!1}}),Y=new h({props:{title:"Selecting a Playlist for the Party Using smolagents",local:"selecting-a-playlist-for-the-party-using-smolagents",headingTag:"h3"}}),K=new c({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJEdWNrRHVja0dvU2VhcmNoVG9vbCgpJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQSUwQWFnZW50LnJ1biglMjJTZWFyY2glMjBmb3IlMjB0aGUlMjBiZXN0JTIwbXVzaWMlMjByZWNvbW1lbmRhdGlvbnMlMjBmb3IlMjBhJTIwcGFydHklMjBhdCUyMHRoZSUyMFdheW5lJ3MlMjBtYW5zaW9uLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, InferenceClientModel

agent = CodeAgent(tools=[DuckDuckGoSearchTool()], model=InferenceClientModel())

agent.run(<span class="hljs-string">&quot;Search for the best music recommendations for a party at the Wayne&#x27;s mansion.&quot;</span>)`,wrap:!1}}),te=new c({props:{code:"JTIwJUUyJTk0JTgwJTIwRXhlY3V0aW5nJTIwcGFyc2VkJTIwY29kZSUzQSUyMCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCUyMCUwQSUyMCUyMHJlc3VsdHMlMjAlM0QlMjB3ZWJfc2VhcmNoKHF1ZXJ5JTNEJTIyYmVzdCUyMG11c2ljJTIwZm9yJTIwYSUyMEJhdG1hbiUyMHBhcnR5JTIyKSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMHByaW50KHJlc3VsdHMpJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTIwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJTIw",highlighted:` ─ Executing parsed code: ──────────────────────────────────────────────────────────────────────────────────────── 
  results = web_search(query=<span class="hljs-string">&quot;best music for a Batman party&quot;</span>)                                                      
  <span class="hljs-built_in">print</span>(results)                                                                                                   
 ───────────────────────────────────────────────────────────────────────────────────────────────────────────────── `,wrap:!1}}),se=new h({props:{title:"Using a Custom Tool to Prepare the Menu",local:"using-a-custom-tool-to-prepare-the-menu",headingTag:"h3"}}),Me=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, tool, InferenceClientModel

<span class="hljs-comment"># Tool to suggest a menu based on the occasion</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">suggest_menu</span>(<span class="hljs-params">occasion: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Suggests a menu based on the occasion.
    Args:
        occasion (str): The type of occasion for the party. Allowed values are:
                        - &quot;casual&quot;: Menu for casual party.
                        - &quot;formal&quot;: Menu for formal party.
                        - &quot;superhero&quot;: Menu for superhero party.
                        - &quot;custom&quot;: Custom menu.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> occasion == <span class="hljs-string">&quot;casual&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Pizza, snacks, and drinks.&quot;</span>
    <span class="hljs-keyword">elif</span> occasion == <span class="hljs-string">&quot;formal&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;3-course dinner with wine and dessert.&quot;</span>
    <span class="hljs-keyword">elif</span> occasion == <span class="hljs-string">&quot;superhero&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Buffet with high-energy and healthy food.&quot;</span>
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Custom menu for the butler.&quot;</span>

<span class="hljs-comment"># Alfred, the butler, preparing the menu for the party</span>
agent = CodeAgent(tools=[suggest_menu], model=InferenceClientModel())

<span class="hljs-comment"># Preparing the menu for the party</span>
agent.run(<span class="hljs-string">&quot;Prepare a formal menu for the party.&quot;</span>)`,wrap:!1}}),re=new h({props:{title:"Using Python Imports Inside the Agent",local:"using-python-imports-inside-the-agent",headingTag:"h3"}}),ce=new c({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWltcG9ydCUyMHRpbWUlMEFpbXBvcnQlMjBkYXRldGltZSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTJDJTIwYWRkaXRpb25hbF9hdXRob3JpemVkX2ltcG9ydHMlM0QlNUInZGF0ZXRpbWUnJTVEKSUwQSUwQWFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBbGZyZWQlMjBuZWVkcyUyMHRvJTIwcHJlcGFyZSUyMGZvciUyMHRoZSUyMHBhcnR5LiUyMEhlcmUlMjBhcmUlMjB0aGUlMjB0YXNrcyUzQSUwQSUyMCUyMCUyMCUyMDEuJTIwUHJlcGFyZSUyMHRoZSUyMGRyaW5rcyUyMC0lMjAzMCUyMG1pbnV0ZXMlMEElMjAlMjAlMjAlMjAyLiUyMERlY29yYXRlJTIwdGhlJTIwbWFuc2lvbiUyMC0lMjA2MCUyMG1pbnV0ZXMlMEElMjAlMjAlMjAlMjAzLiUyMFNldCUyMHVwJTIwdGhlJTIwbWVudSUyMC0lMjA0NSUyMG1pbnV0ZXMlMEElMjAlMjAlMjAlMjA0LiUyMFByZXBhcmUlMjB0aGUlMjBtdXNpYyUyMGFuZCUyMHBsYXlsaXN0JTIwLSUyMDQ1JTIwbWludXRlcyUwQSUwQSUyMCUyMCUyMCUyMElmJTIwd2UlMjBzdGFydCUyMHJpZ2h0JTIwbm93JTJDJTIwYXQlMjB3aGF0JTIwdGltZSUyMHdpbGwlMjB0aGUlMjBwYXJ0eSUyMGJlJTIwcmVhZHklM0YlMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> datetime

agent = CodeAgent(tools=[], model=InferenceClientModel(), additional_authorized_imports=[<span class="hljs-string">&#x27;datetime&#x27;</span>])

agent.run(
    <span class="hljs-string">&quot;&quot;&quot;
    Alfred needs to prepare for the party. Here are the tasks:
    1. Prepare the drinks - 30 minutes
    2. Decorate the mansion - 60 minutes
    3. Set up the menu - 45 minutes
    4. Prepare the music and playlist - 45 minutes

    If we start right now, at what time will the party be ready?
    &quot;&quot;&quot;</span>
)`,wrap:!1}}),de=new h({props:{title:"Sharing Our Custom Party Preparator Agent to the Hub",local:"sharing-our-custom-party-preparator-agent-to-the-hub",headingTag:"h3"}}),je=new c({props:{code:"JTIzJTIwQ2hhbmdlJTIwdG8lMjB5b3VyJTIwdXNlcm5hbWUlMjBhbmQlMjByZXBvJTIwbmFtZSUwQWFnZW50LnB1c2hfdG9faHViKCdzZXJnaW9wYW5pZWdvJTJGQWxmcmVkQWdlbnQnKQ==",highlighted:`<span class="hljs-comment"># Change to your username and repo name</span>
agent.push_to_hub(<span class="hljs-string">&#x27;sergiopaniego/AlfredAgent&#x27;</span>)`,wrap:!1}}),Ie=new c({props:{code:"JTIzJTIwQ2hhbmdlJTIwdG8lMjB5b3VyJTIwdXNlcm5hbWUlMjBhbmQlMjByZXBvJTIwbmFtZSUwQWFsZnJlZF9hZ2VudCUyMCUzRCUyMGFnZW50LmZyb21faHViKCdzZXJnaW9wYW5pZWdvJTJGQWxmcmVkQWdlbnQnJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQSUwQWFsZnJlZF9hZ2VudC5ydW4oJTIyR2l2ZSUyMG1lJTIwdGhlJTIwYmVzdCUyMHBsYXlsaXN0JTIwZm9yJTIwYSUyMHBhcnR5JTIwYXQlMjBXYXluZSdzJTIwbWFuc2lvbi4lMjBUaGUlMjBwYXJ0eSUyMGlkZWElMjBpcyUyMGElMjAndmlsbGFpbiUyMG1hc3F1ZXJhZGUnJTIwdGhlbWUlMjIpJTIwJTIw",highlighted:`<span class="hljs-comment"># Change to your username and repo name</span>
alfred_agent = agent.from_hub(<span class="hljs-string">&#x27;sergiopaniego/AlfredAgent&#x27;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

alfred_agent.run(<span class="hljs-string">&quot;Give me the best playlist for a party at Wayne&#x27;s mansion. The party idea is a &#x27;villain masquerade&#x27; theme&quot;</span>)  `,wrap:!1}}),ve=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, FinalAnswerTool, InferenceClientModel, Tool, tool, VisitWebpageTool

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">suggest_menu</span>(<span class="hljs-params">occasion: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Suggests a menu based on the occasion.
    Args:
        occasion: The type of occasion for the party.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> occasion == <span class="hljs-string">&quot;casual&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Pizza, snacks, and drinks.&quot;</span>
    <span class="hljs-keyword">elif</span> occasion == <span class="hljs-string">&quot;formal&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;3-course dinner with wine and dessert.&quot;</span>
    <span class="hljs-keyword">elif</span> occasion == <span class="hljs-string">&quot;superhero&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Buffet with high-energy and healthy food.&quot;</span>
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Custom menu for the butler.&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">catering_service_tool</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    This tool returns the highest-rated catering service in Gotham City.
    
    Args:
        query: A search term for finding catering services.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Example list of catering services and their ratings</span>
    services = {
        <span class="hljs-string">&quot;Gotham Catering Co.&quot;</span>: <span class="hljs-number">4.9</span>,
        <span class="hljs-string">&quot;Wayne Manor Catering&quot;</span>: <span class="hljs-number">4.8</span>,
        <span class="hljs-string">&quot;Gotham City Events&quot;</span>: <span class="hljs-number">4.7</span>,
    }
    
    <span class="hljs-comment"># Find the highest rated catering service (simulating search query filtering)</span>
    best_service = <span class="hljs-built_in">max</span>(services, key=services.get)
    
    <span class="hljs-keyword">return</span> best_service

<span class="hljs-keyword">class</span> <span class="hljs-title class_">SuperheroPartyThemeTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;superhero_party_theme_generator&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This tool suggests creative superhero-themed party ideas based on a category.
    It returns a unique party theme idea.&quot;&quot;&quot;</span>
    
    inputs = {
        <span class="hljs-string">&quot;category&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The type of superhero party (e.g., &#x27;classic heroes&#x27;, &#x27;villain masquerade&#x27;, &#x27;futuristic Gotham&#x27;).&quot;</span>,
        }
    }
    
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, category: <span class="hljs-built_in">str</span></span>):
        themes = {
            <span class="hljs-string">&quot;classic heroes&quot;</span>: <span class="hljs-string">&quot;Justice League Gala: Guests come dressed as their favorite DC heroes with themed cocktails like &#x27;The Kryptonite Punch&#x27;.&quot;</span>,
            <span class="hljs-string">&quot;villain masquerade&quot;</span>: <span class="hljs-string">&quot;Gotham Rogues&#x27; Ball: A mysterious masquerade where guests dress as classic Batman villains.&quot;</span>,
            <span class="hljs-string">&quot;futuristic Gotham&quot;</span>: <span class="hljs-string">&quot;Neo-Gotham Night: A cyberpunk-style party inspired by Batman Beyond, with neon decorations and futuristic gadgets.&quot;</span>
        }
        
        <span class="hljs-keyword">return</span> themes.get(category.lower(), <span class="hljs-string">&quot;Themed party idea not found. Try &#x27;classic heroes&#x27;, &#x27;villain masquerade&#x27;, or &#x27;futuristic Gotham&#x27;.&quot;</span>)


<span class="hljs-comment"># Alfred, the butler, preparing the menu for the party</span>
agent = CodeAgent(
    tools=[
        DuckDuckGoSearchTool(), 
        VisitWebpageTool(),
        suggest_menu,
        catering_service_tool,
        SuperheroPartyThemeTool(),
	FinalAnswerTool()
    ], 
    model=InferenceClientModel(),
    max_steps=<span class="hljs-number">10</span>,
    verbosity_level=<span class="hljs-number">2</span>
)

agent.run(<span class="hljs-string">&quot;Give me the best playlist for a party at the Wayne&#x27;s mansion. The party idea is a &#x27;villain masquerade&#x27; theme&quot;</span>)`,wrap:!1}}),Ze=new h({props:{title:"Inspecting Our Party Preparator Agent with OpenTelemetry and Langfuse 📡",local:"inspecting-our-party-preparator-agent-with-opentelemetry-and-langfuse-",headingTag:"h3"}}),He=new c({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9wZW50ZWxlbWV0cnktc2RrJTIwb3BlbnRlbGVtZXRyeS1leHBvcnRlci1vdGxwJTIwb3BlbmluZmVyZW5jZS1pbnN0cnVtZW50YXRpb24tc21vbGFnZW50cyUyMGxhbmdmdXNl",highlighted:"pip install opentelemetry-sdk opentelemetry-exporter-otlp openinference-instrumentation-smolagents langfuse",wrap:!1}}),Se=new c({props:{code:"aW1wb3J0JTIwb3MlMEElMEElMjMlMjBHZXQlMjBrZXlzJTIwZm9yJTIweW91ciUyMHByb2plY3QlMjBmcm9tJTIwdGhlJTIwcHJvamVjdCUyMHNldHRpbmdzJTIwcGFnZSUzQSUyMGh0dHBzJTNBJTJGJTJGY2xvdWQubGFuZ2Z1c2UuY29tJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX1BVQkxJQ19LRVklMjIlNUQlMjAlM0QlMjAlMjJway1sZi0uLi4lMjIlMjAlMEFvcy5lbnZpcm9uJTVCJTIyTEFOR0ZVU0VfU0VDUkVUX0tFWSUyMiU1RCUyMCUzRCUyMCUyMnNrLWxmLS4uLiUyMiUyMCUwQW9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZjbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQUElRjAlOUYlODclQkElMjBFVSUyMHJlZ2lvbiUwQSUyMyUyMG9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cy5jbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQkElRjAlOUYlODclQjglMjBVUyUyMHJlZ2lvbg==",highlighted:`<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Get keys for your project from the project settings page: https://cloud.langfuse.com</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_PUBLIC_KEY&quot;</span>] = <span class="hljs-string">&quot;pk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_SECRET_KEY&quot;</span>] = <span class="hljs-string">&quot;sk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com&quot;</span> <span class="hljs-comment"># 🇪🇺 EU region</span>
<span class="hljs-comment"># os.environ[&quot;LANGFUSE_HOST&quot;] = &quot;https://us.cloud.langfuse.com&quot; # 🇺🇸 US region</span>`,wrap:!1}}),Qe=new c({props:{code:"ZnJvbSUyMGxhbmdmdXNlJTIwaW1wb3J0JTIwZ2V0X2NsaWVudCUwQSUyMCUwQWxhbmdmdXNlJTIwJTNEJTIwZ2V0X2NsaWVudCgpJTBBJTIwJTBBJTIzJTIwVmVyaWZ5JTIwY29ubmVjdGlvbiUwQWlmJTIwbGFuZ2Z1c2UuYXV0aF9jaGVjaygpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyTGFuZ2Z1c2UlMjBjbGllbnQlMjBpcyUyMGF1dGhlbnRpY2F0ZWQlMjBhbmQlMjByZWFkeSElMjIpJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkF1dGhlbnRpY2F0aW9uJTIwZmFpbGVkLiUyMFBsZWFzZSUyMGNoZWNrJTIweW91ciUyMGNyZWRlbnRpYWxzJTIwYW5kJTIwaG9zdC4lMjIp",highlighted:`<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client
 
langfuse = get_client()
 
<span class="hljs-comment"># Verify connection</span>
<span class="hljs-keyword">if</span> langfuse.auth_check():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Langfuse client is authenticated and ready!&quot;</span>)
<span class="hljs-keyword">else</span>:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Authentication failed. Please check your credentials and host.&quot;</span>)`,wrap:!1}}),Re=new c({props:{code:"ZnJvbSUyMG9wZW5pbmZlcmVuY2UuaW5zdHJ1bWVudGF0aW9uLnNtb2xhZ2VudHMlMjBpbXBvcnQlMjBTbW9sYWdlbnRzSW5zdHJ1bWVudG9yJTBBJTBBU21vbGFnZW50c0luc3RydW1lbnRvcigpLmluc3RydW1lbnQoKQ==",highlighted:`<span class="hljs-keyword">from</span> openinference.instrumentation.smolagents <span class="hljs-keyword">import</span> SmolagentsInstrumentor

SmolagentsInstrumentor().instrument()`,wrap:!1}}),Xe=new c({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQWFsZnJlZF9hZ2VudCUyMCUzRCUyMGFnZW50LmZyb21faHViKCdzZXJnaW9wYW5pZWdvJTJGQWxmcmVkQWdlbnQnJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQWFsZnJlZF9hZ2VudC5ydW4oJTIyR2l2ZSUyMG1lJTIwdGhlJTIwYmVzdCUyMHBsYXlsaXN0JTIwZm9yJTIwYSUyMHBhcnR5JTIwYXQlMjBXYXluZSdzJTIwbWFuc2lvbi4lMjBUaGUlMjBwYXJ0eSUyMGlkZWElMjBpcyUyMGElMjAndmlsbGFpbiUyMG1hc3F1ZXJhZGUnJTIwdGhlbWUlMjIpJTIwJTIw",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

agent = CodeAgent(tools=[], model=InferenceClientModel())
alfred_agent = agent.from_hub(<span class="hljs-string">&#x27;sergiopaniego/AlfredAgent&#x27;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
alfred_agent.run(<span class="hljs-string">&quot;Give me the best playlist for a party at Wayne&#x27;s mansion. The party idea is a &#x27;villain masquerade&#x27; theme&quot;</span>)  `,wrap:!1}}),ze=new h({props:{title:"Resources",local:"resources",headingTag:"h2"}}),De=new ln({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/smolagents/code_agents.mdx"}}),{c(){d=i("meta"),et=n(),Oe=i("p"),tt=n(),J(f.$$.fragment),lt=n(),J(b.$$.fragment),st=n(),B=i("p"),B.innerHTML=Ql,nt=n(),v=i("p"),v.innerHTML=El,at=n(),k=i("p"),k.innerHTML=Rl,it=n(),m=i("blockquote"),m.innerHTML=ql,Mt=n(),J(A.$$.fragment),ot=n(),Z=i("p"),Z.innerHTML=Xl,Jt=n(),V=i("p"),V.innerHTML=Ll,rt=n(),G=i("p"),G.textContent=_l,yt=n(),W=i("ul"),W.innerHTML=Yl,Ut=n(),J(N.$$.fragment),Tt=n(),H=i("p"),H.innerHTML=zl,pt=n(),F=i("p"),F.innerHTML=Pl,wt=n(),x=i("p"),x.innerHTML=Dl,ct=n(),S=i("ol"),S.innerHTML=Ol,ut=n(),$=i("p"),$.innerHTML=Kl,ht=n(),J(Q.$$.fragment),dt=n(),g=i("blockquote"),g.innerHTML=es,mt=n(),E=i("p"),E.innerHTML=ts,gt=n(),R=i("img"),jt=n(),q=i("p"),q.innerHTML=ss,Ct=n(),J(X.$$.fragment),It=n(),L=i("p"),L.textContent=ns,ft=n(),J(_.$$.fragment),bt=n(),J(Y.$$.fragment),Bt=n(),z=i("p"),z.innerHTML=as,vt=n(),P=i("img"),kt=n(),D=i("p"),D.innerHTML=Ms,At=n(),O=i("p"),O.textContent=os,Zt=n(),J(K.$$.fragment),Vt=n(),ee=i("p"),ee.innerHTML=Js,Gt=n(),J(te.$$.fragment),Wt=n(),le=i("p"),le.textContent=rs,Nt=n(),J(se.$$.fragment),Ht=n(),ne=i("img"),Ft=n(),ae=i("p"),ae.innerHTML=Us,xt=n(),ie=i("p"),ie.innerHTML=Ts,St=n(),J(Me.$$.fragment),$t=n(),oe=i("p"),oe.innerHTML=ps,Qt=n(),Je=i("p"),Je.textContent=ws,Et=n(),J(re.$$.fragment),Rt=n(),ye=i("p"),ye.textContent=cs,qt=n(),Ue=i("p"),Ue.textContent=us,Xt=n(),Te=i("p"),Te.innerHTML=hs,Lt=n(),pe=i("p"),pe.innerHTML=ds,_t=n(),we=i("p"),we.innerHTML=ms,Yt=n(),J(ce.$$.fragment),zt=n(),ue=i("p"),ue.innerHTML=gs,Pt=n(),he=i("p"),he.innerHTML=js,Dt=n(),J(de.$$.fragment),Ot=n(),me=i("p"),me.innerHTML=Cs,Kt=n(),ge=i("p"),ge.innerHTML=Is,el=n(),J(je.$$.fragment),tl=n(),Ce=i("p"),Ce.textContent=fs,ll=n(),J(Ie.$$.fragment),sl=n(),fe=i("p"),fe.innerHTML=bs,nl=n(),be=i("p"),be.innerHTML=Bs,al=n(),u=i("iframe"),il=n(),Be=i("p"),Be.innerHTML=ks,Ml=n(),J(ve.$$.fragment),ol=n(),ke=i("p"),ke.innerHTML=As,Jl=n(),Ae=i("p"),Ae.textContent=Zs,rl=n(),j=i("blockquote"),j.innerHTML=Vs,yl=n(),J(Ze.$$.fragment),Ul=n(),Ve=i("p"),Ve.textContent=Gs,Tl=n(),Ge=i("p"),Ge.innerHTML=Ws,pl=n(),We=i("p"),We.textContent=Ns,wl=n(),Ne=i("p"),Ne.textContent=Hs,cl=n(),J(He.$$.fragment),ul=n(),Fe=i("p"),Fe.innerHTML=Fs,hl=n(),xe=i("p"),xe.textContent=xs,dl=n(),J(Se.$$.fragment),ml=n(),$e=i("p"),$e.textContent=Ss,gl=n(),J(Qe.$$.fragment),jl=n(),Ee=i("p"),Ee.innerHTML=$s,Cl=n(),J(Re.$$.fragment),Il=n(),qe=i("p"),qe.innerHTML=Qs,fl=n(),C=i("blockquote"),C.innerHTML=Es,bl=n(),J(Xe.$$.fragment),Bl=n(),Le=i("p"),Le.innerHTML=Rs,vl=n(),I=i("blockquote"),I.innerHTML=qs,kl=n(),_e=i("p"),_e.innerHTML=Xs,Al=n(),Zl=i("hr"),Vl=n(),Ye=i("p"),Ye.innerHTML=Ls,Gl=n(),J(ze.$$.fragment),Wl=n(),Pe=i("ul"),Pe.innerHTML=_s,Nl=n(),J(De.$$.fragment),Hl=n(),Ke=i("p"),this.h()},l(e){const t=Ks("svelte-u9bgzb",document.head);d=M(t,"META",{name:!0,content:!0}),t.forEach(l),et=a(e),Oe=M(e,"P",{}),Sl(Oe).forEach(l),tt=a(e),r(f.$$.fragment,e),lt=a(e),r(b.$$.fragment,e),st=a(e),B=M(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-17ycni3"&&(B.innerHTML=Ql),nt=a(e),v=M(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1vji85d"&&(v.innerHTML=El),at=a(e),k=M(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1uhgwdo"&&(k.innerHTML=Rl),it=a(e),m=M(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(m)!=="svelte-1vs2p9j"&&(m.innerHTML=ql),Mt=a(e),r(A.$$.fragment,e),ot=a(e),Z=M(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-i4pkup"&&(Z.innerHTML=Xl),Jt=a(e),V=M(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-qsp339"&&(V.innerHTML=Ll),rt=a(e),G=M(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1cvhdio"&&(G.textContent=_l),yt=a(e),W=M(e,"UL",{"data-svelte-h":!0}),o(W)!=="svelte-1sdj82c"&&(W.innerHTML=Yl),Ut=a(e),r(N.$$.fragment,e),Tt=a(e),H=M(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-2i0rf5"&&(H.innerHTML=zl),pt=a(e),F=M(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1w1ih9q"&&(F.innerHTML=Pl),wt=a(e),x=M(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1fyv2mb"&&(x.innerHTML=Dl),ct=a(e),S=M(e,"OL",{"data-svelte-h":!0}),o(S)!=="svelte-110rju1"&&(S.innerHTML=Ol),ut=a(e),$=M(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1qg0cxf"&&($.innerHTML=Kl),ht=a(e),r(Q.$$.fragment,e),dt=a(e),g=M(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(g)!=="svelte-m4phip"&&(g.innerHTML=es),mt=a(e),E=M(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1bke2ma"&&(E.innerHTML=ts),gt=a(e),R=M(e,"IMG",{src:!0,alt:!0}),jt=a(e),q=M(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1rbs9u6"&&(q.innerHTML=ss),Ct=a(e),r(X.$$.fragment,e),It=a(e),L=M(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1cqyo9g"&&(L.textContent=ns),ft=a(e),r(_.$$.fragment,e),bt=a(e),r(Y.$$.fragment,e),Bt=a(e),z=M(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-x78vs2"&&(z.innerHTML=as),vt=a(e),P=M(e,"IMG",{src:!0,alt:!0}),kt=a(e),D=M(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-skojn1"&&(D.innerHTML=Ms),At=a(e),O=M(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1aau6qe"&&(O.textContent=os),Zt=a(e),r(K.$$.fragment,e),Vt=a(e),ee=M(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1idfq95"&&(ee.innerHTML=Js),Gt=a(e),r(te.$$.fragment,e),Wt=a(e),le=M(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-qibxtx"&&(le.textContent=rs),Nt=a(e),r(se.$$.fragment,e),Ht=a(e),ne=M(e,"IMG",{src:!0,alt:!0}),Ft=a(e),ae=M(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1voj352"&&(ae.innerHTML=Us),xt=a(e),ie=M(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1iiuzsj"&&(ie.innerHTML=Ts),St=a(e),r(Me.$$.fragment,e),$t=a(e),oe=M(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1nldwyv"&&(oe.innerHTML=ps),Qt=a(e),Je=M(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-1f7ze3r"&&(Je.textContent=ws),Et=a(e),r(re.$$.fragment,e),Rt=a(e),ye=M(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-8depwo"&&(ye.textContent=cs),qt=a(e),Ue=M(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-eykpll"&&(Ue.textContent=us),Xt=a(e),Te=M(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-4672lb"&&(Te.innerHTML=hs),Lt=a(e),pe=M(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-fobjrc"&&(pe.innerHTML=ds),_t=a(e),we=M(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-1u248np"&&(we.innerHTML=ms),Yt=a(e),r(ce.$$.fragment,e),zt=a(e),ue=M(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-vwsn9d"&&(ue.innerHTML=gs),Pt=a(e),he=M(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-1u95395"&&(he.innerHTML=js),Dt=a(e),r(de.$$.fragment,e),Ot=a(e),me=M(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-1hhl4b3"&&(me.innerHTML=Cs),Kt=a(e),ge=M(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-1phne6y"&&(ge.innerHTML=Is),el=a(e),r(je.$$.fragment,e),tl=a(e),Ce=M(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-rbahqz"&&(Ce.textContent=fs),ll=a(e),r(Ie.$$.fragment,e),sl=a(e),fe=M(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-ig9tc2"&&(fe.innerHTML=bs),nl=a(e),be=M(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-ivdwzg"&&(be.innerHTML=Bs),al=a(e),u=M(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Sl(u).forEach(l),il=a(e),Be=M(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-1dqpcjq"&&(Be.innerHTML=ks),Ml=a(e),r(ve.$$.fragment,e),ol=a(e),ke=M(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-1096ue8"&&(ke.innerHTML=As),Jl=a(e),Ae=M(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-eyk6wc"&&(Ae.textContent=Zs),rl=a(e),j=M(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(j)!=="svelte-920krh"&&(j.innerHTML=Vs),yl=a(e),r(Ze.$$.fragment,e),Ul=a(e),Ve=M(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-1cbcpl7"&&(Ve.textContent=Gs),Tl=a(e),Ge=M(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-lvq792"&&(Ge.innerHTML=Ws),pl=a(e),We=M(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-1nz0zrc"&&(We.textContent=Ns),wl=a(e),Ne=M(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-bon1th"&&(Ne.textContent=Hs),cl=a(e),r(He.$$.fragment,e),ul=a(e),Fe=M(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-1j4k9mc"&&(Fe.innerHTML=Fs),hl=a(e),xe=M(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-6s2c5k"&&(xe.textContent=xs),dl=a(e),r(Se.$$.fragment,e),ml=a(e),$e=M(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-kdnbgz"&&($e.textContent=Ss),gl=a(e),r(Qe.$$.fragment,e),jl=a(e),Ee=M(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-1ci9jvt"&&(Ee.innerHTML=$s),Cl=a(e),r(Re.$$.fragment,e),Il=a(e),qe=M(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-htkmxe"&&(qe.innerHTML=Qs),fl=a(e),C=M(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(C)!=="svelte-12tu00n"&&(C.innerHTML=Es),bl=a(e),r(Xe.$$.fragment,e),Bl=a(e),Le=M(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-fmbkd1"&&(Le.innerHTML=Rs),vl=a(e),I=M(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(I)!=="svelte-4pderd"&&(I.innerHTML=qs),kl=a(e),_e=M(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-emnj79"&&(_e.innerHTML=Xs),Al=a(e),Zl=M(e,"HR",{}),Vl=a(e),Ye=M(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-1goremc"&&(Ye.innerHTML=Ls),Gl=a(e),r(ze.$$.fragment,e),Wl=a(e),Pe=M(e,"UL",{"data-svelte-h":!0}),o(Pe)!=="svelte-695w00"&&(Pe.innerHTML=_s),Nl=a(e),r(De.$$.fragment,e),Hl=a(e),Ke=M(e,"P",{}),Sl(Ke).forEach(l),this.h()},h(){w(d,"name","hf:doc:metadata"),w(d,"content",nn),w(m,"class","tip"),w(g,"class","tip"),xl(R.src,ls="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/alfred-party.jpg")||w(R,"src",ls),w(R,"alt","Alfred Party"),xl(P.src,is="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/alfred-playlist.jpg")||w(P,"src",is),w(P,"alt","Alfred Playlist"),xl(ne.src,ys="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/alfred-menu.jpg")||w(ne,"src",ys),w(ne,"alt","Alfred Menu"),xl(u.src,vs="https://sergiopaniego-alfredagent.hf.space/")||w(u,"src",vs),w(u,"frameborder","0"),w(u,"width","850"),w(u,"height","450"),w(j,"class","tip"),w(C,"class","tip"),w(I,"class","tip")},m(e,t){en(document.head,d),s(e,et,t),s(e,Oe,t),s(e,tt,t),y(f,e,t),s(e,lt,t),y(b,e,t),s(e,st,t),s(e,B,t),s(e,nt,t),s(e,v,t),s(e,at,t),s(e,k,t),s(e,it,t),s(e,m,t),s(e,Mt,t),y(A,e,t),s(e,ot,t),s(e,Z,t),s(e,Jt,t),s(e,V,t),s(e,rt,t),s(e,G,t),s(e,yt,t),s(e,W,t),s(e,Ut,t),y(N,e,t),s(e,Tt,t),s(e,H,t),s(e,pt,t),s(e,F,t),s(e,wt,t),s(e,x,t),s(e,ct,t),s(e,S,t),s(e,ut,t),s(e,$,t),s(e,ht,t),y(Q,e,t),s(e,dt,t),s(e,g,t),s(e,mt,t),s(e,E,t),s(e,gt,t),s(e,R,t),s(e,jt,t),s(e,q,t),s(e,Ct,t),y(X,e,t),s(e,It,t),s(e,L,t),s(e,ft,t),y(_,e,t),s(e,bt,t),y(Y,e,t),s(e,Bt,t),s(e,z,t),s(e,vt,t),s(e,P,t),s(e,kt,t),s(e,D,t),s(e,At,t),s(e,O,t),s(e,Zt,t),y(K,e,t),s(e,Vt,t),s(e,ee,t),s(e,Gt,t),y(te,e,t),s(e,Wt,t),s(e,le,t),s(e,Nt,t),y(se,e,t),s(e,Ht,t),s(e,ne,t),s(e,Ft,t),s(e,ae,t),s(e,xt,t),s(e,ie,t),s(e,St,t),y(Me,e,t),s(e,$t,t),s(e,oe,t),s(e,Qt,t),s(e,Je,t),s(e,Et,t),y(re,e,t),s(e,Rt,t),s(e,ye,t),s(e,qt,t),s(e,Ue,t),s(e,Xt,t),s(e,Te,t),s(e,Lt,t),s(e,pe,t),s(e,_t,t),s(e,we,t),s(e,Yt,t),y(ce,e,t),s(e,zt,t),s(e,ue,t),s(e,Pt,t),s(e,he,t),s(e,Dt,t),y(de,e,t),s(e,Ot,t),s(e,me,t),s(e,Kt,t),s(e,ge,t),s(e,el,t),y(je,e,t),s(e,tl,t),s(e,Ce,t),s(e,ll,t),y(Ie,e,t),s(e,sl,t),s(e,fe,t),s(e,nl,t),s(e,be,t),s(e,al,t),s(e,u,t),s(e,il,t),s(e,Be,t),s(e,Ml,t),y(ve,e,t),s(e,ol,t),s(e,ke,t),s(e,Jl,t),s(e,Ae,t),s(e,rl,t),s(e,j,t),s(e,yl,t),y(Ze,e,t),s(e,Ul,t),s(e,Ve,t),s(e,Tl,t),s(e,Ge,t),s(e,pl,t),s(e,We,t),s(e,wl,t),s(e,Ne,t),s(e,cl,t),y(He,e,t),s(e,ul,t),s(e,Fe,t),s(e,hl,t),s(e,xe,t),s(e,dl,t),y(Se,e,t),s(e,ml,t),s(e,$e,t),s(e,gl,t),y(Qe,e,t),s(e,jl,t),s(e,Ee,t),s(e,Cl,t),y(Re,e,t),s(e,Il,t),s(e,qe,t),s(e,fl,t),s(e,C,t),s(e,bl,t),y(Xe,e,t),s(e,Bl,t),s(e,Le,t),s(e,vl,t),s(e,I,t),s(e,kl,t),s(e,_e,t),s(e,Al,t),s(e,Zl,t),s(e,Vl,t),s(e,Ye,t),s(e,Gl,t),y(ze,e,t),s(e,Wl,t),s(e,Pe,t),s(e,Nl,t),y(De,e,t),s(e,Hl,t),s(e,Ke,t),Fl=!0},p:zs,i(e){Fl||(U(f.$$.fragment,e),U(b.$$.fragment,e),U(A.$$.fragment,e),U(N.$$.fragment,e),U(Q.$$.fragment,e),U(X.$$.fragment,e),U(_.$$.fragment,e),U(Y.$$.fragment,e),U(K.$$.fragment,e),U(te.$$.fragment,e),U(se.$$.fragment,e),U(Me.$$.fragment,e),U(re.$$.fragment,e),U(ce.$$.fragment,e),U(de.$$.fragment,e),U(je.$$.fragment,e),U(Ie.$$.fragment,e),U(ve.$$.fragment,e),U(Ze.$$.fragment,e),U(He.$$.fragment,e),U(Se.$$.fragment,e),U(Qe.$$.fragment,e),U(Re.$$.fragment,e),U(Xe.$$.fragment,e),U(ze.$$.fragment,e),U(De.$$.fragment,e),Fl=!0)},o(e){T(f.$$.fragment,e),T(b.$$.fragment,e),T(A.$$.fragment,e),T(N.$$.fragment,e),T(Q.$$.fragment,e),T(X.$$.fragment,e),T(_.$$.fragment,e),T(Y.$$.fragment,e),T(K.$$.fragment,e),T(te.$$.fragment,e),T(se.$$.fragment,e),T(Me.$$.fragment,e),T(re.$$.fragment,e),T(ce.$$.fragment,e),T(de.$$.fragment,e),T(je.$$.fragment,e),T(Ie.$$.fragment,e),T(ve.$$.fragment,e),T(Ze.$$.fragment,e),T(He.$$.fragment,e),T(Se.$$.fragment,e),T(Qe.$$.fragment,e),T(Re.$$.fragment,e),T(Xe.$$.fragment,e),T(ze.$$.fragment,e),T(De.$$.fragment,e),Fl=!1},d(e){e&&(l(et),l(Oe),l(tt),l(lt),l(st),l(B),l(nt),l(v),l(at),l(k),l(it),l(m),l(Mt),l(ot),l(Z),l(Jt),l(V),l(rt),l(G),l(yt),l(W),l(Ut),l(Tt),l(H),l(pt),l(F),l(wt),l(x),l(ct),l(S),l(ut),l($),l(ht),l(dt),l(g),l(mt),l(E),l(gt),l(R),l(jt),l(q),l(Ct),l(It),l(L),l(ft),l(bt),l(Bt),l(z),l(vt),l(P),l(kt),l(D),l(At),l(O),l(Zt),l(Vt),l(ee),l(Gt),l(Wt),l(le),l(Nt),l(Ht),l(ne),l(Ft),l(ae),l(xt),l(ie),l(St),l($t),l(oe),l(Qt),l(Je),l(Et),l(Rt),l(ye),l(qt),l(Ue),l(Xt),l(Te),l(Lt),l(pe),l(_t),l(we),l(Yt),l(zt),l(ue),l(Pt),l(he),l(Dt),l(Ot),l(me),l(Kt),l(ge),l(el),l(tl),l(Ce),l(ll),l(sl),l(fe),l(nl),l(be),l(al),l(u),l(il),l(Be),l(Ml),l(ol),l(ke),l(Jl),l(Ae),l(rl),l(j),l(yl),l(Ul),l(Ve),l(Tl),l(Ge),l(pl),l(We),l(wl),l(Ne),l(cl),l(ul),l(Fe),l(hl),l(xe),l(dl),l(ml),l($e),l(gl),l(jl),l(Ee),l(Cl),l(Il),l(qe),l(fl),l(C),l(bl),l(Bl),l(Le),l(vl),l(I),l(kl),l(_e),l(Al),l(Zl),l(Vl),l(Ye),l(Gl),l(Wl),l(Pe),l(Nl),l(Hl),l(Ke)),l(d),p(f,e),p(b,e),p(A,e),p(N,e),p(Q,e),p(X,e),p(_,e),p(Y,e),p(K,e),p(te,e),p(se,e),p(Me,e),p(re,e),p(ce,e),p(de,e),p(je,e),p(Ie,e),p(ve,e),p(Ze,e),p(He,e),p(Se,e),p(Qe,e),p(Re,e),p(Xe,e),p(ze,e),p(De,e)}}}const nn='{"title":"Building Agents That Use Code","local":"building-agents-that-use-code","sections":[{"title":"Why Code Agents?","local":"why-code-agents","sections":[],"depth":2},{"title":"How Does a Code Agent Work?","local":"how-does-a-code-agent-work","sections":[],"depth":2},{"title":"Let’s See Some Examples","local":"lets-see-some-examples","sections":[{"title":"Selecting a Playlist for the Party Using smolagents","local":"selecting-a-playlist-for-the-party-using-smolagents","sections":[],"depth":3},{"title":"Using a Custom Tool to Prepare the Menu","local":"using-a-custom-tool-to-prepare-the-menu","sections":[],"depth":3},{"title":"Using Python Imports Inside the Agent","local":"using-python-imports-inside-the-agent","sections":[],"depth":3},{"title":"Sharing Our Custom Party Preparator Agent to the Hub","local":"sharing-our-custom-party-preparator-agent-to-the-hub","sections":[],"depth":3},{"title":"Inspecting Our Party Preparator Agent with OpenTelemetry and Langfuse 📡","local":"inspecting-our-party-preparator-agent-with-opentelemetry-and-langfuse-","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function an($l){return Ps(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tn extends Ds{constructor(d){super(),Os(this,d,an,sn,Ys,{})}}export{Tn as component};
