import{s as XJ,f as HJ,n as _J,o as zJ}from"../chunks/scheduler.37c15a92.js";import{S as $J,i as LJ,g as y,s as U,r as e,A as qJ,h as t,f as J,c as w,j as EJ,u as j,x as I,k as PM,l as KJ,y as PJ,a as T,v as s,d as A,t as a,w as n}from"../chunks/index.2bf4358c.js";import{C}from"../chunks/CodeBlock.4e987730.js";import{C as lT}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as Fl}from"../chunks/Heading.8ada512a.js";import{E as MT}from"../chunks/getInferenceSnippets.0aa3753f.js";function JT(lJ){let i,Ql,xl,Rl,p,fl,g,Zl,r,MJ="Multi-agent systems enable <strong>specialized agents to collaborate on complex tasks</strong>, improving modularity, scalability, and robustness. Instead of relying on a single agent, tasks are distributed among agents with distinct capabilities.",Wl,m,JJ="In <strong>smolagents</strong>, different agents can be combined to generate Python code, call external tools, perform web searches, and more. By orchestrating these agents, we can create powerful workflows.",Ol,c,TJ="A typical setup might include:",vl,d,UJ="<li>A <strong>Manager Agent</strong> for task delegation</li> <li>A <strong>Code Interpreter Agent</strong> for code execution</li> <li>A <strong>Web Search Agent</strong> for information retrieval</li>",Dl,k,wJ="The diagram below illustrates a simple multi-agent architecture where a <strong>Manager Agent</strong> coordinates a <strong>Code Interpreter Tool</strong> and a <strong>Web Search Agent</strong>, which in turn utilizes tools like the <code>DuckDuckGoSearchTool</code> and <code>VisitWebpageTool</code> to gather relevant information.",Yl,u,yJ,El,h,Xl,b,tJ="A multi-agent system consists of multiple specialized agents working together under the coordination of an <strong>Orchestrator Agent</strong>. This approach enables complex workflows by distributing tasks among agents with distinct roles.",Hl,B,IJ="For example, a <strong>Multi-Agent RAG system</strong> can integrate:",_l,N,eJ="<li>A <strong>Web Agent</strong> for browsing the internet.</li> <li>A <strong>Retriever Agent</strong> for fetching information from knowledge bases.</li> <li>An <strong>Image Generation Agent</strong> for producing visuals.</li>",zl,V,jJ="All of these agents operate under an orchestrator that manages task delegation and interaction.",$l,S,Ll,o,sJ='<p>You can follow the code in <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/multiagent_notebook.ipynb" target="_blank">this notebook</a> that you can run using Google Colab.</p>',ql,F,AJ="The reception is approaching! With your help, Alfred is now nearly finished with the preparations.",Kl,x,aJ="But now there’s a problem: the Batmobile has disappeared. Alfred needs to find a replacement, and find it quickly.",Pl,G,nJ="Fortunately, a few biopics have been done on Bruce Wayne’s life, so maybe Alfred could get a car left behind on one of the movie sets, and re-engineer it up to modern standards, which certainly would include a full self-driving option.",lM,Q,CJ="But this could be anywhere in the filming locations around the world - which could be numerous.",MM,R,iJ="So Alfred wants your help. Could you build an agent able to solve this task?",JM,f,oJ="<p>👉 Find all Batman filming locations in the world, calculate the time to transfer via boat to there, and represent them on a map, with a color varying by boat transfer time. Also represent some supercar factories with the same boat transfer time.</p>",TM,Z,pJ="Let’s build this!",UM,W,gJ="This example needs some additional packages, so let’s install them first:",wM,O,yM,v,tM,D,IM,Y,eM,E,rJ='For the model provider, we use Together AI, one of the new <a href="https://huggingface.co/blog/inference-providers" rel="nofollow">inference providers on the Hub</a>!',jM,X,mJ='The GoogleSearchTool uses the <a href="https://serper.dev" rel="nofollow">Serper API</a> to search the web, so this requires either having setup env variable <code>SERPAPI_API_KEY</code> and passing <code>provider=&quot;serpapi&quot;</code> or having <code>SERPER_API_KEY</code> and passing <code>provider=serper</code>.',sM,H,cJ="If you don’t have any Serp API provider setup, you can use <code>DuckDuckGoSearchTool</code> but beware that it has a rate limit.",AM,_,aM,z,dJ="We can start by creating a simple agent as a baseline to give us a simple report.",nM,$,CM,L,iM,q,oM,K,pM,P,kJ="In our case, it generates this output:",gM,ll,rM,Ml,uJ="We could already improve this a bit by throwing in some dedicated planning steps, and adding more prompting.",mM,Jl,hJ="Planning steps allow the agent to think ahead and plan its next steps, which can be useful for more complex tasks.",cM,Tl,dM,Ul,kM,wl,bJ="In our case, it generates this output:",uM,yl,hM,tl,BJ="Thanks to these quick changes, we obtained a much more concise report by simply providing our agent a detailed prompt, and giving it planning capabilities!",bM,Il,NJ="The model’s context window is quickly filling up. So <strong>if we ask our agent to combine the results of detailed search with another, it will be slower and quickly ramp up tokens and costs</strong>.",BM,el,VJ="➡️ We need to improve the structure of our system.",NM,jl,VM,sl,SJ="Multi-agent structures allow to separate memories between different sub-tasks, with two great benefits:",SM,Al,FJ="<li>Each agent is more focused on its core task, thus more performant</li> <li>Separating memories reduces the count of input tokens at each step, thus reducing latency and cost.</li>",FM,al,xJ="Let’s create a team with a dedicated web search agent, managed by another agent.",xM,nl,GJ="The manager agent should have plotting capabilities to write its final report: so let us give it access to additional imports, including <code>plotly</code>, and <code>geopandas</code> + <code>shapely</code> for spatial plotting.",GM,Cl,QM,il,QJ="The manager agent will need to do some mental heavy lifting.",RM,ol,RJ='So we give it the stronger model <a href="https://huggingface.co/deepseek-ai/DeepSeek-R1" rel="nofollow">DeepSeek-R1</a>, and add a <code>planning_interval</code> to the mix.',fM,pl,ZM,gl,fJ="Let us inspect what this team looks like:",WM,rl,OM,ml,ZJ="This will generate something like this, helping us understand the structure and relationship between agents and tools used:",vM,cl,DM,dl,YM,kl,WJ="I don’t know how that went in your run, but in mine, the manager agent skilfully divided tasks given to the web agent in <code>1. Search for Batman filming locations</code>, then <code>2. Find supercar factories</code>, before aggregating the lists and plotting the map.",EM,ul,OJ="Let’s see what the map looks like by inspecting it directly from the agent state:",XM,hl,HM,bl,vJ="This will output the map:",_M,Bl,DJ='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/output_map.png" alt="Multiagent system example output map"/>',zM,Nl,$M,Vl,YJ='<li><a href="https://huggingface.co/docs/smolagents/main/en/examples/multiagents" rel="nofollow">Multi-Agent Systems</a> – Overview of multi-agent systems.</li> <li><a href="https://weaviate.io/blog/what-is-agentic-rag" rel="nofollow">What is Agentic RAG?</a> – Introduction to Agentic RAG.</li> <li><a href="https://huggingface.co/learn/cookbook/multiagent_rag_system" rel="nofollow">Multi-Agent RAG System 🤖🤝🤖 Recipe</a> – Step-by-step guide to building a multi-agent RAG system.</li>',LM,Sl,qM,Gl,KM;return p=new lT({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/multiagent_notebook.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),g=new Fl({props:{title:"Multi-Agent Systems",local:"multi-agent-systems",headingTag:"h1"}}),h=new Fl({props:{title:"Multi-Agent Systems in Action",local:"multi-agent-systems-in-action",headingTag:"h2"}}),S=new Fl({props:{title:"Solving a complex task with a multi-agent hierarchy",local:"solving-a-complex-task-with-a-multi-agent-hierarchy",headingTag:"h2"}}),O=new C({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCbGl0ZWxsbSU1RCclMjBwbG90bHklMjBnZW9wYW5kYXMlMjBzaGFwZWx5JTIwa2FsZWlkbyUyMC1x",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[litellm]&#x27;</span> plotly geopandas shapely kaleido -q',wrap:!1}}),v=new Fl({props:{title:"We first make a tool to get the cargo plane transfer time.",local:"we-first-make-a-tool-to-get-the-cargo-plane-transfer-time",headingTag:"h3"}}),D=new C({props:{code:"aW1wb3J0JTIwbWF0aCUwQWZyb20lMjB0eXBpbmclMjBpbXBvcnQlMjBPcHRpb25hbCUyQyUyMFR1cGxlJTBBJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjB0b29sJTBBJTBBJTBBJTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0ZV9jYXJnb190cmF2ZWxfdGltZSglMEElMjAlMjAlMjAlMjBvcmlnaW5fY29vcmRzJTNBJTIwVHVwbGUlNUJmbG9hdCUyQyUyMGZsb2F0JTVEJTJDJTBBJTIwJTIwJTIwJTIwZGVzdGluYXRpb25fY29vcmRzJTNBJTIwVHVwbGUlNUJmbG9hdCUyQyUyMGZsb2F0JTVEJTJDJTBBJTIwJTIwJTIwJTIwY3J1aXNpbmdfc3BlZWRfa21oJTNBJTIwT3B0aW9uYWwlNUJmbG9hdCU1RCUyMCUzRCUyMDc1MC4wJTJDJTIwJTIwJTIzJTIwQXZlcmFnZSUyMHNwZWVkJTIwZm9yJTIwY2FyZ28lMjBwbGFuZXMlMEEpJTIwLSUzRSUyMGZsb2F0JTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwQ2FsY3VsYXRlJTIwdGhlJTIwdHJhdmVsJTIwdGltZSUyMGZvciUyMGElMjBjYXJnbyUyMHBsYW5lJTIwYmV0d2VlbiUyMHR3byUyMHBvaW50cyUyMG9uJTIwRWFydGglMjB1c2luZyUyMGdyZWF0LWNpcmNsZSUyMGRpc3RhbmNlLiUwQSUwQSUyMCUyMCUyMCUyMEFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcmlnaW5fY29vcmRzJTNBJTIwVHVwbGUlMjBvZiUyMChsYXRpdHVkZSUyQyUyMGxvbmdpdHVkZSklMjBmb3IlMjB0aGUlMjBzdGFydGluZyUyMHBvaW50JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVzdGluYXRpb25fY29vcmRzJTNBJTIwVHVwbGUlMjBvZiUyMChsYXRpdHVkZSUyQyUyMGxvbmdpdHVkZSklMjBmb3IlMjB0aGUlMjBkZXN0aW5hdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNydWlzaW5nX3NwZWVkX2ttaCUzQSUyME9wdGlvbmFsJTIwY3J1aXNpbmclMjBzcGVlZCUyMGluJTIwa20lMkZoJTIwKGRlZmF1bHRzJTIwdG8lMjA3NTAlMjBrbSUyRmglMjBmb3IlMjB0eXBpY2FsJTIwY2FyZ28lMjBwbGFuZXMpJTBBJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZsb2F0JTNBJTIwVGhlJTIwZXN0aW1hdGVkJTIwdHJhdmVsJTIwdGltZSUyMGluJTIwaG91cnMlMEElMEElMjAlMjAlMjAlMjBFeGFtcGxlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTNFJTNFJTNFJTIwJTIzJTIwQ2hpY2FnbyUyMCg0MS44NzgxJUMyJUIwJTIwTiUyQyUyMDg3LjYyOTglQzIlQjAlMjBXKSUyMHRvJTIwU3lkbmV5JTIwKDMzLjg2ODglQzIlQjAlMjBTJTJDJTIwMTUxLjIwOTMlQzIlQjAlMjBFKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRSUzRSUzRSUyMHJlc3VsdCUyMCUzRCUyMGNhbGN1bGF0ZV9jYXJnb190cmF2ZWxfdGltZSgoNDEuODc4MSUyQyUyMC04Ny42Mjk4KSUyQyUyMCgtMzMuODY4OCUyQyUyMDE1MS4yMDkzKSklMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMEElMjAlMjAlMjAlMjBkZWYlMjB0b19yYWRpYW5zKGRlZ3JlZXMlM0ElMjBmbG9hdCklMjAtJTNFJTIwZmxvYXQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBkZWdyZWVzJTIwKiUyMChtYXRoLnBpJTIwJTJGJTIwMTgwKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEV4dHJhY3QlMjBjb29yZGluYXRlcyUwQSUyMCUyMCUyMCUyMGxhdDElMkMlMjBsb24xJTIwJTNEJTIwbWFwKHRvX3JhZGlhbnMlMkMlMjBvcmlnaW5fY29vcmRzKSUwQSUyMCUyMCUyMCUyMGxhdDIlMkMlMjBsb24yJTIwJTNEJTIwbWFwKHRvX3JhZGlhbnMlMkMlMjBkZXN0aW5hdGlvbl9jb29yZHMpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRWFydGgncyUyMHJhZGl1cyUyMGluJTIwa2lsb21ldGVycyUwQSUyMCUyMCUyMCUyMEVBUlRIX1JBRElVU19LTSUyMCUzRCUyMDYzNzEuMCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMENhbGN1bGF0ZSUyMGdyZWF0LWNpcmNsZSUyMGRpc3RhbmNlJTIwdXNpbmclMjB0aGUlMjBoYXZlcnNpbmUlMjBmb3JtdWxhJTBBJTIwJTIwJTIwJTIwZGxvbiUyMCUzRCUyMGxvbjIlMjAtJTIwbG9uMSUwQSUyMCUyMCUyMCUyMGRsYXQlMjAlM0QlMjBsYXQyJTIwLSUyMGxhdDElMEElMEElMjAlMjAlMjAlMjBhJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1hdGguc2luKGRsYXQlMjAlMkYlMjAyKSUyMCoqJTIwMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyQiUyMG1hdGguY29zKGxhdDEpJTIwKiUyMG1hdGguY29zKGxhdDIpJTIwKiUyMG1hdGguc2luKGRsb24lMjAlMkYlMjAyKSUyMCoqJTIwMiUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBjJTIwJTNEJTIwMiUyMColMjBtYXRoLmFzaW4obWF0aC5zcXJ0KGEpKSUwQSUyMCUyMCUyMCUyMGRpc3RhbmNlJTIwJTNEJTIwRUFSVEhfUkFESVVTX0tNJTIwKiUyMGMlMEElMEElMjAlMjAlMjAlMjAlMjMlMjBBZGQlMjAxMCUyNSUyMHRvJTIwYWNjb3VudCUyMGZvciUyMG5vbi1kaXJlY3QlMjByb3V0ZXMlMjBhbmQlMjBhaXIlMjB0cmFmZmljJTIwY29udHJvbHMlMEElMjAlMjAlMjAlMjBhY3R1YWxfZGlzdGFuY2UlMjAlM0QlMjBkaXN0YW5jZSUyMColMjAxLjElMEElMEElMjAlMjAlMjAlMjAlMjMlMjBDYWxjdWxhdGUlMjBmbGlnaHQlMjB0aW1lJTBBJTIwJTIwJTIwJTIwJTIzJTIwQWRkJTIwMSUyMGhvdXIlMjBmb3IlMjB0YWtlb2ZmJTIwYW5kJTIwbGFuZGluZyUyMHByb2NlZHVyZXMlMEElMjAlMjAlMjAlMjBmbGlnaHRfdGltZSUyMCUzRCUyMChhY3R1YWxfZGlzdGFuY2UlMjAlMkYlMjBjcnVpc2luZ19zcGVlZF9rbWgpJTIwJTJCJTIwMS4wJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRm9ybWF0JTIwdGhlJTIwcmVzdWx0cyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHJvdW5kKGZsaWdodF90aW1lJTJDJTIwMiklMEElMEElMEFwcmludChjYWxjdWxhdGVfY2FyZ29fdHJhdmVsX3RpbWUoKDQxLjg3ODElMkMlMjAtODcuNjI5OCklMkMlMjAoLTMzLjg2ODglMkMlMjAxNTEuMjA5MykpKQ==",highlighted:`<span class="hljs-keyword">import</span> math
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>, <span class="hljs-type">Tuple</span>

<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculate_cargo_travel_time</span>(<span class="hljs-params">
    origin_coords: <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">float</span>, <span class="hljs-built_in">float</span>],
    destination_coords: <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">float</span>, <span class="hljs-built_in">float</span>],
    cruising_speed_kmh: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">float</span>] = <span class="hljs-number">750.0</span>,  <span class="hljs-comment"># Average speed for cargo planes</span>
</span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Calculate the travel time for a cargo plane between two points on Earth using great-circle distance.

    Args:
        origin_coords: Tuple of (latitude, longitude) for the starting point
        destination_coords: Tuple of (latitude, longitude) for the destination
        cruising_speed_kmh: Optional cruising speed in km/h (defaults to 750 km/h for typical cargo planes)

    Returns:
        float: The estimated travel time in hours

    Example:
        &gt;&gt;&gt; # Chicago (41.8781° N, 87.6298° W) to Sydney (33.8688° S, 151.2093° E)
        &gt;&gt;&gt; result = calculate_cargo_travel_time((41.8781, -87.6298), (-33.8688, 151.2093))
    &quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">to_radians</span>(<span class="hljs-params">degrees: <span class="hljs-built_in">float</span></span>) -&gt; <span class="hljs-built_in">float</span>:
        <span class="hljs-keyword">return</span> degrees * (math.pi / <span class="hljs-number">180</span>)

    <span class="hljs-comment"># Extract coordinates</span>
    lat1, lon1 = <span class="hljs-built_in">map</span>(to_radians, origin_coords)
    lat2, lon2 = <span class="hljs-built_in">map</span>(to_radians, destination_coords)

    <span class="hljs-comment"># Earth&#x27;s radius in kilometers</span>
    EARTH_RADIUS_KM = <span class="hljs-number">6371.0</span>

    <span class="hljs-comment"># Calculate great-circle distance using the haversine formula</span>
    dlon = lon2 - lon1
    dlat = lat2 - lat1

    a = (
        math.sin(dlat / <span class="hljs-number">2</span>) ** <span class="hljs-number">2</span>
        + math.cos(lat1) * math.cos(lat2) * math.sin(dlon / <span class="hljs-number">2</span>) ** <span class="hljs-number">2</span>
    )
    c = <span class="hljs-number">2</span> * math.asin(math.sqrt(a))
    distance = EARTH_RADIUS_KM * c

    <span class="hljs-comment"># Add 10% to account for non-direct routes and air traffic controls</span>
    actual_distance = distance * <span class="hljs-number">1.1</span>

    <span class="hljs-comment"># Calculate flight time</span>
    <span class="hljs-comment"># Add 1 hour for takeoff and landing procedures</span>
    flight_time = (actual_distance / cruising_speed_kmh) + <span class="hljs-number">1.0</span>

    <span class="hljs-comment"># Format the results</span>
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">round</span>(flight_time, <span class="hljs-number">2</span>)


<span class="hljs-built_in">print</span>(calculate_cargo_travel_time((<span class="hljs-number">41.8781</span>, -<span class="hljs-number">87.6298</span>), (-<span class="hljs-number">33.8688</span>, <span class="hljs-number">151.2093</span>)))`,wrap:!1}}),Y=new Fl({props:{title:"Setting up the agent",local:"setting-up-the-agent",headingTag:"h3"}}),_=new C({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMENvZGVBZ2VudCUyQyUyMEdvb2dsZVNlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFZpc2l0V2VicGFnZVRvb2wlMEElMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKG1vZGVsX2lkJTNEJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyJTJDJTIwcHJvdmlkZXIlM0QlMjJ0b2dldGhlciUyMik=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, GoogleSearchTool, InferenceClientModel, VisitWebpageTool

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>, provider=<span class="hljs-string">&quot;together&quot;</span>)`,wrap:!1}}),$=new C({props:{code:"dGFzayUyMCUzRCUyMCUyMiUyMiUyMkZpbmQlMjBhbGwlMjBCYXRtYW4lMjBmaWxtaW5nJTIwbG9jYXRpb25zJTIwaW4lMjB0aGUlMjB3b3JsZCUyQyUyMGNhbGN1bGF0ZSUyMHRoZSUyMHRpbWUlMjB0byUyMHRyYW5zZmVyJTIwdmlhJTIwY2FyZ28lMjBwbGFuZSUyMHRvJTIwaGVyZSUyMCh3ZSdyZSUyMGluJTIwR290aGFtJTJDJTIwNDAuNzEyOCVDMiVCMCUyME4lMkMlMjA3NC4wMDYwJUMyJUIwJTIwVyklMkMlMjBhbmQlMjByZXR1cm4lMjB0aGVtJTIwdG8lMjBtZSUyMGFzJTIwYSUyMHBhbmRhcyUyMGRhdGFmcmFtZS4lMEFBbHNvJTIwZ2l2ZSUyMG1lJTIwc29tZSUyMHN1cGVyY2FyJTIwZmFjdG9yaWVzJTIwd2l0aCUyMHRoZSUyMHNhbWUlMjBjYXJnbyUyMHBsYW5lJTIwdHJhbnNmZXIlMjB0aW1lLiUyMiUyMiUyMg==",highlighted:`task = <span class="hljs-string">&quot;&quot;&quot;Find all Batman filming locations in the world, calculate the time to transfer via cargo plane to here (we&#x27;re in Gotham, 40.7128° N, 74.0060° W), and return them to me as a pandas dataframe.
Also give me some supercar factories with the same cargo plane transfer time.&quot;&quot;&quot;</span>`,wrap:!1}}),L=new C({props:{code:"YWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCR29vZ2xlU2VhcmNoVG9vbCglMjJzZXJwZXIlMjIpJTJDJTIwVmlzaXRXZWJwYWdlVG9vbCgpJTJDJTIwY2FsY3VsYXRlX2NhcmdvX3RyYXZlbF90aW1lJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRkaXRpb25hbF9hdXRob3JpemVkX2ltcG9ydHMlM0QlNUIlMjJwYW5kYXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0QyMCUyQyUwQSk=",highlighted:`agent = CodeAgent(
    model=model,
    tools=[GoogleSearchTool(<span class="hljs-string">&quot;serper&quot;</span>), VisitWebpageTool(), calculate_cargo_travel_time],
    additional_authorized_imports=[<span class="hljs-string">&quot;pandas&quot;</span>],
    max_steps=<span class="hljs-number">20</span>,
)`,wrap:!1}}),q=new C({props:{code:"cmVzdWx0JTIwJTNEJTIwYWdlbnQucnVuKHRhc2sp",highlighted:"result = agent.run(task)",wrap:!1}}),K=new C({props:{code:"cmVzdWx0",highlighted:"result",wrap:!1}}),ll=new C({props:{code:"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",highlighted:`|  | Location                                             | Travel Time to Gotham (hours) |
|--|------------------------------------------------------|------------------------------|
| <span class="hljs-number">0</span>  | Necropolis Cemetery, Glasgow, Scotland, UK         | <span class="hljs-number">8.60</span>                         |
| <span class="hljs-number">1</span>  | St. George<span class="hljs-string">&#x27;s Hall, Liverpool, England, UK         | 8.81                         |
| 2  | Two Temple Place, London, England, UK             | 9.17                         |
| 3  | Wollaton Hall, Nottingham, England, UK           | 9.00                         |
| 4  | Knebworth House, Knebworth, Hertfordshire, UK    | 9.15                         |
| 5  | Acton Lane Power Station, Acton Lane, Acton, UK  | 9.16                         |
| 6  | Queensboro Bridge, New York City, USA            | 1.01                         |
| 7  | Wall Street, New York City, USA                  | 1.00                         |
| 8  | Mehrangarh Fort, Jodhpur, Rajasthan, India       | 18.34                        |
| 9  | Turda Gorge, Turda, Romania                      | 11.89                        |
| 10 | Chicago, USA                                     | 2.68                         |
| 11 | Hong Kong, China                                 | 19.99                        |
| 12 | Cardington Studios, Northamptonshire, UK        | 9.10                         |
| 13 | Warner Bros. Leavesden Studios, Hertfordshire, UK | 9.13                         |
| 14 | Westwood, Los Angeles, CA, USA                  | 6.79                         |
| 15 | Woking, UK (McLaren)                             | 9.13                         |</span>`,wrap:!1}}),Tl=new C({props:{code:"YWdlbnQucGxhbm5pbmdfaW50ZXJ2YWwlMjAlM0QlMjA0JTBBJTBBZGV0YWlsZWRfcmVwb3J0JTIwJTNEJTIwYWdlbnQucnVuKGYlMjIlMjIlMjIlMEFZb3UncmUlMjBhbiUyMGV4cGVydCUyMGFuYWx5c3QuJTIwWW91JTIwbWFrZSUyMGNvbXByZWhlbnNpdmUlMjByZXBvcnRzJTIwYWZ0ZXIlMjB2aXNpdGluZyUyMG1hbnklMjB3ZWJzaXRlcy4lMEFEb24ndCUyMGhlc2l0YXRlJTIwdG8lMjBzZWFyY2glMjBmb3IlMjBtYW55JTIwcXVlcmllcyUyMGF0JTIwb25jZSUyMGluJTIwYSUyMGZvciUyMGxvb3AuJTBBRm9yJTIwZWFjaCUyMGRhdGElMjBwb2ludCUyMHRoYXQlMjB5b3UlMjBmaW5kJTJDJTIwdmlzaXQlMjB0aGUlMjBzb3VyY2UlMjB1cmwlMjB0byUyMGNvbmZpcm0lMjBudW1iZXJzLiUwQSUwQSU3QnRhc2slN0QlMEElMjIlMjIlMjIpJTBBJTBBcHJpbnQoZGV0YWlsZWRfcmVwb3J0KQ==",highlighted:`agent.planning_interval = <span class="hljs-number">4</span>

detailed_report = agent.run(<span class="hljs-string">f&quot;&quot;&quot;
You&#x27;re an expert analyst. You make comprehensive reports after visiting many websites.
Don&#x27;t hesitate to search for many queries at once in a for loop.
For each data point that you find, visit the source url to confirm numbers.

<span class="hljs-subst">{task}</span>
&quot;&quot;&quot;</span>)

<span class="hljs-built_in">print</span>(detailed_report)`,wrap:!1}}),Ul=new C({props:{code:"ZGV0YWlsZWRfcmVwb3J0",highlighted:"detailed_report",wrap:!1}}),yl=new C({props:{code:"JTdDJTIwJTIwJTdDJTIwTG9jYXRpb24lMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjBUcmF2ZWwlMjBUaW1lJTIwKGhvdXJzKSUyMCU3QyUwQSU3Qy0tJTdDLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0lN0MtLS0tLS0tLS0tLS0tLS0tLS0tLS0lN0MlMEElN0MlMjAwJTIwJTIwJTdDJTIwQnJpZGdlJTIwb2YlMjBTaWdocyUyQyUyMEdsYXNnb3clMjBOZWNyb3BvbGlzJTJDJTIwR2xhc2dvdyUyQyUyMFVLJTIwJTdDJTIwOC42JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTBBJTdDJTIwMSUyMCUyMCU3QyUyMFdpc2hhcnQlMjBTdHJlZXQlMkMlMjBHbGFzZ293JTJDJTIwU2NvdGxhbmQlMkMlMjBVSyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDguNiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3Qw==",highlighted:`|  | Location                                         | Travel Time (hours) |
|--|--------------------------------------------------|---------------------|
| <span class="hljs-number">0</span>  | Bridge of Sighs, Glasgow Necropolis, Glasgow, UK | <span class="hljs-number">8.6</span>                 |
| <span class="hljs-number">1</span>  | Wishart Street, Glasgow, Scotland, UK         | <span class="hljs-number">8.6</span>                 |`,wrap:!1}}),jl=new Fl({props:{title:"✌️ Splitting the task between two agents",local:"-splitting-the-task-between-two-agents",headingTag:"h3"}}),Cl=new C({props:{code:"bW9kZWwlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCglMEElMjAlMjAlMjAlMjAlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIlMkMlMjBwcm92aWRlciUzRCUyMnRvZ2V0aGVyJTIyJTJDJTIwbWF4X3Rva2VucyUzRDgwOTYlMEEpJTBBJTBBd2ViX2FnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEdvb2dsZVNlYXJjaFRvb2wocHJvdmlkZXIlM0QlMjJzZXJwZXIlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVmlzaXRXZWJwYWdlVG9vbCgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FsY3VsYXRlX2NhcmdvX3RyYXZlbF90aW1lJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMndlYl9hZ2VudCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyQnJvd3NlcyUyMHRoZSUyMHdlYiUyMHRvJTIwZmluZCUyMGluZm9ybWF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwdmVyYm9zaXR5X2xldmVsJTNEMCUyQyUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDEwJTJDJTBBKQ==",highlighted:`model = InferenceClientModel(
    <span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>, provider=<span class="hljs-string">&quot;together&quot;</span>, max_tokens=<span class="hljs-number">8096</span>
)

web_agent = CodeAgent(
    model=model,
    tools=[
        GoogleSearchTool(provider=<span class="hljs-string">&quot;serper&quot;</span>),
        VisitWebpageTool(),
        calculate_cargo_travel_time,
    ],
    name=<span class="hljs-string">&quot;web_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Browses the web to find information&quot;</span>,
    verbosity_level=<span class="hljs-number">0</span>,
    max_steps=<span class="hljs-number">10</span>,
)`,wrap:!1}}),pl=new C({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents.utils <span class="hljs-keyword">import</span> encode_image_base64, make_image_url
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> OpenAIServerModel


<span class="hljs-keyword">def</span> <span class="hljs-title function_">check_reasoning_and_plot</span>(<span class="hljs-params">final_answer, agent_memory</span>):
    multimodal_model = OpenAIServerModel(<span class="hljs-string">&quot;gpt-4o&quot;</span>, max_tokens=<span class="hljs-number">8096</span>)
    filepath = <span class="hljs-string">&quot;saved_map.png&quot;</span>
    <span class="hljs-keyword">assert</span> os.path.exists(filepath), <span class="hljs-string">&quot;Make sure to save the plot under saved_map.png!&quot;</span>
    image = Image.<span class="hljs-built_in">open</span>(filepath)
    prompt = (
        <span class="hljs-string">f&quot;Here is a user-given task and the agent steps: <span class="hljs-subst">{agent_memory.get_succinct_steps()}</span>. Now here is the plot that was made.&quot;</span>
        <span class="hljs-string">&quot;Please check that the reasoning process and plot are correct: do they correctly answer the given task?&quot;</span>
        <span class="hljs-string">&quot;First list reasons why yes/no, then write your final decision: PASS in caps lock if it is satisfactory, FAIL if it is not.&quot;</span>
        <span class="hljs-string">&quot;Don&#x27;t be harsh: if the plot mostly solves the task, it should pass.&quot;</span>
        <span class="hljs-string">&quot;To pass, a plot should be made using px.scatter_map and not any other method (scatter_map looks nicer).&quot;</span>
    )
    messages = [
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: [
                {
                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                    <span class="hljs-string">&quot;text&quot;</span>: prompt,
                },
                {
                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
                    <span class="hljs-string">&quot;image_url&quot;</span>: {<span class="hljs-string">&quot;url&quot;</span>: make_image_url(encode_image_base64(image))},
                },
            ],
        }
    ]
    output = multimodal_model(messages).content
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Feedback: &quot;</span>, output)
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;FAIL&quot;</span> <span class="hljs-keyword">in</span> output:
        <span class="hljs-keyword">raise</span> Exception(output)
    <span class="hljs-keyword">return</span> <span class="hljs-literal">True</span>


manager_agent = CodeAgent(
    model=InferenceClientModel(<span class="hljs-string">&quot;deepseek-ai/DeepSeek-R1&quot;</span>, provider=<span class="hljs-string">&quot;together&quot;</span>, max_tokens=<span class="hljs-number">8096</span>),
    tools=[calculate_cargo_travel_time],
    managed_agents=[web_agent],
    additional_authorized_imports=[
        <span class="hljs-string">&quot;geopandas&quot;</span>,
        <span class="hljs-string">&quot;plotly&quot;</span>,
        <span class="hljs-string">&quot;shapely&quot;</span>,
        <span class="hljs-string">&quot;json&quot;</span>,
        <span class="hljs-string">&quot;pandas&quot;</span>,
        <span class="hljs-string">&quot;numpy&quot;</span>,
    ],
    planning_interval=<span class="hljs-number">5</span>,
    verbosity_level=<span class="hljs-number">2</span>,
    final_answer_checks=[check_reasoning_and_plot],
    max_steps=<span class="hljs-number">15</span>,
)`,wrap:!1}}),rl=new C({props:{code:"bWFuYWdlcl9hZ2VudC52aXN1YWxpemUoKQ==",highlighted:"manager_agent.visualize()",wrap:!1}}),cl=new C({props:{code:"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",highlighted:`CodeAgent | deepseek-ai/DeepSeek-R1
├── ✅ Authorized imports: [<span class="hljs-string">&#x27;geopandas&#x27;</span>, <span class="hljs-string">&#x27;plotly&#x27;</span>, <span class="hljs-string">&#x27;shapely&#x27;</span>, <span class="hljs-string">&#x27;json&#x27;</span>, <span class="hljs-string">&#x27;pandas&#x27;</span>, <span class="hljs-string">&#x27;numpy&#x27;</span>]
├── 🛠️ Tools:
│   ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
│   ┃ Name                        ┃ Description                           ┃ Arguments                             ┃
│   ┡━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┩
│   │ calculate_cargo_travel_time │ Calculate the travel time <span class="hljs-keyword">for</span> a cargo │ origin_coords (\`array\`): <span class="hljs-type">Tuple</span> of     │
│   │                             │ plane between two points on Earth     │ (latitude, longitude) <span class="hljs-keyword">for</span> the         │
│   │                             │ using great-circle distance.          │ starting point                        │
│   │                             │                                       │ destination_coords (\`array\`): <span class="hljs-type">Tuple</span>   │
│   │                             │                                       │ of (latitude, longitude) <span class="hljs-keyword">for</span> the      │
│   │                             │                                       │ destination                           │
│   │                             │                                       │ cruising_speed_kmh (\`number\`):        │
│   │                             │                                       │ <span class="hljs-type">Optional</span> cruising speed <span class="hljs-keyword">in</span> km/h       │
│   │                             │                                       │ (defaults to <span class="hljs-number">750</span> km/h <span class="hljs-keyword">for</span> typical     │
│   │                             │                                       │ cargo planes)                         │
│   │ final_answer                │ Provides a final answer to the given  │ answer (\`<span class="hljs-built_in">any</span>\`): The final answer to   │
│   │                             │ problem.                              │ the problem                           │
│   └─────────────────────────────┴───────────────────────────────────────┴───────────────────────────────────────┘
└── 🤖 Managed agents:
    └── web_agent | CodeAgent | Qwen/Qwen2<span class="hljs-number">.5</span>-Coder-32B-Instruct
        ├── ✅ Authorized imports: []
        ├── 📝 Description: Browses the web to find information
        └── 🛠️ Tools:
            ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
            ┃ Name                        ┃ Description                       ┃ Arguments                         ┃
            ┡━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┩
            │ web_search                  │ Performs a google web search <span class="hljs-keyword">for</span>  │ query (\`string\`): The search      │
            │                             │ your query then returns a string  │ query to perform.                 │
            │                             │ of the top search results.        │ filter_year (\`integer\`):          │
            │                             │                                   │ Optionally restrict results to a  │
            │                             │                                   │ certain year                      │
            │ visit_webpage               │ Visits a webpage at the given url │ url (\`string\`): The url of the    │
            │                             │ <span class="hljs-keyword">and</span> reads its content <span class="hljs-keyword">as</span> a        │ webpage to visit.                 │
            │                             │ markdown string. Use this to      │                                   │
            │                             │ browse webpages.                  │                                   │
            │ calculate_cargo_travel_time │ Calculate the travel time <span class="hljs-keyword">for</span> a   │ origin_coords (\`array\`): <span class="hljs-type">Tuple</span> of │
            │                             │ cargo plane between two points on │ (latitude, longitude) <span class="hljs-keyword">for</span> the     │
            │                             │ Earth using great-circle          │ starting point                    │
            │                             │ distance.                         │ destination_coords (\`array\`):     │
            │                             │                                   │ <span class="hljs-type">Tuple</span> of (latitude, longitude)    │
            │                             │                                   │ <span class="hljs-keyword">for</span> the destination               │
            │                             │                                   │ cruising_speed_kmh (\`number\`):    │
            │                             │                                   │ <span class="hljs-type">Optional</span> cruising speed <span class="hljs-keyword">in</span> km/h   │
            │                             │                                   │ (defaults to <span class="hljs-number">750</span> km/h <span class="hljs-keyword">for</span> typical │
            │                             │                                   │ cargo planes)                     │
            │ final_answer                │ Provides a final answer to the    │ answer (\`<span class="hljs-built_in">any</span>\`): The final answer  │
            │                             │ given problem.                    │ to the problem                    │
            └─────────────────────────────┴───────────────────────────────────┴───────────────────────────────────┘`,wrap:!1}}),dl=new C({props:{code:"bWFuYWdlcl9hZ2VudC5ydW4oJTIyJTIyJTIyJTBBRmluZCUyMGFsbCUyMEJhdG1hbiUyMGZpbG1pbmclMjBsb2NhdGlvbnMlMjBpbiUyMHRoZSUyMHdvcmxkJTJDJTIwY2FsY3VsYXRlJTIwdGhlJTIwdGltZSUyMHRvJTIwdHJhbnNmZXIlMjB2aWElMjBjYXJnbyUyMHBsYW5lJTIwdG8lMjBoZXJlJTIwKHdlJ3JlJTIwaW4lMjBHb3RoYW0lMkMlMjA0MC43MTI4JUMyJUIwJTIwTiUyQyUyMDc0LjAwNjAlQzIlQjAlMjBXKS4lMEFBbHNvJTIwZ2l2ZSUyMG1lJTIwc29tZSUyMHN1cGVyY2FyJTIwZmFjdG9yaWVzJTIwd2l0aCUyMHRoZSUyMHNhbWUlMjBjYXJnbyUyMHBsYW5lJTIwdHJhbnNmZXIlMjB0aW1lLiUyMFlvdSUyMG5lZWQlMjBhdCUyMGxlYXN0JTIwNiUyMHBvaW50cyUyMGluJTIwdG90YWwuJTBBUmVwcmVzZW50JTIwdGhpcyUyMGFzJTIwc3BhdGlhbCUyMG1hcCUyMG9mJTIwdGhlJTIwd29ybGQlMkMlMjB3aXRoJTIwdGhlJTIwbG9jYXRpb25zJTIwcmVwcmVzZW50ZWQlMjBhcyUyMHNjYXR0ZXIlMjBwb2ludHMlMjB3aXRoJTIwYSUyMGNvbG9yJTIwdGhhdCUyMGRlcGVuZHMlMjBvbiUyMHRoZSUyMHRyYXZlbCUyMHRpbWUlMkMlMjBhbmQlMjBzYXZlJTIwaXQlMjB0byUyMHNhdmVkX21hcC5wbmchJTBBJTBBSGVyZSdzJTIwYW4lMjBleGFtcGxlJTIwb2YlMjBob3clMjB0byUyMHBsb3QlMjBhbmQlMjByZXR1cm4lMjBhJTIwbWFwJTNBJTBBaW1wb3J0JTIwcGxvdGx5LmV4cHJlc3MlMjBhcyUyMHB4JTBBZGYlMjAlM0QlMjBweC5kYXRhLmNhcnNoYXJlKCklMEFmaWclMjAlM0QlMjBweC5zY2F0dGVyX21hcChkZiUyQyUyMGxhdCUzRCUyMmNlbnRyb2lkX2xhdCUyMiUyQyUyMGxvbiUzRCUyMmNlbnRyb2lkX2xvbiUyMiUyQyUyMHRleHQlM0QlMjJuYW1lJTIyJTJDJTIwY29sb3IlM0QlMjJwZWFrX2hvdXIlMjIlMkMlMjBzaXplJTNEMTAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwY29sb3JfY29udGludW91c19zY2FsZSUzRHB4LmNvbG9ycy5zZXF1ZW50aWFsLk1hZ21hJTJDJTIwc2l6ZV9tYXglM0QxNSUyQyUyMHpvb20lM0QxKSUwQWZpZy5zaG93KCklMEFmaWcud3JpdGVfaW1hZ2UoJTIyc2F2ZWRfaW1hZ2UucG5nJTIyKSUwQWZpbmFsX2Fuc3dlcihmaWcpJTBBJTBBTmV2ZXIlMjB0cnklMjB0byUyMHByb2Nlc3MlMjBzdHJpbmdzJTIwdXNpbmclMjBjb2RlJTNBJTIwd2hlbiUyMHlvdSUyMGhhdmUlMjBhJTIwc3RyaW5nJTIwdG8lMjByZWFkJTJDJTIwanVzdCUyMHByaW50JTIwaXQlMjBhbmQlMjB5b3UnbGwlMjBzZWUlMjBpdC4lMEElMjIlMjIlMjIp",highlighted:`manager_agent.run(<span class="hljs-string">&quot;&quot;&quot;
Find all Batman filming locations in the world, calculate the time to transfer via cargo plane to here (we&#x27;re in Gotham, 40.7128° N, 74.0060° W).
Also give me some supercar factories with the same cargo plane transfer time. You need at least 6 points in total.
Represent this as spatial map of the world, with the locations represented as scatter points with a color that depends on the travel time, and save it to saved_map.png!

Here&#x27;s an example of how to plot and return a map:
import plotly.express as px
df = px.data.carshare()
fig = px.scatter_map(df, lat=&quot;centroid_lat&quot;, lon=&quot;centroid_lon&quot;, text=&quot;name&quot;, color=&quot;peak_hour&quot;, size=100,
     color_continuous_scale=px.colors.sequential.Magma, size_max=15, zoom=1)
fig.show()
fig.write_image(&quot;saved_image.png&quot;)
final_answer(fig)

Never try to process strings using code: when you have a string to read, just print it and you&#x27;ll see it.
&quot;&quot;&quot;</span>)`,wrap:!1}}),hl=new C({props:{code:"bWFuYWdlcl9hZ2VudC5weXRob25fZXhlY3V0b3Iuc3RhdGUlNUIlMjJmaWclMjIlNUQ=",highlighted:'manager_agent.python_executor.state[<span class="hljs-string">&quot;fig&quot;</span>]',wrap:!1}}),Nl=new Fl({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Sl=new MT({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/smolagents/multi_agent_systems.mdx"}}),{c(){i=y("meta"),Ql=U(),xl=y("p"),Rl=U(),e(p.$$.fragment),fl=U(),e(g.$$.fragment),Zl=U(),r=y("p"),r.innerHTML=MJ,Wl=U(),m=y("p"),m.innerHTML=JJ,Ol=U(),c=y("p"),c.textContent=TJ,vl=U(),d=y("ul"),d.innerHTML=UJ,Dl=U(),k=y("p"),k.innerHTML=wJ,Yl=U(),u=y("img"),El=U(),e(h.$$.fragment),Xl=U(),b=y("p"),b.innerHTML=tJ,Hl=U(),B=y("p"),B.innerHTML=IJ,_l=U(),N=y("ul"),N.innerHTML=eJ,zl=U(),V=y("p"),V.textContent=jJ,$l=U(),e(S.$$.fragment),Ll=U(),o=y("blockquote"),o.innerHTML=sJ,ql=U(),F=y("p"),F.textContent=AJ,Kl=U(),x=y("p"),x.textContent=aJ,Pl=U(),G=y("p"),G.textContent=nJ,lM=U(),Q=y("p"),Q.textContent=CJ,MM=U(),R=y("p"),R.textContent=iJ,JM=U(),f=y("blockquote"),f.innerHTML=oJ,TM=U(),Z=y("p"),Z.textContent=pJ,UM=U(),W=y("p"),W.textContent=gJ,wM=U(),e(O.$$.fragment),yM=U(),e(v.$$.fragment),tM=U(),e(D.$$.fragment),IM=U(),e(Y.$$.fragment),eM=U(),E=y("p"),E.innerHTML=rJ,jM=U(),X=y("p"),X.innerHTML=mJ,sM=U(),H=y("p"),H.innerHTML=cJ,AM=U(),e(_.$$.fragment),aM=U(),z=y("p"),z.textContent=dJ,nM=U(),e($.$$.fragment),CM=U(),e(L.$$.fragment),iM=U(),e(q.$$.fragment),oM=U(),e(K.$$.fragment),pM=U(),P=y("p"),P.textContent=kJ,gM=U(),e(ll.$$.fragment),rM=U(),Ml=y("p"),Ml.textContent=uJ,mM=U(),Jl=y("p"),Jl.textContent=hJ,cM=U(),e(Tl.$$.fragment),dM=U(),e(Ul.$$.fragment),kM=U(),wl=y("p"),wl.textContent=bJ,uM=U(),e(yl.$$.fragment),hM=U(),tl=y("p"),tl.textContent=BJ,bM=U(),Il=y("p"),Il.innerHTML=NJ,BM=U(),el=y("p"),el.textContent=VJ,NM=U(),e(jl.$$.fragment),VM=U(),sl=y("p"),sl.textContent=SJ,SM=U(),Al=y("ul"),Al.innerHTML=FJ,FM=U(),al=y("p"),al.textContent=xJ,xM=U(),nl=y("p"),nl.innerHTML=GJ,GM=U(),e(Cl.$$.fragment),QM=U(),il=y("p"),il.textContent=QJ,RM=U(),ol=y("p"),ol.innerHTML=RJ,fM=U(),e(pl.$$.fragment),ZM=U(),gl=y("p"),gl.textContent=fJ,WM=U(),e(rl.$$.fragment),OM=U(),ml=y("p"),ml.textContent=ZJ,vM=U(),e(cl.$$.fragment),DM=U(),e(dl.$$.fragment),YM=U(),kl=y("p"),kl.innerHTML=WJ,EM=U(),ul=y("p"),ul.textContent=OJ,XM=U(),e(hl.$$.fragment),HM=U(),bl=y("p"),bl.textContent=vJ,_M=U(),Bl=y("p"),Bl.innerHTML=DJ,zM=U(),e(Nl.$$.fragment),$M=U(),Vl=y("ul"),Vl.innerHTML=YJ,LM=U(),e(Sl.$$.fragment),qM=U(),Gl=y("p"),this.h()},l(l){const M=qJ("svelte-u9bgzb",document.head);i=t(M,"META",{name:!0,content:!0}),M.forEach(J),Ql=w(l),xl=t(l,"P",{}),EJ(xl).forEach(J),Rl=w(l),j(p.$$.fragment,l),fl=w(l),j(g.$$.fragment,l),Zl=w(l),r=t(l,"P",{"data-svelte-h":!0}),I(r)!=="svelte-1utk6uq"&&(r.innerHTML=MJ),Wl=w(l),m=t(l,"P",{"data-svelte-h":!0}),I(m)!=="svelte-495kbr"&&(m.innerHTML=JJ),Ol=w(l),c=t(l,"P",{"data-svelte-h":!0}),I(c)!=="svelte-7rzbsb"&&(c.textContent=TJ),vl=w(l),d=t(l,"UL",{"data-svelte-h":!0}),I(d)!=="svelte-4g0mr"&&(d.innerHTML=UJ),Dl=w(l),k=t(l,"P",{"data-svelte-h":!0}),I(k)!=="svelte-1w7g1oo"&&(k.innerHTML=wJ),Yl=w(l),u=t(l,"IMG",{src:!0,style:!0}),El=w(l),j(h.$$.fragment,l),Xl=w(l),b=t(l,"P",{"data-svelte-h":!0}),I(b)!=="svelte-1y9d32a"&&(b.innerHTML=tJ),Hl=w(l),B=t(l,"P",{"data-svelte-h":!0}),I(B)!=="svelte-5zisae"&&(B.innerHTML=IJ),_l=w(l),N=t(l,"UL",{"data-svelte-h":!0}),I(N)!=="svelte-1yhsihd"&&(N.innerHTML=eJ),zl=w(l),V=t(l,"P",{"data-svelte-h":!0}),I(V)!=="svelte-1rcqnot"&&(V.textContent=jJ),$l=w(l),j(S.$$.fragment,l),Ll=w(l),o=t(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),I(o)!=="svelte-1mwu5hb"&&(o.innerHTML=sJ),ql=w(l),F=t(l,"P",{"data-svelte-h":!0}),I(F)!=="svelte-5kqcy3"&&(F.textContent=AJ),Kl=w(l),x=t(l,"P",{"data-svelte-h":!0}),I(x)!=="svelte-beftqy"&&(x.textContent=aJ),Pl=w(l),G=t(l,"P",{"data-svelte-h":!0}),I(G)!=="svelte-e3wlek"&&(G.textContent=nJ),lM=w(l),Q=t(l,"P",{"data-svelte-h":!0}),I(Q)!=="svelte-vokbk8"&&(Q.textContent=CJ),MM=w(l),R=t(l,"P",{"data-svelte-h":!0}),I(R)!=="svelte-s6dymp"&&(R.textContent=iJ),JM=w(l),f=t(l,"BLOCKQUOTE",{"data-svelte-h":!0}),I(f)!=="svelte-dczmp8"&&(f.innerHTML=oJ),TM=w(l),Z=t(l,"P",{"data-svelte-h":!0}),I(Z)!=="svelte-1nbo15e"&&(Z.textContent=pJ),UM=w(l),W=t(l,"P",{"data-svelte-h":!0}),I(W)!=="svelte-1k3qpbd"&&(W.textContent=gJ),wM=w(l),j(O.$$.fragment,l),yM=w(l),j(v.$$.fragment,l),tM=w(l),j(D.$$.fragment,l),IM=w(l),j(Y.$$.fragment,l),eM=w(l),E=t(l,"P",{"data-svelte-h":!0}),I(E)!=="svelte-patzp8"&&(E.innerHTML=rJ),jM=w(l),X=t(l,"P",{"data-svelte-h":!0}),I(X)!=="svelte-f8fqei"&&(X.innerHTML=mJ),sM=w(l),H=t(l,"P",{"data-svelte-h":!0}),I(H)!=="svelte-1vx2pje"&&(H.innerHTML=cJ),AM=w(l),j(_.$$.fragment,l),aM=w(l),z=t(l,"P",{"data-svelte-h":!0}),I(z)!=="svelte-1ix25jf"&&(z.textContent=dJ),nM=w(l),j($.$$.fragment,l),CM=w(l),j(L.$$.fragment,l),iM=w(l),j(q.$$.fragment,l),oM=w(l),j(K.$$.fragment,l),pM=w(l),P=t(l,"P",{"data-svelte-h":!0}),I(P)!=="svelte-xzrd3x"&&(P.textContent=kJ),gM=w(l),j(ll.$$.fragment,l),rM=w(l),Ml=t(l,"P",{"data-svelte-h":!0}),I(Ml)!=="svelte-1ii1il1"&&(Ml.textContent=uJ),mM=w(l),Jl=t(l,"P",{"data-svelte-h":!0}),I(Jl)!=="svelte-korqsh"&&(Jl.textContent=hJ),cM=w(l),j(Tl.$$.fragment,l),dM=w(l),j(Ul.$$.fragment,l),kM=w(l),wl=t(l,"P",{"data-svelte-h":!0}),I(wl)!=="svelte-xzrd3x"&&(wl.textContent=bJ),uM=w(l),j(yl.$$.fragment,l),hM=w(l),tl=t(l,"P",{"data-svelte-h":!0}),I(tl)!=="svelte-8nkvul"&&(tl.textContent=BJ),bM=w(l),Il=t(l,"P",{"data-svelte-h":!0}),I(Il)!=="svelte-1gyvx6b"&&(Il.innerHTML=NJ),BM=w(l),el=t(l,"P",{"data-svelte-h":!0}),I(el)!=="svelte-vkmihl"&&(el.textContent=VJ),NM=w(l),j(jl.$$.fragment,l),VM=w(l),sl=t(l,"P",{"data-svelte-h":!0}),I(sl)!=="svelte-9zsog"&&(sl.textContent=SJ),SM=w(l),Al=t(l,"UL",{"data-svelte-h":!0}),I(Al)!=="svelte-gafqe4"&&(Al.innerHTML=FJ),FM=w(l),al=t(l,"P",{"data-svelte-h":!0}),I(al)!=="svelte-hh9or6"&&(al.textContent=xJ),xM=w(l),nl=t(l,"P",{"data-svelte-h":!0}),I(nl)!=="svelte-1eotd96"&&(nl.innerHTML=GJ),GM=w(l),j(Cl.$$.fragment,l),QM=w(l),il=t(l,"P",{"data-svelte-h":!0}),I(il)!=="svelte-kidlug"&&(il.textContent=QJ),RM=w(l),ol=t(l,"P",{"data-svelte-h":!0}),I(ol)!=="svelte-5b9vd4"&&(ol.innerHTML=RJ),fM=w(l),j(pl.$$.fragment,l),ZM=w(l),gl=t(l,"P",{"data-svelte-h":!0}),I(gl)!=="svelte-x8evmd"&&(gl.textContent=fJ),WM=w(l),j(rl.$$.fragment,l),OM=w(l),ml=t(l,"P",{"data-svelte-h":!0}),I(ml)!=="svelte-1m5hm05"&&(ml.textContent=ZJ),vM=w(l),j(cl.$$.fragment,l),DM=w(l),j(dl.$$.fragment,l),YM=w(l),kl=t(l,"P",{"data-svelte-h":!0}),I(kl)!=="svelte-1wpsn6f"&&(kl.innerHTML=WJ),EM=w(l),ul=t(l,"P",{"data-svelte-h":!0}),I(ul)!=="svelte-1djejr1"&&(ul.textContent=OJ),XM=w(l),j(hl.$$.fragment,l),HM=w(l),bl=t(l,"P",{"data-svelte-h":!0}),I(bl)!=="svelte-1slbqua"&&(bl.textContent=vJ),_M=w(l),Bl=t(l,"P",{"data-svelte-h":!0}),I(Bl)!=="svelte-z627a9"&&(Bl.innerHTML=DJ),zM=w(l),j(Nl.$$.fragment,l),$M=w(l),Vl=t(l,"UL",{"data-svelte-h":!0}),I(Vl)!=="svelte-sve9y7"&&(Vl.innerHTML=YJ),LM=w(l),j(Sl.$$.fragment,l),qM=w(l),Gl=t(l,"P",{}),EJ(Gl).forEach(J),this.h()},h(){PM(i,"name","hf:doc:metadata"),PM(i,"content",TT),HJ(u.src,yJ="https://mermaid.ink/img/pako:eNp1kc1qhTAQRl9FUiQb8wIpdNO76eKubrmFks1oRg3VSYgjpYjv3lFL_2hnMWQOJwn5sqgmelRWleUSKLAtFs09jqhtoWuYUFfFAa6QA9QDTnpzamheuhxn8pt40-6l13UtS0ddhtQXj6dbR4XUGQg6zEYasTF393KjeSDGnDJKNxzj8I_7hLW5IOSmP9CH9hv_NL-d94d4DVNg84p1EnK4qlIj5hGClySWbadT-6OdsrL02MI8sFOOVkciw8zx8kaNspxnrJQE0fXKtjBMMs3JA-MpgOQwftIE9Bzj14w-cMznI_39E9Z3p0uFoA?type=png")||PM(u,"src",yJ),KJ(u,"background","white"),PM(o,"class","tip")},m(l,M){PJ(document.head,i),T(l,Ql,M),T(l,xl,M),T(l,Rl,M),s(p,l,M),T(l,fl,M),s(g,l,M),T(l,Zl,M),T(l,r,M),T(l,Wl,M),T(l,m,M),T(l,Ol,M),T(l,c,M),T(l,vl,M),T(l,d,M),T(l,Dl,M),T(l,k,M),T(l,Yl,M),T(l,u,M),T(l,El,M),s(h,l,M),T(l,Xl,M),T(l,b,M),T(l,Hl,M),T(l,B,M),T(l,_l,M),T(l,N,M),T(l,zl,M),T(l,V,M),T(l,$l,M),s(S,l,M),T(l,Ll,M),T(l,o,M),T(l,ql,M),T(l,F,M),T(l,Kl,M),T(l,x,M),T(l,Pl,M),T(l,G,M),T(l,lM,M),T(l,Q,M),T(l,MM,M),T(l,R,M),T(l,JM,M),T(l,f,M),T(l,TM,M),T(l,Z,M),T(l,UM,M),T(l,W,M),T(l,wM,M),s(O,l,M),T(l,yM,M),s(v,l,M),T(l,tM,M),s(D,l,M),T(l,IM,M),s(Y,l,M),T(l,eM,M),T(l,E,M),T(l,jM,M),T(l,X,M),T(l,sM,M),T(l,H,M),T(l,AM,M),s(_,l,M),T(l,aM,M),T(l,z,M),T(l,nM,M),s($,l,M),T(l,CM,M),s(L,l,M),T(l,iM,M),s(q,l,M),T(l,oM,M),s(K,l,M),T(l,pM,M),T(l,P,M),T(l,gM,M),s(ll,l,M),T(l,rM,M),T(l,Ml,M),T(l,mM,M),T(l,Jl,M),T(l,cM,M),s(Tl,l,M),T(l,dM,M),s(Ul,l,M),T(l,kM,M),T(l,wl,M),T(l,uM,M),s(yl,l,M),T(l,hM,M),T(l,tl,M),T(l,bM,M),T(l,Il,M),T(l,BM,M),T(l,el,M),T(l,NM,M),s(jl,l,M),T(l,VM,M),T(l,sl,M),T(l,SM,M),T(l,Al,M),T(l,FM,M),T(l,al,M),T(l,xM,M),T(l,nl,M),T(l,GM,M),s(Cl,l,M),T(l,QM,M),T(l,il,M),T(l,RM,M),T(l,ol,M),T(l,fM,M),s(pl,l,M),T(l,ZM,M),T(l,gl,M),T(l,WM,M),s(rl,l,M),T(l,OM,M),T(l,ml,M),T(l,vM,M),s(cl,l,M),T(l,DM,M),s(dl,l,M),T(l,YM,M),T(l,kl,M),T(l,EM,M),T(l,ul,M),T(l,XM,M),s(hl,l,M),T(l,HM,M),T(l,bl,M),T(l,_M,M),T(l,Bl,M),T(l,zM,M),s(Nl,l,M),T(l,$M,M),T(l,Vl,M),T(l,LM,M),s(Sl,l,M),T(l,qM,M),T(l,Gl,M),KM=!0},p:_J,i(l){KM||(A(p.$$.fragment,l),A(g.$$.fragment,l),A(h.$$.fragment,l),A(S.$$.fragment,l),A(O.$$.fragment,l),A(v.$$.fragment,l),A(D.$$.fragment,l),A(Y.$$.fragment,l),A(_.$$.fragment,l),A($.$$.fragment,l),A(L.$$.fragment,l),A(q.$$.fragment,l),A(K.$$.fragment,l),A(ll.$$.fragment,l),A(Tl.$$.fragment,l),A(Ul.$$.fragment,l),A(yl.$$.fragment,l),A(jl.$$.fragment,l),A(Cl.$$.fragment,l),A(pl.$$.fragment,l),A(rl.$$.fragment,l),A(cl.$$.fragment,l),A(dl.$$.fragment,l),A(hl.$$.fragment,l),A(Nl.$$.fragment,l),A(Sl.$$.fragment,l),KM=!0)},o(l){a(p.$$.fragment,l),a(g.$$.fragment,l),a(h.$$.fragment,l),a(S.$$.fragment,l),a(O.$$.fragment,l),a(v.$$.fragment,l),a(D.$$.fragment,l),a(Y.$$.fragment,l),a(_.$$.fragment,l),a($.$$.fragment,l),a(L.$$.fragment,l),a(q.$$.fragment,l),a(K.$$.fragment,l),a(ll.$$.fragment,l),a(Tl.$$.fragment,l),a(Ul.$$.fragment,l),a(yl.$$.fragment,l),a(jl.$$.fragment,l),a(Cl.$$.fragment,l),a(pl.$$.fragment,l),a(rl.$$.fragment,l),a(cl.$$.fragment,l),a(dl.$$.fragment,l),a(hl.$$.fragment,l),a(Nl.$$.fragment,l),a(Sl.$$.fragment,l),KM=!1},d(l){l&&(J(Ql),J(xl),J(Rl),J(fl),J(Zl),J(r),J(Wl),J(m),J(Ol),J(c),J(vl),J(d),J(Dl),J(k),J(Yl),J(u),J(El),J(Xl),J(b),J(Hl),J(B),J(_l),J(N),J(zl),J(V),J($l),J(Ll),J(o),J(ql),J(F),J(Kl),J(x),J(Pl),J(G),J(lM),J(Q),J(MM),J(R),J(JM),J(f),J(TM),J(Z),J(UM),J(W),J(wM),J(yM),J(tM),J(IM),J(eM),J(E),J(jM),J(X),J(sM),J(H),J(AM),J(aM),J(z),J(nM),J(CM),J(iM),J(oM),J(pM),J(P),J(gM),J(rM),J(Ml),J(mM),J(Jl),J(cM),J(dM),J(kM),J(wl),J(uM),J(hM),J(tl),J(bM),J(Il),J(BM),J(el),J(NM),J(VM),J(sl),J(SM),J(Al),J(FM),J(al),J(xM),J(nl),J(GM),J(QM),J(il),J(RM),J(ol),J(fM),J(ZM),J(gl),J(WM),J(OM),J(ml),J(vM),J(DM),J(YM),J(kl),J(EM),J(ul),J(XM),J(HM),J(bl),J(_M),J(Bl),J(zM),J($M),J(Vl),J(LM),J(qM),J(Gl)),J(i),n(p,l),n(g,l),n(h,l),n(S,l),n(O,l),n(v,l),n(D,l),n(Y,l),n(_,l),n($,l),n(L,l),n(q,l),n(K,l),n(ll,l),n(Tl,l),n(Ul,l),n(yl,l),n(jl,l),n(Cl,l),n(pl,l),n(rl,l),n(cl,l),n(dl,l),n(hl,l),n(Nl,l),n(Sl,l)}}}const TT='{"title":"Multi-Agent Systems","local":"multi-agent-systems","sections":[{"title":"Multi-Agent Systems in Action","local":"multi-agent-systems-in-action","sections":[],"depth":2},{"title":"Solving a complex task with a multi-agent hierarchy","local":"solving-a-complex-task-with-a-multi-agent-hierarchy","sections":[{"title":"We first make a tool to get the cargo plane transfer time.","local":"we-first-make-a-tool-to-get-the-cargo-plane-transfer-time","sections":[],"depth":3},{"title":"Setting up the agent","local":"setting-up-the-agent","sections":[],"depth":3},{"title":"✌️ Splitting the task between two agents","local":"-splitting-the-task-between-two-agents","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function UT(lJ){return zJ(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sT extends $J{constructor(i){super(),LJ(this,i,UT,JT,XJ,{})}}export{sT as component};
