import{s as ot,f as dl,n as it,o as pt}from"../chunks/scheduler.37c15a92.js";import{S as Mt,i as mt,g as r,s as a,r as m,A as ct,h as o,f as t,c as n,j as jl,u as c,x as i,k as M,y as ut,a as s,v as u,d as J,t as y,w as T}from"../chunks/index.2bf4358c.js";import{C as wl}from"../chunks/CodeBlock.4e987730.js";import{H as ye}from"../chunks/Heading.8ada512a.js";import{E as Jt}from"../chunks/getInferenceSnippets.0aa3753f.js";function yt(Ul){let w,Te,ue,we,d,de,j,bl="En la última sección, aprendimos cómo podemos crear Agentes desde cero usando código Python, y <strong>vimos lo tedioso que puede ser ese proceso</strong>. Afortunadamente, muchas librerías de Agentes simplifican este trabajo <strong>manejando gran parte del trabajo pesado por ti</strong>.",je,U,hl="En este tutorial, <strong>crearás tu primer Agente</strong> capaz de realizar acciones como generación de imágenes, búsqueda web, verificación de zonas horarias y mucho más.",Ue,b,Il="También publicarás tu agente <strong>en un Space de Hugging Face para que puedas compartirlo con amigos y colegas</strong>.",be,h,Bl="¡Comencemos!",he,I,Ie,B,gl,Be,g,Cl="Para crear este Agente, vamos a usar <code>smolagents</code>, una librería que <strong>proporciona un marco para desarrollar tus agentes con facilidad</strong>.",ge,C,fl="Esta librería ligera está diseñada para ser simple, pero abstrae gran parte de la complejidad de construir un Agente, permitiéndote enfocarte en diseño el comportamiento de tu agente.",Ce,f,vl='Profundizaremos más en smolagents en la siguiente Unidad. Mientras tanto, también puedes consultar esta <a href="https://huggingface.co/blog/smolagents" target="_blank">publicación del blog</a> o el <a href="https://github.com/huggingface/smolagents" target="_blank">repositorio de la librería en GitHub</a>.',fe,v,Wl="En resumen, <code>smolagents</code> es una librería que se enfoca en <strong>codeAgent</strong>, un tipo de agente que realiza <strong>“Acciones”</strong> a través de bloques de código, y luego <strong>“Observa”</strong> los resultados ejecutando el código.",ve,W,Gl="¡Aquí un ejemplo de lo que construiremos!",We,G,Zl="Proporcionamos a nuestro agente una <strong>herramienta de generación de imágenes</strong> y le pedimos que genere una imagen de un gato.",Ge,Z,Vl="El agente dentro de <code>smolagents</code> va a tener los <strong>mismos comportamientos que el personalizado que construimos anteriormente</strong>: va a <strong>pensar, actuar y observar en ciclo</strong> hasta que llegue a una respuesta final:",Ze,p,El,Ve,V,_l="Emocionante, ¿cierto?",Ee,E,_e,_,zl='Para comenzar, duplica este Space: <a href="https://huggingface.co/spaces/agents-course/First_agent_template" target="_blank">https://huggingface.co/spaces/agents-course/First_agent_template</a>',ze,z,Sl='<p>¡Gracias a <a href="https://huggingface.co/m-ric" target="_blank">Aymeric</a> por esta plantilla! 🙌</p>',Se,S,Hl="Duplicar este space significa <strong>crear una copia local en tu propio perfil</strong>:",He,H,Ql,Qe,Q,Al='A lo largo de esta lección, el único archivo que necesitarás modificar es el (actualmente incompleto) <strong>“app.py”</strong>. Puedes ver aquí el <a href="https://huggingface.co/spaces/agents-course/First_agent_template/blob/main/app.py" rel="nofollow">original en la plantilla</a>. Para encontrar el tuyo, ve a tu copia del space, luego haz clic en la pestaña <code>Files</code> y luego en <code>app.py</code> en el listado de directorios.',Ae,A,xl="Analicemos el código juntos:",xe,x,Rl="<li>El archivo comienza con algunas importaciones de bibliotecas simples pero necesarias</li>",Re,R,Ye,Y,Yl="Como se describió anteriormente, usaremos directamente la clase <strong>CodeAgent</strong> de <strong>smolagents</strong>.",ke,k,Ne,N,kl='¡Ahora vamos con las herramientas! Si quieres un repaso sobre las herramientas, no dudes en volver a la sección <a href="tools">Herramientas</a> del curso.',Fe,F,qe,q,Nl="Las Herramientas son lo que te estamos animando a construir en esta sección. Te damos dos ejemplos:",Xe,X,Fl="<li>Una <strong>Herramienta ficticia que no funciona</strong> que puedes modificar para hacer algo útil.</li> <li>Una <strong>Herramienta que realmente funciona</strong> que obtiene la hora actual en algún lugar del mundo.</li>",$e,$,ql="Para definir tu herramienta es importante:",Le,L,Xl="<li>Proporcionar tipos de entrada y salida para tu función, como en <code>get_current_time_in_timezone(timezone: str) -&gt; str:</code></li> <li><strong>Un docstring formateado</strong>. <code>smolagents</code> espera que todos los argumentos tengan una <strong>descripción textual en el docstring</strong>.</li>",Pe,P,De,D,$l='Utiliza <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow"><code>Qwen/Qwen2.5-Coder-32B-Instruct</code></a> como motor LLM. Este es un modelo muy capaz al que accederemos a través de la API sin servidor.',Ke,K,Oe,O,Ll="¡Este Agente todavía usa el <code>InferenceClient</code> que vimos en una sección anterior detrás de la clase <strong>InferenceClientModel</strong>!",el,ee,Pl="Daremos ejemplos más detallados cuando presentemos el marco en la Unidad 2. Por ahora, debes enfocarte en <strong>agregar nuevas herramientas a la lista de herramientas</strong> usando el parámetro <code>tools</code> de tu Agente.",ll,le,Dl="Por ejemplo, podrías usar el <code>DuckDuckGoSearchTool</code> que se importó en la primera línea del código, o puedes examinar el <code>image_generation_tool</code> que se carga desde el Hub más adelante en el código.",tl,te,Kl="<strong>Agregar herramientas le dará a tu agente nuevas capacidades</strong>, ¡intenta ser creativo aquí!",sl,se,Ol="El “app.py” completo:",al,ae,nl,ne,et="Tu <strong>Objetivo</strong> es familiarizarte con el Space y el Agente.",rl,re,lt="Actualmente, el agente en la plantilla <strong>no utiliza ninguna herramienta, así que intenta proporcionarle algunas de las prefabricadas o incluso crear algunas herramientas nuevas tú mismo.</strong>",ol,oe,tt="¡Estamos esperando ansiosamente tus increíbles resultados de agentes en el canal de Discord <strong>#agents-course-showcase</strong>!",il,pl,Ml,ie,st="¡Felicidades, has construido tu primer Agente! No dudes en compartirlo con tus amigos y colegas.",ml,pe,at="Como este es tu primer intento, es perfectamente normal si es un poco inestable o lento. En futuras unidades, aprenderemos cómo construir Agentes aún mejores.",cl,Me,nt="La mejor manera de aprender es intentarlo, así que no dudes en actualizarlo, agregar más herramientas, probar con otro modelo, etc.",ul,me,rt="En la siguiente sección, completarás el Quiz final y obtendrás tu certificado.",Jl,ce,yl,Je,Tl;return d=new ye({props:{title:"Vamos Crear Nuestro Primer Agente Usando smolagents",local:"vamos-crear-nuestro-primer-agente-usando-smolagents",headingTag:"h1"}}),I=new ye({props:{title:"¿Qué es smolagents?",local:"qué-es-smolagents",headingTag:"h2"}}),E=new ye({props:{title:"¡Construyamos nuestro Agente!",local:"construyamos-nuestro-agente",headingTag:"h2"}}),R=new wl({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTJDJTIwbG9hZF90b29sJTJDJTIwdG9vbCUwQWltcG9ydCUyMGRhdGV0aW1lJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjBweXR6JTBBaW1wb3J0JTIweWFtbCUwQWZyb20lMjB0b29scy5maW5hbF9hbnN3ZXIlMjBpbXBvcnQlMjBGaW5hbEFuc3dlclRvb2w=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, InferenceClientModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool`,wrap:!1}}),k=new ye({props:{title:"Las Herramientas",local:"las-herramientas",headingTag:"h3"}}),F=new wl({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># es importante especificar el tipo que se regresara</span>
    <span class="hljs-comment"># Mantén este formato para la descripción de la herramienta / descripción de args pero siéntete libre de modificar la herramienta</span>
    <span class="hljs-string">&quot;&quot;&quot;Una herramienta que aun no hace nada 
    Args:
        arg1: el primer argumento
        arg2: el segundo argumento
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;¿Qué magia construirás?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Una herramienta que obtiene la hora local actual en una zona horaria especificada.
    Args:
        timezone: Una cadena que representa una zona horaria válida (por ejemplo, &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Crear objeto de zona horaria</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Obtener la hora actual en esa zona horaria</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;La hora local actual en <span class="hljs-subst">{timezone}</span> es: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error al obtener la hora para la zona horaria &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),P=new ye({props:{title:"El Agente",local:"el-agente",headingTag:"h3"}}),K=new wl({props:{code:"ZmluYWxfYW5zd2VyJTIwJTNEJTIwRmluYWxBbnN3ZXJUb29sKCklMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKCUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QyMDk2JTJDJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjUlMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCdRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QnJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3JvbGVfY29udmVyc2lvbnMlM0ROb25lJTJDJTBBKSUwQSUwQXdpdGglMjBvcGVuKCUyMnByb21wdHMueWFtbCUyMiUyQyUyMCdyJyklMjBhcyUyMHN0cmVhbSUzQSUwQSUyMCUyMCUyMCUyMHByb21wdF90ZW1wbGF0ZXMlMjAlM0QlMjB5YW1sLnNhZmVfbG9hZChzdHJlYW0pJTBBJTIwJTIwJTIwJTIwJTBBJTIzJTIwRXN0YW1vcyUyMGNyZWFuZG8lMjBudWVzdHJvJTIwQ29kZUFnZW50JTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCZmluYWxfYW5zd2VyJTVEJTJDJTIwJTIzJTIwYSVDMyVCMWFkZSUyMHR1cyUyMGhlcnJhbWllbnRhcyUyMGFxdSVDMyVBRCUyMChubyUyMGVsaW1pbmVzJTIwZmluYWxfYW5zd2VyKSUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDYlMkMlMEElMjAlMjAlMjAlMjB2ZXJib3NpdHlfbGV2ZWwlM0QxJTJDJTBBJTIwJTIwJTIwJTIwZ3JhbW1hciUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBwbGFubmluZ19pbnRlcnZhbCUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHByb21wdF90ZW1wbGF0ZXMlM0Rwcm9tcHRfdGVtcGxhdGVzJTBBKSUwQSUwQUdyYWRpb1VJKGFnZW50KS5sYXVuY2goKQ==",highlighted:`final_answer = FinalAnswerTool()
model = InferenceClientModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
<span class="hljs-comment"># Estamos creando nuestro CodeAgent</span>
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># añade tus herramientas aquí (no elimines final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)

GradioUI(agent).launch()`,wrap:!1}}),ae=new wl({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, InferenceClientModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool

<span class="hljs-keyword">from</span> Gradio_UI <span class="hljs-keyword">import</span> GradioUI

<span class="hljs-comment"># A continuación hay un ejemplo de una herramienta que no hace nada. ¡Sorpréndenos con tu creatividad!</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># es importante especificar el tipo de retorno</span>
    <span class="hljs-comment"># Mantén este formato para la descripción de la herramienta / descripción de args pero siéntete libre de modificar la herramienta</span>
    <span class="hljs-string">&quot;&quot;&quot;Una herramienta que aún no hace nada 
    Args:
        arg1: el primer argumento
        arg2: el segundo argumento
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;¿Qué magia construirás?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Una herramienta que obtiene la hora local actual en una zona horaria especificada.
    Args:
        timezone: Una cadena que representa una zona horaria válida (por ejemplo, &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Crear objeto de zona horaria</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Obtener la hora actual en esa zona horaria</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;La hora local actual en <span class="hljs-subst">{timezone}</span> es: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error al obtener la hora para la zona horaria &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>


final_answer = FinalAnswerTool()
model = InferenceClientModel(
max_tokens=<span class="hljs-number">2096</span>,
temperature=<span class="hljs-number">0.5</span>,
model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
custom_role_conversions=<span class="hljs-literal">None</span>,
)


<span class="hljs-comment"># Importar herramienta desde Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;agents-course/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># añade tus herramientas aquí (no elimines final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)


GradioUI(agent).launch()`,wrap:!1}}),ce=new Jt({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/unit1/tutorial.mdx"}}),{c(){w=r("meta"),Te=a(),ue=r("p"),we=a(),m(d.$$.fragment),de=a(),j=r("p"),j.innerHTML=bl,je=a(),U=r("p"),U.innerHTML=hl,Ue=a(),b=r("p"),b.innerHTML=Il,be=a(),h=r("p"),h.textContent=Bl,he=a(),m(I.$$.fragment),Ie=a(),B=r("img"),Be=a(),g=r("p"),g.innerHTML=Cl,ge=a(),C=r("p"),C.textContent=fl,Ce=a(),f=r("p"),f.innerHTML=vl,fe=a(),v=r("p"),v.innerHTML=Wl,ve=a(),W=r("p"),W.textContent=Gl,We=a(),G=r("p"),G.innerHTML=Zl,Ge=a(),Z=r("p"),Z.innerHTML=Vl,Ze=a(),p=r("iframe"),Ve=a(),V=r("p"),V.textContent=_l,Ee=a(),m(E.$$.fragment),_e=a(),_=r("p"),_.innerHTML=zl,ze=a(),z=r("blockquote"),z.innerHTML=Sl,Se=a(),S=r("p"),S.innerHTML=Hl,He=a(),H=r("img"),Qe=a(),Q=r("p"),Q.innerHTML=Al,Ae=a(),A=r("p"),A.textContent=xl,xe=a(),x=r("ul"),x.innerHTML=Rl,Re=a(),m(R.$$.fragment),Ye=a(),Y=r("p"),Y.innerHTML=Yl,ke=a(),m(k.$$.fragment),Ne=a(),N=r("p"),N.innerHTML=kl,Fe=a(),m(F.$$.fragment),qe=a(),q=r("p"),q.textContent=Nl,Xe=a(),X=r("ol"),X.innerHTML=Fl,$e=a(),$=r("p"),$.textContent=ql,Le=a(),L=r("ol"),L.innerHTML=Xl,Pe=a(),m(P.$$.fragment),De=a(),D=r("p"),D.innerHTML=$l,Ke=a(),m(K.$$.fragment),Oe=a(),O=r("p"),O.innerHTML=Ll,el=a(),ee=r("p"),ee.innerHTML=Pl,ll=a(),le=r("p"),le.innerHTML=Dl,tl=a(),te=r("p"),te.innerHTML=Kl,sl=a(),se=r("p"),se.textContent=Ol,al=a(),m(ae.$$.fragment),nl=a(),ne=r("p"),ne.innerHTML=et,rl=a(),re=r("p"),re.innerHTML=lt,ol=a(),oe=r("p"),oe.innerHTML=tt,il=a(),pl=r("hr"),Ml=a(),ie=r("p"),ie.textContent=st,ml=a(),pe=r("p"),pe.textContent=at,cl=a(),Me=r("p"),Me.textContent=nt,ul=a(),me=r("p"),me.textContent=rt,Jl=a(),m(ce.$$.fragment),yl=a(),Je=r("p"),this.h()},l(e){const l=ct("svelte-u9bgzb",document.head);w=o(l,"META",{name:!0,content:!0}),l.forEach(t),Te=n(e),ue=o(e,"P",{}),jl(ue).forEach(t),we=n(e),c(d.$$.fragment,e),de=n(e),j=o(e,"P",{"data-svelte-h":!0}),i(j)!=="svelte-1k05pg6"&&(j.innerHTML=bl),je=n(e),U=o(e,"P",{"data-svelte-h":!0}),i(U)!=="svelte-tievl2"&&(U.innerHTML=hl),Ue=n(e),b=o(e,"P",{"data-svelte-h":!0}),i(b)!=="svelte-11b1hs9"&&(b.innerHTML=Il),be=n(e),h=o(e,"P",{"data-svelte-h":!0}),i(h)!=="svelte-z8wdc9"&&(h.textContent=Bl),he=n(e),c(I.$$.fragment,e),Ie=n(e),B=o(e,"IMG",{src:!0,alt:!0}),Be=n(e),g=o(e,"P",{"data-svelte-h":!0}),i(g)!=="svelte-zqt6ec"&&(g.innerHTML=Cl),ge=n(e),C=o(e,"P",{"data-svelte-h":!0}),i(C)!=="svelte-ibz603"&&(C.textContent=fl),Ce=n(e),f=o(e,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1oz1fp9"&&(f.innerHTML=vl),fe=n(e),v=o(e,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1971uy4"&&(v.innerHTML=Wl),ve=n(e),W=o(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1kjiebb"&&(W.textContent=Gl),We=n(e),G=o(e,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1pdukv3"&&(G.innerHTML=Zl),Ge=n(e),Z=o(e,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1e49dxv"&&(Z.innerHTML=Vl),Ze=n(e),p=o(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0,referrerpolicy:!0}),jl(p).forEach(t),Ve=n(e),V=o(e,"P",{"data-svelte-h":!0}),i(V)!=="svelte-160ich6"&&(V.textContent=_l),Ee=n(e),c(E.$$.fragment,e),_e=n(e),_=o(e,"P",{"data-svelte-h":!0}),i(_)!=="svelte-x24dt4"&&(_.innerHTML=zl),ze=n(e),z=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),i(z)!=="svelte-1lt0ymi"&&(z.innerHTML=Sl),Se=n(e),S=o(e,"P",{"data-svelte-h":!0}),i(S)!=="svelte-976dli"&&(S.innerHTML=Hl),He=n(e),H=o(e,"IMG",{src:!0,alt:!0}),Qe=n(e),Q=o(e,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-ahm5nq"&&(Q.innerHTML=Al),Ae=n(e),A=o(e,"P",{"data-svelte-h":!0}),i(A)!=="svelte-yy81s5"&&(A.textContent=xl),xe=n(e),x=o(e,"UL",{"data-svelte-h":!0}),i(x)!=="svelte-119fxux"&&(x.innerHTML=Rl),Re=n(e),c(R.$$.fragment,e),Ye=n(e),Y=o(e,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-mt70f8"&&(Y.innerHTML=Yl),ke=n(e),c(k.$$.fragment,e),Ne=n(e),N=o(e,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1ou7f4u"&&(N.innerHTML=kl),Fe=n(e),c(F.$$.fragment,e),qe=n(e),q=o(e,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1q83jk1"&&(q.textContent=Nl),Xe=n(e),X=o(e,"OL",{"data-svelte-h":!0}),i(X)!=="svelte-1xx1ttu"&&(X.innerHTML=Fl),$e=n(e),$=o(e,"P",{"data-svelte-h":!0}),i($)!=="svelte-fltuof"&&($.textContent=ql),Le=n(e),L=o(e,"OL",{"data-svelte-h":!0}),i(L)!=="svelte-1mxmbql"&&(L.innerHTML=Xl),Pe=n(e),c(P.$$.fragment,e),De=n(e),D=o(e,"P",{"data-svelte-h":!0}),i(D)!=="svelte-4qpjof"&&(D.innerHTML=$l),Ke=n(e),c(K.$$.fragment,e),Oe=n(e),O=o(e,"P",{"data-svelte-h":!0}),i(O)!=="svelte-noysk9"&&(O.innerHTML=Ll),el=n(e),ee=o(e,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-10pkzke"&&(ee.innerHTML=Pl),ll=n(e),le=o(e,"P",{"data-svelte-h":!0}),i(le)!=="svelte-vla5kx"&&(le.innerHTML=Dl),tl=n(e),te=o(e,"P",{"data-svelte-h":!0}),i(te)!=="svelte-i0yzw0"&&(te.innerHTML=Kl),sl=n(e),se=o(e,"P",{"data-svelte-h":!0}),i(se)!=="svelte-kgrbhd"&&(se.textContent=Ol),al=n(e),c(ae.$$.fragment,e),nl=n(e),ne=o(e,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-s8ocjr"&&(ne.innerHTML=et),rl=n(e),re=o(e,"P",{"data-svelte-h":!0}),i(re)!=="svelte-1mir7mg"&&(re.innerHTML=lt),ol=n(e),oe=o(e,"P",{"data-svelte-h":!0}),i(oe)!=="svelte-f30lju"&&(oe.innerHTML=tt),il=n(e),pl=o(e,"HR",{}),Ml=n(e),ie=o(e,"P",{"data-svelte-h":!0}),i(ie)!=="svelte-bgfucn"&&(ie.textContent=st),ml=n(e),pe=o(e,"P",{"data-svelte-h":!0}),i(pe)!=="svelte-1amxj21"&&(pe.textContent=at),cl=n(e),Me=o(e,"P",{"data-svelte-h":!0}),i(Me)!=="svelte-nyg79v"&&(Me.textContent=nt),ul=n(e),me=o(e,"P",{"data-svelte-h":!0}),i(me)!=="svelte-1dldop1"&&(me.textContent=rt),Jl=n(e),c(ce.$$.fragment,e),yl=n(e),Je=o(e,"P",{}),jl(Je).forEach(t),this.h()},h(){M(w,"name","hf:doc:metadata"),M(w,"content",Tt),dl(B.src,gl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/smolagents.png")||M(B,"src",gl),M(B,"alt","smolagents"),M(p,"width","560"),M(p,"height","315"),dl(p.src,El="https://www.youtube.com/embed/PQDKcWiuln4?si=ysSTDZoi8y55FVvA")||M(p,"src",El),M(p,"title","YouTube video player"),M(p,"frameborder","0"),M(p,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"),M(p,"referrerpolicy","strict-origin-when-cross-origin"),p.allowFullscreen="",dl(H.src,Ql="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/duplicate-space.gif")||M(H,"src",Ql),M(H,"alt","Duplicate")},m(e,l){ut(document.head,w),s(e,Te,l),s(e,ue,l),s(e,we,l),u(d,e,l),s(e,de,l),s(e,j,l),s(e,je,l),s(e,U,l),s(e,Ue,l),s(e,b,l),s(e,be,l),s(e,h,l),s(e,he,l),u(I,e,l),s(e,Ie,l),s(e,B,l),s(e,Be,l),s(e,g,l),s(e,ge,l),s(e,C,l),s(e,Ce,l),s(e,f,l),s(e,fe,l),s(e,v,l),s(e,ve,l),s(e,W,l),s(e,We,l),s(e,G,l),s(e,Ge,l),s(e,Z,l),s(e,Ze,l),s(e,p,l),s(e,Ve,l),s(e,V,l),s(e,Ee,l),u(E,e,l),s(e,_e,l),s(e,_,l),s(e,ze,l),s(e,z,l),s(e,Se,l),s(e,S,l),s(e,He,l),s(e,H,l),s(e,Qe,l),s(e,Q,l),s(e,Ae,l),s(e,A,l),s(e,xe,l),s(e,x,l),s(e,Re,l),u(R,e,l),s(e,Ye,l),s(e,Y,l),s(e,ke,l),u(k,e,l),s(e,Ne,l),s(e,N,l),s(e,Fe,l),u(F,e,l),s(e,qe,l),s(e,q,l),s(e,Xe,l),s(e,X,l),s(e,$e,l),s(e,$,l),s(e,Le,l),s(e,L,l),s(e,Pe,l),u(P,e,l),s(e,De,l),s(e,D,l),s(e,Ke,l),u(K,e,l),s(e,Oe,l),s(e,O,l),s(e,el,l),s(e,ee,l),s(e,ll,l),s(e,le,l),s(e,tl,l),s(e,te,l),s(e,sl,l),s(e,se,l),s(e,al,l),u(ae,e,l),s(e,nl,l),s(e,ne,l),s(e,rl,l),s(e,re,l),s(e,ol,l),s(e,oe,l),s(e,il,l),s(e,pl,l),s(e,Ml,l),s(e,ie,l),s(e,ml,l),s(e,pe,l),s(e,cl,l),s(e,Me,l),s(e,ul,l),s(e,me,l),s(e,Jl,l),u(ce,e,l),s(e,yl,l),s(e,Je,l),Tl=!0},p:it,i(e){Tl||(J(d.$$.fragment,e),J(I.$$.fragment,e),J(E.$$.fragment,e),J(R.$$.fragment,e),J(k.$$.fragment,e),J(F.$$.fragment,e),J(P.$$.fragment,e),J(K.$$.fragment,e),J(ae.$$.fragment,e),J(ce.$$.fragment,e),Tl=!0)},o(e){y(d.$$.fragment,e),y(I.$$.fragment,e),y(E.$$.fragment,e),y(R.$$.fragment,e),y(k.$$.fragment,e),y(F.$$.fragment,e),y(P.$$.fragment,e),y(K.$$.fragment,e),y(ae.$$.fragment,e),y(ce.$$.fragment,e),Tl=!1},d(e){e&&(t(Te),t(ue),t(we),t(de),t(j),t(je),t(U),t(Ue),t(b),t(be),t(h),t(he),t(Ie),t(B),t(Be),t(g),t(ge),t(C),t(Ce),t(f),t(fe),t(v),t(ve),t(W),t(We),t(G),t(Ge),t(Z),t(Ze),t(p),t(Ve),t(V),t(Ee),t(_e),t(_),t(ze),t(z),t(Se),t(S),t(He),t(H),t(Qe),t(Q),t(Ae),t(A),t(xe),t(x),t(Re),t(Ye),t(Y),t(ke),t(Ne),t(N),t(Fe),t(qe),t(q),t(Xe),t(X),t($e),t($),t(Le),t(L),t(Pe),t(De),t(D),t(Ke),t(Oe),t(O),t(el),t(ee),t(ll),t(le),t(tl),t(te),t(sl),t(se),t(al),t(nl),t(ne),t(rl),t(re),t(ol),t(oe),t(il),t(pl),t(Ml),t(ie),t(ml),t(pe),t(cl),t(Me),t(ul),t(me),t(Jl),t(yl),t(Je)),t(w),T(d,e),T(I,e),T(E,e),T(R,e),T(k,e),T(F,e),T(P,e),T(K,e),T(ae,e),T(ce,e)}}}const Tt='{"title":"Vamos Crear Nuestro Primer Agente Usando smolagents","local":"vamos-crear-nuestro-primer-agente-usando-smolagents","sections":[{"title":"¿Qué es smolagents?","local":"qué-es-smolagents","sections":[],"depth":2},{"title":"¡Construyamos nuestro Agente!","local":"construyamos-nuestro-agente","sections":[{"title":"Las Herramientas","local":"las-herramientas","sections":[],"depth":3},{"title":"El Agente","local":"el-agente","sections":[],"depth":3}],"depth":2}],"depth":1}';function wt(Ul){return pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class It extends Mt{constructor(w){super(),mt(this,w,wt,yt,ot,{})}}export{It as component};
