import{s as ln,n as on,o as rn}from"../chunks/scheduler.37c15a92.js";import{S as cn,i as un,g as o,s,r as u,A as pn,h as i,f as a,c as l,j as sn,u as p,x as r,k as P,y as mn,a as t,v as m,d as M,t as d,w as y}from"../chunks/index.2bf4358c.js";import{C as Qe}from"../chunks/CodeBlock.4e987730.js";import{H as Ve}from"../chunks/Heading.8ada512a.js";import{E as Mn}from"../chunks/getInferenceSnippets.0aa3753f.js";function dn(ve){let c,D,H,K,j,O,T,Ee="¿Recuerdas a Alfred, nuestro agente mayordomo útil de antes? ¡Bueno, está a punto de recibir una mejora! Ahora que entendemos las herramientas disponibles en LlamaIndex, podemos darle a Alfred nuevas capacidades para servirnos mejor.",ee,w,ze="Pero antes de continuar, recordemos qué hace funcionar a un agente como Alfred. En la Unidad 1, aprendimos que:",ne,g,ke="<p>Un Agente es un sistema que aprovecha un modelo de IA para interactuar con su entorno y lograr un objetivo definido por el usuario. Combina razonamiento, planificación y ejecución de acciones (a menudo a través de herramientas externas) para cumplir tareas.</p>",ae,h,qe="LlamaIndex soporta <strong>tres tipos principales de agentes de razonamiento</strong>:",te,f,Ae='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/agents.png" alt="Agents"/>',se,I,_e="<li><code>Agentes de Llamada de Funciones</code> - Estos trabajan con modelos de IA que pueden llamar funciones específicas.</li> <li><code>Agentes ReAct</code> - Estos pueden trabajar con cualquier IA que tenga un endpoint de chat o texto y manejar tareas de razonamiento complejas.</li> <li><code>Agentes Personalizados Avanzados</code> - Estos usan métodos más complejos para manejar tareas y flujos de trabajo.</li>",le,b,Re='<p>FEncuentra más información sobre agentes avanzados en <a href="https://github.com/run-llama/llama_index/blob/main/llama-index-core/llama_index/core/agent/workflow/base_agent.py">BaseWorkflowAgent</a></p>',oe,B,ie,U,Se='<p>Puedes seguir el código en <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/llama-index/agents.ipynb" target="_blank">este notebook</a> que puedes ejecutar usando Google Colab.</p>',re,C,Ye="Para crear un agente, comenzamos proporcionándole un <strong>conjunto de funciones/herramientas que definen sus capacidades</strong>. Veamos cómo crear un agente con algunas herramientas básicas. Al momento de escribir esto, el agente usará automáticamente la API de llamada de funciones (si está disponible), o un bucle de agente ReAct estándar.",ce,W,Xe="Los LLMs que soportan una API de herramientas/funciones son relativamente nuevos, pero proporcionan una forma poderosa de llamar herramientas al evitar indicaciones específicas y permitir que el LLM cree llamadas a herramientas basadas en esquemas proporcionados.",ue,G,Fe="Los agentes ReAct también son buenos en tareas de razonamiento complejas y pueden trabajar con cualquier LLM que tenga capacidades de chat o completación de texto. Son más verbosos y muestran el razonamiento detrás de ciertas acciones que toman.",pe,Z,me,x,Ne="<strong>Los agentes son sin estado por defecto</strong>, recordar interacciones pasadas es opcional usando un objeto <code>Context</code>. Esto puede ser útil si quieres usar un agente que necesita recordar interacciones previas, como un chatbot que mantiene el contexto a través de múltiples mensajes o un administrador de tareas que necesita rastrear el progreso a lo largo del tiempo.",Me,Q,de,V,Le='Notarás que los agentes en <code>LlamaIndex</code> son asíncronos porque usan el operador await de Python. Si eres nuevo en el código asíncrono en Python, o necesitas un repaso, tienen una excelente <a href="https://docs.llamaindex.ai/en/stable/getting_started/async_python/" rel="nofollow">guía de async</a>.',ye,v,He="Ahora que tenemos los conceptos básicos, echemos un vistazo a como podemos usar herramientas más complejas en nuestros agentes.",be,E,Ue,z,$e="<strong>Agentic RAG es una forma poderosa de usar agentes para responder preguntas sobre tus datos</strong>. Podemos pasar varias herramientas a Alfred para ayudarlo a responder preguntas. Sin embargo, en lugar de responder la pregunta sobre los documentos automáticamente, Alfred puede decidir usar cualquier otra herramienta o flujo para responder la pregunta.",Je,k,Pe='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/agentic-rag.png" alt="Agentic RAG"/>',je,q,De=`Es fácil <strong>envolver <code>QueryEngine</code> como una herramienta</strong> para un agente.
Al hacerlo, necesitamos <strong>definir un nombre y una descripción</strong>. El LLM usará esta información para usar la herramienta correctamente.
Veamos cómo cargar un <code>QueryEngineTool</code> usando el QueryEngine que creamos en la <a href="02_components">sección de componentes</a>.`,Te,A,Ke=`It is easy to <strong>wrap <code>QueryEngine</code> as a tool</strong> for an agent.
When doing so, we need to <strong>define a name and description</strong>. The LLM will use this information to correctly use the tool.
Let’s see how to load in a <code>QueryEngineTool</code> using the <code>QueryEngine</code> we created in the <a href="02_components">component section</a>.`,we,_,ge,R,he,S,Oe="La clase <code>AgentWorkflow</code> también soporta directamente sistemas multi-agente. Al darle a cada agente un nombre y una descripción, el sistema mantiene un único hablante activo, con cada agente teniendo la capacidad de pasar el control a otro agente.",fe,Y,en="Al reducir el alcance de cada agente, podemos ayudar a aumentar su precisión general al responder a los mensajes del usuario.",Ie,X,nn="Los agentes en LlamaIndex también pueden usarse directamente como herramientas para otros agentes, para escenarios más complejos y personalizados.",Be,F,Ce,J,an='<p>¿No has aprendido lo suficiente todavía? Hay mucho más por descubrir sobre agentes y herramientas en LlamaIndex dentro de la  <a href="https://docs.llamaindex.ai/en/stable/examples/agent/agent_workflow_basic/">Introducción Básica a AgentWorkflow</a> o la <a href="https://docs.llamaindex.ai/en/stable/understanding/agent/">Guía de Aprendizaje de Agentes</a>, ¡donde puedes leer más sobre streaming, serialización de contexto y humano-en-el-bucle!</p>',We,N,tn="Ahora que entendemos los conceptos básicos de agentes y herramientas en LlamaIndex, ¡veamos cómo podemos usar LlamaIndex para <strong>crear flujos de trabajo configurables y manejables!</strong>",Ge,L,Ze,$,xe;return j=new Ve({props:{title:"Usando Agentes en LlamaIndex",local:"usando-agentes-en-llamaindex",headingTag:"h1"}}),B=new Ve({props:{title:"Inicializando Agentes",local:"inicializando-agentes",headingTag:"h2"}}),Z=new Qe({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmxsbXMuaHVnZ2luZ2ZhY2VfYXBpJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VJbmZlcmVuY2VBUEklMEFmcm9tJTIwbGxhbWFfaW5kZXguY29yZS5hZ2VudC53b3JrZmxvdyUyMGltcG9ydCUyMEFnZW50V29ya2Zsb3clMEFmcm9tJTIwbGxhbWFfaW5kZXguY29yZS50b29scyUyMGltcG9ydCUyMEZ1bmN0aW9uVG9vbCUwQSUwQSUyMyUyMGRlZmluZSUyMHVuYSUyMGhlcnJhbWllbnRhJTIwZGUlMjBtdWVzdHJhJTIwLS0lMjAlQzIlQTFsYXMlMjBhbm90YWNpb25lcyUyMGRlJTIwdGlwbyUyQyUyMG5vbWJyZXMlMjBkZSUyMGZ1bmNpb25lcyUyMHklMjBkb2NzdHJpbmdzJTIwZXN0JUMzJUExbiUyMGluY2x1aWRvcyUyMGVuJTIwbG9zJTIwZXNxdWVtYXMlMjBhbmFsaXphZG9zISUwQWRlZiUyMG11bHRpcGx5KGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50KSUyMC0lM0UlMjBpbnQlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJNdWx0aXBsaWNhJTIwZG9zJTIwZW50ZXJvcyUyMHklMjBkZXZ1ZWx2ZSUyMGVsJTIwZW50ZXJvJTIwcmVzdWx0YW50ZSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGElMjAqJTIwYiUwQSUwQSUyMyUyMGluaWNpYWxpemElMjBlbCUyMGxsbSUwQWxsbSUyMCUzRCUyMEh1Z2dpbmdGYWNlSW5mZXJlbmNlQVBJKG1vZGVsX25hbWUlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBJTBBJTIzJTIwaW5pY2lhbGl6YSUyMGVsJTIwYWdlbnRlJTBBYWdlbnQlMjAlM0QlMjBBZ2VudFdvcmtmbG93LmZyb21fdG9vbHNfb3JfZnVuY3Rpb25zKCUwQSUyMCUyMCUyMCUyMCU1QkZ1bmN0aW9uVG9vbC5mcm9tX2RlZmF1bHRzKG11bHRpcGx5KSU1RCUyQyUwQSUyMCUyMCUyMCUyMGxsbSUzRGxsbSUwQSk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI
<span class="hljs-keyword">from</span> llama_index.core.agent.workflow <span class="hljs-keyword">import</span> AgentWorkflow
<span class="hljs-keyword">from</span> llama_index.core.tools <span class="hljs-keyword">import</span> FunctionTool

<span class="hljs-comment"># define una herramienta de muestra -- ¡las anotaciones de tipo, nombres de funciones y docstrings están incluidos en los esquemas analizados!</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplica dos enteros y devuelve el entero resultante&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-comment"># inicializa el llm</span>
llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

<span class="hljs-comment"># inicializa el agente</span>
agent = AgentWorkflow.from_tools_or_functions(
    [FunctionTool.from_defaults(multiply)],
    llm=llm
)`,wrap:!1}}),Q=new Qe({props:{code:"JTIzJTIwc2luJTIwZXN0YWRvJTBBcmVzcG9uc2UlMjAlM0QlMjBhd2FpdCUyMGFnZW50LnJ1biglMjIlQzIlQkZDdSVDMyVBMW50byUyMGVzJTIwMiUyMHBvciUyMDIlM0YlMjIpJTBBJTBBJTIzJTIwcmVjb3JkYW5kbyUyMGVzdGFkbyUwQWZyb20lMjBsbGFtYV9pbmRleC5jb3JlLndvcmtmbG93JTIwaW1wb3J0JTIwQ29udGV4dCUwQSUwQWN0eCUyMCUzRCUyMENvbnRleHQoYWdlbnQpJTBBJTBBcmVzcG9uc2UlMjAlM0QlMjBhd2FpdCUyMGFnZW50LnJ1biglMjJNaSUyMG5vbWJyZSUyMGVzJTIwQm9iLiUyMiUyQyUyMGN0eCUzRGN0eCklMEFyZXNwb25zZSUyMCUzRCUyMGF3YWl0JTIwYWdlbnQucnVuKCUyMiVDMiVCRkN1JUMzJUExbCUyMGVyYSUyMG1pJTIwbm9tYnJlJTIwZGUlMjBudWV2byUzRiUyMiUyQyUyMGN0eCUzRGN0eCk=",highlighted:`<span class="hljs-comment"># sin estado</span>
response = <span class="hljs-keyword">await</span> agent.run(<span class="hljs-string">&quot;¿Cuánto es 2 por 2?&quot;</span>)

<span class="hljs-comment"># recordando estado</span>
<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context

ctx = Context(agent)

response = <span class="hljs-keyword">await</span> agent.run(<span class="hljs-string">&quot;Mi nombre es Bob.&quot;</span>, ctx=ctx)
response = <span class="hljs-keyword">await</span> agent.run(<span class="hljs-string">&quot;¿Cuál era mi nombre de nuevo?&quot;</span>, ctx=ctx)`,wrap:!1}}),E=new Ve({props:{title:"Creando Agentes RAG con QueryEngineTools",local:"creando-agentes-rag-con-queryenginetools",headingTag:"h2"}}),_=new Qe({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUudG9vbHMlMjBpbXBvcnQlMjBRdWVyeUVuZ2luZVRvb2wlMEElMEFxdWVyeV9lbmdpbmUlMjAlM0QlMjBpbmRleC5hc19xdWVyeV9lbmdpbmUobGxtJTNEbGxtJTJDJTIwc2ltaWxhcml0eV90b3BfayUzRDMpJTIwJTIzJTIwY29tbyUyMHNlJTIwbW9zdHIlQzMlQjMlMjBlbiUyMGxhJTIwc2VjY2klQzMlQjNuJTIwYW50ZXJpb3IlMEElMEFxdWVyeV9lbmdpbmVfdG9vbCUyMCUzRCUyMFF1ZXJ5RW5naW5lVG9vbC5mcm9tX2RlZmF1bHRzKCUwQSUyMCUyMCUyMCUyMHF1ZXJ5X2VuZ2luZSUzRHF1ZXJ5X2VuZ2luZSUyQyUwQSUyMCUyMCUyMCUyMG5hbWUlM0QlMjJub21icmUlMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMnVuYSUyMGRlc2NyaXBjaSVDMyVCM24lMjBlc3BlYyVDMyVBRGZpY2ElMjIlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fZGlyZWN0JTNERmFsc2UlMkMlMEEpJTBBcXVlcnlfZW5naW5lX2FnZW50JTIwJTNEJTIwQWdlbnRXb3JrZmxvdy5mcm9tX3Rvb2xzX29yX2Z1bmN0aW9ucyglMEElMjAlMjAlMjAlMjAlNUJxdWVyeV9lbmdpbmVfdG9vbCU1RCUyQyUwQSUyMCUyMCUyMCUyMGxsbSUzRGxsbSUyQyUwQSUyMCUyMCUyMCUyMHN5c3RlbV9wcm9tcHQlM0QlMjJFcmVzJTIwdW4lMjBhc2lzdGVudGUlMjAlQzMlQkF0aWwlMjBxdWUlMjB0aWVuZSUyMGFjY2VzbyUyMGElMjB1bmElMjBiYXNlJTIwZGUlMjBkYXRvcyUyMHF1ZSUyMGNvbnRpZW5lJTIwZGVzY3JpcGNpb25lcyUyMGRlJTIwcGVyc29uYXMuJTIwJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.tools <span class="hljs-keyword">import</span> QueryEngineTool

query_engine = index.as_query_engine(llm=llm, similarity_top_k=<span class="hljs-number">3</span>) <span class="hljs-comment"># como se mostró en la sección anterior</span>

query_engine_tool = QueryEngineTool.from_defaults(
    query_engine=query_engine,
    name=<span class="hljs-string">&quot;nombre&quot;</span>,
    description=<span class="hljs-string">&quot;una descripción específica&quot;</span>,
    return_direct=<span class="hljs-literal">False</span>,
)
query_engine_agent = AgentWorkflow.from_tools_or_functions(
    [query_engine_tool],
    llm=llm,
    system_prompt=<span class="hljs-string">&quot;Eres un asistente útil que tiene acceso a una base de datos que contiene descripciones de personas. &quot;</span>
)`,wrap:!1}}),R=new Ve({props:{title:"Creando Sistemas Multi-agente",local:"creando-sistemas-multi-agente",headingTag:"h2"}}),F=new Qe({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.agent.workflow <span class="hljs-keyword">import</span> (
    AgentWorkflow,
    FunctionAgent,
    ReActAgent,
)

<span class="hljs-comment"># Define algunas herramientas</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Suma dos números.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a + b


<span class="hljs-keyword">def</span> <span class="hljs-title function_">subtract</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Resta dos números.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a - b


<span class="hljs-comment"># Crea configuraciones de agentes</span>
<span class="hljs-comment"># NOTA: podemos usar FunctionAgent o ReActAgent aquí.</span>
<span class="hljs-comment"># FunctionAgent funciona para LLMs con una API de llamada de funciones.</span>
<span class="hljs-comment"># ReActAgent funciona para cualquier LLM.</span>
calculator_agent = ReActAgent(
    name=<span class="hljs-string">&quot;calculadora&quot;</span>,
    description=<span class="hljs-string">&quot;Realiza operaciones aritméticas básicas&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;Eres un asistente de calculadora. Usa tus herramientas para cualquier operación matemática.&quot;</span>,
    tools=[add, subtract],
    llm=llm,
)

query_agent = ReActAgent(
    name=<span class="hljs-string">&quot;búsqueda_de_información&quot;</span>,
    description=<span class="hljs-string">&quot;Busca información sobre XYZ&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;Usa tu herramienta para consultar un sistema RAG y responder información sobre XYZ&quot;</span>,
    tools=[query_engine_tool],
    llm=llm
)

<span class="hljs-comment"># Crea y ejecuta el flujo de trabajo</span>
agent = AgentWorkflow(
    agents=[calculator_agent, query_agent], root_agent=<span class="hljs-string">&quot;calculadora&quot;</span>
)

<span class="hljs-comment"># Ejecuta el sistema</span>
response = <span class="hljs-keyword">await</span> agent.run(user_msg=<span class="hljs-string">&quot;¿Puedes sumar 5 y 3?&quot;</span>)`,wrap:!1}}),L=new Mn({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/unit2/llama-index/agents.mdx"}}),{c(){c=o("meta"),D=s(),H=o("p"),K=s(),u(j.$$.fragment),O=s(),T=o("p"),T.textContent=Ee,ee=s(),w=o("p"),w.textContent=ze,ne=s(),g=o("blockquote"),g.innerHTML=ke,ae=s(),h=o("p"),h.innerHTML=qe,te=s(),f=o("p"),f.innerHTML=Ae,se=s(),I=o("ol"),I.innerHTML=_e,le=s(),b=o("blockquote"),b.innerHTML=Re,oe=s(),u(B.$$.fragment),ie=s(),U=o("blockquote"),U.innerHTML=Se,re=s(),C=o("p"),C.innerHTML=Ye,ce=s(),W=o("p"),W.textContent=Xe,ue=s(),G=o("p"),G.textContent=Fe,pe=s(),u(Z.$$.fragment),me=s(),x=o("p"),x.innerHTML=Ne,Me=s(),u(Q.$$.fragment),de=s(),V=o("p"),V.innerHTML=Le,ye=s(),v=o("p"),v.textContent=He,be=s(),u(E.$$.fragment),Ue=s(),z=o("p"),z.innerHTML=$e,Je=s(),k=o("p"),k.innerHTML=Pe,je=s(),q=o("p"),q.innerHTML=De,Te=s(),A=o("p"),A.innerHTML=Ke,we=s(),u(_.$$.fragment),ge=s(),u(R.$$.fragment),he=s(),S=o("p"),S.innerHTML=Oe,fe=s(),Y=o("p"),Y.textContent=en,Ie=s(),X=o("p"),X.textContent=nn,Be=s(),u(F.$$.fragment),Ce=s(),J=o("blockquote"),J.innerHTML=an,We=s(),N=o("p"),N.innerHTML=tn,Ge=s(),u(L.$$.fragment),Ze=s(),$=o("p"),this.h()},l(e){const n=pn("svelte-u9bgzb",document.head);c=i(n,"META",{name:!0,content:!0}),n.forEach(a),D=l(e),H=i(e,"P",{}),sn(H).forEach(a),K=l(e),p(j.$$.fragment,e),O=l(e),T=i(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-sdyhau"&&(T.textContent=Ee),ee=l(e),w=i(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-13l1wq2"&&(w.textContent=ze),ne=l(e),g=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(g)!=="svelte-11duboz"&&(g.innerHTML=ke),ae=l(e),h=i(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-15neg43"&&(h.innerHTML=qe),te=l(e),f=i(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-14dee9q"&&(f.innerHTML=Ae),se=l(e),I=i(e,"OL",{"data-svelte-h":!0}),r(I)!=="svelte-rbabkw"&&(I.innerHTML=_e),le=l(e),b=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-q682b1"&&(b.innerHTML=Re),oe=l(e),p(B.$$.fragment,e),ie=l(e),U=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-o2zejh"&&(U.innerHTML=Se),re=l(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-soh9gx"&&(C.innerHTML=Ye),ce=l(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-35kesw"&&(W.textContent=Xe),ue=l(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-gww4kt"&&(G.textContent=Fe),pe=l(e),p(Z.$$.fragment,e),me=l(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-q54fuk"&&(x.innerHTML=Ne),Me=l(e),p(Q.$$.fragment,e),de=l(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-u9nts9"&&(V.innerHTML=Le),ye=l(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-3mrzta"&&(v.textContent=He),be=l(e),p(E.$$.fragment,e),Ue=l(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-hxl336"&&(z.innerHTML=$e),Je=l(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1srircl"&&(k.innerHTML=Pe),je=l(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1okujzi"&&(q.innerHTML=De),Te=l(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1tgvryu"&&(A.innerHTML=Ke),we=l(e),p(_.$$.fragment,e),ge=l(e),p(R.$$.fragment,e),he=l(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1ij28k7"&&(S.innerHTML=Oe),fe=l(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1nm3g2f"&&(Y.textContent=en),Ie=l(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1hdefld"&&(X.textContent=nn),Be=l(e),p(F.$$.fragment,e),Ce=l(e),J=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-xed67n"&&(J.innerHTML=an),We=l(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-hobv74"&&(N.innerHTML=tn),Ge=l(e),p(L.$$.fragment,e),Ze=l(e),$=i(e,"P",{}),sn($).forEach(a),this.h()},h(){P(c,"name","hf:doc:metadata"),P(c,"content",yn),P(b,"class","tip"),P(U,"class","tip"),P(J,"class","tip")},m(e,n){mn(document.head,c),t(e,D,n),t(e,H,n),t(e,K,n),m(j,e,n),t(e,O,n),t(e,T,n),t(e,ee,n),t(e,w,n),t(e,ne,n),t(e,g,n),t(e,ae,n),t(e,h,n),t(e,te,n),t(e,f,n),t(e,se,n),t(e,I,n),t(e,le,n),t(e,b,n),t(e,oe,n),m(B,e,n),t(e,ie,n),t(e,U,n),t(e,re,n),t(e,C,n),t(e,ce,n),t(e,W,n),t(e,ue,n),t(e,G,n),t(e,pe,n),m(Z,e,n),t(e,me,n),t(e,x,n),t(e,Me,n),m(Q,e,n),t(e,de,n),t(e,V,n),t(e,ye,n),t(e,v,n),t(e,be,n),m(E,e,n),t(e,Ue,n),t(e,z,n),t(e,Je,n),t(e,k,n),t(e,je,n),t(e,q,n),t(e,Te,n),t(e,A,n),t(e,we,n),m(_,e,n),t(e,ge,n),m(R,e,n),t(e,he,n),t(e,S,n),t(e,fe,n),t(e,Y,n),t(e,Ie,n),t(e,X,n),t(e,Be,n),m(F,e,n),t(e,Ce,n),t(e,J,n),t(e,We,n),t(e,N,n),t(e,Ge,n),m(L,e,n),t(e,Ze,n),t(e,$,n),xe=!0},p:on,i(e){xe||(M(j.$$.fragment,e),M(B.$$.fragment,e),M(Z.$$.fragment,e),M(Q.$$.fragment,e),M(E.$$.fragment,e),M(_.$$.fragment,e),M(R.$$.fragment,e),M(F.$$.fragment,e),M(L.$$.fragment,e),xe=!0)},o(e){d(j.$$.fragment,e),d(B.$$.fragment,e),d(Z.$$.fragment,e),d(Q.$$.fragment,e),d(E.$$.fragment,e),d(_.$$.fragment,e),d(R.$$.fragment,e),d(F.$$.fragment,e),d(L.$$.fragment,e),xe=!1},d(e){e&&(a(D),a(H),a(K),a(O),a(T),a(ee),a(w),a(ne),a(g),a(ae),a(h),a(te),a(f),a(se),a(I),a(le),a(b),a(oe),a(ie),a(U),a(re),a(C),a(ce),a(W),a(ue),a(G),a(pe),a(me),a(x),a(Me),a(de),a(V),a(ye),a(v),a(be),a(Ue),a(z),a(Je),a(k),a(je),a(q),a(Te),a(A),a(we),a(ge),a(he),a(S),a(fe),a(Y),a(Ie),a(X),a(Be),a(Ce),a(J),a(We),a(N),a(Ge),a(Ze),a($)),a(c),y(j,e),y(B,e),y(Z,e),y(Q,e),y(E,e),y(_,e),y(R,e),y(F,e),y(L,e)}}}const yn='{"title":"Usando Agentes en LlamaIndex","local":"usando-agentes-en-llamaindex","sections":[{"title":"Inicializando Agentes","local":"inicializando-agentes","sections":[],"depth":2},{"title":"Creando Agentes RAG con QueryEngineTools","local":"creando-agentes-rag-con-queryenginetools","sections":[],"depth":2},{"title":"Creando Sistemas Multi-agente","local":"creando-sistemas-multi-agente","sections":[],"depth":2}],"depth":1}';function bn(ve){return rn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gn extends cn{constructor(c){super(),un(this,c,bn,dn,ln,{})}}export{gn as component};
