import{s as Ht,f as Rt,n as xt,o as Nt}from"../chunks/scheduler.37c15a92.js";import{S as Qt,i as zt,g as i,s as n,r as d,A as St,h as r,f as t,c as s,j as Et,u as M,x as o,k as Ze,y as _t,a as l,v as c,d as p,t as m,w as u}from"../chunks/index.2bf4358c.js";import{C as Ie}from"../chunks/CodeBlock.4e987730.js";import{C as Yt}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as y}from"../chunks/Heading.8ada512a.js";import{E as qt}from"../chunks/getInferenceSnippets.0aa3753f.js";function kt(qa){let U,We,Be,Ve,J,$e,h,Ee,b,ka='Como exploramos en la <a href="https://huggingface.co/learn/agents-course/unit1/tools" rel="nofollow">unidad 1</a>, los agentes utilizan herramientas para realizar diversas acciones. En <code>smolagents</code>, las herramientas son tratadas como <strong>funciones que un LLM puede llamar dentro de un sistema de agentes</strong>.',He,j,Aa="Para interactuar con una herramienta, el LLM necesita una <strong>descripción de la interfaz</strong> con estos componentes clave:",Re,f,Xa="<li><strong>Nombre</strong>: Cómo se llama la herramienta</li> <li><strong>Descripción de la herramienta</strong>: Qué hace la herramienta</li> <li><strong>Tipos de entrada y descripciones</strong>: Qué argumentos acepta la herramienta</li> <li><strong>Tipo de salida</strong>: Qué devuelve la herramienta</li>",xe,g,Fa="Por ejemplo, mientras prepara una fiesta en la Mansión Wayne, Alfred necesita varias herramientas para recopilar información - desde buscar servicios de catering hasta encontrar ideas para temas de fiesta. Así es como podría verse la interfaz de una herramienta de búsqueda simple:",Ne,w,La="<li><strong>Nombre:</strong> <code>web_search</code></li> <li><strong>Descripción de la herramienta:</strong> Busca en la web consultas específicas</li> <li><strong>Entrada:</strong> <code>query</code> (cadena) - El término de búsqueda a consultar</li> <li><strong>Salida:</strong> Cadena que contiene los resultados de la búsqueda</li>",Qe,C,Pa="Al utilizar estas herramientas, Alfred puede tomar decisiones informadas y recopilar toda la información necesaria para planificar la fiesta perfecta.",ze,v,Da="A continuación, puedes ver una animación que ilustra cómo se gestiona una llamada a una herramienta:",Se,I,Ka='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/Agent_ManimCE.gif" alt="Pipeline de agente de https://huggingface.co/docs/smolagents/conceptual_guides/react"/>',_e,B,Ye,G,Oa="En <code>smolagents</code>, las herramientas pueden definirse de dos maneras:",qe,Z,et="<li><strong>Usando el decorador <code>@tool</code></strong> para herramientas simples basadas en funciones</li> <li><strong>Creando una subclase de <code>Tool</code></strong> para funcionalidades más complejas</li>",ke,W,Ae,V,at="El decorador <code>@tool</code> es <strong>la forma recomendada para definir herramientas simples</strong>. Internamente, smolagents analizará la información básica sobre la función desde Python. Por lo tanto, si nombras tu función claramente y escribes un buen docstring, será más fácil para el LLM utilizarla.",Xe,$,tt="Usando este enfoque, definimos una función con:",Fe,E,lt="<li><strong>Un nombre de función claro y descriptivo</strong> que ayuda al LLM a entender su propósito.</li> <li><strong>Anotaciones de tipo tanto para entradas como para salidas</strong> para garantizar un uso adecuado.</li> <li><strong>Una descripción detallada</strong>, que incluye una sección <code>Args:</code> donde cada argumento se describe explícitamente. Estas descripciones proporcionan un contexto valioso para el LLM, por lo que es importante escribirlas cuidadosamente.</li>",Le,H,Pe,R,nt,De,T,st='<p>Puedes seguir el código en <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/tools.ipynb" target="_blank">este notebook</a> que puedes ejecutar usando Google Colab.</p>',Ke,x,it="Imaginemos que Alfred ya ha decidido el menú para la fiesta, pero ahora necesita ayuda para preparar comida para un número tan grande de invitados. Para hacerlo, le gustaría contratar un servicio de catering y necesita identificar las opciones mejor valoradas disponibles. Alfred puede aprovechar una herramienta para buscar los mejores servicios de catering en su área.",Oe,N,rt="A continuación se muestra un ejemplo de cómo Alfred puede usar el decorador <code>@tool</code> para lograrlo:",ea,Q,aa,z,ta,S,ot='Este enfoque implica crear una subclase de <a href="https://huggingface.co/docs/smolagents/v1.8.1/en/reference/tools#smolagents.Tool" rel="nofollow"><code>Tool</code></a>. Para herramientas complejas, podemos implementar una clase en lugar de una función de Python. La clase envuelve la función con metadatos que ayudan al LLM a entender cómo usarla de manera efectiva. En esta clase, definimos:',la,_,dt="<li><code>name</code>: El nombre de la herramienta.</li> <li><code>description</code>: Una descripción utilizada para completar el prompt del sistema del agente.</li> <li><code>inputs</code>: Un diccionario con claves <code>type</code> y <code>description</code>, proporcionando información para ayudar al intérprete de Python a procesar las entradas.</li> <li><code>output_type</code>: Especifica el tipo de salida esperado.</li> <li><code>forward</code>: El método que contiene la lógica de inferencia a ejecutar.</li>",na,Y,Mt="A continuación, podemos ver un ejemplo de una herramienta construida usando <code>Tool</code> y cómo integrarla dentro de un <code>CodeAgent</code>.",sa,q,ia,k,ct="La fiesta de Alfred en la mansión es un <strong>evento temático de superhéroes</strong>, pero necesita algunas ideas creativas para hacerla verdaderamente especial. Como anfitrión fantástico, quiere sorprender a los invitados con un tema único.",ra,A,pt="Para hacer esto, puede usar un agente que genere ideas de fiestas temáticas de superhéroes basadas en una categoría dada. De esta manera, Alfred puede encontrar el tema de fiesta perfecto para impresionar a sus invitados.",oa,X,da,F,mt="Con esta herramienta, ¡Alfred será el mejor anfitrión, impresionando a sus invitados con una fiesta temática de superhéroes que no olvidarán! 🦸‍♂️🦸‍♀️",Ma,L,ca,P,ut='<code>smolagents</code> viene con un conjunto de herramientas preintegradas que pueden inyectarse directamente en tu agente. La <a href="https://huggingface.co/docs/smolagents/guided_tour?build-a-tool=Decorate+a+function+with+%40tool#default-toolbox" rel="nofollow">caja de herramientas predeterminada</a> incluye:',pa,D,yt="<li><strong>PythonInterpreterTool</strong></li> <li><strong>FinalAnswerTool</strong></li> <li><strong>UserInputTool</strong></li> <li><strong>DuckDuckGoSearchTool</strong></li> <li><strong>GoogleSearchTool</strong></li> <li><strong>VisitWebpageTool</strong></li>",ma,K,Ut="Alfred podría usar varias herramientas para asegurar una fiesta impecable en la Mansión Wayne:",ua,O,Tt="<li><p>Primero, podría usar la <code>DuckDuckGoSearchTool</code> para encontrar ideas creativas para fiestas temáticas de superhéroes.</p></li> <li><p>Para el catering, confiaría en la <code>GoogleSearchTool</code> para encontrar los servicios mejor valorados en Gotham.</p></li> <li><p>Para gestionar la distribución de asientos, Alfred podría realizar cálculos con la <code>PythonInterpreterTool</code>.</p></li> <li><p>Una vez recopilado todo, compilaría el plan usando la <code>FinalAnswerTool</code>.</p></li>",ya,ee,Jt="Con estas herramientas, Alfred garantiza que la fiesta sea excepcional e impecable. 🦇💡",Ua,ae,Ta,te,ht="Una de las características más poderosas de <strong>smolagents</strong> es su capacidad para compartir herramientas personalizadas en el Hub e integrar perfectamente herramientas creadas por la comunidad. Esto incluye la conexión con <strong>HF Spaces</strong> y <strong>herramientas de LangChain</strong>, mejorando significativamente la capacidad de Alfred para organizar una fiesta inolvidable en la Mansión Wayne. 🎭",Ja,le,bt="Con estas integraciones, Alfred puede aprovechar herramientas avanzadas de planificación de eventos, ya sea ajustar la iluminación para el ambiente perfecto, seleccionar la lista de reproducción ideal para la fiesta, o coordinar con los mejores servicios de catering de Gotham.",ha,ne,jt="Aquí hay ejemplos que muestran cómo estas funcionalidades pueden elevar la experiencia de la fiesta:",ba,se,ja,ie,ft="¡Compartir tu herramienta personalizada con la comunidad es fácil! Simplemente súbela a tu cuenta de Hugging Face usando el método <code>push_to_hub()</code>.",fa,re,gt="Por ejemplo, Alfred puede compartir su <code>party_theme_tool</code> para ayudar a otros a encontrar los mejores servicios de catering en Gotham. Así es cómo hacerlo:",ga,oe,wa,de,Ca,Me,wt="Puedes importar fácilmente herramientas creadas por otros usuarios usando la función <code>load_tool()</code>. Por ejemplo, Alfred podría querer generar una imagen promocional para la fiesta usando IA. En lugar de construir una herramienta desde cero, puede aprovechar una predefinida de la comunidad:",va,ce,Ia,pe,Ba,me,Ct="También puedes importar un HF Space como herramienta usando <code>Tool.from_space()</code>. Esto abre posibilidades para integrar miles de spaces de la comunidad para tareas desde generación de imágenes hasta análisis de datos.",Ga,ue,vt="La herramienta se conectará con el backend Gradio del space usando <code>gradio_client</code>, así que asegúrate de instalarlo via <code>pip</code> si aún no lo tienes.",Za,ye,It="Para la fiesta, Alfred puede usar un HF Space existente para la generación de la imagen generada por IA que se usará en el anuncio (en lugar de la herramienta preintegrada que mencionamos antes). ¡Vamos a construirla!",Wa,Ue,Va,Te,$a,Je,Bt="Discutiremos el framework <code>LangChain</code> en las próximas secciones. Por ahora, solo notamos que ¡podemos reutilizar herramientas de LangChain en tu flujo de trabajo de smolagents!",Ea,he,Gt="Puedes cargar fácilmente herramientas de LangChain usando el método <code>Tool.from_langchain()</code>. Alfred, siempre perfeccionista, está preparando una espectacular noche de superhéroes en la Mansión Wayne mientras los Wayne están fuera. Para asegurarse de que cada detalle supere las expectativas, aprovecha las herramientas de LangChain para encontrar ideas de entretenimiento de primera categoría.",Ha,be,Zt="Al usar <code>Tool.from_langchain()</code>, Alfred añade sin esfuerzo funcionalidades de búsqueda avanzadas a su smolagent, permitiéndole descubrir ideas y servicios exclusivos para fiestas con solo unos pocos comandos.",Ra,je,Wt="Así es como lo hace:",xa,fe,Na,ge,Vt="Con esta configuración, Alfred puede descubrir rápidamente opciones de entretenimiento lujosas, asegurando que los invitados de élite de Gotham tengan una experiencia inolvidable. ¡Esta herramienta le ayuda a organizar el evento temático de superhéroes perfecto para la Mansión Wayne! 🎉",Qa,we,za,Ce,$t='<li><a href="https://huggingface.co/docs/smolagents/tutorials/tools" rel="nofollow">Tutorial de Herramientas</a> - Explora este tutorial para aprender a trabajar efectivamente con herramientas.</li> <li><a href="https://huggingface.co/docs/smolagents/v1.8.1/en/reference/tools" rel="nofollow">Documentación de Herramientas</a> - Documentación de referencia completa sobre herramientas.</li> <li><a href="https://huggingface.co/docs/smolagents/v1.8.1/en/guided_tour#tools" rel="nofollow">Tour Guiado de Herramientas</a> - Un tour guiado paso a paso para ayudarte a construir y utilizar herramientas eficientemente.</li> <li><a href="https://huggingface.co/docs/smolagents/tutorials/building_good_agents" rel="nofollow">Construyendo Agentes Efectivos</a> - Una guía detallada sobre mejores prácticas para desarrollar agentes de función personalizados fiables y de alto rendimiento.</li>',Sa,ve,_a,Ge,Ya;return J=new Yt({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/tools.ipynb"}]}}),h=new y({props:{title:"Herramientas",local:"herramientas",headingTag:"h1"}}),B=new y({props:{title:"Métodos de Creación de Herramientas",local:"métodos-de-creación-de-herramientas",headingTag:"h2"}}),W=new y({props:{title:"El Decorador @tool",local:"el-decorador-tool",headingTag:"h3"}}),H=new y({props:{title:"Generando una herramienta que recupera el servicio de catering mejor valorado",local:"generando-una-herramienta-que-recupera-el-servicio-de-catering-mejor-valorado",headingTag:"h4"}}),Q=new Ie({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel, tool

<span class="hljs-comment"># Imaginemos que tenemos una función que obtiene los servicios de catering mejor valorados.</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">catering_service_tool</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Esta herramienta devuelve el servicio de catering mejor valorado en Ciudad Gótica.
    
    Args:
        query: Un término de búsqueda para encontrar servicios de catering.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Lista de ejemplo de servicios de catering y sus calificaciones</span>
    services = {
        <span class="hljs-string">&quot;Gotham Catering Co.&quot;</span>: <span class="hljs-number">4.9</span>,
        <span class="hljs-string">&quot;Wayne Manor Catering&quot;</span>: <span class="hljs-number">4.8</span>,
        <span class="hljs-string">&quot;Gotham City Events&quot;</span>: <span class="hljs-number">4.7</span>,
    }
    
    <span class="hljs-comment"># Encuentra el servicio de catering mejor valorado (simulando el filtrado de consultas de búsqueda)</span>
    best_service = <span class="hljs-built_in">max</span>(services, key=services.get)
    
    <span class="hljs-keyword">return</span> best_service


agent = CodeAgent(tools=[catering_service_tool], model=InferenceClientModel())

<span class="hljs-comment"># Ejecuta el agente para encontrar el mejor servicio de catering</span>
result = agent.run(
    <span class="hljs-string">&quot;¿Puedes darme el nombre del servicio de catering mejor valorado en Ciudad Gótica?&quot;</span>
)

<span class="hljs-built_in">print</span>(result)   <span class="hljs-comment"># Salida: Gotham Catering Co.</span>`,wrap:!1}}),z=new y({props:{title:"Definiendo una Herramienta como una Clase de Python",local:"definiendo-una-herramienta-como-una-clase-de-python",headingTag:"h3"}}),q=new y({props:{title:"Generando una herramienta para generar ideas sobre la fiesta temática de superhéroes",local:"generando-una-herramienta-para-generar-ideas-sobre-la-fiesta-temática-de-superhéroes",headingTag:"h4"}}),X=new Ie({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTJDJTIwQ29kZUFnZW50JTJDJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwlMEElMEFjbGFzcyUyMFN1cGVyaGVyb1BhcnR5VGhlbWVUb29sKFRvb2wpJTNBJTBBJTIwJTIwJTIwJTIwbmFtZSUyMCUzRCUyMCUyMnN1cGVyaGVyb19wYXJ0eV90aGVtZV9nZW5lcmF0b3IlMjIlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUyMCUzRCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMEVzdGElMjBoZXJyYW1pZW50YSUyMHN1Z2llcmUlMjBpZGVhcyUyMGNyZWF0aXZhcyUyMHBhcmElMjBmaWVzdGFzJTIwdGVtJUMzJUExdGljYXMlMjBkZSUyMHN1cGVyaCVDMyVBOXJvZXMlMjBiYXNhZGFzJTIwZW4lMjB1bmElMjBjYXRlZ29yJUMzJUFEYS4lMEElMjAlMjAlMjAlMjBEZXZ1ZWx2ZSUyMHVuYSUyMGlkZWElMjAlQzMlQkFuaWNhJTIwZGUlMjB0ZW1hJTIwcGFyYSUyMGxhJTIwZmllc3RhLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNhdGVnb3J5JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIyRWwlMjB0aXBvJTIwZGUlMjBmaWVzdGElMjBkZSUyMHN1cGVyaCVDMyVBOXJvZXMlMjAocG9yJTIwZWplbXBsbyUyQyUyMCdoJUMzJUE5cm9lcyUyMGNsJUMzJUExc2ljb3MnJTJDJTIwJ21hc2NhcmFkYSUyMGRlJTIwdmlsbGFub3MnJTJDJTIwJ0dvdGhhbSUyMGZ1dHVyaXN0YScpLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTIwJTNEJTIwJTIyc3RyaW5nJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwY2F0ZWdvcnklM0ElMjBzdHIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGhlbWVzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY2xhc3NpYyUyMGhlcm9lcyUyMiUzQSUyMCUyMkdhbGElMjBkZSUyMGxhJTIwTGlnYSUyMGRlJTIwbGElMjBKdXN0aWNpYSUzQSUyMExvcyUyMGludml0YWRvcyUyMHZpZW5lbiUyMHZlc3RpZG9zJTIwY29tbyUyMHN1cyUyMGglQzMlQTlyb2VzJTIwZmF2b3JpdG9zJTIwZGUlMjBEQyUyMGNvbiUyMGMlQzMlQjNjdGVsZXMlMjB0ZW0lQzMlQTF0aWNvcyUyMGNvbW8lMjAnRWwlMjBQb25jaGUlMjBkZSUyMEtyeXB0b25pdGEnLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZpbGxhaW4lMjBtYXNxdWVyYWRlJTIyJTNBJTIwJTIyQmFpbGUlMjBkZSUyMGxvcyUyMFAlQzMlQURjYXJvcyUyMGRlJTIwR290aGFtJTNBJTIwVW5hJTIwbWFzY2FyYWRhJTIwbWlzdGVyaW9zYSUyMGRvbmRlJTIwbG9zJTIwaW52aXRhZG9zJTIwc2UlMjB2aXN0ZW4lMjBjb21vJTIwdmlsbGFub3MlMjBjbCVDMyVBMXNpY29zJTIwZGUlMjBCYXRtYW4uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZnV0dXJpc3RpYyUyMEdvdGhhbSUyMiUzQSUyMCUyMk5vY2hlJTIwTmVvLUdvdGhhbSUzQSUyMFVuYSUyMGZpZXN0YSUyMGRlJTIwZXN0aWxvJTIwY3liZXJwdW5rJTIwaW5zcGlyYWRhJTIwZW4lMjBCYXRtYW4lMjBCZXlvbmQlMkMlMjBjb24lMjBkZWNvcmFjaW9uZXMlMjBkZSUyMG5lJUMzJUIzbiUyMHklMjBnYWRnZXRzJTIwZnV0dXJpc3Rhcy4lMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjB0aGVtZXMuZ2V0KGNhdGVnb3J5Lmxvd2VyKCklMkMlMjAlMjJJZGVhJTIwZGUlMjBmaWVzdGElMjB0ZW0lQzMlQTF0aWNhJTIwbm8lMjBlbmNvbnRyYWRhLiUyMFBydWViYSUyMGNvbiUyMCdoJUMzJUE5cm9lcyUyMGNsJUMzJUExc2ljb3MnJTJDJTIwJ21hc2NhcmFkYSUyMGRlJTIwdmlsbGFub3MnJTIwbyUyMCdHb3RoYW0lMjBmdXR1cmlzdGEnLiUyMiklMEElMEElMjMlMjBJbnN0YW5jaWElMjBsYSUyMGhlcnJhbWllbnRhJTBBcGFydHlfdGhlbWVfdG9vbCUyMCUzRCUyMFN1cGVyaGVyb1BhcnR5VGhlbWVUb29sKCklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QnBhcnR5X3RoZW1lX3Rvb2wlNUQlMkMlMjBtb2RlbCUzREluZmVyZW5jZUNsaWVudE1vZGVsKCkpJTBBJTBBJTIzJTIwRWplY3V0YSUyMGVsJTIwYWdlbnRlJTIwcGFyYSUyMGdlbmVyYXIlMjB1bmElMjBpZGVhJTIwZGUlMjB0ZW1hJTIwcGFyYSUyMGxhJTIwZmllc3RhJTBBcmVzdWx0JTIwJTNEJTIwYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMiVDMiVCRkN1JUMzJUExbCUyMHNlciVDMyVBRGElMjB1bmElMjBidWVuYSUyMGlkZWElMjBwYXJhJTIwdW5hJTIwZmllc3RhJTIwZGUlMjBzdXBlcmglQzMlQTlyb2VzJTIwY29uJTIwZWwlMjB0ZW1hJTIwJ21hc2NhcmFkYSUyMGRlJTIwdmlsbGFub3MnJTNGJTIyJTBBKSUwQSUwQXByaW50KHJlc3VsdCklMjAlMjAlMjMlMjBTYWxpZGElM0ElMjAlMjJCYWlsZSUyMGRlJTIwbG9zJTIwUCVDMyVBRGNhcm9zJTIwZGUlMjBHb3RoYW0lM0ElMjBVbmElMjBtYXNjYXJhZGElMjBtaXN0ZXJpb3NhJTIwZG9uZGUlMjBsb3MlMjBpbnZpdGFkb3MlMjBzZSUyMHZpc3RlbiUyMGNvbW8lMjB2aWxsYW5vcyUyMGNsJUMzJUExc2ljb3MlMjBkZSUyMEJhdG1hbi4lMjI=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool, CodeAgent, InferenceClientModel

<span class="hljs-keyword">class</span> <span class="hljs-title class_">SuperheroPartyThemeTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;superhero_party_theme_generator&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    Esta herramienta sugiere ideas creativas para fiestas temáticas de superhéroes basadas en una categoría.
    Devuelve una idea única de tema para la fiesta.&quot;&quot;&quot;</span>
    
    inputs = {
        <span class="hljs-string">&quot;category&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;El tipo de fiesta de superhéroes (por ejemplo, &#x27;héroes clásicos&#x27;, &#x27;mascarada de villanos&#x27;, &#x27;Gotham futurista&#x27;).&quot;</span>,
        }
    }
    
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, category: <span class="hljs-built_in">str</span></span>):
        themes = {
            <span class="hljs-string">&quot;classic heroes&quot;</span>: <span class="hljs-string">&quot;Gala de la Liga de la Justicia: Los invitados vienen vestidos como sus héroes favoritos de DC con cócteles temáticos como &#x27;El Ponche de Kryptonita&#x27;.&quot;</span>,
            <span class="hljs-string">&quot;villain masquerade&quot;</span>: <span class="hljs-string">&quot;Baile de los Pícaros de Gotham: Una mascarada misteriosa donde los invitados se visten como villanos clásicos de Batman.&quot;</span>,
            <span class="hljs-string">&quot;futuristic Gotham&quot;</span>: <span class="hljs-string">&quot;Noche Neo-Gotham: Una fiesta de estilo cyberpunk inspirada en Batman Beyond, con decoraciones de neón y gadgets futuristas.&quot;</span>
        }
        
        <span class="hljs-keyword">return</span> themes.get(category.lower(), <span class="hljs-string">&quot;Idea de fiesta temática no encontrada. Prueba con &#x27;héroes clásicos&#x27;, &#x27;mascarada de villanos&#x27; o &#x27;Gotham futurista&#x27;.&quot;</span>)

<span class="hljs-comment"># Instancia la herramienta</span>
party_theme_tool = SuperheroPartyThemeTool()
agent = CodeAgent(tools=[party_theme_tool], model=InferenceClientModel())

<span class="hljs-comment"># Ejecuta el agente para generar una idea de tema para la fiesta</span>
result = agent.run(
    <span class="hljs-string">&quot;¿Cuál sería una buena idea para una fiesta de superhéroes con el tema &#x27;mascarada de villanos&#x27;?&quot;</span>
)

<span class="hljs-built_in">print</span>(result)  <span class="hljs-comment"># Salida: &quot;Baile de los Pícaros de Gotham: Una mascarada misteriosa donde los invitados se visten como villanos clásicos de Batman.&quot;</span>`,wrap:!1}}),L=new y({props:{title:"Caja de Herramientas Predeterminada",local:"caja-de-herramientas-predeterminada",headingTag:"h2"}}),ae=new y({props:{title:"Compartir e Importar Herramientas",local:"compartir-e-importar-herramientas",headingTag:"h2"}}),se=new y({props:{title:"Compartir una Herramienta en el Hub",local:"compartir-una-herramienta-en-el-hub",headingTag:"h3"}}),oe=new Ie({props:{code:"cGFydHlfdGhlbWVfdG9vbC5wdXNoX3RvX2h1YiglMjIlN0J0dV9ub21icmVfZGVfdXN1YXJpbyU3RCUyRnBhcnR5X3RoZW1lX3Rvb2wlMjIlMkMlMjB0b2tlbiUzRCUyMiUzQ1RVX1RPS0VOX0FQSV9IVUdHSU5HRkFDRUhVQiUzRSUyMik=",highlighted:'party_theme_tool.push_to_hub(<span class="hljs-string">&quot;{tu_nombre_de_usuario}/party_theme_tool&quot;</span>, token=<span class="hljs-string">&quot;&lt;TU_TOKEN_API_HUGGINGFACEHUB&gt;&quot;</span>)',wrap:!1}}),de=new y({props:{title:"Importar una Herramienta desde el Hub",local:"importar-una-herramienta-desde-el-hub",headingTag:"h3"}}),ce=new Ie({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQWltYWdlX2dlbmVyYXRpb25fdG9vbCUyMCUzRCUyMGxvYWRfdG9vbCglMEElMjAlMjAlMjAlMjAlMjJtLXJpYyUyRnRleHQtdG8taW1hZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzREluZmVyZW5jZUNsaWVudE1vZGVsKCklMEEpJTBBJTBBYWdlbnQucnVuKCUyMkdlbmVyYSUyMHVuYSUyMGltYWdlbiUyMGRlJTIwdW5hJTIwbHVqb3NhJTIwZmllc3RhJTIwdGVtJUMzJUExdGljYSUyMGRlJTIwc3VwZXJoJUMzJUE5cm9lcyUyMGVuJTIwbGElMjBNYW5zaSVDMyVCM24lMjBXYXluZSUyMGNvbiUyMHN1cGVyaCVDMyVBOXJvZXMlMjBpbnZlbnRhZG9zLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent, InferenceClientModel

image_generation_tool = load_tool(
    <span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)

agent = CodeAgent(
    tools=[image_generation_tool],
    model=InferenceClientModel()
)

agent.run(<span class="hljs-string">&quot;Genera una imagen de una lujosa fiesta temática de superhéroes en la Mansión Wayne con superhéroes inventados.&quot;</span>)`,wrap:!1}}),pe=new y({props:{title:"Importar un Hugging Face Space como Herramienta",local:"importar-un-hugging-face-space-como-herramienta",headingTag:"h3"}}),Ue=new Ie({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFRvb2wlMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fc3BhY2UoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5hbWUlM0QlMjJpbWFnZV9nZW5lcmF0b3IlMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMkdlbmVyYXIlMjB1bmElMjBpbWFnZW4lMjBhJTIwcGFydGlyJTIwZGUlMjB1biUyMHByb21wdCUyMiUwQSklMEElMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiklMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QmltYWdlX2dlbmVyYXRpb25fdG9vbCU1RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBJTBBYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMk1lam9yYSUyMGVzdGUlMjBwcm9tcHQlMkMlMjBsdWVnbyUyMGdlbmVyYSUyMHVuYSUyMGltYWdlbiUyMGRlbCUyMG1pc21vLiUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMGFkZGl0aW9uYWxfYXJncyUzRCU3Qid1c2VyX3Byb21wdCclM0ElMjAnVW5hJTIwZ3JhbiUyMGZpZXN0YSUyMHRlbSVDMyVBMXRpY2ElMjBkZSUyMHN1cGVyaCVDMyVBOXJvZXMlMjBlbiUyMGxhJTIwTWFuc2klQzMlQjNuJTIwV2F5bmUlMkMlMjBjb24lMjBBbGZyZWQlMjBzdXBlcnZpc2FuZG8lMjB1bmElMjBsdWpvc2ElMjBnYWxhJyU3RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel, Tool

image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generar una imagen a partir de un prompt&quot;</span>
)

model = InferenceClientModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Mejora este prompt, luego genera una imagen del mismo.&quot;</span>, 
    additional_args={<span class="hljs-string">&#x27;user_prompt&#x27;</span>: <span class="hljs-string">&#x27;Una gran fiesta temática de superhéroes en la Mansión Wayne, con Alfred supervisando una lujosa gala&#x27;</span>}
)`,wrap:!1}}),Te=new y({props:{title:"Importar una Herramienta de LangChain",local:"importar-una-herramienta-de-langchain",headingTag:"h3"}}),fe=new Ie({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFRvb2wlMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMFRvb2wuZnJvbV9sYW5nY2hhaW4obG9hZF90b29scyglNUIlMjJzZXJwYXBpJTIyJTVEKSU1QjAlNUQpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJzZWFyY2hfdG9vbCU1RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBJTBBYWdlbnQucnVuKCUyMkJ1c2NhJTIwaWRlYXMlMjBkZSUyMGVudHJldGVuaW1pZW50byUyMGRlJTIwbHVqbyUyMHBhcmElMjB1biUyMGV2ZW50byUyMHRlbSVDMyVBMXRpY28lMjBkZSUyMHN1cGVyaCVDMyVBOXJvZXMlMkMlMjBjb21vJTIwYWN0dWFjaW9uZXMlMjBlbiUyMHZpdm8lMjB5JTIwZXhwZXJpZW5jaWFzJTIwaW50ZXJhY3RpdmFzLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel, Tool

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;Busca ideas de entretenimiento de lujo para un evento temático de superhéroes, como actuaciones en vivo y experiencias interactivas.&quot;</span>)`,wrap:!1}}),we=new y({props:{title:"Recursos",local:"recursos",headingTag:"h2"}}),ve=new qt({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/unit2/smolagents/tools.mdx"}}),{c(){U=i("meta"),We=n(),Be=i("p"),Ve=n(),d(J.$$.fragment),$e=n(),d(h.$$.fragment),Ee=n(),b=i("p"),b.innerHTML=ka,He=n(),j=i("p"),j.innerHTML=Aa,Re=n(),f=i("ul"),f.innerHTML=Xa,xe=n(),g=i("p"),g.textContent=Fa,Ne=n(),w=i("ul"),w.innerHTML=La,Qe=n(),C=i("p"),C.textContent=Pa,ze=n(),v=i("p"),v.textContent=Da,Se=n(),I=i("p"),I.innerHTML=Ka,_e=n(),d(B.$$.fragment),Ye=n(),G=i("p"),G.innerHTML=Oa,qe=n(),Z=i("ol"),Z.innerHTML=et,ke=n(),d(W.$$.fragment),Ae=n(),V=i("p"),V.innerHTML=at,Xe=n(),$=i("p"),$.textContent=tt,Fe=n(),E=i("ul"),E.innerHTML=lt,Le=n(),d(H.$$.fragment),Pe=n(),R=i("img"),De=n(),T=i("blockquote"),T.innerHTML=st,Ke=n(),x=i("p"),x.textContent=it,Oe=n(),N=i("p"),N.innerHTML=rt,ea=n(),d(Q.$$.fragment),aa=n(),d(z.$$.fragment),ta=n(),S=i("p"),S.innerHTML=ot,la=n(),_=i("ul"),_.innerHTML=dt,na=n(),Y=i("p"),Y.innerHTML=Mt,sa=n(),d(q.$$.fragment),ia=n(),k=i("p"),k.innerHTML=ct,ra=n(),A=i("p"),A.textContent=pt,oa=n(),d(X.$$.fragment),da=n(),F=i("p"),F.textContent=mt,Ma=n(),d(L.$$.fragment),ca=n(),P=i("p"),P.innerHTML=ut,pa=n(),D=i("ul"),D.innerHTML=yt,ma=n(),K=i("p"),K.textContent=Ut,ua=n(),O=i("ul"),O.innerHTML=Tt,ya=n(),ee=i("p"),ee.textContent=Jt,Ua=n(),d(ae.$$.fragment),Ta=n(),te=i("p"),te.innerHTML=ht,Ja=n(),le=i("p"),le.textContent=bt,ha=n(),ne=i("p"),ne.textContent=jt,ba=n(),d(se.$$.fragment),ja=n(),ie=i("p"),ie.innerHTML=ft,fa=n(),re=i("p"),re.innerHTML=gt,ga=n(),d(oe.$$.fragment),wa=n(),d(de.$$.fragment),Ca=n(),Me=i("p"),Me.innerHTML=wt,va=n(),d(ce.$$.fragment),Ia=n(),d(pe.$$.fragment),Ba=n(),me=i("p"),me.innerHTML=Ct,Ga=n(),ue=i("p"),ue.innerHTML=vt,Za=n(),ye=i("p"),ye.textContent=It,Wa=n(),d(Ue.$$.fragment),Va=n(),d(Te.$$.fragment),$a=n(),Je=i("p"),Je.innerHTML=Bt,Ea=n(),he=i("p"),he.innerHTML=Gt,Ha=n(),be=i("p"),be.innerHTML=Zt,Ra=n(),je=i("p"),je.textContent=Wt,xa=n(),d(fe.$$.fragment),Na=n(),ge=i("p"),ge.textContent=Vt,Qa=n(),d(we.$$.fragment),za=n(),Ce=i("ul"),Ce.innerHTML=$t,Sa=n(),d(ve.$$.fragment),_a=n(),Ge=i("p"),this.h()},l(e){const a=St("svelte-u9bgzb",document.head);U=r(a,"META",{name:!0,content:!0}),a.forEach(t),We=s(e),Be=r(e,"P",{}),Et(Be).forEach(t),Ve=s(e),M(J.$$.fragment,e),$e=s(e),M(h.$$.fragment,e),Ee=s(e),b=r(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1vquyog"&&(b.innerHTML=ka),He=s(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1ffc0qb"&&(j.innerHTML=Aa),Re=s(e),f=r(e,"UL",{"data-svelte-h":!0}),o(f)!=="svelte-1u9qy3e"&&(f.innerHTML=Xa),xe=s(e),g=r(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1jdcqjs"&&(g.textContent=Fa),Ne=s(e),w=r(e,"UL",{"data-svelte-h":!0}),o(w)!=="svelte-g5pzg5"&&(w.innerHTML=La),Qe=s(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-14cn6bt"&&(C.textContent=Pa),ze=s(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1d4gp29"&&(v.textContent=Da),Se=s(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-14iql5d"&&(I.innerHTML=Ka),_e=s(e),M(B.$$.fragment,e),Ye=s(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-losady"&&(G.innerHTML=Oa),qe=s(e),Z=r(e,"OL",{"data-svelte-h":!0}),o(Z)!=="svelte-1gwgfyv"&&(Z.innerHTML=et),ke=s(e),M(W.$$.fragment,e),Ae=s(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-11jmxz0"&&(V.innerHTML=at),Xe=s(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-19e8n6w"&&($.textContent=tt),Fe=s(e),E=r(e,"UL",{"data-svelte-h":!0}),o(E)!=="svelte-is9j1j"&&(E.innerHTML=lt),Le=s(e),M(H.$$.fragment,e),Pe=s(e),R=r(e,"IMG",{src:!0,alt:!0}),De=s(e),T=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(T)!=="svelte-nyegvz"&&(T.innerHTML=st),Ke=s(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1phj33a"&&(x.textContent=it),Oe=s(e),N=r(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-o6ahqz"&&(N.innerHTML=rt),ea=s(e),M(Q.$$.fragment,e),aa=s(e),M(z.$$.fragment,e),ta=s(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1uchfjq"&&(S.innerHTML=ot),la=s(e),_=r(e,"UL",{"data-svelte-h":!0}),o(_)!=="svelte-1pxkday"&&(_.innerHTML=dt),na=s(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1r3qbe3"&&(Y.innerHTML=Mt),sa=s(e),M(q.$$.fragment,e),ia=s(e),k=r(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1miih4m"&&(k.innerHTML=ct),ra=s(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-rvosa0"&&(A.textContent=pt),oa=s(e),M(X.$$.fragment,e),da=s(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1e33jkv"&&(F.textContent=mt),Ma=s(e),M(L.$$.fragment,e),ca=s(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-5vnj9j"&&(P.innerHTML=ut),pa=s(e),D=r(e,"UL",{"data-svelte-h":!0}),o(D)!=="svelte-1pasg00"&&(D.innerHTML=yt),ma=s(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-2s1u84"&&(K.textContent=Ut),ua=s(e),O=r(e,"UL",{"data-svelte-h":!0}),o(O)!=="svelte-euiqhi"&&(O.innerHTML=Tt),ya=s(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1f9wu4y"&&(ee.textContent=Jt),Ua=s(e),M(ae.$$.fragment,e),Ta=s(e),te=r(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-wvbuk7"&&(te.innerHTML=ht),Ja=s(e),le=r(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1iy53su"&&(le.textContent=bt),ha=s(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1ku4hoy"&&(ne.textContent=jt),ba=s(e),M(se.$$.fragment,e),ja=s(e),ie=r(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1uocugf"&&(ie.innerHTML=ft),fa=s(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-136gg4"&&(re.innerHTML=gt),ga=s(e),M(oe.$$.fragment,e),wa=s(e),M(de.$$.fragment,e),Ca=s(e),Me=r(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-pf0yzb"&&(Me.innerHTML=wt),va=s(e),M(ce.$$.fragment,e),Ia=s(e),M(pe.$$.fragment,e),Ba=s(e),me=r(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-1raf2m8"&&(me.innerHTML=Ct),Ga=s(e),ue=r(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-lhbhy7"&&(ue.innerHTML=vt),Za=s(e),ye=r(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-1dcwgd5"&&(ye.textContent=It),Wa=s(e),M(Ue.$$.fragment,e),Va=s(e),M(Te.$$.fragment,e),$a=s(e),Je=r(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-2qkpbc"&&(Je.innerHTML=Bt),Ea=s(e),he=r(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-62kksu"&&(he.innerHTML=Gt),Ha=s(e),be=r(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-xn5d7w"&&(be.innerHTML=Zt),Ra=s(e),je=r(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-cwvvl3"&&(je.textContent=Wt),xa=s(e),M(fe.$$.fragment,e),Na=s(e),ge=r(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-1r4npw6"&&(ge.textContent=Vt),Qa=s(e),M(we.$$.fragment,e),za=s(e),Ce=r(e,"UL",{"data-svelte-h":!0}),o(Ce)!=="svelte-1c3sd2l"&&(Ce.innerHTML=$t),Sa=s(e),M(ve.$$.fragment,e),_a=s(e),Ge=r(e,"P",{}),Et(Ge).forEach(t),this.h()},h(){Ze(U,"name","hf:doc:metadata"),Ze(U,"content",At),Rt(R.src,nt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/alfred-catering.jpg")||Ze(R,"src",nt),Ze(R,"alt","Alfred Catering"),Ze(T,"class","tip")},m(e,a){_t(document.head,U),l(e,We,a),l(e,Be,a),l(e,Ve,a),c(J,e,a),l(e,$e,a),c(h,e,a),l(e,Ee,a),l(e,b,a),l(e,He,a),l(e,j,a),l(e,Re,a),l(e,f,a),l(e,xe,a),l(e,g,a),l(e,Ne,a),l(e,w,a),l(e,Qe,a),l(e,C,a),l(e,ze,a),l(e,v,a),l(e,Se,a),l(e,I,a),l(e,_e,a),c(B,e,a),l(e,Ye,a),l(e,G,a),l(e,qe,a),l(e,Z,a),l(e,ke,a),c(W,e,a),l(e,Ae,a),l(e,V,a),l(e,Xe,a),l(e,$,a),l(e,Fe,a),l(e,E,a),l(e,Le,a),c(H,e,a),l(e,Pe,a),l(e,R,a),l(e,De,a),l(e,T,a),l(e,Ke,a),l(e,x,a),l(e,Oe,a),l(e,N,a),l(e,ea,a),c(Q,e,a),l(e,aa,a),c(z,e,a),l(e,ta,a),l(e,S,a),l(e,la,a),l(e,_,a),l(e,na,a),l(e,Y,a),l(e,sa,a),c(q,e,a),l(e,ia,a),l(e,k,a),l(e,ra,a),l(e,A,a),l(e,oa,a),c(X,e,a),l(e,da,a),l(e,F,a),l(e,Ma,a),c(L,e,a),l(e,ca,a),l(e,P,a),l(e,pa,a),l(e,D,a),l(e,ma,a),l(e,K,a),l(e,ua,a),l(e,O,a),l(e,ya,a),l(e,ee,a),l(e,Ua,a),c(ae,e,a),l(e,Ta,a),l(e,te,a),l(e,Ja,a),l(e,le,a),l(e,ha,a),l(e,ne,a),l(e,ba,a),c(se,e,a),l(e,ja,a),l(e,ie,a),l(e,fa,a),l(e,re,a),l(e,ga,a),c(oe,e,a),l(e,wa,a),c(de,e,a),l(e,Ca,a),l(e,Me,a),l(e,va,a),c(ce,e,a),l(e,Ia,a),c(pe,e,a),l(e,Ba,a),l(e,me,a),l(e,Ga,a),l(e,ue,a),l(e,Za,a),l(e,ye,a),l(e,Wa,a),c(Ue,e,a),l(e,Va,a),c(Te,e,a),l(e,$a,a),l(e,Je,a),l(e,Ea,a),l(e,he,a),l(e,Ha,a),l(e,be,a),l(e,Ra,a),l(e,je,a),l(e,xa,a),c(fe,e,a),l(e,Na,a),l(e,ge,a),l(e,Qa,a),c(we,e,a),l(e,za,a),l(e,Ce,a),l(e,Sa,a),c(ve,e,a),l(e,_a,a),l(e,Ge,a),Ya=!0},p:xt,i(e){Ya||(p(J.$$.fragment,e),p(h.$$.fragment,e),p(B.$$.fragment,e),p(W.$$.fragment,e),p(H.$$.fragment,e),p(Q.$$.fragment,e),p(z.$$.fragment,e),p(q.$$.fragment,e),p(X.$$.fragment,e),p(L.$$.fragment,e),p(ae.$$.fragment,e),p(se.$$.fragment,e),p(oe.$$.fragment,e),p(de.$$.fragment,e),p(ce.$$.fragment,e),p(pe.$$.fragment,e),p(Ue.$$.fragment,e),p(Te.$$.fragment,e),p(fe.$$.fragment,e),p(we.$$.fragment,e),p(ve.$$.fragment,e),Ya=!0)},o(e){m(J.$$.fragment,e),m(h.$$.fragment,e),m(B.$$.fragment,e),m(W.$$.fragment,e),m(H.$$.fragment,e),m(Q.$$.fragment,e),m(z.$$.fragment,e),m(q.$$.fragment,e),m(X.$$.fragment,e),m(L.$$.fragment,e),m(ae.$$.fragment,e),m(se.$$.fragment,e),m(oe.$$.fragment,e),m(de.$$.fragment,e),m(ce.$$.fragment,e),m(pe.$$.fragment,e),m(Ue.$$.fragment,e),m(Te.$$.fragment,e),m(fe.$$.fragment,e),m(we.$$.fragment,e),m(ve.$$.fragment,e),Ya=!1},d(e){e&&(t(We),t(Be),t(Ve),t($e),t(Ee),t(b),t(He),t(j),t(Re),t(f),t(xe),t(g),t(Ne),t(w),t(Qe),t(C),t(ze),t(v),t(Se),t(I),t(_e),t(Ye),t(G),t(qe),t(Z),t(ke),t(Ae),t(V),t(Xe),t($),t(Fe),t(E),t(Le),t(Pe),t(R),t(De),t(T),t(Ke),t(x),t(Oe),t(N),t(ea),t(aa),t(ta),t(S),t(la),t(_),t(na),t(Y),t(sa),t(ia),t(k),t(ra),t(A),t(oa),t(da),t(F),t(Ma),t(ca),t(P),t(pa),t(D),t(ma),t(K),t(ua),t(O),t(ya),t(ee),t(Ua),t(Ta),t(te),t(Ja),t(le),t(ha),t(ne),t(ba),t(ja),t(ie),t(fa),t(re),t(ga),t(wa),t(Ca),t(Me),t(va),t(Ia),t(Ba),t(me),t(Ga),t(ue),t(Za),t(ye),t(Wa),t(Va),t($a),t(Je),t(Ea),t(he),t(Ha),t(be),t(Ra),t(je),t(xa),t(Na),t(ge),t(Qa),t(za),t(Ce),t(Sa),t(_a),t(Ge)),t(U),u(J,e),u(h,e),u(B,e),u(W,e),u(H,e),u(Q,e),u(z,e),u(q,e),u(X,e),u(L,e),u(ae,e),u(se,e),u(oe,e),u(de,e),u(ce,e),u(pe,e),u(Ue,e),u(Te,e),u(fe,e),u(we,e),u(ve,e)}}}const At='{"title":"Herramientas","local":"herramientas","sections":[{"title":"Métodos de Creación de Herramientas","local":"métodos-de-creación-de-herramientas","sections":[{"title":"El Decorador @tool","local":"el-decorador-tool","sections":[{"title":"Generando una herramienta que recupera el servicio de catering mejor valorado","local":"generando-una-herramienta-que-recupera-el-servicio-de-catering-mejor-valorado","sections":[],"depth":4}],"depth":3},{"title":"Definiendo una Herramienta como una Clase de Python","local":"definiendo-una-herramienta-como-una-clase-de-python","sections":[{"title":"Generando una herramienta para generar ideas sobre la fiesta temática de superhéroes","local":"generando-una-herramienta-para-generar-ideas-sobre-la-fiesta-temática-de-superhéroes","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Caja de Herramientas Predeterminada","local":"caja-de-herramientas-predeterminada","sections":[],"depth":2},{"title":"Compartir e Importar Herramientas","local":"compartir-e-importar-herramientas","sections":[{"title":"Compartir una Herramienta en el Hub","local":"compartir-una-herramienta-en-el-hub","sections":[],"depth":3},{"title":"Importar una Herramienta desde el Hub","local":"importar-una-herramienta-desde-el-hub","sections":[],"depth":3},{"title":"Importar un Hugging Face Space como Herramienta","local":"importar-un-hugging-face-space-como-herramienta","sections":[],"depth":3},{"title":"Importar una Herramienta de LangChain","local":"importar-una-herramienta-de-langchain","sections":[],"depth":3}],"depth":2},{"title":"Recursos","local":"recursos","sections":[],"depth":2}],"depth":1}';function Xt(qa){return Nt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class el extends Qt{constructor(U){super(),zt(this,U,Xt,kt,Ht,{})}}export{el as component};
