import{s as Js,n as Ts,o as bs}from"../chunks/scheduler.37c15a92.js";import{S as ws,i as Cs,g as i,s,r as M,A as fs,h as o,f as l,c as n,j as Us,u as p,x as r,k as na,y as gs,a,v as u,d as c,t as m,w as d}from"../chunks/index.2bf4358c.js";import{C as j}from"../chunks/CodeBlock.4e987730.js";import{C as hs}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as y}from"../chunks/Heading.8ada512a.js";import{E as Is}from"../chunks/getInferenceSnippets.0aa3753f.js";function Zs(ia){let U,ut,Mt,ct,T,mt,b,dt,J,oa='<p>Puedes seguir el código en <a href="https://huggingface.co/agents-course/notebooks/blob/main/bonus-unit2/monitoring-and-evaluating-agents-notebook.ipynb" target="_blank">este notebook</a> que puedes ejecutar usando Google Colab.</p>',yt,w,ra="En este notebook, aprenderemos cómo <strong>monitorear los pasos internos (trazos) de nuestro agente de IA</strong> y <strong>evaluar su rendimiento</strong> utilizando herramientas de observabilidad de código abierto.",jt,C,Ma="La capacidad de observar y evaluar el comportamiento de un agente es esencial para:",Ut,f,pa="<li>Depurar problemas cuando las tareas fallan o producen resultados subóptimos</li> <li>Monitorear costos y rendimiento en tiempo real</li> <li>Mejorar la fiabilidad y seguridad a través de retroalimentación continua</li>",Jt,g,Tt,h,ua="Antes de ejecutar este notebook, asegúrate de que has:",bt,I,ca='🔲 📚  <strong>Estudiado</strong> <a href="https://huggingface.co/learn/agents-course/unit1/introduction" rel="nofollow">Introducción a los Agentes</a>',wt,Z,ma='🔲 📚  <strong>Estudiado</strong> <a href="https://huggingface.co/learn/agents-course/unit2/smolagents/introduction" rel="nofollow">El framework smolagents</a>',Ct,v,ft,V,da="Necesitaremos algunas librerías que nos permitan ejecutar, monitorear y evaluar nuestros agentes:",gt,W,ht,B,It,E,ya='En este notebook, utilizaremos <a href="https://langfuse.com/" rel="nofollow">Langfuse</a> como nuestra herramienta de observabilidad, pero puedes usar <strong>cualquier otro servicio compatible con OpenTelemetry</strong>. El código a continuación muestra cómo configurar variables de entorno para Langfuse (o cualquier endpoint OTel) y cómo instrumentar tu smolagent.',Zt,G,ja='<strong>Nota:</strong> Si estás utilizando LlamaIndex o LangGraph, puedes encontrar documentación sobre cómo instrumentarlos <a href="https://langfuse.com/docs/integrations/llama-index/workflows" rel="nofollow">aquí</a> y <a href="https://langfuse.com/docs/integrations/langchain/example-python-langgraph" rel="nofollow">aquí</a>.',vt,R,Ua="Primero, vamos a configurar la variable de entorno correcta para establecer la conexión con el endpoint OpenTelemetry de Langfuse.",Vt,k,Wt,$,Ja="También necesitamos configurar nuestro token de Hugging Face para las llamadas de inferencia.",Bt,N,Et,A,Ta="A continuación, podemos configurar un proveedor de trazoss para nuestro OpenTelemetry configurado.",Gt,x,Rt,Y,kt,Q,ba="Aquí hay un simple CodeAgent de smolagents que calcula <code>1+1</code>. Lo ejecutamos para confirmar que la instrumentación está funcionando correctamente. Si todo está configurado correctamente, verás registros/spans en tu panel de observabilidad.",$t,_,Nt,H,wa='Revisa tu <a href="https://cloud.langfuse.com/traces" rel="nofollow">Panel de rastros de Langfuse</a> (o tu herramienta de observabilidad elegida) para confirmar que los spans y registros han sido grabados.',At,X,Ca="Captura de pantalla de ejemplo de Langfuse:",xt,L,fa='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/first-example-trace.png" alt="Ejemplo de rastros en Langfuse"/>',Yt,S,ga='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1b94d6888258e0998329cdb72a371155?timestamp=2025-03-10T11%3A59%3A41.743Z" rel="nofollow">Enlace a  los rastros</a></em>',Qt,F,_t,z,ha="Ahora que has confirmado que tu instrumentación funciona, probemos una consulta más compleja para ver cómo se rastrean las métricas avanzadas (uso de tokens, latencia, costos, etc.).",Ht,q,Xt,P,Lt,D,Ia="La mayoría de las herramientas de observabilidad registran una <strong>rastro</strong> que contiene <strong>spans</strong>, que representan cada paso de la lógica de tu agente. Aquí, el rastro contiene la ejecución general del agente y sub-spans para:",St,K,Za="<li>Las llamadas a herramientas (DuckDuckGoSearchTool)</li> <li>Las llamadas al LLM (InferenceClientModel)</li>",Ft,O,va="Puedes inspeccionarlos para ver precisamente dónde se gasta el tiempo, cuántos tokens se utilizan, etc.:",zt,ee,Va='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/trace-tree.png" alt="Árbol de rastros en Langfuse"/>',qt,te,Wa='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Enlace a los rastros</a></em>',Pt,le,Dt,ae,Ba="En la sección anterior, aprendimos sobre la diferencia entre evaluación en línea y fuera de línea. Ahora, veremos cómo monitorear tu agente en producción y evaluarlo en vivo.",Kt,se,Ot,ne,Ea="<li><strong>Costos</strong> — La instrumentación de smolagents captura el uso de tokens, que puedes transformar en costos aproximados asignando un precio por token.</li> <li><strong>Latencia</strong> — Observa el tiempo que toma completar cada paso, o la ejecución completa.</li> <li><strong>Retroalimentación del Usuario</strong> — Los usuarios pueden proporcionar retroalimentación directa (pulgar arriba/abajo) para ayudar a refinar o corregir el agente.</li> <li><strong>LLM-como-Juez</strong> — Utiliza un LLM separado para evaluar la salida de tu agente en tiempo casi real (por ejemplo, verificando toxicidad o corrección).</li>",el,ie,Ga="A continuación, mostramos ejemplos de estas métricas.",tl,oe,ll,re,Ra="A continuación se muestra una captura de pantalla que muestra el uso para llamadas a <code>Qwen2.5-Coder-32B-Instruct</code>. Esto es útil para ver pasos costosos y optimizar tu agente.",al,Me,ka='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-costs.png" alt="Costos"/>',sl,pe,$a='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Enlace a los rastros</a></em>',nl,ue,il,ce,Na="También podemos ver cuánto tiempo tomó completar cada paso. En el ejemplo a continuación, toda la conversación tomó 32 segundos, que puedes desglosar por paso. Esto te ayuda a identificar cuellos de botella y optimizar tu agente.",ol,me,Aa='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-latency.png" alt="Latencia"/>',rl,de,xa='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Enlace a los rastros</a></em>',Ml,ye,pl,je,Ya="También puedes pasar atributos adicionales, como IDs de usuario, IDs de sesión o etiquetas, configurándolos en los spans. Por ejemplo, la instrumentación de smolagents utiliza OpenTelemetry para adjuntar atributos como <code>langfuse.user.id</code> o etiquetas personalizadas.",ul,Ue,cl,Je,Qa='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-attributes.png" alt="Mejorando las ejecuciones de agentes con métricas adicionales"/>',ml,Te,dl,be,_a='Si tu agente está integrado en una interfaz de usuario, puedes registrar la retroalimentación directa del usuario (como un pulgar arriba/abajo en una interfaz de chat). A continuación se muestra un ejemplo utilizando <a href="https://gradio.app/" rel="nofollow">Gradio</a> para integrar un chat con un mecanismo de retroalimentación simple.',yl,we,Ha="En el fragmento de código a continuación, cuando un usuario envía un mensaje de chat, capturamos el ID de traza de OpenTelemetry. Si al usuario le gusta/no le gusta la última respuesta, adjuntamos una puntuación a la traza.",jl,Ce,Ul,fe,Xa="La retroalimentación del usuario se captura entonces en tu herramienta de observabilidad:",Jl,ge,La='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/user-feedback-gradio.png" alt="La retroalimentación del usuario se captura en Langfuse"/>',Tl,he,bl,Ie,Sa="LLM-como-Juez es otra forma de evaluar automáticamente la salida de tu agente. Puedes configurar una llamada LLM separada para medir la corrección, toxicidad, estilo o cualquier otro criterio que te importe.",wl,Ze,Fa="<strong>Flujo de trabajo</strong>:",Cl,ve,za="<li>Defines una <strong>Plantilla de Evaluación</strong>, por ejemplo, “Verifica si el texto es tóxico”.</li> <li>Cada vez que tu agente genera una salida, pasas esa salida a tu LLM “juez” con la plantilla.</li> <li>El LLM juez responde con una calificación o etiqueta que registras en tu herramienta de observabilidad.</li>",fl,Ve,qa="Ejemplo de Langfuse:",gl,We,Pa='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/evaluator-template.png" alt="Plantilla de Evaluación LLM-como-Juez"/> <img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/evaluator.png" alt="Evaluador LLM-como-Juez"/>',hl,Be,Il,Ee,Da="Puedes ver que la respuesta de este ejemplo se juzga como “no tóxica”.",Zl,Ge,Ka='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/llm-as-a-judge-score.png" alt="Puntuación de Evaluación LLM-como-Juez"/>',vl,Re,Vl,ke,Oa="Todas estas métricas pueden visualizarse juntas en paneles. Esto te permite ver rápidamente cómo se desempeña tu agente a través de muchas sesiones y te ayuda a seguir las métricas de calidad a lo largo del tiempo.",Wl,$e,es='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/langfuse-dashboard.png" alt="Resumen de métricas de observabilidad"/>',Bl,Ne,El,Ae,ts="La evaluación en línea es esencial para la retroalimentación en vivo, pero también necesitas <strong>evaluación fuera de línea</strong>—verificaciones sistemáticas antes o durante el desarrollo. Esto ayuda a mantener la calidad y fiabilidad antes de implementar cambios en producción.",Gl,xe,Rl,Ye,ls="En la evaluación fuera de línea, típicamente:",kl,Qe,as="<li>Tienes un conjunto de datos de referencia (con pares de prompt y salida esperada)</li> <li>Ejecutas tu agente en ese conjunto de datos</li> <li>Comparas las salidas con los resultados esperados o utilizas un mecanismo de puntuación adicional</li>",$l,_e,ss='A continuación, demostramos este enfoque con el <a href="https://huggingface.co/datasets/gsm8k" rel="nofollow">conjunto de datos GSM8K</a>, que contiene preguntas matemáticas y soluciones.',Nl,He,Al,Xe,ns="A continuación, creamos una entidad de conjunto de datos en Langfuse para rastrear las ejecuciones. Luego, agregamos cada elemento del conjunto de datos al sistema. (Si no estás utilizando Langfuse, podrías simplemente almacenar estos en tu propia base de datos o archivo local para análisis).",xl,Le,Yl,Se,Ql,Fe,is='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/example-dataset.png" alt="Elementos del conjunto de datos en Langfuse"/>',_l,ze,Hl,qe,os="Definimos una función auxiliar <code>run_smolagent()</code> que:",Xl,Pe,rs="<li>Inicia un span de OpenTelemetry</li> <li>Ejecuta nuestro agente en el prompt</li> <li>Registra el ID de traza en Langfuse</li>",Ll,De,Ms="Luego, recorremos cada elemento del conjunto de datos, ejecutamos el agente y vinculamos el rastro al elemento del conjunto de datos. También podemos adjuntar una puntuación de evaluación rápida si lo deseamos.",Sl,Ke,Fl,Oe,zl,et,ps="Puedes repetir este proceso con diferentes:",ql,tt,us="<li>Modelos (OpenAI GPT, LLM local, etc.)</li> <li>Herramientas (búsqueda vs. sin búsqueda)</li> <li>Prompts (diferentes mensajes de sistema)</li>",Pl,lt,cs="Luego compararlos lado a lado en tu herramienta de observabilidad:",Dl,at,ms='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/dataset_runs.png" alt="Resumen de ejecución del conjunto de datos"/> <img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/dataset-run-comparison.png" alt="Comparación de ejecución del conjunto de datos"/>',Kl,st,Ol,nt,ds="En este notebook, cubrimos cómo:",ea,it,ys="<li><strong>Configurar la Observabilidad</strong> usando smolagents + exportadores OpenTelemetry</li> <li><strong>Verificar la Instrumentación</strong> ejecutando un agente simple</li> <li><strong>Capturar Métricas Detalladas</strong> (costo, latencia, etc.) a través de herramientas de observabilidad</li> <li><strong>Recopilar Retroalimentación del Usuario</strong> a través de una interfaz Gradio</li> <li><strong>Usar LLM-como-Juez</strong> para evaluar automáticamente las salidas</li> <li><strong>Realizar Evaluación Fuera de Línea</strong> con un conjunto de datos de referencia</li>",ta,ot,js="🤗 ¡Feliz programación!",la,rt,aa,pt,sa;return T=new hs({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/bonus-unit2/monitoring-and-evaluating-agents.ipynb"}]}}),b=new y({props:{title:"Unidad Extra 2: Observabilidad y Evaluación de Agentes",local:"unidad-extra-2-observabilidad-y-evaluación-de-agentes",headingTag:"h1"}}),g=new y({props:{title:"Requisitos del Ejercicio 🏗️",local:"requisitos-del-ejercicio-",headingTag:"h2"}}),v=new y({props:{title:"Paso 0: Instalar las Librerías Necesarias",local:"paso-0-instalar-las-librerías-necesarias",headingTag:"h2"}}),W=new j({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCdGVsZW1ldHJ5JTVEJyUwQSUyNXBpcCUyMGluc3RhbGwlMjBvcGVudGVsZW1ldHJ5LXNkayUyMG9wZW50ZWxlbWV0cnktZXhwb3J0ZXItb3RscCUyMG9wZW5pbmZlcmVuY2UtaW5zdHJ1bWVudGF0aW9uLXNtb2xhZ2VudHMlMEElMjVwaXAlMjBpbnN0YWxsJTIwbGFuZ2Z1c2UlMjBkYXRhc2V0cyUyMCdzbW9sYWdlbnRzJTVCZ3JhZGlvJTVEJw==",highlighted:`%pip install <span class="hljs-string">&#x27;smolagents[telemetry]&#x27;</span>
%pip install opentelemetry-sdk opentelemetry-exporter-otlp openinference-instrumentation-smolagents
%pip install langfuse datasets <span class="hljs-string">&#x27;smolagents[gradio]&#x27;</span>`,wrap:!1}}),B=new y({props:{title:"Paso 1: Instrumentar tu Agente",local:"paso-1-instrumentar-tu-agente",headingTag:"h2"}}),k=new j({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjBiYXNlNjQlMEElMEElMjMlMjBPYnQlQzMlQTluJTIwdHVzJTIwcHJvcGlhcyUyMGNsYXZlcyUyMGRlc2RlJTIwaHR0cHMlM0ElMkYlMkZjbG91ZC5sYW5nZnVzZS5jb20lMEFMQU5HRlVTRV9QVUJMSUNfS0VZJTIwJTNEJTIwJTNEJTIwJTIycGstbGYtLi4uJTIyJTIwJTBBTEFOR0ZVU0VfU0VDUkVUX0tFWSUyMCUzRCUyMCUyMnNrLWxmLS4uLiUyMiUyMCUwQW9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9QVUJMSUNfS0VZJTIyJTVEJTIwJTNEJTIwTEFOR0ZVU0VfUFVCTElDX0tFWSUwQW9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9TRUNSRVRfS0VZJTIyJTVEJTIwJTNEJTIwTEFOR0ZVU0VfU0VDUkVUX0tFWSUwQW9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZjbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjAlMjMlMjAlRjAlOUYlODclQUElRjAlOUYlODclQkElMjBlamVtcGxvJTIwZGUlMjByZWdpJUMzJUIzbiUyMEVVJTBBJTIzJTIwb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX0hPU1QlMjIlNUQlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVzLmNsb3VkLmxhbmdmdXNlLmNvbSUyMiUyMCUyMCUyMyUyMCVGMCU5RiU4NyVCQSVGMCU5RiU4NyVCOCUyMGVqZW1wbG8lMjBkZSUyMHJlZ2klQzMlQjNuJTIwVVMlMEElMEFMQU5HRlVTRV9BVVRIJTIwJTNEJTIwYmFzZTY0LmI2NGVuY29kZSglMEElMjAlMjAlMjAlMjBmJTIyJTdCTEFOR0ZVU0VfUFVCTElDX0tFWSU3RCUzQSU3QkxBTkdGVVNFX1NFQ1JFVF9LRVklN0QlMjIuZW5jb2RlKCklMEEpLmRlY29kZSgpJTBBJTBBb3MuZW52aXJvbiU1QiUyMk9URUxfRVhQT1JURVJfT1RMUF9FTkRQT0lOVCUyMiU1RCUyMCUzRCUyMG9zLmVudmlyb24uZ2V0KCUyMkxBTkdGVVNFX0hPU1QlMjIpJTIwJTJCJTIwJTIyJTJGYXBpJTJGcHVibGljJTJGb3RlbCUyMiUwQW9zLmVudmlyb24lNUIlMjJPVEVMX0VYUE9SVEVSX09UTFBfSEVBREVSUyUyMiU1RCUyMCUzRCUyMGYlMjJBdXRob3JpemF0aW9uJTNEQmFzaWMlMjAlN0JMQU5HRlVTRV9BVVRIJTdEJTIy",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> base64

<span class="hljs-comment"># Obtén tus propias claves desde https://cloud.langfuse.com</span>
LANGFUSE_PUBLIC_KEY = = <span class="hljs-string">&quot;pk-lf-...&quot;</span> 
LANGFUSE_SECRET_KEY = <span class="hljs-string">&quot;sk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_PUBLIC_KEY&quot;</span>] = LANGFUSE_PUBLIC_KEY
os.environ[<span class="hljs-string">&quot;LANGFUSE_SECRET_KEY&quot;</span>] = LANGFUSE_SECRET_KEY
os.environ[<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com&quot;</span>  <span class="hljs-comment"># 🇪🇺 ejemplo de región EU</span>
<span class="hljs-comment"># os.environ[&quot;LANGFUSE_HOST&quot;] = &quot;https://us.cloud.langfuse.com&quot;  # 🇺🇸 ejemplo de región US</span>

LANGFUSE_AUTH = base64.b64encode(
    <span class="hljs-string">f&quot;<span class="hljs-subst">{LANGFUSE_PUBLIC_KEY}</span>:<span class="hljs-subst">{LANGFUSE_SECRET_KEY}</span>&quot;</span>.encode()
).decode()

os.environ[<span class="hljs-string">&quot;OTEL_EXPORTER_OTLP_ENDPOINT&quot;</span>] = os.environ.get(<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>) + <span class="hljs-string">&quot;/api/public/otel&quot;</span>
os.environ[<span class="hljs-string">&quot;OTEL_EXPORTER_OTLP_HEADERS&quot;</span>] = <span class="hljs-string">f&quot;Authorization=Basic <span class="hljs-subst">{LANGFUSE_AUTH}</span>&quot;</span>`,wrap:!1}}),N=new j({props:{code:"JTIzJTIwQ29uZmlndXJhJTIwdHUlMjB0b2tlbiUyMGRlJTIwSHVnZ2luZyUyMEZhY2UlMjB5JTIwb3Ryb3MlMjB0b2tlbnMlMkZzZWNyZXRvcyUyMGNvbW8lMjB2YXJpYWJsZXMlMjBkZSUyMGVudG9ybm8lMEFvcy5lbnZpcm9uJTVCJTIySEZfVE9LRU4lMjIlNUQlMjAlM0QlMjAlMjJoZl8uLi4lMjIlMjA=",highlighted:`<span class="hljs-comment"># Configura tu token de Hugging Face y otros tokens/secretos como variables de entorno</span>
os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>] = <span class="hljs-string">&quot;hf_...&quot;</span> `,wrap:!1}}),x=new j({props:{code:"ZnJvbSUyMG9wZW50ZWxlbWV0cnkuc2RrLnRyYWNlJTIwaW1wb3J0JTIwVHJhY2VyUHJvdmlkZXIlMEFmcm9tJTIwb3BlbmluZmVyZW5jZS5pbnN0cnVtZW50YXRpb24uc21vbGFnZW50cyUyMGltcG9ydCUyMFNtb2xhZ2VudHNJbnN0cnVtZW50b3IlMEFmcm9tJTIwb3BlbnRlbGVtZXRyeS5leHBvcnRlci5vdGxwLnByb3RvLmh0dHAudHJhY2VfZXhwb3J0ZXIlMjBpbXBvcnQlMjBPVExQU3BhbkV4cG9ydGVyJTBBZnJvbSUyMG9wZW50ZWxlbWV0cnkuc2RrLnRyYWNlLmV4cG9ydCUyMGltcG9ydCUyMFNpbXBsZVNwYW5Qcm9jZXNzb3IlMEElMjAlMEElMjMlMjBDcmVhciUyMHVuJTIwVHJhY2VyUHJvdmlkZXIlMjBwYXJhJTIwT3BlblRlbGVtZXRyeSUwQXRyYWNlX3Byb3ZpZGVyJTIwJTNEJTIwVHJhY2VyUHJvdmlkZXIoKSUwQSUwQSUyMyUyMEElQzMlQjFhZGlyJTIwdW4lMjBTaW1wbGVTcGFuUHJvY2Vzc29yJTIwY29uJTIwZWwlMjBPVExQU3BhbkV4cG9ydGVyJTIwcGFyYSUyMGVudmlhciUyMHRyYXpvc3MlMEF0cmFjZV9wcm92aWRlci5hZGRfc3Bhbl9wcm9jZXNzb3IoU2ltcGxlU3BhblByb2Nlc3NvcihPVExQU3BhbkV4cG9ydGVyKCkpKSUwQSUwQSUyMyUyMEVzdGFibGVjZXIlMjBlbCUyMHByb3ZlZWRvciUyMGRlJTIwdHJhemFzJTIwcHJlZGV0ZXJtaW5hZG8lMjBnbG9iYWwlMEFmcm9tJTIwb3BlbnRlbGVtZXRyeSUyMGltcG9ydCUyMHRyYWNlJTBBdHJhY2Uuc2V0X3RyYWNlcl9wcm92aWRlcih0cmFjZV9wcm92aWRlciklMEF0cmFjZXIlMjAlM0QlMjB0cmFjZS5nZXRfdHJhY2VyKF9fbmFtZV9fKSUwQSUwQSUyMyUyMEluc3RydW1lbnRhciUyMHNtb2xhZ2VudHMlMjBjb24lMjBlbCUyMHByb3ZlZWRvciUyMGNvbmZpZ3VyYWRvJTBBU21vbGFnZW50c0luc3RydW1lbnRvcigpLmluc3RydW1lbnQodHJhY2VyX3Byb3ZpZGVyJTNEdHJhY2VfcHJvdmlkZXIp",highlighted:`<span class="hljs-keyword">from</span> opentelemetry.sdk.trace <span class="hljs-keyword">import</span> TracerProvider
<span class="hljs-keyword">from</span> openinference.instrumentation.smolagents <span class="hljs-keyword">import</span> SmolagentsInstrumentor
<span class="hljs-keyword">from</span> opentelemetry.exporter.otlp.proto.http.trace_exporter <span class="hljs-keyword">import</span> OTLPSpanExporter
<span class="hljs-keyword">from</span> opentelemetry.sdk.trace.export <span class="hljs-keyword">import</span> SimpleSpanProcessor
 
<span class="hljs-comment"># Crear un TracerProvider para OpenTelemetry</span>
trace_provider = TracerProvider()

<span class="hljs-comment"># Añadir un SimpleSpanProcessor con el OTLPSpanExporter para enviar trazoss</span>
trace_provider.add_span_processor(SimpleSpanProcessor(OTLPSpanExporter()))

<span class="hljs-comment"># Establecer el proveedor de trazas predeterminado global</span>
<span class="hljs-keyword">from</span> opentelemetry <span class="hljs-keyword">import</span> trace
trace.set_tracer_provider(trace_provider)
tracer = trace.get_tracer(__name__)

<span class="hljs-comment"># Instrumentar smolagents con el proveedor configurado</span>
SmolagentsInstrumentor().instrument(tracer_provider=trace_provider)`,wrap:!1}}),Y=new y({props:{title:"Paso 2: Probar tu Instrumentación",local:"paso-2-probar-tu-instrumentación",headingTag:"h2"}}),_=new j({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQSUyMyUyMENyZWFyJTIwdW4lMjBhZ2VudGUlMjBzaW1wbGUlMjBwYXJhJTIwcHJvYmFyJTIwbGElMjBpbnN0cnVtZW50YWNpJUMzJUIzbiUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBKSUwQSUwQWFnZW50LnJ1biglMjIxJTJCMSUzRCUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-comment"># Crear un agente simple para probar la instrumentación</span>
agent = CodeAgent(
    tools=[],
    model=InferenceClientModel()
)

agent.run(<span class="hljs-string">&quot;1+1=&quot;</span>)`,wrap:!1}}),F=new y({props:{title:"Paso 3: Observar y Evaluar un Agente Más Complejo",local:"paso-3-observar-y-evaluar-un-agente-más-complejo",headingTag:"h2"}}),q=new j({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQSUwQWFnZW50LnJ1biglMjIlQzIlQkZDdSVDMyVBMW50b3MlMjBjdWJvcyUyMGRlJTIwUnViaWslMjBwb2RyJUMzJUFEYXMlMjBtZXRlciUyMGRlbnRybyUyMGRlJTIwbGElMjBDYXRlZHJhbCUyMGRlJTIwTm90cmUlMjBEYW1lJTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(tools=[search_tool], model=InferenceClientModel())

agent.run(<span class="hljs-string">&quot;¿Cuántos cubos de Rubik podrías meter dentro de la Catedral de Notre Dame?&quot;</span>)`,wrap:!1}}),P=new y({props:{title:"Estructura de Rastros",local:"estructura-de-rastros",headingTag:"h3"}}),le=new y({props:{title:"Evaluación en Línea",local:"evaluación-en-línea",headingTag:"h2"}}),se=new y({props:{title:"Métricas Comunes para Seguir en Producción",local:"métricas-comunes-para-seguir-en-producción",headingTag:"h3"}}),oe=new y({props:{title:"1. Costos",local:"1-costos",headingTag:"h4"}}),ue=new y({props:{title:"2. Latencia",local:"2-latencia",headingTag:"h4"}}),ye=new y({props:{title:"3. Atributos Adicionales",local:"3-atributos-adicionales",headingTag:"h4"}}),Ue=new j({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEFmcm9tJTIwb3BlbnRlbGVtZXRyeSUyMGltcG9ydCUyMHRyYWNlJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCgpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJzZWFyY2hfdG9vbCU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUwQSklMEElMEF3aXRoJTIwdHJhY2VyLnN0YXJ0X2FzX2N1cnJlbnRfc3BhbiglMjJTbW9sYWdlbnQtVHJhY2UlMjIpJTIwYXMlMjBzcGFuJTNBJTBBJTIwJTIwJTIwJTIwc3Bhbi5zZXRfYXR0cmlidXRlKCUyMmxhbmdmdXNlLnVzZXIuaWQlMjIlMkMlMjAlMjJzbW9sYWdlbnQtdXNlci0xMjMlMjIpJTBBJTIwJTIwJTIwJTIwc3Bhbi5zZXRfYXR0cmlidXRlKCUyMmxhbmdmdXNlLnNlc3Npb24uaWQlMjIlMkMlMjAlMjJzbW9sYWdlbnQtc2Vzc2lvbi0xMjM0NTY3ODklMjIpJTBBJTIwJTIwJTIwJTIwc3Bhbi5zZXRfYXR0cmlidXRlKCUyMmxhbmdmdXNlLnRhZ3MlMjIlMkMlMjAlNUIlMjJjaXR5LXF1ZXN0aW9uJTIyJTJDJTIwJTIydGVzdGluZy1hZ2VudHMlMjIlNUQpJTBBJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMiVDMiVCRkN1JUMzJUExbCUyMGVzJTIwbGElMjBjYXBpdGFsJTIwZGUlMjBBbGVtYW5pYSUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)
<span class="hljs-keyword">from</span> opentelemetry <span class="hljs-keyword">import</span> trace

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(
    tools=[search_tool],
    model=InferenceClientModel()
)

<span class="hljs-keyword">with</span> tracer.start_as_current_span(<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>) <span class="hljs-keyword">as</span> span:
    span.set_attribute(<span class="hljs-string">&quot;langfuse.user.id&quot;</span>, <span class="hljs-string">&quot;smolagent-user-123&quot;</span>)
    span.set_attribute(<span class="hljs-string">&quot;langfuse.session.id&quot;</span>, <span class="hljs-string">&quot;smolagent-session-123456789&quot;</span>)
    span.set_attribute(<span class="hljs-string">&quot;langfuse.tags&quot;</span>, [<span class="hljs-string">&quot;city-question&quot;</span>, <span class="hljs-string">&quot;testing-agents&quot;</span>])

    agent.run(<span class="hljs-string">&quot;¿Cuál es la capital de Alemania?&quot;</span>)`,wrap:!1}}),Te=new y({props:{title:"4. Retroalimentación del Usuario",local:"4-retroalimentación-del-usuario",headingTag:"h4"}}),Ce=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> opentelemetry.trace <span class="hljs-keyword">import</span> format_trace_id
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, InferenceClientModel)
<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> Langfuse

langfuse = Langfuse()
model = InferenceClientModel()
agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)

formatted_trace_id = <span class="hljs-literal">None</span>  <span class="hljs-comment"># Almacenaremos el trace_id actual globalmente para demostración</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">respond</span>(<span class="hljs-params">prompt, history</span>):
    <span class="hljs-keyword">with</span> trace.get_tracer(__name__).start_as_current_span(<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>) <span class="hljs-keyword">as</span> span:
        output = agent.run(prompt)

        current_span = trace.get_current_span()
        span_context = current_span.get_span_context()
        trace_id = span_context.trace_id
        <span class="hljs-keyword">global</span> formatted_trace_id
        formatted_trace_id = <span class="hljs-built_in">str</span>(format_trace_id(trace_id))
        langfuse.trace(<span class="hljs-built_in">id</span>=formatted_trace_id, <span class="hljs-built_in">input</span>=prompt, output=output)

    history.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-built_in">str</span>(output)})
    <span class="hljs-keyword">return</span> history

<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_like</span>(<span class="hljs-params">data: gr.LikeData</span>):
    <span class="hljs-comment"># Para demostración, mapeamos la retroalimentación del usuario a un 1 (me gusta) o 0 (no me gusta)</span>
    <span class="hljs-keyword">if</span> data.liked:
        langfuse.score(
            value=<span class="hljs-number">1</span>,
            name=<span class="hljs-string">&quot;user-feedback&quot;</span>,
            trace_id=formatted_trace_id
        )
    <span class="hljs-keyword">else</span>:
        langfuse.score(
            value=<span class="hljs-number">0</span>,
            name=<span class="hljs-string">&quot;user-feedback&quot;</span>,
            trace_id=formatted_trace_id
        )

<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    chatbot = gr.Chatbot(label=<span class="hljs-string">&quot;Chat&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>)
    prompt_box = gr.Textbox(placeholder=<span class="hljs-string">&quot;Escribe tu mensaje...&quot;</span>, label=<span class="hljs-string">&quot;Tu mensaje&quot;</span>)

    <span class="hljs-comment"># Cuando el usuario presiona &#x27;Enter&#x27; en el prompt, ejecutamos &#x27;respond&#x27;</span>
    prompt_box.submit(
        fn=respond,
        inputs=[prompt_box, chatbot],
        outputs=chatbot
    )

    <span class="hljs-comment"># Cuando el usuario hace clic en un botón de &#x27;me gusta&#x27; en un mensaje, ejecutamos &#x27;handle_like&#x27;</span>
    chatbot.like(handle_like, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>)

demo.launch()
`,wrap:!1}}),he=new y({props:{title:"5. LLM-como-Juez",local:"5-llm-como-juez",headingTag:"h4"}}),Be=new j({props:{code:"JTIzJTIwRWplbXBsbyUzQSUyMFZlcmlmaWNhciUyMHNpJTIwbGElMjBzYWxpZGElMjBkZWwlMjBhZ2VudGUlMjBlcyUyMHQlQzMlQjN4aWNhJTIwbyUyMG5vLiUwQWZyb20lMjBzbW9sYWdlbnRzJTIwaW1wb3J0JTIwKENvZGVBZ2VudCUyQyUyMER1Y2tEdWNrR29TZWFyY2hUb29sJTJDJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwpJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCgpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJzZWFyY2hfdG9vbCU1RCUyQyUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSklMEElMEFhZ2VudC5ydW4oJTIyJUMyJUJGUHVlZGUlMjBjb21lciUyMHphbmFob3JpYXMlMjBtZWpvcmFyJTIwdHUlMjB2aXNpJUMzJUIzbiUzRiUyMik=",highlighted:`<span class="hljs-comment"># Ejemplo: Verificar si la salida del agente es tóxica o no.</span>
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(tools=[search_tool], model=InferenceClientModel())

agent.run(<span class="hljs-string">&quot;¿Puede comer zanahorias mejorar tu visión?&quot;</span>)`,wrap:!1}}),Re=new y({props:{title:"6. Resumen de Métricas de Observabilidad",local:"6-resumen-de-métricas-de-observabilidad",headingTag:"h4"}}),Ne=new y({props:{title:"Evaluación fuera de línea",local:"evaluación-fuera-de-línea",headingTag:"h2"}}),xe=new y({props:{title:"Evaluación con Conjuntos de Datos",local:"evaluación-con-conjuntos-de-datos",headingTag:"h3"}}),He=new j({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQSUyMyUyME9idGVuZXIlMjBHU004SyUyMGRlc2RlJTIwSHVnZ2luZyUyMEZhY2UlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMm9wZW5haSUyRmdzbThrJTIyJTJDJTIwJ21haW4nJTJDJTIwc3BsaXQlM0QndHJhaW4nKSUwQWRmJTIwJTNEJTIwcGQuRGF0YUZyYW1lKGRhdGFzZXQpJTBBcHJpbnQoJTIyUHJpbWVyYXMlMjBmaWxhcyUyMGRlbCUyMGNvbmp1bnRvJTIwZGUlMjBkYXRvcyUyMEdTTThLJTNBJTIyKSUwQXByaW50KGRmLmhlYWQoKSk=",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Obtener GSM8K desde Hugging Face</span>
dataset = load_dataset(<span class="hljs-string">&quot;openai/gsm8k&quot;</span>, <span class="hljs-string">&#x27;main&#x27;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>)
df = pd.DataFrame(dataset)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Primeras filas del conjunto de datos GSM8K:&quot;</span>)
<span class="hljs-built_in">print</span>(df.head())`,wrap:!1}}),Le=new j({props:{code:"ZnJvbSUyMGxhbmdmdXNlJTIwaW1wb3J0JTIwTGFuZ2Z1c2UlMEFsYW5nZnVzZSUyMCUzRCUyMExhbmdmdXNlKCklMEElMEFsYW5nZnVzZV9kYXRhc2V0X25hbWUlMjAlM0QlMjAlMjJnc204a19kYXRhc2V0X2h1Z2dpbmdmYWNlJTIyJTBBJTBBJTIzJTIwQ3JlYXIlMjB1biUyMGNvbmp1bnRvJTIwZGUlMjBkYXRvcyUyMGVuJTIwTGFuZ2Z1c2UlMEFsYW5nZnVzZS5jcmVhdGVfZGF0YXNldCglMEElMjAlMjAlMjAlMjBuYW1lJTNEbGFuZ2Z1c2VfZGF0YXNldF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJDb25qdW50byUyMGRlJTIwZGF0b3MlMjBkZSUyMHJlZmVyZW5jaWElMjBHU004SyUyMGNhcmdhZG8lMjBkZXNkZSUyMEh1Z2dpbmdmYWNlJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWV0YWRhdGElM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkYXRlJTIyJTNBJTIwJTIyMjAyNS0wMy0xMCUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJiZW5jaG1hcmslMjIlMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> Langfuse
langfuse = Langfuse()

langfuse_dataset_name = <span class="hljs-string">&quot;gsm8k_dataset_huggingface&quot;</span>

<span class="hljs-comment"># Crear un conjunto de datos en Langfuse</span>
langfuse.create_dataset(
    name=langfuse_dataset_name,
    description=<span class="hljs-string">&quot;Conjunto de datos de referencia GSM8K cargado desde Huggingface&quot;</span>,
    metadata={
        <span class="hljs-string">&quot;date&quot;</span>: <span class="hljs-string">&quot;2025-03-10&quot;</span>, 
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;benchmark&quot;</span>
    }
)`,wrap:!1}}),Se=new j({props:{code:"Zm9yJTIwaWR4JTJDJTIwcm93JTIwaW4lMjBkZi5pdGVycm93cygpJTNBJTBBJTIwJTIwJTIwJTIwbGFuZ2Z1c2UuY3JlYXRlX2RhdGFzZXRfaXRlbSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhc2V0X25hbWUlM0RsYW5nZnVzZV9kYXRhc2V0X25hbWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dCUzRCU3QiUyMnRleHQlMjIlM0ElMjByb3clNUIlMjJxdWVzdGlvbiUyMiU1RCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4cGVjdGVkX291dHB1dCUzRCU3QiUyMnRleHQlMjIlM0ElMjByb3clNUIlMjJhbnN3ZXIlMjIlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZV9pbmRleCUyMiUzQSUyMGlkeCU3RCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBpZiUyMGlkeCUyMCUzRSUzRCUyMDklM0ElMjAlMjMlMjBDYXJnYXIlMjBzb2xvJTIwbG9zJTIwcHJpbWVyb3MlMjAxMCUyMGVsZW1lbnRvcyUyMHBhcmElMjBkZW1vc3RyYWNpJUMzJUIzbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-keyword">for</span> idx, row <span class="hljs-keyword">in</span> df.iterrows():
    langfuse.create_dataset_item(
        dataset_name=langfuse_dataset_name,
        <span class="hljs-built_in">input</span>={<span class="hljs-string">&quot;text&quot;</span>: row[<span class="hljs-string">&quot;question&quot;</span>]},
        expected_output={<span class="hljs-string">&quot;text&quot;</span>: row[<span class="hljs-string">&quot;answer&quot;</span>]},
        metadata={<span class="hljs-string">&quot;source_index&quot;</span>: idx}
    )
    <span class="hljs-keyword">if</span> idx &gt;= <span class="hljs-number">9</span>: <span class="hljs-comment"># Cargar solo los primeros 10 elementos para demostración</span>
        <span class="hljs-keyword">break</span>`,wrap:!1}}),ze=new y({props:{title:"Ejecutando el Agente en el Conjunto de Datos",local:"ejecutando-el-agente-en-el-conjunto-de-datos",headingTag:"h4"}}),Ke=new j({props:{code:"ZnJvbSUyMG9wZW50ZWxlbWV0cnkudHJhY2UlMjBpbXBvcnQlMjBmb3JtYXRfdHJhY2VfaWQlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMChDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMExpdGVMTE1Nb2RlbCklMEElMEElMjMlMjBFamVtcGxvJTNBJTIwdXNhbmRvJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwlMjBvJTIwTGl0ZUxMTU1vZGVsJTIwcGFyYSUyMGFjY2VkZXIlMjBhJTIwbW9kZWxvcyUyMGRlJTIwb3BlbmFpJTJDJTIwYW50aHJvcGljJTJDJTIwZ2VtaW5pJTJDJTIwZXRjLiUzQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSUwQSklMEElMEFkZWYlMjBydW5fc21vbGFnZW50KHF1ZXN0aW9uKSUzQSUwQSUyMCUyMCUyMCUyMHdpdGglMjB0cmFjZXIuc3RhcnRfYXNfY3VycmVudF9zcGFuKCUyMlNtb2xhZ2VudC1UcmFjZSUyMiklMjBhcyUyMHNwYW4lM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGFuLnNldF9hdHRyaWJ1dGUoJTIybGFuZ2Z1c2UudGFnJTIyJTJDJTIwJTIyZGF0YXNldC1ydW4lMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwYWdlbnQucnVuKHF1ZXN0aW9uKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGN1cnJlbnRfc3BhbiUyMCUzRCUyMHRyYWNlLmdldF9jdXJyZW50X3NwYW4oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwYW5fY29udGV4dCUyMCUzRCUyMGN1cnJlbnRfc3Bhbi5nZXRfc3Bhbl9jb250ZXh0KCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFjZV9pZCUyMCUzRCUyMHNwYW5fY29udGV4dC50cmFjZV9pZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvcm1hdHRlZF90cmFjZV9pZCUyMCUzRCUyMGZvcm1hdF90cmFjZV9pZCh0cmFjZV9pZCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYW5nZnVzZV90cmFjZSUyMCUzRCUyMGxhbmdmdXNlLnRyYWNlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlkJTNEZm9ybWF0dGVkX3RyYWNlX2lkJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXQlM0RxdWVzdGlvbiUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dCUzRG91dHB1dCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBsYW5nZnVzZV90cmFjZSUyQyUyMG91dHB1dA==",highlighted:`<span class="hljs-keyword">from</span> opentelemetry.trace <span class="hljs-keyword">import</span> format_trace_id
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, InferenceClientModel, LiteLLMModel)

<span class="hljs-comment"># Ejemplo: usando InferenceClientModel o LiteLLMModel para acceder a modelos de openai, anthropic, gemini, etc.:</span>
model = InferenceClientModel()

agent = CodeAgent(
    tools=[],
    model=model,
    add_base_tools=<span class="hljs-literal">True</span>
)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_smolagent</span>(<span class="hljs-params">question</span>):
    <span class="hljs-keyword">with</span> tracer.start_as_current_span(<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>) <span class="hljs-keyword">as</span> span:
        span.set_attribute(<span class="hljs-string">&quot;langfuse.tag&quot;</span>, <span class="hljs-string">&quot;dataset-run&quot;</span>)
        output = agent.run(question)

        current_span = trace.get_current_span()
        span_context = current_span.get_span_context()
        trace_id = span_context.trace_id
        formatted_trace_id = format_trace_id(trace_id)

        langfuse_trace = langfuse.trace(
            <span class="hljs-built_in">id</span>=formatted_trace_id, 
            <span class="hljs-built_in">input</span>=question, 
            output=output
        )
    <span class="hljs-keyword">return</span> langfuse_trace, output`,wrap:!1}}),Oe=new j({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxhbmdmdXNlLmdldF9kYXRhc2V0KGxhbmdmdXNlX2RhdGFzZXRfbmFtZSklMEElMEElMjMlMjBFamVjdXRhciUyMG51ZXN0cm8lMjBhZ2VudGUlMjBjb250cmElMjBjYWRhJTIwZWxlbWVudG8lMjBkZWwlMjBjb25qdW50byUyMGRlJTIwZGF0b3MlMjAobGltaXRhZG8lMjBhJTIwbG9zJTIwcHJpbWVyb3MlMjAxMCUyMGFycmliYSklMEFmb3IlMjBpdGVtJTIwaW4lMjBkYXRhc2V0Lml0ZW1zJTNBJTBBJTIwJTIwJTIwJTIwbGFuZ2Z1c2VfdHJhY2UlMkMlMjBvdXRwdXQlMjAlM0QlMjBydW5fc21vbGFnZW50KGl0ZW0uaW5wdXQlNUIlMjJ0ZXh0JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFZpbmN1bGFyJTIwbGElMjB0cmF6YSUyMGFsJTIwZWxlbWVudG8lMjBkZWwlMjBjb25qdW50byUyMGRlJTIwZGF0b3MlMjBwYXJhJTIwYW4lQzMlQTFsaXNpcyUwQSUyMCUyMCUyMCUyMGl0ZW0ubGluayglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYW5nZnVzZV90cmFjZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJ1bl9uYW1lJTNEJTIyc21vbGFnZW50LW5vdGVib29rLXJ1bi0wMSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJ1bl9tZXRhZGF0YSUzRCU3QiUyMCUyMm1vZGVsJTIyJTNBJTIwbW9kZWwubW9kZWxfaWQlMjAlN0QlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwT3BjaW9uYWxtZW50ZSUyQyUyMGFsbWFjZW5hciUyMHVuYSUyMHB1bnR1YWNpJUMzJUIzbiUyMGRlJTIwZXZhbHVhY2klQzMlQjNuJTIwciVDMyVBMXBpZGElMjBwYXJhJTIwZGVtb3N0cmFjaSVDMyVCM24lMEElMjAlMjAlMjAlMjBsYW5nZnVzZV90cmFjZS5zY29yZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNEJTIyJTNDZXhhbXBsZV9ldmFsJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmFsdWUlM0QxJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29tbWVudCUzRCUyMkVzdGUlMjBlcyUyMHVuJTIwY29tZW50YXJpbyUyMiUwQSUyMCUyMCUyMCUyMCklMEElMEElMjMlMjBWYWNpYXIlMjBkYXRvcyUyMHBhcmElMjBhc2VndXJhciUyMHF1ZSUyMHRvZGElMjBsYSUyMHRlbGVtZXRyJUMzJUFEYSUyMHNlYSUyMGVudmlhZGElMEFsYW5nZnVzZS5mbHVzaCgp",highlighted:`dataset = langfuse.get_dataset(langfuse_dataset_name)

<span class="hljs-comment"># Ejecutar nuestro agente contra cada elemento del conjunto de datos (limitado a los primeros 10 arriba)</span>
<span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> dataset.items:
    langfuse_trace, output = run_smolagent(item.<span class="hljs-built_in">input</span>[<span class="hljs-string">&quot;text&quot;</span>])

    <span class="hljs-comment"># Vincular la traza al elemento del conjunto de datos para análisis</span>
    item.link(
        langfuse_trace,
        run_name=<span class="hljs-string">&quot;smolagent-notebook-run-01&quot;</span>,
        run_metadata={ <span class="hljs-string">&quot;model&quot;</span>: model.model_id }
    )

    <span class="hljs-comment"># Opcionalmente, almacenar una puntuación de evaluación rápida para demostración</span>
    langfuse_trace.score(
        name=<span class="hljs-string">&quot;&lt;example_eval&gt;&quot;</span>,
        value=<span class="hljs-number">1</span>,
        comment=<span class="hljs-string">&quot;Este es un comentario&quot;</span>
    )

<span class="hljs-comment"># Vaciar datos para asegurar que toda la telemetría sea enviada</span>
langfuse.flush()`,wrap:!1}}),st=new y({props:{title:"Consideraciones Finales",local:"consideraciones-finales",headingTag:"h2"}}),rt=new Is({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/bonus-unit2/monitoring-and-evaluating-agents-notebook.mdx"}}),{c(){U=i("meta"),ut=s(),Mt=i("p"),ct=s(),M(T.$$.fragment),mt=s(),M(b.$$.fragment),dt=s(),J=i("blockquote"),J.innerHTML=oa,yt=s(),w=i("p"),w.innerHTML=ra,jt=s(),C=i("p"),C.textContent=Ma,Ut=s(),f=i("ul"),f.innerHTML=pa,Jt=s(),M(g.$$.fragment),Tt=s(),h=i("p"),h.textContent=ua,bt=s(),I=i("p"),I.innerHTML=ca,wt=s(),Z=i("p"),Z.innerHTML=ma,Ct=s(),M(v.$$.fragment),ft=s(),V=i("p"),V.textContent=da,gt=s(),M(W.$$.fragment),ht=s(),M(B.$$.fragment),It=s(),E=i("p"),E.innerHTML=ya,Zt=s(),G=i("p"),G.innerHTML=ja,vt=s(),R=i("p"),R.textContent=Ua,Vt=s(),M(k.$$.fragment),Wt=s(),$=i("p"),$.textContent=Ja,Bt=s(),M(N.$$.fragment),Et=s(),A=i("p"),A.textContent=Ta,Gt=s(),M(x.$$.fragment),Rt=s(),M(Y.$$.fragment),kt=s(),Q=i("p"),Q.innerHTML=ba,$t=s(),M(_.$$.fragment),Nt=s(),H=i("p"),H.innerHTML=wa,At=s(),X=i("p"),X.textContent=Ca,xt=s(),L=i("p"),L.innerHTML=fa,Yt=s(),S=i("p"),S.innerHTML=ga,Qt=s(),M(F.$$.fragment),_t=s(),z=i("p"),z.textContent=ha,Ht=s(),M(q.$$.fragment),Xt=s(),M(P.$$.fragment),Lt=s(),D=i("p"),D.innerHTML=Ia,St=s(),K=i("ul"),K.innerHTML=Za,Ft=s(),O=i("p"),O.textContent=va,zt=s(),ee=i("p"),ee.innerHTML=Va,qt=s(),te=i("p"),te.innerHTML=Wa,Pt=s(),M(le.$$.fragment),Dt=s(),ae=i("p"),ae.textContent=Ba,Kt=s(),M(se.$$.fragment),Ot=s(),ne=i("ol"),ne.innerHTML=Ea,el=s(),ie=i("p"),ie.textContent=Ga,tl=s(),M(oe.$$.fragment),ll=s(),re=i("p"),re.innerHTML=Ra,al=s(),Me=i("p"),Me.innerHTML=ka,sl=s(),pe=i("p"),pe.innerHTML=$a,nl=s(),M(ue.$$.fragment),il=s(),ce=i("p"),ce.textContent=Na,ol=s(),me=i("p"),me.innerHTML=Aa,rl=s(),de=i("p"),de.innerHTML=xa,Ml=s(),M(ye.$$.fragment),pl=s(),je=i("p"),je.innerHTML=Ya,ul=s(),M(Ue.$$.fragment),cl=s(),Je=i("p"),Je.innerHTML=Qa,ml=s(),M(Te.$$.fragment),dl=s(),be=i("p"),be.innerHTML=_a,yl=s(),we=i("p"),we.textContent=Ha,jl=s(),M(Ce.$$.fragment),Ul=s(),fe=i("p"),fe.textContent=Xa,Jl=s(),ge=i("p"),ge.innerHTML=La,Tl=s(),M(he.$$.fragment),bl=s(),Ie=i("p"),Ie.textContent=Sa,wl=s(),Ze=i("p"),Ze.innerHTML=Fa,Cl=s(),ve=i("ol"),ve.innerHTML=za,fl=s(),Ve=i("p"),Ve.textContent=qa,gl=s(),We=i("p"),We.innerHTML=Pa,hl=s(),M(Be.$$.fragment),Il=s(),Ee=i("p"),Ee.textContent=Da,Zl=s(),Ge=i("p"),Ge.innerHTML=Ka,vl=s(),M(Re.$$.fragment),Vl=s(),ke=i("p"),ke.textContent=Oa,Wl=s(),$e=i("p"),$e.innerHTML=es,Bl=s(),M(Ne.$$.fragment),El=s(),Ae=i("p"),Ae.innerHTML=ts,Gl=s(),M(xe.$$.fragment),Rl=s(),Ye=i("p"),Ye.textContent=ls,kl=s(),Qe=i("ol"),Qe.innerHTML=as,$l=s(),_e=i("p"),_e.innerHTML=ss,Nl=s(),M(He.$$.fragment),Al=s(),Xe=i("p"),Xe.textContent=ns,xl=s(),M(Le.$$.fragment),Yl=s(),M(Se.$$.fragment),Ql=s(),Fe=i("p"),Fe.innerHTML=is,_l=s(),M(ze.$$.fragment),Hl=s(),qe=i("p"),qe.innerHTML=os,Xl=s(),Pe=i("ol"),Pe.innerHTML=rs,Ll=s(),De=i("p"),De.textContent=Ms,Sl=s(),M(Ke.$$.fragment),Fl=s(),M(Oe.$$.fragment),zl=s(),et=i("p"),et.textContent=ps,ql=s(),tt=i("ul"),tt.innerHTML=us,Pl=s(),lt=i("p"),lt.textContent=cs,Dl=s(),at=i("p"),at.innerHTML=ms,Kl=s(),M(st.$$.fragment),Ol=s(),nt=i("p"),nt.textContent=ds,ea=s(),it=i("ol"),it.innerHTML=ys,ta=s(),ot=i("p"),ot.textContent=js,la=s(),M(rt.$$.fragment),aa=s(),pt=i("p"),this.h()},l(e){const t=fs("svelte-u9bgzb",document.head);U=o(t,"META",{name:!0,content:!0}),t.forEach(l),ut=n(e),Mt=o(e,"P",{}),Us(Mt).forEach(l),ct=n(e),p(T.$$.fragment,e),mt=n(e),p(b.$$.fragment,e),dt=n(e),J=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-1kd3o88"&&(J.innerHTML=oa),yt=n(e),w=o(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-udjbaf"&&(w.innerHTML=ra),jt=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-g6j46l"&&(C.textContent=Ma),Ut=n(e),f=o(e,"UL",{"data-svelte-h":!0}),r(f)!=="svelte-1x3sj8f"&&(f.innerHTML=pa),Jt=n(e),p(g.$$.fragment,e),Tt=n(e),h=o(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-177txu9"&&(h.textContent=ua),bt=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1t3gp2v"&&(I.innerHTML=ca),wt=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-7if8bz"&&(Z.innerHTML=ma),Ct=n(e),p(v.$$.fragment,e),ft=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-ir9osj"&&(V.textContent=da),gt=n(e),p(W.$$.fragment,e),ht=n(e),p(B.$$.fragment,e),It=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1kzuma7"&&(E.innerHTML=ya),Zt=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-xmw502"&&(G.innerHTML=ja),vt=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1wrmoiy"&&(R.textContent=Ua),Vt=n(e),p(k.$$.fragment,e),Wt=n(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-hqvkfd"&&($.textContent=Ja),Bt=n(e),p(N.$$.fragment,e),Et=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1uh5xe8"&&(A.textContent=Ta),Gt=n(e),p(x.$$.fragment,e),Rt=n(e),p(Y.$$.fragment,e),kt=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1ttfubs"&&(Q.innerHTML=ba),$t=n(e),p(_.$$.fragment,e),Nt=n(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-kb9mpv"&&(H.innerHTML=wa),At=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-92grbp"&&(X.textContent=Ca),xt=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-opeu5l"&&(L.innerHTML=fa),Yt=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1cgbonm"&&(S.innerHTML=ga),Qt=n(e),p(F.$$.fragment,e),_t=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1dl64zz"&&(z.textContent=ha),Ht=n(e),p(q.$$.fragment,e),Xt=n(e),p(P.$$.fragment,e),Lt=n(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-i6j7qc"&&(D.innerHTML=Ia),St=n(e),K=o(e,"UL",{"data-svelte-h":!0}),r(K)!=="svelte-13uhxnr"&&(K.innerHTML=Za),Ft=n(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1g7qson"&&(O.textContent=va),zt=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1fch75q"&&(ee.innerHTML=Va),qt=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-12lduh0"&&(te.innerHTML=Wa),Pt=n(e),p(le.$$.fragment,e),Dt=n(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-oaz0jq"&&(ae.textContent=Ba),Kt=n(e),p(se.$$.fragment,e),Ot=n(e),ne=o(e,"OL",{"data-svelte-h":!0}),r(ne)!=="svelte-1439457"&&(ne.innerHTML=Ea),el=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-103zbnc"&&(ie.textContent=Ga),tl=n(e),p(oe.$$.fragment,e),ll=n(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1v993j1"&&(re.innerHTML=Ra),al=n(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-36dk7q"&&(Me.innerHTML=ka),sl=n(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-12lduh0"&&(pe.innerHTML=$a),nl=n(e),p(ue.$$.fragment,e),il=n(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-we2rt6"&&(ce.textContent=Na),ol=n(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-nhz3gc"&&(me.innerHTML=Aa),rl=n(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-12lduh0"&&(de.innerHTML=xa),Ml=n(e),p(ye.$$.fragment,e),pl=n(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1emttgu"&&(je.innerHTML=Ya),ul=n(e),p(Ue.$$.fragment,e),cl=n(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-ihgll6"&&(Je.innerHTML=Qa),ml=n(e),p(Te.$$.fragment,e),dl=n(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-10sp8fd"&&(be.innerHTML=_a),yl=n(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-jf76gk"&&(we.textContent=Ha),jl=n(e),p(Ce.$$.fragment,e),Ul=n(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-zsstgn"&&(fe.textContent=Xa),Jl=n(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-ta5ta1"&&(ge.innerHTML=La),Tl=n(e),p(he.$$.fragment,e),bl=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1cjte1i"&&(Ie.textContent=Sa),wl=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1lgmmid"&&(Ze.innerHTML=Fa),Cl=n(e),ve=o(e,"OL",{"data-svelte-h":!0}),r(ve)!=="svelte-1rbh0nf"&&(ve.innerHTML=za),fl=n(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-aqwlqk"&&(Ve.textContent=qa),gl=n(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-15ug6nt"&&(We.innerHTML=Pa),hl=n(e),p(Be.$$.fragment,e),Il=n(e),Ee=o(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-1wwhvdi"&&(Ee.textContent=Da),Zl=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1fi06xz"&&(Ge.innerHTML=Ka),vl=n(e),p(Re.$$.fragment,e),Vl=n(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1o474o1"&&(ke.textContent=Oa),Wl=n(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-18bjtnr"&&($e.innerHTML=es),Bl=n(e),p(Ne.$$.fragment,e),El=n(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-k35our"&&(Ae.innerHTML=ts),Gl=n(e),p(xe.$$.fragment,e),Rl=n(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1gktbt3"&&(Ye.textContent=ls),kl=n(e),Qe=o(e,"OL",{"data-svelte-h":!0}),r(Qe)!=="svelte-14rstmo"&&(Qe.innerHTML=as),$l=n(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-sj9u9y"&&(_e.innerHTML=ss),Nl=n(e),p(He.$$.fragment,e),Al=n(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-xji3kb"&&(Xe.textContent=ns),xl=n(e),p(Le.$$.fragment,e),Yl=n(e),p(Se.$$.fragment,e),Ql=n(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-11f0115"&&(Fe.innerHTML=is),_l=n(e),p(ze.$$.fragment,e),Hl=n(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-9ctqha"&&(qe.innerHTML=os),Xl=n(e),Pe=o(e,"OL",{"data-svelte-h":!0}),r(Pe)!=="svelte-13wgpt6"&&(Pe.innerHTML=rs),Ll=n(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-90ofcd"&&(De.textContent=Ms),Sl=n(e),p(Ke.$$.fragment,e),Fl=n(e),p(Oe.$$.fragment,e),zl=n(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-14t08r2"&&(et.textContent=ps),ql=n(e),tt=o(e,"UL",{"data-svelte-h":!0}),r(tt)!=="svelte-cdo50l"&&(tt.innerHTML=us),Pl=n(e),lt=o(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-ul4a9c"&&(lt.textContent=cs),Dl=n(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1yiuof6"&&(at.innerHTML=ms),Kl=n(e),p(st.$$.fragment,e),Ol=n(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-rq6osp"&&(nt.textContent=ds),ea=n(e),it=o(e,"OL",{"data-svelte-h":!0}),r(it)!=="svelte-vs0ox2"&&(it.innerHTML=ys),ta=n(e),ot=o(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1rhdw2l"&&(ot.textContent=js),la=n(e),p(rt.$$.fragment,e),aa=n(e),pt=o(e,"P",{}),Us(pt).forEach(l),this.h()},h(){na(U,"name","hf:doc:metadata"),na(U,"content",vs),na(J,"class","tip")},m(e,t){gs(document.head,U),a(e,ut,t),a(e,Mt,t),a(e,ct,t),u(T,e,t),a(e,mt,t),u(b,e,t),a(e,dt,t),a(e,J,t),a(e,yt,t),a(e,w,t),a(e,jt,t),a(e,C,t),a(e,Ut,t),a(e,f,t),a(e,Jt,t),u(g,e,t),a(e,Tt,t),a(e,h,t),a(e,bt,t),a(e,I,t),a(e,wt,t),a(e,Z,t),a(e,Ct,t),u(v,e,t),a(e,ft,t),a(e,V,t),a(e,gt,t),u(W,e,t),a(e,ht,t),u(B,e,t),a(e,It,t),a(e,E,t),a(e,Zt,t),a(e,G,t),a(e,vt,t),a(e,R,t),a(e,Vt,t),u(k,e,t),a(e,Wt,t),a(e,$,t),a(e,Bt,t),u(N,e,t),a(e,Et,t),a(e,A,t),a(e,Gt,t),u(x,e,t),a(e,Rt,t),u(Y,e,t),a(e,kt,t),a(e,Q,t),a(e,$t,t),u(_,e,t),a(e,Nt,t),a(e,H,t),a(e,At,t),a(e,X,t),a(e,xt,t),a(e,L,t),a(e,Yt,t),a(e,S,t),a(e,Qt,t),u(F,e,t),a(e,_t,t),a(e,z,t),a(e,Ht,t),u(q,e,t),a(e,Xt,t),u(P,e,t),a(e,Lt,t),a(e,D,t),a(e,St,t),a(e,K,t),a(e,Ft,t),a(e,O,t),a(e,zt,t),a(e,ee,t),a(e,qt,t),a(e,te,t),a(e,Pt,t),u(le,e,t),a(e,Dt,t),a(e,ae,t),a(e,Kt,t),u(se,e,t),a(e,Ot,t),a(e,ne,t),a(e,el,t),a(e,ie,t),a(e,tl,t),u(oe,e,t),a(e,ll,t),a(e,re,t),a(e,al,t),a(e,Me,t),a(e,sl,t),a(e,pe,t),a(e,nl,t),u(ue,e,t),a(e,il,t),a(e,ce,t),a(e,ol,t),a(e,me,t),a(e,rl,t),a(e,de,t),a(e,Ml,t),u(ye,e,t),a(e,pl,t),a(e,je,t),a(e,ul,t),u(Ue,e,t),a(e,cl,t),a(e,Je,t),a(e,ml,t),u(Te,e,t),a(e,dl,t),a(e,be,t),a(e,yl,t),a(e,we,t),a(e,jl,t),u(Ce,e,t),a(e,Ul,t),a(e,fe,t),a(e,Jl,t),a(e,ge,t),a(e,Tl,t),u(he,e,t),a(e,bl,t),a(e,Ie,t),a(e,wl,t),a(e,Ze,t),a(e,Cl,t),a(e,ve,t),a(e,fl,t),a(e,Ve,t),a(e,gl,t),a(e,We,t),a(e,hl,t),u(Be,e,t),a(e,Il,t),a(e,Ee,t),a(e,Zl,t),a(e,Ge,t),a(e,vl,t),u(Re,e,t),a(e,Vl,t),a(e,ke,t),a(e,Wl,t),a(e,$e,t),a(e,Bl,t),u(Ne,e,t),a(e,El,t),a(e,Ae,t),a(e,Gl,t),u(xe,e,t),a(e,Rl,t),a(e,Ye,t),a(e,kl,t),a(e,Qe,t),a(e,$l,t),a(e,_e,t),a(e,Nl,t),u(He,e,t),a(e,Al,t),a(e,Xe,t),a(e,xl,t),u(Le,e,t),a(e,Yl,t),u(Se,e,t),a(e,Ql,t),a(e,Fe,t),a(e,_l,t),u(ze,e,t),a(e,Hl,t),a(e,qe,t),a(e,Xl,t),a(e,Pe,t),a(e,Ll,t),a(e,De,t),a(e,Sl,t),u(Ke,e,t),a(e,Fl,t),u(Oe,e,t),a(e,zl,t),a(e,et,t),a(e,ql,t),a(e,tt,t),a(e,Pl,t),a(e,lt,t),a(e,Dl,t),a(e,at,t),a(e,Kl,t),u(st,e,t),a(e,Ol,t),a(e,nt,t),a(e,ea,t),a(e,it,t),a(e,ta,t),a(e,ot,t),a(e,la,t),u(rt,e,t),a(e,aa,t),a(e,pt,t),sa=!0},p:Ts,i(e){sa||(c(T.$$.fragment,e),c(b.$$.fragment,e),c(g.$$.fragment,e),c(v.$$.fragment,e),c(W.$$.fragment,e),c(B.$$.fragment,e),c(k.$$.fragment,e),c(N.$$.fragment,e),c(x.$$.fragment,e),c(Y.$$.fragment,e),c(_.$$.fragment,e),c(F.$$.fragment,e),c(q.$$.fragment,e),c(P.$$.fragment,e),c(le.$$.fragment,e),c(se.$$.fragment,e),c(oe.$$.fragment,e),c(ue.$$.fragment,e),c(ye.$$.fragment,e),c(Ue.$$.fragment,e),c(Te.$$.fragment,e),c(Ce.$$.fragment,e),c(he.$$.fragment,e),c(Be.$$.fragment,e),c(Re.$$.fragment,e),c(Ne.$$.fragment,e),c(xe.$$.fragment,e),c(He.$$.fragment,e),c(Le.$$.fragment,e),c(Se.$$.fragment,e),c(ze.$$.fragment,e),c(Ke.$$.fragment,e),c(Oe.$$.fragment,e),c(st.$$.fragment,e),c(rt.$$.fragment,e),sa=!0)},o(e){m(T.$$.fragment,e),m(b.$$.fragment,e),m(g.$$.fragment,e),m(v.$$.fragment,e),m(W.$$.fragment,e),m(B.$$.fragment,e),m(k.$$.fragment,e),m(N.$$.fragment,e),m(x.$$.fragment,e),m(Y.$$.fragment,e),m(_.$$.fragment,e),m(F.$$.fragment,e),m(q.$$.fragment,e),m(P.$$.fragment,e),m(le.$$.fragment,e),m(se.$$.fragment,e),m(oe.$$.fragment,e),m(ue.$$.fragment,e),m(ye.$$.fragment,e),m(Ue.$$.fragment,e),m(Te.$$.fragment,e),m(Ce.$$.fragment,e),m(he.$$.fragment,e),m(Be.$$.fragment,e),m(Re.$$.fragment,e),m(Ne.$$.fragment,e),m(xe.$$.fragment,e),m(He.$$.fragment,e),m(Le.$$.fragment,e),m(Se.$$.fragment,e),m(ze.$$.fragment,e),m(Ke.$$.fragment,e),m(Oe.$$.fragment,e),m(st.$$.fragment,e),m(rt.$$.fragment,e),sa=!1},d(e){e&&(l(ut),l(Mt),l(ct),l(mt),l(dt),l(J),l(yt),l(w),l(jt),l(C),l(Ut),l(f),l(Jt),l(Tt),l(h),l(bt),l(I),l(wt),l(Z),l(Ct),l(ft),l(V),l(gt),l(ht),l(It),l(E),l(Zt),l(G),l(vt),l(R),l(Vt),l(Wt),l($),l(Bt),l(Et),l(A),l(Gt),l(Rt),l(kt),l(Q),l($t),l(Nt),l(H),l(At),l(X),l(xt),l(L),l(Yt),l(S),l(Qt),l(_t),l(z),l(Ht),l(Xt),l(Lt),l(D),l(St),l(K),l(Ft),l(O),l(zt),l(ee),l(qt),l(te),l(Pt),l(Dt),l(ae),l(Kt),l(Ot),l(ne),l(el),l(ie),l(tl),l(ll),l(re),l(al),l(Me),l(sl),l(pe),l(nl),l(il),l(ce),l(ol),l(me),l(rl),l(de),l(Ml),l(pl),l(je),l(ul),l(cl),l(Je),l(ml),l(dl),l(be),l(yl),l(we),l(jl),l(Ul),l(fe),l(Jl),l(ge),l(Tl),l(bl),l(Ie),l(wl),l(Ze),l(Cl),l(ve),l(fl),l(Ve),l(gl),l(We),l(hl),l(Il),l(Ee),l(Zl),l(Ge),l(vl),l(Vl),l(ke),l(Wl),l($e),l(Bl),l(El),l(Ae),l(Gl),l(Rl),l(Ye),l(kl),l(Qe),l($l),l(_e),l(Nl),l(Al),l(Xe),l(xl),l(Yl),l(Ql),l(Fe),l(_l),l(Hl),l(qe),l(Xl),l(Pe),l(Ll),l(De),l(Sl),l(Fl),l(zl),l(et),l(ql),l(tt),l(Pl),l(lt),l(Dl),l(at),l(Kl),l(Ol),l(nt),l(ea),l(it),l(ta),l(ot),l(la),l(aa),l(pt)),l(U),d(T,e),d(b,e),d(g,e),d(v,e),d(W,e),d(B,e),d(k,e),d(N,e),d(x,e),d(Y,e),d(_,e),d(F,e),d(q,e),d(P,e),d(le,e),d(se,e),d(oe,e),d(ue,e),d(ye,e),d(Ue,e),d(Te,e),d(Ce,e),d(he,e),d(Be,e),d(Re,e),d(Ne,e),d(xe,e),d(He,e),d(Le,e),d(Se,e),d(ze,e),d(Ke,e),d(Oe,e),d(st,e),d(rt,e)}}}const vs='{"title":"Unidad Extra 2: Observabilidad y Evaluación de Agentes","local":"unidad-extra-2-observabilidad-y-evaluación-de-agentes","sections":[{"title":"Requisitos del Ejercicio 🏗️","local":"requisitos-del-ejercicio-","sections":[],"depth":2},{"title":"Paso 0: Instalar las Librerías Necesarias","local":"paso-0-instalar-las-librerías-necesarias","sections":[],"depth":2},{"title":"Paso 1: Instrumentar tu Agente","local":"paso-1-instrumentar-tu-agente","sections":[],"depth":2},{"title":"Paso 2: Probar tu Instrumentación","local":"paso-2-probar-tu-instrumentación","sections":[],"depth":2},{"title":"Paso 3: Observar y Evaluar un Agente Más Complejo","local":"paso-3-observar-y-evaluar-un-agente-más-complejo","sections":[{"title":"Estructura de Rastros","local":"estructura-de-rastros","sections":[],"depth":3}],"depth":2},{"title":"Evaluación en Línea","local":"evaluación-en-línea","sections":[{"title":"Métricas Comunes para Seguir en Producción","local":"métricas-comunes-para-seguir-en-producción","sections":[{"title":"1. Costos","local":"1-costos","sections":[],"depth":4},{"title":"2. Latencia","local":"2-latencia","sections":[],"depth":4},{"title":"3. Atributos Adicionales","local":"3-atributos-adicionales","sections":[],"depth":4},{"title":"4. Retroalimentación del Usuario","local":"4-retroalimentación-del-usuario","sections":[],"depth":4},{"title":"5. LLM-como-Juez","local":"5-llm-como-juez","sections":[],"depth":4},{"title":"6. Resumen de Métricas de Observabilidad","local":"6-resumen-de-métricas-de-observabilidad","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Evaluación fuera de línea","local":"evaluación-fuera-de-línea","sections":[{"title":"Evaluación con Conjuntos de Datos","local":"evaluación-con-conjuntos-de-datos","sections":[{"title":"Ejecutando el Agente en el Conjunto de Datos","local":"ejecutando-el-agente-en-el-conjunto-de-datos","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Consideraciones Finales","local":"consideraciones-finales","sections":[],"depth":2}],"depth":1}';function Vs(ia){return bs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $s extends ws{constructor(U){super(),Cs(this,U,Vs,Zs,Js,{})}}export{$s as component};
