import{s as Xn,n as Sn,o as Yn}from"../chunks/scheduler.37c15a92.js";import{S as Fn,i as An,g as a,s as l,r as u,A as Nn,h as o,f as n,c as i,j as Rt,u as p,x as r,k as Z,y as f,a as s,v as d,d as m,t as c,w as v}from"../chunks/index.2bf4358c.js";import{C as T}from"../chunks/CodeBlock.4e987730.js";import{H as we}from"../chunks/Heading.8ada512a.js";import{E as zn}from"../chunks/getInferenceSnippets.0aa3753f.js";function Pn(zt){let g,He,$e,qe,j,Ve,C,Pt=`Vous vous souvenez d’Alfred, notre agent majordome serviable de l’Unité 1 ?
Pour nous aider efficacement, Alfred doit comprendre nos demandes et <strong>préparer, trouver et utiliser les informations pertinentes pour aider à accomplir les tâches.</strong>
C’est là que les <em>components</em> de LlamaIndex entrent en jeu.`,ke,I,Qt=`Bien que LlamaIndex ait de nombreux <em>components</em>, <strong>nous nous concentrerons spécifiquement sur le <em>component</em> <code>QueryEngine</code>.</strong>
Pourquoi ? Parce qu’il peut être utilisé comme un outil de <em>Retrieval-Augmented Generation</em> (RAG) pour un agent.`,Ee,_,Ot=`Alors, qu’est-ce que le RAG ? Les LLM sont entraînés sur d’énormes corpus de données pour apprendre les connaissances générales.
Cependant, ils peuvent ne pas être entraînés sur des données pertinentes et à jour.
Le RAG résout ce problème en trouvant et récupérant des informations pertinentes de vos données et en les donnant au LLM.`,Be,G,Dt='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/rag.png" alt="RAG"/>',Re,$,Kt="Maintenant, pensez à comment Alfred fonctionne :",Xe,W,en="<li>Vous demandez à Alfred d’aider à planifier un dîner</li> <li>Alfred doit vérifier votre calendrier, vos préférences alimentaires et les menus précédents réussis</li> <li>Le <code>QueryEngine</code> aide Alfred à trouver ces informations et à les utiliser pour planifier le dîner</li>",Se,H,tn=`Cela fait du <code>QueryEngine</code> <strong>un <em>component</em> clé pour construire des <em>workflows</em> de RAG agentiques</strong> dans LlamaIndex.
Tout comme Alfred a besoin de rechercher dans les informations de votre maison pour être utile, tout agent a besoin d’un moyen de trouver et comprendre des données pertinentes.
Le <code>QueryEngine</code> fournit exactement cette capacité.`,Ye,q,nn="Maintenant, approfondissons un peu les <em>components</em> et voyons comment vous pouvez <strong>combiner les <em>components</em> pour créer un pipeline de RAG.</strong>",Fe,V,Ae,h,sn='<p>Vous pouvez suivre le code dans <a href="https://huggingface.co/agents-course/notebooks/blob/main/fr/unit2/llama-index/components.ipynb" target="_blank">ce <i>notebook</i></a> que vous pouvez exécuter avec Google Colab.</p>',Ne,k,ln="Il y a cinq étapes clés dans le RAG, qui feront partie de la plupart des applications plus ambitieuses que vous construirez. A savoir :",ze,E,an="<li><strong>Chargement</strong> : cela se réfère à obtenir vos données d’où elles vivent (qu’il s’agisse de fichiers texte, de PDF, d’un autre site web, d’une base de données, ou d’une API) dans votre <em>workflow</em>. <em>LlamaHub</em> fournit des centaines d’intégrations parmi lesquelles choisir.</li> <li><strong>Indexation</strong> : cela signifie créer une structure de données qui permet d’interroger les données. Pour les LLM, cela signifie presque toujours créer des <em>embeddings</em> vectoriels. Ce sont des représentations numériques de la signification des données. L’indexation peut également se référer à de nombreuses autres stratégies de métadonnées pour faciliter la recherche de données contextuellement pertinentes basées sur les propriétés.</li> <li><strong>Stockage</strong> : une fois vos données indexées, vous voudrez stocker votre index, ainsi que d’autres métadonnées, pour éviter de devoir ré-indexer à chaque utilisation.</li> <li><strong>Requête</strong> : pour toute stratégie d’indexation donnée, il y a de nombreuses façons d’utiliser les LLM et les structures de données LlamaIndex pour faire des requêtes, incluant des sous-requêtes, des requêtes multi-étapes et des stratégies hybrides.</li> <li><strong>Évaluation</strong> : une étape critique dans tout flux est de vérifier son efficacité par rapport à d’autres stratégies, ou lorsque vous apportez des modifications. L’évaluation fournit des mesures objectives de la précision, de la fidélité et de la rapidité de vos réponses aux requêtes.</li>",Pe,B,on="Ensuite, voyons comment nous pouvons reproduire ces étapes en utilisant des <em>components</em>.",Qe,R,Oe,X,rn=`Comme mentionné précédemment, LlamaIndex peut fonctionner au-dessus de vos propres données, cependant, <strong>avant d’accéder aux données, nous devons les charger.</strong>
Il y a trois façons principales de charger des données dans LlamaIndex :`,De,S,un="<li><code>SimpleDirectoryReader</code> : Un chargeur de données intégré pour divers types de fichiers d’un répertoire local.</li> <li><code>LlamaParse</code> : L’outil officiel de LlamaIndex pour l’analyse de PDF, disponible comme une API gérée.</li> <li><code>LlamaHub</code> : Un registre de centaines de bibliothèques de chargement de données pour ingérer des données de n’importe quelle source.</li>",Ke,x,pn='<p>Familiarisez-vous avec les chargeurs de données <a href="https://docs.llamaindex.ai/en/stable/module_guides/loading/connector/">LlamaHub</a> et le <i>parser</i> <a href="https://github.com/run-llama/llama_cloud_services/blob/main/parse.md">LlamaParse</a> pour des sources de données plus complexes.</p>',et,Y,dn=`<strong>La façon la plus simple de charger des données est avec <code>SimpleDirectoryReader</code>.</strong>
Ce <em>component</em> polyvalent peut charger divers types de fichiers d’un dossier et les convertir en objets <code>Document</code> avec lesquels LlamaIndex peut travailler.
Voyons comment nous pouvons utiliser <code>SimpleDirectoryReader</code> pour charger des données d’un dossier.`,tt,F,nt,A,mn=`Après avoir chargé nos documents, nous devons les diviser en plus petites parties appelées objets <code>Node</code>.
Un <code>Node</code> est juste un morceau de texte du document original qui est plus facile à traiter pour l’IA, tout en conservant des références à l’objet <code>Document</code> original.`,st,N,cn="L’<code>IngestionPipeline</code> nous aide à créer ces <em>nodes</em> grâce à deux transformations clés.",lt,z,vn="<li><code>SentenceSplitter</code> divise les documents en morceaux aux niveaux des phrases.</li> <li><code>HuggingFaceEmbedding</code> convertit chaque morceau en <em>embeddings</em> numériques.</li>",it,P,Mn="Ce processus nous aide à organiser nos documents d’une manière qui est plus utile pour la recherche et l’analyse.",at,Q,ot,O,rt,D,fn="Après avoir créé nos objets <code>Node</code>, nous devons les indexer pour les rendre recherchables, mais avant de pouvoir le faire, nous avons besoin d’un endroit pour stocker nos données.",ut,K,bn=`Puisque nous utilisons un pipeline d’ingestion, nous pouvons directement attacher un <em>vector store</em> au pipeline pour le remplir.
Dans ce cas, nous utiliserons <code>Chroma</code> pour stocker nos documents.`,pt,b,Le,yn="Installer ChromaDB",Xt,Ze,gn='Comme introduit dans la <a href="./llama-hub">section sur le LlamaHub</a>, nous pouvons installer le <em>vector store</em> ChromaDB avec la commande suivante :',St,ee,dt,te,mt,U,Tn='<p>Un aperçu des différents <i>vector stores</i> peut être trouvé dans la <a href="https://docs.llamaindex.ai/en/stable/module_guides/storing/vector_stores/">documentation de LlamaIndex</a>.</p>',ct,ne,hn=`C’est là que les <em>embeddings</em> vectoriels entrent en jeu. En enchassant à la fois la requête et les <em>nodes</em> dans le même espace vectoriel, nous pouvons trouver des correspondances pertinentes.
Le <code>VectorStoreIndex</code> s’occupe de cela pour nous, en utilisant le même modèle d’<em>embedding</em> que nous avons utilisé pendant l’ingestion pour assurer la cohérence.`,vt,se,xn="Voyons comment créer cet index à partir de notre <em>vector store</em> et des <em>embeddings</em> :",Mt,le,ft,ie,Un="Toutes les informations sont automatiquement persistées dans l’objet <code>ChromaVectorStore</code> et le chemin du répertoire passé.",bt,ae,Jn="Parfait ! Maintenant que nous pouvons sauvegarder et charger notre index facilement, explorons comment l’interroger de différentes manières.",yt,oe,gt,re,wn="Avant de pouvoir interroger notre index, nous devons le convertir en interface de requête. Les options de conversion les plus courantes sont :",Tt,ue,Ln="<li><code>as_retriever</code> : Pour la récupération basique de documents, retournant une liste d’objets <code>NodeWithScore</code> avec des scores de similarité</li> <li><code>as_query_engine</code> : Pour les interactions question-réponse simples, retournant une réponse écrite</li> <li><code>as_chat_engine</code> : Pour les interactions conversationnelles qui maintiennent la mémoire à travers plusieurs messages, retournant une réponse écrite utilisant l’historique de chat et le contexte indexé</li>",ht,pe,Zn=`Nous nous concentrerons sur le <em>query engine</em> car il est plus commun pour les interactions de type agent.
Nous passons également un LLM au <em>query engine</em> à utiliser pour la réponse.`,xt,de,Ut,me,Jt,ce,jn=`Sous le capot, le <em>query engine</em> n’utilise pas seulement le LLM pour répondre à la question mais utilise également un <code>ResponseSynthesizer</code> comme stratégie pour traiter la réponse.
Encore une fois, c’est entièrement personnalisable mais il y a trois stratégies principales qui fonctionnent bien prêtes à l’emploi :`,wt,ve,Cn="<li><code>refine</code> : créer et affiner une réponse en parcourant séquentiellement chaque morceau de texte récupéré. Cela fait un appel au LLM séparé pour chaque <em>Node</em>/morceau récupéré.</li> <li><code>compact</code> (par défaut) : similaire à l’affinement mais concaténant les morceaux au préalable, résultant en moins d’appels au LLM.</li> <li><code>tree_summarize</code> : créer une réponse détaillée en parcourant chaque morceau de texte récupéré et créant une structure d’arbre de la réponse.</li>",Lt,J,In='<p>Prenez un contrôle fin de vos <i>workflows</i> de requête avec l’<a href="https://docs.llamaindex.ai/en/stable/module_guides/deploying/query_engine/usage_pattern/#low-level-composition-api">API de composition de bas niveau</a>. Cette API vous permet de personnaliser et de finetuner chaque étape du processus de requête pour correspondre à vos besoins exacts, ce qui se marie également très bien avec les <a href="https://docs.llamaindex.ai/en/stable/module_guides/workflow/"><i>Workflows</i></a>.</p>',Zt,Me,_n="Le modèle de langage ne performera pas toujours de manière prévisible, donc nous ne pouvons pas être sûrs que la réponse que nous obtenons soit toujours correcte. Nous pouvons gérer cela en <strong>évaluant la qualité de la réponse</strong>.",jt,fe,Ct,be,Gn=`LlamaIndex fournit <strong>des outils d’évaluation intégrés pour évaluer la qualité des réponses.</strong>
Ces évaluateurs exploitent les LLM pour analyser les réponses à travers différentes dimensions.
Regardons les trois évaluateurs principaux disponibles :`,It,ye,$n="<li><code>FaithfulnessEvaluator</code> : Évalue la fidélité de la réponse en vérifiant si la réponse est supportée par le contexte.</li> <li><code>AnswerRelevancyEvaluator</code> : Évalue la pertinence de la réponse en vérifiant si la réponse est pertinente par rapport à la question.</li> <li><code>CorrectnessEvaluator</code> : Évalue la correction de la réponse en vérifiant si la réponse est correcte.</li>",_t,w,Wn='<p>Vous voulez en savoir plus sur l’observabilité et l’évaluation des agents ? Suivez l’<a href="https://huggingface.co/learn/agents-course/fr/bonus-unit2/introduction">Unité Bonus 2</a>.</p>',Gt,ge,$t,Te,Hn=`Même sans évaluation directe, nous pouvons <strong>obtenir des informations sur la performance de notre système grâce à l’observabilité.</strong>
Ceci est particulièrement utile quand nous construisons des <em>workflows</em> plus complexes et que nous voulons comprendre comment chaque <em>component</em> performe.`,Wt,M,je,qn="Installer LlamaTrace",Yt,Ce,Vn='Comme introduit dans la <a href="./llama-hub">section sur le LlamaHub</a>, nous pouvons installer le <em>callback</em> LlamaTrace d’Arize Phoenix avec la commande suivante :',Ft,he,At,Ie,kn="De plus, nous devons définir la variable d’environnement <code>PHOENIX_API_KEY</code> avec notre clé API LlamaTrace. Nous pouvons l’obtenir en :",Nt,_e,En='<li>Créant un compte sur <a href="https://llamatrace.com/login" rel="nofollow">LlamaTrace</a></li> <li>Générant une clé API dans les paramètres de votre compte</li> <li>Utilisant la clé API dans le code ci-dessous pour activer le <em>tracking</em></li>',Ht,xe,qt,L,Bn='<p>Vous voulez en savoir plus sur les <i>components</i> et comment les utiliser ? Continuez votre parcours avec les <a href="https://docs.llamaindex.ai/en/stable/module_guides/"><i>Guides</i> des <i>components</i></a> ou le <a href="https://docs.llamaindex.ai/en/stable/understanding/rag/"><i>Guide</i> sur le RAG</a>.</p>',Vt,Ue,Rn="Nous avons vu comment utiliser les <em>components</em> pour créer un <code>QueryEngine</code>. Maintenant, voyons comment nous pouvons <strong>utiliser le <code>QueryEngine</code> comme un outil pour un agent !</strong>",kt,Je,Et,We,Bt;return j=new we({props:{title:"Que sont les components dans LlamaIndex ?",local:"que-sont-les-components-dans-llamaindex-",headingTag:"h1"}}),V=new we({props:{title:"Créer un pipeline de RAG en utilisant des components",local:"créer-un-pipeline-de-rag-en-utilisant-des-components",headingTag:"h2"}}),R=new we({props:{title:"Chargement et intégration des documents",local:"chargement-et-intégration-des-documents",headingTag:"h3"}}),F=new T({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBTaW1wbGVEaXJlY3RvcnlSZWFkZXIlMEElMEFyZWFkZXIlMjAlM0QlMjBTaW1wbGVEaXJlY3RvcnlSZWFkZXIoaW5wdXRfZGlyJTNEJTIycGF0aCUyRnRvJTJGZGlyZWN0b3J5JTIyKSUwQWRvY3VtZW50cyUyMCUzRCUyMHJlYWRlci5sb2FkX2RhdGEoKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> SimpleDirectoryReader

reader = SimpleDirectoryReader(input_dir=<span class="hljs-string">&quot;path/to/directory&quot;</span>)
documents = reader.load_data()`,wrap:!1}}),Q=new T({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBEb2N1bWVudCUwQWZyb20lMjBsbGFtYV9pbmRleC5lbWJlZGRpbmdzLmh1Z2dpbmdmYWNlJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmclMEFmcm9tJTIwbGxhbWFfaW5kZXguY29yZS5ub2RlX3BhcnNlciUyMGltcG9ydCUyMFNlbnRlbmNlU3BsaXR0ZXIlMEFmcm9tJTIwbGxhbWFfaW5kZXguY29yZS5pbmdlc3Rpb24lMjBpbXBvcnQlMjBJbmdlc3Rpb25QaXBlbGluZSUwQSUwQSUyMyUyMGNyJUMzJUE5ZXIlMjBsZSUyMHBpcGVsaW5lJTIwYXZlYyUyMGxlcyUyMHRyYW5zZm9ybWF0aW9ucyUwQXBpcGVsaW5lJTIwJTNEJTIwSW5nZXN0aW9uUGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtYXRpb25zJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwU2VudGVuY2VTcGxpdHRlcihjaHVua19vdmVybGFwJTNEMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBIdWdnaW5nRmFjZUVtYmVkZGluZyhtb2RlbF9uYW1lJTNEJTIyQkFBSSUyRmJnZS1zbWFsbC1lbi12MS41JTIyKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSklMEElMEFub2RlcyUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUuYXJ1bihkb2N1bWVudHMlM0QlNUJEb2N1bWVudC5leGFtcGxlKCklNUQp",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> llama_index.embeddings.huggingface <span class="hljs-keyword">import</span> HuggingFaceEmbedding
<span class="hljs-keyword">from</span> llama_index.core.node_parser <span class="hljs-keyword">import</span> SentenceSplitter
<span class="hljs-keyword">from</span> llama_index.core.ingestion <span class="hljs-keyword">import</span> IngestionPipeline

<span class="hljs-comment"># créer le pipeline avec les transformations</span>
pipeline = IngestionPipeline(
    transformations=[
        SentenceSplitter(chunk_overlap=<span class="hljs-number">0</span>),
        HuggingFaceEmbedding(model_name=<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>),
    ]
)

nodes = <span class="hljs-keyword">await</span> pipeline.arun(documents=[Document.example()])`,wrap:!1}}),O=new we({props:{title:"Stockage et indexation des documents",local:"stockage-et-indexation-des-documents",headingTag:"h3"}}),ee=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxsYW1hLWluZGV4LXZlY3Rvci1zdG9yZXMtY2hyb21h",highlighted:"pip install llama-index-vector-stores-chroma",wrap:!1}}),te=new T({props:{code:"aW1wb3J0JTIwY2hyb21hZGIlMEFmcm9tJTIwbGxhbWFfaW5kZXgudmVjdG9yX3N0b3Jlcy5jaHJvbWElMjBpbXBvcnQlMjBDaHJvbWFWZWN0b3JTdG9yZSUwQSUwQWRiJTIwJTNEJTIwY2hyb21hZGIuUGVyc2lzdGVudENsaWVudChwYXRoJTNEJTIyLiUyRmFsZnJlZF9jaHJvbWFfZGIlMjIpJTBBY2hyb21hX2NvbGxlY3Rpb24lMjAlM0QlMjBkYi5nZXRfb3JfY3JlYXRlX2NvbGxlY3Rpb24oJTIyYWxmcmVkJTIyKSUwQXZlY3Rvcl9zdG9yZSUyMCUzRCUyMENocm9tYVZlY3RvclN0b3JlKGNocm9tYV9jb2xsZWN0aW9uJTNEY2hyb21hX2NvbGxlY3Rpb24pJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBJbmdlc3Rpb25QaXBlbGluZSglMEElMjAlMjAlMjAlMjB0cmFuc2Zvcm1hdGlvbnMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTZW50ZW5jZVNwbGl0dGVyKGNodW5rX3NpemUlM0QyNSUyQyUyMGNodW5rX292ZXJsYXAlM0QwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5nKG1vZGVsX25hbWUlM0QlMjJCQUFJJTJGYmdlLXNtYWxsLWVuLXYxLjUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwdmVjdG9yX3N0b3JlJTNEdmVjdG9yX3N0b3JlJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> chromadb
<span class="hljs-keyword">from</span> llama_index.vector_stores.chroma <span class="hljs-keyword">import</span> ChromaVectorStore

db = chromadb.PersistentClient(path=<span class="hljs-string">&quot;./alfred_chroma_db&quot;</span>)
chroma_collection = db.get_or_create_collection(<span class="hljs-string">&quot;alfred&quot;</span>)
vector_store = ChromaVectorStore(chroma_collection=chroma_collection)

pipeline = IngestionPipeline(
    transformations=[
        SentenceSplitter(chunk_size=<span class="hljs-number">25</span>, chunk_overlap=<span class="hljs-number">0</span>),
        HuggingFaceEmbedding(model_name=<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>),
    ],
    vector_store=vector_store,
)`,wrap:!1}}),le=new T({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBWZWN0b3JTdG9yZUluZGV4JTBBZnJvbSUyMGxsYW1hX2luZGV4LmVtYmVkZGluZ3MuaHVnZ2luZ2ZhY2UlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUVtYmVkZGluZyUwQSUwQWVtYmVkX21vZGVsJTIwJTNEJTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmcobW9kZWxfbmFtZSUzRCUyMkJBQUklMkZiZ2Utc21hbGwtZW4tdjEuNSUyMiklMEFpbmRleCUyMCUzRCUyMFZlY3RvclN0b3JlSW5kZXguZnJvbV92ZWN0b3Jfc3RvcmUodmVjdG9yX3N0b3JlJTJDJTIwZW1iZWRfbW9kZWwlM0RlbWJlZF9tb2RlbCk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> VectorStoreIndex
<span class="hljs-keyword">from</span> llama_index.embeddings.huggingface <span class="hljs-keyword">import</span> HuggingFaceEmbedding

embed_model = HuggingFaceEmbedding(model_name=<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>)
index = VectorStoreIndex.from_vector_store(vector_store, embed_model=embed_model)`,wrap:!1}}),oe=new we({props:{title:"Interroger un VectorStoreIndex avec des prompts et des LLM",local:"interroger-un-vectorstoreindex-avec-des-prompts-et-des-llm",headingTag:"h3"}}),de=new T({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmxsbXMuaHVnZ2luZ2ZhY2VfYXBpJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VJbmZlcmVuY2VBUEklMEElMEFsbG0lMjAlM0QlMjBIdWdnaW5nRmFjZUluZmVyZW5jZUFQSShtb2RlbF9uYW1lJTNEJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyKSUwQXF1ZXJ5X2VuZ2luZSUyMCUzRCUyMGluZGV4LmFzX3F1ZXJ5X2VuZ2luZSglMEElMjAlMjAlMjAlMjBsbG0lM0RsbG0lMkMlMEElMjAlMjAlMjAlMjByZXNwb25zZV9tb2RlJTNEJTIydHJlZV9zdW1tYXJpemUlMjIlMkMlMEEpJTBBcXVlcnlfZW5naW5lLnF1ZXJ5KCUyMldoYXQlMjBpcyUyMHRoZSUyMG1lYW5pbmclMjBvZiUyMGxpZmUlM0YlMjIpJTBBJTIzJTIwTGUlMjBzZW5zJTIwZGUlMjBsYSUyMHZpZSUyMGVzdCUyMDQy",highlighted:`<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
query_engine = index.as_query_engine(
    llm=llm,
    response_mode=<span class="hljs-string">&quot;tree_summarize&quot;</span>,
)
query_engine.query(<span class="hljs-string">&quot;What is the meaning of life?&quot;</span>)
<span class="hljs-comment"># Le sens de la vie est 42</span>`,wrap:!1}}),me=new we({props:{title:"Traitement des réponses",local:"traitement-des-réponses",headingTag:"h3"}}),fe=new we({props:{title:"Évaluation et observabilité",local:"évaluation-et-observabilité",headingTag:"h3"}}),ge=new T({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUuZXZhbHVhdGlvbiUyMGltcG9ydCUyMEZhaXRoZnVsbmVzc0V2YWx1YXRvciUwQSUwQXF1ZXJ5X2VuZ2luZSUyMCUzRCUyMCUyMyUyMGRlJTIwbGElMjBzZWN0aW9uJTIwcHIlQzMlQTljJUMzJUE5ZGVudGUlMEFsbG0lMjAlM0QlMjAlMjMlMjBkZSUyMGxhJTIwc2VjdGlvbiUyMHByJUMzJUE5YyVDMyVBOWRlbnRlJTBBJTBBJTIzJTIwaW5kZXglMjBkZXMlMjByZXF1JUMzJUFBdGVzJTBBZXZhbHVhdG9yJTIwJTNEJTIwRmFpdGhmdWxuZXNzRXZhbHVhdG9yKGxsbSUzRGxsbSklMEFyZXNwb25zZSUyMCUzRCUyMHF1ZXJ5X2VuZ2luZS5xdWVyeSglMEElMjAlMjAlMjAlMjAlMjJXaGF0JTIwYmF0dGxlcyUyMHRvb2slMjBwbGFjZSUyMGluJTIwTmV3JTIwWW9yayUyMENpdHklMjBpbiUyMHRoZSUyMEFtZXJpY2FuJTIwUmV2b2x1dGlvbiUzRiUyMiUwQSklMEFldmFsX3Jlc3VsdCUyMCUzRCUyMGV2YWx1YXRvci5ldmFsdWF0ZV9yZXNwb25zZShyZXNwb25zZSUzRHJlc3BvbnNlKSUwQWV2YWxfcmVzdWx0LnBhc3Npbmc=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.evaluation <span class="hljs-keyword">import</span> FaithfulnessEvaluator

query_engine = <span class="hljs-comment"># de la section précédente</span>
llm = <span class="hljs-comment"># de la section précédente</span>

<span class="hljs-comment"># index des requêtes</span>
evaluator = FaithfulnessEvaluator(llm=llm)
response = query_engine.query(
    <span class="hljs-string">&quot;What battles took place in New York City in the American Revolution?&quot;</span>
)
eval_result = evaluator.evaluate_response(response=response)
eval_result.passing`,wrap:!1}}),he=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwbGxhbWEtaW5kZXgtY2FsbGJhY2tzLWFyaXplLXBob2VuaXg=",highlighted:"pip install -U llama-index-callbacks-arize-phoenix",wrap:!1}}),xe=new T({props:{code:"aW1wb3J0JTIwbGxhbWFfaW5kZXglMEFpbXBvcnQlMjBvcyUwQSUwQVBIT0VOSVhfQVBJX0tFWSUyMCUzRCUyMCUyMiUzQ1BIT0VOSVhfQVBJX0tFWSUzRSUyMiUwQW9zLmVudmlyb24lNUIlMjJPVEVMX0VYUE9SVEVSX09UTFBfSEVBREVSUyUyMiU1RCUyMCUzRCUyMGYlMjJhcGlfa2V5JTNEJTdCUEhPRU5JWF9BUElfS0VZJTdEJTIyJTBBbGxhbWFfaW5kZXguY29yZS5zZXRfZ2xvYmFsX2hhbmRsZXIoJTBBJTIwJTIwJTIwJTIwJTIyYXJpemVfcGhvZW5peCUyMiUyQyUwQSUyMCUyMCUyMCUyMGVuZHBvaW50JTNEJTIyaHR0cHMlM0ElMkYlMkZsbGFtYXRyYWNlLmNvbSUyRnYxJTJGdHJhY2VzJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> llama_index
<span class="hljs-keyword">import</span> os

PHOENIX_API_KEY = <span class="hljs-string">&quot;&lt;PHOENIX_API_KEY&gt;&quot;</span>
os.environ[<span class="hljs-string">&quot;OTEL_EXPORTER_OTLP_HEADERS&quot;</span>] = <span class="hljs-string">f&quot;api_key=<span class="hljs-subst">{PHOENIX_API_KEY}</span>&quot;</span>
llama_index.core.set_global_handler(
    <span class="hljs-string">&quot;arize_phoenix&quot;</span>,
    endpoint=<span class="hljs-string">&quot;https://llamatrace.com/v1/traces&quot;</span>
)`,wrap:!1}}),Je=new zn({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit2/llama-index/components.mdx"}}),{c(){g=a("meta"),He=l(),$e=a("p"),qe=l(),u(j.$$.fragment),Ve=l(),C=a("p"),C.innerHTML=Pt,ke=l(),I=a("p"),I.innerHTML=Qt,Ee=l(),_=a("p"),_.textContent=Ot,Be=l(),G=a("p"),G.innerHTML=Dt,Re=l(),$=a("p"),$.textContent=Kt,Xe=l(),W=a("ol"),W.innerHTML=en,Se=l(),H=a("p"),H.innerHTML=tn,Ye=l(),q=a("p"),q.innerHTML=nn,Fe=l(),u(V.$$.fragment),Ae=l(),h=a("blockquote"),h.innerHTML=sn,Ne=l(),k=a("p"),k.textContent=ln,ze=l(),E=a("ol"),E.innerHTML=an,Pe=l(),B=a("p"),B.innerHTML=on,Qe=l(),u(R.$$.fragment),Oe=l(),X=a("p"),X.innerHTML=rn,De=l(),S=a("ol"),S.innerHTML=un,Ke=l(),x=a("blockquote"),x.innerHTML=pn,et=l(),Y=a("p"),Y.innerHTML=dn,tt=l(),u(F.$$.fragment),nt=l(),A=a("p"),A.innerHTML=mn,st=l(),N=a("p"),N.innerHTML=cn,lt=l(),z=a("ol"),z.innerHTML=vn,it=l(),P=a("p"),P.textContent=Mn,at=l(),u(Q.$$.fragment),ot=l(),u(O.$$.fragment),rt=l(),D=a("p"),D.innerHTML=fn,ut=l(),K=a("p"),K.innerHTML=bn,pt=l(),b=a("details"),Le=a("summary"),Le.textContent=yn,Xt=l(),Ze=a("p"),Ze.innerHTML=gn,St=l(),u(ee.$$.fragment),dt=l(),u(te.$$.fragment),mt=l(),U=a("blockquote"),U.innerHTML=Tn,ct=l(),ne=a("p"),ne.innerHTML=hn,vt=l(),se=a("p"),se.innerHTML=xn,Mt=l(),u(le.$$.fragment),ft=l(),ie=a("p"),ie.innerHTML=Un,bt=l(),ae=a("p"),ae.textContent=Jn,yt=l(),u(oe.$$.fragment),gt=l(),re=a("p"),re.textContent=wn,Tt=l(),ue=a("ul"),ue.innerHTML=Ln,ht=l(),pe=a("p"),pe.innerHTML=Zn,xt=l(),u(de.$$.fragment),Ut=l(),u(me.$$.fragment),Jt=l(),ce=a("p"),ce.innerHTML=jn,wt=l(),ve=a("ul"),ve.innerHTML=Cn,Lt=l(),J=a("blockquote"),J.innerHTML=In,Zt=l(),Me=a("p"),Me.innerHTML=_n,jt=l(),u(fe.$$.fragment),Ct=l(),be=a("p"),be.innerHTML=Gn,It=l(),ye=a("ul"),ye.innerHTML=$n,_t=l(),w=a("blockquote"),w.innerHTML=Wn,Gt=l(),u(ge.$$.fragment),$t=l(),Te=a("p"),Te.innerHTML=Hn,Wt=l(),M=a("details"),je=a("summary"),je.textContent=qn,Yt=l(),Ce=a("p"),Ce.innerHTML=Vn,Ft=l(),u(he.$$.fragment),At=l(),Ie=a("p"),Ie.innerHTML=kn,Nt=l(),_e=a("ul"),_e.innerHTML=En,Ht=l(),u(xe.$$.fragment),qt=l(),L=a("blockquote"),L.innerHTML=Bn,Vt=l(),Ue=a("p"),Ue.innerHTML=Rn,kt=l(),u(Je.$$.fragment),Et=l(),We=a("p"),this.h()},l(e){const t=Nn("svelte-u9bgzb",document.head);g=o(t,"META",{name:!0,content:!0}),t.forEach(n),He=i(e),$e=o(e,"P",{}),Rt($e).forEach(n),qe=i(e),p(j.$$.fragment,e),Ve=i(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-pxwiak"&&(C.innerHTML=Pt),ke=i(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1xo4nsz"&&(I.innerHTML=Qt),Ee=i(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-7uim2k"&&(_.textContent=Ot),Be=i(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-kysd50"&&(G.innerHTML=Dt),Re=i(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-44evoa"&&($.textContent=Kt),Xe=i(e),W=o(e,"OL",{"data-svelte-h":!0}),r(W)!=="svelte-jkh73n"&&(W.innerHTML=en),Se=i(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-nuxhg2"&&(H.innerHTML=tn),Ye=i(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-jft2l3"&&(q.innerHTML=nn),Fe=i(e),p(V.$$.fragment,e),Ae=i(e),h=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-sfmym1"&&(h.innerHTML=sn),Ne=i(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-fdg7ob"&&(k.textContent=ln),ze=i(e),E=o(e,"OL",{"data-svelte-h":!0}),r(E)!=="svelte-4vyxcq"&&(E.innerHTML=an),Pe=i(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-r4hmjs"&&(B.innerHTML=on),Qe=i(e),p(R.$$.fragment,e),Oe=i(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1o5em1g"&&(X.innerHTML=rn),De=i(e),S=o(e,"OL",{"data-svelte-h":!0}),r(S)!=="svelte-15w64er"&&(S.innerHTML=un),Ke=i(e),x=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(x)!=="svelte-t1xalt"&&(x.innerHTML=pn),et=i(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1irm16k"&&(Y.innerHTML=dn),tt=i(e),p(F.$$.fragment,e),nt=i(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-ve0pqg"&&(A.innerHTML=mn),st=i(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-3a0x3m"&&(N.innerHTML=cn),lt=i(e),z=o(e,"OL",{"data-svelte-h":!0}),r(z)!=="svelte-7go41n"&&(z.innerHTML=vn),it=i(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-12r0ioj"&&(P.textContent=Mn),at=i(e),p(Q.$$.fragment,e),ot=i(e),p(O.$$.fragment,e),rt=i(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1csphb"&&(D.innerHTML=fn),ut=i(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-198q9k7"&&(K.innerHTML=bn),pt=i(e),b=o(e,"DETAILS",{});var Ge=Rt(b);Le=o(Ge,"SUMMARY",{"data-svelte-h":!0}),r(Le)!=="svelte-dldaxg"&&(Le.textContent=yn),Xt=i(Ge),Ze=o(Ge,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-p36gdx"&&(Ze.innerHTML=gn),St=i(Ge),p(ee.$$.fragment,Ge),Ge.forEach(n),dt=i(e),p(te.$$.fragment,e),mt=i(e),U=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-vxu781"&&(U.innerHTML=Tn),ct=i(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-wtcah1"&&(ne.innerHTML=hn),vt=i(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-fxvav0"&&(se.innerHTML=xn),Mt=i(e),p(le.$$.fragment,e),ft=i(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1oy733j"&&(ie.innerHTML=Un),bt=i(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-t85ub1"&&(ae.textContent=Jn),yt=i(e),p(oe.$$.fragment,e),gt=i(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-v2d4vt"&&(re.textContent=wn),Tt=i(e),ue=o(e,"UL",{"data-svelte-h":!0}),r(ue)!=="svelte-1d3fy2c"&&(ue.innerHTML=Ln),ht=i(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-uizvd5"&&(pe.innerHTML=Zn),xt=i(e),p(de.$$.fragment,e),Ut=i(e),p(me.$$.fragment,e),Jt=i(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1p7e1ed"&&(ce.innerHTML=jn),wt=i(e),ve=o(e,"UL",{"data-svelte-h":!0}),r(ve)!=="svelte-p8ghcu"&&(ve.innerHTML=Cn),Lt=i(e),J=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-6r9frr"&&(J.innerHTML=In),Zt=i(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1gwo2kv"&&(Me.innerHTML=_n),jt=i(e),p(fe.$$.fragment,e),Ct=i(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1wjs2oa"&&(be.innerHTML=Gn),It=i(e),ye=o(e,"UL",{"data-svelte-h":!0}),r(ye)!=="svelte-m4seyd"&&(ye.innerHTML=$n),_t=i(e),w=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-1qwth2n"&&(w.innerHTML=Wn),Gt=i(e),p(ge.$$.fragment,e),$t=i(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1q5v3v8"&&(Te.innerHTML=Hn),Wt=i(e),M=o(e,"DETAILS",{});var y=Rt(M);je=o(y,"SUMMARY",{"data-svelte-h":!0}),r(je)!=="svelte-5rgs26"&&(je.textContent=qn),Yt=i(y),Ce=o(y,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-ytox17"&&(Ce.innerHTML=Vn),Ft=i(y),p(he.$$.fragment,y),At=i(y),Ie=o(y,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1v3b2z0"&&(Ie.innerHTML=kn),Nt=i(y),_e=o(y,"UL",{"data-svelte-h":!0}),r(_e)!=="svelte-c4es9c"&&(_e.innerHTML=En),y.forEach(n),Ht=i(e),p(xe.$$.fragment,e),qt=i(e),L=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(L)!=="svelte-1poxk2t"&&(L.innerHTML=Bn),Vt=i(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-q0glse"&&(Ue.innerHTML=Rn),kt=i(e),p(Je.$$.fragment,e),Et=i(e),We=o(e,"P",{}),Rt(We).forEach(n),this.h()},h(){Z(g,"name","hf:doc:metadata"),Z(g,"content",Qn),Z(h,"class","tip"),Z(x,"class","tip"),Z(U,"class","tip"),Z(J,"class","tip"),Z(w,"class","tip"),Z(L,"class","tip")},m(e,t){f(document.head,g),s(e,He,t),s(e,$e,t),s(e,qe,t),d(j,e,t),s(e,Ve,t),s(e,C,t),s(e,ke,t),s(e,I,t),s(e,Ee,t),s(e,_,t),s(e,Be,t),s(e,G,t),s(e,Re,t),s(e,$,t),s(e,Xe,t),s(e,W,t),s(e,Se,t),s(e,H,t),s(e,Ye,t),s(e,q,t),s(e,Fe,t),d(V,e,t),s(e,Ae,t),s(e,h,t),s(e,Ne,t),s(e,k,t),s(e,ze,t),s(e,E,t),s(e,Pe,t),s(e,B,t),s(e,Qe,t),d(R,e,t),s(e,Oe,t),s(e,X,t),s(e,De,t),s(e,S,t),s(e,Ke,t),s(e,x,t),s(e,et,t),s(e,Y,t),s(e,tt,t),d(F,e,t),s(e,nt,t),s(e,A,t),s(e,st,t),s(e,N,t),s(e,lt,t),s(e,z,t),s(e,it,t),s(e,P,t),s(e,at,t),d(Q,e,t),s(e,ot,t),d(O,e,t),s(e,rt,t),s(e,D,t),s(e,ut,t),s(e,K,t),s(e,pt,t),s(e,b,t),f(b,Le),f(b,Xt),f(b,Ze),f(b,St),d(ee,b,null),s(e,dt,t),d(te,e,t),s(e,mt,t),s(e,U,t),s(e,ct,t),s(e,ne,t),s(e,vt,t),s(e,se,t),s(e,Mt,t),d(le,e,t),s(e,ft,t),s(e,ie,t),s(e,bt,t),s(e,ae,t),s(e,yt,t),d(oe,e,t),s(e,gt,t),s(e,re,t),s(e,Tt,t),s(e,ue,t),s(e,ht,t),s(e,pe,t),s(e,xt,t),d(de,e,t),s(e,Ut,t),d(me,e,t),s(e,Jt,t),s(e,ce,t),s(e,wt,t),s(e,ve,t),s(e,Lt,t),s(e,J,t),s(e,Zt,t),s(e,Me,t),s(e,jt,t),d(fe,e,t),s(e,Ct,t),s(e,be,t),s(e,It,t),s(e,ye,t),s(e,_t,t),s(e,w,t),s(e,Gt,t),d(ge,e,t),s(e,$t,t),s(e,Te,t),s(e,Wt,t),s(e,M,t),f(M,je),f(M,Yt),f(M,Ce),f(M,Ft),d(he,M,null),f(M,At),f(M,Ie),f(M,Nt),f(M,_e),s(e,Ht,t),d(xe,e,t),s(e,qt,t),s(e,L,t),s(e,Vt,t),s(e,Ue,t),s(e,kt,t),d(Je,e,t),s(e,Et,t),s(e,We,t),Bt=!0},p:Sn,i(e){Bt||(m(j.$$.fragment,e),m(V.$$.fragment,e),m(R.$$.fragment,e),m(F.$$.fragment,e),m(Q.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(te.$$.fragment,e),m(le.$$.fragment,e),m(oe.$$.fragment,e),m(de.$$.fragment,e),m(me.$$.fragment,e),m(fe.$$.fragment,e),m(ge.$$.fragment,e),m(he.$$.fragment,e),m(xe.$$.fragment,e),m(Je.$$.fragment,e),Bt=!0)},o(e){c(j.$$.fragment,e),c(V.$$.fragment,e),c(R.$$.fragment,e),c(F.$$.fragment,e),c(Q.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(oe.$$.fragment,e),c(de.$$.fragment,e),c(me.$$.fragment,e),c(fe.$$.fragment,e),c(ge.$$.fragment,e),c(he.$$.fragment,e),c(xe.$$.fragment,e),c(Je.$$.fragment,e),Bt=!1},d(e){e&&(n(He),n($e),n(qe),n(Ve),n(C),n(ke),n(I),n(Ee),n(_),n(Be),n(G),n(Re),n($),n(Xe),n(W),n(Se),n(H),n(Ye),n(q),n(Fe),n(Ae),n(h),n(Ne),n(k),n(ze),n(E),n(Pe),n(B),n(Qe),n(Oe),n(X),n(De),n(S),n(Ke),n(x),n(et),n(Y),n(tt),n(nt),n(A),n(st),n(N),n(lt),n(z),n(it),n(P),n(at),n(ot),n(rt),n(D),n(ut),n(K),n(pt),n(b),n(dt),n(mt),n(U),n(ct),n(ne),n(vt),n(se),n(Mt),n(ft),n(ie),n(bt),n(ae),n(yt),n(gt),n(re),n(Tt),n(ue),n(ht),n(pe),n(xt),n(Ut),n(Jt),n(ce),n(wt),n(ve),n(Lt),n(J),n(Zt),n(Me),n(jt),n(Ct),n(be),n(It),n(ye),n(_t),n(w),n(Gt),n($t),n(Te),n(Wt),n(M),n(Ht),n(qt),n(L),n(Vt),n(Ue),n(kt),n(Et),n(We)),n(g),v(j,e),v(V,e),v(R,e),v(F,e),v(Q,e),v(O,e),v(ee),v(te,e),v(le,e),v(oe,e),v(de,e),v(me,e),v(fe,e),v(ge,e),v(he),v(xe,e),v(Je,e)}}}const Qn='{"title":"Que sont les components dans LlamaIndex ?","local":"que-sont-les-components-dans-llamaindex-","sections":[{"title":"Créer un pipeline de RAG en utilisant des components","local":"créer-un-pipeline-de-rag-en-utilisant-des-components","sections":[{"title":"Chargement et intégration des documents","local":"chargement-et-intégration-des-documents","sections":[],"depth":3},{"title":"Stockage et indexation des documents","local":"stockage-et-indexation-des-documents","sections":[],"depth":3},{"title":"Interroger un VectorStoreIndex avec des prompts et des LLM","local":"interroger-un-vectorstoreindex-avec-des-prompts-et-des-llm","sections":[],"depth":3},{"title":"Traitement des réponses","local":"traitement-des-réponses","sections":[],"depth":3},{"title":"Évaluation et observabilité","local":"évaluation-et-observabilité","sections":[],"depth":3}],"depth":2}],"depth":1}';function On(zt){return Yn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ss extends Fn{constructor(g){super(),An(this,g,On,Pn,Xn,{})}}export{ss as component};
