import{s as Oe,n as sl,o as el}from"../chunks/scheduler.37c15a92.js";import{S as ll,i as tl,g as o,s as n,r,m as je,A as nl,h as p,f as l,c as a,j as Je,u,x as i,n as Te,k as Js,y as ws,a as t,v as c,d as M,t as w,w as d}from"../chunks/index.2bf4358c.js";import{C as U}from"../chunks/CodeBlock.4e987730.js";import{H as f}from"../chunks/Heading.8ada512a.js";import{E as al}from"../chunks/getInferenceSnippets.0aa3753f.js";function ol(Ue){let y,Ts,ys,Us,h,fs,b,fe="Un <em>workflow</em> dans LlamaIndex fournit un moyen structuré d’organiser votre code en étapes séquentielles et gérables.",hs,I,he=`Un tel <em>workflow</em> est créé en définissant des <code>Steps</code> qui sont déclenchés par des <code>Events</code>, et qui émettent eux-mêmes des <code>Events</code> pour déclencher d’autres étapes.
Jetons un coup d’œil à Alfred montrant un <em>workflow</em> LlamaIndex pour une tâche de RAG.`,bs,v,be='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/workflows.png" alt="Workflow Schematic"/>',Is,k,Ie="<strong>Les <em>workflows</em> offrent plusieurs avantages clés :</strong>",vs,C,ve="<li>Organisation claire du code en étapes discrètes</li> <li>Architecture événementielle pour un flux de contrôle flexible</li> <li>Communication <em>type-safe</em> entre les étapes</li> <li>Gestion d’état intégrée</li> <li>Support pour des interactions d’agents simples et complexes</li>",ks,B,ke="Comme vous l’avez peut-être deviné, <strong>les <em>workflows</em> trouvent un excellent équilibre entre l’autonomie des agents tout en maintenant le contrôle sur le <em>workflow</em> global.</strong>",Cs,g,Ce="Alors, apprenons à créer un <em>workflow</em> nous-mêmes !",Bs,G,gs,j,Be='<p>Vous pouvez suivre le code dans <a href="https://huggingface.co/agents-course/notebooks/blob/main/fr/unit2/llama-index/workflows.ipynb" target="_blank">ce <i>notebook</i></a> que vous pouvez exécuter avec Google Colab.</p>',Gs,Z,Zs,m,ds,ge="Installer le package <i>Workflow</i>",de,V,Ge="section sur le LlamaHub",me,ms,Ze="Workflow",ye,E,Vs,x,Ve=`Nous pouvons créer un <em>workflow</em> en une seule étape en définissant une classe qui hérite de <code>Workflow</code> et en décorant vos fonctions avec <code>@step</code>.
Nous devrons également ajouter <code>StartEvent</code> et <code>StopEvent</code>, qui sont des événements spéciaux utilisés pour indiquer le début et la fin du <em>workflow</em>.`,Es,_,xs,W,Ee="Comme vous pouvez le voir, nous pouvons maintenant exécuter le <em>workflow</em> en appelant <code>w.run()</code>.",_s,q,Ws,Q,xe=`Pour connecter plusieurs étapes, nous <strong>créons des événements personnalisés qui transportent des données entre les étapes.</strong>
Pour ce faire, nous devons ajouter un <code>Event</code> qui est passé entre les étapes et transfère la sortie de la première étape vers la deuxième étape.`,qs,A,Qs,$,_e="L’indication de type est importante ici, car elle garantit que le <em>workflow</em> est exécuté correctement. Compliquons un peu les choses !",As,H,$s,S,We="L’indication de type est la partie la plus puissante des <em>workflows</em> car elle nous permet de créer des branches, des boucles et des jointures pour faciliter des <em>workflows</em> plus complexes.",Hs,X,qe=`Montrons un exemple de <strong>création d’une boucle</strong> en utilisant l’opérateur union <code>|</code>.
Dans l’exemple ci-dessous, nous voyons que le <code>LoopEvent</code> est pris en entrée pour l’étape et peut également être retourné en sortie.`,Ss,R,Xs,z,Rs,N,Qe="Nous pouvons également dessiner des <em>workflows</em>. Utilisons la fonction <code>draw_all_possible_flows</code> pour dessiner le <em>workflow</em>. Cela stocke le <em>workflow</em> dans un fichier HTML.",zs,L,Ns,F,Ae='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/workflow-draw.png" alt="workflow drawing"/>',Ls,Y,$e="Il y a une dernière astuce cool que nous couvrirons dans le cours, qui est la capacité d’ajouter de l’état au <em>workflow</em>.",Fs,P,Ys,D,He=`La gestion d’état est utile quand vous voulez garder une trace de l’état du <em>workflow</em>, pour que chaque étape ait accès au même état.
Nous pouvons faire cela en utilisant l’indication de type <code>Context</code> au-dessus d’un paramètre dans la fonction d’étape.`,Ps,K,Ds,O,Se="Parfait ! Maintenant vous savez comment créer des <em>workflows</em> de base dans LlamaIndex !",Ks,J,Xe='<p>Il y a quelques nuances plus complexes aux <i>workflows</i>, que vous pouvez apprendre dans <a href="https://docs.llamaindex.ai/en/stable/understanding/workflows/">la documentation LlamaIndex</a>.</p>',Os,ss,Re="Cependant, il y a une autre façon de créer des <em>workflows</em>, qui repose sur la classe <code>AgentWorkflow</code>. Jetons un coup d’œil à comment nous pouvons utiliser cela pour créer un <em>workflow</em> multi-agents.",se,es,ee,ls,ze=`Au lieu de la création manuelle de <em>workflows</em>, nous pouvons utiliser la <strong>classe <code>AgentWorkflow</code> pour créer un <em>workflow</em> multi-agents</strong>.
L’<code>AgentWorkflow</code> utilise des <em>Workflow Agents</em> pour vous permettre de créer un système d’un ou plusieurs agents qui peuvent collaborer et se passer des tâches entre eux basées sur leurs capacités spécialisées.
Cela permet de construire des systèmes d’agents complexes où différents agents gèrent différents aspects d’une tâche.
Au lieu d’importer des classes de <code>llama_index.core.agent</code>, nous importerons les classes d’agents de <code>llama_index.core.agent.workflow</code>.
Un agent doit être désigné comme l’agent racine dans le constructeur <code>AgentWorkflow</code>.
Quand un message utilisateur arrive, il est d’abord routé vers l’agent racine.`,le,ts,Ne="Chaque agent peut ensuite :",te,ns,Le="<li>Gérer la demande directement en utilisant leurs outils</li> <li>Passer le relais à un autre agent mieux adapté à la tâche</li> <li>Retourner une réponse à l’utilisateur</li>",ne,as,Fe="Voyons comment créer un <em>workflow</em> multi-agents.",ae,os,oe,ps,Ye=`Les outils d’agents peuvent également modifier l’état du <em>workflow</em> que nous avons mentionné plus tôt. Avant de commencer le <em>workflow</em>, nous pouvons fournir un dictionnaire d’état initial qui sera disponible pour tous les agents.
L’état est stocké dans la clé d’état du contexte du <em>workflow</em>. Il sera injecté dans le <em>state_prompt</em> qui augmente chaque nouveau message utilisateur.`,pe,is,Pe="Injectons un compteur pour compter les appels de fonctions en modifiant l’exemple précédent :",ie,rs,re,us,De="Félicitations ! Vous avez maintenant passer en revue les bases des agents dans LlamaIndex ! 🎉",ue,cs,Ke="Continuons avec un dernier quiz pour solidifier vos connaissances ! 🚀",ce,Ms,Me,js,we;return h=new f({props:{title:"Créer des workflows agentiques dans LlamaIndex",local:"créer-des-workflows-agentiques-dans-llamaindex",headingTag:"h1"}}),G=new f({props:{title:"Créer des Workflows",local:"créer-des-workflows",headingTag:"h2"}}),Z=new f({props:{title:"Création de Workflow de base",local:"création-de-workflow-de-base",headingTag:"h3"}}),E=new U({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxsYW1hLWluZGV4LXV0aWxzLXdvcmtmbG93",highlighted:"pip install llama-index-utils-workflow",wrap:!1}}),_=new U({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBTdGFydEV2ZW50JTJDJTIwU3RvcEV2ZW50JTJDJTIwV29ya2Zsb3clMkMlMjBzdGVwJTBBJTBBY2xhc3MlMjBNeVdvcmtmbG93KFdvcmtmbG93KSUzQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMG15X3N0ZXAoc2VsZiUyQyUyMGV2JTNBJTIwU3RhcnRFdmVudCklMjAtJTNFJTIwU3RvcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZG8lMjBzb21ldGhpbmclMjBoZXJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRCUyMkhlbGxvJTJDJTIwd29ybGQhJTIyKSUwQSUwQSUwQXclMjAlM0QlMjBNeVdvcmtmbG93KHRpbWVvdXQlM0QxMCUyQyUyMHZlcmJvc2UlM0RGYWxzZSklMEFyZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHcucnVuKCk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> StartEvent, StopEvent, Workflow, step

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">my_step</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># do something here</span>
        <span class="hljs-keyword">return</span> StopEvent(result=<span class="hljs-string">&quot;Hello, world!&quot;</span>)


w = MyWorkflow(timeout=<span class="hljs-number">10</span>, verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()`,wrap:!1}}),q=new f({props:{title:"Connecter plusieurs étapes",local:"connecter-plusieurs-étapes",headingTag:"h3"}}),A=new U({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBFdmVudCUwQSUwQWNsYXNzJTIwUHJvY2Vzc2luZ0V2ZW50KEV2ZW50KSUzQSUwQSUyMCUyMCUyMCUyMGludGVybWVkaWF0ZV9yZXN1bHQlM0ElMjBzdHIlMEElMEFjbGFzcyUyME11bHRpU3RlcFdvcmtmbG93KFdvcmtmbG93KSUzQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMHN0ZXBfb25lKHNlbGYlMkMlMjBldiUzQSUyMFN0YXJ0RXZlbnQpJTIwLSUzRSUyMFByb2Nlc3NpbmdFdmVudCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFRyYWl0ZW1lbnQlMjBkZXMlMjBkb25uJUMzJUE5ZXMlMjBpbml0aWFsZXMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBQcm9jZXNzaW5nRXZlbnQoaW50ZXJtZWRpYXRlX3Jlc3VsdCUzRCUyMlN0ZXAlMjAxJTIwY29tcGxldGUlMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTQwc3RlcCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc3RlcF90d28oc2VsZiUyQyUyMGV2JTNBJTIwUHJvY2Vzc2luZ0V2ZW50KSUyMC0lM0UlMjBTdG9wRXZlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBVdGlsaXNlciUyMGxlJTIwciVDMyVBOXN1bHRhdCUyMGludGVybSVDMyVBOWRpYWlyZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZpbmFsX3Jlc3VsdCUyMCUzRCUyMGYlMjJGaW5pc2hlZCUyMHByb2Nlc3NpbmclM0ElMjAlN0Jldi5pbnRlcm1lZGlhdGVfcmVzdWx0JTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRGZpbmFsX3Jlc3VsdCklMEElMEF3JTIwJTNEJTIwTXVsdGlTdGVwV29ya2Zsb3codGltZW91dCUzRDEwJTJDJTIwdmVyYm9zZSUzREZhbHNlKSUwQXJlc3VsdCUyMCUzRCUyMGF3YWl0JTIwdy5ydW4oKSUwQXJlc3VsdA==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Event

<span class="hljs-keyword">class</span> <span class="hljs-title class_">ProcessingEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    intermediate_result: <span class="hljs-built_in">str</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiStepWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_one</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; ProcessingEvent:
        <span class="hljs-comment"># Traitement des données initiales</span>
        <span class="hljs-keyword">return</span> ProcessingEvent(intermediate_result=<span class="hljs-string">&quot;Step 1 complete&quot;</span>)

<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_two</span>(<span class="hljs-params">self, ev: ProcessingEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># Utiliser le résultat intermédiaire</span>
        final_result = <span class="hljs-string">f&quot;Finished processing: <span class="hljs-subst">{ev.intermediate_result}</span>&quot;</span>
        <span class="hljs-keyword">return</span> StopEvent(result=final_result)

w = MultiStepWorkflow(timeout=<span class="hljs-number">10</span>, verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()
result`,wrap:!1}}),H=new f({props:{title:"Boucles et branches",local:"boucles-et-branches",headingTag:"h3"}}),R=new U({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBFdmVudCUwQWltcG9ydCUyMHJhbmRvbSUwQSUwQSUwQWNsYXNzJTIwUHJvY2Vzc2luZ0V2ZW50KEV2ZW50KSUzQSUwQSUyMCUyMCUyMCUyMGludGVybWVkaWF0ZV9yZXN1bHQlM0ElMjBzdHIlMEElMEElMEFjbGFzcyUyMExvb3BFdmVudChFdmVudCklM0ElMEElMjAlMjAlMjAlMjBsb29wX291dHB1dCUzQSUyMHN0ciUwQSUwQSUwQWNsYXNzJTIwTXVsdGlTdGVwV29ya2Zsb3coV29ya2Zsb3cpJTNBJTBBJTIwJTIwJTIwJTIwJTQwc3RlcCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc3RlcF9vbmUoc2VsZiUyQyUyMGV2JTNBJTIwU3RhcnRFdmVudCUyMCU3QyUyMExvb3BFdmVudCklMjAtJTNFJTIwUHJvY2Vzc2luZ0V2ZW50JTIwJTdDJTIwTG9vcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjByYW5kb20ucmFuZGludCgwJTJDJTIwMSklMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyQmFkJTIwdGhpbmclMjBoYXBwZW5lZCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBMb29wRXZlbnQobG9vcF9vdXRwdXQlM0QlMjJCYWNrJTIwdG8lMjBzdGVwJTIwb25lLiUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyR29vZCUyMHRoaW5nJTIwaGFwcGVuZWQlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwUHJvY2Vzc2luZ0V2ZW50KGludGVybWVkaWF0ZV9yZXN1bHQlM0QlMjJGaXJzdCUyMHN0ZXAlMjBjb21wbGV0ZS4lMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTQwc3RlcCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc3RlcF90d28oc2VsZiUyQyUyMGV2JTNBJTIwUHJvY2Vzc2luZ0V2ZW50KSUyMC0lM0UlMjBTdG9wRXZlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBVdGlsaXNlciUyMGxlJTIwciVDMyVBOXN1bHRhdCUyMGludGVybSVDMyVBOWRpYWlyZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZpbmFsX3Jlc3VsdCUyMCUzRCUyMGYlMjJGaW5pc2hlZCUyMHByb2Nlc3NpbmclM0ElMjAlN0Jldi5pbnRlcm1lZGlhdGVfcmVzdWx0JTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRGZpbmFsX3Jlc3VsdCklMEElMEElMEF3JTIwJTNEJTIwTXVsdGlTdGVwV29ya2Zsb3codmVyYm9zZSUzREZhbHNlKSUwQXJlc3VsdCUyMCUzRCUyMGF3YWl0JTIwdy5ydW4oKSUwQXJlc3VsdA==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Event
<span class="hljs-keyword">import</span> random


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ProcessingEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    intermediate_result: <span class="hljs-built_in">str</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoopEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    loop_output: <span class="hljs-built_in">str</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiStepWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_one</span>(<span class="hljs-params">self, ev: StartEvent | LoopEvent</span>) -&gt; ProcessingEvent | LoopEvent:
        <span class="hljs-keyword">if</span> random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>) == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Bad thing happened&quot;</span>)
            <span class="hljs-keyword">return</span> LoopEvent(loop_output=<span class="hljs-string">&quot;Back to step one.&quot;</span>)
        <span class="hljs-keyword">else</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Good thing happened&quot;</span>)
            <span class="hljs-keyword">return</span> ProcessingEvent(intermediate_result=<span class="hljs-string">&quot;First step complete.&quot;</span>)

<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_two</span>(<span class="hljs-params">self, ev: ProcessingEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># Utiliser le résultat intermédiaire</span>
        final_result = <span class="hljs-string">f&quot;Finished processing: <span class="hljs-subst">{ev.intermediate_result}</span>&quot;</span>
        <span class="hljs-keyword">return</span> StopEvent(result=final_result)


w = MultiStepWorkflow(verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()
result`,wrap:!1}}),z=new f({props:{title:"Dessiner des Workflows",local:"dessiner-des-workflows",headingTag:"h3"}}),L=new U({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LnV0aWxzLndvcmtmbG93JTIwaW1wb3J0JTIwZHJhd19hbGxfcG9zc2libGVfZmxvd3MlMEElMEF3JTIwJTNEJTIwLi4uJTIwJTIzJTIwdGVsJTIwcXVlJTIwZCVDMyVBOWZpbmklMjBkYW5zJTIwbGElMjBzZWN0aW9uJTIwcHIlQzMlQTljJUMzJUE5ZGVudGV0ZWwlMjBxdWUlMjBkJUMzJUE5ZmluaSUyMGRhbnMlMjBsYSUyMHNlY3Rpb24lMjBwciVDMyVBOWMlQzMlQTlkZW50ZSUwQWRyYXdfYWxsX3Bvc3NpYmxlX2Zsb3dzKHclMkMlMjAlMjJmbG93Lmh0bWwlMjIp",highlighted:`<span class="hljs-keyword">from</span> llama_index.utils.workflow <span class="hljs-keyword">import</span> draw_all_possible_flows

w = ... <span class="hljs-comment"># tel que défini dans la section précédentetel que défini dans la section précédente</span>
draw_all_possible_flows(w, <span class="hljs-string">&quot;flow.html&quot;</span>)`,wrap:!1}}),P=new f({props:{title:"Gestion d’état",local:"gestion-détat",headingTag:"h3"}}),K=new U({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBDb250ZXh0JTJDJTIwU3RhcnRFdmVudCUyQyUyMFN0b3BFdmVudCUwQSUwQSUwQSU0MHN0ZXAlMEFhc3luYyUyMGRlZiUyMHF1ZXJ5KHNlbGYlMkMlMjBjdHglM0ElMjBDb250ZXh0JTJDJTIwZXYlM0ElMjBTdGFydEV2ZW50KSUyMC0lM0UlMjBTdG9wRXZlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBzdG9ja2VyJTIwbGElMjByZXF1JUMzJUFBdGUlMjBkYW5zJTIwbGUlMjBjb250ZXh0ZSUwQSUyMCUyMCUyMCUyMGF3YWl0JTIwY3R4LnN0b3JlLnNldCglMjJxdWVyeSUyMiUyQyUyMCUyMldoYXQlMjBpcyUyMHRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUzRiUyMiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBmYWlyZSUyMHF1ZWxxdWUlMjBjaG9zZSUyMGF2ZWMlMjBsZSUyMGNvbnRleHRlJTIwZXQlMjBsJ2V2ZW50JTBBJTIwJTIwJTIwJTIwdmFsJTIwJTNEJTIwLi4uJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwciVDMyVBOWN1cCVDMyVBOXJlciUyMGxhJTIwcmVxdSVDMyVBQXRlJTIwZGFucyUyMGxlJTIwY29udGV4dGUlMEElMjAlMjAlMjAlMjBxdWVyeSUyMCUzRCUyMGF3YWl0JTIwY3R4LnN0b3JlLmdldCglMjJxdWVyeSUyMiklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBTdG9wRXZlbnQocmVzdWx0JTNEdmFsKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context, StartEvent, StopEvent


<span class="hljs-meta">@step</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">query</span>(<span class="hljs-params">self, ctx: Context, ev: StartEvent</span>) -&gt; StopEvent:
    <span class="hljs-comment"># stocker la requête dans le contexte</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;What is the capital of France?&quot;</span>)

    <span class="hljs-comment"># faire quelque chose avec le contexte et l&#x27;event</span>
    val = ...

    <span class="hljs-comment"># récupérer la requête dans le contexte</span>
    query = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;query&quot;</span>)

    <span class="hljs-keyword">return</span> StopEvent(result=val)`,wrap:!1}}),es=new f({props:{title:"Automatiser les workflows avec des Multi-Agent Workflows",local:"automatiser-les-workflows-avec-des-multi-agent-workflows",headingTag:"h2"}}),os=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.agent.workflow <span class="hljs-keyword">import</span> AgentWorkflow, ReActAgent
<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

<span class="hljs-comment"># Définir quelques outils</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Additionner deux nombres.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a + b

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplier deux nombres.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

<span class="hljs-comment"># nous pouvons passer des fonctions directement sans FunctionTool -- les fn/docstring sont analysés pour le nom/description</span>
multiply_agent = ReActAgent(
    name=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Is able to multiply two integers&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;A helpful assistant that can use a tool to multiply numbers.&quot;</span>,
    tools=[multiply],
    llm=llm,
)

addition_agent = ReActAgent(
    name=<span class="hljs-string">&quot;add_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Is able to add two integers&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;A helpful assistant that can use a tool to add numbers.&quot;</span>,
    tools=[add],
    llm=llm,
)

<span class="hljs-comment"># Créer le workflow</span>
workflow = AgentWorkflow(
    agents=[multiply_agent, addition_agent],
    root_agent=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
)

<span class="hljs-comment"># Exécuter le système</span>
response = <span class="hljs-keyword">await</span> workflow.run(user_msg=<span class="hljs-string">&quot;Can you add 5 and 3?&quot;</span>)`,wrap:!1}}),rs=new U({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context

<span class="hljs-comment"># Définir quelques outils</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">ctx: Context, a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Additionner deux nombres.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># mettre à jour notre comptage</span>
    cur_state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
    cur_state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>] += <span class="hljs-number">1</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;state&quot;</span>, cur_state)

    <span class="hljs-keyword">return</span> a + b

<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">ctx: Context, a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplier deux nombres.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># mettre à jour notre comptage</span>
    cur_state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
    cur_state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>] += <span class="hljs-number">1</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;state&quot;</span>, cur_state)

    <span class="hljs-keyword">return</span> a * b

...

workflow = AgentWorkflow(
    agents=[multiply_agent, addition_agent],
    root_agent=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
    initial_state={<span class="hljs-string">&quot;num_fn_calls&quot;</span>: <span class="hljs-number">0</span>},
    state_prompt=<span class="hljs-string">&quot;Current state: {state}. User message: {msg}&quot;</span>,
)

<span class="hljs-comment"># exécuter le workflow avec le contexte</span>
ctx = Context(workflow)
response = <span class="hljs-keyword">await</span> workflow.run(user_msg=<span class="hljs-string">&quot;Can you add 5 and 3?&quot;</span>, ctx=ctx)

<span class="hljs-comment"># sortir et inspecter l&#x27;état</span>
state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
<span class="hljs-built_in">print</span>(state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>])`,wrap:!1}}),Ms=new al({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit2/llama-index/workflows.mdx"}}),{c(){y=o("meta"),Ts=n(),ys=o("p"),Us=n(),r(h.$$.fragment),fs=n(),b=o("p"),b.innerHTML=fe,hs=n(),I=o("p"),I.innerHTML=he,bs=n(),v=o("p"),v.innerHTML=be,Is=n(),k=o("p"),k.innerHTML=Ie,vs=n(),C=o("ul"),C.innerHTML=ve,ks=n(),B=o("p"),B.innerHTML=ke,Cs=n(),g=o("p"),g.innerHTML=Ce,Bs=n(),r(G.$$.fragment),gs=n(),j=o("blockquote"),j.innerHTML=Be,Gs=n(),r(Z.$$.fragment),Zs=n(),m=o("details"),ds=o("summary"),ds.innerHTML=ge,de=je(`
Comme introduit dans la `),V=o("a"),V.textContent=Ge,me=je(", nous pouvons installer le package "),ms=o("code"),ms.textContent=Ze,ye=je(` avec la commande suivante :

	`),r(E.$$.fragment),Vs=n(),x=o("p"),x.innerHTML=Ve,Es=n(),r(_.$$.fragment),xs=n(),W=o("p"),W.innerHTML=Ee,_s=n(),r(q.$$.fragment),Ws=n(),Q=o("p"),Q.innerHTML=xe,qs=n(),r(A.$$.fragment),Qs=n(),$=o("p"),$.innerHTML=_e,As=n(),r(H.$$.fragment),$s=n(),S=o("p"),S.innerHTML=We,Hs=n(),X=o("p"),X.innerHTML=qe,Ss=n(),r(R.$$.fragment),Xs=n(),r(z.$$.fragment),Rs=n(),N=o("p"),N.innerHTML=Qe,zs=n(),r(L.$$.fragment),Ns=n(),F=o("p"),F.innerHTML=Ae,Ls=n(),Y=o("p"),Y.innerHTML=$e,Fs=n(),r(P.$$.fragment),Ys=n(),D=o("p"),D.innerHTML=He,Ps=n(),r(K.$$.fragment),Ds=n(),O=o("p"),O.innerHTML=Se,Ks=n(),J=o("blockquote"),J.innerHTML=Xe,Os=n(),ss=o("p"),ss.innerHTML=Re,se=n(),r(es.$$.fragment),ee=n(),ls=o("p"),ls.innerHTML=ze,le=n(),ts=o("p"),ts.textContent=Ne,te=n(),ns=o("ul"),ns.innerHTML=Le,ne=n(),as=o("p"),as.innerHTML=Fe,ae=n(),r(os.$$.fragment),oe=n(),ps=o("p"),ps.innerHTML=Ye,pe=n(),is=o("p"),is.textContent=Pe,ie=n(),r(rs.$$.fragment),re=n(),us=o("p"),us.textContent=De,ue=n(),cs=o("p"),cs.textContent=Ke,ce=n(),r(Ms.$$.fragment),Me=n(),js=o("p"),this.h()},l(s){const e=nl("svelte-u9bgzb",document.head);y=p(e,"META",{name:!0,content:!0}),e.forEach(l),Ts=a(s),ys=p(s,"P",{}),Je(ys).forEach(l),Us=a(s),u(h.$$.fragment,s),fs=a(s),b=p(s,"P",{"data-svelte-h":!0}),i(b)!=="svelte-5cgz8d"&&(b.innerHTML=fe),hs=a(s),I=p(s,"P",{"data-svelte-h":!0}),i(I)!=="svelte-cbvicn"&&(I.innerHTML=he),bs=a(s),v=p(s,"P",{"data-svelte-h":!0}),i(v)!=="svelte-whmuha"&&(v.innerHTML=be),Is=a(s),k=p(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-klkse7"&&(k.innerHTML=Ie),vs=a(s),C=p(s,"UL",{"data-svelte-h":!0}),i(C)!=="svelte-1xmwb5a"&&(C.innerHTML=ve),ks=a(s),B=p(s,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1w1c494"&&(B.innerHTML=ke),Cs=a(s),g=p(s,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1b9bk90"&&(g.innerHTML=Ce),Bs=a(s),u(G.$$.fragment,s),gs=a(s),j=p(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(j)!=="svelte-oi3xbb"&&(j.innerHTML=Be),Gs=a(s),u(Z.$$.fragment,s),Zs=a(s),m=p(s,"DETAILS",{});var T=Je(m);ds=p(T,"SUMMARY",{"data-svelte-h":!0}),i(ds)!=="svelte-19cqk5h"&&(ds.innerHTML=ge),de=Te(T,`
Comme introduit dans la `),V=p(T,"A",{href:!0,"data-svelte-h":!0}),i(V)!=="svelte-1pl43ly"&&(V.textContent=Ge),me=Te(T,", nous pouvons installer le package "),ms=p(T,"CODE",{"data-svelte-h":!0}),i(ms)!=="svelte-sosek1"&&(ms.textContent=Ze),ye=Te(T,` avec la commande suivante :

	`),u(E.$$.fragment,T),T.forEach(l),Vs=a(s),x=p(s,"P",{"data-svelte-h":!0}),i(x)!=="svelte-1sl0sod"&&(x.innerHTML=Ve),Es=a(s),u(_.$$.fragment,s),xs=a(s),W=p(s,"P",{"data-svelte-h":!0}),i(W)!=="svelte-931ze4"&&(W.innerHTML=Ee),_s=a(s),u(q.$$.fragment,s),Ws=a(s),Q=p(s,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-12kywcz"&&(Q.innerHTML=xe),qs=a(s),u(A.$$.fragment,s),Qs=a(s),$=p(s,"P",{"data-svelte-h":!0}),i($)!=="svelte-qgro0z"&&($.innerHTML=_e),As=a(s),u(H.$$.fragment,s),$s=a(s),S=p(s,"P",{"data-svelte-h":!0}),i(S)!=="svelte-szxamf"&&(S.innerHTML=We),Hs=a(s),X=p(s,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1lfwgtw"&&(X.innerHTML=qe),Ss=a(s),u(R.$$.fragment,s),Xs=a(s),u(z.$$.fragment,s),Rs=a(s),N=p(s,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1ovmdvg"&&(N.innerHTML=Qe),zs=a(s),u(L.$$.fragment,s),Ns=a(s),F=p(s,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1j5vf43"&&(F.innerHTML=Ae),Ls=a(s),Y=p(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1j9ku4g"&&(Y.innerHTML=$e),Fs=a(s),u(P.$$.fragment,s),Ys=a(s),D=p(s,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1e7y3ck"&&(D.innerHTML=He),Ps=a(s),u(K.$$.fragment,s),Ds=a(s),O=p(s,"P",{"data-svelte-h":!0}),i(O)!=="svelte-dlbiw8"&&(O.innerHTML=Se),Ks=a(s),J=p(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(J)!=="svelte-7hggce"&&(J.innerHTML=Xe),Os=a(s),ss=p(s,"P",{"data-svelte-h":!0}),i(ss)!=="svelte-qiy9vi"&&(ss.innerHTML=Re),se=a(s),u(es.$$.fragment,s),ee=a(s),ls=p(s,"P",{"data-svelte-h":!0}),i(ls)!=="svelte-lpmh0e"&&(ls.innerHTML=ze),le=a(s),ts=p(s,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-gkja97"&&(ts.textContent=Ne),te=a(s),ns=p(s,"UL",{"data-svelte-h":!0}),i(ns)!=="svelte-10bnzp4"&&(ns.innerHTML=Le),ne=a(s),as=p(s,"P",{"data-svelte-h":!0}),i(as)!=="svelte-j3rou5"&&(as.innerHTML=Fe),ae=a(s),u(os.$$.fragment,s),oe=a(s),ps=p(s,"P",{"data-svelte-h":!0}),i(ps)!=="svelte-181xssw"&&(ps.innerHTML=Ye),pe=a(s),is=p(s,"P",{"data-svelte-h":!0}),i(is)!=="svelte-bbhsjt"&&(is.textContent=Pe),ie=a(s),u(rs.$$.fragment,s),re=a(s),us=p(s,"P",{"data-svelte-h":!0}),i(us)!=="svelte-101kzby"&&(us.textContent=De),ue=a(s),cs=p(s,"P",{"data-svelte-h":!0}),i(cs)!=="svelte-rfxun4"&&(cs.textContent=Ke),ce=a(s),u(Ms.$$.fragment,s),Me=a(s),js=p(s,"P",{}),Je(js).forEach(l),this.h()},h(){Js(y,"name","hf:doc:metadata"),Js(y,"content",pl),Js(j,"class","tip"),Js(V,"href","./llama-hub"),Js(J,"class","tip")},m(s,e){ws(document.head,y),t(s,Ts,e),t(s,ys,e),t(s,Us,e),c(h,s,e),t(s,fs,e),t(s,b,e),t(s,hs,e),t(s,I,e),t(s,bs,e),t(s,v,e),t(s,Is,e),t(s,k,e),t(s,vs,e),t(s,C,e),t(s,ks,e),t(s,B,e),t(s,Cs,e),t(s,g,e),t(s,Bs,e),c(G,s,e),t(s,gs,e),t(s,j,e),t(s,Gs,e),c(Z,s,e),t(s,Zs,e),t(s,m,e),ws(m,ds),ws(m,de),ws(m,V),ws(m,me),ws(m,ms),ws(m,ye),c(E,m,null),t(s,Vs,e),t(s,x,e),t(s,Es,e),c(_,s,e),t(s,xs,e),t(s,W,e),t(s,_s,e),c(q,s,e),t(s,Ws,e),t(s,Q,e),t(s,qs,e),c(A,s,e),t(s,Qs,e),t(s,$,e),t(s,As,e),c(H,s,e),t(s,$s,e),t(s,S,e),t(s,Hs,e),t(s,X,e),t(s,Ss,e),c(R,s,e),t(s,Xs,e),c(z,s,e),t(s,Rs,e),t(s,N,e),t(s,zs,e),c(L,s,e),t(s,Ns,e),t(s,F,e),t(s,Ls,e),t(s,Y,e),t(s,Fs,e),c(P,s,e),t(s,Ys,e),t(s,D,e),t(s,Ps,e),c(K,s,e),t(s,Ds,e),t(s,O,e),t(s,Ks,e),t(s,J,e),t(s,Os,e),t(s,ss,e),t(s,se,e),c(es,s,e),t(s,ee,e),t(s,ls,e),t(s,le,e),t(s,ts,e),t(s,te,e),t(s,ns,e),t(s,ne,e),t(s,as,e),t(s,ae,e),c(os,s,e),t(s,oe,e),t(s,ps,e),t(s,pe,e),t(s,is,e),t(s,ie,e),c(rs,s,e),t(s,re,e),t(s,us,e),t(s,ue,e),t(s,cs,e),t(s,ce,e),c(Ms,s,e),t(s,Me,e),t(s,js,e),we=!0},p:sl,i(s){we||(M(h.$$.fragment,s),M(G.$$.fragment,s),M(Z.$$.fragment,s),M(E.$$.fragment,s),M(_.$$.fragment,s),M(q.$$.fragment,s),M(A.$$.fragment,s),M(H.$$.fragment,s),M(R.$$.fragment,s),M(z.$$.fragment,s),M(L.$$.fragment,s),M(P.$$.fragment,s),M(K.$$.fragment,s),M(es.$$.fragment,s),M(os.$$.fragment,s),M(rs.$$.fragment,s),M(Ms.$$.fragment,s),we=!0)},o(s){w(h.$$.fragment,s),w(G.$$.fragment,s),w(Z.$$.fragment,s),w(E.$$.fragment,s),w(_.$$.fragment,s),w(q.$$.fragment,s),w(A.$$.fragment,s),w(H.$$.fragment,s),w(R.$$.fragment,s),w(z.$$.fragment,s),w(L.$$.fragment,s),w(P.$$.fragment,s),w(K.$$.fragment,s),w(es.$$.fragment,s),w(os.$$.fragment,s),w(rs.$$.fragment,s),w(Ms.$$.fragment,s),we=!1},d(s){s&&(l(Ts),l(ys),l(Us),l(fs),l(b),l(hs),l(I),l(bs),l(v),l(Is),l(k),l(vs),l(C),l(ks),l(B),l(Cs),l(g),l(Bs),l(gs),l(j),l(Gs),l(Zs),l(m),l(Vs),l(x),l(Es),l(xs),l(W),l(_s),l(Ws),l(Q),l(qs),l(Qs),l($),l(As),l($s),l(S),l(Hs),l(X),l(Ss),l(Xs),l(Rs),l(N),l(zs),l(Ns),l(F),l(Ls),l(Y),l(Fs),l(Ys),l(D),l(Ps),l(Ds),l(O),l(Ks),l(J),l(Os),l(ss),l(se),l(ee),l(ls),l(le),l(ts),l(te),l(ns),l(ne),l(as),l(ae),l(oe),l(ps),l(pe),l(is),l(ie),l(re),l(us),l(ue),l(cs),l(ce),l(Me),l(js)),l(y),d(h,s),d(G,s),d(Z,s),d(E),d(_,s),d(q,s),d(A,s),d(H,s),d(R,s),d(z,s),d(L,s),d(P,s),d(K,s),d(es,s),d(os,s),d(rs,s),d(Ms,s)}}}const pl='{"title":"Créer des workflows agentiques dans LlamaIndex","local":"créer-des-workflows-agentiques-dans-llamaindex","sections":[{"title":"Créer des Workflows","local":"créer-des-workflows","sections":[{"title":"Création de Workflow de base","local":"création-de-workflow-de-base","sections":[],"depth":3},{"title":"Connecter plusieurs étapes","local":"connecter-plusieurs-étapes","sections":[],"depth":3},{"title":"Boucles et branches","local":"boucles-et-branches","sections":[],"depth":3},{"title":"Dessiner des Workflows","local":"dessiner-des-workflows","sections":[],"depth":3},{"title":"Gestion d’état","local":"gestion-détat","sections":[],"depth":3}],"depth":2},{"title":"Automatiser les workflows avec des Multi-Agent Workflows","local":"automatiser-les-workflows-avec-des-multi-agent-workflows","sections":[],"depth":2}],"depth":1}';function il(Ue){return el(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dl extends ll{constructor(y){super(),tl(this,y,il,ol,Oe,{})}}export{dl as component};
