import{s as _s,f as xt,n as Ys,o as Ds}from"../chunks/scheduler.37c15a92.js";import{S as Ps,i as Os,g as M,s as n,r as u,A as Ks,h as i,f as t,c as a,j as qt,u as r,x as o,k as c,y as en,a as s,v as J,d as U,t as p,w as T}from"../chunks/index.2bf4358c.js";import{C as y}from"../chunks/CodeBlock.4e987730.js";import{C as ln}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as w}from"../chunks/Heading.8ada512a.js";import{E as tn}from"../chunks/getInferenceSnippets.0aa3753f.js";function sn(Ft){let m,el,Oe,ll,b,tl,v,sl,V,St="Les agents à code sont le type d’agent par défaut dans <code>smolagents</code>. Ils génèrent des appels d’outils Python pour effectuer des actions, obtenant des représentations d’actions qui sont efficaces, expressives et précises.",nl,h,Ht="Leur approche simplifiée réduit le nombre d’actions requises, simplifie les opérations complexes et permet la réutilisation de fonctions de code existantes. <code>smolagents</code> fournit un <em>framework</em> léger pour construire de tels agents en environ 1 000 lignes de code.",al,B,Et=`<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/code_vs_json_actions.png" alt="Code vs JSON Actions"/>
Graphique issu du papier <a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Executable Code Actions Elicit Better LLM Agents</a>`,Ml,j,Xt='<p>Si vous voulez en savoir plus sur pourquoi les agents à code sont efficaces, consultez <a href="https://huggingface.co/docs/smolagents/en/conceptual_guides/intro_agents#code-agents" target="_blank">ce guide</a> de la documentation smolagents.</p>',il,Z,ol,A,$t="Dans un processus d’agent multi-étapes, le LLM écrit et exécute des actions, impliquant généralement des appels d’outils externes. Les approches traditionnelles utilisent un format JSON pour spécifier les noms d’outils et les arguments sous forme de chaînes, <strong>que le système doit analyser pour déterminer quel outil exécuter</strong>.",ul,k,Lt='Cependant, la recherche montre que <strong>les LLM d’appel d’outils fonctionnent plus efficacement avec du code directement</strong>. C’est un principe fondamental de <code>smolagents</code>, comme le montre le diagramme ci-dessus issu de <a href="https://huggingface.co/papers/2402.01030" rel="nofollow"><em>Executable Code Actions Elicit Better LLM Agents</em></a>.',rl,G,Rt="Écrire des actions en code plutôt qu’en JSON offre plusieurs avantages clés :",Jl,Q,_t="<li><strong>Composabilité</strong> : Combiner et réutiliser facilement des actions</li> <li><strong>Gestion d’objets</strong> : Travailler directement avec des structures complexes comme des images</li> <li><strong>Généralité</strong> : Exprimer toute tâche computationnellement possible</li> <li><strong>Naturel pour les LLM</strong> : Du code de haute qualité est déjà présent dans les données d’entraînement des LLM</li>",Ul,N,pl,W,Yt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/codeagent_docs.png" alt="From https://huggingface.co/docs/smolagents/conceptual_guides/react"/>',Tl,z,Dt="Le diagramme ci-dessus illustre comment <code>CodeAgent.run()</code> fonctionne, suivant le <em>framework</em> ReAct que nous avons mentionné dans l’Unité 1. L’abstraction principale pour les agents dans <code>smolagents</code> est un <code>MultiStepAgent</code> qui sert de bloc de construction principal. Comme nous le verrons dans un exemple ci-dessous, <code>CodeAgent</code> est un type spécial de <code>MultiStepAgent</code>.",cl,x,Pt="Un <code>CodeAgent</code> effectue des actions à travers un cycle d’étapes (avec les variables existantes et les connaissances étant incorporées dans le contexte de l’agent) qui est conservé dans un journal d’exécution :",yl,q,Ot='<li><p>Le <em>prompt</em> système est stocké dans un <code>SystemPromptStep</code> et la requête utilisateur est enregistrée dans un <code>TaskStep</code>.</p></li> <li><p>Ensuite, la boucle <em>while</em> suivante est exécutée :</p> <p>2.1 La méthode <code>agent.write_memory_to_messages()</code> écrit les <em>logs</em> de l’agent dans une liste de <a href="https://huggingface.co/docs/transformers/main/en/chat_templating" rel="nofollow">messages de chat</a> lisibles par le LLM.</p> <p>2.2 Ces messages sont envoyés à un <code>Model</code> qui génère une complétion.</p> <p>2.3 La complétion est analysée pour extraire l’action, qui, dans notre cas, devrait être un extrait de code puisque nous travaillons avec un <code>CodeAgent</code>.</p> <p>2.4 L’action est exécutée.</p> <p>2.5 Les résultats sont enregistrés en mémoire dans un <code>ActionStep</code>.</p></li>',dl,F,Kt="À la fin de chaque étape, si l’agent inclut des appels de fonction (dans <code>agent.step_callback</code>), ils sont exécutés.",wl,S,ml,I,es='<p>Vous pouvez suivre le code dans <a href="https://huggingface.co/agents-course/notebooks/blob/main/fr/unit2/smolagents/code_agents.ipynb" target="_blank">ce <i>notebook</i></a> que vous pouvez exécuter avec Google Colab.</p>',jl,H,ls="Alfred planifie une fête au manoir de la famille Wayne et a besoin de votre aide pour s’assurer que tout se passe bien. Pour l’aider, nous appliquerons ce que nous avons appris sur le fonctionnement d’un <code>CodeAgent</code> multi-étapes.",Il,E,ts,gl,X,ss="Si vous n’avez pas encore installé <code>smolagents</code>, vous pouvez le faire en exécutant la commande suivante :",Cl,$,fl,L,ns="Connectons-nous également au Hub d’Hugging Face pour avoir accès à l’API d’inférence <em>Serverless</em>.",bl,R,vl,_,Vl,Y,as="La musique est un élément essentiel d’une fête réussie ! Alfred a besoin d’aide pour sélectionner la <em>playlist</em>. Heureusement, <code>smolagents</code> nous couvre ! Nous pouvons construire un agent capable de rechercher sur le web en utilisant DuckDuckGo. Pour donner à l’accès à cet outil  l’agent, nous l’incluons dans la liste des outils lors de la création de l’agent.",hl,D,Ms,Bl,P,is='Pour le modèle, nous nous appuierons sur <code>InferenceClientModel</code>, qui fournit l’accès à l’<a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">API d’inférence Serverless</a> d’Hugging Face. Le modèle par défaut est <code>&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</code>, qui est performant et disponible pour une inférence rapide, mais vous pouvez sélectionner depuis le Hub n’importe quel modèle compatible.',Zl,O,os="Exécuter un agent est assez simple :",Al,K,kl,ee,us="Lorsque vous exécutez cet exemple, la sortie <strong>affichera une trace des étapes du <em>workflow</em> en cours d’exécution</strong>. Elle affichera également le code Python correspondant avec le message :",Gl,le,Ql,te,rs="Après quelques étapes, vous verrez la <em>playlist</em> générée qu’Alfred peut utiliser pour la fête ! 🎵",Nl,se,Wl,ne,Js,zl,ae,Us="Maintenant que nous avons sélectionné une <em>playlist</em>, nous devons organiser le menu pour les invités. Encore une fois, Alfred peut tirer parti de <code>smolagents</code> pour le faire. Ici, nous utilisons le décorateur <code>@tool</code> pour définir une fonction personnalisée qui agit comme un outil. Nous couvrirons la création d’outils plus en détail plus tard, donc pour l’instant, nous pouvons simplement exécuter le code.",xl,Me,ps="Comme vous pouvez le voir dans l’exemple ci-dessous, nous allons créer un outil en utilisant le décorateur <code>@tool</code> et l’inclure dans la liste <code>tools</code>.",ql,ie,Fl,oe,Ts="L’agent s’exécutera pendant quelques étapes jusqu’à trouver la réponse. Préciser les valeurs autorisées dans la docstring aide à diriger l’agent vers les valeurs d’argument <code>occasion</code> qui existent et limite les hallucinations.",Sl,ue,cs="Le menu est prêt ! 🥗",Hl,re,El,Je,ys="Nous avons la <em>playlist</em> et le menu prêts, mais nous devons vérifier un dernier détail crucial : le temps de préparation !",Xl,Ue,ds="Alfred doit calculer quand tout serait prêt s’il commençait à préparer maintenant, au cas où ils auraient besoin de l’aide d’autres super-héros.",$l,pe,ws="<code>smolagents</code> est spécialisé dans les agents qui écrivent et exécutent des extraits de code Python, offrant une exécution sécurisée.",Ll,Te,ms=`En effet, <strong>l’exécution du code a des mesures de sécurité strictes</strong> : les imports en dehors d’une liste sûre prédéfinie sont bloqués par défaut. Cependant, vous pouvez autoriser des imports supplémentaires en les passant sous forme de chaînes dans <code>additional_authorized_imports</code>.
Pour plus de détails sur l’exécution sécurisée du code, consultez le <a href="https://huggingface.co/docs/smolagents/tutorials/secure_code_execution" rel="nofollow">guide</a> officiel.`,Rl,ce,js="Lors de la création de l’agent, nous utiliserons <code>additional_authorized_imports</code> pour permettre l’importation du module <code>datetime</code>.",_l,ye,Yl,de,Is=`Ces exemples ne sont que le début de ce que vous pouvez faire avec les agents à code, et nous commençons déjà à voir leur utilité pour préparer la fête.
Vous pouvez en apprendre davantage sur la façon de construire de tels agents dans la <a href="https://huggingface.co/docs/smolagents" rel="nofollow">documentation de <code>smolagents</code></a>.`,Dl,we,gs="En résumé, <code>smolagents</code> se spécialise dans les agents qui écrivent et exécutent des extraits de code Python, offrant une exécution sécurisée. Il supporte à la fois les modèles de langage locaux et basés sur API, le rendant adaptable à divers environnements de développement.",Pl,me,Ol,je,Cs="Ne serait-il pas <strong>incroyable de partager notre propre agent Alfred avec le reste du monde</strong> ? En faisant cela, n’importe qui peut facilement télécharger et utiliser l’agent directement depuis le Hub, apportant l’ultime planificateur de fête de Gotham à portée de main ! Faisons-le ! 🎉",Kl,Ie,fs="La bibliothèque <code>smolagents</code> rend cela possible en vous permettant de partager un agent complet avec la communauté et de télécharger ceux des autres pour une utilisation immédiate. C’est aussi simple que ce qui suit :",et,ge,lt,Ce,bs="Pour télécharger à nouveau l’agent, utilisez le code ci-dessous :",tt,fe,st,be,vs='Ce qui est également excitant, c’est que les agents partagés sont directement disponibles en tant que <em>Spaces</em>, vous permettant d’interagir avec eux en temps réel. Vous pouvez explorer d’autres agents <a href="https://huggingface.co/spaces/davidberenstein1957/smolagents-and-tools" rel="nofollow">ici</a>.',nt,ve,Vs='Par exemple, l’<em>AlfredAgent</em> est disponible <a href="https://huggingface.co/spaces/sergiopaniego/AlfredAgent" rel="nofollow">ici</a>. Vous pouvez l’essayer directement ci-dessous :',at,d,hs,Mt,Ve,Bs="Vous vous demandez peut-être comment Alfred a construit un tel agent en utilisant <code>smolagents</code> ? En intégrant plusieurs outils, il peut générer un agent comme suit. Ne vous inquiétez pas des outils pour l’instant, car nous aurons une section dédiée plus tard dans cette unité pour explorer cela en détail :",it,he,ot,Be,Zs="Comme vous pouvez le voir, nous avons créé un <code>CodeAgent</code> avec plusieurs outils qui améliorent la fonctionnalité de l’agent, le transformant en l’ultime planificateur de fête prêt à partager avec la communauté ! 🎉",ut,Ze,As="Maintenant, c’est à votre tour : construisez votre propre agent et partagez-le avec la communauté en utilisant les connaissances que nous venons d’apprendre ! 🕵️‍♂️💡",rt,g,ks='<p>Si vous souhaitez partager votre projet d’agent, créez un <i>Space</i> et taguez <a href="https://huggingface.co/agents-course">agents-course</a> sur le Hub. Nous serions ravis de voir ce que vous avez créé !</p>',Jt,Ae,Ut,ke,Gs="Alors qu’Alfred peaufine l’agent, il se lasse de déboguer ses exécutions. Les agents, par nature, sont imprévisibles et difficiles à inspecter. Mais comme il vise à construire l’ultime agent préparateur de fête et à le déployer en production, il a besoin d’une traçabilité robuste pour la surveillance et l’analyse futures.",pt,Ge,Qs='Encore une fois, <code>smolagents</code> vient à la rescousse ! Il adopte la norme <a href="https://opentelemetry.io/" rel="nofollow">OpenTelemetry</a> pour instrumenter les exécutions d’agents, permettant une inspection et une journalisation transparentes. Avec l’aide de <a href="https://langfuse.com/" rel="nofollow">Langfuse</a> et du <code>SmolagentsInstrumentor</code>, Alfred peut facilement suivre et analyser le comportement de son agent.',Tt,Qe,Ns="La configuration est simple !",ct,Ne,Ws="D’abord, nous devons installer les dépendances nécessaires :",yt,We,dt,ze,zs='Ensuite, Alfred a déjà créé un compte sur Langfuse et a ses clés API prêtes. Si vous ne l’avez pas encore fait, vous pouvez vous inscrire à Langfuse Cloud <a href="https://cloud.langfuse.com/" rel="nofollow">ici</a> ou explorer des <a href="https://huggingface.co/docs/smolagents/tutorials/inspect_runs" rel="nofollow">alternatives</a>.',wt,xe,xs="Une fois que vous avez vos clés API, elles doivent être correctement configurées comme suit :",mt,qe,jt,Fe,qs="Avec les variables d’environnement définies, nous pouvons maintenant initialiser le client Langfuse. <code>get_client()</code> initialise le client Langfuse en utilisant les identifiants fournis dans les variables d’environnement.",It,Se,gt,He,Fs="Enfin, Alfred est prêt à initialiser le <code>SmolagentsInstrumentor</code> et commencer à suivre les performances de son agent.",Ct,Ee,ft,Xe,Ss="Alfred est maintenant connecté 🔌 ! Les exécutions de <code>smolagents</code> sont enregistrées dans Langfuse, lui donnant une visibilité complète sur le comportement de l’agent. Avec cette configuration, il est prêt à revisiter les exécutions précédentes et à affiner encore plus son agent préparateur de fête.",bt,C,Hs='<p>Pour en savoir plus sur le traçage de vos agents et l’utilisation des données collectées pour évaluer leurs performances, consultez <a href="https://huggingface.co/learn/agents-course/fr/bonus-unit2/introduction">l’Unité Bonus 2</a>.</p>',vt,$e,Vt,Le,Es='Alfred peut maintenant accéder aux logs <a href="https://cloud.langfuse.com/project/cm7bq0abj025rad078ak3luwi/traces/995fc019255528e4f48cf6770b0ce27b?timestamp=2025-02-19T10%3A28%3A36.929Z" rel="nofollow">ici</a> pour les relire et les analyser.',ht,f,Xs='<p>En fait, une erreur mineure s’est produite lors de l’exécution. Pouvez-vous la repérer dans les logs ? Essayez de suivre comment l’agent la gère et renvoie quand même une réponse valide. <a href="https://cloud.langfuse.com/project/cm7bq0abj025rad078ak3luwi/traces/995fc019255528e4f48cf6770b0ce27b?timestamp=2025-02-19T10%3A28%3A36.929Z&amp;observation=80ca57ace4f69b52">Voici</a> le lien direct vers l’erreur si vous voulez vérifier votre réponse. Bien sûr, l’erreur a été corrigée entre-temps, plus de détails peuvent être trouvés dans cette <a href="https://github.com/huggingface/smolagents/issues/838"><i>issue</i></a>.</p>',Bt,Re,$s='Pendant ce temps, la <a href="https://open.spotify.com/playlist/0gZMMHjuxMrrybQ7wTMTpw" rel="nofollow"><em>playlist</em> suggérée</a> crée l’ambiance parfaite pour les préparatifs de la fête. Cool, non ? 🎶',Zt,At,kt,_e,Ls="Maintenant que nous avons créé notre premier <em>Code Agent</em>, <strong>apprenons comment nous pouvons créer des <em>Tool Calling Agents</em></strong>, le deuxième type d’agent disponible dans <code>smolagents</code>.",Gt,Ye,Qt,De,Rs='<li><a href="https://huggingface.co/blog/smolagents" rel="nofollow">Blog smolagents</a> - Introduction à smolagents et aux interactions de code</li> <li><a href="https://huggingface.co/docs/smolagents/tutorials/building_good_agents" rel="nofollow">smolagents : Construire de bons agents</a> - Meilleures pratiques pour des agents fiables</li> <li><a href="https://www.anthropic.com/research/building-effective-agents" rel="nofollow">Construire des agents efficaces - Anthropic</a> - Principes de conception d’agents</li> <li><a href="https://huggingface.co/docs/smolagents/tutorials/inspect_runs" rel="nofollow">Partager des exécutions avec OpenTelemetry</a> - Détails sur la façon de configurer OpenTelemetry pour suivre vos agents.</li>',Nt,Pe,Wt,Ke,zt;return b=new ln({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/fr/unit2/smolagents/code_agents.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),v=new w({props:{title:"Construire des agents qui utilisent du code",local:"construire-des-agents-qui-utilisent-du-code",headingTag:"h1"}}),Z=new w({props:{title:"Pourquoi les agents à code ?",local:"pourquoi-les-agents-à-code-",headingTag:"h2"}}),N=new w({props:{title:"Comment fonctionne un agent à code ?",local:"comment-fonctionne-un-agent-à-code-",headingTag:"h2"}}),S=new w({props:{title:"Voyons quelques exemples",local:"voyons-quelques-exemples",headingTag:"h2"}}),$=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNtb2xhZ2VudHMlMjAtVQ==",highlighted:"pip install smolagents -U",wrap:!1}}),R=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBJTBBbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login

login()`,wrap:!1}}),_=new w({props:{title:"Sélectionner une playlist pour la fête en utilisant smolagents",local:"sélectionner-une-playlist-pour-la-fête-en-utilisant-smolagents",headingTag:"h3"}}),K=new y({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJEdWNrRHVja0dvU2VhcmNoVG9vbCgpJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQSUwQWFnZW50LnJ1biglMjJSZWNoZXJjaGUlMjBsZXMlMjBtZWlsbGV1cmVzJTIwcmVjb21tYW5kYXRpb25zJTIwbXVzaWNhbGVzJTIwcG91ciUyMHVuZSUyMGYlQzMlQUF0ZSUyMGF1JTIwbWFub2lyJTIwZGVzJTIwV2F5bmUuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, InferenceClientModel

agent = CodeAgent(tools=[DuckDuckGoSearchTool()], model=InferenceClientModel())

agent.run(<span class="hljs-string">&quot;Recherche les meilleures recommandations musicales pour une fête au manoir des Wayne.&quot;</span>)`,wrap:!1}}),le=new y({props:{code:"JTIwJUUyJTk0JTgwJTIwRXhlY3V0aW5nJTIwcGFyc2VkJTIwY29kZSUzQSUyMCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCUyMCUwQSUyMCUyMHJlc3VsdHMlMjAlM0QlMjB3ZWJfc2VhcmNoKHF1ZXJ5JTNEJTIyYmVzdCUyMG11c2ljJTIwZm9yJTIwYSUyMEJhdG1hbiUyMHBhcnR5JTIyKSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMHByaW50KHJlc3VsdHMpJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTIwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJTIw",highlighted:` ─ Executing parsed code: ──────────────────────────────────────────────────────────────────────────────────────── 
  results = web_search(query=<span class="hljs-string">&quot;best music for a Batman party&quot;</span>)                                                      
  <span class="hljs-built_in">print</span>(results)                                                                                                   
 ───────────────────────────────────────────────────────────────────────────────────────────────────────────────── `,wrap:!1}}),se=new w({props:{title:"Utiliser un outil personnalisé pour préparer le menu",local:"utiliser-un-outil-personnalisé-pour-préparer-le-menu",headingTag:"h3"}}),ie=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, tool, InferenceClientModel

<span class="hljs-comment"># Outil pour suggérer un menu basé sur l&#x27;occasion</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">suggest_menu</span>(<span class="hljs-params">occasion: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Suggère un menu basé sur l&#x27;occasion.
    Args:
        occasion (str): Le type d&#x27;occasion pour la fête. Les valeurs autorisées sont :
                        - &quot;casual&quot;: Menu pour une fête décontractée.
                        - &quot;formal&quot;: Menu pour une fête formelle.
                        - &quot;superhero&quot;: Menu pour une fête de super-héros.
                        - &quot;custom&quot;: Menu personnalisé.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> occasion == <span class="hljs-string">&quot;casual&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Pizza, collations et boissons.&quot;</span>
    <span class="hljs-keyword">elif</span> occasion == <span class="hljs-string">&quot;formal&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Dîner 3 services avec vin et dessert.&quot;</span>
    <span class="hljs-keyword">elif</span> occasion == <span class="hljs-string">&quot;superhero&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Buffet avec nourriture énergétique et saine.&quot;</span>
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Menu personnalisé pour le majordome.&quot;</span>

<span class="hljs-comment"># Alfred, le majordome, préparant le menu pour la fête</span>
agent = CodeAgent(tools=[suggest_menu], model=InferenceClientModel())

<span class="hljs-comment"># Préparer le menu pour la fête</span>
agent.run(<span class="hljs-string">&quot;Prépare un menu formel pour la fête.&quot;</span>)`,wrap:!1}}),re=new w({props:{title:"Utiliser des imports Python à l’intérieur de l’agent",local:"utiliser-des-imports-python-à-lintérieur-de-lagent",headingTag:"h3"}}),ye=new y({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWltcG9ydCUyMHRpbWUlMEFpbXBvcnQlMjBkYXRldGltZSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTJDJTIwYWRkaXRpb25hbF9hdXRob3JpemVkX2ltcG9ydHMlM0QlNUInZGF0ZXRpbWUnJTVEKSUwQSUwQWFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBbGZyZWQlMjBkb2l0JTIwc2UlMjBwciVDMyVBOXBhcmVyJTIwcG91ciUyMGxhJTIwZiVDMyVBQXRlLiUyMFZvaWNpJTIwbGVzJTIwdCVDMyVBMmNoZXMlMjAlM0ElMEElMjAlMjAlMjAlMjAxLiUyMFByJUMzJUE5cGFyZXIlMjBsZXMlMjBib2lzc29ucyUyMC0lMjAzMCUyMG1pbnV0ZXMlMEElMjAlMjAlMjAlMjAyLiUyMEQlQzMlQTljb3JlciUyMGxlJTIwbWFub2lyJTIwLSUyMDYwJTIwbWludXRlcyUwQSUyMCUyMCUyMCUyMDMuJTIwTWV0dHJlJTIwZW4lMjBwbGFjZSUyMGxlJTIwbWVudSUyMC0lMjA0NSUyMG1pbnV0ZXMlMEElMjAlMjAlMjAlMjA0LiUyMFByJUMzJUE5cGFyZXIlMjBsYSUyMG11c2lxdWUlMjBldCUyMGxhJTIwcGxheWxpc3QlMjAtJTIwNDUlMjBtaW51dGVzJTBBJTBBJTIwJTIwJTIwJTIwU2klMjBub3VzJTIwY29tbWVuJUMzJUE3b25zJTIwbWFpbnRlbmFudCUyQyUyMCVDMyVBMCUyMHF1ZWxsZSUyMGhldXJlJTIwbGElMjBmJUMzJUFBdGUlMjBzZXJhLXQtZWxsZSUyMHByJUMzJUFBdGUlMjAlM0YlMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> datetime

agent = CodeAgent(tools=[], model=InferenceClientModel(), additional_authorized_imports=[<span class="hljs-string">&#x27;datetime&#x27;</span>])

agent.run(
    <span class="hljs-string">&quot;&quot;&quot;
    Alfred doit se préparer pour la fête. Voici les tâches :
    1. Préparer les boissons - 30 minutes
    2. Décorer le manoir - 60 minutes
    3. Mettre en place le menu - 45 minutes
    4. Préparer la musique et la playlist - 45 minutes

    Si nous commençons maintenant, à quelle heure la fête sera-t-elle prête ?
    &quot;&quot;&quot;</span>
)`,wrap:!1}}),me=new w({props:{title:"Partager notre agent préparateur de fête personnalisé sur le Hub",local:"partager-notre-agent-préparateur-de-fête-personnalisé-sur-le-hub",headingTag:"h3"}}),ge=new y({props:{code:"JTIzJTIwQ2hhbmdleiUyMHBvdXIlMjB2b3RyZSUyMG5vbSUyMGQndXRpbGlzYXRldXIlMjBldCUyMG5vbSUyMGRlJTIwZCVDMyVBOXAlQzMlQjR0JTBBYWdlbnQucHVzaF90b19odWIoJ3Nlcmdpb3BhbmllZ28lMkZBbGZyZWRBZ2VudCcp",highlighted:`<span class="hljs-comment"># Changez pour votre nom d&#x27;utilisateur et nom de dépôt</span>
agent.push_to_hub(<span class="hljs-string">&#x27;sergiopaniego/AlfredAgent&#x27;</span>)`,wrap:!1}}),fe=new y({props:{code:"JTIzJTIwQ2hhbmdleiUyMHBvdXIlMjB2b3RyZSUyMG5vbSUyMGQndXRpbGlzYXRldXIlMjBldCUyMG5vbSUyMGRlJTIwZCVDMyVBOXAlQzMlQjR0JTBBYWxmcmVkX2FnZW50JTIwJTNEJTIwYWdlbnQuZnJvbV9odWIoJ3Nlcmdpb3BhbmllZ28lMkZBbGZyZWRBZ2VudCclMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBJTBBYWxmcmVkX2FnZW50LnJ1biglMjJEb25uZS1tb2klMjBsYSUyMG1laWxsZXVyZSUyMHBsYXlsaXN0JTIwcG91ciUyMHVuZSUyMGYlQzMlQUF0ZSUyMGF1JTIwbWFub2lyJTIwZGVzJTIwV2F5bmUuJTIwTCdpZCVDMyVBOWUlMjBkZSUyMGxhJTIwZiVDMyVBQXRlJTIwZXN0JTIwdW4lMjB0aCVDMyVBOG1lJTIwJ21hc2NhcmFkZSUyMGRlJTIwbSVDMyVBOWNoYW50cyclMjIpJTIwJTIw",highlighted:`<span class="hljs-comment"># Changez pour votre nom d&#x27;utilisateur et nom de dépôt</span>
alfred_agent = agent.from_hub(<span class="hljs-string">&#x27;sergiopaniego/AlfredAgent&#x27;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

alfred_agent.run(<span class="hljs-string">&quot;Donne-moi la meilleure playlist pour une fête au manoir des Wayne. L&#x27;idée de la fête est un thème &#x27;mascarade de méchants&#x27;&quot;</span>)  `,wrap:!1}}),he=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, FinalAnswerTool, InferenceClientModel, Tool, tool, VisitWebpageTool

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">suggest_menu</span>(<span class="hljs-params">occasion: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Suggère un menu basé sur l&#x27;occasion.
    Args:
        occasion: Le type d&#x27;occasion pour la fête.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> occasion == <span class="hljs-string">&quot;casual&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Pizza, collations et boissons.&quot;</span>
    <span class="hljs-keyword">elif</span> occasion == <span class="hljs-string">&quot;formal&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Dîner 3 services avec vin et dessert.&quot;</span>
    <span class="hljs-keyword">elif</span> occasion == <span class="hljs-string">&quot;superhero&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Buffet avec nourriture énergétique et saine.&quot;</span>
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Menu personnalisé pour le majordome.&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">catering_service_tool</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Cet outil renvoie le service de restauration le mieux noté à Gotham City.
    
    Args:
        query: Un terme de recherche pour trouver des services de restauration.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Exemple de liste de services de restauration et leurs notes</span>
    services = {
        <span class="hljs-string">&quot;Gotham Catering Co.&quot;</span>: <span class="hljs-number">4.9</span>,
        <span class="hljs-string">&quot;Wayne Manor Catering&quot;</span>: <span class="hljs-number">4.8</span>,
        <span class="hljs-string">&quot;Gotham City Events&quot;</span>: <span class="hljs-number">4.7</span>,
    }
    
    <span class="hljs-comment"># Trouver le service de restauration le mieux noté (simuler le filtrage de requête de recherche)</span>
    best_service = <span class="hljs-built_in">max</span>(services, key=services.get)
    
    <span class="hljs-keyword">return</span> best_service

<span class="hljs-keyword">class</span> <span class="hljs-title class_">SuperheroPartyThemeTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;superhero_party_theme_generator&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    Cet outil suggère des idées créatives de fête sur le thème des super-héros basées sur une catégorie.
    Il renvoie une idée de thème de fête unique.&quot;&quot;&quot;</span>
    
    inputs = {
        <span class="hljs-string">&quot;category&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Le type de fête de super-héros (par ex., &#x27;héros classiques&#x27;, &#x27;mascarade de méchants&#x27;, &#x27;Gotham futuriste&#x27;).&quot;</span>,
        }
    }
    
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, category: <span class="hljs-built_in">str</span></span>):
        themes = {
            <span class="hljs-string">&quot;classic heroes&quot;</span>: <span class="hljs-string">&quot;Gala de la Justice League : Les invités viennent habillés comme leurs héros DC préférés avec des cocktails thématiques comme &#x27;Le Punch Kryptonite&#x27;.&quot;</span>,
            <span class="hljs-string">&quot;villain masquerade&quot;</span>: <span class="hljs-string">&quot;Bal des Voyous de Gotham : Une mascarade mystérieuse où les invités s&#x27;habillent en méchants classiques de Batman.&quot;</span>,
            <span class="hljs-string">&quot;futuristic Gotham&quot;</span>: <span class="hljs-string">&quot;Nuit Neo-Gotham : Une fête de style cyberpunk inspirée de Batman Beyond, avec des décorations néon et des gadgets futuristes.&quot;</span>
        }
        
        <span class="hljs-keyword">return</span> themes.get(category.lower(), <span class="hljs-string">&quot;Idée de fête thématique non trouvée. Essayez &#x27;héros classiques&#x27;, &#x27;mascarade de méchants&#x27;, ou &#x27;Gotham futuriste&#x27;.&quot;</span>)


<span class="hljs-comment"># Alfred, le majordome, préparant le menu pour la fête</span>
agent = CodeAgent(
    tools=[
        DuckDuckGoSearchTool(), 
        VisitWebpageTool(),
        suggest_menu,
        catering_service_tool,
        SuperheroPartyThemeTool(),
	FinalAnswerTool()
    ], 
    model=InferenceClientModel(),
    max_steps=<span class="hljs-number">10</span>,
    verbosity_level=<span class="hljs-number">2</span>
)

agent.run(<span class="hljs-string">&quot;Donne-moi la meilleure playlist pour une fête au manoir des Wayne. L&#x27;idée de la fête est un thème &#x27;mascarade de méchants&#x27;&quot;</span>)`,wrap:!1}}),Ae=new w({props:{title:"Inspecter notre agent préparateur de fête avec OpenTelemetry et Langfuse 📡",local:"inspecter-notre-agent-préparateur-de-fête-avec-opentelemetry-et-langfuse-",headingTag:"h3"}}),We=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9wZW50ZWxlbWV0cnktc2RrJTIwb3BlbnRlbGVtZXRyeS1leHBvcnRlci1vdGxwJTIwb3BlbmluZmVyZW5jZS1pbnN0cnVtZW50YXRpb24tc21vbGFnZW50cyUyMGxhbmdmdXNl",highlighted:"pip install opentelemetry-sdk opentelemetry-exporter-otlp openinference-instrumentation-smolagents langfuse",wrap:!1}}),qe=new y({props:{code:"aW1wb3J0JTIwb3MlMEElMEElMjMlMjBPYnRlbmV6JTIwbGVzJTIwY2wlQzMlQTlzJTIwcG91ciUyMHZvdHJlJTIwcHJvamV0JTIwZGVwdWlzJTIwbGElMjBwYWdlJTIwZGVzJTIwcGFyYW0lQzMlQTh0cmVzJTIwZHUlMjBwcm9qZXQlMjAlM0ElMjBodHRwcyUzQSUyRiUyRmNsb3VkLmxhbmdmdXNlLmNvbSUwQW9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9QVUJMSUNfS0VZJTIyJTVEJTIwJTNEJTIwJTIycGstbGYtLi4uJTIyJTIwJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX1NFQ1JFVF9LRVklMjIlNUQlMjAlM0QlMjAlMjJzay1sZi0uLi4lMjIlMjAlMEFvcy5lbnZpcm9uJTVCJTIyTEFOR0ZVU0VfSE9TVCUyMiU1RCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGY2xvdWQubGFuZ2Z1c2UuY29tJTIyJTIwJTIzJTIwJUYwJTlGJTg3JUFBJUYwJTlGJTg3JUJBJTIwUiVDMyVBOWdpb24lMjBVRSUwQSUyMyUyMG9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cy5jbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQkElRjAlOUYlODclQjglMjBSJUMzJUE5Z2lvbiUyMFVT",highlighted:`<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Obtenez les clés pour votre projet depuis la page des paramètres du projet : https://cloud.langfuse.com</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_PUBLIC_KEY&quot;</span>] = <span class="hljs-string">&quot;pk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_SECRET_KEY&quot;</span>] = <span class="hljs-string">&quot;sk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com&quot;</span> <span class="hljs-comment"># 🇪🇺 Région UE</span>
<span class="hljs-comment"># os.environ[&quot;LANGFUSE_HOST&quot;] = &quot;https://us.cloud.langfuse.com&quot; # 🇺🇸 Région US</span>`,wrap:!1}}),Se=new y({props:{code:"ZnJvbSUyMGxhbmdmdXNlJTIwaW1wb3J0JTIwZ2V0X2NsaWVudCUwQSUyMCUwQWxhbmdmdXNlJTIwJTNEJTIwZ2V0X2NsaWVudCgpJTBBJTIwJTBBJTIzJTIwViVDMyVBOXJpZmllciUyMGxhJTIwY29ubmV4aW9uJTBBaWYlMjBsYW5nZnVzZS5hdXRoX2NoZWNrKCklM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJMZSUyMGNsaWVudCUyMExhbmdmdXNlJTIwZXN0JTIwYXV0aGVudGlmaSVDMyVBOSUyMGV0JTIwcHIlQzMlQUF0JTIwISUyMiklMEFlbHNlJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyTCdhdXRoZW50aWZpY2F0aW9uJTIwYSUyMCVDMyVBOWNob3UlQzMlQTkuJTIwVmV1aWxsZXolMjB2JUMzJUE5cmlmaWVyJTIwdm9zJTIwaWRlbnRpZmlhbnRzJTIwZXQlMjBsJ2glQzMlQjR0ZS4lMjIp",highlighted:`<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client
 
langfuse = get_client()
 
<span class="hljs-comment"># Vérifier la connexion</span>
<span class="hljs-keyword">if</span> langfuse.auth_check():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Le client Langfuse est authentifié et prêt !&quot;</span>)
<span class="hljs-keyword">else</span>:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;L&#x27;authentification a échoué. Veuillez vérifier vos identifiants et l&#x27;hôte.&quot;</span>)`,wrap:!1}}),Ee=new y({props:{code:"ZnJvbSUyMG9wZW5pbmZlcmVuY2UuaW5zdHJ1bWVudGF0aW9uLnNtb2xhZ2VudHMlMjBpbXBvcnQlMjBTbW9sYWdlbnRzSW5zdHJ1bWVudG9yJTBBJTBBU21vbGFnZW50c0luc3RydW1lbnRvcigpLmluc3RydW1lbnQoKQ==",highlighted:`<span class="hljs-keyword">from</span> openinference.instrumentation.smolagents <span class="hljs-keyword">import</span> SmolagentsInstrumentor

SmolagentsInstrumentor().instrument()`,wrap:!1}}),$e=new y({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQWFsZnJlZF9hZ2VudCUyMCUzRCUyMGFnZW50LmZyb21faHViKCdzZXJnaW9wYW5pZWdvJTJGQWxmcmVkQWdlbnQnJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQWFsZnJlZF9hZ2VudC5ydW4oJTIyRG9ubmUtbW9pJTIwbGElMjBtZWlsbGV1cmUlMjBwbGF5bGlzdCUyMHBvdXIlMjB1bmUlMjBmJUMzJUFBdGUlMjBhdSUyMG1hbm9pciUyMGRlcyUyMFdheW5lLiUyMEwnaWQlQzMlQTllJTIwZGUlMjBsYSUyMGYlQzMlQUF0ZSUyMGVzdCUyMHVuJTIwdGglQzMlQThtZSUyMCdtYXNjYXJhZGUlMjBkZSUyMG0lQzMlQTljaGFudHMnJTIyKSUyMCUyMA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

agent = CodeAgent(tools=[], model=InferenceClientModel())
alfred_agent = agent.from_hub(<span class="hljs-string">&#x27;sergiopaniego/AlfredAgent&#x27;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
alfred_agent.run(<span class="hljs-string">&quot;Donne-moi la meilleure playlist pour une fête au manoir des Wayne. L&#x27;idée de la fête est un thème &#x27;mascarade de méchants&#x27;&quot;</span>)  `,wrap:!1}}),Ye=new w({props:{title:"Ressources",local:"ressources",headingTag:"h2"}}),Pe=new tn({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit2/smolagents/code_agents.mdx"}}),{c(){m=M("meta"),el=n(),Oe=M("p"),ll=n(),u(b.$$.fragment),tl=n(),u(v.$$.fragment),sl=n(),V=M("p"),V.innerHTML=St,nl=n(),h=M("p"),h.innerHTML=Ht,al=n(),B=M("p"),B.innerHTML=Et,Ml=n(),j=M("blockquote"),j.innerHTML=Xt,il=n(),u(Z.$$.fragment),ol=n(),A=M("p"),A.innerHTML=$t,ul=n(),k=M("p"),k.innerHTML=Lt,rl=n(),G=M("p"),G.textContent=Rt,Jl=n(),Q=M("ul"),Q.innerHTML=_t,Ul=n(),u(N.$$.fragment),pl=n(),W=M("p"),W.innerHTML=Yt,Tl=n(),z=M("p"),z.innerHTML=Dt,cl=n(),x=M("p"),x.innerHTML=Pt,yl=n(),q=M("ol"),q.innerHTML=Ot,dl=n(),F=M("p"),F.innerHTML=Kt,wl=n(),u(S.$$.fragment),ml=n(),I=M("blockquote"),I.innerHTML=es,jl=n(),H=M("p"),H.innerHTML=ls,Il=n(),E=M("img"),gl=n(),X=M("p"),X.innerHTML=ss,Cl=n(),u($.$$.fragment),fl=n(),L=M("p"),L.innerHTML=ns,bl=n(),u(R.$$.fragment),vl=n(),u(_.$$.fragment),Vl=n(),Y=M("p"),Y.innerHTML=as,hl=n(),D=M("img"),Bl=n(),P=M("p"),P.innerHTML=is,Zl=n(),O=M("p"),O.textContent=os,Al=n(),u(K.$$.fragment),kl=n(),ee=M("p"),ee.innerHTML=us,Gl=n(),u(le.$$.fragment),Ql=n(),te=M("p"),te.innerHTML=rs,Nl=n(),u(se.$$.fragment),Wl=n(),ne=M("img"),zl=n(),ae=M("p"),ae.innerHTML=Us,xl=n(),Me=M("p"),Me.innerHTML=ps,ql=n(),u(ie.$$.fragment),Fl=n(),oe=M("p"),oe.innerHTML=Ts,Sl=n(),ue=M("p"),ue.textContent=cs,Hl=n(),u(re.$$.fragment),El=n(),Je=M("p"),Je.innerHTML=ys,Xl=n(),Ue=M("p"),Ue.textContent=ds,$l=n(),pe=M("p"),pe.innerHTML=ws,Ll=n(),Te=M("p"),Te.innerHTML=ms,Rl=n(),ce=M("p"),ce.innerHTML=js,_l=n(),u(ye.$$.fragment),Yl=n(),de=M("p"),de.innerHTML=Is,Dl=n(),we=M("p"),we.innerHTML=gs,Pl=n(),u(me.$$.fragment),Ol=n(),je=M("p"),je.innerHTML=Cs,Kl=n(),Ie=M("p"),Ie.innerHTML=fs,et=n(),u(ge.$$.fragment),lt=n(),Ce=M("p"),Ce.textContent=bs,tt=n(),u(fe.$$.fragment),st=n(),be=M("p"),be.innerHTML=vs,nt=n(),ve=M("p"),ve.innerHTML=Vs,at=n(),d=M("iframe"),Mt=n(),Ve=M("p"),Ve.innerHTML=Bs,it=n(),u(he.$$.fragment),ot=n(),Be=M("p"),Be.innerHTML=Zs,ut=n(),Ze=M("p"),Ze.textContent=As,rt=n(),g=M("blockquote"),g.innerHTML=ks,Jt=n(),u(Ae.$$.fragment),Ut=n(),ke=M("p"),ke.textContent=Gs,pt=n(),Ge=M("p"),Ge.innerHTML=Qs,Tt=n(),Qe=M("p"),Qe.textContent=Ns,ct=n(),Ne=M("p"),Ne.textContent=Ws,yt=n(),u(We.$$.fragment),dt=n(),ze=M("p"),ze.innerHTML=zs,wt=n(),xe=M("p"),xe.textContent=xs,mt=n(),u(qe.$$.fragment),jt=n(),Fe=M("p"),Fe.innerHTML=qs,It=n(),u(Se.$$.fragment),gt=n(),He=M("p"),He.innerHTML=Fs,Ct=n(),u(Ee.$$.fragment),ft=n(),Xe=M("p"),Xe.innerHTML=Ss,bt=n(),C=M("blockquote"),C.innerHTML=Hs,vt=n(),u($e.$$.fragment),Vt=n(),Le=M("p"),Le.innerHTML=Es,ht=n(),f=M("blockquote"),f.innerHTML=Xs,Bt=n(),Re=M("p"),Re.innerHTML=$s,Zt=n(),At=M("hr"),kt=n(),_e=M("p"),_e.innerHTML=Ls,Gt=n(),u(Ye.$$.fragment),Qt=n(),De=M("ul"),De.innerHTML=Rs,Nt=n(),u(Pe.$$.fragment),Wt=n(),Ke=M("p"),this.h()},l(e){const l=Ks("svelte-u9bgzb",document.head);m=i(l,"META",{name:!0,content:!0}),l.forEach(t),el=a(e),Oe=i(e,"P",{}),qt(Oe).forEach(t),ll=a(e),r(b.$$.fragment,e),tl=a(e),r(v.$$.fragment,e),sl=a(e),V=i(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-w14gwc"&&(V.innerHTML=St),nl=a(e),h=i(e,"P",{"data-svelte-h":!0}),o(h)!=="svelte-1w7tdn8"&&(h.innerHTML=Ht),al=a(e),B=i(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-104mgp5"&&(B.innerHTML=Et),Ml=a(e),j=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(j)!=="svelte-ojur7l"&&(j.innerHTML=Xt),il=a(e),r(Z.$$.fragment,e),ol=a(e),A=i(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-tfi5uw"&&(A.innerHTML=$t),ul=a(e),k=i(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1j1nox0"&&(k.innerHTML=Lt),rl=a(e),G=i(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-pyefm3"&&(G.textContent=Rt),Jl=a(e),Q=i(e,"UL",{"data-svelte-h":!0}),o(Q)!=="svelte-ljzzvy"&&(Q.innerHTML=_t),Ul=a(e),r(N.$$.fragment,e),pl=a(e),W=i(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-2i0rf5"&&(W.innerHTML=Yt),Tl=a(e),z=i(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-31rm5i"&&(z.innerHTML=Dt),cl=a(e),x=i(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-e2xwrt"&&(x.innerHTML=Pt),yl=a(e),q=i(e,"OL",{"data-svelte-h":!0}),o(q)!=="svelte-8653na"&&(q.innerHTML=Ot),dl=a(e),F=i(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-ke17x7"&&(F.innerHTML=Kt),wl=a(e),r(S.$$.fragment,e),ml=a(e),I=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(I)!=="svelte-v9dbhk"&&(I.innerHTML=es),jl=a(e),H=i(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-hlzj5i"&&(H.innerHTML=ls),Il=a(e),E=i(e,"IMG",{src:!0,alt:!0}),gl=a(e),X=i(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-in86n6"&&(X.innerHTML=ss),Cl=a(e),r($.$$.fragment,e),fl=a(e),L=i(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-i1q2eb"&&(L.innerHTML=ns),bl=a(e),r(R.$$.fragment,e),vl=a(e),r(_.$$.fragment,e),Vl=a(e),Y=i(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-nbv8of"&&(Y.innerHTML=as),hl=a(e),D=i(e,"IMG",{src:!0,alt:!0}),Bl=a(e),P=i(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-ros972"&&(P.innerHTML=is),Zl=a(e),O=i(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-10dimdp"&&(O.textContent=os),Al=a(e),r(K.$$.fragment,e),kl=a(e),ee=i(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1je39e0"&&(ee.innerHTML=us),Gl=a(e),r(le.$$.fragment,e),Ql=a(e),te=i(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-q8z4id"&&(te.innerHTML=rs),Nl=a(e),r(se.$$.fragment,e),Wl=a(e),ne=i(e,"IMG",{src:!0,alt:!0}),zl=a(e),ae=i(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-19rnwld"&&(ae.innerHTML=Us),xl=a(e),Me=i(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-1odaua3"&&(Me.innerHTML=ps),ql=a(e),r(ie.$$.fragment,e),Fl=a(e),oe=i(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-vb5vfu"&&(oe.innerHTML=Ts),Sl=a(e),ue=i(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-soaq08"&&(ue.textContent=cs),Hl=a(e),r(re.$$.fragment,e),El=a(e),Je=i(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-h0ap13"&&(Je.innerHTML=ys),Xl=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-176qcik"&&(Ue.textContent=ds),$l=a(e),pe=i(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1nbkqdp"&&(pe.innerHTML=ws),Ll=a(e),Te=i(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-4dnuda"&&(Te.innerHTML=ms),Rl=a(e),ce=i(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-93tlx9"&&(ce.innerHTML=js),_l=a(e),r(ye.$$.fragment,e),Yl=a(e),de=i(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-g6rq43"&&(de.innerHTML=Is),Dl=a(e),we=i(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-1ypso5j"&&(we.innerHTML=gs),Pl=a(e),r(me.$$.fragment,e),Ol=a(e),je=i(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-oq2swv"&&(je.innerHTML=Cs),Kl=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-ad9apm"&&(Ie.innerHTML=fs),et=a(e),r(ge.$$.fragment,e),lt=a(e),Ce=i(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-1qfppzv"&&(Ce.textContent=bs),tt=a(e),r(fe.$$.fragment,e),st=a(e),be=i(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-1h3kncv"&&(be.innerHTML=vs),nt=a(e),ve=i(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-bhiihf"&&(ve.innerHTML=Vs),at=a(e),d=i(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),qt(d).forEach(t),Mt=a(e),Ve=i(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-u5okdk"&&(Ve.innerHTML=Bs),it=a(e),r(he.$$.fragment,e),ot=a(e),Be=i(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-1u3udsr"&&(Be.innerHTML=Zs),ut=a(e),Ze=i(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-1n74e31"&&(Ze.textContent=As),rt=a(e),g=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(g)!=="svelte-xvemed"&&(g.innerHTML=ks),Jt=a(e),r(Ae.$$.fragment,e),Ut=a(e),ke=i(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-5ucj7u"&&(ke.textContent=Gs),pt=a(e),Ge=i(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-th4cqd"&&(Ge.innerHTML=Qs),Tt=a(e),Qe=i(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-1kqsety"&&(Qe.textContent=Ns),ct=a(e),Ne=i(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1vyo3dy"&&(Ne.textContent=Ws),yt=a(e),r(We.$$.fragment,e),dt=a(e),ze=i(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-tiqfgb"&&(ze.innerHTML=zs),wt=a(e),xe=i(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-1u3cp6e"&&(xe.textContent=xs),mt=a(e),r(qe.$$.fragment,e),jt=a(e),Fe=i(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-163dki2"&&(Fe.innerHTML=qs),It=a(e),r(Se.$$.fragment,e),gt=a(e),He=i(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-n7e0p9"&&(He.innerHTML=Fs),Ct=a(e),r(Ee.$$.fragment,e),ft=a(e),Xe=i(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-1yvulo5"&&(Xe.innerHTML=Ss),bt=a(e),C=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(C)!=="svelte-1ln306s"&&(C.innerHTML=Hs),vt=a(e),r($e.$$.fragment,e),Vt=a(e),Le=i(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-1mgyxy6"&&(Le.innerHTML=Es),ht=a(e),f=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(f)!=="svelte-e6pw4i"&&(f.innerHTML=Xs),Bt=a(e),Re=i(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-1k95rqr"&&(Re.innerHTML=$s),Zt=a(e),At=i(e,"HR",{}),kt=a(e),_e=i(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-e10mys"&&(_e.innerHTML=Ls),Gt=a(e),r(Ye.$$.fragment,e),Qt=a(e),De=i(e,"UL",{"data-svelte-h":!0}),o(De)!=="svelte-92ndd0"&&(De.innerHTML=Rs),Nt=a(e),r(Pe.$$.fragment,e),Wt=a(e),Ke=i(e,"P",{}),qt(Ke).forEach(t),this.h()},h(){c(m,"name","hf:doc:metadata"),c(m,"content",nn),c(j,"class","tip"),c(I,"class","tip"),xt(E.src,ts="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/alfred-party.jpg")||c(E,"src",ts),c(E,"alt","Alfred Party"),xt(D.src,Ms="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/alfred-playlist.jpg")||c(D,"src",Ms),c(D,"alt","Alfred Playlist"),xt(ne.src,Js="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/alfred-menu.jpg")||c(ne,"src",Js),c(ne,"alt","Alfred Menu"),xt(d.src,hs="https://sergiopaniego-alfredagent.hf.space/")||c(d,"src",hs),c(d,"frameborder","0"),c(d,"width","850"),c(d,"height","450"),c(g,"class","tip"),c(C,"class","tip"),c(f,"class","tip")},m(e,l){en(document.head,m),s(e,el,l),s(e,Oe,l),s(e,ll,l),J(b,e,l),s(e,tl,l),J(v,e,l),s(e,sl,l),s(e,V,l),s(e,nl,l),s(e,h,l),s(e,al,l),s(e,B,l),s(e,Ml,l),s(e,j,l),s(e,il,l),J(Z,e,l),s(e,ol,l),s(e,A,l),s(e,ul,l),s(e,k,l),s(e,rl,l),s(e,G,l),s(e,Jl,l),s(e,Q,l),s(e,Ul,l),J(N,e,l),s(e,pl,l),s(e,W,l),s(e,Tl,l),s(e,z,l),s(e,cl,l),s(e,x,l),s(e,yl,l),s(e,q,l),s(e,dl,l),s(e,F,l),s(e,wl,l),J(S,e,l),s(e,ml,l),s(e,I,l),s(e,jl,l),s(e,H,l),s(e,Il,l),s(e,E,l),s(e,gl,l),s(e,X,l),s(e,Cl,l),J($,e,l),s(e,fl,l),s(e,L,l),s(e,bl,l),J(R,e,l),s(e,vl,l),J(_,e,l),s(e,Vl,l),s(e,Y,l),s(e,hl,l),s(e,D,l),s(e,Bl,l),s(e,P,l),s(e,Zl,l),s(e,O,l),s(e,Al,l),J(K,e,l),s(e,kl,l),s(e,ee,l),s(e,Gl,l),J(le,e,l),s(e,Ql,l),s(e,te,l),s(e,Nl,l),J(se,e,l),s(e,Wl,l),s(e,ne,l),s(e,zl,l),s(e,ae,l),s(e,xl,l),s(e,Me,l),s(e,ql,l),J(ie,e,l),s(e,Fl,l),s(e,oe,l),s(e,Sl,l),s(e,ue,l),s(e,Hl,l),J(re,e,l),s(e,El,l),s(e,Je,l),s(e,Xl,l),s(e,Ue,l),s(e,$l,l),s(e,pe,l),s(e,Ll,l),s(e,Te,l),s(e,Rl,l),s(e,ce,l),s(e,_l,l),J(ye,e,l),s(e,Yl,l),s(e,de,l),s(e,Dl,l),s(e,we,l),s(e,Pl,l),J(me,e,l),s(e,Ol,l),s(e,je,l),s(e,Kl,l),s(e,Ie,l),s(e,et,l),J(ge,e,l),s(e,lt,l),s(e,Ce,l),s(e,tt,l),J(fe,e,l),s(e,st,l),s(e,be,l),s(e,nt,l),s(e,ve,l),s(e,at,l),s(e,d,l),s(e,Mt,l),s(e,Ve,l),s(e,it,l),J(he,e,l),s(e,ot,l),s(e,Be,l),s(e,ut,l),s(e,Ze,l),s(e,rt,l),s(e,g,l),s(e,Jt,l),J(Ae,e,l),s(e,Ut,l),s(e,ke,l),s(e,pt,l),s(e,Ge,l),s(e,Tt,l),s(e,Qe,l),s(e,ct,l),s(e,Ne,l),s(e,yt,l),J(We,e,l),s(e,dt,l),s(e,ze,l),s(e,wt,l),s(e,xe,l),s(e,mt,l),J(qe,e,l),s(e,jt,l),s(e,Fe,l),s(e,It,l),J(Se,e,l),s(e,gt,l),s(e,He,l),s(e,Ct,l),J(Ee,e,l),s(e,ft,l),s(e,Xe,l),s(e,bt,l),s(e,C,l),s(e,vt,l),J($e,e,l),s(e,Vt,l),s(e,Le,l),s(e,ht,l),s(e,f,l),s(e,Bt,l),s(e,Re,l),s(e,Zt,l),s(e,At,l),s(e,kt,l),s(e,_e,l),s(e,Gt,l),J(Ye,e,l),s(e,Qt,l),s(e,De,l),s(e,Nt,l),J(Pe,e,l),s(e,Wt,l),s(e,Ke,l),zt=!0},p:Ys,i(e){zt||(U(b.$$.fragment,e),U(v.$$.fragment,e),U(Z.$$.fragment,e),U(N.$$.fragment,e),U(S.$$.fragment,e),U($.$$.fragment,e),U(R.$$.fragment,e),U(_.$$.fragment,e),U(K.$$.fragment,e),U(le.$$.fragment,e),U(se.$$.fragment,e),U(ie.$$.fragment,e),U(re.$$.fragment,e),U(ye.$$.fragment,e),U(me.$$.fragment,e),U(ge.$$.fragment,e),U(fe.$$.fragment,e),U(he.$$.fragment,e),U(Ae.$$.fragment,e),U(We.$$.fragment,e),U(qe.$$.fragment,e),U(Se.$$.fragment,e),U(Ee.$$.fragment,e),U($e.$$.fragment,e),U(Ye.$$.fragment,e),U(Pe.$$.fragment,e),zt=!0)},o(e){p(b.$$.fragment,e),p(v.$$.fragment,e),p(Z.$$.fragment,e),p(N.$$.fragment,e),p(S.$$.fragment,e),p($.$$.fragment,e),p(R.$$.fragment,e),p(_.$$.fragment,e),p(K.$$.fragment,e),p(le.$$.fragment,e),p(se.$$.fragment,e),p(ie.$$.fragment,e),p(re.$$.fragment,e),p(ye.$$.fragment,e),p(me.$$.fragment,e),p(ge.$$.fragment,e),p(fe.$$.fragment,e),p(he.$$.fragment,e),p(Ae.$$.fragment,e),p(We.$$.fragment,e),p(qe.$$.fragment,e),p(Se.$$.fragment,e),p(Ee.$$.fragment,e),p($e.$$.fragment,e),p(Ye.$$.fragment,e),p(Pe.$$.fragment,e),zt=!1},d(e){e&&(t(el),t(Oe),t(ll),t(tl),t(sl),t(V),t(nl),t(h),t(al),t(B),t(Ml),t(j),t(il),t(ol),t(A),t(ul),t(k),t(rl),t(G),t(Jl),t(Q),t(Ul),t(pl),t(W),t(Tl),t(z),t(cl),t(x),t(yl),t(q),t(dl),t(F),t(wl),t(ml),t(I),t(jl),t(H),t(Il),t(E),t(gl),t(X),t(Cl),t(fl),t(L),t(bl),t(vl),t(Vl),t(Y),t(hl),t(D),t(Bl),t(P),t(Zl),t(O),t(Al),t(kl),t(ee),t(Gl),t(Ql),t(te),t(Nl),t(Wl),t(ne),t(zl),t(ae),t(xl),t(Me),t(ql),t(Fl),t(oe),t(Sl),t(ue),t(Hl),t(El),t(Je),t(Xl),t(Ue),t($l),t(pe),t(Ll),t(Te),t(Rl),t(ce),t(_l),t(Yl),t(de),t(Dl),t(we),t(Pl),t(Ol),t(je),t(Kl),t(Ie),t(et),t(lt),t(Ce),t(tt),t(st),t(be),t(nt),t(ve),t(at),t(d),t(Mt),t(Ve),t(it),t(ot),t(Be),t(ut),t(Ze),t(rt),t(g),t(Jt),t(Ut),t(ke),t(pt),t(Ge),t(Tt),t(Qe),t(ct),t(Ne),t(yt),t(dt),t(ze),t(wt),t(xe),t(mt),t(jt),t(Fe),t(It),t(gt),t(He),t(Ct),t(ft),t(Xe),t(bt),t(C),t(vt),t(Vt),t(Le),t(ht),t(f),t(Bt),t(Re),t(Zt),t(At),t(kt),t(_e),t(Gt),t(Qt),t(De),t(Nt),t(Wt),t(Ke)),t(m),T(b,e),T(v,e),T(Z,e),T(N,e),T(S,e),T($,e),T(R,e),T(_,e),T(K,e),T(le,e),T(se,e),T(ie,e),T(re,e),T(ye,e),T(me,e),T(ge,e),T(fe,e),T(he,e),T(Ae,e),T(We,e),T(qe,e),T(Se,e),T(Ee,e),T($e,e),T(Ye,e),T(Pe,e)}}}const nn='{"title":"Construire des agents qui utilisent du code","local":"construire-des-agents-qui-utilisent-du-code","sections":[{"title":"Pourquoi les agents à code ?","local":"pourquoi-les-agents-à-code-","sections":[],"depth":2},{"title":"Comment fonctionne un agent à code ?","local":"comment-fonctionne-un-agent-à-code-","sections":[],"depth":2},{"title":"Voyons quelques exemples","local":"voyons-quelques-exemples","sections":[{"title":"Sélectionner une playlist pour la fête en utilisant smolagents","local":"sélectionner-une-playlist-pour-la-fête-en-utilisant-smolagents","sections":[],"depth":3},{"title":"Utiliser un outil personnalisé pour préparer le menu","local":"utiliser-un-outil-personnalisé-pour-préparer-le-menu","sections":[],"depth":3},{"title":"Utiliser des imports Python à l’intérieur de l’agent","local":"utiliser-des-imports-python-à-lintérieur-de-lagent","sections":[],"depth":3},{"title":"Partager notre agent préparateur de fête personnalisé sur le Hub","local":"partager-notre-agent-préparateur-de-fête-personnalisé-sur-le-hub","sections":[],"depth":3},{"title":"Inspecter notre agent préparateur de fête avec OpenTelemetry et Langfuse 📡","local":"inspecter-notre-agent-préparateur-de-fête-avec-opentelemetry-et-langfuse-","sections":[],"depth":3}],"depth":2},{"title":"Ressources","local":"ressources","sections":[],"depth":2}],"depth":1}';function an(Ft){return Ds(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pn extends Ps{constructor(m){super(),Os(this,m,an,sn,_s,{})}}export{pn as component};
