import{s as Oe,n as el,o as ll}from"../chunks/scheduler.37c15a92.js";import{S as sl,i as tl,g as i,s as n,r as u,A as nl,h as r,f as s,c as a,j as Pe,u as c,x as M,k as Ze,y as al,a as t,v as p,d as y,t as d,w as J}from"../chunks/index.2bf4358c.js";import{C as Ke}from"../chunks/CodeBlock.4e987730.js";import{C as il}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as F}from"../chunks/Heading.8ada512a.js";import{E as rl}from"../chunks/getInferenceSnippets.0aa3753f.js";function Ml(ge){let o,D,$,Y,m,P,j,K,U,Ve='<p>Vous pouvez suivre le code dans <a href="https://huggingface.co/agents-course/notebooks/blob/main/fr/unit2/smolagents/retrieval_agents.ipynb" target="_blank">ce <i>notebook</i></a> que vous pouvez exécuter avec Google Colab.</p>',O,T,ve="Les systèmes de RAG (<em>Retrieval Augmented Generation</em>) combinent les capacités de récupération de données et de modèles de génération pour fournir des réponses contextuelles. Par exemple, la requête d’un utilisateur est transmise à un moteur de recherche puis les résultats récupérés sont fournis au LLM avec la requête. Le modèle génère ensuite une réponse basée sur la requête et les informations récupérées.",ee,I,Qe="Le RAG agentique (<em>Agentic RAG</em>) étend les systèmes de RAG traditionnels en <strong>combinant des agents autonomes avec une récupération dynamique des connaissances</strong>.",le,w,qe="Alors que les systèmes de RAG traditionnels utilisent un LLM pour répondre aux requêtes basées sur des données récupérées, le RAG agentique <strong>permet un contrôle intelligent des processus de récupération et de génération</strong>, améliorant l’efficacité et la précision.",se,h,Ae="Les systèmes de RAG traditionnels font face à des limitations clés, telles que <strong>s’appuyer sur une seule étape de récupération</strong> et se concentrer sur la similarité sémantique directe avec la requête de l’utilisateur, ce qui peut négliger des informations pertinentes.",te,b,xe="Le RAG agentique résout ces problèmes en permettant à l’agent de formuler de manière autonome des requêtes, de critiquer les résultats récupérés et de mener plusieurs étapes de récupération pour une sortie plus adaptée et complète.",ne,C,ae,G,Xe="Construisons un agent simple qui peut rechercher sur le web en utilisant DuckDuckGo. Cet agent récupérera des informations et synthétisera des réponses pour répondre aux requêtes. Avec le RAG agentique, l’agent d’Alfred peut :",ie,B,Ee="<li>Rechercher des dernières tendances en matière de fêtes de super-héros</li> <li>Affiner les résultats pour inclure des éléments luxueux</li> <li>Synthétiser les informations en un plan complet</li>",re,f,ze="Voici comment l’agent d’Alfred peut y parvenir :",Me,Z,oe,g,Re="L’agent suit ce processus :",ue,V,We="<li><strong>Analyse la requête :</strong> identifie les éléments clés de la requête - organisation de fêtes de luxe sur le thème des super-héros, en mettant l’accent sur la décoration, les divertissements et la restauration.</li> <li><strong>Effectue la récupération :</strong> exploite DuckDuckGo pour rechercher les informations les plus pertinentes et à jour, en s’assurant qu’elles correspondent aux préférences d’Alfred pour un événement luxueux.</li> <li><strong>Synthétise l’information :</strong> après avoir rassemblé les résultats, l’agent les traite en un plan cohérent et actionnable pour Alfred, couvrant tous les aspects de la fête.</li> <li><strong>Stocke pour référence future :</strong> stocke les informations récupérées pour un accès facile lors de la planification d’événements futurs, optimisant l’efficacité des tâches ultérieures.</li>",ce,v,pe,Q,ke="Pour des tâches spécialisées, une base de connaissances personnalisée peut être inestimable. Créons un outil qui interroge une base de données vectorielle de documentation technique ou de connaissances spécialisées. En utilisant la recherche sémantique, l’agent peut trouver les informations les plus pertinentes pour les besoins d’Alfred.",ye,q,Ne="Une base de données vectorielle stocke des représentations numériques (<em>embeddings</em>) de texte ou d’autres données, créées par des modèles d’apprentissage automatique. Elle permet la recherche sémantique en identifiant des significations similaires dans un espace de haute dimension.",de,A,Se="Cette approche combine des connaissances prédéfinies avec une recherche sémantique pour fournir des solutions contextuelles pour la planification d’événements. Avec un accès à des connaissances spécialisées, Alfred peut perfectionner chaque détail de la fête.",Je,x,He="Dans cet exemple, nous allons créer un outil qui récupère des idées de planification de fête à partir d’une base de connaissances personnalisée. Nous utiliserons un modèle BM25 pour rechercher dans la base de connaissances et retourner les meilleurs résultats, et <code>RecursiveCharacterTextSplitter</code> pour diviser les documents en morceaux plus petits pour une recherche plus efficace.",Ue,X,me,E,_e="Cet agent amélioré peut :",je,z,$e="<li>D’abord vérifier la documentation pour des informations pertinentes</li> <li>Combiner les informations de la base de connaissances</li> <li>Maintenir le contexte de conversation en mémoire</li>",Te,R,Ie,W,Le="Lors de la construction de systèmes de RAG agentiques, l’agent peut employer des stratégies sophistiquées comme :",we,k,Fe='<li><strong>La reformulation de requête :</strong> Au lieu d’utiliser la requête brute de l’utilisateur, l’agent peut élaborer des termes de recherche optimisés qui correspondent mieux aux documents cibles</li> <li><strong>La décomposition de requête :</strong> Au lieu d’utiliser directement la requête de l’utilisateur, si elle contient plusieurs éléments d’information à interroger, elle peut être décomposée en plusieurs requêtes</li> <li><strong>L’expansion de requête :</strong> Similaire à la reformulation de requête mais effectuée plusieurs fois pour formuler la requête de plusieurs façons et les interroger toutes</li> <li><strong>Le reclassement :</strong> Utiliser des <a href="https://huggingface.co/models?pipeline_tag=text-ranking&amp;sort=trending" rel="nofollow"><em>Cross-Encoders</em></a> pour attribuer des scores de pertinence sémantique plus complets entre les documents récupérés et la requête</li> <li><strong>La récupération multi-étapes :</strong> L’agent peut effectuer plusieurs recherches, en utilisant les résultats initiaux pour informer les requêtes suivantes</li> <li><strong>L’intégration de sources :</strong> Les informations peuvent être combinées à partir de plusieurs sources comme la recherche web et la documentation locale</li> <li><strong>La validation des résultats :</strong> Le contenu récupéré peut être analysé pour sa pertinence et son exactitude avant d’être inclus dans les réponses</li>',he,N,De="Les systèmes de RAG agentiques efficaces nécessitent une considération attentive de plusieurs aspects clés. L’agent <strong>devrait sélectionner entre les outils disponibles en fonction du type de requête et du contexte</strong>. Les systèmes de mémoire aident à maintenir l’historique de conversation et évitent les récupérations répétitives. Avoir des stratégies de secours garantit que le système peut toujours fournir de la valeur même lorsque les méthodes de récupération principales échouent. De plus, l’implémentation d’étapes de validation aide à assurer l’exactitude et la pertinence des informations récupérées.",be,S,Ce,H,Ye='<li><a href="https://huggingface.co/learn/cookbook/agent_rag" rel="nofollow">Agentic RAG : boostez votre RAG avec la reformulation de requête et l’auto-requête ! 🚀</a> - Recette pour développer un système de RAG agentique en utilisant <code>smolagents</code>.</li>',Ge,_,Be,L,fe;return m=new il({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/fr/unit2/smolagents/retrieval_agents.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),j=new F({props:{title:"Construction de systèmes de RAG agentiques",local:"construction-de-systèmes-de-rag-agentiques",headingTag:"h1"}}),C=new F({props:{title:"Récupération de base avec DuckDuckGo",local:"récupération-de-base-avec-duckduckgo",headingTag:"h2"}}),Z=new Ke({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGlzZXIlMjBsJ291dGlsJTIwZGUlMjByZWNoZXJjaGUlMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEElMEElMjMlMjBJbml0aWFsaXNlciUyMGxlJTIwbW9kJUMzJUE4bGUlMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKCklMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJzZWFyY2hfdG9vbCU1RCUyQyUwQSklMEElMEElMjMlMjBFeGVtcGxlJTIwZCd1dGlsaXNhdGlvbiUwQXJlc3BvbnNlJTIwJTNEJTIwYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMlNlYXJjaCUyMGZvciUyMGx1eHVyeSUyMHN1cGVyaGVyby10aGVtZWQlMjBwYXJ0eSUyMGlkZWFzJTJDJTIwaW5jbHVkaW5nJTIwZGVjb3JhdGlvbnMlMkMlMjBlbnRlcnRhaW5tZW50JTJDJTIwYW5kJTIwY2F0ZXJpbmcuJTIyJTBBKSUwQXByaW50KHJlc3BvbnNlKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, InferenceClientModel

<span class="hljs-comment"># Initialiser l&#x27;outil de recherche</span>
search_tool = DuckDuckGoSearchTool()

<span class="hljs-comment"># Initialiser le modèle</span>
model = InferenceClientModel()

agent = CodeAgent(
    model=model,
    tools=[search_tool],
)

<span class="hljs-comment"># Exemple d&#x27;utilisation</span>
response = agent.run(
    <span class="hljs-string">&quot;Search for luxury superhero-themed party ideas, including decorations, entertainment, and catering.&quot;</span>
)
<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),v=new F({props:{title:"Outil de base de connaissances personnalisé",local:"outil-de-base-de-connaissances-personnalisé",headingTag:"h2"}}),X=new Ke({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_community.retrievers <span class="hljs-keyword">import</span> BM25Retriever
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PartyPlanningRetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;party_planning_retriever&quot;</span>
    description = <span class="hljs-string">&quot;Utilise la recherche sémantique pour trouver des idées pertinentes pour l&#x27;organisation de la fête d&#x27;Alfred au Manoir Wayne sur le thème des super-héros.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;La requête à effectuer. Celle-ci doit être liée à l&#x27;organisation de fêtes ou à des thèmes de super-héros.&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, docs, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.retriever = BM25Retriever.from_documents(
            docs, k=<span class="hljs-number">5</span>  <span class="hljs-comment"># Récupérer les 5 meilleurs documents</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Votre requête doit être une chaîne de caractères&quot;</span>

        docs = self.retriever.invoke(
            query,
        )
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\nIdées récupérées :\\n&quot;</span> + <span class="hljs-string">&quot;&quot;</span>.join(
            [
                <span class="hljs-string">f&quot;\\n\\n===== Idée <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span> =====\\n&quot;</span> + doc.page_content
                <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(docs)
            ]
        )

<span class="hljs-comment"># Simuler une base de connaissances sur la planification de la fête</span>
party_ideas = [
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Un bal masqué sur le thème des super-héros avec un décor luxueux, notamment des accents dorés et des rideaux de velours.&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Idées de fête 1&quot;</span>},
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Engagez un DJ professionnel qui peut jouer de la musique sur le thème des super-héros comme Batman et Wonder Woman.&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Idées de divertissement&quot;</span>},
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Pour la restauration, servez des plats portant le nom de super-héros, comme &#x27;Le smoothie vert de Hulk&#x27; et &#x27;Le steak de puissance d&#x27;Iron Man&#x27;&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Idées de traiteur&quot;</span>},
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Décorez le lieu avec des logos de super-héros emblématiques et des projections de Gotham et d&#x27;autres villes de super-héros.&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Idées de décoration&quot;</span>},
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Expériences interactives avec la VR où les invités peuvent participer à des simulations de super-héros ou à des jeux à thème.&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Idées de divertissement&quot;</span>}
]

source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>]})
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> party_ideas
]

<span class="hljs-comment"># Découper les documents en morceaux plus petits pour une recherche plus efficace</span>
text_splitter = RecursiveCharacterTextSplitter(
    chunk_size=<span class="hljs-number">500</span>,
    chunk_overlap=<span class="hljs-number">50</span>,
    add_start_index=<span class="hljs-literal">True</span>,
    strip_whitespace=<span class="hljs-literal">True</span>,
    separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],
)
docs_processed = text_splitter.split_documents(source_docs)

<span class="hljs-comment"># Créer l&#x27;outil de récupération</span>
party_planning_retriever = PartyPlanningRetrieverTool(docs_processed)

<span class="hljs-comment"># Initialiser l&#x27;agent</span>
agent = CodeAgent(tools=[party_planning_retriever], model=InferenceClientModel())

<span class="hljs-comment"># Exemple d&#x27;utilisation</span>
response = agent.run(
    <span class="hljs-string">&quot;Trouver des idées pour une fête de luxe sur le thème des super-héros, y compris des options de divertissement, de restauration et de décoration.&quot;</span>
)

<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),R=new F({props:{title:"Capacités de récupération améliorées",local:"capacités-de-récupération-améliorées",headingTag:"h2"}}),S=new F({props:{title:"Ressources",local:"ressources",headingTag:"h2"}}),_=new rl({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit2/smolagents/retrieval_agents.mdx"}}),{c(){o=i("meta"),D=n(),$=i("p"),Y=n(),u(m.$$.fragment),P=n(),u(j.$$.fragment),K=n(),U=i("blockquote"),U.innerHTML=Ve,O=n(),T=i("p"),T.innerHTML=ve,ee=n(),I=i("p"),I.innerHTML=Qe,le=n(),w=i("p"),w.innerHTML=qe,se=n(),h=i("p"),h.innerHTML=Ae,te=n(),b=i("p"),b.textContent=xe,ne=n(),u(C.$$.fragment),ae=n(),G=i("p"),G.textContent=Xe,ie=n(),B=i("ul"),B.innerHTML=Ee,re=n(),f=i("p"),f.textContent=ze,Me=n(),u(Z.$$.fragment),oe=n(),g=i("p"),g.textContent=Re,ue=n(),V=i("ol"),V.innerHTML=We,ce=n(),u(v.$$.fragment),pe=n(),Q=i("p"),Q.textContent=ke,ye=n(),q=i("p"),q.innerHTML=Ne,de=n(),A=i("p"),A.textContent=Se,Je=n(),x=i("p"),x.innerHTML=He,Ue=n(),u(X.$$.fragment),me=n(),E=i("p"),E.textContent=_e,je=n(),z=i("ol"),z.innerHTML=$e,Te=n(),u(R.$$.fragment),Ie=n(),W=i("p"),W.textContent=Le,we=n(),k=i("ol"),k.innerHTML=Fe,he=n(),N=i("p"),N.innerHTML=De,be=n(),u(S.$$.fragment),Ce=n(),H=i("ul"),H.innerHTML=Ye,Ge=n(),u(_.$$.fragment),Be=n(),L=i("p"),this.h()},l(e){const l=nl("svelte-u9bgzb",document.head);o=r(l,"META",{name:!0,content:!0}),l.forEach(s),D=a(e),$=r(e,"P",{}),Pe($).forEach(s),Y=a(e),c(m.$$.fragment,e),P=a(e),c(j.$$.fragment,e),K=a(e),U=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(U)!=="svelte-1cr93ez"&&(U.innerHTML=Ve),O=a(e),T=r(e,"P",{"data-svelte-h":!0}),M(T)!=="svelte-1q55u1h"&&(T.innerHTML=ve),ee=a(e),I=r(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-171s4ef"&&(I.innerHTML=Qe),le=a(e),w=r(e,"P",{"data-svelte-h":!0}),M(w)!=="svelte-174din4"&&(w.innerHTML=qe),se=a(e),h=r(e,"P",{"data-svelte-h":!0}),M(h)!=="svelte-kpdqca"&&(h.innerHTML=Ae),te=a(e),b=r(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1idy7jv"&&(b.textContent=xe),ne=a(e),c(C.$$.fragment,e),ae=a(e),G=r(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1ehg1a0"&&(G.textContent=Xe),ie=a(e),B=r(e,"UL",{"data-svelte-h":!0}),M(B)!=="svelte-13jxt5y"&&(B.innerHTML=Ee),re=a(e),f=r(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-1xfi7ss"&&(f.textContent=ze),Me=a(e),c(Z.$$.fragment,e),oe=a(e),g=r(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-12hlf7k"&&(g.textContent=Re),ue=a(e),V=r(e,"OL",{"data-svelte-h":!0}),M(V)!=="svelte-1n78adl"&&(V.innerHTML=We),ce=a(e),c(v.$$.fragment,e),pe=a(e),Q=r(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1al822e"&&(Q.textContent=ke),ye=a(e),q=r(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-e3o4wg"&&(q.innerHTML=Ne),de=a(e),A=r(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-19hmuww"&&(A.textContent=Se),Je=a(e),x=r(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-cgpquh"&&(x.innerHTML=He),Ue=a(e),c(X.$$.fragment,e),me=a(e),E=r(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-ahpiz3"&&(E.textContent=_e),je=a(e),z=r(e,"OL",{"data-svelte-h":!0}),M(z)!=="svelte-5ii5zg"&&(z.innerHTML=$e),Te=a(e),c(R.$$.fragment,e),Ie=a(e),W=r(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-11bml2y"&&(W.textContent=Le),we=a(e),k=r(e,"OL",{"data-svelte-h":!0}),M(k)!=="svelte-1bdyrer"&&(k.innerHTML=Fe),he=a(e),N=r(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-g1x8ux"&&(N.innerHTML=De),be=a(e),c(S.$$.fragment,e),Ce=a(e),H=r(e,"UL",{"data-svelte-h":!0}),M(H)!=="svelte-ufdv41"&&(H.innerHTML=Ye),Ge=a(e),c(_.$$.fragment,e),Be=a(e),L=r(e,"P",{}),Pe(L).forEach(s),this.h()},h(){Ze(o,"name","hf:doc:metadata"),Ze(o,"content",ol),Ze(U,"class","tip")},m(e,l){al(document.head,o),t(e,D,l),t(e,$,l),t(e,Y,l),p(m,e,l),t(e,P,l),p(j,e,l),t(e,K,l),t(e,U,l),t(e,O,l),t(e,T,l),t(e,ee,l),t(e,I,l),t(e,le,l),t(e,w,l),t(e,se,l),t(e,h,l),t(e,te,l),t(e,b,l),t(e,ne,l),p(C,e,l),t(e,ae,l),t(e,G,l),t(e,ie,l),t(e,B,l),t(e,re,l),t(e,f,l),t(e,Me,l),p(Z,e,l),t(e,oe,l),t(e,g,l),t(e,ue,l),t(e,V,l),t(e,ce,l),p(v,e,l),t(e,pe,l),t(e,Q,l),t(e,ye,l),t(e,q,l),t(e,de,l),t(e,A,l),t(e,Je,l),t(e,x,l),t(e,Ue,l),p(X,e,l),t(e,me,l),t(e,E,l),t(e,je,l),t(e,z,l),t(e,Te,l),p(R,e,l),t(e,Ie,l),t(e,W,l),t(e,we,l),t(e,k,l),t(e,he,l),t(e,N,l),t(e,be,l),p(S,e,l),t(e,Ce,l),t(e,H,l),t(e,Ge,l),p(_,e,l),t(e,Be,l),t(e,L,l),fe=!0},p:el,i(e){fe||(y(m.$$.fragment,e),y(j.$$.fragment,e),y(C.$$.fragment,e),y(Z.$$.fragment,e),y(v.$$.fragment,e),y(X.$$.fragment,e),y(R.$$.fragment,e),y(S.$$.fragment,e),y(_.$$.fragment,e),fe=!0)},o(e){d(m.$$.fragment,e),d(j.$$.fragment,e),d(C.$$.fragment,e),d(Z.$$.fragment,e),d(v.$$.fragment,e),d(X.$$.fragment,e),d(R.$$.fragment,e),d(S.$$.fragment,e),d(_.$$.fragment,e),fe=!1},d(e){e&&(s(D),s($),s(Y),s(P),s(K),s(U),s(O),s(T),s(ee),s(I),s(le),s(w),s(se),s(h),s(te),s(b),s(ne),s(ae),s(G),s(ie),s(B),s(re),s(f),s(Me),s(oe),s(g),s(ue),s(V),s(ce),s(pe),s(Q),s(ye),s(q),s(de),s(A),s(Je),s(x),s(Ue),s(me),s(E),s(je),s(z),s(Te),s(Ie),s(W),s(we),s(k),s(he),s(N),s(be),s(Ce),s(H),s(Ge),s(Be),s(L)),s(o),J(m,e),J(j,e),J(C,e),J(Z,e),J(v,e),J(X,e),J(R,e),J(S,e),J(_,e)}}}const ol='{"title":"Construction de systèmes de RAG agentiques","local":"construction-de-systèmes-de-rag-agentiques","sections":[{"title":"Récupération de base avec DuckDuckGo","local":"récupération-de-base-avec-duckduckgo","sections":[],"depth":2},{"title":"Outil de base de connaissances personnalisé","local":"outil-de-base-de-connaissances-personnalisé","sections":[],"depth":2},{"title":"Capacités de récupération améliorées","local":"capacités-de-récupération-améliorées","sections":[],"depth":2},{"title":"Ressources","local":"ressources","sections":[],"depth":2}],"depth":1}';function ul(ge){return ll(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ml extends sl{constructor(o){super(),tl(this,o,ul,Ml,Oe,{})}}export{ml as component};
