import{s as Dl,f as Ll,o as Ol,n as x}from"../chunks/scheduler.37c15a92.js";import{S as Pl,i as Kl,g as m,s as u,r as h,A as es,h as U,f as s,c as M,j as Ul,u as C,x as J,k as $,y as ls,a as t,v as I,d as v,t as Z,w as g}from"../chunks/index.2bf4358c.js";import{C as V}from"../chunks/CodeBlock.4e987730.js";import{H as W}from"../chunks/Heading.8ada512a.js";import{H as Jl,a as k}from"../chunks/HfOption.02c8e375.js";import{E as ss}from"../chunks/getInferenceSnippets.0aa3753f.js";function ts(G){let i,j="Nous utiliserons la bibliothèque <code>datasets</code> d’Hugging Face pour charger le jeu de données et le convertir en une liste d’objets <code>Document</code> du module <code>langchain.docstore.document</code>.",p,d,y;return d=new V({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEFmcm9tJTIwbGFuZ2NoYWluX2NvcmUuZG9jdW1lbnRzJTIwaW1wb3J0JTIwRG9jdW1lbnQlMEElMEElMjMlMjBDaGFyZ2VyJTIwbGUlMjBqZXUlMjBkZSUyMGRvbm4lQzMlQTllcyUwQWd1ZXN0X2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0cy5sb2FkX2RhdGFzZXQoJTIyYWdlbnRzLWNvdXJzZSUyRnVuaXQzLWludml0ZWVzJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEElMEElMjMlMjBDb252ZXJ0aXIlMjBsZXMlMjBlbnRyJUMzJUE5ZXMlMjBkdSUyMGpldSUyMGRlJTIwZG9ubiVDMyVBOWVzJTIwZW4lMjBvYmpldHMlMjBEb2N1bWVudCUwQWRvY3MlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBEb2N1bWVudCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYWdlX2NvbnRlbnQlM0QlMjIlNUNuJTIyLmpvaW4oJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMk5hbWUlM0ElMjAlN0JndWVzdCU1QiduYW1lJyU1RCU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjJSZWxhdGlvbiUzQSUyMCU3Qmd1ZXN0JTVCJ3JlbGF0aW9uJyU1RCU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjJEZXNjcmlwdGlvbiUzQSUyMCU3Qmd1ZXN0JTVCJ2Rlc2NyaXB0aW9uJyU1RCU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjJFbWFpbCUzQSUyMCU3Qmd1ZXN0JTVCJ2VtYWlsJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRhZGF0YSUzRCU3QiUyMm5hbWUlMjIlM0ElMjBndWVzdCU1QiUyMm5hbWUlMjIlNUQlN0QlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwZm9yJTIwZ3Vlc3QlMjBpbiUyMGd1ZXN0X2RhdGFzZXQlMEElNUQlMEE=",highlighted:`<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">from</span> langchain_core.documents <span class="hljs-keyword">import</span> Document

<span class="hljs-comment"># Charger le jeu de données</span>
guest_dataset = datasets.load_dataset(<span class="hljs-string">&quot;agents-course/unit3-invitees&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-comment"># Convertir les entrées du jeu de données en objets Document</span>
docs = [
    Document(
        page_content=<span class="hljs-string">&quot;\\n&quot;</span>.join([
            <span class="hljs-string">f&quot;Name: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;name&#x27;</span>]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Relation: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;relation&#x27;</span>]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Description: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;description&#x27;</span>]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Email: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;email&#x27;</span>]}</span>&quot;</span>
        ]),
        metadata={<span class="hljs-string">&quot;name&quot;</span>: guest[<span class="hljs-string">&quot;name&quot;</span>]}
    )
    <span class="hljs-keyword">for</span> guest <span class="hljs-keyword">in</span> guest_dataset
]
`,wrap:!1}}),{c(){i=m("p"),i.innerHTML=j,p=u(),h(d.$$.fragment)},l(o){i=U(o,"P",{"data-svelte-h":!0}),J(i)!=="svelte-1pw5s05"&&(i.innerHTML=j),p=M(o),C(d.$$.fragment,o)},m(o,l){t(o,i,l),t(o,p,l),I(d,o,l),y=!0},p:x,i(o){y||(v(d.$$.fragment,o),y=!0)},o(o){Z(d.$$.fragment,o),y=!1},d(o){o&&(s(i),s(p)),g(d,o)}}}function ns(G){let i,j="Nous utiliserons la bibliothèque <code>datasets</code> d’Hugging Face pour charger le jeu de données et le convertir en une liste d’objets <code>Document</code> du module <code>llama_index.core.schema</code>.",p,d,y;return d=new V({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEFmcm9tJTIwbGxhbWFfaW5kZXguY29yZS5zY2hlbWElMjBpbXBvcnQlMjBEb2N1bWVudCUwQSUwQSUyMyUyMENoYXJnZXIlMjBsZSUyMGpldSUyMGRlJTIwZG9ubiVDMyVBOWVzJTBBZ3Vlc3RfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJhZ2VudHMtY291cnNlJTJGdW5pdDMtaW52aXRlZXMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQSUyMyUyMENvbnZlcnRpciUyMGxlcyUyMGVudHIlQzMlQTllcyUyMGR1JTIwamV1JTIwZGUlMjBkb25uJUMzJUE5ZXMlMjBlbiUyMG9iamV0cyUyMERvY3VtZW50JTBBZG9jcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMERvY3VtZW50KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHQlM0QlMjIlNUNuJTIyLmpvaW4oJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMk5hbWUlM0ElMjAlN0JndWVzdF9kYXRhc2V0JTVCJ25hbWUnJTVEJTVCaSU1RCU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjJSZWxhdGlvbiUzQSUyMCU3Qmd1ZXN0X2RhdGFzZXQlNUIncmVsYXRpb24nJTVEJTVCaSU1RCU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjJEZXNjcmlwdGlvbiUzQSUyMCU3Qmd1ZXN0X2RhdGFzZXQlNUInZGVzY3JpcHRpb24nJTVEJTVCaSU1RCU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjJFbWFpbCUzQSUyMCU3Qmd1ZXN0X2RhdGFzZXQlNUInZW1haWwnJTVEJTVCaSU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRhZGF0YSUzRCU3QiUyMm5hbWUlMjIlM0ElMjBndWVzdF9kYXRhc2V0JTVCJ25hbWUnJTVEJTVCaSU1RCU3RCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oZ3Vlc3RfZGF0YXNldCkpJTBBJTVE",highlighted:`<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">from</span> llama_index.core.schema <span class="hljs-keyword">import</span> Document

<span class="hljs-comment"># Charger le jeu de données</span>
guest_dataset = datasets.load_dataset(<span class="hljs-string">&quot;agents-course/unit3-invitees&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-comment"># Convertir les entrées du jeu de données en objets Document</span>
docs = [
    Document(
        text=<span class="hljs-string">&quot;\\n&quot;</span>.join([
            <span class="hljs-string">f&quot;Name: <span class="hljs-subst">{guest_dataset[<span class="hljs-string">&#x27;name&#x27;</span>][i]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Relation: <span class="hljs-subst">{guest_dataset[<span class="hljs-string">&#x27;relation&#x27;</span>][i]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Description: <span class="hljs-subst">{guest_dataset[<span class="hljs-string">&#x27;description&#x27;</span>][i]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Email: <span class="hljs-subst">{guest_dataset[<span class="hljs-string">&#x27;email&#x27;</span>][i]}</span>&quot;</span>
        ]),
        metadata={<span class="hljs-string">&quot;name&quot;</span>: guest_dataset[<span class="hljs-string">&#x27;name&#x27;</span>][i]}
    )
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(guest_dataset))
]`,wrap:!1}}),{c(){i=m("p"),i.innerHTML=j,p=u(),h(d.$$.fragment)},l(o){i=U(o,"P",{"data-svelte-h":!0}),J(i)!=="svelte-8hk7d2"&&(i.innerHTML=j),p=M(o),C(d.$$.fragment,o)},m(o,l){t(o,i,l),t(o,p,l),I(d,o,l),y=!0},p:x,i(o){y||(v(d.$$.fragment,o),y=!0)},o(o){Z(d.$$.fragment,o),y=!1},d(o){o&&(s(i),s(p)),g(d,o)}}}function as(G){let i,j="Nous utiliserons la bibliothèque <code>datasets</code> d’Hugging Face pour charger le jeu de données et le convertir en une liste d’objets <code>Document</code> du module <code>langchain.docstore.document</code>.",p,d,y;return d=new V({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEFmcm9tJTIwbGFuZ2NoYWluX2NvcmUuZG9jdW1lbnRzJTIwaW1wb3J0JTIwRG9jdW1lbnQlMEElMEElMjMlMjBDaGFyZ2VyJTIwbGUlMjBqZXUlMjBkZSUyMGRvbm4lQzMlQTllcyUwQWd1ZXN0X2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0cy5sb2FkX2RhdGFzZXQoJTIyYWdlbnRzLWNvdXJzZSUyRnVuaXQzLWludml0ZWVzJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEElMEElMjMlMjBDb252ZXJ0aXIlMjBsZXMlMjBlbnRyJUMzJUE5ZXMlMjBkdSUyMGpldSUyMGRlJTIwZG9ubiVDMyVBOWVzJTIwZW4lMjBvYmpldHMlMjBEb2N1bWVudCUwQWRvY3MlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBEb2N1bWVudCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYWdlX2NvbnRlbnQlM0QlMjIlNUNuJTIyLmpvaW4oJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMk5hbWUlM0ElMjAlN0JndWVzdCU1QiduYW1lJyU1RCU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjJSZWxhdGlvbiUzQSUyMCU3Qmd1ZXN0JTVCJ3JlbGF0aW9uJyU1RCU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjJEZXNjcmlwdGlvbiUzQSUyMCU3Qmd1ZXN0JTVCJ2Rlc2NyaXB0aW9uJyU1RCU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjJFbWFpbCUzQSUyMCU3Qmd1ZXN0JTVCJ2VtYWlsJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRhZGF0YSUzRCU3QiUyMm5hbWUlMjIlM0ElMjBndWVzdCU1QiUyMm5hbWUlMjIlNUQlN0QlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwZm9yJTIwZ3Vlc3QlMjBpbiUyMGd1ZXN0X2RhdGFzZXQlMEElNUQ=",highlighted:`<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">from</span> langchain_core.documents <span class="hljs-keyword">import</span> Document

<span class="hljs-comment"># Charger le jeu de données</span>
guest_dataset = datasets.load_dataset(<span class="hljs-string">&quot;agents-course/unit3-invitees&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-comment"># Convertir les entrées du jeu de données en objets Document</span>
docs = [
    Document(
        page_content=<span class="hljs-string">&quot;\\n&quot;</span>.join([
            <span class="hljs-string">f&quot;Name: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;name&#x27;</span>]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Relation: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;relation&#x27;</span>]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Description: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;description&#x27;</span>]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Email: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;email&#x27;</span>]}</span>&quot;</span>
        ]),
        metadata={<span class="hljs-string">&quot;name&quot;</span>: guest[<span class="hljs-string">&quot;name&quot;</span>]}
    )
    <span class="hljs-keyword">for</span> guest <span class="hljs-keyword">in</span> guest_dataset
]`,wrap:!1}}),{c(){i=m("p"),i.innerHTML=j,p=u(),h(d.$$.fragment)},l(o){i=U(o,"P",{"data-svelte-h":!0}),J(i)!=="svelte-1pw5s05"&&(i.innerHTML=j),p=M(o),C(d.$$.fragment,o)},m(o,l){t(o,i,l),t(o,p,l),I(d,o,l),y=!0},p:x,i(o){y||(v(d.$$.fragment,o),y=!0)},o(o){Z(d.$$.fragment,o),y=!1},d(o){o&&(s(i),s(p)),g(d,o)}}}function is(G){let i,j,p,d,y,o;return i=new k({props:{id:"agents-frameworks",option:"smolagents",$$slots:{default:[ts]},$$scope:{ctx:G}}}),p=new k({props:{id:"agents-frameworks",option:"llama-index",$$slots:{default:[ns]},$$scope:{ctx:G}}}),y=new k({props:{id:"agents-frameworks",option:"langgraph",$$slots:{default:[as]},$$scope:{ctx:G}}}),{c(){h(i.$$.fragment),j=u(),h(p.$$.fragment),d=u(),h(y.$$.fragment)},l(l){C(i.$$.fragment,l),j=M(l),C(p.$$.fragment,l),d=M(l),C(y.$$.fragment,l)},m(l,c){I(i,l,c),t(l,j,c),I(p,l,c),t(l,d,c),I(y,l,c),o=!0},p(l,c){const T={};c&2&&(T.$$scope={dirty:c,ctx:l}),i.$set(T);const f={};c&2&&(f.$$scope={dirty:c,ctx:l}),p.$set(f);const w={};c&2&&(w.$$scope={dirty:c,ctx:l}),y.$set(w)},i(l){o||(v(i.$$.fragment,l),v(p.$$.fragment,l),v(y.$$.fragment,l),o=!0)},o(l){Z(i.$$.fragment,l),Z(p.$$.fragment,l),Z(y.$$.fragment,l),o=!1},d(l){l&&(s(j),s(d)),g(i,l),g(p,l),g(y,l)}}}function rs(G){let i,j="Nous utiliserons le <code>BM25Retriever</code> du module <code>langchain_community.retrievers</code> pour créer un outil de récupération.",p,d,y='<p>Le <code>BM25Retriever</code> est un excellent point de départ pour la récupération, mais pour une recherche sémantique plus avancée, vous pourriez considérer l’utilisation de récupérateurs basés sur des <i>embeddings</i> comme ceux de <a href="https://www.sbert.net/">sentence-transformers</a>.</p>',o,l,c,T,f="Comprenons cet outil étape par étape :",w,b,Q="<li>Le <code>name</code> et la <code>description</code> aident l’agent à comprendre quand et comment utiliser cet outil</li> <li>Les <code>inputs</code> définissent quels paramètres l’outil attend (dans ce cas, une requête de recherche)</li> <li>Nous utilisons un <code>BM25Retriever</code>, qui est un algorithme de récupération de texte puissant qui ne nécessite pas d’<em>embeddings</em></li> <li>La méthode <code>forward</code> traite la requête et retourne les informations d’invité les plus pertinentes</li>",a;return l=new V({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBZnJvbSUyMGxhbmdjaGFpbl9jb21tdW5pdHkucmV0cmlldmVycyUyMGltcG9ydCUyMEJNMjVSZXRyaWV2ZXIlMEElMEFjbGFzcyUyMEd1ZXN0SW5mb1JldHJpZXZlclRvb2woVG9vbCklM0ElMEElMjAlMjAlMjAlMjBuYW1lJTIwJTNEJTIwJTIyZ3Vlc3RfaW5mb19yZXRyaWV2ZXIlMjIlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUyMCUzRCUyMCUyMlIlQzMlQTljdXAlQzMlQThyZSUyMGRlcyUyMGluZm9ybWF0aW9ucyUyMGQlQzMlQTl0YWlsbCVDMyVBOWVzJTIwc3VyJTIwbGVzJTIwaW52aXQlQzMlQTlzJTIwZHUlMjBnYWxhJTIwYmFzJUMzJUE5ZXMlMjBzdXIlMjBsZXVyJTIwbm9tJTIwb3UlMjByZWxhdGlvbi4lMjIlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJxdWVyeSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJzdHJpbmclMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkZXNjcmlwdGlvbiUyMiUzQSUyMCUyMkxlJTIwbm9tJTIwb3UlMjBsYSUyMHJlbGF0aW9uJTIwZGUlMjBsJ2ludml0JUMzJUE5JTIwc3VyJTIwbGVxdWVsJTIwdm91cyUyMHZvdWxleiUyMGRlcyUyMGluZm9ybWF0aW9ucy4lMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUyMCUzRCUyMCUyMnN0cmluZyUyMiUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBkb2NzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaXNfaW5pdGlhbGl6ZWQlMjAlM0QlMjBGYWxzZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYucmV0cmlldmVyJTIwJTNEJTIwQk0yNVJldHJpZXZlci5mcm9tX2RvY3VtZW50cyhkb2NzKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHF1ZXJ5JTNBJTIwc3RyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBzZWxmLnJldHJpZXZlci5nZXRfcmVsZXZhbnRfZG9jdW1lbnRzKHF1ZXJ5KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwcmVzdWx0cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMiU1Q24lNUNuJTIyLmpvaW4oJTVCZG9jLnBhZ2VfY29udGVudCUyMGZvciUyMGRvYyUyMGluJTIwcmVzdWx0cyU1QiUzQTMlNUQlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMkF1Y3VuZSUyMGluZm9ybWF0aW9uJTIwZCdpbnZpdCVDMyVBOSUyMGNvcnJlc3BvbmRhbnRlJTIwdHJvdXYlQzMlQTllLiUyMiUwQSUwQSUyMyUyMEluaXRpYWxpc2VyJTIwbCdvdXRpbCUwQWd1ZXN0X2luZm9fdG9vbCUyMCUzRCUyMEd1ZXN0SW5mb1JldHJpZXZlclRvb2woZG9jcyk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_community.retrievers <span class="hljs-keyword">import</span> BM25Retriever

<span class="hljs-keyword">class</span> <span class="hljs-title class_">GuestInfoRetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;guest_info_retriever&quot;</span>
    description = <span class="hljs-string">&quot;Récupère des informations détaillées sur les invités du gala basées sur leur nom ou relation.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Le nom ou la relation de l&#x27;invité sur lequel vous voulez des informations.&quot;</span>
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, docs</span>):
        self.is_initialized = <span class="hljs-literal">False</span>
        self.retriever = BM25Retriever.from_documents(docs)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>):
        results = self.retriever.get_relevant_documents(query)
        <span class="hljs-keyword">if</span> results:
            <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> results[:<span class="hljs-number">3</span>]])
        <span class="hljs-keyword">else</span>:
            <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Aucune information d&#x27;invité correspondante trouvée.&quot;</span>

<span class="hljs-comment"># Initialiser l&#x27;outil</span>
guest_info_tool = GuestInfoRetrieverTool(docs)`,wrap:!1}}),{c(){i=m("p"),i.innerHTML=j,p=u(),d=m("blockquote"),d.innerHTML=y,o=u(),h(l.$$.fragment),c=u(),T=m("p"),T.textContent=f,w=u(),b=m("ul"),b.innerHTML=Q,this.h()},l(n){i=U(n,"P",{"data-svelte-h":!0}),J(i)!=="svelte-1j0ijm9"&&(i.innerHTML=j),p=M(n),d=U(n,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),J(d)!=="svelte-1ttnypg"&&(d.innerHTML=y),o=M(n),C(l.$$.fragment,n),c=M(n),T=U(n,"P",{"data-svelte-h":!0}),J(T)!=="svelte-1gxhttu"&&(T.textContent=f),w=M(n),b=U(n,"UL",{"data-svelte-h":!0}),J(b)!=="svelte-dak8da"&&(b.innerHTML=Q),this.h()},h(){$(d,"class","tip")},m(n,B){t(n,i,B),t(n,p,B),t(n,d,B),t(n,o,B),I(l,n,B),t(n,c,B),t(n,T,B),t(n,w,B),t(n,b,B),a=!0},p:x,i(n){a||(v(l.$$.fragment,n),a=!0)},o(n){Z(l.$$.fragment,n),a=!1},d(n){n&&(s(i),s(p),s(d),s(o),s(c),s(T),s(w),s(b)),g(l,n)}}}function os(G){let i,j="Nous utiliserons le <code>BM25Retriever</code> du module <code>llama_index.retrievers.bm25</code> pour créer un outil de récupération.",p,d,y='<p>Le <code>BM25Retriever</code> est un excellent point de départ pour la récupération, mais pour une recherche sémantique plus avancée, vous pourriez considérer l’utilisation de récupérateurs basés sur des <em>embeddings</em> comme ceux de <a href="https://www.sbert.net/">sentence-transformers</a>.</p>',o,l,c,T,f="Comprenons cet outil étape par étape :",w,b,Q="<li>La <em>docstring</em> aide l’agent à comprendre quand et comment utiliser cet outil</li> <li>Les décorateurs de type définissent quels paramètres l’outil attend (dans ce cas, une requête de recherche)</li> <li>Nous utilisons un <code>BM25Retriever</code>, qui est un algorithme de récupération de texte puissant qui ne nécessite pas d’<em>embeddings</em></li> <li>La méthode traite la requête et retourne les informations d’invité les plus pertinentes</li>",a;return l=new V({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUudG9vbHMlMjBpbXBvcnQlMjBGdW5jdGlvblRvb2wlMEFmcm9tJTIwbGxhbWFfaW5kZXgucmV0cmlldmVycy5ibTI1JTIwaW1wb3J0JTIwQk0yNVJldHJpZXZlciUwQSUwQWJtMjVfcmV0cmlldmVyJTIwJTNEJTIwQk0yNVJldHJpZXZlci5mcm9tX2RlZmF1bHRzKG5vZGVzJTNEZG9jcyklMEElMEFkZWYlMjBnZXRfZ3Vlc3RfaW5mb19yZXRyaWV2ZXIocXVlcnklM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMlIlQzMlQTljdXAlQzMlQThyZSUyMGRlcyUyMGluZm9ybWF0aW9ucyUyMGQlQzMlQTl0YWlsbCVDMyVBOWVzJTIwc3VyJTIwbGVzJTIwaW52aXQlQzMlQTlzJTIwZHUlMjBnYWxhJTIwYmFzJUMzJUE5ZXMlMjBzdXIlMjBsZXVyJTIwbm9tJTIwb3UlMjByZWxhdGlvbi4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXN1bHRzJTIwJTNEJTIwYm0yNV9yZXRyaWV2ZXIucmV0cmlldmUocXVlcnkpJTBBJTIwJTIwJTIwJTIwaWYlMjByZXN1bHRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyJTVDbiU1Q24lMjIuam9pbiglNUJkb2MudGV4dCUyMGZvciUyMGRvYyUyMGluJTIwcmVzdWx0cyU1QiUzQTMlNUQlNUQpJTBBJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMkF1Y3VuZSUyMGluZm9ybWF0aW9uJTIwZCdpbnZpdCVDMyVBOSUyMGNvcnJlc3BvbmRhbnRlJTIwdHJvdXYlQzMlQTllLiUyMiUwQSUwQSUyMyUyMEluaXRpYWxpc2VyJTIwbCdvdXRpbCUwQWd1ZXN0X2luZm9fdG9vbCUyMCUzRCUyMEZ1bmN0aW9uVG9vbC5mcm9tX2RlZmF1bHRzKGdldF9ndWVzdF9pbmZvX3JldHJpZXZlcik=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.tools <span class="hljs-keyword">import</span> FunctionTool
<span class="hljs-keyword">from</span> llama_index.retrievers.bm25 <span class="hljs-keyword">import</span> BM25Retriever

bm25_retriever = BM25Retriever.from_defaults(nodes=docs)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_guest_info_retriever</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Récupère des informations détaillées sur les invités du gala basées sur leur nom ou relation.&quot;&quot;&quot;</span>
    results = bm25_retriever.retrieve(query)
    <span class="hljs-keyword">if</span> results:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([doc.text <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> results[:<span class="hljs-number">3</span>]])
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Aucune information d&#x27;invité correspondante trouvée.&quot;</span>

<span class="hljs-comment"># Initialiser l&#x27;outil</span>
guest_info_tool = FunctionTool.from_defaults(get_guest_info_retriever)`,wrap:!1}}),{c(){i=m("p"),i.innerHTML=j,p=u(),d=m("blockquote"),d.innerHTML=y,o=u(),h(l.$$.fragment),c=u(),T=m("p"),T.textContent=f,w=u(),b=m("ul"),b.innerHTML=Q,this.h()},l(n){i=U(n,"P",{"data-svelte-h":!0}),J(i)!=="svelte-13v4bfa"&&(i.innerHTML=j),p=M(n),d=U(n,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),J(d)!=="svelte-a5avfa"&&(d.innerHTML=y),o=M(n),C(l.$$.fragment,n),c=M(n),T=U(n,"P",{"data-svelte-h":!0}),J(T)!=="svelte-1gxhttu"&&(T.textContent=f),w=M(n),b=U(n,"UL",{"data-svelte-h":!0}),J(b)!=="svelte-11si3ct"&&(b.innerHTML=Q),this.h()},h(){$(d,"class","tip")},m(n,B){t(n,i,B),t(n,p,B),t(n,d,B),t(n,o,B),I(l,n,B),t(n,c,B),t(n,T,B),t(n,w,B),t(n,b,B),a=!0},p:x,i(n){a||(v(l.$$.fragment,n),a=!0)},o(n){Z(l.$$.fragment,n),a=!1},d(n){n&&(s(i),s(p),s(d),s(o),s(c),s(T),s(w),s(b)),g(l,n)}}}function ps(G){let i,j="Nous utiliserons le <code>BM25Retriever</code> du module <code>langchain_community.retrievers</code> pour créer un outil de récupération.",p,d,y='<p>Le <code>BM25Retriever</code> est un excellent point de départ pour la récupération, mais pour une recherche sémantique plus avancée, vous pourriez considérer l’utilisation de récupérateurs basés sur des <em>embeddings</em> comme ceux de <a href="https://www.sbert.net/">sentence-transformers</a>.</p>',o,l,c,T,f="Comprenons cet outil étape par étape :",w,b,Q="<li>Le <code>name</code> et la <code>description</code> aident l’agent à comprendre quand et comment utiliser cet outil</li> <li>Les décorateurs de type définissent quels paramètres l’outil attend (dans ce cas, une requête de recherche)</li> <li>Nous utilisons un <code>BM25Retriever</code>, qui est un algorithme de récupération de texte puissant qui ne nécessite pas d’<em>embeddings</em></li> <li>La méthode traite la requête et retourne les informations d’invité les plus pertinentes</li>",a;return l=new V({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb21tdW5pdHkucmV0cmlldmVycyUyMGltcG9ydCUyMEJNMjVSZXRyaWV2ZXIlMEFmcm9tJTIwbGFuZ2NoYWluLnRvb2xzJTIwaW1wb3J0JTIwVG9vbCUwQSUwQWJtMjVfcmV0cmlldmVyJTIwJTNEJTIwQk0yNVJldHJpZXZlci5mcm9tX2RvY3VtZW50cyhkb2NzKSUwQSUwQWRlZiUyMGV4dHJhY3RfdGV4dChxdWVyeSUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyUiVDMyVBOWN1cCVDMyVBOHJlJTIwZGVzJTIwaW5mb3JtYXRpb25zJTIwZCVDMyVBOXRhaWxsJUMzJUE5ZXMlMjBzdXIlMjBsZXMlMjBpbnZpdCVDMyVBOXMlMjBkdSUyMGdhbGElMjBiYXMlQzMlQTllcyUyMHN1ciUyMGxldXIlMjBub20lMjBvdSUyMHJlbGF0aW9uLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBibTI1X3JldHJpZXZlci5pbnZva2UocXVlcnkpJTBBJTIwJTIwJTIwJTIwaWYlMjByZXN1bHRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyJTVDbiU1Q24lMjIuam9pbiglNUJkb2MucGFnZV9jb250ZW50JTIwZm9yJTIwZG9jJTIwaW4lMjByZXN1bHRzJTVCJTNBMyU1RCU1RCklMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyQXVjdW5lJTIwaW5mb3JtYXRpb24lMjBkJ2ludml0JUMzJUE5JTIwY29ycmVzcG9uZGFudGUlMjB0cm91diVDMyVBOWUuJTIyJTBBJTBBZ3Vlc3RfaW5mb190b29sJTIwJTNEJTIwVG9vbCglMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyZ3Vlc3RfaW5mb19yZXRyaWV2ZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBmdW5jJTNEZXh0cmFjdF90ZXh0JTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJSJUMzJUE5Y3VwJUMzJUE4cmUlMjBkZXMlMjBpbmZvcm1hdGlvbnMlMjBkJUMzJUE5dGFpbGwlQzMlQTllcyUyMHN1ciUyMGxlcyUyMGludml0JUMzJUE5cyUyMGR1JTIwZ2FsYSUyMGJhcyVDMyVBOWVzJTIwc3VyJTIwbGV1ciUyMG5vbSUyMG91JTIwcmVsYXRpb24uJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain_community.retrievers <span class="hljs-keyword">import</span> BM25Retriever
<span class="hljs-keyword">from</span> langchain.tools <span class="hljs-keyword">import</span> Tool

bm25_retriever = BM25Retriever.from_documents(docs)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_text</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Récupère des informations détaillées sur les invités du gala basées sur leur nom ou relation.&quot;&quot;&quot;</span>
    results = bm25_retriever.invoke(query)
    <span class="hljs-keyword">if</span> results:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> results[:<span class="hljs-number">3</span>]])
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Aucune information d&#x27;invité correspondante trouvée.&quot;</span>

guest_info_tool = Tool(
    name=<span class="hljs-string">&quot;guest_info_retriever&quot;</span>,
    func=extract_text,
    description=<span class="hljs-string">&quot;Récupère des informations détaillées sur les invités du gala basées sur leur nom ou relation.&quot;</span>
)`,wrap:!1}}),{c(){i=m("p"),i.innerHTML=j,p=u(),d=m("blockquote"),d.innerHTML=y,o=u(),h(l.$$.fragment),c=u(),T=m("p"),T.textContent=f,w=u(),b=m("ul"),b.innerHTML=Q,this.h()},l(n){i=U(n,"P",{"data-svelte-h":!0}),J(i)!=="svelte-1j0ijm9"&&(i.innerHTML=j),p=M(n),d=U(n,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),J(d)!=="svelte-a5avfa"&&(d.innerHTML=y),o=M(n),C(l.$$.fragment,n),c=M(n),T=U(n,"P",{"data-svelte-h":!0}),J(T)!=="svelte-1gxhttu"&&(T.textContent=f),w=M(n),b=U(n,"UL",{"data-svelte-h":!0}),J(b)!=="svelte-wlttn0"&&(b.innerHTML=Q),this.h()},h(){$(d,"class","tip")},m(n,B){t(n,i,B),t(n,p,B),t(n,d,B),t(n,o,B),I(l,n,B),t(n,c,B),t(n,T,B),t(n,w,B),t(n,b,B),a=!0},p:x,i(n){a||(v(l.$$.fragment,n),a=!0)},o(n){Z(l.$$.fragment,n),a=!1},d(n){n&&(s(i),s(p),s(d),s(o),s(c),s(T),s(w),s(b)),g(l,n)}}}function us(G){let i,j,p,d,y,o;return i=new k({props:{id:"agents-frameworks",option:"smolagents",$$slots:{default:[rs]},$$scope:{ctx:G}}}),p=new k({props:{id:"agents-frameworks",option:"llama-index",$$slots:{default:[os]},$$scope:{ctx:G}}}),y=new k({props:{id:"agents-frameworks",option:"langgraph",$$slots:{default:[ps]},$$scope:{ctx:G}}}),{c(){h(i.$$.fragment),j=u(),h(p.$$.fragment),d=u(),h(y.$$.fragment)},l(l){C(i.$$.fragment,l),j=M(l),C(p.$$.fragment,l),d=M(l),C(y.$$.fragment,l)},m(l,c){I(i,l,c),t(l,j,c),I(p,l,c),t(l,d,c),I(y,l,c),o=!0},p(l,c){const T={};c&2&&(T.$$scope={dirty:c,ctx:l}),i.$set(T);const f={};c&2&&(f.$$scope={dirty:c,ctx:l}),p.$set(f);const w={};c&2&&(w.$$scope={dirty:c,ctx:l}),y.$set(w)},i(l){o||(v(i.$$.fragment,l),v(p.$$.fragment,l),v(y.$$.fragment,l),o=!0)},o(l){Z(i.$$.fragment,l),Z(p.$$.fragment,l),Z(y.$$.fragment,l),o=!1},d(l){l&&(s(j),s(d)),g(i,l),g(p,l),g(y,l)}}}function Ms(G){let i,j,p,d="Sortie attendue :",y,o,l,c,T="Ce qui se passe dans cette étape finale :",f,w,b="<li>Nous initialisons un modèle Hugging Face en utilisant la classe <code>InferenceClientModel</code></li> <li>Nous créons notre agent (Alfred) comme un <code>CodeAgent</code>, qui peut exécuter du code Python pour résoudre des problèmes</li> <li>Nous demandons à Alfred de récupérer des informations sur une invitée nommée “Lady Ada Lovelace”</li>",Q;return i=new V({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpc2VyJTIwbGUlMjBtb2QlQzMlQThsZSUyMEh1Z2dpbmclMjBGYWNlJTBBbW9kZWwlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBJTBBJTIzJTIwQ3IlQzMlQTllciUyMEFsZnJlZCUyQyUyMG5vdHJlJTIwYWdlbnQlMjBkZSUyMGdhbGElMkMlMjBhdmVjJTIwbCdvdXRpbCUyMGQnaW5mb3JtYXRpb25zJTIwc3VyJTIwbGVzJTIwaW52aXQlQzMlQTlzJTBBYWxmcmVkJTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCZ3Vlc3RfaW5mb190b29sJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCklMEElMEElMjMlMjBFeGVtcGxlJTIwZGUlMjByZXF1JUMzJUFBdGUlMjBxdSdBbGZyZWQlMjBwb3VycmFpdCUyMHJlY2V2b2lyJTIwcGVuZGFudCUyMGxlJTIwZ2FsYSUwQXJlc3BvbnNlJTIwJTNEJTIwYWxmcmVkLnJ1biglMjJQYXJsZXotbW9pJTIwZGUlMjBub3RyZSUyMGludml0JUMzJUE5ZSUyMG5vbW0lQzMlQTllJTIwJ0xhZHklMjBBZGElMjBMb3ZlbGFjZScuJTIyKSUwQSUwQXByaW50KCUyMiVGMCU5RiU4RSVBOSUyMFIlQzMlQTlwb25zZSUyMGQnQWxmcmVkJTIwJTNBJTIyKSUwQXByaW50KHJlc3BvbnNlKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

<span class="hljs-comment"># Initialiser le modèle Hugging Face</span>
model = InferenceClientModel()

<span class="hljs-comment"># Créer Alfred, notre agent de gala, avec l&#x27;outil d&#x27;informations sur les invités</span>
alfred = CodeAgent(tools=[guest_info_tool], model=model)

<span class="hljs-comment"># Exemple de requête qu&#x27;Alfred pourrait recevoir pendant le gala</span>
response = alfred.run(<span class="hljs-string">&quot;Parlez-moi de notre invitée nommée &#x27;Lady Ada Lovelace&#x27;.&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🎩 Réponse d&#x27;Alfred :&quot;</span>)
<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),o=new V({props:{code:"JUYwJTlGJThFJUE5JTIwUiVDMyVBOXBvbnNlJTIwZCdBbGZyZWQlMjAlM0ElMEFCYXMlQzMlQTklMjBzdXIlMjBsZXMlMjBpbmZvcm1hdGlvbnMlMjBxdWUlMjBqJ2FpJTIwciVDMyVBOWN1cCVDMyVBOXIlQzMlQTllcyUyQyUyMExhZHklMjBBZGElMjBMb3ZlbGFjZSUyMGVzdCUyMHVuZSUyMG1hdGglQzMlQTltYXRpY2llbm5lJTIwZXN0aW0lQzMlQTllJTIwZXQlMjB1bmUlMjBhbWllLiUyMEVsbGUlMjBlc3QlMjByZW5vbW0lQzMlQTllJTIwcG91ciUyMHNvbiUyMHRyYXZhaWwlMjBwaW9ubmllciUyMGVuJTIwbWF0aCVDMyVBOW1hdGlxdWVzJTIwZXQlMjBlbiUyMGluZm9ybWF0aXF1ZSUyQyUyMHNvdXZlbnQlMjBjJUMzJUE5bCVDMyVBOWJyJUMzJUE5ZSUyMGNvbW1lJTIwbGElMjBwcmVtaSVDMyVBOHJlJTIwcHJvZ3JhbW1ldXNlJTIwaW5mb3JtYXRpcXVlJTIwZW4lMjByYWlzb24lMjBkZSUyMHNvbiUyMHRyYXZhaWwlMjBzdXIlMjBsYSUyMG1hY2hpbmUlMjBhbmFseXRpcXVlJTIwZGUlMjBDaGFybGVzJTIwQmFiYmFnZS4lMjBTb24lMjBhZHJlc3NlJTIwZW1haWwlMjBlc3QlMjBhZGEubG92ZWxhY2UlNDBleGFtcGxlLmNvbS4=",highlighted:`🎩 Réponse <span class="hljs-keyword">d</span>&#x27;Alfred :
Basé sur les informations <span class="hljs-keyword">que</span> j&#x27;ai récupérées, Lady Ada Lovelace <span class="hljs-keyword">est</span> une mathématicienne estimé<span class="hljs-keyword">e</span> et une amie. Elle <span class="hljs-keyword">est</span> renommé<span class="hljs-keyword">e</span> pour son travail pionnier <span class="hljs-keyword">en</span> mathématiques et <span class="hljs-keyword">en</span> informatique, souvent cé<span class="hljs-keyword">l</span>é<span class="hljs-keyword">br</span>é<span class="hljs-keyword">e</span> comme <span class="hljs-keyword">la</span> première programmeuse informatique <span class="hljs-keyword">en</span> raison <span class="hljs-keyword">de</span> son travail sur <span class="hljs-keyword">la</span> machine analytique <span class="hljs-keyword">de</span> Charles Babbage. Son adresse email <span class="hljs-keyword">est</span> ada.lovelace@example.com.`,wrap:!1}}),{c(){h(i.$$.fragment),j=u(),p=m("p"),p.textContent=d,y=u(),h(o.$$.fragment),l=u(),c=m("p"),c.textContent=T,f=u(),w=m("ul"),w.innerHTML=b},l(a){C(i.$$.fragment,a),j=M(a),p=U(a,"P",{"data-svelte-h":!0}),J(p)!=="svelte-cs180i"&&(p.textContent=d),y=M(a),C(o.$$.fragment,a),l=M(a),c=U(a,"P",{"data-svelte-h":!0}),J(c)!=="svelte-32t9d6"&&(c.textContent=T),f=M(a),w=U(a,"UL",{"data-svelte-h":!0}),J(w)!=="svelte-kfvah9"&&(w.innerHTML=b)},m(a,n){I(i,a,n),t(a,j,n),t(a,p,n),t(a,y,n),I(o,a,n),t(a,l,n),t(a,c,n),t(a,f,n),t(a,w,n),Q=!0},p:x,i(a){Q||(v(i.$$.fragment,a),v(o.$$.fragment,a),Q=!0)},o(a){Z(i.$$.fragment,a),Z(o.$$.fragment,a),Q=!1},d(a){a&&(s(j),s(p),s(y),s(l),s(c),s(f),s(w)),g(i,a),g(o,a)}}}function cs(G){let i,j,p,d="Sortie attendue :",y,o,l,c,T="Ce qui se passe dans cette étape finale :",f,w,b="<li>Nous initialisons un modèle Hugging Face en utilisant la classe <code>HuggingFaceInferenceAPI</code></li> <li>Nous créons notre agent (Alfred) comme un <code>AgentWorkflow</code>, incluant l’outil que nous venons de créer</li> <li>Nous demandons à Alfred de récupérer des informations sur une invitée nommée “Lady Ada Lovelace”</li>",Q;return i=new V({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUuYWdlbnQud29ya2Zsb3clMjBpbXBvcnQlMjBBZ2VudFdvcmtmbG93JTBBZnJvbSUyMGxsYW1hX2luZGV4LmxsbXMuaHVnZ2luZ2ZhY2VfYXBpJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VJbmZlcmVuY2VBUEklMEElMEElMjMlMjBJbml0aWFsaXNlciUyMGxlJTIwbW9kJUMzJUE4bGUlMjBIdWdnaW5nJTIwRmFjZSUwQWxsbSUyMCUzRCUyMEh1Z2dpbmdGYWNlSW5mZXJlbmNlQVBJKG1vZGVsX25hbWUlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBJTBBJTIzJTIwQ3IlQzMlQTllciUyMEFsZnJlZCUyQyUyMG5vdHJlJTIwYWdlbnQlMjBkZSUyMGdhbGElMkMlMjBhdmVjJTIwbCdvdXRpbCUyMGQnaW5mb3JtYXRpb25zJTIwc3VyJTIwbGVzJTIwaW52aXQlQzMlQTlzJTBBYWxmcmVkJTIwJTNEJTIwQWdlbnRXb3JrZmxvdy5mcm9tX3Rvb2xzX29yX2Z1bmN0aW9ucyglMEElMjAlMjAlMjAlMjAlNUJndWVzdF9pbmZvX3Rvb2wlNUQlMkMlMEElMjAlMjAlMjAlMjBsbG0lM0RsbG0lMkMlMEEpJTBBJTBBJTIzJTIwRXhlbXBsZSUyMGRlJTIwcmVxdSVDMyVBQXRlJTIwcXUnQWxmcmVkJTIwcG91cnJhaXQlMjByZWNldm9pciUyMHBlbmRhbnQlMjBsZSUyMGdhbGElMEFyZXNwb25zZSUyMCUzRCUyMGF3YWl0JTIwYWxmcmVkLnJ1biglMjJQYXJsZXotbW9pJTIwZGUlMjBub3RyZSUyMGludml0JUMzJUE5ZSUyMG5vbW0lQzMlQTllJTIwJ0xhZHklMjBBZGElMjBMb3ZlbGFjZScuJTIyKSUwQSUwQXByaW50KCUyMiVGMCU5RiU4RSVBOSUyMFIlQzMlQTlwb25zZSUyMGQnQWxmcmVkJTIwJTNBJTIyKSUwQXByaW50KHJlc3BvbnNlKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.agent.workflow <span class="hljs-keyword">import</span> AgentWorkflow
<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

<span class="hljs-comment"># Initialiser le modèle Hugging Face</span>
llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

<span class="hljs-comment"># Créer Alfred, notre agent de gala, avec l&#x27;outil d&#x27;informations sur les invités</span>
alfred = AgentWorkflow.from_tools_or_functions(
    [guest_info_tool],
    llm=llm,
)

<span class="hljs-comment"># Exemple de requête qu&#x27;Alfred pourrait recevoir pendant le gala</span>
response = <span class="hljs-keyword">await</span> alfred.run(<span class="hljs-string">&quot;Parlez-moi de notre invitée nommée &#x27;Lady Ada Lovelace&#x27;.&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🎩 Réponse d&#x27;Alfred :&quot;</span>)
<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),o=new V({props:{code:"JUYwJTlGJThFJUE5JTIwUiVDMyVBOXBvbnNlJTIwZCdBbGZyZWQlMjAlM0ElMEFMYWR5JTIwQWRhJTIwTG92ZWxhY2UlMjBlc3QlMjB1bmUlMjBtYXRoJUMzJUE5bWF0aWNpZW5uZSUyMGVzdGltJUMzJUE5ZSUyMGV0JTIwYW1pZSUyQyUyMHJlbm9tbSVDMyVBOWUlMjBwb3VyJTIwc29uJTIwdHJhdmFpbCUyMHBpb25uaWVyJTIwZW4lMjBtYXRoJUMzJUE5bWF0aXF1ZXMlMjBldCUyMGVuJTIwaW5mb3JtYXRpcXVlLiUyMEVsbGUlMjBlc3QlMjBjJUMzJUE5bCVDMyVBOWJyJUMzJUE5ZSUyMGNvbW1lJTIwbGElMjBwcmVtaSVDMyVBOHJlJTIwcHJvZ3JhbW1ldXNlJTIwaW5mb3JtYXRpcXVlJTIwZW4lMjByYWlzb24lMjBkZSUyMHNvbiUyMHRyYXZhaWwlMjBzdXIlMjBsYSUyMG1hY2hpbmUlMjBhbmFseXRpcXVlJTIwZGUlMjBDaGFybGVzJTIwQmFiYmFnZS4lMjBTb24lMjBlbWFpbCUyMGVzdCUyMGFkYS5sb3ZlbGFjZSU0MGV4YW1wbGUuY29tLg==",highlighted:`🎩 Réponse <span class="hljs-keyword">d</span>&#x27;Alfred :
Lady Ada Lovelace <span class="hljs-keyword">est</span> une mathématicienne estimé<span class="hljs-keyword">e</span> et amie, renommé<span class="hljs-keyword">e</span> pour son travail pionnier <span class="hljs-keyword">en</span> mathématiques et <span class="hljs-keyword">en</span> informatique. Elle <span class="hljs-keyword">est</span> cé<span class="hljs-keyword">l</span>é<span class="hljs-keyword">br</span>é<span class="hljs-keyword">e</span> comme <span class="hljs-keyword">la</span> première programmeuse informatique <span class="hljs-keyword">en</span> raison <span class="hljs-keyword">de</span> son travail sur <span class="hljs-keyword">la</span> machine analytique <span class="hljs-keyword">de</span> Charles Babbage. Son email <span class="hljs-keyword">est</span> ada.lovelace@example.com.`,wrap:!1}}),{c(){h(i.$$.fragment),j=u(),p=m("p"),p.textContent=d,y=u(),h(o.$$.fragment),l=u(),c=m("p"),c.textContent=T,f=u(),w=m("ul"),w.innerHTML=b},l(a){C(i.$$.fragment,a),j=M(a),p=U(a,"P",{"data-svelte-h":!0}),J(p)!=="svelte-cs180i"&&(p.textContent=d),y=M(a),C(o.$$.fragment,a),l=M(a),c=U(a,"P",{"data-svelte-h":!0}),J(c)!=="svelte-32t9d6"&&(c.textContent=T),f=M(a),w=U(a,"UL",{"data-svelte-h":!0}),J(w)!=="svelte-71tvlf"&&(w.innerHTML=b)},m(a,n){I(i,a,n),t(a,j,n),t(a,p,n),t(a,y,n),I(o,a,n),t(a,l,n),t(a,c,n),t(a,f,n),t(a,w,n),Q=!0},p:x,i(a){Q||(v(i.$$.fragment,a),v(o.$$.fragment,a),Q=!0)},o(a){Z(i.$$.fragment,a),Z(o.$$.fragment,a),Q=!1},d(a){a&&(s(j),s(p),s(y),s(l),s(c),s(f),s(w)),g(i,a),g(o,a)}}}function ds(G){let i,j,p,d="Sortie attendue :",y,o,l,c,T="Ce qui se passe dans cette étape finale :",f,w,b="<li>Nous initialisons un modèle Hugging Face en utilisant la classe <code>HuggingFaceEndpoint</code>. Nous générons aussi une interface de chat et ajoutons les outils.</li> <li>Nous créons notre agent (Alfred) comme un <code>StateGraph</code>, qui combine 2 nœuds (<code>assistant</code>, <code>tools</code>) en utilisant une arête</li> <li>Nous demandons à Alfred de récupérer des informations sur une invitée nommée “Lady Ada Lovelace”</li>",Q;return i=new V({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> TypedDict, Annotated
<span class="hljs-keyword">from</span> langgraph.graph.message <span class="hljs-keyword">import</span> add_messages
<span class="hljs-keyword">from</span> langchain_core.messages <span class="hljs-keyword">import</span> AnyMessage, HumanMessage, AIMessage
<span class="hljs-keyword">from</span> langgraph.prebuilt <span class="hljs-keyword">import</span> ToolNode
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> START, StateGraph
<span class="hljs-keyword">from</span> langgraph.prebuilt <span class="hljs-keyword">import</span> tools_condition
<span class="hljs-keyword">from</span> langchain_huggingface <span class="hljs-keyword">import</span> HuggingFaceEndpoint, ChatHuggingFace

<span class="hljs-comment"># Générer l&#x27;interface de chat, incluant les outils</span>
llm = HuggingFaceEndpoint(
    repo_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>,
    huggingfacehub_api_token=HUGGINGFACEHUB_API_TOKEN,
)

chat = ChatHuggingFace(llm=llm, verbose=<span class="hljs-literal">True</span>)
tools = [guest_info_tool]
chat_with_tools = chat.bind_tools(tools)

<span class="hljs-comment"># Générer l&#x27;AgentState et le graphe d&#x27;agent</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">AgentState</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    messages: Annotated[<span class="hljs-built_in">list</span>[AnyMessage], add_messages]

<span class="hljs-keyword">def</span> <span class="hljs-title function_">assistant</span>(<span class="hljs-params">state: AgentState</span>):
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;messages&quot;</span>: [chat_with_tools.invoke(state[<span class="hljs-string">&quot;messages&quot;</span>])],
    }

<span class="hljs-comment">## Le graphe</span>
builder = StateGraph(AgentState)

<span class="hljs-comment"># Définir les nœuds : ils font le travail</span>
builder.add_node(<span class="hljs-string">&quot;assistant&quot;</span>, assistant)
builder.add_node(<span class="hljs-string">&quot;tools&quot;</span>, ToolNode(tools))

<span class="hljs-comment"># Définir les arêtes : elles déterminent comment le flux de contrôle se déplace</span>
builder.add_edge(START, <span class="hljs-string">&quot;assistant&quot;</span>)
builder.add_conditional_edges(
    <span class="hljs-string">&quot;assistant&quot;</span>,
    <span class="hljs-comment"># Si le dernier message nécessite un outil, router vers les outils</span>
    <span class="hljs-comment"># Sinon, fournir une réponse directe</span>
    tools_condition,
)
builder.add_edge(<span class="hljs-string">&quot;tools&quot;</span>, <span class="hljs-string">&quot;assistant&quot;</span>)
alfred = builder.<span class="hljs-built_in">compile</span>()

messages = [HumanMessage(content=<span class="hljs-string">&quot;Parlez-moi de notre invitée nommée &#x27;Lady Ada Lovelace&#x27;.&quot;</span>)]
response = alfred.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages})

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🎩 Réponse d&#x27;Alfred :&quot;</span>)
<span class="hljs-built_in">print</span>(response[<span class="hljs-string">&#x27;messages&#x27;</span>][-<span class="hljs-number">1</span>].content)`,wrap:!1}}),o=new V({props:{code:"JUYwJTlGJThFJUE5JTIwUiVDMyVBOXBvbnNlJTIwZCdBbGZyZWQlMjAlM0ElMEFMYWR5JTIwQWRhJTIwTG92ZWxhY2UlMjBlc3QlMjB1bmUlMjBtYXRoJUMzJUE5bWF0aWNpZW5uZSUyMGVzdGltJUMzJUE5ZSUyMGV0JTIwcGlvbm5pJUMzJUE4cmUlMjBlbiUyMGluZm9ybWF0aXF1ZSUyQyUyMHNvdXZlbnQlMjBjJUMzJUE5bCVDMyVBOWJyJUMzJUE5ZSUyMGNvbW1lJTIwbGElMjBwcmVtaSVDMyVBOHJlJTIwcHJvZ3JhbW1ldXNlJTIwaW5mb3JtYXRpcXVlJTIwZW4lMjByYWlzb24lMjBkZSUyMHNvbiUyMHRyYXZhaWwlMjBzdXIlMjBsYSUyMG1hY2hpbmUlMjBhbmFseXRpcXVlJTIwZGUlMjBDaGFybGVzJTIwQmFiYmFnZS4=",highlighted:`🎩 Réponse <span class="hljs-keyword">d</span>&#x27;Alfred :
Lady Ada Lovelace <span class="hljs-keyword">est</span> une mathématicienne estimé<span class="hljs-keyword">e</span> et pionnière <span class="hljs-keyword">en</span> informatique, souvent cé<span class="hljs-keyword">l</span>é<span class="hljs-keyword">br</span>é<span class="hljs-keyword">e</span> comme <span class="hljs-keyword">la</span> première programmeuse informatique <span class="hljs-keyword">en</span> raison <span class="hljs-keyword">de</span> son travail sur <span class="hljs-keyword">la</span> machine analytique <span class="hljs-keyword">de</span> Charles Babbage.`,wrap:!1}}),{c(){h(i.$$.fragment),j=u(),p=m("p"),p.textContent=d,y=u(),h(o.$$.fragment),l=u(),c=m("p"),c.textContent=T,f=u(),w=m("ul"),w.innerHTML=b},l(a){C(i.$$.fragment,a),j=M(a),p=U(a,"P",{"data-svelte-h":!0}),J(p)!=="svelte-cs180i"&&(p.textContent=d),y=M(a),C(o.$$.fragment,a),l=M(a),c=U(a,"P",{"data-svelte-h":!0}),J(c)!=="svelte-32t9d6"&&(c.textContent=T),f=M(a),w=U(a,"UL",{"data-svelte-h":!0}),J(w)!=="svelte-1e8sj3t"&&(w.innerHTML=b)},m(a,n){I(i,a,n),t(a,j,n),t(a,p,n),t(a,y,n),I(o,a,n),t(a,l,n),t(a,c,n),t(a,f,n),t(a,w,n),Q=!0},p:x,i(a){Q||(v(i.$$.fragment,a),v(o.$$.fragment,a),Q=!0)},o(a){Z(i.$$.fragment,a),Z(o.$$.fragment,a),Q=!1},d(a){a&&(s(j),s(p),s(y),s(l),s(c),s(f),s(w)),g(i,a),g(o,a)}}}function ys(G){let i,j,p,d,y,o;return i=new k({props:{id:"agents-frameworks",option:"smolagents",$$slots:{default:[Ms]},$$scope:{ctx:G}}}),p=new k({props:{id:"agents-frameworks",option:"llama-index",$$slots:{default:[cs]},$$scope:{ctx:G}}}),y=new k({props:{id:"agents-frameworks",option:"langgraph",$$slots:{default:[ds]},$$scope:{ctx:G}}}),{c(){h(i.$$.fragment),j=u(),h(p.$$.fragment),d=u(),h(y.$$.fragment)},l(l){C(i.$$.fragment,l),j=M(l),C(p.$$.fragment,l),d=M(l),C(y.$$.fragment,l)},m(l,c){I(i,l,c),t(l,j,c),I(p,l,c),t(l,d,c),I(y,l,c),o=!0},p(l,c){const T={};c&2&&(T.$$scope={dirty:c,ctx:l}),i.$set(T);const f={};c&2&&(f.$$scope={dirty:c,ctx:l}),p.$set(f);const w={};c&2&&(w.$$scope={dirty:c,ctx:l}),y.$set(w)},i(l){o||(v(i.$$.fragment,l),v(p.$$.fragment,l),v(y.$$.fragment,l),o=!0)},o(l){Z(i.$$.fragment,l),Z(p.$$.fragment,l),Z(y.$$.fragment,l),o=!1},d(l){l&&(s(j),s(d)),g(i,l),g(p,l),g(y,l)}}}function ms(G){let i,j,p,d,y,o,l,c="Alfred, votre agent de confiance, se prépare pour le gala le plus extravagant du siècle. Pour s’assurer que l’événement se déroule sans encombre, il a besoin d’un accès rapide à des informations à jour sur chaque invité. Aidons le en créant un outil RAG alimenté par notre jeu de données personnalisé.",T,f,w,b,Q="Imaginez Alfred se mêlant aux invités, ayant besoin de se rappeler des détails spécifiques sur chaque personne à tout moment. Un LLM traditionnel pourrait avoir du mal avec cette tâche parce que :",a,n,B="<li>La liste des invités est spécifique à votre événement et ne fait pas partie des données d’entraînement du modèle</li> <li>Les informations sur les invités peuvent changer ou être mises à jour fréquemment</li> <li>Alfred doit récupérer des détails précis comme les adresses email</li>",ve,_,jl="C’est là que le RAG brille ! En combinant un système de récupération avec un LLM, Alfred peut accéder à des informations précises et à jour sur vos invités à la demande.",Ze,z,wl="<p>Vous pouvez choisir n’importe lequel des <i>frameworks</i> couverts dans le cours pour ce cas d’usage. Sélectionnez votre option préférée dans les onglets de code.</p>",ge,F,Be,H,Tl="Dans cette unité, nous développerons notre agent au sein d’un <em>Space</em>, sous la forme d’un projet Python structuré. Cette approche nous aide à maintenir un code propre et modulaire en organisant différentes fonctionnalités dans des fichiers séparés. De plus, cela permet un cas d’usage plus réaliste où vous déploieriez l’application pour une utilisation publique.",Ge,Y,Qe,L,fl="<li><strong><code>tools.py</code></strong> – Fournit des outils auxiliaires pour l’agent.</li> <li><strong><code>retriever.py</code></strong> – Implémente les fonctions de récupération pour soutenir l’accès à la connaissance.</li> <li><strong><code>app.py</code></strong> – Intègre tous les composants dans un agent entièrement fonctionnel, que nous finaliserons dans la dernière partie de cette unité.</li>",$e,D,bl='Pour une référence pratique, consultez <a href="https://huggingface.co/spaces/agents-course/Unit_3_Agentic_RAG" rel="nofollow">ce <em>Space</em></a> sur un RAG agentique. N’hésitez pas à le cloner et à expérimenter !',Ve,O,hl="Vous pouvez tester directement l’agent ci-dessous :",We,R,Cl,Re,P,Xe,K,Il='Notre jeu de données <a href="https://huggingface.co/datasets/agents-course/unit3-invitees/" rel="nofollow"><code>agents-course/unit3-invitees</code></a> contient les champs suivants pour chaque invité :',ke,ee,vl="<li><strong>Name</strong> : Nom complet de l’invité</li> <li><strong>Relation</strong> : Comment l’invité est lié à l’hôte</li> <li><strong>Description</strong> : Une brève biographie ou des faits intéressants sur l’invité</li> <li><strong>Email Address</strong> : Informations de contact pour envoyer des invitations ou des suivis</li>",xe,le,Zl="Voici un aperçu du jeu de données :",ze,X,gl,Ee,E,Bl="<p>Dans un scénario réel, ce jeu de données pourrait être étendu pour inclure les préférences alimentaires, les intérêts pour les cadeaux, les sujets de conversation à éviter, et d’autres détails utiles pour un hôte.</p>",Ne,se,Se,te,Gl="Nous allons créer un outil personnalisé qu’Alfred peut utiliser pour récupérer rapidement les informations sur les invités pendant le gala. Décomposons cela en trois étapes gérables :",qe,ne,Ql="<li>Charger et préparer le jeu de données</li> <li>Créer l’outil de récupération</li> <li>Intégrer l’outil à Alfred</li>",Ae,ae,$l="Commençons par charger et préparer le jeu de données !",_e,ie,Fe,re,Vl="Tout d’abord, nous devons transformer nos données brutes sur les invités en un format optimisé pour la récupération.",He,N,Ye,oe,Wl="Dans le code ci-dessus, nous :",Le,pe,Rl="<li>Chargeons le jeu de données</li> <li>Convertissons chaque entrée d’invité en un objet <code>Document</code> avec du contenu formaté</li> <li>Stockons les objets <code>Document</code> dans une liste</li>",De,ue,Xl="Cela signifie que nous avons toutes nos données bien disponibles pour pouvoir commencer à configurer notre récupération.",Oe,Me,Pe,ce,kl="Maintenant, créons un outil personnalisé qu’Alfred peut utiliser pour rechercher dans nos informations sur les invités.",Ke,S,el,de,ll,ye,xl="Enfin, assemblons le tout en créant notre agent et en l’équipant de notre outil personnalisé :",sl,q,tl,me,nl,Ue,zl="Pendant le gala, une conversation pourrait se dérouler comme ceci :",al,Je,El="<strong>Vous :</strong> “Alfred, qui est ce monsieur qui parle à l’ambassadeur ?”",il,je,Nl="<strong>Alfred :</strong> <em>recherche rapidement dans la base de données des invités</em> “C’est le Dr. Nikola Tesla, monsieur. C’est un vieil ami de votre période à l’université. Il vient récemment de breveter un nouveau système de transmission d’énergie sans fil et serait ravi d’en discuter avec vous. N’oubliez pas qu’il est passionné par les pigeons, donc cela pourrait faire une bonne conversation.”",rl,we,ol,Te,pl,fe,Sl="Maintenant qu’Alfred peut récupérer des informations sur les invités, considérez comment vous pourriez améliorer ce système :",ul,be,ql='<li><strong>Améliorer le récupérateur</strong> pour utiliser un algorithme plus sophistiqué comme ceux disponibles dans <a href="https://www.sbert.net/" rel="nofollow"><code>sentence-transformers</code></a></li> <li><strong>Implémenter une mémoire de conversation</strong> pour qu’Alfred se souvienne des interactions précédentes</li> <li><strong>Combiner avec la recherche web</strong> pour obtenir les dernières informations sur les invités inconnus</li> <li><strong>Intégrer plusieurs index</strong> pour obtenir des informations plus complètes à partir de sources vérifiées</li>',Ml,he,Al="Maintenant Alfred est entièrement équipé pour gérer sans effort les questions sur les invités, s’assurant que votre gala soit mémorisé comme l’événement le plus sophistiqué et délicieux du siècle !",cl,A,_l="<p>Essayez d’étendre l’outil de récupération pour aussi retourner des amorces de conversation basées sur les intérêts ou l’arrière-plan de chaque invité. Comment modifieriez-vous l’outil pour accomplir cela ?</p> <p>Quand vous avez terminé, implémentez votre outil de récupération d’invités dans le fichier <code>retriever.py</code> du <i>Space</i>.</p>",dl,Ce,yl,Ie,ml;return y=new W({props:{title:"Création d’un RAG pour converser avec les invités",local:"création-dun-rag-pour-converser-avec-les-invités",headingTag:"h1"}}),f=new W({props:{title:"Pourquoi un RAG pour un gala ?",local:"pourquoi-un-rag-pour-un-gala-",headingTag:"h2"}}),F=new W({props:{title:"Configuration de notre application",local:"configuration-de-notre-application",headingTag:"h2"}}),Y=new W({props:{title:"Structure du projet",local:"structure-du-projet",headingTag:"h3"}}),P=new W({props:{title:"Aperçu du jeu de données",local:"aperçu-du-jeu-de-données",headingTag:"h2"}}),se=new W({props:{title:"Construction d’un outil pour un livre d’or",local:"construction-dun-outil-pour-un-livre-dor",headingTag:"h2"}}),ie=new W({props:{title:"Étape 1 : Charger et préparer le jeu de données",local:"étape-1--charger-et-préparer-le-jeu-de-données",headingTag:"h3"}}),N=new Jl({props:{id:"agents-frameworks",options:["smolagents","llama-index","langgraph"],$$slots:{default:[is]},$$scope:{ctx:G}}}),Me=new W({props:{title:"Étape 2 : Créer l’outil de récupération",local:"étape-2--créer-loutil-de-récupération",headingTag:"h3"}}),S=new Jl({props:{id:"agents-frameworks",options:["smolagents","llama-index","langgraph"],$$slots:{default:[us]},$$scope:{ctx:G}}}),de=new W({props:{title:"Étape 3 : Intégrer l’outil avec Alfred",local:"étape-3--intégrer-loutil-avec-alfred",headingTag:"h3"}}),q=new Jl({props:{id:"agents-frameworks",options:["smolagents","llama-index","langgraph"],$$slots:{default:[ys]},$$scope:{ctx:G}}}),me=new W({props:{title:"Exemple d’interaction",local:"exemple-dinteraction",headingTag:"h2"}}),we=new V({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIybmFtZSUyMiUzQSUyMCUyMkRyLiUyME5pa29sYSUyMFRlc2xhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVsYXRpb24lMjIlM0ElMjAlMjJ2aWVpbCUyMGFtaSUyMGRlcyUyMGpvdXJzJTIwZCd1bml2ZXJzaXQlQzMlQTklMjIlMkMlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjJkZXNjcmlwdGlvbiUyMiUzQSUyMCUyMkxlJTIwRHIuJTIwTmlrb2xhJTIwVGVzbGElMjBlc3QlMjB1biUyMHZpZWlsJTIwYW1pJTIwZGUlMjB2b3RyZSUyMHAlQzMlQTlyaW9kZSUyMCVDMyVBMCUyMGwndW5pdmVyc2l0JUMzJUE5LiUyMElsJTIwdmllbnQlMjByJUMzJUE5Y2VtbWVudCUyMGRlJTIwYnJldmV0ZXIlMjB1biUyMG5vdXZlYXUlMjBzeXN0JUMzJUE4bWUlMjBkZSUyMHRyYW5zbWlzc2lvbiUyMGQnJUMzJUE5bmVyZ2llJTIwc2FucyUyMGZpbCUyMGV0JTIwc2VyYWl0JTIwcmF2aSUyMGQnZW4lMjBkaXNjdXRlciUyMGF2ZWMlMjB2b3VzLiUyME4nb3VibGlleiUyMHBhcyUyMHF1J2lsJTIwZXN0JTIwcGFzc2lvbm4lQzMlQTklMjBwYXIlMjBsZXMlMjBwaWdlb25zJTJDJTIwZG9uYyUyMGNlbGElMjBwb3VycmFpdCUyMGZhaXJlJTIwdW5lJTIwYm9ubmUlMjBjb252ZXJzYXRpb24uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyZW1haWwlMjIlM0ElMjAlMjJuaWtvbGEudGVzbGElNDBnbWFpbC5jb20lMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Dr. Nikola Tesla&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;relation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;vieil ami des jours d&#x27;université&quot;</span><span class="hljs-punctuation">,</span>  
    <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Le Dr. Nikola Tesla est un vieil ami de votre période à l&#x27;université. Il vient récemment de breveter un nouveau système de transmission d&#x27;énergie sans fil et serait ravi d&#x27;en discuter avec vous. N&#x27;oubliez pas qu&#x27;il est passionné par les pigeons, donc cela pourrait faire une bonne conversation.&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;email&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;nikola.tesla@gmail.com&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Te=new W({props:{title:"Aller plus loin",local:"aller-plus-loin",headingTag:"h2"}}),Ce=new ss({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit3/agentic-rag/invitees.mdx"}}),{c(){i=m("meta"),j=u(),p=m("p"),d=u(),h(y.$$.fragment),o=u(),l=m("p"),l.textContent=c,T=u(),h(f.$$.fragment),w=u(),b=m("p"),b.textContent=Q,a=u(),n=m("ol"),n.innerHTML=B,ve=u(),_=m("p"),_.textContent=jl,Ze=u(),z=m("blockquote"),z.innerHTML=wl,ge=u(),h(F.$$.fragment),Be=u(),H=m("p"),H.innerHTML=Tl,Ge=u(),h(Y.$$.fragment),Qe=u(),L=m("ul"),L.innerHTML=fl,$e=u(),D=m("p"),D.innerHTML=bl,Ve=u(),O=m("p"),O.textContent=hl,We=u(),R=m("iframe"),Re=u(),h(P.$$.fragment),Xe=u(),K=m("p"),K.innerHTML=Il,ke=u(),ee=m("ul"),ee.innerHTML=vl,xe=u(),le=m("p"),le.textContent=Zl,ze=u(),X=m("iframe"),Ee=u(),E=m("blockquote"),E.innerHTML=Bl,Ne=u(),h(se.$$.fragment),Se=u(),te=m("p"),te.textContent=Gl,qe=u(),ne=m("ol"),ne.innerHTML=Ql,Ae=u(),ae=m("p"),ae.textContent=$l,_e=u(),h(ie.$$.fragment),Fe=u(),re=m("p"),re.textContent=Vl,He=u(),h(N.$$.fragment),Ye=u(),oe=m("p"),oe.textContent=Wl,Le=u(),pe=m("ul"),pe.innerHTML=Rl,De=u(),ue=m("p"),ue.textContent=Xl,Oe=u(),h(Me.$$.fragment),Pe=u(),ce=m("p"),ce.textContent=kl,Ke=u(),h(S.$$.fragment),el=u(),h(de.$$.fragment),ll=u(),ye=m("p"),ye.textContent=xl,sl=u(),h(q.$$.fragment),tl=u(),h(me.$$.fragment),nl=u(),Ue=m("p"),Ue.textContent=zl,al=u(),Je=m("p"),Je.innerHTML=El,il=u(),je=m("p"),je.innerHTML=Nl,rl=u(),h(we.$$.fragment),ol=u(),h(Te.$$.fragment),pl=u(),fe=m("p"),fe.textContent=Sl,ul=u(),be=m("ol"),be.innerHTML=ql,Ml=u(),he=m("p"),he.textContent=Al,cl=u(),A=m("blockquote"),A.innerHTML=_l,dl=u(),h(Ce.$$.fragment),yl=u(),Ie=m("p"),this.h()},l(e){const r=es("svelte-u9bgzb",document.head);i=U(r,"META",{name:!0,content:!0}),r.forEach(s),j=M(e),p=U(e,"P",{}),Ul(p).forEach(s),d=M(e),C(y.$$.fragment,e),o=M(e),l=U(e,"P",{"data-svelte-h":!0}),J(l)!=="svelte-10vaq2f"&&(l.textContent=c),T=M(e),C(f.$$.fragment,e),w=M(e),b=U(e,"P",{"data-svelte-h":!0}),J(b)!=="svelte-1j3vz76"&&(b.textContent=Q),a=M(e),n=U(e,"OL",{"data-svelte-h":!0}),J(n)!=="svelte-1orlwys"&&(n.innerHTML=B),ve=M(e),_=U(e,"P",{"data-svelte-h":!0}),J(_)!=="svelte-uqr10i"&&(_.textContent=jl),Ze=M(e),z=U(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),J(z)!=="svelte-3juerg"&&(z.innerHTML=wl),ge=M(e),C(F.$$.fragment,e),Be=M(e),H=U(e,"P",{"data-svelte-h":!0}),J(H)!=="svelte-1qhtine"&&(H.innerHTML=Tl),Ge=M(e),C(Y.$$.fragment,e),Qe=M(e),L=U(e,"UL",{"data-svelte-h":!0}),J(L)!=="svelte-nhc3qb"&&(L.innerHTML=fl),$e=M(e),D=U(e,"P",{"data-svelte-h":!0}),J(D)!=="svelte-195majs"&&(D.innerHTML=bl),Ve=M(e),O=U(e,"P",{"data-svelte-h":!0}),J(O)!=="svelte-1flvt2o"&&(O.textContent=hl),We=M(e),R=U(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Ul(R).forEach(s),Re=M(e),C(P.$$.fragment,e),Xe=M(e),K=U(e,"P",{"data-svelte-h":!0}),J(K)!=="svelte-wloegn"&&(K.innerHTML=Il),ke=M(e),ee=U(e,"UL",{"data-svelte-h":!0}),J(ee)!=="svelte-112ychf"&&(ee.innerHTML=vl),xe=M(e),le=U(e,"P",{"data-svelte-h":!0}),J(le)!=="svelte-j9piat"&&(le.textContent=Zl),ze=M(e),X=U(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Ul(X).forEach(s),Ee=M(e),E=U(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),J(E)!=="svelte-scjuwu"&&(E.innerHTML=Bl),Ne=M(e),C(se.$$.fragment,e),Se=M(e),te=U(e,"P",{"data-svelte-h":!0}),J(te)!=="svelte-1lifv41"&&(te.textContent=Gl),qe=M(e),ne=U(e,"OL",{"data-svelte-h":!0}),J(ne)!=="svelte-12nbta4"&&(ne.innerHTML=Ql),Ae=M(e),ae=U(e,"P",{"data-svelte-h":!0}),J(ae)!=="svelte-1uinyta"&&(ae.textContent=$l),_e=M(e),C(ie.$$.fragment,e),Fe=M(e),re=U(e,"P",{"data-svelte-h":!0}),J(re)!=="svelte-dm19ow"&&(re.textContent=Vl),He=M(e),C(N.$$.fragment,e),Ye=M(e),oe=U(e,"P",{"data-svelte-h":!0}),J(oe)!=="svelte-112sdet"&&(oe.textContent=Wl),Le=M(e),pe=U(e,"UL",{"data-svelte-h":!0}),J(pe)!=="svelte-10q7x11"&&(pe.innerHTML=Rl),De=M(e),ue=U(e,"P",{"data-svelte-h":!0}),J(ue)!=="svelte-1j69ifk"&&(ue.textContent=Xl),Oe=M(e),C(Me.$$.fragment,e),Pe=M(e),ce=U(e,"P",{"data-svelte-h":!0}),J(ce)!=="svelte-29zbds"&&(ce.textContent=kl),Ke=M(e),C(S.$$.fragment,e),el=M(e),C(de.$$.fragment,e),ll=M(e),ye=U(e,"P",{"data-svelte-h":!0}),J(ye)!=="svelte-1hv6yva"&&(ye.textContent=xl),sl=M(e),C(q.$$.fragment,e),tl=M(e),C(me.$$.fragment,e),nl=M(e),Ue=U(e,"P",{"data-svelte-h":!0}),J(Ue)!=="svelte-1cu0ok6"&&(Ue.textContent=zl),al=M(e),Je=U(e,"P",{"data-svelte-h":!0}),J(Je)!=="svelte-wflh83"&&(Je.innerHTML=El),il=M(e),je=U(e,"P",{"data-svelte-h":!0}),J(je)!=="svelte-1eaa5ai"&&(je.innerHTML=Nl),rl=M(e),C(we.$$.fragment,e),ol=M(e),C(Te.$$.fragment,e),pl=M(e),fe=U(e,"P",{"data-svelte-h":!0}),J(fe)!=="svelte-1b0r9nd"&&(fe.textContent=Sl),ul=M(e),be=U(e,"OL",{"data-svelte-h":!0}),J(be)!=="svelte-1pcnpq1"&&(be.innerHTML=ql),Ml=M(e),he=U(e,"P",{"data-svelte-h":!0}),J(he)!=="svelte-d8k26u"&&(he.textContent=Al),cl=M(e),A=U(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),J(A)!=="svelte-xtekln"&&(A.innerHTML=_l),dl=M(e),C(Ce.$$.fragment,e),yl=M(e),Ie=U(e,"P",{}),Ul(Ie).forEach(s),this.h()},h(){$(i,"name","hf:doc:metadata"),$(i,"content",Us),$(z,"class","tip"),Ll(R.src,Cl="https://agents-course-unit-3-agentic-rag.hf.space")||$(R,"src",Cl),$(R,"frameborder","0"),$(R,"width","850"),$(R,"height","450"),Ll(X.src,gl="https://huggingface.co/datasets/agents-course/unit3-invitees/embed/viewer/default/train")||$(X,"src",gl),$(X,"frameborder","0"),$(X,"width","100%"),$(X,"height","560px"),$(E,"class","tip"),$(A,"class","tip")},m(e,r){ls(document.head,i),t(e,j,r),t(e,p,r),t(e,d,r),I(y,e,r),t(e,o,r),t(e,l,r),t(e,T,r),I(f,e,r),t(e,w,r),t(e,b,r),t(e,a,r),t(e,n,r),t(e,ve,r),t(e,_,r),t(e,Ze,r),t(e,z,r),t(e,ge,r),I(F,e,r),t(e,Be,r),t(e,H,r),t(e,Ge,r),I(Y,e,r),t(e,Qe,r),t(e,L,r),t(e,$e,r),t(e,D,r),t(e,Ve,r),t(e,O,r),t(e,We,r),t(e,R,r),t(e,Re,r),I(P,e,r),t(e,Xe,r),t(e,K,r),t(e,ke,r),t(e,ee,r),t(e,xe,r),t(e,le,r),t(e,ze,r),t(e,X,r),t(e,Ee,r),t(e,E,r),t(e,Ne,r),I(se,e,r),t(e,Se,r),t(e,te,r),t(e,qe,r),t(e,ne,r),t(e,Ae,r),t(e,ae,r),t(e,_e,r),I(ie,e,r),t(e,Fe,r),t(e,re,r),t(e,He,r),I(N,e,r),t(e,Ye,r),t(e,oe,r),t(e,Le,r),t(e,pe,r),t(e,De,r),t(e,ue,r),t(e,Oe,r),I(Me,e,r),t(e,Pe,r),t(e,ce,r),t(e,Ke,r),I(S,e,r),t(e,el,r),I(de,e,r),t(e,ll,r),t(e,ye,r),t(e,sl,r),I(q,e,r),t(e,tl,r),I(me,e,r),t(e,nl,r),t(e,Ue,r),t(e,al,r),t(e,Je,r),t(e,il,r),t(e,je,r),t(e,rl,r),I(we,e,r),t(e,ol,r),I(Te,e,r),t(e,pl,r),t(e,fe,r),t(e,ul,r),t(e,be,r),t(e,Ml,r),t(e,he,r),t(e,cl,r),t(e,A,r),t(e,dl,r),I(Ce,e,r),t(e,yl,r),t(e,Ie,r),ml=!0},p(e,[r]){const Fl={};r&2&&(Fl.$$scope={dirty:r,ctx:e}),N.$set(Fl);const Hl={};r&2&&(Hl.$$scope={dirty:r,ctx:e}),S.$set(Hl);const Yl={};r&2&&(Yl.$$scope={dirty:r,ctx:e}),q.$set(Yl)},i(e){ml||(v(y.$$.fragment,e),v(f.$$.fragment,e),v(F.$$.fragment,e),v(Y.$$.fragment,e),v(P.$$.fragment,e),v(se.$$.fragment,e),v(ie.$$.fragment,e),v(N.$$.fragment,e),v(Me.$$.fragment,e),v(S.$$.fragment,e),v(de.$$.fragment,e),v(q.$$.fragment,e),v(me.$$.fragment,e),v(we.$$.fragment,e),v(Te.$$.fragment,e),v(Ce.$$.fragment,e),ml=!0)},o(e){Z(y.$$.fragment,e),Z(f.$$.fragment,e),Z(F.$$.fragment,e),Z(Y.$$.fragment,e),Z(P.$$.fragment,e),Z(se.$$.fragment,e),Z(ie.$$.fragment,e),Z(N.$$.fragment,e),Z(Me.$$.fragment,e),Z(S.$$.fragment,e),Z(de.$$.fragment,e),Z(q.$$.fragment,e),Z(me.$$.fragment,e),Z(we.$$.fragment,e),Z(Te.$$.fragment,e),Z(Ce.$$.fragment,e),ml=!1},d(e){e&&(s(j),s(p),s(d),s(o),s(l),s(T),s(w),s(b),s(a),s(n),s(ve),s(_),s(Ze),s(z),s(ge),s(Be),s(H),s(Ge),s(Qe),s(L),s($e),s(D),s(Ve),s(O),s(We),s(R),s(Re),s(Xe),s(K),s(ke),s(ee),s(xe),s(le),s(ze),s(X),s(Ee),s(E),s(Ne),s(Se),s(te),s(qe),s(ne),s(Ae),s(ae),s(_e),s(Fe),s(re),s(He),s(Ye),s(oe),s(Le),s(pe),s(De),s(ue),s(Oe),s(Pe),s(ce),s(Ke),s(el),s(ll),s(ye),s(sl),s(tl),s(nl),s(Ue),s(al),s(Je),s(il),s(je),s(rl),s(ol),s(pl),s(fe),s(ul),s(be),s(Ml),s(he),s(cl),s(A),s(dl),s(yl),s(Ie)),s(i),g(y,e),g(f,e),g(F,e),g(Y,e),g(P,e),g(se,e),g(ie,e),g(N,e),g(Me,e),g(S,e),g(de,e),g(q,e),g(me,e),g(we,e),g(Te,e),g(Ce,e)}}}const Us='{"title":"Création d’un RAG pour converser avec les invités","local":"création-dun-rag-pour-converser-avec-les-invités","sections":[{"title":"Pourquoi un RAG pour un gala ?","local":"pourquoi-un-rag-pour-un-gala-","sections":[],"depth":2},{"title":"Configuration de notre application","local":"configuration-de-notre-application","sections":[{"title":"Structure du projet","local":"structure-du-projet","sections":[],"depth":3}],"depth":2},{"title":"Aperçu du jeu de données","local":"aperçu-du-jeu-de-données","sections":[],"depth":2},{"title":"Construction d’un outil pour un livre d’or","local":"construction-dun-outil-pour-un-livre-dor","sections":[{"title":"Étape 1 : Charger et préparer le jeu de données","local":"étape-1--charger-et-préparer-le-jeu-de-données","sections":[],"depth":3},{"title":"Étape 2 : Créer l’outil de récupération","local":"étape-2--créer-loutil-de-récupération","sections":[],"depth":3},{"title":"Étape 3 : Intégrer l’outil avec Alfred","local":"étape-3--intégrer-loutil-avec-alfred","sections":[],"depth":3}],"depth":2},{"title":"Exemple d’interaction","local":"exemple-dinteraction","sections":[],"depth":2},{"title":"Aller plus loin","local":"aller-plus-loin","sections":[],"depth":2}],"depth":1}';function Js(G){return Ol(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Cs extends Pl{constructor(i){super(),Kl(this,i,Js,ms,Dl,{})}}export{Cs as component};
