import{s as ys,f as Ft,n as rs,o as Js}from"../chunks/scheduler.37c15a92.js";import{S as Ts,i as ms,g as p,s as n,r as M,A as gs,h as i,f as l,c as a,j as Ms,u as y,x as U,k as o,y as os,a as e,v as r,d as J,t as T,w as m}from"../chunks/index.2bf4358c.js";import{C as z}from"../chunks/CodeBlock.4e987730.js";import{H as P}from"../chunks/Heading.8ada512a.js";import{E as us}from"../chunks/getInferenceSnippets.0aa3753f.js";function hs(xt){let g,lt,tt,et,h,nt,C,Lt="要使用 LangGraph 构建应用程序，需要理解其核心组件。让我们探索构成 LangGraph 应用程序的基础构建模块。",at,u,qt,pt,d,Ht="LangGraph 应用程序从 <strong>entrypoint</strong> 开始，根据执行情况，流程可能流向不同的函数直到抵达 END。",it,c,Ot,Ut,f,Mt,w,Wt="<strong>State</strong> 是 LangGraph 中的核心概念，表示流经应用程序的所有信息。",yt,j,rt,$,Dt="状态是 <strong>用户自定义</strong> 的，因此需要仔细设计字段以包含决策过程所需的所有数据！",Jt,S,Yt="<p>💡 <strong>提示:</strong> 仔细考虑应用程序需要在步骤之间跟踪哪些信息。</p>",Tt,k,mt,G,At="<strong>Nodes</strong> 是 Python 函数。每个节点：",gt,_,Xt="<li>接收状态作为输入</li> <li>执行某些操作</li> <li>返回状态更新</li>",ot,V,ut,I,Kt="举例, 节点可以包含：",ht,Q,zt="<li><strong>LLM 调用</strong>: 生成文本或做出决策</li> <li><strong>工具调用</strong>: 与外部系统交互</li> <li><strong>条件逻辑</strong>: 决定后续步骤</li> <li><strong>人工干预</strong>: 获取用户输入</li>",Ct,b,Pt="<p>💡 <strong>信息:</strong> 像 START 和 END 这样的必要节点已直接包含在 LangGraph 中。</p>",dt,Z,ct,R,ts="<strong>Edges</strong> 连接节点并定义图中的可能路径：",ft,v,wt,E,ss="边可以是：",jt,B,ls="<li><strong>直接边</strong>: 始终从节点 A 到节点 B</li> <li><strong>条件边</strong>: 根据当前状态选择下一个节点</li>",$t,N,St,F,es="<strong>StateGraph</strong> 是包含整个 agent 工作流的容器：",kt,x,Gt,L,ns="可以可视化图表：",_t,q,Vt,H,as,It,O,ps="最重要的是可以调用：",Qt,W,bt,D,is="output :",Zt,Y,Rt,A,vt,X,Us="下一节我们将通过构建第一个图表来实践这些概念。该图表将让 Alfred 能够处理电子邮件，进行分类，并在邮件真实时起草初步回复。",Et,K,Bt,st,Nt;return h=new P({props:{title:"LangGraph 的核心构建模块",local:"langgraph-的核心构建模块",headingTag:"h1"}}),f=new P({props:{title:"1. 状态（State）",local:"1-状态state",headingTag:"h2"}}),j=new z({props:{code:"ZnJvbSUyMHR5cGluZ19leHRlbnNpb25zJTIwaW1wb3J0JTIwVHlwZWREaWN0JTBBJTBBY2xhc3MlMjBTdGF0ZShUeXBlZERpY3QpJTNBJTBBJTIwJTIwJTIwJTIwZ3JhcGhfc3RhdGUlM0ElMjBzdHI=",highlighted:`<span class="hljs-keyword">from</span> typing_extensions <span class="hljs-keyword">import</span> TypedDict

<span class="hljs-keyword">class</span> <span class="hljs-title class_">State</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    graph_state: <span class="hljs-built_in">str</span>`,wrap:!1}}),k=new P({props:{title:"2. 节点（Nodes）",local:"2-节点nodes",headingTag:"h2"}}),V=new z({props:{code:"ZGVmJTIwbm9kZV8xKHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0tLU5vZGUlMjAxLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmdyYXBoX3N0YXRlJTIyJTNBJTIwc3RhdGUlNUInZ3JhcGhfc3RhdGUnJTVEJTIwJTJCJTIyJTIwSSUyMGFtJTIyJTdEJTBBJTBBZGVmJTIwbm9kZV8yKHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0tLU5vZGUlMjAyLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmdyYXBoX3N0YXRlJTIyJTNBJTIwc3RhdGUlNUInZ3JhcGhfc3RhdGUnJTVEJTIwJTJCJTIyJTIwaGFwcHkhJTIyJTdEJTBBJTBBZGVmJTIwbm9kZV8zKHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0tLU5vZGUlMjAzLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmdyYXBoX3N0YXRlJTIyJTNBJTIwc3RhdGUlNUInZ3JhcGhfc3RhdGUnJTVEJTIwJTJCJTIyJTIwc2FkISUyMiU3RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_1</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 1---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; I am&quot;</span>}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_2</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 2---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; happy!&quot;</span>}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_3</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 3---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; sad!&quot;</span>}`,wrap:!1}}),Z=new P({props:{title:"3. 边（Edges）",local:"3-边edges",headingTag:"h2"}}),v=new z({props:{code:"aW1wb3J0JTIwcmFuZG9tJTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpdGVyYWwlMEElMEFkZWYlMjBkZWNpZGVfbW9vZChzdGF0ZSklMjAtJTNFJTIwTGl0ZXJhbCU1QiUyMm5vZGVfMiUyMiUyQyUyMCUyMm5vZGVfMyUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMCVFOSU4MCU5QSVFNSVCOCVCOCVFNiU4OCU5MSVFNCVCQiVBQyVFNCVCQyU5QSVFNiVBMCVCOSVFNiU4RCVBRSVFNyU4QSVCNiVFNiU4MCU4MSVFNSU4NiVCMyVFNSVBRSU5QSVFNCVCOCU4QiVFNCVCOCU4MCVFNCVCOCVBQSVFOCU4QSU4MiVFNyU4MiVCOSUwQSUyMCUyMCUyMCUyMHVzZXJfaW5wdXQlMjAlM0QlMjBzdGF0ZSU1QidncmFwaF9zdGF0ZSclNUQlMjAlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjAlRTglQkYlOTklRTklODclOEMlRTYlODglOTElRTQlQkIlQUMlRTUlOUMlQTglRTglOEElODIlRTclODIlQjkyJUU1JTkyJThDJUU4JThBJTgyJUU3JTgyJUI5MyVFNCVCOSU4QiVFOSU5NyVCNCVFNyVBRSU4MCVFNSU4RCU5NSVFNSVBRSU5RSVFNyU4RSVCMCUyMDUwJTJGNTAlMjAlRTclOUElODQlRTYlQTYlODIlRTclOEUlODclRTUlODglODYlRTklODUlOEQlMEElMjAlMjAlMjAlMjBpZiUyMHJhbmRvbS5yYW5kb20oKSUyMCUzQyUyMDAuNSUzQSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMDUwJTI1JTIwJUU2JTk3JUI2JUU5JTk3JUI0JUVGJUJDJThDJTIwJUU2JTg4JTkxJUU0JUJCJUFDJUU4JUJGJTk0JUU1JTlCJTlFJUU4JThBJTgyJUU3JTgyJUI5MiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMm5vZGVfMiUyMiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMDUwJTI1JTIwJUU2JTk3JUI2JUU5JTk3JUI0JUVGJUJDJThDJTIwJUU2JTg4JTkxJUU0JUJCJUFDJUU4JUJGJTk0JUU1JTlCJTlFJUU4JThBJTgyJUU3JTgyJUI5MyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCUyMm5vZGVfMyUyMg==",highlighted:`<span class="hljs-keyword">import</span> random
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Literal</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">decide_mood</span>(<span class="hljs-params">state</span>) -&gt; <span class="hljs-type">Literal</span>[<span class="hljs-string">&quot;node_2&quot;</span>, <span class="hljs-string">&quot;node_3&quot;</span>]:
    
    <span class="hljs-comment"># 通常我们会根据状态决定下一个节点</span>
    user_input = state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] 
    
    <span class="hljs-comment"># 这里我们在节点2和节点3之间简单实现 50/50 的概率分配</span>
    <span class="hljs-keyword">if</span> random.random() &lt; <span class="hljs-number">0.5</span>:

        <span class="hljs-comment"># 50% 时间， 我们返回节点2</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;node_2&quot;</span>
    
    <span class="hljs-comment"># 50% 时间， 我们返回节点3</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;node_3&quot;</span>`,wrap:!1}}),N=new P({props:{title:"4. 状态图（StateGraph）",local:"4-状态图stategraph",headingTag:"h2"}}),x=new z({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEltYWdlJTJDJTIwZGlzcGxheSUwQWZyb20lMjBsYW5nZ3JhcGguZ3JhcGglMjBpbXBvcnQlMjBTdGF0ZUdyYXBoJTJDJTIwU1RBUlQlMkMlMjBFTkQlMEElMEElMjMlMjAlRTYlOUUlODQlRTUlQkIlQkElRTUlOUIlQkUlRTglQTElQTglMEFidWlsZGVyJTIwJTNEJTIwU3RhdGVHcmFwaChTdGF0ZSklMEFidWlsZGVyLmFkZF9ub2RlKCUyMm5vZGVfMSUyMiUyQyUyMG5vZGVfMSklMEFidWlsZGVyLmFkZF9ub2RlKCUyMm5vZGVfMiUyMiUyQyUyMG5vZGVfMiklMEFidWlsZGVyLmFkZF9ub2RlKCUyMm5vZGVfMyUyMiUyQyUyMG5vZGVfMyklMEElMEElMjMlMjAlRTglQkYlOUUlRTYlOEUlQTUlRTklODAlQkIlRTglQkUlOTElMEFidWlsZGVyLmFkZF9lZGdlKFNUQVJUJTJDJTIwJTIybm9kZV8xJTIyKSUwQWJ1aWxkZXIuYWRkX2NvbmRpdGlvbmFsX2VkZ2VzKCUyMm5vZGVfMSUyMiUyQyUyMGRlY2lkZV9tb29kKSUwQWJ1aWxkZXIuYWRkX2VkZ2UoJTIybm9kZV8yJTIyJTJDJTIwRU5EKSUwQWJ1aWxkZXIuYWRkX2VkZ2UoJTIybm9kZV8zJTIyJTJDJTIwRU5EKSUwQSUwQSUyMyUyMCVFNyVCQyU5NiVFOCVBRiU5MSUwQWdyYXBoJTIwJTNEJTIwYnVpbGRlci5jb21waWxlKCk=",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Image, display
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> StateGraph, START, END

<span class="hljs-comment"># 构建图表</span>
builder = StateGraph(State)
builder.add_node(<span class="hljs-string">&quot;node_1&quot;</span>, node_1)
builder.add_node(<span class="hljs-string">&quot;node_2&quot;</span>, node_2)
builder.add_node(<span class="hljs-string">&quot;node_3&quot;</span>, node_3)

<span class="hljs-comment"># 连接逻辑</span>
builder.add_edge(START, <span class="hljs-string">&quot;node_1&quot;</span>)
builder.add_conditional_edges(<span class="hljs-string">&quot;node_1&quot;</span>, decide_mood)
builder.add_edge(<span class="hljs-string">&quot;node_2&quot;</span>, END)
builder.add_edge(<span class="hljs-string">&quot;node_3&quot;</span>, END)

<span class="hljs-comment"># 编译</span>
graph = builder.<span class="hljs-built_in">compile</span>()`,wrap:!1}}),q=new z({props:{code:"JTIzJTIwJUU1JThGJUFGJUU4JUE3JTg2JUU1JThDJTk2JTBBZGlzcGxheShJbWFnZShncmFwaC5nZXRfZ3JhcGgoKS5kcmF3X21lcm1haWRfcG5nKCkpKQ==",highlighted:`<span class="hljs-comment"># 可视化</span>
display(Image(graph.get_graph().draw_mermaid_png()))`,wrap:!1}}),W=new z({props:{code:"Z3JhcGguaW52b2tlKCU3QiUyMmdyYXBoX3N0YXRlJTIyJTIwJTNBJTIwJTIySGklMkMlMjB0aGlzJTIwaXMlMjBMYW5jZS4lMjIlN0Qp",highlighted:'graph.invoke({<span class="hljs-string">&quot;graph_state&quot;</span> : <span class="hljs-string">&quot;Hi, this is Lance.&quot;</span>})',wrap:!1}}),Y=new z({props:{code:"LS0tTm9kZSUyMDEtLS0lMEEtLS1Ob2RlJTIwMy0tLSUwQSU3QidncmFwaF9zdGF0ZSclM0ElMjAnSGklMkMlMjB0aGlzJTIwaXMlMjBMYW5jZS4lMjBJJTIwYW0lMjBzYWQhJyU3RA==",highlighted:`---<span class="hljs-keyword">Node</span> <span class="hljs-title">1---</span>
---<span class="hljs-keyword">Node</span> <span class="hljs-title">3---</span>
{&#x27;graph_state&#x27;: &#x27;Hi, this is Lance. I am sad!&#x27;}`,wrap:!1}}),A=new P({props:{title:"下一步？",local:"下一步",headingTag:"h2"}}),K=new us({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/zh-CN/unit2/langgraph/building_blocks.mdx"}}),{c(){g=p("meta"),lt=n(),tt=p("p"),et=n(),M(h.$$.fragment),nt=n(),C=p("p"),C.textContent=Lt,at=n(),u=p("img"),pt=n(),d=p("p"),d.innerHTML=Ht,it=n(),c=p("img"),Ut=n(),M(f.$$.fragment),Mt=n(),w=p("p"),w.innerHTML=Wt,yt=n(),M(j.$$.fragment),rt=n(),$=p("p"),$.innerHTML=Dt,Jt=n(),S=p("blockquote"),S.innerHTML=Yt,Tt=n(),M(k.$$.fragment),mt=n(),G=p("p"),G.innerHTML=At,gt=n(),_=p("ul"),_.innerHTML=Xt,ot=n(),M(V.$$.fragment),ut=n(),I=p("p"),I.textContent=Kt,ht=n(),Q=p("ul"),Q.innerHTML=zt,Ct=n(),b=p("blockquote"),b.innerHTML=Pt,dt=n(),M(Z.$$.fragment),ct=n(),R=p("p"),R.innerHTML=ts,ft=n(),M(v.$$.fragment),wt=n(),E=p("p"),E.textContent=ss,jt=n(),B=p("ul"),B.innerHTML=ls,$t=n(),M(N.$$.fragment),St=n(),F=p("p"),F.innerHTML=es,kt=n(),M(x.$$.fragment),Gt=n(),L=p("p"),L.textContent=ns,_t=n(),M(q.$$.fragment),Vt=n(),H=p("img"),It=n(),O=p("p"),O.textContent=ps,Qt=n(),M(W.$$.fragment),bt=n(),D=p("p"),D.textContent=is,Zt=n(),M(Y.$$.fragment),Rt=n(),M(A.$$.fragment),vt=n(),X=p("p"),X.textContent=Us,Et=n(),M(K.$$.fragment),Bt=n(),st=p("p"),this.h()},l(t){const s=gs("svelte-u9bgzb",document.head);g=i(s,"META",{name:!0,content:!0}),s.forEach(l),lt=a(t),tt=i(t,"P",{}),Ms(tt).forEach(l),et=a(t),y(h.$$.fragment,t),nt=a(t),C=i(t,"P",{"data-svelte-h":!0}),U(C)!=="svelte-1800rwf"&&(C.textContent=Lt),at=a(t),u=i(t,"IMG",{src:!0,alt:!0,width:!0}),pt=a(t),d=i(t,"P",{"data-svelte-h":!0}),U(d)!=="svelte-ejgf0e"&&(d.innerHTML=Ht),it=a(t),c=i(t,"IMG",{src:!0,alt:!0}),Ut=a(t),y(f.$$.fragment,t),Mt=a(t),w=i(t,"P",{"data-svelte-h":!0}),U(w)!=="svelte-1e4aibb"&&(w.innerHTML=Wt),yt=a(t),y(j.$$.fragment,t),rt=a(t),$=i(t,"P",{"data-svelte-h":!0}),U($)!=="svelte-1jtd4jr"&&($.innerHTML=Dt),Jt=a(t),S=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),U(S)!=="svelte-ajfpr1"&&(S.innerHTML=Yt),Tt=a(t),y(k.$$.fragment,t),mt=a(t),G=i(t,"P",{"data-svelte-h":!0}),U(G)!=="svelte-1iisg6m"&&(G.innerHTML=At),gt=a(t),_=i(t,"UL",{"data-svelte-h":!0}),U(_)!=="svelte-1iub67j"&&(_.innerHTML=Xt),ot=a(t),y(V.$$.fragment,t),ut=a(t),I=i(t,"P",{"data-svelte-h":!0}),U(I)!=="svelte-1sfr10c"&&(I.textContent=Kt),ht=a(t),Q=i(t,"UL",{"data-svelte-h":!0}),U(Q)!=="svelte-quo06t"&&(Q.innerHTML=zt),Ct=a(t),b=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),U(b)!=="svelte-11dq7zt"&&(b.innerHTML=Pt),dt=a(t),y(Z.$$.fragment,t),ct=a(t),R=i(t,"P",{"data-svelte-h":!0}),U(R)!=="svelte-vdr5dg"&&(R.innerHTML=ts),ft=a(t),y(v.$$.fragment,t),wt=a(t),E=i(t,"P",{"data-svelte-h":!0}),U(E)!=="svelte-3euhzu"&&(E.textContent=ss),jt=a(t),B=i(t,"UL",{"data-svelte-h":!0}),U(B)!=="svelte-yrpswg"&&(B.innerHTML=ls),$t=a(t),y(N.$$.fragment,t),St=a(t),F=i(t,"P",{"data-svelte-h":!0}),U(F)!=="svelte-1riuotf"&&(F.innerHTML=es),kt=a(t),y(x.$$.fragment,t),Gt=a(t),L=i(t,"P",{"data-svelte-h":!0}),U(L)!=="svelte-1gq7r39"&&(L.textContent=ns),_t=a(t),y(q.$$.fragment,t),Vt=a(t),H=i(t,"IMG",{src:!0,alt:!0}),It=a(t),O=i(t,"P",{"data-svelte-h":!0}),U(O)!=="svelte-p075fy"&&(O.textContent=ps),Qt=a(t),y(W.$$.fragment,t),bt=a(t),D=i(t,"P",{"data-svelte-h":!0}),U(D)!=="svelte-1wdnc59"&&(D.textContent=is),Zt=a(t),y(Y.$$.fragment,t),Rt=a(t),y(A.$$.fragment,t),vt=a(t),X=i(t,"P",{"data-svelte-h":!0}),U(X)!=="svelte-mejdbb"&&(X.textContent=Us),Et=a(t),y(K.$$.fragment,t),Bt=a(t),st=i(t,"P",{}),Ms(st).forEach(l),this.h()},h(){o(g,"name","hf:doc:metadata"),o(g,"content",Cs),Ft(u.src,qt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/Building_blocks.png")||o(u,"src",qt),o(u,"alt","Building Blocks"),o(u,"width","70%"),Ft(c.src,Ot="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/application.png")||o(c,"src",Ot),o(c,"alt","Application"),Ft(H.src,as="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/basic_graph.jpeg")||o(H,"src",as),o(H,"alt","图可视化")},m(t,s){os(document.head,g),e(t,lt,s),e(t,tt,s),e(t,et,s),r(h,t,s),e(t,nt,s),e(t,C,s),e(t,at,s),e(t,u,s),e(t,pt,s),e(t,d,s),e(t,it,s),e(t,c,s),e(t,Ut,s),r(f,t,s),e(t,Mt,s),e(t,w,s),e(t,yt,s),r(j,t,s),e(t,rt,s),e(t,$,s),e(t,Jt,s),e(t,S,s),e(t,Tt,s),r(k,t,s),e(t,mt,s),e(t,G,s),e(t,gt,s),e(t,_,s),e(t,ot,s),r(V,t,s),e(t,ut,s),e(t,I,s),e(t,ht,s),e(t,Q,s),e(t,Ct,s),e(t,b,s),e(t,dt,s),r(Z,t,s),e(t,ct,s),e(t,R,s),e(t,ft,s),r(v,t,s),e(t,wt,s),e(t,E,s),e(t,jt,s),e(t,B,s),e(t,$t,s),r(N,t,s),e(t,St,s),e(t,F,s),e(t,kt,s),r(x,t,s),e(t,Gt,s),e(t,L,s),e(t,_t,s),r(q,t,s),e(t,Vt,s),e(t,H,s),e(t,It,s),e(t,O,s),e(t,Qt,s),r(W,t,s),e(t,bt,s),e(t,D,s),e(t,Zt,s),r(Y,t,s),e(t,Rt,s),r(A,t,s),e(t,vt,s),e(t,X,s),e(t,Et,s),r(K,t,s),e(t,Bt,s),e(t,st,s),Nt=!0},p:rs,i(t){Nt||(J(h.$$.fragment,t),J(f.$$.fragment,t),J(j.$$.fragment,t),J(k.$$.fragment,t),J(V.$$.fragment,t),J(Z.$$.fragment,t),J(v.$$.fragment,t),J(N.$$.fragment,t),J(x.$$.fragment,t),J(q.$$.fragment,t),J(W.$$.fragment,t),J(Y.$$.fragment,t),J(A.$$.fragment,t),J(K.$$.fragment,t),Nt=!0)},o(t){T(h.$$.fragment,t),T(f.$$.fragment,t),T(j.$$.fragment,t),T(k.$$.fragment,t),T(V.$$.fragment,t),T(Z.$$.fragment,t),T(v.$$.fragment,t),T(N.$$.fragment,t),T(x.$$.fragment,t),T(q.$$.fragment,t),T(W.$$.fragment,t),T(Y.$$.fragment,t),T(A.$$.fragment,t),T(K.$$.fragment,t),Nt=!1},d(t){t&&(l(lt),l(tt),l(et),l(nt),l(C),l(at),l(u),l(pt),l(d),l(it),l(c),l(Ut),l(Mt),l(w),l(yt),l(rt),l($),l(Jt),l(S),l(Tt),l(mt),l(G),l(gt),l(_),l(ot),l(ut),l(I),l(ht),l(Q),l(Ct),l(b),l(dt),l(ct),l(R),l(ft),l(wt),l(E),l(jt),l(B),l($t),l(St),l(F),l(kt),l(Gt),l(L),l(_t),l(Vt),l(H),l(It),l(O),l(Qt),l(bt),l(D),l(Zt),l(Rt),l(vt),l(X),l(Et),l(Bt),l(st)),l(g),m(h,t),m(f,t),m(j,t),m(k,t),m(V,t),m(Z,t),m(v,t),m(N,t),m(x,t),m(q,t),m(W,t),m(Y,t),m(A,t),m(K,t)}}}const Cs='{"title":"LangGraph 的核心构建模块","local":"langgraph-的核心构建模块","sections":[{"title":"1. 状态（State）","local":"1-状态state","sections":[],"depth":2},{"title":"2. 节点（Nodes）","local":"2-节点nodes","sections":[],"depth":2},{"title":"3. 边（Edges）","local":"3-边edges","sections":[],"depth":2},{"title":"4. 状态图（StateGraph）","local":"4-状态图stategraph","sections":[],"depth":2},{"title":"下一步？","local":"下一步","sections":[],"depth":2}],"depth":1}';function ds(xt){return Js(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ss extends Ts{constructor(g){super(),ms(this,g,ds,hs,ys,{})}}export{Ss as component};
