import{s as Xl,n as ql,o as zl}from"../chunks/scheduler.37c15a92.js";import{S as Yl,i as Ll,g as p,s as n,r as U,m as Pl,A as Kl,h as M,f as t,c as a,j as wl,u as J,x as i,n as Dl,k as Jl,y as cl,a as e,v as o,d as w,t as c,w as y}from"../chunks/index.2bf4358c.js";import{C as d}from"../chunks/CodeBlock.4e987730.js";import{H as r}from"../chunks/Heading.8ada512a.js";import{E as Ol}from"../chunks/getInferenceSnippets.0aa3753f.js";function st(yl){let u,ys,ws,us,h,js,C,ul="LlamaIndex 中的工作流提供了一种结构化方式来将代码组织成可管理的顺序步骤。",Ts,I,jl=`这种工作流通过定义由<code>事件（Events）</code>触发的<code>步骤（Steps）</code>来创建，这些步骤本身也会发出<code>事件</code>来触发后续步骤。
让我们看看 Alfred 展示的用于 RAG 任务的 LlamaIndex 工作流。`,ms,b,Tl='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/workflows.png" alt="工作流示意图"/>',ds,f,ml="<strong>工作流具有以下关键优势：</strong>",rs,B,dl="<li>将代码清晰地组织为离散步骤</li> <li>事件驱动架构实现灵活控制流</li> <li>步骤间类型安全的通信</li> <li>内置状态管理</li> <li>支持简单和复杂的智能体交互</li>",hs,k,rl="正如您可能猜到的，<strong>工作流在保持对整体流程控制的同时，实现了智能体的自主性之间的完美平衡。</strong>",Cs,v,hl="现在让我们学习如何自己创建工作流！",Is,Q,bs,j,Cl='<p>您可以通过 <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/llama-index/workflows.ipynb" target="_blank">这个笔记本</a> 中的代码进行实践，可使用 Google Colab 运行。</p>',fs,E,Bs,T,os,Il="安装工作流包",ol,V,ks,_,bl=`我们可以通过定义一个继承自 <code>Workflow</code> 的类并用 <code>@step</code> 装饰你的函数来创建一个单步工作流。
我们还需要添加 <code>StartEvent</code> 和 <code>StopEvent</code>，它们是用于指示工作流开始和结束的特殊事件。`,vs,g,Qs,Z,fl="如您所见，我们现在可以通过调用“w.run()”来运行工作流程。",Es,G,Vs,x,Bl=`为了连接多个步骤，我们<strong>创建在步骤之间传输数据的自定义事件</strong>。
为此，我们需要添加一个在步骤之间传递的“事件”，并将第一步的输出传输到第二步。`,_s,S,gs,$,kl="类型提示在这里很重要，因为它可以确保工作流正确执行。让我们把事情复杂化一点吧！",Zs,F,Gs,W,vl="类型提示是工作流中最强大的部分，因为它允许我们创建分支、循环和连接以促进更复杂的工作流。",xs,R,Ql=`让我们展示一个使用联合运算符 <code>|</code> <strong>创建循环</strong> 的示例。
在下面的示例中，我们看到 <code>LoopEvent</code> 被作为步骤的输入，也可以作为输出返回。`,Ss,A,$s,N,Fs,H,El="我们还可以绘制工作流程。让我们使用 <code>draw_all_possible_flows</code> 函数来绘制工作流程。这会将工作流程存储在 HTML 文件中。",Ws,X,Rs,q,Vl='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/workflow-draw.png" alt="工作流程图"/>',As,z,_l="课程中我们将介绍最后一个很酷的技巧，即向工作流添加状态的能力。",Ns,Y,Hs,L,gl=`当您想要跟踪工作流的状态时，状态管理非常有用，这样每个步骤都可以访问相同的状态。
我们可以在步骤函数中的参数上使用“上下文”类型提示来实现这一点。`,Xs,P,qs,K,Zl="太棒了！现在您知道如何在 LlamaIndex 中创建基本工作流了！",zs,m,Gl='<p>工作流还有一些更复杂的细微差别，您可以在<a href="https://docs.llamaindex.ai/en/stable/understanding/workflows/">LlamaIndex 文档</a>中了解。</p>',Ys,D,xl="但是，还有另一种创建工作流的方法，它依赖于 <code>AgentWorkflow</code> 类。让我们看看如何使用它来创建多智能体工作流。",Ls,O,Ps,ss,Sl=`我们可以使用<strong><code>AgentWorkflow</code> 类来创建多智能体工作流</strong>，而无需手动创建工作流。
<code>AgentWorkflow</code> 使用工作流智能体，允许您创建一个或多个智能体的系统，这些智能体可以根据其专门功能进行协作并相互交接任务。
这可以构建复杂的智能体系统，其中不同的智能体处理任务的不同方面。
我们将从<code>llama_index.core.agent.workflow</code> 导入智能体类，而不是从<code>llama_index.core.agent</code> 导入类。
在<code>AgentWorkflow</code> 构造函数中，必须将一个智能体指定为根智能体。
当用户消息传入时，它首先被路由到根智能体。`,Ks,ls,$l="然后每个智能体可以：",Ds,ts,Fl="<li>使用他们的工具直接处理请求</li> <li>交接给更适合该任务的另一个智能体</li> <li>向用户返回响应</li>",Os,es,Wl="让我们看看如何创建多智能体工作流。",sl,ns,ll,as,Rl=`智能体工具还可以修改我们前面提到的工作流状态。在启动工作流之前，我们可以提供一个可供所有智能体使用的初始状态字典。
状态存储在工作流上下文的 state 键中。它将被注入到 state_prompt 中，以增强每个新用户消息。`,tl,ps,Al="让我们通过修改前面的示例来注入一个计数器来计数函数调用：",el,Ms,nl,is,Nl="恭喜！您现在已经掌握了 LlamaIndex 中 Agent 的基础知识！🎉",al,Us,Hl="让我们继续进行最后一次测验来巩固您的知识！🚀",pl,Js,Ml,cs,il;return h=new r({props:{title:"在 LlamaIndex 中创建智能工作流",local:"在-llamaindex-中创建智能工作流",headingTag:"h1"}}),Q=new r({props:{title:"创建工作流",local:"创建工作流",headingTag:"h2"}}),E=new r({props:{title:"基础工作流创建",local:"基础工作流创建",headingTag:"h3"}}),V=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxsYW1hLWluZGV4LXV0aWxzLXdvcmtmbG93",highlighted:"pip install llama-index-utils-workflow",wrap:!1}}),g=new d({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBTdGFydEV2ZW50JTJDJTIwU3RvcEV2ZW50JTJDJTIwV29ya2Zsb3clMkMlMjBzdGVwJTBBJTBBY2xhc3MlMjBNeVdvcmtmbG93KFdvcmtmbG93KSUzQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMG15X3N0ZXAoc2VsZiUyQyUyMGV2JTNBJTIwU3RhcnRFdmVudCklMjAtJTNFJTIwU3RvcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZG8lMjBzb21ldGhpbmclMjBoZXJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRCUyMkhlbGxvJTJDJTIwd29ybGQhJTIyKSUwQSUwQSUwQXclMjAlM0QlMjBNeVdvcmtmbG93KHRpbWVvdXQlM0QxMCUyQyUyMHZlcmJvc2UlM0RGYWxzZSklMEFyZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHcucnVuKCk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> StartEvent, StopEvent, Workflow, step

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">my_step</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># do something here</span>
        <span class="hljs-keyword">return</span> StopEvent(result=<span class="hljs-string">&quot;Hello, world!&quot;</span>)


w = MyWorkflow(timeout=<span class="hljs-number">10</span>, verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()`,wrap:!1}}),G=new r({props:{title:"连接多个步骤",local:"连接多个步骤",headingTag:"h3"}}),S=new d({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBFdmVudCUwQSUwQWNsYXNzJTIwUHJvY2Vzc2luZ0V2ZW50KEV2ZW50KSUzQSUwQSUyMCUyMCUyMCUyMGludGVybWVkaWF0ZV9yZXN1bHQlM0ElMjBzdHIlMEElMEFjbGFzcyUyME11bHRpU3RlcFdvcmtmbG93KFdvcmtmbG93KSUzQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMHN0ZXBfb25lKHNlbGYlMkMlMjBldiUzQSUyMFN0YXJ0RXZlbnQpJTIwLSUzRSUyMFByb2Nlc3NpbmdFdmVudCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFByb2Nlc3MlMjBpbml0aWFsJTIwZGF0YSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMFByb2Nlc3NpbmdFdmVudChpbnRlcm1lZGlhdGVfcmVzdWx0JTNEJTIyU3RlcCUyMDElMjBjb21wbGV0ZSUyMiklMEElMEElMjAlMjAlMjAlMjAlNDBzdGVwJTBBJTIwJTIwJTIwJTIwYXN5bmMlMjBkZWYlMjBzdGVwX3R3byhzZWxmJTJDJTIwZXYlM0ElMjBQcm9jZXNzaW5nRXZlbnQpJTIwLSUzRSUyMFN0b3BFdmVudCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFVzZSUyMHRoZSUyMGludGVybWVkaWF0ZSUyMHJlc3VsdCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZpbmFsX3Jlc3VsdCUyMCUzRCUyMGYlMjJGaW5pc2hlZCUyMHByb2Nlc3NpbmclM0ElMjAlN0Jldi5pbnRlcm1lZGlhdGVfcmVzdWx0JTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRGZpbmFsX3Jlc3VsdCklMEElMEF3JTIwJTNEJTIwTXVsdGlTdGVwV29ya2Zsb3codGltZW91dCUzRDEwJTJDJTIwdmVyYm9zZSUzREZhbHNlKSUwQXJlc3VsdCUyMCUzRCUyMGF3YWl0JTIwdy5ydW4oKSUwQXJlc3VsdA==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Event

<span class="hljs-keyword">class</span> <span class="hljs-title class_">ProcessingEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    intermediate_result: <span class="hljs-built_in">str</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiStepWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_one</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; ProcessingEvent:
        <span class="hljs-comment"># Process initial data</span>
        <span class="hljs-keyword">return</span> ProcessingEvent(intermediate_result=<span class="hljs-string">&quot;Step 1 complete&quot;</span>)

<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_two</span>(<span class="hljs-params">self, ev: ProcessingEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># Use the intermediate result</span>
        final_result = <span class="hljs-string">f&quot;Finished processing: <span class="hljs-subst">{ev.intermediate_result}</span>&quot;</span>
        <span class="hljs-keyword">return</span> StopEvent(result=final_result)

w = MultiStepWorkflow(timeout=<span class="hljs-number">10</span>, verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()
result`,wrap:!1}}),F=new r({props:{title:"循环和分支",local:"循环和分支",headingTag:"h3"}}),A=new d({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBFdmVudCUwQWltcG9ydCUyMHJhbmRvbSUwQSUwQSUwQWNsYXNzJTIwUHJvY2Vzc2luZ0V2ZW50KEV2ZW50KSUzQSUwQSUyMCUyMCUyMCUyMGludGVybWVkaWF0ZV9yZXN1bHQlM0ElMjBzdHIlMEElMEElMEFjbGFzcyUyMExvb3BFdmVudChFdmVudCklM0ElMEElMjAlMjAlMjAlMjBsb29wX291dHB1dCUzQSUyMHN0ciUwQSUwQSUwQWNsYXNzJTIwTXVsdGlTdGVwV29ya2Zsb3coV29ya2Zsb3cpJTNBJTBBJTIwJTIwJTIwJTIwJTQwc3RlcCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc3RlcF9vbmUoc2VsZiUyQyUyMGV2JTNBJTIwU3RhcnRFdmVudCUyMCU3QyUyMExvb3BFdmVudCklMjAtJTNFJTIwUHJvY2Vzc2luZ0V2ZW50JTIwJTdDJTIwTG9vcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjByYW5kb20ucmFuZGludCgwJTJDJTIwMSklMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyQmFkJTIwdGhpbmclMjBoYXBwZW5lZCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBMb29wRXZlbnQobG9vcF9vdXRwdXQlM0QlMjJCYWNrJTIwdG8lMjBzdGVwJTIwb25lLiUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyR29vZCUyMHRoaW5nJTIwaGFwcGVuZWQlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwUHJvY2Vzc2luZ0V2ZW50KGludGVybWVkaWF0ZV9yZXN1bHQlM0QlMjJGaXJzdCUyMHN0ZXAlMjBjb21wbGV0ZS4lMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTQwc3RlcCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc3RlcF90d28oc2VsZiUyQyUyMGV2JTNBJTIwUHJvY2Vzc2luZ0V2ZW50KSUyMC0lM0UlMjBTdG9wRXZlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBVc2UlMjB0aGUlMjBpbnRlcm1lZGlhdGUlMjByZXN1bHQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmaW5hbF9yZXN1bHQlMjAlM0QlMjBmJTIyRmluaXNoZWQlMjBwcm9jZXNzaW5nJTNBJTIwJTdCZXYuaW50ZXJtZWRpYXRlX3Jlc3VsdCU3RCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMFN0b3BFdmVudChyZXN1bHQlM0RmaW5hbF9yZXN1bHQpJTBBJTBBJTBBdyUyMCUzRCUyME11bHRpU3RlcFdvcmtmbG93KHZlcmJvc2UlM0RGYWxzZSklMEFyZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHcucnVuKCklMEFyZXN1bHQ=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Event
<span class="hljs-keyword">import</span> random


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ProcessingEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    intermediate_result: <span class="hljs-built_in">str</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoopEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    loop_output: <span class="hljs-built_in">str</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiStepWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_one</span>(<span class="hljs-params">self, ev: StartEvent | LoopEvent</span>) -&gt; ProcessingEvent | LoopEvent:
        <span class="hljs-keyword">if</span> random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>) == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Bad thing happened&quot;</span>)
            <span class="hljs-keyword">return</span> LoopEvent(loop_output=<span class="hljs-string">&quot;Back to step one.&quot;</span>)
        <span class="hljs-keyword">else</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Good thing happened&quot;</span>)
            <span class="hljs-keyword">return</span> ProcessingEvent(intermediate_result=<span class="hljs-string">&quot;First step complete.&quot;</span>)

<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_two</span>(<span class="hljs-params">self, ev: ProcessingEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># Use the intermediate result</span>
        final_result = <span class="hljs-string">f&quot;Finished processing: <span class="hljs-subst">{ev.intermediate_result}</span>&quot;</span>
        <span class="hljs-keyword">return</span> StopEvent(result=final_result)


w = MultiStepWorkflow(verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()
result`,wrap:!1}}),N=new r({props:{title:"绘制工作流程",local:"绘制工作流程",headingTag:"h3"}}),X=new d({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LnV0aWxzLndvcmtmbG93JTIwaW1wb3J0JTIwZHJhd19hbGxfcG9zc2libGVfZmxvd3MlMEElMEF3JTIwJTNEJTIwLi4uJTIwJTIzJTIwYXMlMjBkZWZpbmVkJTIwaW4lMjB0aGUlMjBwcmV2aW91cyUyMHNlY3Rpb24lMEFkcmF3X2FsbF9wb3NzaWJsZV9mbG93cyh3JTJDJTIwJTIyZmxvdy5odG1sJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.utils.workflow <span class="hljs-keyword">import</span> draw_all_possible_flows

w = ... <span class="hljs-comment"># as defined in the previous section</span>
draw_all_possible_flows(w, <span class="hljs-string">&quot;flow.html&quot;</span>)`,wrap:!1}}),Y=new r({props:{title:"状态管理",local:"状态管理",headingTag:"h3"}}),P=new d({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBDb250ZXh0JTJDJTIwU3RhcnRFdmVudCUyQyUyMFN0b3BFdmVudCUwQSUwQSUwQSU0MHN0ZXAlMEFhc3luYyUyMGRlZiUyMHF1ZXJ5KHNlbGYlMkMlMjBjdHglM0ElMjBDb250ZXh0JTJDJTIwZXYlM0ElMjBTdGFydEV2ZW50KSUyMC0lM0UlMjBTdG9wRXZlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjAlRTUlQUQlOTglRTUlODIlQTglRTUlOUMlQTglRTQlQjglOEElRTQlQjglOEIlRTYlOTYlODclRTQlQjglQUQlMEElMjAlMjAlMjAlMjBhd2FpdCUyMGN0eC5zdG9yZS5zZXQoJTIycXVlcnklMjIlMkMlMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwJUU2JUEwJUI5JUU2JThEJUFFJUU0JUI4JThBJUU0JUI4JThCJUU2JTk2JTg3JUU1JTkyJThDJUU0JUJBJThCJUU0JUJCJUI2JUU1JTgxJTlBJUU2JTlGJTkwJUU0JUJBJThCJTBBJTIwJTIwJTIwJTIwdmFsJTIwJTNEJTIwLi4uJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwJUU0JUJCJThFJUU0JUI4JThBJUU0JUI4JThCJUU2JTk2JTg3JUU0JUI4JUFEJUU2JUEzJTgwJUU3JUI0JUEyJTBBJTIwJTIwJTIwJTIwcXVlcnklMjAlM0QlMjBhd2FpdCUyMGN0eC5zdG9yZS5nZXQoJTIycXVlcnklMjIpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRHJlc3VsdCk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context, StartEvent, StopEvent


<span class="hljs-meta">@step</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">query</span>(<span class="hljs-params">self, ctx: Context, ev: StartEvent</span>) -&gt; StopEvent:
    <span class="hljs-comment"># 存储在上下文中</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;What is the capital of France?&quot;</span>)

    <span class="hljs-comment"># 根据上下文和事件做某事</span>
    val = ...

    <span class="hljs-comment"># 从上下文中检索</span>
    query = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;query&quot;</span>)

    <span class="hljs-keyword">return</span> StopEvent(result=result)`,wrap:!1}}),O=new r({props:{title:"使用多智能体工作流自动化工作流",local:"使用多智能体工作流自动化工作流",headingTag:"h2"}}),ns=new d({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUuYWdlbnQud29ya2Zsb3clMjBpbXBvcnQlMjBBZ2VudFdvcmtmbG93JTJDJTIwUmVBY3RBZ2VudCUwQWZyb20lMjBsbGFtYV9pbmRleC5sbG1zLmh1Z2dpbmdmYWNlX2FwaSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlSW5mZXJlbmNlQVBJJTBBJTBBJTIzJTIwJUU1JUFFJTlBJUU0JUI5JTg5JUU0JUI4JTgwJUU0JUJBJTlCJUU1JUI3JUE1JUU1JTg1JUI3JTBBZGVmJTIwYWRkKGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50KSUyMC0lM0UlMjBpbnQlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJBZGQlMjB0d28lMjBudW1iZXJzLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGElMjAlMkIlMjBiJTBBJTBBZGVmJTIwbXVsdGlwbHkoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGx5JTIwdHdvJTIwbnVtYmVycy4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBhJTIwKiUyMGIlMEElMEFsbG0lMjAlM0QlMjBIdWdnaW5nRmFjZUluZmVyZW5jZUFQSShtb2RlbF9uYW1lJTNEJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyKSUwQSUwQSUyMyUyMCVFNiU4OCU5MSVFNCVCQiVBQyVFNSU4RiVBRiVFNCVCQiVBNSVFNyU5QiVCNCVFNiU4RSVBNSVFNCVCQyVBMCVFOSU4MCU5MiVFNSU4NyVCRCVFNiU5NSVCMCVFRiVCQyU4QyVFOCU4MCU4QyVFNiU5NyVBMCVFOSU5QyU4MCUyMEZ1bmN0aW9uVG9vbCVFMiU4MCU5NCVFMiU4MCU5NGZuJTJGZG9jc3RyaW5nJTIwJUU0JUJDJTlBJUU4JUEyJUFCJUU4JUE3JUEzJUU2JTlFJTkwJUU0JUI4JUJBJUU1JTkwJThEJUU3JUE3JUIwJTJGJUU2JThGJThGJUU4JUJGJUIwJTBBbXVsdGlwbHlfYWdlbnQlMjAlM0QlMjBSZUFjdEFnZW50KCUwQSUyMCUyMCUyMCUyMG5hbWUlM0QlMjJtdWx0aXBseV9hZ2VudCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIySXMlMjBhYmxlJTIwdG8lMjBtdWx0aXBseSUyMHR3byUyMGludGVnZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3lzdGVtX3Byb21wdCUzRCUyMkElMjBoZWxwZnVsJTIwYXNzaXN0YW50JTIwdGhhdCUyMGNhbiUyMHVzZSUyMGElMjB0b29sJTIwdG8lMjBtdWx0aXBseSUyMG51bWJlcnMuJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJtdWx0aXBseSU1RCUyQyUwQSUyMCUyMCUyMCUyMGxsbSUzRGxsbSUyQyUwQSklMEElMEFhZGRpdGlvbl9hZ2VudCUyMCUzRCUyMFJlQWN0QWdlbnQoJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMmFkZF9hZ2VudCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIySXMlMjBhYmxlJTIwdG8lMjBhZGQlMjB0d28lMjBpbnRlZ2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHN5c3RlbV9wcm9tcHQlM0QlMjJBJTIwaGVscGZ1bCUyMGFzc2lzdGFudCUyMHRoYXQlMjBjYW4lMjB1c2UlMjBhJTIwdG9vbCUyMHRvJTIwYWRkJTIwbnVtYmVycy4lMjIlMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QmFkZCU1RCUyQyUwQSUyMCUyMCUyMCUyMGxsbSUzRGxsbSUyQyUwQSklMEElMEElMjMlMjAlRTUlODglOUIlRTUlQkIlQkElRTUlQjclQTUlRTQlQkQlOUMlRTYlQjUlODElMEF3b3JrZmxvdyUyMCUzRCUyMEFnZW50V29ya2Zsb3coJTBBJTIwJTIwJTIwJTIwYWdlbnRzJTNEJTVCbXVsdGlwbHlfYWdlbnQlMkMlMjBhZGRpdGlvbl9hZ2VudCU1RCUyQyUwQSUyMCUyMCUyMCUyMHJvb3RfYWdlbnQlM0QlMjJtdWx0aXBseV9hZ2VudCUyMiUyQyUwQSklMEElMEElMjMlMjAlRTglQkYlOTAlRTglQTElOEMlRTclQjMlQkIlRTclQkIlOUYlMEFyZXNwb25zZSUyMCUzRCUyMGF3YWl0JTIwd29ya2Zsb3cucnVuKHVzZXJfbXNnJTNEJTIyQ2FuJTIweW91JTIwYWRkJTIwNSUyMGFuZCUyMDMlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.agent.workflow <span class="hljs-keyword">import</span> AgentWorkflow, ReActAgent
<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

<span class="hljs-comment"># 定义一些工具</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Add two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a + b

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

<span class="hljs-comment"># 我们可以直接传递函数，而无需 FunctionTool——fn/docstring 会被解析为名称/描述</span>
multiply_agent = ReActAgent(
    name=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Is able to multiply two integers&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;A helpful assistant that can use a tool to multiply numbers.&quot;</span>,
    tools=[multiply],
    llm=llm,
)

addition_agent = ReActAgent(
    name=<span class="hljs-string">&quot;add_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Is able to add two integers&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;A helpful assistant that can use a tool to add numbers.&quot;</span>,
    tools=[add],
    llm=llm,
)

<span class="hljs-comment"># 创建工作流</span>
workflow = AgentWorkflow(
    agents=[multiply_agent, addition_agent],
    root_agent=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
)

<span class="hljs-comment"># 运行系统</span>
response = <span class="hljs-keyword">await</span> workflow.run(user_msg=<span class="hljs-string">&quot;Can you add 5 and 3?&quot;</span>)`,wrap:!1}}),Ms=new d({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context

<span class="hljs-comment"># 定义一些工具</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">ctx: Context, a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Add two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># update our count</span>
    cur_state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
    cur_state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>] += <span class="hljs-number">1</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;state&quot;</span>, cur_state)

    <span class="hljs-keyword">return</span> a + b

<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">ctx: Context, a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># update our count</span>
    cur_state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
    cur_state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>] += <span class="hljs-number">1</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;state&quot;</span>, cur_state)

    <span class="hljs-keyword">return</span> a * b

...

workflow = AgentWorkflow(
    agents=[multiply_agent, addition_agent],
    root_agent=<span class="hljs-string">&quot;multiply_agent&quot;</span>
    initial_state={<span class="hljs-string">&quot;num_fn_calls&quot;</span>: <span class="hljs-number">0</span>},
    state_prompt=<span class="hljs-string">&quot;Current state: {state}. User message: {msg}&quot;</span>,
)

<span class="hljs-comment"># 使用上下文运行工作流程</span>
ctx = Context(workflow)
response = <span class="hljs-keyword">await</span> workflow.run(user_msg=<span class="hljs-string">&quot;Can you add 5 and 3?&quot;</span>, ctx=ctx)

<span class="hljs-comment"># 拉出并检查状态</span>
state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
<span class="hljs-built_in">print</span>(state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>])`,wrap:!1}}),Js=new Ol({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/zh-CN/unit2/llama-index/workflows.mdx"}}),{c(){u=p("meta"),ys=n(),ws=p("p"),us=n(),U(h.$$.fragment),js=n(),C=p("p"),C.textContent=ul,Ts=n(),I=p("p"),I.innerHTML=jl,ms=n(),b=p("p"),b.innerHTML=Tl,ds=n(),f=p("p"),f.innerHTML=ml,rs=n(),B=p("ul"),B.innerHTML=dl,hs=n(),k=p("p"),k.innerHTML=rl,Cs=n(),v=p("p"),v.textContent=hl,Is=n(),U(Q.$$.fragment),bs=n(),j=p("blockquote"),j.innerHTML=Cl,fs=n(),U(E.$$.fragment),Bs=n(),T=p("details"),os=p("summary"),os.textContent=Il,ol=Pl(`
如 [LlamaHub 章节](llama-hub) 介绍的，我们可以通过以下命令安装工作流包：

	`),U(V.$$.fragment),ks=n(),_=p("p"),_.innerHTML=bl,vs=n(),U(g.$$.fragment),Qs=n(),Z=p("p"),Z.textContent=fl,Es=n(),U(G.$$.fragment),Vs=n(),x=p("p"),x.innerHTML=Bl,_s=n(),U(S.$$.fragment),gs=n(),$=p("p"),$.textContent=kl,Zs=n(),U(F.$$.fragment),Gs=n(),W=p("p"),W.textContent=vl,xs=n(),R=p("p"),R.innerHTML=Ql,Ss=n(),U(A.$$.fragment),$s=n(),U(N.$$.fragment),Fs=n(),H=p("p"),H.innerHTML=El,Ws=n(),U(X.$$.fragment),Rs=n(),q=p("p"),q.innerHTML=Vl,As=n(),z=p("p"),z.textContent=_l,Ns=n(),U(Y.$$.fragment),Hs=n(),L=p("p"),L.textContent=gl,Xs=n(),U(P.$$.fragment),qs=n(),K=p("p"),K.textContent=Zl,zs=n(),m=p("blockquote"),m.innerHTML=Gl,Ys=n(),D=p("p"),D.innerHTML=xl,Ls=n(),U(O.$$.fragment),Ps=n(),ss=p("p"),ss.innerHTML=Sl,Ks=n(),ls=p("p"),ls.textContent=$l,Ds=n(),ts=p("ul"),ts.innerHTML=Fl,Os=n(),es=p("p"),es.textContent=Wl,sl=n(),U(ns.$$.fragment),ll=n(),as=p("p"),as.textContent=Rl,tl=n(),ps=p("p"),ps.textContent=Al,el=n(),U(Ms.$$.fragment),nl=n(),is=p("p"),is.textContent=Nl,al=n(),Us=p("p"),Us.textContent=Hl,pl=n(),U(Js.$$.fragment),Ml=n(),cs=p("p"),this.h()},l(s){const l=Kl("svelte-u9bgzb",document.head);u=M(l,"META",{name:!0,content:!0}),l.forEach(t),ys=a(s),ws=M(s,"P",{}),wl(ws).forEach(t),us=a(s),J(h.$$.fragment,s),js=a(s),C=M(s,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1zncfn"&&(C.textContent=ul),Ts=a(s),I=M(s,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1phl6o4"&&(I.innerHTML=jl),ms=a(s),b=M(s,"P",{"data-svelte-h":!0}),i(b)!=="svelte-1fdqx1j"&&(b.innerHTML=Tl),ds=a(s),f=M(s,"P",{"data-svelte-h":!0}),i(f)!=="svelte-kcsc97"&&(f.innerHTML=ml),rs=a(s),B=M(s,"UL",{"data-svelte-h":!0}),i(B)!=="svelte-hv8940"&&(B.innerHTML=dl),hs=a(s),k=M(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-941b0a"&&(k.innerHTML=rl),Cs=a(s),v=M(s,"P",{"data-svelte-h":!0}),i(v)!=="svelte-10dcwra"&&(v.textContent=hl),Is=a(s),J(Q.$$.fragment,s),bs=a(s),j=M(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(j)!=="svelte-jhglzk"&&(j.innerHTML=Cl),fs=a(s),J(E.$$.fragment,s),Bs=a(s),T=M(s,"DETAILS",{});var Ul=wl(T);os=M(Ul,"SUMMARY",{"data-svelte-h":!0}),i(os)!=="svelte-14m3ggn"&&(os.textContent=Il),ol=Dl(Ul,`
如 [LlamaHub 章节](llama-hub) 介绍的，我们可以通过以下命令安装工作流包：

	`),J(V.$$.fragment,Ul),Ul.forEach(t),ks=a(s),_=M(s,"P",{"data-svelte-h":!0}),i(_)!=="svelte-1dxezou"&&(_.innerHTML=bl),vs=a(s),J(g.$$.fragment,s),Qs=a(s),Z=M(s,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-4urpti"&&(Z.textContent=fl),Es=a(s),J(G.$$.fragment,s),Vs=a(s),x=M(s,"P",{"data-svelte-h":!0}),i(x)!=="svelte-6xydj5"&&(x.innerHTML=Bl),_s=a(s),J(S.$$.fragment,s),gs=a(s),$=M(s,"P",{"data-svelte-h":!0}),i($)!=="svelte-1aahnbx"&&($.textContent=kl),Zs=a(s),J(F.$$.fragment,s),Gs=a(s),W=M(s,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1fzqx5n"&&(W.textContent=vl),xs=a(s),R=M(s,"P",{"data-svelte-h":!0}),i(R)!=="svelte-61qf0g"&&(R.innerHTML=Ql),Ss=a(s),J(A.$$.fragment,s),$s=a(s),J(N.$$.fragment,s),Fs=a(s),H=M(s,"P",{"data-svelte-h":!0}),i(H)!=="svelte-nsfhj0"&&(H.innerHTML=El),Ws=a(s),J(X.$$.fragment,s),Rs=a(s),q=M(s,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1fejrbj"&&(q.innerHTML=Vl),As=a(s),z=M(s,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1g6o0kz"&&(z.textContent=_l),Ns=a(s),J(Y.$$.fragment,s),Hs=a(s),L=M(s,"P",{"data-svelte-h":!0}),i(L)!=="svelte-18z3r0o"&&(L.textContent=gl),Xs=a(s),J(P.$$.fragment,s),qs=a(s),K=M(s,"P",{"data-svelte-h":!0}),i(K)!=="svelte-zlhwuy"&&(K.textContent=Zl),zs=a(s),m=M(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(m)!=="svelte-bf8gqx"&&(m.innerHTML=Gl),Ys=a(s),D=M(s,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1f7ur07"&&(D.innerHTML=xl),Ls=a(s),J(O.$$.fragment,s),Ps=a(s),ss=M(s,"P",{"data-svelte-h":!0}),i(ss)!=="svelte-1q9g7so"&&(ss.innerHTML=Sl),Ks=a(s),ls=M(s,"P",{"data-svelte-h":!0}),i(ls)!=="svelte-x6am9b"&&(ls.textContent=$l),Ds=a(s),ts=M(s,"UL",{"data-svelte-h":!0}),i(ts)!=="svelte-1szl21w"&&(ts.innerHTML=Fl),Os=a(s),es=M(s,"P",{"data-svelte-h":!0}),i(es)!=="svelte-uyi5am"&&(es.textContent=Wl),sl=a(s),J(ns.$$.fragment,s),ll=a(s),as=M(s,"P",{"data-svelte-h":!0}),i(as)!=="svelte-kjz8yo"&&(as.textContent=Rl),tl=a(s),ps=M(s,"P",{"data-svelte-h":!0}),i(ps)!=="svelte-1kmhjoz"&&(ps.textContent=Al),el=a(s),J(Ms.$$.fragment,s),nl=a(s),is=M(s,"P",{"data-svelte-h":!0}),i(is)!=="svelte-65f1le"&&(is.textContent=Nl),al=a(s),Us=M(s,"P",{"data-svelte-h":!0}),i(Us)!=="svelte-xofn8o"&&(Us.textContent=Hl),pl=a(s),J(Js.$$.fragment,s),Ml=a(s),cs=M(s,"P",{}),wl(cs).forEach(t),this.h()},h(){Jl(u,"name","hf:doc:metadata"),Jl(u,"content",lt),Jl(j,"class","tip"),Jl(m,"class","tip")},m(s,l){cl(document.head,u),e(s,ys,l),e(s,ws,l),e(s,us,l),o(h,s,l),e(s,js,l),e(s,C,l),e(s,Ts,l),e(s,I,l),e(s,ms,l),e(s,b,l),e(s,ds,l),e(s,f,l),e(s,rs,l),e(s,B,l),e(s,hs,l),e(s,k,l),e(s,Cs,l),e(s,v,l),e(s,Is,l),o(Q,s,l),e(s,bs,l),e(s,j,l),e(s,fs,l),o(E,s,l),e(s,Bs,l),e(s,T,l),cl(T,os),cl(T,ol),o(V,T,null),e(s,ks,l),e(s,_,l),e(s,vs,l),o(g,s,l),e(s,Qs,l),e(s,Z,l),e(s,Es,l),o(G,s,l),e(s,Vs,l),e(s,x,l),e(s,_s,l),o(S,s,l),e(s,gs,l),e(s,$,l),e(s,Zs,l),o(F,s,l),e(s,Gs,l),e(s,W,l),e(s,xs,l),e(s,R,l),e(s,Ss,l),o(A,s,l),e(s,$s,l),o(N,s,l),e(s,Fs,l),e(s,H,l),e(s,Ws,l),o(X,s,l),e(s,Rs,l),e(s,q,l),e(s,As,l),e(s,z,l),e(s,Ns,l),o(Y,s,l),e(s,Hs,l),e(s,L,l),e(s,Xs,l),o(P,s,l),e(s,qs,l),e(s,K,l),e(s,zs,l),e(s,m,l),e(s,Ys,l),e(s,D,l),e(s,Ls,l),o(O,s,l),e(s,Ps,l),e(s,ss,l),e(s,Ks,l),e(s,ls,l),e(s,Ds,l),e(s,ts,l),e(s,Os,l),e(s,es,l),e(s,sl,l),o(ns,s,l),e(s,ll,l),e(s,as,l),e(s,tl,l),e(s,ps,l),e(s,el,l),o(Ms,s,l),e(s,nl,l),e(s,is,l),e(s,al,l),e(s,Us,l),e(s,pl,l),o(Js,s,l),e(s,Ml,l),e(s,cs,l),il=!0},p:ql,i(s){il||(w(h.$$.fragment,s),w(Q.$$.fragment,s),w(E.$$.fragment,s),w(V.$$.fragment,s),w(g.$$.fragment,s),w(G.$$.fragment,s),w(S.$$.fragment,s),w(F.$$.fragment,s),w(A.$$.fragment,s),w(N.$$.fragment,s),w(X.$$.fragment,s),w(Y.$$.fragment,s),w(P.$$.fragment,s),w(O.$$.fragment,s),w(ns.$$.fragment,s),w(Ms.$$.fragment,s),w(Js.$$.fragment,s),il=!0)},o(s){c(h.$$.fragment,s),c(Q.$$.fragment,s),c(E.$$.fragment,s),c(V.$$.fragment,s),c(g.$$.fragment,s),c(G.$$.fragment,s),c(S.$$.fragment,s),c(F.$$.fragment,s),c(A.$$.fragment,s),c(N.$$.fragment,s),c(X.$$.fragment,s),c(Y.$$.fragment,s),c(P.$$.fragment,s),c(O.$$.fragment,s),c(ns.$$.fragment,s),c(Ms.$$.fragment,s),c(Js.$$.fragment,s),il=!1},d(s){s&&(t(ys),t(ws),t(us),t(js),t(C),t(Ts),t(I),t(ms),t(b),t(ds),t(f),t(rs),t(B),t(hs),t(k),t(Cs),t(v),t(Is),t(bs),t(j),t(fs),t(Bs),t(T),t(ks),t(_),t(vs),t(Qs),t(Z),t(Es),t(Vs),t(x),t(_s),t(gs),t($),t(Zs),t(Gs),t(W),t(xs),t(R),t(Ss),t($s),t(Fs),t(H),t(Ws),t(Rs),t(q),t(As),t(z),t(Ns),t(Hs),t(L),t(Xs),t(qs),t(K),t(zs),t(m),t(Ys),t(D),t(Ls),t(Ps),t(ss),t(Ks),t(ls),t(Ds),t(ts),t(Os),t(es),t(sl),t(ll),t(as),t(tl),t(ps),t(el),t(nl),t(is),t(al),t(Us),t(pl),t(Ml),t(cs)),t(u),y(h,s),y(Q,s),y(E,s),y(V),y(g,s),y(G,s),y(S,s),y(F,s),y(A,s),y(N,s),y(X,s),y(Y,s),y(P,s),y(O,s),y(ns,s),y(Ms,s),y(Js,s)}}}const lt='{"title":"在 LlamaIndex 中创建智能工作流","local":"在-llamaindex-中创建智能工作流","sections":[{"title":"创建工作流","local":"创建工作流","sections":[{"title":"基础工作流创建","local":"基础工作流创建","sections":[],"depth":3},{"title":"连接多个步骤","local":"连接多个步骤","sections":[],"depth":3},{"title":"循环和分支","local":"循环和分支","sections":[],"depth":3},{"title":"绘制工作流程","local":"绘制工作流程","sections":[],"depth":3},{"title":"状态管理","local":"状态管理","sections":[],"depth":3}],"depth":2},{"title":"使用多智能体工作流自动化工作流","local":"使用多智能体工作流自动化工作流","sections":[],"depth":2}],"depth":1}';function tt(yl){return zl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class it extends Yl{constructor(u){super(),Ll(this,u,tt,st,Xl,{})}}export{it as component};
