import{s as je,n as be,o as Ue}from"../chunks/scheduler.c57aa7ef.js";import{S as Ce,i as Ze,g as d,s,r as p,A as Ie,h as i,f as l,c as n,j as Je,u as o,x as m,k as _e,y as ge,a,v as M,d as r,t as c,w as u}from"../chunks/index.394f8801.js";import{C as X}from"../chunks/CodeBlock.b5488637.js";import{H as pe,E as Be}from"../chunks/index.af4fbae1.js";function ke(oe){let y,F,R,v,f,Q,w,me='With PEFT, you can inject trainable adapters into any <code>torch</code> module which allows you to use adapter methods without relying on the modeling classes in PEFT. Currently, PEFT supports injecting <a href="../conceptual_guides/adapter#low-rank-adaptation-lora">LoRA</a>, <a href="../conceptual_guides/adapter#adaptive-low-rank-adaptation-adalora">AdaLoRA</a>, and <a href="../conceptual_guides/ia3">IA3</a> into models because for these adapters, inplace modification of the model is sufficient for finetuning it.',x,T,Me="Check the table below to see when you should inject adapters.",N,h,re="<thead><tr><th>Pros</th> <th>Cons</th></tr></thead> <tbody><tr><td>the model is modified inplace, keeping all the original attributes and methods</td> <td>manually write the <code>from_pretrained</code> and <code>save_pretrained</code> utility functions from Hugging Face to save and load adapters</td></tr> <tr><td>works for any <code>torch</code> module and modality</td> <td>doesn’t work with any of the utility methods provided by <code>PeftModel</code> such as disabling and merging adapters</td></tr></tbody>",Y,J,S,_,ce='To perform the adapter injection, use the <a href="/docs/peft/main/en/package_reference/peft_model#peft.inject_adapter_in_model">inject_adapter_in_model()</a> method. This method takes 3 arguments, the PEFT config, the model, and an optional adapter name. You can also attach multiple adapters to the model if you call <a href="/docs/peft/main/en/package_reference/peft_model#peft.inject_adapter_in_model">inject_adapter_in_model()</a> multiple times with different adapter names.',H,j,ue="For example, to inject LoRA adapters into the <code>linear</code> submodule of the <code>DummyModel</code> module:",z,b,L,U,ye="Print the model to see that the adapters have been correctly injected.",D,C,K,Z,P,I,fe='To only save the adapter, use the <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model_state_dict">get_peft_model_state_dict()</a> function:',q,g,O,B,we="Otherwise, <code>model.state_dict()</code> returns the full state dict of the model.",ee,k,te,W,Te="After loading the saved <code>state_dict</code>, it can be applied using the <code>set_peft_model_state_dict()</code> function:",le,G,ae,E,he='If injecting the adapter is slow or you need to load a large number of adapters, you may use an optimization that allows to create an “empty” adapter on meta device and only fills the weights with real weights when the <code>set_peft_model_state_dict()</code> is called. To do this, pass <code>low_cpu_mem_usage=True</code> to both <a href="/docs/peft/main/en/package_reference/peft_model#peft.inject_adapter_in_model">inject_adapter_in_model()</a> and <code>set_peft_model_state_dict()</code>.',se,V,ne,$,de,A,ie;return f=new pe({props:{title:"Adapter injection",local:"adapter-injection",headingTag:"h1"}}),J=new pe({props:{title:"Creating a new PEFT model",local:"creating-a-new-peft-model",headingTag:"h2"}}),b=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMGluamVjdF9hZGFwdGVyX2luX21vZGVsJTJDJTIwTG9yYUNvbmZpZyUwQSUwQWNsYXNzJTIwRHVtbXlNb2RlbCh0b3JjaC5ubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmVtYmVkZGluZyUyMCUzRCUyMHRvcmNoLm5uLkVtYmVkZGluZygxMCUyQyUyMDEwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubGluZWFyJTIwJTNEJTIwdG9yY2gubm4uTGluZWFyKDEwJTJDJTIwMTApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5sbV9oZWFkJTIwJTNEJTIwdG9yY2gubm4uTGluZWFyKDEwJTJDJTIwMTApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwaW5wdXRfaWRzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjBzZWxmLmVtYmVkZGluZyhpbnB1dF9pZHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYubGluZWFyKHgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYubG1faGVhZCh4KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHglMEElMEElMEFsb3JhX2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9yYV9hbHBoYSUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwciUzRDY0JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmxpbmVhciUyMiU1RCUyQyUwQSklMEElMEFtb2RlbCUyMCUzRCUyMER1bW15TW9kZWwoKSUwQW1vZGVsJTIwJTNEJTIwaW5qZWN0X2FkYXB0ZXJfaW5fbW9kZWwobG9yYV9jb25maWclMkMlMjBtb2RlbCklMEElMEFkdW1teV9pbnB1dHMlMjAlM0QlMjB0b3JjaC5Mb25nVGVuc29yKCU1QiU1QjAlMkMlMjAxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTJDJTIwNSUyQyUyMDYlMkMlMjA3JTVEJTVEKSUwQWR1bW15X291dHB1dHMlMjAlM0QlMjBtb2RlbChkdW1teV9pbnB1dHMp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> inject_adapter_in_model, LoraConfig

<span class="hljs-keyword">class</span> <span class="hljs-title class_">DummyModel</span>(torch.nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.embedding = torch.nn.Embedding(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.linear = torch.nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.lm_head = torch.nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, input_ids</span>):
        x = self.embedding(input_ids)
        x = self.linear(x)
        x = self.lm_head(x)
        <span class="hljs-keyword">return</span> x


lora_config = LoraConfig(
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.1</span>,
    r=<span class="hljs-number">64</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    target_modules=[<span class="hljs-string">&quot;linear&quot;</span>],
)

model = DummyModel()
model = inject_adapter_in_model(lora_config, model)

dummy_inputs = torch.LongTensor([[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>]])
dummy_outputs = model(dummy_inputs)`,wrap:!1}}),C=new X({props:{code:"RHVtbXlNb2RlbCglMEElMjAlMjAoZW1iZWRkaW5nKSUzQSUyMEVtYmVkZGluZygxMCUyQyUyMDEwKSUwQSUyMCUyMChsaW5lYXIpJTNBJTIwTGluZWFyKCUwQSUyMCUyMCUyMCUyMGluX2ZlYXR1cmVzJTNEMTAlMkMlMjBvdXRfZmVhdHVyZXMlM0QxMCUyQyUyMGJpYXMlM0RUcnVlJTBBJTIwJTIwJTIwJTIwKGxvcmFfZHJvcG91dCklM0ElMjBNb2R1bGVEaWN0KCUwQSUyMCUyMCUyMCUyMCUyMCUyMChkZWZhdWx0KSUzQSUyMERyb3BvdXQocCUzRDAuMSUyQyUyMGlucGxhY2UlM0RGYWxzZSklMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwKGxvcmFfQSklM0ElMjBNb2R1bGVEaWN0KCUwQSUyMCUyMCUyMCUyMCUyMCUyMChkZWZhdWx0KSUzQSUyMExpbmVhcihpbl9mZWF0dXJlcyUzRDEwJTJDJTIwb3V0X2ZlYXR1cmVzJTNENjQlMkMlMjBiaWFzJTNERmFsc2UpJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMChsb3JhX0IpJTNBJTIwTW9kdWxlRGljdCglMEElMjAlMjAlMjAlMjAlMjAlMjAoZGVmYXVsdCklM0ElMjBMaW5lYXIoaW5fZmVhdHVyZXMlM0Q2NCUyQyUyMG91dF9mZWF0dXJlcyUzRDEwJTJDJTIwYmlhcyUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAobG9yYV9lbWJlZGRpbmdfQSklM0ElMjBQYXJhbWV0ZXJEaWN0KCklMEElMjAlMjAlMjAlMjAobG9yYV9lbWJlZGRpbmdfQiklM0ElMjBQYXJhbWV0ZXJEaWN0KCklMEElMjAlMjApJTBBJTIwJTIwKGxtX2hlYWQpJTNBJTIwTGluZWFyKGluX2ZlYXR1cmVzJTNEMTAlMkMlMjBvdXRfZmVhdHVyZXMlM0QxMCUyQyUyMGJpYXMlM0RUcnVlKSUwQSk=",highlighted:`DummyModel(
  (embedding): Embedding(10, 10)
  (linear): Linear(
    in_features=10, out_features=10, bias=True
    (lora_dropout): ModuleDict(
      (default): Dropout(p=0.1, inplace=False)
    )
    (lora_A): ModuleDict(
      (default): Linear(in_features=10, out_features=64, bias=False)
    )
    (lora_B): ModuleDict(
      (default): Linear(in_features=64, out_features=10, bias=False)
    )
    (lora_embedding_A): ParameterDict()
    (lora_embedding_B): ParameterDict()
  )
  (lm_head): Linear(in_features=10, out_features=10, bias=True)
)`,wrap:!1}}),Z=new pe({props:{title:"Saving the model",local:"saving-the-model",headingTag:"h2"}}),g=new X({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbF9zdGF0ZV9kaWN0JTBBJTBBcGVmdF9zdGF0ZV9kaWN0JTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWxfc3RhdGVfZGljdChtb2RlbCklMEFwcmludChwZWZ0X3N0YXRlX2RpY3Qp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model_state_dict

peft_state_dict = get_peft_model_state_dict(model)
<span class="hljs-built_in">print</span>(peft_state_dict)`,wrap:!1}}),k=new pe({props:{title:"Loading the model",local:"loading-the-model",headingTag:"h2"}}),G=new X({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBzZXRfcGVmdF9tb2RlbF9zdGF0ZV9kaWN0JTBBJTBBbW9kZWwlMjAlM0QlMjBEdW1teU1vZGVsKCklMEFtb2RlbCUyMCUzRCUyMGluamVjdF9hZGFwdGVyX2luX21vZGVsKGxvcmFfY29uZmlnJTJDJTIwbW9kZWwpJTBBb3V0Y29tZSUyMCUzRCUyMHNldF9wZWZ0X21vZGVsX3N0YXRlX2RpY3QobW9kZWwlMkMlMjBwZWZ0X3N0YXRlX2RpY3QpJTBBJTIzJTIwY2hlY2slMjB0aGF0JTIwdGhlcmUlMjB3ZXJlJTIwbm8lMjB3cm9uZyUyMGtleXMlMEFwcmludChvdXRjb21lLnVuZXhwZWN0ZWRfa2V5cyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> set_peft_model_state_dict

model = DummyModel()
model = inject_adapter_in_model(lora_config, model)
outcome = set_peft_model_state_dict(model, peft_state_dict)
<span class="hljs-comment"># check that there were no wrong keys</span>
<span class="hljs-built_in">print</span>(outcome.unexpected_keys)`,wrap:!1}}),V=new X({props:{code:"bW9kZWwlMjAlM0QlMjBEdW1teU1vZGVsKCklMEFtb2RlbCUyMCUzRCUyMGluamVjdF9hZGFwdGVyX2luX21vZGVsKGxvcmFfY29uZmlnJTJDJTIwbW9kZWwlMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUpJTBBJTBBcHJpbnQobW9kZWwubGluZWFyLmxvcmFfQSU1QiUyMmRlZmF1bHQlMjIlNUQud2VpZ2h0LmRldmljZS50eXBlJTIwJTNEJTNEJTIwJTIybWV0YSUyMiklMjAlMjAlMjMlMjBzaG91bGQlMjBiZSUyMFRydWUlMEFzZXRfcGVmdF9tb2RlbF9zdGF0ZV9kaWN0KG1vZGVsJTJDJTIwcGVmdF9zdGF0ZV9kaWN0JTJDJTIwbG93X2NwdV9tZW1fdXNhZ2UlM0RUcnVlKSUwQXByaW50KG1vZGVsLmxpbmVhci5sb3JhX0ElNUIlMjJkZWZhdWx0JTIyJTVELndlaWdodC5kZXZpY2UudHlwZSUyMCUzRCUzRCUyMCUyMmNwdSUyMiklMjAlMjAlMjMlMjBzaG91bGQlMjBiZSUyMFRydWU=",highlighted:`model = DummyModel()
model = inject_adapter_in_model(lora_config, model, low_cpu_mem_usage=<span class="hljs-literal">True</span>)

<span class="hljs-built_in">print</span>(model.linear.lora_A[<span class="hljs-string">&quot;default&quot;</span>].weight.device.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;meta&quot;</span>)  <span class="hljs-comment"># should be True</span>
set_peft_model_state_dict(model, peft_state_dict, low_cpu_mem_usage=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(model.linear.lora_A[<span class="hljs-string">&quot;default&quot;</span>].weight.device.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;cpu&quot;</span>)  <span class="hljs-comment"># should be True</span>`,wrap:!1}}),$=new Be({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/low_level_api.md"}}),{c(){y=d("meta"),F=s(),R=d("p"),v=s(),p(f.$$.fragment),Q=s(),w=d("p"),w.innerHTML=me,x=s(),T=d("p"),T.textContent=Me,N=s(),h=d("table"),h.innerHTML=re,Y=s(),p(J.$$.fragment),S=s(),_=d("p"),_.innerHTML=ce,H=s(),j=d("p"),j.innerHTML=ue,z=s(),p(b.$$.fragment),L=s(),U=d("p"),U.textContent=ye,D=s(),p(C.$$.fragment),K=s(),p(Z.$$.fragment),P=s(),I=d("p"),I.innerHTML=fe,q=s(),p(g.$$.fragment),O=s(),B=d("p"),B.innerHTML=we,ee=s(),p(k.$$.fragment),te=s(),W=d("p"),W.innerHTML=Te,le=s(),p(G.$$.fragment),ae=s(),E=d("p"),E.innerHTML=he,se=s(),p(V.$$.fragment),ne=s(),p($.$$.fragment),de=s(),A=d("p"),this.h()},l(e){const t=Ie("svelte-u9bgzb",document.head);y=i(t,"META",{name:!0,content:!0}),t.forEach(l),F=n(e),R=i(e,"P",{}),Je(R).forEach(l),v=n(e),o(f.$$.fragment,e),Q=n(e),w=i(e,"P",{"data-svelte-h":!0}),m(w)!=="svelte-1sptwg7"&&(w.innerHTML=me),x=n(e),T=i(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-mj4045"&&(T.textContent=Me),N=n(e),h=i(e,"TABLE",{"data-svelte-h":!0}),m(h)!=="svelte-j2tc6m"&&(h.innerHTML=re),Y=n(e),o(J.$$.fragment,e),S=n(e),_=i(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1g0ub5c"&&(_.innerHTML=ce),H=n(e),j=i(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-tifeyo"&&(j.innerHTML=ue),z=n(e),o(b.$$.fragment,e),L=n(e),U=i(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-3xa704"&&(U.textContent=ye),D=n(e),o(C.$$.fragment,e),K=n(e),o(Z.$$.fragment,e),P=n(e),I=i(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-d53opr"&&(I.innerHTML=fe),q=n(e),o(g.$$.fragment,e),O=n(e),B=i(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1hk759o"&&(B.innerHTML=we),ee=n(e),o(k.$$.fragment,e),te=n(e),W=i(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-197rq1s"&&(W.innerHTML=Te),le=n(e),o(G.$$.fragment,e),ae=n(e),E=i(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-phb375"&&(E.innerHTML=he),se=n(e),o(V.$$.fragment,e),ne=n(e),o($.$$.fragment,e),de=n(e),A=i(e,"P",{}),Je(A).forEach(l),this.h()},h(){_e(y,"name","hf:doc:metadata"),_e(y,"content",We)},m(e,t){ge(document.head,y),a(e,F,t),a(e,R,t),a(e,v,t),M(f,e,t),a(e,Q,t),a(e,w,t),a(e,x,t),a(e,T,t),a(e,N,t),a(e,h,t),a(e,Y,t),M(J,e,t),a(e,S,t),a(e,_,t),a(e,H,t),a(e,j,t),a(e,z,t),M(b,e,t),a(e,L,t),a(e,U,t),a(e,D,t),M(C,e,t),a(e,K,t),M(Z,e,t),a(e,P,t),a(e,I,t),a(e,q,t),M(g,e,t),a(e,O,t),a(e,B,t),a(e,ee,t),M(k,e,t),a(e,te,t),a(e,W,t),a(e,le,t),M(G,e,t),a(e,ae,t),a(e,E,t),a(e,se,t),M(V,e,t),a(e,ne,t),M($,e,t),a(e,de,t),a(e,A,t),ie=!0},p:be,i(e){ie||(r(f.$$.fragment,e),r(J.$$.fragment,e),r(b.$$.fragment,e),r(C.$$.fragment,e),r(Z.$$.fragment,e),r(g.$$.fragment,e),r(k.$$.fragment,e),r(G.$$.fragment,e),r(V.$$.fragment,e),r($.$$.fragment,e),ie=!0)},o(e){c(f.$$.fragment,e),c(J.$$.fragment,e),c(b.$$.fragment,e),c(C.$$.fragment,e),c(Z.$$.fragment,e),c(g.$$.fragment,e),c(k.$$.fragment,e),c(G.$$.fragment,e),c(V.$$.fragment,e),c($.$$.fragment,e),ie=!1},d(e){e&&(l(F),l(R),l(v),l(Q),l(w),l(x),l(T),l(N),l(h),l(Y),l(S),l(_),l(H),l(j),l(z),l(L),l(U),l(D),l(K),l(P),l(I),l(q),l(O),l(B),l(ee),l(te),l(W),l(le),l(ae),l(E),l(se),l(ne),l(de),l(A)),l(y),u(f,e),u(J,e),u(b,e),u(C,e),u(Z,e),u(g,e),u(k,e),u(G,e),u(V,e),u($,e)}}}const We='{"title":"Adapter injection","local":"adapter-injection","sections":[{"title":"Creating a new PEFT model","local":"creating-a-new-peft-model","sections":[],"depth":2},{"title":"Saving the model","local":"saving-the-model","sections":[],"depth":2},{"title":"Loading the model","local":"loading-the-model","sections":[],"depth":2}],"depth":1}';function Ge(oe){return Ue(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ae extends Ce{constructor(y){super(),Ze(this,y,Ge,ke,je,{})}}export{Ae as component};
