import{s as dl,f as pl,o as ml,n as It}from"../chunks/scheduler.9212057a.js";import{S as cl,i as hl,g as n,s,r as u,A as Ml,h as i,f as l,c as a,j as ul,u as d,x as p,k as jt,y as bl,a as o,v as m,d as c,t as h,w as M}from"../chunks/index.59dd74e5.js";import{T as Ct}from"../chunks/Tip.e2b5578c.js";import{C as y}from"../chunks/CodeBlock.06303aa5.js";import{D as fl}from"../chunks/DocNotebookDropdown.08420028.js";import{H as $,E as yl}from"../chunks/EditOnGithub.9be697b9.js";function gl(w){let r,f='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){r=n("p"),r.innerHTML=f},l(b){r=i(b,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1p1d9vw"&&(r.innerHTML=f)},m(b,g){o(b,r,g)},p:It,d(b){b&&l(r)}}}function wl(w){let r,f="gradio-tools require <em>textual</em> inputs and outputs even when working with different modalities like image and audio objects. Image and audio inputs and outputs are currently incompatible.";return{c(){r=n("p"),r.innerHTML=f},l(b){r=i(b,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1vfyu6i"&&(r.innerHTML=f)},m(b,g){o(b,r,g)},p:It,d(b){b&&l(r)}}}function Tl(w){let r,f="Beware of not adding too many tools to an agent: this can overwhelm weaker LLM engines.";return{c(){r=n("p"),r.textContent=f},l(b){r=i(b,"P",{"data-svelte-h":!0}),p(r)!=="svelte-h9mzfm"&&(r.textContent=f)},m(b,g){o(b,r,g)},p:It,d(b){b&&l(r)}}}function Jl(w){let r,f,b,g,v,$e,j,ve,C,_t="Here, we’re going to see advanced tool usage.",je,T,Ce,I,Ie,_,Zt='Let’s take again the tool example from the <a href="../quicktour">quicktour</a>, for which we had implemented a <code>@tool</code> decorator. The <code>tool</code> decorator is the standard format, but sometimes you need more: use several methods in a class for more clarity, or using additional class attributes.',_e,Z,Gt='In this case, you can build your tool following the fine-grained method: building a class that inherits from the <a href="/docs/smolagents/v0.1.3/en/reference/tools#smolagents.Tool">Tool</a> superclass.',Ze,G,kt="The custom tool needs:",Ge,k,Ht="<li>An attribute <code>name</code>, which corresponds to the name of the tool itself. The name usually describes what the tool does. Since the code returns the model with the most downloads for a task, let’s name it <code>model_download_counter</code>.</li> <li>An attribute <code>description</code> is used to populate the agent’s system prompt.</li> <li>An <code>inputs</code> attribute, which is a dictionary with keys <code>&quot;type&quot;</code> and <code>&quot;description&quot;</code>. It contains information that helps the Python interpreter make educated choices about the input.</li> <li>An <code>output_type</code> attribute, which specifies the output type.</li> <li>A <code>forward</code> method which contains the inference code to be executed.</li>",ke,H,Bt='The types for both <code>inputs</code> and <code>output_type</code> should be amongst <a href="https://docs.pydantic.dev/latest/concepts/json_schema/#generating-json-schema" rel="nofollow">Pydantic formats</a>, they can be either of these: <code>~AUTHORIZED_TYPES()</code>.',He,B,xt="Also, all imports should be put within the tool’s forward function, else you will get an error.",Be,x,xe,V,Vt="Now the custom <code>HfModelDownloadsTool</code> class is ready.",Ve,R,Re,W,Rt='You can also share your custom tool to the Hub by calling <a href="/docs/smolagents/v0.1.3/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> on the tool. Make sure you’ve created a repository for it on the Hub and are using a token with read access.',We,Q,Qe,F,Wt="For the push to Hub to work, your tool will need to respect some rules:",Fe,S,Qt="<li>All method are self-contained, e.g. use variables that come either from their args,</li> <li>If you subclass the <code>__init__</code> method, you can give it no other argument than <code>self</code>. This is because arguments set during a specific tool instance’s initialization are hard to track, which prevents from sharing them properly to the hub. And anyway, the idea of making a specific class is that you can already set class attributes for anything you need to hard-code (just set <code>your_variable=(...)</code> directly under the <code>class YourTool(Tool):</code> line). And of course you can still create a class attribute anywhere in your code by assigning stuff to <code>self.your_variable</code>.</li>",Se,N,Ft=`Once your tool is pushed to Hub, you can load it with the <code>~Tool.load_tool</code> function and pass it to the <code>tools</code> parameter in your agent.
Since running tools means running custom code, you need to make sure you trust the repository, and pass <code>trust_remote_code=True</code>.`,Ne,E,Ee,A,Ae,X,St='You can directly import a Space from the Hub as a tool using the <a href="/docs/smolagents/v0.1.3/en/reference/tools#smolagents.Tool.from_space">Tool.from_space()</a> method!',Xe,Y,Nt='You only need to provide the id of the Space on the Hub, its name, and a description that will help you agent understand what the tool does. Under the hood, this will use <a href="https://pypi.org/project/gradio-client/" rel="nofollow"><code>gradio-client</code></a> library to call the Space.',Ye,q,Et='For instance, let’s import the <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a> Space from the Hub and use it to generate an image.',qe,z,ze,L,At="And voilà, here’s your image! 🏖️",Le,Te,Xt,Pe,P,Yt="Then you can use this tool just like any other tool.  For example, let’s improve the prompt  <code>a rabbit wearing a space suit</code> and generate an image of it.",De,D,Ke,K,Oe,Je,qt,et,O,zt="How cool is this? 🤩",tt,ee,lt,te,Lt=`<a href="https://github.com/freddyaboulton/gradio-tools" rel="nofollow">gradio-tools</a> is a powerful library that allows using Hugging
Face Spaces as tools. It supports many existing Spaces as well as custom Spaces.`,ot,le,Pt='Transformers supports <code>gradio_tools</code> with the <a href="/docs/smolagents/v0.1.3/en/reference/tools#smolagents.Tool.from_gradio">Tool.from_gradio()</a> method. For example, let’s use the <a href="https://github.com/freddyaboulton/gradio-tools/blob/main/gradio_tools/tools/prompt_generator.py" rel="nofollow"><code>StableDiffusionPromptGeneratorTool</code></a> from <code>gradio-tools</code> toolkit for improving prompts to generate better images.',st,oe,Dt="Import and instantiate the tool, then pass it to the <code>Tool.from_gradio</code> method:",at,se,nt,J,it,ae,rt,ne,Kt=`We love Langchain and think it has a very compelling suite of tools.
To import a tool from LangChain, use the <code>from_langchain()</code> method.`,pt,ie,Ot=`Here is how you can use it to recreate the intro’s search result using a LangChain web search tool.
This tool will need <code>pip install langchain google-search-results -q</code> to work properly.`,ut,re,dt,pe,mt,ue,el="You can manage an agent’s toolbox by adding or replacing a tool.",ct,de,tl="Let’s add the <code>model_download_tool</code> to an existing agent initialized with only the default toolbox.",ht,me,Mt,ce,ll="Now we can leverage the new tool:",bt,he,ft,U,yt,Me,ol=`Use the <code>agent.toolbox.update_tool()</code> method to replace an existing tool in the agent’s toolbox.
This is useful if your new tool is a one-to-one replacement of the existing tool because the agent already knows how to perform that specific task.
Just make sure the new tool follows the same API as the replaced tool or adapt the system prompt template to ensure all examples using the replaced tool are updated.`,gt,be,wt,fe,sl=`You can leverage tool collections by using the ToolCollection object, with the slug of the collection you want to use.
Then pass them as a list to initialize you agent, and start using them!`,Tt,ye,Jt,ge,al="To speed up the start, tools are loaded only if called by the agent.",Ut,we,$t,Ue,vt;return v=new $({props:{title:"Tools",local:"tools",headingTag:"h1"}}),j=new fl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"}]}}),T=new Ct({props:{warning:!1,$$slots:{default:[gl]},$$scope:{ctx:w}}}),I=new $({props:{title:"Directly define a tool by subclassing Tool",local:"directly-define-a-tool-by-subclassing-tool",headingTag:"h3"}}),x=new y({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBJTBBY2xhc3MlMjBIRk1vZGVsRG93bmxvYWRzVG9vbChUb29sKSUzQSUwQSUyMCUyMCUyMCUyMG5hbWUlMjAlM0QlMjAlMjJtb2RlbF9kb3dubG9hZF9jb3VudGVyJTIyJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBUaGlzJTIwaXMlMjBhJTIwdG9vbCUyMHRoYXQlMjByZXR1cm5zJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkZWQlMjBtb2RlbCUyMG9mJTIwYSUyMGdpdmVuJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTBBJTIwJTIwJTIwJTIwSXQlMjByZXR1cm5zJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2hlY2twb2ludC4lMjIlMjIlMjIlMEElMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0YXNrJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIydGhlJTIwdGFzayUyMGNhdGVnb3J5JTIwKHN1Y2glMjBhcyUyMHRleHQtY2xhc3NpZmljYXRpb24lMkMlMjBkZXB0aC1lc3RpbWF0aW9uJTJDJTIwZXRjKSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTIwJTNEJTIwJTIyc3RyaW5nJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGFzayUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWwuaWQlMEF0b29sJTIwJTNEJTIwSEZNb2RlbERvd25sb2Fkc1Rvb2woKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;model_download_counter&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub.
    It returns the name of the checkpoint.&quot;&quot;&quot;</span>

    inputs = {
        <span class="hljs-string">&quot;task&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the task category (such as text-classification, depth-estimation, etc)&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, task: <span class="hljs-built_in">str</span></span>):
        <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

        model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
        <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>
tool = HFModelDownloadsTool()`,wrap:!1}}),R=new $({props:{title:"Share your tool to the Hub",local:"share-your-tool-to-the-hub",headingTag:"h3"}}),Q=new y({props:{code:"dG9vbC5wdXNoX3RvX2h1YiglMjIlN0J5b3VyX3VzZXJuYW1lJTdEJTJGaGYtbW9kZWwtZG93bmxvYWRzJTIyJTJDJTIwdG9rZW4lM0QlMjIlM0NZT1VSX0hVR0dJTkdGQUNFSFVCX0FQSV9UT0tFTiUzRSUyMik=",highlighted:'tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),E=new y({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMEElMEFtb2RlbF9kb3dubG9hZF90b29sJTIwJTNEJTIwbG9hZF90b29sKCUwQSUyMCUyMCUyMCUyMCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZoZi1tb2RlbC1kb3dubG9hZHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent

model_download_tool = load_tool(
    <span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)`,wrap:!1}}),A=new $({props:{title:"Import a Space as a tool",local:"import-a-space-as-a-tool",headingTag:"h3"}}),z=new y({props:{code:"aW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwVG9vbC5mcm9tX3NwYWNlKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLXNjaG5lbGwlMjIlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyaW1hZ2VfZ2VuZXJhdG9yJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJHZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBmcm9tJTIwYSUyMHByb21wdCUyMiUwQSklMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2woJTIyQSUyMHN1bm55JTIwYmVhY2glMjIp",highlighted:`image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

image_generation_tool(<span class="hljs-string">&quot;A sunny beach&quot;</span>)`,wrap:!1}}),D=new y({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBIZkFwaU1vZGVsKCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QmltYWdlX2dlbmVyYXRpb25fdG9vbCU1RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBJTBBYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkltcHJvdmUlMjB0aGlzJTIwcHJvbXB0JTJDJTIwdGhlbiUyMGdlbmVyYXRlJTIwYW4lMjBpbWFnZSUyMG9mJTIwaXQuJTIyJTJDJTIwcHJvbXB0JTNEJ0ElMjByYWJiaXQlMjB3ZWFyaW5nJTIwYSUyMHNwYWNlJTIwc3VpdCclMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel

model = HfApiModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>, prompt=<span class="hljs-string">&#x27;A rabbit wearing a space suit&#x27;</span>
)`,wrap:!1}}),K=new y({props:{code:"JTBBQWdlbnQlMjBpcyUyMGV4ZWN1dGluZyUyMHRoZSUyMGNvZGUlMjBiZWxvdyUzQQ==",highlighted:`=== Agent thoughts:
improved_prompt could be &quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;

Now that I have improved the prompt, I can use the image generator tool to generate an image based on this prompt.
&gt;&gt;&gt; Agent is executing the code below:
image = image_generator(prompt=&quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;)
final_answer(image)`,wrap:!1}}),ee=new $({props:{title:"Use gradio-tools",local:"use-gradio-tools",headingTag:"h3"}}),se=new y({props:{code:"ZnJvbSUyMGdyYWRpb190b29scyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblByb21wdEdlbmVyYXRvclRvb2wlMEElMEFncmFkaW9fcHJvbXB0X2dlbmVyYXRvcl90b29sJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUHJvbXB0R2VuZXJhdG9yVG9vbCgpJTBBcHJvbXB0X2dlbmVyYXRvcl90b29sJTIwJTNEJTIwVG9vbC5mcm9tX2dyYWRpbyhncmFkaW9fcHJvbXB0X2dlbmVyYXRvcl90b29sKQ==",highlighted:`<span class="hljs-keyword">from</span> gradio_tools <span class="hljs-keyword">import</span> StableDiffusionPromptGeneratorTool

gradio_prompt_generator_tool = StableDiffusionPromptGeneratorTool()
prompt_generator_tool = Tool.from_gradio(gradio_prompt_generator_tool)`,wrap:!1}}),J=new Ct({props:{warning:!0,$$slots:{default:[wl]},$$scope:{ctx:w}}}),ae=new $({props:{title:"Use LangChain tools",local:"use-langchain-tools",headingTag:"h3"}}),re=new y({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwbW9yZSUyMGJsb2NrcyUyMChhbHNvJTIwZGVub3RlZCUyMGFzJTIwbGF5ZXJzKSUyMGFyZSUyMGluJTIwQkVSVCUyMGJhc2UlMjBlbmNvZGVyJTIwY29tcGFyZWQlMjB0byUyMHRoZSUyMGVuY29kZXIlMjBmcm9tJTIwdGhlJTIwYXJjaGl0ZWN0dXJlJTIwcHJvcG9zZWQlMjBpbiUyMEF0dGVudGlvbiUyMGlzJTIwQWxsJTIwWW91JTIwTmVlZCUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;How many more blocks (also denoted as layers) are in BERT base encoder compared to the encoder from the architecture proposed in Attention is All You Need?&quot;</span>)`,wrap:!1}}),pe=new $({props:{title:"Manage your agent’s toolbox",local:"manage-your-agents-toolbox",headingTag:"h3"}}),me=new y({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBIZkFwaU1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBIZkFwaU1vZGVsKCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiklMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBYWdlbnQudG9vbGJveC5hZGRfdG9vbChtb2RlbF9kb3dubG9hZF90b29sKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> HfApiModel

model = HfApiModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)
agent.toolbox.add_tool(model_download_tool)`,wrap:!1}}),he=new y({props:{code:"YWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwYnV0JTIwcmV2ZXJzZSUyMHRoZSUyMGxldHRlcnMlM0YlMjIlMEEp",highlighted:`agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub but reverse the letters?&quot;</span>
)`,wrap:!1}}),U=new Ct({props:{warning:!1,$$slots:{default:[Tl]},$$scope:{ctx:w}}}),be=new $({props:{title:"Use a collection of tools",local:"use-a-collection-of-tools",headingTag:"h3"}}),ye=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRvb2xDb2xsZWN0aW9uJTJDJTIwQ29kZUFnZW50JTBBJTBBaW1hZ2VfdG9vbF9jb2xsZWN0aW9uJTIwJTNEJTIwVG9vbENvbGxlY3Rpb24oJTBBJTIwJTIwJTIwJTIwY29sbGVjdGlvbl9zbHVnJTNEJTIyaHVnZ2luZ2ZhY2UtdG9vbHMlMkZkaWZmdXNpb24tdG9vbHMtNjYzMGJiMTlhOTQyYzIzMDZhMmNkYjZmJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW4lM0QlMjIlM0NZT1VSX0hVR0dJTkdGQUNFSFVCX0FQSV9UT0tFTiUzRSUyMiUwQSklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QippbWFnZV90b29sX2NvbGxlY3Rpb24udG9vbHMlNUQlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQSUwQWFnZW50LnJ1biglMjJQbGVhc2UlMjBkcmF3JTIwbWUlMjBhJTIwcGljdHVyZSUyMG9mJTIwcml2ZXJzJTIwYW5kJTIwbGFrZXMuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

image_tool_collection = ToolCollection(
    collection_slug=<span class="hljs-string">&quot;huggingface-tools/diffusion-tools-6630bb19a942c2306a2cdb6f&quot;</span>,
    token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>
)
agent = CodeAgent(tools=[*image_tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)

agent.run(<span class="hljs-string">&quot;Please draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),we=new yl({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/tools.md"}}),{c(){r=n("meta"),f=s(),b=n("p"),g=s(),u(v.$$.fragment),$e=s(),u(j.$$.fragment),ve=s(),C=n("p"),C.textContent=_t,je=s(),u(T.$$.fragment),Ce=s(),u(I.$$.fragment),Ie=s(),_=n("p"),_.innerHTML=Zt,_e=s(),Z=n("p"),Z.innerHTML=Gt,Ze=s(),G=n("p"),G.textContent=kt,Ge=s(),k=n("ul"),k.innerHTML=Ht,ke=s(),H=n("p"),H.innerHTML=Bt,He=s(),B=n("p"),B.textContent=xt,Be=s(),u(x.$$.fragment),xe=s(),V=n("p"),V.innerHTML=Vt,Ve=s(),u(R.$$.fragment),Re=s(),W=n("p"),W.innerHTML=Rt,We=s(),u(Q.$$.fragment),Qe=s(),F=n("p"),F.textContent=Wt,Fe=s(),S=n("ul"),S.innerHTML=Qt,Se=s(),N=n("p"),N.innerHTML=Ft,Ne=s(),u(E.$$.fragment),Ee=s(),u(A.$$.fragment),Ae=s(),X=n("p"),X.innerHTML=St,Xe=s(),Y=n("p"),Y.innerHTML=Nt,Ye=s(),q=n("p"),q.innerHTML=Et,qe=s(),u(z.$$.fragment),ze=s(),L=n("p"),L.textContent=At,Le=s(),Te=n("img"),Pe=s(),P=n("p"),P.innerHTML=Yt,De=s(),u(D.$$.fragment),Ke=s(),u(K.$$.fragment),Oe=s(),Je=n("img"),et=s(),O=n("p"),O.textContent=zt,tt=s(),u(ee.$$.fragment),lt=s(),te=n("p"),te.innerHTML=Lt,ot=s(),le=n("p"),le.innerHTML=Pt,st=s(),oe=n("p"),oe.innerHTML=Dt,at=s(),u(se.$$.fragment),nt=s(),u(J.$$.fragment),it=s(),u(ae.$$.fragment),rt=s(),ne=n("p"),ne.innerHTML=Kt,pt=s(),ie=n("p"),ie.innerHTML=Ot,ut=s(),u(re.$$.fragment),dt=s(),u(pe.$$.fragment),mt=s(),ue=n("p"),ue.textContent=el,ct=s(),de=n("p"),de.innerHTML=tl,ht=s(),u(me.$$.fragment),Mt=s(),ce=n("p"),ce.textContent=ll,bt=s(),u(he.$$.fragment),ft=s(),u(U.$$.fragment),yt=s(),Me=n("p"),Me.innerHTML=ol,gt=s(),u(be.$$.fragment),wt=s(),fe=n("p"),fe.textContent=sl,Tt=s(),u(ye.$$.fragment),Jt=s(),ge=n("p"),ge.textContent=al,Ut=s(),u(we.$$.fragment),$t=s(),Ue=n("p"),this.h()},l(e){const t=Ml("svelte-u9bgzb",document.head);r=i(t,"META",{name:!0,content:!0}),t.forEach(l),f=a(e),b=i(e,"P",{}),ul(b).forEach(l),g=a(e),d(v.$$.fragment,e),$e=a(e),d(j.$$.fragment,e),ve=a(e),C=i(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-8951oz"&&(C.textContent=_t),je=a(e),d(T.$$.fragment,e),Ce=a(e),d(I.$$.fragment,e),Ie=a(e),_=i(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1l17v6b"&&(_.innerHTML=Zt),_e=a(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1ttrl93"&&(Z.innerHTML=Gt),Ze=a(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-hid0wz"&&(G.textContent=kt),Ge=a(e),k=i(e,"UL",{"data-svelte-h":!0}),p(k)!=="svelte-he81o0"&&(k.innerHTML=Ht),ke=a(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-16f1wo8"&&(H.innerHTML=Bt),He=a(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-epeqxx"&&(B.textContent=xt),Be=a(e),d(x.$$.fragment,e),xe=a(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-qzr63y"&&(V.innerHTML=Vt),Ve=a(e),d(R.$$.fragment,e),Re=a(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1n60j6p"&&(W.innerHTML=Rt),We=a(e),d(Q.$$.fragment,e),Qe=a(e),F=i(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-hoocvd"&&(F.textContent=Wt),Fe=a(e),S=i(e,"UL",{"data-svelte-h":!0}),p(S)!=="svelte-1iljgzo"&&(S.innerHTML=Qt),Se=a(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-139hwmc"&&(N.innerHTML=Ft),Ne=a(e),d(E.$$.fragment,e),Ee=a(e),d(A.$$.fragment,e),Ae=a(e),X=i(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1xeslzm"&&(X.innerHTML=St),Xe=a(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1xkj0c9"&&(Y.innerHTML=Nt),Ye=a(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1gucs20"&&(q.innerHTML=Et),qe=a(e),d(z.$$.fragment,e),ze=a(e),L=i(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-sgspwr"&&(L.textContent=At),Le=a(e),Te=i(e,"IMG",{src:!0}),Pe=a(e),P=i(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-3y2998"&&(P.innerHTML=Yt),De=a(e),d(D.$$.fragment,e),Ke=a(e),d(K.$$.fragment,e),Oe=a(e),Je=i(e,"IMG",{src:!0}),et=a(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-i5dtbz"&&(O.textContent=zt),tt=a(e),d(ee.$$.fragment,e),lt=a(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-c328x"&&(te.innerHTML=Lt),ot=a(e),le=i(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-ma0k6d"&&(le.innerHTML=Pt),st=a(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-6fvul5"&&(oe.innerHTML=Dt),at=a(e),d(se.$$.fragment,e),nt=a(e),d(J.$$.fragment,e),it=a(e),d(ae.$$.fragment,e),rt=a(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1rq40pf"&&(ne.innerHTML=Kt),pt=a(e),ie=i(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1g7jkvd"&&(ie.innerHTML=Ot),ut=a(e),d(re.$$.fragment,e),dt=a(e),d(pe.$$.fragment,e),mt=a(e),ue=i(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1upp7uo"&&(ue.textContent=el),ct=a(e),de=i(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-ocb8u2"&&(de.innerHTML=tl),ht=a(e),d(me.$$.fragment,e),Mt=a(e),ce=i(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-o3ledg"&&(ce.textContent=ll),bt=a(e),d(he.$$.fragment,e),ft=a(e),d(U.$$.fragment,e),yt=a(e),Me=i(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-zx9fzv"&&(Me.innerHTML=ol),gt=a(e),d(be.$$.fragment,e),wt=a(e),fe=i(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-15fzsol"&&(fe.textContent=sl),Tt=a(e),d(ye.$$.fragment,e),Jt=a(e),ge=i(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-6r1jgt"&&(ge.textContent=al),Ut=a(e),d(we.$$.fragment,e),$t=a(e),Ue=i(e,"P",{}),ul(Ue).forEach(l),this.h()},h(){jt(r,"name","hf:doc:metadata"),jt(r,"content",Ul),pl(Te.src,Xt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/sunny_beach.webp")||jt(Te,"src",Xt),pl(Je.src,qt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit_spacesuit_flux.webp")||jt(Je,"src",qt)},m(e,t){bl(document.head,r),o(e,f,t),o(e,b,t),o(e,g,t),m(v,e,t),o(e,$e,t),m(j,e,t),o(e,ve,t),o(e,C,t),o(e,je,t),m(T,e,t),o(e,Ce,t),m(I,e,t),o(e,Ie,t),o(e,_,t),o(e,_e,t),o(e,Z,t),o(e,Ze,t),o(e,G,t),o(e,Ge,t),o(e,k,t),o(e,ke,t),o(e,H,t),o(e,He,t),o(e,B,t),o(e,Be,t),m(x,e,t),o(e,xe,t),o(e,V,t),o(e,Ve,t),m(R,e,t),o(e,Re,t),o(e,W,t),o(e,We,t),m(Q,e,t),o(e,Qe,t),o(e,F,t),o(e,Fe,t),o(e,S,t),o(e,Se,t),o(e,N,t),o(e,Ne,t),m(E,e,t),o(e,Ee,t),m(A,e,t),o(e,Ae,t),o(e,X,t),o(e,Xe,t),o(e,Y,t),o(e,Ye,t),o(e,q,t),o(e,qe,t),m(z,e,t),o(e,ze,t),o(e,L,t),o(e,Le,t),o(e,Te,t),o(e,Pe,t),o(e,P,t),o(e,De,t),m(D,e,t),o(e,Ke,t),m(K,e,t),o(e,Oe,t),o(e,Je,t),o(e,et,t),o(e,O,t),o(e,tt,t),m(ee,e,t),o(e,lt,t),o(e,te,t),o(e,ot,t),o(e,le,t),o(e,st,t),o(e,oe,t),o(e,at,t),m(se,e,t),o(e,nt,t),m(J,e,t),o(e,it,t),m(ae,e,t),o(e,rt,t),o(e,ne,t),o(e,pt,t),o(e,ie,t),o(e,ut,t),m(re,e,t),o(e,dt,t),m(pe,e,t),o(e,mt,t),o(e,ue,t),o(e,ct,t),o(e,de,t),o(e,ht,t),m(me,e,t),o(e,Mt,t),o(e,ce,t),o(e,bt,t),m(he,e,t),o(e,ft,t),m(U,e,t),o(e,yt,t),o(e,Me,t),o(e,gt,t),m(be,e,t),o(e,wt,t),o(e,fe,t),o(e,Tt,t),m(ye,e,t),o(e,Jt,t),o(e,ge,t),o(e,Ut,t),m(we,e,t),o(e,$t,t),o(e,Ue,t),vt=!0},p(e,[t]){const nl={};t&2&&(nl.$$scope={dirty:t,ctx:e}),T.$set(nl);const il={};t&2&&(il.$$scope={dirty:t,ctx:e}),J.$set(il);const rl={};t&2&&(rl.$$scope={dirty:t,ctx:e}),U.$set(rl)},i(e){vt||(c(v.$$.fragment,e),c(j.$$.fragment,e),c(T.$$.fragment,e),c(I.$$.fragment,e),c(x.$$.fragment,e),c(R.$$.fragment,e),c(Q.$$.fragment,e),c(E.$$.fragment,e),c(A.$$.fragment,e),c(z.$$.fragment,e),c(D.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(se.$$.fragment,e),c(J.$$.fragment,e),c(ae.$$.fragment,e),c(re.$$.fragment,e),c(pe.$$.fragment,e),c(me.$$.fragment,e),c(he.$$.fragment,e),c(U.$$.fragment,e),c(be.$$.fragment,e),c(ye.$$.fragment,e),c(we.$$.fragment,e),vt=!0)},o(e){h(v.$$.fragment,e),h(j.$$.fragment,e),h(T.$$.fragment,e),h(I.$$.fragment,e),h(x.$$.fragment,e),h(R.$$.fragment,e),h(Q.$$.fragment,e),h(E.$$.fragment,e),h(A.$$.fragment,e),h(z.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(se.$$.fragment,e),h(J.$$.fragment,e),h(ae.$$.fragment,e),h(re.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(he.$$.fragment,e),h(U.$$.fragment,e),h(be.$$.fragment,e),h(ye.$$.fragment,e),h(we.$$.fragment,e),vt=!1},d(e){e&&(l(f),l(b),l(g),l($e),l(ve),l(C),l(je),l(Ce),l(Ie),l(_),l(_e),l(Z),l(Ze),l(G),l(Ge),l(k),l(ke),l(H),l(He),l(B),l(Be),l(xe),l(V),l(Ve),l(Re),l(W),l(We),l(Qe),l(F),l(Fe),l(S),l(Se),l(N),l(Ne),l(Ee),l(Ae),l(X),l(Xe),l(Y),l(Ye),l(q),l(qe),l(ze),l(L),l(Le),l(Te),l(Pe),l(P),l(De),l(Ke),l(Oe),l(Je),l(et),l(O),l(tt),l(lt),l(te),l(ot),l(le),l(st),l(oe),l(at),l(nt),l(it),l(rt),l(ne),l(pt),l(ie),l(ut),l(dt),l(mt),l(ue),l(ct),l(de),l(ht),l(Mt),l(ce),l(bt),l(ft),l(yt),l(Me),l(gt),l(wt),l(fe),l(Tt),l(Jt),l(ge),l(Ut),l($t),l(Ue)),l(r),M(v,e),M(j,e),M(T,e),M(I,e),M(x,e),M(R,e),M(Q,e),M(E,e),M(A,e),M(z,e),M(D,e),M(K,e),M(ee,e),M(se,e),M(J,e),M(ae,e),M(re,e),M(pe,e),M(me,e),M(he,e),M(U,e),M(be,e),M(ye,e),M(we,e)}}}const Ul='{"title":"Tools","local":"tools","sections":[{"title":"Directly define a tool by subclassing Tool","local":"directly-define-a-tool-by-subclassing-tool","sections":[],"depth":3},{"title":"Share your tool to the Hub","local":"share-your-tool-to-the-hub","sections":[],"depth":3},{"title":"Import a Space as a tool","local":"import-a-space-as-a-tool","sections":[],"depth":3},{"title":"Use gradio-tools","local":"use-gradio-tools","sections":[],"depth":3},{"title":"Use LangChain tools","local":"use-langchain-tools","sections":[],"depth":3},{"title":"Manage your agent’s toolbox","local":"manage-your-agents-toolbox","sections":[],"depth":3},{"title":"Use a collection of tools","local":"use-a-collection-of-tools","sections":[],"depth":3}],"depth":1}';function $l(w){return ml(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gl extends cl{constructor(r){super(),hl(this,r,$l,Jl,dl,{})}}export{Gl as component};
