import{s as pn,o as mn,n as ml}from"../chunks/scheduler.9212057a.js";import{S as hn,i as yn,g as a,s as o,r as u,A as cn,h as i,f as l,c as s,j as un,u as r,x as d,k as rn,y as wn,a as n,v as p,d as m,t as h,w as y}from"../chunks/index.59dd74e5.js";import{T as pl}from"../chunks/Tip.e2b5578c.js";import{C as b}from"../chunks/CodeBlock.06303aa5.js";import{D as bn}from"../chunks/DocNotebookDropdown.08420028.js";import{H as U,E as Tn}from"../chunks/EditOnGithub.9be697b9.js";function Un(J){let M,w="The LLM can generate arbitrary code that will then be executed: do not add any unsafe imports!";return{c(){M=a("p"),M.textContent=w},l(c){M=i(c,"P",{"data-svelte-h":!0}),d(M)!=="svelte-sjm8o2"&&(M.textContent=w)},m(c,T){n(c,M,T)},p:ml,d(c){c&&l(M)}}}function Jn(J){let M,w=`Please make sure to define the <code>{{tool_descriptions}}</code> string somewhere in the <code>template</code> so the agent is aware
of the available tools.`;return{c(){M=a("p"),M.innerHTML=w},l(c){M=i(c,"P",{"data-svelte-h":!0}),d(M)!=="svelte-1dnr1za"&&(M.innerHTML=w)},m(c,T){n(c,M,T)},p:ml,d(c){c&&l(M)}}}function fn(J){let M,w='This definition format is the same as tool schemas used in <code>apply_chat_template</code>, the only difference is the added <code>tool</code> decorator: read more on our tool use API <a href="https://huggingface.co/blog/unified-tool-use#passing-tools-to-a-chat-template" rel="nofollow">here</a>.';return{c(){M=a("p"),M.innerHTML=w},l(c){M=i(c,"P",{"data-svelte-h":!0}),d(M)!=="svelte-1qhpksd"&&(M.innerHTML=w)},m(c,T){n(c,M,T)},p:ml,d(c){c&&l(M)}}}function gn(J){let M,w='For an in-depth example of an efficient multi-agent implementation, see <a href="https://huggingface.co/blog/beating-gaia" rel="nofollow">how we pushed our multi-agent system to the top of the GAIA leaderboard</a>.';return{c(){M=a("p"),M.innerHTML=w},l(c){M=i(c,"P",{"data-svelte-h":!0}),d(M)!=="svelte-1d151kq"&&(M.innerHTML=w)},m(c,T){n(c,M,T)},p:ml,d(c){c&&l(M)}}}function jn(J){let M,w,c,T,B,Ee,G,Se,Z,hl="In this guided visit, you will learn how to build an agent, how to run it, and how to customize it to make it work better for your use-case.",Fe,I,Le,C,yl="To initialize a minimal agent, you need at least these two arguments:",Ae,x,cl="<li>An text-generation model to power your agent - because the agent is different from a simple LLM, it is a system that uses a LLM as its engine.</li> <li>A list of tools from which the agent pick tools to execute</li>",Pe,$,wl="For your model, you can use any of these options:",qe,H,bl='<li><a href="/docs/smolagents/v0.1.3/en/reference/agents#smolagents.TransformersModel">TransformersModel</a> takes a pre-initialized <code>transformers</code> pipeline to run inference on your local machine using <code>transformers</code>.</li> <li><a href="/docs/smolagents/v0.1.3/en/reference/agents#smolagents.HfApiModel">HfApiModel</a> leverages a <code>huggingface_hub.InferenceClient</code> under the hood.</li> <li>We also provide <a href="/docs/smolagents/v0.1.3/en/reference/agents#smolagents.LiteLLMModel">LiteLLMModel</a>, which lets you call 100+ different models through <a href="https://docs.litellm.ai/" rel="nofollow">LiteLLM</a>!</li>',De,W,Tl="You will also need a <code>tools</code> argument which accepts a list of <code>Tools</code> - it can be an empty list. You can also add the default toolbox on top of your <code>tools</code> list by defining the optional argument <code>add_base_tools=True</code>.",Ke,k,Ul="Once you have these two arguments, <code>tools</code> and <code>model</code>,  you can create an agent and run it.",Oe,R,et,_,tt,Y,Jl=`A Python interpreter executes the code on a set of inputs passed along with your tools.
This should be safe because the only functions that can be called are the tools you provided (especially if it’s only tools by Hugging Face) and a set of predefined safe functions like <code>print</code> or functions from the <code>math</code> module, so you’re already limited in what can be executed.`,lt,N,fl=`The Python interpreter also doesn’t allow imports by default outside of a safe list, so all the most obvious attacks shouldn’t be an issue.
You can authorize additional imports by passing the authorized modules as a list of strings in argument <code>additional_authorized_imports</code> upon initialization of your <a href="/docs/smolagents/v0.1.3/en/reference/agents#smolagents.CodeAgent">CodeAgent</a> or <a href="/docs/smolagents/v0.1.3/en/reference/agents#smolagents.CodeAgent">CodeAgent</a>:`,nt,Q,ot,X,gl="This gives you at the end of the agent run:",st,V,at,z,jl="The execution will stop at any code trying to perform an illegal operation or if there is a regular Python error with the code generated by the agent. You can also use E2B code executor instead of a local Python interpreter by passing <code>use_e2b_executor=True</code> upon agent initialization.",it,f,dt,E,Mt,S,vl="Upon initialization of the agent system, a system prompt (attribute <code>system_prompt</code>) is built automatically by turning the description extracted from the tools into a predefined system prompt template.",ut,F,Bl="But you can customize it!",rt,L,Gl='Let’s see how it works. For example, check the system prompt for the <a href="/docs/smolagents/v0.1.3/en/reference/agents#smolagents.CodeAgent">CodeAgent</a> (below version is slightly simplified).',pt,A,Zl="The prompt and output parser were automatically defined, but you can easily inspect them by calling the <code>system_prompt_template</code> on your agent.",mt,P,ht,q,Il="Here is what you get:",yt,D,ct,K,Cl="The system prompt includes:",wt,O,xl="<li>An <em>introduction</em> that explains how the agent should behave and what tools are.</li> <li>A description of all the tools that is defined by a <code>{{tool_descriptions}}</code> token that is dynamically replaced at runtime with the tools defined/chosen by the user.<ul><li>The tool description comes from the tool attributes, <code>name</code>, <code>description</code>, <code>inputs</code> and <code>output_type</code>,  and a simple <code>jinja2</code> template that you can refine.</li></ul></li> <li>The expected output format.</li>",bt,ee,$l="You could improve the system prompt, for example, by adding an explanation of the output format.",Tt,te,Hl="For maximum flexibility, you can overwrite the whole system prompt template by passing your custom prompt as an argument to the <code>system_prompt</code> parameter.",Ut,le,Jt,g,ft,ne,gt,oe,Wl="Here are a few useful attributes to inspect what happened after a run:",jt,se,kl="<li><code>agent.logs</code> stores the fine-grained logs of the agent. At every step of the agent’s run, everything gets stored in a dictionary that then is appended to <code>agent.logs</code>.</li> <li>Running <code>agent.write_inner_memory_from_logs()</code> creates an inner memory of the agent’s logs for the LLM to view, as a list of chat messages. This method goes over each step of the log and only stores what it’s interested in as a message: for instance, it will save the system prompt and task in separate messages, then for each step it will store the LLM output as a message, and the tool call output as another message. Use this if you want a higher-level view of what has happened - but not every log will be transcripted by this method.</li>",vt,ae,Bt,ie,Rl="A tool is an atomic function to be used by an agent.",Gt,de,_l="You can for instance check the <code>PythonInterpreterTool</code>: it has a name, a description, input descriptions, an output type, and a <code>__call__</code> method to perform the action.",Zt,Me,Yl="When the agent is initialized, the tool attributes are used to generate a tool description which is baked into the agent’s system prompt. This lets the agent know which tools it can use and why.",It,ue,Ct,re,Nl="Transformers comes with a default toolbox for empowering agents, that you can add to your agent upon initialization with argument <code>add_base_tools = True</code>:",xt,pe,Ql='<li><strong>DuckDuckGo web search*</strong>: performs a web search using DuckDuckGo browser.</li> <li><strong>Python code interpreter</strong>: runs your the LLM generated Python code in a secure environment. This tool will only be added to <a href="/docs/smolagents/v0.1.3/en/reference/agents#smolagents.ToolCallingAgent">ToolCallingAgent</a> if you initialize it with <code>add_base_tools=True</code>, since code-based agent can already natively execute Python code</li> <li><strong>Transcriber</strong>: a speech-to-text pipeline built on Whisper-Turbo that transcribes an audio to text.</li>',$t,me,Xl='You can manually use a tool by calling the <a href="/docs/smolagents/v0.1.3/en/reference/tools#smolagents.load_tool">load_tool()</a> function and a task to perform.',Ht,he,Wt,ye,kt,ce,Vl=`You can create your own tool for use cases not covered by the default tools from Hugging Face.
For example, let’s create a tool that returns the most downloaded model for a given task from the Hub.`,Rt,we,zl="You’ll start with the code below.",_t,be,Yt,Te,El="This code can quickly be converted into a tool, just by wrapping it in a function and adding the <code>tool</code> decorator:",Nt,Ue,Qt,Je,Sl="The function needs:",Xt,fe,Fl=`<li>A clear name. The name usually describes what the tool does. Since the code returns the model with the most downloads for a task, let’s put <code>model_download_tool</code>.</li> <li>Type hints on both inputs and output</li> <li>A description, that includes an ‘Args:’ part where each argument is described (without a type indication this time, it will be pulled from the type hint).
All these will be automatically baked into the agent’s system prompt upon initialization: so strive to make them as clear as possible!</li>`,Vt,j,zt,ge,Ll="Then you can directly initialize your agent:",Et,je,St,ve,Al="You get the following:",Ft,Be,Lt,Ge,Pl=`And the output:
<code>&quot;The most downloaded model for the &#39;text-to-video&#39; task is ByteDance/AnimateDiff-Lightning.&quot;</code>`,At,Ze,Pt,Ie,ql=`Multi-agent has been introduced in Microsoft’s framework <a href="https://huggingface.co/papers/2308.08155" rel="nofollow">Autogen</a>.
In this type of framework, you have several agents working together to solve your task instead of only one.
It empirically yields better performance on most benchmarks. The reason for this better performance is conceptually simple: for many tasks, rather than using a do-it-all system, you would prefer to specialize units on sub-tasks. Here, having agents with separate tool sets and memories allows to achieve efficient specialization. For instance, why fill the memory of the code generating agent with all the content of webpages visited by the web search agent? It’s better to keep them separate.`,qt,Ce,Dl="You can easily build hierarchical multi-agent systems with <code>smolagents</code>.",Dt,xe,Kl='To do so, encapsulate the agent in a <a href="/docs/smolagents/v0.1.3/en/reference/agents#smolagents.ManagedAgent">ManagedAgent</a> object. This object needs arguments <code>agent</code>, <code>name</code>, and a <code>description</code>, which will then be embedded in the manager agent’s system prompt to let it know how to call this managed agent, as we also do for tools.',Kt,$e,Ol="Here’s an example of making an agent that managed a specific web search agent using our <code>DuckDuckGoSearchTool</code>:",Ot,He,el,v,tl,We,ll,ke,en="You can use <code>GradioUI</code> to interactively submit tasks to your agent and observe its thought and execution process, here is an example:",nl,Re,ol,_e,tn=`Under the hood, when the user types a new answer, the agent is launched with <code>agent.run(user_request, reset=False)</code>.
The <code>reset=False</code> flag means the agent’s memory is not flushed before launching this new task, which lets the conversation go on.`,sl,Ye,ln="You can also use this <code>reset=False</code> argument to keep the conversation going in any other agentic application.",al,Ne,il,Qe,nn="For more in-depth usage, you will then want to check out our tutorials:",dl,Xe,on='<li><a href="./tutorials/secure_code_execution">the explanation of how our code agents work</a></li> <li><a href="./tutorials/building_good_agents">this guide on how to build good agents</a>.</li> <li><a href="./tutorials/building_good_agents">the in-depth guide for tool usage</a>.</li>',Ml,Ve,ul,ze,rl;return B=new U({props:{title:"Agents - Guided tour",local:"agents---guided-tour",headingTag:"h1"}}),G=new bn({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/guided_tour.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/guided_tour.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/guided_tour.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/guided_tour.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/guided_tour.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/guided_tour.ipynb"}]}}),I=new U({props:{title:"Building your agent",local:"building-your-agent",headingTag:"h3"}}),R=new b({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBJTBBbG9naW4oJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIpJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4zLTcwQi1JbnN0cnVjdCUyMiUwQSUwQW1vZGVsJTIwJTNEJTIwSGZBcGlNb2RlbChtb2RlbF9pZCUzRG1vZGVsX2lkKSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMEFhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIyQ291bGQlMjB5b3UlMjBnaXZlJTIwbWUlMjB0aGUlMjAxMTh0aCUyMG51bWJlciUyMGluJTIwdGhlJTIwRmlib25hY2NpJTIwc2VxdWVuY2UlM0YlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login

login(<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)

model_id = <span class="hljs-string">&quot;meta-llama/Llama-3.3-70B-Instruct&quot;</span>

model = HfApiModel(model_id=model_id)
agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)

agent.run(
    <span class="hljs-string">&quot;Could you give me the 118th number in the Fibonacci sequence?&quot;</span>,
)`,wrap:!1}}),_=new U({props:{title:"Code execution",local:"code-execution",headingTag:"h4"}}),Q=new b({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBhZGRpdGlvbmFsX2F1dGhvcml6ZWRfaW1wb3J0cyUzRCU1QidyZXF1ZXN0cyclMkMlMjAnYnM0JyU1RCklMEFhZ2VudC5ydW4oJTIyQ291bGQlMjB5b3UlMjBnZXQlMjBtZSUyMHRoZSUyMHRpdGxlJTIwb2YlMjB0aGUlMjBwYWdlJTIwYXQlMjB1cmwlMjAnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmJsb2cnJTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent

agent = CodeAgent(tools=[], model=model, additional_authorized_imports=[<span class="hljs-string">&#x27;requests&#x27;</span>, <span class="hljs-string">&#x27;bs4&#x27;</span>])
agent.run(<span class="hljs-string">&quot;Could you get me the title of the page at url &#x27;https://huggingface.co/blog&#x27;?&quot;</span>)`,wrap:!1}}),V=new b({props:{code:"J0h1Z2dpbmclMjBGYWNlJTIwJUUyJTgwJTkzJTIwQmxvZyc=",highlighted:"&#x27;Hugging Face – Blog&#x27;",wrap:!1}}),f=new pl({props:{warning:!0,$$slots:{default:[Un]},$$scope:{ctx:J}}}),E=new U({props:{title:"The system prompt",local:"the-system-prompt",headingTag:"h3"}}),P=new b({props:{code:"cHJpbnQoYWdlbnQuc3lzdGVtX3Byb21wdF90ZW1wbGF0ZSk=",highlighted:'<span class="hljs-built_in">print</span>(agent.system_prompt_template)',wrap:!1}}),D=new b({props:{code:"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",highlighted:`You are an expert assistant who can solve any task using code blobs. You will be given a task to solve as best you can.
To do so, you have been given access to a list of tools: these tools are basically Python functions which you can call with code.
To solve the task, you must plan forward to proceed in a series of steps, in a cycle of &#x27;Thought:&#x27;, &#x27;Code:&#x27;, and &#x27;Observation:&#x27; sequences.

At each step, in the &#x27;Thought:&#x27; sequence, you should first explain your reasoning towards solving the task and the tools that you want to use.
Then in the &#x27;Code:&#x27; sequence, you should write the code in simple Python. The code sequence must end with &#x27;&lt;end_code&gt;&#x27; sequence.
During each intermediate step, you can use &#x27;print()&#x27; to save whatever important information you will then need.
These print outputs will then appear in the &#x27;Observation:&#x27; field, which will be available as input for the next step.
In the end you have to return a final answer using the \`final_answer\` tool.

Here are a few examples using notional tools:
---
{examples}

Above example were using notional tools that might not exist for you. On top of performing computations in the Python code snippets that you create, you only have access to these tools:

{{tool_descriptions}}

{{managed_agents_descriptions}}

Here are the rules you should always follow to solve your task:
1. Always provide a &#x27;Thought:&#x27; sequence, and a &#x27;Code:\\n\`\`\`py&#x27; sequence ending with &#x27;\`\`\`&lt;end_code&gt;&#x27; sequence, else you will fail.
2. Use only variables that you have defined!
3. Always use the right arguments for the tools. DO NOT pass the arguments as a dict as in &#x27;answer = wiki({&#x27;query&#x27;: &quot;What is the place where James Bond lives?&quot;})&#x27;, but use the arguments directly as in &#x27;answer = wiki(query=&quot;What is the place where James Bond lives?&quot;)&#x27;.
4. Take care to not chain too many sequential tool calls in the same code block, especially when the output format is unpredictable. For instance, a call to search has an unpredictable return format, so do not have another tool call that depends on its output in the same block: rather output results with print() to use them in the next block.
5. Call a tool only when needed, and never re-do a tool call that you previously did with the exact same parameters.
6. Don&#x27;t name any new variable with the same name as a tool: for instance don&#x27;t name a variable &#x27;final_answer&#x27;.
7. Never create any notional variables in our code, as having these in your logs might derail you from the true variables.
8. You can use imports in your code, but only from the following list of modules: {{authorized_imports}}
9. The state persists between code executions: so if in one step you&#x27;ve created variables or imported modules, these will all persist.
10. Don&#x27;t give up! You&#x27;re in charge of solving the task, not providing directions to solve it.

Now Begin! If you solve the task correctly, you will receive a reward of $1,000,000.`,wrap:!1}}),le=new b({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ2FsbGluZ0FnZW50JTJDJTIwUHl0aG9uSW50ZXJwcmV0ZXJUb29sJTJDJTIwVE9PTF9DQUxMSU5HX1NZU1RFTV9QUk9NUFQlMEElMEFtb2RpZmllZF9wcm9tcHQlMjAlM0QlMjBUT09MX0NBTExJTkdfU1lTVEVNX1BST01QVCUwQSUwQWFnZW50JTIwJTNEJTIwVG9vbENhbGxpbmdBZ2VudCh0b29scyUzRCU1QlB5dGhvbkludGVycHJldGVyVG9vbCgpJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHN5c3RlbV9wcm9tcHQlM0Rtb2RpZmllZF9wcm9tcHQp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCallingAgent, PythonInterpreterTool, TOOL_CALLING_SYSTEM_PROMPT

modified_prompt = TOOL_CALLING_SYSTEM_PROMPT

agent = ToolCallingAgent(tools=[PythonInterpreterTool()], model=model, system_prompt=modified_prompt)`,wrap:!1}}),g=new pl({props:{warning:!0,$$slots:{default:[Jn]},$$scope:{ctx:J}}}),ne=new U({props:{title:"Inspecting an agent run",local:"inspecting-an-agent-run",headingTag:"h3"}}),ae=new U({props:{title:"Tools",local:"tools",headingTag:"h2"}}),ue=new U({props:{title:"Default toolbox",local:"default-toolbox",headingTag:"h3"}}),he=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGxvYWRfdG9vbCUwQSUwQXNlYXJjaF90b29sJTIwJTNEJTIwbG9hZF90b29sKCUyMndlYl9zZWFyY2glMjIpJTBBcHJpbnQoc2VhcmNoX3Rvb2woJTIyV2hvJ3MlMjB0aGUlMjBjdXJyZW50JTIwcHJlc2lkZW50JTIwb2YlMjBSdXNzaWElM0YlMjIpKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> load_tool

search_tool = load_tool(<span class="hljs-string">&quot;web_search&quot;</span>)
<span class="hljs-built_in">print</span>(search_tool(<span class="hljs-string">&quot;Who&#x27;s the current president of Russia?&quot;</span>))`,wrap:!1}}),ye=new U({props:{title:"Create a new tool",local:"create-a-new-tool",headingTag:"h3"}}),be=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfbW9kZWxzJTBBJTBBdGFzayUyMCUzRCUyMCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIlMEElMEFtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBcHJpbnQobW9kZWwuaWQp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

task = <span class="hljs-string">&quot;text-classification&quot;</span>

model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
<span class="hljs-built_in">print</span>(model.<span class="hljs-built_in">id</span>)`,wrap:!1}}),Ue=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHRvb2wlMEElMEElNDB0b29sJTBBZGVmJTIwbW9kZWxfZG93bmxvYWRfdG9vbCh0YXNrJTNBJTIwc3RyKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBUaGlzJTIwaXMlMjBhJTIwdG9vbCUyMHRoYXQlMjByZXR1cm5zJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkZWQlMjBtb2RlbCUyMG9mJTIwYSUyMGdpdmVuJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTBBJTIwJTIwJTIwJTIwSXQlMjByZXR1cm5zJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2hlY2twb2ludC4lMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGFzayUzQSUyMFRoZSUyMHRhc2slMjBmb3IlMjB3aGljaCUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwbmV4dChpdGVyKGxpc3RfbW9kZWxzKGZpbHRlciUzRCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIlMkMlMjBzb3J0JTNEJTIyZG93bmxvYWRzJTIyJTJDJTIwZGlyZWN0aW9uJTNELTEpKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBtb2RlbC5pZA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> tool

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">model_download_tool</span>(<span class="hljs-params">task: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub.
    It returns the name of the checkpoint.

    Args:
        task: The task for which
    &quot;&quot;&quot;</span>
    model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=<span class="hljs-string">&quot;text-classification&quot;</span>, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
    <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>`,wrap:!1}}),j=new pl({props:{warning:!1,$$slots:{default:[fn]},$$scope:{ctx:J}}}),je=new b({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1Qm1vZGVsX2Rvd25sb2FkX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQWFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjJDYW4lMjB5b3UlMjBnaXZlJTIwbWUlMjB0aGUlMjBuYW1lJTIwb2YlMjB0aGUlMjBtb2RlbCUyMHRoYXQlMjBoYXMlMjB0aGUlMjBtb3N0JTIwZG93bmxvYWRzJTIwaW4lMjB0aGUlMjAndGV4dC10by12aWRlbyclMjB0YXNrJTIwb24lMjB0aGUlMjBIdWdnaW5nJTIwRmFjZSUyMEh1YiUzRiUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent
agent = CodeAgent(tools=[model_download_tool], model=model)
agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub?&quot;</span>
)`,wrap:!1}}),Be=new b({props:{code:"JTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTIwTmV3JTIwdGFzayUyMCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUwQUNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTNGJTBBJTNEJTNEJTNEJTNEJTIwQWdlbnQlMjBpcyUyMGV4ZWN1dGluZyUyMHRoZSUyMGNvZGUlMjBiZWxvdyUzQSUwQW1vc3RfZG93bmxvYWRlZF9tb2RlbCUyMCUzRCUyMG1vZGVsX2Rvd25sb2FkX3Rvb2wodGFzayUzRCUyMnRleHQtdG8tdmlkZW8lMjIpJTBBcHJpbnQoZiUyMlRoZSUyMG1vc3QlMjBkb3dubG9hZGVkJTIwbW9kZWwlMjBmb3IlMjB0aGUlMjAndGV4dC10by12aWRlbyclMjB0YXNrJTIwaXMlMjAlN0Jtb3N0X2Rvd25sb2FkZWRfbW9kZWwlN0QuJTIyKSUwQSUzRCUzRCUzRCUzRA==",highlighted:`======== New task ========
Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub?
==== Agent is executing the code below:
most_downloaded_model = model_download_tool(task=&quot;text-to-video&quot;)
print(f&quot;The most downloaded model for the &#x27;text-to-video&#x27; task is {most_downloaded_model}.&quot;)
====`,wrap:!1}}),Ze=new U({props:{title:"Multi-agents",local:"multi-agents",headingTag:"h2"}}),He=new b({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBNYW5hZ2VkQWdlbnQlMEElMEFtb2RlbCUyMCUzRCUyMEhmQXBpTW9kZWwoKSUwQSUwQXdlYl9hZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QkR1Y2tEdWNrR29TZWFyY2hUb29sKCklNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQW1hbmFnZWRfd2ViX2FnZW50JTIwJTNEJTIwTWFuYWdlZEFnZW50KCUwQSUyMCUyMCUyMCUyMGFnZW50JTNEd2ViX2FnZW50JTJDJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMndlYl9zZWFyY2glMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMlJ1bnMlMjB3ZWIlMjBzZWFyY2hlcyUyMGZvciUyMHlvdS4lMjBHaXZlJTIwaXQlMjB5b3VyJTIwcXVlcnklMjBhcyUyMGFuJTIwYXJndW1lbnQuJTIyJTBBKSUwQSUwQW1hbmFnZXJfYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUIlNUQlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwbWFuYWdlZF9hZ2VudHMlM0QlNUJtYW5hZ2VkX3dlYl9hZ2VudCU1RCUwQSklMEElMEFtYW5hZ2VyX2FnZW50LnJ1biglMjJXaG8lMjBpcyUyMHRoZSUyMENFTyUyMG9mJTIwSHVnZ2luZyUyMEZhY2UlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel, DuckDuckGoSearchTool, ManagedAgent

model = HfApiModel()

web_agent = CodeAgent(tools=[DuckDuckGoSearchTool()], model=model)

managed_web_agent = ManagedAgent(
    agent=web_agent,
    name=<span class="hljs-string">&quot;web_search&quot;</span>,
    description=<span class="hljs-string">&quot;Runs web searches for you. Give it your query as an argument.&quot;</span>
)

manager_agent = CodeAgent(
    tools=[], model=model, managed_agents=[managed_web_agent]
)

manager_agent.run(<span class="hljs-string">&quot;Who is the CEO of Hugging Face?&quot;</span>)`,wrap:!1}}),v=new pl({props:{warning:!1,$$slots:{default:[gn]},$$scope:{ctx:J}}}),We=new U({props:{title:"Talk with your agent and visualize its thoughts in a cool Gradio interface",local:"talk-with-your-agent-and-visualize-its-thoughts-in-a-cool-gradio-interface",headingTag:"h2"}}),Re=new b({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwbG9hZF90b29sJTJDJTBBJTIwJTIwJTIwJTIwQ29kZUFnZW50JTJDJTBBJTIwJTIwJTIwJTIwSGZBcGlNb2RlbCUyQyUwQSUyMCUyMCUyMCUyMEdyYWRpb1VJJTBBKSUwQSUwQSUyMyUyMEltcG9ydCUyMHRvb2wlMjBmcm9tJTIwSHViJTBBaW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwbG9hZF90b29sKCUyMm0tcmljJTJGdGV4dC10by1pbWFnZSUyMiklMEElMEFtb2RlbCUyMCUzRCUyMEhmQXBpTW9kZWwobW9kZWxfaWQpJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMHRoZSUyMGFnZW50JTIwd2l0aCUyMHRoZSUyMGltYWdlJTIwZ2VuZXJhdGlvbiUyMHRvb2wlMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QmltYWdlX2dlbmVyYXRpb25fdG9vbCU1RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBJTBBR3JhZGlvVUkoYWdlbnQpLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (
    load_tool,
    CodeAgent,
    HfApiModel,
    GradioUI
)

<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>)

model = HfApiModel(model_id)

<span class="hljs-comment"># Initialize the agent with the image generation tool</span>
agent = CodeAgent(tools=[image_generation_tool], model=model)

GradioUI(agent).launch()`,wrap:!1}}),Ne=new U({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),Ve=new Tn({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/guided_tour.md"}}),{c(){M=a("meta"),w=o(),c=a("p"),T=o(),u(B.$$.fragment),Ee=o(),u(G.$$.fragment),Se=o(),Z=a("p"),Z.textContent=hl,Fe=o(),u(I.$$.fragment),Le=o(),C=a("p"),C.textContent=yl,Ae=o(),x=a("ul"),x.innerHTML=cl,Pe=o(),$=a("p"),$.textContent=wl,qe=o(),H=a("ul"),H.innerHTML=bl,De=o(),W=a("p"),W.innerHTML=Tl,Ke=o(),k=a("p"),k.innerHTML=Ul,Oe=o(),u(R.$$.fragment),et=o(),u(_.$$.fragment),tt=o(),Y=a("p"),Y.innerHTML=Jl,lt=o(),N=a("p"),N.innerHTML=fl,nt=o(),u(Q.$$.fragment),ot=o(),X=a("p"),X.textContent=gl,st=o(),u(V.$$.fragment),at=o(),z=a("p"),z.innerHTML=jl,it=o(),u(f.$$.fragment),dt=o(),u(E.$$.fragment),Mt=o(),S=a("p"),S.innerHTML=vl,ut=o(),F=a("p"),F.textContent=Bl,rt=o(),L=a("p"),L.innerHTML=Gl,pt=o(),A=a("p"),A.innerHTML=Zl,mt=o(),u(P.$$.fragment),ht=o(),q=a("p"),q.textContent=Il,yt=o(),u(D.$$.fragment),ct=o(),K=a("p"),K.textContent=Cl,wt=o(),O=a("ul"),O.innerHTML=xl,bt=o(),ee=a("p"),ee.textContent=$l,Tt=o(),te=a("p"),te.innerHTML=Hl,Ut=o(),u(le.$$.fragment),Jt=o(),u(g.$$.fragment),ft=o(),u(ne.$$.fragment),gt=o(),oe=a("p"),oe.textContent=Wl,jt=o(),se=a("ul"),se.innerHTML=kl,vt=o(),u(ae.$$.fragment),Bt=o(),ie=a("p"),ie.textContent=Rl,Gt=o(),de=a("p"),de.innerHTML=_l,Zt=o(),Me=a("p"),Me.textContent=Yl,It=o(),u(ue.$$.fragment),Ct=o(),re=a("p"),re.innerHTML=Nl,xt=o(),pe=a("ul"),pe.innerHTML=Ql,$t=o(),me=a("p"),me.innerHTML=Xl,Ht=o(),u(he.$$.fragment),Wt=o(),u(ye.$$.fragment),kt=o(),ce=a("p"),ce.textContent=Vl,Rt=o(),we=a("p"),we.textContent=zl,_t=o(),u(be.$$.fragment),Yt=o(),Te=a("p"),Te.innerHTML=El,Nt=o(),u(Ue.$$.fragment),Qt=o(),Je=a("p"),Je.textContent=Sl,Xt=o(),fe=a("ul"),fe.innerHTML=Fl,Vt=o(),u(j.$$.fragment),zt=o(),ge=a("p"),ge.textContent=Ll,Et=o(),u(je.$$.fragment),St=o(),ve=a("p"),ve.textContent=Al,Ft=o(),u(Be.$$.fragment),Lt=o(),Ge=a("p"),Ge.innerHTML=Pl,At=o(),u(Ze.$$.fragment),Pt=o(),Ie=a("p"),Ie.innerHTML=ql,qt=o(),Ce=a("p"),Ce.innerHTML=Dl,Dt=o(),xe=a("p"),xe.innerHTML=Kl,Kt=o(),$e=a("p"),$e.innerHTML=Ol,Ot=o(),u(He.$$.fragment),el=o(),u(v.$$.fragment),tl=o(),u(We.$$.fragment),ll=o(),ke=a("p"),ke.innerHTML=en,nl=o(),u(Re.$$.fragment),ol=o(),_e=a("p"),_e.innerHTML=tn,sl=o(),Ye=a("p"),Ye.innerHTML=ln,al=o(),u(Ne.$$.fragment),il=o(),Qe=a("p"),Qe.textContent=nn,dl=o(),Xe=a("ul"),Xe.innerHTML=on,Ml=o(),u(Ve.$$.fragment),ul=o(),ze=a("p"),this.h()},l(e){const t=cn("svelte-u9bgzb",document.head);M=i(t,"META",{name:!0,content:!0}),t.forEach(l),w=s(e),c=i(e,"P",{}),un(c).forEach(l),T=s(e),r(B.$$.fragment,e),Ee=s(e),r(G.$$.fragment,e),Se=s(e),Z=i(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-c0efqa"&&(Z.textContent=hl),Fe=s(e),r(I.$$.fragment,e),Le=s(e),C=i(e,"P",{"data-svelte-h":!0}),d(C)!=="svelte-fbbc6g"&&(C.textContent=yl),Ae=s(e),x=i(e,"UL",{"data-svelte-h":!0}),d(x)!=="svelte-z2kmxm"&&(x.innerHTML=cl),Pe=s(e),$=i(e,"P",{"data-svelte-h":!0}),d($)!=="svelte-rmwmp7"&&($.textContent=wl),qe=s(e),H=i(e,"UL",{"data-svelte-h":!0}),d(H)!=="svelte-t913o8"&&(H.innerHTML=bl),De=s(e),W=i(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-1qjx3mb"&&(W.innerHTML=Tl),Ke=s(e),k=i(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-174zo24"&&(k.innerHTML=Ul),Oe=s(e),r(R.$$.fragment,e),et=s(e),r(_.$$.fragment,e),tt=s(e),Y=i(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-1kxu7a2"&&(Y.innerHTML=Jl),lt=s(e),N=i(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1c2rurd"&&(N.innerHTML=fl),nt=s(e),r(Q.$$.fragment,e),ot=s(e),X=i(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-rxp1r4"&&(X.textContent=gl),st=s(e),r(V.$$.fragment,e),at=s(e),z=i(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-qefrq8"&&(z.innerHTML=jl),it=s(e),r(f.$$.fragment,e),dt=s(e),r(E.$$.fragment,e),Mt=s(e),S=i(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-kzr4mu"&&(S.innerHTML=vl),ut=s(e),F=i(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-149fcv1"&&(F.textContent=Bl),rt=s(e),L=i(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-4lxszn"&&(L.innerHTML=Gl),pt=s(e),A=i(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-1d0hijn"&&(A.innerHTML=Zl),mt=s(e),r(P.$$.fragment,e),ht=s(e),q=i(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-174l3zr"&&(q.textContent=Il),yt=s(e),r(D.$$.fragment,e),ct=s(e),K=i(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1xlke9j"&&(K.textContent=Cl),wt=s(e),O=i(e,"UL",{"data-svelte-h":!0}),d(O)!=="svelte-153s4pv"&&(O.innerHTML=xl),bt=s(e),ee=i(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1poc7fx"&&(ee.textContent=$l),Tt=s(e),te=i(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-2xz207"&&(te.innerHTML=Hl),Ut=s(e),r(le.$$.fragment,e),Jt=s(e),r(g.$$.fragment,e),ft=s(e),r(ne.$$.fragment,e),gt=s(e),oe=i(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-4h2er2"&&(oe.textContent=Wl),jt=s(e),se=i(e,"UL",{"data-svelte-h":!0}),d(se)!=="svelte-1bn17ay"&&(se.innerHTML=kl),vt=s(e),r(ae.$$.fragment,e),Bt=s(e),ie=i(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-kl6fdx"&&(ie.textContent=Rl),Gt=s(e),de=i(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-2gk7zp"&&(de.innerHTML=_l),Zt=s(e),Me=i(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-u83m8z"&&(Me.textContent=Yl),It=s(e),r(ue.$$.fragment,e),Ct=s(e),re=i(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-1uj21n8"&&(re.innerHTML=Nl),xt=s(e),pe=i(e,"UL",{"data-svelte-h":!0}),d(pe)!=="svelte-1v71gju"&&(pe.innerHTML=Ql),$t=s(e),me=i(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-1mh3goe"&&(me.innerHTML=Xl),Ht=s(e),r(he.$$.fragment,e),Wt=s(e),r(ye.$$.fragment,e),kt=s(e),ce=i(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-8dd7rj"&&(ce.textContent=Vl),Rt=s(e),we=i(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-jio97"&&(we.textContent=zl),_t=s(e),r(be.$$.fragment,e),Yt=s(e),Te=i(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-12iqsd4"&&(Te.innerHTML=El),Nt=s(e),r(Ue.$$.fragment,e),Qt=s(e),Je=i(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-10btble"&&(Je.textContent=Sl),Xt=s(e),fe=i(e,"UL",{"data-svelte-h":!0}),d(fe)!=="svelte-1c8qmx6"&&(fe.innerHTML=Fl),Vt=s(e),r(j.$$.fragment,e),zt=s(e),ge=i(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-1bc8e8e"&&(ge.textContent=Ll),Et=s(e),r(je.$$.fragment,e),St=s(e),ve=i(e,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-rgc1m9"&&(ve.textContent=Al),Ft=s(e),r(Be.$$.fragment,e),Lt=s(e),Ge=i(e,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-di3g23"&&(Ge.innerHTML=Pl),At=s(e),r(Ze.$$.fragment,e),Pt=s(e),Ie=i(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-1hup0so"&&(Ie.innerHTML=ql),qt=s(e),Ce=i(e,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-1n3puco"&&(Ce.innerHTML=Dl),Dt=s(e),xe=i(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-5e5uoh"&&(xe.innerHTML=Kl),Kt=s(e),$e=i(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-bx601e"&&($e.innerHTML=Ol),Ot=s(e),r(He.$$.fragment,e),el=s(e),r(v.$$.fragment,e),tl=s(e),r(We.$$.fragment,e),ll=s(e),ke=i(e,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-8ye7ad"&&(ke.innerHTML=en),nl=s(e),r(Re.$$.fragment,e),ol=s(e),_e=i(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-1k7bqf2"&&(_e.innerHTML=tn),sl=s(e),Ye=i(e,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-130f0gy"&&(Ye.innerHTML=ln),al=s(e),r(Ne.$$.fragment,e),il=s(e),Qe=i(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-1emppws"&&(Qe.textContent=nn),dl=s(e),Xe=i(e,"UL",{"data-svelte-h":!0}),d(Xe)!=="svelte-1hcect5"&&(Xe.innerHTML=on),Ml=s(e),r(Ve.$$.fragment,e),ul=s(e),ze=i(e,"P",{}),un(ze).forEach(l),this.h()},h(){rn(M,"name","hf:doc:metadata"),rn(M,"content",vn)},m(e,t){wn(document.head,M),n(e,w,t),n(e,c,t),n(e,T,t),p(B,e,t),n(e,Ee,t),p(G,e,t),n(e,Se,t),n(e,Z,t),n(e,Fe,t),p(I,e,t),n(e,Le,t),n(e,C,t),n(e,Ae,t),n(e,x,t),n(e,Pe,t),n(e,$,t),n(e,qe,t),n(e,H,t),n(e,De,t),n(e,W,t),n(e,Ke,t),n(e,k,t),n(e,Oe,t),p(R,e,t),n(e,et,t),p(_,e,t),n(e,tt,t),n(e,Y,t),n(e,lt,t),n(e,N,t),n(e,nt,t),p(Q,e,t),n(e,ot,t),n(e,X,t),n(e,st,t),p(V,e,t),n(e,at,t),n(e,z,t),n(e,it,t),p(f,e,t),n(e,dt,t),p(E,e,t),n(e,Mt,t),n(e,S,t),n(e,ut,t),n(e,F,t),n(e,rt,t),n(e,L,t),n(e,pt,t),n(e,A,t),n(e,mt,t),p(P,e,t),n(e,ht,t),n(e,q,t),n(e,yt,t),p(D,e,t),n(e,ct,t),n(e,K,t),n(e,wt,t),n(e,O,t),n(e,bt,t),n(e,ee,t),n(e,Tt,t),n(e,te,t),n(e,Ut,t),p(le,e,t),n(e,Jt,t),p(g,e,t),n(e,ft,t),p(ne,e,t),n(e,gt,t),n(e,oe,t),n(e,jt,t),n(e,se,t),n(e,vt,t),p(ae,e,t),n(e,Bt,t),n(e,ie,t),n(e,Gt,t),n(e,de,t),n(e,Zt,t),n(e,Me,t),n(e,It,t),p(ue,e,t),n(e,Ct,t),n(e,re,t),n(e,xt,t),n(e,pe,t),n(e,$t,t),n(e,me,t),n(e,Ht,t),p(he,e,t),n(e,Wt,t),p(ye,e,t),n(e,kt,t),n(e,ce,t),n(e,Rt,t),n(e,we,t),n(e,_t,t),p(be,e,t),n(e,Yt,t),n(e,Te,t),n(e,Nt,t),p(Ue,e,t),n(e,Qt,t),n(e,Je,t),n(e,Xt,t),n(e,fe,t),n(e,Vt,t),p(j,e,t),n(e,zt,t),n(e,ge,t),n(e,Et,t),p(je,e,t),n(e,St,t),n(e,ve,t),n(e,Ft,t),p(Be,e,t),n(e,Lt,t),n(e,Ge,t),n(e,At,t),p(Ze,e,t),n(e,Pt,t),n(e,Ie,t),n(e,qt,t),n(e,Ce,t),n(e,Dt,t),n(e,xe,t),n(e,Kt,t),n(e,$e,t),n(e,Ot,t),p(He,e,t),n(e,el,t),p(v,e,t),n(e,tl,t),p(We,e,t),n(e,ll,t),n(e,ke,t),n(e,nl,t),p(Re,e,t),n(e,ol,t),n(e,_e,t),n(e,sl,t),n(e,Ye,t),n(e,al,t),p(Ne,e,t),n(e,il,t),n(e,Qe,t),n(e,dl,t),n(e,Xe,t),n(e,Ml,t),p(Ve,e,t),n(e,ul,t),n(e,ze,t),rl=!0},p(e,[t]){const sn={};t&2&&(sn.$$scope={dirty:t,ctx:e}),f.$set(sn);const an={};t&2&&(an.$$scope={dirty:t,ctx:e}),g.$set(an);const dn={};t&2&&(dn.$$scope={dirty:t,ctx:e}),j.$set(dn);const Mn={};t&2&&(Mn.$$scope={dirty:t,ctx:e}),v.$set(Mn)},i(e){rl||(m(B.$$.fragment,e),m(G.$$.fragment,e),m(I.$$.fragment,e),m(R.$$.fragment,e),m(_.$$.fragment,e),m(Q.$$.fragment,e),m(V.$$.fragment,e),m(f.$$.fragment,e),m(E.$$.fragment,e),m(P.$$.fragment,e),m(D.$$.fragment,e),m(le.$$.fragment,e),m(g.$$.fragment,e),m(ne.$$.fragment,e),m(ae.$$.fragment,e),m(ue.$$.fragment,e),m(he.$$.fragment,e),m(ye.$$.fragment,e),m(be.$$.fragment,e),m(Ue.$$.fragment,e),m(j.$$.fragment,e),m(je.$$.fragment,e),m(Be.$$.fragment,e),m(Ze.$$.fragment,e),m(He.$$.fragment,e),m(v.$$.fragment,e),m(We.$$.fragment,e),m(Re.$$.fragment,e),m(Ne.$$.fragment,e),m(Ve.$$.fragment,e),rl=!0)},o(e){h(B.$$.fragment,e),h(G.$$.fragment,e),h(I.$$.fragment,e),h(R.$$.fragment,e),h(_.$$.fragment,e),h(Q.$$.fragment,e),h(V.$$.fragment,e),h(f.$$.fragment,e),h(E.$$.fragment,e),h(P.$$.fragment,e),h(D.$$.fragment,e),h(le.$$.fragment,e),h(g.$$.fragment,e),h(ne.$$.fragment,e),h(ae.$$.fragment,e),h(ue.$$.fragment,e),h(he.$$.fragment,e),h(ye.$$.fragment,e),h(be.$$.fragment,e),h(Ue.$$.fragment,e),h(j.$$.fragment,e),h(je.$$.fragment,e),h(Be.$$.fragment,e),h(Ze.$$.fragment,e),h(He.$$.fragment,e),h(v.$$.fragment,e),h(We.$$.fragment,e),h(Re.$$.fragment,e),h(Ne.$$.fragment,e),h(Ve.$$.fragment,e),rl=!1},d(e){e&&(l(w),l(c),l(T),l(Ee),l(Se),l(Z),l(Fe),l(Le),l(C),l(Ae),l(x),l(Pe),l($),l(qe),l(H),l(De),l(W),l(Ke),l(k),l(Oe),l(et),l(tt),l(Y),l(lt),l(N),l(nt),l(ot),l(X),l(st),l(at),l(z),l(it),l(dt),l(Mt),l(S),l(ut),l(F),l(rt),l(L),l(pt),l(A),l(mt),l(ht),l(q),l(yt),l(ct),l(K),l(wt),l(O),l(bt),l(ee),l(Tt),l(te),l(Ut),l(Jt),l(ft),l(gt),l(oe),l(jt),l(se),l(vt),l(Bt),l(ie),l(Gt),l(de),l(Zt),l(Me),l(It),l(Ct),l(re),l(xt),l(pe),l($t),l(me),l(Ht),l(Wt),l(kt),l(ce),l(Rt),l(we),l(_t),l(Yt),l(Te),l(Nt),l(Qt),l(Je),l(Xt),l(fe),l(Vt),l(zt),l(ge),l(Et),l(St),l(ve),l(Ft),l(Lt),l(Ge),l(At),l(Pt),l(Ie),l(qt),l(Ce),l(Dt),l(xe),l(Kt),l($e),l(Ot),l(el),l(tl),l(ll),l(ke),l(nl),l(ol),l(_e),l(sl),l(Ye),l(al),l(il),l(Qe),l(dl),l(Xe),l(Ml),l(ul),l(ze)),l(M),y(B,e),y(G,e),y(I,e),y(R,e),y(_,e),y(Q,e),y(V,e),y(f,e),y(E,e),y(P,e),y(D,e),y(le,e),y(g,e),y(ne,e),y(ae,e),y(ue,e),y(he,e),y(ye,e),y(be,e),y(Ue,e),y(j,e),y(je,e),y(Be,e),y(Ze,e),y(He,e),y(v,e),y(We,e),y(Re,e),y(Ne,e),y(Ve,e)}}}const vn='{"title":"Agents - Guided tour","local":"agents---guided-tour","sections":[{"title":"Building your agent","local":"building-your-agent","sections":[{"title":"Code execution","local":"code-execution","sections":[],"depth":4}],"depth":3},{"title":"The system prompt","local":"the-system-prompt","sections":[],"depth":3},{"title":"Inspecting an agent run","local":"inspecting-an-agent-run","sections":[],"depth":3},{"title":"Tools","local":"tools","sections":[{"title":"Default toolbox","local":"default-toolbox","sections":[],"depth":3},{"title":"Create a new tool","local":"create-a-new-tool","sections":[],"depth":3}],"depth":2},{"title":"Multi-agents","local":"multi-agents","sections":[],"depth":2},{"title":"Talk with your agent and visualize its thoughts in a cool Gradio interface","local":"talk-with-your-agent-and-visualize-its-thoughts-in-a-cool-gradio-interface","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Bn(J){return mn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hn extends hn{constructor(M){super(),yn(this,M,Bn,jn,pn,{})}}export{Hn as component};
