import{s as os,n as rs,o as is}from"../chunks/scheduler.85c25b89.js";import{S as ls,i as ss,g as a,s as o,r as d,A as ms,h as n,f as i,c as r,j as m,u as c,x as l,k as v,y as t,a as p,v as g,d as u,t as f,w as h}from"../chunks/index.c9837788.js";import{D as b}from"../chunks/Docstring.5c1d567f.js";import{H as j,E as ps}from"../chunks/EditOnGithub.b65eee75.js";function ds(fi){let Q,hn,tn,vn,be,bn,ye,hi="This page contains the API reference documentation for learning rate optimizers included in <code>timm</code>.",yn,_e,_n,xe,xn,y,$e,yo,Lt,vi="Create an optimizer instance via timm registry.",_o,At,bi=`Creates and configures an optimizer with appropriate parameter groups and settings.
Supports automatic parameter group creation for weight decay and layer-wise learning
rates, as well as custom parameter grouping.`,xo,Tt,yi="Examples:",$o,an,nn,we,Ce,wo,zt,_i="optimizer = create_optimizer_v2(model, ‘adamw’, lr=1e-3)",Co,on,rn,Le,Ae,Lo,Dt,xi=`optimizer = create_optimizer_v2(
…     model, ‘sgd’, lr=0.1, momentum=0.9, weight_decay=1e-4
… )`,Ao,ln,sn,Te,ze,To,Pt,$i=`optimizer = create_optimizer_v2(
…     model, ‘adam’, lr=1e-3, layer_decay=0.7
… )`,zo,mn,pn,De,Pe,Do,Mt,wi=`def group_fn(model):
…     return [
…         {‘params’: model.backbone.parameters(), ‘lr’: 1e-4},
…         {‘params’: model.head.parameters(), ‘lr’: 1e-3}
…     ]
optimizer = create_optimizer_v2(
…     model, ‘sgd’, param_group_fn=group_fn
… )`,Po,kt,Ci=`Note:
Parameter group handling precedence:`,Mo,It,Li="<li>If param_group_fn is provided, it will be used exclusively</li> <li>If layer_decay is provided, layer-wise groups will be created</li> <li>If weight_decay &gt; 0 and filter_bias_and_bn is True, weight decay groups will be created</li> <li>Otherwise, all parameters will be in a single group</li>",$n,_,Me,ko,qt,Ai="List available optimizer names, optionally filtered.",Io,Et,Ti=`List all registered optimizers, with optional filtering using wildcard patterns.
Optimizers can be filtered using include and exclude patterns, and can optionally
return descriptions with each optimizer name.`,qo,Ot,zi="Examples:",Eo,Nt,Di=`<blockquote><blockquote><p>list_optimizers()
[‘adam’, ‘adamw’, ‘sgd’, …]</p></blockquote></blockquote>`,Oo,Ft,Pi=`<blockquote><blockquote><p>list_optimizers([‘la<em>’, ‘nla</em>’])  # List lamb &amp; lars
[‘lamb’, ‘lambc’, ‘larc’, ‘lars’, ‘nlarc’, ‘nlars’]</p></blockquote></blockquote>`,No,Ht,Mi=`<blockquote><blockquote><p>list_optimizers(’<em>adam</em>’, exclude_filters=[‘bnb<em>’, ‘fused</em>’])  # Exclude bnb &amp; apex adam optimizers
[‘adam’, ‘adamax’, ‘adamp’, ‘adamw’, ‘nadam’, ‘nadamw’, ‘radam’]</p></blockquote></blockquote>`,Fo,Bt,ki=`<blockquote><blockquote><p>list_optimizers(with_description=True)  # Get descriptions
[(‘adabelief’, ‘Adapts learning rate based on gradient prediction error’),
(‘adadelta’, ‘torch.optim Adadelta, Adapts learning rates based on running windows of gradients’),
(‘adafactor’, ‘Memory-efficient implementation of Adam with factored gradients’),
…]</p></blockquote></blockquote>`,wn,L,ke,Ho,Gt,Ii="Get optimizer class by name with option to bind default arguments.",Bo,St,qi=`Retrieves the optimizer class or a partial function with default arguments bound.
This allows direct instantiation of optimizers with their default configurations
without going through the full factory.`,Go,Rt,Ei="Examples:",So,dn,cn,Ie,qe,Ro,Vt,Oi=`SGD = get_optimizer_class(‘sgd’)  # nesterov=True bound
opt = SGD(model.parameters(), lr=0.1, momentum=0.9)`,Vo,gn,un,Ee,Oe,Uo,Ut,Ni=`SGD = get_optimizer_class(‘sgd’)
opt = SGD(model.parameters(), lr=1e-3, momentum=0.9)`,Cn,Ne,Ln,A,Fe,Wo,Wt,Fi="Implements AdaBelief algorithm. Modified from Adam in PyTorch",jo,jt,Hi="reference: AdaBelief Optimizer, adapting stepsizes by the belief in observed gradients, NeurIPS 2020",Qo,Qt,Bi=`For a complete table of recommended hyperparameters, see <a href="https://github.com/juntang-zhuang/Adabelief-Optimizer&#39;" rel="nofollow">https://github.com/juntang-zhuang/Adabelief-Optimizer’</a>
For example train/args for EfficientNet see these gists`,Ko,Kt,Gi='<li>link to train_scipt: <a href="https://gist.github.com/juntang-zhuang/0a501dd51c02278d952cf159bc233037" rel="nofollow">https://gist.github.com/juntang-zhuang/0a501dd51c02278d952cf159bc233037</a></li> <li>link to args.yaml: <a href="https://gist.github.com/juntang-zhuang/517ce3c27022b908bb93f78e4f786dc3" rel="nofollow">https://gist.github.com/juntang-zhuang/517ce3c27022b908bb93f78e4f786dc3</a></li>',Zo,Z,He,Xo,Zt,Si="Performs a single optimization step.",An,w,Be,Jo,Xt,Ri="Implements Adafactor algorithm.",Yo,Jt,Vi=`This implementation is based on: <code>Adafactor: Adaptive Learning Rates with Sublinear Memory Cost</code>
(see <a href="https://arxiv.org/abs/1804.04235" rel="nofollow">https://arxiv.org/abs/1804.04235</a>)`,er,Yt,Ui=`Note that this optimizer internally adjusts the learning rate depending on the
<em>scale_parameter</em>, <em>relative_step</em> and <em>warmup_init</em> options.`,tr,ea,Wi=`To use a manual (external) learning rate schedule you should set <code>scale_parameter=False</code> and
<code>relative_step=False</code>.`,ar,ta,ji=`Ags:
params: iterable of parameters to optimize or dicts defining parameter groups
lr: external learning rate
eps: regularization constants for square gradient and parameter scale respectively
eps_scale: regularization constants for parameter scale respectively
clip_threshold: threshold of root-mean-square of final gradient update
decay_rate: coefficient used to compute running averages of square gradient
beta1: coefficient used for computing running averages of gradient
weight_decay: weight decay
scale_parameter: if True, learning rate is scaled by root-mean-square of parameter
warmup_init: time-dependent learning rate computation depends on whether warm-up initialization is being used`,nr,X,Ge,or,aa,Qi="Performs a single optimization step.",Tn,S,Se,rr,na,Ki="PyTorch implementation of BigVision’s Adafactor variant with both single and multi tensor implementations.",ir,oa,Zi='Adapted from <a href="https://github.com/google-research/big_vision" rel="nofollow">https://github.com/google-research/big_vision</a> by Ross Wightman',zn,T,Re,lr,ra,Xi="Implements the AdaHessian algorithm from “ADAHESSIAN: An Adaptive Second OrderOptimizer for Machine Learning”",sr,J,Ve,mr,ia,Ji="Gets all parameters in all param_groups with gradients",pr,Y,Ue,dr,la,Yi="Computes the Hutchinson approximation of the hessian trace and accumulates it for each trainable parameter.",cr,ee,We,gr,sa,el="Performs a single optimization step.",ur,te,je,fr,ma,tl="Zeros out the accumalated hessian traces.",Dn,Qe,Ke,Pn,q,Ze,hr,pa,al="Implements a pytorch variant of Adan.",vr,da,nl=`Adan was proposed in Adan: Adaptive Nesterov Momentum Algorithm for Faster Optimizing Deep Models
<a href="https://arxiv.org/abs/2208.06677" rel="nofollow">https://arxiv.org/abs/2208.06677</a>`,br,ae,Xe,yr,ca,ol="Performs a single optimization step.",Mn,R,Je,_r,ga,rl='ADOPT: Modified Adam Can Converge with Any β2 with the Optimal Rate: <a href="https://arxiv.org/abs/2411.02853" rel="nofollow">https://arxiv.org/abs/2411.02853</a>',xr,ne,Ye,$r,ua,il="Perform a single optimization step.",kn,M,et,wr,fa,ll=`Implements a pure pytorch variant of FuseLAMB (NvLamb variant) optimizer from apex.optimizers.FusedLAMB
reference: <a href="https://github.com/NVIDIA/DeepLearningExamples/blob/master/PyTorch/LanguageModeling/Transformer-XL/pytorch/lamb.py" rel="nofollow">https://github.com/NVIDIA/DeepLearningExamples/blob/master/PyTorch/LanguageModeling/Transformer-XL/pytorch/lamb.py</a>`,Cr,ha,sl="LAMB was proposed in:",Lr,va,ml='<li>Large Batch Optimization for Deep Learning - Training BERT in 76 minutes:  <a href="https://arxiv.org/abs/1904.00962" rel="nofollow">https://arxiv.org/abs/1904.00962</a></li> <li>On the Convergence of Adam and Beyond: <a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a></li>',Ar,oe,tt,Tr,ba,pl="Performs a single optimization step.",In,E,at,zr,ya,dl="LaProp Optimizer",Dr,_a,cl='Paper: LaProp: Separating Momentum and Adaptivity in Adam, <a href="https://arxiv.org/abs/2002.04839" rel="nofollow">https://arxiv.org/abs/2002.04839</a>',Pr,re,nt,Mr,xa,gl="Performs a single optimization step.",qn,O,ot,kr,$a,ul="LARS for PyTorch",Ir,wa,fl='Paper: <code>Large batch training of Convolutional Networks</code> - <a href="https://arxiv.org/pdf/1708.03888.pdf" rel="nofollow">https://arxiv.org/pdf/1708.03888.pdf</a>',qr,ie,rt,Er,Ca,hl="Performs a single optimization step.",En,V,it,Or,La,vl="Implements Lion algorithm.",Nr,le,lt,Fr,Aa,bl="Performs a single optimization step.",On,st,mt,Nn,C,pt,Hr,Ta,yl=`MADGRAD_: A Momentumized, Adaptive, Dual Averaged Gradient Method for Stochastic
Optimization.`,Br,za,_l='.. _MADGRAD: <a href="https://arxiv.org/abs/2101.11075" rel="nofollow">https://arxiv.org/abs/2101.11075</a>',Gr,Da,xl=`MADGRAD is a general purpose optimizer that can be used in place of SGD or
Adam may converge faster and generalize better. Currently GPU-only.
Typically, the same learning rate schedule that is used for SGD or Adam may
be used. The overall learning rate is not comparable to either method and
should be determined by a hyper-parameter sweep.`,Sr,Pa,$l=`MADGRAD requires less weight decay than other methods, often as little as
zero. Momentum values used for SGD or Adam’s beta1 should work here also.`,Rr,Ma,wl="On sparse problems both weight_decay and momentum should be set to 0.",Vr,se,dt,Ur,ka,Cl="Performs a single optimization step.",Fn,N,ct,Wr,Ia,Ll="MARS Optimizer",jr,qa,Al=`Paper: MARS: Unleashing the Power of Variance Reduction for Training Large Models
<a href="https://arxiv.org/abs/2411.10438" rel="nofollow">https://arxiv.org/abs/2411.10438</a>`,Qr,me,gt,Kr,Ea,Tl="Performs a single optimization step.",Hn,z,ut,Zr,Oa,zl="Implements NAdamW algorithm.",Xr,Na,Dl=`See Table 1 in <a href="https://arxiv.org/abs/1910.05446" rel="nofollow">https://arxiv.org/abs/1910.05446</a> for the implementation of
the NAdam algorithm (there is also a comment in the code which highlights
the only difference of NAdamW and AdamW).`,Jr,Fa,Pl="For further details regarding the algorithm we refer to",Yr,Ha,Ml='<li>Decoupled Weight Decay Regularization: <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a></li> <li>On the Convergence of Adam and Beyond: <a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a></li>',ei,pe,ft,ti,Ba,kl="Performs a single optimization step.",Bn,U,ht,ai,Ga,Il="Implements Novograd algorithm.",ni,de,vt,oi,Sa,ql="Performs a single optimization step.",Gn,x,bt,ri,Ra,El="Implements RMSprop algorithm (TensorFlow style epsilon)",ii,Va,Ol=`NOTE: This is a direct cut-and-paste of PyTorch RMSprop with eps applied before sqrt
and a few other modifications to closer match Tensorflow for matching hyper-params.`,li,Ua,Nl="Noteworthy changes include:",si,Wa,Fl="<li>Epsilon applied inside square-root</li> <li>square_avg initialized to ones</li> <li>LR scaling of update accumulated in momentum buffer</li>",mi,ja,Hl=`Proposed by G. Hinton in his
<a href="http://www.cs.toronto.edu/~tijmen/csc321/slides/lecture_slides_lec6.pdf" rel="nofollow">course</a>.`,pi,Qa,Bl=`The centered version first appears in <a href="https://arxiv.org/pdf/1308.0850v5.pdf" rel="nofollow">Generating Sequences
With Recurrent Neural Networks</a>.`,di,ce,yt,ci,Ka,Gl="Performs a single optimization step.",Sn,_t,xt,Rn,K,$t,gi,ge,wt,ui,Za,Sl="Performs a single optimization step.",Vn,Ct,Un,fn,Wn;return be=new j({props:{title:"Optimization",local:"optimization",headingTag:"h1"}}),_e=new j({props:{title:"Optimizers",local:"optimizers",headingTag:"h2"}}),xe=new j({props:{title:"Factory functions",local:"timm.optim.create_optimizer_v2",headingTag:"h3"}}),$e=new b({props:{name:"timm.optim.create_optimizer_v2",anchor:"timm.optim.create_optimizer_v2",parameters:[{name:"model_or_params",val:": typing.Union[torch.nn.modules.module.Module, typing.Iterable[torch.Tensor], typing.Iterable[typing.Dict[str, typing.Any]]]"},{name:"opt",val:": str = 'sgd'"},{name:"lr",val:": typing.Optional[float] = None"},{name:"weight_decay",val:": float = 0.0"},{name:"momentum",val:": float = 0.9"},{name:"foreach",val:": typing.Optional[bool] = None"},{name:"filter_bias_and_bn",val:": bool = True"},{name:"layer_decay",val:": typing.Optional[float] = None"},{name:"param_group_fn",val:": typing.Optional[typing.Callable[[torch.nn.modules.module.Module], typing.Union[typing.Iterable[torch.Tensor], typing.Iterable[typing.Dict[str, typing.Any]]]]] = None"},{name:"**kwargs",val:": typing.Any"}],parametersDescription:[{anchor:"timm.optim.create_optimizer_v2.model_or_params",description:`<strong>model_or_params</strong> &#x2014; A PyTorch model or an iterable of parameters/parameter groups.
If a model is provided, parameters will be automatically extracted and grouped
based on the other arguments.`,name:"model_or_params"},{anchor:"timm.optim.create_optimizer_v2.opt",description:`<strong>opt</strong> &#x2014; Name of the optimizer to create (e.g., &#x2018;adam&#x2019;, &#x2018;adamw&#x2019;, &#x2018;sgd&#x2019;).
Use list_optimizers() to see available options.`,name:"opt"},{anchor:"timm.optim.create_optimizer_v2.lr",description:"<strong>lr</strong> &#x2014; Learning rate. If None, will use the optimizer&#x2019;s default.",name:"lr"},{anchor:"timm.optim.create_optimizer_v2.weight_decay",description:"<strong>weight_decay</strong> &#x2014; Weight decay factor. Will be used to create param groups if model_or_params is a model.",name:"weight_decay"},{anchor:"timm.optim.create_optimizer_v2.momentum",description:`<strong>momentum</strong> &#x2014; Momentum factor for optimizers that support it. Only used if the
chosen optimizer accepts a momentum parameter.`,name:"momentum"},{anchor:"timm.optim.create_optimizer_v2.foreach",description:`<strong>foreach</strong> &#x2014; Enable/disable foreach (multi-tensor) implementation if available.
If None, will use optimizer-specific defaults.`,name:"foreach"},{anchor:"timm.optim.create_optimizer_v2.filter_bias_and_bn",description:`<strong>filter_bias_and_bn</strong> &#x2014; If True, bias, norm layer parameters (all 1d params) will not have
weight decay applied. Only used when model_or_params is a model and
weight_decay &gt; 0.`,name:"filter_bias_and_bn"},{anchor:"timm.optim.create_optimizer_v2.layer_decay",description:`<strong>layer_decay</strong> &#x2014; Optional layer-wise learning rate decay factor. If provided,
learning rates will be scaled by layer_decay^(max_depth - layer_depth).
Only used when model_or_params is a model.`,name:"layer_decay"},{anchor:"timm.optim.create_optimizer_v2.param_group_fn",description:`<strong>param_group_fn</strong> &#x2014; Optional function to create custom parameter groups.
If provided, other parameter grouping options will be ignored.`,name:"param_group_fn"},{anchor:"timm.optim.create_optimizer_v2.*kwargs",description:"*<strong>*kwargs</strong> &#x2014; Additional optimizer-specific arguments (e.g., betas for Adam).",name:"*kwargs"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/_optim_factory.py#L993",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Configured optimizer instance.</p>
`}}),Ce=new j({props:{title:"Basic usage with a model",local:"basic-usage-with-a-model",headingTag:"h1"}}),Ae=new j({props:{title:"SGD with momentum and weight decay",local:"sgd-with-momentum-and-weight-decay",headingTag:"h1"}}),ze=new j({props:{title:"Adam with layer-wise learning rate decay",local:"adam-with-layer-wise-learning-rate-decay",headingTag:"h1"}}),Pe=new j({props:{title:"Custom parameter groups",local:"custom-parameter-groups",headingTag:"h1"}}),Me=new b({props:{name:"timm.optim.list_optimizers",anchor:"timm.optim.list_optimizers",parameters:[{name:"filter",val:": typing.Union[str, typing.List[str]] = ''"},{name:"exclude_filters",val:": typing.Optional[typing.List[str]] = None"},{name:"with_description",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.list_optimizers.filter",description:`<strong>filter</strong> &#x2014; Wildcard style filter string or list of filter strings
(e.g., &#x2018;adam<em>&#x2019; for all Adam variants, or [&#x2018;adam</em>&#x2019;, &#x2018;*8bit&#x2019;] for
Adam variants and 8-bit optimizers). Empty string means no filtering.`,name:"filter"},{anchor:"timm.optim.list_optimizers.exclude_filters",description:`<strong>exclude_filters</strong> &#x2014; Optional list of wildcard patterns to exclude. For example,
[&#x2019;<em>8bit&#x2019;, &#x2018;fused</em>&#x2019;] would exclude 8-bit and fused implementations.`,name:"exclude_filters"},{anchor:"timm.optim.list_optimizers.with_description",description:`<strong>with_description</strong> &#x2014; If True, returns tuples of (name, description) instead of
just names. Descriptions provide brief explanations of optimizer characteristics.`,name:"with_description"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/_optim_factory.py#L896",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of optimizer names as strings (e.g., [‘adam’, ‘adamw’, …])
If with_description is True:
List of tuples of (name, description) (e.g., [(‘adam’, ‘Adaptive Moment…’), …])</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If with_description is False</p>
`}}),ke=new b({props:{name:"timm.optim.get_optimizer_class",anchor:"timm.optim.get_optimizer_class",parameters:[{name:"name",val:": str"},{name:"bind_defaults",val:": bool = True"}],parametersDescription:[{anchor:"timm.optim.get_optimizer_class.name",description:"<strong>name</strong> &#x2014; Name of the optimizer to retrieve (e.g., &#x2018;adam&#x2019;, &#x2018;sgd&#x2019;)",name:"name"},{anchor:"timm.optim.get_optimizer_class.bind_defaults",description:`<strong>bind_defaults</strong> &#x2014; If True, returns a partial function with default arguments from OptimInfo bound.
If False, returns the raw optimizer class.`,name:"bind_defaults"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/_optim_factory.py#L956",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The optimizer class (e.g., torch.optim.Adam)
If bind_defaults is True:
A partial function with default arguments bound</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If bind_defaults is False</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> — If optimizer name is not found in registry</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),qe=new j({props:{title:"Get SGD with nesterov momentum default",local:"get-sgd-with-nesterov-momentum-default",headingTag:"h1"}}),Oe=new j({props:{title:"Get raw optimizer class",local:"get-raw-optimizer-class",headingTag:"h1"}}),Ne=new j({props:{title:"Optimizer Classes",local:"timm.optim.AdaBelief",headingTag:"h3"}}),Fe=new b({props:{name:"class timm.optim.AdaBelief",anchor:"timm.optim.AdaBelief",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-16"},{name:"weight_decay",val:" = 0"},{name:"amsgrad",val:" = False"},{name:"decoupled_decay",val:" = True"},{name:"fixed_decay",val:" = False"},{name:"rectify",val:" = True"},{name:"degenerated_to_sgd",val:" = True"}],parametersDescription:[{anchor:"timm.optim.AdaBelief.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.AdaBelief.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.AdaBelief.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.AdaBelief.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-16)`,name:"eps"},{anchor:"timm.optim.AdaBelief.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.AdaBelief.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"},{anchor:"timm.optim.AdaBelief.decoupled_decay",description:`<strong>decoupled_decay</strong> (boolean, optional) &#x2014; (default: True) If set as True, then
the optimizer uses decoupled weight decay as in AdamW`,name:"decoupled_decay"},{anchor:"timm.optim.AdaBelief.fixed_decay",description:`<strong>fixed_decay</strong> (boolean, optional) &#x2014; (default: False) This is used when weight<em>decouple
is set as True.
When fixed_decay == True, the weight decay is performed as
$W</em>{new} = W<em>{old} - W</em>{old} \\times decay$.
When fixed<em>decay == False, the weight decay is performed as
$W</em>{new} = W<em>{old} - W</em>{old} \\times decay \\times lr$. Note that in this case, the
weight decay ratio decreases with learning rate (lr).`,name:"fixed_decay"},{anchor:"timm.optim.AdaBelief.rectify",description:`<strong>rectify</strong> (boolean, optional) &#x2014; (default: True) If set as True, then perform the rectified
update similar to RAdam`,name:"rectify"},{anchor:"timm.optim.AdaBelief.degenerated_to_sgd",description:`<strong>degenerated_to_sgd</strong> (boolean, optional) (default &#x2014;True) If set as True, then perform SGD update
when variance of gradient is high`,name:"degenerated_to_sgd"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adabelief.py#L6"}}),He=new b({props:{name:"step",anchor:"timm.optim.AdaBelief.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.AdaBelief.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adabelief.py#L106"}}),Be=new b({props:{name:"class timm.optim.Adafactor",anchor:"timm.optim.Adafactor",parameters:[{name:"params",val:": typing.Union[typing.Iterable[torch.Tensor], typing.Iterable[typing.Dict[str, typing.Any]]]"},{name:"lr",val:": typing.Optional[float] = None"},{name:"eps",val:": float = 1e-30"},{name:"eps_scale",val:": float = 0.001"},{name:"clip_threshold",val:": float = 1.0"},{name:"decay_rate",val:": float = -0.8"},{name:"betas",val:": typing.Optional[typing.Tuple[float, float]] = None"},{name:"weight_decay",val:": float = 0.0"},{name:"scale_parameter",val:": bool = True"},{name:"warmup_init",val:": bool = False"},{name:"min_dim_size_to_factor",val:": int = 16"},{name:"caution",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adafactor.py#L21"}}),Ge=new b({props:{name:"step",anchor:"timm.optim.Adafactor.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adafactor.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adafactor.py#L127"}}),Se=new b({props:{name:"class timm.optim.AdafactorBigVision",anchor:"timm.optim.AdafactorBigVision",parameters:[{name:"params",val:": typing.Union[typing.Iterable[torch.Tensor], typing.Iterable[typing.Dict[str, typing.Any]]]"},{name:"lr",val:": float = 1.0"},{name:"min_dim_size_to_factor",val:": int = 16"},{name:"decay_rate",val:": float = 0.8"},{name:"decay_offset",val:": int = 0"},{name:"beta2_cap",val:": float = 0.999"},{name:"momentum",val:": typing.Optional[float] = 0.9"},{name:"momentum_dtype",val:": typing.Union[str, torch.dtype] = torch.bfloat16"},{name:"eps",val:": typing.Optional[float] = None"},{name:"weight_decay",val:": float = 0.0"},{name:"clipping_threshold",val:": typing.Optional[float] = None"},{name:"unscaled_wd",val:": bool = False"},{name:"caution",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adafactor_bv.py#L49"}}),Re=new b({props:{name:"class timm.optim.Adahessian",anchor:"timm.optim.Adahessian",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.1"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.0"},{name:"hessian_power",val:" = 1.0"},{name:"update_each",val:" = 1"},{name:"n_samples",val:" = 1"},{name:"avg_conv_kernel",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Adahessian.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.Adahessian.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 0.1)",name:"lr"},{anchor:"timm.optim.Adahessian.betas",description:`<strong>betas</strong> ((float, float), optional) &#x2014; coefficients used for computing running averages of gradient and the
squared hessian trace (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.Adahessian.eps",description:"<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve numerical stability (default: 1e-8)",name:"eps"},{anchor:"timm.optim.Adahessian.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0.0)",name:"weight_decay"},{anchor:"timm.optim.Adahessian.hessian_power",description:"<strong>hessian_power</strong> (float, optional) &#x2014; exponent of the hessian trace (default: 1.0)",name:"hessian_power"},{anchor:"timm.optim.Adahessian.update_each",description:`<strong>update_each</strong> (int, optional) &#x2014; compute the hessian trace approximation only after <em>this</em> number of steps
(to save time) (default: 1)`,name:"update_each"},{anchor:"timm.optim.Adahessian.n_samples",description:"<strong>n_samples</strong> (int, optional) &#x2014; how many times to sample <code>z</code> for the approximation of the hessian trace (default: 1)",name:"n_samples"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L9"}}),Ve=new b({props:{name:"get_params",anchor:"timm.optim.Adahessian.get_params",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L74"}}),Ue=new b({props:{name:"set_hessian",anchor:"timm.optim.Adahessian.set_hessian",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L90"}}),We=new b({props:{name:"step",anchor:"timm.optim.Adahessian.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adahessian.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; a closure that reevaluates the model and returns the loss (default &#x2014; None)",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L118"}}),je=new b({props:{name:"zero_hessian",anchor:"timm.optim.Adahessian.zero_hessian",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L81"}}),Ke=new b({props:{name:"class timm.optim.AdamP",anchor:"timm.optim.AdamP",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"delta",val:" = 0.1"},{name:"wd_ratio",val:" = 0.1"},{name:"nesterov",val:" = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adamp.py#L43"}}),Ze=new b({props:{name:"class timm.optim.Adan",anchor:"timm.optim.Adan",parameters:[{name:"params",val:""},{name:"lr",val:": float = 0.001"},{name:"betas",val:": typing.Tuple[float, float, float] = (0.98, 0.92, 0.99)"},{name:"eps",val:": float = 1e-08"},{name:"weight_decay",val:": float = 0.0"},{name:"no_prox",val:": bool = False"},{name:"caution",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"timm.optim.Adan.params",description:"<strong>params</strong> &#x2014; Iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Adan.lr",description:"<strong>lr</strong> &#x2014; Learning rate.",name:"lr"},{anchor:"timm.optim.Adan.betas",description:"<strong>betas</strong> &#x2014; Coefficients used for first- and second-order moments.",name:"betas"},{anchor:"timm.optim.Adan.eps",description:"<strong>eps</strong> &#x2014; Term added to the denominator to improve numerical stability.",name:"eps"},{anchor:"timm.optim.Adan.weight_decay",description:"<strong>weight_decay</strong> &#x2014; Decoupled weight decay (L2 penalty)",name:"weight_decay"},{anchor:"timm.optim.Adan.no_prox",description:"<strong>no_prox</strong> &#x2014; How to perform the weight decay",name:"no_prox"},{anchor:"timm.optim.Adan.caution",description:"<strong>caution</strong> &#x2014; Enable caution from &#x2018;Cautious Optimizers&#x2019;",name:"caution"},{anchor:"timm.optim.Adan.foreach",description:"<strong>foreach</strong> &#x2014; If True would use torch._foreach implementation. Faster but uses slightly more memory.",name:"foreach"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adan.py#L46"}}),Xe=new b({props:{name:"step",anchor:"timm.optim.Adan.step",parameters:[{name:"closure",val:" = None"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adan.py#L117"}}),Je=new b({props:{name:"class timm.optim.Adopt",anchor:"timm.optim.Adopt",parameters:[{name:"params",val:": typing.Union[typing.Iterable[torch.Tensor], typing.Iterable[typing.Dict[str, typing.Any]]]"},{name:"lr",val:": typing.Union[float, torch.Tensor] = 0.001"},{name:"betas",val:": typing.Tuple[float, float] = (0.9, 0.9999)"},{name:"eps",val:": float = 1e-06"},{name:"clip_exp",val:": typing.Optional[float] = 0.333"},{name:"weight_decay",val:": float = 0.0"},{name:"decoupled",val:": bool = False"},{name:"caution",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = False"},{name:"maximize",val:": bool = False"},{name:"capturable",val:": bool = False"},{name:"differentiable",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adopt.py#L55"}}),Ye=new b({props:{name:"step",anchor:"timm.optim.Adopt.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adopt.step.closure",description:`<strong>closure</strong> (Callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adopt.py#L181"}}),et=new b({props:{name:"class timm.optim.Lamb",anchor:"timm.optim.Lamb",parameters:[{name:"params",val:": typing.Union[typing.Iterable[torch.Tensor], typing.Iterable[typing.Dict[str, typing.Any]]]"},{name:"lr",val:": float = 0.001"},{name:"bias_correction",val:": bool = True"},{name:"betas",val:": typing.Tuple[float, float] = (0.9, 0.999)"},{name:"eps",val:": float = 1e-06"},{name:"weight_decay",val:": float = 0.01"},{name:"grad_averaging",val:": bool = True"},{name:"max_grad_norm",val:": typing.Optional[float] = 1.0"},{name:"trust_clip",val:": bool = False"},{name:"always_adapt",val:": bool = False"},{name:"caution",val:": bool = False"},{name:"decoupled_decay",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.Lamb.params",description:"<strong>params</strong> &#x2014; Iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Lamb.lr",description:"<strong>lr</strong> &#x2014; Learning rate",name:"lr"},{anchor:"timm.optim.Lamb.betas",description:"<strong>betas</strong> &#x2014; Coefficients used for computing running averages of gradient and its norm.",name:"betas"},{anchor:"timm.optim.Lamb.eps",description:"<strong>eps</strong> &#x2014; Term added to the denominator to improve numerical stability.",name:"eps"},{anchor:"timm.optim.Lamb.weight_decay",description:"<strong>weight_decay</strong> &#x2014; Weight decay",name:"weight_decay"},{anchor:"timm.optim.Lamb.grad_averaging",description:"<strong>grad_averaging</strong> &#x2014; Whether apply (1-beta2) to grad when calculating running averages of gradient.",name:"grad_averaging"},{anchor:"timm.optim.Lamb.max_grad_norm",description:"<strong>max_grad_norm</strong> &#x2014; Value used to clip global grad norm.",name:"max_grad_norm"},{anchor:"timm.optim.Lamb.trust_clip",description:"<strong>trust_clip</strong> &#x2014; Enable LAMBC trust ratio clipping.",name:"trust_clip"},{anchor:"timm.optim.Lamb.always_adapt",description:"<strong>always_adapt</strong> &#x2014; Apply adaptive learning rate to 0.0 weight decay parameter.",name:"always_adapt"},{anchor:"timm.optim.Lamb.caution",description:"<strong>caution</strong> &#x2014; Apply caution.",name:"caution"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lamb.py#L63"}}),tt=new b({props:{name:"step",anchor:"timm.optim.Lamb.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lamb.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lamb.py#L138"}}),at=new b({props:{name:"class timm.optim.LaProp",anchor:"timm.optim.LaProp",parameters:[{name:"params",val:": typing.Union[typing.Iterable[torch.Tensor], typing.Iterable[typing.Dict[str, typing.Any]]]"},{name:"lr",val:": float = 0.0004"},{name:"betas",val:": typing.Tuple[float, float] = (0.9, 0.999)"},{name:"eps",val:": float = 1e-15"},{name:"weight_decay",val:": float = 0.0"},{name:"caution",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/laprop.py#L23"}}),nt=new b({props:{name:"step",anchor:"timm.optim.LaProp.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.LaProp.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/laprop.py#L54"}}),ot=new b({props:{name:"class timm.optim.Lars",anchor:"timm.optim.Lars",parameters:[{name:"params",val:""},{name:"lr",val:" = 1.0"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"trust_coeff",val:" = 0.001"},{name:"eps",val:" = 1e-08"},{name:"trust_clip",val:" = False"},{name:"always_adapt",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Lars.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Lars.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1.0).",name:"lr"},{anchor:"timm.optim.Lars.momentum",description:"<strong>momentum</strong> (float, optional) &#x2014; momentum factor (default: 0)",name:"momentum"},{anchor:"timm.optim.Lars.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Lars.dampening",description:"<strong>dampening</strong> (float, optional) &#x2014; dampening for momentum (default: 0)",name:"dampening"},{anchor:"timm.optim.Lars.nesterov",description:"<strong>nesterov</strong> (bool, optional) &#x2014; enables Nesterov momentum (default: False)",name:"nesterov"},{anchor:"timm.optim.Lars.trust_coeff",description:"<strong>trust_coeff</strong> (float) &#x2014; trust coefficient for computing adaptive lr / trust_ratio (default: 0.001)",name:"trust_coeff"},{anchor:"timm.optim.Lars.eps",description:"<strong>eps</strong> (float) &#x2014; eps for division denominator (default: 1e-8)",name:"eps"},{anchor:"timm.optim.Lars.trust_clip",description:"<strong>trust_clip</strong> (bool) &#x2014; enable LARC trust ratio clipping (default: False)",name:"trust_clip"},{anchor:"timm.optim.Lars.always_adapt",description:"<strong>always_adapt</strong> (bool) &#x2014; always apply LARS LR adapt, otherwise only when group weight_decay != 0 (default: False)",name:"always_adapt"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lars.py#L17"}}),rt=new b({props:{name:"step",anchor:"timm.optim.Lars.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lars.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lars.py#L75"}}),it=new b({props:{name:"class timm.optim.Lion",anchor:"timm.optim.Lion",parameters:[{name:"params",val:": typing.Union[typing.Iterable[torch.Tensor], typing.Iterable[typing.Dict[str, typing.Any]]]"},{name:"lr",val:": float = 0.0001"},{name:"betas",val:": typing.Tuple[float, float] = (0.9, 0.99)"},{name:"weight_decay",val:": float = 0.0"},{name:"caution",val:": bool = False"},{name:"maximize",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lion.py#L27"}}),lt=new b({props:{name:"step",anchor:"timm.optim.Lion.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lion.step.closure",description:"<strong>closure</strong> &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lion.py#L73",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the loss.</p>
`}}),mt=new b({props:{name:"class timm.optim.Lookahead",anchor:"timm.optim.Lookahead",parameters:[{name:"base_optimizer",val:""},{name:"alpha",val:" = 0.5"},{name:"k",val:" = 6"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lookahead.py#L15"}}),pt=new b({props:{name:"class timm.optim.MADGRAD",anchor:"timm.optim.MADGRAD",parameters:[{name:"params",val:": typing.Any"},{name:"lr",val:": float = 0.01"},{name:"momentum",val:": float = 0.9"},{name:"weight_decay",val:": float = 0"},{name:"eps",val:": float = 1e-06"},{name:"decoupled_decay",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.MADGRAD.params",description:`<strong>params</strong> (iterable) &#x2014;
Iterable of parameters to optimize or dicts defining parameter groups.`,name:"params"},{anchor:"timm.optim.MADGRAD.lr",description:`<strong>lr</strong> (float) &#x2014;
Learning rate (default: 1e-2).`,name:"lr"},{anchor:"timm.optim.MADGRAD.momentum",description:`<strong>momentum</strong> (float) &#x2014;
Momentum value in  the range [0,1) (default: 0.9).`,name:"momentum"},{anchor:"timm.optim.MADGRAD.weight_decay",description:`<strong>weight_decay</strong> (float) &#x2014;
Weight decay, i.e. a L2 penalty (default: 0).`,name:"weight_decay"},{anchor:"timm.optim.MADGRAD.eps",description:`<strong>eps</strong> (float) &#x2014;
Term added to the denominator outside of the root operation to improve numerical stability. (default: 1e-6).`,name:"eps"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/madgrad.py#L24"}}),dt=new b({props:{name:"step",anchor:"timm.optim.MADGRAD.step",parameters:[{name:"closure",val:": typing.Optional[typing.Callable[[], float]] = None"}],parametersDescription:[{anchor:"timm.optim.MADGRAD.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/madgrad.py#L90"}}),ct=new b({props:{name:"class timm.optim.Mars",anchor:"timm.optim.Mars",parameters:[{name:"params",val:": typing.Union[typing.Iterable[torch.Tensor], typing.Iterable[typing.Dict[str, typing.Any]]]"},{name:"lr",val:": float = 0.003"},{name:"betas",val:": typing.Tuple[float, float] = (0.9, 0.99)"},{name:"eps",val:": float = 1e-08"},{name:"weight_decay",val:": float = 0.0"},{name:"gamma",val:": float = 0.025"},{name:"mars_type",val:": str = 'adamw'"},{name:"optimize_1d",val:": bool = False"},{name:"lr_1d_factor",val:": float = 1.0"},{name:"betas_1d",val:": typing.Optional[typing.Tuple[float, float]] = None"},{name:"caution",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/mars.py#L91"}}),gt=new b({props:{name:"step",anchor:"timm.optim.Mars.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Mars.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/mars.py#L141"}}),ut=new b({props:{name:"class timm.optim.NAdamW",anchor:"timm.optim.NAdamW",parameters:[{name:"params",val:": typing.Union[typing.Iterable[torch.Tensor], typing.Iterable[typing.Dict[str, typing.Any]]]"},{name:"lr",val:": float = 0.001"},{name:"betas",val:": typing.Tuple[float, float] = (0.9, 0.999)"},{name:"eps",val:": float = 1e-08"},{name:"weight_decay",val:": float = 0.01"},{name:"caution",val:": bool = False"},{name:"maximize",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = None"},{name:"capturable",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.NAdamW.params",description:"<strong>params</strong> &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.NAdamW.lr",description:"<strong>lr</strong> &#x2014; learning rate",name:"lr"},{anchor:"timm.optim.NAdamW.betas",description:"<strong>betas</strong> &#x2014; coefficients used for computing running averages of gradient and its square",name:"betas"},{anchor:"timm.optim.NAdamW.eps",description:"<strong>eps</strong> &#x2014; term added to the denominator to improve numerical stability",name:"eps"},{anchor:"timm.optim.NAdamW.weight_decay",description:"<strong>weight_decay</strong> &#x2014; weight decay coefficient",name:"weight_decay"},{anchor:"timm.optim.NAdamW.caution",description:"<strong>caution</strong> &#x2014; enable caution",name:"caution"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nadamw.py#L17"}}),ft=new b({props:{name:"step",anchor:"timm.optim.NAdamW.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.NAdamW.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nadamw.py#L81"}}),ht=new b({props:{name:"class timm.optim.NvNovoGrad",anchor:"timm.optim.NvNovoGrad",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.95, 0.98)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"grad_averaging",val:" = False"},{name:"amsgrad",val:" = False"}],parametersDescription:[{anchor:"timm.optim.NvNovoGrad.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.NvNovoGrad.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.NvNovoGrad.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.95, 0.98))`,name:"betas"},{anchor:"timm.optim.NvNovoGrad.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.NvNovoGrad.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.NvNovoGrad.grad_averaging",description:"<strong>grad_averaging</strong> &#x2014; gradient averaging",name:"grad_averaging"},{anchor:"timm.optim.NvNovoGrad.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nvnovograd.py#L13"}}),vt=new b({props:{name:"step",anchor:"timm.optim.NvNovoGrad.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.NvNovoGrad.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model",name:"closure"},{anchor:"timm.optim.NvNovoGrad.step.and",description:"<strong>and</strong> returns the loss. &#x2014;",name:"and"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nvnovograd.py#L66"}}),bt=new b({props:{name:"class timm.optim.RMSpropTF",anchor:"timm.optim.RMSpropTF",parameters:[{name:"params",val:": typing.Union[typing.Iterable[torch.Tensor], typing.Iterable[typing.Dict[str, typing.Any]]]"},{name:"lr",val:": float = 0.01"},{name:"alpha",val:": float = 0.9"},{name:"eps",val:": float = 1e-10"},{name:"weight_decay",val:": float = 0"},{name:"momentum",val:": float = 0.0"},{name:"centered",val:": bool = False"},{name:"decoupled_decay",val:": bool = False"},{name:"lr_in_momentum",val:": bool = True"},{name:"caution",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.RMSpropTF.params",description:"<strong>params</strong> &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.RMSpropTF.lr",description:"<strong>lr</strong> &#x2014; learning rate",name:"lr"},{anchor:"timm.optim.RMSpropTF.momentum",description:"<strong>momentum</strong> &#x2014; momentum factor",name:"momentum"},{anchor:"timm.optim.RMSpropTF.alpha",description:"<strong>alpha</strong> &#x2014; smoothing (decay) constant",name:"alpha"},{anchor:"timm.optim.RMSpropTF.eps",description:"<strong>eps</strong> &#x2014; term added to the denominator to improve numerical stability",name:"eps"},{anchor:"timm.optim.RMSpropTF.centered",description:"<strong>centered</strong> &#x2014; if <code>True</code>, compute the centered RMSProp, the gradient is normalized by an estimation of its variance",name:"centered"},{anchor:"timm.optim.RMSpropTF.weight_decay",description:"<strong>weight_decay</strong> &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.RMSpropTF.decoupled_decay",description:'<strong>decoupled_decay</strong> &#x2014; decoupled weight decay as per <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a>',name:"decoupled_decay"},{anchor:"timm.optim.RMSpropTF.lr_in_momentum",description:"<strong>lr_in_momentum</strong> &#x2014; learning rate scaling is included in the momentum buffer update as per defaults in Tensorflow",name:"lr_in_momentum"},{anchor:"timm.optim.RMSpropTF.caution",description:"<strong>caution</strong> &#x2014; apply caution",name:"caution"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/rmsprop_tf.py#L16"}}),yt=new b({props:{name:"step",anchor:"timm.optim.RMSpropTF.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.RMSpropTF.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/rmsprop_tf.py#L90"}}),xt=new b({props:{name:"class timm.optim.SGDP",anchor:"timm.optim.SGDP",parameters:[{name:"params",val:""},{name:"lr",val:" = <required parameter>"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"eps",val:" = 1e-08"},{name:"delta",val:" = 0.1"},{name:"wd_ratio",val:" = 0.1"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/sgdp.py#L19"}}),$t=new b({props:{name:"class timm.optim.SGDW",anchor:"timm.optim.SGDW",parameters:[{name:"params",val:": typing.Union[typing.Iterable[torch.Tensor], typing.Iterable[typing.Dict[str, typing.Any]]]"},{name:"lr",val:": float = 0.001"},{name:"momentum",val:": float = 0.0"},{name:"dampening",val:": float = 0.0"},{name:"weight_decay",val:": float = 0.0"},{name:"nesterov",val:": bool = False"},{name:"caution",val:": bool = False"},{name:"maximize",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = None"},{name:"differentiable",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/sgdw.py#L17"}}),wt=new b({props:{name:"step",anchor:"timm.optim.SGDW.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.SGDW.step.closure",description:`<strong>closure</strong> (Callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/sgdw.py#L83"}}),Ct=new ps({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/reference/optimizers.mdx"}}),{c(){Q=a("meta"),hn=o(),tn=a("p"),vn=o(),d(be.$$.fragment),bn=o(),ye=a("p"),ye.innerHTML=hi,yn=o(),d(_e.$$.fragment),_n=o(),d(xe.$$.fragment),xn=o(),y=a("div"),d($e.$$.fragment),yo=o(),Lt=a("p"),Lt.textContent=vi,_o=o(),At=a("p"),At.textContent=bi,xo=o(),Tt=a("p"),Tt.textContent=yi,$o=o(),an=a("blockquote"),nn=a("blockquote"),we=a("blockquote"),d(Ce.$$.fragment),wo=o(),zt=a("p"),zt.textContent=_i,Co=o(),on=a("blockquote"),rn=a("blockquote"),Le=a("blockquote"),d(Ae.$$.fragment),Lo=o(),Dt=a("p"),Dt.textContent=xi,Ao=o(),ln=a("blockquote"),sn=a("blockquote"),Te=a("blockquote"),d(ze.$$.fragment),To=o(),Pt=a("p"),Pt.textContent=$i,zo=o(),mn=a("blockquote"),pn=a("blockquote"),De=a("blockquote"),d(Pe.$$.fragment),Do=o(),Mt=a("p"),Mt.textContent=wi,Po=o(),kt=a("p"),kt.textContent=Ci,Mo=o(),It=a("ol"),It.innerHTML=Li,$n=o(),_=a("div"),d(Me.$$.fragment),ko=o(),qt=a("p"),qt.textContent=Ai,Io=o(),Et=a("p"),Et.textContent=Ti,qo=o(),Ot=a("p"),Ot.textContent=zi,Eo=o(),Nt=a("blockquote"),Nt.innerHTML=Di,Oo=o(),Ft=a("blockquote"),Ft.innerHTML=Pi,No=o(),Ht=a("blockquote"),Ht.innerHTML=Mi,Fo=o(),Bt=a("blockquote"),Bt.innerHTML=ki,wn=o(),L=a("div"),d(ke.$$.fragment),Ho=o(),Gt=a("p"),Gt.textContent=Ii,Bo=o(),St=a("p"),St.textContent=qi,Go=o(),Rt=a("p"),Rt.textContent=Ei,So=o(),dn=a("blockquote"),cn=a("blockquote"),Ie=a("blockquote"),d(qe.$$.fragment),Ro=o(),Vt=a("p"),Vt.textContent=Oi,Vo=o(),gn=a("blockquote"),un=a("blockquote"),Ee=a("blockquote"),d(Oe.$$.fragment),Uo=o(),Ut=a("p"),Ut.textContent=Ni,Cn=o(),d(Ne.$$.fragment),Ln=o(),A=a("div"),d(Fe.$$.fragment),Wo=o(),Wt=a("p"),Wt.textContent=Fi,jo=o(),jt=a("p"),jt.textContent=Hi,Qo=o(),Qt=a("p"),Qt.innerHTML=Bi,Ko=o(),Kt=a("ul"),Kt.innerHTML=Gi,Zo=o(),Z=a("div"),d(He.$$.fragment),Xo=o(),Zt=a("p"),Zt.textContent=Si,An=o(),w=a("div"),d(Be.$$.fragment),Jo=o(),Xt=a("p"),Xt.textContent=Ri,Yo=o(),Jt=a("p"),Jt.innerHTML=Vi,er=o(),Yt=a("p"),Yt.innerHTML=Ui,tr=o(),ea=a("p"),ea.innerHTML=Wi,ar=o(),ta=a("p"),ta.textContent=ji,nr=o(),X=a("div"),d(Ge.$$.fragment),or=o(),aa=a("p"),aa.textContent=Qi,Tn=o(),S=a("div"),d(Se.$$.fragment),rr=o(),na=a("p"),na.textContent=Ki,ir=o(),oa=a("p"),oa.innerHTML=Zi,zn=o(),T=a("div"),d(Re.$$.fragment),lr=o(),ra=a("p"),ra.textContent=Xi,sr=o(),J=a("div"),d(Ve.$$.fragment),mr=o(),ia=a("p"),ia.textContent=Ji,pr=o(),Y=a("div"),d(Ue.$$.fragment),dr=o(),la=a("p"),la.textContent=Yi,cr=o(),ee=a("div"),d(We.$$.fragment),gr=o(),sa=a("p"),sa.textContent=el,ur=o(),te=a("div"),d(je.$$.fragment),fr=o(),ma=a("p"),ma.textContent=tl,Dn=o(),Qe=a("div"),d(Ke.$$.fragment),Pn=o(),q=a("div"),d(Ze.$$.fragment),hr=o(),pa=a("p"),pa.textContent=al,vr=o(),da=a("p"),da.innerHTML=nl,br=o(),ae=a("div"),d(Xe.$$.fragment),yr=o(),ca=a("p"),ca.textContent=ol,Mn=o(),R=a("div"),d(Je.$$.fragment),_r=o(),ga=a("p"),ga.innerHTML=rl,xr=o(),ne=a("div"),d(Ye.$$.fragment),$r=o(),ua=a("p"),ua.textContent=il,kn=o(),M=a("div"),d(et.$$.fragment),wr=o(),fa=a("p"),fa.innerHTML=ll,Cr=o(),ha=a("p"),ha.textContent=sl,Lr=o(),va=a("ul"),va.innerHTML=ml,Ar=o(),oe=a("div"),d(tt.$$.fragment),Tr=o(),ba=a("p"),ba.textContent=pl,In=o(),E=a("div"),d(at.$$.fragment),zr=o(),ya=a("p"),ya.textContent=dl,Dr=o(),_a=a("p"),_a.innerHTML=cl,Pr=o(),re=a("div"),d(nt.$$.fragment),Mr=o(),xa=a("p"),xa.textContent=gl,qn=o(),O=a("div"),d(ot.$$.fragment),kr=o(),$a=a("p"),$a.textContent=ul,Ir=o(),wa=a("p"),wa.innerHTML=fl,qr=o(),ie=a("div"),d(rt.$$.fragment),Er=o(),Ca=a("p"),Ca.textContent=hl,En=o(),V=a("div"),d(it.$$.fragment),Or=o(),La=a("p"),La.textContent=vl,Nr=o(),le=a("div"),d(lt.$$.fragment),Fr=o(),Aa=a("p"),Aa.textContent=bl,On=o(),st=a("div"),d(mt.$$.fragment),Nn=o(),C=a("div"),d(pt.$$.fragment),Hr=o(),Ta=a("p"),Ta.textContent=yl,Br=o(),za=a("p"),za.innerHTML=_l,Gr=o(),Da=a("p"),Da.textContent=xl,Sr=o(),Pa=a("p"),Pa.textContent=$l,Rr=o(),Ma=a("p"),Ma.textContent=wl,Vr=o(),se=a("div"),d(dt.$$.fragment),Ur=o(),ka=a("p"),ka.textContent=Cl,Fn=o(),N=a("div"),d(ct.$$.fragment),Wr=o(),Ia=a("p"),Ia.textContent=Ll,jr=o(),qa=a("p"),qa.innerHTML=Al,Qr=o(),me=a("div"),d(gt.$$.fragment),Kr=o(),Ea=a("p"),Ea.textContent=Tl,Hn=o(),z=a("div"),d(ut.$$.fragment),Zr=o(),Oa=a("p"),Oa.textContent=zl,Xr=o(),Na=a("p"),Na.innerHTML=Dl,Jr=o(),Fa=a("p"),Fa.textContent=Pl,Yr=o(),Ha=a("ul"),Ha.innerHTML=Ml,ei=o(),pe=a("div"),d(ft.$$.fragment),ti=o(),Ba=a("p"),Ba.textContent=kl,Bn=o(),U=a("div"),d(ht.$$.fragment),ai=o(),Ga=a("p"),Ga.textContent=Il,ni=o(),de=a("div"),d(vt.$$.fragment),oi=o(),Sa=a("p"),Sa.textContent=ql,Gn=o(),x=a("div"),d(bt.$$.fragment),ri=o(),Ra=a("p"),Ra.textContent=El,ii=o(),Va=a("p"),Va.textContent=Ol,li=o(),Ua=a("p"),Ua.textContent=Nl,si=o(),Wa=a("ol"),Wa.innerHTML=Fl,mi=o(),ja=a("p"),ja.innerHTML=Hl,pi=o(),Qa=a("p"),Qa.innerHTML=Bl,di=o(),ce=a("div"),d(yt.$$.fragment),ci=o(),Ka=a("p"),Ka.textContent=Gl,Sn=o(),_t=a("div"),d(xt.$$.fragment),Rn=o(),K=a("div"),d($t.$$.fragment),gi=o(),ge=a("div"),d(wt.$$.fragment),ui=o(),Za=a("p"),Za.textContent=Sl,Vn=o(),d(Ct.$$.fragment),Un=o(),fn=a("p"),this.h()},l(e){const s=ms("svelte-u9bgzb",document.head);Q=n(s,"META",{name:!0,content:!0}),s.forEach(i),hn=r(e),tn=n(e,"P",{}),m(tn).forEach(i),vn=r(e),c(be.$$.fragment,e),bn=r(e),ye=n(e,"P",{"data-svelte-h":!0}),l(ye)!=="svelte-1c6qm22"&&(ye.innerHTML=hi),yn=r(e),c(_e.$$.fragment,e),_n=r(e),c(xe.$$.fragment,e),xn=r(e),y=n(e,"DIV",{class:!0});var $=m(y);c($e.$$.fragment,$),yo=r($),Lt=n($,"P",{"data-svelte-h":!0}),l(Lt)!=="svelte-1330e7"&&(Lt.textContent=vi),_o=r($),At=n($,"P",{"data-svelte-h":!0}),l(At)!=="svelte-9cjiwr"&&(At.textContent=bi),xo=r($),Tt=n($,"P",{"data-svelte-h":!0}),l(Tt)!=="svelte-kvfsh7"&&(Tt.textContent=yi),$o=r($),an=n($,"BLOCKQUOTE",{});var Rl=m(an);nn=n(Rl,"BLOCKQUOTE",{});var Vl=m(nn);we=n(Vl,"BLOCKQUOTE",{});var jn=m(we);c(Ce.$$.fragment,jn),wo=r(jn),zt=n(jn,"P",{"data-svelte-h":!0}),l(zt)!=="svelte-180ncmf"&&(zt.textContent=_i),jn.forEach(i),Vl.forEach(i),Rl.forEach(i),Co=r($),on=n($,"BLOCKQUOTE",{});var Ul=m(on);rn=n(Ul,"BLOCKQUOTE",{});var Wl=m(rn);Le=n(Wl,"BLOCKQUOTE",{});var Qn=m(Le);c(Ae.$$.fragment,Qn),Lo=r(Qn),Dt=n(Qn,"P",{"data-svelte-h":!0}),l(Dt)!=="svelte-6yrpk7"&&(Dt.textContent=xi),Qn.forEach(i),Wl.forEach(i),Ul.forEach(i),Ao=r($),ln=n($,"BLOCKQUOTE",{});var jl=m(ln);sn=n(jl,"BLOCKQUOTE",{});var Ql=m(sn);Te=n(Ql,"BLOCKQUOTE",{});var Kn=m(Te);c(ze.$$.fragment,Kn),To=r(Kn),Pt=n(Kn,"P",{"data-svelte-h":!0}),l(Pt)!=="svelte-1vmtu70"&&(Pt.textContent=$i),Kn.forEach(i),Ql.forEach(i),jl.forEach(i),zo=r($),mn=n($,"BLOCKQUOTE",{});var Kl=m(mn);pn=n(Kl,"BLOCKQUOTE",{});var Zl=m(pn);De=n(Zl,"BLOCKQUOTE",{});var Zn=m(De);c(Pe.$$.fragment,Zn),Do=r(Zn),Mt=n(Zn,"P",{"data-svelte-h":!0}),l(Mt)!=="svelte-15ovmpe"&&(Mt.textContent=wi),Zn.forEach(i),Zl.forEach(i),Kl.forEach(i),Po=r($),kt=n($,"P",{"data-svelte-h":!0}),l(kt)!=="svelte-sgpn75"&&(kt.textContent=Ci),Mo=r($),It=n($,"OL",{"data-svelte-h":!0}),l(It)!=="svelte-psaz57"&&(It.innerHTML=Li),$.forEach(i),$n=r(e),_=n(e,"DIV",{class:!0});var D=m(_);c(Me.$$.fragment,D),ko=r(D),qt=n(D,"P",{"data-svelte-h":!0}),l(qt)!=="svelte-1h2sspw"&&(qt.textContent=Ai),Io=r(D),Et=n(D,"P",{"data-svelte-h":!0}),l(Et)!=="svelte-1tapwxe"&&(Et.textContent=Ti),qo=r(D),Ot=n(D,"P",{"data-svelte-h":!0}),l(Ot)!=="svelte-kvfsh7"&&(Ot.textContent=zi),Eo=r(D),Nt=n(D,"BLOCKQUOTE",{"data-svelte-h":!0}),l(Nt)!=="svelte-m875zf"&&(Nt.innerHTML=Di),Oo=r(D),Ft=n(D,"BLOCKQUOTE",{"data-svelte-h":!0}),l(Ft)!=="svelte-1mioyvo"&&(Ft.innerHTML=Pi),No=r(D),Ht=n(D,"BLOCKQUOTE",{"data-svelte-h":!0}),l(Ht)!=="svelte-ji9gfr"&&(Ht.innerHTML=Mi),Fo=r(D),Bt=n(D,"BLOCKQUOTE",{"data-svelte-h":!0}),l(Bt)!=="svelte-tvmm3x"&&(Bt.innerHTML=ki),D.forEach(i),wn=r(e),L=n(e,"DIV",{class:!0});var F=m(L);c(ke.$$.fragment,F),Ho=r(F),Gt=n(F,"P",{"data-svelte-h":!0}),l(Gt)!=="svelte-1rcjgrx"&&(Gt.textContent=Ii),Bo=r(F),St=n(F,"P",{"data-svelte-h":!0}),l(St)!=="svelte-13jhmtj"&&(St.textContent=qi),Go=r(F),Rt=n(F,"P",{"data-svelte-h":!0}),l(Rt)!=="svelte-kvfsh7"&&(Rt.textContent=Ei),So=r(F),dn=n(F,"BLOCKQUOTE",{});var Xl=m(dn);cn=n(Xl,"BLOCKQUOTE",{});var Jl=m(cn);Ie=n(Jl,"BLOCKQUOTE",{});var Xn=m(Ie);c(qe.$$.fragment,Xn),Ro=r(Xn),Vt=n(Xn,"P",{"data-svelte-h":!0}),l(Vt)!=="svelte-1en25gb"&&(Vt.textContent=Oi),Xn.forEach(i),Jl.forEach(i),Xl.forEach(i),Vo=r(F),gn=n(F,"BLOCKQUOTE",{});var Yl=m(gn);un=n(Yl,"BLOCKQUOTE",{});var es=m(un);Ee=n(es,"BLOCKQUOTE",{});var Jn=m(Ee);c(Oe.$$.fragment,Jn),Uo=r(Jn),Ut=n(Jn,"P",{"data-svelte-h":!0}),l(Ut)!=="svelte-gfx8y2"&&(Ut.textContent=Ni),Jn.forEach(i),es.forEach(i),Yl.forEach(i),F.forEach(i),Cn=r(e),c(Ne.$$.fragment,e),Ln=r(e),A=n(e,"DIV",{class:!0});var H=m(A);c(Fe.$$.fragment,H),Wo=r(H),Wt=n(H,"P",{"data-svelte-h":!0}),l(Wt)!=="svelte-1hnunr4"&&(Wt.textContent=Fi),jo=r(H),jt=n(H,"P",{"data-svelte-h":!0}),l(jt)!=="svelte-1cjb7xo"&&(jt.textContent=Hi),Qo=r(H),Qt=n(H,"P",{"data-svelte-h":!0}),l(Qt)!=="svelte-1347q2l"&&(Qt.innerHTML=Bi),Ko=r(H),Kt=n(H,"UL",{"data-svelte-h":!0}),l(Kt)!=="svelte-12x3l9q"&&(Kt.innerHTML=Gi),Zo=r(H),Z=n(H,"DIV",{class:!0});var Yn=m(Z);c(He.$$.fragment,Yn),Xo=r(Yn),Zt=n(Yn,"P",{"data-svelte-h":!0}),l(Zt)!=="svelte-1gr03w4"&&(Zt.textContent=Si),Yn.forEach(i),H.forEach(i),An=r(e),w=n(e,"DIV",{class:!0});var k=m(w);c(Be.$$.fragment,k),Jo=r(k),Xt=n(k,"P",{"data-svelte-h":!0}),l(Xt)!=="svelte-1j9mkxe"&&(Xt.textContent=Ri),Yo=r(k),Jt=n(k,"P",{"data-svelte-h":!0}),l(Jt)!=="svelte-1xvyiun"&&(Jt.innerHTML=Vi),er=r(k),Yt=n(k,"P",{"data-svelte-h":!0}),l(Yt)!=="svelte-1i7ubkr"&&(Yt.innerHTML=Ui),tr=r(k),ea=n(k,"P",{"data-svelte-h":!0}),l(ea)!=="svelte-96f97i"&&(ea.innerHTML=Wi),ar=r(k),ta=n(k,"P",{"data-svelte-h":!0}),l(ta)!=="svelte-1q67fqp"&&(ta.textContent=ji),nr=r(k),X=n(k,"DIV",{class:!0});var eo=m(X);c(Ge.$$.fragment,eo),or=r(eo),aa=n(eo,"P",{"data-svelte-h":!0}),l(aa)!=="svelte-1gr03w4"&&(aa.textContent=Qi),eo.forEach(i),k.forEach(i),Tn=r(e),S=n(e,"DIV",{class:!0});var Xa=m(S);c(Se.$$.fragment,Xa),rr=r(Xa),na=n(Xa,"P",{"data-svelte-h":!0}),l(na)!=="svelte-19t8yzj"&&(na.textContent=Ki),ir=r(Xa),oa=n(Xa,"P",{"data-svelte-h":!0}),l(oa)!=="svelte-aajaln"&&(oa.innerHTML=Zi),Xa.forEach(i),zn=r(e),T=n(e,"DIV",{class:!0});var B=m(T);c(Re.$$.fragment,B),lr=r(B),ra=n(B,"P",{"data-svelte-h":!0}),l(ra)!=="svelte-1cuo0rh"&&(ra.textContent=Xi),sr=r(B),J=n(B,"DIV",{class:!0});var to=m(J);c(Ve.$$.fragment,to),mr=r(to),ia=n(to,"P",{"data-svelte-h":!0}),l(ia)!=="svelte-1jz1hl7"&&(ia.textContent=Ji),to.forEach(i),pr=r(B),Y=n(B,"DIV",{class:!0});var ao=m(Y);c(Ue.$$.fragment,ao),dr=r(ao),la=n(ao,"P",{"data-svelte-h":!0}),l(la)!=="svelte-1y1oyzd"&&(la.textContent=Yi),ao.forEach(i),cr=r(B),ee=n(B,"DIV",{class:!0});var no=m(ee);c(We.$$.fragment,no),gr=r(no),sa=n(no,"P",{"data-svelte-h":!0}),l(sa)!=="svelte-1gr03w4"&&(sa.textContent=el),no.forEach(i),ur=r(B),te=n(B,"DIV",{class:!0});var oo=m(te);c(je.$$.fragment,oo),fr=r(oo),ma=n(oo,"P",{"data-svelte-h":!0}),l(ma)!=="svelte-4lvf5h"&&(ma.textContent=tl),oo.forEach(i),B.forEach(i),Dn=r(e),Qe=n(e,"DIV",{class:!0});var ts=m(Qe);c(Ke.$$.fragment,ts),ts.forEach(i),Pn=r(e),q=n(e,"DIV",{class:!0});var ue=m(q);c(Ze.$$.fragment,ue),hr=r(ue),pa=n(ue,"P",{"data-svelte-h":!0}),l(pa)!=="svelte-1vdc41k"&&(pa.textContent=al),vr=r(ue),da=n(ue,"P",{"data-svelte-h":!0}),l(da)!=="svelte-1vkysjq"&&(da.innerHTML=nl),br=r(ue),ae=n(ue,"DIV",{class:!0});var ro=m(ae);c(Xe.$$.fragment,ro),yr=r(ro),ca=n(ro,"P",{"data-svelte-h":!0}),l(ca)!=="svelte-1gr03w4"&&(ca.textContent=ol),ro.forEach(i),ue.forEach(i),Mn=r(e),R=n(e,"DIV",{class:!0});var Ja=m(R);c(Je.$$.fragment,Ja),_r=r(Ja),ga=n(Ja,"P",{"data-svelte-h":!0}),l(ga)!=="svelte-bxurot"&&(ga.innerHTML=rl),xr=r(Ja),ne=n(Ja,"DIV",{class:!0});var io=m(ne);c(Ye.$$.fragment,io),$r=r(io),ua=n(io,"P",{"data-svelte-h":!0}),l(ua)!=="svelte-1siu6mf"&&(ua.textContent=il),io.forEach(i),Ja.forEach(i),kn=r(e),M=n(e,"DIV",{class:!0});var W=m(M);c(et.$$.fragment,W),wr=r(W),fa=n(W,"P",{"data-svelte-h":!0}),l(fa)!=="svelte-d5zqgn"&&(fa.innerHTML=ll),Cr=r(W),ha=n(W,"P",{"data-svelte-h":!0}),l(ha)!=="svelte-9itjiu"&&(ha.textContent=sl),Lr=r(W),va=n(W,"UL",{"data-svelte-h":!0}),l(va)!=="svelte-ylo4gl"&&(va.innerHTML=ml),Ar=r(W),oe=n(W,"DIV",{class:!0});var lo=m(oe);c(tt.$$.fragment,lo),Tr=r(lo),ba=n(lo,"P",{"data-svelte-h":!0}),l(ba)!=="svelte-1gr03w4"&&(ba.textContent=pl),lo.forEach(i),W.forEach(i),In=r(e),E=n(e,"DIV",{class:!0});var fe=m(E);c(at.$$.fragment,fe),zr=r(fe),ya=n(fe,"P",{"data-svelte-h":!0}),l(ya)!=="svelte-1ky75u7"&&(ya.textContent=dl),Dr=r(fe),_a=n(fe,"P",{"data-svelte-h":!0}),l(_a)!=="svelte-ee3cwp"&&(_a.innerHTML=cl),Pr=r(fe),re=n(fe,"DIV",{class:!0});var so=m(re);c(nt.$$.fragment,so),Mr=r(so),xa=n(so,"P",{"data-svelte-h":!0}),l(xa)!=="svelte-1gr03w4"&&(xa.textContent=gl),so.forEach(i),fe.forEach(i),qn=r(e),O=n(e,"DIV",{class:!0});var he=m(O);c(ot.$$.fragment,he),kr=r(he),$a=n(he,"P",{"data-svelte-h":!0}),l($a)!=="svelte-vzcsb8"&&($a.textContent=ul),Ir=r(he),wa=n(he,"P",{"data-svelte-h":!0}),l(wa)!=="svelte-euart9"&&(wa.innerHTML=fl),qr=r(he),ie=n(he,"DIV",{class:!0});var mo=m(ie);c(rt.$$.fragment,mo),Er=r(mo),Ca=n(mo,"P",{"data-svelte-h":!0}),l(Ca)!=="svelte-1gr03w4"&&(Ca.textContent=hl),mo.forEach(i),he.forEach(i),En=r(e),V=n(e,"DIV",{class:!0});var Ya=m(V);c(it.$$.fragment,Ya),Or=r(Ya),La=n(Ya,"P",{"data-svelte-h":!0}),l(La)!=="svelte-pwyp7b"&&(La.textContent=vl),Nr=r(Ya),le=n(Ya,"DIV",{class:!0});var po=m(le);c(lt.$$.fragment,po),Fr=r(po),Aa=n(po,"P",{"data-svelte-h":!0}),l(Aa)!=="svelte-1gr03w4"&&(Aa.textContent=bl),po.forEach(i),Ya.forEach(i),On=r(e),st=n(e,"DIV",{class:!0});var as=m(st);c(mt.$$.fragment,as),as.forEach(i),Nn=r(e),C=n(e,"DIV",{class:!0});var I=m(C);c(pt.$$.fragment,I),Hr=r(I),Ta=n(I,"P",{"data-svelte-h":!0}),l(Ta)!=="svelte-wmmdpx"&&(Ta.textContent=yl),Br=r(I),za=n(I,"P",{"data-svelte-h":!0}),l(za)!=="svelte-12dyngi"&&(za.innerHTML=_l),Gr=r(I),Da=n(I,"P",{"data-svelte-h":!0}),l(Da)!=="svelte-qjjdis"&&(Da.textContent=xl),Sr=r(I),Pa=n(I,"P",{"data-svelte-h":!0}),l(Pa)!=="svelte-rosfou"&&(Pa.textContent=$l),Rr=r(I),Ma=n(I,"P",{"data-svelte-h":!0}),l(Ma)!=="svelte-hlwvkn"&&(Ma.textContent=wl),Vr=r(I),se=n(I,"DIV",{class:!0});var co=m(se);c(dt.$$.fragment,co),Ur=r(co),ka=n(co,"P",{"data-svelte-h":!0}),l(ka)!=="svelte-1gr03w4"&&(ka.textContent=Cl),co.forEach(i),I.forEach(i),Fn=r(e),N=n(e,"DIV",{class:!0});var ve=m(N);c(ct.$$.fragment,ve),Wr=r(ve),Ia=n(ve,"P",{"data-svelte-h":!0}),l(Ia)!=="svelte-yn9hq2"&&(Ia.textContent=Ll),jr=r(ve),qa=n(ve,"P",{"data-svelte-h":!0}),l(qa)!=="svelte-1l0d0b"&&(qa.innerHTML=Al),Qr=r(ve),me=n(ve,"DIV",{class:!0});var go=m(me);c(gt.$$.fragment,go),Kr=r(go),Ea=n(go,"P",{"data-svelte-h":!0}),l(Ea)!=="svelte-1gr03w4"&&(Ea.textContent=Tl),go.forEach(i),ve.forEach(i),Hn=r(e),z=n(e,"DIV",{class:!0});var G=m(z);c(ut.$$.fragment,G),Zr=r(G),Oa=n(G,"P",{"data-svelte-h":!0}),l(Oa)!=="svelte-3mtxcr"&&(Oa.textContent=zl),Xr=r(G),Na=n(G,"P",{"data-svelte-h":!0}),l(Na)!=="svelte-1kok3gr"&&(Na.innerHTML=Dl),Jr=r(G),Fa=n(G,"P",{"data-svelte-h":!0}),l(Fa)!=="svelte-1usqxsj"&&(Fa.textContent=Pl),Yr=r(G),Ha=n(G,"UL",{"data-svelte-h":!0}),l(Ha)!=="svelte-xfb8g2"&&(Ha.innerHTML=Ml),ei=r(G),pe=n(G,"DIV",{class:!0});var uo=m(pe);c(ft.$$.fragment,uo),ti=r(uo),Ba=n(uo,"P",{"data-svelte-h":!0}),l(Ba)!=="svelte-1gr03w4"&&(Ba.textContent=kl),uo.forEach(i),G.forEach(i),Bn=r(e),U=n(e,"DIV",{class:!0});var en=m(U);c(ht.$$.fragment,en),ai=r(en),Ga=n(en,"P",{"data-svelte-h":!0}),l(Ga)!=="svelte-5vv99d"&&(Ga.textContent=Il),ni=r(en),de=n(en,"DIV",{class:!0});var fo=m(de);c(vt.$$.fragment,fo),oi=r(fo),Sa=n(fo,"P",{"data-svelte-h":!0}),l(Sa)!=="svelte-1gr03w4"&&(Sa.textContent=ql),fo.forEach(i),en.forEach(i),Gn=r(e),x=n(e,"DIV",{class:!0});var P=m(x);c(bt.$$.fragment,P),ri=r(P),Ra=n(P,"P",{"data-svelte-h":!0}),l(Ra)!=="svelte-1tqv0s5"&&(Ra.textContent=El),ii=r(P),Va=n(P,"P",{"data-svelte-h":!0}),l(Va)!=="svelte-g10xv4"&&(Va.textContent=Ol),li=r(P),Ua=n(P,"P",{"data-svelte-h":!0}),l(Ua)!=="svelte-1acg3vg"&&(Ua.textContent=Nl),si=r(P),Wa=n(P,"OL",{"data-svelte-h":!0}),l(Wa)!=="svelte-15y6o6y"&&(Wa.innerHTML=Fl),mi=r(P),ja=n(P,"P",{"data-svelte-h":!0}),l(ja)!=="svelte-1yvkj2h"&&(ja.innerHTML=Hl),pi=r(P),Qa=n(P,"P",{"data-svelte-h":!0}),l(Qa)!=="svelte-53x1ow"&&(Qa.innerHTML=Bl),di=r(P),ce=n(P,"DIV",{class:!0});var ho=m(ce);c(yt.$$.fragment,ho),ci=r(ho),Ka=n(ho,"P",{"data-svelte-h":!0}),l(Ka)!=="svelte-1gr03w4"&&(Ka.textContent=Gl),ho.forEach(i),P.forEach(i),Sn=r(e),_t=n(e,"DIV",{class:!0});var ns=m(_t);c(xt.$$.fragment,ns),ns.forEach(i),Rn=r(e),K=n(e,"DIV",{class:!0});var vo=m(K);c($t.$$.fragment,vo),gi=r(vo),ge=n(vo,"DIV",{class:!0});var bo=m(ge);c(wt.$$.fragment,bo),ui=r(bo),Za=n(bo,"P",{"data-svelte-h":!0}),l(Za)!=="svelte-1gr03w4"&&(Za.textContent=Sl),bo.forEach(i),vo.forEach(i),Vn=r(e),c(Ct.$$.fragment,e),Un=r(e),fn=n(e,"P",{}),m(fn).forEach(i),this.h()},h(){v(Q,"name","hf:doc:metadata"),v(Q,"content",cs),v(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){t(document.head,Q),p(e,hn,s),p(e,tn,s),p(e,vn,s),g(be,e,s),p(e,bn,s),p(e,ye,s),p(e,yn,s),g(_e,e,s),p(e,_n,s),g(xe,e,s),p(e,xn,s),p(e,y,s),g($e,y,null),t(y,yo),t(y,Lt),t(y,_o),t(y,At),t(y,xo),t(y,Tt),t(y,$o),t(y,an),t(an,nn),t(nn,we),g(Ce,we,null),t(we,wo),t(we,zt),t(y,Co),t(y,on),t(on,rn),t(rn,Le),g(Ae,Le,null),t(Le,Lo),t(Le,Dt),t(y,Ao),t(y,ln),t(ln,sn),t(sn,Te),g(ze,Te,null),t(Te,To),t(Te,Pt),t(y,zo),t(y,mn),t(mn,pn),t(pn,De),g(Pe,De,null),t(De,Do),t(De,Mt),t(y,Po),t(y,kt),t(y,Mo),t(y,It),p(e,$n,s),p(e,_,s),g(Me,_,null),t(_,ko),t(_,qt),t(_,Io),t(_,Et),t(_,qo),t(_,Ot),t(_,Eo),t(_,Nt),t(_,Oo),t(_,Ft),t(_,No),t(_,Ht),t(_,Fo),t(_,Bt),p(e,wn,s),p(e,L,s),g(ke,L,null),t(L,Ho),t(L,Gt),t(L,Bo),t(L,St),t(L,Go),t(L,Rt),t(L,So),t(L,dn),t(dn,cn),t(cn,Ie),g(qe,Ie,null),t(Ie,Ro),t(Ie,Vt),t(L,Vo),t(L,gn),t(gn,un),t(un,Ee),g(Oe,Ee,null),t(Ee,Uo),t(Ee,Ut),p(e,Cn,s),g(Ne,e,s),p(e,Ln,s),p(e,A,s),g(Fe,A,null),t(A,Wo),t(A,Wt),t(A,jo),t(A,jt),t(A,Qo),t(A,Qt),t(A,Ko),t(A,Kt),t(A,Zo),t(A,Z),g(He,Z,null),t(Z,Xo),t(Z,Zt),p(e,An,s),p(e,w,s),g(Be,w,null),t(w,Jo),t(w,Xt),t(w,Yo),t(w,Jt),t(w,er),t(w,Yt),t(w,tr),t(w,ea),t(w,ar),t(w,ta),t(w,nr),t(w,X),g(Ge,X,null),t(X,or),t(X,aa),p(e,Tn,s),p(e,S,s),g(Se,S,null),t(S,rr),t(S,na),t(S,ir),t(S,oa),p(e,zn,s),p(e,T,s),g(Re,T,null),t(T,lr),t(T,ra),t(T,sr),t(T,J),g(Ve,J,null),t(J,mr),t(J,ia),t(T,pr),t(T,Y),g(Ue,Y,null),t(Y,dr),t(Y,la),t(T,cr),t(T,ee),g(We,ee,null),t(ee,gr),t(ee,sa),t(T,ur),t(T,te),g(je,te,null),t(te,fr),t(te,ma),p(e,Dn,s),p(e,Qe,s),g(Ke,Qe,null),p(e,Pn,s),p(e,q,s),g(Ze,q,null),t(q,hr),t(q,pa),t(q,vr),t(q,da),t(q,br),t(q,ae),g(Xe,ae,null),t(ae,yr),t(ae,ca),p(e,Mn,s),p(e,R,s),g(Je,R,null),t(R,_r),t(R,ga),t(R,xr),t(R,ne),g(Ye,ne,null),t(ne,$r),t(ne,ua),p(e,kn,s),p(e,M,s),g(et,M,null),t(M,wr),t(M,fa),t(M,Cr),t(M,ha),t(M,Lr),t(M,va),t(M,Ar),t(M,oe),g(tt,oe,null),t(oe,Tr),t(oe,ba),p(e,In,s),p(e,E,s),g(at,E,null),t(E,zr),t(E,ya),t(E,Dr),t(E,_a),t(E,Pr),t(E,re),g(nt,re,null),t(re,Mr),t(re,xa),p(e,qn,s),p(e,O,s),g(ot,O,null),t(O,kr),t(O,$a),t(O,Ir),t(O,wa),t(O,qr),t(O,ie),g(rt,ie,null),t(ie,Er),t(ie,Ca),p(e,En,s),p(e,V,s),g(it,V,null),t(V,Or),t(V,La),t(V,Nr),t(V,le),g(lt,le,null),t(le,Fr),t(le,Aa),p(e,On,s),p(e,st,s),g(mt,st,null),p(e,Nn,s),p(e,C,s),g(pt,C,null),t(C,Hr),t(C,Ta),t(C,Br),t(C,za),t(C,Gr),t(C,Da),t(C,Sr),t(C,Pa),t(C,Rr),t(C,Ma),t(C,Vr),t(C,se),g(dt,se,null),t(se,Ur),t(se,ka),p(e,Fn,s),p(e,N,s),g(ct,N,null),t(N,Wr),t(N,Ia),t(N,jr),t(N,qa),t(N,Qr),t(N,me),g(gt,me,null),t(me,Kr),t(me,Ea),p(e,Hn,s),p(e,z,s),g(ut,z,null),t(z,Zr),t(z,Oa),t(z,Xr),t(z,Na),t(z,Jr),t(z,Fa),t(z,Yr),t(z,Ha),t(z,ei),t(z,pe),g(ft,pe,null),t(pe,ti),t(pe,Ba),p(e,Bn,s),p(e,U,s),g(ht,U,null),t(U,ai),t(U,Ga),t(U,ni),t(U,de),g(vt,de,null),t(de,oi),t(de,Sa),p(e,Gn,s),p(e,x,s),g(bt,x,null),t(x,ri),t(x,Ra),t(x,ii),t(x,Va),t(x,li),t(x,Ua),t(x,si),t(x,Wa),t(x,mi),t(x,ja),t(x,pi),t(x,Qa),t(x,di),t(x,ce),g(yt,ce,null),t(ce,ci),t(ce,Ka),p(e,Sn,s),p(e,_t,s),g(xt,_t,null),p(e,Rn,s),p(e,K,s),g($t,K,null),t(K,gi),t(K,ge),g(wt,ge,null),t(ge,ui),t(ge,Za),p(e,Vn,s),g(Ct,e,s),p(e,Un,s),p(e,fn,s),Wn=!0},p:rs,i(e){Wn||(u(be.$$.fragment,e),u(_e.$$.fragment,e),u(xe.$$.fragment,e),u($e.$$.fragment,e),u(Ce.$$.fragment,e),u(Ae.$$.fragment,e),u(ze.$$.fragment,e),u(Pe.$$.fragment,e),u(Me.$$.fragment,e),u(ke.$$.fragment,e),u(qe.$$.fragment,e),u(Oe.$$.fragment,e),u(Ne.$$.fragment,e),u(Fe.$$.fragment,e),u(He.$$.fragment,e),u(Be.$$.fragment,e),u(Ge.$$.fragment,e),u(Se.$$.fragment,e),u(Re.$$.fragment,e),u(Ve.$$.fragment,e),u(Ue.$$.fragment,e),u(We.$$.fragment,e),u(je.$$.fragment,e),u(Ke.$$.fragment,e),u(Ze.$$.fragment,e),u(Xe.$$.fragment,e),u(Je.$$.fragment,e),u(Ye.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(at.$$.fragment,e),u(nt.$$.fragment,e),u(ot.$$.fragment,e),u(rt.$$.fragment,e),u(it.$$.fragment,e),u(lt.$$.fragment,e),u(mt.$$.fragment,e),u(pt.$$.fragment,e),u(dt.$$.fragment,e),u(ct.$$.fragment,e),u(gt.$$.fragment,e),u(ut.$$.fragment,e),u(ft.$$.fragment,e),u(ht.$$.fragment,e),u(vt.$$.fragment,e),u(bt.$$.fragment,e),u(yt.$$.fragment,e),u(xt.$$.fragment,e),u($t.$$.fragment,e),u(wt.$$.fragment,e),u(Ct.$$.fragment,e),Wn=!0)},o(e){f(be.$$.fragment,e),f(_e.$$.fragment,e),f(xe.$$.fragment,e),f($e.$$.fragment,e),f(Ce.$$.fragment,e),f(Ae.$$.fragment,e),f(ze.$$.fragment,e),f(Pe.$$.fragment,e),f(Me.$$.fragment,e),f(ke.$$.fragment,e),f(qe.$$.fragment,e),f(Oe.$$.fragment,e),f(Ne.$$.fragment,e),f(Fe.$$.fragment,e),f(He.$$.fragment,e),f(Be.$$.fragment,e),f(Ge.$$.fragment,e),f(Se.$$.fragment,e),f(Re.$$.fragment,e),f(Ve.$$.fragment,e),f(Ue.$$.fragment,e),f(We.$$.fragment,e),f(je.$$.fragment,e),f(Ke.$$.fragment,e),f(Ze.$$.fragment,e),f(Xe.$$.fragment,e),f(Je.$$.fragment,e),f(Ye.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(at.$$.fragment,e),f(nt.$$.fragment,e),f(ot.$$.fragment,e),f(rt.$$.fragment,e),f(it.$$.fragment,e),f(lt.$$.fragment,e),f(mt.$$.fragment,e),f(pt.$$.fragment,e),f(dt.$$.fragment,e),f(ct.$$.fragment,e),f(gt.$$.fragment,e),f(ut.$$.fragment,e),f(ft.$$.fragment,e),f(ht.$$.fragment,e),f(vt.$$.fragment,e),f(bt.$$.fragment,e),f(yt.$$.fragment,e),f(xt.$$.fragment,e),f($t.$$.fragment,e),f(wt.$$.fragment,e),f(Ct.$$.fragment,e),Wn=!1},d(e){e&&(i(hn),i(tn),i(vn),i(bn),i(ye),i(yn),i(_n),i(xn),i(y),i($n),i(_),i(wn),i(L),i(Cn),i(Ln),i(A),i(An),i(w),i(Tn),i(S),i(zn),i(T),i(Dn),i(Qe),i(Pn),i(q),i(Mn),i(R),i(kn),i(M),i(In),i(E),i(qn),i(O),i(En),i(V),i(On),i(st),i(Nn),i(C),i(Fn),i(N),i(Hn),i(z),i(Bn),i(U),i(Gn),i(x),i(Sn),i(_t),i(Rn),i(K),i(Vn),i(Un),i(fn)),i(Q),h(be,e),h(_e,e),h(xe,e),h($e),h(Ce),h(Ae),h(ze),h(Pe),h(Me),h(ke),h(qe),h(Oe),h(Ne,e),h(Fe),h(He),h(Be),h(Ge),h(Se),h(Re),h(Ve),h(Ue),h(We),h(je),h(Ke),h(Ze),h(Xe),h(Je),h(Ye),h(et),h(tt),h(at),h(nt),h(ot),h(rt),h(it),h(lt),h(mt),h(pt),h(dt),h(ct),h(gt),h(ut),h(ft),h(ht),h(vt),h(bt),h(yt),h(xt),h($t),h(wt),h(Ct,e)}}}const cs='{"title":"Optimization","local":"optimization","sections":[{"title":"Optimizers","local":"optimizers","sections":[{"title":"Factory functions","local":"timm.optim.create_optimizer_v2","sections":[],"depth":3}],"depth":2}],"depth":1}';function gs(fi){return is(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bs extends ls{constructor(Q){super(),ss(this,Q,gs,ds,os,{})}}export{bs as component};
