import{s as Lp,o as jp,n as Yl}from"../chunks/scheduler.9bc65507.js";import{S as Dp,i as Hp,g as a,s as n,r as c,A as Gp,h as o,f as l,c as i,j as $p,u as d,x as r,k as U,y as Jp,a as s,v,d as w,t as g,w as y}from"../chunks/index.707bf1b6.js";import{T as _a}from"../chunks/Tip.c2ecdbf4.js";import{C as x}from"../chunks/CodeBlock.54a9f38d.js";import{H as C}from"../chunks/Heading.342b1fa6.js";import{H as Ip,a as $a}from"../chunks/HfOption.6d864328.js";function kp(T){let p,M=`While the main concepts discussed in this guide are likely applicable across frameworks, here we focus on
PyTorch-based implementations.`;return{c(){p=a("p"),p.textContent=M},l(f){p=o(f,"P",{"data-svelte-h":!0}),r(p)!=="svelte-11nx342"&&(p.textContent=M)},m(f,u){s(f,p,u)},p:Yl,d(f){f&&l(p)}}}function Sp(T){let p,M=`This mechanism is similar to an efficient group backpacking strategy: person A carries the tent, person B carries the stove,
and person C carries the axe. Each night they all share what they have with others and get from others what they don’t have,
and in the morning they pack up their allocated type of gear and continue on their way. This is what ZeRO DP/Sharded DDP is.
Compare this strategy to the simple one where each person has to carry their own tent, stove and axe (similar to
DataParallel (DP and DDP) in PyTorch), which would be far more inefficient.`;return{c(){p=a("p"),p.textContent=M},l(f){p=o(f,"P",{"data-svelte-h":!0}),r(p)!=="svelte-15youi0"&&(p.textContent=M)},m(f,u){s(f,p,u)},p:Yl,d(f){f&&l(p)}}}function Ap(T){let p,M="Use the <code>--nproc_per_node</code> to select how many GPUs to use.",f,u,P;return u=new x({props:{code:"dG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTNEMiUyMCUyMHRyYWluZXItcHJvZ3JhbS5weSUyMC4uLg==",highlighted:"torchrun --nproc_per_node=2  trainer-program.py ...",wrap:!1}}),{c(){p=a("p"),p.innerHTML=M,f=n(),c(u.$$.fragment)},l(h){p=o(h,"P",{"data-svelte-h":!0}),r(p)!=="svelte-ghitll"&&(p.innerHTML=M),f=i(h),d(u.$$.fragment,h)},m(h,m){s(h,p,m),s(h,f,m),v(u,h,m),P=!0},p:Yl,i(h){P||(w(u.$$.fragment,h),P=!0)},o(h){g(u.$$.fragment,h),P=!1},d(h){h&&(l(p),l(f)),y(u,h)}}}function Vp(T){let p,M="Use <code>--num_processes</code> to select how many GPUs to use.",f,u,P;return u=new x({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbnVtX3Byb2Nlc3NlcyUyMDIlMjB0cmFpbmVyLXByb2dyYW0ucHklMjAuLi4=",highlighted:"accelerate launch --num_processes 2 trainer-program.py ...",wrap:!1}}),{c(){p=a("p"),p.innerHTML=M,f=n(),c(u.$$.fragment)},l(h){p=o(h,"P",{"data-svelte-h":!0}),r(p)!=="svelte-15fv5d7"&&(p.innerHTML=M),f=i(h),d(u.$$.fragment,h)},m(h,m){s(h,p,m),s(h,f,m),v(u,h,m),P=!0},p:Yl,i(h){P||(w(u.$$.fragment,h),P=!0)},o(h){g(u.$$.fragment,h),P=!1},d(h){h&&(l(p),l(f)),y(u,h)}}}function Ep(T){let p,M="Use <code>--num_gpus</code> to select how many GPUs to use.",f,u,P;return u=new x({props:{code:"ZGVlcHNwZWVkJTIwLS1udW1fZ3B1cyUyMDIlMjB0cmFpbmVyLXByb2dyYW0ucHklMjAuLi4=",highlighted:"deepspeed --num_gpus 2 trainer-program.py ...",wrap:!1}}),{c(){p=a("p"),p.innerHTML=M,f=n(),c(u.$$.fragment)},l(h){p=o(h,"P",{"data-svelte-h":!0}),r(p)!=="svelte-14evfjd"&&(p.innerHTML=M),f=i(h),d(u.$$.fragment,h)},m(h,m){s(h,p,m),s(h,f,m),v(u,h,m),P=!0},p:Yl,i(h){P||(w(u.$$.fragment,h),P=!0)},o(h){g(u.$$.fragment,h),P=!1},d(h){h&&(l(p),l(f)),y(u,h)}}}function Np(T){let p,M,f,u,P,h;return p=new $a({props:{id:"select-gpu",option:"torchrun",$$slots:{default:[Ap]},$$scope:{ctx:T}}}),f=new $a({props:{id:"select-gpu",option:"Accelerate",$$slots:{default:[Vp]},$$scope:{ctx:T}}}),P=new $a({props:{id:"select-gpu",option:"DeepSpeed",$$slots:{default:[Ep]},$$scope:{ctx:T}}}),{c(){c(p.$$.fragment),M=n(),c(f.$$.fragment),u=n(),c(P.$$.fragment)},l(m){d(p.$$.fragment,m),M=i(m),d(f.$$.fragment,m),u=i(m),d(P.$$.fragment,m)},m(m,b){v(p,m,b),s(m,M,b),v(f,m,b),s(m,u,b),v(P,m,b),h=!0},p(m,b){const z={};b&2&&(z.$$scope={dirty:b,ctx:m}),p.$set(z);const _={};b&2&&(_.$$scope={dirty:b,ctx:m}),f.$set(_);const Kl={};b&2&&(Kl.$$scope={dirty:b,ctx:m}),P.$set(Kl)},i(m){h||(w(p.$$.fragment,m),w(f.$$.fragment,m),w(P.$$.fragment,m),h=!0)},o(m){g(p.$$.fragment,m),g(f.$$.fragment,m),g(P.$$.fragment,m),h=!1},d(m){m&&(l(M),l(u)),y(p,m),y(f,m),y(P,m)}}}function Rp(T){let p,M="As with any environment variable, they can be exported instead of being added to the command line. However, this is not recommended because it can be confusing if you forget how the environment variable was setup and you end up using the wrong GPUs. Instead, it is common practice to set the environment variable for a specific training run on the same command line.";return{c(){p=a("p"),p.textContent=M},l(f){p=o(f,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1ky103q"&&(p.textContent=M)},m(f,u){s(f,p,u)},p:Yl,d(f){f&&l(p)}}}function zp(T){let p,M,f,u,P,h,m,b=`If training a model on a single GPU is too slow or if the model’s weights do not fit in a single GPU’s memory, transitioning
to a multi-GPU setup may be a viable option. Prior to making this transition, thoroughly explore all the strategies covered
in the <a href="perf_train_gpu_one">Methods and tools for efficient training on a single GPU</a> as they are universally applicable
to model training on any number of GPUs. Once you have employed those strategies and found them insufficient for your
case on a single GPU, consider moving to multiple GPUs.`,z,_,Kl=`Transitioning from a single GPU to multiple GPUs requires the introduction of some form of parallelism, as the workload
must be distributed across the resources. Multiple techniques can be employed to achieve parallelism, such as data
parallelism, tensor parallelism, and pipeline parallelism. It’s important to note that there isn’t a one-size-fits-all
solution, and the optimal settings depend on the specific hardware configuration you are using.`,ts,B,La=`This guide offers an in-depth overview of individual types of parallelism, as well as guidance on ways to combine<br/>
techniques and choosing an appropriate approach. For step-by-step tutorials on distributed training, please refer to
the <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">🤗 Accelerate documentation</a>.`,ls,$,ss,Q,ja=`Before diving deeper into the specifics of each technique, let’s go over the rough decision process when training
large models on a large infrastructure.`,ns,F,is,W,Da=`Begin by estimating how much vRAM is required to train your model. For models hosted on the 🤗 Hub, use our
<a href="https://huggingface.co/spaces/hf-accelerate/model-memory-usage" rel="nofollow">Model Memory Calculator</a>, which gives you
accurate calculations within a few percent margin.`,as,Z,Ha="<strong>Parallelization strategy for a single Node / multi-GPU setup</strong>",os,X,Ga=`When training a model on a single node with multiple GPUs, your choice of parallelization strategy can significantly
impact performance. Here’s a breakdown of your options:`,rs,O,Ja="<strong>Case 1: Your model fits onto a single GPU</strong>",ps,q,Ia="If your model can comfortably fit onto a single GPU, you have two primary options:",hs,Y,ka="<li>DDP - Distributed DataParallel</li> <li>ZeRO - depending on the situation and configuration used, this method may or may not be faster, however, it’s worth experimenting with it.</li>",ms,K,Sa="<strong>Case 2: Your model doesn’t fit onto a single GPU:</strong>",fs,ee,Aa="If your model is too large for a single GPU, you have several alternatives to consider:",us,te,Va="<li>PipelineParallel (PP)</li> <li>ZeRO</li> <li>TensorParallel (TP)</li>",cs,le,Ea=`With very fast inter-node connectivity (e.g., NVLINK or NVSwitch) all three strategies (PP, ZeRO, TP) should result in
similar performance. However, without these, PP will be faster than TP or ZeRO. The degree of TP may also
make a difference. It’s best to experiment with your specific setup to determine the most suitable strategy.`,ds,se,Na="TP is almost always used within a single node. That is TP size <= GPUs per node.",vs,ne,Ra="<strong>Case 3: Largest layer of your model does not fit onto a single GPU</strong>",ws,ie,za='<li>If you are not using ZeRO, you have to use TensorParallel (TP), because PipelineParallel (PP) alone won’t be sufficient to accommodate the large layer.</li> <li>If you are using ZeRO, additionally adopt techniques from the <a href="perf_train_gpu_one">Methods and tools for efficient training on a single GPU</a>.</li>',gs,ae,Ba="<strong>Parallelization strategy for a multi-Node / multi-GPU setup</strong>",ys,oe,Qa="<li><p>When you have fast inter-node connectivity (e.g., NVLINK or NVSwitch) consider using one of these options:</p> <ol><li>ZeRO - as it requires close to no modifications to the model</li> <li>A combination of PipelineParallel(PP) with TensorParallel(TP) and DataParallel(DP) - this approach will result in fewer communications, but requires significant changes to the model</li></ol></li> <li><p>When you have slow inter-node connectivity and still low on GPU memory:</p> <ol><li>Employ a combination of DataParallel(DP) with PipelineParallel(PP), TensorParallel(TP), and ZeRO.</li></ol></li>",Ps,re,Fa="In the following sections of this guide we dig deeper into how these different parallelism methods work.",Ms,pe,Ts,he,Wa=`Even with only 2 GPUs, you can readily leverage the accelerated training capabilities offered by PyTorch’s built-in features,
such as <code>DataParallel</code> (DP) and <code>DistributedDataParallel</code> (DDP). Note that
<a href="https://pytorch.org/docs/master/generated/torch.nn.DataParallel.html" rel="nofollow">PyTorch documentation</a> recommends to prefer
<code>DistributedDataParallel</code> (DDP) over <code>DataParallel</code> (DP) for multi-GPU training as it works for all models.
Let’s take a look at how these two methods work and what makes them different.`,bs,me,xs,fe,Za="To understand the key differences in inter-GPU communication overhead between the two methods, let’s review the processes per batch:",Cs,ue,Xa='<a href="https://pytorch.org/docs/master/notes/ddp.html" rel="nofollow">DDP</a>:',Us,ce,Oa="<li>At the start time the main process replicates the model once from GPU 0 to the rest of GPUs</li> <li>Then for each batch:<ol><li>Each GPU directly consumes its mini-batch of data.</li> <li>During <code>backward</code>, once the local gradients are ready, they are averaged across all processes.</li></ol></li>",_s,de,qa='<a href="https://pytorch.org/docs/master/generated/torch.nn.DataParallel.html" rel="nofollow">DP</a>:',$s,ve,Ya="For each batch:",Ls,we,Ka="<li>GPU 0 reads the batch of data and then sends a mini-batch to each GPU.</li> <li>The up-to-date model is replicated from GPU 0 to each GPU.</li> <li><code>forward</code> is executed, and output from each GPU is sent to GPU 0 to compute the loss.</li> <li>The loss is distributed from GPU 0 to all GPUs, and <code>backward</code> is run.</li> <li>Gradients from each GPU are sent to GPU 0 and averaged.</li>",js,ge,eo="Key differences include:",Ds,ye,to=`<li>DDP performs only a single communication per batch - sending gradients, while DP performs five different data exchanges per batch.
DDP copies data using <a href="https://pytorch.org/docs/master/distributed.html" rel="nofollow">torch.distributed</a>, while DP copies data within
the process via Python threads (which introduces limitations associated with GIL). As a result, <strong><code>DistributedDataParallel</code> (DDP) is generally faster than <code>DataParallel</code> (DP)</strong> unless you have slow GPU card inter-connectivity.</li> <li>Under DP, GPU 0 performs significantly more work than other GPUs, resulting in GPU under-utilization.</li> <li>DDP supports distributed training across multiple machines, whereas DP does not.</li>`,Hs,Pe,lo=`This is not an exhaustive list of differences between DP and DDP, however, other nuances are out of scope of this guide.
You can get a deeper understanding of these methods by reading this <a href="https://www.telesens.co/2019/04/04/distributed-data-parallel-training-using-pytorch-on-aws/" rel="nofollow">article</a>.`,Gs,Me,so=`Let’s illustrate the differences between DP and DDP with an experiment. We’ll benchmark the differences between DP and
DDP with an added context of NVLink presence:`,Js,Te,no="<li>Hardware: 2x TITAN RTX 24GB each + NVlink with 2 NVLinks (<code>NV2</code> in <code>nvidia-smi topo -m</code>).</li> <li>Software: <code>pytorch-1.8-to-be</code> + <code>cuda-11.0</code> / <code>transformers==4.3.0.dev0</code>.</li>",Is,be,io="To disable the NVLink feature on one of the benchmarks, we use <code>NCCL_P2P_DISABLE=1</code>.",ks,xe,ao="Here is the benchmarking code and outputs:",Ss,Ce,oo="<strong>DP</strong>",As,Ue,Vs,_e,ro="<strong>DDP w/ NVlink</strong>",Es,$e,Ns,Le,po="<strong>DDP w/o NVlink</strong>",Rs,je,zs,De,ho="Here are the same benchmarking results gathered in a table for convenience:",Bs,He,mo='<thead><tr><th align="left">Type</th> <th>NVlink</th> <th align="right">Time</th></tr></thead> <tbody><tr><td align="left">2:DP</td> <td>Y</td> <td align="right">110s</td></tr> <tr><td align="left">2:DDP</td> <td>Y</td> <td align="right">101s</td></tr> <tr><td align="left">2:DDP</td> <td>N</td> <td align="right">131s</td></tr></tbody>',Qs,Ge,fo=`As you can see, in this case DP is ~10% slower than DDP with NVlink, but ~15% faster than DDP without NVlink.
The real difference will depend on how much data each GPU needs to sync with the others - the more there is to sync,
the more a slow link will impede the overall runtime.`,Fs,Je,Ws,Ie,uo='ZeRO-powered data parallelism (ZeRO-DP) is illustrated in the following diagram from this <a href="https://www.microsoft.com/en-us/research/blog/zero-deepspeed-new-system-optimizations-enable-training-models-with-over-100-billion-parameters/" rel="nofollow">blog post</a>.',Zs,L,co='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-zero.png" alt="DeepSpeed-Image-1"/>',Xs,ke,vo=`While it may appear complex, it is a very similar concept to <code>DataParallel</code> (DP). The difference is that instead of
replicating the full model parameters, gradients and optimizer states, each GPU stores only a slice of it. Then, at
run-time when the full layer parameters are needed just for the given layer, all GPUs synchronize to give each other
parts that they miss.`,Os,Se,wo=`To illustrate this idea, consider a simple model with 3 layers (La, Lb, and Lc), where each layer has 3 parameters.
Layer La, for example, has weights a0, a1 and a2:`,qs,Ae,Ys,Ve,go="If we have 3 GPUs, ZeRO-DP splits the model onto 3 GPUs like so:",Ks,Ee,en,Ne,yo=`In a way, this is the same horizontal slicing as tensor parallelism, as opposed to Vertical
slicing, where one puts whole layer-groups on different GPUs. Now let’s see how this works:`,tn,Re,Po="Each of these GPUs will get the usual mini-batch as it works in DP:",ln,ze,sn,Be,Mo="The inputs are passed without modifications as if they would be processed by the original model.",nn,Qe,To="First, the inputs get to the layer <code>La</code>. What happens at this point?",an,Fe,bo=`On GPU0: the x0 mini-batch requires the a0, a1, a2 parameters to do its forward path through the layer, but the GPU0 has only a0.
It will get a1 from GPU1 and a2 from GPU2, bringing all the pieces of the model together.`,on,We,xo=`In parallel, GPU1 gets another mini-batch - x1. GPU1 has the a1 parameter, but needs a0 and a2, so it gets those from GPU0 and GPU2.
Same happens to GPU2 that gets the mini-batch x2. It gets a0 and a1 from GPU0 and GPU1.`,rn,Ze,Co=`This way each of the 3 GPUs gets the full tensors reconstructed and makes a forward pass with its own mini-batch.
As soon as the calculation is done, the data that is no longer needed gets dropped - it’s only used during the calculation.
The reconstruction is done efficiently via a pre-fetch.`,pn,Xe,Uo="Then the whole process is repeated for layer Lb, then Lc forward-wise, and then backward Lc -> Lb -> La.",hn,j,mn,Oe,_o=`While reading the literature on this topic you may encounter the following synonyms: Sharded, Partitioned.
If you pay close attention the way ZeRO partitions the model’s weights - it looks very similar to tensor parallelism
which will be discussed later. This is because it partitions/shards each layer’s weights, unlike vertical model parallelism
which is discussed next.`,fn,qe,$o="Implementations:",un,Ye,Lo='<li><a href="https://www.deepspeed.ai/tutorials/zero/" rel="nofollow">DeepSpeed</a> ZeRO-DP stages 1+2+3</li> <li><a href="https://huggingface.co/docs/accelerate/en/usage_guides/deepspeed" rel="nofollow"><code>Accelerate</code> integration</a></li> <li><a href="main_classes/trainer#trainer-integrations"><code>transformers</code> integration</a></li>',cn,Ke,dn,et,jo=`To explain Pipeline parallelism, we’ll first look into Naive Model Parallelism (MP), also known as Vertical MP. This approach
involves distributing groups of model layers across multiple GPUs by assigning specific layers to specific GPUs with <code>.to()</code>.
As data flows through these layers, it is moved to the same GPU as the layer, while the other layers remain untouched.`,vn,tt,Do=`We refer to this Model parallelism as “Vertical” because of how models are typically visualized. For example, the
following diagram shows an 8-layer model split vertically into two slices, placing layers 0-3 onto
GPU0 and 4-7 to GPU1:`,wn,lt,gn,st,Ho=`In this example, when data moves from layer 0 to 3, it’s no different from regular forward pass. However, passing data
from layer 3 to 4 requires moving it from GPU0 to GPU1, introducing a communication overhead. If the participating
GPUs are on the same compute node (e.g. same physical machine) this copying is fast, but if the GPUs are distributed
across different compute nodes (e.g. multiple machines), the communication overhead could be substantially greater.`,yn,nt,Go=`Following that, layers 4 to 7 work as they would in the original model. Upon completion of the 7th layer, there is often
a need to send the data back to layer 0 where the labels are (or alternatively send the labels to the last layer). Now the loss can be
computed and the optimizer can do its work.`,Pn,it,Jo="Naive Model Parallelism comes several shortcomings:",Mn,at,Io="<li><strong>All but one GPU are idle at any given moment</strong>: if 4 GPUs are used, it’s nearly identical to quadrupling the amount of memory of a single GPU, and ignoring the rest of the hardware.</li> <li><strong>Overhead in data transfer between devices</strong>:  E.g. 4x 6GB cards will be able to accommodate the same size as 1x 24GB card using naive MP, but a single 24GB card will complete the training faster, because it doesn’t have the data copying overhead. But, say, if you have 40GB cards and need to fit a 45GB model you can with 4x 40GB cards (but barely because of the gradient and optimizer states)</li> <li><strong>Copying shared embeddings</strong>: Shared embeddings may need to get copied back and forth between GPUs.</li>",Tn,ot,ko=`Now that you are familiar with how the naive approach to model parallelism works and its shortcomings, let’s look at Pipeline Parallelism (PP).
PP is almost identical to a naive MP, but it solves the GPU idling problem by chunking the incoming batch into micro-batches
and artificially creating a pipeline, which allows different GPUs to concurrently participate in the computation process.`,bn,rt,So=`The following illustration from the <a href="https://ai.googleblog.com/2019/03/introducing-gpipe-open-source-library.html" rel="nofollow">GPipe paper</a>
shows the naive MP on the top, and PP on the bottom:`,xn,D,Ao='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-gpipe-bubble.png" alt="MP vs PP"/>',Cn,pt,Vo=`At the bottom of the diagram, you can observe that the Pipeline Parallelism (PP) approach minimizes the number of idle
GPU zones, referred to as ‘bubbles’. Both parts of the diagram show a parallelism level of degree 4, meaning that 4 GPUs
are involved in the pipeline. You can see that there’s a forward path of 4 pipe stages (F0, F1, F2 and F3) followed by
a backward path in reverse order (B3, B2, B1, and B0).`,Un,ht,Eo=`PP introduces a new hyperparameter to tune - <code>chunks</code>, which determines how many data chunks are sent in a sequence
through the same pipe stage. For example, in the bottom diagram you can see <code>chunks=4</code>. GPU0 performs the same
forward path on chunk 0, 1, 2 and 3 (F0,0, F0,1, F0,2, F0,3) and then it waits for other GPUs to do complete their work.
Only when the other GPUs begin to complete their work, GPU0 starts to work again doing the backward path for chunks
3, 2, 1 and 0 (B0,3, B0,2, B0,1, B0,0).`,_n,mt,No=`Note that this is the same concept as gradient accumulation steps. PyTorch uses <code>chunks</code>, while DeepSpeed refers
to the same hyperparameter as gradient accumulation steps.`,$n,ft,Ro=`Because of the chunks, PP introduces the notion of micro-batches (MBS). DP splits the global data batch size into
mini-batches, so if you have a DP degree of 4, a global batch size of 1024 gets split up into 4 mini-batches of
256 each (1024/4). And if the number of <code>chunks</code> (or GAS) is 32 we end up with a micro-batch size of 8 (256/32). Each
Pipeline stage works with a single micro-batch at a time. To calculate the global batch size of the DP + PP setup,
use the formula: <code>mbs * chunks * dp_degree</code> (<code>8 * 32 * 4 = 1024</code>).
With <code>chunks=1</code> you end up with the naive MP, which is inefficient. With a large <code>chunks</code> value you end up with
tiny micro-batch sizes which is also inefficient. For this reason, we encourage to experiment with the <code>chunks</code> value to
find the one that leads to the most efficient GPUs utilization.`,Ln,ut,zo=`You may notice a bubble of “dead” time on the diagram that can’t be parallelized because the last <code>forward</code> stage
has to wait for <code>backward</code> to complete the pipeline. The purpose of finding the best value for <code>chunks</code> is to enable a high
concurrent GPU utilization across all participating GPUs which translates to minimizing the size of the bubble.`,jn,ct,Bo="Pipeline API solutions have been implemented in:",Dn,dt,Qo="<li>PyTorch</li> <li>DeepSpeed</li> <li>Megatron-LM</li>",Hn,vt,Fo="These come with some shortcomings:",Gn,wt,Wo='<li>They have to modify the model quite heavily, because Pipeline requires one to rewrite the normal flow of modules into a <code>nn.Sequential</code> sequence of the same, which may require changes to the design of the model.</li> <li>Currently the Pipeline API is very restricted. If you had a bunch of Python variables being passed in the very first stage of the Pipeline, you will have to find a way around it. Currently, the pipeline interface requires either a single Tensor or a tuple of Tensors as the only input and output. These tensors must have a batch size as the very first dimension, since pipeline is going to chunk the mini batch into micro-batches. Possible improvements are being discussed here <a href="https://github.com/pytorch/pytorch/pull/50693" rel="nofollow">https://github.com/pytorch/pytorch/pull/50693</a></li> <li>Conditional control flow at the level of pipe stages is not possible - e.g., Encoder-Decoder models like T5 require special workarounds to handle a conditional encoder stage.</li> <li>They have to arrange each layer so that the output of one layer becomes an input to the other layer.</li>',Jn,gt,Zo="More recent solutions include:",In,yt,Xo="<li>Varuna</li> <li>Sagemaker</li>",kn,Pt,Oo=`We have not experimented with Varuna and SageMaker but their papers report that they have overcome the list of problems
mentioned above and that they require smaller changes to the user’s model.`,Sn,Mt,qo="Implementations:",An,Tt,Yo='<li><a href="https://pytorch.org/docs/stable/pipeline.html" rel="nofollow">PyTorch</a> (initial support in pytorch-1.8, and progressively getting improved in 1.9 and more so in 1.10). Some <a href="https://github.com/pytorch/pytorch/blob/master/benchmarks/distributed/pipeline/pipe.py" rel="nofollow">examples</a></li> <li><a href="https://www.deepspeed.ai/tutorials/pipeline/" rel="nofollow">DeepSpeed</a></li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a> has an internal implementation - no API.</li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a> - this is a proprietary solution that can only be used on AWS.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a> - this is implemented based on the Hugging Face Transformers.</li>',Vn,bt,Ko=`🤗 Transformers status: as of this writing none of the models supports full-PP. GPT2 and T5 models have naive MP support.
The main obstacle is being unable to convert the models to <code>nn.Sequential</code> and have all the inputs to be Tensors. This
is because currently the models include many features that make the conversion very complicated, and will need to be removed to accomplish that.`,En,xt,er='DeepSpeed and Megatron-LM integrations are available in <a href="https://huggingface.co/docs/accelerate/main/en/usage_guides/deepspeed" rel="nofollow">🤗 Accelerate</a>',Nn,Ct,tr="Other approaches:",Rn,Ut,lr='DeepSpeed, Varuna and SageMaker use the concept of an <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-parallel-core-features.html" rel="nofollow">Interleaved Pipeline</a>',zn,H,sr='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-sagemaker-interleaved-pipeline.png" alt="Interleaved pipeline execution"/>',Bn,_t,nr=`Here the bubble (idle time) is further minimized by prioritizing backward passes. Varuna further attempts to improve the
schedule by using simulations to discover the most efficient scheduling.`,Qn,$t,ir="OSLO has pipeline parallelism implementation based on the Transformers without <code>nn.Sequential</code> conversion.",Fn,Lt,Wn,jt,ar=`In Tensor Parallelism, each GPU processes a slice of a tensor and only aggregates the full tensor for operations requiring it.
To describe this method, this section of the guide relies on the concepts and diagrams from the <a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a>
paper: <a href="https://arxiv.org/abs/2104.04473" rel="nofollow">Efficient Large-Scale Language Model Training on GPU Clusters</a>.`,Zn,Dt,or=`The main building block of any transformer is a fully connected <code>nn.Linear</code> followed by a nonlinear activation <code>GeLU</code>.
The dot dot-product part of it, following the Megatron’s paper notation, can be written as <code>Y = GeLU(XA)</code>, where <code>X</code> is
an input vector, <code>Y</code> is the output vector, and <code>A</code> is the weight matrix.`,Xn,Ht,rr="If we look at the computation in matrix form, you can see how the matrix multiplication can be split between multiple GPUs:",On,G,pr='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_gemm.png" alt="Parallel GEMM"/>',qn,Gt,hr=`If we split the weight matrix <code>A</code> column-wise across <code>N</code> GPUs and perform matrix multiplications <code>XA_1</code> through <code>XA_n</code> in parallel,
then we will end up with <code>N</code> output vectors <code>Y_1, Y_2, ..., Y_n</code> which can be fed into <code>GeLU</code> independently:`,Yn,J,mr='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-independent-gelu.png" alt="Independent GeLU"/>',Kn,Jt,fr=`Using this principle, we can update a multi-layer perceptron of arbitrary depth, without the need for any synchronization
between GPUs until the very end, where we need to reconstruct the output vector from shards. The Megatron-LM paper authors
provide a helpful illustration for that:`,ei,I,ur='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_shard_processing.png" alt="Parallel shard processing"/>',ti,It,cr=`Parallelizing the multi-headed attention layers is even simpler, since they are already inherently parallel, due to having
multiple independent heads!`,li,k,dr='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_self_attention.png" alt="Parallel self-attention"/>',si,kt,vr=`Special considerations: TP requires very fast network, and therefore it’s not advisable to do TP across more than one node.
Practically, if a node has 4 GPUs, the highest TP degree is therefore 4. If you need a TP degree of 8, you need to use
nodes that have at least 8 GPUs.`,ni,St,wr=`This section is based on the original much more <a href="https://github.com/huggingface/transformers/issues/10321#issuecomment-783543530" rel="nofollow">detailed TP overview</a>.
by <a href="https://github.com/anton-l" rel="nofollow">@anton-l</a>.`,ii,At,gr="Alternative names:",ai,Vt,yr='<li>DeepSpeed calls it <a href="https://www.deepspeed.ai/training/#model-parallelism" rel="nofollow">tensor slicing</a></li>',oi,Et,Pr="Implementations:",ri,Nt,Mr='<li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a> has an internal implementation, as it’s very model-specific</li> <li><a href="https://github.com/tunib-ai/parallelformers" rel="nofollow">parallelformers</a> (only inference at the moment)</li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a> - this is a proprietary solution that can only be used on AWS.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a> has the tensor parallelism implementation based on the Transformers.</li>',pi,Rt,Tr="SageMaker combines TP with DP for a more efficient processing.",hi,zt,br="🤗 Transformers status:",mi,Bt,xr='<li>core: not yet implemented in the core</li> <li>but if you want inference <a href="https://github.com/tunib-ai/parallelformers" rel="nofollow">parallelformers</a> provides this support for most of our models. So until this is implemented in the core you can use theirs. And hopefully training mode will be supported too.</li> <li>Deepspeed-Inference also supports our BERT, GPT-2, and GPT-Neo models in their super-fast CUDA-kernel-based inference mode, see more <a href="https://www.deepspeed.ai/tutorials/inference-tutorial/" rel="nofollow">here</a></li>',fi,Qt,Cr='🤗 Accelerate integrates with <a href="https://huggingface.co/docs/accelerate/v0.23.0/en/usage_guides/megatron_lm" rel="nofollow">TP from Megatron-LM</a>.',ui,Ft,ci,Wt,Ur=`The following diagram from the DeepSpeed <a href="https://www.deepspeed.ai/tutorials/pipeline/" rel="nofollow">pipeline tutorial</a> demonstrates
how one can combine DP with PP.`,di,S,_r='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-zero-dp-pp.png" alt="DP + PP-2d"/>',vi,Zt,$r=`Here it’s important to see how DP rank 0 doesn’t see GPU2 and DP rank 1 doesn’t see GPU3. To DP there is just GPUs 0
and 1 where it feeds data as if there were just 2 GPUs. GPU0 “secretly” offloads some of its load to GPU2 using PP.
And GPU1 does the same by enlisting GPU3 to its aid.`,wi,Xt,Lr="Since each dimension requires at least 2 GPUs, here you’d need at least 4 GPUs.",gi,Ot,jr="Implementations:",yi,qt,Dr='<li><a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a></li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a></li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a></li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',Pi,Yt,Hr="🤗 Transformers status: not yet implemented",Mi,Kt,Ti,el,Gr="To get an even more efficient training a 3D parallelism is used where PP is combined with TP and DP. This can be seen in the following diagram.",bi,A,Jr='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-deepspeed-3d.png" alt="dp-pp-tp-3d"/>',xi,tl,Ir='This diagram is from a blog post <a href="https://www.microsoft.com/en-us/research/blog/deepspeed-extreme-scale-model-training-for-everyone/" rel="nofollow">3D parallelism: Scaling to trillion-parameter models</a>, which is a good read as well.',Ci,ll,kr="Since each dimension requires at least 2 GPUs, here you’d need at least 8 GPUs.",Ui,sl,Sr="Implementations:",_i,nl,Ar='<li><a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a> - DeepSpeed also includes an even more efficient DP, which they call ZeRO-DP.</li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a></li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a></li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',$i,il,Vr="🤗 Transformers status: not yet implemented, since we have no PP and TP.",Li,al,ji,ol,Er=`One of the main features of DeepSpeed is ZeRO, which is a super-scalable extension of DP. It has already been
discussed in <a href="#zero-data-parallelism">ZeRO Data Parallelism</a>. Normally it’s a standalone feature that doesn’t require PP or TP.
But it can be combined with PP and TP.`,Di,rl,Nr="When ZeRO-DP is combined with PP (and optionally TP) it typically enables only ZeRO stage 1 (optimizer sharding).",Hi,pl,Rr=`While it’s theoretically possible to use ZeRO stage 2 (gradient sharding) with Pipeline Parallelism, it will have negative
performance impacts. There would need to be an additional reduce-scatter collective for every micro-batch to aggregate
the gradients before sharding, which adds a potentially significant communication overhead. By nature of Pipeline Parallelism,
small micro-batches are used and instead the focus is on trying to balance arithmetic intensity (micro-batch size) with
minimizing the Pipeline bubble (number of micro-batches). Therefore those communication costs are going to impact the performance.`,Gi,hl,zr=`In addition, there are already fewer layers than normal due to PP and so the memory savings won’t be huge. PP already
reduces gradient size by <code>1/PP</code>, and so gradient sharding savings on top of that are less significant than pure DP.`,Ji,ml,Br="ZeRO stage 3 is not a good choice either for the same reason - more inter-node communications required.",Ii,fl,Qr="And since we have ZeRO, the other benefit is ZeRO-Offload. Since this is stage 1 optimizer states can be offloaded to CPU.",ki,ul,Fr="Implementations:",Si,cl,Wr='<li><a href="https://github.com/microsoft/Megatron-DeepSpeed" rel="nofollow">Megatron-DeepSpeed</a> and <a href="https://github.com/bigscience-workshop/Megatron-DeepSpeed" rel="nofollow">Megatron-Deepspeed from BigScience</a>, which is the fork of the former repo.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',Ai,dl,Zr="Important papers:",Vi,vl,Xr='<li><a href="https://arxiv.org/abs/2201.11990" rel="nofollow">Using DeepSpeed and Megatron to Train Megatron-Turing NLG 530B, A Large-Scale Generative Language Model</a></li>',Ei,wl,Or="🤗 Transformers status: not yet implemented, since we have no PP and TP.",Ni,gl,Ri,yl,qr='<a href="https://github.com/flexflow/FlexFlow" rel="nofollow">FlexFlow</a> also solves the parallelization problem in a slightly different approach.',zi,Pl,Yr='Paper: <a href="https://arxiv.org/abs/1807.05358" rel="nofollow">“Beyond Data and Model Parallelism for Deep Neural Networks” by Zhihao Jia, Matei Zaharia, Alex Aiken</a>',Bi,Ml,Kr="It performs a sort of 4D Parallelism over Sample-Operator-Attribute-Parameter.",Qi,Tl,ep="<li>Sample = Data Parallelism (sample-wise parallel)</li> <li>Operator = Parallelize a single operation into several sub-operations</li> <li>Attribute = Data Parallelism (length-wise parallel)</li> <li>Parameter = Model Parallelism (regardless of dimension - horizontal or vertical)</li>",Fi,bl,tp="Examples:",Wi,xl,lp="<li>Sample</li>",Zi,Cl,sp="Let’s take 10 batches of sequence length 512. If we parallelize them by sample dimension into 2 devices, we get 10 x 512 which becomes be 5 x 2 x 512.",Xi,Ul,np="<li>Operator</li>",Oi,_l,ip=`If we perform layer normalization, we compute std first and mean second, and then we can normalize data.
Operator parallelism allows computing std and mean in parallel. So if we parallelize them by operator dimension into 2
devices (cuda:0, cuda:1), first we copy input data into both devices, and cuda:0 computes std, cuda:1 computes mean at the same time.`,qi,$l,ap="<li>Attribute</li>",Yi,Ll,op="We have 10 batches of 512 length. If we parallelize them by attribute dimension into 2 devices, 10 x 512 will be 10 x 2 x 256.",Ki,jl,rp="<li>Parameter</li>",ea,Dl,pp="It is similar with tensor model parallelism or naive layer-wise model parallelism.",ta,V,hp='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-flexflow.jpeg" alt="flex-flow-soap"/>',la,Hl,mp=`The significance of this framework is that it takes resources like (1) GPU/TPU/CPU vs. (2) RAM/DRAM vs. (3)
fast-intra-connect/slow-inter-connect and it automatically optimizes all these algorithmically deciding which
parallelisation to use where.`,sa,Gl,fp=`One very important aspect is that FlexFlow is designed for optimizing DNN parallelizations for models with static and
fixed workloads, since models with dynamic behavior may prefer different parallelization strategies across iterations.`,na,Jl,up=`So the promise is very attractive - it runs a 30min simulation on the cluster of choice and it comes up with the best
strategy to utilise this specific environment. If you add/remove/replace any parts it’ll run and re-optimize the plan
for that. And then you can train. A different setup will have its own custom optimization.`,ia,Il,cp=`🤗 Transformers status: Transformers models are FX-trace-able via <a href="https://github.com/huggingface/transformers/blob/master/src/transformers/utils/fx.py" rel="nofollow">transformers.utils.fx</a>,
which is a prerequisite for FlexFlow, however, changes are required on the FlexFlow side to make it work with Transformers models.`,aa,kl,oa,Sl,dp='When training on multiple GPUs, you can specify the number of GPUs to use and in what order. This can be useful for instance when you have GPUs with different computing power and want to use the faster GPU first. The selection process works for both <a href="https://pytorch.org/docs/stable/generated/torch.nn.parallel.DistributedDataParallel.html" rel="nofollow">DistributedDataParallel</a> and <a href="https://pytorch.org/docs/stable/generated/torch.nn.DataParallel.html" rel="nofollow">DataParallel</a> to use only a subset of the available GPUs, and you don’t need Accelerate or the <a href="./main_classes/deepspeed">DeepSpeed integration</a>.',ra,Al,pa,Vl,vp="For example, if you have 4 GPUs and you only want to use the first 2:",ha,E,ma,El,fa,Nl,wp="Now, to select which GPUs to use and their order, you’ll use the <code>CUDA_VISIBLE_DEVICES</code> environment variable. It is easiest to set the environment variable in a <code>~/bashrc</code> or another startup config file. <code>CUDA_VISIBLE_DEVICES</code> is used to map which GPUs are used. For example, if you have 4 GPUs (0, 1, 2, 3) and you only want to run GPUs 0 and 2:",ua,Rl,ca,zl,gp="Only the 2 physical GPUs (0 and 2) are “visible” to PyTorch and these are mapped to <code>cuda:0</code> and <code>cuda:1</code> respectively. You can also reverse the order of the GPUs to use 2 first. Now, the mapping is <code>cuda:1</code> for GPU 0 and <code>cuda:0</code> for GPU 2.",da,Bl,va,Ql,yp="You can also set the <code>CUDA_VISIBLE_DEVICES</code> environment variable to an empty value to create an environment without GPUs.",wa,Fl,ga,N,ya,Wl,Pp="<code>CUDA_DEVICE_ORDER</code> is an alternative environment variable you can use to control how the GPUs are ordered. You can either order them by:",Pa,Zl,Mp='<li>PCIe bus ID’s that matches the order of <a href="https://developer.nvidia.com/nvidia-system-management-interface" rel="nofollow"><code>nvidia-smi</code></a> and <a href="https://rocm.docs.amd.com/projects/rocm_smi_lib/en/latest/.doxygen/docBin/html/index.html" rel="nofollow"><code>rocm-smi</code></a> for NVIDIA and AMD GPUs respectively</li>',Ma,Xl,Ta,R,Tp="<li>GPU compute ability</li>",ba,Ol,xa,ql,bp="The <code>CUDA_DEVICE_ORDER</code> is especially useful if your training setup consists of an older and newer GPU, where the older GPU appears first, but you cannot physically swap the cards to make the newer GPU appear first. In this case, set <code>CUDA_DEVICE_ORDER=FASTEST_FIRST</code> to always use the newer and faster GPU first (<code>nvidia-smi</code> or <code>rocm-smi</code> still reports the GPUs in their PCIe order). Or you could also set <code>export CUDA_VISIBLE_DEVICES=1,0</code>.",Ca,es,Ua;return P=new C({props:{title:"Efficient Training on Multiple GPUs",local:"efficient-training-on-multiple-gpus",headingTag:"h1"}}),$=new _a({props:{$$slots:{default:[kp]},$$scope:{ctx:T}}}),F=new C({props:{title:"Scalability strategy",local:"scalability-strategy",headingTag:"h2"}}),pe=new C({props:{title:"Data Parallelism",local:"data-parallelism",headingTag:"h2"}}),me=new C({props:{title:"DataParallel vs DistributedDataParallel",local:"dataparallel-vs-distributeddataparallel",headingTag:"h3"}}),Ue=new x({props:{code:"cm0lMjAtciUyMCUyRnRtcCUyRnRlc3QtY2xtJTNCJTIwQ1VEQV9WSVNJQkxFX0RFVklDRVMlM0QwJTJDMSUyMCU1QyUwQXB5dGhvbiUyMGV4YW1wbGVzJTJGcHl0b3JjaCUyRmxhbmd1YWdlLW1vZGVsaW5nJTJGcnVuX2NsbS5weSUyMCU1QyUwQS0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwZ3B0MiUyMC0tZGF0YXNldF9uYW1lJTIwd2lraXRleHQlMjAtLWRhdGFzZXRfY29uZmlnX25hbWUlMjB3aWtpdGV4dC0yLXJhdy12MSUyMCU1QyUwQS0tZG9fdHJhaW4lMjAtLW91dHB1dF9kaXIlMjAlMkZ0bXAlMkZ0ZXN0LWNsbSUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwNCUyMC0tbWF4X3N0ZXBzJTIwMjAwJTBBJTBBJTdCJ3RyYWluX3J1bnRpbWUnJTNBJTIwMTEwLjU5NDglMkMlMjAndHJhaW5fc2FtcGxlc19wZXJfc2Vjb25kJyUzQSUyMDEuODA4JTJDJTIwJ2Vwb2NoJyUzQSUyMDAuNjklN0Q=",highlighted:`<span class="hljs-string">rm</span> -<span class="hljs-string">r</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span>; <span class="hljs-string">CUDA_VISIBLE_DEVICES</span>=<span class="hljs-string">0</span>,<span class="hljs-string">1</span> \\
<span class="hljs-string">python</span> <span class="hljs-string">examples</span>/<span class="hljs-string">pytorch</span>/<span class="hljs-string">language-modeling</span>/<span class="hljs-string">run_clm</span>.<span class="hljs-string">py</span> \\
<span class="hljs-built_in">--model_name_or_path</span> <span class="hljs-string">gpt2</span> <span class="hljs-built_in">--dataset_name</span> <span class="hljs-string">wikitext</span> <span class="hljs-built_in">--dataset_config_name</span> <span class="hljs-string">wikitext-2-raw-v1</span> \\
<span class="hljs-built_in">--do_train</span> <span class="hljs-built_in">--output_dir</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span> <span class="hljs-built_in">--per_device_train_batch_size</span> <span class="hljs-string">4</span> <span class="hljs-built_in">--max_steps</span> <span class="hljs-string">200</span>

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-string">110</span>.<span class="hljs-string">5948</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-string">1</span>.<span class="hljs-string">808</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-string">0</span>.<span class="hljs-string">69</span>}`,wrap:!1}}),$e=new x({props:{code:"cm0lMjAtciUyMCUyRnRtcCUyRnRlc3QtY2xtJTNCJTIwQ1VEQV9WSVNJQkxFX0RFVklDRVMlM0QwJTJDMSUyMCU1QyUwQXRvcmNocnVuJTIwLS1ucHJvY19wZXJfbm9kZSUyMDIlMjBleGFtcGxlcyUyRnB5dG9yY2glMkZsYW5ndWFnZS1tb2RlbGluZyUyRnJ1bl9jbG0ucHklMjAlNUMlMEEtLW1vZGVsX25hbWVfb3JfcGF0aCUyMGdwdDIlMjAtLWRhdGFzZXRfbmFtZSUyMHdpa2l0ZXh0JTIwLS1kYXRhc2V0X2NvbmZpZ19uYW1lJTIwd2lraXRleHQtMi1yYXctdjElMjAlNUMlMEEtLWRvX3RyYWluJTIwLS1vdXRwdXRfZGlyJTIwJTJGdG1wJTJGdGVzdC1jbG0lMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDQlMjAtLW1heF9zdGVwcyUyMDIwMCUwQSUwQSU3Qid0cmFpbl9ydW50aW1lJyUzQSUyMDEwMS45MDAzJTJDJTIwJ3RyYWluX3NhbXBsZXNfcGVyX3NlY29uZCclM0ElMjAxLjk2MyUyQyUyMCdlcG9jaCclM0ElMjAwLjY5JTdE",highlighted:`<span class="hljs-string">rm</span> -<span class="hljs-string">r</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span>; <span class="hljs-string">CUDA_VISIBLE_DEVICES</span>=<span class="hljs-string">0</span>,<span class="hljs-string">1</span> \\
<span class="hljs-string">torchrun</span> <span class="hljs-built_in">--nproc_per_node</span> <span class="hljs-string">2</span> <span class="hljs-string">examples</span>/<span class="hljs-string">pytorch</span>/<span class="hljs-string">language-modeling</span>/<span class="hljs-string">run_clm</span>.<span class="hljs-string">py</span> \\
<span class="hljs-built_in">--model_name_or_path</span> <span class="hljs-string">gpt2</span> <span class="hljs-built_in">--dataset_name</span> <span class="hljs-string">wikitext</span> <span class="hljs-built_in">--dataset_config_name</span> <span class="hljs-string">wikitext-2-raw-v1</span> \\
<span class="hljs-built_in">--do_train</span> <span class="hljs-built_in">--output_dir</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span> <span class="hljs-built_in">--per_device_train_batch_size</span> <span class="hljs-string">4</span> <span class="hljs-built_in">--max_steps</span> <span class="hljs-string">200</span>

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-string">101</span>.<span class="hljs-string">9003</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-string">1</span>.<span class="hljs-string">963</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-string">0</span>.<span class="hljs-string">69</span>}`,wrap:!1}}),je=new x({props:{code:"cm0lMjAtciUyMCUyRnRtcCUyRnRlc3QtY2xtJTNCJTIwTkNDTF9QMlBfRElTQUJMRSUzRDElMjBDVURBX1ZJU0lCTEVfREVWSUNFUyUzRDAlMkMxJTIwJTVDJTBBdG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTIwMiUyMGV4YW1wbGVzJTJGcHl0b3JjaCUyRmxhbmd1YWdlLW1vZGVsaW5nJTJGcnVuX2NsbS5weSUyMCU1QyUwQS0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwZ3B0MiUyMC0tZGF0YXNldF9uYW1lJTIwd2lraXRleHQlMjAtLWRhdGFzZXRfY29uZmlnX25hbWUlMjB3aWtpdGV4dC0yLXJhdy12MSUyMCU1QyUwQS0tZG9fdHJhaW4lMjAtLW91dHB1dF9kaXIlMjAlMkZ0bXAlMkZ0ZXN0LWNsbSUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwNCUyMC0tbWF4X3N0ZXBzJTIwMjAwJTBBJTBBJTdCJ3RyYWluX3J1bnRpbWUnJTNBJTIwMTMxLjQzNjclMkMlMjAndHJhaW5fc2FtcGxlc19wZXJfc2Vjb25kJyUzQSUyMDEuNTIyJTJDJTIwJ2Vwb2NoJyUzQSUyMDAuNjklN0Q=",highlighted:`<span class="hljs-string">rm</span> -<span class="hljs-string">r</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span>; <span class="hljs-string">NCCL_P2P_DISABLE</span>=<span class="hljs-string">1</span> <span class="hljs-string">CUDA_VISIBLE_DEVICES</span>=<span class="hljs-string">0</span>,<span class="hljs-string">1</span> \\
<span class="hljs-string">torchrun</span> <span class="hljs-built_in">--nproc_per_node</span> <span class="hljs-string">2</span> <span class="hljs-string">examples</span>/<span class="hljs-string">pytorch</span>/<span class="hljs-string">language-modeling</span>/<span class="hljs-string">run_clm</span>.<span class="hljs-string">py</span> \\
<span class="hljs-built_in">--model_name_or_path</span> <span class="hljs-string">gpt2</span> <span class="hljs-built_in">--dataset_name</span> <span class="hljs-string">wikitext</span> <span class="hljs-built_in">--dataset_config_name</span> <span class="hljs-string">wikitext-2-raw-v1</span> \\
<span class="hljs-built_in">--do_train</span> <span class="hljs-built_in">--output_dir</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span> <span class="hljs-built_in">--per_device_train_batch_size</span> <span class="hljs-string">4</span> <span class="hljs-built_in">--max_steps</span> <span class="hljs-string">200</span>

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-string">131</span>.<span class="hljs-string">4367</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-string">1</span>.<span class="hljs-string">522</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-string">0</span>.<span class="hljs-string">69</span>}`,wrap:!1}}),Je=new C({props:{title:"ZeRO Data Parallelism",local:"zero-data-parallelism",headingTag:"h2"}}),Ae=new x({props:{code:"TGElMjAlN0MlMjBMYiUyMCU3QyUyMExjJTBBLS0tJTdDLS0tLSU3Qy0tLSUwQWEwJTIwJTdDJTIwYjAlMjAlN0MlMjBjMCUwQWExJTIwJTdDJTIwYjElMjAlN0MlMjBjMSUwQWEyJTIwJTdDJTIwYjIlMjAlN0MlMjBjMg==",highlighted:`La |<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a0 </span>|<span class="hljs-string"> b0 </span>|<span class="hljs-string"> c0
a1 </span>|<span class="hljs-string"> b1 </span>|<span class="hljs-string"> c1
a2 </span>|<span class="hljs-string"> b2 </span>|<span class="hljs-string"> c2</span>`,wrap:!1}}),Ee=new x({props:{code:"R1BVMCUzQSUwQUxhJTIwJTdDJTIwTGIlMjAlN0MlMjBMYyUwQS0tLSU3Qy0tLS0lN0MtLS0lMEFhMCUyMCU3QyUyMGIwJTIwJTdDJTIwYzAlMEElMEFHUFUxJTNBJTBBTGElMjAlN0MlMjBMYiUyMCU3QyUyMExjJTBBLS0tJTdDLS0tLSU3Qy0tLSUwQWExJTIwJTdDJTIwYjElMjAlN0MlMjBjMSUwQSUwQUdQVTIlM0ElMEFMYSUyMCU3QyUyMExiJTIwJTdDJTIwTGMlMEEtLS0lN0MtLS0tJTdDLS0tJTBBYTIlMjAlN0MlMjBiMiUyMCU3QyUyMGMy",highlighted:`GPU0:
La |<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a0 </span>|<span class="hljs-string"> b0 </span>|<span class="hljs-string"> c0

GPU1:
La </span>|<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a1 </span>|<span class="hljs-string"> b1 </span>|<span class="hljs-string"> c1

GPU2:
La </span>|<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a2 </span>|<span class="hljs-string"> b2 </span>|<span class="hljs-string"> c2</span>`,wrap:!1}}),ze=new x({props:{code:"eDAlMjAlM0QlM0UlMjBHUFUwJTBBeDElMjAlM0QlM0UlMjBHUFUxJTBBeDIlMjAlM0QlM0UlMjBHUFUy",highlighted:`<span class="hljs-attribute">x0</span> <span class="hljs-operator">=</span>&gt; GPU0
<span class="hljs-attribute">x1</span> <span class="hljs-operator">=</span>&gt; GPU1
<span class="hljs-attribute">x2</span> <span class="hljs-operator">=</span>&gt; GPU2`,wrap:!1}}),j=new _a({props:{$$slots:{default:[Sp]},$$scope:{ctx:T}}}),Ke=new C({props:{title:"From Naive Model Parallelism to Pipeline Parallelism",local:"from-naive-model-parallelism-to-pipeline-parallelism",headingTag:"h2"}}),lt=new x({props:{code:"JTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTBBJTdDJTIwTGF5ZXIlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMEElN0MlMjAlMjAlMjAwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTBBJTdDJTIwJTIwJTIwMSUyMCUyMCUyMCU3QyUyMEdQVTAlMjAlN0MlMEElN0MlMjAlMjAlMjAyJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTBBJTdDJTIwJTIwJTIwMyUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUwQSU3QyUyMExheWVyJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTBBJTdDJTIwJTIwJTIwNCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSU3QyUyMCUyMCUyMDUlMjAlMjAlMjAlN0MlMjBHUFUxJTIwJTdDJTBBJTdDJTIwJTIwJTIwNiUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSU3QyUyMCUyMCUyMDclMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMEElM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0Q=",highlighted:`================
|<span class="hljs-string"> Layer </span>|<span class="hljs-string">      </span>|
|<span class="hljs-string">   0   </span>|<span class="hljs-string">      </span>|
|<span class="hljs-string">   1   </span>|<span class="hljs-string"> GPU0 </span>|
|<span class="hljs-string">   2   </span>|<span class="hljs-string">      </span>|
|<span class="hljs-string">   3   </span>|<span class="hljs-string">      </span>|
================
|<span class="hljs-string"> Layer </span>|<span class="hljs-string">      </span>|
|<span class="hljs-string">   4   </span>|<span class="hljs-string">      </span>|
|<span class="hljs-string">   5   </span>|<span class="hljs-string"> GPU1 </span>|
|<span class="hljs-string">   6   </span>|<span class="hljs-string">      </span>|
|<span class="hljs-string">   7   </span>|<span class="hljs-string">      </span>|
================`,wrap:!1}}),Lt=new C({props:{title:"Tensor Parallelism",local:"tensor-parallelism",headingTag:"h2"}}),Ft=new C({props:{title:"Data Parallelism + Pipeline Parallelism",local:"data-parallelism--pipeline-parallelism",headingTag:"h2"}}),Kt=new C({props:{title:"Data Parallelism + Pipeline Parallelism + Tensor Parallelism",local:"data-parallelism--pipeline-parallelism--tensor-parallelism",headingTag:"h2"}}),al=new C({props:{title:"ZeRO Data Parallelism + Pipeline Parallelism + Tensor Parallelism",local:"zero-data-parallelism--pipeline-parallelism--tensor-parallelism",headingTag:"h2"}}),gl=new C({props:{title:"FlexFlow",local:"flexflow",headingTag:"h2"}}),kl=new C({props:{title:"GPU selection",local:"gpu-selection",headingTag:"h2"}}),Al=new C({props:{title:"Number of GPUs",local:"number-of-gpus",headingTag:"h3"}}),E=new Ip({props:{id:"select-gpu",options:["torchrun","Accelerate","DeepSpeed"],$$slots:{default:[Np]},$$scope:{ctx:T}}}),El=new C({props:{title:"Order of GPUs",local:"order-of-gpus",headingTag:"h3"}}),Rl=new x({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0QwJTJDMiUyMHRvcmNocnVuJTIwdHJhaW5lci1wcm9ncmFtLnB5JTIwLi4u",highlighted:"CUDA_VISIBLE_DEVICES=0,2 torchrun trainer-program.py ...",wrap:!1}}),Bl=new x({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0QyJTJDMCUyMHRvcmNocnVuJTIwdHJhaW5lci1wcm9ncmFtLnB5JTIwLi4u",highlighted:"CUDA_VISIBLE_DEVICES=2,0 torchrun trainer-program.py ...",wrap:!1}}),Fl=new x({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0QlMjBweXRob24lMjB0cmFpbmVyLXByb2dyYW0ucHklMjAuLi4=",highlighted:"CUDA_VISIBLE_DEVICES= python trainer-program.py ...",wrap:!1}}),N=new _a({props:{warning:!0,$$slots:{default:[Rp]},$$scope:{ctx:T}}}),Xl=new x({props:{code:"ZXhwb3J0JTIwQ1VEQV9ERVZJQ0VfT1JERVIlM0RQQ0lfQlVTX0lE",highlighted:'<span class="hljs-built_in">export</span> CUDA_DEVICE_ORDER=PCI_BUS_ID',wrap:!1}}),Ol=new x({props:{code:"ZXhwb3J0JTIwQ1VEQV9ERVZJQ0VfT1JERVIlM0RGQVNURVNUX0ZJUlNU",highlighted:'<span class="hljs-built_in">export</span> CUDA_DEVICE_ORDER=FASTEST_FIRST',wrap:!1}}),{c(){p=a("meta"),M=n(),f=a("p"),u=n(),c(P.$$.fragment),h=n(),m=a("p"),m.innerHTML=b,z=n(),_=a("p"),_.textContent=Kl,ts=n(),B=a("p"),B.innerHTML=La,ls=n(),c($.$$.fragment),ss=n(),Q=a("p"),Q.textContent=ja,ns=n(),c(F.$$.fragment),is=n(),W=a("p"),W.innerHTML=Da,as=n(),Z=a("p"),Z.innerHTML=Ha,os=n(),X=a("p"),X.textContent=Ga,rs=n(),O=a("p"),O.innerHTML=Ja,ps=n(),q=a("p"),q.textContent=Ia,hs=n(),Y=a("ol"),Y.innerHTML=ka,ms=n(),K=a("p"),K.innerHTML=Sa,fs=n(),ee=a("p"),ee.textContent=Aa,us=n(),te=a("ol"),te.innerHTML=Va,cs=n(),le=a("p"),le.textContent=Ea,ds=n(),se=a("p"),se.textContent=Na,vs=n(),ne=a("p"),ne.innerHTML=Ra,ws=n(),ie=a("ol"),ie.innerHTML=za,gs=n(),ae=a("p"),ae.innerHTML=Ba,ys=n(),oe=a("ul"),oe.innerHTML=Qa,Ps=n(),re=a("p"),re.textContent=Fa,Ms=n(),c(pe.$$.fragment),Ts=n(),he=a("p"),he.innerHTML=Wa,bs=n(),c(me.$$.fragment),xs=n(),fe=a("p"),fe.textContent=Za,Cs=n(),ue=a("p"),ue.innerHTML=Xa,Us=n(),ce=a("ul"),ce.innerHTML=Oa,_s=n(),de=a("p"),de.innerHTML=qa,$s=n(),ve=a("p"),ve.textContent=Ya,Ls=n(),we=a("ol"),we.innerHTML=Ka,js=n(),ge=a("p"),ge.textContent=eo,Ds=n(),ye=a("ol"),ye.innerHTML=to,Hs=n(),Pe=a("p"),Pe.innerHTML=lo,Gs=n(),Me=a("p"),Me.textContent=so,Js=n(),Te=a("ul"),Te.innerHTML=no,Is=n(),be=a("p"),be.innerHTML=io,ks=n(),xe=a("p"),xe.textContent=ao,Ss=n(),Ce=a("p"),Ce.innerHTML=oo,As=n(),c(Ue.$$.fragment),Vs=n(),_e=a("p"),_e.innerHTML=ro,Es=n(),c($e.$$.fragment),Ns=n(),Le=a("p"),Le.innerHTML=po,Rs=n(),c(je.$$.fragment),zs=n(),De=a("p"),De.textContent=ho,Bs=n(),He=a("table"),He.innerHTML=mo,Qs=n(),Ge=a("p"),Ge.textContent=fo,Fs=n(),c(Je.$$.fragment),Ws=n(),Ie=a("p"),Ie.innerHTML=uo,Zs=n(),L=a("div"),L.innerHTML=co,Xs=n(),ke=a("p"),ke.innerHTML=vo,Os=n(),Se=a("p"),Se.textContent=wo,qs=n(),c(Ae.$$.fragment),Ys=n(),Ve=a("p"),Ve.textContent=go,Ks=n(),c(Ee.$$.fragment),en=n(),Ne=a("p"),Ne.textContent=yo,tn=n(),Re=a("p"),Re.textContent=Po,ln=n(),c(ze.$$.fragment),sn=n(),Be=a("p"),Be.textContent=Mo,nn=n(),Qe=a("p"),Qe.innerHTML=To,an=n(),Fe=a("p"),Fe.textContent=bo,on=n(),We=a("p"),We.textContent=xo,rn=n(),Ze=a("p"),Ze.textContent=Co,pn=n(),Xe=a("p"),Xe.textContent=Uo,hn=n(),c(j.$$.fragment),mn=n(),Oe=a("p"),Oe.textContent=_o,fn=n(),qe=a("p"),qe.textContent=$o,un=n(),Ye=a("ul"),Ye.innerHTML=Lo,cn=n(),c(Ke.$$.fragment),dn=n(),et=a("p"),et.innerHTML=jo,vn=n(),tt=a("p"),tt.textContent=Do,wn=n(),c(lt.$$.fragment),gn=n(),st=a("p"),st.textContent=Ho,yn=n(),nt=a("p"),nt.textContent=Go,Pn=n(),it=a("p"),it.textContent=Jo,Mn=n(),at=a("ul"),at.innerHTML=Io,Tn=n(),ot=a("p"),ot.textContent=ko,bn=n(),rt=a("p"),rt.innerHTML=So,xn=n(),D=a("div"),D.innerHTML=Ao,Cn=n(),pt=a("p"),pt.textContent=Vo,Un=n(),ht=a("p"),ht.innerHTML=Eo,_n=n(),mt=a("p"),mt.innerHTML=No,$n=n(),ft=a("p"),ft.innerHTML=Ro,Ln=n(),ut=a("p"),ut.innerHTML=zo,jn=n(),ct=a("p"),ct.textContent=Bo,Dn=n(),dt=a("ul"),dt.innerHTML=Qo,Hn=n(),vt=a("p"),vt.textContent=Fo,Gn=n(),wt=a("ul"),wt.innerHTML=Wo,Jn=n(),gt=a("p"),gt.textContent=Zo,In=n(),yt=a("ul"),yt.innerHTML=Xo,kn=n(),Pt=a("p"),Pt.textContent=Oo,Sn=n(),Mt=a("p"),Mt.textContent=qo,An=n(),Tt=a("ul"),Tt.innerHTML=Yo,Vn=n(),bt=a("p"),bt.innerHTML=Ko,En=n(),xt=a("p"),xt.innerHTML=er,Nn=n(),Ct=a("p"),Ct.textContent=tr,Rn=n(),Ut=a("p"),Ut.innerHTML=lr,zn=n(),H=a("div"),H.innerHTML=sr,Bn=n(),_t=a("p"),_t.textContent=nr,Qn=n(),$t=a("p"),$t.innerHTML=ir,Fn=n(),c(Lt.$$.fragment),Wn=n(),jt=a("p"),jt.innerHTML=ar,Zn=n(),Dt=a("p"),Dt.innerHTML=or,Xn=n(),Ht=a("p"),Ht.textContent=rr,On=n(),G=a("div"),G.innerHTML=pr,qn=n(),Gt=a("p"),Gt.innerHTML=hr,Yn=n(),J=a("div"),J.innerHTML=mr,Kn=n(),Jt=a("p"),Jt.textContent=fr,ei=n(),I=a("div"),I.innerHTML=ur,ti=n(),It=a("p"),It.textContent=cr,li=n(),k=a("div"),k.innerHTML=dr,si=n(),kt=a("p"),kt.textContent=vr,ni=n(),St=a("p"),St.innerHTML=wr,ii=n(),At=a("p"),At.textContent=gr,ai=n(),Vt=a("ul"),Vt.innerHTML=yr,oi=n(),Et=a("p"),Et.textContent=Pr,ri=n(),Nt=a("ul"),Nt.innerHTML=Mr,pi=n(),Rt=a("p"),Rt.textContent=Tr,hi=n(),zt=a("p"),zt.textContent=br,mi=n(),Bt=a("ul"),Bt.innerHTML=xr,fi=n(),Qt=a("p"),Qt.innerHTML=Cr,ui=n(),c(Ft.$$.fragment),ci=n(),Wt=a("p"),Wt.innerHTML=Ur,di=n(),S=a("div"),S.innerHTML=_r,vi=n(),Zt=a("p"),Zt.textContent=$r,wi=n(),Xt=a("p"),Xt.textContent=Lr,gi=n(),Ot=a("p"),Ot.textContent=jr,yi=n(),qt=a("ul"),qt.innerHTML=Dr,Pi=n(),Yt=a("p"),Yt.textContent=Hr,Mi=n(),c(Kt.$$.fragment),Ti=n(),el=a("p"),el.textContent=Gr,bi=n(),A=a("div"),A.innerHTML=Jr,xi=n(),tl=a("p"),tl.innerHTML=Ir,Ci=n(),ll=a("p"),ll.textContent=kr,Ui=n(),sl=a("p"),sl.textContent=Sr,_i=n(),nl=a("ul"),nl.innerHTML=Ar,$i=n(),il=a("p"),il.textContent=Vr,Li=n(),c(al.$$.fragment),ji=n(),ol=a("p"),ol.innerHTML=Er,Di=n(),rl=a("p"),rl.textContent=Nr,Hi=n(),pl=a("p"),pl.textContent=Rr,Gi=n(),hl=a("p"),hl.innerHTML=zr,Ji=n(),ml=a("p"),ml.textContent=Br,Ii=n(),fl=a("p"),fl.textContent=Qr,ki=n(),ul=a("p"),ul.textContent=Fr,Si=n(),cl=a("ul"),cl.innerHTML=Wr,Ai=n(),dl=a("p"),dl.textContent=Zr,Vi=n(),vl=a("ul"),vl.innerHTML=Xr,Ei=n(),wl=a("p"),wl.textContent=Or,Ni=n(),c(gl.$$.fragment),Ri=n(),yl=a("p"),yl.innerHTML=qr,zi=n(),Pl=a("p"),Pl.innerHTML=Yr,Bi=n(),Ml=a("p"),Ml.textContent=Kr,Qi=n(),Tl=a("ol"),Tl.innerHTML=ep,Fi=n(),bl=a("p"),bl.textContent=tp,Wi=n(),xl=a("ul"),xl.innerHTML=lp,Zi=n(),Cl=a("p"),Cl.textContent=sp,Xi=n(),Ul=a("ul"),Ul.innerHTML=np,Oi=n(),_l=a("p"),_l.textContent=ip,qi=n(),$l=a("ul"),$l.innerHTML=ap,Yi=n(),Ll=a("p"),Ll.textContent=op,Ki=n(),jl=a("ul"),jl.innerHTML=rp,ea=n(),Dl=a("p"),Dl.textContent=pp,ta=n(),V=a("div"),V.innerHTML=hp,la=n(),Hl=a("p"),Hl.textContent=mp,sa=n(),Gl=a("p"),Gl.textContent=fp,na=n(),Jl=a("p"),Jl.textContent=up,ia=n(),Il=a("p"),Il.innerHTML=cp,aa=n(),c(kl.$$.fragment),oa=n(),Sl=a("p"),Sl.innerHTML=dp,ra=n(),c(Al.$$.fragment),pa=n(),Vl=a("p"),Vl.textContent=vp,ha=n(),c(E.$$.fragment),ma=n(),c(El.$$.fragment),fa=n(),Nl=a("p"),Nl.innerHTML=wp,ua=n(),c(Rl.$$.fragment),ca=n(),zl=a("p"),zl.innerHTML=gp,da=n(),c(Bl.$$.fragment),va=n(),Ql=a("p"),Ql.innerHTML=yp,wa=n(),c(Fl.$$.fragment),ga=n(),c(N.$$.fragment),ya=n(),Wl=a("p"),Wl.innerHTML=Pp,Pa=n(),Zl=a("ol"),Zl.innerHTML=Mp,Ma=n(),c(Xl.$$.fragment),Ta=n(),R=a("ol"),R.innerHTML=Tp,ba=n(),c(Ol.$$.fragment),xa=n(),ql=a("p"),ql.innerHTML=bp,Ca=n(),es=a("p"),this.h()},l(e){const t=Gp("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(l),M=i(e),f=o(e,"P",{}),$p(f).forEach(l),u=i(e),d(P.$$.fragment,e),h=i(e),m=o(e,"P",{"data-svelte-h":!0}),r(m)!=="svelte-pmpw5m"&&(m.innerHTML=b),z=i(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-6u57b2"&&(_.textContent=Kl),ts=i(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1fmi0j5"&&(B.innerHTML=La),ls=i(e),d($.$$.fragment,e),ss=i(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-k4erla"&&(Q.textContent=ja),ns=i(e),d(F.$$.fragment,e),is=i(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-vl1lph"&&(W.innerHTML=Da),as=i(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-exgbxp"&&(Z.innerHTML=Ha),os=i(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1ld98nk"&&(X.textContent=Ga),rs=i(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-owu077"&&(O.innerHTML=Ja),ps=i(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-108eswe"&&(q.textContent=Ia),hs=i(e),Y=o(e,"OL",{"data-svelte-h":!0}),r(Y)!=="svelte-17djrzw"&&(Y.innerHTML=ka),ms=i(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1pjlj4x"&&(K.innerHTML=Sa),fs=i(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1vvmjdr"&&(ee.textContent=Aa),us=i(e),te=o(e,"OL",{"data-svelte-h":!0}),r(te)!=="svelte-1s0wp36"&&(te.innerHTML=Va),cs=i(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-g99shh"&&(le.textContent=Ea),ds=i(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-bg5rkn"&&(se.textContent=Na),vs=i(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1vlifqo"&&(ne.innerHTML=Ra),ws=i(e),ie=o(e,"OL",{"data-svelte-h":!0}),r(ie)!=="svelte-12kjlqq"&&(ie.innerHTML=za),gs=i(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-ym8ubp"&&(ae.innerHTML=Ba),ys=i(e),oe=o(e,"UL",{"data-svelte-h":!0}),r(oe)!=="svelte-1dtz42n"&&(oe.innerHTML=Qa),Ps=i(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-4bia72"&&(re.textContent=Fa),Ms=i(e),d(pe.$$.fragment,e),Ts=i(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1017dvy"&&(he.innerHTML=Wa),bs=i(e),d(me.$$.fragment,e),xs=i(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1j6eoys"&&(fe.textContent=Za),Cs=i(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1v8b0bi"&&(ue.innerHTML=Xa),Us=i(e),ce=o(e,"UL",{"data-svelte-h":!0}),r(ce)!=="svelte-ibjm0a"&&(ce.innerHTML=Oa),_s=i(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-2za96j"&&(de.innerHTML=qa),$s=i(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1e3g0sm"&&(ve.textContent=Ya),Ls=i(e),we=o(e,"OL",{"data-svelte-h":!0}),r(we)!=="svelte-n1bojj"&&(we.innerHTML=Ka),js=i(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1yk5hqh"&&(ge.textContent=eo),Ds=i(e),ye=o(e,"OL",{"data-svelte-h":!0}),r(ye)!=="svelte-1glndlp"&&(ye.innerHTML=to),Hs=i(e),Pe=o(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-tn8imq"&&(Pe.innerHTML=lo),Gs=i(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-196u8fm"&&(Me.textContent=so),Js=i(e),Te=o(e,"UL",{"data-svelte-h":!0}),r(Te)!=="svelte-1p9lena"&&(Te.innerHTML=no),Is=i(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-lyxecx"&&(be.innerHTML=io),ks=i(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1ccu14e"&&(xe.textContent=ao),Ss=i(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1cuy4x"&&(Ce.innerHTML=oo),As=i(e),d(Ue.$$.fragment,e),Vs=i(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-ady25n"&&(_e.innerHTML=ro),Es=i(e),d($e.$$.fragment,e),Ns=i(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1bcmt3e"&&(Le.innerHTML=po),Rs=i(e),d(je.$$.fragment,e),zs=i(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-ammqnu"&&(De.textContent=ho),Bs=i(e),He=o(e,"TABLE",{"data-svelte-h":!0}),r(He)!=="svelte-1glyygb"&&(He.innerHTML=mo),Qs=i(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-3h79hx"&&(Ge.textContent=fo),Fs=i(e),d(Je.$$.fragment,e),Ws=i(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-rus1tj"&&(Ie.innerHTML=uo),Zs=i(e),L=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(L)!=="svelte-l6ikqh"&&(L.innerHTML=co),Xs=i(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1n0hd1i"&&(ke.innerHTML=vo),Os=i(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-yml45c"&&(Se.textContent=wo),qs=i(e),d(Ae.$$.fragment,e),Ys=i(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-ycp41i"&&(Ve.textContent=go),Ks=i(e),d(Ee.$$.fragment,e),en=i(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-vhaef9"&&(Ne.textContent=yo),tn=i(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-v79p4j"&&(Re.textContent=Po),ln=i(e),d(ze.$$.fragment,e),sn=i(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1x8bz4m"&&(Be.textContent=Mo),nn=i(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-9s70m2"&&(Qe.innerHTML=To),an=i(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-18avb09"&&(Fe.textContent=bo),on=i(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-ptnnl0"&&(We.textContent=xo),rn=i(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1e42x7e"&&(Ze.textContent=Co),pn=i(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1qw37a5"&&(Xe.textContent=Uo),hn=i(e),d(j.$$.fragment,e),mn=i(e),Oe=o(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-3x8lv3"&&(Oe.textContent=_o),fn=i(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1b2mzqh"&&(qe.textContent=$o),un=i(e),Ye=o(e,"UL",{"data-svelte-h":!0}),r(Ye)!=="svelte-a0zshu"&&(Ye.innerHTML=Lo),cn=i(e),d(Ke.$$.fragment,e),dn=i(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-byke96"&&(et.innerHTML=jo),vn=i(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-kfubqe"&&(tt.textContent=Do),wn=i(e),d(lt.$$.fragment,e),gn=i(e),st=o(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-vd21sy"&&(st.textContent=Ho),yn=i(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-vjztmh"&&(nt.textContent=Go),Pn=i(e),it=o(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1l6dgyv"&&(it.textContent=Jo),Mn=i(e),at=o(e,"UL",{"data-svelte-h":!0}),r(at)!=="svelte-19omdeq"&&(at.innerHTML=Io),Tn=i(e),ot=o(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1yzyde0"&&(ot.textContent=ko),bn=i(e),rt=o(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-1lu2bt6"&&(rt.innerHTML=So),xn=i(e),D=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(D)!=="svelte-1zwet4"&&(D.innerHTML=Ao),Cn=i(e),pt=o(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-10mywh3"&&(pt.textContent=Vo),Un=i(e),ht=o(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-qcenct"&&(ht.innerHTML=Eo),_n=i(e),mt=o(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-q4rot4"&&(mt.innerHTML=No),$n=i(e),ft=o(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1qpt7zo"&&(ft.innerHTML=Ro),Ln=i(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1g0sf3v"&&(ut.innerHTML=zo),jn=i(e),ct=o(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-18mmroz"&&(ct.textContent=Bo),Dn=i(e),dt=o(e,"UL",{"data-svelte-h":!0}),r(dt)!=="svelte-1m54oo0"&&(dt.innerHTML=Qo),Hn=i(e),vt=o(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-3pifdn"&&(vt.textContent=Fo),Gn=i(e),wt=o(e,"UL",{"data-svelte-h":!0}),r(wt)!=="svelte-p13wwf"&&(wt.innerHTML=Wo),Jn=i(e),gt=o(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-5h607a"&&(gt.textContent=Zo),In=i(e),yt=o(e,"UL",{"data-svelte-h":!0}),r(yt)!=="svelte-n2xihd"&&(yt.innerHTML=Xo),kn=i(e),Pt=o(e,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-1xvp26s"&&(Pt.textContent=Oo),Sn=i(e),Mt=o(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1b2mzqh"&&(Mt.textContent=qo),An=i(e),Tt=o(e,"UL",{"data-svelte-h":!0}),r(Tt)!=="svelte-1kewxhh"&&(Tt.innerHTML=Yo),Vn=i(e),bt=o(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-zuoye1"&&(bt.innerHTML=Ko),En=i(e),xt=o(e,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-1nopw2u"&&(xt.innerHTML=er),Nn=i(e),Ct=o(e,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-1djad0c"&&(Ct.textContent=tr),Rn=i(e),Ut=o(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-vnarcr"&&(Ut.innerHTML=lr),zn=i(e),H=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(H)!=="svelte-xyuwxq"&&(H.innerHTML=sr),Bn=i(e),_t=o(e,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-19x9s0e"&&(_t.textContent=nr),Qn=i(e),$t=o(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-1q9n35q"&&($t.innerHTML=ir),Fn=i(e),d(Lt.$$.fragment,e),Wn=i(e),jt=o(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-1fj06i7"&&(jt.innerHTML=ar),Zn=i(e),Dt=o(e,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-1ktbklq"&&(Dt.innerHTML=or),Xn=i(e),Ht=o(e,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-250ai3"&&(Ht.textContent=rr),On=i(e),G=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(G)!=="svelte-1ugxk60"&&(G.innerHTML=pr),qn=i(e),Gt=o(e,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-s73n1q"&&(Gt.innerHTML=hr),Yn=i(e),J=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-gpv8h8"&&(J.innerHTML=mr),Kn=i(e),Jt=o(e,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-1lnmjiw"&&(Jt.textContent=fr),ei=i(e),I=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(I)!=="svelte-yslb0f"&&(I.innerHTML=ur),ti=i(e),It=o(e,"P",{"data-svelte-h":!0}),r(It)!=="svelte-8jgntx"&&(It.textContent=cr),li=i(e),k=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(k)!=="svelte-b5xtwy"&&(k.innerHTML=dr),si=i(e),kt=o(e,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-kplhah"&&(kt.textContent=vr),ni=i(e),St=o(e,"P",{"data-svelte-h":!0}),r(St)!=="svelte-hmoxa9"&&(St.innerHTML=wr),ii=i(e),At=o(e,"P",{"data-svelte-h":!0}),r(At)!=="svelte-1ma7lah"&&(At.textContent=gr),ai=i(e),Vt=o(e,"UL",{"data-svelte-h":!0}),r(Vt)!=="svelte-p60tn3"&&(Vt.innerHTML=yr),oi=i(e),Et=o(e,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-1b2mzqh"&&(Et.textContent=Pr),ri=i(e),Nt=o(e,"UL",{"data-svelte-h":!0}),r(Nt)!=="svelte-sudg8s"&&(Nt.innerHTML=Mr),pi=i(e),Rt=o(e,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-xqarbt"&&(Rt.textContent=Tr),hi=i(e),zt=o(e,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-1g6ovc1"&&(zt.textContent=br),mi=i(e),Bt=o(e,"UL",{"data-svelte-h":!0}),r(Bt)!=="svelte-13k8bts"&&(Bt.innerHTML=xr),fi=i(e),Qt=o(e,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-f1rs41"&&(Qt.innerHTML=Cr),ui=i(e),d(Ft.$$.fragment,e),ci=i(e),Wt=o(e,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-1oq9xy9"&&(Wt.innerHTML=Ur),di=i(e),S=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(S)!=="svelte-jbayi"&&(S.innerHTML=_r),vi=i(e),Zt=o(e,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-1xg3nfy"&&(Zt.textContent=$r),wi=i(e),Xt=o(e,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-4rkar7"&&(Xt.textContent=Lr),gi=i(e),Ot=o(e,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-1b2mzqh"&&(Ot.textContent=jr),yi=i(e),qt=o(e,"UL",{"data-svelte-h":!0}),r(qt)!=="svelte-1ry6c7"&&(qt.innerHTML=Dr),Pi=i(e),Yt=o(e,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-9dc2gy"&&(Yt.textContent=Hr),Mi=i(e),d(Kt.$$.fragment,e),Ti=i(e),el=o(e,"P",{"data-svelte-h":!0}),r(el)!=="svelte-fz9fyw"&&(el.textContent=Gr),bi=i(e),A=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(A)!=="svelte-4i6t8z"&&(A.innerHTML=Jr),xi=i(e),tl=o(e,"P",{"data-svelte-h":!0}),r(tl)!=="svelte-18bvwlv"&&(tl.innerHTML=Ir),Ci=i(e),ll=o(e,"P",{"data-svelte-h":!0}),r(ll)!=="svelte-1hp29wn"&&(ll.textContent=kr),Ui=i(e),sl=o(e,"P",{"data-svelte-h":!0}),r(sl)!=="svelte-1b2mzqh"&&(sl.textContent=Sr),_i=i(e),nl=o(e,"UL",{"data-svelte-h":!0}),r(nl)!=="svelte-3ic0jq"&&(nl.innerHTML=Ar),$i=i(e),il=o(e,"P",{"data-svelte-h":!0}),r(il)!=="svelte-r6xwz8"&&(il.textContent=Vr),Li=i(e),d(al.$$.fragment,e),ji=i(e),ol=o(e,"P",{"data-svelte-h":!0}),r(ol)!=="svelte-7uwyc9"&&(ol.innerHTML=Er),Di=i(e),rl=o(e,"P",{"data-svelte-h":!0}),r(rl)!=="svelte-172u2n6"&&(rl.textContent=Nr),Hi=i(e),pl=o(e,"P",{"data-svelte-h":!0}),r(pl)!=="svelte-mgnvai"&&(pl.textContent=Rr),Gi=i(e),hl=o(e,"P",{"data-svelte-h":!0}),r(hl)!=="svelte-bdt2fr"&&(hl.innerHTML=zr),Ji=i(e),ml=o(e,"P",{"data-svelte-h":!0}),r(ml)!=="svelte-q3kikv"&&(ml.textContent=Br),Ii=i(e),fl=o(e,"P",{"data-svelte-h":!0}),r(fl)!=="svelte-s2rtor"&&(fl.textContent=Qr),ki=i(e),ul=o(e,"P",{"data-svelte-h":!0}),r(ul)!=="svelte-1b2mzqh"&&(ul.textContent=Fr),Si=i(e),cl=o(e,"UL",{"data-svelte-h":!0}),r(cl)!=="svelte-o5zp0z"&&(cl.innerHTML=Wr),Ai=i(e),dl=o(e,"P",{"data-svelte-h":!0}),r(dl)!=="svelte-1grbiex"&&(dl.textContent=Zr),Vi=i(e),vl=o(e,"UL",{"data-svelte-h":!0}),r(vl)!=="svelte-1oyel1u"&&(vl.innerHTML=Xr),Ei=i(e),wl=o(e,"P",{"data-svelte-h":!0}),r(wl)!=="svelte-r6xwz8"&&(wl.textContent=Or),Ni=i(e),d(gl.$$.fragment,e),Ri=i(e),yl=o(e,"P",{"data-svelte-h":!0}),r(yl)!=="svelte-121cfuq"&&(yl.innerHTML=qr),zi=i(e),Pl=o(e,"P",{"data-svelte-h":!0}),r(Pl)!=="svelte-dou7hg"&&(Pl.innerHTML=Yr),Bi=i(e),Ml=o(e,"P",{"data-svelte-h":!0}),r(Ml)!=="svelte-oa098n"&&(Ml.textContent=Kr),Qi=i(e),Tl=o(e,"OL",{"data-svelte-h":!0}),r(Tl)!=="svelte-6cxs64"&&(Tl.innerHTML=ep),Fi=i(e),bl=o(e,"P",{"data-svelte-h":!0}),r(bl)!=="svelte-kvfsh7"&&(bl.textContent=tp),Wi=i(e),xl=o(e,"UL",{"data-svelte-h":!0}),r(xl)!=="svelte-1734ihx"&&(xl.innerHTML=lp),Zi=i(e),Cl=o(e,"P",{"data-svelte-h":!0}),r(Cl)!=="svelte-jsce61"&&(Cl.textContent=sp),Xi=i(e),Ul=o(e,"UL",{"data-svelte-h":!0}),r(Ul)!=="svelte-ilmkvr"&&(Ul.innerHTML=np),Oi=i(e),_l=o(e,"P",{"data-svelte-h":!0}),r(_l)!=="svelte-w2gbdo"&&(_l.textContent=ip),qi=i(e),$l=o(e,"UL",{"data-svelte-h":!0}),r($l)!=="svelte-dyjda9"&&($l.innerHTML=ap),Yi=i(e),Ll=o(e,"P",{"data-svelte-h":!0}),r(Ll)!=="svelte-1qwl5bi"&&(Ll.textContent=op),Ki=i(e),jl=o(e,"UL",{"data-svelte-h":!0}),r(jl)!=="svelte-bzftse"&&(jl.innerHTML=rp),ea=i(e),Dl=o(e,"P",{"data-svelte-h":!0}),r(Dl)!=="svelte-pn1yl1"&&(Dl.textContent=pp),ta=i(e),V=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(V)!=="svelte-1jywqo8"&&(V.innerHTML=hp),la=i(e),Hl=o(e,"P",{"data-svelte-h":!0}),r(Hl)!=="svelte-11n85y7"&&(Hl.textContent=mp),sa=i(e),Gl=o(e,"P",{"data-svelte-h":!0}),r(Gl)!=="svelte-13bz10s"&&(Gl.textContent=fp),na=i(e),Jl=o(e,"P",{"data-svelte-h":!0}),r(Jl)!=="svelte-iohzxv"&&(Jl.textContent=up),ia=i(e),Il=o(e,"P",{"data-svelte-h":!0}),r(Il)!=="svelte-so3ryv"&&(Il.innerHTML=cp),aa=i(e),d(kl.$$.fragment,e),oa=i(e),Sl=o(e,"P",{"data-svelte-h":!0}),r(Sl)!=="svelte-18jn5v3"&&(Sl.innerHTML=dp),ra=i(e),d(Al.$$.fragment,e),pa=i(e),Vl=o(e,"P",{"data-svelte-h":!0}),r(Vl)!=="svelte-1tfztmr"&&(Vl.textContent=vp),ha=i(e),d(E.$$.fragment,e),ma=i(e),d(El.$$.fragment,e),fa=i(e),Nl=o(e,"P",{"data-svelte-h":!0}),r(Nl)!=="svelte-1gq2rbv"&&(Nl.innerHTML=wp),ua=i(e),d(Rl.$$.fragment,e),ca=i(e),zl=o(e,"P",{"data-svelte-h":!0}),r(zl)!=="svelte-1jed3my"&&(zl.innerHTML=gp),da=i(e),d(Bl.$$.fragment,e),va=i(e),Ql=o(e,"P",{"data-svelte-h":!0}),r(Ql)!=="svelte-waga1j"&&(Ql.innerHTML=yp),wa=i(e),d(Fl.$$.fragment,e),ga=i(e),d(N.$$.fragment,e),ya=i(e),Wl=o(e,"P",{"data-svelte-h":!0}),r(Wl)!=="svelte-qvyxrz"&&(Wl.innerHTML=Pp),Pa=i(e),Zl=o(e,"OL",{"data-svelte-h":!0}),r(Zl)!=="svelte-dqc5mg"&&(Zl.innerHTML=Mp),Ma=i(e),d(Xl.$$.fragment,e),Ta=i(e),R=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(R)!=="svelte-7l4syx"&&(R.innerHTML=Tp),ba=i(e),d(Ol.$$.fragment,e),xa=i(e),ql=o(e,"P",{"data-svelte-h":!0}),r(ql)!=="svelte-xdw23d"&&(ql.innerHTML=bp),Ca=i(e),es=o(e,"P",{}),$p(es).forEach(l),this.h()},h(){U(p,"name","hf:doc:metadata"),U(p,"content",Bp),U(L,"class","flex justify-center"),U(D,"class","flex justify-center"),U(H,"class","flex justify-center"),U(G,"class","flex justify-center"),U(J,"class","flex justify-center"),U(I,"class","flex justify-center"),U(k,"class","flex justify-center"),U(S,"class","flex justify-center"),U(A,"class","flex justify-center"),U(V,"class","flex justify-center"),U(R,"start","2")},m(e,t){Jp(document.head,p),s(e,M,t),s(e,f,t),s(e,u,t),v(P,e,t),s(e,h,t),s(e,m,t),s(e,z,t),s(e,_,t),s(e,ts,t),s(e,B,t),s(e,ls,t),v($,e,t),s(e,ss,t),s(e,Q,t),s(e,ns,t),v(F,e,t),s(e,is,t),s(e,W,t),s(e,as,t),s(e,Z,t),s(e,os,t),s(e,X,t),s(e,rs,t),s(e,O,t),s(e,ps,t),s(e,q,t),s(e,hs,t),s(e,Y,t),s(e,ms,t),s(e,K,t),s(e,fs,t),s(e,ee,t),s(e,us,t),s(e,te,t),s(e,cs,t),s(e,le,t),s(e,ds,t),s(e,se,t),s(e,vs,t),s(e,ne,t),s(e,ws,t),s(e,ie,t),s(e,gs,t),s(e,ae,t),s(e,ys,t),s(e,oe,t),s(e,Ps,t),s(e,re,t),s(e,Ms,t),v(pe,e,t),s(e,Ts,t),s(e,he,t),s(e,bs,t),v(me,e,t),s(e,xs,t),s(e,fe,t),s(e,Cs,t),s(e,ue,t),s(e,Us,t),s(e,ce,t),s(e,_s,t),s(e,de,t),s(e,$s,t),s(e,ve,t),s(e,Ls,t),s(e,we,t),s(e,js,t),s(e,ge,t),s(e,Ds,t),s(e,ye,t),s(e,Hs,t),s(e,Pe,t),s(e,Gs,t),s(e,Me,t),s(e,Js,t),s(e,Te,t),s(e,Is,t),s(e,be,t),s(e,ks,t),s(e,xe,t),s(e,Ss,t),s(e,Ce,t),s(e,As,t),v(Ue,e,t),s(e,Vs,t),s(e,_e,t),s(e,Es,t),v($e,e,t),s(e,Ns,t),s(e,Le,t),s(e,Rs,t),v(je,e,t),s(e,zs,t),s(e,De,t),s(e,Bs,t),s(e,He,t),s(e,Qs,t),s(e,Ge,t),s(e,Fs,t),v(Je,e,t),s(e,Ws,t),s(e,Ie,t),s(e,Zs,t),s(e,L,t),s(e,Xs,t),s(e,ke,t),s(e,Os,t),s(e,Se,t),s(e,qs,t),v(Ae,e,t),s(e,Ys,t),s(e,Ve,t),s(e,Ks,t),v(Ee,e,t),s(e,en,t),s(e,Ne,t),s(e,tn,t),s(e,Re,t),s(e,ln,t),v(ze,e,t),s(e,sn,t),s(e,Be,t),s(e,nn,t),s(e,Qe,t),s(e,an,t),s(e,Fe,t),s(e,on,t),s(e,We,t),s(e,rn,t),s(e,Ze,t),s(e,pn,t),s(e,Xe,t),s(e,hn,t),v(j,e,t),s(e,mn,t),s(e,Oe,t),s(e,fn,t),s(e,qe,t),s(e,un,t),s(e,Ye,t),s(e,cn,t),v(Ke,e,t),s(e,dn,t),s(e,et,t),s(e,vn,t),s(e,tt,t),s(e,wn,t),v(lt,e,t),s(e,gn,t),s(e,st,t),s(e,yn,t),s(e,nt,t),s(e,Pn,t),s(e,it,t),s(e,Mn,t),s(e,at,t),s(e,Tn,t),s(e,ot,t),s(e,bn,t),s(e,rt,t),s(e,xn,t),s(e,D,t),s(e,Cn,t),s(e,pt,t),s(e,Un,t),s(e,ht,t),s(e,_n,t),s(e,mt,t),s(e,$n,t),s(e,ft,t),s(e,Ln,t),s(e,ut,t),s(e,jn,t),s(e,ct,t),s(e,Dn,t),s(e,dt,t),s(e,Hn,t),s(e,vt,t),s(e,Gn,t),s(e,wt,t),s(e,Jn,t),s(e,gt,t),s(e,In,t),s(e,yt,t),s(e,kn,t),s(e,Pt,t),s(e,Sn,t),s(e,Mt,t),s(e,An,t),s(e,Tt,t),s(e,Vn,t),s(e,bt,t),s(e,En,t),s(e,xt,t),s(e,Nn,t),s(e,Ct,t),s(e,Rn,t),s(e,Ut,t),s(e,zn,t),s(e,H,t),s(e,Bn,t),s(e,_t,t),s(e,Qn,t),s(e,$t,t),s(e,Fn,t),v(Lt,e,t),s(e,Wn,t),s(e,jt,t),s(e,Zn,t),s(e,Dt,t),s(e,Xn,t),s(e,Ht,t),s(e,On,t),s(e,G,t),s(e,qn,t),s(e,Gt,t),s(e,Yn,t),s(e,J,t),s(e,Kn,t),s(e,Jt,t),s(e,ei,t),s(e,I,t),s(e,ti,t),s(e,It,t),s(e,li,t),s(e,k,t),s(e,si,t),s(e,kt,t),s(e,ni,t),s(e,St,t),s(e,ii,t),s(e,At,t),s(e,ai,t),s(e,Vt,t),s(e,oi,t),s(e,Et,t),s(e,ri,t),s(e,Nt,t),s(e,pi,t),s(e,Rt,t),s(e,hi,t),s(e,zt,t),s(e,mi,t),s(e,Bt,t),s(e,fi,t),s(e,Qt,t),s(e,ui,t),v(Ft,e,t),s(e,ci,t),s(e,Wt,t),s(e,di,t),s(e,S,t),s(e,vi,t),s(e,Zt,t),s(e,wi,t),s(e,Xt,t),s(e,gi,t),s(e,Ot,t),s(e,yi,t),s(e,qt,t),s(e,Pi,t),s(e,Yt,t),s(e,Mi,t),v(Kt,e,t),s(e,Ti,t),s(e,el,t),s(e,bi,t),s(e,A,t),s(e,xi,t),s(e,tl,t),s(e,Ci,t),s(e,ll,t),s(e,Ui,t),s(e,sl,t),s(e,_i,t),s(e,nl,t),s(e,$i,t),s(e,il,t),s(e,Li,t),v(al,e,t),s(e,ji,t),s(e,ol,t),s(e,Di,t),s(e,rl,t),s(e,Hi,t),s(e,pl,t),s(e,Gi,t),s(e,hl,t),s(e,Ji,t),s(e,ml,t),s(e,Ii,t),s(e,fl,t),s(e,ki,t),s(e,ul,t),s(e,Si,t),s(e,cl,t),s(e,Ai,t),s(e,dl,t),s(e,Vi,t),s(e,vl,t),s(e,Ei,t),s(e,wl,t),s(e,Ni,t),v(gl,e,t),s(e,Ri,t),s(e,yl,t),s(e,zi,t),s(e,Pl,t),s(e,Bi,t),s(e,Ml,t),s(e,Qi,t),s(e,Tl,t),s(e,Fi,t),s(e,bl,t),s(e,Wi,t),s(e,xl,t),s(e,Zi,t),s(e,Cl,t),s(e,Xi,t),s(e,Ul,t),s(e,Oi,t),s(e,_l,t),s(e,qi,t),s(e,$l,t),s(e,Yi,t),s(e,Ll,t),s(e,Ki,t),s(e,jl,t),s(e,ea,t),s(e,Dl,t),s(e,ta,t),s(e,V,t),s(e,la,t),s(e,Hl,t),s(e,sa,t),s(e,Gl,t),s(e,na,t),s(e,Jl,t),s(e,ia,t),s(e,Il,t),s(e,aa,t),v(kl,e,t),s(e,oa,t),s(e,Sl,t),s(e,ra,t),v(Al,e,t),s(e,pa,t),s(e,Vl,t),s(e,ha,t),v(E,e,t),s(e,ma,t),v(El,e,t),s(e,fa,t),s(e,Nl,t),s(e,ua,t),v(Rl,e,t),s(e,ca,t),s(e,zl,t),s(e,da,t),v(Bl,e,t),s(e,va,t),s(e,Ql,t),s(e,wa,t),v(Fl,e,t),s(e,ga,t),v(N,e,t),s(e,ya,t),s(e,Wl,t),s(e,Pa,t),s(e,Zl,t),s(e,Ma,t),v(Xl,e,t),s(e,Ta,t),s(e,R,t),s(e,ba,t),v(Ol,e,t),s(e,xa,t),s(e,ql,t),s(e,Ca,t),s(e,es,t),Ua=!0},p(e,[t]){const xp={};t&2&&(xp.$$scope={dirty:t,ctx:e}),$.$set(xp);const Cp={};t&2&&(Cp.$$scope={dirty:t,ctx:e}),j.$set(Cp);const Up={};t&2&&(Up.$$scope={dirty:t,ctx:e}),E.$set(Up);const _p={};t&2&&(_p.$$scope={dirty:t,ctx:e}),N.$set(_p)},i(e){Ua||(w(P.$$.fragment,e),w($.$$.fragment,e),w(F.$$.fragment,e),w(pe.$$.fragment,e),w(me.$$.fragment,e),w(Ue.$$.fragment,e),w($e.$$.fragment,e),w(je.$$.fragment,e),w(Je.$$.fragment,e),w(Ae.$$.fragment,e),w(Ee.$$.fragment,e),w(ze.$$.fragment,e),w(j.$$.fragment,e),w(Ke.$$.fragment,e),w(lt.$$.fragment,e),w(Lt.$$.fragment,e),w(Ft.$$.fragment,e),w(Kt.$$.fragment,e),w(al.$$.fragment,e),w(gl.$$.fragment,e),w(kl.$$.fragment,e),w(Al.$$.fragment,e),w(E.$$.fragment,e),w(El.$$.fragment,e),w(Rl.$$.fragment,e),w(Bl.$$.fragment,e),w(Fl.$$.fragment,e),w(N.$$.fragment,e),w(Xl.$$.fragment,e),w(Ol.$$.fragment,e),Ua=!0)},o(e){g(P.$$.fragment,e),g($.$$.fragment,e),g(F.$$.fragment,e),g(pe.$$.fragment,e),g(me.$$.fragment,e),g(Ue.$$.fragment,e),g($e.$$.fragment,e),g(je.$$.fragment,e),g(Je.$$.fragment,e),g(Ae.$$.fragment,e),g(Ee.$$.fragment,e),g(ze.$$.fragment,e),g(j.$$.fragment,e),g(Ke.$$.fragment,e),g(lt.$$.fragment,e),g(Lt.$$.fragment,e),g(Ft.$$.fragment,e),g(Kt.$$.fragment,e),g(al.$$.fragment,e),g(gl.$$.fragment,e),g(kl.$$.fragment,e),g(Al.$$.fragment,e),g(E.$$.fragment,e),g(El.$$.fragment,e),g(Rl.$$.fragment,e),g(Bl.$$.fragment,e),g(Fl.$$.fragment,e),g(N.$$.fragment,e),g(Xl.$$.fragment,e),g(Ol.$$.fragment,e),Ua=!1},d(e){e&&(l(M),l(f),l(u),l(h),l(m),l(z),l(_),l(ts),l(B),l(ls),l(ss),l(Q),l(ns),l(is),l(W),l(as),l(Z),l(os),l(X),l(rs),l(O),l(ps),l(q),l(hs),l(Y),l(ms),l(K),l(fs),l(ee),l(us),l(te),l(cs),l(le),l(ds),l(se),l(vs),l(ne),l(ws),l(ie),l(gs),l(ae),l(ys),l(oe),l(Ps),l(re),l(Ms),l(Ts),l(he),l(bs),l(xs),l(fe),l(Cs),l(ue),l(Us),l(ce),l(_s),l(de),l($s),l(ve),l(Ls),l(we),l(js),l(ge),l(Ds),l(ye),l(Hs),l(Pe),l(Gs),l(Me),l(Js),l(Te),l(Is),l(be),l(ks),l(xe),l(Ss),l(Ce),l(As),l(Vs),l(_e),l(Es),l(Ns),l(Le),l(Rs),l(zs),l(De),l(Bs),l(He),l(Qs),l(Ge),l(Fs),l(Ws),l(Ie),l(Zs),l(L),l(Xs),l(ke),l(Os),l(Se),l(qs),l(Ys),l(Ve),l(Ks),l(en),l(Ne),l(tn),l(Re),l(ln),l(sn),l(Be),l(nn),l(Qe),l(an),l(Fe),l(on),l(We),l(rn),l(Ze),l(pn),l(Xe),l(hn),l(mn),l(Oe),l(fn),l(qe),l(un),l(Ye),l(cn),l(dn),l(et),l(vn),l(tt),l(wn),l(gn),l(st),l(yn),l(nt),l(Pn),l(it),l(Mn),l(at),l(Tn),l(ot),l(bn),l(rt),l(xn),l(D),l(Cn),l(pt),l(Un),l(ht),l(_n),l(mt),l($n),l(ft),l(Ln),l(ut),l(jn),l(ct),l(Dn),l(dt),l(Hn),l(vt),l(Gn),l(wt),l(Jn),l(gt),l(In),l(yt),l(kn),l(Pt),l(Sn),l(Mt),l(An),l(Tt),l(Vn),l(bt),l(En),l(xt),l(Nn),l(Ct),l(Rn),l(Ut),l(zn),l(H),l(Bn),l(_t),l(Qn),l($t),l(Fn),l(Wn),l(jt),l(Zn),l(Dt),l(Xn),l(Ht),l(On),l(G),l(qn),l(Gt),l(Yn),l(J),l(Kn),l(Jt),l(ei),l(I),l(ti),l(It),l(li),l(k),l(si),l(kt),l(ni),l(St),l(ii),l(At),l(ai),l(Vt),l(oi),l(Et),l(ri),l(Nt),l(pi),l(Rt),l(hi),l(zt),l(mi),l(Bt),l(fi),l(Qt),l(ui),l(ci),l(Wt),l(di),l(S),l(vi),l(Zt),l(wi),l(Xt),l(gi),l(Ot),l(yi),l(qt),l(Pi),l(Yt),l(Mi),l(Ti),l(el),l(bi),l(A),l(xi),l(tl),l(Ci),l(ll),l(Ui),l(sl),l(_i),l(nl),l($i),l(il),l(Li),l(ji),l(ol),l(Di),l(rl),l(Hi),l(pl),l(Gi),l(hl),l(Ji),l(ml),l(Ii),l(fl),l(ki),l(ul),l(Si),l(cl),l(Ai),l(dl),l(Vi),l(vl),l(Ei),l(wl),l(Ni),l(Ri),l(yl),l(zi),l(Pl),l(Bi),l(Ml),l(Qi),l(Tl),l(Fi),l(bl),l(Wi),l(xl),l(Zi),l(Cl),l(Xi),l(Ul),l(Oi),l(_l),l(qi),l($l),l(Yi),l(Ll),l(Ki),l(jl),l(ea),l(Dl),l(ta),l(V),l(la),l(Hl),l(sa),l(Gl),l(na),l(Jl),l(ia),l(Il),l(aa),l(oa),l(Sl),l(ra),l(pa),l(Vl),l(ha),l(ma),l(fa),l(Nl),l(ua),l(ca),l(zl),l(da),l(va),l(Ql),l(wa),l(ga),l(ya),l(Wl),l(Pa),l(Zl),l(Ma),l(Ta),l(R),l(ba),l(xa),l(ql),l(Ca),l(es)),l(p),y(P,e),y($,e),y(F,e),y(pe,e),y(me,e),y(Ue,e),y($e,e),y(je,e),y(Je,e),y(Ae,e),y(Ee,e),y(ze,e),y(j,e),y(Ke,e),y(lt,e),y(Lt,e),y(Ft,e),y(Kt,e),y(al,e),y(gl,e),y(kl,e),y(Al,e),y(E,e),y(El,e),y(Rl,e),y(Bl,e),y(Fl,e),y(N,e),y(Xl,e),y(Ol,e)}}}const Bp='{"title":"Efficient Training on Multiple GPUs","local":"efficient-training-on-multiple-gpus","sections":[{"title":"Scalability strategy","local":"scalability-strategy","sections":[],"depth":2},{"title":"Data Parallelism","local":"data-parallelism","sections":[{"title":"DataParallel vs DistributedDataParallel","local":"dataparallel-vs-distributeddataparallel","sections":[],"depth":3}],"depth":2},{"title":"ZeRO Data Parallelism","local":"zero-data-parallelism","sections":[],"depth":2},{"title":"From Naive Model Parallelism to Pipeline Parallelism","local":"from-naive-model-parallelism-to-pipeline-parallelism","sections":[],"depth":2},{"title":"Tensor Parallelism","local":"tensor-parallelism","sections":[],"depth":2},{"title":"Data Parallelism + Pipeline Parallelism","local":"data-parallelism--pipeline-parallelism","sections":[],"depth":2},{"title":"Data Parallelism + Pipeline Parallelism + Tensor Parallelism","local":"data-parallelism--pipeline-parallelism--tensor-parallelism","sections":[],"depth":2},{"title":"ZeRO Data Parallelism + Pipeline Parallelism + Tensor Parallelism","local":"zero-data-parallelism--pipeline-parallelism--tensor-parallelism","sections":[],"depth":2},{"title":"FlexFlow","local":"flexflow","sections":[],"depth":2},{"title":"GPU selection","local":"gpu-selection","sections":[{"title":"Number of GPUs","local":"number-of-gpus","sections":[],"depth":3},{"title":"Order of GPUs","local":"order-of-gpus","sections":[],"depth":3}],"depth":2}],"depth":1}';function Qp(T){return jp(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yp extends Dp{constructor(p){super(),Hp(this,p,Qp,zp,Lp,{})}}export{Yp as component};
