import{s as Gs,f as Ss,o as Vs,n as Xs}from"../chunks/scheduler.36a0863c.js";import{S as Ys,i as Fs,g as a,s as n,r as p,A as Os,h as r,f as i,c as o,j as Es,u as m,x as s,k as w,y as Ks,a as l,v as u,d as c,t as d,w as M}from"../chunks/index.9c13489a.js";import{H as v,g as ep}from"../chunks/Heading.eab17db2.js";import{T as tp}from"../chunks/Tip.3b06990e.js";import{C as f}from"../chunks/CodeBlock.05d8ec32.js";function ip(Ri){let g,I="Nel caso siate su Windows, sostituite <code>RUN_SLOW=1</code> con <code>SET RUN_SLOW=1</code>";return{c(){g=a("p"),g.innerHTML=I},l(T){g=r(T,"P",{"data-svelte-h":!0}),s(g)!=="svelte-1gsy2xt"&&(g.innerHTML=I)},m(T,Qi){l(T,g,Qi)},p:Xs,d(T){T&&i(g)}}}function lp(Ri){let g,I,T,Qi,L,qi,z,da=`Aggiungere un nuovo modello é spesso difficile e richiede una profonda conoscenza della libreria 🤗 Transformers e anche
della repository originale del modello. A Hugging Face cerchiamo di dare alla community sempre piú poteri per aggiungere
modelli independentemente. Quindi, per alcuni nuovi modelli che la community vuole aggiungere a 🤗 Transformers, abbiamo
creato una specifica <em>call-for-model-addition</em> che spiega passo dopo passo come aggiungere il modello richiesto. Con
questo <em>call-for-model-addition</em> vogliamo insegnare a volenterosi e esperti collaboratori della community come implementare
un modello in 🤗 Transformers.`,Ei,$,Ma=`Se questo é qualcosa che può interessarvi, siete liberi di controllare l’attuale “calls-for-model-addition” <a href="https://github.com/huggingface/transformers/tree/main/templates/adding_a_new_model/open_model_proposals/README.md" rel="nofollow">qui</a>
e contattarci.`,Gi,k,fa=`Se il modello sarà selezionato, allora potrete lavorare insieme a un membro di Hugging Face per integrare il modello in 🤗
Transformers. Così facendo, ci guadagnerai in una comprensione totale, sia teorica che pratica, del modello proposto. Inoltre,
sarai l’artefice di un importante contributo open-source a 🤗 Transformers. Durante l’implementazione avrai l’opportunità di:`,Si,x,ga="<li>ottenere più comprensione delle best practices in open-source</li> <li>capire i principi di design di una della librerie NLP più popolari</li> <li>capire come efficientemente testare complessi modelli NLP</li> <li>capire come integrare utilit Python come <code>black</code>, <code>ruff</code>, <code>make fix-copies</code> in una libreria per garantire sempre di avere un codice leggibile e pulito</li>",Vi,A,Ta=`Siamo anche contenti se vuoi aggiungere un modello che non può essere trovato nella cartella “calls-for-model-addition”.
Le seguenti sezioni spiegano in dettaglio come aggiungere un nuovo modello. Può anche essere molto utile controllare modelli
già aggiunti <a href="https://github.com/huggingface/transformers/pulls?q=is%3Apr+label%3A%22PR+for+Model+Addition%22+is%3Aclosed" rel="nofollow">qui</a>,
per capire se richiamano il modello che vorreste aggiungere.`,Xi,H,va="Per cominciare, vediamo una panoramica general della libreria Transformers.",Yi,N,Fi,P,wa=`Prima di tutto, vediamo in generale 🤗 Transformers. 🤗 Transformers é una libreria molto strutturata, quindi
puà essere che a volte ci sia un disaccordo con alcune filosofie della libreria o scelte di design. Dalla nostra esperienza,
tuttavia, abbiamo trovato che le scelte fondamentali di design della libreria sono cruciali per usare 🤗 Transformers efficacemente
su larga scala, mantenendo i costi a un livello accettabile.`,Oi,B,ba=`Un buon primo punto di partenza per capire al meglio la libreria é leggere la <a href="filosofia">documentazione sulla nostra filosofia</a>
Da qui, ci sono alcune scelte sul modo di lavorare che cerchiamo di applicare a tutti i modelli:`,Ki,Z,ya=`<li>La composizione é generalmente favorita sulla sovra-astrazione</li> <li>Duplicare il codice non é sempre male, soprattutto se migliora notevolmente la leggibilità e accessibilità del modello</li> <li>Tutti i files creati per il nuovo modello devono il piu possibile “compatti”. Questo vuol dire che quando qualcuno leggerá il codice
di uno specifico modello, potrá vedere solo il corrispettivo file <code>modeling_....py</code> senza avere multiple dipendenze.</li>`,el,Q,ha=`La cosa piú importante, é che consideriamo la libreria non solo un mezzo per dare un prodotto, <em>per esempio</em> dare la possibilità
di usare BERT per inferenza, ma é anche il prodotto reale che noi vogliamo migliorare sempre più. Quindi, quando aggiungi
un modello, non sei solo la persona che userà il modello, ma rappresenti anche tutti coloro che leggeranno,
cercheranno di capire e modificare il tuo modello.`,tl,W,Ja="Tenendo questi principi in mente, immergiamoci nel design generale della libreria.",il,D,ll,R,Ca=`Per aggiungere con successo un modello, é importante capire l’interazione tra il tuo modello e la sua configurazione,
<code>PreTrainedModel</code>, e <code>PretrainedConfig</code>. Per dare un esempio, chiameremo il modello da aggiungere a 🤗 Transformers<br/> <code>BrandNewBert</code>.`,nl,q,ja="Diamo un’occhiata:",ol,Wi,Ua,al,E,_a=`Come potete vedere, ci basiamo sull’ereditarietà in 🤗 Transformers, tenendo però il livello di astrazione a un minimo
assoluto.  Non ci sono mai più di due livelli di astrazione per ogni modello nella libreria. <code>BrandNewBertModel</code> eredita
da <code>BrandNewBertPreTrainedModel</code> che, a sua volta, eredita da <code>PreTrainedModel</code> -  semplice no?
Come regola generale, vogliamo essere sicuri che un nuovo modello dipenda solo da <code>PreTrainedModel</code>. Le funzionalità
importanti che sono automaticamente conferite a ogni nuovo modello sono <code>from_pretrained()</code>
e <code>save_pretrained()</code>, che sono usate per serializzazione e deserializzazione. Tutte le altre importanti
funzionalità, come ad esempio <code>BrandNewBertModel.forward</code> devono essere definite completamente nel nuovo script
<code>modeling_brand_new_bert.py</code>. Inoltre, vogliamo essere sicuri che un modello con uno specifico head layer, come
<code>BrandNewBertForMaskedLM</code> non erediti da <code>BrandNewBertModel</code>, ma piuttosto usi <code>BrandNewBertModel</code>
come componente che può essere chiamata nel passaggio forward per mantenere il livello di astrazione basso. Ogni
nuovo modello richieste una classe di configurazione, chiamata <code>BrandNewBertConfig</code>. Questa configurazione é sempre
mantenuta come un attributo in <code>PreTrainedModel</code>, e quindi può essere accessibile tramite l’attributo <code>config</code>
per tutte le classi che ereditano da <code>BrandNewBertPreTrainedModel</code>:`,rl,G,sl,S,Ia=`Analogamente al modello, la configurazione eredita le funzionalità base di serializzazione e deserializzazione da
<code>PretrainedConfig</code>. É da notare che la configurazione e il modello sono sempre serializzati in due formati differenti -
il modello é serializzato in un file <em>pytorch_model.bin</em> mentre la configurazione con <em>config.json</em>. Chiamando
<code>save_pretrained()</code> automaticamente chiamerà <code>save_pretrained()</code>, cosicché sia il
modello che la configurazione siano salvati.`,pl,V,ml,X,La=`Quando codifichi un nuovo modello, tieni presente che Transformers ha una sua struttura di fondo come libreria, perciò
ci sono alcuni fatti da considerare su come scrivere un codice :-)`,ul,Y,za=`<li>Il forward pass del tuo modello dev’essere scritto completamente nel file del modello, mentre dev’essere indipendente
da altri modelli nella libreria. Se vuoi riutilizzare un blocco di codice da un altro modello, copia e incolla il codice con un commento <code># Copied from</code> in cima al codice (guarda <a href="https://github.com/huggingface/transformers/blob/v4.17.0/src/transformers/models/roberta/modeling_roberta.py#L160" rel="nofollow">qui</a>
per un ottimo esempio).</li> <li>Il codice dev’essere interamente comprensibile, anche da persone che non parlano in inglese. Questo significa che le
variabili devono avere un nome descrittivo e bisogna evitare abbreviazioni. Per esempio, <code>activation</code> é molto meglio
che <code>act</code>. Le variabili con una lettera sono da evitare fortemente, almeno che non sia per un indce in un for loop.</li> <li>Generamente é meglio avere un codice esplicito e piú lungo che un codice corto e magico.</li> <li>Evita di subclassare <code>nn.Sequential</code> in Pytorch, puoi subclassare <code>nn.Module</code> e scrivere il forward pass, cosicché
chiunque può effettuare debug sul tuo codice, aggiungendo print o breaking points.</li> <li>La tua function-signature dev’essere type-annoted. Per il resto, é meglio preferire variabili con un nome accettabile
piuttosto che annotazioni per aumentare la comprensione e leggibilità del codice.</li>`,cl,F,dl,O,$a="Questa sezione sarà creata al piu presto :-(",Ml,K,fl,ee,ka="Ci sono differenti modi per aggiungere un modello a Hugging Face. Qui trovi una lista di blog posts da parte della community su come aggiungere un modello:",gl,te,xa='<li><a href="https://medium.com/huggingface/from-tensorflow-to-pytorch-265f40ef2a28" rel="nofollow">Aggiungere GPT2</a> scritto da <a href="https://huggingface.co/thomwolf" rel="nofollow">Thomas</a></li> <li><a href="https://huggingface.co/blog/porting-fsmt" rel="nofollow">Aggiungere WMT19 MT</a> scritto da <a href="https://huggingface.co/stas" rel="nofollow">Stas</a></li>',Tl,ie,Aa="Per esperienza, possiamo dirti che quando si aggiunge un modello é meglio tenere a mente le seguenti considerazioni:",vl,le,Ha=`<li>Non sfondare una porta giá aperta! La maggior parte del codice che aggiungerai per un nuovo modello 🤗 Transformers
esiste già da qualche parte in 🤗 Transformers. Prendi un po’ di tempo per trovare codici simili in modelli e tokenizers esistenti e fare un copia-incolla. Ricorda che <a href="https://www.gnu.org/software/grep/" rel="nofollow">grep</a> e <a href="https://github.com/BurntSushi/ripgrep" rel="nofollow">rg</a> sono tuoi buoni amici. Inoltre, ricorda che puó essere molto probabile che il tokenizer per il tuo modello sia basato sull’implementazione di un altro modello, e il codice del tuo modello stesso su un altro ancora. <em>Per esempio</em> il modello FSMT é basato su BART, mentre il tokenizer di FSMT é basato su XLM.</li> <li>Ricorda che qui é piu una sfida ingegneristica che scientifica. Spendi piú tempo per create un efficiente ambiente di debugging piuttosto che cercare di capire tutti gli aspetti teorici dell’articolo del modello.</li> <li>Chiedi aiuto se sei in panne! I modelli sono la parte principale di 🤗 Transformers, perciò qui a Hugging Face siamo più che contenti di aiutarti in ogni passo per aggiungere il tuo modello. Non esitare a chiedere se vedi che non riesci a progredire.</li>`,wl,ne,Na="Di seguito, diamo una ricetta generale per aiutare a portare un modello in 🤗 Transformers.",bl,oe,Pa="La lista seguente é un sommario di tutto quello che é stato fatto per aggiungere un modello, e può essere usata come To-Do List:",yl,ae,Ba='<li><ol><li>☐ (Opzionale) Capire gli aspetti teorici del modello</li></ol></li> <li><ol start="2"><li>☐ Preparare l’ambiente dev per transformers</li></ol></li> <li><ol start="3"><li>☐ Preparare l’ambiente debugging della repository originale</li></ol></li> <li><ol start="4"><li>☐ Create uno script che gestisca con successo il forward pass usando la repository originale e checkpoint</li></ol></li> <li><ol start="5"><li>☐ Aggiungere con successo lo scheletro del modello a Transformers</li></ol></li> <li><ol start="6"><li>☐ Convertire i checkpoint original a Transformers checkpoint</li></ol></li> <li><ol start="7"><li>☐ Effettuare con successo la forward pass in Transformers, di modo che dia un output identico al checkpoint originale</li></ol></li> <li><ol start="8"><li>☐ Finire i tests per il modello in Transformers</li></ol></li> <li><ol start="9"><li>☐ Aggiungere con successo Tokenizer in Transformers</li></ol></li> <li><ol start="10"><li>☐ Testare e provare gli integration tests da capo a fine</li></ol></li> <li><ol start="11"><li>☐ Completare i docs</li></ol></li> <li><ol start="12"><li>☐ Caricare i moedl weights all’hub</li></ol></li> <li><ol start="13"><li>☐ Sottomettere una pull request</li></ol></li> <li><ol start="14"><li>☐ (Opzionale) Aggiungere un notebook con una demo</li></ol></li>',hl,re,Za="Per cominciare di solito consigliamo <code>BrandNewBert</code>, partendo dalla teoria, di modo da avere una buona comprensione della teoria generale. TUttavia, se preferisci imparare l’aspetto teorico del modello mentre <em>lavori</em> sul modello é ok immergersi direttamente nel codice di <code>BrandNewBert</code>. Questa opzione puó essere buona se le tue skills ingegneristiche sono meglio che quelle teoriche, o se il paper <code>BrandNewBert</code> ti dá problemi, o se semplicemente ti piace programmare piú che leggere articoli scientifici.",Jl,se,Cl,pe,Qa="Allora con calma, prendi un po’ di tempo per leggere l’articolo su <em>BrandNewBert</em> . Sicuramente, alcune sezioni dell’articolo sono molto complesse, ma non preoccuparti! L’obiettivo non é avere una compresione immensa della teoria alla base, ma estrarre le informazioni necessarie per re-implementare con successo il modello in 🤗 Transformers. Quindi, non impazzire sugli aspetti teorici, ma piuttosto focalizzati su quelli pratici, ossia:",jl,me,Wa='<li>Che tipo di modello é <em>brand_new_bert</em>? É solo un encoder in stile BERT? O tipo decoder come GPT2? O encoder e decoder stile BART? Dai un’occhiata a <a href="model_summary">model_summary</a> se non sei famigliare con le differenze tra questi modelli</li> <li>Quali sono le applicazioni di <em>brand_new_bert</em>? Classificazione di testo? Generazione di testo? O per tasks del genere seq2seq?</li> <li>Quali sono le nuove aggiunte al modello che lo rendono diverso da BERT/GPT-2/BART?</li> <li>Quali modelli estistenti in <a href="https://huggingface.co/transformers/#contents" rel="nofollow">🤗 Transformers models</a> sono molto simili a <em>brand_new_bert</em>?</li> <li>Che tipo di tokenizer si usa in questo caso? Un sentencepiece tokenizer? O un word piece tokenizer? Il tokenizer é lo stesso di BERT o BART?</li>',Ul,ue,Da="Una volta che senti che hai avuto una bella overview dell’architettura del modello, puoi scrivere senza problemi al team di Hugging Face per ogni domanda che tu hai. Questo puó includere domande sull’architettura del modello, o sull’attention layer, etc. Saremo molto felici di aiutarti :)",_l,ce,Il,de,Ra='<li><p>Forka la <a href="https://github.com/huggingface/transformers" rel="nofollow">repository</a> cliccando sul tasto ‘Fork’ nella pagina della repository. Questo crea una copia del codice nel tuo account GitHub</p></li> <li><p>Clona il tuo fork <code>transfomers</code> sul tuo dico locale, e aggiungi la repository base come remota:</p></li>',Ll,Me,zl,b,qa="<li>Crea un ambiente di sviluppo, per esempio tramite questo comando:</li>",$l,fe,kl,ge,Ea="quindi torna alla directory principale:",xl,Te,Al,y,Ga='<li>Attenzione, raccomandiamo di aggiungere la versione di PyTorch di <em>brand_new_bert</em> a Transfomers. Per installare PyTorch, basta seguire queste istruzioni <a href="https://pytorch.org/get-started/locally/" rel="nofollow">https://pytorch.org/get-started/locally/</a>.</li>',Hl,ve,Sa="<strong>Nota bene:</strong> Non c’é bisogno di installare o avere installato CUDA. Il nuovo modello può funzionare senza problemi su una CPU.",Nl,h,Va="<li>Per trasferire <em>brand_new_bert</em> To port <em>brand_new_bert</em> avrai bisogno anche accesso alla sua repository originale:</li>",Pl,we,Bl,be,Xa="Ok, ora hai un ambiente di sviluppo per portare <em>brand_new_bert</em> in 🤗 Transformers.",Zl,ye,Ql,he,Ya="Per cominciare, comincerai a lavorare sulla repo originale di <em>brand_new_bert</em>. Come spesso accade, l’implementazione originale é molto sullo stile “ricerca”. Questo significa che a volte la documentazione non é al top, magari manca qualche cosa e il codice puó essere difficile da capire. Tuttavia, questa é e dev’essere la motivazione per reimplementare <em>brand_new_bert</em>. In Hugging Face, uno degli obiettivi principali é di <em>mettere le persone sulle spalle dei giganti</em>, il che si traduce, in questo contesto, di prendere un modello funzionante e riscriverlo e renderlo il piú possibile <strong>accessibile, user-friendly, e leggibile</strong>. Questa é la top motivazione per re-implementare modelli in 🤗 Transformers - cercare di creare nuove complesse tecnologie NLP accessibili a <strong>chiunque</strong>.",Wl,Je,Fa="Riuscire a far girare il modello pretrained originale dalla repository ufficiale é spesso il passo <strong>piu arduo</strong>. Dalla nostra esperienza, é molto importante spendere un p’ di tempo per diventare familiari con il codice base originale. Come test, prova a capire i seguenti punti:",Dl,Ce,Oa="<li>Dove si trovano i pretrained weights?</li> <li>Come caricare i pretrained weights nel modello corrispondente?</li> <li>Come girare un tokenizer independentemente dal modello?</li> <li>Prova a tracciare un singolo forward pass, cosicché potrai sapere che classi e funzioni sono richieste per un semplice forward pass. Di solito, dovrai reimplementare queste funzioni e basta</li> <li>Prova a localizzare i componenti importanti del modello: Dove si trova la classe del modello? Ci sono sotto classi nel modello <em>per esempio</em> EngoderModel, DecoderMOdel? Dove si trova il self-attention layer? Ci sono molteplici differenti layer di attention, <em>per esempio</em> <em>self-attention</em>, <em>cross-attention</em>…?</li> <li>Come puoi fare debug sul modello nell’ambiente originale della repo? Devi aggiungere dei <em>print</em> o puoi usare <em>ipdb</em> come debugger interattivo, o vabene anche un IDE efficiente per debug come PyCharm?</li>",Rl,je,Ka="É molto importante che prima di cominciare a trasferire il modello nuovo tu spenda tempo a fare debug del codice originale in maniera <strong>efficiente</strong>! Inoltre, ricorda che tutta la library é open-soruce, quindi non temere di aprire issue o fare una pull request nella repo originale. Tutti coloro che mantengono la repository saranno piú che felici di avere qualcuno che guarda e gioca con i loro codici!",ql,Ue,er="A questo punto, sta a te decidere quale ambiente per debug vuoi usare. Noi consilgiamo di evitare setup con GPU, che potrebbero costare assai, lavorare su una CPU puó essere un ottimo punto di partenza per indagare la repository originale e per cominciare a scrivere il codice per 🤗 Transformers. Solo alla fine, quando il modello é stato portato con successo in  🤗 Transformers, allora si potrá verificare il suo funzionamento su GPU.",El,_e,tr="In generale ci sono due possibili ambienti di debug per il testare il modello originale:",Gl,Ie,ir='<li><a href="https://jupyter.org/" rel="nofollow">Jupyter notebooks</a> / <a href="https://colab.research.google.com/notebooks/intro.ipynb" rel="nofollow">google colab</a></li> <li>Scripts locali in Python</li>',Sl,Le,lr="Il vantaggio dei Jupyter notebooks é la possibilità di eseguire cella per cella, il che può essere utile per decomporre tutte le componenti logiche, cosi da a vere un ciclo di debug più rapido, siccome si possono salvare i risultati da steps intermedi. Inoltre, i notebooks spesso sono molto facili da condividere con altri contributors, il che può essere molto utile se vuoi chiedere aiuto al team di Hugging Face. Se sei famigliare con Jupyter notebooks allora racommandiamo di lavorare in questa maniera.",Vl,ze,nr="Ovviamente se non siete abituati a lavorare con i notebook, questo può essere uno svantaggio nell’usare questa tecnologia, sprecando un sacco di tempo per setup e portare tutto al nuovo ambiente, siccome non potreste neanche usare dei tools di debug come <code>ipdb</code>.",Xl,$e,or="Per ogni pratica code-base, é sempre meglio come primo step caricare un <strong>piccolo</strong> checkpoint pretrained e cercare di riprodurre un singolo forward pass usando un vettore fittizio di IDs fatti da numeri interi. Un esempio per uno script simile, in pseudocodice é:",Yl,ke,Fl,xe,ar="Per quanto riguarda la strategia di debugging, si può scegliere tra:",Ol,Ae,rr=`<li>Decomporre il modello originario in piccole componenenti e testare ognuna di esse</li> <li>Decomporre il modello originario nel <em>tokenizer</em> originale e nel <em>modello</em> originale, testare un forward pass su questi,
e usare dei print statement o breakpoints intermedi per verificare</li>`,Kl,He,sr=`Ancora una volta, siete liberi di scegliere quale strategia sia ottimale per voi. Spesso una strategia é piu
avvantaggiosa di un’altra, ma tutto dipende dall’code-base originario.`,en,Ne,pr=`Se il code-base vi permette di decomporre il modello in piccole sub-componenenti, <em>per esempio</em> se il code-base
originario può essere facilmente testato in eager mode, allora vale la pena effettuare un debugging di questo genere.
Ricordate che ci sono dei vantaggi nel decidere di prendere la strada piu impegnativa sin da subito:`,tn,Pe,mr=`<li>negli stage piu finali, quando bisognerà comparare il modello originario all’implementazione in Hugging Face, potrete verificare
automaticamente ogni componente, individualmente, di modo che ci sia una corrispondenza 1:1</li> <li>avrete l’opportunità di decomporre un problema molto grande in piccoli passi, così da strutturare meglio il vostro lavoro</li> <li>separare il modello in componenti logiche vi aiuterà ad avere un’ottima overview sul design del modello, quindi una migliore
comprensione del modello stesso</li> <li>verso gli stage finali i test fatti componente per componente vi aiuterà ad essere sicuri di non andare avanti e indietro
nell’implementazione, così da continuare la modifica del codice senza interruzione</li>`,ln,Be,ur=`Un ottimo esempio di come questo può essere fatto é dato da <a href="https://gist.github.com/LysandreJik/db4c948f6b4483960de5cbac598ad4ed" rel="nofollow">Lysandre</a>
per il modello ELECTRA`,nn,Ze,cr=`Tuttavia, se il code-base originale é molto complesso o le componenti intermedie possono essere testate solo in tramite
compilazione, potrebbe richiedere parecchio tempo o addirittura essere impossibile separare il modello in piccole sotto-componenti.
Un buon esempio é <a href="https://github.com/tensorflow/mesh/tree/master/mesh_tensorflow" rel="nofollow">MeshTensorFlow di T5</a>. Questa libreria
é molto complessa e non offre un metodo semplice di decomposizione in sotto-componenti. Per simili librerie, potrete fare
affidamento ai print statements.`,on,Qe,dr=`In ogni caso, indipendentemente da quale strategia scegliete, la procedura raccomandata é di cominciare a fare debug dal
primo layer al layer finale.
É consigliato recuperare gli output dai layers, tramite print o sotto-componenti, nel seguente ordine:`,an,We,Mr="<li>Recuperare gli IDs di input dati al modello</li> <li>Recuperare i word embeddings</li> <li>Recuperare l’input del primo Transformer layer</li> <li>Recuperare l’output del primo Transformer layer</li> <li>Recuperare l’output dei seguenti <code>n - 1</code> Transformer layers</li> <li>Recuperare l’output dell’intero BrandNewBert Model</li>",rn,De,fr="Gli IDs in input dovrebbero essere un arrary di interi, <em>per esempio</em> <code>input_ids = [0, 4, 4, 3, 2, 4, 1, 7, 19]</code>",sn,Re,gr="Gli output dei seguenti layer di solito dovrebbero essere degli array di float multi-dimensionali come questo:",pn,qe,mn,Ee,Tr=`Ci aspettiamo che ogni modello aggiunto a 🤗 Transformers passi con successo un paio di test d’integrazione. Questo
significa che il modello originale e la sua implementazione in 🤗 Transformers abbiano lo stesso output con una precisione
di 0.001! Siccome é normale che lo stesso esatto modello, scritto in librerie diverse, possa dare output leggermente
diversi, la tolleranza accettata é 1e-3 (0.001). Ricordate che i due modelli devono dare output quasi identici. Dunque,
é molto conveniente comparare gli output intermedi di 🤗 Transformers molteplici volte con gli output intermedi del
modello originale di <em>brand_new_bert</em>. Di seguito vi diamo alcuni consigli per avere un ambiente di debug il piu efficiente
possibile:`,un,Ge,vr=`<li>Trovate la migliore strategia per fare debug dei risultati intermedi. Per esempio, é la repository originale scritta in PyTorch?
Se si, molto probabilmente dovrete dedicare un po’ di tempo per scrivere degli script piu lunghi, così da decomporre il
modello originale in piccole sotto-componenti, in modo da poter recuperare i valori intermedi. Oppure, la repo originale
é scritta in Tensorflow 1? Se é così dovrete fare affidamento ai print di Tensorflow <a href="https://www.tensorflow.org/api_docs/python/tf/print" rel="nofollow">tf.print</a>
per avere i valori intermedi. Altro caso, la repo é scritta in Jax? Allora assicuratevi che il modello non sia in <strong>jit</strong>
quanto testate il foward pass, <em>per esempio</em> controllate <a href="https://github.com/google/jax/issues/196" rel="nofollow">questo link</a>.</li> <li>Usate i più piccoli pretrained checkpoint che potete trovare. Piu piccolo é il checkpoint, piu velocemente sarà il vostro
ciclo di debug. Non é efficiente avere un pretrained model così gigante che per il forward pass impieghi piu di 10 secondi.
Nel caso in cui i checkpoints siano molto grandi, e non si possa trovare di meglio, allora é buona consuetudine ricorrere
a fare un dummy model nel nuovo ambiente, con weights inizializzati random e salvare quei weights per comprare la versione 🤗 Transformers
con il vostro modello</li> <li>Accertatevi di usare la via piu semplice per chiamare il forward pass nella repo originale. Sarebbe opportuno trovare
la funzione originaria che chiami <strong>solo</strong> un singolo forward pass, <em>per esempio</em> questa funzione spesso viene chiamata
<code>predict</code>, <code>evaluate</code>, <code>forward</code> o <code>__call__</code>. Siate sicuri di non fare debug su una funzione che chiami <code>forward</code> molteplici
volte, <em>per esempio</em> per generare testo, come <code>autoregressive_sample</code>, <code>generate</code>.</li> <li>Cercate di separare la tokenization dal forward pass del modello. Se la repo originaria mostra esempio dove potete dare
come input una stringa, provate a cercare dove nella forward call la stringa viene cambiata in input ids e cominciate il
debug da questo punto. Questo vi garantisce un ottimo punto di partenza per scrivere un piccolo script personale dove dare
gli input al modello, anziche delle stringhe in input.</li> <li>Assicuratevi che il debugging <strong>non</strong> sia in training mode. Spesso questo potra il modello a dare degli output random, per
via dei molteplici dropout layers. Assicuratevi che il forward pass nell’ambiente di debug sia <strong>deterministico</strong>, cosicche
i dropout non siano usati. Alternativamente, potete usare <em>transformers.utils.set_seed</em> se la vecchia e nuova implementazione
sono nello stesso framework.</li>`,cn,Se,wr="La seguente sezione vi da ulteriori dettagli e accorgimenti su come potete fare tutto questo per <em>brand_new_bert</em>.",dn,Ve,Mn,Xe,br="Allora cominciamo ad aggiungere un nuovo codice in 🤗 Transformers. Andate nel vostro fork clone di 🤗 Transformers:",fn,Ye,gn,Fe,yr=`Nel caso speciale in cui stiate aggiungendo un modello, la cui architettura sia identica a una di un modello già esistente,
dovrete solo aggiugnere uno script di conversione, come descritto <a href="#write-a-conversion-script">qui</a>.
In questo caso, potete riutilizzare l’intera architettura del modello gia esistente.`,Tn,Oe,hr="Se questo non é il caso, cominciamo con il generare un nuovo modello. Avrete due opzioni:",vn,Ke,Jr="<li><code>transformers-cli add-new-model-like</code> per aggiungere un nuovo modello come uno che gia esiste</li> <li><code>transformers-cli add-new-model</code> per aggiungere un nuovo modello da un nostro template (questo assomigliera a BERT o Bart, in base al modello che selezionerete)</li>",wn,et,Cr=`In entrambi i casi, l’output vi darà un questionario da riempire con informazioni basi sul modello. Il secondo comando richiede di installare
un <code>cookiecutter</code> - maggiori informazioni <a href="https://github.com/huggingface/transformers/tree/main/templates/adding_a_new_model" rel="nofollow">qui</a>.`,bn,tt,jr="<strong>Aprire una Pull Request in main huggingface/transformers repo</strong>",yn,it,Ur=`Prime di cominciare ad adattare il codice automaticamente generato, aprite una nuova PR come “Work in progress (WIP)“,
<em>per esempio</em> ”[WIP] Aggiungere <em>brand_new_bert</em>”, cosicché il team di Hugging Face possa lavorare al vostro fianco nell’
integrare il modello in 🤗 Transformers.`,hn,lt,_r="Questi sarebbero gli step generali da seguire:",Jn,nt,Ir="<li>Creare un branch dal main branch con un nome descrittivo</li>",Cn,ot,jn,J,Lr="<li>Commit del codice automaticamente generato</li>",Un,at,_n,C,zr="<li>Fare fetch e rebase del main esistente</li>",In,rt,Ln,j,$r="<li>Push dei cambiamenti al proprio account:</li>",zn,st,$n,U,kr=`<li><p>Una volte che siete soddisfatti dei nuovi cambiamenti, andate sulla webpage del vostro fork su GitHub. Cliccate “Pull request”.
Assiuratevi di aggiungere alcuni membri di Hugging Face come reviewers, nel riguardo alla destra della pagina della PR, cosicche il team
Hugging Face verrà notificato anche per i futuri cambiamenti.</p></li> <li><p>Cambiare la PR a draft, cliccando su “Convert to draft” alla destra della pagina della PR</p></li>`,kn,pt,xr=`Da quel punto in poi, ricordate di fare commit di ogni progresso e cambiamento, cosicche venga mostrato nella PR. Inoltre,
ricordatevi di tenere aggiornato il vostro lavoro con il main esistente:`,xn,mt,An,ut,Ar=`In generale, tutte le domande che avrete riguardo al modello o l’implementazione dovranno essere fatte nella vostra PR
e discusse/risolte nella PR stessa. In questa maniera, il team di Hugging Face sarà sempre notificato quando farete commit
di un nuovo codice o se avrete qualche domanda. É molto utile indicare al team di Hugging Face il codice a cui fate riferimento
nella domanda, cosicche il team potra facilmente capire il problema o la domanda.`,Hn,ct,Hr=`Per fare questo andate sulla tab “Files changed”, dove potrete vedere tutti i vostri cambiamenti al codice, andate sulla linea
dove volete chiedere una domanda, e cliccate sul simbolo ”+” per aggiungere un commento. Ogni volta che una domanda o problema
é stato risolto, cliccate sul bottone “Resolve”.`,Nn,dt,Nr=`In questa stessa maniera, Hugging Face aprirà domande o commenti nel rivedere il vostro codice. Mi raccomando, chiedete più
domande possibili nella pagina della vostra PR. Se avete domande molto generali, non molto utili per il pubblico, siete liberi
di chiedere al team Hugging Face direttamente su slack o email.`,Pn,Mt,Pr="<strong>5. Adattare i codici per brand_new_bert</strong>",Bn,ft,Br=`Per prima cosa, ci focalizzeremo sul modello e non sui tokenizer. Tutto il codice relative dovrebbe trovarsi in<br/> <code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code> e
<code>src/transformers/models/brand_new_bert/configuration_brand_new_bert.py</code>.`,Zn,gt,Zr=`Ora potete finalmente cominciare il codice :). Il codice generato in
<code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code> avrà sia la stessa architettura di BERT se é un
modello encoder-only o BART se é encoder-decoder. A questo punto, ricordatevi cio che avete imparato all’inizio, riguardo
agli aspetti teorici del modello: <em>In che maniera il modello che sto implmementando é diverso da BERT o BART?</em>. Implementare
questi cambi  spesso vuol dire cambiare il layer <em>self-attention</em>, l’ordine dei layer di normalizzazione e così via…
Ancora una volta ripetiamo, é molto utile vedere architetture simili di modelli gia esistenti in Transformers per avere
un’idea migliore su come implementare il modello.`,Qn,Tt,Qr=`<strong>Notate</strong> che a questo punto non dovete avere subito un codice tutto corretto o pulito. Piuttosto, é consigliato cominciare con un
codice poco pulito, con copia-incolla del codice originale in <code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code>
fino a che non avrete tutto il codice necessario. In base alla nostra esperienza, é molto meglio aggiungere una prima bozza
del codice richiesto e poi correggere e migliorare iterativamente. L’unica cosa essenziale che deve funzionare qui é la seguente
instanza:`,Wn,vt,Dn,wt,Wr=`Questo comando creerà un modello con i parametri di default definiti in <code>BrandNewBergConfig()</code> e weights random. Questo garantisce
che <code>init()</code> di tutte le componenti funzioni correttamente.`,Rn,bt,Dr="<strong>6. Scrivere uno script di conversione</strong>",qn,yt,Rr=`Il prossimo step é scrivere uno script per convertire il checkpoint che avete usato per fare debug su <em>brand_new_berts</em> nella
repo originale in un checkpoint per la nuova implementazione di <em>brand_new_bert</em> in 🤗 Transformers. Non é consigliato scrivere
lo script di conversione da zero, ma piuttosto cercate e guardate script gia esistenti in 🤗 Transformers, così da trovarne
uno simile al vostro modello. Di solito basta fare una copia di uno script gia esistente e adattarlo al vostro caso.
Non esistate a chiedre al team di Hugging Face a riguardo.`,En,ht,qr='<li>Se state convertendo un modello da TensorFlow a PyTorch, un ottimo inizio é vedere <a href="https://github.com/huggingface/transformers/blob/7acfa95afb8194f8f9c1f4d2c6028224dbed35a2/src/transformers/models/bert/modeling_bert.py#L91" rel="nofollow">questo script di conversione per BERT</a></li> <li>Se state convertendo un modello da PyTorch a PyTorch, <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/bart/convert_bart_original_pytorch_checkpoint_to_pytorch.py" rel="nofollow">lo script di conversione di BART può esservi utile</a></li>',Gn,Jt,Er=`Qui di seguito spiegheremo come i modelli PyTorch salvano i weights per ogni layer e come i nomi dei layer sono definiti. In PyTorch,
il nomde del layer é definito dal nome della class attribute che date al layer. Definiamo un modello dummy in PyTorch,
chiamato <code>SimpleModel</code>:`,Sn,Ct,Vn,jt,Gr=`Ora possiamo creare un’instanza di questa definizione di modo da inizializzare a random weights: <code>dense</code>, <code>intermediate</code>, <code>layer_norm</code>.
Possiamo usare print per vedere l’architettura del modello:`,Xn,Ut,Yn,_t,Sr="Da cui si ottiene:",Fn,It,On,Lt,Vr=`Si può vedere come i nomi dei layers siano definiti dal nome della class attribute in PyTorch. I valori dei weights di uno
specifico layer possono essere visualizzati:`,Kn,zt,eo,$t,Xr="ad esempio:",to,kt,io,xt,Yr=`Nello script di conversione, dovreste riempire quei valori di inizializzazione random con gli stessi weights del corrispondente
layer nel checkpoint. <em>Per esempio</em>`,lo,At,no,Ht,Fr=`Così facendo, dovete verificare che ogni inizializzazione random di un peso del modello PyTorch e il suo corrispondente peso nel pretrained checkpoint
siano esattamente gli stessi e uguali in <strong>dimensione/shape e nome</strong>. Per fare questo, é <strong>necessario</strong> aggiungere un <code>assert</code>
per la dimensione/shape e nome:`,oo,Nt,ao,Pt,Or="Inoltre, dovrete fare il print sia dei nomi che dei weights per essere sicuri che siano gli stessi:",ro,Bt,so,Zt,Kr=`Se la dimensione o il nome non sono uguali, probabilmente avete sbagliato ad assegnare il peso nel checkpoint o nel layer costrutture di
🤗 Transformers.`,po,Qt,es=`Una dimensione sbagliata può essere dovuta ad un errore nei parameteri in <code>BrandNewBertConfig()</code>. Tuttavia, può essere anche
che l’implementazione del layer in PyTorch richieda di fare una transposizione della matrice dei weights.`,mo,Wt,ts=`Infine, controllate <strong>tutti</strong> che tutti i weights inizializzati e fate print di tutti i weights del checkpoint che non sono stati
usati per l’inizializzazione, di modo da essere sicuri che il modello sia correttamente convertito. É normale che ci siano
errori nel test di conversione, fai per un errore in <code>BrandNewBertConfig()</code>, o un errore nell’architettura in 🤗 Transformers,
o un bug in <code>init()</code>.`,uo,Dt,is=`Questo step dev’essere fatto tramite iterazioni fino a che non si raggiungano gli stessi valori per i weights. Una volta che
il checkpoint é stato correttamente caricato in 🤗 Transformers, potete salvare il modello in una cartella di vostra scelta
<code>/path/to/converted/checkpoint/folder</code> che contenga sia
<code>pytorch_model.bin</code> che <code>config.json</code>:`,co,Rt,Mo,qt,ls="<strong>7. Implementare il forward pass</strong>",fo,Et,ns=`Una volta che i weights pretrained sono stati correttamente caricati in 🤗 Transformers, dovrete assicurarvi che il forward pass
sia correttamente implementato. <a href="#provare-un-pretrained-checkpoint-usando-la-repo-originale">Qui</a>, avete give creato e provato
uno script che testi il forward pass del modello usando la repo originaria. Ora dovrete fare lo stesso con uno script analogo
usando l’implementazione in 🤗 Transformers anziché l’originale. Piu o meno lo script dovrebbe essere:`,go,Gt,To,St,os=`Di solito l’output da 🤗 Transformers non é uguale uguale all’output originario, sopratto la prima volta. Non vi abbattete -
é normale! Prima di tutto assicuratevi che non ci siano errori o che non vengano segnalati degli errori nella forward pass.
Spesso capita che ci siano dimensioni sbagliate o data type sbagliati, <em>ad esempio</em> <code>torch.long</code> anziche <code>torch.float32</code>.
Non esistate a chiedere al team Hugging Face!`,vo,Vt,as=`Nella parte finale assicuratevi che l’implementazione 🤗 Transformers funzioni correttamente cosi da testare che gli output
siano equivalenti a una precisione di <code>1e-3</code>. Controllate che <code>outputs.shape</code> siano le stesse tra 🤗 Transformers e l’implementazione
originaria. Poi, controllate che i valori in output siano identici. Questa é sicuramente la parte più difficile, qui una serie
di errori comuni quando gli output non sono uguali:`,wo,Xt,rs=`<li>Alcuni layers non sono stati aggiunti, <em>ad esempio</em> un <em>activation</em> layer non é stato aggiunto, o ci si é scordati di una connessione</li> <li>La matrice del word embedding non é stata ripareggiata</li> <li>Ci sono degli embeddings posizionali sbagliati perché l’implementazione originaria ha un offset</li> <li>Il dropout é in azione durante il forward pass. Per sistemare questo errore controllate che <em>model.training = False</em> e che
il dropout non sia stato attivato nel forward pass, <em>per esempio</em> passate <em>self.training</em> a <a href="https://pytorch.org/docs/stable/nn.functional.html?highlight=dropout#torch.nn.functional.dropout" rel="nofollow">PyTorch’s functional dropout</a></li>`,bo,Yt,ss=`La miglior maniera per sistemare il problema é di vedere all’implementazione originaria del forward pass e in 🤗 Transformers
fianco a fianco e vedere se ci sono delle differenze. In teoria, con debug e print degli output intermedie di entrambe le
implementazioni nel forward pass nell’esatta posizione del network dovrebbe aiutarvi a vedere dove ci sono differenze tra
i due frameworks. Come prima mossa controllate che <code>input_ids</code> siano identici in entrambi gli scripts. Da lì andate fino
all’ultimo layer. Potrete notare una differenza tra le due implementazioni a quel punto.`,yo,Ft,ps=`Una volta che lo stesso output é stato ragguingi, verificate gli output con <code>torch.allclose(original_output, output, atol=1e-3)</code>.
A questo punto se é tutto a posto: complimenti! Le parti seguenti saranno una passeggiata 😊.`,ho,Ot,ms="<strong>8. Aggiungere i test necessari per il modello</strong>",Jo,Kt,us=`A questo punto avete aggiunto con successo il vostro nuovo modello. Tuttavia, é molto probabile che il modello non sia
del tutto ok con il design richiesto. Per essere sicuri che l’implementazione sia consona e compatibile con 🤗 Transformers é
necessario implementare dei tests. Il Cookiecutter dovrebbe fornire automaticamente dei file per test per il vostro modello,
di solito nella folder <code>tests/test_modeling_brand_new_bert.py</code>. Provate questo per verificare l’ok nei test piu comuni:`,Co,ei,jo,ti,cs="Una volta sistemati i test comuni, bisogna assicurarsi che il vostro lavoro sia correttamente testato cosicchè:",Uo,ii,ds="<li>a) La community puo capire in maniera semplice il vostro lavoro controllando tests specifici del modello <em>brand_new_bert</em>,</li> <li>b) Implementazioni future del vostro modello non rompano alcune feature importante del modello.</li>",_o,li,Ms=`Per prima cosa agguingete dei test d’integrazione. Questi sono essenziali perche fanno la stessa funzione degli scripts di
debug usati precedentemente. Un template per questi tests esiste gia nel Cookiecutter ed é sotto il nome di <code>BrandNewBertModelIntegrationTests</code>,
voi dovrete solo completarlo. Una volta che questi tests sono OK, provate:`,Io,ni,Lo,_,zo,oi,fs=`Di seguito, tutte le features che sono utili e necessarire per <em>brand_new_bert</em> devono essere testate in test separati,
contenuti in <code>BrandNewBertModelTester</code>/ <code>BrandNewBertModelTest</code>. spesso la gente si scorda questi test, ma ricordate che sono utili per:`,$o,ai,gs="<li>Aiuta gli utenti a capire il vostro codice meglio, richiamando l’attenzione su queste nuove features</li> <li>Developers e contributors futuri potranno velocemente testare nuove implementazioni del modello testanto questi casi speciali.</li>",ko,ri,Ts="<strong>9. Implementare il tokenizer</strong>",xo,si,vs="A questo punto avremo bisogno un tokenizer per <em>brand_new_bert</em>. Di solito il tokenizer é uguale ad altri modelli in 🤗 Transformers.",Ao,pi,ws="É importante che troviate il file con il tokenizer originale e che lo carichiate in 🤗 Transformers.",Ho,mi,bs=`Per controllare che il tokenizer funzioni in modo corretto, create uno script nella repo originaria che riceva come input
una stringa e ritorni gli <code>input_ids</code>. Piu o meno questo potrebbe essere il codice:`,No,ui,Po,ci,ys=`Potrebbe richiedere un po’ di tempo, ma guardate ancora alla repo originaria per trovare la funzione corretta del tokenizer.
A volte capita di dover riscrivere il tokenizer nella repo originaria, di modo da avere come output gli <code>input_ids</code>.
A quel punto uno script analogo é necessario in 🤗 Transformers:`,Bo,di,Zo,Mi,hs="Una volta che <code>input_ids</code> sono uguali, bisogna aggiungere un test per il tokenizer.",Qo,fi,Js="Il file test per tokenizer di <em>brand_new_brand</em> dovrebbe avere un paio di hard-coded test d’integrazione.",Wo,gi,Cs="<strong>10. Test end-to-end</strong>",Do,Ti,js=`Ora che avete il tokenizer, dovrete aggiungere dei test d’integrazione per l’intero workflow in <code>tests/test_modeling_brand_new_bert.py</code> in 🤗 Transformer.
Questi test devono mostrare che un significante campione text-to-text funzioni come ci si aspetta nell’implementazione di  🤗 Transformers.
<em>Per esempio</em> potreste usare dei source-to-target-translation, o un sommario di un articolo, o un domanda-risposta e cosi via.
Se nessuno dei checkpoints é stato ultra parametrizzato per task simili, allora i tests per il modello sono piu che sufficienti.
Nello step finale dovete assicurarvi che il modello sia totalmente funzionale, e consigliamo anche di provare a testare su GPU.
Puo succedere che ci si scordi un <code>.to(self.device)</code> ad esempio. Se non avete accesso a GPU, il team Hugging Face puo provvedere
a testare questo aspetto per voi.`,Ro,vi,Us="<strong>11. Aggiungere una Docstring</strong>",qo,wi,_s=`Siete quasi alla fine! L’ultima cosa rimasta é avere una bella docstring e una pagina doc. Il Cookiecutter dovrebbe provvedere già
un template chiamato <code>docs/source/model_doc/brand_new_bert.rst</code>, che dovrete compilare. La prima cosa che un utente farà
per usare il vostro modello sarà dare una bella lettura al doc. Quindi proponete una documentazione chiara e concisa. É molto
utile per la community avere anche delle <em>Tips</em> per mostrare come il modello puo’ essere usato. Non esitate a chiedere a Hugging Face
riguardo alle docstirng.`,Eo,bi,Is=`Quindi, assicuratevi che la docstring sia stata aggiunta a <code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code>.
Assicuratevi che la docstring sia corretta e che includa tutti i necessari input e output. Abbiamo una guida dettagliata per
scrivere la documentazione e docstring.`,Go,yi,Ls="<strong>Rifattorizzare il codice</strong>",So,hi,zs="Perfetto! Ora che abbiamo tutto per <em>brand_new_bert</em> controllate che lo stile del codice sia ok:",Vo,Ji,Xo,Ci,$s="E che il codice passi i quality check:",Yo,ji,Fo,Ui,ks=`A volte capita che manchino delle informazioninella docstring o alcuni nomi sbagliati, questo farà fallire i tests sopra.
Ripetiamo: chiedete pure a Hugging Face, saremo lieti di aiutarvi.`,Oo,_i,xs="Per ultimo, fare del refactoring del codice una volta che é stato creato.",Ko,Ii,As="Avete finito con il codice, congratulazioni! 🎉 Siete fantasticiiiiiii! 😎",ea,Li,Hs="<strong>12. Caricare il modello sul model hub</strong>",ta,zi,Ns=`In questa ultima parte dovrete convertire e caricare il modello, con tutti i checkpoints, nel model hub e aggiungere una
model card per ogni checkpoint caricato. Leggete la nostra guida <a href="model_sharing">Model sharing and uploading Page</a> per
avere familiarità con l’hub. Di solito in questa parte lavorate a fianco di Hugging face per decidere un nome che sia ok
per ogni checkpoint, per ottenere i permessi necessari per caricare il modello nell’organizzazione dell’autore di <em>brand_new_bert</em>.
Il metodo <code>push_to_hub</code>, presente in tutti i modelli <code>transformers</code>, é una maniera rapida e indolore per caricare il vostro checkpoint sull’hub:`,ia,$i,la,ki,Ps=`Vale la pena spendere un po’ di tempo per creare una model card ad-hoc per ogni checkpoint. Le model cards dovrebbero
suggerire le caratteristiche specifiche del checkpoint, <em>per esempio</em> su che dataset il checkpoint é stato pretrained o fine-tuned.
O che su che genere di task il modello lavoro? E anche buona pratica includere del codice su come usare il modello correttamente.`,na,xi,Bs="<strong>13. (Opzionale) Aggiungere un notebook</strong>",oa,Ai,Zs=`É molto utile aggiungere un notebook, che dimostri in dettaglio come <em>brand_new_bert</em> si utilizzi per fare inferenza e/o
fine-tuned su specifiche task. Non é una cosa obbligatoria da avere nella vostra PR, ma é molto utile per la community.`,aa,Hi,Qs="<strong>14. Sottomettere la PR</strong>",ra,Ni,Ws=`L’ultimissimo step! Ovvero il merge della PR nel main. Di solito il team Hugging face a questo punto vi avrà gia aiutato,
ma é ok prendere un po’ di tempo per pulire la descirzione e commenti nel codice.`,sa,Pi,pa,Bi,Ds=`É ora tempo di prendere un po’ di credito dalla communità per il vostro lavoro! Caricare e implementare un nuovo modello
é un grandissimo contributo per Transformers e l’intera community NLP. Il codice e la conversione dei modelli pre-trained sara
sicuramente utilizzato da centinaia o migliaia di sviluppatori e ricercatori. Siate fieri e orgogliosi di condividere il vostro
traguardo con l’intera community :)`,ma,Zi,Rs="<strong>Avete create un altro modello che é super facile da usare per tutti quanti nella community! 🤯</strong>",ua,Di,ca;return L=new v({props:{title:"Come aggiungere un modello a 🤗 Transformers?",local:"come-aggiungere-un-modello-a--transformers",headingTag:"h1"}}),N=new v({props:{title:"Panoramica generale su 🤗 Transformers",local:"panoramica-generale-su--transformers",headingTag:"h2"}}),D=new v({props:{title:"Panoramica sui modelli",local:"panoramica-sui-modelli",headingTag:"h3"}}),G=new f({props:{code:"bW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyYnJhbmR5JTJGYnJhbmRfbmV3X2JlcnQlMjIpJTBBbW9kZWwuY29uZmlnJTIwJTIwJTIzJTIwaWwlMjBtb2RlbGxvJTIwaGElMjBhY2Nlc3NvJTIwYWwlMjBzdW8lMjBjb25maWc=",highlighted:`model = BrandNewBertModel.from_pretrained(<span class="hljs-string">&quot;brandy/brand_new_bert&quot;</span>)
model.config  <span class="hljs-comment"># il modello ha accesso al suo config</span>`,wrap:!1}}),V=new v({props:{title:"Stile per il codice",local:"stile-per-il-codice",headingTag:"h3"}}),F=new v({props:{title:"Panoramica sui tokenizers",local:"panoramica-sui-tokenizers",headingTag:"h3"}}),K=new v({props:{title:"Aggiungere un modello a 🤗 Transformers passo dopo passo",local:"aggiungere-un-modello-a--transformers-passo-dopo-passo",headingTag:"h2"}}),se=new v({props:{title:"1. (Opzionale) Aspetti teorici di BrandNewBert",local:"1-opzionale-aspetti-teorici-di-brandnewbert",headingTag:"h3"}}),ce=new v({props:{title:"2. Prepare il tuo ambiente",local:"2-prepare-il-tuo-ambiente",headingTag:"h3"}}),Me=new f({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkYlNUJ5b3VyJTIwR2l0aHViJTIwaGFuZGxlJTVEJTJGdHJhbnNmb3JtZXJzLmdpdCUwQWNkJTIwdHJhbnNmb3JtZXJzJTBBZ2l0JTIwcmVtb3RlJTIwYWRkJTIwdXBzdHJlYW0lMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnRyYW5zZm9ybWVycy5naXQ=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/[your Github handle]/transformers.git
<span class="hljs-built_in">cd</span> transformers
git remote add upstream https://github.com/huggingface/transformers.git`,wrap:!1}}),fe=new f({props:{code:"cHl0aG9uJTIwLW0lMjB2ZW52JTIwLmVudiUwQXNvdXJjZSUyMC5lbnYlMkZiaW4lMkZhY3RpdmF0ZSUwQXBpcCUyMGluc3RhbGwlMjAtZSUyMCUyMi4lNUJkZXYlNUQlMjI=",highlighted:`python -m venv .<span class="hljs-built_in">env</span>
<span class="hljs-built_in">source</span> .<span class="hljs-built_in">env</span>/bin/activate
pip install -e <span class="hljs-string">&quot;.[dev]&quot;</span>`,wrap:!1}}),Te=new f({props:{code:"Y2QlMjAuLg==",highlighted:'<span class="hljs-built_in">cd</span> ..',wrap:!1}}),we=new f({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZvcmdfdGhhdF9jcmVhdGVkX2JyYW5kX25ld19iZXJ0X29yZyUyRmJyYW5kX25ld19iZXJ0LmdpdCUyMCUwQWNkJTIwYnJhbmRfbmV3X2JlcnQlMEFwaXAlMjBpbnN0YWxsJTIwLWUlMjAu",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/org_that_created_brand_new_bert_org/brand_new_bert.git 
<span class="hljs-built_in">cd</span> brand_new_bert
pip install -e .`,wrap:!1}}),ye=new v({props:{title:"3.-4. Provare un pretrained checkpoint usando la repo originale",local:"3-4-provare-un-pretrained-checkpoint-usando-la-repo-originale",headingTag:"h3"}}),ke=new f({props:{code:"bW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbC5sb2FkX3ByZXRyYWluZWRfY2hlY2twb2ludCglMjIlMkZwYXRoJTJGdG8lMkZjaGVja3BvaW50JTJGJTIyKSUwQWlucHV0X2lkcyUyMCUzRCUyMCU1QjAlMkMlMjA0JTJDJTIwNSUyQyUyMDIlMkMlMjAzJTJDJTIwNyUyQyUyMDklNUQlMjAlMjAlMjMlMjB2ZWN0b3IlMjBvZiUyMGlucHV0JTIwaWRzJTBBb3JpZ2luYWxfb3V0cHV0JTIwJTNEJTIwbW9kZWwucHJlZGljdChpbnB1dF9pZHMp",highlighted:`model = BrandNewBertModel.load_pretrained_checkpoint(<span class="hljs-string">&quot;/path/to/checkpoint/&quot;</span>)
input_ids = [<span class="hljs-number">0</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">7</span>, <span class="hljs-number">9</span>]  <span class="hljs-comment"># vector of input ids</span>
original_output = model.predict(input_ids)`,wrap:!1}}),qe=new f({props:{code:"JTVCJTVCJTBBJTIwJTVCLTAuMTQ2NSUyQyUyMC0wLjY1MDElMkMlMjAlMjAwLjE5OTMlMkMlMjAlMjAuLi4lMkMlMjAlMjAwLjE0NTElMkMlMjAlMjAwLjM0MzAlMkMlMjAlMjAwLjYwMjQlNUQlMkMlMEElMjAlNUItMC40NDE3JTJDJTIwLTAuNTkyMCUyQyUyMCUyMDAuMzQ1MCUyQyUyMCUyMC4uLiUyQyUyMC0wLjMwNjIlMkMlMjAlMjAwLjYxODIlMkMlMjAlMjAwLjcxMzIlNUQlMkMlMEElMjAlNUItMC41MDA5JTJDJTIwLTAuNzEyMiUyQyUyMCUyMDAuNDU0OCUyQyUyMCUyMC4uLiUyQyUyMC0wLjM2NjIlMkMlMjAlMjAwLjYwOTElMkMlMjAlMjAwLjc2NDglNUQlMkMlMEElMjAuLi4lMkMlMEElMjAlNUItMC41NjEzJTJDJTIwLTAuNjMzMiUyQyUyMCUyMDAuNDMyNCUyQyUyMCUyMC4uLiUyQyUyMC0wLjM3OTIlMkMlMjAlMjAwLjczNzIlMkMlMjAlMjAwLjkyODglNUQlMkMlMEElMjAlNUItMC41NDE2JTJDJTIwLTAuNjM0NSUyQyUyMCUyMDAuNDE4MCUyQyUyMCUyMC4uLiUyQyUyMC0wLjM1NjQlMkMlMjAlMjAwLjY5OTIlMkMlMjAlMjAwLjkxOTElNUQlMkMlMEElMjAlNUItMC41MzM0JTJDJTIwLTAuNjQwMyUyQyUyMCUyMDAuNDI3MSUyQyUyMCUyMC4uLiUyQyUyMC0wLjMzMzklMkMlMjAlMjAwLjY1MzMlMkMlMjAlMjAwLjg2OTQlNUQlNUQlNUQlMkM=",highlighted:`<span class="hljs-comment">[<span class="hljs-comment">[
 <span class="hljs-comment">[-0.1465, -0.6501,  0.1993,  ...,  0.1451,  0.3430,  0.6024]</span>,
 <span class="hljs-comment">[-0.4417, -0.5920,  0.3450,  ..., -0.3062,  0.6182,  0.7132]</span>,
 <span class="hljs-comment">[-0.5009, -0.7122,  0.4548,  ..., -0.3662,  0.6091,  0.7648]</span>,
 ...,
 <span class="hljs-comment">[-0.5613, -0.6332,  0.4324,  ..., -0.3792,  0.7372,  0.9288]</span>,
 <span class="hljs-comment">[-0.5416, -0.6345,  0.4180,  ..., -0.3564,  0.6992,  0.9191]</span>,
 <span class="hljs-comment">[-0.5334, -0.6403,  0.4271,  ..., -0.3339,  0.6533,  0.8694]</span>]</span>]</span>,`,wrap:!1}}),Ve=new v({props:{title:"5.-14. Trasferire BrandNewBert in 🤗 Transformers",local:"5-14-trasferire-brandnewbert-in--transformers",headingTag:"h3"}}),Ye=new f({props:{code:"Y2QlMjB0cmFuc2Zvcm1lcnM=",highlighted:'<span class="hljs-built_in">cd</span> transformers',wrap:!1}}),ot=new f({props:{code:"Z2l0JTIwY2hlY2tvdXQlMjAtYiUyMGFkZF9icmFuZF9uZXdfYmVydCUyMA==",highlighted:"git checkout -b add_brand_new_bert ",wrap:!1}}),at=new f({props:{code:"Z2l0JTIwYWRkJTIwLiUyMCUwQWdpdCUyMGNvbW1pdCUyMA==",highlighted:`git add . 
git commit `,wrap:!1}}),rt=new f({props:{code:"Z2l0JTIwZmV0Y2glMjB1cHN0cmVhbSUyMCUwQWdpdCUyMHJlYmFzZSUyMHVwc3RyZWFtJTJGbWFpbiUyMA==",highlighted:`git fetch upstream 
git rebase upstream/main `,wrap:!1}}),st=new f({props:{code:"Z2l0JTIwcHVzaCUyMC11JTIwb3JpZ2luJTIwYS1kZXNjcmlwdGl2ZS1uYW1lLWZvci1teS1jaGFuZ2Vz",highlighted:"git push -u origin a-descriptive-name-for-my-changes",wrap:!1}}),mt=new f({props:{code:"Z2l0JTIwZmV0Y2glMjB1cHN0cmVhbSUwQWdpdCUyMG1lcmdlJTIwdXBzdHJlYW0lMkZtYWlu",highlighted:`git fetch upstream
git merge upstream/main`,wrap:!1}}),vt=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJyYW5kTmV3QmVydE1vZGVsJTJDJTIwQnJhbmROZXdCZXJ0Q29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbChCcmFuZE5ld0JlcnRDb25maWcoKSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BrandNewBertModel, BrandNewBertConfig

model = BrandNewBertModel(BrandNewBertConfig())`,wrap:!1}}),Ct=new f({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwbm4lMEElMEElMEFjbGFzcyUyMFNpbXBsZU1vZGVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZGVuc2UlMjAlM0QlMjBubi5MaW5lYXIoMTAlMkMlMjAxMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmludGVybWVkaWF0ZSUyMCUzRCUyMG5uLkxpbmVhcigxMCUyQyUyMDEwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubGF5ZXJfbm9ybSUyMCUzRCUyMG5uLkxheWVyTm9ybSgxMCk=",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn


<span class="hljs-keyword">class</span> <span class="hljs-title class_">SimpleModel</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.dense = nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.intermediate = nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.layer_norm = nn.LayerNorm(<span class="hljs-number">10</span>)`,wrap:!1}}),Ut=new f({props:{code:"bW9kZWwlMjAlM0QlMjBTaW1wbGVNb2RlbCgpJTBBJTBBcHJpbnQobW9kZWwp",highlighted:`model = SimpleModel()

<span class="hljs-built_in">print</span>(model)`,wrap:!1}}),It=new f({props:{code:"U2ltcGxlTW9kZWwoJTBBJTIwJTIwKGRlbnNlKSUzQSUyMExpbmVhcihpbl9mZWF0dXJlcyUzRDEwJTJDJTIwb3V0X2ZlYXR1cmVzJTNEMTAlMkMlMjBiaWFzJTNEVHJ1ZSklMEElMjAlMjAoaW50ZXJtZWRpYXRlKSUzQSUyMExpbmVhcihpbl9mZWF0dXJlcyUzRDEwJTJDJTIwb3V0X2ZlYXR1cmVzJTNEMTAlMkMlMjBiaWFzJTNEVHJ1ZSklMEElMjAlMjAobGF5ZXJfbm9ybSklM0ElMjBMYXllck5vcm0oKDEwJTJDKSUyQyUyMGVwcyUzRDFlLTA1JTJDJTIwZWxlbWVudHdpc2VfYWZmaW5lJTNEVHJ1ZSklMEEp",highlighted:`SimpleModel(
  (dense): Linear(<span class="hljs-attribute">in_features</span>=10, <span class="hljs-attribute">out_features</span>=10, <span class="hljs-attribute">bias</span>=<span class="hljs-literal">True</span>)
  (intermediate): Linear(<span class="hljs-attribute">in_features</span>=10, <span class="hljs-attribute">out_features</span>=10, <span class="hljs-attribute">bias</span>=<span class="hljs-literal">True</span>)
  (layer_norm): LayerNorm((10,), <span class="hljs-attribute">eps</span>=1e-05, <span class="hljs-attribute">elementwise_affine</span>=<span class="hljs-literal">True</span>)
)`,wrap:!1}}),zt=new f({props:{code:"cHJpbnQobW9kZWwuZGVuc2Uud2VpZ2h0LmRhdGEp",highlighted:'<span class="hljs-built_in">print</span>(model.dense.weight.data)',wrap:!1}}),kt=new f({props:{code:"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",highlighted:`tensor([[<span class="hljs-string">-0</span>.0818,  0.2207, <span class="hljs-string">-0</span>.0749, <span class="hljs-string">-0</span>.0030,  0.0045, <span class="hljs-string">-0</span>.1569, <span class="hljs-string">-0</span>.1598,  0.0212,
         <span class="hljs-string">-0</span>.2077,  0.2157],
        [ 0.1044,  0.0201,  0.0990,  0.2482,  0.3116,  0.2509,  0.2866, <span class="hljs-string">-0</span>.2190,
          0.2166, <span class="hljs-string">-0</span>.0212],
        [<span class="hljs-string">-0</span>.2000,  0.1107, <span class="hljs-string">-0</span>.1999, <span class="hljs-string">-0</span>.3119,  0.1559,  0.0993,  0.1776, <span class="hljs-string">-0</span>.1950,
         <span class="hljs-string">-0</span>.1023, <span class="hljs-string">-0</span>.0447],
        [<span class="hljs-string">-0</span>.0888, <span class="hljs-string">-0</span>.1092,  0.2281,  0.0336,  0.1817, <span class="hljs-string">-0</span>.0115,  0.2096,  0.1415,
         <span class="hljs-string">-0</span>.1876, <span class="hljs-string">-0</span>.2467],
        [ 0.2208, <span class="hljs-string">-0</span>.2352, <span class="hljs-string">-0</span>.1426, <span class="hljs-string">-0</span>.2636, <span class="hljs-string">-0</span>.2889, <span class="hljs-string">-0</span>.2061, <span class="hljs-string">-0</span>.2849, <span class="hljs-string">-0</span>.0465,
          0.2577,  0.0402],
        [ 0.1502,  0.2465,  0.2566,  0.0693,  0.2352, <span class="hljs-string">-0</span>.0530,  0.1859, <span class="hljs-string">-0</span>.0604,
          0.2132,  0.1680],
        [ 0.1733, <span class="hljs-string">-0</span>.2407, <span class="hljs-string">-0</span>.1721,  0.1484,  0.0358, <span class="hljs-string">-0</span>.0633, <span class="hljs-string">-0</span>.0721, <span class="hljs-string">-0</span>.0090,
          0.2707, <span class="hljs-string">-0</span>.2509],
        [<span class="hljs-string">-0</span>.1173,  0.1561,  0.2945,  0.0595, <span class="hljs-string">-0</span>.1996,  0.2988, <span class="hljs-string">-0</span>.0802,  0.0407,
          0.1829, <span class="hljs-string">-0</span>.1568],
        [<span class="hljs-string">-0</span>.1164, <span class="hljs-string">-0</span>.2228, <span class="hljs-string">-0</span>.0403,  0.0428,  0.1339,  0.0047,  0.1967,  0.2923,
          0.0333, <span class="hljs-string">-0</span>.0536],
        [<span class="hljs-string">-0</span>.1492, <span class="hljs-string">-0</span>.1616,  0.1057,  0.1950, <span class="hljs-string">-0</span>.2807, <span class="hljs-string">-0</span>.2710, <span class="hljs-string">-0</span>.1586,  0.0739,
          0.2220,  0.2358]]).`,wrap:!1}}),At=new f({props:{code:"JTIzJTIwcmV0cmlldmUlMjBtYXRjaGluZyUyMGxheWVyJTIwd2VpZ2h0cyUyQyUyMGUuZy4lMjBieSUwQSUyMyUyMHJlY3Vyc2l2ZSUyMGFsZ29yaXRobSUwQWxheWVyX25hbWUlMjAlM0QlMjAlMjJkZW5zZSUyMiUwQXByZXRyYWluZWRfd2VpZ2h0JTIwJTNEJTIwYXJyYXlfb2ZfZGVuc2VfbGF5ZXIlMEElMEFtb2RlbF9wb2ludGVyJTIwJTNEJTIwZ2V0YXR0cihtb2RlbCUyQyUyMCUyMmRlbnNlJTIyKSUwQSUwQW1vZGVsX3BvaW50ZXIud2VpZ2h0LmRhdGElMjAlM0QlMjB0b3JjaC5mcm9tX251bXB5KHByZXRyYWluZWRfd2VpZ2h0KQ==",highlighted:`<span class="hljs-comment"># retrieve matching layer weights, e.g. by</span>
<span class="hljs-comment"># recursive algorithm</span>
layer_name = <span class="hljs-string">&quot;dense&quot;</span>
pretrained_weight = array_of_dense_layer

model_pointer = <span class="hljs-built_in">getattr</span>(model, <span class="hljs-string">&quot;dense&quot;</span>)

model_pointer.weight.data = torch.from_numpy(pretrained_weight)`,wrap:!1}}),Nt=new f({props:{code:"YXNzZXJ0JTIwKCUwQSUyMCUyMCUyMCUyMG1vZGVsX3BvaW50ZXIud2VpZ2h0LnNoYXBlJTIwJTNEJTNEJTIwcHJldHJhaW5lZF93ZWlnaHQuc2hhcGUlMEEpJTJDJTIwZiUyMlBvaW50ZXIlMjBzaGFwZSUyMG9mJTIwcmFuZG9tJTIwd2VpZ2h0JTIwJTdCbW9kZWxfcG9pbnRlci5zaGFwZSU3RCUyMGFuZCUyMGFycmF5JTIwc2hhcGUlMjBvZiUyMGNoZWNrcG9pbnQlMjB3ZWlnaHQlMjAlN0JwcmV0cmFpbmVkX3dlaWdodC5zaGFwZSU3RCUyMG1pc21hdGNoZWQlMjI=",highlighted:`<span class="hljs-keyword">assert</span> (
    model_pointer.weight.shape == pretrained_weight.shape
), <span class="hljs-string">f&quot;Pointer shape of random weight <span class="hljs-subst">{model_pointer.shape}</span> and array shape of checkpoint weight <span class="hljs-subst">{pretrained_weight.shape}</span> mismatched&quot;</span>`,wrap:!1}}),Bt=new f({props:{code:"bG9nZ2VyLmluZm8oZiUyMkluaXRpYWxpemUlMjBQeVRvcmNoJTIwd2VpZ2h0JTIwJTdCbGF5ZXJfbmFtZSU3RCUyMGZyb20lMjAlN0JwcmV0cmFpbmVkX3dlaWdodC5uYW1lJTdEJTIyKQ==",highlighted:'logger.info(<span class="hljs-string">f&quot;Initialize PyTorch weight <span class="hljs-subst">{layer_name}</span> from <span class="hljs-subst">{pretrained_weight.name}</span>&quot;</span>)',wrap:!1}}),Rt=new f({props:{code:"bW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMiUyRnBhdGglMkZ0byUyRmNvbnZlcnRlZCUyRmNoZWNrcG9pbnQlMkZmb2xkZXIlMjIp",highlighted:'model.save_pretrained(<span class="hljs-string">&quot;/path/to/converted/checkpoint/folder&quot;</span>)',wrap:!1}}),Gt=new f({props:{code:"bW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyJTJGcGF0aCUyRnRvJTJGY29udmVydGVkJTJGY2hlY2twb2ludCUyRmZvbGRlciUyMiklMEFpbnB1dF9pZHMlMjAlM0QlMjAlNUIwJTJDJTIwNCUyQyUyMDQlMkMlMjAzJTJDJTIwMiUyQyUyMDQlMkMlMjAxJTJDJTIwNyUyQyUyMDE5JTVEJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzKS5sYXN0X2hpZGRlbl9zdGF0ZXM=",highlighted:`model = BrandNewBertModel.from_pretrained(<span class="hljs-string">&quot;/path/to/converted/checkpoint/folder&quot;</span>)
input_ids = [<span class="hljs-number">0</span>, <span class="hljs-number">4</span>, <span class="hljs-number">4</span>, <span class="hljs-number">3</span>, <span class="hljs-number">2</span>, <span class="hljs-number">4</span>, <span class="hljs-number">1</span>, <span class="hljs-number">7</span>, <span class="hljs-number">19</span>]
output = model(input_ids).last_hidden_states`,wrap:!1}}),ei=new f({props:{code:"cHl0ZXN0JTIwdGVzdHMlMkZ0ZXN0X21vZGVsaW5nX2JyYW5kX25ld19iZXJ0LnB5",highlighted:"pytest tests/test_modeling_brand_new_bert.py",wrap:!1}}),ni=new f({props:{code:"UlVOX1NMT1clM0QxJTIwcHl0ZXN0JTIwLXN2JTIwdGVzdHMlMkZ0ZXN0X21vZGVsaW5nX2JyYW5kX25ld19iZXJ0LnB5JTNBJTNBQnJhbmROZXdCZXJ0TW9kZWxJbnRlZ3JhdGlvblRlc3Rz",highlighted:"RUN_SLOW=1 pytest -sv tests/test_modeling_brand_new_bert.py::BrandNewBertModelIntegrationTests",wrap:!1}}),_=new tp({props:{$$slots:{default:[ip]},$$scope:{ctx:Ri}}}),ui=new f({props:{code:"aW5wdXRfc3RyJTIwJTNEJTIwJTIyVGhpcyUyMGlzJTIwYSUyMGxvbmclMjBleGFtcGxlJTIwaW5wdXQlMjBzdHJpbmclMjBjb250YWluaW5nJTIwc3BlY2lhbCUyMGNoYXJhY3RlcnMlMjAuJTI0JTNGLSUyQyUyMG51bWJlcnMlMjAyODcyJTIwMjM0JTIwMTIlMjBhbmQlMjB3b3Jkcy4lMjIlMEFtb2RlbCUyMCUzRCUyMEJyYW5kTmV3QmVydE1vZGVsLmxvYWRfcHJldHJhaW5lZF9jaGVja3BvaW50KCUyMiUyRnBhdGglMkZ0byUyRmNoZWNrcG9pbnQlMkYlMjIpJTBBaW5wdXRfaWRzJTIwJTNEJTIwbW9kZWwudG9rZW5pemUoaW5wdXRfc3RyKQ==",highlighted:`input_str = <span class="hljs-string">&quot;This is a long example input string containing special characters .$?-, numbers 2872 234 12 and words.&quot;</span>
model = BrandNewBertModel.load_pretrained_checkpoint(<span class="hljs-string">&quot;/path/to/checkpoint/&quot;</span>)
input_ids = model.tokenize(input_str)`,wrap:!1}}),di=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJyYW5kTmV3QmVydFRva2VuaXplciUwQSUwQWlucHV0X3N0ciUyMCUzRCUyMCUyMlRoaXMlMjBpcyUyMGElMjBsb25nJTIwZXhhbXBsZSUyMGlucHV0JTIwc3RyaW5nJTIwY29udGFpbmluZyUyMHNwZWNpYWwlMjBjaGFyYWN0ZXJzJTIwLiUyNCUzRi0lMkMlMjBudW1iZXJzJTIwMjg3MiUyMDIzNCUyMDEyJTIwYW5kJTIwd29yZHMuJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQnJhbmROZXdCZXJ0VG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjIlMkZwYXRoJTJGdG8lMkZ0b2tlbml6ZXIlMkZmb2xkZXIlMkYlMjIpJTBBJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3N0cikuaW5wdXRfaWRz",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BrandNewBertTokenizer

input_str = <span class="hljs-string">&quot;This is a long example input string containing special characters .$?-, numbers 2872 234 12 and words.&quot;</span>

tokenizer = BrandNewBertTokenizer.from_pretrained(<span class="hljs-string">&quot;/path/to/tokenizer/folder/&quot;</span>)

input_ids = tokenizer(input_str).input_ids`,wrap:!1}}),Ji=new f({props:{code:"bWFrZSUyMHN0eWxl",highlighted:"make style",wrap:!1}}),ji=new f({props:{code:"bWFrZSUyMHF1YWxpdHk=",highlighted:"make quality",wrap:!1}}),$i=new f({props:{code:"YnJhbmRfbmV3X2JlcnQucHVzaF90b19odWIoJTBBJTIwJTIwJTIwJTIwcmVwb19wYXRoX29yX25hbWUlM0QlMjJicmFuZF9uZXdfYmVydCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMyUyMFVuY29tbWVudCUyMHRoZSUyMGZvbGxvd2luZyUyMGxpbmUlMjB0byUyMHB1c2glMjB0byUyMGFuJTIwb3JnYW5pemF0aW9uJTBBJTIwJTIwJTIwJTIwJTIzJTIwb3JnYW5pemF0aW9uJTNEJTIyJTNDT1JHQU5JWkFUSU9OJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwY29tbWl0X21lc3NhZ2UlM0QlMjJBZGQlMjBtb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHVzZV90ZW1wX2RpciUzRFRydWUlMkMlMEEp",highlighted:`brand_new_bert.push_to_hub(
    repo_path_or_name=<span class="hljs-string">&quot;brand_new_bert&quot;</span>,
    <span class="hljs-comment"># Uncomment the following line to push to an organization</span>
    <span class="hljs-comment"># organization=&quot;&lt;ORGANIZATION&gt;&quot;,</span>
    commit_message=<span class="hljs-string">&quot;Add model&quot;</span>,
    use_temp_dir=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),Pi=new v({props:{title:"Condividete il vostro lavoro!!",local:"condividete-il-vostro-lavoro",headingTag:"h3"}}),{c(){g=a("meta"),I=n(),T=a("p"),Qi=n(),p(L.$$.fragment),qi=n(),z=a("p"),z.innerHTML=da,Ei=n(),$=a("p"),$.innerHTML=Ma,Gi=n(),k=a("p"),k.textContent=fa,Si=n(),x=a("ul"),x.innerHTML=ga,Vi=n(),A=a("p"),A.innerHTML=Ta,Xi=n(),H=a("p"),H.textContent=va,Yi=n(),p(N.$$.fragment),Fi=n(),P=a("p"),P.textContent=wa,Oi=n(),B=a("p"),B.innerHTML=ba,Ki=n(),Z=a("ul"),Z.innerHTML=ya,el=n(),Q=a("p"),Q.innerHTML=ha,tl=n(),W=a("p"),W.textContent=Ja,il=n(),p(D.$$.fragment),ll=n(),R=a("p"),R.innerHTML=Ca,nl=n(),q=a("p"),q.textContent=ja,ol=n(),Wi=a("img"),al=n(),E=a("p"),E.innerHTML=_a,rl=n(),p(G.$$.fragment),sl=n(),S=a("p"),S.innerHTML=Ia,pl=n(),p(V.$$.fragment),ml=n(),X=a("p"),X.textContent=La,ul=n(),Y=a("ol"),Y.innerHTML=za,cl=n(),p(F.$$.fragment),dl=n(),O=a("p"),O.textContent=$a,Ml=n(),p(K.$$.fragment),fl=n(),ee=a("p"),ee.textContent=ka,gl=n(),te=a("ol"),te.innerHTML=xa,Tl=n(),ie=a("p"),ie.textContent=Aa,vl=n(),le=a("ul"),le.innerHTML=Ha,wl=n(),ne=a("p"),ne.textContent=Na,bl=n(),oe=a("p"),oe.textContent=Pa,yl=n(),ae=a("ul"),ae.innerHTML=Ba,hl=n(),re=a("p"),re.innerHTML=Za,Jl=n(),p(se.$$.fragment),Cl=n(),pe=a("p"),pe.innerHTML=Qa,jl=n(),me=a("ul"),me.innerHTML=Wa,Ul=n(),ue=a("p"),ue.textContent=Da,_l=n(),p(ce.$$.fragment),Il=n(),de=a("ol"),de.innerHTML=Ra,Ll=n(),p(Me.$$.fragment),zl=n(),b=a("ol"),b.innerHTML=qa,$l=n(),p(fe.$$.fragment),kl=n(),ge=a("p"),ge.textContent=Ea,xl=n(),p(Te.$$.fragment),Al=n(),y=a("ol"),y.innerHTML=Ga,Hl=n(),ve=a("p"),ve.innerHTML=Sa,Nl=n(),h=a("ol"),h.innerHTML=Va,Pl=n(),p(we.$$.fragment),Bl=n(),be=a("p"),be.innerHTML=Xa,Zl=n(),p(ye.$$.fragment),Ql=n(),he=a("p"),he.innerHTML=Ya,Wl=n(),Je=a("p"),Je.innerHTML=Fa,Dl=n(),Ce=a("ul"),Ce.innerHTML=Oa,Rl=n(),je=a("p"),je.innerHTML=Ka,ql=n(),Ue=a("p"),Ue.textContent=er,El=n(),_e=a("p"),_e.textContent=tr,Gl=n(),Ie=a("ul"),Ie.innerHTML=ir,Sl=n(),Le=a("p"),Le.textContent=lr,Vl=n(),ze=a("p"),ze.innerHTML=nr,Xl=n(),$e=a("p"),$e.innerHTML=or,Yl=n(),p(ke.$$.fragment),Fl=n(),xe=a("p"),xe.textContent=ar,Ol=n(),Ae=a("ul"),Ae.innerHTML=rr,Kl=n(),He=a("p"),He.textContent=sr,en=n(),Ne=a("p"),Ne.innerHTML=pr,tn=n(),Pe=a("ul"),Pe.innerHTML=mr,ln=n(),Be=a("p"),Be.innerHTML=ur,nn=n(),Ze=a("p"),Ze.innerHTML=cr,on=n(),Qe=a("p"),Qe.textContent=dr,an=n(),We=a("ol"),We.innerHTML=Mr,rn=n(),De=a("p"),De.innerHTML=fr,sn=n(),Re=a("p"),Re.textContent=gr,pn=n(),p(qe.$$.fragment),mn=n(),Ee=a("p"),Ee.innerHTML=Tr,un=n(),Ge=a("ul"),Ge.innerHTML=vr,cn=n(),Se=a("p"),Se.innerHTML=wr,dn=n(),p(Ve.$$.fragment),Mn=n(),Xe=a("p"),Xe.textContent=br,fn=n(),p(Ye.$$.fragment),gn=n(),Fe=a("p"),Fe.innerHTML=yr,Tn=n(),Oe=a("p"),Oe.textContent=hr,vn=n(),Ke=a("ul"),Ke.innerHTML=Jr,wn=n(),et=a("p"),et.innerHTML=Cr,bn=n(),tt=a("p"),tt.innerHTML=jr,yn=n(),it=a("p"),it.innerHTML=Ur,hn=n(),lt=a("p"),lt.textContent=_r,Jn=n(),nt=a("ol"),nt.innerHTML=Ir,Cn=n(),p(ot.$$.fragment),jn=n(),J=a("ol"),J.innerHTML=Lr,Un=n(),p(at.$$.fragment),_n=n(),C=a("ol"),C.innerHTML=zr,In=n(),p(rt.$$.fragment),Ln=n(),j=a("ol"),j.innerHTML=$r,zn=n(),p(st.$$.fragment),$n=n(),U=a("ol"),U.innerHTML=kr,kn=n(),pt=a("p"),pt.textContent=xr,xn=n(),p(mt.$$.fragment),An=n(),ut=a("p"),ut.textContent=Ar,Hn=n(),ct=a("p"),ct.textContent=Hr,Nn=n(),dt=a("p"),dt.textContent=Nr,Pn=n(),Mt=a("p"),Mt.innerHTML=Pr,Bn=n(),ft=a("p"),ft.innerHTML=Br,Zn=n(),gt=a("p"),gt.innerHTML=Zr,Qn=n(),Tt=a("p"),Tt.innerHTML=Qr,Wn=n(),p(vt.$$.fragment),Dn=n(),wt=a("p"),wt.innerHTML=Wr,Rn=n(),bt=a("p"),bt.innerHTML=Dr,qn=n(),yt=a("p"),yt.innerHTML=Rr,En=n(),ht=a("ul"),ht.innerHTML=qr,Gn=n(),Jt=a("p"),Jt.innerHTML=Er,Sn=n(),p(Ct.$$.fragment),Vn=n(),jt=a("p"),jt.innerHTML=Gr,Xn=n(),p(Ut.$$.fragment),Yn=n(),_t=a("p"),_t.textContent=Sr,Fn=n(),p(It.$$.fragment),On=n(),Lt=a("p"),Lt.textContent=Vr,Kn=n(),p(zt.$$.fragment),eo=n(),$t=a("p"),$t.textContent=Xr,to=n(),p(kt.$$.fragment),io=n(),xt=a("p"),xt.innerHTML=Yr,lo=n(),p(At.$$.fragment),no=n(),Ht=a("p"),Ht.innerHTML=Fr,oo=n(),p(Nt.$$.fragment),ao=n(),Pt=a("p"),Pt.textContent=Or,ro=n(),p(Bt.$$.fragment),so=n(),Zt=a("p"),Zt.textContent=Kr,po=n(),Qt=a("p"),Qt.innerHTML=es,mo=n(),Wt=a("p"),Wt.innerHTML=ts,uo=n(),Dt=a("p"),Dt.innerHTML=is,co=n(),p(Rt.$$.fragment),Mo=n(),qt=a("p"),qt.innerHTML=ls,fo=n(),Et=a("p"),Et.innerHTML=ns,go=n(),p(Gt.$$.fragment),To=n(),St=a("p"),St.innerHTML=os,vo=n(),Vt=a("p"),Vt.innerHTML=as,wo=n(),Xt=a("ul"),Xt.innerHTML=rs,bo=n(),Yt=a("p"),Yt.innerHTML=ss,yo=n(),Ft=a("p"),Ft.innerHTML=ps,ho=n(),Ot=a("p"),Ot.innerHTML=ms,Jo=n(),Kt=a("p"),Kt.innerHTML=us,Co=n(),p(ei.$$.fragment),jo=n(),ti=a("p"),ti.textContent=cs,Uo=n(),ii=a("ul"),ii.innerHTML=ds,_o=n(),li=a("p"),li.innerHTML=Ms,Io=n(),p(ni.$$.fragment),Lo=n(),p(_.$$.fragment),zo=n(),oi=a("p"),oi.innerHTML=fs,$o=n(),ai=a("ul"),ai.innerHTML=gs,ko=n(),ri=a("p"),ri.innerHTML=Ts,xo=n(),si=a("p"),si.innerHTML=vs,Ao=n(),pi=a("p"),pi.textContent=ws,Ho=n(),mi=a("p"),mi.innerHTML=bs,No=n(),p(ui.$$.fragment),Po=n(),ci=a("p"),ci.innerHTML=ys,Bo=n(),p(di.$$.fragment),Zo=n(),Mi=a("p"),Mi.innerHTML=hs,Qo=n(),fi=a("p"),fi.innerHTML=Js,Wo=n(),gi=a("p"),gi.innerHTML=Cs,Do=n(),Ti=a("p"),Ti.innerHTML=js,Ro=n(),vi=a("p"),vi.innerHTML=Us,qo=n(),wi=a("p"),wi.innerHTML=_s,Eo=n(),bi=a("p"),bi.innerHTML=Is,Go=n(),yi=a("p"),yi.innerHTML=Ls,So=n(),hi=a("p"),hi.innerHTML=zs,Vo=n(),p(Ji.$$.fragment),Xo=n(),Ci=a("p"),Ci.textContent=$s,Yo=n(),p(ji.$$.fragment),Fo=n(),Ui=a("p"),Ui.textContent=ks,Oo=n(),_i=a("p"),_i.textContent=xs,Ko=n(),Ii=a("p"),Ii.textContent=As,ea=n(),Li=a("p"),Li.innerHTML=Hs,ta=n(),zi=a("p"),zi.innerHTML=Ns,ia=n(),p($i.$$.fragment),la=n(),ki=a("p"),ki.innerHTML=Ps,na=n(),xi=a("p"),xi.innerHTML=Bs,oa=n(),Ai=a("p"),Ai.innerHTML=Zs,aa=n(),Hi=a("p"),Hi.innerHTML=Qs,ra=n(),Ni=a("p"),Ni.textContent=Ws,sa=n(),p(Pi.$$.fragment),pa=n(),Bi=a("p"),Bi.textContent=Ds,ma=n(),Zi=a("p"),Zi.innerHTML=Rs,ua=n(),Di=a("p"),this.h()},l(e){const t=Os("svelte-u9bgzb",document.head);g=r(t,"META",{name:!0,content:!0}),t.forEach(i),I=o(e),T=r(e,"P",{}),Es(T).forEach(i),Qi=o(e),m(L.$$.fragment,e),qi=o(e),z=r(e,"P",{"data-svelte-h":!0}),s(z)!=="svelte-mcybxm"&&(z.innerHTML=da),Ei=o(e),$=r(e,"P",{"data-svelte-h":!0}),s($)!=="svelte-i63dob"&&($.innerHTML=Ma),Gi=o(e),k=r(e,"P",{"data-svelte-h":!0}),s(k)!=="svelte-nuipgt"&&(k.textContent=fa),Si=o(e),x=r(e,"UL",{"data-svelte-h":!0}),s(x)!=="svelte-17lssrb"&&(x.innerHTML=ga),Vi=o(e),A=r(e,"P",{"data-svelte-h":!0}),s(A)!=="svelte-1s0iijf"&&(A.innerHTML=Ta),Xi=o(e),H=r(e,"P",{"data-svelte-h":!0}),s(H)!=="svelte-1hjdlgn"&&(H.textContent=va),Yi=o(e),m(N.$$.fragment,e),Fi=o(e),P=r(e,"P",{"data-svelte-h":!0}),s(P)!=="svelte-celw82"&&(P.textContent=wa),Oi=o(e),B=r(e,"P",{"data-svelte-h":!0}),s(B)!=="svelte-1uhsu9n"&&(B.innerHTML=ba),Ki=o(e),Z=r(e,"UL",{"data-svelte-h":!0}),s(Z)!=="svelte-1puf5lg"&&(Z.innerHTML=ya),el=o(e),Q=r(e,"P",{"data-svelte-h":!0}),s(Q)!=="svelte-fh5e7z"&&(Q.innerHTML=ha),tl=o(e),W=r(e,"P",{"data-svelte-h":!0}),s(W)!=="svelte-1or0tgf"&&(W.textContent=Ja),il=o(e),m(D.$$.fragment,e),ll=o(e),R=r(e,"P",{"data-svelte-h":!0}),s(R)!=="svelte-j8wqm2"&&(R.innerHTML=Ca),nl=o(e),q=r(e,"P",{"data-svelte-h":!0}),s(q)!=="svelte-1kc404e"&&(q.textContent=ja),ol=o(e),Wi=r(e,"IMG",{src:!0}),al=o(e),E=r(e,"P",{"data-svelte-h":!0}),s(E)!=="svelte-15z3m1e"&&(E.innerHTML=_a),rl=o(e),m(G.$$.fragment,e),sl=o(e),S=r(e,"P",{"data-svelte-h":!0}),s(S)!=="svelte-19tom7d"&&(S.innerHTML=Ia),pl=o(e),m(V.$$.fragment,e),ml=o(e),X=r(e,"P",{"data-svelte-h":!0}),s(X)!=="svelte-1e0x1j9"&&(X.textContent=La),ul=o(e),Y=r(e,"OL",{"data-svelte-h":!0}),s(Y)!=="svelte-1dh7wut"&&(Y.innerHTML=za),cl=o(e),m(F.$$.fragment,e),dl=o(e),O=r(e,"P",{"data-svelte-h":!0}),s(O)!=="svelte-1h3mdlf"&&(O.textContent=$a),Ml=o(e),m(K.$$.fragment,e),fl=o(e),ee=r(e,"P",{"data-svelte-h":!0}),s(ee)!=="svelte-1kdxkf0"&&(ee.textContent=ka),gl=o(e),te=r(e,"OL",{"data-svelte-h":!0}),s(te)!=="svelte-kjaxqe"&&(te.innerHTML=xa),Tl=o(e),ie=r(e,"P",{"data-svelte-h":!0}),s(ie)!=="svelte-l6ux6x"&&(ie.textContent=Aa),vl=o(e),le=r(e,"UL",{"data-svelte-h":!0}),s(le)!=="svelte-hnqwmd"&&(le.innerHTML=Ha),wl=o(e),ne=r(e,"P",{"data-svelte-h":!0}),s(ne)!=="svelte-6fjf2p"&&(ne.textContent=Na),bl=o(e),oe=r(e,"P",{"data-svelte-h":!0}),s(oe)!=="svelte-1a0cf88"&&(oe.textContent=Pa),yl=o(e),ae=r(e,"UL",{"data-svelte-h":!0}),s(ae)!=="svelte-1vr4224"&&(ae.innerHTML=Ba),hl=o(e),re=r(e,"P",{"data-svelte-h":!0}),s(re)!=="svelte-zoos1q"&&(re.innerHTML=Za),Jl=o(e),m(se.$$.fragment,e),Cl=o(e),pe=r(e,"P",{"data-svelte-h":!0}),s(pe)!=="svelte-1i01ztv"&&(pe.innerHTML=Qa),jl=o(e),me=r(e,"UL",{"data-svelte-h":!0}),s(me)!=="svelte-p3axpb"&&(me.innerHTML=Wa),Ul=o(e),ue=r(e,"P",{"data-svelte-h":!0}),s(ue)!=="svelte-jezgdr"&&(ue.textContent=Da),_l=o(e),m(ce.$$.fragment,e),Il=o(e),de=r(e,"OL",{"data-svelte-h":!0}),s(de)!=="svelte-v6kqrl"&&(de.innerHTML=Ra),Ll=o(e),m(Me.$$.fragment,e),zl=o(e),b=r(e,"OL",{start:!0,"data-svelte-h":!0}),s(b)!=="svelte-1evkptw"&&(b.innerHTML=qa),$l=o(e),m(fe.$$.fragment,e),kl=o(e),ge=r(e,"P",{"data-svelte-h":!0}),s(ge)!=="svelte-1jmeh4e"&&(ge.textContent=Ea),xl=o(e),m(Te.$$.fragment,e),Al=o(e),y=r(e,"OL",{start:!0,"data-svelte-h":!0}),s(y)!=="svelte-1flpp1p"&&(y.innerHTML=Ga),Hl=o(e),ve=r(e,"P",{"data-svelte-h":!0}),s(ve)!=="svelte-ktjdn9"&&(ve.innerHTML=Sa),Nl=o(e),h=r(e,"OL",{start:!0,"data-svelte-h":!0}),s(h)!=="svelte-1ksg1jw"&&(h.innerHTML=Va),Pl=o(e),m(we.$$.fragment,e),Bl=o(e),be=r(e,"P",{"data-svelte-h":!0}),s(be)!=="svelte-dbtpxy"&&(be.innerHTML=Xa),Zl=o(e),m(ye.$$.fragment,e),Ql=o(e),he=r(e,"P",{"data-svelte-h":!0}),s(he)!=="svelte-1qu4jr4"&&(he.innerHTML=Ya),Wl=o(e),Je=r(e,"P",{"data-svelte-h":!0}),s(Je)!=="svelte-110j2za"&&(Je.innerHTML=Fa),Dl=o(e),Ce=r(e,"UL",{"data-svelte-h":!0}),s(Ce)!=="svelte-1o86ips"&&(Ce.innerHTML=Oa),Rl=o(e),je=r(e,"P",{"data-svelte-h":!0}),s(je)!=="svelte-1i7tk"&&(je.innerHTML=Ka),ql=o(e),Ue=r(e,"P",{"data-svelte-h":!0}),s(Ue)!=="svelte-1fqyo7q"&&(Ue.textContent=er),El=o(e),_e=r(e,"P",{"data-svelte-h":!0}),s(_e)!=="svelte-1r60y3z"&&(_e.textContent=tr),Gl=o(e),Ie=r(e,"UL",{"data-svelte-h":!0}),s(Ie)!=="svelte-1ubalb5"&&(Ie.innerHTML=ir),Sl=o(e),Le=r(e,"P",{"data-svelte-h":!0}),s(Le)!=="svelte-svralj"&&(Le.textContent=lr),Vl=o(e),ze=r(e,"P",{"data-svelte-h":!0}),s(ze)!=="svelte-mel9r4"&&(ze.innerHTML=nr),Xl=o(e),$e=r(e,"P",{"data-svelte-h":!0}),s($e)!=="svelte-cjwu38"&&($e.innerHTML=or),Yl=o(e),m(ke.$$.fragment,e),Fl=o(e),xe=r(e,"P",{"data-svelte-h":!0}),s(xe)!=="svelte-1i7fntd"&&(xe.textContent=ar),Ol=o(e),Ae=r(e,"UL",{"data-svelte-h":!0}),s(Ae)!=="svelte-1b950b5"&&(Ae.innerHTML=rr),Kl=o(e),He=r(e,"P",{"data-svelte-h":!0}),s(He)!=="svelte-5ialh3"&&(He.textContent=sr),en=o(e),Ne=r(e,"P",{"data-svelte-h":!0}),s(Ne)!=="svelte-13adnmr"&&(Ne.innerHTML=pr),tn=o(e),Pe=r(e,"UL",{"data-svelte-h":!0}),s(Pe)!=="svelte-s9xa0y"&&(Pe.innerHTML=mr),ln=o(e),Be=r(e,"P",{"data-svelte-h":!0}),s(Be)!=="svelte-dngyoh"&&(Be.innerHTML=ur),nn=o(e),Ze=r(e,"P",{"data-svelte-h":!0}),s(Ze)!=="svelte-kg6we1"&&(Ze.innerHTML=cr),on=o(e),Qe=r(e,"P",{"data-svelte-h":!0}),s(Qe)!=="svelte-ebp8u2"&&(Qe.textContent=dr),an=o(e),We=r(e,"OL",{"data-svelte-h":!0}),s(We)!=="svelte-1sk2t1e"&&(We.innerHTML=Mr),rn=o(e),De=r(e,"P",{"data-svelte-h":!0}),s(De)!=="svelte-cnfp5i"&&(De.innerHTML=fr),sn=o(e),Re=r(e,"P",{"data-svelte-h":!0}),s(Re)!=="svelte-wlz2de"&&(Re.textContent=gr),pn=o(e),m(qe.$$.fragment,e),mn=o(e),Ee=r(e,"P",{"data-svelte-h":!0}),s(Ee)!=="svelte-1icu6e6"&&(Ee.innerHTML=Tr),un=o(e),Ge=r(e,"UL",{"data-svelte-h":!0}),s(Ge)!=="svelte-1ifrof5"&&(Ge.innerHTML=vr),cn=o(e),Se=r(e,"P",{"data-svelte-h":!0}),s(Se)!=="svelte-q1g4tr"&&(Se.innerHTML=wr),dn=o(e),m(Ve.$$.fragment,e),Mn=o(e),Xe=r(e,"P",{"data-svelte-h":!0}),s(Xe)!=="svelte-y19szg"&&(Xe.textContent=br),fn=o(e),m(Ye.$$.fragment,e),gn=o(e),Fe=r(e,"P",{"data-svelte-h":!0}),s(Fe)!=="svelte-1c5tp6d"&&(Fe.innerHTML=yr),Tn=o(e),Oe=r(e,"P",{"data-svelte-h":!0}),s(Oe)!=="svelte-qv115k"&&(Oe.textContent=hr),vn=o(e),Ke=r(e,"UL",{"data-svelte-h":!0}),s(Ke)!=="svelte-erhqs2"&&(Ke.innerHTML=Jr),wn=o(e),et=r(e,"P",{"data-svelte-h":!0}),s(et)!=="svelte-1rwitc3"&&(et.innerHTML=Cr),bn=o(e),tt=r(e,"P",{"data-svelte-h":!0}),s(tt)!=="svelte-1lp0v27"&&(tt.innerHTML=jr),yn=o(e),it=r(e,"P",{"data-svelte-h":!0}),s(it)!=="svelte-1l49660"&&(it.innerHTML=Ur),hn=o(e),lt=r(e,"P",{"data-svelte-h":!0}),s(lt)!=="svelte-susl50"&&(lt.textContent=_r),Jn=o(e),nt=r(e,"OL",{"data-svelte-h":!0}),s(nt)!=="svelte-5jcgu6"&&(nt.innerHTML=Ir),Cn=o(e),m(ot.$$.fragment,e),jn=o(e),J=r(e,"OL",{start:!0,"data-svelte-h":!0}),s(J)!=="svelte-194t2cz"&&(J.innerHTML=Lr),Un=o(e),m(at.$$.fragment,e),_n=o(e),C=r(e,"OL",{start:!0,"data-svelte-h":!0}),s(C)!=="svelte-1a8qrdq"&&(C.innerHTML=zr),In=o(e),m(rt.$$.fragment,e),Ln=o(e),j=r(e,"OL",{start:!0,"data-svelte-h":!0}),s(j)!=="svelte-1ntx3yt"&&(j.innerHTML=$r),zn=o(e),m(st.$$.fragment,e),$n=o(e),U=r(e,"OL",{start:!0,"data-svelte-h":!0}),s(U)!=="svelte-1plevyn"&&(U.innerHTML=kr),kn=o(e),pt=r(e,"P",{"data-svelte-h":!0}),s(pt)!=="svelte-1j3sibr"&&(pt.textContent=xr),xn=o(e),m(mt.$$.fragment,e),An=o(e),ut=r(e,"P",{"data-svelte-h":!0}),s(ut)!=="svelte-1nsjpv4"&&(ut.textContent=Ar),Hn=o(e),ct=r(e,"P",{"data-svelte-h":!0}),s(ct)!=="svelte-dewsnv"&&(ct.textContent=Hr),Nn=o(e),dt=r(e,"P",{"data-svelte-h":!0}),s(dt)!=="svelte-iueh1s"&&(dt.textContent=Nr),Pn=o(e),Mt=r(e,"P",{"data-svelte-h":!0}),s(Mt)!=="svelte-13yidk9"&&(Mt.innerHTML=Pr),Bn=o(e),ft=r(e,"P",{"data-svelte-h":!0}),s(ft)!=="svelte-d6o9fs"&&(ft.innerHTML=Br),Zn=o(e),gt=r(e,"P",{"data-svelte-h":!0}),s(gt)!=="svelte-128ejbp"&&(gt.innerHTML=Zr),Qn=o(e),Tt=r(e,"P",{"data-svelte-h":!0}),s(Tt)!=="svelte-jaq4jf"&&(Tt.innerHTML=Qr),Wn=o(e),m(vt.$$.fragment,e),Dn=o(e),wt=r(e,"P",{"data-svelte-h":!0}),s(wt)!=="svelte-w8emzm"&&(wt.innerHTML=Wr),Rn=o(e),bt=r(e,"P",{"data-svelte-h":!0}),s(bt)!=="svelte-cjyudz"&&(bt.innerHTML=Dr),qn=o(e),yt=r(e,"P",{"data-svelte-h":!0}),s(yt)!=="svelte-10j71zn"&&(yt.innerHTML=Rr),En=o(e),ht=r(e,"UL",{"data-svelte-h":!0}),s(ht)!=="svelte-1vpn2ms"&&(ht.innerHTML=qr),Gn=o(e),Jt=r(e,"P",{"data-svelte-h":!0}),s(Jt)!=="svelte-gmncyo"&&(Jt.innerHTML=Er),Sn=o(e),m(Ct.$$.fragment,e),Vn=o(e),jt=r(e,"P",{"data-svelte-h":!0}),s(jt)!=="svelte-zfbl8p"&&(jt.innerHTML=Gr),Xn=o(e),m(Ut.$$.fragment,e),Yn=o(e),_t=r(e,"P",{"data-svelte-h":!0}),s(_t)!=="svelte-bxzo98"&&(_t.textContent=Sr),Fn=o(e),m(It.$$.fragment,e),On=o(e),Lt=r(e,"P",{"data-svelte-h":!0}),s(Lt)!=="svelte-msvb9t"&&(Lt.textContent=Vr),Kn=o(e),m(zt.$$.fragment,e),eo=o(e),$t=r(e,"P",{"data-svelte-h":!0}),s($t)!=="svelte-1t1y1q3"&&($t.textContent=Xr),to=o(e),m(kt.$$.fragment,e),io=o(e),xt=r(e,"P",{"data-svelte-h":!0}),s(xt)!=="svelte-2gi4z2"&&(xt.innerHTML=Yr),lo=o(e),m(At.$$.fragment,e),no=o(e),Ht=r(e,"P",{"data-svelte-h":!0}),s(Ht)!=="svelte-17998hi"&&(Ht.innerHTML=Fr),oo=o(e),m(Nt.$$.fragment,e),ao=o(e),Pt=r(e,"P",{"data-svelte-h":!0}),s(Pt)!=="svelte-1lzjagf"&&(Pt.textContent=Or),ro=o(e),m(Bt.$$.fragment,e),so=o(e),Zt=r(e,"P",{"data-svelte-h":!0}),s(Zt)!=="svelte-1e4mgvb"&&(Zt.textContent=Kr),po=o(e),Qt=r(e,"P",{"data-svelte-h":!0}),s(Qt)!=="svelte-1fia2hr"&&(Qt.innerHTML=es),mo=o(e),Wt=r(e,"P",{"data-svelte-h":!0}),s(Wt)!=="svelte-1vr2avi"&&(Wt.innerHTML=ts),uo=o(e),Dt=r(e,"P",{"data-svelte-h":!0}),s(Dt)!=="svelte-1t5012"&&(Dt.innerHTML=is),co=o(e),m(Rt.$$.fragment,e),Mo=o(e),qt=r(e,"P",{"data-svelte-h":!0}),s(qt)!=="svelte-9hyeti"&&(qt.innerHTML=ls),fo=o(e),Et=r(e,"P",{"data-svelte-h":!0}),s(Et)!=="svelte-11qu2xd"&&(Et.innerHTML=ns),go=o(e),m(Gt.$$.fragment,e),To=o(e),St=r(e,"P",{"data-svelte-h":!0}),s(St)!=="svelte-6sq3ph"&&(St.innerHTML=os),vo=o(e),Vt=r(e,"P",{"data-svelte-h":!0}),s(Vt)!=="svelte-13khp56"&&(Vt.innerHTML=as),wo=o(e),Xt=r(e,"UL",{"data-svelte-h":!0}),s(Xt)!=="svelte-rkz3oc"&&(Xt.innerHTML=rs),bo=o(e),Yt=r(e,"P",{"data-svelte-h":!0}),s(Yt)!=="svelte-1okwk4r"&&(Yt.innerHTML=ss),yo=o(e),Ft=r(e,"P",{"data-svelte-h":!0}),s(Ft)!=="svelte-1wms3g3"&&(Ft.innerHTML=ps),ho=o(e),Ot=r(e,"P",{"data-svelte-h":!0}),s(Ot)!=="svelte-i0maob"&&(Ot.innerHTML=ms),Jo=o(e),Kt=r(e,"P",{"data-svelte-h":!0}),s(Kt)!=="svelte-1c7vfm0"&&(Kt.innerHTML=us),Co=o(e),m(ei.$$.fragment,e),jo=o(e),ti=r(e,"P",{"data-svelte-h":!0}),s(ti)!=="svelte-8sms8k"&&(ti.textContent=cs),Uo=o(e),ii=r(e,"UL",{"data-svelte-h":!0}),s(ii)!=="svelte-1utz3yu"&&(ii.innerHTML=ds),_o=o(e),li=r(e,"P",{"data-svelte-h":!0}),s(li)!=="svelte-1xufcow"&&(li.innerHTML=Ms),Io=o(e),m(ni.$$.fragment,e),Lo=o(e),m(_.$$.fragment,e),zo=o(e),oi=r(e,"P",{"data-svelte-h":!0}),s(oi)!=="svelte-1dvwjty"&&(oi.innerHTML=fs),$o=o(e),ai=r(e,"UL",{"data-svelte-h":!0}),s(ai)!=="svelte-vlkyi5"&&(ai.innerHTML=gs),ko=o(e),ri=r(e,"P",{"data-svelte-h":!0}),s(ri)!=="svelte-ngul8x"&&(ri.innerHTML=Ts),xo=o(e),si=r(e,"P",{"data-svelte-h":!0}),s(si)!=="svelte-ytxoz9"&&(si.innerHTML=vs),Ao=o(e),pi=r(e,"P",{"data-svelte-h":!0}),s(pi)!=="svelte-sdkk44"&&(pi.textContent=ws),Ho=o(e),mi=r(e,"P",{"data-svelte-h":!0}),s(mi)!=="svelte-ohw0y7"&&(mi.innerHTML=bs),No=o(e),m(ui.$$.fragment,e),Po=o(e),ci=r(e,"P",{"data-svelte-h":!0}),s(ci)!=="svelte-1yo29jy"&&(ci.innerHTML=ys),Bo=o(e),m(di.$$.fragment,e),Zo=o(e),Mi=r(e,"P",{"data-svelte-h":!0}),s(Mi)!=="svelte-dj5zaz"&&(Mi.innerHTML=hs),Qo=o(e),fi=r(e,"P",{"data-svelte-h":!0}),s(fi)!=="svelte-1xqbzg9"&&(fi.innerHTML=Js),Wo=o(e),gi=r(e,"P",{"data-svelte-h":!0}),s(gi)!=="svelte-1yq64p9"&&(gi.innerHTML=Cs),Do=o(e),Ti=r(e,"P",{"data-svelte-h":!0}),s(Ti)!=="svelte-1somwnj"&&(Ti.innerHTML=js),Ro=o(e),vi=r(e,"P",{"data-svelte-h":!0}),s(vi)!=="svelte-1eolzno"&&(vi.innerHTML=Us),qo=o(e),wi=r(e,"P",{"data-svelte-h":!0}),s(wi)!=="svelte-vibpxl"&&(wi.innerHTML=_s),Eo=o(e),bi=r(e,"P",{"data-svelte-h":!0}),s(bi)!=="svelte-1nt2o60"&&(bi.innerHTML=Is),Go=o(e),yi=r(e,"P",{"data-svelte-h":!0}),s(yi)!=="svelte-17ikozp"&&(yi.innerHTML=Ls),So=o(e),hi=r(e,"P",{"data-svelte-h":!0}),s(hi)!=="svelte-17h78jd"&&(hi.innerHTML=zs),Vo=o(e),m(Ji.$$.fragment,e),Xo=o(e),Ci=r(e,"P",{"data-svelte-h":!0}),s(Ci)!=="svelte-168a2an"&&(Ci.textContent=$s),Yo=o(e),m(ji.$$.fragment,e),Fo=o(e),Ui=r(e,"P",{"data-svelte-h":!0}),s(Ui)!=="svelte-13nuxd8"&&(Ui.textContent=ks),Oo=o(e),_i=r(e,"P",{"data-svelte-h":!0}),s(_i)!=="svelte-18k5kow"&&(_i.textContent=xs),Ko=o(e),Ii=r(e,"P",{"data-svelte-h":!0}),s(Ii)!=="svelte-1ftaoot"&&(Ii.textContent=As),ea=o(e),Li=r(e,"P",{"data-svelte-h":!0}),s(Li)!=="svelte-1iv4oh1"&&(Li.innerHTML=Hs),ta=o(e),zi=r(e,"P",{"data-svelte-h":!0}),s(zi)!=="svelte-bo6tk8"&&(zi.innerHTML=Ns),ia=o(e),m($i.$$.fragment,e),la=o(e),ki=r(e,"P",{"data-svelte-h":!0}),s(ki)!=="svelte-6hjvqd"&&(ki.innerHTML=Ps),na=o(e),xi=r(e,"P",{"data-svelte-h":!0}),s(xi)!=="svelte-1xvbv99"&&(xi.innerHTML=Bs),oa=o(e),Ai=r(e,"P",{"data-svelte-h":!0}),s(Ai)!=="svelte-wwq3kk"&&(Ai.innerHTML=Zs),aa=o(e),Hi=r(e,"P",{"data-svelte-h":!0}),s(Hi)!=="svelte-1s6evuy"&&(Hi.innerHTML=Qs),ra=o(e),Ni=r(e,"P",{"data-svelte-h":!0}),s(Ni)!=="svelte-1d6fg3c"&&(Ni.textContent=Ws),sa=o(e),m(Pi.$$.fragment,e),pa=o(e),Bi=r(e,"P",{"data-svelte-h":!0}),s(Bi)!=="svelte-1wuu6xv"&&(Bi.textContent=Ds),ma=o(e),Zi=r(e,"P",{"data-svelte-h":!0}),s(Zi)!=="svelte-1oczpay"&&(Zi.innerHTML=Rs),ua=o(e),Di=r(e,"P",{}),Es(Di).forEach(i),this.h()},h(){w(g,"name","hf:doc:metadata"),w(g,"content",np),Ss(Wi.src,Ua="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers_overview.png")||w(Wi,"src",Ua),w(b,"start","3"),w(y,"start","4"),w(h,"start","5"),w(J,"start","2"),w(C,"start","3"),w(j,"start","4"),w(U,"start","5")},m(e,t){Ks(document.head,g),l(e,I,t),l(e,T,t),l(e,Qi,t),u(L,e,t),l(e,qi,t),l(e,z,t),l(e,Ei,t),l(e,$,t),l(e,Gi,t),l(e,k,t),l(e,Si,t),l(e,x,t),l(e,Vi,t),l(e,A,t),l(e,Xi,t),l(e,H,t),l(e,Yi,t),u(N,e,t),l(e,Fi,t),l(e,P,t),l(e,Oi,t),l(e,B,t),l(e,Ki,t),l(e,Z,t),l(e,el,t),l(e,Q,t),l(e,tl,t),l(e,W,t),l(e,il,t),u(D,e,t),l(e,ll,t),l(e,R,t),l(e,nl,t),l(e,q,t),l(e,ol,t),l(e,Wi,t),l(e,al,t),l(e,E,t),l(e,rl,t),u(G,e,t),l(e,sl,t),l(e,S,t),l(e,pl,t),u(V,e,t),l(e,ml,t),l(e,X,t),l(e,ul,t),l(e,Y,t),l(e,cl,t),u(F,e,t),l(e,dl,t),l(e,O,t),l(e,Ml,t),u(K,e,t),l(e,fl,t),l(e,ee,t),l(e,gl,t),l(e,te,t),l(e,Tl,t),l(e,ie,t),l(e,vl,t),l(e,le,t),l(e,wl,t),l(e,ne,t),l(e,bl,t),l(e,oe,t),l(e,yl,t),l(e,ae,t),l(e,hl,t),l(e,re,t),l(e,Jl,t),u(se,e,t),l(e,Cl,t),l(e,pe,t),l(e,jl,t),l(e,me,t),l(e,Ul,t),l(e,ue,t),l(e,_l,t),u(ce,e,t),l(e,Il,t),l(e,de,t),l(e,Ll,t),u(Me,e,t),l(e,zl,t),l(e,b,t),l(e,$l,t),u(fe,e,t),l(e,kl,t),l(e,ge,t),l(e,xl,t),u(Te,e,t),l(e,Al,t),l(e,y,t),l(e,Hl,t),l(e,ve,t),l(e,Nl,t),l(e,h,t),l(e,Pl,t),u(we,e,t),l(e,Bl,t),l(e,be,t),l(e,Zl,t),u(ye,e,t),l(e,Ql,t),l(e,he,t),l(e,Wl,t),l(e,Je,t),l(e,Dl,t),l(e,Ce,t),l(e,Rl,t),l(e,je,t),l(e,ql,t),l(e,Ue,t),l(e,El,t),l(e,_e,t),l(e,Gl,t),l(e,Ie,t),l(e,Sl,t),l(e,Le,t),l(e,Vl,t),l(e,ze,t),l(e,Xl,t),l(e,$e,t),l(e,Yl,t),u(ke,e,t),l(e,Fl,t),l(e,xe,t),l(e,Ol,t),l(e,Ae,t),l(e,Kl,t),l(e,He,t),l(e,en,t),l(e,Ne,t),l(e,tn,t),l(e,Pe,t),l(e,ln,t),l(e,Be,t),l(e,nn,t),l(e,Ze,t),l(e,on,t),l(e,Qe,t),l(e,an,t),l(e,We,t),l(e,rn,t),l(e,De,t),l(e,sn,t),l(e,Re,t),l(e,pn,t),u(qe,e,t),l(e,mn,t),l(e,Ee,t),l(e,un,t),l(e,Ge,t),l(e,cn,t),l(e,Se,t),l(e,dn,t),u(Ve,e,t),l(e,Mn,t),l(e,Xe,t),l(e,fn,t),u(Ye,e,t),l(e,gn,t),l(e,Fe,t),l(e,Tn,t),l(e,Oe,t),l(e,vn,t),l(e,Ke,t),l(e,wn,t),l(e,et,t),l(e,bn,t),l(e,tt,t),l(e,yn,t),l(e,it,t),l(e,hn,t),l(e,lt,t),l(e,Jn,t),l(e,nt,t),l(e,Cn,t),u(ot,e,t),l(e,jn,t),l(e,J,t),l(e,Un,t),u(at,e,t),l(e,_n,t),l(e,C,t),l(e,In,t),u(rt,e,t),l(e,Ln,t),l(e,j,t),l(e,zn,t),u(st,e,t),l(e,$n,t),l(e,U,t),l(e,kn,t),l(e,pt,t),l(e,xn,t),u(mt,e,t),l(e,An,t),l(e,ut,t),l(e,Hn,t),l(e,ct,t),l(e,Nn,t),l(e,dt,t),l(e,Pn,t),l(e,Mt,t),l(e,Bn,t),l(e,ft,t),l(e,Zn,t),l(e,gt,t),l(e,Qn,t),l(e,Tt,t),l(e,Wn,t),u(vt,e,t),l(e,Dn,t),l(e,wt,t),l(e,Rn,t),l(e,bt,t),l(e,qn,t),l(e,yt,t),l(e,En,t),l(e,ht,t),l(e,Gn,t),l(e,Jt,t),l(e,Sn,t),u(Ct,e,t),l(e,Vn,t),l(e,jt,t),l(e,Xn,t),u(Ut,e,t),l(e,Yn,t),l(e,_t,t),l(e,Fn,t),u(It,e,t),l(e,On,t),l(e,Lt,t),l(e,Kn,t),u(zt,e,t),l(e,eo,t),l(e,$t,t),l(e,to,t),u(kt,e,t),l(e,io,t),l(e,xt,t),l(e,lo,t),u(At,e,t),l(e,no,t),l(e,Ht,t),l(e,oo,t),u(Nt,e,t),l(e,ao,t),l(e,Pt,t),l(e,ro,t),u(Bt,e,t),l(e,so,t),l(e,Zt,t),l(e,po,t),l(e,Qt,t),l(e,mo,t),l(e,Wt,t),l(e,uo,t),l(e,Dt,t),l(e,co,t),u(Rt,e,t),l(e,Mo,t),l(e,qt,t),l(e,fo,t),l(e,Et,t),l(e,go,t),u(Gt,e,t),l(e,To,t),l(e,St,t),l(e,vo,t),l(e,Vt,t),l(e,wo,t),l(e,Xt,t),l(e,bo,t),l(e,Yt,t),l(e,yo,t),l(e,Ft,t),l(e,ho,t),l(e,Ot,t),l(e,Jo,t),l(e,Kt,t),l(e,Co,t),u(ei,e,t),l(e,jo,t),l(e,ti,t),l(e,Uo,t),l(e,ii,t),l(e,_o,t),l(e,li,t),l(e,Io,t),u(ni,e,t),l(e,Lo,t),u(_,e,t),l(e,zo,t),l(e,oi,t),l(e,$o,t),l(e,ai,t),l(e,ko,t),l(e,ri,t),l(e,xo,t),l(e,si,t),l(e,Ao,t),l(e,pi,t),l(e,Ho,t),l(e,mi,t),l(e,No,t),u(ui,e,t),l(e,Po,t),l(e,ci,t),l(e,Bo,t),u(di,e,t),l(e,Zo,t),l(e,Mi,t),l(e,Qo,t),l(e,fi,t),l(e,Wo,t),l(e,gi,t),l(e,Do,t),l(e,Ti,t),l(e,Ro,t),l(e,vi,t),l(e,qo,t),l(e,wi,t),l(e,Eo,t),l(e,bi,t),l(e,Go,t),l(e,yi,t),l(e,So,t),l(e,hi,t),l(e,Vo,t),u(Ji,e,t),l(e,Xo,t),l(e,Ci,t),l(e,Yo,t),u(ji,e,t),l(e,Fo,t),l(e,Ui,t),l(e,Oo,t),l(e,_i,t),l(e,Ko,t),l(e,Ii,t),l(e,ea,t),l(e,Li,t),l(e,ta,t),l(e,zi,t),l(e,ia,t),u($i,e,t),l(e,la,t),l(e,ki,t),l(e,na,t),l(e,xi,t),l(e,oa,t),l(e,Ai,t),l(e,aa,t),l(e,Hi,t),l(e,ra,t),l(e,Ni,t),l(e,sa,t),u(Pi,e,t),l(e,pa,t),l(e,Bi,t),l(e,ma,t),l(e,Zi,t),l(e,ua,t),l(e,Di,t),ca=!0},p(e,[t]){const qs={};t&2&&(qs.$$scope={dirty:t,ctx:e}),_.$set(qs)},i(e){ca||(c(L.$$.fragment,e),c(N.$$.fragment,e),c(D.$$.fragment,e),c(G.$$.fragment,e),c(V.$$.fragment,e),c(F.$$.fragment,e),c(K.$$.fragment,e),c(se.$$.fragment,e),c(ce.$$.fragment,e),c(Me.$$.fragment,e),c(fe.$$.fragment,e),c(Te.$$.fragment,e),c(we.$$.fragment,e),c(ye.$$.fragment,e),c(ke.$$.fragment,e),c(qe.$$.fragment,e),c(Ve.$$.fragment,e),c(Ye.$$.fragment,e),c(ot.$$.fragment,e),c(at.$$.fragment,e),c(rt.$$.fragment,e),c(st.$$.fragment,e),c(mt.$$.fragment,e),c(vt.$$.fragment,e),c(Ct.$$.fragment,e),c(Ut.$$.fragment,e),c(It.$$.fragment,e),c(zt.$$.fragment,e),c(kt.$$.fragment,e),c(At.$$.fragment,e),c(Nt.$$.fragment,e),c(Bt.$$.fragment,e),c(Rt.$$.fragment,e),c(Gt.$$.fragment,e),c(ei.$$.fragment,e),c(ni.$$.fragment,e),c(_.$$.fragment,e),c(ui.$$.fragment,e),c(di.$$.fragment,e),c(Ji.$$.fragment,e),c(ji.$$.fragment,e),c($i.$$.fragment,e),c(Pi.$$.fragment,e),ca=!0)},o(e){d(L.$$.fragment,e),d(N.$$.fragment,e),d(D.$$.fragment,e),d(G.$$.fragment,e),d(V.$$.fragment,e),d(F.$$.fragment,e),d(K.$$.fragment,e),d(se.$$.fragment,e),d(ce.$$.fragment,e),d(Me.$$.fragment,e),d(fe.$$.fragment,e),d(Te.$$.fragment,e),d(we.$$.fragment,e),d(ye.$$.fragment,e),d(ke.$$.fragment,e),d(qe.$$.fragment,e),d(Ve.$$.fragment,e),d(Ye.$$.fragment,e),d(ot.$$.fragment,e),d(at.$$.fragment,e),d(rt.$$.fragment,e),d(st.$$.fragment,e),d(mt.$$.fragment,e),d(vt.$$.fragment,e),d(Ct.$$.fragment,e),d(Ut.$$.fragment,e),d(It.$$.fragment,e),d(zt.$$.fragment,e),d(kt.$$.fragment,e),d(At.$$.fragment,e),d(Nt.$$.fragment,e),d(Bt.$$.fragment,e),d(Rt.$$.fragment,e),d(Gt.$$.fragment,e),d(ei.$$.fragment,e),d(ni.$$.fragment,e),d(_.$$.fragment,e),d(ui.$$.fragment,e),d(di.$$.fragment,e),d(Ji.$$.fragment,e),d(ji.$$.fragment,e),d($i.$$.fragment,e),d(Pi.$$.fragment,e),ca=!1},d(e){e&&(i(I),i(T),i(Qi),i(qi),i(z),i(Ei),i($),i(Gi),i(k),i(Si),i(x),i(Vi),i(A),i(Xi),i(H),i(Yi),i(Fi),i(P),i(Oi),i(B),i(Ki),i(Z),i(el),i(Q),i(tl),i(W),i(il),i(ll),i(R),i(nl),i(q),i(ol),i(Wi),i(al),i(E),i(rl),i(sl),i(S),i(pl),i(ml),i(X),i(ul),i(Y),i(cl),i(dl),i(O),i(Ml),i(fl),i(ee),i(gl),i(te),i(Tl),i(ie),i(vl),i(le),i(wl),i(ne),i(bl),i(oe),i(yl),i(ae),i(hl),i(re),i(Jl),i(Cl),i(pe),i(jl),i(me),i(Ul),i(ue),i(_l),i(Il),i(de),i(Ll),i(zl),i(b),i($l),i(kl),i(ge),i(xl),i(Al),i(y),i(Hl),i(ve),i(Nl),i(h),i(Pl),i(Bl),i(be),i(Zl),i(Ql),i(he),i(Wl),i(Je),i(Dl),i(Ce),i(Rl),i(je),i(ql),i(Ue),i(El),i(_e),i(Gl),i(Ie),i(Sl),i(Le),i(Vl),i(ze),i(Xl),i($e),i(Yl),i(Fl),i(xe),i(Ol),i(Ae),i(Kl),i(He),i(en),i(Ne),i(tn),i(Pe),i(ln),i(Be),i(nn),i(Ze),i(on),i(Qe),i(an),i(We),i(rn),i(De),i(sn),i(Re),i(pn),i(mn),i(Ee),i(un),i(Ge),i(cn),i(Se),i(dn),i(Mn),i(Xe),i(fn),i(gn),i(Fe),i(Tn),i(Oe),i(vn),i(Ke),i(wn),i(et),i(bn),i(tt),i(yn),i(it),i(hn),i(lt),i(Jn),i(nt),i(Cn),i(jn),i(J),i(Un),i(_n),i(C),i(In),i(Ln),i(j),i(zn),i($n),i(U),i(kn),i(pt),i(xn),i(An),i(ut),i(Hn),i(ct),i(Nn),i(dt),i(Pn),i(Mt),i(Bn),i(ft),i(Zn),i(gt),i(Qn),i(Tt),i(Wn),i(Dn),i(wt),i(Rn),i(bt),i(qn),i(yt),i(En),i(ht),i(Gn),i(Jt),i(Sn),i(Vn),i(jt),i(Xn),i(Yn),i(_t),i(Fn),i(On),i(Lt),i(Kn),i(eo),i($t),i(to),i(io),i(xt),i(lo),i(no),i(Ht),i(oo),i(ao),i(Pt),i(ro),i(so),i(Zt),i(po),i(Qt),i(mo),i(Wt),i(uo),i(Dt),i(co),i(Mo),i(qt),i(fo),i(Et),i(go),i(To),i(St),i(vo),i(Vt),i(wo),i(Xt),i(bo),i(Yt),i(yo),i(Ft),i(ho),i(Ot),i(Jo),i(Kt),i(Co),i(jo),i(ti),i(Uo),i(ii),i(_o),i(li),i(Io),i(Lo),i(zo),i(oi),i($o),i(ai),i(ko),i(ri),i(xo),i(si),i(Ao),i(pi),i(Ho),i(mi),i(No),i(Po),i(ci),i(Bo),i(Zo),i(Mi),i(Qo),i(fi),i(Wo),i(gi),i(Do),i(Ti),i(Ro),i(vi),i(qo),i(wi),i(Eo),i(bi),i(Go),i(yi),i(So),i(hi),i(Vo),i(Xo),i(Ci),i(Yo),i(Fo),i(Ui),i(Oo),i(_i),i(Ko),i(Ii),i(ea),i(Li),i(ta),i(zi),i(ia),i(la),i(ki),i(na),i(xi),i(oa),i(Ai),i(aa),i(Hi),i(ra),i(Ni),i(sa),i(pa),i(Bi),i(ma),i(Zi),i(ua),i(Di)),i(g),M(L,e),M(N,e),M(D,e),M(G,e),M(V,e),M(F,e),M(K,e),M(se,e),M(ce,e),M(Me,e),M(fe,e),M(Te,e),M(we,e),M(ye,e),M(ke,e),M(qe,e),M(Ve,e),M(Ye,e),M(ot,e),M(at,e),M(rt,e),M(st,e),M(mt,e),M(vt,e),M(Ct,e),M(Ut,e),M(It,e),M(zt,e),M(kt,e),M(At,e),M(Nt,e),M(Bt,e),M(Rt,e),M(Gt,e),M(ei,e),M(ni,e),M(_,e),M(ui,e),M(di,e),M(Ji,e),M(ji,e),M($i,e),M(Pi,e)}}}const np='{"title":"Come aggiungere un modello a 🤗 Transformers?","local":"come-aggiungere-un-modello-a--transformers","sections":[{"title":"Panoramica generale su 🤗 Transformers","local":"panoramica-generale-su--transformers","sections":[{"title":"Panoramica sui modelli","local":"panoramica-sui-modelli","sections":[],"depth":3},{"title":"Stile per il codice","local":"stile-per-il-codice","sections":[],"depth":3},{"title":"Panoramica sui tokenizers","local":"panoramica-sui-tokenizers","sections":[],"depth":3}],"depth":2},{"title":"Aggiungere un modello a 🤗 Transformers passo dopo passo","local":"aggiungere-un-modello-a--transformers-passo-dopo-passo","sections":[{"title":"1. (Opzionale) Aspetti teorici di BrandNewBert","local":"1-opzionale-aspetti-teorici-di-brandnewbert","sections":[],"depth":3},{"title":"2. Prepare il tuo ambiente","local":"2-prepare-il-tuo-ambiente","sections":[],"depth":3},{"title":"3.-4. Provare un pretrained checkpoint usando la repo originale","local":"3-4-provare-un-pretrained-checkpoint-usando-la-repo-originale","sections":[],"depth":3},{"title":"5.-14. Trasferire BrandNewBert in 🤗 Transformers","local":"5-14-trasferire-brandnewbert-in--transformers","sections":[],"depth":3},{"title":"Condividete il vostro lavoro!!","local":"condividete-il-vostro-lavoro","sections":[],"depth":3}],"depth":2}],"depth":1}';function op(Ri){return Vs(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=ep}),[]}class up extends Ys{constructor(g){super(),Fs(this,g,op,lp,Gs,{})}}export{up as component};
