import{s as Qs,o as Hs,n as zt}from"../chunks/scheduler.0219f8bd.js";import{S as Ns,i as Ss,g as p,s as a,r,A as Ls,h as i,f as s,c as n,j as Gs,u as h,x as o,k as Es,y as As,a as l,v as m,d,t as M,w as u}from"../chunks/index.f61edf3b.js";import{T as _t}from"../chunks/Tip.5d1e3ef4.js";import{C as T}from"../chunks/CodeBlock.15473de1.js";import{H as We,E as Rs}from"../chunks/getInferenceSnippets.b5792783.js";function Ys(b){let c,w='The <code>type=&quot;module&quot;</code> attribute is important, as it turns our file into a <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Modules" rel="nofollow">JavaScript module</a>, meaning that we’ll be able to use imports and exports.';return{c(){c=p("p"),c.innerHTML=w},l(j){c=i(j,"P",{"data-svelte-h":!0}),o(c)!=="svelte-kr58bn"&&(c.innerHTML=w)},m(j,J){l(j,c,J)},p:zt,d(j){j&&s(c)}}}function _s(b){let c,w='To keep this tutorial simple, we’ll be loading and running the model in the main (UI) thread. This is not recommended for production applications, since the UI will freeze when we’re performing these actions. This is because JavaScript is a single-threaded language. To overcome this, you can use a <a href="https://developer.mozilla.org/en-US/docs/Web/API/Web_Workers_API/Using_web_workers" rel="nofollow">web worker</a> to download and run the model in the background. However, we’re not going to do cover that in this tutorial…';return{c(){c=p("p"),c.innerHTML=w},l(j){c=i(j,"P",{"data-svelte-h":!0}),o(c)!=="svelte-g1c7oq"&&(c.innerHTML=w)},m(j,J){l(j,c,J)},p:zt,d(j){j&&s(c)}}}function zs(b){let c,w="NOTE: The <code>detect</code> function needs to be asynchronous, since we’ll <code>await</code> the result of the the model.";return{c(){c=p("p"),c.innerHTML=w},l(j){c=i(j,"P",{"data-svelte-h":!0}),o(c)!=="svelte-2c69hg"&&(c.innerHTML=w)},m(j,J){l(j,c,J)},p:zt,d(j){j&&s(c)}}}function Vs(b){let c,w,j,J,U,ke,I,Vt="In this tutorial, you’ll build a simple web application that detects objects in images using Transformers.js! To follow along, all you need is a code editor, a browser, and a simple server (e.g., VS Code Live Server).",Ge,C,qt="Here’s how it works: the user clicks “Upload image” and selects an image using an input dialog. After analysing the image with an object detection model, the predicted bounding boxes are overlaid on top of the image, like this:",Ee,v,Xt='<img src="https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/js-detection-interence-zebra.png" alt="Demo"/>',Qe,$,Ft="Useful links:",He,x,Dt='<li><a href="https://huggingface.co/spaces/Scrimba/vanilla-js-object-detector" rel="nofollow">Demo site</a></li> <li><a href="https://scrimba.com/scrim/cKm9bDAg" rel="nofollow">Interactive code walk-through (scrim)</a></li> <li><a href="https://github.com/huggingface/transformers.js/tree/main/examples/vanilla-js" rel="nofollow">Source code</a></li>',Ne,B,Se,W,Pt="Before we start building with Transformers.js, we first need to lay the groundwork with some markup and styling. Create an <code>index.html</code> file with a basic HTML skeleton, and add the following <code>&lt;main&gt;</code> tag to the <code>&lt;body&gt;</code>:",Le,Z,Ae,k,Kt="<summary>Click here to see a breakdown of this markup.</summary> <p>We’re adding an <code>&lt;input&gt;</code> element with <code>type=&quot;file&quot;</code> that accepts images. This allows the user to select an image from their local file system using a popup dialog. The default styling for this element looks quite bad, so let’s add some styling. The easiest way to achieve this is to wrap the <code>&lt;input&gt;</code> element in a <code>&lt;label&gt;</code>, hide the input, and then style the label as a button.</p> <p>We’re also adding an empty <code>&lt;div&gt;</code> container for displaying the image, plus an empty <code>&lt;p&gt;</code> tag that we’ll use to give status updates to the user while we download and run the model, since both of these operations take some time.</p>",Re,G,Ot="Next, add the following CSS rules in a <code>style.css</code> file and link it to the HTML:",Ye,E,_e,Q,es="Here’s how the UI looks at this point:",ze,H,ts='<img src="https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/js-detection-btn.png" alt="Demo"/>',Ve,N,qe,S,ss="With the <em>boring</em> part out of the way, let’s start writing some JavaScript code! Create a file called <code>index.js</code> and link to it in <code>index.html</code> by adding the following to the end of the <code>&lt;body&gt;</code>:",Xe,L,Fe,f,De,A,ls="Moving into <code>index.js</code>, let’s import Transformers.js by adding the following line to the top of the file:",Pe,R,Ke,Y,as="Since we will be downloading the model from the Hugging Face Hub, we can skip the local model check by setting:",Oe,_,et,z,ns="Next, let’s create references to the various DOM elements we will access later:",tt,V,st,q,lt,X,ps='We’re finally ready to create our object detection pipeline! As a reminder, a <a href="../pipelines">pipeline</a>. is a high-level interface provided by the library to perform a specific task. In our case, we will instantiate an object detection pipeline with the <code>pipeline()</code> helper function.',at,F,is="Since this can take some time (especially the first time when we have to download the ~40MB model), we first update the <code>status</code> paragraph so that the user knows that we’re about to load the model.",nt,D,pt,y,it,P,os="We can now call the <code>pipeline()</code> function that we imported at the top of our file, to create our object detection pipeline:",ot,K,ct,O,cs="We’re passing two arguments into the <code>pipeline()</code> function: (1) task and (2) model.",rt,ee,rs='<li><p>The first tells Transformers.js what kind of task we want to perform. In our case, that is <code>object-detection</code>, but there are many other tasks that the library supports, including <code>text-generation</code>, <code>sentiment-analysis</code>, <code>summarization</code>, or <code>automatic-speech-recognition</code>. See <a href="https://huggingface.co/docs/transformers.js/pipelines#tasks" rel="nofollow">here</a> for the full list.</p></li> <li><p>The second argument specifies which model we would like to use to solve the given task. We will use <a href="https://huggingface.co/Xenova/detr-resnet-50" rel="nofollow"><code>Xenova/detr-resnet-50</code></a>, as it is a relatively small (~40MB) but powerful model for detecting objects in an image.</p></li>',ht,te,hs="Once the function returns, we’ll tell the user that the app is ready to be used.",mt,se,dt,le,Mt,ae,ms="The next step is to support uploading/selection of images. To achieve this, we will listen for “change” events from the <code>fileUpload</code> element. In the callback function, we use a <code>FileReader()</code> to read the contents of the image if one is selected (and nothing otherwise).",ut,ne,jt,pe,ds="Once the image has been loaded into the browser, the <code>reader.onload</code> callback function will be invoked. In it, we append the new <code>&lt;img&gt;</code> element to the <code>imageContainer</code> to be displayed to the user.",Tt,ie,Ms="Don’t worry about the <code>detect(image)</code> function call (which is commented out) - we will explain it later! For now, try to run the app and upload an image to the browser. You should see your image displayed under the button like this:",wt,oe,us='<img src="https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/js-detection-btn-img.png" alt="Demo"/>',Jt,ce,bt,re,js="We’re finally ready to start interacting with Transformers.js! Let’s uncomment the <code>detect(image)</code> function call from the snippet above. Then we’ll define the function itself:",ft,he,yt,g,gt,me,Ts="Once we’ve updated the <code>status</code> to “Analysing”, we’re ready to perform <em>inference</em>, which simply means to run the model with some data. This is done via the <code>detector()</code> function that was returned from <code>pipeline()</code>. The first argument we’re passing is the image data (<code>img.src</code>).",Ut,de,ws="The second argument is an options object:",It,Me,Js="<li>We set the <code>threshold</code> property to <code>0.5</code>. This means that we want the model to be at least 50% confident before claiming it has detected an object in the image. The lower the threshold, the more objects it’ll detect (but may misidentify objects); the higher the threshold, the fewer objects it’ll detect (but may miss objects in the scene).</li> <li>We also specify <code>percentage: true</code>, which means that we want the bounding box for the objects to be returned as percentages (instead of pixels).</li>",Ct,ue,bs="If you now try to run the app and upload an image, you should see the following output logged to the console:",vt,je,fs='<img src="https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/js-detection-console.png" alt="Demo"/>',$t,Te,ys="In the example above, we uploaded an image of two elephants, so the <code>output</code> variable holds an array with two objects, each containing a <code>label</code> (the string “elephant”), a <code>score</code> (indicating the model’s confidence in its prediction) and a <code>box</code> object (representing the bounding box of the detected entity).",xt,we,Bt,Je,gs="The final step is to display the <code>box</code> coordinates as rectangles around each of the elephants.",Wt,be,Us="At the end of our <code>detect()</code> function, we’ll run the <code>renderBox</code> function on each object in the <code>output</code> array, using <code>.forEach()</code>.",Zt,fe,kt,ye,Is="Here’s the code for the <code>renderBox()</code> function with comments to help you understand what’s going on:",Gt,ge,Et,Ue,Cs="The bounding box and label span also need some styling, so add the following to the <code>style.css</code> file:",Qt,Ie,Ht,Ce,vs="<strong>And that’s it!</strong>",Nt,ve,$s="You’ve now built your own fully-functional AI application that detects objects in images, which runns completely in your browser: no external server, APIs, or build tools. Pretty cool! 🥳",St,$e,xs='<img src="https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/js-detection-inference-elephant.png" alt="Demo"/>',Lt,xe,Bs='The app is live at the following URL: <a href="https://huggingface.co/spaces/Scrimba/vanilla-js-object-detector" rel="nofollow">https://huggingface.co/spaces/Scrimba/vanilla-js-object-detector</a>',At,Be,Rt,Ze,Yt;return U=new We({props:{title:"Building a Vanilla JavaScript Application",local:"building-a-vanilla-javascript-application",headingTag:"h1"}}),B=new We({props:{title:"Step 1:  HTML and CSS setup",local:"step-1-html-and-css-setup",headingTag:"h2"}}),Z=new T({props:{code:"JTNDbWFpbiUyMGNsYXNzJTNEJTIyY29udGFpbmVyJTIyJTNFJTBBJTIwJTIwJTNDbGFiZWwlMjBjbGFzcyUzRCUyMmN1c3RvbS1maWxlLXVwbG9hZCUyMiUzRSUwQSUyMCUyMCUyMCUyMCUzQ2lucHV0JTIwaWQlM0QlMjJmaWxlLXVwbG9hZCUyMiUyMHR5cGUlM0QlMjJmaWxlJTIyJTIwYWNjZXB0JTNEJTIyaW1hZ2UlMkYqJTIyJTIwJTJGJTNFJTBBJTIwJTIwJTIwJTIwJTNDaW1nJTIwY2xhc3MlM0QlMjJ1cGxvYWQtaWNvbiUyMiUyMHNyYyUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ1cGxvYWQtaWNvbi5wbmclMjIlMjAlMkYlM0UlMEElMjAlMjAlMjAlMjBVcGxvYWQlMjBpbWFnZSUwQSUyMCUyMCUzQyUyRmxhYmVsJTNFJTBBJTIwJTIwJTNDZGl2JTIwaWQlM0QlMjJpbWFnZS1jb250YWluZXIlMjIlM0UlM0MlMkZkaXYlM0UlMEElMjAlMjAlM0NwJTIwaWQlM0QlMjJzdGF0dXMlMjIlM0UlM0MlMkZwJTNFJTBBJTNDJTJGbWFpbiUzRQ==",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">main</span> <span class="hljs-attr">class</span>=<span class="hljs-string">&quot;container&quot;</span>&gt;</span>
  <span class="hljs-tag">&lt;<span class="hljs-name">label</span> <span class="hljs-attr">class</span>=<span class="hljs-string">&quot;custom-file-upload&quot;</span>&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">input</span> <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;file-upload&quot;</span> <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;file&quot;</span> <span class="hljs-attr">accept</span>=<span class="hljs-string">&quot;image/*&quot;</span> /&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">img</span> <span class="hljs-attr">class</span>=<span class="hljs-string">&quot;upload-icon&quot;</span> <span class="hljs-attr">src</span>=<span class="hljs-string">&quot;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/upload-icon.png&quot;</span> /&gt;</span>
    Upload image
  <span class="hljs-tag">&lt;/<span class="hljs-name">label</span>&gt;</span>
  <span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;image-container&quot;</span>&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span>
  <span class="hljs-tag">&lt;<span class="hljs-name">p</span> <span class="hljs-attr">id</span>=<span class="hljs-string">&quot;status&quot;</span>&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">p</span>&gt;</span>
<span class="hljs-tag">&lt;/<span class="hljs-name">main</span>&gt;</span>`,wrap:!1}}),E=new T({props:{code:"aHRtbCUyQyUwQWJvZHklMjAlN0IlMEElMjAlMjAlMjAlMjBmb250LWZhbWlseSUzQSUyMEFyaWFsJTJDJTIwSGVsdmV0aWNhJTJDJTIwc2Fucy1zZXJpZiUzQiUwQSU3RCUwQSUwQS5jb250YWluZXIlMjAlN0IlMEElMjAlMjAlMjAlMjBtYXJnaW4lM0ElMjA0MHB4JTIwYXV0byUzQiUwQSUyMCUyMCUyMCUyMHdpZHRoJTNBJTIwbWF4KDUwdnclMkMlMjA0MDBweCklM0IlMEElMjAlMjAlMjAlMjBkaXNwbGF5JTNBJTIwZmxleCUzQiUwQSUyMCUyMCUyMCUyMGZsZXgtZGlyZWN0aW9uJTNBJTIwY29sdW1uJTNCJTBBJTIwJTIwJTIwJTIwYWxpZ24taXRlbXMlM0ElMjBjZW50ZXIlM0IlMEElN0QlMEElMEEuY3VzdG9tLWZpbGUtdXBsb2FkJTIwJTdCJTBBJTIwJTIwJTIwJTIwZGlzcGxheSUzQSUyMGZsZXglM0IlMEElMjAlMjAlMjAlMjBhbGlnbi1pdGVtcyUzQSUyMGNlbnRlciUzQiUwQSUyMCUyMCUyMCUyMGdhcCUzQSUyMDEwcHglM0IlMEElMjAlMjAlMjAlMjBib3JkZXIlM0ElMjAycHglMjBzb2xpZCUyMGJsYWNrJTNCJTBBJTIwJTIwJTIwJTIwcGFkZGluZyUzQSUyMDhweCUyMDE2cHglM0IlMEElMjAlMjAlMjAlMjBjdXJzb3IlM0ElMjBwb2ludGVyJTNCJTBBJTIwJTIwJTIwJTIwYm9yZGVyLXJhZGl1cyUzQSUyMDZweCUzQiUwQSU3RCUwQSUwQSUyM2ZpbGUtdXBsb2FkJTIwJTdCJTBBJTIwJTIwJTIwJTIwZGlzcGxheSUzQSUyMG5vbmUlM0IlMEElN0QlMEElMEEudXBsb2FkLWljb24lMjAlN0IlMEElMjAlMjAlMjAlMjB3aWR0aCUzQSUyMDMwcHglM0IlMEElN0QlMEElMEElMjNpbWFnZS1jb250YWluZXIlMjAlN0IlMEElMjAlMjAlMjAlMjB3aWR0aCUzQSUyMDEwMCUyNSUzQiUwQSUyMCUyMCUyMCUyMG1hcmdpbi10b3AlM0ElMjAyMHB4JTNCJTBBJTIwJTIwJTIwJTIwcG9zaXRpb24lM0ElMjByZWxhdGl2ZSUzQiUwQSU3RCUwQSUwQSUyM2ltYWdlLWNvbnRhaW5lciUzRWltZyUyMCU3QiUwQSUyMCUyMCUyMCUyMHdpZHRoJTNBJTIwMTAwJTI1JTNCJTBBJTdE",highlighted:`<span class="hljs-selector-tag">html</span>,
<span class="hljs-selector-tag">body</span> {
    <span class="hljs-attribute">font-family</span>: Arial, Helvetica, sans-serif;
}

<span class="hljs-selector-class">.container</span> {
    <span class="hljs-attribute">margin</span>: <span class="hljs-number">40px</span> auto;
    <span class="hljs-attribute">width</span>: <span class="hljs-built_in">max</span>(<span class="hljs-number">50vw</span>, <span class="hljs-number">400px</span>);
    <span class="hljs-attribute">display</span>: flex;
    <span class="hljs-attribute">flex-direction</span>: column;
    <span class="hljs-attribute">align-items</span>: center;
}

<span class="hljs-selector-class">.custom-file-upload</span> {
    <span class="hljs-attribute">display</span>: flex;
    <span class="hljs-attribute">align-items</span>: center;
    <span class="hljs-attribute">gap</span>: <span class="hljs-number">10px</span>;
    <span class="hljs-attribute">border</span>: <span class="hljs-number">2px</span> solid black;
    <span class="hljs-attribute">padding</span>: <span class="hljs-number">8px</span> <span class="hljs-number">16px</span>;
    <span class="hljs-attribute">cursor</span>: pointer;
    <span class="hljs-attribute">border-radius</span>: <span class="hljs-number">6px</span>;
}

<span class="hljs-selector-id">#file-upload</span> {
    <span class="hljs-attribute">display</span>: none;
}

<span class="hljs-selector-class">.upload-icon</span> {
    <span class="hljs-attribute">width</span>: <span class="hljs-number">30px</span>;
}

<span class="hljs-selector-id">#image-container</span> {
    <span class="hljs-attribute">width</span>: <span class="hljs-number">100%</span>;
    <span class="hljs-attribute">margin-top</span>: <span class="hljs-number">20px</span>;
    <span class="hljs-attribute">position</span>: relative;
}

<span class="hljs-selector-id">#image-container</span>&gt;<span class="hljs-selector-tag">img</span> {
    <span class="hljs-attribute">width</span>: <span class="hljs-number">100%</span>;
}`,wrap:!1}}),N=new We({props:{title:"Step 2: JavaScript setup",local:"step-2-javascript-setup",headingTag:"h2"}}),L=new T({props:{code:"JTNDc2NyaXB0JTIwc3JjJTNEJTIyLiUyRmluZGV4LmpzJTIyJTIwdHlwZSUzRCUyMm1vZHVsZSUyMiUzRSUzQyUyRnNjcmlwdCUzRQ==",highlighted:'<span class="hljs-tag">&lt;<span class="hljs-name">script</span> <span class="hljs-attr">src</span>=<span class="hljs-string">&quot;./index.js&quot;</span> <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;module&quot;</span>&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">script</span>&gt;</span>',wrap:!1}}),f=new _t({props:{$$slots:{default:[Ys]},$$scope:{ctx:b}}}),R=new T({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMkMlMjBlbnYlMjAlN0QlMjBmcm9tJTIwJTIyaHR0cHMlM0ElMkYlMkZjZG4uanNkZWxpdnIubmV0JTJGbnBtJTJGJTQwaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMlMjIlM0I=",highlighted:'<span class="hljs-keyword">import</span> { pipeline, env } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://cdn.jsdelivr.net/npm/@huggingface/transformers&quot;</span>;',wrap:!1}}),_=new T({props:{code:"ZW52LmFsbG93TG9jYWxNb2RlbHMlMjAlM0QlMjBmYWxzZSUzQg==",highlighted:'env.<span class="hljs-property">allowLocalModels</span> = <span class="hljs-literal">false</span>;',wrap:!1}}),V=new T({props:{code:"Y29uc3QlMjBmaWxlVXBsb2FkJTIwJTNEJTIwZG9jdW1lbnQuZ2V0RWxlbWVudEJ5SWQoJTIyZmlsZS11cGxvYWQlMjIpJTNCJTBBY29uc3QlMjBpbWFnZUNvbnRhaW5lciUyMCUzRCUyMGRvY3VtZW50LmdldEVsZW1lbnRCeUlkKCUyMmltYWdlLWNvbnRhaW5lciUyMiklM0IlMEFjb25zdCUyMHN0YXR1cyUyMCUzRCUyMGRvY3VtZW50LmdldEVsZW1lbnRCeUlkKCUyMnN0YXR1cyUyMiklM0I=",highlighted:`<span class="hljs-keyword">const</span> fileUpload = <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&quot;file-upload&quot;</span>);
<span class="hljs-keyword">const</span> imageContainer = <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&quot;image-container&quot;</span>);
<span class="hljs-keyword">const</span> status = <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">getElementById</span>(<span class="hljs-string">&quot;status&quot;</span>);`,wrap:!1}}),q=new We({props:{title:"Step 3: Create an object detection pipeline",local:"step-3-create-an-object-detection-pipeline",headingTag:"h2"}}),D=new T({props:{code:"c3RhdHVzLnRleHRDb250ZW50JTIwJTNEJTIwJTIyTG9hZGluZyUyMG1vZGVsLi4uJTIyJTNC",highlighted:'status.<span class="hljs-property">textContent</span> = <span class="hljs-string">&quot;Loading model...&quot;</span>;',wrap:!1}}),y=new _t({props:{$$slots:{default:[_s]},$$scope:{ctx:b}}}),K=new T({props:{code:"Y29uc3QlMjBkZXRlY3RvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJTIyb2JqZWN0LWRldGVjdGlvbiUyMiUyQyUyMCUyMlhlbm92YSUyRmRldHItcmVzbmV0LTUwJTIyKSUzQg==",highlighted:'<span class="hljs-keyword">const</span> detector = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&quot;object-detection&quot;</span>, <span class="hljs-string">&quot;Xenova/detr-resnet-50&quot;</span>);',wrap:!1}}),se=new T({props:{code:"c3RhdHVzLnRleHRDb250ZW50JTIwJTNEJTIwJTIyUmVhZHklMjIlM0I=",highlighted:'status.<span class="hljs-property">textContent</span> = <span class="hljs-string">&quot;Ready&quot;</span>;',wrap:!1}}),le=new We({props:{title:"Step 4: Create the image uploader",local:"step-4-create-the-image-uploader",headingTag:"h2"}}),ne=new T({props:{code:"ZmlsZVVwbG9hZC5hZGRFdmVudExpc3RlbmVyKCUyMmNoYW5nZSUyMiUyQyUyMGZ1bmN0aW9uJTIwKGUpJTIwJTdCJTBBJTIwJTIwY29uc3QlMjBmaWxlJTIwJTNEJTIwZS50YXJnZXQuZmlsZXMlNUIwJTVEJTNCJTBBJTIwJTIwaWYlMjAoIWZpbGUpJTIwJTdCJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTNCJTBBJTIwJTIwJTdEJTBBJTBBJTIwJTIwY29uc3QlMjByZWFkZXIlMjAlM0QlMjBuZXclMjBGaWxlUmVhZGVyKCklM0IlMEElMEElMjAlMjAlMkYlMkYlMjBTZXQlMjB1cCUyMGElMjBjYWxsYmFjayUyMHdoZW4lMjB0aGUlMjBmaWxlJTIwaXMlMjBsb2FkZWQlMEElMjAlMjByZWFkZXIub25sb2FkJTIwJTNEJTIwZnVuY3Rpb24lMjAoZTIpJTIwJTdCJTBBJTIwJTIwJTIwJTIwaW1hZ2VDb250YWluZXIuaW5uZXJIVE1MJTIwJTNEJTIwJTIyJTIyJTNCJTBBJTIwJTIwJTIwJTIwY29uc3QlMjBpbWFnZSUyMCUzRCUyMGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJTIyaW1nJTIyKSUzQiUwQSUyMCUyMCUyMCUyMGltYWdlLnNyYyUyMCUzRCUyMGUyLnRhcmdldC5yZXN1bHQlM0IlMEElMjAlMjAlMjAlMjBpbWFnZUNvbnRhaW5lci5hcHBlbmRDaGlsZChpbWFnZSklM0IlMEElMjAlMjAlMjAlMjAlMkYlMkYlMjBkZXRlY3QoaW1hZ2UpJTNCJTIwJTJGJTJGJTIwVW5jb21tZW50JTIwdGhpcyUyMGxpbmUlMjB0byUyMHJ1biUyMHRoZSUyMG1vZGVsJTBBJTIwJTIwJTdEJTNCJTBBJTIwJTIwcmVhZGVyLnJlYWRBc0RhdGFVUkwoZmlsZSklM0IlMEElN0QpJTNC",highlighted:`fileUpload.<span class="hljs-title function_">addEventListener</span>(<span class="hljs-string">&quot;change&quot;</span>, <span class="hljs-keyword">function</span> (<span class="hljs-params">e</span>) {
  <span class="hljs-keyword">const</span> file = e.<span class="hljs-property">target</span>.<span class="hljs-property">files</span>[<span class="hljs-number">0</span>];
  <span class="hljs-keyword">if</span> (!file) {
    <span class="hljs-keyword">return</span>;
  }

  <span class="hljs-keyword">const</span> reader = <span class="hljs-keyword">new</span> <span class="hljs-title class_">FileReader</span>();

  <span class="hljs-comment">// Set up a callback when the file is loaded</span>
  reader.<span class="hljs-property">onload</span> = <span class="hljs-keyword">function</span> (<span class="hljs-params">e2</span>) {
    imageContainer.<span class="hljs-property">innerHTML</span> = <span class="hljs-string">&quot;&quot;</span>;
    <span class="hljs-keyword">const</span> image = <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">createElement</span>(<span class="hljs-string">&quot;img&quot;</span>);
    image.<span class="hljs-property">src</span> = e2.<span class="hljs-property">target</span>.<span class="hljs-property">result</span>;
    imageContainer.<span class="hljs-title function_">appendChild</span>(image);
    <span class="hljs-comment">// detect(image); // Uncomment this line to run the model</span>
  };
  reader.<span class="hljs-title function_">readAsDataURL</span>(file);
});`,wrap:!1}}),ce=new We({props:{title:"Step 5: Run the model",local:"step-5-run-the-model",headingTag:"h2"}}),he=new T({props:{code:"YXN5bmMlMjBmdW5jdGlvbiUyMGRldGVjdChpbWcpJTIwJTdCJTBBJTIwJTIwc3RhdHVzLnRleHRDb250ZW50JTIwJTNEJTIwJTIyQW5hbHlzaW5nLi4uJTIyJTNCJTBBJTIwJTIwY29uc3QlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGRldGVjdG9yKGltZy5zcmMlMkMlMjAlN0IlMEElMjAlMjAlMjAlMjB0aHJlc2hvbGQlM0ElMjAwLjUlMkMlMEElMjAlMjAlMjAlMjBwZXJjZW50YWdlJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCU3RCklM0IlMEElMjAlMjBzdGF0dXMudGV4dENvbnRlbnQlMjAlM0QlMjAlMjIlMjIlM0IlMEElMjAlMjBjb25zb2xlLmxvZyglMjJvdXRwdXQlMjIlMkMlMjBvdXRwdXQpJTNCJTBBJTIwJTIwJTJGJTJGJTIwLi4uJTBBJTdE",highlighted:`<span class="hljs-keyword">async</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">detect</span>(<span class="hljs-params">img</span>) {
  status.<span class="hljs-property">textContent</span> = <span class="hljs-string">&quot;Analysing...&quot;</span>;
  <span class="hljs-keyword">const</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">detector</span>(img.<span class="hljs-property">src</span>, {
    <span class="hljs-attr">threshold</span>: <span class="hljs-number">0.5</span>,
    <span class="hljs-attr">percentage</span>: <span class="hljs-literal">true</span>,
  });
  status.<span class="hljs-property">textContent</span> = <span class="hljs-string">&quot;&quot;</span>;
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;output&quot;</span>, output);
  <span class="hljs-comment">// ...</span>
}`,wrap:!1}}),g=new _t({props:{$$slots:{default:[zs]},$$scope:{ctx:b}}}),we=new We({props:{title:"Step 6: Render the boxes",local:"step-6-render-the-boxes",headingTag:"h2"}}),fe=new T({props:{code:"b3V0cHV0LmZvckVhY2gocmVuZGVyQm94KSUzQg==",highlighted:'output.<span class="hljs-title function_">forEach</span>(renderBox);',wrap:!1}}),ge=new T({props:{code:"JTJGJTJGJTIwUmVuZGVyJTIwYSUyMGJvdW5kaW5nJTIwYm94JTIwYW5kJTIwbGFiZWwlMjBvbiUyMHRoZSUyMGltYWdlJTBBZnVuY3Rpb24lMjByZW5kZXJCb3goJTdCJTIwYm94JTJDJTIwbGFiZWwlMjAlN0QpJTIwJTdCJTBBJTIwJTIwY29uc3QlMjAlN0IlMjB4bWF4JTJDJTIweG1pbiUyQyUyMHltYXglMkMlMjB5bWluJTIwJTdEJTIwJTNEJTIwYm94JTNCJTBBJTBBJTIwJTIwJTJGJTJGJTIwR2VuZXJhdGUlMjBhJTIwcmFuZG9tJTIwY29sb3IlMjBmb3IlMjB0aGUlMjBib3glMEElMjAlMjBjb25zdCUyMGNvbG9yJTIwJTNEJTIwJTIyJTIzJTIyJTIwJTJCJTIwTWF0aC5mbG9vcihNYXRoLnJhbmRvbSgpJTIwKiUyMDB4ZmZmZmZmKS50b1N0cmluZygxNikucGFkU3RhcnQoNiUyQyUyMDApJTNCJTBBJTBBJTIwJTIwJTJGJTJGJTIwRHJhdyUyMHRoZSUyMGJveCUwQSUyMCUyMGNvbnN0JTIwYm94RWxlbWVudCUyMCUzRCUyMGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJTIyZGl2JTIyKSUzQiUwQSUyMCUyMGJveEVsZW1lbnQuY2xhc3NOYW1lJTIwJTNEJTIwJTIyYm91bmRpbmctYm94JTIyJTNCJTBBJTIwJTIwT2JqZWN0LmFzc2lnbihib3hFbGVtZW50LnN0eWxlJTJDJTIwJTdCJTBBJTIwJTIwJTIwJTIwYm9yZGVyQ29sb3IlM0ElMjBjb2xvciUyQyUwQSUyMCUyMCUyMCUyMGxlZnQlM0ElMjAxMDAlMjAqJTIweG1pbiUyMCUyQiUyMCUyMiUyNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcCUzQSUyMDEwMCUyMColMjB5bWluJTIwJTJCJTIwJTIyJTI1JTIyJTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0ElMjAxMDAlMjAqJTIwKHhtYXglMjAtJTIweG1pbiklMjAlMkIlMjAlMjIlMjUlMjIlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0ElMjAxMDAlMjAqJTIwKHltYXglMjAtJTIweW1pbiklMjAlMkIlMjAlMjIlMjUlMjIlMkMlMEElMjAlMjAlN0QpJTNCJTBBJTBBJTIwJTIwJTJGJTJGJTIwRHJhdyUyMHRoZSUyMGxhYmVsJTBBJTIwJTIwY29uc3QlMjBsYWJlbEVsZW1lbnQlMjAlM0QlMjBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCUyMnNwYW4lMjIpJTNCJTBBJTIwJTIwbGFiZWxFbGVtZW50LnRleHRDb250ZW50JTIwJTNEJTIwbGFiZWwlM0IlMEElMjAlMjBsYWJlbEVsZW1lbnQuY2xhc3NOYW1lJTIwJTNEJTIwJTIyYm91bmRpbmctYm94LWxhYmVsJTIyJTNCJTBBJTIwJTIwbGFiZWxFbGVtZW50LnN0eWxlLmJhY2tncm91bmRDb2xvciUyMCUzRCUyMGNvbG9yJTNCJTBBJTBBJTIwJTIwYm94RWxlbWVudC5hcHBlbmRDaGlsZChsYWJlbEVsZW1lbnQpJTNCJTBBJTIwJTIwaW1hZ2VDb250YWluZXIuYXBwZW5kQ2hpbGQoYm94RWxlbWVudCklM0IlMEElN0Q=",highlighted:`<span class="hljs-comment">// Render a bounding box and label on the image</span>
<span class="hljs-keyword">function</span> <span class="hljs-title function_">renderBox</span>(<span class="hljs-params">{ box, label }</span>) {
  <span class="hljs-keyword">const</span> { xmax, xmin, ymax, ymin } = box;

  <span class="hljs-comment">// Generate a random color for the box</span>
  <span class="hljs-keyword">const</span> color = <span class="hljs-string">&quot;#&quot;</span> + <span class="hljs-title class_">Math</span>.<span class="hljs-title function_">floor</span>(<span class="hljs-title class_">Math</span>.<span class="hljs-title function_">random</span>() * <span class="hljs-number">0xffffff</span>).<span class="hljs-title function_">toString</span>(<span class="hljs-number">16</span>).<span class="hljs-title function_">padStart</span>(<span class="hljs-number">6</span>, <span class="hljs-number">0</span>);

  <span class="hljs-comment">// Draw the box</span>
  <span class="hljs-keyword">const</span> boxElement = <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">createElement</span>(<span class="hljs-string">&quot;div&quot;</span>);
  boxElement.<span class="hljs-property">className</span> = <span class="hljs-string">&quot;bounding-box&quot;</span>;
  <span class="hljs-title class_">Object</span>.<span class="hljs-title function_">assign</span>(boxElement.<span class="hljs-property">style</span>, {
    <span class="hljs-attr">borderColor</span>: color,
    <span class="hljs-attr">left</span>: <span class="hljs-number">100</span> * xmin + <span class="hljs-string">&quot;%&quot;</span>,
    <span class="hljs-attr">top</span>: <span class="hljs-number">100</span> * ymin + <span class="hljs-string">&quot;%&quot;</span>,
    <span class="hljs-attr">width</span>: <span class="hljs-number">100</span> * (xmax - xmin) + <span class="hljs-string">&quot;%&quot;</span>,
    <span class="hljs-attr">height</span>: <span class="hljs-number">100</span> * (ymax - ymin) + <span class="hljs-string">&quot;%&quot;</span>,
  });

  <span class="hljs-comment">// Draw the label</span>
  <span class="hljs-keyword">const</span> labelElement = <span class="hljs-variable language_">document</span>.<span class="hljs-title function_">createElement</span>(<span class="hljs-string">&quot;span&quot;</span>);
  labelElement.<span class="hljs-property">textContent</span> = label;
  labelElement.<span class="hljs-property">className</span> = <span class="hljs-string">&quot;bounding-box-label&quot;</span>;
  labelElement.<span class="hljs-property">style</span>.<span class="hljs-property">backgroundColor</span> = color;

  boxElement.<span class="hljs-title function_">appendChild</span>(labelElement);
  imageContainer.<span class="hljs-title function_">appendChild</span>(boxElement);
}`,wrap:!1}}),Ie=new T({props:{code:"LmJvdW5kaW5nLWJveCUyMCU3QiUwQSUyMCUyMCUyMCUyMHBvc2l0aW9uJTNBJTIwYWJzb2x1dGUlM0IlMEElMjAlMjAlMjAlMjBib3gtc2l6aW5nJTNBJTIwYm9yZGVyLWJveCUzQiUwQSUyMCUyMCUyMCUyMGJvcmRlci13aWR0aCUzQSUyMDJweCUzQiUwQSUyMCUyMCUyMCUyMGJvcmRlci1zdHlsZSUzQSUyMHNvbGlkJTNCJTBBJTdEJTBBJTBBLmJvdW5kaW5nLWJveC1sYWJlbCUyMCU3QiUwQSUyMCUyMCUyMCUyMGNvbG9yJTNBJTIwd2hpdGUlM0IlMEElMjAlMjAlMjAlMjBwb3NpdGlvbiUzQSUyMGFic29sdXRlJTNCJTBBJTIwJTIwJTIwJTIwZm9udC1zaXplJTNBJTIwMTJweCUzQiUwQSUyMCUyMCUyMCUyMG1hcmdpbi10b3AlM0ElMjAtMTZweCUzQiUwQSUyMCUyMCUyMCUyMG1hcmdpbi1sZWZ0JTNBJTIwLTJweCUzQiUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0ElMjAxcHglM0IlMEElN0Q=",highlighted:`<span class="hljs-selector-class">.bounding-box</span> {
    <span class="hljs-attribute">position</span>: absolute;
    <span class="hljs-attribute">box-sizing</span>: border-box;
    <span class="hljs-attribute">border-width</span>: <span class="hljs-number">2px</span>;
    <span class="hljs-attribute">border-style</span>: solid;
}

<span class="hljs-selector-class">.bounding-box-label</span> {
    <span class="hljs-attribute">color</span>: white;
    <span class="hljs-attribute">position</span>: absolute;
    <span class="hljs-attribute">font-size</span>: <span class="hljs-number">12px</span>;
    <span class="hljs-attribute">margin-top</span>: -<span class="hljs-number">16px</span>;
    <span class="hljs-attribute">margin-left</span>: -<span class="hljs-number">2px</span>;
    <span class="hljs-attribute">padding</span>: <span class="hljs-number">1px</span>;
}`,wrap:!1}}),Be=new Rs({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/tutorials/vanilla-js.md"}}),{c(){c=p("meta"),w=a(),j=p("p"),J=a(),r(U.$$.fragment),ke=a(),I=p("p"),I.textContent=Vt,Ge=a(),C=p("p"),C.textContent=qt,Ee=a(),v=p("p"),v.innerHTML=Xt,Qe=a(),$=p("p"),$.textContent=Ft,He=a(),x=p("ul"),x.innerHTML=Dt,Ne=a(),r(B.$$.fragment),Se=a(),W=p("p"),W.innerHTML=Pt,Le=a(),r(Z.$$.fragment),Ae=a(),k=p("details"),k.innerHTML=Kt,Re=a(),G=p("p"),G.innerHTML=Ot,Ye=a(),r(E.$$.fragment),_e=a(),Q=p("p"),Q.textContent=es,ze=a(),H=p("p"),H.innerHTML=ts,Ve=a(),r(N.$$.fragment),qe=a(),S=p("p"),S.innerHTML=ss,Xe=a(),r(L.$$.fragment),Fe=a(),r(f.$$.fragment),De=a(),A=p("p"),A.innerHTML=ls,Pe=a(),r(R.$$.fragment),Ke=a(),Y=p("p"),Y.textContent=as,Oe=a(),r(_.$$.fragment),et=a(),z=p("p"),z.textContent=ns,tt=a(),r(V.$$.fragment),st=a(),r(q.$$.fragment),lt=a(),X=p("p"),X.innerHTML=ps,at=a(),F=p("p"),F.innerHTML=is,nt=a(),r(D.$$.fragment),pt=a(),r(y.$$.fragment),it=a(),P=p("p"),P.innerHTML=os,ot=a(),r(K.$$.fragment),ct=a(),O=p("p"),O.innerHTML=cs,rt=a(),ee=p("ol"),ee.innerHTML=rs,ht=a(),te=p("p"),te.textContent=hs,mt=a(),r(se.$$.fragment),dt=a(),r(le.$$.fragment),Mt=a(),ae=p("p"),ae.innerHTML=ms,ut=a(),r(ne.$$.fragment),jt=a(),pe=p("p"),pe.innerHTML=ds,Tt=a(),ie=p("p"),ie.innerHTML=Ms,wt=a(),oe=p("p"),oe.innerHTML=us,Jt=a(),r(ce.$$.fragment),bt=a(),re=p("p"),re.innerHTML=js,ft=a(),r(he.$$.fragment),yt=a(),r(g.$$.fragment),gt=a(),me=p("p"),me.innerHTML=Ts,Ut=a(),de=p("p"),de.textContent=ws,It=a(),Me=p("ul"),Me.innerHTML=Js,Ct=a(),ue=p("p"),ue.textContent=bs,vt=a(),je=p("p"),je.innerHTML=fs,$t=a(),Te=p("p"),Te.innerHTML=ys,xt=a(),r(we.$$.fragment),Bt=a(),Je=p("p"),Je.innerHTML=gs,Wt=a(),be=p("p"),be.innerHTML=Us,Zt=a(),r(fe.$$.fragment),kt=a(),ye=p("p"),ye.innerHTML=Is,Gt=a(),r(ge.$$.fragment),Et=a(),Ue=p("p"),Ue.innerHTML=Cs,Qt=a(),r(Ie.$$.fragment),Ht=a(),Ce=p("p"),Ce.innerHTML=vs,Nt=a(),ve=p("p"),ve.textContent=$s,St=a(),$e=p("p"),$e.innerHTML=xs,Lt=a(),xe=p("p"),xe.innerHTML=Bs,At=a(),r(Be.$$.fragment),Rt=a(),Ze=p("p"),this.h()},l(e){const t=Ls("svelte-u9bgzb",document.head);c=i(t,"META",{name:!0,content:!0}),t.forEach(s),w=n(e),j=i(e,"P",{}),Gs(j).forEach(s),J=n(e),h(U.$$.fragment,e),ke=n(e),I=i(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-124rffi"&&(I.textContent=Vt),Ge=n(e),C=i(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-10r3y0k"&&(C.textContent=qt),Ee=n(e),v=i(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-13hi3r9"&&(v.innerHTML=Xt),Qe=n(e),$=i(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1tlxmzn"&&($.textContent=Ft),He=n(e),x=i(e,"UL",{"data-svelte-h":!0}),o(x)!=="svelte-1qw26s9"&&(x.innerHTML=Dt),Ne=n(e),h(B.$$.fragment,e),Se=n(e),W=i(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1ro6f4o"&&(W.innerHTML=Pt),Le=n(e),h(Z.$$.fragment,e),Ae=n(e),k=i(e,"DETAILS",{"data-svelte-h":!0}),o(k)!=="svelte-m0rku7"&&(k.innerHTML=Kt),Re=n(e),G=i(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1oz6lja"&&(G.innerHTML=Ot),Ye=n(e),h(E.$$.fragment,e),_e=n(e),Q=i(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-9b3nck"&&(Q.textContent=es),ze=n(e),H=i(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-mwib6l"&&(H.innerHTML=ts),Ve=n(e),h(N.$$.fragment,e),qe=n(e),S=i(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-k9jxb8"&&(S.innerHTML=ss),Xe=n(e),h(L.$$.fragment,e),Fe=n(e),h(f.$$.fragment,e),De=n(e),A=i(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-mqvw0e"&&(A.innerHTML=ls),Pe=n(e),h(R.$$.fragment,e),Ke=n(e),Y=i(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1cxz7vo"&&(Y.textContent=as),Oe=n(e),h(_.$$.fragment,e),et=n(e),z=i(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-2hgpai"&&(z.textContent=ns),tt=n(e),h(V.$$.fragment,e),st=n(e),h(q.$$.fragment,e),lt=n(e),X=i(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1d20pgp"&&(X.innerHTML=ps),at=n(e),F=i(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-4x6koj"&&(F.innerHTML=is),nt=n(e),h(D.$$.fragment,e),pt=n(e),h(y.$$.fragment,e),it=n(e),P=i(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-nzqjt5"&&(P.innerHTML=os),ot=n(e),h(K.$$.fragment,e),ct=n(e),O=i(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-eu4w8s"&&(O.innerHTML=cs),rt=n(e),ee=i(e,"OL",{"data-svelte-h":!0}),o(ee)!=="svelte-1fsg0h3"&&(ee.innerHTML=rs),ht=n(e),te=i(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-1qhlioo"&&(te.textContent=hs),mt=n(e),h(se.$$.fragment,e),dt=n(e),h(le.$$.fragment,e),Mt=n(e),ae=i(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1s0f9r2"&&(ae.innerHTML=ms),ut=n(e),h(ne.$$.fragment,e),jt=n(e),pe=i(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1lk01wa"&&(pe.innerHTML=ds),Tt=n(e),ie=i(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-4ka4xl"&&(ie.innerHTML=Ms),wt=n(e),oe=i(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-16s7klb"&&(oe.innerHTML=us),Jt=n(e),h(ce.$$.fragment,e),bt=n(e),re=i(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-17edfdz"&&(re.innerHTML=js),ft=n(e),h(he.$$.fragment,e),yt=n(e),h(g.$$.fragment,e),gt=n(e),me=i(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-8pzcmm"&&(me.innerHTML=Ts),Ut=n(e),de=i(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-vbn04e"&&(de.textContent=ws),It=n(e),Me=i(e,"UL",{"data-svelte-h":!0}),o(Me)!=="svelte-1flghaj"&&(Me.innerHTML=Js),Ct=n(e),ue=i(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-vz1vzo"&&(ue.textContent=bs),vt=n(e),je=i(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-1e4bl98"&&(je.innerHTML=fs),$t=n(e),Te=i(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-ey5r3r"&&(Te.innerHTML=ys),xt=n(e),h(we.$$.fragment,e),Bt=n(e),Je=i(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-xglmdw"&&(Je.innerHTML=gs),Wt=n(e),be=i(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-6b76js"&&(be.innerHTML=Us),Zt=n(e),h(fe.$$.fragment,e),kt=n(e),ye=i(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-88zjgn"&&(ye.innerHTML=Is),Gt=n(e),h(ge.$$.fragment,e),Et=n(e),Ue=i(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1otf5ry"&&(Ue.innerHTML=Cs),Qt=n(e),h(Ie.$$.fragment,e),Ht=n(e),Ce=i(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-4x54i7"&&(Ce.innerHTML=vs),Nt=n(e),ve=i(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-1gkj58a"&&(ve.textContent=$s),St=n(e),$e=i(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-1yhdijg"&&($e.innerHTML=xs),Lt=n(e),xe=i(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-9xei6b"&&(xe.innerHTML=Bs),At=n(e),h(Be.$$.fragment,e),Rt=n(e),Ze=i(e,"P",{}),Gs(Ze).forEach(s),this.h()},h(){Es(c,"name","hf:doc:metadata"),Es(c,"content",qs)},m(e,t){As(document.head,c),l(e,w,t),l(e,j,t),l(e,J,t),m(U,e,t),l(e,ke,t),l(e,I,t),l(e,Ge,t),l(e,C,t),l(e,Ee,t),l(e,v,t),l(e,Qe,t),l(e,$,t),l(e,He,t),l(e,x,t),l(e,Ne,t),m(B,e,t),l(e,Se,t),l(e,W,t),l(e,Le,t),m(Z,e,t),l(e,Ae,t),l(e,k,t),l(e,Re,t),l(e,G,t),l(e,Ye,t),m(E,e,t),l(e,_e,t),l(e,Q,t),l(e,ze,t),l(e,H,t),l(e,Ve,t),m(N,e,t),l(e,qe,t),l(e,S,t),l(e,Xe,t),m(L,e,t),l(e,Fe,t),m(f,e,t),l(e,De,t),l(e,A,t),l(e,Pe,t),m(R,e,t),l(e,Ke,t),l(e,Y,t),l(e,Oe,t),m(_,e,t),l(e,et,t),l(e,z,t),l(e,tt,t),m(V,e,t),l(e,st,t),m(q,e,t),l(e,lt,t),l(e,X,t),l(e,at,t),l(e,F,t),l(e,nt,t),m(D,e,t),l(e,pt,t),m(y,e,t),l(e,it,t),l(e,P,t),l(e,ot,t),m(K,e,t),l(e,ct,t),l(e,O,t),l(e,rt,t),l(e,ee,t),l(e,ht,t),l(e,te,t),l(e,mt,t),m(se,e,t),l(e,dt,t),m(le,e,t),l(e,Mt,t),l(e,ae,t),l(e,ut,t),m(ne,e,t),l(e,jt,t),l(e,pe,t),l(e,Tt,t),l(e,ie,t),l(e,wt,t),l(e,oe,t),l(e,Jt,t),m(ce,e,t),l(e,bt,t),l(e,re,t),l(e,ft,t),m(he,e,t),l(e,yt,t),m(g,e,t),l(e,gt,t),l(e,me,t),l(e,Ut,t),l(e,de,t),l(e,It,t),l(e,Me,t),l(e,Ct,t),l(e,ue,t),l(e,vt,t),l(e,je,t),l(e,$t,t),l(e,Te,t),l(e,xt,t),m(we,e,t),l(e,Bt,t),l(e,Je,t),l(e,Wt,t),l(e,be,t),l(e,Zt,t),m(fe,e,t),l(e,kt,t),l(e,ye,t),l(e,Gt,t),m(ge,e,t),l(e,Et,t),l(e,Ue,t),l(e,Qt,t),m(Ie,e,t),l(e,Ht,t),l(e,Ce,t),l(e,Nt,t),l(e,ve,t),l(e,St,t),l(e,$e,t),l(e,Lt,t),l(e,xe,t),l(e,At,t),m(Be,e,t),l(e,Rt,t),l(e,Ze,t),Yt=!0},p(e,[t]){const Ws={};t&2&&(Ws.$$scope={dirty:t,ctx:e}),f.$set(Ws);const Zs={};t&2&&(Zs.$$scope={dirty:t,ctx:e}),y.$set(Zs);const ks={};t&2&&(ks.$$scope={dirty:t,ctx:e}),g.$set(ks)},i(e){Yt||(d(U.$$.fragment,e),d(B.$$.fragment,e),d(Z.$$.fragment,e),d(E.$$.fragment,e),d(N.$$.fragment,e),d(L.$$.fragment,e),d(f.$$.fragment,e),d(R.$$.fragment,e),d(_.$$.fragment,e),d(V.$$.fragment,e),d(q.$$.fragment,e),d(D.$$.fragment,e),d(y.$$.fragment,e),d(K.$$.fragment,e),d(se.$$.fragment,e),d(le.$$.fragment,e),d(ne.$$.fragment,e),d(ce.$$.fragment,e),d(he.$$.fragment,e),d(g.$$.fragment,e),d(we.$$.fragment,e),d(fe.$$.fragment,e),d(ge.$$.fragment,e),d(Ie.$$.fragment,e),d(Be.$$.fragment,e),Yt=!0)},o(e){M(U.$$.fragment,e),M(B.$$.fragment,e),M(Z.$$.fragment,e),M(E.$$.fragment,e),M(N.$$.fragment,e),M(L.$$.fragment,e),M(f.$$.fragment,e),M(R.$$.fragment,e),M(_.$$.fragment,e),M(V.$$.fragment,e),M(q.$$.fragment,e),M(D.$$.fragment,e),M(y.$$.fragment,e),M(K.$$.fragment,e),M(se.$$.fragment,e),M(le.$$.fragment,e),M(ne.$$.fragment,e),M(ce.$$.fragment,e),M(he.$$.fragment,e),M(g.$$.fragment,e),M(we.$$.fragment,e),M(fe.$$.fragment,e),M(ge.$$.fragment,e),M(Ie.$$.fragment,e),M(Be.$$.fragment,e),Yt=!1},d(e){e&&(s(w),s(j),s(J),s(ke),s(I),s(Ge),s(C),s(Ee),s(v),s(Qe),s($),s(He),s(x),s(Ne),s(Se),s(W),s(Le),s(Ae),s(k),s(Re),s(G),s(Ye),s(_e),s(Q),s(ze),s(H),s(Ve),s(qe),s(S),s(Xe),s(Fe),s(De),s(A),s(Pe),s(Ke),s(Y),s(Oe),s(et),s(z),s(tt),s(st),s(lt),s(X),s(at),s(F),s(nt),s(pt),s(it),s(P),s(ot),s(ct),s(O),s(rt),s(ee),s(ht),s(te),s(mt),s(dt),s(Mt),s(ae),s(ut),s(jt),s(pe),s(Tt),s(ie),s(wt),s(oe),s(Jt),s(bt),s(re),s(ft),s(yt),s(gt),s(me),s(Ut),s(de),s(It),s(Me),s(Ct),s(ue),s(vt),s(je),s($t),s(Te),s(xt),s(Bt),s(Je),s(Wt),s(be),s(Zt),s(kt),s(ye),s(Gt),s(Et),s(Ue),s(Qt),s(Ht),s(Ce),s(Nt),s(ve),s(St),s($e),s(Lt),s(xe),s(At),s(Rt),s(Ze)),s(c),u(U,e),u(B,e),u(Z,e),u(E,e),u(N,e),u(L,e),u(f,e),u(R,e),u(_,e),u(V,e),u(q,e),u(D,e),u(y,e),u(K,e),u(se,e),u(le,e),u(ne,e),u(ce,e),u(he,e),u(g,e),u(we,e),u(fe,e),u(ge,e),u(Ie,e),u(Be,e)}}}const qs='{"title":"Building a Vanilla JavaScript Application","local":"building-a-vanilla-javascript-application","sections":[{"title":"Step 1:  HTML and CSS setup","local":"step-1-html-and-css-setup","sections":[],"depth":2},{"title":"Step 2: JavaScript setup","local":"step-2-javascript-setup","sections":[],"depth":2},{"title":"Step 3: Create an object detection pipeline","local":"step-3-create-an-object-detection-pipeline","sections":[],"depth":2},{"title":"Step 4: Create the image uploader","local":"step-4-create-the-image-uploader","sections":[],"depth":2},{"title":"Step 5: Run the model","local":"step-5-run-the-model","sections":[],"depth":2},{"title":"Step 6: Render the boxes","local":"step-6-render-the-boxes","sections":[],"depth":2}],"depth":1}';function Xs(b){return Hs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class el extends Ns{constructor(c){super(),Ss(this,c,Xs,Vs,Qs,{})}}export{el as component};
