import{s as De,n as je,o as Ke}from"../chunks/scheduler.53228c21.js";import{S as Ce,i as Re,e as i,s,c,h as Be,a as r,d as n,b as a,f as N,g as m,j as b,k as V,l as g,m as o,n as d,t as u,o as p,p as f}from"../chunks/index.100fac89.js";import{C as Ee}from"../chunks/CopyLLMTxtMenu.0ee1b69b.js";import{D as _e}from"../chunks/Docstring.db856a1e.js";import{C as ze}from"../chunks/CodeBlock.d30a6509.js";import{H as Y,E as Xe}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.136ef3fd.js";function Fe(Me){let h,I,Q,H,$,O,w,q,M,ke='Improved larger variational autoencoder (VAE) model with KL loss for inpainting task: <a href="https://huggingface.co/papers/2306.04632" rel="nofollow">Designing a Better Asymmetric VQGAN for StableDiffusion</a> by Zixin Zhu, Xuelu Feng, Dongdong Chen, Jianmin Bao, Le Wang, Yinpeng Chen, Lu Yuan, Gang Hua.',P,k,Ae="The abstract from the paper is:",ee,A,Te='<em>StableDiffusion is a revolutionary text-to-image generator that is causing a stir in the world of image generation and editing. Unlike traditional methods that learn a diffusion model in pixel space, StableDiffusion learns a diffusion model in the latent space via a VQGAN, ensuring both efficiency and quality. It not only supports image generation tasks, but also enables image editing for real images, such as image inpainting and local editing. However, we have observed that the vanilla VQGAN used in StableDiffusion leads to significant information loss, causing distortion artifacts even in non-edited image regions. To this end, we propose a new asymmetric VQGAN with two simple designs. Firstly, in addition to the input from the encoder, the decoder contains a conditional branch that incorporates information from task-specific priors, such as the unmasked image region in inpainting. Secondly, the decoder is much heavier than the encoder, allowing for more detailed recovery while only slightly increasing the total inference cost. The training cost of our asymmetric VQGAN is cheap, and we only need to retrain a new asymmetric decoder while keeping the vanilla VQGAN encoder and StableDiffusion unchanged. Our asymmetric VQGAN can be widely used in StableDiffusion-based inpainting and local editing methods. Extensive experiments demonstrate that it can significantly improve the inpainting and editing performance, while maintaining the original text-to-image capability. The code is available at <a href="https://github.com/buxiangzhiren/Asymmetric_VQGAN" rel="nofollow">https://github.com/buxiangzhiren/Asymmetric_VQGAN</a></em>',te,T,xe="Evaluation results can be found in section 4.1 of the original paper.",ne,x,oe,Z,Ze='<li><a href="https://huggingface.co/cross-attention/asymmetric-autoencoder-kl-x-1-5" rel="nofollow">https://huggingface.co/cross-attention/asymmetric-autoencoder-kl-x-1-5</a></li> <li><a href="https://huggingface.co/cross-attention/asymmetric-autoencoder-kl-x-2" rel="nofollow">https://huggingface.co/cross-attention/asymmetric-autoencoder-kl-x-2</a></li>',se,W,ae,L,ie,U,re,l,G,ye,B,We=`Designing a Better Asymmetric VQGAN for StableDiffusion <a href="https://huggingface.co/papers/2306.04632" rel="nofollow">https://huggingface.co/papers/2306.04632</a> . A VAE model with
KL loss for encoding images into latents and decoding latent representations into images.`,be,E,Le=`This model inherits from <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a>. Check the superclass documentation for it’s generic methods implemented
for all models (such as downloading or saving).`,ve,z,J,le,D,ce,_,j,$e,X,Ue="Output of AutoencoderKL encoding method.",me,K,de,y,C,we,F,Ge="Output of decoding method.",ue,R,pe,S,fe;return $=new Ee({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new Y({props:{title:"AsymmetricAutoencoderKL",local:"asymmetricautoencoderkl",headingTag:"h1"}}),x=new Y({props:{title:"Available checkpoints",local:"available-checkpoints",headingTag:"h2"}}),W=new Y({props:{title:"Example Usage",local:"example-usage",headingTag:"h2"}}),L=new ze({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEFzeW1tZXRyaWNBdXRvZW5jb2RlcktMJTJDJTIwU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBwZXJzb24lMjB3aXRoJTIwYmVhcmQlMjIlMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnJlcGFpbnQlMkZjZWxlYmFfaHFfMjU2LnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnJlcGFpbnQlMkZtYXNrXzI1Ni5wbmclMjIlMEElMEFvcmlnaW5hbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoaW1nX3VybCkucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKG1hc2tfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLWlucGFpbnRpbmclMjIpJTBBcGlwZS52YWUlMjAlM0QlMjBBc3ltbWV0cmljQXV0b2VuY29kZXJLTC5mcm9tX3ByZXRyYWluZWQoJTIyY3Jvc3MtYXR0ZW50aW9uJTJGYXN5bW1ldHJpYy1hdXRvZW5jb2Rlci1rbC14LTEtNSUyMiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEb3JpZ2luYWxfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJvcmlnaW5hbF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AsymmetricAutoencoderKL, StableDiffusionInpaintPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid


prompt = <span class="hljs-string">&quot;a photo of a person with beard&quot;</span>
img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/repaint/celeba_hq_256.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/repaint/mask_256.png&quot;</span>

original_image = load_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = load_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

pipe = StableDiffusionInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>)
pipe.vae = AsymmetricAutoencoderKL.from_pretrained(<span class="hljs-string">&quot;cross-attention/asymmetric-autoencoder-kl-x-1-5&quot;</span>)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(prompt=prompt, image=original_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
make_image_grid([original_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),U=new Y({props:{title:"AsymmetricAutoencoderKL",local:"diffusers.AsymmetricAutoencoderKL",headingTag:"h2"}}),G=new _e({props:{name:"class diffusers.AsymmetricAutoencoderKL",anchor:"diffusers.AsymmetricAutoencoderKL",parameters:[{name:"in_channels",val:": int = 3"},{name:"out_channels",val:": int = 3"},{name:"down_block_types",val:": typing.Tuple[str, ...] = ('DownEncoderBlock2D',)"},{name:"down_block_out_channels",val:": typing.Tuple[int, ...] = (64,)"},{name:"layers_per_down_block",val:": int = 1"},{name:"up_block_types",val:": typing.Tuple[str, ...] = ('UpDecoderBlock2D',)"},{name:"up_block_out_channels",val:": typing.Tuple[int, ...] = (64,)"},{name:"layers_per_up_block",val:": int = 1"},{name:"act_fn",val:": str = 'silu'"},{name:"latent_channels",val:": int = 4"},{name:"norm_num_groups",val:": int = 32"},{name:"sample_size",val:": int = 32"},{name:"scaling_factor",val:": float = 0.18215"}],parametersDescription:[{anchor:"diffusers.AsymmetricAutoencoderKL.in_channels",description:"<strong>in_channels</strong> (int, <em>optional</em>, defaults to 3) &#x2014; Number of channels in the input image.",name:"in_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.out_channels",description:"<strong>out_channels</strong> (int,  <em>optional</em>, defaults to 3) &#x2014; Number of channels in the output.",name:"out_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.down_block_types",description:`<strong>down_block_types</strong> (<code>Tuple[str]</code>, <em>optional</em>, defaults to <code>(&quot;DownEncoderBlock2D&quot;,)</code>) &#x2014;
Tuple of downsample block types.`,name:"down_block_types"},{anchor:"diffusers.AsymmetricAutoencoderKL.down_block_out_channels",description:`<strong>down_block_out_channels</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(64,)</code>) &#x2014;
Tuple of down block output channels.`,name:"down_block_out_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.layers_per_down_block",description:`<strong>layers_per_down_block</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Number layers for down block.`,name:"layers_per_down_block"},{anchor:"diffusers.AsymmetricAutoencoderKL.up_block_types",description:`<strong>up_block_types</strong> (<code>Tuple[str]</code>, <em>optional</em>, defaults to <code>(&quot;UpDecoderBlock2D&quot;,)</code>) &#x2014;
Tuple of upsample block types.`,name:"up_block_types"},{anchor:"diffusers.AsymmetricAutoencoderKL.up_block_out_channels",description:`<strong>up_block_out_channels</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(64,)</code>) &#x2014;
Tuple of up block output channels.`,name:"up_block_out_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.layers_per_up_block",description:`<strong>layers_per_up_block</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Number layers for up block.`,name:"layers_per_up_block"},{anchor:"diffusers.AsymmetricAutoencoderKL.act_fn",description:"<strong>act_fn</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014; The activation function to use.",name:"act_fn"},{anchor:"diffusers.AsymmetricAutoencoderKL.latent_channels",description:"<strong>latent_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014; Number of channels in the latent space.",name:"latent_channels"},{anchor:"diffusers.AsymmetricAutoencoderKL.sample_size",description:"<strong>sample_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>32</code>) &#x2014; Sample input size.",name:"sample_size"},{anchor:"diffusers.AsymmetricAutoencoderKL.norm_num_groups",description:`<strong>norm_num_groups</strong> (<code>int</code>, <em>optional</em>, defaults to <code>32</code>) &#x2014;
Number of groups to use for the first normalization layer in ResNet blocks.`,name:"norm_num_groups"},{anchor:"diffusers.AsymmetricAutoencoderKL.scaling_factor",description:`<strong>scaling_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.18215) &#x2014;
The component-wise standard deviation of the trained latent space computed using the first batch of the
training set. This is used to scale the latent space to have unit variance when training the diffusion
model. The latents are scaled with the formula <code>z = z * scaling_factor</code> before being passed to the
diffusion model. When decoding, the latents are scaled back to the original scale with the formula: <code>z = 1 / scaling_factor * z</code>. For more details, refer to sections 4.3.2 and D.1 of the <a href="https://huggingface.co/papers/2112.10752" rel="nofollow">High-Resolution Image
Synthesis with Latent Diffusion Models</a> paper.`,name:"scaling_factor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/autoencoder_asym_kl.py#L26"}}),J=new _e({props:{name:"forward",anchor:"diffusers.AsymmetricAutoencoderKL.forward",parameters:[{name:"sample",val:": Tensor"},{name:"mask",val:": typing.Optional[torch.Tensor] = None"},{name:"sample_posterior",val:": bool = False"},{name:"return_dict",val:": bool = True"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"}],parametersDescription:[{anchor:"diffusers.AsymmetricAutoencoderKL.forward.sample",description:"<strong>sample</strong> (<code>torch.Tensor</code>) &#x2014; Input sample.",name:"sample"},{anchor:"diffusers.AsymmetricAutoencoderKL.forward.mask",description:"<strong>mask</strong> (<code>torch.Tensor</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014; Optional inpainting mask.",name:"mask"},{anchor:"diffusers.AsymmetricAutoencoderKL.forward.sample_posterior",description:`<strong>sample_posterior</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to sample from the posterior.`,name:"sample_posterior"},{anchor:"diffusers.AsymmetricAutoencoderKL.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>DecoderOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/autoencoder_asym_kl.py#L158"}}),D=new Y({props:{title:"AutoencoderKLOutput",local:"diffusers.models.modeling_outputs.AutoencoderKLOutput",headingTag:"h2"}}),j=new _e({props:{name:"class diffusers.models.modeling_outputs.AutoencoderKLOutput",anchor:"diffusers.models.modeling_outputs.AutoencoderKLOutput",parameters:[{name:"latent_dist",val:": DiagonalGaussianDistribution"}],parametersDescription:[{anchor:"diffusers.models.modeling_outputs.AutoencoderKLOutput.latent_dist",description:`<strong>latent_dist</strong> (<code>DiagonalGaussianDistribution</code>) &#x2014;
Encoded outputs of <code>Encoder</code> represented as the mean and logvar of <code>DiagonalGaussianDistribution</code>.
<code>DiagonalGaussianDistribution</code> allows for sampling latents from the distribution.`,name:"latent_dist"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_outputs.py#L7"}}),K=new Y({props:{title:"DecoderOutput",local:"diffusers.models.autoencoders.vae.DecoderOutput",headingTag:"h2"}}),C=new _e({props:{name:"class diffusers.models.autoencoders.vae.DecoderOutput",anchor:"diffusers.models.autoencoders.vae.DecoderOutput",parameters:[{name:"sample",val:": Tensor"},{name:"commit_loss",val:": typing.Optional[torch.FloatTensor] = None"}],parametersDescription:[{anchor:"diffusers.models.autoencoders.vae.DecoderOutput.sample",description:`<strong>sample</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
The decoded output sample from the last layer of the model.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoders/vae.py#L47"}}),R=new Xe({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/models/asymmetricautoencoderkl.md"}}),{c(){h=i("meta"),I=s(),Q=i("p"),H=s(),c($.$$.fragment),O=s(),c(w.$$.fragment),q=s(),M=i("p"),M.innerHTML=ke,P=s(),k=i("p"),k.textContent=Ae,ee=s(),A=i("p"),A.innerHTML=Te,te=s(),T=i("p"),T.textContent=xe,ne=s(),c(x.$$.fragment),oe=s(),Z=i("ul"),Z.innerHTML=Ze,se=s(),c(W.$$.fragment),ae=s(),c(L.$$.fragment),ie=s(),c(U.$$.fragment),re=s(),l=i("div"),c(G.$$.fragment),ye=s(),B=i("p"),B.innerHTML=We,be=s(),E=i("p"),E.innerHTML=Le,ve=s(),z=i("div"),c(J.$$.fragment),le=s(),c(D.$$.fragment),ce=s(),_=i("div"),c(j.$$.fragment),$e=s(),X=i("p"),X.textContent=Ue,me=s(),c(K.$$.fragment),de=s(),y=i("div"),c(C.$$.fragment),we=s(),F=i("p"),F.textContent=Ge,ue=s(),c(R.$$.fragment),pe=s(),S=i("p"),this.h()},l(e){const t=Be("svelte-u9bgzb",document.head);h=r(t,"META",{name:!0,content:!0}),t.forEach(n),I=a(e),Q=r(e,"P",{}),N(Q).forEach(n),H=a(e),m($.$$.fragment,e),O=a(e),m(w.$$.fragment,e),q=a(e),M=r(e,"P",{"data-svelte-h":!0}),b(M)!=="svelte-5bqk5j"&&(M.innerHTML=ke),P=a(e),k=r(e,"P",{"data-svelte-h":!0}),b(k)!=="svelte-1cwsb16"&&(k.textContent=Ae),ee=a(e),A=r(e,"P",{"data-svelte-h":!0}),b(A)!=="svelte-ggnlwl"&&(A.innerHTML=Te),te=a(e),T=r(e,"P",{"data-svelte-h":!0}),b(T)!=="svelte-1dzj46z"&&(T.textContent=xe),ne=a(e),m(x.$$.fragment,e),oe=a(e),Z=r(e,"UL",{"data-svelte-h":!0}),b(Z)!=="svelte-1m6ravg"&&(Z.innerHTML=Ze),se=a(e),m(W.$$.fragment,e),ae=a(e),m(L.$$.fragment,e),ie=a(e),m(U.$$.fragment,e),re=a(e),l=r(e,"DIV",{class:!0});var v=N(l);m(G.$$.fragment,v),ye=a(v),B=r(v,"P",{"data-svelte-h":!0}),b(B)!=="svelte-1clr2gx"&&(B.innerHTML=We),be=a(v),E=r(v,"P",{"data-svelte-h":!0}),b(E)!=="svelte-1hyu2ru"&&(E.innerHTML=Le),ve=a(v),z=r(v,"DIV",{class:!0});var Je=N(z);m(J.$$.fragment,Je),Je.forEach(n),v.forEach(n),le=a(e),m(D.$$.fragment,e),ce=a(e),_=r(e,"DIV",{class:!0});var ge=N(_);m(j.$$.fragment,ge),$e=a(ge),X=r(ge,"P",{"data-svelte-h":!0}),b(X)!=="svelte-1vsc7ag"&&(X.textContent=Ue),ge.forEach(n),me=a(e),m(K.$$.fragment,e),de=a(e),y=r(e,"DIV",{class:!0});var he=N(y);m(C.$$.fragment,he),we=a(he),F=r(he,"P",{"data-svelte-h":!0}),b(F)!=="svelte-18u8upa"&&(F.textContent=Ge),he.forEach(n),ue=a(e),m(R.$$.fragment,e),pe=a(e),S=r(e,"P",{}),N(S).forEach(n),this.h()},h(){V(h,"name","hf:doc:metadata"),V(h,"content",Ne),V(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(l,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){g(document.head,h),o(e,I,t),o(e,Q,t),o(e,H,t),d($,e,t),o(e,O,t),d(w,e,t),o(e,q,t),o(e,M,t),o(e,P,t),o(e,k,t),o(e,ee,t),o(e,A,t),o(e,te,t),o(e,T,t),o(e,ne,t),d(x,e,t),o(e,oe,t),o(e,Z,t),o(e,se,t),d(W,e,t),o(e,ae,t),d(L,e,t),o(e,ie,t),d(U,e,t),o(e,re,t),o(e,l,t),d(G,l,null),g(l,ye),g(l,B),g(l,be),g(l,E),g(l,ve),g(l,z),d(J,z,null),o(e,le,t),d(D,e,t),o(e,ce,t),o(e,_,t),d(j,_,null),g(_,$e),g(_,X),o(e,me,t),d(K,e,t),o(e,de,t),o(e,y,t),d(C,y,null),g(y,we),g(y,F),o(e,ue,t),d(R,e,t),o(e,pe,t),o(e,S,t),fe=!0},p:je,i(e){fe||(u($.$$.fragment,e),u(w.$$.fragment,e),u(x.$$.fragment,e),u(W.$$.fragment,e),u(L.$$.fragment,e),u(U.$$.fragment,e),u(G.$$.fragment,e),u(J.$$.fragment,e),u(D.$$.fragment,e),u(j.$$.fragment,e),u(K.$$.fragment,e),u(C.$$.fragment,e),u(R.$$.fragment,e),fe=!0)},o(e){p($.$$.fragment,e),p(w.$$.fragment,e),p(x.$$.fragment,e),p(W.$$.fragment,e),p(L.$$.fragment,e),p(U.$$.fragment,e),p(G.$$.fragment,e),p(J.$$.fragment,e),p(D.$$.fragment,e),p(j.$$.fragment,e),p(K.$$.fragment,e),p(C.$$.fragment,e),p(R.$$.fragment,e),fe=!1},d(e){e&&(n(I),n(Q),n(H),n(O),n(q),n(M),n(P),n(k),n(ee),n(A),n(te),n(T),n(ne),n(oe),n(Z),n(se),n(ae),n(ie),n(re),n(l),n(le),n(ce),n(_),n(me),n(de),n(y),n(ue),n(pe),n(S)),n(h),f($,e),f(w,e),f(x,e),f(W,e),f(L,e),f(U,e),f(G),f(J),f(D,e),f(j),f(K,e),f(C),f(R,e)}}}const Ne='{"title":"AsymmetricAutoencoderKL","local":"asymmetricautoencoderkl","sections":[{"title":"Available checkpoints","local":"available-checkpoints","sections":[],"depth":2},{"title":"Example Usage","local":"example-usage","sections":[],"depth":2},{"title":"AsymmetricAutoencoderKL","local":"diffusers.AsymmetricAutoencoderKL","sections":[],"depth":2},{"title":"AutoencoderKLOutput","local":"diffusers.models.modeling_outputs.AutoencoderKLOutput","sections":[],"depth":2},{"title":"DecoderOutput","local":"diffusers.models.autoencoders.vae.DecoderOutput","sections":[],"depth":2}],"depth":1}';function Ve(Me){return Ke(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qe extends Ce{constructor(h){super(),Re(this,h,Ve,Fe,De,{})}}export{qe as component};
