import{s as bt,n as yt,o as Jt}from"../chunks/scheduler.53228c21.js";import{S as Tt,i as gt,e as n,s,c as r,h as jt,a as p,d as t,b as a,f as wt,g as m,j as o,k as ve,l as Zt,m as i,n as f,t as d,o as u,p as c}from"../chunks/index.100fac89.js";import{C as Ut}from"../chunks/CopyLLMTxtMenu.0ee1b69b.js";import{C as M}from"../chunks/CodeBlock.d30a6509.js";import{D as vt}from"../chunks/DocNotebookDropdown.74a16910.js";import{H as w,E as $t}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.136ef3fd.js";function Wt(Hl){let h,$e,Ze,We,T,Ie,g,Ge,j,Be,Z,Cl='Diffusion models consists of multiple components like UNets or diffusion transformers (DiTs), text encoders, variational autoencoders (VAEs), and schedulers. The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> wraps all of these components into a single easy-to-use API without giving up the flexibility to modify it’s components.',_e,U,Rl='This guide will show you how to load a <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>.',ke,v,xe,$,Xl='<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> is a base pipeline class that automatically selects and returns an instance of a model’s pipeline subclass, like <a href="/docs/diffusers/main/en/api/pipelines/qwenimage#diffusers.QwenImagePipeline">QwenImagePipeline</a>, by scanning the <code>model_index.json</code> file for the class name.',Ee,W,Ql='Pass a model id to <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to load a pipeline.',He,I,Ce,G,Pl='Every model has a specific pipeline subclass that inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. A subclass usually has a narrow focus and are task-specific. See the table below for an example.',Re,B,Yl='<thead><tr><th>pipeline subclass</th> <th>task</th></tr></thead> <tbody><tr><td><a href="/docs/diffusers/main/en/api/pipelines/qwenimage#diffusers.QwenImagePipeline">QwenImagePipeline</a></td> <td>text-to-image</td></tr> <tr><td><a href="/docs/diffusers/main/en/api/pipelines/qwenimage#diffusers.QwenImageImg2ImgPipeline">QwenImageImg2ImgPipeline</a></td> <td>image-to-image</td></tr> <tr><td><a href="/docs/diffusers/main/en/api/pipelines/qwenimage#diffusers.QwenImageInpaintPipeline">QwenImageInpaintPipeline</a></td> <td>inpaint</td></tr></tbody>',Xe,_,Ll='You could use the subclass directly by passing a model id to <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a>.',Qe,k,Pe,b,Vl='<p>Refer to the <a href="./other-formats#single-file-format">Single file format</a> docs to learn how to load single file models.</p>',Ye,x,Le,E,ql='Pipelines can also be run locally. Use <a href="https://huggingface.co/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.snapshot_download" rel="nofollow">snapshot_download</a> to download a model repository.',Ve,H,qe,C,Fl='The model is downloaded to your <a href="../installation#cache">cache</a>. Pass the folder path to <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to load it.',Fe,R,Ne,X,Nl='The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method won’t download files from the Hub when it detects a local path. But this also means it won’t download and cache any updates that have been made to the model either.',Se,Q,De,P,Sl='Use the <code>torch_dtype</code> argument in <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to load a model with a specific data type. This allows you to load different models in different precisions. For example, loading a large transformer model in half-precision reduces the memory required.',ze,Y,Dl="Pass the data type for each model as a dictionary to <code>torch_dtype</code>. Use the <code>default</code> key to set the default data type. If a model isn’t in the dictionary and <code>default</code> isn’t provided, it is loaded in full precision (<code>torch.float32</code>).",Ae,L,Ke,V,zl="You don’t need to use a dictionary if you’re loading all the models in the same data type.",Oe,q,el,F,ll,N,Al="The <code>device_map</code> argument determines individual model or pipeline placement on an accelerator like a GPU. It is especially helpful when there are multiple GPUs.",tl,S,Kl="A pipeline supports two options for <code>device_map</code>, <code>&quot;cuda&quot;</code> and <code>&quot;balanced&quot;</code>. Refer to the table below to compare the placement strategies.",il,D,Ol="<thead><tr><th>parameter</th> <th>description</th></tr></thead> <tbody><tr><td><code>&quot;cuda&quot;</code></td> <td>places pipeline on a supported accelerator device like CUDA</td></tr> <tr><td><code>&quot;balanced&quot;</code></td> <td>evenly distributes pipeline on all GPUs</td></tr></tbody>",sl,z,et='Use the <code>max_memory</code> argument in <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to allocate a maximum amount of memory to use on each device. By default, Diffusers uses the maximum amount available.',al,A,nl,K,lt="The <code>hf_device_map</code> attribute allows you to access and view the <code>device_map</code>.",pl,O,ol,ee,tt='Reset a pipeline’s <code>device_map</code> with the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.reset_device_map">reset_device_map()</a> method. This is necessary if you want to use methods such as <code>.to()</code>, <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>, and <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a>.',rl,le,ml,te,fl,ie,it='Large models are often <a href="../training/distributed_inference#model-sharding">sharded</a> into smaller files so that they are easier to load. Diffusers supports loading shards in parallel to speed up the loading process.',dl,se,st="Set <code>HF_ENABLE_PARALLEL_LOADING</code> to <code>&quot;YES&quot;</code> to enable parallel loading of shards.",ul,ae,at="The <code>device_map</code> argument should be set to <code>&quot;cuda&quot;</code> to pre-allocate a large chunk of memory based on the model size. This substantially reduces model load time because warming up the memory allocator now avoids many smaller calls to the allocator later.",cl,ne,Ml,pe,hl,oe,nt='<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> is flexible and accommodates loading different models or schedulers. You can experiment with different schedulers to optimize for generation speed or quality, and you can replace models with more performant ones.',wl,re,pt="The example below uses a more stable VAE version.",bl,me,yl,fe,Jl,de,ot='When working with multiple pipelines that use the same model, the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> method enables reusing a model instead of reloading it each time. This allows you to use multiple pipelines without increasing memory usage.',Tl,ue,rt="Memory usage is determined by the pipeline with the highest memory requirement regardless of the number of pipelines.",gl,ce,mt='The example below loads a pipeline and then loads a second pipeline with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> to use <a href="../api/pipelines/pag">perturbed-attention guidance (PAG)</a> to improve generation quality.',jl,y,ft='<p>Use <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForText2Image">AutoPipelineForText2Image</a> because <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> doesn’t support PAG. Refer to the <a href="../tutorials/autopipeline">AutoPipeline</a> docs to learn more.</p>',Zl,Me,Ul,he,dt="Set <code>enable_pag=True</code> in the second pipeline to enable PAG. The second pipeline uses the same amount of memory because it shares model weights with the first one.",vl,we,$l,J,ut='<p>Pipelines created by <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> share the same models and <em>state</em>. Modifying the state of a model in one pipeline affects all the other pipelines that share the same model.</p>',Wl,be,ct='Some methods may not work correctly on pipelines created with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a>. For example, <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> relies on a unique model execution order, which may differ in the new pipeline. To ensure proper functionality, reapply these methods on the new pipeline.',Il,ye,Gl,Je,Mt='Diffusers provides a <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/safety_checker.py" rel="nofollow">safety checker</a> for older Stable Diffusion models to prevent generating harmful content. It screens the generated output against a set of hardcoded harmful concepts.',Bl,Te,ht='If you want to disable the safety checker, pass <code>safety_checker=None</code> in <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> as shown below.',_l,ge,kl,je,xl,Ue,El;return T=new Ut({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),g=new vt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/loading.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/loading.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/loading.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/loading.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/loading.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/loading.ipynb"}]}}),j=new w({props:{title:"DiffusionPipeline",local:"diffusionpipeline",headingTag:"h1"}}),v=new w({props:{title:"Loading a pipeline",local:"loading-a-pipeline",headingTag:"h2"}}),I=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiUwQSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)`,wrap:!1}}),k=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFF3ZW5JbWFnZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiUwQSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImagePipeline

pipeline = QwenImagePipeline.from_pretrained(
  <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)`,wrap:!1}}),x=new w({props:{title:"Local pipelines",local:"local-pipelines",headingTag:"h3"}}),H=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMlF3ZW4lMkZRd2VuLUltYWdlJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download

snapshot_download(repo_id=<span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>)`,wrap:!1}}),R=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFF3ZW5JbWFnZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJwYXRoJTJGdG8lMkZ5b3VyJTJGY2FjaGUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImagePipeline

pipeline = QwenImagePipeline.from_pretrained(
  <span class="hljs-string">&quot;path/to/your/cache&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)`,wrap:!1}}),Q=new w({props:{title:"Pipeline data types",local:"pipeline-data-types",headingTag:"h2"}}),L=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFF3ZW5JbWFnZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUwQSUyMCUyMHRvcmNoX2R0eXBlJTNEJTdCJTIydHJhbnNmb3JtZXIlMjIlM0ElMjB0b3JjaC5iZmxvYXQxNiUyQyUyMCUyMmRlZmF1bHQlMjIlM0ElMjB0b3JjaC5mbG9hdDE2JTdEJTJDJTBBKSUwQXByaW50KHBpcGVsaW5lLnRyYW5zZm9ybWVyLmR0eXBlJTJDJTIwcGlwZWxpbmUudmFlLmR0eXBlKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImagePipeline

pipeline = QwenImagePipeline.from_pretrained(
  <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>,
  torch_dtype={<span class="hljs-string">&quot;transformer&quot;</span>: torch.bfloat16, <span class="hljs-string">&quot;default&quot;</span>: torch.float16},
)
<span class="hljs-built_in">print</span>(pipeline.transformer.dtype, pipeline.vae.dtype)`,wrap:!1}}),q=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwUXdlbkltYWdlUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFF3ZW5JbWFnZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBcHJpbnQocGlwZWxpbmUudHJhbnNmb3JtZXIuZHR5cGUlMkMlMjBwaXBlbGluZS52YWUuZHR5cGUp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> QwenImagePipeline

pipeline = QwenImagePipeline.from_pretrained(
  <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16
)
<span class="hljs-built_in">print</span>(pipeline.transformer.dtype, pipeline.vae.dtype)`,wrap:!1}}),F=new w({props:{title:"Device placement",local:"device-placement",headingTag:"h2"}}),A=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFtYXhfbWVtb3J5JTIwJTNEJTIwJTdCMCUzQSUyMCUyMjE2R0IlMjIlMkMlMjAxJTNBJTIwJTIyMTZHQiUyMiU3RCUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMlF3ZW4lMkZRd2VuLUltYWdlJTIyJTJDJTIwJTBBJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMGRldmljZV9tYXAlM0QlMjJjdWRhJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

max_memory = {<span class="hljs-number">0</span>: <span class="hljs-string">&quot;16GB&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;16GB&quot;</span>}
pipeline = DiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, 
  torch_dtype=torch.bfloat16,
  device_map=<span class="hljs-string">&quot;cuda&quot;</span>,
)`,wrap:!1}}),O=new M({props:{code:"cHJpbnQocGlwZWxpbmUuaGZfZGV2aWNlX21hcCklMEElMjMlMjAlN0IndW5ldCclM0ElMjAxJTJDJTIwJ3ZhZSclM0ElMjAxJTJDJTIwJ3NhZmV0eV9jaGVja2VyJyUzQSUyMDAlMkMlMjAndGV4dF9lbmNvZGVyJyUzQSUyMDAlN0Q=",highlighted:`<span class="hljs-built_in">print</span>(pipeline.hf_device_map)
<span class="hljs-comment"># {&#x27;unet&#x27;: 1, &#x27;vae&#x27;: 1, &#x27;safety_checker&#x27;: 0, &#x27;text_encoder&#x27;: 0}</span>`,wrap:!1}}),le=new M({props:{code:"cGlwZWxpbmUucmVzZXRfZGV2aWNlX21hcCgp",highlighted:"pipeline.reset_device_map()",wrap:!1}}),te=new w({props:{title:"Parallel loading",local:"parallel-loading",headingTag:"h2"}}),ne=new M({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBEaWZmdXNpb25QaXBlbGluZSUwQSUwQW9zLmVudmlyb24lNUIlMjJIRl9FTkFCTEVfUEFSQUxMRUxfTE9BRElORyUyMiU1RCUyMCUzRCUyMCUyMllFUyUyMiUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMldhbi1BSSUyRldhbjIuMi1JMlYtQTE0Qi1EaWZmdXNlcnMlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMEEp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

os.environ[<span class="hljs-string">&quot;HF_ENABLE_PARALLEL_LOADING&quot;</span>] = <span class="hljs-string">&quot;YES&quot;</span>

pipeline = DiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;Wan-AI/Wan2.2-I2V-A14B-Diffusers&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)`,wrap:!1}}),pe=new w({props:{title:"Replacing models in a pipeline",local:"replacing-models-in-a-pipeline",headingTag:"h2"}}),me=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBBdXRvTW9kZWwlMEElMEF2YWUlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMm1hZGVieW9sbGluJTJGc2R4bC12YWUtZnAxNi1maXglMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwdmFlJTNEdmFlJTJDJTBBJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, AutoModel

vae = AutoModel.from_pretrained(
  <span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16
)

pipeline = DiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
  vae=vae,
  torch_dtype=torch.float16,
  device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)`,wrap:!1}}),fe=new w({props:{title:"Reusing models in multiple pipelines",local:"reusing-models-in-multiple-pipelines",headingTag:"h2"}}),Me=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUwQSUwQXBpcGVsaW5lX3NkeGwlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiUwQSklMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjIlMEFjaW5lbWF0aWMlMjBmaWxtJTIwc3RpbGwlMjBvZiUyMGElMjBjYXQlMjBzaXBwaW5nJTIwYSUyMG1hcmdhcml0YSUyMGluJTIwYSUyMHBvb2wlMjBpbiUyMFBhbG0lMjBTcHJpbmdzJTJDJTIwQ2FsaWZvcm5pYSUwQWhpZ2hseSUyMGRldGFpbGVkJTJDJTIwaGlnaCUyMGJ1ZGdldCUyMGhvbGx5d29vZCUyMG1vdmllJTJDJTIwY2luZW1hc2NvcGUlMkMlMjBtb29keSUyQyUyMGVwaWMlMkMlMjBnb3JnZW91cyUyQyUyMGZpbG0lMjBncmFpbiUwQSUyMiUyMiUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmVfc2R4bChwcm9tcHQpLmltYWdlcyU1QjAlNUQlMEFwcmludChmJTIyTWF4JTIwbWVtb3J5JTIwcmVzZXJ2ZWQlM0ElMjAlN0J0b3JjaC5jdWRhLm1heF9tZW1vcnlfYWxsb2NhdGVkKCklMjAlMkYlMjAxMDI0KiozJTNBLjJmJTdEJTIwR0IlMjIpJTBBJTIzJTIwTWF4JTIwbWVtb3J5JTIwcmVzZXJ2ZWQlM0ElMjAxMC40NyUyMEdC",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image

pipeline_sdxl = AutoPipelineForText2Image.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
prompt = <span class="hljs-string">&quot;&quot;&quot;
cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
&quot;&quot;&quot;</span>
image = pipeline_sdxl(prompt).images[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory reserved: <span class="hljs-subst">{torch.cuda.max_memory_allocated() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)
<span class="hljs-comment"># Max memory reserved: 10.47 GB</span>`,wrap:!1}}),we=new M({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcGlwZSglMEElMjAlMjBwaXBlbGluZV9zZHhsJTJDJTIwZW5hYmxlX3BhZyUzRFRydWUlMEEpJTBBcHJvbXB0JTIwJTNEJTIwJTIyJTIyJTIyJTBBY2luZW1hdGljJTIwZmlsbSUyMHN0aWxsJTIwb2YlMjBhJTIwY2F0JTIwc2lwcGluZyUyMGElMjBtYXJnYXJpdGElMjBpbiUyMGElMjBwb29sJTIwaW4lMjBQYWxtJTIwU3ByaW5ncyUyQyUyMENhbGlmb3JuaWElMEFoaWdobHklMjBkZXRhaWxlZCUyQyUyMGhpZ2glMjBidWRnZXQlMjBob2xseXdvb2QlMjBtb3ZpZSUyQyUyMGNpbmVtYXNjb3BlJTJDJTIwbW9vZHklMkMlMjBlcGljJTJDJTIwZ29yZ2VvdXMlMkMlMjBmaWxtJTIwZ3JhaW4lMEElMjIlMjIlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCkuaW1hZ2VzJTVCMCU1RCUwQXByaW50KGYlMjJNYXglMjBtZW1vcnklMjByZXNlcnZlZCUzQSUyMCU3QnRvcmNoLmN1ZGEubWF4X21lbW9yeV9hbGxvY2F0ZWQoKSUyMCUyRiUyMDEwMjQqKjMlM0EuMmYlN0QlMjBHQiUyMiklMEElMjMlMjBNYXglMjBtZW1vcnklMjByZXNlcnZlZCUzQSUyMDEwLjQ3JTIwR0I=",highlighted:`pipeline = AutoPipelineForText2Image.from_pipe(
  pipeline_sdxl, enable_pag=<span class="hljs-literal">True</span>
)
prompt = <span class="hljs-string">&quot;&quot;&quot;
cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
&quot;&quot;&quot;</span>
image = pipeline(prompt).images[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory reserved: <span class="hljs-subst">{torch.cuda.max_memory_allocated() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)
<span class="hljs-comment"># Max memory reserved: 10.47 GB</span>`,wrap:!1}}),ye=new w({props:{title:"Safety checker",local:"safety-checker",headingTag:"h2"}}),ge=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwc2FmZXR5X2NoZWNrZXIlM0ROb25lJTBBKSUwQSUyMiUyMiUyMiUwQVlvdSUyMGhhdmUlMjBkaXNhYmxlZCUyMHRoZSUyMHNhZmV0eSUyMGNoZWNrZXIlMjBmb3IlMjAlM0NjbGFzcyUyMCdkaWZmdXNlcnMucGlwZWxpbmVzLnN0YWJsZV9kaWZmdXNpb24ucGlwZWxpbmVfc3RhYmxlX2RpZmZ1c2lvbi5TdGFibGVEaWZmdXNpb25QaXBlbGluZSclM0UlMjBieSUyMHBhc3NpbmclMjAlNjBzYWZldHlfY2hlY2tlciUzRE5vbmUlNjAuJTIwRW5zdXJlJTIwdGhhdCUyMHlvdSUyMGFiaWRlJTIwYnklMjB0aGUlMjBjb25kaXRpb25zJTIwb2YlMjB0aGUlMjBTdGFibGUlMjBEaWZmdXNpb24lMjBsaWNlbnNlJTIwYW5kJTIwZG8lMjBub3QlMjBleHBvc2UlMjB1bmZpbHRlcmVkJTIwcmVzdWx0cyUyMGluJTIwc2VydmljZXMlMjBvciUyMGFwcGxpY2F0aW9ucyUyMG9wZW4lMjB0byUyMHRoZSUyMHB1YmxpYy4lMjBCb3RoJTIwdGhlJTIwZGlmZnVzZXJzJTIwdGVhbSUyMGFuZCUyMEh1Z2dpbmclMjBGYWNlJTIwc3Ryb25nbHklMjByZWNvbW1lbmQlMjBrZWVwaW5nJTIwdGhlJTIwc2FmZXR5JTIwZmlsdGVyJTIwZW5hYmxlZCUyMGluJTIwYWxsJTIwcHVibGljLWZhY2luZyUyMGNpcmN1bXN0YW5jZXMlMkMlMjBkaXNhYmxpbmclMjBpdCUyMG9ubHklMjBmb3IlMjB1c2UlMjBjYXNlcyUyMHRoYXQlMjBpbnZvbHZlJTIwYW5hbHl6aW5nJTIwbmV0d29yayUyMGJlaGF2aW9yJTIwb3IlMjBhdWRpdGluZyUyMGl0cyUyMHJlc3VsdHMuJTIwRm9yJTIwbW9yZSUyMGluZm9ybWF0aW9uJTJDJTIwcGxlYXNlJTIwaGF2ZSUyMGElMjBsb29rJTIwYXQlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUyRnB1bGwlMkYyNTQlMjAuJTBBJTIyJTIyJTIy",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, safety_checker=<span class="hljs-literal">None</span>
)
<span class="hljs-string">&quot;&quot;&quot;
You have disabled the safety checker for &lt;class &#x27;diffusers.pipelines.stable_diffusion.pipeline_stable_diffusion.StableDiffusionPipeline&#x27;&gt; by passing \`safety_checker=None\`. Ensure that you abide by the conditions of the Stable Diffusion license and do not expose unfiltered results in services or applications open to the public. Both the diffusers team and Hugging Face strongly recommend keeping the safety filter enabled in all public-facing circumstances, disabling it only for use cases that involve analyzing network behavior or auditing its results. For more information, please have a look at https://github.com/huggingface/diffusers/pull/254 .
&quot;&quot;&quot;</span>`,wrap:!1}}),je=new $t({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/loading.md"}}),{c(){h=n("meta"),$e=s(),Ze=n("p"),We=s(),r(T.$$.fragment),Ie=s(),r(g.$$.fragment),Ge=s(),r(j.$$.fragment),Be=s(),Z=n("p"),Z.innerHTML=Cl,_e=s(),U=n("p"),U.innerHTML=Rl,ke=s(),r(v.$$.fragment),xe=s(),$=n("p"),$.innerHTML=Xl,Ee=s(),W=n("p"),W.innerHTML=Ql,He=s(),r(I.$$.fragment),Ce=s(),G=n("p"),G.innerHTML=Pl,Re=s(),B=n("table"),B.innerHTML=Yl,Xe=s(),_=n("p"),_.innerHTML=Ll,Qe=s(),r(k.$$.fragment),Pe=s(),b=n("blockquote"),b.innerHTML=Vl,Ye=s(),r(x.$$.fragment),Le=s(),E=n("p"),E.innerHTML=ql,Ve=s(),r(H.$$.fragment),qe=s(),C=n("p"),C.innerHTML=Fl,Fe=s(),r(R.$$.fragment),Ne=s(),X=n("p"),X.innerHTML=Nl,Se=s(),r(Q.$$.fragment),De=s(),P=n("p"),P.innerHTML=Sl,ze=s(),Y=n("p"),Y.innerHTML=Dl,Ae=s(),r(L.$$.fragment),Ke=s(),V=n("p"),V.textContent=zl,Oe=s(),r(q.$$.fragment),el=s(),r(F.$$.fragment),ll=s(),N=n("p"),N.innerHTML=Al,tl=s(),S=n("p"),S.innerHTML=Kl,il=s(),D=n("table"),D.innerHTML=Ol,sl=s(),z=n("p"),z.innerHTML=et,al=s(),r(A.$$.fragment),nl=s(),K=n("p"),K.innerHTML=lt,pl=s(),r(O.$$.fragment),ol=s(),ee=n("p"),ee.innerHTML=tt,rl=s(),r(le.$$.fragment),ml=s(),r(te.$$.fragment),fl=s(),ie=n("p"),ie.innerHTML=it,dl=s(),se=n("p"),se.innerHTML=st,ul=s(),ae=n("p"),ae.innerHTML=at,cl=s(),r(ne.$$.fragment),Ml=s(),r(pe.$$.fragment),hl=s(),oe=n("p"),oe.innerHTML=nt,wl=s(),re=n("p"),re.textContent=pt,bl=s(),r(me.$$.fragment),yl=s(),r(fe.$$.fragment),Jl=s(),de=n("p"),de.innerHTML=ot,Tl=s(),ue=n("p"),ue.textContent=rt,gl=s(),ce=n("p"),ce.innerHTML=mt,jl=s(),y=n("blockquote"),y.innerHTML=ft,Zl=s(),r(Me.$$.fragment),Ul=s(),he=n("p"),he.innerHTML=dt,vl=s(),r(we.$$.fragment),$l=s(),J=n("blockquote"),J.innerHTML=ut,Wl=s(),be=n("p"),be.innerHTML=ct,Il=s(),r(ye.$$.fragment),Gl=s(),Je=n("p"),Je.innerHTML=Mt,Bl=s(),Te=n("p"),Te.innerHTML=ht,_l=s(),r(ge.$$.fragment),kl=s(),r(je.$$.fragment),xl=s(),Ue=n("p"),this.h()},l(e){const l=jt("svelte-u9bgzb",document.head);h=p(l,"META",{name:!0,content:!0}),l.forEach(t),$e=a(e),Ze=p(e,"P",{}),wt(Ze).forEach(t),We=a(e),m(T.$$.fragment,e),Ie=a(e),m(g.$$.fragment,e),Ge=a(e),m(j.$$.fragment,e),Be=a(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-15acv4d"&&(Z.innerHTML=Cl),_e=a(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1r7k4fu"&&(U.innerHTML=Rl),ke=a(e),m(v.$$.fragment,e),xe=a(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-77vcgr"&&($.innerHTML=Xl),Ee=a(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-ebiflz"&&(W.innerHTML=Ql),He=a(e),m(I.$$.fragment,e),Ce=a(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-18gmtm6"&&(G.innerHTML=Pl),Re=a(e),B=p(e,"TABLE",{"data-svelte-h":!0}),o(B)!=="svelte-yqi7at"&&(B.innerHTML=Yl),Xe=a(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-7u1us2"&&(_.innerHTML=Ll),Qe=a(e),m(k.$$.fragment,e),Pe=a(e),b=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-88i11w"&&(b.innerHTML=Vl),Ye=a(e),m(x.$$.fragment,e),Le=a(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-12ybt7d"&&(E.innerHTML=ql),Ve=a(e),m(H.$$.fragment,e),qe=a(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-18vxmhu"&&(C.innerHTML=Fl),Fe=a(e),m(R.$$.fragment,e),Ne=a(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-km3nn9"&&(X.innerHTML=Nl),Se=a(e),m(Q.$$.fragment,e),De=a(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-ht6trw"&&(P.innerHTML=Sl),ze=a(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-xbxzon"&&(Y.innerHTML=Dl),Ae=a(e),m(L.$$.fragment,e),Ke=a(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-17eskne"&&(V.textContent=zl),Oe=a(e),m(q.$$.fragment,e),el=a(e),m(F.$$.fragment,e),ll=a(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-16dgqhw"&&(N.innerHTML=Al),tl=a(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-yjq2nu"&&(S.innerHTML=Kl),il=a(e),D=p(e,"TABLE",{"data-svelte-h":!0}),o(D)!=="svelte-1u6nxso"&&(D.innerHTML=Ol),sl=a(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-ssiv2x"&&(z.innerHTML=et),al=a(e),m(A.$$.fragment,e),nl=a(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-jt67uv"&&(K.innerHTML=lt),pl=a(e),m(O.$$.fragment,e),ol=a(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-17qp95k"&&(ee.innerHTML=tt),rl=a(e),m(le.$$.fragment,e),ml=a(e),m(te.$$.fragment,e),fl=a(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-14tzv1s"&&(ie.innerHTML=it),dl=a(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-uz1jzg"&&(se.innerHTML=st),ul=a(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-34lk0z"&&(ae.innerHTML=at),cl=a(e),m(ne.$$.fragment,e),Ml=a(e),m(pe.$$.fragment,e),hl=a(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1ejgwxl"&&(oe.innerHTML=nt),wl=a(e),re=p(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1i6angb"&&(re.textContent=pt),bl=a(e),m(me.$$.fragment,e),yl=a(e),m(fe.$$.fragment,e),Jl=a(e),de=p(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-2i9f2r"&&(de.innerHTML=ot),Tl=a(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-fe2l13"&&(ue.textContent=rt),gl=a(e),ce=p(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-142eqve"&&(ce.innerHTML=mt),jl=a(e),y=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(y)!=="svelte-tcfbns"&&(y.innerHTML=ft),Zl=a(e),m(Me.$$.fragment,e),Ul=a(e),he=p(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-tea5ze"&&(he.innerHTML=dt),vl=a(e),m(we.$$.fragment,e),$l=a(e),J=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(J)!=="svelte-1mgat1c"&&(J.innerHTML=ut),Wl=a(e),be=p(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-1iyxpvz"&&(be.innerHTML=ct),Il=a(e),m(ye.$$.fragment,e),Gl=a(e),Je=p(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-1fc5mnv"&&(Je.innerHTML=Mt),Bl=a(e),Te=p(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-3onxuv"&&(Te.innerHTML=ht),_l=a(e),m(ge.$$.fragment,e),kl=a(e),m(je.$$.fragment,e),xl=a(e),Ue=p(e,"P",{}),wt(Ue).forEach(t),this.h()},h(){ve(h,"name","hf:doc:metadata"),ve(h,"content",It),ve(b,"class","tip"),ve(y,"class","warning"),ve(J,"class","warning")},m(e,l){Zt(document.head,h),i(e,$e,l),i(e,Ze,l),i(e,We,l),f(T,e,l),i(e,Ie,l),f(g,e,l),i(e,Ge,l),f(j,e,l),i(e,Be,l),i(e,Z,l),i(e,_e,l),i(e,U,l),i(e,ke,l),f(v,e,l),i(e,xe,l),i(e,$,l),i(e,Ee,l),i(e,W,l),i(e,He,l),f(I,e,l),i(e,Ce,l),i(e,G,l),i(e,Re,l),i(e,B,l),i(e,Xe,l),i(e,_,l),i(e,Qe,l),f(k,e,l),i(e,Pe,l),i(e,b,l),i(e,Ye,l),f(x,e,l),i(e,Le,l),i(e,E,l),i(e,Ve,l),f(H,e,l),i(e,qe,l),i(e,C,l),i(e,Fe,l),f(R,e,l),i(e,Ne,l),i(e,X,l),i(e,Se,l),f(Q,e,l),i(e,De,l),i(e,P,l),i(e,ze,l),i(e,Y,l),i(e,Ae,l),f(L,e,l),i(e,Ke,l),i(e,V,l),i(e,Oe,l),f(q,e,l),i(e,el,l),f(F,e,l),i(e,ll,l),i(e,N,l),i(e,tl,l),i(e,S,l),i(e,il,l),i(e,D,l),i(e,sl,l),i(e,z,l),i(e,al,l),f(A,e,l),i(e,nl,l),i(e,K,l),i(e,pl,l),f(O,e,l),i(e,ol,l),i(e,ee,l),i(e,rl,l),f(le,e,l),i(e,ml,l),f(te,e,l),i(e,fl,l),i(e,ie,l),i(e,dl,l),i(e,se,l),i(e,ul,l),i(e,ae,l),i(e,cl,l),f(ne,e,l),i(e,Ml,l),f(pe,e,l),i(e,hl,l),i(e,oe,l),i(e,wl,l),i(e,re,l),i(e,bl,l),f(me,e,l),i(e,yl,l),f(fe,e,l),i(e,Jl,l),i(e,de,l),i(e,Tl,l),i(e,ue,l),i(e,gl,l),i(e,ce,l),i(e,jl,l),i(e,y,l),i(e,Zl,l),f(Me,e,l),i(e,Ul,l),i(e,he,l),i(e,vl,l),f(we,e,l),i(e,$l,l),i(e,J,l),i(e,Wl,l),i(e,be,l),i(e,Il,l),f(ye,e,l),i(e,Gl,l),i(e,Je,l),i(e,Bl,l),i(e,Te,l),i(e,_l,l),f(ge,e,l),i(e,kl,l),f(je,e,l),i(e,xl,l),i(e,Ue,l),El=!0},p:yt,i(e){El||(d(T.$$.fragment,e),d(g.$$.fragment,e),d(j.$$.fragment,e),d(v.$$.fragment,e),d(I.$$.fragment,e),d(k.$$.fragment,e),d(x.$$.fragment,e),d(H.$$.fragment,e),d(R.$$.fragment,e),d(Q.$$.fragment,e),d(L.$$.fragment,e),d(q.$$.fragment,e),d(F.$$.fragment,e),d(A.$$.fragment,e),d(O.$$.fragment,e),d(le.$$.fragment,e),d(te.$$.fragment,e),d(ne.$$.fragment,e),d(pe.$$.fragment,e),d(me.$$.fragment,e),d(fe.$$.fragment,e),d(Me.$$.fragment,e),d(we.$$.fragment,e),d(ye.$$.fragment,e),d(ge.$$.fragment,e),d(je.$$.fragment,e),El=!0)},o(e){u(T.$$.fragment,e),u(g.$$.fragment,e),u(j.$$.fragment,e),u(v.$$.fragment,e),u(I.$$.fragment,e),u(k.$$.fragment,e),u(x.$$.fragment,e),u(H.$$.fragment,e),u(R.$$.fragment,e),u(Q.$$.fragment,e),u(L.$$.fragment,e),u(q.$$.fragment,e),u(F.$$.fragment,e),u(A.$$.fragment,e),u(O.$$.fragment,e),u(le.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(fe.$$.fragment,e),u(Me.$$.fragment,e),u(we.$$.fragment,e),u(ye.$$.fragment,e),u(ge.$$.fragment,e),u(je.$$.fragment,e),El=!1},d(e){e&&(t($e),t(Ze),t(We),t(Ie),t(Ge),t(Be),t(Z),t(_e),t(U),t(ke),t(xe),t($),t(Ee),t(W),t(He),t(Ce),t(G),t(Re),t(B),t(Xe),t(_),t(Qe),t(Pe),t(b),t(Ye),t(Le),t(E),t(Ve),t(qe),t(C),t(Fe),t(Ne),t(X),t(Se),t(De),t(P),t(ze),t(Y),t(Ae),t(Ke),t(V),t(Oe),t(el),t(ll),t(N),t(tl),t(S),t(il),t(D),t(sl),t(z),t(al),t(nl),t(K),t(pl),t(ol),t(ee),t(rl),t(ml),t(fl),t(ie),t(dl),t(se),t(ul),t(ae),t(cl),t(Ml),t(hl),t(oe),t(wl),t(re),t(bl),t(yl),t(Jl),t(de),t(Tl),t(ue),t(gl),t(ce),t(jl),t(y),t(Zl),t(Ul),t(he),t(vl),t($l),t(J),t(Wl),t(be),t(Il),t(Gl),t(Je),t(Bl),t(Te),t(_l),t(kl),t(xl),t(Ue)),t(h),c(T,e),c(g,e),c(j,e),c(v,e),c(I,e),c(k,e),c(x,e),c(H,e),c(R,e),c(Q,e),c(L,e),c(q,e),c(F,e),c(A,e),c(O,e),c(le,e),c(te,e),c(ne,e),c(pe,e),c(me,e),c(fe,e),c(Me,e),c(we,e),c(ye,e),c(ge,e),c(je,e)}}}const It='{"title":"DiffusionPipeline","local":"diffusionpipeline","sections":[{"title":"Loading a pipeline","local":"loading-a-pipeline","sections":[{"title":"Local pipelines","local":"local-pipelines","sections":[],"depth":3}],"depth":2},{"title":"Pipeline data types","local":"pipeline-data-types","sections":[],"depth":2},{"title":"Device placement","local":"device-placement","sections":[],"depth":2},{"title":"Parallel loading","local":"parallel-loading","sections":[],"depth":2},{"title":"Replacing models in a pipeline","local":"replacing-models-in-a-pipeline","sections":[],"depth":2},{"title":"Reusing models in multiple pipelines","local":"reusing-models-in-multiple-pipelines","sections":[],"depth":2},{"title":"Safety checker","local":"safety-checker","sections":[],"depth":2}],"depth":1}';function Gt(Hl){return Jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ct extends Tt{constructor(h){super(),gt(this,h,Gt,Wt,bt,{})}}export{Ct as component};
