# CogView4Transformer2DModel

A Diffusion Transformer model for 2D data from [CogView4]()

The model can be loaded with the following code snippet.

```python
from diffusers import CogView4Transformer2DModel

transformer = CogView4Transformer2DModel.from_pretrained("THUDM/CogView4-6B", subfolder="transformer", torch_dtype=torch.bfloat16).to("cuda")
```

## CogView4Transformer2DModel[[diffusers.CogView4Transformer2DModel]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.CogView4Transformer2DModel</name><anchor>diffusers.CogView4Transformer2DModel</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/transformers/transformer_cogview4.py#L619</source><parameters>[{"name": "patch_size", "val": ": int = 2"}, {"name": "in_channels", "val": ": int = 16"}, {"name": "out_channels", "val": ": int = 16"}, {"name": "num_layers", "val": ": int = 30"}, {"name": "attention_head_dim", "val": ": int = 40"}, {"name": "num_attention_heads", "val": ": int = 64"}, {"name": "text_embed_dim", "val": ": int = 4096"}, {"name": "time_embed_dim", "val": ": int = 512"}, {"name": "condition_dim", "val": ": int = 256"}, {"name": "pos_embed_max_size", "val": ": int = 128"}, {"name": "sample_size", "val": ": int = 128"}, {"name": "rope_axes_dim", "val": ": typing.Tuple[int, int] = (256, 256)"}]</parameters><paramsdesc>- **patch_size** (`int`, defaults to `2`) --
  The size of the patches to use in the patch embedding layer.
- **in_channels** (`int`, defaults to `16`) --
  The number of channels in the input.
- **num_layers** (`int`, defaults to `30`) --
  The number of layers of Transformer blocks to use.
- **attention_head_dim** (`int`, defaults to `40`) --
  The number of channels in each head.
- **num_attention_heads** (`int`, defaults to `64`) --
  The number of heads to use for multi-head attention.
- **out_channels** (`int`, defaults to `16`) --
  The number of channels in the output.
- **text_embed_dim** (`int`, defaults to `4096`) --
  Input dimension of text embeddings from the text encoder.
- **time_embed_dim** (`int`, defaults to `512`) --
  Output dimension of timestep embeddings.
- **condition_dim** (`int`, defaults to `256`) --
  The embedding dimension of the input SDXL-style resolution conditions (original_size, target_size,
  crop_coords).
- **pos_embed_max_size** (`int`, defaults to `128`) --
  The maximum resolution of the positional embeddings, from which slices of shape `H x W` are taken and added
  to input patched latents, where `H` and `W` are the latent height and width respectively. A value of 128
  means that the maximum supported height and width for image generation is `128 * vae_scale_factor *
  patch_size => 128 * 8 * 2 => 2048`.
- **sample_size** (`int`, defaults to `128`) --
  The base resolution of input latents. If height/width is not provided during generation, this value is used
  to determine the resolution as `sample_size * vae_scale_factor => 128 * 8 => 1024`</paramsdesc><paramgroups>0</paramgroups></docstring>




</div>

## Transformer2DModelOutput[[diffusers.models.modeling_outputs.Transformer2DModelOutput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.modeling_outputs.Transformer2DModelOutput</name><anchor>diffusers.models.modeling_outputs.Transformer2DModelOutput</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_outputs.py#L21</source><parameters>[{"name": "sample", "val": ": torch.Tensor"}]</parameters><paramsdesc>- **sample** (`torch.Tensor` of shape `(batch_size, num_channels, height, width)` or `(batch size, num_vector_embeds - 1, num_latent_pixels)` if [Transformer2DModel](/docs/diffusers/main/en/api/models/transformer2d#diffusers.Transformer2DModel) is discrete) --
  The hidden states output conditioned on the `encoder_hidden_states` input. If discrete, returns probability
  distributions for the unnoised latent pixels.</paramsdesc><paramgroups>0</paramgroups></docstring>

The output of [Transformer2DModel](/docs/diffusers/main/en/api/models/transformer2d#diffusers.Transformer2DModel).




</div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/models/cogview4_transformer2d.md" />